$(function(){
	setMenuIndicator();
	
	//prevent nested scrolling - maximum child mousewheel scrolling wont trigger the parent to scroll
    $(".scrollable").bind("mousewheel DOMMouseScroll", function ( e ) {
        var e0 = e.originalEvent,
        delta = e0.wheelDelta || -e0.detail;

        this.scrollTop += ( delta < 0 ? 1 : -1 ) * 30;
        e.preventDefault();
    });

	$(".collapsible").each(function(){
		collapseSubMenu($(this));
	});

	$(".expand").each(function(){
		expandSubMenu($(this));
	});

	$(".left-sidebar ul .left-sidebar-menu-item").click(function(){
	// $(".left-sidebar ul .left-sidebar-menu-item").removeClass("selected");
	// $(this).addClass("selected");

		if ($(this).hasClass("collapsible")){
			$(this).toggleClass("expand");
			if ($(this).hasClass("expand")){
				expandSubMenu($(this));
				$(this).find("i").addClass("fa-rotate-180-negative");
			}
			else{
				collapseSubMenu($(this));
				$(this).find("i").removeClass("fa-rotate-180-negative");
			}
		}
	});

	//detect device / screen size, then zoom to make the report container looks smaller
	if (window.innerWidth <840){
		$(".content").css("zoom", (window.innerWidth / 840));
	}

	$(window).bind('resize', function() {
		if (window.innerWidth >= 1280){
			$(".content").css("zoom", 1);
			if ($('.gray-overlay').is(':visible')){
				$('.gray-overlay').fadeOut("fast");
				if ($("#right-sidebar").hasClass("active")){
					$("#right-sidebar").removeClass("active animated slideInRight");
				}
				if ($("#left-sidebar").hasClass("active")){
					$("#left-sidebar").removeClass("active animated slideInLeft");
				}
			}
		}
		else if (window.innerWidth >= 1080){
			$(".content").css("zoom", 1);
			if ($('.gray-overlay').is(':visible')){
				if ($("#left-sidebar").hasClass("active")){
					$("#left-sidebar").removeClass("active animated slideInLeft");
					$('.gray-overlay').fadeOut("fast");
				}
			}
		}
		else if (window.innerWidth >= 840){
			$(".content").css("zoom", 1);
		}
		else{
			$(".content").css("zoom", (window.innerWidth / 840));
		}
	});

	$("#header-menu").click(function(){
		showMenuSideBar();
	});

	$("#header-setting").click(function(){
		showSettingsSideBar();
	});

	$("#toggleCloseMenu").click(function(){
		hideMenuSideBar();
	});

	$("#toggleCloseSetting").click(function(){
		hideSettingSideBar();
	});

	$('.gray-overlay').click(function(){
		hideMenuSideBar();
		hideSettingSideBar();
	});

	$(".report.header").hover(function(){
		$(this).find("button").removeAttr("title");
	});

	$("#startDate").css("cursor", "pointer");
	$("#endDate").css("cursor", "pointer");
	$("#datePickerDateRange").css("cursor", "pointer");
	

});

function expandSubMenu(element){
	var menu = element.data("menu-for");
    $("div[data-submenu="+menu+"]").height($("div[data-submenu="+menu+"]").find(".collapseWrapper").height());
}

function collapseSubMenu(element){
	var menu = element.data("menu-for");
    $("div[data-submenu="+menu+"]").height(0);
}

function showMenuSideBar(){
	if (!$("#left-sidebar").hasClass("active")){
		$('.gray-overlay').fadeIn(200);
		$("#left-sidebar").toggleClass("active animated slideInLeft");
	}
}

function hideMenuSideBar(){
	if ($("#left-sidebar").hasClass("active")){
		$("#left-sidebar").toggleClass("slideInLeft slideOutLeft");

		$('#left-sidebar').bind('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function(){
			$("#left-sidebar").removeClass("active animated slideOutLeft");
			$('.gray-overlay').fadeOut("fast");
			$(this).unbind();
		});
	}
}

function showSettingsSideBar(){
	if (!$("#right-sidebar").hasClass("active")){
		$('.gray-overlay').fadeIn(200);
		$("#right-sidebar").toggleClass("active animated slideInRight");
	}
}

function hideSettingSideBar(){
	if ($("#right-sidebar").hasClass("active")){
		$("#right-sidebar").toggleClass("slideOutRight slideInRight");

		$('#right-sidebar').bind('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function(){
			$("#right-sidebar").removeClass("active animated slideOutRight");
			$('.gray-overlay').fadeOut("fast");
			$(this).unbind();
		});
	}
}

function GetParameterValues(param) {
    var url = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');
    for (var i = 0; i < url.length; i++) {
        var urlparam = url[i].split('=');
        if (urlparam[0] == param) {
            return urlparam[1];
        }
    }
}

function setMenuIndicator() {
    var menuId = GetParameterValues('MenuId');
    var indexlist = GetParameterValues('indexlist');

    if (typeof menuId == 'undefined' || typeof indexlist == 'undefined') {
        return;
    }

    if (indexlist.indexOf("position") == -1) {
        return;
    }
    else {
        indexlist = indexlist.replace('position', '');
    }

    menuId = parseInt(menuId);
    indexlist = parseInt(indexlist);

    $(".left-sidebar li").each(function () {
        if ($(this).data("menu") == menuId && $(this).data("index") == indexlist){
            $(this).addClass("selected");

            var expanded = $(this).closest(".left-sidebar-submenu").data("submenu");
            if (typeof expanded == 'undefined')
            	return;
            else{
            	$("li[data-menu-for="+expanded+"]").addClass("expand");
            }
        }
    });

}
