/************************************************************************************************************
Tab view
Copyright (C) October 2005  DTHMLGoodies.com, Alf Magne Kalleland

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

Dhtmlgoodies.com., hereby disclaims all copyright interest in this script
written by Alf Magne Kalleland.

Alf Magne Kalleland, 2009
Owner of DHTMLgoodies.com

************************************************************************************************************/

var textPadding = 3; // Padding at the left of tab text - bigger value gives you wider tabs
var strictDocType = true;
var tabView_maxNumberOfTabs = 99; // Maximum number of tabs

/* Don't change anything below here */
var dhtmlgoodies_tabObj = new Array();
var activeTabIndex = new Array();
var MSIE = navigator.userAgent.indexOf('MSIE') >= 0 ? true : false;

var regExp = new RegExp(".*MSIE ([0-9]\.[0-9]).*", "g");
var navigatorVersion = navigator.userAgent.replace(regExp, '$1');

var ajaxObjects = new Array();
var tabView_countTabs = new Array();
var tabViewHeight = new Array();
var tabDivCounter = 0;
var closeImageHeight = 8; // Pixel height of close buttons
var closeImageWidth = 8; // Pixel height of close buttons


function setPadding(obj, padding) {
	var span = obj.getElementsByTagName('SPAN')[0];
	span.style.paddingLeft = padding + 'px';
	span.style.paddingRight = padding + 'px';
}
function showTab(parentId, tabIndex) {
	var parentId_div = parentId + "_";
	if (!document.getElementById('tabView' + parentId_div + tabIndex)) {
		return;
	}
	if (activeTabIndex[parentId] >= 0) {
		if (activeTabIndex[parentId] == tabIndex) {
			return;
		}

		var obj = document.getElementById('tabTab' + parentId_div + activeTabIndex[parentId]);

		obj.className = 'tabInactive';
		var img = obj.getElementsByTagName('IMG')[0];
		if (img.src.indexOf('tab_') == -1) img = obj.getElementsByTagName('IMG')[1];
		img.src = '../../Content/Footfallcam/images/tab_right_inactive.gif';
		document.getElementById('tabView' + parentId_div + activeTabIndex[parentId]).style.display = 'none';
	}

	var thisObj = document.getElementById('tabTab' + parentId_div + tabIndex);

	thisObj.className = 'tabActive';
	var img = thisObj.getElementsByTagName('IMG')[0];
	if (img.src.indexOf('tab_') == -1) img = thisObj.getElementsByTagName('IMG')[1];
	img.src = '../../Content/Footfallcam/images/tab_right_active.gif';

	document.getElementById('tabView' + parentId_div + tabIndex).style.display = 'block';
	activeTabIndex[parentId] = tabIndex;


	var parentObj = thisObj.parentNode;
	var aTab = parentObj.getElementsByTagName('DIV')[0];
	countObjects = 0;
	var startPos = 2;
	var previousObjectActive = false;
	while (aTab) {
		if (aTab.tagName == 'DIV') {
			if (previousObjectActive) {
				previousObjectActive = false;
				startPos -= 2;
			}
			if (aTab == thisObj) {
				startPos -= 2;
				previousObjectActive = true;
				setPadding(aTab, textPadding + 1);
			} else {
				setPadding(aTab, textPadding);
			}

			aTab.style.left = startPos + 'px';
			countObjects++;
			startPos += 2;
		}
		aTab = aTab.nextSibling;
	}

	return;
}

function tabClick() {
	var idArray = this.id.split('_');
	showTab(this.parentNode.parentNode.id, idArray[idArray.length - 1].replace(/[^0-9]/gi, ''));

}

function rolloverTab() {
	if (this.className.indexOf('tabInactive') >= 0) {
		this.className = 'inactiveTabOver';
		var img = this.getElementsByTagName('IMG')[0];
		if (img.src.indexOf('tab_') <= 0) img = this.getElementsByTagName('IMG')[1];
		img.src = '../../Content/Footfallcam/images/tab_right_over.gif';
	}

}
function rolloutTab() {
	if (this.className == 'inactiveTabOver') {
		this.className = 'tabInactive';
		var img = this.getElementsByTagName('IMG')[0];
		if (img.src.indexOf('tab_') <= 0) img = this.getElementsByTagName('IMG')[1];
		img.src = '../../Content/Footfallcam/images/tab_right_inactive.gif';
	}

}

function hoverTabViewCloseButton() {
	this.src = this.src.replace('../../Content/Footfallcam/images/close.gif', '../../Content/Footfallcam/images/close_over.gif');
}

function stopHoverTabViewCloseButton() {
	this.src = this.src.replace('../../Content/Footfallcam/images/close_over.gif', '../../Content/Footfallcam/images/close.gif');
}

function initTabs(mainContainerID, tabTitles, activeTab, width, height, closeButtonArray, additionalTab) {
	if (!closeButtonArray) closeButtonArray = new Array();

	if (!additionalTab || additionalTab == 'undefined') {
		dhtmlgoodies_tabObj[mainContainerID] = document.getElementById(mainContainerID);
		width = width + '';
		if (width.indexOf('%') < 0) width = width + 'px';
		dhtmlgoodies_tabObj[mainContainerID].style.width = width;

		height = height + '';
		if (height.length > 0) {
			if (height.indexOf('%') < 0) height = height + 'px';
			dhtmlgoodies_tabObj[mainContainerID].style.minHeight = height;
		}


		tabViewHeight[mainContainerID] = height;

		var tabDiv = document.createElement('DIV');
		var firstDiv = dhtmlgoodies_tabObj[mainContainerID].getElementsByTagName('DIV')[0];

		dhtmlgoodies_tabObj[mainContainerID].insertBefore(tabDiv, firstDiv);
		tabDiv.className = 'dhtmlgoodies_tabPane';
		tabView_countTabs[mainContainerID] = 0;

	} else {
		var tabDiv = dhtmlgoodies_tabObj[mainContainerID].getElementsByTagName('DIV')[0];
		var firstDiv = dhtmlgoodies_tabObj[mainContainerID].getElementsByTagName('DIV')[1];
		height = tabViewHeight[mainContainerID];
		activeTab = tabView_countTabs[mainContainerID];


	}



	for (var no = 0; no < tabTitles.length; no++) {
		var aTab = document.createElement('DIV');
		aTab.id = 'tabTab' + mainContainerID + "_" + (no + tabView_countTabs[mainContainerID]);
		aTab.onmouseover = rolloverTab;
		aTab.onmouseout = rolloutTab;
		aTab.onclick = tabClick;
		aTab.className = 'tabInactive';
		tabDiv.appendChild(aTab);
		var span = document.createElement('SPAN');
		span.innerHTML = tabTitles[no];
		span.style.position = 'relative';
		aTab.appendChild(span);

		if (closeButtonArray[no]) {
			var closeButton = document.createElement('IMG');
			closeButton.src = '../../Content/Footfallcam/images/close.gif';
			closeButton.height = closeImageHeight + 'px';
			closeButton.width = closeImageHeight + 'px';
			closeButton.setAttribute('height', closeImageHeight);
			closeButton.setAttribute('width', closeImageHeight);
			closeButton.style.position = 'absolute';
			closeButton.style.top = '6px';
			closeButton.style.right = '0px';
			closeButton.onmouseover = hoverTabViewCloseButton;
			closeButton.onmouseout = stopHoverTabViewCloseButton;

			span.innerHTML = span.innerHTML + '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';

			var deleteTxt = span.innerHTML + '';

			closeButton.onclick = function () { deleteTab(this.parentNode.innerHTML) };
			span.appendChild(closeButton);
		}

		var img = document.createElement('IMG');
		img.valign = 'bottom';
		img.src = '../../Content/Footfallcam/images/tab_right_inactive.gif';
		// IE5.X FIX
		if ((navigatorVersion && navigatorVersion < 6) || (MSIE && !strictDocType)) {
			img.style.styleFloat = 'none';
			img.style.position = 'relative';
			img.style.top = '4px'
			span.style.paddingTop = '4px';
			aTab.style.cursor = 'hand';
		} // End IE5.x FIX
		aTab.appendChild(img);
	}

	var tabs = dhtmlgoodies_tabObj[mainContainerID].getElementsByTagName('DIV');
	var divCounter = 0;
	for (var no = 0; no < tabs.length; no++) {
		if (tabs[no].className == 'dhtmlgoodies_aTab' && tabs[no].parentNode.id == mainContainerID) {
			if (height.length > 0) tabs[no].style.height = height;
			tabs[no].style.display = 'none';
			tabs[no].id = 'tabView' + mainContainerID + "_" + divCounter;
			divCounter++;
		}
	}
	tabView_countTabs[mainContainerID] = tabView_countTabs[mainContainerID] + tabTitles.length;
	showTab(mainContainerID, activeTab);

	return activeTab;
}

function showAjaxTabContent(ajaxIndex, parentId, tabId) {
	var obj = document.getElementById('tabView' + parentId + '_' + tabId);
	obj.innerHTML = ajaxObjects[ajaxIndex].response;
}

function resetTabIds(parentId) {
	var tabTitleCounter = 0;
	var tabContentCounter = 0;


	var divs = dhtmlgoodies_tabObj[parentId].getElementsByTagName('DIV');


	for (var no = 0; no < divs.length; no++) {
		if (divs[no].className == 'dhtmlgoodies_aTab') {
			divs[no].id = 'tabView' + parentId + '_' + tabTitleCounter;
			tabTitleCounter++;
		}
		if (divs[no].id.indexOf('tabTab') >= 0) {
			divs[no].id = 'tabTab' + parentId + '_' + tabContentCounter;
			tabContentCounter++;
		}


	}

	tabView_countTabs[parentId] = tabContentCounter;
}

//generate string date with fotmat dd/mm/yyyy
function initDate(date, dayBefore) {
	var today = new Date(date);
	today.setDate(today.getDate() + dayBefore);
	return (getDate(today) + "/" + getMonth(today) + "/" + today.getFullYear());
}

function initDate2(date, dayBefore) {
	var today = new Date(date);
	today.setDate(today.getDate() + dayBefore);
	return (today.getFullYear() + "-" + getMonth(today) + "-" + getDate(today));
}

var totalVisitorThisWeek = 0;
var thisYearTurnInRate = [];
var lastYearTurnInRate = [];
var day = ["Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"];

function createNewTab(parentId, tabTitle, tabContent, tabContentUrl, closeButton) {
	window.scrollTo(0, 0);
	if (tabView_countTabs[parentId] >= tabView_maxNumberOfTabs) return; // Maximum number of tabs reached - return
	var div = document.createElement('DIV');
	div.className = 'dhtmlgoodies_aTab';
	dhtmlgoodies_tabObj[parentId].appendChild(div);

	var tabId = initTabs(parentId, Array(tabTitle), 0, '', '', Array(closeButton), true);

	//get BranchId and it's data
	var passedString = tabContent;
	var getWhatToGet = [];
	var getWhatToGet = passedString.split("&");

	var branchId = getWhatToGet[0];
	var getWhat = getWhatToGet[1];
	//console.log("Branch ID: " + branchId + " and " + getWhat);

	if (getWhat == "getValueIn" || getWhat == "getTurnInRate") {
		var today = new Date();
		var wk = getWeekOnly(today);        //get the week of today
		//console.log(wk);

		//var startDate = weekToDate(today.getFullYear(), wk, 0);     //get the 1st day of this week
//		var startDate = today.setDate(today.getDate() - today.getDay() + 1);
		var startDate = $('#weekpicker').val();
        splitDatePickerStr = startDate.split(" ");
        startDate = splitDatePickerStr[2].substr(1);

        var reformatDate = startDate.split("/");
        var reformatDateDay = reformatDate[0];
        var reformatDateMonth = reformatDate[1];
        var reformatDateYear = reformatDate[2];

        var convToDate = new Date(reformatDateMonth +"/"+ reformatDateDay + "/"+ reformatDateYear);

        var tempEndDate = new Date(convToDate);
        tempEndDate.setDate(convToDate.getDate()+6);
		var endDate = getDate(tempEndDate) + "/" + getMonth(tempEndDate) + "/" + tempEndDate.getFullYear();
        
        console.log(endDate);
		//var branchId = $("#selectBoxBranch").val();
		//var branchName = $("#selectBoxBranch option:selected").text();

		var thisWeekDateFrom = new Date(startDate);
		var thisWeekDateTo = new Date(startDate);
		thisWeekDateFrom.setDate(thisWeekDateFrom.getDate() - 7);
		thisWeekDateTo.setDate(thisWeekDateTo.getDate() - 1);
		var thisWeekFrom = thisWeekDateFrom.toString("dd/MM/yyyy");
		var thisWeekTo = thisWeekDateTo.toString("dd/MM/yyyy");

		var lastWeekDateFrom = new Date(startDate);
		var lastWeekDateTo = new Date(startDate);
		lastWeekDateFrom.setDate(lastWeekDateFrom.getDate() - 14);
		lastWeekDateTo.setDate(lastWeekDateTo.getDate() - 8);

		var lastWeekFrom = lastWeekDateFrom.toString("dd/MM/yyyy");
		var lastWeekTo = lastWeekDateTo.toString("dd/MM/yyyy");

		var dateStringFrom = getDate(thisWeekDateFrom) + "/" + getMonth(thisWeekDateFrom) + "/" + thisWeekDateFrom.getFullYear();
		var dateStringTo = getDate(thisWeekDateTo) + "/" + getMonth(thisWeekDateTo) + "/" + thisWeekDateTo.getFullYear();

		//$('#topTitle').text(branchName + ' WEEKLY REPORT ');
		//$('#topTitleDate').text(dateStringFrom + ' to ' + dateStringTo);
		var datas = new Object();
		datas.date = [];
		datas.valueIn = [];
		datas.valueOut = [];
		datas.turnInRate = [];
		datas.outsideTraffic = [];
		datas.lastDate = [];
		datas.lastValueIn = [];
		datas.lastValueOut = [];
		datas.changesRate = [];
		datas.lastOutsideTraffic = [];
		datas.lastTurnInRate = [];
		datas.maxYValue = 0;


		//datas.branchName = branchName;
		$.getJSON('/footfallcam/StoreFrontConversionDailyDataNew?BranchId=' + branchId + "&StartDate=" + startDate + "&EndDate=" + endDate, function (data) {
			var dayFootfallThisWeek = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
			var currentIndex = 0;
			//this is for outside traffice using wifi
			$.each(data.Cameras[0].ThisWeek7Days, function () {
				var index = parseInt(this.Day) - 1;

				var milli = this.DateTime * 1000;
				var d = new Date(parseInt(milli));
				var date = Date.UTC(d.getFullYear(), (d.getMonth() + 1), d.getDate());
				datas.valueIn.push(parseInt(this.ValueIn));
				datas.valueOut.push(parseInt(this.ValueOut));
				datas.outsideTraffic.push(23467);
				datas.outsideTraffic.push(parseInt(this.OutsideTraffic));
				datas.date.push(dayFootfallThisWeek[this.Day]);

				datas.turnInRate.push(parseFloat(this.TurnInRate.toFixed(1)));

				currentIndex++;
			});

			for (var i = datas.valueIn.length; i < 7; i++) {

				datas.valueIn.push(0);
				datas.valueOut.push(0);
				datas.date.push(0);
			}

			for (var i = datas.outsideTraffic.length; i < 7; i++) {
				datas.outsideTraffic.push(0);
				datas.turnInRate.push(0);
			}


			currentIndex = 0;
			$.each(data.Cameras[0].LastWeek7Days, function () {
				var index = parseInt(this.Day) - 1;
				datas.lastOutsideTraffic.push(parseInt(this.OutsideTraffic));
				datas.lastValueIn.push(parseInt(this.ValueIn));
				datas.lastValueOut.push(parseInt(this.ValueOut));
				datas.lastDate.push(this.Date);
				datas.lastTurnInRate.push(parseFloat(this.TurnInRate.toFixed(1)));
				currentIndex++;
			});

			//calculate the turn in rate because need to use both value in and outside traffic
			for (var i = 0; i < datas.lastValueIn.length; i++) {
				var lastTurnInRate = datas.lastTurnInRate[i];

				if (datas.lastOutsideTraffic[i] == 0 || datas.lastOutsideTraffic[i] == undefined)
					lastTurnInRate = 0;
				var changesRate = 0;
				if (lastTurnInRate == 0 || lastTurnInRate == undefined)
					changesRate = datas.turnInRate[i];
				else
					changesRate = (datas.turnInRate[i] - lastTurnInRate) / lastTurnInRate * 100;

				datas.changesRate.push(parseFloat(changesRate.toFixed(1)));
			}

			for (var i = datas.lastValueIn.length; i < 7; i++) {
				datas.lastOutsideTraffic.push(0);
				datas.changesRate.push(0.0);
				datas.lastValueIn.push(0);
				datas.lastValueOut.push(0);
				datas.lastDate.push(0);
			}

			var dataFound = false;

			if (datas.valueIn.length > 0)
				dataFound = true;

			//fix the outside traffic to greater than max data but not too high
			if (dataFound) {
				var highestData = Math.max.apply(Math, datas.outsideTraffic);
				var numberOfTimes = 0;

				while (highestData > 10) {
					highestData = highestData / 10;
					numberOfTimes++;
				}
				datas.maxYValue = Math.floor(++highestData) * (Math.pow(10, numberOfTimes));

				
				console.log(datas);

				//for footfall tab
				if (getWhat == "getValueIn") {
					var newTabId = "tabViewdhtmlgoodies_tabView1_" + tabId;

					//find the newly created tab
					var insertThis = document.getElementById(newTabId);
					console.log("Current Tab ID: " + newTabId);
					
					//$("#" + newTabId).addClass("chartLoading");
					for (var i = 0; i < datas.valueIn.length; i++) {
						totalVisitorThisWeek += datas.valueIn[i];
					}
					console.log("total visitor this week: " + totalVisitorThisWeek);

					var totalVisitorLastWeek = 0;
					for (var i = 0; i < datas.lastValueIn.length; i++) {
						totalVisitorLastWeek += datas.lastValueIn[i];
					}
					console.log("total visitor last week: " + totalVisitorLastWeek);

					//calculate the changes of total visitor of last week and this week in percentage
					var isTotalVisitorIncrease = 0;
					var differenceOfChangesForTotalVisitor = 0;
					var differenceOfTotalVisitorInPercentage = 0;
					//Determine if total visitor is increased or decreased
					if (totalVisitorThisWeek > totalVisitorLastWeek) { //if increased
						isTotalVisitorIncrease = 1;
						differenceOfChangesForTotalVisitor = totalVisitorThisWeek - totalVisitorLastWeek;
						differenceOfTotalVisitorInPercentage = differenceOfChangesForTotalVisitor / totalVisitorLastWeek * 100;
						console.log("Total Visitor Increased by: " + differenceOfTotalVisitorInPercentage.toFixed(1) + "%");
					} else if (totalVisitorLastWeek > totalVisitorThisWeek) { //if decreased
						isTotalVisitorIncrease = 0;
						differenceOfChangesForTotalVisitor = totalVisitorLastWeek - totalVisitorThisWeek;
						differenceOfTotalVisitorInPercentage = differenceOfChangesForTotalVisitor / totalVisitorLastWeek * 100;
						console.log("Total Visitor Decreased by: " + differenceOfTotalVisitorInPercentage.toFixed(1) + "%");
					}


					//------------------------------
					//values for graph under total visitor section -- Jack
					var eachDay = 0;
					var totalVisitor = 0;
					console.log("vvv Total visitor graph vvv");
					for (var i = 0; i < datas.date.length; i++) {
						//daily turn in rate for selected week
						eachDay = datas.date[i];
						totalVisitor = datas.valueIn[i];
						console.log(eachDay + ": " + totalVisitor);
					}
					
					var graphContainer = document.getElementById(newTabId);
					graphContainer.style.height = "400px";
					graphContainer.style.width = "770px";

					callLastWeekTrend_Tab(datas, newTabId);
					

				}

				//for footfall tab
				if (getWhat == "getTurnInRate") {
					var newTabId = "tabViewdhtmlgoodies_tabView1_" + tabId;

					//find the newly created tab
					var insertThis = document.getElementById(newTabId);

					//------------------------------
					//Begin Turn In Rate section
					//calculate IN count in compare with Turn In Rate (percentage) -- Jack
					var totalInCount = 0;
					for (var i = 0; i < datas.valueIn.length; i++) {
						totalInCount += datas.valueIn[i];
					}
					//console.log("total in count: " + totalInCount);

					var totalOutsideTraffic = 0;
					for (var i = 0; i < datas.outsideTraffic.length; i++) {
						totalOutsideTraffic += datas.outsideTraffic[i];
					}
					//console.log("total outside traffic: " + totalOutsideTraffic);

					var turnInRatePercentage = (totalInCount / totalOutsideTraffic) * 100;
					console.log("Turn in rate (%): " + turnInRatePercentage.toFixed(0) + "%");


					//------------------------------
					//calculate turn in rate changes -- Jack
					//calculate the total turn in rate of last week
					var totalTurnInRateLastWeek = 0;
					for (var i = 0; i < datas.lastTurnInRate.length; i++) {
						totalTurnInRateLastWeek += datas.lastTurnInRate[i];
					}
					//console.log("Last week: " + totalTurnInRateLastWeek);

					//calculate the total turn in rate of this week
					var totalTurnInRate = 0;
					for (var i = 0; i < datas.turnInRate.length; i++) {
						totalTurnInRate += datas.turnInRate[i];
						//console.log("totalturninrate: " + totalTurnInRate + " | [ " +i+" ]");
					}
					//console.log("This week: " + totalTurnInRate);

					//get turn in rate changes in percentage
					var isIncrease;
					var differenceOfChanges;
					var differenceTurnInRateInPercentage;
					//Determine if turn in rate is increased or decreased
					if (totalTurnInRate > totalTurnInRateLastWeek) { //if increased
						isIncrease = 1;
						differenceOfChanges = totalTurnInRate - totalTurnInRateLastWeek;
						differenceTurnInRateInPercentage = differenceOfChanges / totalTurnInRateLastWeek * 100;
						console.log("Turn In Rate Increased by: " + differenceTurnInRateInPercentage.toFixed(1) + "%");
					} else if (totalTurnInRateLastWeek > totalTurnInRate) { //if decreased
						isIncrease = 0;
						differenceOfChanges = totalTurnInRateLastWeek - totalTurnInRate;
						differenceTurnInRateInPercentage = differenceOfChanges / totalTurnInRateLastWeek * 100;
						console.log("Turn In Rate Decreased by: " + differenceTurnInRateInPercentage.toFixed(1) + "%");
					}

					//------------------------------
					//values for graph under turn in rate section -- Jack
					var eachDay = 0;
					var turnInRate = 0;
					console.log("vvv Turn in rate graph vvv");
					for (var i = 0; i < datas.date.length; i++) {
						//daily turn in rate for selected week
						eachDay = datas.date[i];
						turnInRate = datas.turnInRate[i];
						console.log(eachDay + ": " + turnInRate + "%");
					}

					//get percentage of last last week
					$.getJSON('/footfallcam/StoreFrontConversionDailyDataNewGetLastLastWeek?BranchId=' + branchId, function (data) {
						var currentIndex = 0;
						$.each(data.Cameras[0].ThisWeek7Days, function () {
							datas.turnInRate.push(parseFloat(this.TurnInRate.toFixed(1)));
							currentIndex++;
						});

						for (var i = datas.valueIn.length; i < 7; i++) {
							datas.valueIn.push(0);
							datas.valueOut.push(0);
							datas.date.push(0);
						}

						currentIndex = 0;
						$.each(data.Cameras[0].LastWeek7Days, function () {
							var index = parseInt(this.Day) - 1;
							datas.lastTurnInRate.push(parseFloat(this.TurnInRate.toFixed(1)));
							currentIndex++;
						});

						var dataFound = false;

						if (datas.valueIn.length > 0)
							dataFound = true;

						if (dataFound) {
							var turnInRatePercentage = (totalInCount / totalOutsideTraffic) * 100;
							//------------------------------
							//calculate turn in rate changes -- Jack
							//calculate the total turn in rate of last last week
							var totalTurnInRateLastWeek = 0;
							for (var i = 0; i < datas.lastTurnInRate.length; i++) {
								totalTurnInRateLastWeek += datas.lastTurnInRate[i];
							}
							//console.log("Last last week: " + totalTurnInRateLastWeek);

							//calculate the total turn in rate of last week
							var totalTurnInRate = 0;
							for (var i = 0; i < datas.turnInRate.length; i++) {
								totalTurnInRate += datas.turnInRate[i];
							}
							//console.log("Last  week: " + totalTurnInRate);

							//get turn in rate changes in percentage for last week and last last week
							var isIncrease;
							var differenceOfChanges;
							var differenceTurnInRateInPercentage;
							//Determine if turn in rate is increased or decreased
							if (totalTurnInRate > totalTurnInRateLastWeek) { //if increased
								isIncrease = 1;
								differenceOfChanges = totalTurnInRate - totalTurnInRateLastWeek;
								differenceTurnInRateInPercentage = differenceOfChanges / totalTurnInRateLastWeek * 100;
								console.log("Last Week Turn In Rate Increased by: " + differenceTurnInRateInPercentage.toFixed(1) + "%");
							} else if (totalTurnInRateLastWeek > totalTurnInRate) { //if decreased
								isIncrease = 0;
								differenceOfChanges = totalTurnInRateLastWeek - totalTurnInRate;
								differenceTurnInRateInPercentage = differenceOfChanges / totalTurnInRateLastWeek * 100;
								console.log("Last Week Turn In Rate Decreased by: " + differenceTurnInRateInPercentage.toFixed(1) + "%");
							}
						}
					});

					var graphContainer = document.getElementById(newTabId);
					graphContainer.style.height = "400px";
					graphContainer.style.width = "770px";

					callLastWeekTurnInRateTrend_Tab(datas, newTabId);


				}





			}

			//$("#dataTable").html("");

			//$("#dataTable").append('<tr><th rowspan="2" style="width:75px;">Week ' + wk + '</th><th colspan="2">Footfall</th><th colspan="2">Conversion</th></tr><tr><th style="width:89px;">Today<span style="font-size:9px; font-weight:default;"> (Last Week)</span></th><th style="width:61px;">Changes</th><th style="width:61px;">Today</th><th style="width:72px;">Changes</th></tr>');


			//put into table if needed
			for (var i = 0; i < datas.valueIn.length; i++) {
				var valueIn = datas.valueIn[i];
				var lastValueIn = datas.lastValueIn[i];
				var footfallChanges = valueIn - lastValueIn;
				var turnInRate = datas.turnInRate[i];
				var changesRate = datas.changesRate[i];
				var arrowClassName = "positive";
				var rateArrowClass = "positive";
				if (footfallChanges < 0) {
					arrowClassName = "negative";
					footfallChanges = footfallChanges * -1;
				}
				if (changesRate < 0) {
					rateArrowClass = "negative";
					changesRate = changesRate * -1;
				}
				//$("#dataTable").append('<tr><td>' + day[i] + '</td><td style="text-align:center; ">' + valueIn + ' <span style="font-size:9px; font-weight:default;">(' + lastValueIn + ')</span></td><td style="text-align:center;" class="' + arrowClassName + '">' + footfallChanges + '</td><td style="text-align:center; ">' + turnInRate + '%</td><td style="text-align:center;" class="' + rateArrowClass + '">' + changesRate.toFixed(1) + '%</td></tr>');
			}
		});






	} else if (getWhat == "getReturningCustomer") {
		var newTabId = "tabViewdhtmlgoodies_tabView1_" + tabId;

		//find the newly created tab
		var insertThis = document.getElementById(newTabId);
		console.log("get returning customer");

		var branchId = branchId;

		var datas = new Object();
		datas.newCust = [];
		datas.vlwCust = [];
		datas.returningRate = [];
		datas.totalCount = [];
		datas.categories = [];

		var thisYearReturningCustomerMTD = new Object();
		thisYearReturningCustomerMTD.newCust = [];
		thisYearReturningCustomerMTD.vlwCust = [];
		thisYearReturningCustomerMTD.returningRate = [];
		thisYearReturningCustomerMTD.totalCount = [];
		thisYearReturningCustomerMTD.categories = [];
		thisYearReturningCustomerMTD.MTD = [];

		var lastYearReturningCustomerMTD = new Object();
		lastYearReturningCustomerMTD.newCust = [];
		lastYearReturningCustomerMTD.vlwCust = [];
		lastYearReturningCustomerMTD.returningRate = [];
		lastYearReturningCustomerMTD.totalCount = [];
		lastYearReturningCustomerMTD.categories = [];
		lastYearReturningCustomerMTD.MTD = [];

		var thisYearReturningCustomerYTD = new Object();
		thisYearReturningCustomerYTD.newCust = [];
		thisYearReturningCustomerYTD.vlwCust = [];
		thisYearReturningCustomerYTD.returningRate = [];
		thisYearReturningCustomerYTD.totalCount = [];
		thisYearReturningCustomerYTD.categories = [];
		thisYearReturningCustomerYTD.YTD = [];

		var lastYearReturningCustomerYTD = new Object();
		lastYearReturningCustomerYTD.newCust = [];
		lastYearReturningCustomerYTD.vlwCust = [];
		lastYearReturningCustomerYTD.returningRate = [];
		lastYearReturningCustomerYTD.totalCount = [];
		lastYearReturningCustomerYTD.categories = [];
		lastYearReturningCustomerYTD.YTD = [];

		var lastYearDatas = new Object();
		lastYearDatas.newCust = [];
		lastYearDatas.vlwCust = [];
		lastYearDatas.returningRate = [];
		lastYearDatas.totalCount = [];
		lastYearDatas.categories = [];

		var lastWeekDatas = new Object();
		lastWeekDatas.newCust = [];
		lastWeekDatas.vlwCust = [];
		//datas.vlmCust = [];
		lastWeekDatas.categories = [];

		var today = new Date();
		var wk = getWeekOnly(today);        //get the week of today
		var year = today.getFullYear();
		if (wk == 1 && getMonth(today) == 12)
			year = year + 1;
		//var startDate = weekToDate(year, wk, 0);     //get the 1st day of this week
		var startDate = new Date(today.setDate(today.getDate() - today.getDay() + 1));
		var endDate = new Date(startDate);
		startDate.setDate(startDate.getDate() - 7);
		endDate.setDate(endDate.getDate() - 1);

		var start = startDate.getFullYear() + "-" + (startDate.getMonth() + 1) + "-" + startDate.getDate();
		var end = endDate.getFullYear() + "-" + (endDate.getMonth() + 1) + "-" + endDate.getDate();
		var returningRateWeeklyPercent = 0;
		var returningRateWeeklyPercentMTD = 0;
		var lastYearReturningRateWeeklyPercentMTD = 0;
		var lastYearReturningRateWeeklyPercentYTD = 0;
		var returningRateWeeklyPercentYTD = 0;
		var lastYearReturningRateWeeklyPercent = 0;
		var lastWeekReturningRateWeeklyPercent = 0;

		$.getJSON('/Footfallcam/ReturningCustomersDataNew?branchId=' + branchId + '&StartDate=' + start + '&EndDate=' + end, function (data) {
			var dayFootfallThisWeek = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
			data = data.Countings;
			var dataLength = data.length;
			var vlwCustPercent = 0;
			var newCustPercent = 0;
			for (var i = 0; i < dataLength; i++) {
				var vlwCustValue = parseInt((parseInt(data[i].VisitedLastMonth) + parseInt(data[i].VisitedLastWeek)) / 100.0 * parseInt(data[i].TotalCount));
				var newCustValue = parseInt(data[i].TotalCount) - vlwCustValue;
				var returningCustValue = parseInt(data[i].TotalCount) - newCustValue;
				//datas.date.push(dayFootfallThisWeek[this.Day]);
				//console.log("Day " + i + ": " + vlwCustValue);
				if (data[i].TotalCount == 0) {
					vlwCustPercent += (vlwCustValue / 1) * 100;
					newCustPercent += (newCustValue / 1) * 100;
				} else {
					vlwCustPercent += (vlwCustValue / parseInt(data[i].TotalCount)) * 100;
					newCustPercent += (newCustValue / parseInt(data[i].TotalCount)) * 100;
				}

				var totalValue = data[i].TotalCount;
				returningRateWeeklyPercent += (parseInt(data[i].VisitedLastMonth) + parseInt(data[i].VisitedLastWeek));
				datas.categories[i] = day[i];
				datas.returningRate.push(parseInt(data[i].VisitedLastMonth) + parseInt(data[i].VisitedLastWeek));
				datas.newCust.push(newCustValue);
				datas.vlwCust.push(vlwCustValue);
				datas.totalCount.push(totalValue);
				//console.log(vlwCustPercent);
			};

			//for circle pie chart
			console.log("Returning Percentage: " + (vlwCustPercent / dataLength).toFixed(1) + "%");
			console.log("New Customer Percentage: " + (newCustPercent / dataLength).toFixed(1) + "%");

			//$("#returningCustomer").removeClass("chartLoading");
			//callReturningCustomerChart(datas);
			console.log(datas);

			 var graphContainer = document.getElementById(newTabId);
			graphContainer.style.height = "400px";
			graphContainer.style.width = "770px";
			callLastWeekReturningRate_Tab(datas, newTabId);    

			console.log("vvv Returning Rate vvv");
			console.log("Returning Rate weekly (%): " + (returningRateWeeklyPercent / dataLength).toFixed(1) + "%");
		});

		$.getJSON('/Footfallcam/ReturningCustomersDataNewMTD?branchId=' + branchId + '&StartDate=' + start + '&EndDate=' + end, function (data) {
			data = data.Countings;
			var dataLength = data.length;
			for (var i = 0; i < dataLength; i++) {
				var vlwCustValue = parseInt((parseInt(data[i].VisitedLastMonth) + parseInt(data[i].VisitedLastWeek)) / 100.0 * parseInt(data[i].TotalCount));
				var newCustValue = parseInt(data[i].TotalCount) - vlwCustValue;
				var totalValue = data[i].TotalCount;
				returningRateWeeklyPercentMTD += (parseInt(data[i].VisitedLastMonth) + parseInt(data[i].VisitedLastWeek));
				thisYearReturningCustomerMTD.returningRate.push(parseInt(data[i].VisitedLastMonth) + parseInt(data[i].VisitedLastWeek) + "%");
				thisYearReturningCustomerMTD.newCust.push(newCustValue);
				thisYearReturningCustomerMTD.vlwCust.push(vlwCustValue);
				thisYearReturningCustomerMTD.totalCount.push(totalValue);


			};

			//console.log(thisYearReturningCustomerMTD);
			thisYearReturningCustomerMTD.MTD.push((returningRateWeeklyPercentMTD / dataLength).toFixed(1) + "%");
			console.log("Returning Customer MTD (%): " + (returningRateWeeklyPercentMTD / dataLength).toFixed(1) + "%");
		});

		$.getJSON('/Footfallcam/ReturningCustomersDataNewLMTD?branchId=' + branchId + '&StartDate=' + start + '&EndDate=' + end, function (data) {
			data = data.Countings;
			var dataLength = data.length;
			for (var i = 0; i < dataLength; i++) {
				var vlwCustValue = parseInt((parseInt(data[i].VisitedLastMonth) + parseInt(data[i].VisitedLastWeek)) / 100.0 * parseInt(data[i].TotalCount));
				var newCustValue = parseInt(data[i].TotalCount) - vlwCustValue;
				var totalValue = data[i].TotalCount;
				lastYearReturningRateWeeklyPercentMTD += (parseInt(data[i].VisitedLastMonth) + parseInt(data[i].VisitedLastWeek));
				lastYearReturningCustomerMTD.returningRate.push(parseInt(data[i].VisitedLastMonth) + parseInt(data[i].VisitedLastWeek) + "%");
				lastYearReturningCustomerMTD.newCust.push(newCustValue);
				lastYearReturningCustomerMTD.vlwCust.push(vlwCustValue);
				lastYearReturningCustomerMTD.totalCount.push(totalValue);
			};

			//console.log(lastYearReturningCustomerMTD);
			lastYearReturningCustomerMTD.MTD.push((lastYearReturningRateWeeklyPercentMTD / dataLength).toFixed(1) + "%");
			console.log("Last Year Returning Customer MTD (%): " + (lastYearReturningRateWeeklyPercentMTD / dataLength).toFixed(1) + "%");
		});

		$.getJSON('/Footfallcam/ReturningCustomersDataNewYTD?branchId=' + branchId + '&StartDate=' + start + '&EndDate=' + end, function (data) {
			data = data.Countings;
			var dataLength = data.length;
			for (var i = 0; i < dataLength; i++) {
				var vlwCustValue = parseInt((parseInt(data[i].VisitedLastMonth) + parseInt(data[i].VisitedLastWeek)) / 100.0 * parseInt(data[i].TotalCount));
				var newCustValue = parseInt(data[i].TotalCount) - vlwCustValue;
				var totalValue = data[i].TotalCount;
				returningRateWeeklyPercentYTD += (parseInt(data[i].VisitedLastMonth) + parseInt(data[i].VisitedLastWeek));
				thisYearReturningCustomerYTD.returningRate.push(parseInt(data[i].VisitedLastMonth) + parseInt(data[i].VisitedLastWeek) + "%");
				thisYearReturningCustomerYTD.newCust.push(newCustValue);
				thisYearReturningCustomerYTD.vlwCust.push(vlwCustValue);
				thisYearReturningCustomerYTD.totalCount.push(totalValue);
			};

			thisYearReturningCustomerYTD.YTD.push((returningRateWeeklyPercentYTD / dataLength).toFixed(1) + "%");
			//console.log(thisYearReturningCustomerYTD);
			console.log("Returning Customer YTD (%): " + (returningRateWeeklyPercentYTD / dataLength).toFixed(1) + "%");
		});

		$.getJSON('/Footfallcam/ReturningCustomersDataNewLYTD?branchId=' + branchId + '&StartDate=' + start + '&EndDate=' + end, function (data) {
			data = data.Countings;
			var dataLength = data.length;
			for (var i = 0; i < dataLength; i++) {
				var vlwCustValue = parseInt((parseInt(data[i].VisitedLastMonth) + parseInt(data[i].VisitedLastWeek)) / 100.0 * parseInt(data[i].TotalCount));
				var newCustValue = parseInt(data[i].TotalCount) - vlwCustValue;
				var totalValue = data[i].TotalCount;
				lastYearReturningRateWeeklyPercentYTD += (parseInt(data[i].VisitedLastMonth) + parseInt(data[i].VisitedLastWeek));
				lastYearReturningCustomerYTD.returningRate.push(parseInt(data[i].VisitedLastMonth) + parseInt(data[i].VisitedLastWeek) + "%");
				lastYearReturningCustomerYTD.newCust.push(newCustValue);
				lastYearReturningCustomerYTD.vlwCust.push(vlwCustValue);
				lastYearReturningCustomerYTD.totalCount.push(totalValue);
			};

			lastYearReturningCustomerYTD.YTD.push((lastYearReturningRateWeeklyPercentYTD / dataLength).toFixed(1) + "%");
			//console.log(lastYearReturningCustomerYTD);
			console.log("Last Year Returning Customer YTD (%): " + (lastYearReturningRateWeeklyPercentYTD / dataLength).toFixed(1) + "%");
		});

		$.getJSON('/Footfallcam/ReturningCustomersDataLastYear?branchId=' + branchId + '&StartDate=' + start + '&EndDate=' + end, function (lastYear) {
			lastYear = lastYear.Countings;
			var dataLength = lastYear.length;

			for (var i = 0; i < dataLength; i++) {
				var vlwCustValue = parseInt((parseInt(lastYear[i].VisitedLastMonth) + parseInt(lastYear[i].VisitedLastWeek)) / 100.0 * parseInt(lastYear[i].TotalCount));
				var newCustValue = parseInt(lastYear[i].TotalCount) - vlwCustValue;
				var totalValue = lastYear[i].TotalCount;
				lastYearReturningRateWeeklyPercent += (parseInt(lastYear[i].VisitedLastMonth) + parseInt(lastYear[i].VisitedLastWeek));
				lastYearDatas.categories[i] = day[i];
				lastYearDatas.returningRate.push(parseInt(lastYear[i].VisitedLastMonth) + parseInt(lastYear[i].VisitedLastWeek) + "%");
				lastYearDatas.newCust.push(newCustValue);
				lastYearDatas.vlwCust.push(vlwCustValue);
				lastYearDatas.totalCount.push(totalValue);
			};

			//console.log(lastYearDatas);

			console.log("vvv Last Year Monthly Returning Rate vvv");
			console.log("Last Year Returning Rate weekly (%): " + (lastYearReturningRateWeeklyPercent / 7).toFixed(1) + "%");
		});



		$.getJSON('/Footfallcam/ReturningCustomersDataNewLastLastWeek?branchId=' + branchId + '&StartDate=' + start + '&EndDate=' + end, function (lastWeekData) {
			lastWeekData = lastWeekData.Countings;
			var dataLength = lastWeekData.length;

			for (var i = 0; i < dataLength; i++) {
				var milli = lastWeekData[i].Date * 1000;
				var d = new Date(parseInt(milli));
				var date = Date.UTC(d.getFullYear(), (d.getMonth() + 1), d.getDate());
				var vlwCustValue = parseInt((parseInt(lastWeekData[i].VisitedLastMonth) + parseInt(lastWeekData[i].VisitedLastWeek)) / 100.0 * parseInt(lastWeekData[i].TotalCount));
				var newCustValue = parseInt(lastWeekData[i].TotalCount) - vlwCustValue;

				lastWeekReturningRateWeeklyPercent += (parseInt(lastWeekData[i].VisitedLastMonth) + parseInt(lastWeekData[i].VisitedLastWeek));
				lastWeekDatas.categories[i] = day[i];
				lastWeekDatas.newCust.push(newCustValue);
				lastWeekDatas.vlwCust.push(vlwCustValue);
			};

			console.log("vvv Last Week Returning Rate vvv");
			console.log("Last Week Returning Rate weekly (%): " + (lastWeekReturningRateWeeklyPercent / 7).toFixed(1) + "%");
		});

		//formula to count weekly returning rate changes (%)
		if (returningRateWeeklyPercent > lastWeekReturningRateWeeklyPercent) {
			var returningRateChanges = returningRateWeeklyPercent - lastWeekReturningRateWeeklyPercent;
			console.log("Returning Rate increased by: " + returningRateChanges + "%");
		} else if (returningRateWeeklyPercent < lastWeekReturningRateWeeklyPercent) {
			var returningRateChanges = lastWeekReturningRateWeeklyPercent - returningRateWeeklyPercent;
			console.log("Returning Rate decreased by: " + returningRateChanges + "%");
		}







	} else {
		var datas = new Object();

		//last year data
		datas.lastYearIn = [];
		datas.lastYearOut = [];
		datas.lastYearMonths = [];

		//current year data
		datas.valueIn = [];
		datas.valueOut = [];
		datas.month = [];

		datas.categories = [];

		$.getJSON('/footfallcam/ComparePrevYearMonthlyFootfallData?BranchId=' + branchId, function (data) {

			//last year data
			$.each(data[0], function () {
				datas.lastYearIn.push(this.ValueIn);
				datas.lastYearOut.push(this.ValueOut);
				var convertedMonth = this.Month;
				if (convertedMonth == "001") {
					convertedMonth = "Jan";
				}
				if (convertedMonth == "002") {
					convertedMonth = "Feb";
				}
				if (convertedMonth == "003") {
					convertedMonth = "Mar";
				}
				if (convertedMonth == "004") {
					convertedMonth = "Apr";
				}
				if (convertedMonth == "005") {
					convertedMonth = "May";
				}
				if (convertedMonth == "006") {
					convertedMonth = "Jun";
				}
				if (convertedMonth == "007") {
					convertedMonth = "Jul";
				}
				if (convertedMonth == "008") {
					convertedMonth = "Aug";
				}
				if (convertedMonth == "009") {
					convertedMonth = "Sep";
				}
				if (convertedMonth == "010") {
					convertedMonth = "Oct";
				}
				if (convertedMonth == "011") {
					convertedMonth = "Nov";
				}
				if (convertedMonth == "012") {
					convertedMonth = "Dec";
				}
				datas.month.push(convertedMonth);
			});

			//current year data
			$.each(data[1], function () {
				datas.valueIn.push(this.ValueIn);
				datas.valueOut.push(this.ValueOut);
				var convertedMonth = this.Month;
				if (convertedMonth == "001") {
					convertedMonth = "Jan";
				}
				if (convertedMonth == "002") {
					convertedMonth = "Feb";
				}
				if (convertedMonth == "003") {
					convertedMonth = "Mar";
				}
				if (convertedMonth == "004") {
					convertedMonth = "Apr";
				}
				if (convertedMonth == "005") {
					convertedMonth = "May";
				}
				if (convertedMonth == "006") {
					convertedMonth = "Jun";
				}
				if (convertedMonth == "007") {
					convertedMonth = "Jul";
				}
				if (convertedMonth == "008") {
					convertedMonth = "Aug";
				}
				if (convertedMonth == "009") {
					convertedMonth = "Sep";
				}
				if (convertedMonth == "010") {
					convertedMonth = "Oct";
				}
				if (convertedMonth == "011") {
					convertedMonth = "Nov";
				}
				if (convertedMonth == "012") {
					convertedMonth = "Dec";
				}
				datas.lastYearMonths.push(convertedMonth);
			});

			if (datas.month[0] != undefined) {
				for (var i = 0; i < 12; i++) {
					datas.categories.push(datas.month[i]);
				}

				//callMonthlyTrend(datas);
				//console.log(datas);
			}
			else {
				//$('#newMonthlyTrend').html('<h3 style="color:grey; text-align:center; "> No Data Found! </h3>');
			}
		});
	}





	//if (tabContent) div.innerHTML = passedString;
	//put content for selected branch




	if (tabContentUrl) {
		var ajaxIndex = ajaxObjects.length;
		ajaxObjects[ajaxIndex] = new sack();
		ajaxObjects[ajaxIndex].requestFile = tabContentUrl; // Specifying which file to get

		ajaxObjects[ajaxIndex].onCompletion = function () { showAjaxTabContent(ajaxIndex, parentId, tabId); }; // Specify function that will be executed after file has been found
		ajaxObjects[ajaxIndex].runAJAX(); 	// Execute AJAX function

	}

}



function callLastWeekTrend_Tab(datas, newTabId) {
	$(function () {
		var chart = new Highcharts.Chart({
			chart: {
				renderTo: newTabId,
				type: "column",
				events: {
					load: function () {
						chartEvent[0] = this;
					}
				},
			},
			credits: {
				enabled: false
			},
			title: {
				text: null,
				align: 'left'
			},
			tooltip: {
				shared: true
			},
			plotOptions: {
				column: {
					stacking: 'normal'
				}
			},
			yAxis: [{
				lineWidth: 1,
				gridLineWidth: 0,
				tickWidth: 1,
				tickLength: 5,
				tickPosition: 'inside',
				title: {
					text: 'No. of Visitor',
					margin: 5,
					style: {
						fontSize: '12px',
						"font-family": "Franklin Gothic Medium"
					}
				},
				labels: {
					style: {
						fontSize: '10px',
						"font-family": "Franklin Gothic Book"
					}
				}
			}, 
//            {
//                opposite: false,
//                gridLineWidth: 0,
//                lineWidth: 1,
//                tickWidth: 1,
//                tickLength: 5,
//                tickPosition: 'inside',
//                max: datas.maxYValue,
//                min: 0,
//                labels: {
//                    align: 'left',
//                    style: {
//                        fontSize: '10px',
//                        "font-family": "Franklin Gothic Book"
//                    }
//                },
//                title: 
//                {
//                    text: 'Outside Traffic',
//                    style: 
//                    {
//                    fontSize: '12px',
//                    "font-family": "Franklin Gothic Medium"
//                    }
//                }
//            }, 
			{
				lineWidth: 0,
				gridLineWidth: 0,
				max: 100,
				min: 0,
				dataLabels: {
					enabled: true,
					format: '{y} %',
					rotation: -90,
					y: -25,
					x: 3
				},
				title: {
					text: null
				},
				labels: {
					enabled: false
				}
			}],
			xAxis: {
				categories: datas.date,
				tickWidth: 0,
				labels: {
					rotation: 0,
					style: {
						"font-family": "Franklin Gothic Book",
						fontSize: '10px'
					}
				}
			},
			series: [
			{
				name: 'Footfall',
				color: '#97c5e9',
				data: datas.valueIn,
				pointWidth: 40
			}, 
//            {
//                yAxis: 1,
//                name: 'Outside Traffic',
//                type: 'area',
//                fillColor: 'rgba(249, 189, 113, 0.1)',
//                color: '#f9bd71',
//                data: datas.outsideTraffic,
//                marker: 
//                {
//                    enabled: false
//                }
//            }, 
//            {
//                yAxis: 2,
//                name: 'Turn In Rate',
//                type: 'line',
//                marker: {
//                    symbol: 'square'
//                },
//                dataLabels: {
//                    enabled: true
//                },
//                color: '#2482c4',
//                lineWidth: 0,
//                data: datas.turnInRate
//            }

			//, {
			//   data: dataOut
			//}
				],
			legend: {
				enabled: true,
				align: 'center',
				layout: 'horizontal',
				verticalAlign: 'top',
				shadow: true,
				symbolHeight: 10,
				symbolWidth: 10,
				itemStyle: {
					color: '#787878',
					fontSize: '11px',		
					fontweight: 'normal',
					fontFamily: 'Franklin Gothic Book',
				}
			},
			exporting: {
				enabled: false,
				sourceWidth: 326,
				sourceHeight: 304       
			}
		});
	});
}

function callLastWeekTurnInRateTrend_Tab(datas, newTabId) {
	$(function () {
		var chart = new Highcharts.Chart({
			chart: {
				renderTo: newTabId,
				type: "column",
				events: {
					load: function () {
						chartEvent[0] = this;
					}
				},
			},
			credits: {
				enabled: false
			},
			title: {
				text: null,
				align: 'left'
			},
			tooltip: {
				shared: true
			},
			plotOptions: {
				column: {
					stacking: 'normal'
				}
			},
			yAxis: [{
				lineWidth: 1,
				gridLineWidth: 0,
				tickWidth: 1,
				tickLength: 5,
				tickPosition: 'inside',
				title: {
					text: 'Turn In Rate',
					margin: 5,
					style: {
						fontSize: '12px',
						"font-family": "Franklin Gothic Medium"
					}
				},
				labels: {
					style: {
						fontSize: '10px',
						"font-family": "Franklin Gothic Book"
					}
				}
			},
//             {
//                opposite: false,
//                gridLineWidth: 0,
//                lineWidth: 1,
//                tickWidth: 1,
//                tickLength: 5,
//                tickPosition: 'inside',
//                max: datas.maxYValue,
//                min: 0,
//                labels: {
//                    align: 'left',
//                    style: {
//                        fontSize: '10px',
//                        "font-family": "Franklin Gothic Book"
//                    }
//                },
//                title: {
//                    text: 'Outside Traffic',
//                    style: {
//                fontSize: '12px',
//                "font-family": "Franklin Gothic Medium"
//            }
//                }
//            },
			 {
				lineWidth: 0,
				gridLineWidth: 0,
				max: 100,
				min: 0,
				dataLabels: {
					enabled: true,
					format: '{y} %',
					rotation: -90,
					y: -25,
					x: 3
				},
				title: {
					text: null
				},
				labels: {
					enabled: false
				}
			}],
			xAxis: {
				categories: datas.date,
				tickWidth: 0,
				labels: {
					rotation: 0,
					style: {
						"font-family": "Franklin Gothic Book",
						fontSize: '10px'
					}
				}
			},
			series: [
			{
				name: 'Turn In Rate',
				color: '#2482c4',
				data: datas.turnInRate,
				pointWidth: 40
			}, 
//            {
//                yAxis: 1,
//                name: 'Outside Traffic',
//                type: 'area',
//                fillColor: 'rgba(249, 189, 113, 0.1)',
//                color: '#f9bd71',
//                data: datas.outsideTraffic,
//                marker: 
//                {
//                    enabled: false
//                }
//            }, 
//            {
//                yAxis: 2,
//                name: 'Turn In Rate',
//                type: 'line',
//                marker: {
//                    symbol: 'square'
//                },
//                dataLabels: {
//                    enabled: true
//                },
//                color: '#2482c4',
//                lineWidth: 0,
//                data: datas.turnInRate
//            }

			//, {
			//   data: dataOut
			//}
				],
			legend: {
				enabled: true,
				align: 'center',
				layout: 'horizontal',
				verticalAlign: 'top',
				shadow: true,
				symbolHeight: 10,
				symbolWidth: 10,
				itemStyle: {
					color: '#787878',
					fontSize: '11px',		
					fontweight: 'normal',
					fontFamily: 'Franklin Gothic Book',
				}
			},
			exporting: {
				enabled: false,
				sourceWidth: 326,
				sourceHeight: 304       
			}
		});
	});
}

function callLastWeekReturningRate_Tab(datas, newTabId) {
	$(function () {
		var chart = new Highcharts.Chart({
			chart: {
				renderTo: newTabId,
				type: "column",
				events: {
					load: function () {
						chartEvent[0] = this;
					}
				},
			},
			credits: {
				enabled: false
			},
			title: {
				text: null,
				align: 'left'
			},
			tooltip: {
				shared: true
			},
			plotOptions: {
				column: {
					stacking: 'normal'
				}
			},
			yAxis: [{
				lineWidth: 1,
				gridLineWidth: 0,
				tickWidth: 1,
				tickLength: 5,
				tickPosition: 'inside',
				title: {
					text: 'Returning Rate',
					margin: 5,
					style: {
						fontSize: '12px',
						"font-family": "Franklin Gothic Medium"
					}
				},
				labels: {
					style: {
						fontSize: '10px',
						"font-family": "Franklin Gothic Book"
					}
				}
			}, 
//            {
//                opposite: false,
//                gridLineWidth: 0,
//                lineWidth: 1,
//                tickWidth: 1,
//                tickLength: 5,
//                tickPosition: 'inside',
//                max: datas.maxYValue,
//                min: 0,
//                labels: {
//                    align: 'left',
//                    style: {
//                        fontSize: '10px',
//                        "font-family": "Franklin Gothic Book"
//                    }
//                },
//                title: {
//                    text: 'Outside Traffic',
//                    style: {
//                fontSize: '12px',
//                "font-family": "Franklin Gothic Medium"
//            }
//                }
//            },
			 {
				lineWidth: 0,
				gridLineWidth: 0,
				max: 100,
				min: 0,
				dataLabels: {
					enabled: true,
					format: '{y} %',
					rotation: -90,
					y: -25,
					x: 3
				},
				title: {
					text: null
				},
				labels: {
					enabled: false
				}
			}],
			xAxis: {
				categories: datas.categories,
				tickWidth: 0,
				labels: {
					rotation: 0,
					style: {
						"font-family": "Franklin Gothic Book",
						fontSize: '10px'
					}
				}
			},
			series: [
			{
				name: 'Returning Rate (%)',
				color: '#f9bd71',
				type: 'line',
				data: datas.returningRate,
				pointWidth: 40
			}, 
//            {
//                yAxis: 1,
//                name: 'Outside Traffic',
//                type: 'area',
//                fillColor: 'rgba(249, 189, 113, 0.1)',
//                color: '#f9bd71',
//                data: datas.outsideTraffic,
//                marker: 
//                {
//                    enabled: false
//                }
//            }, 
//            {
//                yAxis: 2,
//                name: 'Turn In Rate',
//                type: 'line',
//                marker: {
//                    symbol: 'square'
//                },
//                dataLabels: {
//                    enabled: true
//                },
//                color: '#2482c4',
//                lineWidth: 0,
//                data: datas.turnInRate
//            }

			//, {
			//   data: dataOut
			//}
				],
			legend: {
				enabled: true,
				align: 'center',
				layout: 'horizontal',
				verticalAlign: 'top',
				shadow: true,
				symbolHeight: 10,
				symbolWidth: 10,
				itemStyle: {
					color: '#787878',
					fontSize: '11px',		
					fontweight: 'normal',
					fontFamily: 'Franklin Gothic Book',
				}
			},
			exporting: {
				enabled: false,
				sourceWidth: 326,
				sourceHeight: 304       
			}
		});
	});
}



function getTabIndexByTitle(tabTitle) {
	var regExp = new RegExp("(.*?)&nbsp.*$", "gi");
	tabTitle = tabTitle.replace(regExp, '$1');
	for (var prop in dhtmlgoodies_tabObj) {
		var divs = dhtmlgoodies_tabObj[prop].getElementsByTagName('DIV');
		for (var no = 0; no < divs.length; no++) {
			if (divs[no].id.indexOf('tabTab') >= 0) {
				var span = divs[no].getElementsByTagName('SPAN')[0];
				var regExp2 = new RegExp("(.*?)&nbsp.*$", "gi");
				var spanTitle = span.innerHTML.replace(regExp2, '$1');

				if (spanTitle == tabTitle) {

					var tmpId = divs[no].id.split('_');
					return Array(prop, tmpId[tmpId.length - 1].replace(/[^0-9]/g, '') / 1);
				}
			}
		}
	}

	return -1;

}

/* Call this function if you want to display some content from external file in one of the tabs
Arguments: Title of tab and relative path to external file */

function addAjaxContentToTab(tabTitle, tabContentUrl) {
	var index = getTabIndexByTitle(tabTitle);
	if (index != -1) {
		var ajaxIndex = ajaxObjects.length;

		tabId = index[1];
		parentId = index[0];


		ajaxObjects[ajaxIndex] = new sack();
		ajaxObjects[ajaxIndex].requestFile = tabContentUrl; // Specifying which file to get

		ajaxObjects[ajaxIndex].onCompletion = function () { showAjaxTabContent(ajaxIndex, parentId, tabId); }; // Specify function that will be executed after file has been found
		ajaxObjects[ajaxIndex].runAJAX(); 	// Execute AJAX function

	}
}



function deleteTab(tabLabel, tabIndex, parentId) {

	if (tabLabel) {
		var index = getTabIndexByTitle(tabLabel);
		if (index != -1) {
			deleteTab(false, index[1], index[0]);
		}

	} else if (tabIndex >= 0) {
		if (document.getElementById('tabTab' + parentId + '_' + tabIndex)) {
			var obj = document.getElementById('tabTab' + parentId + '_' + tabIndex);
			var id = obj.parentNode.parentNode.id;
			obj.parentNode.removeChild(obj);
			var obj2 = document.getElementById('tabView' + parentId + '_' + tabIndex);
			obj2.parentNode.removeChild(obj2);
			resetTabIds(parentId);
			activeTabIndex[parentId] = -1;
			showTab(parentId, '0');
		}
	}

}

