//HOW TO USE:
//var a_random_variable_name = new CustomBootstrapModal({
//	title: "Alert",
//	content: "Content text here",
//	addClass: "", //modal-lg, modal-sm
//	buttons: [{
//			title: "Close",
//			btnClick: function () {
//				//to close popup
//				a_random_variable_name.hide();
//			}
//	},
//		{
//			title: "Okay",
//			btnClass: "btn-primary",
//			btnClick: function () {
//				//to close popup
//				a_random_variable_name.hide();
//			}
//	}]
//});



var CustomBootstrapModal = (function ($) {

	"use strict";

	function CustomBootstrapModal(options) {
		this.options = $.extend(true, {}, CustomBootstrapModal.DEFAULTS, options);
		this.$target = $("body");
		this.init();
	}

	CustomBootstrapModal.prototype = {
		constructor: CustomBootstrapModal,
		init: function () {
			var _this = this;
			_this.$modal = $("<div/>", {
				"class": "modal fade"
			}).append($("<div/>", {
				"class": "modal-dialog " + _this.options.addClass
			}).append($("<div/>", {
				"class": "modal-content"
			}).append($("<div/>", {
				"class": "modal-header"
			}).append($("<button/>", {
				"type": "button",
				"class": "close"
			}).html($("<span/>").html("&times;")).attr("data-dismiss", "modal")).append($("<h4/>", {
				"class": "modal-title",
			}).html(_this.options.title))).append($("<div/>", {
				"class": "modal-body"
			}).html(_this.options.content)).append($("<div/>", {
				"class": "modal-footer"
			})))).appendTo(_this.$target);


			/*set bootstrap modal state callbacks*/
			if (typeof _this.options.onHide === "function") {
				_this.$modal.on("hide.bs.modal", _this.options.onHide);
			}
			if (typeof _this.options.onHidden === "function") {
				_this.$modal.on("hidden.bs.modal", _this.options.onHidden);
			}
			if (typeof _this.options.onShow === "function") {
				_this.$modal.on("show.bs.modal", _this.options.onShow);
			}
			if (typeof _this.options.onShown === "function") {
				_this.$modal.on("shown.bs.modal", _this.options.onShown);
			}
			/*set bootstrap modal state callbacks*/

			if (_this.options.buttons instanceof Array) {
				$.each(_this.options.buttons, function (key, val) {
					if (typeof val === "object" && !($.isEmptyObject(val))) {
						var btn = new CustomBootstrapModalButton(val);

						var fn = (typeof val.btnClick !== "function") ? (function () {}) : val.btnClick;

						btn.click(fn);

						_this.$modal.find(".modal-footer").append(btn);
					}
				});
			}
		},
		show: function () {
			var _this = this;
			_this.$modal.modal("show");
		},
		hide: function () {
			var _this = this;
			_this.$modal.modal("hide");
		},
		setTitle: function (modalTitle) {
			var _this = this;
			_this.options.title = modalTitle;
			_this.$modal.find(".modal-header").html(_this.options.title);
		},
		setContent: function (modalContent) {
			var _this = this;
			_this.options.content = modalContent;
			_this.$modal.find(".modal-body").html(_this.options.content);
		}
	};



	CustomBootstrapModal.DEFAULTS = {
		title: "Alert",
		content: "Content text here",
		addClass: "",
		buttons: [],
		onHide: function () {},
		onHidden: function () {},
		onShow: function () {},
		onShown: function () {},
	};


	var CustomBootstrapModalButton = (function ($) {
		function CustomBootstrapModalButton(options) {

			var _this = this;

			_this.options = $.extend(true, {}, CustomBootstrapModalButton.BUTTON_DEFAULTS, options);

			var newButton = $("<button/>", {
				"class": "btn " + _this.options.btnClass,
			}).html(_this.options.title);
			return newButton;
		}


		CustomBootstrapModalButton.prototype = {
			constructor: CustomBootstrapModalButton
		}

		CustomBootstrapModalButton.BUTTON_DEFAULTS = {
			title: "Button",
			btnClass: "btn-white",
			btnClick: function () {}
		}

		return CustomBootstrapModalButton;
	})(jQuery);

	return CustomBootstrapModal;
})(jQuery);
