var regions = "";
    var corridor = [];
    var zone = [];
    var stores = [];
    var counterCount = 0;
    var dateFormat = "DD/MM/YYYY";
    var firstDayOfWeek = "Monday";
    var days = { sunday: 0, monday: 1, tuesday: 2, wednesday: 3, thursday: 4, friday: 5, saturday: 6 }
    var gInfo = {};
    var charts = [];
    var table = "";
    var compareParam = [];
    var yAxis = [];
    var date = [];
    var date2 = [];
    var tabledate = [];
    var model = {};
    var loadTime = [];
    var allCounters = "@AnalyticsMall.AnalyticsMall_AllCounters";
    var LanguageSelectASite = "@AnalyticsMall.AnalyticsMall_SelectASite";
    var testing = "@ViewBag.selectedRegionID";
    var userType = "@MyHelper.Role";
    var selectedCounterType = '';

    var checkLoading = false;
    var loadingElement = '<div id="loadingpulse" class="sk-spinner sk-spinner-pulse"></div>';

    function decodeHtml(html) {
        var txt = document.createElement("textarea");
        txt.innerHTML = html;
        return txt.value;
    }

    var customSelectFn = function (data) {
        // We only really care if there is an element to pull classes from
        if (!data.element) {
            return data.text;
        }
        var $element = $(data.element);
        var $wrapper = $('<div></div>');
        $wrapper.addClass($element[0].className);
        if ($element[0].className == "opt-company") {
            $wrapper.html("<i class='fa fa-globe'></i>" + data.text);
        }
        else if ($element[0].className == "opt-branch") {
            $wrapper.html("<i class='fa fa-home'></i>" + data.text);
        }
        else if ($element[0].className == "RegionTitle") {
            $wrapper.html("<i class='fa fa-globe'></i>" + data.text);
        }
        else if ($element[0].className == "opt-region") {
            $wrapper.html(data.text);
        }
        else if ($element[0].className == "opt-corridor") {
            $wrapper.html("<i class='fa fa-road'></i>" + data.text);
        }
        else if ($element[0].className == "opt-zone") {
            $wrapper.html("<i class='fa fa-codepen'></i>" + data.text);
        }
        else {
            $wrapper.html("<i class='fa fa-camera'></i>" + data.text);
        }
        return $wrapper;
    };
    //(function ($) {
    //    $("#dataTableHead").append("234567890");
    //    var xhrPool = [];
    //    $(document).ajaxSend(function (e, jqXHR, options) {
    //        xhrPool.push(jqXHR);
    //    });
    //    $(document).ajaxComplete(function (e, jqXHR, options) {
    //        xhrPool = $.grep(xhrPool, function (x) { return x != jqXHR });
    //    });
    //    abort = function () {
    //        $.each(xhrPool, function (idx, jqXHR) {
    //            jqXHR.abort();
    //        });
    //    };

    //})(jQuery);
    function getCookie(cn) {
        var name = cn + "=";
        var allCookie = decodeURIComponent(document.cookie).split(';');
        var cval = [];
        for (var i = 0; i < allCookie.length; i++) {
            if (allCookie[i].trim().indexOf(name) == 0) {
                cval = allCookie[i].trim().split("=");
            }
        }
        return (cval.length > 0) ? cval[1] : "";
    }
    $(function () {
        console.log("@Model.start");
        model = {
            start : "@Model.start",
            end : "@Model.end",
            range : "@Model.range",
            parameter : "@Model.parameter",
            type : "@Model.type",
            cameraId : "@Model.cameraId",
            branchId : "@Model.branchId",
            compare : "@Model.compare",
            Dashboard : "@Model.Dashboard",
            showOutValue : "@Model.showOutValue",
            selectedRegionID: "@Model.selectedRegionID",
            corridor: "@Model.corridor",
            zone: "@Model.zone",
        };
        if(model.Dashboard != ""){
            $("#dayreport").attr("id","dayreport" + model.Dashboard);
            $("#dataTable").attr("id","dataTable" + model.Dashboard);
            $("#chartTitle").attr("id","chartTitle" + model.Dashboard);
        }
        setInterval(function(){
            if($.active > 0){
                $("#applyBtn").attr("disabled","disabled");
                $("#applyBtn").attr("title","Graph is Loading");
                $('#applyBtn').off('click');
            }
            else{
                $("#applyBtn").attr("disabled",false);
                $("#applyBtn").removeAttr("title");
                $('#applyBtn').on('click');
            }
        }, 500);
        dateFormat = getCookie("companyControlPanelSetting").split(',')[1];

        $.getJSON('/footfallcam/GetControlPanelSettingData?companyCode=' + companyCode, function (data) {
            //dateFormat = data[0].DateFormat.toLowerCase() == "datefirst" ? "DD/MM/YYYY" : "MM/DD/YYYY";
            firstDayOfWeek = data[0].FirstDayOfWeek;
        });
        if (model.branchId != "") {
            $("#counterTypeSelect").val('branch');
        }
        else if (model.cameraId != "") {
            $("#counterTypeSelect").val('counter');
        }
        else if (model.corridor != "") {
            $("#counterTypeSelect").val('corridor');
        }
        else if (model.zone != "") {
            $("#counterTypeSelect").val('zone');
        }
        //get counter type and display only necessary option
        selectedCounterType = $("#counterTypeSelect option:selected").val();
        populateBranchCounter(selectedCounterType);
        InitMetrics(selectedCounterType);
        InitCompareMetrics();

        setDate(userType);
        initializeDateRange();

        //initialize pm selector
        $("#pmSelectorRadio").on("change",function(){
            var options = $('.MetricSelect option');
            var selector = $('.MetricSelect :selected');
            var selectorNS = $('.MetricSelect');
            var compareWith = $("input[name=data-selection]:checked").val();
            $.map(options ,function(option) {

                if(option.value.substring(0,1) == "2" && compareWith == "1")
                    $(option).hide();
                else
                    $(option).show();
            });
            for(var s = 0; s < selector.length; s++){
                if($(selector[s]).val().substring(0,1) == "2")
                    $(selectorNS[s]).val(101);
            }

        });

        //change things based on counter type
        $("#counterTypeSelect").on("change", function () {
            selectedCounterType = $("#counterTypeSelect option:selected").val();
            $('#branchCounterSelectLabel').text($("#counterTypeSelect option:selected").text());
            $('#radio-compare-site-label').text($("#counterTypeSelect option:selected").text());
            populateBranchCounter(selectedCounterType);
            InitMetrics(selectedCounterType);

            $("#branchCounterSelect").change();
        });

        if (stores.length < 1000) {
            $(".counterBranch").on("change", function (me) {
                //set all to non disabled
                $('.counterBranch').find('option').attr('disabled', false);
                //disable only the selected
                var length = $(".counterBranch").length;
                var selectedVal = $(this).val();
                for (var x = 0; x < length; x++) {
                    var thisVal = $($(".counterBranch")[x]).val();
                    $('.counterBranch').find('option[value="' + thisVal + '"]:not(:selected)').attr('disabled', true).attr("title", "Option is already selected");
                }
                InitializeSelect2();
            });
        }

        $("input[name='compare-with-selection']").on("change", function () {
            var compare = $("#toggleCompare").attr("checked") == "checked" ? true : false;
            var compareParam = $("input[name='compare-with-selection']:checked").val();
            if (compare) {
                if (compareParam == "site") {
                    var length = $(".counterBranch").length;
                    var selectedVal = $(this).val();
                    for (var x = 0; x < length; x++) {
                        var thisVal = $($(".counterBranch")[x]).val();
                        $('.counterBranch').children('option[value="' + thisVal + '"]:not(:selected)').attr('disabled', true).attr("title", "Option is already selected");
                    }
                    InitializeSelect2();
                }
                else {
                    $('.counterBranch').children('option[class*="opt"]').attr('disabled', false);
                    InitializeSelect2();
                }
            }
        });

        $("#toggleCompare").on("change", function () {
            var compare = $("#toggleCompare").attr("checked") == "checked" ? true : false;
            if (!compare) {
                $('.counterBranch').children('option[class*="opt"]').attr('disabled', false);
                InitializeSelect2();
            }
            else {
                var length = $(".counterBranch").length;
                var selectedVal = $(this).val();
                for (var x = 0; x < length; x++) {
                    var thisVal = $($(".counterBranch")[x]).val();
                    $('.counterBranch').children('option[value="' + thisVal + '"]:not(:selected)').attr('disabled', true).attr("title", "Option is already selected");
                }
                InitializeSelect2();
            }
        });

        //set chart
        initializeSettings();
        var checkInfo = setInterval(function () {
            if ($("#startDate").val()) {
                setChart();
                clearInterval(checkInfo);
            }
        }, 200);
        
    });

    function setChart() {
        $(".highcharts-container").hide();
        $("#dataTable").hide();
        $("#dayreport").prepend(loadingElement);

        tblContent = '';
        loadTime = [];
        $("#noDataComment").hide();
        if($.active > 0 && $("#dayreport" + model.Dashboard).html().length > 100)
            return;

        charts = [];
        yAxis = [];
        var compare = $("#toggleCompare").attr("checked") == undefined ? false : true;
        var count = 1;
        var secondCount = 0; //spefically for two metrics comparison
        var chartType = "column";
        var compareWith = $("input[name=compare-with-selection]:checked").val();

        initializeModel();
        console.log("compare -- " + compare);
        if (compare) {
            if (compareWith == "site")
            {
                for (var x = 0; x < $("#compareBranchCounterSection").find("select").length; x++) {
                    if ($($("#compareBranchCounterSection").find("select")[x]).val() != null && $($("#compareBranchCounterSection").find("select")[x]).val() != "")
                        count++;
                }
            }
            else if (compareWith == "time") {

                for (var x = 0; x < $("#compareDateSection").find("input[name*='start']").length; x++) {
                    if ($($("#compareDateSection").find("input[name*='start']")[x]).val() != "")
                        count++;
                }
            }
            else if (compareWith == "metric") {
                for (var x = 0; x < $("#compareMetricSection").find("select").length; x++) {
                    if ($($("#compareMetricSection").find("select")[x]).val() != null)
                        count++;
                }
            }
        }

        var period = $("input[name=data-selection]:checked").val();
        var checkGraphType = $("#pmSelector :selected").val();
        if (count > 1 || (checkGraphType != "101" && checkGraphType != "102" && checkGraphType != "206"))
            chartType = "line";

        var dateStart = [$($('input[id*=start]')[0]).val()];
        var dateEnd = [$($('input[id*=end]')[0]).val()];
        if (compareWith == "time") {
            for (var v = 1; v < $('input[id*=start]').length; v++) {
                if ($($('input[id*=start]')[v]).val() != "") {
                    dateStart.push($($('input[id*=start]')[v]).val());
                    dateEnd.push($($('input[id*=end]')[v]).val());
                }
            }
        }

        for (var x = 0; x < count; x++) {

            var tempx = 0;
            var tempx2 = 0;
            var tempx3 = 0;
            if (compareWith == "metric")
                tempx2 = x;
            var metrics = $($(".MetricSelect")[tempx2]).val();


            //only remove if it is the first param
            if (x == 0)
                compareParam = [];
            gInfo = {};
            if (compareWith == "time")
                tempx3 = x;

            //console.log($($("input[id*='end']")[tempx3]).val());
            gInfo.startDate = dateStart[tempx3];
            gInfo.endDate = dateEnd[tempx3];
            gInfo.Param = metrics + "" + period;
            gInfo.Time = new Date().getTime();

            if (compareWith == "site")
                tempx = x;
            $($("select[id*='CounterSelect'] :selected:not([value='']):not([value=''])")[tempx]).hasClass("opt-branch") ?
                gInfo.branchId = $($("select[id*='CounterSelect'] :selected:not([value=''])")[tempx]).val() :
                $($("select[id*='CounterSelect'] :selected:not([value=''])")[tempx]).hasClass("opt-cam") ?
                    gInfo.cameraId = $($("select[id*='CounterSelect'] :selected:not([value=''])")[tempx]).val() :
                    $($("select[id*='CounterSelect'] :selected:not([value=''])")[tempx]).hasClass("opt-corridor") ?
                        gInfo.corridor = $($("select[id*='CounterSelect'] :selected:not([value=''])")[tempx]).val() :
                        $($("select[id*='CounterSelect'] :selected:not([value=''])")[tempx]).hasClass("opt-zone") ?
                            gInfo.zone = $($("select[id*='CounterSelect'] :selected:not([value=''])")[tempx]).val() :
                                gInfo.SelectedRegionID = $($("select[id*='CounterSelect'] :selected:not([value=''])")[tempx]).val();

            //var title = compareWith == "site" ?
            $("#chartTitle" + model.Dashboard).text(decodeHtml($("#branchCounterSelect :selected").text() + " - " + $("#pmSelector :selected").text()));
            $("#topTitleDate").text(decodeHtml("@AnalyticsMall.AnalyticsMall_ReportPeriod" + ": " + gInfo.startDate + " - " + gInfo.endDate));

            //to create closure so that x value can be retained
            (function (x) {
                var keepX = x;
                compareParam.push(gInfo.Param);
                loadTime.push(gInfo.Time);
                $.ajax({
                    type: "GET",
                    url: "/FootfallCam/AnalyticsAIONewMall",
                    data: gInfo,
                    success: function (data) {
                        if(data.length == 0){
                            $("#dayreport" + model.Dashboard).empty();
                            $("#dataTable" + model.Dashboard).empty();
                            $("#chartTitle"  + model.Dashboard).empty();
                            $("#topTitleDate").empty();
                            $("#noDataComment").show();
                            return;
                        }
                        var thisData = manualMapData(data, 'data', keepX, null, selectedCounterType);
                        //if (!compare && compareWith != "time" && x == 0) {
                        //    //date = data.map(m => m.Datetime);
                        //    date = manualMapData(data,'datetime');
                        //    tabledate = manualMapData(data,'datetime');
                        //}
                        //else if (x == 0){
                        //    for (var g = 0; g < data.length; g++) {
                        //        date.push("Day " + (parseInt(g)+1));
                        //        tabledate.push("Day " + (parseInt(g)+1));
                        //    }

                        //}
                        if (compare && compareWith == "time") {
                            for (var g = 0; g < data.length; g++) {
                                date.push("Day " + (parseInt(g) + 1));
                                tabledate.push("Day " + (parseInt(g) + 1));
                            }
                        }
                        else if (x == 0) {
                            //date = data.map(m => m.Datetime);
                            date = manualMapData(data, 'datetime');
                            tabledate = manualMapData(data, 'datetime');
                        }
                        var chartName = compareWith == "metric" ? $($(".MetricSelect :selected")[keepX]).html()
                            : compareWith == "site" ? $($("select[id*='CounterSelect'] :selected:not([value=''])")[keepX]).text()
                                : dateStart[keepX] + " - " + dateEnd[keepX]; 


                        while (thisData.indexOf(-1) != -1)
                            thisData[thisData.indexOf(-1)] = 0;


                        jQuery.get("../../Scripts/chart-color-scheme.txt", function (colorScheme) {
                            colorScheme = JSON.parse(colorScheme);
                            if (model.parameter.indexOf("205") != -1 && count == 1 && selectedCounterType == 'branch'){ // branch Average Visit Duration metric
                                charts.push({
                                    color: "rgb(230, 191, 45)",
                                    name: "< 15 mins",
                                    data: manualMapData(data, 'data', keepX, "1", selectedCounterType)
                                });
                                charts.push({
                                    color: "rgb(153,179,106)",
                                    name: "15-30 mins",
                                    data: manualMapData(data, 'data', keepX, "2", selectedCounterType)
                                });
                                charts.push({
                                    name: "> 30 mins",
                                    color: "rgb(96,171,146)",
                                    data: manualMapData(data, 'data', keepX, "3", selectedCounterType)
                                });

                            } else if (model.parameter.indexOf("206") != -1 && count == 1 && selectedCounterType == 'branch') { // branch Returning Customer metric
                                charts.push({
                                    color: "rgb(153,179,106)",
                                    name: "Returning Customer (%)",
                                    data: manualMapData(data, 'data', keepX, "1", selectedCounterType)
                                });
                                charts.push({
                                    color: "rgb(230, 191, 45)",
                                    name: "New Customer (%)",
                                    data: manualMapData(data, 'data', keepX, "2", selectedCounterType)
                                });
                            }else if (model.parameter.indexOf("101") != -1 && count == 1 && selectedCounterType == 'corridor') { // corridor visitor count metric without comparison
                                charts.push({
                                    color: "rgb(96,171,146)",
                                    name: "Line 1",
                                    data: manualMapData(data, 'data', keepX, "1", selectedCounterType)
                                });
                                charts.push({
                                    color: "rgb(230, 191, 45)",
                                    name: "Line 2",
                                    data: manualMapData(data, 'data', keepX, "2", selectedCounterType)
                                });
                            }else if (model.parameter.indexOf("101") != -1 && count > 1 && selectedCounterType == 'corridor') { // corridor visitor count metric with comparison
                                charts.push({
                                    name: chartName + " (Line 1)",
                                    data: manualMapData(data, 'data', keepX, "1", selectedCounterType),
                                    borderWidth: 0,
                                    lineWidth: 1,
                                    yAxis: compareWith != "metric" ? 0 : x,
                                    color: colorScheme.analytics.chart.stackColumn.color[x]
                                });
                                charts.push({
                                    name: chartName + " (Line 2)",
                                    data: manualMapData(data, 'data', keepX, "2", selectedCounterType),
                                    borderWidth: 0,
                                    lineWidth: 1,
                                    yAxis: compareWith != "metric" ? 0 : x,
                                    color: colorScheme.analytics.chart.stackColumn.color[x]
                                });
                                secondCount++;
                            }else{ 
                                charts.push({
                                    //name: $("#pmSelector option[value='" + gInfo.Param.substring(0, 3) + "']").text(),
                                    name: chartName,
                                    data: thisData,
                                    borderWidth: 0,
                                    lineWidth: 1,
                                    yAxis: compareWith != "metric" ? 0 : x,
                                    color: colorScheme.analytics.chart.stackColumn.color[x]
                                });
                            }
                            if ((compareWith == "metric" && x > 0) || x == 0) {
                                var yAxisObject = {
                                    lineWidth: 0,
                                    gridLineWidth: 1,
                                    tickPixelInterval: 30,
                                    min: 0,
                                    title: {
                                        text: compareWith == "metric" ? chartName : $("#pmSelector :selected").text(),
                                        style: {
                                            color: x >= 1 ? colorScheme.analytics.chart.stackColumn.color[x] : colorScheme.chart.axisLabel.y.label.color,            //Same colour as the corresponding line
                                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                                        }
                                    },
                                    labels: {
                                        style: {
                                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                                            color: colorScheme.chart.axisLabel.y.label.color,
                                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                                        }
                                    },
                                    opposite: x % 2 == 0 ? false : true
                                };
                                //To adding null object to the index of array of the previous index of array is not present [Kelvin Yap]
                                if (x > 0 && yAxis[x - 1] == null) {
                                    yAxis.splice(x - 1, 0, null);
                                }
                                //Replace the specified index with new object [Kelvin Yap]
                                yAxis.splice(x, 1, yAxisObject);
                            }

                            //InitializeGraph(date, charts, colorScheme, chartType, keepX);
                            //charts = [];
                        });

                        setTimeout(function checkTable(){
                            console.log(data[0].Time + " - " + loadTime[0] + " - " + keepX);
                            if(data[0].Time == loadTime[0]){
                                InitializeTable(data, keepX, selectedCounterType, dateStart, dateEnd);
                                loadTime.shift();
                                if(loadTime.length == 0)
                                    tabledate = [];
                            }
                            else{
                                setTimeout(checkTable,500);
                            }
                        },500);

                    },
                    error: function(data){
                        console.log(data);
                    }
                });
            })(x);
        }//end for

        checkLoading = false;
        var waitForData = setInterval(function () {
            if (!checkLoading) {
                checkLoading = setInterval(function () {
                    if ($.active == 0) {
                        $(".highcharts-container").show();
                        $("#dataTable").show();
                        $("#loadingpulse").remove();
                        clearInterval(checkLoading);
                    }
                }, 400)
            }
            if (charts.length == count + secondCount || (count == 1 && charts.length != 0)) {
                jQuery.get("../../Scripts/chart-color-scheme.txt", function (colorScheme) {
                    colorScheme = JSON.parse(colorScheme);
                    console.log(charts);
                    InitializeGraph(date, charts, colorScheme, chartType);
                    date = [];
                    clearInterval(waitForData);
                });
            }
        }, 500);
    }

    function Previous() {
        var myDateF = dateFormat == "dateFirst" ? "DD/MM/YYYY" : "MM/DD/YYYY";
        var firstDate = new moment($('#startDate').val(), myDateF);
        var secondDate = new moment($('#endDate').val(), myDateF);

        var diff = secondDate.diff(firstDate) + 86400000;
        firstDate.subtract(diff, 'ms');
        secondDate.subtract(diff, 'ms');

        $('#startDate').val(firstDate.format(myDateF));
        $('#endDate').val(secondDate.format(myDateF));

        setChart();
    }

    function Next() {
        var myDateF = dateFormat == "dateFirst" ? "DD/MM/YYYY" : "MM/DD/YYYY";
        var firstDate = new moment($('#startDate').val(), myDateF);
        var secondDate = new moment($('#endDate').val(), myDateF);

        var diff = secondDate.diff(firstDate) + 86400000;
        firstDate = firstDate.add(diff, 'ms');
        secondDate = secondDate.add(diff, 'ms');

        firstDate = firstDate > new moment() || secondDate > new moment() ? new moment().subtract(diff - 86400000, 'ms') : firstDate;
        secondDate = secondDate > new moment() ? new moment() : secondDate;

        $('#startDate').val(firstDate.format(myDateF));
        $('#endDate').val(secondDate.format(myDateF));

        setChart();
    }

    function GeneratePDF() {
        var toEscape = "/footfallcam/AnalyticsMall?start=" + model.start + "&end=" + model.end + "&parameter=" + model.parameter + "&cameraId=" + model.cameraId + "&branchid=" + model.branchId + "&selectedregionid=" + model.selectedRegionID.split('&').join('||') + "&corridor=" + model.corridor.split('&').join('||') + "&zone=" + model.zone + "&range=" + model.range;
        //console.log(toEscape);
        var url = encodeURIComponent(toEscape);
        console.log(toEscape);
        console.log(url);
        $.ajax({
            type: "GET",
            url: "/FootfallCam/GenerateAnalyticsPDF?url="+url,
            success: function (data) {
                $("#page-svg-loading").fadeIn();
                $.ajax({
                    type: "GET",
                    url: "/FootfallCam/SendAnalyticsPDF",
                    success: function (data) {
                        prompt("Confirmation Message", "Download Report ? ", "<button class='general-button' id='download' data-dismiss='modal'>Download</button>&nbsp;&nbsp;&nbsp;<button class='general-button' data-dismiss='modal'>Cancel</button>");
                        $("#download").on("click",function(){
                            window.open('SendAnalyticsPDF');
                        });
                        $("#page-svg-loading").fadeOut();
                    },
                    error: function () {
                        $("#page-svg-loading").fadeIn();
                    }
                });
            }
        });
    }