// Inject jQuery, so I can use it later to manipulate my page
phantom.injectJs("../static/jquery.js");
var page, system, fs, info, csrftoken, sessionid, categories,
notification, data, address, output;
// Create a page object
page = require('webpage').create();
// Require the system module so I can read the command line arguments
system = require('system');
// Require the FileSystem module, so I can read the cookie file
fs = require('fs');
// Read the cookie file and split it by spaces
// Because the way I constructed this file, separate each field using spaces
info = fs.read('/tmp/cookies.txt').split(' ');
csrftoken = info[0];
sessionid = info[1];
// Let's presume categories are the checked check boxes
categories = info[2];
// Let's presume notification is the clicked radio button
notification = info[3];
// Create a data object contains the information we gaterhed earlier
data = {categories: categories, notification: notification};
// Now we can add cookies into phantomjs, so when it renders the page, it
// will have the same permission and data as the current user
phantom.addCookie({'domain':'localhost', 'name':'csrftoken',
                   'value': csrftoken});
phantom.addCookie({'domain':'localhost', 'name':'sessionid',
                   'value': sessionid});
phantom.addCookie({'domain':'localhost', 'name':'Secret',
                   'value': 'kvvbUXZDllO7fajNWgLMx1aq7rDgoSlg0GmSBvRZWJM='});				   

// Read the url and output file location from the command line argument
address = system.args[1];
output = system.args[2];
// Set the page size and orientation

page.paperSize = {
    format: 'A4',
    orientation: 'portrait'};
// Now we have everything settled, let's render the page
page.open(address, function (status) {
    if (status !== 'success') {
        // If PhantomJS failed to reach the address, print a message
        console.log('Unable to load the address!');
        phantom.exit();
    } else {
        // If we are here, it means we rendered page successfully
        // Use "evaluate" method of page object to manipulate the web page
        // Notice I am passing the data into the function, so I can use
        // them on the page
        page.evaluate(function(data) {
			$("#accordion").remove();
			$("#headerTitle").remove();
			$("#selectBranchName").remove();
			$("#body").show();
			$('#body').css({ transform: 'scale(2)' });
			$("#body").offset({top:0,left:0})
			$("#rightContent").css("background-color","white");
			jQuery('footer').remove();
        }, data);

		
		setTimeout(function(){
			//do what you need here
			page.render(output);
			phantom.exit();
		}, 10000);
		
        // Now create the output file and exit PhantomJS
        
    }
});