var system, fs, info, csrftoken, sessionid, categories,
notification, data, address, output;
// Create a page object
// Require the system module so I can read the command line arguments
system = require('system');
// Require the FileSystem module, so I can read the cookie file
fs = require('fs');
// Read the cookie file and split it by spaces
// Because the way I constructed this file, separate each field using spaces
info = fs.read('cookies.txt').split(' ');
//info = fs.read('G:\\Project\\FootfallCam\\RetailCamControlPanel\\Footfallcam\\phantomjs\\cookies.txt').split(' ');

//<add key="PhantomjsPath" value="G:\Project\FootfallCam\RetailCamControlPanel\Footfallcam\phantomjs\" />

csrftoken = info[0];
sessionid = info[1];

// Let's presume categories are the checked check boxes
categories = info[2];
// Let's presume notification is the clicked radio button
notification = info[3];
// Create a data object contains the information we gaterhed earlier
data = {categories: categories, notification: notification};
// Now we can add cookies into phantomjs, so when it renders the page, it
// will have the same permission and data as the current user
phantom.addCookie({'domain':'localhost', 'name':'csrftoken',
                   'value': csrftoken});
phantom.addCookie({'domain':'localhost', 'name':'sessionid',
                   'value': sessionid});
phantom.addCookie({'domain':'localhost', 'name':'companyControlPanelSetting',
                   'value': ''});
phantom.addCookie({'domain':'localhost', 'name':'Secret',
                   'value': system.args[3]});				   
				   
// Read the url and output file location from the command line argument
address = system.args[1];
output = system.args[2];
// Set the page size and orientation

var resourceWait  = 5000,
    maxRenderWait = 300000,
    url           = address;

var page          = require('webpage').create(),
    count         = 0,
    forcedRenderTimeout,
    renderTimeout;

page.viewportSize = { width: 700, height : 600 };
page.paperSize = {
	format: 'A4',
	orientation: 'potrait',
    margin: { left: "0cm", right: "0cm", top: "2cm", bottom: "3cm" },
    footer: {
        height: "1cm",
        contents: phantom.callback(function (pageNum, numPages) {
            return "<div style='padding:0px 66px;'><hr/><h5 style='font-family: Arial, Helvetica, sans-serif; padding:10px;'>generated by Footfallcam Analytics Manager V8<span style='float:right'>" + pageNum + " / " + numPages + "</span></h5></div>";
        })
    }
};

function doRender() {
    page.render(output);
    phantom.exit();
}

page.onResourceRequested = function (req) {
    count += 1;
    console.log('> ' + req.id + ' - ' + req.url);
    clearTimeout(renderTimeout);
};

page.onResourceReceived = function (res) {
    if (!res.stage || res.stage === 'end') {
        count -= 1;
        console.log(res.id + ' ' + res.status + ' - ' + res.url);
        if (count === 0) {
            renderTimeout = setTimeout(doRender, resourceWait);
        }
    }
};

page.open(url, function (status) {
	if (status !== "success") {
		console.log('Unable to load url');
		phantom.exit();
	} else {
		forcedRenderTimeout = setTimeout(function () {
			console.log(count);
			doRender();
		}, maxRenderWait);
	}
});