﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Quartz;
using RetailCamControlPanel.Services.SingularService;
using RetailCamControlPanel.Models;
using RetailCamControlPanel.ViewModel;
using System.Configuration;
using System.IO;
using RetailCamControlPanel.Helper;
using FluentFTP;
using System.Globalization;
using System.Text.RegularExpressions;

namespace RetailCamControlPanel.Quartz
{
    [DisallowConcurrentExecution]
    public class AutoFWUpgradeJob : IJob
    {
        private readonly ICompanyService companyService;
        private readonly ICompanySettingService companySettingService;
        private readonly IFFCameraVersionService fFCameraVersionService;
        private readonly IFFCameraService fFCameraService;
        private readonly IFFCameraSettingService fFCameraSettingService;
        private String FootfallCam = ConfigurationManager.AppSettings["FootfallCam"];
        private string isLocalDebug = ConfigurationManager.AppSettings["IsLocalDebug"];

        public AutoFWUpgradeJob(ICompanyService companyService, IFFCameraVersionService fFCameraVersionService, IFFCameraService fFCameraService, ICompanySettingService companySettingService, IFFCameraSettingService fFCameraSettingService)
        {
            this.companyService = companyService;
            this.fFCameraVersionService = fFCameraVersionService;
            this.fFCameraService = fFCameraService;
            this.companySettingService = companySettingService;
            this.fFCameraSettingService = fFCameraSettingService;
        }
        public void Execute(IJobExecutionContext context) {
            try
            {
                if (String.IsNullOrEmpty(isLocalDebug))
                {
                    isLocalDebug = "1";
                }

                if (isLocalDebug == "1")
                {
                    return;
                }
                else
                {
                    //get latest firmware version
                    var threeDlatestFirmwareVersion = fFCameraVersionService.GetLatest("3DPi");
                    var twoDlatestFirmwareVersion = fFCameraVersionService.GetLatest("Pi");
                    //get all settings that have firmware update flag on
                    var companies = companyService.GetCompanies();
                    var listCompanySettings = companySettingService.GetMultipleCompanySetting(c => c.cameraUpdate != 0).ToList();
                    if (listCompanySettings != null)
                    {
                        foreach (var companysetting in listCompanySettings)
                        {
                            //declaration
                            List<FFCamera> tobeUpgradeCounter3D = new List<FFCamera>();
                            List<FFCamera> tobeUpgradeCounter2D = new List<FFCamera>();
                            List<FFCamera> tobeUpgradeCounter = new List<FFCamera>();
                            var company = companies.Where(c => c.ID == companysetting.CompanyId).FirstOrDefault();
                            //get all cameras from companycode 
                            var cameras = fFCameraService.GetCameras(c => c.CompanyCode == company.CompanyCode).ToList();
                            //differentiate 3D or 2D
                            if (cameras != null)
                            {
                                //3D Counters 
                                var camera3D = cameras.Where(c => c.CounterCameraType == "3DPi" || c.CounterCameraType == "3DMax").ToList();
                                if (camera3D != null)
                                {
                                    if (camera3D.Count() > 0)
                                    {
                                        // all available counters to be download
                                        tobeUpgradeCounter3D = checkCameraVersion(camera3D, threeDlatestFirmwareVersion.Version);
                                    }
                                }
                                //2D Counters
                                var camera2D = cameras.Where(c => c.CounterCameraType == "Pi").ToList();
                                if (camera2D != null)
                                {
                                    if (camera2D.Count() > 0)
                                    {
                                        // all available counters to be download
                                        tobeUpgradeCounter2D = checkCameraVersion(camera2D, twoDlatestFirmwareVersion.Version);
                                    }
                                }
                                if (tobeUpgradeCounter3D != null)
                                {
                                    if (tobeUpgradeCounter3D.Count >= 1)
                                    {
                                        tobeUpgradeCounter.AddRange(tobeUpgradeCounter3D);
                                    }
                                    //tobeUpgradeCounter.AddRange(tobeUpgradeCounter3D.ToList());
                                }
                                if (tobeUpgradeCounter2D != null)
                                {
                                    if (tobeUpgradeCounter2D.Count >= 1)
                                    {
                                        tobeUpgradeCounter.AddRange(tobeUpgradeCounter2D);
                                    }
                                    //tobeUpgradeCounter.AddRange(tobeUpgradeCounter2D.ToList());
                                }

                            }
                            //update counters accordingly
                            if (tobeUpgradeCounter != null)
                            {
                                tobeUpgradeCounter = tobeUpgradeCounter.OrderByDescending(c => c.LastHeartBeat).Take(companysetting.cameraUpdate).ToList();
                                foreach (var counter in tobeUpgradeCounter)
                                {
                                    if (counter.ID == 1626)
                                    {
                                        continue;
                                    }
                                    counter.CameraSetting.AutoUpdate = true;
                                    counter.CameraSetting.RebootFlag = true;
                                    fFCameraSettingService.UpdateCameraSetting(counter.CameraSetting);
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
            }
        }

        public List<FFCamera> checkCameraVersion(List<FFCamera> cameras, string cameraversion)
        {
            List<FFCamera> tobeupgrade = new List<FFCamera>();
            try
            {
                //versioning comparison
                //3 types of versioning numbers. Major, Minor, Sub
                var serverVersion = cameraversion.Split('.');
                foreach (var camera in cameras)
                {
                    var counterVersion = camera.CameraFirmwareVersion.Split('.');
                    if (Convert.ToInt32(counterVersion[1]) > Convert.ToInt32(serverVersion[1]))
                    {
                        //this counter version is newer than server version
                        continue;
                    }
                    else if (Convert.ToInt32(counterVersion[1]) == Convert.ToInt32(serverVersion[1]))
                    {
                        var counterVersion2Arr = Regex.Matches(counterVersion[2], @"\D+|\d+").Cast<Match>().Select(m => m.Value).ToArray();
                        var serverVersion2Arr = Regex.Matches(serverVersion[2], @"\D+|\d+").Cast<Match>().Select(m => m.Value).ToArray();
                        if (Convert.ToInt32(counterVersion2Arr[0]) > Convert.ToInt32(serverVersion2Arr[0]))
                        {
                            //this counter version is newer or not required to update
                            continue;
                        }
                        else if (Convert.ToInt32(counterVersion2Arr[0]) == Convert.ToInt32(serverVersion2Arr[0]))
                        {
                            if (counterVersion[2].CompareTo(serverVersion[2]) >= 0)
                            {
                                //this counter version is newer or not required to update
                                continue;
                            }
                            else
                            {
                                //counter is upgradable
                                tobeupgrade.Add(camera);
                            }
                        }
                        else
                        {
                            //counter is upgradable
                            tobeupgrade.Add(camera);
                        }
                    }
                    else
                    {
                        //counter is upgradable
                        tobeupgrade.Add(camera);
                    }
                }
                return tobeupgrade;
            }
            catch (Exception)
            {
                return tobeupgrade;
            }
        }
    }
}