﻿using System;
using System.Web;
using System.Collections.Generic;
using System.Linq;
using Quartz;
using RetailCamControlPanel.Services.SingularService;
using RetailCamControlPanel.Models;
using RetailCamControlPanel.ViewModel;
using System.Configuration;
using System.IO;
using System.Web.Mvc;
using RetailCamControlPanel.Controllers;
using RetailCamControlPanel.Services.CompositeService;

namespace RetailCamControlPanel.Quartz
{
    [DisallowConcurrentExecution]
    public class AutoGenerateVerificationReport : IJob
    {
        private readonly IFFCameraService ffCameraService;
        private readonly IFFVideoScheduleService ffVideoScheduleService;
        private readonly IFFVerificationStudyReportService ffVerificationStudyReportService;
        private readonly IFFCompositeService ffCompositeService;

        public AutoGenerateVerificationReport(IFFCameraService ffCameraService, IFFVideoScheduleService ffVideoScheduleService, IFFVerificationStudyReportService ffVerificationStudyReportService, IFFCompositeService ffCompositeService)
        {
            this.ffCameraService = ffCameraService;
            this.ffVideoScheduleService = ffVideoScheduleService;
            this.ffVerificationStudyReportService = ffVerificationStudyReportService;
            this.ffCompositeService = ffCompositeService;
        }
        private String FootfallCam = ConfigurationManager.AppSettings["FootfallCam"];
        private string isLocalDebug = ConfigurationManager.AppSettings["IsLocalDebug"];
        public void Execute(IJobExecutionContext context)
        {
            if (String.IsNullOrEmpty(isLocalDebug))
            {
                isLocalDebug = "1";
            }

            if (isLocalDebug == "1")
            {
                return;
            }
            else
            {
                //list of all allocated cameras
                List<FFCameraViewModel> AllAllocatedCameras = ffCameraService.GetCameras(w => w.BranchId != 0 && w.CompanyCode != "New" && w.CompanyCode != null && (!w.BranchCode.Contains("TestLab")))
                    .Select(s => new FFCameraViewModel()
                    {
                        ID = s.ID,
                        IsVerified = false
                    }).ToList();
                //list of cameraId from camera list
                List<long> AllCameraID = AllAllocatedCameras.Select(s => s.ID).ToList();
                //list of video based on cameraid list and video status = 4 (included in report)
                List<FFVideoSchedule> AllCameraVideos = ffVideoScheduleService.GetVideoScheduleList(w => AllCameraID.Contains(w.FFCameraId) && w.Status == 4).ToList();
                //list of cameraid from video list
                List<long> AllCameraIdWithIncludedInReportVideo = AllCameraVideos.Select(s => s.FFCameraId).Distinct().ToList();

                //list of cameraid generated report
                List<FFVideoSchedule> AllCameraWithVerificationReport = ffVerificationStudyReportService.GetVerificationStudyReports(w => AllCameraIdWithIncludedInReportVideo.Contains(w.FFCameraId))
                    .OrderByDescending(o => o.FFCameraId)
                    .GroupBy(g => g.FFCameraId)
                    .Select(s => new FFVideoSchedule()
                    {
                        FFCameraId = s.FirstOrDefault().FFCameraId,
                    }).ToList();

                List<long> AllCameraIdWithVerificationReport = AllCameraWithVerificationReport.Select(s => s.FFCameraId).Distinct().ToList();

                //list of cameraid that need to regenerate report
                var AllCameraIdNeedToReGenerateReport = AllCameraIdWithIncludedInReportVideo.Except(AllCameraIdWithVerificationReport).ToList();

                foreach (var cameraId in AllCameraIdNeedToReGenerateReport)
                {
                    List<FFVideoSchedule> AllVideoIncludedInRegenerateReport = ffVideoScheduleService.GetVideoScheduleList(w => w.FFCameraId == cameraId && w.Status == 4).ToList();
                    List<long> AllVideoIdInclude = AllVideoIncludedInRegenerateReport.Select(s => s.ID).ToList();

                    //create verificationreport 
                    VerificationReportViewModel report = new VerificationReportViewModel();
                    var AllVideoIdIncludeArray = AllVideoIdInclude.ToArray();
                    report.VideoIds = AllVideoIdIncludeArray;
                    report.DataCriteria = "all";
                    report.ReportType = "new";
                    report.VerifyBy = "FootfallCam";
                    long reportid;
                    var result = ffCompositeService.CreateVerificationSummaryReport(report, out reportid);
                }
            }
        }
    }   
}