﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Quartz;
using RetailCamControlPanel.Services.SingularService;
using RetailCamControlPanel.Models;
using RetailCamControlPanel.ViewModel;
using System.Configuration;
using System.IO;
using RetailCamControlPanel.Helper;
using FluentFTP;
using System.Globalization;
using Newtonsoft.Json;
using System.Web.Mvc;
using RetailCamControlPanel.Controllers;
using WinSCP;

namespace RetailCamControlPanel.Quartz
{    

    [DisallowConcurrentExecution]
    public class ImportJob : IJob
    {
        private readonly IAutoImportSettingService autoImportSettingService;
        private readonly IAutoImportLogService autoImportLogService;
        private readonly ICompanyService companyService;
        private readonly IFFBranchService ffBranchService;
        private readonly IFFEPosTransactionDataService ffEPosTransactionDataService;
        private readonly ICounterHealthCheckService counterHealthCheckService;
        private readonly IServerIdentificationService serverIdentificationService;
        private readonly ICompanySettingService companySettingService;
        private readonly EmailHelper emailHelperService;
        private String FootfallCam = ConfigurationManager.AppSettings["FootfallCam"];
        private string isLocalDebug = ConfigurationManager.AppSettings["IsLocalDebug"];
        private string RetailcamcontrolpanelURL = ConfigurationManager.AppSettings["RetailCamControlPanelURL"];
        private static string RCCPPATH = HttpRuntime.AppDomainAppPath;

        public ImportJob(IAutoImportSettingService autoImportSettingService, IAutoImportLogService autoImportLogService, ICompanyService companyService, IFFBranchService ffBranchService, IFFEPosTransactionDataService ffEPosTransactionDataService, ICounterHealthCheckService counterHealthCheckService, IServerIdentificationService serverIdentificationService, ICompanySettingService companySettingService, EmailHelper emailHelperService)
        {
            this.autoImportSettingService = autoImportSettingService;
            this.autoImportLogService = autoImportLogService;
            this.companyService = companyService;
            this.ffBranchService = ffBranchService;
            this.ffEPosTransactionDataService = ffEPosTransactionDataService;
            this.counterHealthCheckService = counterHealthCheckService;
            this.serverIdentificationService = serverIdentificationService;
            this.emailHelperService = emailHelperService;
            this.companySettingService = companySettingService;
        }
        public void Execute(IJobExecutionContext context){
            //Import Function Divided into several parts// 
            //check every minutes, to compare the time set in settings //
            
            if (string.IsNullOrEmpty(isLocalDebug))
            {
                isLocalDebug = "1";
            }

            if ( isLocalDebug == "1")
            {
                return;
            }
            else
            {
                var JobName = context.JobDetail.Key.Name;
                //var JobDataMap = context.JobDetail.JobDataMap;
                var JobDataMap = context.Trigger.JobDataMap;
                var companyId = Convert.ToInt64(JobDataMap.GetString("companyId"));
                var dataType = JobDataMap.GetString("dataType");
                var frequency = JobDataMap.GetString("frequency");
                var importDateTime = DateTime.Parse(JobDataMap.GetString("importDateTime"),null);
                //var JobNameCompanyId = JobName.Split('_');
                //var companyId = Convert.ToInt64(JobNameCompanyId[0]);
                //var dataType = JobNameCompanyId[1];
                //var frequency = JobNameCompanyId[2];
                var autoImportSettings = autoImportSettingService.GetAutoImportSetting(w => w.CompanyId == companyId && w.dataType == dataType && w.frequency == frequency);
                AutoImportLog autoimportlog = new AutoImportLog();
                SalesConversionAggregationStatus SalesConversionAggregationStatus = new SalesConversionAggregationStatus();
                try
                {
                    //create logs for importing data
                    autoimportlog.CompanyId = autoImportSettings.CompanyId;
                    autoimportlog.dataType = autoImportSettings.dataType;
                    autoimportlog.frequency = autoImportSettings.frequency;
                    autoimportlog.ImportLogs = "Automate Import Function started.\r\n ";
                    autoimportlog.status = "Successful";
                    autoImportSettings.status = "Successful";
                    //sales conversion aggregation status 
                    SalesConversionAggregationStatus.branchStatus = "0/0";
                    SalesConversionAggregationStatus.aggregatedStatus = "Successful";
                    SalesConversionAggregationStatus.dateTime = DateTime.UtcNow;
                    getFilefromFTPDirectory(autoImportSettings, "Weekly", autoimportlog, SalesConversionAggregationStatus);
                    autoimportlog.ImportLogs = autoimportlog.ImportLogs + "Done";
                    autoimportlog.ImportedDateTime = DateTime.UtcNow;
                    autoImportSettings.ImportedDateTime = DateTime.Now;
                    autoImportSettings.ImportDateTime = importDateTime;
                    if (autoimportlog.status == "Failed")
                    {
                        autoImportSettings.status = "Failed";
                    }
                    autoImportSettingService.UpdateAutoImportSetting(autoImportSettings);
                    var company = companyService.GetCompany(autoImportSettings.CompanyId);
                    string subPath = "AutomateImportCSV\\" + company.CompanyCode;
                    long timestamp = Utility.ConvertToTimestamp(DateTime.UtcNow);
                    string savedPath = subPath + "\\" + company.CompanyCode + "_" + timestamp + "_" + autoImportSettings.ID + ".txt";
                    string newPath = RCCPPATH + "Footfallcam\\" + savedPath;
                    if (!Directory.Exists(RCCPPATH + "Footfallcam\\" + subPath ))
                    {
                        Directory.CreateDirectory(RCCPPATH + "Footfallcam\\" + subPath);
                    }
                    using (StreamWriter file = new StreamWriter(newPath))
                    {
                        file.WriteLine(autoimportlog.ImportLogs);
                        file.Close();
                    }
                    autoimportlog.ImportLogsLocation = savedPath;
                    if (autoimportlog.CompanyId == 16770)
                    {
                        autoimportlog.ImportLogs = "Done";
                    }
                    autoImportLogService.CreateAutoImportLog(autoimportlog);
                    //System Health Check sales conversion status
                    var myServer = serverIdentificationService.GetAllServerIdentifications().ToList().FirstOrDefault().GUID;
                    var counterHealthChecks = counterHealthCheckService.GetCounterHealthChecks(w => w.CompanyID == companyId && w.ServerGUID == myServer).ToList();
                    List<CounterHealthCheck> tobeInsertCounterHealthChecks = new List<CounterHealthCheck>();
                    //Convert status into json
                    var convertedJson = JsonConvert.SerializeObject(SalesConversionAggregationStatus);
                    foreach (var counterHealthCheck in counterHealthChecks)
                    {
                        counterHealthCheck.SalesConversionAggregationStatus = convertedJson;
                        tobeInsertCounterHealthChecks.Add(counterHealthCheck);
                    }
                    if (tobeInsertCounterHealthChecks.Count() != 0)
                    {
                        counterHealthCheckService.UpdateCounterHealthCheckList(tobeInsertCounterHealthChecks);
                    }
                }
                catch (Exception e)
                {
                    e.WriteExceptionLog(companyId);
                    var exception = e.Message;
                    autoimportlog.ImportLogs = autoimportlog.ImportLogs + "Import Failed due to: ";
                    if (e.InnerException != null)
                    {
                        autoimportlog.ImportLogs += e.InnerException.Message;
                    }
                    else
                    {
                        if(e.Message == "Timed out trying to connect!")
                        {
                            autoimportlog.ImportLogs += "Unable to connect to server now.";
                        }
                        else
                        {
                            autoimportlog.ImportLogs += exception;
                        }                       
                    }
                    autoimportlog.ImportedDateTime = DateTime.UtcNow;
                    autoimportlog.status = "Failed";
                    autoImportSettings.ImportedDateTime = DateTime.Now;
                    autoImportSettings.ImportDateTime = importDateTime;
                    autoImportSettings.status = "Failed";
                    autoImportSettingService.UpdateAutoImportSetting(autoImportSettings);
                    var company = companyService.GetCompany(autoImportSettings.CompanyId);
                    string subPath = "AutomateImportCSV\\" + company.CompanyCode;
                    long timestamp = Utility.ConvertToTimestamp(DateTime.UtcNow);
                    string savedPath = subPath + "\\" + company.CompanyCode + "_" + timestamp + "_" + autoImportSettings.ID + ".txt";
                    string newPath = RCCPPATH + "Footfallcam\\" + savedPath;
                    if (!Directory.Exists(RCCPPATH + subPath))
                    {
                        Directory.CreateDirectory(RCCPPATH + subPath);
                    }
                    using (StreamWriter file = new StreamWriter(newPath))
                    {
                        file.WriteLine(autoimportlog.ImportLogs);
                        file.Close();
                    }
                    autoimportlog.ImportLogsLocation = savedPath;
                    if (autoimportlog.CompanyId != 16770)
                    {
                        autoimportlog.ImportLogs = "Failed";
                    }
                    autoImportLogService.CreateAutoImportLog(autoimportlog);
                    //System Health Check sales conversion status
                    SalesConversionAggregationStatus.branchStatus = "0/0";
                    SalesConversionAggregationStatus.aggregatedStatus = "Failed";
                    SalesConversionAggregationStatus.dateTime = DateTime.UtcNow;
                    var myServer = serverIdentificationService.GetAllServerIdentifications().ToList().FirstOrDefault().GUID;
                    var counterHealthChecks = counterHealthCheckService.GetCounterHealthChecks(w => w.CompanyID == companyId && w.ServerGUID == myServer).ToList();
                    List<CounterHealthCheck> tobeInsertCounterHealthChecks = new List<CounterHealthCheck>();
                    //Convert status into json
                    var convertedJson = JsonConvert.SerializeObject(SalesConversionAggregationStatus);
                    foreach (var counterHealthCheck in counterHealthChecks)
                    {
                        counterHealthCheck.SalesConversionAggregationStatus = convertedJson;
                        tobeInsertCounterHealthChecks.Add(counterHealthCheck);
                    }
                    if (tobeInsertCounterHealthChecks.Count() != 0)
                    {
                        counterHealthCheckService.UpdateCounterHealthCheckList(tobeInsertCounterHealthChecks);
                    }                    
                }

                finally
                {
                    if (autoimportlog.status == "Failed" && autoImportSettings.status == "Failed")
                    {
                        //send email to notify when fail
                        var comSetting = companySettingService.GetCompanySetting(w => w.CompanyId == companyId);
                        var MailViewModel = new MailViewModel();
                        MailViewModel.To = new List<string>() { autoImportSettings.Email };
                        MailViewModel.Bcc = new List<string>() { "munchoonchiew@gmail.com" };                        
                        MailViewModel.Subject = "Import job failure notification";
                        var ftpDir = autoImportSettings.FTPDirectory == null ? "-" : autoImportSettings.FTPDirectory;
                        var errorMsg = autoimportlog.ImportLogs;
                        MailViewModel.Body =
                            "Hi, <br/><br/>" +
                            "The import job from " + RetailcamcontrolpanelURL + " with the folowing settings :- <br/><br/>" +
                            "Company Name : " + comSetting.Company.CompanyName + "<br/>" +
                            "FTP Username : " + autoImportSettings.FTPUserName + "<br/>" +
                            "FTP Host : " + autoImportSettings.FTPHost + "<br/>" +
                            "FTP Port : " + autoImportSettings.FTPPort + "<br/>" +
                            "FTP Directory : " + ftpDir + "<br/>" +
                            //"FTP Port : " + autoExportSetting.FTPPort + "<br/>" +
                            "Have ended with failure due to the following reason :- <br/><br/>" +
                            errorMsg + "<br/><br/>" +
                            "*****This is an auto-generated email, please do not reply to this*****";

                        TextWriter c = new StreamWriter(RCCPPATH + "\\abc123.txt");
                        c.Close();
                        HttpContext.Current = new HttpContext(new HttpRequest("", "http://footfallcounter.com", ""), new HttpResponse(c));

                        var uselessVar = DependencyResolver.Current.GetService<ActionController>().FTPAlert(MailViewModel, companyId);
                        //emailHelperService.SendEmail(new MailServerViewModel(comSetting), MailViewModel);
                    }
                }
            }            
        }

        public void getFilefromFTPDirectory(AutoImportSetting autoImportSetting, string isDailyorWeekly, AutoImportLog autoImportLog, SalesConversionAggregationStatus SalesConversionAggregationStatus)
        {
            var company = companyService.GetCompany(autoImportSetting.CompanyId);

            string subPath = (RCCPPATH + "AutomateImportCSV\\" + company.CompanyCode);
            //always create the directory if not exists
            //directory created according to company folder
            bool subPathExists = System.IO.Directory.Exists(subPath);
            if (!subPathExists)
                System.IO.Directory.CreateDirectory(subPath);

            if (autoImportSetting.isSftp == "FTP")
            {
                var host = autoImportSetting.FTPHost == null ? "" : autoImportSetting.FTPHost;
                var port = autoImportSetting.FTPPort == 0 ? 0 : autoImportSetting.FTPPort;
                var directory = autoImportSetting.FTPDirectory == null ? "" : autoImportSetting.FTPDirectory;
                var username = autoImportSetting.FTPUserName == null ? "" : autoImportSetting.FTPUserName;
                var password = autoImportSetting.FTPPassword == null ? "" : autoImportSetting.FTPPassword;
                var encryptionMode = autoImportSetting.encryptionMode == null ? "" : autoImportSetting.encryptionMode;
                var dataConnectionType = autoImportSetting.dataConnectionType == null ? "" : autoImportSetting.dataConnectionType;
                
                //Get ALL CSV absolute path and ready to download file 
                List<DirectoryItem> listing = GetDirectoryInformation(host, port, username, password, directory, encryptionMode, dataConnectionType, autoImportLog);
                //Download the File 
                downloadCSVFileforImportSalesConversion(company, listing, host, port, username, password, directory, autoImportLog);
            }
            else if (autoImportSetting.isSftp == "SFTP")
            {
                var host = autoImportSetting.sftpServer == null ? "" : autoImportSetting.sftpServer;
                int? port = autoImportSetting.sftpPort == 0 || autoImportSetting.sftpPort == null ? null : autoImportSetting.sftpPort;
                var directory = autoImportSetting.sftpDirectory == null ? "" : autoImportSetting.sftpDirectory;
                var username = autoImportSetting.sftpUsername == null ? "" : autoImportSetting.sftpUsername;
                var password = autoImportSetting.sftpPassword == null ? "" : autoImportSetting.sftpPassword;

                var ppkFilePath = autoImportSetting.ppkFilePath == null ? "" : autoImportSetting.ppkFilePath;
                var ppkFilePassword = autoImportSetting.ppkFilePassword == null ? "" : autoImportSetting.ppkFilePassword;

                var list = getSftpDirectoryInformation(host, port, username, password, directory, ppkFilePath, ppkFilePassword, company.ID, autoImportLog);
                downloadSftpCsvFile(host, port, username, password, directory, ppkFilePath, ppkFilePassword, company.ID, autoImportLog,list);
            }
            //proceed the data (New Functions that goes for )
            ScheduleEposTransactionbyCompanyId(autoImportSetting, true, autoImportLog, SalesConversionAggregationStatus);
        }
        public List<DirectoryItem> GetDirectoryInformation(string host, int port, string username, string password, string directory, string encryptionMode, string dataConnectionType, AutoImportLog autoImportLog)
        {
            List<DirectoryItem> returnValue = new List<DirectoryItem>();
            FtpClient client = new FtpClient(host, port, username, password);
            if (host == "mail.vanwesten.com")
            {
                client.DataConnectionType = FtpDataConnectionType.PASV;
            }

            //encryption mode for ftp connection
            if (encryptionMode == "Implicit")
            {
                client.EncryptionMode = FtpEncryptionMode.Implicit;
                client.ValidateCertificate += (o, e) =>
                {
                    e.Accept = true;
                };
            }
            else if (encryptionMode == "Explicit")
            {
                client.EncryptionMode = FtpEncryptionMode.Explicit;
                client.ValidateCertificate += (o, e) =>
                {
                    e.Accept = true;
                };
            }
            else
            {
                client.EncryptionMode = FtpEncryptionMode.None;
            }

            //data connection type for ftp connection
            if (dataConnectionType == "AutoActive")
            {
                client.DataConnectionType = FtpDataConnectionType.AutoActive;
            }
            else if (dataConnectionType == "AutoPassive")
            {
                client.DataConnectionType = FtpDataConnectionType.AutoPassive;
            }
            else if (dataConnectionType == "EPRT")
            {
                client.DataConnectionType = FtpDataConnectionType.EPRT;
            }
            else if (dataConnectionType == "EPSV")
            {
                client.DataConnectionType = FtpDataConnectionType.EPSV;
            }
            else if (dataConnectionType == "PASV")
            {
                client.DataConnectionType = FtpDataConnectionType.PASV;
            }
            else if (dataConnectionType == "PASVEX")
            {
                client.DataConnectionType = FtpDataConnectionType.PASVEX;
            }
            else if (dataConnectionType == "PORT")
            {
                client.DataConnectionType = FtpDataConnectionType.PORT;
            }
            else
            {
                client.DataConnectionType = FtpDataConnectionType.AutoPassive;
            }
            client.Connect();
            autoImportLog.ImportLogs = autoImportLog.ImportLogs + "Connected To Client FTP server. Copying CSV Files...\r\n ";
            foreach (FtpListItem ftpitem in client.GetListing(directory))
            {
                bool isDirectory = false;
                // if this is a file
                if (ftpitem.Type == FtpFileSystemObjectType.Directory)
                {
                    isDirectory = true;
                }
                // get modified date/time of the file or folder
                DateTime time = client.GetModifiedTime(ftpitem.FullName);

                // Create directory info
                DirectoryItem item = new DirectoryItem();
                item.DateCreated = time;
                item.IsDirectory = isDirectory;
                item.Name = ftpitem.Name;
                item.FullPath = ftpitem.FullName;
                item.Items = item.IsDirectory ? GetDirectoryInformation(host, port, username, password, ftpitem.FullName,encryptionMode,dataConnectionType, autoImportLog) : null;
                //get csv File only
                string isFileExtension = Path.GetExtension(item.Name);
                if (isFileExtension == ".csv" || isFileExtension == ".CSV")
                {
                    returnValue.Add(item);
                }
                if (item.Items != null)
                {
                    //get CSV File if the Directory Contains others Directory
                    foreach (var item2 in item.Items)
                    {
                        string isFileExtension2 = Path.GetExtension(item2.Name);
                        if (isFileExtension2 == ".csv" || isFileExtension2 == ".CSV")
                        {
                            returnValue.Add(item2);
                        }
                    }
                }
            }
            client.Disconnect();
            autoImportLog.ImportLogs = autoImportLog.ImportLogs + "Copied.. Processing Files...\r\n ";
            return returnValue;
        }

        public List<string> getSftpDirectoryInformation(string host,int? port,string username,string password, string directory, string ppkFilePath, string ppkFilePassword, long companyId, AutoImportLog autoImportLog)
        {
            SessionOptions sessionOptions = new SessionOptions();
            sessionOptions.Protocol = Protocol.Sftp;
            var company = companyService.GetCompany(companyId);

            if (!String.IsNullOrEmpty(host))
            {
                sessionOptions.HostName = host;
            }
            if (!String.IsNullOrEmpty(username))
            {
                sessionOptions.UserName = username;
            }
            if (!String.IsNullOrEmpty(password))
            {
                sessionOptions.Password = password;
            }
            if (port != null)
            {
                sessionOptions.PortNumber = Convert.ToInt16(port);
            }
            //Details For Red Cross
            //sessionOptions.HostName = "62.8.120.152";
            //sessionOptions.UserName = "SgSystems";
            //sessionOptions.PrivateKeyPassphrase = "HOSTRedCr055CleaN";
            sessionOptions.SshPrivateKeyPath = RCCPPATH + "Ppk\\" + company.CompanyCode + "\\" + ppkFilePath;
            sessionOptions.PrivateKeyPassphrase = ppkFilePassword;
            sessionOptions.GiveUpSecurityAndAcceptAnySshHostKey = true;
            sessionOptions.Timeout = new TimeSpan(0,3,0);
            Session session = new Session();
            session.Open(sessionOptions);

            autoImportLog.ImportLogs = autoImportLog.ImportLogs + "Connected To Client SFTP server. Copying CSV Files...\r\n ";

            //session.ListDirectory(directory);

            RemoteDirectoryInfo remoteDirectory = session.ListDirectory(directory);
            var fullNameFileList = new List<string>();

            if (companyId == 16770)
            {
                fullNameFileList.AddRange(remoteDirectory.Files
                .Where(w => w.FullName.Contains(".zip"))
                .Select(s => s.FullName)
                .ToArray());
            }
            else
            {
                fullNameFileList.AddRange(remoteDirectory.Files
                .Where(w => w.FullName.Contains(".csv"))
                .Select(s => s.FullName)
                .ToArray());
            }
            return fullNameFileList;
        }

        public void downloadCSVFileforImportSalesConversion(Company company, List<DirectoryItem> listing, string host, int port, string username, string password, string directory, AutoImportLog autoImportLog)
        {
            //always create the root directory if not exists
            string rootPath = (RCCPPATH + "AutomateImportCSV");
            bool rootPathExists = System.IO.Directory.Exists(rootPath);
            if (!rootPathExists)
                System.IO.Directory.CreateDirectory(rootPath);
            string subPath = (RCCPPATH + "AutomateImportCSV\\" + company.CompanyCode);
            //always create the directory if not exists
            //directory created according to company folder
            bool subPathExists = System.IO.Directory.Exists(subPath);
            if (!subPathExists)
                System.IO.Directory.CreateDirectory(subPath);
            //connect to FTP Client
            FtpClient client = new FtpClient(host, port, username, password);
            if (host == "mail.vanwesten.com")
            {
                client.DataConnectionType = FtpDataConnectionType.PASV;
            }
            client.Connect();
            if (listing.Count() >= 1)
            {
                autoImportLog.ImportLogs = autoImportLog.ImportLogs + "Renaming FTP Server CSV Files...\r\n ";
            }
            else
            {
                autoImportLog.ImportLogs = autoImportLog.ImportLogs + "NO CSV Files,Skip...\r\n ";
            }

            foreach (var list in listing)
            {
                long timestamp = Utility.ConvertToTimestamp(DateTime.Now);
                client.DownloadFile(subPath + "\\" + Convert.ToString(timestamp) + "_" + list.Name, list.FullPath);
                client.Rename(list.FullPath, list.FullPath + "_" + "-copied");
            }
            if (listing.Count() >= 1)
            {
                autoImportLog.ImportLogs = autoImportLog.ImportLogs + "Renamed...\r\n ";
            }
            client.Disconnect();
        }

        public void downloadSftpCsvFile(string host, int? port, string username, string password, string directory, string ppkFilePath, string ppkFilePassword, long companyId, AutoImportLog autoImportLog, List<string> fileNameList)
        {
            SessionOptions sessionOptions = new SessionOptions();
            sessionOptions.Protocol = Protocol.Sftp;
            var company = companyService.GetCompany(companyId);

            if (!String.IsNullOrEmpty(host))
            {
                sessionOptions.HostName = host;
            }
            if (!String.IsNullOrEmpty(username))
            {
                sessionOptions.UserName = username;
            }
            if (!String.IsNullOrEmpty(password))
            {
                sessionOptions.Password = password;
            }
            if (port != null)
            {
                sessionOptions.PortNumber = Convert.ToInt16(port);
            }
            //Details For Red Cross
            //sessionOptions.HostName = "62.8.120.152";
            //sessionOptions.UserName = "SgSystems";
            //sessionOptions.PrivateKeyPassphrase = "HOSTRedCr055CleaN";
            sessionOptions.SshPrivateKeyPath = RCCPPATH + "Ppk\\" + company.CompanyCode + "\\" + ppkFilePath;
            sessionOptions.PrivateKeyPassphrase = ppkFilePassword;
            sessionOptions.GiveUpSecurityAndAcceptAnySshHostKey = true;

            Session session = new Session();
            session.Open(sessionOptions);

            TransferOptions transferOptions = new TransferOptions();
            transferOptions.TransferMode = TransferMode.Binary;
            TransferOperationResult result;

            foreach (var fileName in fileNameList)
            {
                var splitFileName = fileName.Split('/');
                result = session.GetFiles(fileName, RCCPPATH + "AutomateImportCSV\\" + company.CompanyCode + "\\" + splitFileName[splitFileName.GetUpperBound(0)], false, transferOptions);
                result.Check();

                if (result.IsSuccess)
                {
                    continue;
                }
                else
                {
                    break;
                }
            }
        }

        public void ScheduleEposTransactionbyCompanyId(AutoImportSetting autoImportSetting, bool isAutomateUpload, AutoImportLog autoImportLog, SalesConversionAggregationStatus SalesConversionAggregationStatus)
        {
            //declare all needed details
            autoImportLog.ImportLogs = autoImportLog.ImportLogs + "Processing CSV Files...\r\n ";
            var company = companyService.GetCompany(autoImportSetting.CompanyId);
            var allBranch = ffBranchService.GetBranches(w => w.CompanyId == company.ID).ToList();
            //System Health Check Aggregate Status variable declaration
            var totalBranchNumber = allBranch.Count();
            List<long> branchcodeLists = new List<long>();

            if (autoImportSetting.CompanyId == 16770)
            {
                string zipFilePath = RCCPPATH + "AutomateImportCSV\\" + company.CompanyCode;
                var zipFiles = Directory.GetFiles(zipFilePath, "*.zip", SearchOption.AllDirectories);
                foreach (var file in zipFiles)
                {
                    Utility.ExtractZipContentWithPassword(file, "Man2Men", zipFilePath);
                    File.Delete(file);
                }
            }
            //Modified for automateupload
            string[] csvFiles;
            if (isAutomateUpload)
            {
                string subPath = (RCCPPATH + "AutomateImportCSV\\" + company.CompanyCode);
                csvFiles = Directory.GetFiles(subPath, "*.csv", SearchOption.AllDirectories);
            }
            else
            {
                csvFiles = Directory.GetFiles(RCCPPATH + "SalesCSV\\", "*", SearchOption.AllDirectories);
            }
            int j = 0;
            foreach (var realcsv in csvFiles)
            {
                if (realcsv.IndexOf("-complete") > 0 || realcsv.IndexOf("-processing") > 0 || realcsv.IndexOf("-error") > 0 || realcsv.IndexOf(".txt") > 0 || realcsv.IndexOf(".finished") > 0 || realcsv.IndexOf("-finished") > 0)
                    continue;
                j = j + 1;
            }
            int i = 0;
            autoImportLog.ImportLogs = autoImportLog.ImportLogs + "total of " + j + " csv files need to be processed...\r\n ";
            if (j == 0)
            {
                autoImportLog.status = "Failed";
                autoImportSetting.status = "Failed";
            }
            foreach (string csv in csvFiles)
            {
                if (csv.IndexOf("-complete") > 0 || csv.IndexOf("-processing") > 0 || csv.IndexOf("-error") > 0 || csv.IndexOf(".txt") > 0 || csv.IndexOf("-finished") > 0)
                    continue;
                var fileName = Path.GetFileName(csv);
                if (File.Exists(csv + "-processing"))
                {
                    File.Delete(csv + "-processing");
                }
                File.Move(csv, csv + "-processing");

                var path = csv + "-processing";
                var salesFileFormat = autoImportSetting.salesFileFormatType;
                var branchCodeIndex = autoImportSetting.branchCodeIndex.ToString();
                var timestampIndex = autoImportSetting.dateTimeIndex.ToString();
                var transactionCountIndex = autoImportSetting.totalTransQtyIndex.ToString();
                var salesAmountIndex = autoImportSetting.totalTransValueIndex.ToString();
                var saleDateTimeFormatValue = Convert.ToInt16(autoImportSetting.dateTimeFormat);
                var timeIndex = autoImportSetting.saleTimeIndex;

                //Get data from csv file
                TextWriter a = new StreamWriter(RCCPPATH + "\\abc123.txt");
                a.Close();
                HttpContext.Current = new HttpContext(new HttpRequest("", "http://footfallcounter.com", ""), new HttpResponse(a));
                var eposList = DependencyResolver.Current.GetService<ImportController>().formatDataFromFile(salesFileFormat, path, branchCodeIndex, timestampIndex, transactionCountIndex, salesAmountIndex, saleDateTimeFormatValue, timeIndex,company,true,null, autoImportLog);

                //Save the Formatted list into DB
                if (eposList != null && eposList.Count()>0)
                {
                    TextWriter b = new StreamWriter(RCCPPATH + "\\abc321.txt");
                    b.Close();
                    HttpContext.Current = new HttpContext(new HttpRequest("", "http://footfallcounter.com", ""), new HttpResponse(a));
                    DependencyResolver.Current.GetService<ImportController>().saveIntoDatabase(eposList);
                }

                File.Move(csv + "-processing", csv + "-complete");
                #region old code for reading csv file/save to db
                //var reader = new StreamReader(File.OpenRead(csv + "-processing"));
                //var count = 0;
                //var list = new List<FFEPosTransactionData>();

                //var dateIndex = -1;
                //var timeIndex = -1;
                //int timestampIndex = -1;
                //int transactionCountIndex = -1;
                //int AverageAmountIndex = -1;
                //int salesAmountIndex = -1;
                //int branchCodeIndex = -1;
                //Dictionary<string, int> branchTimeZone = new Dictionary<string, int>();

                //if (salesFileFormat == "ffcFormat")
                //{
                //    while (!reader.EndOfStream)
                //    {
                //        var line = reader.ReadLine();
                //        count++;
                //        if (count == 1)
                //        {
                //            //convert selecteddata to index
                //            branchCodeIndex = autoImportSetting.branchCodeIndex;
                //            timestampIndex = autoImportSetting.dateTimeIndex;
                //            transactionCountIndex = autoImportSetting.totalTransQtyIndex;
                //            salesAmountIndex = autoImportSetting.totalTransValueIndex;
                //            continue;
                //        }
                //        var values = line.Split(',');
                //        //var datetime = DateTime.Parse(values[1], CultureInfo.CreateSpecificCulture("en-US")).AddHours(Double.Parse(values[2]));
                //        string branchCode = string.Empty;
                //        long timestamp = 0;
                //        double salesAmount = 0;
                //        double averageAmount = 0;
                //        int transactionCount = 0;
                //        long branchId;

                //        if (values.Count() <= 1)
                //        {
                //            autoImportLog.ImportLogs = autoImportLog.ImportLogs + fileName + ", Invalid CSV Format.\r\n ";
                //            autoImportLog.status = "Failed";
                //            autoImportSetting.status = "Failed";
                //            break;
                //        }

                //        if (branchCodeIndex >= 0)
                //        {
                //            branchCode = values[branchCodeIndex];
                //            if (branchCode == "ABC")
                //            {
                //                branchCode = "KL1";
                //            }

                //            if (company == null)
                //            {
                //                using (StreamWriter file = new StreamWriter("C:\\temp\\eposError.txt"))
                //                {
                //                    file.WriteLine("Company Code Not Found: " + csv);
                //                    autoImportLog.ImportLogs = autoImportLog.ImportLogs + fileName + ", Company Code Not Found.\r\n ";
                //                    autoImportLog.status = "Failed";
                //                    autoImportSetting.status = "Failed";
                //                }
                //                continue;
                //            }

                //            //branchId = ffBranchService.GetBranchbyBranchCodeandCompanyID(branchCode, company.ID).ID;
                //            try
                //            {
                //                branchId = allBranch.Find(f => f.BranchCode == branchCode && f.CompanyId == company.ID).ID;
                //                if (!branchcodeLists.Contains(branchId))
                //                {
                //                    branchcodeLists.Add(branchId);
                //                }

                //            }
                //            catch (Exception e)
                //            {
                //                autoImportLog.ImportLogs = autoImportLog.ImportLogs + fileName + ", Branch ID not found, Error Branchcode is : " + branchCode + " \r\n";
                //                autoImportLog.status = "Failed";
                //                autoImportSetting.status = "Failed";
                //                continue;
                //            }
                //        }
                //        else
                //        {
                //            continue;

                //        }
                //        try
                //        {
                //            if (timestampIndex >= 0)
                //            {
                //                //////////////////////////
                //                //Declare every DateTime 
                //                //////////////////////////
                //                var dateTimeFormat = "";
                //                switch (Convert.ToInt16(autoImportSetting.dateTimeFormat))
                //                {
                //                    case 1:
                //                        dateTimeFormat = "M/d/yyyy";
                //                        break;
                //                    case 2:
                //                        dateTimeFormat = "M/d/yy";
                //                        break;
                //                    case 3:
                //                        dateTimeFormat = "MM/dd/yy";
                //                        break;
                //                    case 4:
                //                        dateTimeFormat = "MM/dd/yyyy";
                //                        break;
                //                    case 5:
                //                        dateTimeFormat = "dd-MMM-yy";
                //                        break;
                //                    case 6:
                //                        dateTimeFormat = "MMMM d, yyyy";
                //                        break;
                //                    case 7:
                //                        dateTimeFormat = "d-MMM-yyyy";
                //                        break;
                //                    case 8:
                //                        dateTimeFormat = "dd/MM/yyyy";
                //                        break;
                //                    case 9:
                //                        dateTimeFormat = "dd/MM/yy";
                //                        break;
                //                    case 10:
                //                        dateTimeFormat = "d/M/yy";
                //                        break;
                //                    case 11:
                //                        dateTimeFormat = "yyyy-MM-dd";
                //                        break;
                //                    case 12:
                //                        dateTimeFormat = "dd MMMM yyyy";
                //                        break;
                //                    case 13:
                //                        dateTimeFormat = "d MMMM yyyy";
                //                        break;
                //                    case 14:
                //                        dateTimeFormat = "d.M.yyyy";
                //                        break;
                //                }
                //                //Convert all date time dynamically 
                //                var hourminuteformat = values[timestampIndex].Split(':');
                //                if (hourminuteformat.Count() >= 3)
                //                {
                //                    dateTimeFormat = dateTimeFormat + " H:mm:ss";
                //                }
                //                else
                //                {
                //                    dateTimeFormat = dateTimeFormat + " H:mm";
                //                }
                //                String newDateTime = DateTime.ParseExact(values[timestampIndex], dateTimeFormat, CultureInfo.InvariantCulture).ToString();
                //                timestamp = Utility.ConvertToTimestamp(DateTime.Parse(newDateTime));
                //            }
                //        }
                //        catch
                //        {
                //            autoImportLog.ImportLogs = autoImportLog.ImportLogs + fileName + ", Error insert into database.\r\n Invalid Date / Time format in the CSV file. (Line " + count + ") \r\n";
                //            autoImportLog.status = "Failed";
                //            autoImportSetting.status = "Failed";
                //            break;
                //        }
                //        try
                //        {
                //            transactionCount = transactionCountIndex > 0 ? Int32.Parse(values[transactionCountIndex]) : 0;
                //        }
                //        catch
                //        {
                //            autoImportLog.ImportLogs = autoImportLog.ImportLogs + fileName + ", Error insert into database.\r\n Invalid data for Total Transaction Quantity in the CSV file. (Line " + count + ") \r\n";
                //            autoImportLog.status = "Failed";
                //            autoImportSetting.status = "Failed";
                //            break;
                //        }
                //        try
                //        {
                //            salesAmount = salesAmountIndex > 0 ? Double.Parse(values[salesAmountIndex]) : 0;
                //        }
                //        catch
                //        {
                //            autoImportLog.ImportLogs = autoImportLog.ImportLogs + fileName + ", Error insert into database.\r\n Invalid data for Total Transaction Value in the CSV file. (Line " + count + ") \r\n";
                //            autoImportLog.status = "Failed";
                //            autoImportSetting.status = "Failed";
                //            break;
                //        }
                //        if (AverageAmountIndex > 0)
                //            averageAmount = Double.Parse(values[AverageAmountIndex]);
                //        else
                //            averageAmount = transactionCount > 0 ? ((int)(salesAmount / transactionCount * 100)) / 100.0 : 0;

                //        if (timestamp > 0)
                //        {
                //            var data = new FFEPosTransactionData()
                //            {
                //                BranchCode = branchCode,
                //                Timestamp = timestamp,
                //                SalesAmount = salesAmount,
                //                TransactionCount = transactionCount,
                //                AverageAmount = averageAmount,
                //                BranchId = branchId
                //            };
                //            list.Add(data);
                //        }
                //    }
                //reader.Dispose();
                //        try
                //        {
                //            var transDataList = new List<FFEPosTransactionData>();
                //            var minTime = list.Min(m => m.Timestamp);
                //            var maxTime = list.Max(m => m.Timestamp);
                //            var branchList = allBranch.Select(s => s.ID).ToList();
                //            var transData = ffEPosTransactionDataService.GetMany(w => branchList.Contains(w.BranchId) && w.Timestamp >= minTime && w.Timestamp <= maxTime);
                //            var duplicates = transData.Select(s => new { s.Timestamp, s.BranchCode, s.BranchId }).Intersect(list.Select(ss => new { ss.Timestamp, ss.BranchCode, ss.BranchId }));
                //            var dupTime = duplicates.Select(s => s.Timestamp).ToList();
                //            var dupBranchCode = duplicates.Select(s => s.BranchCode).ToList();
                //            var dupBranchId = duplicates.Select(s => s.BranchId).ToList();
                //            var getDuplicate = ffEPosTransactionDataService.GetMany(w => dupTime.Contains(w.Timestamp) && dupBranchCode.Contains(w.BranchCode) && dupBranchId.Contains(w.BranchId));
                //            ffEPosTransactionDataService.BulkDeleteTransactionData2(getDuplicate);
                //            ffEPosTransactionDataService.BulkInsertTransactionData2(list);
                //            // update branchStatus into sales conversion aggregation status
                //            SalesConversionAggregationStatus.branchStatus = branchcodeLists.Count() + "/" + allBranch.Count();

                //        }
                //        catch (Exception e)
                //        {
                //            long timestamp = Utility.ConvertToTimestamp(DateTime.Now);
                //            File.Move(csv + "-processing", csv + "-error-" + Convert.ToString(timestamp));
                //            var msg = e.InnerException != null ? e.InnerException.Message : e.Message;
                //            autoImportLog.ImportLogs = autoImportLog.ImportLogs + fileName + ", Error insert into database. Due to: " + msg + "\r\n ";
                //            autoImportLog.status = "Failed";
                //            autoImportSetting.status = "Failed";
                //            continue;
                //        }
                //        long timestamp2 = Utility.ConvertToTimestamp(DateTime.Now);
                //        autoImportLog.ImportLogs = autoImportLog.ImportLogs + fileName + " processed Successfully.\r\n ";
                //        File.Move(csv + "-processing", csv + "-complete-" + Convert.ToString(timestamp2));
                //    }
                //    else if (salesFileFormat == "oracleFormat")
                //    {
                //        while (!reader.EndOfStream)
                //        {
                //            var line = reader.ReadLine();
                //            count++;
                //            if (count == 1)
                //            {
                //                //convert selecteddata to index
                //                branchCodeIndex = autoImportSetting.branchCodeIndex;
                //                dateIndex = autoImportSetting.dateTimeIndex;
                //                timeIndex = Convert.ToInt32(autoImportSetting.saleTimeIndex);
                //                salesAmountIndex = autoImportSetting.totalTransValueIndex;
                //                continue;
                //            }
                //            var values = line.Split(',');
                //            //var datetime = DateTime.Parse(values[1], CultureInfo.CreateSpecificCulture("en-US")).AddHours(Double.Parse(values[2]));
                //            string branchCode = string.Empty;
                //            long timestamp = 0;
                //            double salesAmount = 0;
                //            double averageAmount = 0;
                //            int transactionCount = 0;
                //            long branchId;
                //            string dateTime = String.Empty;

                //            if (values.Count() <= 1)
                //            {
                //                autoImportLog.ImportLogs = autoImportLog.ImportLogs + fileName + ", Invalid CSV Format.\r\n ";
                //                autoImportLog.status = "Failed";
                //                autoImportSetting.status = "Failed";
                //                break;
                //            }

                //            if (branchCodeIndex >= 0)
                //            {
                //                branchCode = values[branchCodeIndex];
                //                if (branchCode == "ABC")
                //                {
                //                    branchCode = "KL1";
                //                }

                //                if (company == null)
                //                {
                //                    using (StreamWriter file = new StreamWriter("C:\\temp\\eposError.txt"))
                //                    {
                //                        file.WriteLine("Company Code Not Found: " + csv);
                //                        autoImportLog.ImportLogs = autoImportLog.ImportLogs + fileName + ", Company Code Not Found.\r\n ";
                //                        autoImportLog.status = "Failed";
                //                        autoImportSetting.status = "Failed";
                //                    }
                //                    continue;
                //                }

                //                //branchId = ffBranchService.GetBranchbyBranchCodeandCompanyID(branchCode, company.ID).ID;
                //                try
                //                {
                //                    branchId = allBranch.Find(f => f.BranchCode == branchCode && f.CompanyId == company.ID).ID;
                //                    if (!branchcodeLists.Contains(branchId))
                //                    {
                //                        branchcodeLists.Add(branchId);
                //                    }

                //                }
                //                catch (Exception e)
                //                {
                //                    autoImportLog.ImportLogs = autoImportLog.ImportLogs + fileName + ", Branch ID not found, Error Branchcode is : " + branchCode + " \r\n";
                //                    autoImportLog.status = "Failed";
                //                    autoImportSetting.status = "Failed";
                //                    continue;
                //                }
                //            }
                //            else
                //            {
                //                continue;

                //            }
                //            try
                //            {
                //                if (dateIndex >= 0)
                //                {
                //                    //////////////////////////
                //                    //Declare every DateTime 
                //                    //////////////////////////
                //                    var dateTimeFormat = "";
                //                    switch (Convert.ToInt16(autoImportSetting.dateTimeFormat))
                //                    {
                //                        case 1:
                //                            dateTimeFormat = "M/d/yyyy";
                //                            break;
                //                        case 2:
                //                            dateTimeFormat = "M/d/yy";
                //                            break;
                //                        case 3:
                //                            dateTimeFormat = "MM/dd/yy";
                //                            break;
                //                        case 4:
                //                            dateTimeFormat = "MM/dd/yyyy";
                //                            break;
                //                        case 5:
                //                            dateTimeFormat = "dd-MMM-yy";
                //                            break;
                //                        case 6:
                //                            dateTimeFormat = "MMMM d, yyyy";
                //                            break;
                //                        case 7:
                //                            dateTimeFormat = "d-MMM-yyyy";
                //                            break;
                //                        case 8:
                //                            dateTimeFormat = "dd/MM/yyyy";
                //                            break;
                //                        case 9:
                //                            dateTimeFormat = "dd/MM/yy";
                //                            break;
                //                        case 10:
                //                            dateTimeFormat = "d/M/yy";
                //                            break;
                //                        case 11:
                //                            dateTimeFormat = "yyyy-MM-dd";
                //                            break;
                //                        case 12:
                //                            dateTimeFormat = "dd MMMM yyyy";
                //                            break;
                //                        case 13:
                //                            dateTimeFormat = "d MMMM yyyy";
                //                            break;
                //                        case 14:
                //                            dateTimeFormat = "d.M.yyyy";
                //                            break;
                //                    }
                //                    //Convert all date time dynamically 
                //                    if (timeIndex >= 0)
                //                    {
                //                        dateTimeFormat = dateTimeFormat + " HH:mm:ss";
                //                        var hour = values[timeIndex].Substring(0, 2);
                //                        var minute = values[timeIndex].Substring(2, 2);
                //                        var second = values[timeIndex].Substring(4, 2);
                //                        var time = hour + ":" + minute + ":" + second;
                //                        var date = values[dateIndex];
                //                        dateTime = date + " " + time;
                //                    }
                //                    var newDateTime = DateTime.ParseExact(dateTime, dateTimeFormat, CultureInfo.InvariantCulture).ToString();
                //                    timestamp = Utility.ConvertToTimestamp(DateTime.Parse(newDateTime));
                //                }
                //            }
                //            catch
                //            {
                //                autoImportLog.ImportLogs = autoImportLog.ImportLogs + fileName + ", Error insert into database.\r\n Invalid Date / Time format in the CSV file. (Line " + count + ") \r\n";
                //                autoImportLog.status = "Failed";
                //                autoImportSetting.status = "Failed";
                //                break;
                //            }
                //            try
                //            {
                //                transactionCount = 1;
                //            }
                //            catch
                //            {
                //                autoImportLog.ImportLogs = autoImportLog.ImportLogs + fileName + ", Error insert into database.\r\n Invalid data for Total Transaction Quantity in the CSV file. (Line " + count + ") \r\n";
                //                autoImportLog.status = "Failed";
                //                autoImportSetting.status = "Failed";
                //                break;
                //            }
                //            try
                //            {
                //                salesAmount = salesAmountIndex > 0 ? Double.Parse(values[salesAmountIndex]) : 0;
                //            }
                //            catch
                //            {
                //                autoImportLog.ImportLogs = autoImportLog.ImportLogs + fileName + ", Error insert into database.\r\n Invalid data for Total Transaction Value in the CSV file. (Line " + count + ") \r\n";
                //                autoImportLog.status = "Failed";
                //                autoImportSetting.status = "Failed";
                //                break;
                //            }
                //            if (AverageAmountIndex > 0)
                //                averageAmount = Double.Parse(values[AverageAmountIndex]);
                //            else
                //                averageAmount = transactionCount > 0 ? ((int)(salesAmount / transactionCount * 100)) / 100.0 : 0;

                //            if (timestamp > 0)
                //            {
                //                var data = new FFEPosTransactionData()
                //                {
                //                    BranchCode = branchCode,
                //                    Timestamp = timestamp,
                //                    SalesAmount = salesAmount,
                //                    TransactionCount = transactionCount,
                //                    AverageAmount = averageAmount,
                //                    BranchId = branchId
                //                };
                //                list.Add(data);
                //            }
                //        }
                //        reader.Dispose();
                //        try
                //        {
                //            var transDataList = new List<FFEPosTransactionData>();
                //            var minTime = list.Min(m => m.Timestamp);
                //            var maxTime = list.Max(m => m.Timestamp);
                //            var branchList = allBranch.Select(s => s.ID).ToList();
                //            var transData = ffEPosTransactionDataService.GetMany(w => branchList.Contains(w.BranchId) && w.Timestamp >= minTime && w.Timestamp <= maxTime);
                //            var duplicates = transData.Select(s => new { s.Timestamp, s.BranchCode, s.BranchId }).Intersect(list.Select(ss => new { ss.Timestamp, ss.BranchCode, ss.BranchId }));
                //            var dupTime = duplicates.Select(s => s.Timestamp).ToList();
                //            var dupBranchCode = duplicates.Select(s => s.BranchCode).ToList();
                //            var dupBranchId = duplicates.Select(s => s.BranchId).ToList();
                //            var getDuplicate = ffEPosTransactionDataService.GetMany(w => dupTime.Contains(w.Timestamp) && dupBranchCode.Contains(w.BranchCode) && dupBranchId.Contains(w.BranchId));
                //            ffEPosTransactionDataService.BulkDeleteTransactionData2(getDuplicate);
                //            ffEPosTransactionDataService.BulkInsertTransactionData2(list);
                //            // update branchStatus into sales conversion aggregation status
                //            SalesConversionAggregationStatus.branchStatus = branchcodeLists.Count() + "/" + allBranch.Count();

                //        }
                //        catch (Exception e)
                //        {
                //            long timestamp = Utility.ConvertToTimestamp(DateTime.Now);
                //            File.Move(csv + "-processing", csv + "-error-" + Convert.ToString(timestamp));
                //            var msg = e.InnerException != null ? e.InnerException.Message : e.Message;
                //            autoImportLog.ImportLogs = autoImportLog.ImportLogs + fileName + ", Error insert into database. Due to: " + msg + "\r\n ";
                //            autoImportLog.status = "Failed";
                //            autoImportSetting.status = "Failed";
                //            continue;
                //        }
                //        long timestamp2 = Utility.ConvertToTimestamp(DateTime.Now);
                //        autoImportLog.ImportLogs = autoImportLog.ImportLogs + fileName + " processed Successfully.\r\n ";
                //        File.Move(csv + "-processing", csv + "-complete-" + Convert.ToString(timestamp2));
                //    }
                #endregion
            }
        }
    }
}