﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Quartz;
using Quartz.Collection;
using Quartz.Impl;
using Ninject;
using RetailCamControlPanel.Services.SingularService;
using RetailCamControlPanel.Repositories;
using RetailCamControlPanel.Infrastructure;
using System.Data.Entity;
using RetailCamControlPanel.Services.CompositeService;
using System.Collections.ObjectModel;

namespace RetailCamControlPanel.Quartz
{
    public class JobScheduler
    {
        private readonly IAutoImportSettingService autoImportSettingService;

        public JobScheduler(IAutoImportSettingService autoImportSettingService)
        {
            this.autoImportSettingService = autoImportSettingService;
        }
        public static void Start()
        {
            var kernel = InitializeNinjectKernel();
            var scheduler = kernel.Get<IScheduler>();
            //IScheduler scheduler = StdSchedulerFactory.GetDefaultScheduler();
            scheduler.Start();

            var autoImportSettingService = MvcApplication.container
                .GetInstance<AutoImportSettingService>();
            var autoPatch2DTSData = MvcApplication.container
                .GetInstance<AutoPatch2D>();
            // moved to scheduler project
            //var HealthCheckNotifications = MvcApplication.container
            //    .GetInstance<HealthCheckNotifications>();
            var autoGenerateVerificationReport = MvcApplication.container
                .GetInstance<AutoGenerateVerificationReport>();
            var checkUnregCounter = MvcApplication.container
                .GetInstance<CheckUnregCounter>();
            var lineSettingsTunedNotification = MvcApplication.container
                .GetInstance<lineSettingTunedNotifications>();

            var autoImportSettings = autoImportSettingService.GetAllAutoImportSettings();

            IJobDetail importJob = JobBuilder.Create<ImportJob>()
                   .WithIdentity("importJob", "importJobGroup")
                   .StoreDurably(true)
                   .Build();

            scheduler.AddJob(importJob, true);
            //Import Job
            foreach (var autoimportsetting in autoImportSettings)
            {
                if (autoimportsetting.frequency == "Weekly")
                {
                    var weekday = "";
                    switch (autoimportsetting.ImportDay)
                    {
                        case "Sunday":
                            weekday = "SUN";
                            break;
                        case "Monday":
                            weekday = "MON";
                            break;
                        case "Tuesday":
                            weekday = "TUE";
                            break;
                        case "Wednesday":
                            weekday = "WED";
                            break;
                        case "Thursday":
                            weekday = "THU";
                            break;
                        case "Friday":
                            weekday = "FRI";
                            break;
                        case "Saturday":
                            weekday = "SAT";
                            break;
                    }
                    var hour = autoimportsetting.ImportDateTime.Hour.ToString();
                    var minute = autoimportsetting.ImportDateTime.Minute.ToString();
                    var crontabValue = "0 " + minute + " " + hour + " ? * " + weekday;
                    ITrigger trigger = TriggerBuilder.Create()
                    .WithIdentity(autoimportsetting.CompanyId.ToString() + "_" + autoimportsetting.ID.ToString())
                    .WithCronSchedule(crontabValue, x => x.InTimeZone(TimeZoneInfo.Utc))
                    .UsingJobData("companyId", autoimportsetting.CompanyId.ToString())
                    .UsingJobData("dataType", autoimportsetting.dataType)
                    .UsingJobData("frequency", autoimportsetting.frequency)
                    .UsingJobData("importDateTime", Convert.ToString(autoimportsetting.ImportDateTime))
                    .ForJob("importJob", "importJobGroup")
                    .Build();
                    try
                    {
                        scheduler.ScheduleJob(trigger);
                    }
                    catch { }
                }
                else
                {
                    var hour = autoimportsetting.ImportDateTime.Hour.ToString();
                    var minute = autoimportsetting.ImportDateTime.Minute.ToString();
                    var crontabValue = "0 " + minute + " " + hour + " 1/1 * ?";
                    ITrigger trigger = TriggerBuilder.Create()
                    .WithIdentity(autoimportsetting.CompanyId.ToString() + "_" + autoimportsetting.ID.ToString())
                    .WithCronSchedule(crontabValue, x => x.InTimeZone(TimeZoneInfo.Utc))
                    .UsingJobData("companyId", autoimportsetting.CompanyId.ToString())
                    .UsingJobData("dataType", autoimportsetting.dataType)
                    .UsingJobData("frequency", autoimportsetting.frequency)
                    .UsingJobData("importDateTime", Convert.ToString(autoimportsetting.ImportDateTime))
                    .ForJob("importJob", "importJobGroup")
                    .Build();
                    try
                    {
                        scheduler.ScheduleJob(trigger);
                    }
                    catch { }
                }
            }

            /////////////////////////////////////////
            // Cron Maker to set your schedule time
            // http://www.cronmaker.com/ //
            /////////////////////////////////////////
            //
            //for email scheduler (Generate)

            //daily cron for Auto FW Upgrade JOB
            var autoFWUpgradecrontab = "0 0 1 1/1 * ? *";
            //crontab for auto patch 2D
            var autoPatch2DCron = "0 1 * * * ? *";
            //crontab for HC Notifications everyday at 9am
            //var HCNotificationsCron = "0 0 0/1 1/1 * ? *";
            //crontab for AutoGenerate Verification Report 
            var autoGenerateVerificationReportCron = "0 0 23 1/1 * ? *";

            //1 hour cron on 0 minutes mark
            var hourly0MinMarkCronTab = "0 0 * ? * * *";

            //Auto Firmware Upgrade JOB
            IJobDetail autoFWUpgrade = JobBuilder.Create<AutoFWUpgradeJob>().WithIdentity("AutoFWUpgrade").Build();
            ITrigger autoFWUpgradeTrigger = TriggerBuilder.Create()
                    .WithIdentity("AutoFWUpgrade")
                    .WithCronSchedule(autoFWUpgradecrontab)
                    .Build();
            scheduler.ScheduleJob(autoFWUpgrade, autoFWUpgradeTrigger);

            //JobKey jobKey = new JobKey("AutoExport_573_0_1");
            //scheduler.TriggerJob(jobKey);
            //AutoExport_172_1_0

            //auto patch 2D
            IJobDetail Patch2DCounter = JobBuilder.Create<AutoPatch2D>().WithIdentity("Patch2D").Build();
            ITrigger Patch2DCounterTrigger = TriggerBuilder.Create()
                    .WithIdentity("Patch2D")
                    .WithCronSchedule(autoPatch2DCron)
                    .Build();
            scheduler.ScheduleJob(Patch2DCounter, Patch2DCounterTrigger);

            //for health check notifications
            //IJobDetail HCNotifications = JobBuilder.Create<HealthCheckNotifications>().WithIdentity("HCNot").Build();
            //ITrigger HCNotificationsTrigger = TriggerBuilder.Create()
            //        .WithIdentity("HCNot")
            //        .WithCronSchedule(HCNotificationsCron)
            //        .Build();
            //scheduler.ScheduleJob(HCNotifications, HCNotificationsTrigger);

            //for unregistered counter
            IJobDetail unregisteredCounter = JobBuilder.Create<CheckUnregCounter>().WithIdentity("unregCounter").Build();
            ITrigger unregisteredCounterTrigger = TriggerBuilder.Create()
                    .WithIdentity("unregCounter")
                    .WithCronSchedule(hourly0MinMarkCronTab)
                    .Build();
            scheduler.ScheduleJob(unregisteredCounter, unregisteredCounterTrigger);

            //for after line settings tuned
            IJobDetail lineSettingsTuned = JobBuilder.Create<lineSettingTunedNotifications>().WithIdentity("lineSettingsTuned").Build();
            ITrigger lineSettingsTunedTrigger = TriggerBuilder.Create()
                    .WithIdentity("lineSettingsTuned")
                    .WithCronSchedule(hourly0MinMarkCronTab)
                    .Build();
            scheduler.ScheduleJob(lineSettingsTuned, lineSettingsTunedTrigger);

            IJobDetail AutoGenerateVerificationReportJob = JobBuilder.Create<AutoGenerateVerificationReport>().WithIdentity("AutoGenerateVerificationReportJob").Build();
            ITrigger AutoGenerateVerificationReportTrigger = TriggerBuilder.Create()
                    .WithIdentity("AutoGenerateVerificationReportTrigger")
                    .WithCronSchedule(autoGenerateVerificationReportCron)
                    .ForJob(AutoGenerateVerificationReportJob)
                    .Build();
            scheduler.ScheduleJob(AutoGenerateVerificationReportJob, AutoGenerateVerificationReportTrigger);
        }

        static IKernel InitializeNinjectKernel()
        {
            var kernel = new StandardKernel();
            kernel.Bind<IScheduler>().ToMethod(x =>
            {
                var sched = new StdSchedulerFactory().GetScheduler();
                sched.JobFactory = new NinjectFactory(kernel);
                return sched;
            });

            kernel.Bind<IAutoImportSettingService>().To<AutoImportSettingService>().InSingletonScope();
            kernel.Bind<IAutoImportSettingRepository>().To<AutoImportSettingRepository>().InSingletonScope();
            kernel.Bind<IAutoImportLogService>().To<AutoImportLogService>().InSingletonScope();
            kernel.Bind<IAutoImportLogRepository>().To<AutoImportLogRepository>().InSingletonScope();
            kernel.Bind<IAutoExportSettingService>().To<AutoExportSettingService>().InSingletonScope();
            kernel.Bind<IAutoExportSettingRepository>().To<AutoExportSettingRepository>().InSingletonScope();
            kernel.Bind<IAutoExportLogService>().To<AutoExportLogService>().InSingletonScope();
            kernel.Bind<IAutoExportLogRepository>().To<AutoExportLogRepository>().InSingletonScope();
            kernel.Bind<ICompanyService>().To<CompanyService>().InSingletonScope();
            kernel.Bind<ICompanyRepository>().To<CompanyRepository>().InSingletonScope();
            kernel.Bind<IFFBranchService>().To<FFBranchService>().InSingletonScope();
            kernel.Bind<IFFBranchRepository>().To<FFBranchRepository>().InSingletonScope();
            kernel.Bind<IFFCameraService>().To<FFCameraService>().InSingletonScope();
            kernel.Bind<IFFCameraRepository>().To<FFCameraRepository>().InSingletonScope();
            kernel.Bind<IFFEPosTransactionDataService>().To<FFEPosTransactionDataService>().InSingletonScope();
            kernel.Bind<IFFEPosTransactionDataRepository>().To<FFEPosTransactionDataRepository>().InSingletonScope();
            kernel.Bind<ICompanySettingService>().To<CompanySettingService>().InSingletonScope();
            kernel.Bind<ICompanySettingRepository>().To<CompanySettingRepository>().InSingletonScope();
            kernel.Bind<IUserRepository>().To<UserRepository>().InSingletonScope();
            kernel.Bind<IUserService>().To<UserService>().InSingletonScope();
            kernel.Bind<IFFUserAccessRepository>().To<FFUserAccessRepository>().InSingletonScope();
            kernel.Bind<IFFUserAccessService>().To<FFUserAccessService>().InSingletonScope();
            kernel.Bind<IFFReportSummaryDailyRepository>().To<FFReportSummaryDailyRepository>().InSingletonScope();
            kernel.Bind<IFFBranchOperatingHourRepository>().To<FFBranchOperatingHourRepository>().InSingletonScope();
            kernel.Bind<IFFCameraVersionService>().To<FFCameraVersionService>().InSingletonScope();
            kernel.Bind<IFFCameraVersionRepository>().To<FFCameraVersionRepository>().InSingletonScope();
            kernel.Bind<IFFCameraSettingService>().To<FFCameraSettingService>().InSingletonScope();
            kernel.Bind<IFFCameraSettingRepository>().To<FFCameraSettingRepository>().InSingletonScope();
            kernel.Bind<IFFCompositeService>().To<FFCompositeService>().InSingletonScope();
            kernel.Bind<IFFVideoScheduleService>().To<FFVideoScheduleService>().InSingletonScope();
            kernel.Bind<IApiActionService>().To<ApiActionService>().InSingletonScope();
            kernel.Bind<IApiActionRepository>().To<ApiActionRepository>().InSingletonScope();
            kernel.Bind<IFFDvrHealthChecksService>().To<FFDvrHealthChecksService>().InSingletonScope();
            kernel.Bind<IFFDvrHealthChecksRepository>().To<FFDvrHealthChecksRepository>().InSingletonScope();
            kernel.Bind<IFFCcHealthChecksService>().To<FFCCHealthChecksService>().InSingletonScope();
            kernel.Bind<IFFCCHealthChecksRepository>().To<FFCCHealthChecksRepository>().InSingletonScope();
            kernel.Bind<IFFVerificationStudyReportService>().To<FFVerificationStudyReportService>().InSingletonScope();
            kernel.Bind<IFFVerificationStudyReportVideoService>().To<FFVerificationStudyReportVideoService>().InSingletonScope();
            kernel.Bind<IFFVerificationStudyReportVideoRepository>().To<FFVerificationStudyReportVideoRepository>().InSingletonScope();
            kernel.Bind<IFFCameraSettingBackUpService>().To<FFCameraSettingBackUpService>().InSingletonScope();
            kernel.Bind<IFFCameraSettingBackUpRepository>().To<FFCameraSettingBackUpRepository>().InSingletonScope();
            kernel.Bind<IFFCameraSimulatorSettingService>().To<FFCameraSimulatorSettingService>().InSingletonScope();
            kernel.Bind<IFFCameraSimulatorSettingRepository>().To<FFCameraSimulatorSettingRepository>().InSingletonScope();
            kernel.Bind<IFFCameraCountingValueService>().To<FFCameraCountingValueService>().InSingletonScope();
            kernel.Bind<IFFCameraCountingValueRepository>().To<FFCameraCountingValueRepository>().InSingletonScope();
            kernel.Bind<IFFCameraWifiValueService>().To<FFCameraWifiValueService>().InSingletonScope();
            kernel.Bind<IFFCameraWifiValueRepository>().To<FFCameraWifiValueRepository>().InSingletonScope();
            kernel.Bind<IFFCameraCheckLogService>().To<FFCameraCheckLogService>().InSingletonScope();
            kernel.Bind<IFFCameraCheckLogRepository>().To<FFCameraCheckLogRepository>().InSingletonScope();
            kernel.Bind<IFFCameraWifiThresValueService>().To<FFCameraWifiThresValueService>().InSingletonScope();
            kernel.Bind<IFFCameraWifiThresValueRepository>().To<FFCameraWifiThresValueRepository>().InSingletonScope();
            kernel.Bind<IFFCameraCustomerValueService>().To<FFCameraCustomerValueService>().InSingletonScope();
            kernel.Bind<IFFCameraCustomerValueRepository>().To<FFCameraCustomerValueRepository>().InSingletonScope();
            kernel.Bind<IFFBranchOperatingHourService>().To<FFBranchOperatingHourService>().InSingletonScope();
            kernel.Bind<IFFBranchSpecialOperatingHourService>().To<FFBranchSpecialOperatingHourService>().InSingletonScope();
            kernel.Bind<IFFBranchSpecialOperatingHourRepository>().To<FFBranchSpecialOperatingHourRepository>().InSingletonScope();
            kernel.Bind<IFFCameraHourlyValueRepository>().To<FFCameraHourlyValueRepository>().InSingletonScope();
            kernel.Bind<IFFShopperHourlyValueService>().To<FFShopperHourlyValueService>().InSingletonScope();
            kernel.Bind<IFFCameraValueService>().To<FFCameraValueService>().InSingletonScope();
            kernel.Bind<IFFCameraValueRepository>().To<FFCameraValueRepository>().InSingletonScope();
            kernel.Bind<IFFReportSummaryDailyService>().To<FFReportSummaryDailyService>().InSingletonScope();
            kernel.Bind<IFFWifiFootfallCountingService>().To<FFWifiFootfallCountingService>().InSingletonScope();
            kernel.Bind<IFFWifiFootfallRepository>().To<FFWifiFootfallRepository>().InSingletonScope();
            kernel.Bind<IResellerService>().To<ResellerService>().InSingletonScope();
            kernel.Bind<IResellerRepository>().To<ResellerRepository>().InSingletonScope();
            kernel.Bind<IFFVideoScheduleRepository>().To<FFVideoScheduleRepository>().InSingletonScope();
            kernel.Bind<IFFShopperHourlyValueRepository>().To<FFShopperHourlyValueRepository>().InSingletonScope();
            kernel.Bind<IFFVerificationStudyReportRepository>().To<FFVerificationStudyReportRepository>().InSingletonScope();
            kernel.Bind<IFFCameraHourlyValueService>().To<FFCameraHourlyValueService>().InSingletonScope();
            kernel.Bind<IFFEmailReportService>().To<FFEmailReportService>().InSingletonScope();
            kernel.Bind<IFFEmailReportRepository>().To<FFEmailReportRepository>().InSingletonScope();
            kernel.Bind<IFFDashboardService>().To<FFDashboardService>().InSingletonScope();
            kernel.Bind<IFFDashboardRepository>().To<FFDashboardRepository>().InSingletonScope();
            kernel.Bind<IFFDashboardDetailService>().To<FFDashboardDetailService>().InSingletonScope();
            kernel.Bind<IFFDashboardDetailRepository>().To<FFDashboardDetailRepository>().InSingletonScope();
            kernel.Bind<IFFRecentViewService>().To<FFRecentViewService>().InSingletonScope();
            kernel.Bind<IFFRecentViewRepository>().To<FFRecentViewRepository>().InSingletonScope();
            kernel.Bind<IFFServerService>().To<FFServerService>().InSingletonScope();
            kernel.Bind<IFFServerRepository>().To<FFServerRepository>().InSingletonScope();
            kernel.Bind<IFFOutsideTrafficService>().To<FFOutsideTrafficService>().InSingletonScope();
            kernel.Bind<IFFOutsideTrafficRepository>().To<FFOutsideTrafficRepository>().InSingletonScope();
            kernel.Bind<IFFZoneHourlyService>().To<FFZoneHourlyService>().InSingletonScope();
            kernel.Bind<IFFZoneHourlyRepository>().To<FFZoneHourlyRepository>().InSingletonScope();
            kernel.Bind<IFFCameraZoneService>().To<FFCameraZoneService>().InSingletonScope();
            kernel.Bind<IFFCameraZoneRepository>().To<FFCameraZoneRepository>().InSingletonScope();
            kernel.Bind<IFFCameraHeatValueService>().To<FFCameraHeatValueService>().InSingletonScope();
            kernel.Bind<IFFCameraHeatValueRepository>().To<FFCameraHeatValueRepository>().InSingletonScope();
            kernel.Bind<ISiteTagService>().To<SiteTagService>().InSingletonScope();
            kernel.Bind<ISiteTagRepository>().To<SiteTagRepository>().InSingletonScope();
            kernel.Bind<ISerialCounterService>().To<SerialCounterService>().InSingletonScope();
            kernel.Bind<ISerialCounterRepository>().To<SerialCounterRepository>().InSingletonScope();
            kernel.Bind<IFFCommissionService>().To<FFCommissionService>().InSingletonScope();
            kernel.Bind<IFFCommissionRepository>().To<FFCommissionRepository>().InSingletonScope();
            kernel.Bind<IFFCameraVerificationStatusService>().To<FFCameraVerificationStatusService>().InSingletonScope();
            kernel.Bind<IFFCameraVerificationStatusRepository>().To<FFCameraVerificationStatusRepository>().InSingletonScope();
            kernel.Bind<IServerIdentificationService>().To<ServerIdentificationService>().InSingletonScope();
            kernel.Bind<IServerIdentificationRepository>().To<ServerIdentificationRepository>().InSingletonScope();
            kernel.Bind<IVideoConversionService>().To<VideoConversionService>().InSingletonScope();
            kernel.Bind<IVideoConversionRepository>().To<VideoConversionRepository>().InSingletonScope();
            kernel.Bind<IVerificationReportService>().To<VerificationReportService>().InSingletonScope();
            kernel.Bind<IVerificationReportRepository>().To<VerificationReportRepository>().InSingletonScope();
            kernel.Bind<ICounterHealthCheckService>().To<CounterHealthCheckService>().InSingletonScope();
            kernel.Bind<ICounterHealthCheckRepository>().To<CounterHealthCheckRepository>().InSingletonScope();
            kernel.Bind<IUpdateControlService>().To<UpdateControlService>().InSingletonScope();
            kernel.Bind<IUpdateControlRepository>().To<UpdateControlRepository>().InSingletonScope();
            kernel.Bind<IVerificationReviewerService>().To<VerificationReviewerService>().InSingletonScope();
            kernel.Bind<IVerificationReviewerRepository>().To<VerificationReviewerRepository>().InSingletonScope();
            kernel.Bind<IVerificationTunerService>().To<VerificationTunerService>().InSingletonScope();
            kernel.Bind<IVerificationTunerRepository>().To<VerificationTunerRepository>().InSingletonScope();
            kernel.Bind<IOfflineSimSettingService>().To<OfflineSimSettingService>().InSingletonScope();
            kernel.Bind<IOfflineSimSettingRepository>().To<OfflineSimSettingRepository>().InSingletonScope();
            kernel.Bind<IFFReportService>().To<FFReportService>().InSingletonScope();
            kernel.Bind<IFFReportRepository>().To<FFReportRepository>().InSingletonScope();
            kernel.Bind<IFFBranchSummaryDailyReportService>().To<FFBranchSummaryDailyReportService>().InSingletonScope();
            kernel.Bind<IFFBranchSummaryDailyReportRepository>().To<FFBranchSummaryDailyReportRepository>().InSingletonScope();
            kernel.Bind<IFFBranchSummaryHourlyReportService>().To<FFBranchSummaryHourlyReportService>().InSingletonScope();
            kernel.Bind<IFFBranchSummaryHourlyReportRepository>().To<FFBranchSummaryHourlyReportRepository>().InSingletonScope();
            kernel.Bind<IITSettingService>().To<ITSettingService>().InSingletonScope();
            kernel.Bind<IITSettingRepository>().To<ITSettingRepository>().InSingletonScope();
            kernel.Bind<IDatabaseFactory>().To<DatabaseFactory>().InSingletonScope();
            kernel.Bind<IUnitOfWork>().To<UnitOfWork>().InSingletonScope();
            kernel.Bind<INCDVRHCRepository>().To<NCDVRHCRepository>().InSingletonScope();
            kernel.Bind<IMMHealthChecksRepository>().To<MMHealthChecksRepository>().InSingletonScope();
            kernel.Bind<IMMPhotoGalleryRepository>().To<MMPhotoGalleryRepository>().InSingletonScope();
            kernel.Bind<IMMBranchRepository>().To<MMBranchRepository>().InSingletonScope();
            kernel.Bind<IMMPhotoGalleryDeletedImageRepository>().To<MMPhotoGalleryDeletedImageRepository>().InSingletonScope();
            kernel.Bind<IMMModuleRepository>().To<MMModuleRepository>().InSingletonScope();
            kernel.Bind<IMMWebPhotoGalleryRepository>().To<MMWebPhotoGalleryRepository>().InSingletonScope();
            kernel.Bind<IMMFacebookPhotoGalleryRepository>().To<MMFacebookPhotoGalleryRepository>().InSingletonScope();
            kernel.Bind<IMMCustomizationSettingRepository>().To<MMCustomizationSettingRepository>().InSingletonScope();
            kernel.Bind<IFFVideoScheduleLogRemarkRepository>().To<FFVideoScheduleLogRemarkRepository>().InSingletonScope();
            kernel.Bind<IMMCameraSettingAEModeRepository>().To<MMCameraSettingAEModeRespository>().InSingletonScope();
            kernel.Bind<IMMCameraSettingAVRepository>().To<MMCameraSettingAVRespository>().InSingletonScope();
            kernel.Bind<IMMCameraSettingTVRepository>().To<MMCameraSettingTVRespository>().InSingletonScope();
            kernel.Bind<IMMCameraSettingISORepository>().To<MMCameraSettingISORespository>().InSingletonScope();
            kernel.Bind<IMMCameraSettingRepository>().To<MMCameraSettingRespository>().InSingletonScope();
            kernel.Bind<IFFCameraCountingRecordRepository>().To<FFCameraCountingRecordRepository>().InSingletonScope();
            kernel.Bind<IMMUploadTaskRepository>().To<MMUploadTaskRepository>().InSingletonScope();
            kernel.Bind<IMMVersionRepository>().To<MMVersionRepository>().InSingletonScope();
            kernel.Bind<IMMModuleCompanyRepository>().To<MMModuleCompanyRepository>().InSingletonScope();
            kernel.Bind<IMMModuleTypeRepository>().To<MMModuleTypeRepository>().InSingletonScope();
            kernel.Bind<IFFCameraOperatingHourRepository>().To<FFCameraOperatingHourRepository>().InSingletonScope();
            kernel.Bind<IFFCameraPhotoRepository>().To<FFCameraPhotoRepository>().InSingletonScope();
            kernel.Bind<IFFCameraInstallationRepository>().To<FFCameraInstallationRepository>().InSingletonScope();
            kernel.Bind<IMMLogRespository>().To<MMLogRespository>().InSingletonScope();
            kernel.Bind<IFFEPosStaffHourRepository>().To<FFEPosStaffHourRepository>().InSingletonScope();
            kernel.Bind<IFFChatRoomMemberRepository>().To<FFChatRoomMemberRepository>().InSingletonScope();
            kernel.Bind<IFFChatRoomRepository>().To<FFChatRoomRepository>().InSingletonScope();
            kernel.Bind<IFFChatUserRepository>().To<FFChatUserRepository>().InSingletonScope();
            kernel.Bind<IFFChatMessageRepository>().To<FFChatMessageRepository>().InSingletonScope();
            kernel.Bind<IFFCrossShopperRepository>().To<FFCrossShopperRepository>().InSingletonScope();
            kernel.Bind<ICountryRepository>().To<CountryRepository>().InSingletonScope();
            kernel.Bind<IFFRemoteAccessRepository>().To<FFRemoteAccessRepository>().InSingletonScope();
            kernel.Bind<IFFPageAccessRepository>().To<FFPageAccessRepository>().InSingletonScope();
            kernel.Bind<IFFPageAccessCompanyRepository>().To<FFPageAccessCompanyRepository>().InSingletonScope();
            kernel.Bind<IStaffHoursRepository>().To<StaffHoursRepository>().InSingletonScope();
            kernel.Bind<IFFBranchFloorRepository>().To<FFBranchFloorRepository>().InSingletonScope();
            kernel.Bind<IFFZoneDailyRepository>().To<FFZoneDailyRepository>().InSingletonScope();
            kernel.Bind<IDatabaseUsageRepository>().To<DatabaseUsageRepository>().InSingletonScope();
            kernel.Bind<IFFBranchDailyPredictionRepository>().To<FFBranchDailyPredictionRepository>().InSingletonScope();
            kernel.Bind<IFFDailyPredictionRepository>().To<FFDailyPredictionRepository>().InSingletonScope();
            kernel.Bind<ICountryPriceRepository>().To<CountryPriceRepository>().InSingletonScope();
            kernel.Bind<IProductLineManagementRepository>().To<ProductLineManagementRepository>().InSingletonScope();
            kernel.Bind<ISalesLeadRepository>().To<SalesLeadRepository>().InSingletonScope();
            kernel.Bind<IReturnMerchandiseAuthorisationRepository>().To<ReturnMerchandiseAuthorisationRepository>().InSingletonScope();
            kernel.Bind<IProjectTrackerRepository>().To<ProjectTrackerRepository>().InSingletonScope();
            kernel.Bind<IFFZoneRelationRepository>().To<FFZoneRelationRepository>().InSingletonScope();
            kernel.Bind<IFFRecoveryRepository>().To<FFRecoveryRepository>().InSingletonScope();
            kernel.Bind<ICompanyCounterSettingRepository>().To<CompanyCounterSettingRepository>().InSingletonScope();
            kernel.Bind<IFFCCPUpdateZIPDetailRepository>().To<FFCCPUpdateZIPDetailRepository>().InSingletonScope();
            kernel.Bind<IUserGroupsRepository>().To<UserGroupsRepository>().InSingletonScope();
            kernel.Bind<IuserGroupsEmailRepository>().To<userGroupsEmailRepository>().InSingletonScope();
            kernel.Bind<IScheduledEmailRepository>().To<ScheduledEmailRepository>().InSingletonScope();
            kernel.Bind<IAllServerBranchRepository>().To<AllServerBranchRepository>().InSingletonScope();
            kernel.Bind<IFFBranchHourlyRawMacRepository>().To<FFBranchHourlyRawMacRepository>().InSingletonScope();
            kernel.Bind<IPagesRepository>().To<PagesRepository>().InSingletonScope();
            kernel.Bind<INCDVRHCService>().To<NCDVRHCService>().InSingletonScope();
            kernel.Bind<IMMHealthChecksService>().To<MMHealthChecksService>().InSingletonScope();
            kernel.Bind<IMMPhotoGalleryService>().To<MMPhotoGalleryService>().InSingletonScope();
            kernel.Bind<IMMBranchService>().To<MMBranchService>().InSingletonScope();
            kernel.Bind<IMMPhotoGalleryDeletedImageService>().To<MMPhotoGalleryDeletedImageService>().InSingletonScope();
            kernel.Bind<IMMModuleService>().To<MMModuleService>().InSingletonScope();
            kernel.Bind<IMMWebPhotoGalleryService>().To<MMWebPhotoGalleryService>().InSingletonScope();
            kernel.Bind<IMMFacebookPhotoGalleryService>().To<MMFacebookPhotoGalleryService>().InSingletonScope();
            kernel.Bind<IFFVideoScheduleLogRemarkService>().To<FFVideoScheduleLogRemarkService>().InSingletonScope();
            kernel.Bind<IMMCameraSettingAEModeService>().To<MMCameraSettingAEModeService>().InSingletonScope();
            kernel.Bind<IMMCameraSettingAVService>().To<MMCameraSettingAVService>().InSingletonScope();
            kernel.Bind<IMMCameraSettingTVService>().To<MMCameraSettingTVService>().InSingletonScope();
            kernel.Bind<IMMCameraSettingISOService>().To<MMCameraSettingISOService>().InSingletonScope();
            kernel.Bind<IMMCameraSettingService>().To<MMCameraSettingService>().InSingletonScope();
            kernel.Bind<IFFCameraCountingRecordService>().To<FFCameraCountingRecordService>().InSingletonScope();
            kernel.Bind<IMMUploadTaskService>().To<MMUploadTaskService>().InSingletonScope();
            kernel.Bind<IMMVersionService>().To<MMVersionService>().InSingletonScope();
            kernel.Bind<IMMModuleCompanyService>().To<MMModuleCompanyService>().InSingletonScope();
            kernel.Bind<IMMModuleTypeService>().To<MMModuleTypeService>().InSingletonScope();
            kernel.Bind<IFFCameraOperatingHourService>().To<FFCameraOperatingHourService>().InSingletonScope();
            kernel.Bind<IFFCameraPhotoService>().To<FFCameraPhotoService>().InSingletonScope();
            kernel.Bind<IFFCameraInstallationService>().To<FFCameraInstallationService>().InSingletonScope();
            kernel.Bind<IMMLogService>().To<MMLogService>().InSingletonScope();
            kernel.Bind<IUserGroupsService>().To<UserGroupsService>().InSingletonScope();
            kernel.Bind<IUserGroupsEmailService>().To<userGroupsEmailService>().InSingletonScope();
            kernel.Bind<IScheduledEmailService>().To<ScheduledEmailServices>().InSingletonScope();
            kernel.Bind<IAllServerBranchService>().To<AllServerBranchService>().InSingletonScope();
            kernel.Bind<IFFEPosStaffHourService>().To<FFEPosStaffHourService>().InSingletonScope();
            kernel.Bind<IFFChatMessageService>().To<FFChatMessageService>().InSingletonScope();
            kernel.Bind<IFFChatRoomMemberService>().To<FFChatRoomMemberService>().InSingletonScope();
            kernel.Bind<IFFChatRoomService>().To<FFChatRoomService>().InSingletonScope();
            kernel.Bind<IFFChatUserService>().To<FFChatUserService>().InSingletonScope();
            kernel.Bind<IFFCrossShopperService>().To<FFCrossShopperService>().InSingletonScope();
            kernel.Bind<ICountryService>().To<CountryService>().InSingletonScope();
            kernel.Bind<IFFPageAccessService>().To<FFPageAccessService>().InSingletonScope();
            kernel.Bind<IFFPageAccessCompanyService>().To<FFPageAccessCompanyService>().InSingletonScope();
            kernel.Bind<IStaffHoursService>().To<StaffHoursService>().InSingletonScope();
            kernel.Bind<IFFBranchFloorService>().To<FFBranchFloorService>().InSingletonScope();
            kernel.Bind<IFFZoneDailyService>().To<FFZoneDailyService>().InSingletonScope();
            kernel.Bind<IDatabaseUsageService>().To<DatabaseUsageService>().InSingletonScope();
            kernel.Bind<IFFBranchDailyPredictionService>().To<FFBranchDailyPredictionService>().InSingletonScope();
            kernel.Bind<IFFDailyPredictionService>().To<FFDailyPredictionService>().InSingletonScope();
            kernel.Bind<ICountryPriceService>().To<CountryPriceService>().InSingletonScope();
            kernel.Bind<IProductLineManagementService>().To<ProductLineManagementService>().InSingletonScope();
            kernel.Bind<ISalesLeadService>().To<SalesLeadService>().InSingletonScope();
            kernel.Bind<IReturnMerchandiseAuthorisationService>().To<ReturnMerchandiseAuthorisationService>().InSingletonScope();
            kernel.Bind<IProjectTrackerService>().To<ProjectTrackerService>().InSingletonScope();
            kernel.Bind<IFFZoneRelationService>().To<FFZoneRelationService>().InSingletonScope();
            kernel.Bind<IFFRecoveryService>().To<FFRecoveryService>().InSingletonScope();
            kernel.Bind<IFFRemoteAccessService>().To<FFRemoteAccessService>().InSingletonScope();
            kernel.Bind<ICompanyCounterSettingService>().To<CompanyCounterSettingService>().InSingletonScope();
            kernel.Bind<IFFCCPUpdateZIPDetailService>().To<FFCCPUpdateZIPDetailService>().InSingletonScope();
            kernel.Bind<IFFBranchHourlyRawMacService>().To<FFBranchHourlyRawMacService>().InSingletonScope();
            kernel.Bind<IPagesService>().To<PagesService>().InSingletonScope();
            kernel.Bind<INCCompositeService>().To<NCCompositeService>().InSingletonScope();
            kernel.Bind<IApiActionCompositeService>().To<ApiActionCompositeService>().InSingletonScope();
            kernel.Bind<IAccountService>().To<AccountService>().InSingletonScope();
            kernel.Bind<IMMCompositeService>().To<MMCompositeService>().InSingletonScope();
            kernel.Bind<IMMCameraSettingCompositeService>().To<MMCameraSettingCompositeService>().InSingletonScope();
            kernel.Bind<IFFChatCompositeService>().To<FFChatCompositeService>().InSingletonScope();
            kernel.Bind<IZoneService>().To<ZoneService>().InSingletonScope();
            kernel.Bind<IZoneRepository>().To<ZoneRepository>().InSingletonScope();
            kernel.Bind<IAllServerCompanyService>().To<AllServerCompanyService>().InSingletonScope();
            kernel.Bind<IAllServerCompanyRepository>().To<AllServerCompanyRepository>().InSingletonScope();
            kernel.Bind<IBranchOperatingHourArchiveService>().To<FFBranchOperatingHourArchiveService>().InSingletonScope();
            kernel.Bind<IBranchOperatingHourArchiveRepository>().To<FFBranchOperatingHourArchiveRepository>().InSingletonScope();

            return kernel;
        }
    }
}