﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Quartz;
using Quartz.Simpl;
using Quartz.Spi;
using Ninject;

namespace RetailCamControlPanel.Quartz
{
    public class NinjectFactory : SimpleJobFactory
    {
        readonly IKernel _kernel;

        public NinjectFactory(IKernel kernel) {
            this._kernel = kernel;
        }

        public override IJob NewJob(TriggerFiredBundle bundle, IScheduler scheduler)
        {
            return (IJob)this._kernel.Get(bundle.JobDetail.JobType);
        }
    }
}