﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Quartz;
using RetailCamControlPanel.Services.SingularService;
using RetailCamControlPanel.Models;
using RetailCamControlPanel.ViewModel;
using System.Configuration;
using System.IO;
using RetailCamControlPanel.Helper;
using FluentFTP;
using System.Globalization;
using System.Web.Mvc;
using RetailCamControlPanel.Controllers;

namespace RetailCamControlPanel.Quartz
{
    [DisallowConcurrentExecution]
    public class tmpAutoExportHourlyData : IJob
    {
        private readonly IFFCameraService cameraService;
        private readonly IFFCameraHourlyValueService cameraHourlyValueService;
        private readonly IFFBranchService branchService;
        private readonly IFFBranchOperatingHourService branchOperatingHourService;
        private readonly IServerIdentificationService serverIdentificationService;
        //
        private string isLocalDebug = ConfigurationManager.AppSettings["IsLocalDebug"];
        private string ControlPanelDir = Utility.Root();

        public tmpAutoExportHourlyData(IFFCameraService cameraService, IFFCameraHourlyValueService cameraHourlyValueService, IFFBranchService branchService, IFFBranchOperatingHourService branchOperatingHourService, IServerIdentificationService serverIdentificationService)
        {
            this.cameraService = cameraService;
            this.cameraHourlyValueService = cameraHourlyValueService;
            this.branchService = branchService;
            this.branchOperatingHourService = branchOperatingHourService;
            this.serverIdentificationService = serverIdentificationService;
        }
        public void Execute(IJobExecutionContext context) {
            if (String.IsNullOrEmpty(isLocalDebug))
            {
                isLocalDebug = "1";
            }
            if (isLocalDebug == "1")
            {
                return;
            }
            else
            {
                //write log once job is triggered
                var a = DateTime.Now;
                var logPath = "LogFileForMarionnaud\\";
                var tempLogPath = ControlPanelDir + logPath;
                if (!Directory.Exists(tempLogPath))
                {
                    Directory.CreateDirectory(tempLogPath);
                }

                var logPathName = tempLogPath + a.Day + "_" + a.Hour + "_" + a.Minute + "_" + a.Second + ".txt";
                using (StreamWriter file = new StreamWriter(logPathName))
                {
                    file.WriteLine("Run at " + a);
                    file.Close();
                }

                // ** ONLY FOR TEMPORARY SOLUTION. PERSONALLY DO NOT RECOMMAND THIS AUTOMATION
                // ** To retrive hourly data, and create a txt file into a FTP Directory within operating hour
                // ** WE DO NOT CALCULATE SPECIAL OPERATING HOUR IN THIS CASE
                // ** SFTP 
                // ** Only Run in Footfallcam Server
                // username: MarionnaudFrance
                // password: Ba%$Z9g3THSghf8$
                // port: 1555
                // host: 91.109.10.77
                // Write into a text file
                // ** File Name Format: MarionnaudFrance_01_20180526_023000.txt
                //
                // Always check operating hour first
                // Marionnaud France's branchid is 3422
                try
                {
                    var allCam = cameraService.GetCameras(w => w.CompanyCode == "MarionnaudFrance").OrderBy(w => w.BranchId).ToList();
                    var branchId = allCam.Select(s => s.BranchId).ToList();
                    var serverIdentification = serverIdentificationService.ThisServer();
                    if (serverIdentification.GUID != "36E75A14-4908-439B-ACE0-1658BE480864")
                    {
                        // Not Footfallcam server GUID, return
                        return;
                    }

                    var camera = allCam[0];
                    var firstBranch = branchService.GetBranch(camera.BranchId);
                    //var operatingHour = branchOperatingHourService.GetBranchOperatingHourByBranchId(firstBranch.ID);
                    //get time zone of the branch
                    var timeZoneNow = OlsonTimeZoneToTimeZoneInfo(firstBranch.Timezone);
                    //var nameNow = timeZoneNow.StandardName;
                    DateTime todayDateTime = TimeZoneInfo.ConvertTime(DateTime.UtcNow, timeZoneNow);
                    var todayDaytime = Convert.ToInt16(todayDateTime.DayOfWeek);
                    //var earliestOH = branchOperatingHourService.GetStoreOperatingHours(branchId).Where(w => w.isDayOff == false).Select(s => s.StartTime).Min();
                    //var latestOH = branchOperatingHourService.GetStoreOperatingHours(branchId).Where(w => w.isDayOff == false).Select(s => s.EndTime).Max();

                    var tmp = "tmpMarionnaudFranceHourlyData\\";
                    var tmpFilePATH = ControlPanelDir + tmp;
                    if (!Directory.Exists(tmpFilePATH))
                    {
                        Directory.CreateDirectory(tmpFilePATH);
                    }
                    // Declare current txt file name 
                    var Path = tmpFilePATH + "MarionnaudFrance_" + todayDateTime.Year.ToString() + todayDateTime.Month.ToString("00") + todayDateTime.Day.ToString("00") + "_" + todayDateTime.Hour.ToString("00") + "05" + "00" + ".txt";

                    var line = string.Format("{0};{1};{2};{3};{4};{5};{6};{7};{8}", "CA_Mag", "num_borne", "CA_Date", "CA_Heure", "CA_Comptage_In", "CA_Comptage_Out", "Cumul_Comptage_In", "Cumul_Comptage_Out", "Type");
                    for (var count = 0; count < allCam.Count(); count ++)
                    {
                        var cam = allCam[count];
                        var branch = branchService.GetBranch(cam.BranchId);
                        var operatingHour = branchOperatingHourService.GetBranchOperatingHourByBranchId(branch.ID);
                        //get time zone of the branch
                        var timeZone = OlsonTimeZoneToTimeZoneInfo(branch.Timezone);
                        var name = timeZone.StandardName;

                        //DateTime todayDateTime = TimeZoneInfo.ConvertTime(DateTime.UtcNow, timeZone);
                        //var todayDaytime = Convert.ToInt16(todayDateTime.DayOfWeek);
                        var todayOperatingHour = operatingHour.Find(w => w.Day == todayDaytime);
                        //if (todayOperatingHour.isDayOff)
                        //{
                        //    // Off day, return
                        //    break;
                        //}

                        DateTime previoushourdatetime = todayDateTime.AddHours(-1);
                        DateTime newDateTime = todayDateTime.Date;
                        TimeSpan ts = new TimeSpan(previoushourdatetime.Hour, 0, 0);
                        DateTime sDate = newDateTime + ts;
                        //DateTime sDate = new DateTime(2019, 05, 23, 14, 00, 00);
                        // Today Operating Hour Start Date Time
                        TimeSpan operatingHourStartTime = new TimeSpan(0,0,0);
                        DateTime todayOperatingHourStartDateTime = newDateTime + operatingHourStartTime;
                        // Today Operating Hour End Date Time
                        TimeSpan operatingHourEndTime = new TimeSpan(23,0,0);
                        DateTime todayOperatingHourEndDateTime = newDateTime + operatingHourEndTime;

                        var countingdata = cameraHourlyValueService.GetCameraHourlyValue(w => w.CameraId == cam.ID && w.ValueDateTime == sDate);
                        var todayCountingDatas = cameraHourlyValueService.GetCountingList(w => w.CameraId == cam.ID && w.ValueDateTime >= todayOperatingHourStartDateTime && w.ValueDateTime <= todayOperatingHourEndDateTime).ToList();
                        //var cumulative in and out
                        int cumulativeIn = 0;
                        int cumulativeOut = 0;
                        foreach (var todayCountingData in todayCountingDatas)
                        {
                            cumulativeIn += todayCountingData.ValueIn;
                            cumulativeOut += todayCountingData.ValueOut;
                        }
                        if (countingdata == null)
                        {
                            countingdata = new FFCameraHourlyValue();
                            countingdata.ValueIn = 0;
                            countingdata.ValueOut = 0;
                        }
                        // To Convert date and time based on their requirements
                        DateTime txtTime = new DateTime(1900, 1, 1, 0, 0, 0);
                        DateTime txtDate = new DateTime(todayDateTime.Year, todayDateTime.Month, todayDateTime.Day, 0, 0, 0);
                        txtTime = txtTime + ts;
                        var stringtxtTime = txtTime.AddHours(1).ToString("yyyy-MM-dd HH:mm:ss.fff");
                        var stringtxtDate = txtDate.ToString("yyyy-MM-dd HH:mm:ss");
                        // A proper way to writeline in a string.format method
                        line += Environment.NewLine + string.Format("{0};{1};{2};{3};{4};{5};{6};{7};EXT", cam.BranchCode, cam.CameraName, stringtxtDate, stringtxtTime, countingdata.ValueIn.ToString(), countingdata.ValueOut.ToString(), cumulativeIn.ToString(), cumulativeOut.ToString());
                    }

                    //write file after appending all string
                    writeIntoFile(line, Path, todayDateTime);
                    checkFileExist(todayDateTime, tmpFilePATH,allCam);
                }
                catch (Exception e)
                {
                    e.WriteExceptionLog("Marionnaud France Export Job Exception");
                }
            }
        }

        private void writeIntoFile(string line,string path,DateTime todayDateTime)
        {
            try
            {
                if (!string.IsNullOrEmpty(line))
                {
                    var lineNum = line.Split('\n').Length;
                    if (lineNum > 1)
                    {
                        if (File.Exists(path))
                        {
                            File.Delete(path);
                            using (StreamWriter file = new StreamWriter(path, true))
                            {
                                file.Write(line);
                                file.Close();
                            }
                        }
                        else
                        {
                            using (StreamWriter file = new StreamWriter(path, true))
                            {
                                file.Write(line);
                                file.Close();
                            }
                        }
                    }
                }

                var today = DateTime.Now.Year.ToString("0000") + "-" + DateTime.Now.Month.ToString("00") + "-" + DateTime.Now.Day.ToString("00");
                var fileToCheck = Utility.Root() + "FileToCheckForMarionnaud\\";

                if (!Directory.Exists(fileToCheck))
                {
                    Directory.CreateDirectory(fileToCheck);
                }

                var fileNameToCheck = fileToCheck + today + ".txt";
                using (StreamWriter file = File.AppendText(fileNameToCheck))
                {
                    file.WriteLine(todayDateTime.Hour.ToString("00") + "0500");
                    file.Close();
                }
            }
            catch (Exception e)
            {
                e.WriteExceptionLog("Marionnaud France Failed to write into file.");
            }
        }

        //checking files created for every hours or not
        public void checkFileExist(DateTime todayDateTime,string tmpFilePATH, List<FFCamera> allCam)
        {
            var today = DateTime.Now.Year.ToString("0000") + "-" + DateTime.Now.Month.ToString("00") + "-" + DateTime.Now.Day.ToString("00");
            var todayDaytime = Convert.ToInt16(todayDateTime.DayOfWeek);
            var fileToCheck = Utility.Root() + "FileToCheckForMarionnaud\\";

            if (Directory.Exists(fileToCheck))
            {
                var fileNameToCheck = fileToCheck + today + ".txt";
                if (File.Exists(fileNameToCheck))
                {
                    var hours = File.ReadAllLines(fileNameToCheck);
                    var todayChecking = todayDateTime.Year.ToString("00") + todayDateTime.Month.ToString("00") + todayDateTime.Day.ToString("00");
                    if (hours.Count() != todayDateTime.Hour + 1)
                    {
                        for (var i = 0; i < todayDateTime.Hour + 1; i++)
                        {
                            var myFile = hours.Where(w => w.Contains(i.ToString("00") + "0500")).ToList();
                            if (myFile.Count() > 0)
                            {
                                continue;
                            }
                            else
                            {
                                var newFilePath = tmpFilePATH + "MarionnaudFrance_" + todayChecking + "_" + i.ToString("00") + "05" + "00" + ".txt";
                                var newline = string.Format("{0};{1};{2};{3};{4};{5};{6};{7};{8}", "CA_Mag", "num_borne", "CA_Date", "CA_Heure", "CA_Comptage_In", "CA_Comptage_Out", "Cumul_Comptage_In", "Cumul_Comptage_Out", "Type");
                                for (var count = 0; count < allCam.Count(); count++)
                                {
                                    var cam = allCam[count];
                                    var branch = branchService.GetBranch(cam.BranchId);
                                    var operatingHour = branchOperatingHourService.GetBranchOperatingHourByBranchId(branch.ID);
                                    //get time zone of the branch
                                    var timeZone = OlsonTimeZoneToTimeZoneInfo(branch.Timezone);
                                    var name = timeZone.StandardName;

                                    var todayOperatingHour = operatingHour.Find(w => w.Day == todayDaytime);

                                    DateTime previoushourdatetime = todayDateTime.AddHours(-1);
                                    DateTime newDateTime = todayDateTime.Date;
                                    TimeSpan ts = new TimeSpan(i, 0, 0);
                                    DateTime sDate = newDateTime + ts;
                                    DateTime newDate = sDate.AddHours(-1);

                                    //Operating Hours to be 24 hours (no need to consider operating hours)
                                    TimeSpan operatingHourStartTime = new TimeSpan(0, 0, 0);
                                    DateTime todayOperatingHourStartDateTime = newDateTime + operatingHourStartTime;
                                    TimeSpan operatingHourEndTime = new TimeSpan(23, 0, 0);
                                    DateTime todayOperatingHourEndDateTime = newDateTime + operatingHourEndTime;

                                    var countingdata = cameraHourlyValueService.GetCameraHourlyValue(w => w.CameraId == cam.ID && w.ValueDateTime == newDate);
                                    var todayCountingDatas = cameraHourlyValueService.GetCountingList(w => w.CameraId == cam.ID && w.ValueDateTime >= todayOperatingHourStartDateTime && w.ValueDateTime < sDate).ToList();
                                    //var cumulative in and out
                                    int cumulativeIn = 0;
                                    int cumulativeOut = 0;
                                    foreach (var todayCountingData in todayCountingDatas)
                                    {
                                        cumulativeIn += todayCountingData.ValueIn;
                                        cumulativeOut += todayCountingData.ValueOut;
                                    }
                                    if (countingdata == null)
                                    {
                                        countingdata = new FFCameraHourlyValue();
                                        countingdata.ValueIn = 0;
                                        countingdata.ValueOut = 0;
                                    }
                                    // To Convert date and time based on their requirements
                                    DateTime txtTime = new DateTime(1900, 1, 1, 0, 0, 0);
                                    DateTime txtDate = new DateTime(todayDateTime.Year, todayDateTime.Month, todayDateTime.Day, 0, 0, 0);
                                    txtTime = txtTime + ts;
                                    var stringtxtTime = txtTime.ToString("yyyy-MM-dd HH:mm:ss.fff");
                                    var stringtxtDate = txtDate.ToString("yyyy-MM-dd HH:mm:ss");
                                    // A proper way to writeline in a string.format method
                                    newline += Environment.NewLine + string.Format("{0};{1};{2};{3};{4};{5};{6};{7};EXT", cam.BranchCode, cam.CameraName, stringtxtDate, stringtxtTime, countingdata.ValueIn.ToString(), countingdata.ValueOut.ToString(), cumulativeIn.ToString(), cumulativeOut.ToString());
                                }

                                writeIntoFile(newline, newFilePath,new DateTime(todayDateTime.Year,todayDateTime.Month,todayDateTime.Day,i,0,0));
                            }
                        }
                    }
                }
            }
        }

        public static TimeZoneInfo OlsonTimeZoneToTimeZoneInfo(string olsonTimeZoneId)
        {
            var olsonWindowsTimes = new Dictionary<string, string>()
            {
                { "Africa/Bangui", "W. Central Africa Standard Time" },
                { "Africa/Cairo", "Egypt Standard Time" },
                { "Africa/Casablanca", "Morocco Standard Time" },
                { "Africa/Harare", "South Africa Standard Time" },
                { "Africa/Johannesburg", "South Africa Standard Time" },
                { "Africa/Lagos", "W. Central Africa Standard Time" },
                { "Africa/Monrovia", "Greenwich Standard Time" },
                { "Africa/Nairobi", "E. Africa Standard Time" },
                { "Africa/Windhoek", "Namibia Standard Time" },
                { "America/Anchorage", "Alaskan Standard Time" },
                { "America/Argentina", "Argentina Standard Time" },
                { "America/Asuncion", "Paraguay Standard Time" },
                { "America/Bahia", "Bahia Standard Time" },
                { "America/Bogota", "SA Pacific Standard Time" },
                { "America/Buenos_Aires", "Argentina Standard Time" },
                { "America/Caracas", "Venezuela Standard Time" },
                { "America/Cayenne", "SA Eastern Standard Time" },
                { "America/Chicago", "Central Standard Time" },
                { "America/Chihuahua", "Mountain Standard Time (Mexico)" },
                { "America/Boise", "MST Mountain Standard Time" },
                { "America/Cuiaba", "Central Brazilian Standard Time" },
                { "America/Denver", "Mountain Standard Time" },
                { "America/Fortaleza", "SA Eastern Standard Time" },
                { "America/Godthab", "Greenland Standard Time" },
                { "America/Guatemala", "Central Standard Time (Mexico)" },
                { "America/Halifax", "Atlantic Standard Time" },
                { "America/Glace_Bay", "Atlantic Standard Time" },
                { "America/Indianapolis", "US Eastern Standard Time" },
                { "America/Indiana/Indianapolis", "US Eastern Standard Time" },
                { "America/La_Paz", "SA Western Standard Time" },
                { "America/Los_Angeles", "Pacific Standard Time" },
                { "America/Mexico_City", "Central Standard Time (Mexico)" },
                { "America/Montevideo", "Montevideo Standard Time" },
                { "America/New_York", "Eastern Standard Time" },
                { "America/Noronha", "UTC-02" },
                { "America/Phoenix", "US Mountain Standard Time" },
                { "America/Regina", "Central Standard Time" },
                { "America/Santa_Isabel", "Pacific Standard Time (Mexico)" },
                { "America/Santiago", "Pacific SA Standard Time" },
                { "America/Sao_Paulo", "E. South America Standard Time" },
                { "America/St_Johns", "Newfoundland Standard Time" },
                { "America/Tijuana", "Pacific Standard Time" },
                { "America/Dawson", "Pacific Standard Time" },
                { "America/Detroit", "Eastern Standard Time" },
                { "Antarctica/McMurdo", "New Zealand Standard Time" },
                { "Atlantic/South_Georgia", "UTC-02" },
                { "Asia/Almaty", "Central Asia Standard Time" },
                { "Asia/Amman", "Jordan Standard Time" },
                { "Asia/Baghdad", "Arabic Standard Time" },
                { "Asia/Baku", "Azerbaijan Standard Time" },
                { "Asia/Bangkok", "SE Asia Standard Time" },
                { "Asia/Beirut", "Middle East Standard Time" },
                { "Asia/Calcutta", "India Standard Time" },
                { "Asia/Colombo", "Sri Lanka Standard Time" },
                { "Asia/Damascus", "Syria Standard Time" },
                { "Asia/Dhaka", "Bangladesh Standard Time" },
                { "Asia/Dubai", "Arabian Standard Time" },
                { "Asia/Irkutsk", "North Asia East Standard Time" },
                { "Asia/Jerusalem", "Israel Standard Time" },
                { "Europe/Kaliningrad", "Kaliningrad Standard Time" },
                { "Europe/Samara", "Russia Time Zone 3" },
                { "Africa/Tripoli", "Libya Standard Time" },
                { "Asia/Kabul", "Afghanistan Standard Time" },
                { "Asia/Ashgabat", "West Asia Standard Time" },
                { "Asia/Kamchatka", "Kamchatka Standard Time" },
                { "Asia/Karachi", "Pakistan Standard Time" },
                { "Asia/Katmandu", "Nepal Standard Time" },
                { "Asia/Kolkata", "India Standard Time" },
                { "Asia/Krasnoyarsk", "North Asia Standard Time" },
                { "Asia/Kuala_Lumpur", "Singapore Standard Time" },
                { "Asia/Chongqing", "Singapore Standard Time" },
                { "Asia/Kuwait", "Arab Standard Time" },
                { "Asia/Magadan", "Magadan Standard Time" },
                { "Asia/Muscat", "Arabian Standard Time" },
                { "Asia/Novosibirsk", "N. Central Asia Standard Time" },
                { "Asia/Oral", "West Asia Standard Time" },
                { "Asia/Pyongyang", "North Korea Standard Time" },
                { "Asia/Rangoon", "Myanmar Standard Time" },
                { "Asia/Riyadh", "Arab Standard Time" },
                { "Asia/Seoul", "Korea Standard Time" },
                { "Asia/Shanghai", "China Standard Time" },
                { "Asia/Singapore", "Singapore Standard Time" },
                { "Asia/Taipei", "Taipei Standard Time" },
                { "Asia/Tashkent", "West Asia Standard Time" },
                { "Asia/Tbilisi", "Georgian Standard Time" },
                { "Asia/Tehran", "Iran Standard Time" },
                { "Asia/Tokyo", "Tokyo Standard Time" },
                { "Asia/Ulaanbaatar", "Ulaanbaatar Standard Time" },
                { "Asia/Vladivostok", "Vladivostok Standard Time" },
                { "Asia/Yakutsk", "Yakutsk Standard Time" },
                { "Asia/Yekaterinburg", "Ekaterinburg Standard Time" },
                { "Asia/Yerevan", "Caucasus Standard Time" },
                { "Atlantic/Azores", "Azores Standard Time" },
                { "Atlantic/Cape_Verde", "Cape Verde Standard Time" },
                { "Atlantic/Reykjavik", "Greenwich Standard Time" },
                { "Australia/Adelaide", "Cen. Australia Standard Time" },
                { "Australia/Brisbane", "E. Australia Standard Time" },
                { "Australia/Darwin", "AUS Central Standard Time" },
                { "Australia/Hobart", "Tasmania Standard Time" },
                { "Australia/Perth", "W. Australia Standard Time" },
                { "Australia/Sydney", "AUS Eastern Standard Time" },
                { "UTC", "UTC" },
                { "Etc/GMT", "UTC" },
                { "Etc/GMT+11", "UTC-11" },
                { "Etc/GMT+12", "Dateline Standard Time" },
                { "Etc/GMT+2", "Syria Standard Time" },
                { "Etc/GMT-12", "UTC+12" },
                { "Etc/GMT-11", "Central Pacific Standard Time" },
                { "Europe/Amsterdam", "W. Europe Standard Time" },
                { "Europe/Athens", "GTB Standard Time" },
                { "Europe/Belgrade", "Central Europe Standard Time" },
                { "Europe/Berlin", "W. Europe Standard Time" },
                { "Europe/Brussels", "Romance Standard Time" },
                { "Europe/Budapest", "Central Europe Standard Time" },
                { "Europe/Dublin", "GMT Standard Time" },
                { "Europe/Helsinki", "FLE Standard Time" },
                { "Europe/Istanbul", "GTB Standard Time" },
                { "Europe/Kiev", "FLE Standard Time" },
                { "Europe/London", "GMT Standard Time" },
                { "Europe/Minsk", "Belarus Standard Time" },
                { "Europe/Moscow", "Russian Standard Time" },
                { "Europe/Paris", "Romance Standard Time" },
                { "Europe/Sarajevo", "Central European Standard Time" },
                { "Europe/Warsaw", "Central European Standard Time" },
                { "Indian/Mauritius", "Mauritius Standard Time" },
                { "Pacific/Kiritimati", "Line Islands Standard Time" },
                { "Pacific/Apia", "Samoa Standard Time" },
                { "Pacific/Auckland", "New Zealand Standard Time" },
                { "Pacific/Fiji", "Fiji Standard Time" },
                { "Pacific/Guadalcanal", "Central Pacific Standard Time" },
                { "Asia/Anadyr", "Russia Time Zone 11" },
                { "Pacific/Guam", "West Pacific Standard Time" },
                { "Pacific/Honolulu", "Hawaiian Standard Time" },
                { "Pacific/Fakaofo", "Hawaiian Standard Time" },
                { "Pacific/Pago_Pago", "UTC-11" },
                { "Pacific/Port_Moresby", "West Pacific Standard Time" },
                { "Pacific/Tongatapu", "Tonga Standard Time" },
                { "EET", "Eastern European Time" },
                { "Etc/GMT-2", "South Africa Standard Time" },


    };

            var windowsTimeZoneId = default(string);
            var windowsTimeZone = default(TimeZoneInfo);
            if (olsonWindowsTimes.TryGetValue(olsonTimeZoneId, out windowsTimeZoneId))
            {
                try { windowsTimeZone = TimeZoneInfo.FindSystemTimeZoneById(windowsTimeZoneId); }
                catch (TimeZoneNotFoundException) { }
                catch (InvalidTimeZoneException) { }
            }
            return windowsTimeZone;
        }


    }
}