@echo off
setlocal enabledelayedexpansion

SET getInstallPath=%~dp0
SET installPath=%getInstallPath:~0,-18%

::get current version number
for /f "delims=" %%x in (%installPath%\RccpBackup\Tools\version) do set currentVersionNumber=%%x

echo Current RCCP version: %currentVersionNumber%
set /a counter=%currentVersionNumber%

:increaseby1
set /a counter+=1
set newUpdateVersionNumber=%counter%
::get latest version number

::use %newUpdateVersionNumber% to get the latestZip
echo New RCCP version to be updated: %newUpdateVersionNumber%

::go into update_archive folder to find the zip
cd /D %installPath%\RccpBackup\Update_Archive
::get count of the ZIP with same version number
set /a updateZIPCount=0

for /r %%i in (*) do (
	for /f "tokens=3 delims=_" %%a in ("%%~nxi") do (
		if %%a==%newUpdateVersionNumber% (
			set /a updateZIPCount+=1
		)
	)
)

if %updateZIPCount%==0 (
	set updateFailedReason=Unable to get expected version of update ZIP
	set updateStatus=Unsuccessful
	echo Unable to get expected version of update ZIP
	echo Result: Update unsuccessful
	call "%installPath%\RccpBackup\Tools\update_log.bat"
)

if %updateZIPCount% == 1 (
	call "%installPath%\RccpBackup\Tools\update_control_panel.bat"
) 

if %updateZIPCount% GTR 1 (
	set updateFailedReason=Multiple ZIP package with the same version found
	set updateStatus=Unsuccessful
	echo Multiple ZIP package with the same version found
	echo Result: Update unsuccessful
	call "%installPath%\RccpBackup\Tools\update_log.bat"
)

::pause






