@echo off
setlocal enabledelayedexpansion
rem net stop FFC_WinSvc

SET getInstallPath=%~dp0
SET installPath=%getInstallPath:~0,-18%
CALL "%installPath%\RccpBackup\Tools\stop_FFC_WinSvc.bat"
::get current version number
for /f "delims=" %%x in (%installPath%\RccpBackup\Tools\version_ffc_winsvc) do set currentVersionNumber=%%x

echo Current FFC_WinSvc version: %currentVersionNumber%
set /a counter=%currentVersionNumber%

:increaseby1
set /a counter+=1
set newUpdateVersionNumber=%counter%
::get latest version number

::use %newUpdateVersionNumber% to get the latestZip
echo New FFC_WinSvc version to be updated: %newUpdateVersionNumber%

SET getInstallPath=%~dp0
SET installPath=%getInstallPath:~0,-18%

::go into update_archive folder to find the zip
cd /D %installPath%\RccpBackup\Update_Archive_FFC_WinSvc
::get count of the ZIP with same version number
set /a updateZIPCount=0

for /r %%i in (*) do (
	for /f "tokens=5 delims=_" %%a in ("%%~nxi") do (
		if %%a==%newUpdateVersionNumber% (
			set /a updateZIPCount+=1
		)
	)
)

if %updateZIPCount%==0 (
	set updateFailedReason=Unable to get expected version of update ZIP
	set updateStatus=Unsuccessful
	echo Unable to get expected version of update ZIP
	echo Result: Update unsuccessful
	call "%installPath%\RccpBackup\Tools\update_log_FFC_WinSvc.bat"
)

if %updateZIPCount% == 1 (
	call "%installPath%\RccpBackup\Tools\update_FFC_WinSvc.bat"
) 

if %updateZIPCount% GTR 1 (
	set updateFailedReason=Multiple ZIP package with the same version found
	set updateStatus=Unsuccessful
	echo Multiple ZIP package with the same version found
	echo Result: Update unsuccessful
	call "%installPath%\RccpBackup\Tools\update_log_FFC_WinSvc.bat"
)

::pause






