@echo off
setlocal enabledelayedexpansion
SET getInstallPath=%~dp0
SET installPath=%getInstallPath:~0,-18%

::get current version number
for /f "delims=" %%x in (%installPath%\RccpBackup\Tools\version_predictive_analytic) do set currentVersionNumber=%%x

echo Current PredictiveAnalytic version: %currentVersionNumber%
set /a counter=%currentVersionNumber%

:increaseby1
set /a counter+=1
set newUpdateVersionNumber=%counter%
::get latest version number

::use %newUpdateVersionNumber% to get the latestZip
echo New PredictiveAnalytic version to be updated: %newUpdateVersionNumber%

SET getInstallPath=%~dp0
SET installPath=%getInstallPath:~0,-18%

::go into update_archive folder to find the zip
cd /D %installPath%\RccpBackup\Update_Archive_Predictive_Analytic
::get count of the ZIP with same version number
set /a updateZIPCount=0

for /r %%i in (*) do (
	for /f "tokens=5 delims=_" %%a in ("%%~nxi") do (
		if %%a==%newUpdateVersionNumber% (
			set /a updateZIPCount+=1
		)
	)
)

if %updateZIPCount%==0 (
	set updateFailedReason=Unable to get expected version of update ZIP
	set updateStatus=Unsuccessful
	echo Unable to get expected version of update ZIP
	echo Result: Update unsuccessful
	call "%installPath%\RccpBackup\Tools\update_log_Predictive_Analytic.bat"
)

if %updateZIPCount% == 1 (
	call "%installPath%\RccpBackup\Tools\update_Predictive_Analytic.bat"
) 

if %updateZIPCount% GTR 1 (
	set updateFailedReason=Multiple ZIP package with the same version found
	set updateStatus=Unsuccessful
	echo Multiple ZIP package with the same version found
	echo Result: Update unsuccessful
	call "%installPath%\RccpBackup\Tools\update_log_Predictive_Analytic.bat"
)

::pause






