@echo off
reg Query "HKLM\Hardware\Description\System\CentralProcessor\0" | find /i "x86" > NUL && set OS=32bit || set OS=64bit
for /r %%i in (*) do (
	for /f "tokens=5 delims=_" %%b in ("%%~nxi") do (
		if %%b==%newUpdateVersionNumber% (
			set predictiveAnalyticVersionToBeExtract=%%~nxi
		)
	)
)

echo Zip to be extracted %predictiveAnalyticVersionToBeExtract%
set tmpZipPW=%predictiveAnalyticVersionToBeExtract:~-19%
set zipPW=%tmpZipPW:~0,-4%
::echo ZIP Password: %zipPW%

::perform extraction
echo Extracting %predictiveAnalyticVersionToBeExtract%...
"%installPath%\RccpBackup\Tools\7za.exe" x -p%zipPW% "%predictiveAnalyticVersionToBeExtract%" -o"%installPath%\RccpBackup\Extracted\Update_Package_Predictive_Analytic\%predictiveAnalyticVersionToBeExtract:~0, -4%" -y > NUL
::perform extraction

::---version control checking---::
::check extracted build version number
set extractedFolder=%predictiveAnalyticVersionToBeExtract:~0, -4%
if %OS%==32bit (
	cd /D %installPath%\RccpBackup\Extracted\Update_Package_Predictive_Analytic\%extractedFolder%\x86\
) else (
	cd /D %installPath%\RccpBackup\Extracted\Update_Package_Predictive_Analytic\%extractedFolder%\x64\
)
for /f "delims=" %%x in (version_predictive_analytic) do set extractedVersionNumber=%%x
::check extracted build version number

cd /D %installPath%\RccpBackup\Tools\
::set expected next version number
set /a currentVersionNumber+=1
set /a expectedNextVersionNumber=currentVersionNumber
echo Expected New Version: %expectedNextVersionNumber%
echo Extracted Build version: %extractedVersionNumber%
::set expected next version number
::if extracted is the expected version, then perform copy and replace existing files
if %expectedNextVersionNumber%==%extractedVersionNumber% (
	echo Copying new update files ...
	if %OS%==32bit (
		cd /D "%installPath%\RccpBackup\Extracted\Update_Package_Predictive_Analytic\%predictiveAnalyticVersionToBeExtract:~0, -4%\x86"
	) else (
		cd /D "%installPath%\RccpBackup\Extracted\Update_Package_Predictive_Analytic\%predictiveAnalyticVersionToBeExtract:~0, -4%\x64"
	)
	rem if already have config file, exclude from being copied
	if exist "%installPath%\Footfallcam\Superbug\PredictiveAnalytics\PredictiveAnalytics.exe.config" (
		rem file exists
		echo Config file exist
		(
			echo .txt
			echo .config
			echo version_predictive_analytic
		) > predictiveAnalyticExclude.txt
	) 
	if %OS%==32bit (
		echo 32-bit platform
		xcopy /q /e ".\*" "%installPath%\Footfallcam\Superbug\PredictiveAnalytics\" /y /exclude:predictiveAnalyticExclude.txt
	) else (
		echo 64-bit platform
		xcopy /q /e ".\*" "%installPath%\Footfallcam\Superbug\PredictiveAnalytics\" /y /exclude:predictiveAnalyticExclude.txt
	)
	echo Update version number
	xcopy /q version_predictive_analytic "%installPath%\RccpBackup\Tools\" /y
	echo Result: Update successful.
	set updateStatus=Successful
	CALL "%installPath%\RccpBackup\Tools\update_log_Predictive_Analytic.bat"
) else (
	set updateFailedReason=Package version in ZIP doesn't match with the ZIP package
	set updateStatus=Unsuccessful
	echo Error: Package version in ZIP doesn't match with the ZIP package
	echo Result: Update unsuccessful
	CALL "%installPath%\RccpBackup\Tools\update_log_Predictive_Analytic.bat"
)
cd /D %installPath%\RccpBackup\Tools\
