Highcharts.maps["countries/hk/hk-all"] = {
	"title": "China with Hong Kong and Macau",
	"version": "1.1.1",
	"type": "FeatureCollection",
	"copyright": "Copyright (c) 2014 Highsoft AS, Based on data from Natural Earth",
	"copyrightShort": "Natural Earth",
	"copyrightUrl": "http://www.naturalearthdata.com",
	"crs": {
		"type": "name",
		"properties": {
			"name": "urn:ogc:def:crs:EPSG:3415"
		}
	},
	"hc-transform": {
		"default": {
			"crs": "+proj=lcc +lat_1=18 +lat_2=24 +lat_0=21 +lon_0=114 +x_0=500000 +y_0=500000 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs",
			// "scale": 0.000129831107685,
			// "jsonres": 15.5,
			// "jsonmarginX": -999,
			// "jsonmarginY": 9851.0,
			// "xoffset": -3139937.49309,
			// "yoffset": 4358972.7486
		}
	},

	"features": [{
		"type": "Feature",
		"properties": {
			"name": "Central and Western",
			"ID_0": 102,
			"ID_1": 1,
			"ISO": "HKG"
		},
		"geometry": {
			"type": "MultiPolygon",
			"coordinates": [
				[
					[
						[511685.72952112666, 642178.9793351572],
						[511685.75120768551, 642148.45082808007],
						[511772.11719127401, 642148.51240682602],
						[511772.13927557366, 642117.65207263688],
						[511800.44760690263, 642117.67235507956],
						[511800.51370171923, 642025.53382087033],
						[511828.71925160609, 642025.55407812109],
						[511828.76339360874, 641964.16528064467],
						[511800.55773846526, 641964.14502332034],
						[511800.57987585454, 641933.28471544187],
						[511657.59546478087, 641933.18276788783],
						[511657.61725554464, 641902.43307461636],
						[511571.97056513984, 641902.37260389235],
						[511571.99211800267, 641871.73352525337],
						[511457.31592663145, 641871.65325651679],
						[511457.33734294341, 641840.90357169451],
						[511429.13147645717, 641840.88395120646],
						[511429.02542696102, 641993.52631467569],
						[511429.0033717273, 642025.27151536755],
						[511399.97430164315, 642025.25137274642],
						[511399.95314560086, 642055.77986285428],
						[511428.98216181679, 642055.80000543571],
						[511428.96072135906, 642086.66033130023],
						[511457.16616644349, 642086.67995148804],
						[511457.1876598114, 642055.8196256659],
						[511486.31961573113, 642055.83994112094],
						[511486.27659691725, 642117.44998658192],
						[511514.48198920995, 642117.46970503905],
						[511514.50351272302, 642086.71998540591],
						[511542.81189727789, 642086.7398245004],
						[511542.74724559323, 642178.87838585582],
						[511629.11306943576, 642178.93921380979],
						[511629.13465092477, 642148.41070665629],
						[511657.44292932434, 642148.43074300908],
						[511657.4212952978, 642178.95925013139],
						[511685.72952112666, 642178.9793351572]
					]
				],
				[
					[
						[514744.96491974936, 642765.24059923633],
						[514744.99238388485, 642734.60140342684],
						[514859.66255956743, 642734.70459052804],
						[514859.69013736775, 642704.17601005628],
						[514917.02533134597, 642704.22790346539],
						[514916.99764713959, 642734.75648384087],
						[515059.87215540989, 642734.88666734821],
						[515059.90010477626, 642704.35808721348],
						[515145.54261971771, 642704.43671729765],
						[515145.57144091354, 642673.13386621326],
						[515202.90674308606, 642673.18675606512],
						[515202.93475333811, 642642.87940643006],
						[515260.27016096085, 642642.93249621685],
						[515260.29878991062, 642612.07209723524],
						[515403.17436375533, 642612.20526252233],
						[515403.20315716421, 642581.45547891804],
						[515459.81822349294, 642581.50858953467],
						[515459.78932425001, 642612.2583730371],
						[515488.81735847174, 642612.28567981289],
						[515488.75976389926, 642673.45342753455],
						[515516.96420286276, 642673.48000861681],
						[515516.93467492604, 642704.78285904136],
						[515659.91237922723, 642704.91835134802],
						[515659.97103154846, 642643.30815233942],
						[515717.30643767666, 642643.36283512774],
						[515717.3653047246, 642581.75265390985],
						[515803.00845798361, 642581.83470698621],
						[515803.03810501355, 642550.9743177708],
						[515774.73051932536, 642550.94714747719],
						[515774.75979503314, 642520.41859468981],
						[515803.06743325503, 642520.44576503453],
						[515803.09686775284, 642489.8066059337],
						[515889.46105911676, 642489.88980136416],
						[515889.43146375869, 642520.52896030073],
						[516060.61547047738, 642520.69520352269],
						[516060.6453846838, 642490.05604489485],
						[516159.56789553509, 642490.15292441437],
						[516175.31726505578, 642490.16840341408],
						[516175.3475016068, 642459.41863868234],
						[516231.86005069502, 642459.47430520982],
						[516231.82970850641, 642490.22406983958],
						[516432.14521689434, 642490.42295027105],
						[516432.17593353608, 642459.67318600952],
						[516546.84802570182, 642459.78813447431],
						[516546.81709470483, 642490.53789852047],
						[516575.02184728929, 642490.56629373459],
						[516575.05283101083, 642459.81652974221],
						[516604.18407148216, 642459.84590847453],
						[516604.33937393117, 642305.9865438448],
						[516575.20786098763, 642305.95716484054],
						[516575.39342871727, 642121.79063546192],
						[516547.18804383231, 642121.76223961054],
						[516547.21897477133, 642091.01252800168],
						[516575.42441238335, 642091.04092390684],
						[516575.45550749585, 642060.18060626497],
						[516547.25001697231, 642060.15221030591],
						[516547.31176757376, 641998.76341936411],
						[516575.51736334997, 641998.79181542783],
						[516575.54812409694, 641968.26334213361],
						[516632.88588308508, 641968.32121617068],
						[516632.91708574479, 641937.46091612964],
						[516685.51968845504, 641937.51418649999],
						[516690.28615009534, 641906.76930495934],
						[516833.27079055802, 641906.91499588999],
						[516833.30214263499, 641876.2759257115],
						[516947.97830164962, 641876.39367043832],
						[516948.00998126518, 641845.64399447595],
						[517061.86282511073, 641845.76168467512],
						[517061.8796890903, 641829.50196580798],
						[517061.9264952339, 641784.3729565714],
						[517090.95599038212, 641784.40309055953],
						[517090.98805197806, 641753.54281764792],
						[517148.32655937388, 641753.60248825257],
						[517148.35849792784, 641722.96344038821],
						[517165.65272980882, 641722.98147725011],
						[517181.47965714731, 641649.44210037962],
						[517193.27045490773, 641596.47206499474],
						[517290.00910506479, 641426.78666444332],
						[517304.23802474822, 641405.23262885353],
						[517301.32850657625, 641137.33175030095],
						[517301.47496058641, 640998.07383752661],
						[517132.00982047495, 640814.9475842393],
						[517089.11665528017, 640582.06919167074],
						[517045.19922283973, 640442.32348235417],
						[517045.34396058181, 640302.62357257993],
						[517045.4885836278, 640163.03436153661],
						[517089.6969877691, 640023.38034189516],
						[517045.87466483453, 639790.39133314474],
						[517002.88133081538, 639650.64720205567],
						[516913.4576549757, 639507.53719909361],
						[516829.53765778942, 639417.6364356972],
						[516790.2419950568, 639384.63474137173],
						[516653.73057968961, 639273.99742891116],
						[516582.14958740433, 639299.47584560921],
						[516534.2574543184, 639316.46145895624],
						[516523.23706543643, 639320.43231802364],
						[516306.50226470473, 639226.97257400863],
						[516251.50789568387, 639242.18222118006],
						[516182.4056519029, 639260.25400891714],
						[516132.87019151991, 639273.47846010257],
						[515980.36614344176, 639404.51211650646],
						[515915.96512976236, 639459.53308533574],
						[515743.10197091999, 639459.36677125981],
						[515655.98673682759, 639366.26129586552],
						[515634.8439998423, 639296.44680283836],
						[515612.98048548657, 639226.52106619114],
						[515569.87064769946, 639086.67033126834],
						[515310.07422763098, 638900.0503677536],
						[515006.98575055023, 638760.18267898005],
						[514876.45062176051, 638853.30744490901],
						[514880.45465061354, 638865.92048382503],
						[514895.2381954455, 638913.05327185232],
						[514919.56716765265, 638992.93499727082],
						[514919.44049143925, 639132.63409186853],
						[514832.97481181793, 639225.57815965218],
						[514702.44435645471, 639318.70450321655],
						[514615.98087956157, 639411.64979014802],
						[514630.04438978591, 639458.33938000794],
						[514659.09786761779, 639551.60884191177],
						[514606.30956020841, 639636.17800704355],
						[514572.49155951617, 639691.23146734666],
						[514506.50652167492, 639797.91120151174],
						[514485.98977065005, 639830.744118931],
						[514462.34881327301, 639904.16798633942],
						[514450.57804413518, 639942.98156560387],
						[514441.90591350838, 639970.40510224563],
						[514312.20719367289, 640063.53558137571],
						[514229.58985962055, 640239.88619581121],
						[514151.75195402943, 640367.46259888983],
						[514138.34958915471, 640389.35179497325],
						[514130.50295331841, 640415.44894398854],
						[514118.6314252271, 640453.04605694313],
						[514094.99081736786, 640529.0146839791],
						[513921.26063230605, 640715.13368715171],
						[513848.22634514002, 640767.39051891491],
						[513791.57091208524, 640808.04736886104],
						[513487.51693899016, 640994.06244800542],
						[513010.77207295166, 640993.67849958444],
						[512837.99745124299, 640900.74099702318],
						[512664.50075583596, 640807.14113471494],
						[512295.33070426399, 640806.86108687229],
						[512274.12350088684, 640806.84525095986],
						[512144.62147553108, 640798.56400953152],
						[512116.31234053854, 640796.5521577911],
						[512116.28961254138, 640827.41230380861],
						[512087.25842864718, 640827.39094837022],
						[512087.23583637015, 640858.14048893529],
						[512058.92533757933, 640858.11971297592],
						[512058.90255498094, 640889.20108756144],
						[512001.56103474833, 640889.15915614972],
						[512001.53844117752, 640920.12992534507],
						[511973.22804905858, 640920.10929686064],
						[511973.18385400507, 640980.83413931681],
						[511944.15294084715, 640980.81303640944],
						[511944.13037490554, 641011.89442866948],
						[511915.82014070073, 641011.87389897276],
						[511915.68658810481, 641196.26075517433],
						[511943.9965050079, 641196.28128464159],
						[511943.86279560509, 641380.44707660889],
						[511972.89300355094, 641380.46817900636],
						[511972.82594606275, 641472.60643846402],
						[512001.13538741419, 641472.6270662602],
						[512001.09060359863, 641534.01572413021],
						[512029.39993927535, 641534.0364005625],
						[512029.37737321819, 641564.89665130177],
						[512058.40725567605, 641564.91790460143],
						[512058.38487838843, 641595.44632896502],
						[512110.26797618601, 641595.48444110062],
						[512115.67864361586, 641656.98776097165],
						[512143.98776767624, 641657.00863459427],
						[512143.94236859219, 641718.50795448374],
						[512201.28099812946, 641718.55038216244],
						[512201.2582734414, 641749.18943824666],
						[512229.46429714636, 641749.21038260998],
						[512229.44135546492, 641780.07066365075],
						[512344.11818524211, 641780.15631487593],
						[512344.09494542971, 641811.12721049262],
						[512372.4038042379, 641811.14847718435],
						[512372.38092707749, 641841.56632536324],
						[512457.92499293684, 641841.63088534784],
						[512457.90170630271, 641872.38056881342],
						[512601.7101731982, 641872.4901033435],
						[512601.68670248054, 641903.12918057479],
						[512715.53914857621, 641903.21679014084],
						[512715.51538030792, 641933.96648194513],
						[512772.85325886507, 641934.01090184087],
						[512772.82929752837, 641964.87120835413],
						[512858.37272218458, 641964.93785070162],
						[512858.34885974409, 641995.46633016225],
						[512887.48092254443, 641995.48912694654],
						[512887.40865309496, 642087.73825394979],
						[512915.61409632507, 642087.76037478133],
						[512915.51752611768, 642210.7592717564],
						[512972.8544399126, 642210.80438875477],
						[512972.83036462945, 642241.33290270623],
						[513001.13848311949, 642241.35525135556],
						[513001.11409304535, 642272.21560131584],
						[513173.12419132615, 642272.3524468987],
						[513173.09974428115, 642302.88096922007],
						[513230.43633698183, 642302.92698402086],
						[513230.38678526285, 642364.53709455475],
						[513286.89966032945, 642364.58264385187],
						[513286.87473396346, 642395.44301093998],
						[513516.21981329209, 642395.62985547166],
						[513516.16937269398, 642457.01877014118],
						[513544.37418275583, 642457.04196903855],
						[513544.34886428871, 642487.79173821711],
						[513572.65655865707, 642487.81507036486],
						[513572.60608966905, 642548.98278960038],
						[513629.94182457827, 642549.03019688418],
						[513629.91625435406, 642579.89058974781],
						[513658.94434569258, 642579.91466743313],
						[513658.91881285433, 642610.66445390962],
						[513715.53377866233, 642610.71156123304],
						[513715.50804775959, 642641.57196276961],
						[513801.87144236261, 642641.64419803512],
						[513801.89733528713, 642610.78379663732],
						[514030.41592188471, 642610.97711919411],
						[514030.38960025081, 642641.83752023219],
						[514145.06042260764, 642641.9357258419],
						[514145.03436141065, 642672.24307721027],
						[514258.88148448034, 642672.34136817337],
						[514258.85435061273, 642703.64422076754],
						[514287.88222356822, 642703.66940831032],
						[514287.85570697975, 642734.19798972527],
						[514344.47024761786, 642734.24726165214],
						[514344.44352949748, 642764.88645812171],
						[514373.47129438689, 642764.91179669963],
						[514373.49806657608, 642734.27260028117],
						[514401.80533678719, 642734.2973592612],
						[514401.77851187519, 642764.93655564007],
						[514573.78345794539, 642765.08804723551],
						[514573.81060323602, 642734.44885114557],
						[514631.14569170133, 642734.49974812043],
						[514631.11843961518, 642765.13894411968],
						[514744.96491974936, 642765.24059923633]
					]
				]
			]
		}
	}, {
		"type": "Feature",
		"properties": {
			"name": "Eastern",
			"ID_0": 102,
			"ID_1": 2,
			"ISO": "HKG"
		},
		"geometry": {
			"type": "MultiPolygon",
			"coordinates": [
				[
					[
						[520388.07000500598, 639211.28256401513],
						[520424.61684790952, 639462.63201321405],
						[520437.86125467025, 639575.24872753606],
						[520475.22752863774, 639828.70130512957],
						[520485.33800122637, 639894.52652725775],
						[520607.04987466813, 639960.04874271969],
						[520795.39121818315, 640091.13683104364],
						[520965.68814302393, 640241.7820632332],
						[521141.43887602724, 640391.99373409199],
						[521233.14353153616, 640490.4439213227],
						[521275.41528438992, 640601.44018736237],
						[521268.94936222467, 640745.33529353386],
						[521226.43375583994, 640823.59222502355],
						[521067.60782391811, 640966.95984860661],
						[521056.57625821116, 640979.66587991733],
						[520982.65470089973, 641064.96240140172],
						[520964.63098001975, 641071.35480812809],
						[520865.46217286342, 641177.52505241998],
						[520855.25727016566, 641188.02007620106],
						[520822.28484493995, 641211.64888265147],
						[520725.53206463793, 641280.87928710063],
						[520638.45466873387, 641187.74666219437],
						[520638.59440339578, 641076.36244906089],
						[520638.62770658178, 641049.8160710251],
						[520509.23986312054, 640954.75083541882],
						[520348.33566606446, 640870.15559686953],
						[520295.57525936933, 640911.7903908171],
						[520288.56436450424, 640920.29871360108],
						[520086.37694060674, 641172.79461970553],
						[520056.44364648109, 641237.68625750439],
						[520017.81802814186, 641339.73241985694],
						[519988.69004193257, 641420.11064576614],
						[519969.75627217657, 641498.39972863032],
						[519944.50750169693, 641606.10355596954],
						[519814.79073674971, 641698.97012787417],
						[519791.92451016908, 641795.39489134471],
						[519771.33109128376, 641885.29644136643],
						[519742.32659732073, 641864.57744578773],
						[519708.59137778718, 641839.98146853026],
						[519641.11944749241, 641791.78522251197],
						[519571.25774925802, 641761.83714129264],
						[519505.30601151031, 641733.22132168571],
						[519424.4346419372, 641698.50457515195],
						[519283.88652068912, 641638.05656309216],
						[519272.97760806052, 641635.49974065379],
						[519272.95933638664, 641651.09578105935],
						[519248.44747103285, 641748.95728284307],
						[519059.82461503503, 641866.64840036607],
						[518931.74365970795, 641885.96794703626],
						[518876.76309895853, 641894.7536046101],
						[518865.84947334527, 641896.40024231619],
						[518819.38497069658, 641929.75139259128],
						[518758.15412880591, 641913.20049263886],
						[518725.20719805197, 641918.36165037099],
						[518554.76695070235, 641892.06444720924],
						[518537.46928191808, 641895.25265013776],
						[518291.59775092552, 641939.00040178769],
						[518291.5631906669, 641970.08191927359],
						[518319.87177592935, 641970.11342065223],
						[518319.7694128342, 642062.03067444218],
						[518340.25442004023, 642062.05350024218],
						[518662.9707355139, 642062.19523810549],
						[518662.93547329836, 642093.27677242481],
						[518777.61011955858, 642093.40727151639],
						[518777.53979306732, 642155.01730063686],
						[518805.0245468613, 642155.04869688861],
						[518805.05957191222, 642124.40959589288],
						[518834.91223505477, 642124.22252785461],
						[518834.87690111389, 642155.08284971397],
						[518859.27348023077, 642155.11080104182],
						[518863.15016147157, 642185.64378076443],
						[518920.48716276779, 642185.70962823578],
						[518920.45166814991, 642216.56995866622],
						[518977.78856165259, 642216.63600585994],
						[518977.75334228558, 642247.16450898291],
						[519005.95851215214, 642247.1970722595],
						[519005.92285704898, 642278.05741126393],
						[519063.25953623536, 642278.12375636736],
						[519063.22415810608, 642308.65226797923],
						[519177.89730297436, 642308.7855574782],
						[519177.93289391662, 642278.25704611558],
						[519234.44606535783, 642278.32302783988],
						[519234.48189050786, 642247.68391038757],
						[519320.95055140636, 642247.56402096094],
						[519320.9143053749, 642278.4243592741],
						[519349.11942164577, 642278.45751092944],
						[519349.08351300925, 642308.98602191813],
						[519377.39151506778, 642309.01934313017],
						[519377.21027589566, 642462.87867939274],
						[519406.23857371171, 642462.91289904725],
						[519406.20229765709, 642493.66265725007],
						[519417.21656026441, 642493.67565468536],
						[519491.8459094931, 642493.76391569467],
						[519491.80960440607, 642524.40306742257],
						[519520.01429892267, 642524.43651209306],
						[519519.97807255457, 642554.96505741973],
						[519549.10914451926, 642554.99965134996],
						[519549.07246972847, 642585.86003301118],
						[519577.27705887146, 642585.89357586321],
						[519577.24046279927, 642616.64335116849],
						[519663.70692446595, 642616.74648446147],
						[519663.63380570541, 642677.91421559895],
						[519720.14560414891, 642677.98186591745],
						[519720.10807777941, 642709.28470777953],
						[519749.13594077557, 642709.3195325298],
						[519749.09928874462, 642739.8481034562],
						[519777.40654935315, 642739.88211303274],
						[519777.33300721663, 642801.04987852508],
						[519806.36070828047, 642801.0848042611],
						[519806.32301754353, 642832.38766377221],
						[519862.93722021522, 642832.45592858456],
						[519862.90062381054, 642862.76329499902],
						[519891.92821596767, 642862.79837172781],
						[519891.85424738994, 642923.96617153275],
						[520005.69962816488, 642924.10423586983],
						[520005.6615577889, 642955.40711274382],
						[520120.33019410737, 642955.54697196046],
						[520120.29285258334, 642986.07557685091],
						[520205.9339007372, 642986.18055309309],
						[520205.89626439265, 643016.81977302383],
						[520263.23036862008, 643016.89030062687],
						[520263.1924892189, 643047.64013571118],
						[520280.3823949275, 643047.66132023034],
						[520347.90681474702, 643047.74470994784],
						[520348.69210713793, 643078.60617882083],
						[520406.02599600801, 643078.67720413837],
						[520405.94984023657, 643140.06628465687],
						[520463.28351488459, 643140.13750954671],
						[520463.24526120524, 643170.88736173068],
						[520520.57882842742, 643170.95878632308],
						[520520.61718928663, 643140.2089342752],
						[520806.46209364815, 643140.5680138421],
						[520806.42319843278, 643171.31786522153],
						[520834.7297165498, 643171.35369429167],
						[520834.65196037991, 643232.74279907881],
						[520977.52214312402, 643232.92438087822],
						[520977.56107622158, 643202.39574312838],
						[521006.69100164459, 643202.43291830004],
						[521006.73041256721, 643171.572452005],
						[521061.69652320282, 643171.64273942949],
						[521064.10335424234, 643140.89592014847],
						[521092.30699172925, 643140.93206066184],
						[521092.34656312165, 643110.07160340226],
						[521177.9869656947, 643110.18164049019],
						[521178.02627052757, 643079.65302066703],
						[521207.05347994657, 643079.69041813584],
						[521207.01412124524, 643110.21903789113],
						[521235.3207445009, 643110.25555631984],
						[521235.36015573866, 643079.72693662986],
						[521320.89778293227, 643079.83758488076],
						[521320.85821293906, 643110.3662043612],
						[521435.52576900471, 643110.51523180632],
						[521435.5655518116, 643079.98661259771],
						[521463.87222709227, 643080.0235243279],
						[521463.95261941297, 643018.41324453463],
						[521521.28671807481, 643018.48815709306],
						[521521.32680452237, 642987.84894026956],
						[521550.35417594825, 642987.8869435424],
						[521550.39417154202, 642957.35834201402],
						[521693.36968026543, 642957.54627621337],
						[521693.32941932045, 642988.07487739599],
						[521721.53331882926, 642988.11209676834],
						[521721.57363212091, 642957.58349565638],
						[521807.21482858877, 642957.69680872327],
						[521807.17435635597, 642988.22540962568],
						[521836.20172711444, 642988.26391731726],
						[521836.24225322093, 642957.73531648854],
						[521921.88344890339, 642957.84922656184],
						[521921.9655560322, 642896.23898413999],
						[521979.30008052953, 642896.31549309904],
						[521979.34131535399, 642865.45507322787],
						[522064.88005676772, 642865.56959024654],
						[522064.9207102115, 642835.26222900138],
						[522122.25544724241, 642835.33923623839],
						[522122.29754512064, 642804.03638234688],
						[522207.93954100786, 642804.15178171964],
						[522207.98075652897, 642773.62320796074],
						[522236.28795901337, 642773.66144889407],
						[522236.32937658695, 642743.02226877073],
						[522265.35718004545, 642743.06153378019],
						[522265.4408718932, 642681.23013313743],
						[522350.98057129188, 642681.34613789758],
						[522351.02175136196, 642651.03880330303],
						[522408.35713050299, 642651.11680774472],
						[522408.3158447941, 642681.42414219771],
						[522465.65111802932, 642681.50234633358],
						[522465.69250937446, 642651.19501202507],
						[522522.3073356364, 642651.27242957801],
						[522522.34958850592, 642620.41204624006],
						[522579.68507439678, 642620.49064784381],
						[522579.72728299064, 642589.74087973312],
						[522608.75535693543, 642589.78075071645],
						[522608.79777181189, 642558.92037640547],
						[522665.30997903011, 642558.99814465386],
						[522665.35036625725, 642529.68632381305],
						[522780.02365514234, 642528.62800673011],
						[522780.06608480035, 642497.98886287364],
						[522803.6386593121, 642498.02152355295],
						[522809.13695774681, 642467.27933734527],
						[522865.75241699244, 642467.35793693236],
						[522865.79562116147, 642436.2763596531],
						[522923.13174885628, 642436.35615833988],
						[522923.17398239672, 642406.04885967798],
						[522980.51021544653, 642406.12885835627],
						[522980.55332723021, 642375.26851131336],
						[523008.75827745022, 642375.30793775339],
						[523008.80128742702, 642344.55820573098],
						[523066.13773480454, 642344.63850286277],
						[523066.18100705242, 642313.77816484135],
						[523123.51756171213, 642313.85866197338],
						[523123.5604750677, 642283.33016002586],
						[523151.86852127046, 642283.36997653812],
						[523151.91195417824, 642252.50964750128],
						[523180.94062321511, 642252.55052819173],
						[523180.98364296684, 642222.02203505894],
						[523238.320517443, 642222.10293233267],
						[523238.3641123572, 642191.24261227751],
						[523266.67231702717, 642191.2826263539],
						[523266.93310991232, 642006.89507142955],
						[523295.13869173749, 642006.93498889648],
						[523295.22562360927, 641945.54624584015],
						[523321.99014413427, 641945.58416858607],
						[523324.401373495, 641914.83785530715],
						[523381.73931865528, 641914.9192524621],
						[523381.78286731074, 641884.28019719361],
						[523438.29739221284, 641884.36062098469],
						[523438.34120371484, 641853.61095991544],
						[523467.37057666964, 641853.65234605293],
						[523467.4139690561, 641823.23452022218],
						[523610.39933533681, 641823.43911690533],
						[523610.3556785633, 641853.85694235947],
						[523638.56152278697, 641853.89744864963],
						[523638.51733702683, 641884.64710918919],
						[523667.64959606231, 641884.68899666949],
						[523667.60551497608, 641915.32805117604],
						[523867.8250828684, 641915.61733030342],
						[523867.7804683866, 641946.36699892965],
						[523924.29477998911, 641946.44909234322],
						[523924.24989899457, 641977.30937552254],
						[523953.38199392927, 641977.35176901065],
						[523953.33754146087, 642007.88022543199],
						[523965.07270984538, 642007.89731721499],
						[524038.88074231247, 642008.00500742218],
						[524038.83564618207, 642038.8652990337],
						[524096.17315904179, 642038.94918634952],
						[524096.1284414031, 642069.47765103879],
						[524153.46584756311, 642069.56173804589],
						[524153.51067161263, 642039.03327351809],
						[524168.43695400917, 642039.05519613973],
						[524210.84818388615, 642039.11756053939],
						[524210.93853314954, 641977.72881367349],
						[524239.24710524414, 641977.77050140011],
						[524239.29257716198, 641946.9102190847],
						[524291.89514962037, 641946.98781196412],
						[524296.71487141261, 641889.80927594309],
						[524354.05912641645, 641885.6908710202],
						[524354.10464968381, 641854.94121243223],
						[524382.31049204723, 641854.98299394723],
						[524382.40148007264, 641793.59430025797],
						[524439.73984782468, 641793.67938507581],
						[524439.78569530277, 641762.81912956678],
						[524497.12417032267, 641762.90441439615],
						[524497.16979593202, 641732.26538385509],
						[524525.4787904314, 641732.307564141],
						[524525.52430385817, 641701.77914820123],
						[524582.86299163103, 641701.86473187781],
						[524582.90927261277, 641670.89387967717],
						[524640.24806803453, 641670.97966336529],
						[524640.34018317936, 641609.48041313165],
						[524696.85565212776, 641609.56516062887],
						[524696.90148322051, 641579.03676246281],
						[524725.93134069978, 641579.08036952163],
						[524725.97772440535, 641548.2201453849],
						[524754.28703561693, 641548.26271941687],
						[524754.3333059852, 641517.51310984744],
						[524783.36327203352, 641517.55681825173],
						[524783.40943001828, 641486.9178231986],
						[524811.71884672437, 641486.96049606078],
						[524811.76489060454, 641456.43211547576],
						[524840.79496443935, 641456.47592523112],
						[524840.84206430521, 641425.28388870833],
						[524869.15158707509, 641425.32666040072],
						[524869.33735860267, 641302.43892919552],
						[524897.64709276741, 641302.48174992355],
						[524897.78586849244, 641210.78608958481],
						[524926.8163758053, 641210.83005113457],
						[524927.00307826255, 641087.61061216588],
						[524955.31318211532, 641087.65353212925],
						[524955.40630375163, 641026.26505865518],
						[525012.74734602426, 641026.35214068671],
						[525012.79426607769, 640995.49199585605],
						[525041.00158204616, 640995.53490675543],
						[525041.09401269548, 640934.81011855218],
						[525098.43638621585, 640934.23384045961],
						[525098.53004098497, 640872.84541108983],
						[525184.1820912757, 640872.97630579129],
						[525184.22916311538, 640842.22679295321],
						[525155.91863692401, 640842.18347906542],
						[525156.01250561757, 640780.79507596395],
						[525127.7018737077, 640780.75181062741],
						[525127.84277165472, 640688.50332362438],
						[525098.81134261831, 640688.4590073342],
						[525098.90499727533, 640627.07064714166],
						[525070.69704954303, 640627.02763695887],
						[525070.7439085145, 640596.27815844456],
						[525041.60936782125, 640596.23378621065],
						[525041.70280847233, 640534.84545160085],
						[525013.49470261298, 640534.80253950041],
						[525013.5416225607, 640503.94246421242],
						[524985.23051422718, 640503.89944405085],
						[524985.32374394313, 640442.51113505219],
						[524956.29188081645, 640442.46707025636],
						[524956.47845908324, 640319.4692846823],
						[524985.51053926209, 640319.51334980677],
						[524985.60376889806, 640258.12509259116],
						[525042.123880342, 640258.21102622687],
						[525042.0769075373, 640289.07106672088],
						[525071.21199218777, 640289.11543979053],
						[525071.16547039815, 640319.6436560984],
						[525099.37394516682, 640319.68666708283],
						[525099.32686478493, 640350.54671608284],
						[525128.35889012134, 640350.5910332849],
						[525128.31192422181, 640381.34047703934],
						[525184.93456261535, 640381.42705853528],
						[525184.88766019931, 640412.06589691935],
						[525213.91957697691, 640412.11036510288],
						[525213.87245097186, 640442.85981725273],
						[525242.18366433715, 640442.90323087713],
						[525242.13631570048, 640473.76329683792],
						[525213.82515543816, 640473.7198832928],
						[525213.63699034567, 640596.49653329118],
						[525241.94793932675, 640596.53994651348],
						[525241.8065721289, 640688.67778390879],
						[525270.83800078172, 640688.72235254],
						[525270.74370419083, 640750.11072901916],
						[525299.05438882648, 640750.15424051078],
						[525299.14879106137, 640688.76586419018],
						[525327.356632935, 640688.80926607409],
						[525327.40397181222, 640658.05977964588],
						[525384.74629746191, 640658.14815827599],
						[525384.84101887781, 640596.75980836805],
						[525413.97555863904, 640596.80478843115],
						[525414.11600970349, 640505.88369674794],
						[525441.6055714445, 640504.59886638483],
						[525442.42115312419, 640443.21167444088],
						[525499.76422762859, 640443.30045396893],
						[525499.81188798288, 640412.55100264342],
						[525612.95399958035, 640412.7267574108],
						[525614.54595290404, 640382.09032447718],
						[525642.85727084766, 640382.13442760182],
						[525642.90519846184, 640351.38498532609],
						[525671.113618801, 640351.42897660821],
						[525671.16177171853, 640320.56892926525],
						[525700.29680058942, 640320.61441637843],
						[525700.3444897919, 640290.08620186627],
						[525728.55301523721, 640290.13029163587],
						[525728.60127570375, 640259.27025312162],
						[525757.73641312902, 640259.31584195432],
						[525757.78420872276, 640228.78763618018],
						[525774.25674831495, 640228.59221479821],
						[525785.99318599165, 640228.61060556769],
						[525786.03912693961, 640199.29910776333],
						[525900.72906553769, 640198.1519490449],
						[525900.77712627081, 640167.62375225255],
						[525957.29754862364, 640167.71282990579],
						[525957.39475239604, 640106.10340258409],
						[525986.53016106156, 640106.14939658891],
						[525986.67586826242, 640013.90120234899],
						[526010.97267031646, 640013.9395974474],
						[526014.93348902604, 639983.19639369799],
						[526044.06911535119, 639983.24248960055],
						[526044.11761647894, 639952.6037139328],
						[526072.32672057056, 639952.648393129],
						[526072.37509894033, 639922.12023110804],
						[526129.71998970339, 639922.21120634011],
						[526129.76900148101, 639891.35122096003],
						[526152.62463806814, 639891.38753615972],
						[526158.1300529287, 639860.64683899377],
						[526187.16294276842, 639860.69302461448],
						[526187.21206209215, 639829.83304808021],
						[526215.52433038689, 639829.87813667185],
						[526215.57332656754, 639799.12877377868],
						[526272.91864601499, 639799.22024812712],
						[526272.96792599652, 639768.36028051784],
						[526301.28030007647, 639768.40551668638],
						[526301.32910269278, 639737.8773810413],
						[526330.36220917501, 639737.92381936009],
						[526330.41088863974, 639707.50629721442],
						[526358.62041297252, 639707.55146729026],
						[526358.66949899343, 639676.91273114947],
						[526387.80602252076, 639676.73821748153],
						[526387.90465786739, 639615.23954003665],
						[526444.4269778966, 639615.33029118995],
						[526444.47657897871, 639584.47035000473],
						[526473.50995617185, 639584.5170409251],
						[526473.70751039381, 639461.74097410205],
						[526416.36101466406, 639461.64879991196],
						[526416.410385011, 639430.89948924363],
						[526388.20038633596, 639430.85422008543],
						[526388.25023615966, 639399.77308661037],
						[526359.1135765668, 639399.72638119617],
						[526359.55534990726, 639123.97829614487],
						[526388.69320743042, 639123.58256686456],
						[526388.75441086735, 639085.42251029867],
						[526388.95647083235, 638959.43906616583],
						[526388.98893523903, 638939.19765911857],
						[526359.85146000516, 638939.15095239296],
						[526360.04851219035, 638816.15402680519],
						[526302.80272631324, 638816.06241336302],
						[526302.90086157632, 638754.67458464485],
						[526274.58674301964, 638754.6293456892],
						[526274.63584613579, 638723.8801333158],
						[526302.95001760579, 638723.92537235643],
						[526303.04779918864, 638662.75878655282],
						[526360.29411844863, 638662.8504008475],
						[526360.34426747099, 638631.5481584277],
						[526389.48228743754, 638631.59486602002],
						[526389.58039011434, 638570.42830636282],
						[526417.7918640686, 638570.47357789183],
						[526417.8904267709, 638509.08581822063],
						[526389.67884756043, 638509.04054652457],
						[526389.72816497821, 638478.29136873269],
						[526360.58987351996, 638478.24466070405],
						[526360.73801676964, 638385.77593574091],
						[526332.5262261373, 638385.73076203943],
						[526332.57472828391, 638355.42403515778],
						[526303.53918217169, 638355.37759293872],
						[526303.63767086738, 638293.76867538644],
						[526275.32275916578, 638293.72343516746],
						[526275.37133228919, 638263.30611227965],
						[526247.05707392201, 638262.81848693988],
						[526247.10577113426, 638232.2905597894],
						[526218.07000773447, 638232.24426839605],
						[526218.11882731435, 638201.60573696007],
						[526189.80375701049, 638201.56064390438],
						[526189.85234780819, 638171.03272502753],
						[526160.8164763099, 638170.98653465672],
						[526160.91442942875, 638109.37766754488],
						[526132.59920041717, 638109.33267292858],
						[526132.69704748935, 638047.72382278601],
						[526104.48467723525, 638047.67904008308],
						[526104.53363568394, 638016.81931719847],
						[526018.04299484228, 638016.68232835538],
						[526017.99419860076, 638047.54205149482],
						[525989.78182803385, 638047.49746545823],
						[525989.73325941002, 638078.24658463243],
						[525960.59425951215, 638078.20058495703],
						[525960.54557081999, 638109.06031685451],
						[525904.01807609643, 638108.97122805286],
						[525904.06665876799, 638078.111495991],
						[525846.71534039965, 638078.02130728238],
						[525846.76364175952, 638047.27218768909],
						[525817.72755186749, 638047.22660275677],
						[525817.92019308975, 637924.45138327568],
						[525766.02032130468, 637927.68828764511],
						[525677.03181462036, 638076.31772737927],
						[525584.14845597453, 638214.54447223991],
						[525540.68680858659, 638354.17577128182],
						[525453.36422721785, 638493.62875403464],
						[525409.90441976406, 638633.26057507936],
						[525106.61248467222, 638679.47194679419],
						[524846.28494129214, 638911.68744500284],
						[524672.62531564769, 638958.10313416843],
						[524498.86387798365, 639004.40990399173],
						[524326.09889576107, 639004.15356543614],
						[524152.71514699503, 638864.30952770007],
						[523979.2609072557, 638770.81245376472],
						[523762.42645022681, 638770.49787007994],
						[523675.84186950355, 638909.96159142],
						[523502.05235661415, 639049.6328863739],
						[523372.36150526843, 639095.90396753501],
						[523068.32565413753, 639095.47488370468],
						[522938.70115577435, 639095.29365375638],
						[522808.35594788421, 639095.11244593805],
						[522678.73144667241, 639094.93326412234],
						[522548.32241902442, 639141.32046595088],
						[522375.39243840484, 639187.76143824053],
						[522244.98530339036, 639233.92984612868],
						[522158.37548321183, 639327.0565258495],
						[522071.08658584708, 639466.63868425763],
						[521941.46501167218, 639466.46531090164],
						[521811.01978831657, 639466.29186684173],
						[521594.35871614882, 639419.32896069798],
						[521421.61624823092, 639326.08077809587],
						[521204.90928186529, 639232.55651211343],
						[520988.06492307165, 639325.52201162209],
						[520814.59761875687, 639232.05810431438],
						[520640.96655142255, 639185.49413017393],
						[520627.68500359397, 639185.47747343709],
						[520511.44572007353, 639185.33215217362],
						[520500.44853673223, 639169.83316810394],
						[520458.73135909939, 639185.26651983068],
						[520443.89871060679, 639190.66793033481],
						[520388.07000500598, 639211.28256401513]
					]
				]
			]
		}
	}, {
		"type": "Feature",
		"properties": {
			"name": "Islands",
			"ID_0": 102,
			"ID_1": 3,
			"ISO": "HKG"
		},
		"geometry": {
			"type": "MultiPolygon",
			"coordinates": [
				[
					[
						[492149.25226652221, 627951.53062647884],
						[492149.19362029555, 627828.53949025983],
						[492178.35077146121, 627828.5256130395],
						[492178.2777885223, 627674.89738663984],
						[492120.8902099664, 627674.92474920664],
						[492120.84606718429, 627582.68149967876],
						[492091.79151098896, 627582.69542925141],
						[492091.77684872464, 627552.16889423563],
						[492063.44345240929, 627552.18252743664],
						[492063.428577671, 627521.32418631145],
						[491948.65235009132, 627521.37991208828],
						[491948.68236754462, 627582.76478799421],
						[491891.29446785676, 627582.79295081622],
						[491891.37001918326, 627736.199908696],
						[491920.42430449708, 627736.18562545371],
						[491920.45475326531, 627798.23417836521],
						[491948.78772615944, 627798.22029909992],
						[491948.80259968981, 627828.63626242056],
						[492006.18964249193, 627828.60830004339],
						[492006.2044637067, 627859.13487087283],
						[492035.25853208167, 627859.120790279],
						[492035.28844131436, 627920.94816878485],
						[492063.62120304408, 627920.93448713177],
						[492063.63597117615, 627951.57167359628],
						[492149.25226652221, 627951.53062647884]
					]
				],
				[
					[
						[525919.25459985435, 628430.72570574458],
						[525919.44787749881, 628307.95567351638],
						[525890.39460110944, 628307.90996033594],
						[525890.4429533073, 628277.16216045409],
						[525833.05747373751, 628277.07201929402],
						[525833.10554521682, 628246.43482685299],
						[525633.44079168711, 628246.12275195529],
						[525633.29717526969, 628338.36615389795],
						[525680.4829056256, 628338.4396864305],
						[525689.85823630239, 628338.45431271498],
						[525689.81060368405, 628368.98091399902],
						[525747.19576290506, 628369.07055587275],
						[525747.14750497451, 628399.92897191644],
						[525776.30364421266, 628399.97459361132],
						[525776.20753852942, 628461.3596267018],
						[525890.15301394882, 628461.53841662384],
						[525890.20154010993, 628430.67999290687],
						[525919.25459985435, 628430.72570574458]
					]
				],
				[
					[
						[490919.94485263154, 629488.34110864298],
						[490919.89385355561, 629395.87593912077],
						[490948.22407715418, 629395.86033803923],
						[490948.19044738566, 629334.69619699777],
						[490976.52077626518, 629334.68064461194],
						[490976.48688801855, 629272.85289444192],
						[491062.9204707194, 629272.80574661435],
						[491062.93746268546, 629304.10673444648],
						[491234.25900661049, 629304.01462305489],
						[491234.24234037753, 629272.71363503858],
						[491262.57277591788, 629272.69857490901],
						[491262.55669186288, 629242.3930286566],
						[491348.990434476, 629242.3473827386],
						[491348.97421892575, 629211.4888195399],
						[491377.30475982581, 629211.47395684419],
						[491377.22435312963, 629057.95543062256],
						[491348.89354804356, 629057.97029345715],
						[491348.86129132984, 628996.58503214677],
						[491291.47831951617, 628996.61528563651],
						[491291.46199642564, 628965.75675502536],
						[491062.75385349727, 628965.87932186958],
						[491062.73716176499, 628935.13139960286],
						[491005.35397576174, 628935.16265037376],
						[491005.32043838513, 628873.77742211253],
						[491033.65156043699, 628873.76196803851],
						[491033.51771309972, 628628.00000836037],
						[491176.51474775921, 628627.92275032308],
						[491176.4982095774, 628597.0642685577],
						[491205.65399975982, 628597.04866878479],
						[491205.57199569599, 628443.53054746625],
						[491233.80083318206, 628443.51549285429],
						[491233.75171803305, 628351.27194382192],
						[491291.13693918678, 628351.24148913124],
						[491291.12079166021, 628320.71485495381],
						[491319.4528654482, 628320.69989269983],
						[491319.43659550755, 628289.84145129705],
						[491348.48990383669, 628289.82615879225],
						[491348.45764723158, 628228.44109921262],
						[491319.40423057531, 628228.45639177691],
						[491319.38801895746, 628197.70856621314],
						[491291.05573351879, 628197.72352857748],
						[491291.03941048274, 628166.86510340194],
						[491233.65354668268, 628166.89555842965],
						[491233.66997727705, 628197.75398354873],
						[491205.44071840943, 628197.76903839014],
						[491205.45714283106, 628228.51686384622],
						[491148.07149391866, 628228.54761717469],
						[491148.08796605055, 628259.18484289711],
						[491090.70242403034, 628259.2157961888],
						[491090.68584511249, 628228.57857052016],
						[490947.58231562411, 628228.65663069626],
						[490947.54844276945, 628167.05038067349],
						[490919.21610457328, 628167.06598291919],
						[490919.18224771897, 628105.68095641979],
						[490890.12861443713, 628105.697006503],
						[490890.09477166797, 628044.53320334863],
						[490747.09266994172, 628044.612949142],
						[490747.12704395317, 628105.77675199613],
						[490689.74096723431, 628105.80910283257],
						[490689.75841719937, 628136.66751931258],
						[490604.04005772667, 628136.71621472028],
						[490604.02244709933, 628105.85779833945],
						[490546.63637066382, 628105.89064796944],
						[490546.61871599039, 628075.14283932396],
						[490489.23253249435, 628075.17588903324],
						[490489.21496232867, 628044.75989530049],
						[490432.65289252932, 628044.79266612569],
						[490432.67056718993, 628075.20865979337],
						[490317.89820078149, 628075.27575356723],
						[490317.88031408977, 628044.85976001574],
						[490289.54776562308, 628044.87644582777],
						[490289.49329621479, 627952.52245332021],
						[490260.43939266389, 627952.53961458348],
						[490260.42126911221, 627921.90242992039],
						[490117.41810228792, 627921.98764480208],
						[490117.38099104259, 627860.16027019941],
						[490059.99405822757, 627860.19481601741],
						[490059.97562857065, 627829.66824714525],
						[489945.92275207571, 627829.73749856045],
						[489945.94139319484, 627860.26406730514],
						[489916.88732684322, 627860.28183481994],
						[489916.92519098055, 627922.1092089694],
						[489888.5924312807, 627922.1265847605],
						[489888.61124673719, 627952.76376900438],
						[489802.99495783023, 627952.81657165894],
						[489803.03304438194, 628014.31215913256],
						[489715.76863330125, 628014.36643639742],
						[489688.26025347813, 628014.38364211051],
						[489688.2788876546, 628044.13600933203],
						[489688.31788781058, 628106.40584588028],
						[489630.10759677965, 628106.44240630022],
						[489602.59937079862, 628106.45975513768],
						[489602.61885835894, 628137.31817039684],
						[489573.56528091041, 628137.33654375514],
						[489573.57550720131, 628153.4846766399],
						[489573.58461279998, 628167.86315206089],
						[489546.90070287162, 628167.88007202395],
						[489545.34997071937, 628321.73086074379],
						[489573.68204276153, 628321.71289428836],
						[489573.70137466636, 628352.23952661327],
						[489602.75457288866, 628352.22115349572],
						[489602.793338513, 628413.60624148499],
						[489631.12525245023, 628413.58837387385],
						[489631.18334694247, 628505.83194188657],
						[489660.23627412505, 628505.81367019936],
						[489660.2555847016, 628536.5615343214],
						[489745.97186245368, 628536.50792523404],
						[489745.99108183396, 628567.36639734637],
						[489774.2197069957, 628567.34884014761],
						[489774.25783385639, 628628.73398501542],
						[489859.97363172646, 628628.6809694618],
						[489859.99256942095, 628659.42884998373],
						[489974.76086371421, 628659.35856413969],
						[489974.77951971901, 628689.99584493088],
						[490010.1165500583, 628689.97436508804],
						[490175.16005679074, 628689.87504669791],
						[490175.14177367103, 628659.23776568577],
						[490203.47326491686, 628659.22088300064],
						[490203.44753176288, 628615.97476388107],
						[490203.43660668947, 628597.61452135339],
						[490232.48937190819, 628597.59725949238],
						[490232.45295364485, 628536.21212168876],
						[490346.50093624817, 628536.14485510637],
						[490346.55502308614, 628628.38847405522],
						[490375.60773400066, 628628.3714647505],
						[490375.64361872798, 628689.75662709191],
						[490403.97505745251, 628689.74008944305],
						[490403.99297923711, 628720.48797865212],
						[490461.37691349507, 628720.45463183464],
						[490461.3413483568, 628659.06946123112],
						[490489.56981628301, 628659.05313056428],
						[490489.58751427929, 628689.69041192753],
						[490518.64011701837, 628689.67365502357],
						[490518.6578246493, 628720.42154435732],
						[490576.04175913939, 628720.38859720575],
						[490576.07689675898, 628781.77378418378],
						[490632.73945754027, 628781.74144746445],
						[490632.75701511174, 628812.59995302244],
						[490661.80940095813, 628812.58344876254],
						[490661.89647743956, 628966.10180957417],
						[490632.84436250344, 628966.11831367819],
						[490632.86192008748, 628996.9768436068],
						[490576.20010008349, 628997.00917989854],
						[490576.21757394652, 629027.53590164147],
						[490549.53505730926, 629027.55119660753],
						[490547.18328566919, 629058.4110948951],
						[490576.23523774213, 629058.39443963114],
						[490576.37604171864, 629304.37805703492],
						[490604.70642277296, 629304.36186481314],
						[490604.74132859899, 629365.52599712205],
						[490662.12301458017, 629365.49335001316],
						[490662.1403295378, 629396.02012012887],
						[490719.52190922748, 629395.98767307936],
						[490719.55663809757, 629457.59424683265],
						[490776.93800316768, 629457.56199991074],
						[490776.95529122546, 629488.4205951076],
						[490919.94485263154, 629488.34110864298]
					]
				],
				[
					[
						[489860.67364698491, 629765.24920453713],
						[489860.65484543942, 629734.72238687845],
						[489918.03524459404, 629734.68714624934],
						[489917.94115928921, 629581.05767880124],
						[489889.61125438864, 629581.0750528418],
						[489889.59250672458, 629550.54825933848],
						[489860.54142313125, 629550.56612628675],
						[489860.5221447536, 629519.26510671678],
						[489746.58399065037, 629519.33567558322],
						[489746.62249846634, 629581.16348835628],
						[489660.91165954975, 629581.21709404176],
						[489660.87282983935, 629519.38928146986],
						[489631.82169126556, 629519.407552024],
						[489631.7831704081, 629458.24338159291],
						[489488.69032902952, 629458.33412227733],
						[489488.72938151524, 629519.4982923771],
						[489431.34823232656, 629519.53502935008],
						[489431.3683266993, 629550.83604841295],
						[489403.14138781826, 629550.85419345507],
						[489403.16103749868, 629581.38098639192],
						[489431.3879240427, 629581.36284138099],
						[489431.4075923909, 629612.00024269905],
						[489546.16924631712, 629611.92696916382],
						[489546.18877132965, 629642.67497901595],
						[489660.22908926295, 629642.60295851901],
						[489660.96959155431, 629673.46112405427],
						[489774.90681636287, 629673.61117140064],
						[489774.92563944071, 629703.9167721495],
						[489800.16482092883, 629703.90111526009],
						[489804.11748782638, 629765.28413466341],
						[489860.67364698491, 629765.24920453713]
					]
				],
				[
					[
						[490233.32784767856, 630010.89774813177],
						[490233.30967124592, 629980.26029318105],
						[490261.63888920762, 629980.24351059506],
						[490261.60257636447, 629918.85800828203],
						[490233.27325276507, 629918.87479093019],
						[490233.20041582966, 629796.10383515549],
						[490290.58060103573, 629796.06989303685],
						[490290.52808821737, 629707.03333941917],
						[490261.47525248403, 629703.62176269875],
						[490261.45732508024, 629673.31616140879],
						[490204.07658039121, 629673.12899628212],
						[490204.09474505158, 629703.65580626484],
						[490147.53837428812, 629703.68955658609],
						[490147.55684240814, 629734.54818373604],
						[490090.17644277168, 629734.5826243622],
						[490090.21352755249, 629796.18928639474],
						[490061.16287743091, 629796.20679931366],
						[490061.21836720104, 629888.1191027665],
						[490118.59823168512, 629888.0845612],
						[490118.63507769909, 629949.47005502996],
						[490147.68545736308, 629949.45264352718],
						[490147.70392549998, 629980.31130334665],
						[490175.930128037, 629980.29443492019],
						[490175.94841125782, 630010.93188980571],
						[490233.32784767856, 630010.89774813177]
					]
				],
				[
					[
						[492122.25742743403, 630531.93962580012],
						[492122.24292470881, 630501.6339142198],
						[492150.46823339351, 630501.62043131771],
						[492150.4388572122, 630440.01357727824],
						[492207.81679805455, 630439.98631768557],
						[492207.78774132562, 630378.60068939591],
						[492265.16589622351, 630378.5736296929],
						[492265.15150082548, 630347.93612395902],
						[492292.65587820677, 630347.702014265],
						[492293.46569161915, 630317.17473146541],
						[492322.51542241051, 630317.16115778009],
						[492322.50092747132, 630286.08124141628],
						[492379.15831087111, 630286.05491534609],
						[492379.12999575614, 630224.8905368651],
						[492350.80119878636, 630224.90367557225],
						[492350.7725728525, 630163.29689481994],
						[492236.01476245304, 630163.35061745497],
						[492236.02931623202, 630194.20930799819],
						[492207.7004664687, 630194.22269295936],
						[492207.71502100106, 630224.97078294191],
						[492150.33633071964, 630224.9980428915],
						[492150.35099242243, 630255.74613690458],
						[492122.12526216672, 630255.75962001062],
						[492122.13981780602, 630286.17590405361],
						[492093.09003233677, 630286.18983133486],
						[492093.13444465626, 630378.6553592938],
						[492069.54450316262, 630378.66670669022],
						[492064.83550220117, 630440.05461818981],
						[492036.50707549654, 630440.06829774962],
						[492036.53687805106, 630501.67515158514],
						[492064.04110213433, 630501.66186934023],
						[492064.87980709411, 630531.96718360274],
						[492122.25742743403, 630531.93962580012]
					]
				],
				[
					[
						[525919.25459985435, 628430.72570574458],
						[525919.06097385858, 628553.71700981527],
						[525947.3926466353, 628553.76163697918],
						[525947.34401289152, 628584.62007675052],
						[526004.72842050088, 628584.71061625658],
						[526004.68020329531, 628615.23724868358],
						[526032.90874632355, 628615.28186028032],
						[526032.81133276713, 628676.88815581787],
						[526061.96698153135, 628676.93428339867],
						[526061.9184828205, 628707.57153148344],
						[526090.14686753182, 628707.61624121934],
						[526090.09814101155, 628738.36409704224],
						[526119.2536809087, 628738.4103260705],
						[526119.2050754003, 628769.04758203798],
						[526147.43335470534, 628769.09238999791],
						[526147.38452099927, 628799.84025373193],
						[526175.71577023366, 628799.8852738007],
						[526175.66670775751, 628830.74374534935],
						[526004.34023688012, 628830.47224123136],
						[526004.38897823088, 628799.61376917851],
						[525975.23354672093, 628799.56774356344],
						[525975.28205891198, 628768.81987932243],
						[525889.67001308594, 628768.68502805266],
						[525889.71819144976, 628738.04777141102],
						[525832.3343182964, 628737.9576327746],
						[525832.28624671989, 628768.5948895833],
						[525775.72666340508, 628768.50624146161],
						[525775.6302112441, 628830.1125790216],
						[525746.47483374248, 628830.06695851916],
						[525746.42709461937, 628860.59362380835],
						[525718.19897220202, 628860.54950340849],
						[525718.00684279064, 628983.54103622865],
						[525746.23475433048, 628983.58515629719],
						[525746.13875711616, 629044.97034289851],
						[525775.29375404073, 629045.01596280606],
						[525775.19764809089, 629106.40116539667],
						[525803.42534897593, 629106.44538352778],
						[525803.32913774892, 629167.83060211607],
						[525831.65975373238, 629167.87503011839],
						[525831.61133497395, 629198.73355143343],
						[525860.66303937044, 629198.77916088072],
						[525860.61473989557, 629229.52708215616],
						[525917.99689968536, 629229.61731935933],
						[525917.94831890357, 629260.47584857966],
						[525888.8967233802, 629260.43013804755],
						[525888.84906669334, 629290.73565109505],
						[525917.90060874063, 629290.78136154218],
						[525917.82556098932, 629338.45172020828],
						[525917.70698203275, 629413.77311887452],
						[525946.03717477969, 629413.81774370454],
						[525945.94008124771, 629475.42425073637],
						[525974.16714940639, 629475.46876161639],
						[525974.11846256594, 629506.32732325152],
						[526003.27264246903, 629506.37334688951],
						[526003.17533416499, 629567.97987807088],
						[526031.40224363259, 629568.02448709006],
						[526031.35397388146, 629598.55124818441],
						[526060.50799046701, 629598.59737317916],
						[526060.45949156571, 629629.23474242527],
						[526088.68629600352, 629629.2794496601],
						[526088.63756928791, 629660.02742710034],
						[526117.79147700465, 629660.07365353976],
						[526117.74252035737, 629690.93223922525],
						[526134.22491294029, 629691.17960562953],
						[526145.96886768867, 629691.19825318991],
						[526145.92073643324, 629721.50382155809],
						[526158.48880520521, 629721.52378696622],
						[526174.25039962481, 629721.5488391117],
						[526174.20133695449, 629752.40743278188],
						[526203.25206431036, 629752.45364678116],
						[526203.20347531908, 629782.98043156613],
						[526231.53303271602, 629783.02554768941],
						[526231.48351, 629814.10535797465],
						[526260.53412848059, 629814.15167305595],
						[526260.48543307523, 629844.67846576613],
						[526288.81488430314, 629844.72368047317],
						[526288.76595973771, 629875.361081457],
						[526317.0953581616, 629875.40634482563],
						[526317.04620405124, 629906.15435413108],
						[526346.09666009981, 629906.20082019665],
						[526346.04727471748, 629937.05943786353],
						[526374.27355136047, 629937.10463475995],
						[526374.22464465653, 629967.63144328957],
						[526403.37800763024, 629967.67817547894],
						[526403.32851467968, 629998.53680113901],
						[526431.55468591535, 629998.58209625108],
						[526431.50549521612, 630029.21951710456],
						[526459.8344510973, 630029.37563051155],
						[526459.78485211672, 630060.23426420731],
						[526546.21430045646, 630060.37340902048],
						[526546.16507452296, 630090.90023322206],
						[526631.87325934437, 630091.03866495762],
						[526631.82369554171, 630121.67609738465],
						[526717.53172013606, 630121.81497508823],
						[526717.48181730835, 630152.5630157803],
						[526889.51562969596, 630152.84311892395],
						[526889.46558619977, 630183.48055868689],
						[527032.55212330143, 630183.71489975892],
						[527032.5014502561, 630214.5735521263],
						[527146.43479176704, 630214.76103674038],
						[527146.0804091536, 630429.66567005927],
						[527175.12994138477, 630429.71359908243],
						[527175.02824171016, 630491.32036796678],
						[527231.68491853413, 630491.41399369109],
						[527231.63387118932, 630522.27268643235],
						[527375.43854716269, 630522.51120068517],
						[527375.38814989768, 630552.816873829],
						[527403.71638252679, 630552.86400710337],
						[527403.66464424774, 630583.94391681091],
						[527461.04208320682, 630584.0395323108],
						[527461.0939298122, 630552.95962278172],
						[527489.31915044098, 630553.00673153263],
						[527489.42128793488, 630491.8423668032],
						[527518.57372258091, 630491.89107390062],
						[527518.72773837124, 630399.75744138681],
						[527546.95322167501, 630399.80464895105],
						[527547.00485969591, 630368.94597360119],
						[527575.33340873476, 630368.99340220203],
						[527575.38454403053, 630338.46654470777],
						[527632.76283859834, 630338.56275873492],
						[527632.8150085808, 630307.48288277339],
						[527661.86475642247, 630307.53167070914],
						[527661.91586612037, 630277.11542612792],
						[527747.62308142579, 630277.25966684707],
						[527747.67490876256, 630246.51161301532],
						[527805.05352383945, 630246.608427561],
						[527805.10545834433, 630215.86037799495],
						[527833.33125695447, 630215.90807658038],
						[527833.38343117724, 630185.04942671128],
						[527890.76226047997, 630185.14653999382],
						[527890.81416747102, 630154.5091033295],
						[527948.19310322311, 630154.60641678772],
						[527948.24530476937, 630123.85837991664],
						[527976.57427556731, 630123.90649899794],
						[527976.65246927785, 630077.89505589218],
						[527976.67822057009, 630062.74225090933],
						[528005.72840028908, 630062.79164564889],
						[528005.78089715051, 630031.9330167541],
						[528034.11021448649, 630031.87063044531],
						[528034.18856853875, 629985.85920590069],
						[528034.42400730681, 629847.60377840768],
						[528062.6504373271, 629847.6518701812],
						[528062.80749161344, 629755.51849929627],
						[528120.18781804584, 629755.61641223915],
						[528120.50237976946, 629571.46038537635],
						[528092.27547618991, 629571.4121944129],
						[528092.32888854586, 629540.11121447198],
						[528063.1747683835, 629540.06149130571],
						[528063.2264284346, 629509.75595281716],
						[528034.99941906123, 629509.70786005503],
						[528035.05196889653, 629478.84930475615],
						[528006.72188805183, 629478.80108504894],
						[528006.97308200784, 629331.14461321488],
						[528007.03592751164, 629294.20285888622],
						[528035.36632602045, 629294.25107913732],
						[528035.47048384044, 629233.08704984491],
						[528063.69796750508, 629233.13514341135],
						[528063.75038164877, 629202.38722887437],
						[528121.13263602229, 629202.48514510575],
						[528121.16286411206, 629184.78850559134],
						[528121.23748970556, 629141.09993254207],
						[528150.39231639239, 629141.14975854079],
						[528150.60224109644, 629018.37938227609],
						[528178.83009289787, 629018.42767324531],
						[528178.88291064766, 628987.56918352353],
						[528207.21383682347, 628987.61769949493],
						[528207.26651817036, 628956.86981783144],
						[528236.31864936964, 628956.91961947666],
						[528236.42393085815, 628895.53447233432],
						[528264.75501541421, 628895.58308732847],
						[528265.01876793499, 628741.95438487711],
						[528294.07127838756, 628742.00428843428],
						[528294.33511175669, 628588.48629117757],
						[528265.28233039984, 628588.4363871502],
						[528265.33530871209, 628557.57795453083],
						[528151.39049791684, 628557.38272611867],
						[528151.44307353441, 628526.63490088633],
						[527893.5729111752, 628526.19598847313],
						[527893.62481779896, 628495.55877012364],
						[527836.24009943684, 628495.46164687932],
						[527836.18829960038, 628526.0988654017],
						[527721.41907543829, 628525.90521930705],
						[527721.36730293487, 628556.6530459018],
						[527664.80699149845, 628556.5579079662],
						[527664.75513876835, 628587.41634249466],
						[527549.98634205572, 628587.22389145207],
						[527550.03797967301, 628556.36545656389],
						[527407.04032212717, 628556.12678915146],
						[527406.93813529878, 628617.51185270213],
						[527378.60657222557, 628617.46471388184],
						[527378.40204189508, 628740.45609727839],
						[527349.34952871711, 628740.40780955239],
						[527349.29863411305, 628771.04506180086],
						[527263.58357693325, 628770.90289491322],
						[527263.63431202923, 628740.265642407],
						[527234.58179851284, 628740.21755719907],
						[527234.63266250468, 628709.46970484033],
						[527206.30125767598, 628709.42286253325],
						[527206.35188597383, 628678.78561789566],
						[527178.02042834519, 628678.738824256],
						[527178.172520202, 628586.60590672621],
						[527149.11973552732, 628586.55797233549],
						[527149.17062178743, 628555.69953619549],
						[527091.78611305309, 628555.60500773741],
						[527091.8367097507, 628524.85717918829],
						[527063.60801167844, 628524.81075196422],
						[527063.65837383142, 628494.17353103997],
						[527035.32659851236, 628494.1269829548],
						[527035.37708956061, 628463.37916229689],
						[527006.32408743782, 628463.3314798933],
						[527006.37470564758, 628432.47305953573],
						[526978.04282415146, 628432.42661002581],
						[526978.09284554364, 628401.90000455547],
						[526949.03973492899, 628401.8524232395],
						[526949.09024556866, 628370.99401079863],
						[526920.75825827906, 628370.94765986409],
						[526920.95900325605, 628248.17767179676],
						[526949.29120181408, 628248.22402307403],
						[526949.39204197994, 628186.61784626753],
						[526921.05973740714, 628186.5714948175],
						[526921.1601098252, 628125.18654104439],
						[526892.82769953716, 628125.14023817389],
						[526892.87792325241, 628094.39246548084],
						[526863.82427000091, 628094.34503454028],
						[526863.87389805051, 628063.92907622177],
						[526806.48767525109, 628063.83554216998],
						[526806.53791760164, 628032.97717377113],
						[526778.20534863288, 628032.93106814753],
						[526778.25535798585, 628002.18330716947],
						[526750.02576374635, 628002.13741760887],
						[526750.12549729017, 627940.75251098489],
						[526692.73884516477, 627940.6593734069],
						[526692.78905323101, 627909.69041742268],
						[526663.73507404514, 627909.64333956828],
						[526663.78504833858, 627878.78499097668],
						[526635.45221402613, 627878.73913100967],
						[526635.50159842847, 627848.21259652067],
						[526549.78173667367, 627848.07414592372],
						[526549.83078378206, 627817.65821851022],
						[526463.38956084894, 627817.51905474497],
						[526463.43915935152, 627786.66071760224],
						[526406.87620266271, 627786.56990120606],
						[526406.92622732453, 627755.37975793693],
						[526320.4846774207, 627755.24134443956],
						[526320.43481651193, 627786.43148797215],
						[526292.10182327894, 627786.38621885923],
						[526292.00397500023, 627847.66048469022],
						[526320.33686279226, 627847.70575363596],
						[526320.23873223504, 627909.09063869063],
						[526349.29271240334, 627909.1371103928],
						[526349.19411947927, 627970.74321820622],
						[526377.42376755143, 627970.78842050419],
						[526377.37450686481, 628001.53617866104],
						[526406.53135161928, 628001.58291643613],
						[526406.46642592398, 628042.06378392468],
						[526406.43254392955, 628063.18904814706],
						[526434.66203349491, 628063.23434858408],
						[526434.61319836741, 628093.65030818852],
						[526462.94566284411, 628093.69582253601],
						[526462.89624204813, 628124.44359652908],
						[526491.949842192, 628124.49031997472],
						[526491.90018916386, 628155.3487014398],
						[526520.23254746955, 628155.39431437093],
						[526520.18337580713, 628185.92088919703],
						[526549.23686746368, 628185.96771373041],
						[526549.08812070766, 628278.21108328376],
						[526520.0347918272, 628278.16425901675],
						[526519.98526382225, 628308.91205702059],
						[526462.59989491408, 628308.81972159271],
						[526462.55029630114, 628339.67812742258],
						[526405.98923946684, 628339.58731407707],
						[526405.94027903583, 628370.11391325947],
						[526319.50195657893, 628369.97550493421],
						[526319.45262598025, 628400.83391928126],
						[526148.01865604485, 628400.56075526471],
						[526147.97017373447, 628431.08736321644],
						[525919.25459985435, 628430.72570574458]
					]
				],
				[
					[
						[490405.53297216009, 631362.60956390738],
						[490405.49732158851, 631301.444904231],
						[490491.09619731945, 631301.39523459831],
						[490491.07837133796, 631270.53639791149],
						[490595.63074442174, 631270.47633418953],
						[490605.8284635871, 631270.47051129839],
						[490605.81091584481, 631239.72228375473],
						[490634.13796646742, 631239.70614218013],
						[490634.12940784573, 631224.66384529509],
						[490634.84146226058, 631208.84690335742],
						[490662.34450481128, 631208.83127917442],
						[490663.15125092171, 631178.30380256078],
						[490720.52661846316, 631178.27135902643],
						[490720.50922272477, 631147.41253858083],
						[490748.83643219818, 631147.39659438631],
						[490748.80193341454, 631086.01078099816],
						[490777.85030747956, 631085.99448151677],
						[490777.7986908271, 630993.8604895015],
						[490806.12616453494, 630993.84464389645],
						[490806.0918797343, 630932.45887127868],
						[490834.31644973007, 630932.4431317125],
						[490834.29914441128, 630901.36313411943],
						[490977.37944315292, 630901.28408920718],
						[490977.34591841954, 630840.11955071765],
						[491063.77127273602, 630840.07240737951],
						[491063.80447634641, 630901.23694603611],
						[491092.13210944878, 630901.22159260523],
						[491092.14892796503, 630932.30159046454],
						[491235.12594840571, 630932.2248415848],
						[491235.10939983622, 630901.1448435809],
						[491263.43703309813, 630901.1297849355],
						[491263.42083152104, 630870.60281585925],
						[491292.46958570514, 630870.58742449887],
						[491292.45337949489, 630839.9498544907],
						[491320.78111806535, 630839.93489452545],
						[491320.76502289425, 630809.40793348197],
						[491349.8138850698, 630809.39264331688],
						[491349.79743692389, 630778.09145192138],
						[491378.12528194184, 630778.07659063337],
						[491378.1094090371, 630747.77084750228],
						[491407.15837997792, 630747.75565852958],
						[491407.12622152176, 630686.14874035202],
						[491521.05630014132, 630686.08966396924],
						[491521.07213769807, 630716.83781867055],
						[491550.22417395149, 630716.82282910321],
						[491550.24001382914, 630747.68159282312],
						[491606.7927980143, 630747.65266138734],
						[491606.80824991228, 630777.95840473939],
						[491635.85716758354, 630777.94361933868],
						[491635.84176916466, 630747.63787596114],
						[491693.21863778721, 630747.60882273805],
						[491693.20306593471, 630716.75005887938],
						[491721.53101651004, 630716.73578854464],
						[491721.50003464171, 630655.12887800334],
						[491749.72508014471, 630655.11470798589],
						[491749.70978061075, 630624.58777094469],
						[491778.86198023288, 630624.57318627206],
						[491778.83132358186, 630563.18750980496],
						[491807.05652672518, 630563.17343809374],
						[491807.04105836037, 630532.09348917089],
						[491835.36932670529, 630532.07941473485],
						[491836.17839242454, 630501.77329470799],
						[491864.40370086668, 630501.75932131987],
						[491864.35800341784, 630409.29374482401],
						[491836.13253643119, 630409.3077182913],
						[491836.08695471904, 630317.39520228491],
						[491806.93421111524, 630317.40968562081],
						[491806.90360470739, 630255.91348596453],
						[491692.97054885607, 630255.9705840291],
						[491693.00158087263, 630317.46678347292],
						[491664.77595644188, 630317.48105074291],
						[491663.98293515766, 630378.8670790412],
						[491635.65440316178, 630378.88144840719],
						[491635.66991395294, 630409.40835289494],
						[491578.29186653334, 630409.43760670151],
						[491578.3076534812, 630440.29632940446],
						[491520.92971372063, 630440.32578315178],
						[491520.94555125921, 630471.07390515518],
						[491492.72019020462, 630471.08846743172],
						[491492.73613762221, 630501.94719827233],
						[491463.5837208411, 630501.96228965244],
						[491463.59943613649, 630532.268000621],
						[491435.37418000743, 630532.28266122064],
						[491435.3584127475, 630501.97695027478],
						[491377.98068797815, 630502.00690227177],
						[491377.93225830689, 630409.54132716649],
						[491406.98182610358, 630409.52613788517],
						[491406.96589123592, 630378.99923361558],
						[491434.47032028536, 630378.98489948816],
						[491435.26248572971, 630317.59886014042],
						[491463.48810995615, 630317.58419934823],
						[491463.45622055716, 630256.08800034621],
						[491435.23049088859, 630256.10266119242],
						[491435.2144934719, 630225.35456784209],
						[491406.88569730474, 630225.36933088338],
						[491406.85353891988, 630163.7625518759],
						[491292.91984530602, 630163.82241866249],
						[491292.11205496802, 630194.68154422636],
						[491263.06210804178, 630194.69693621853],
						[491263.0947459077, 630256.1931184947],
						[491234.76600280922, 630256.20817772928],
						[491234.84768539772, 630409.61689056223],
						[491206.62221896864, 630409.63194337569],
						[491206.63870262745, 630440.49066571612],
						[491177.48617701547, 630440.5062637442],
						[491177.45327823109, 630379.12063739193],
						[491149.22775951482, 630379.13578861917],
						[491149.19475548674, 630317.750178613],
						[491006.10938475165, 630317.82773015846],
						[491006.12606289849, 630348.35462592496],
						[490977.07638715475, 630348.37052258512],
						[490977.14380022808, 630471.36298390862],
						[491006.19325893436, 630471.34708737594],
						[491006.21011837758, 630502.20581773226],
						[491034.53843814926, 630502.19036518503],
						[491034.57187012298, 630563.57602389809],
						[491006.24365598668, 630563.59147638874],
						[491006.27719360206, 630624.97715134604],
						[490977.22800599801, 630624.99304773426],
						[490977.26165194664, 630686.37873894698],
						[490948.93364913261, 630686.39429005538],
						[490948.9505553387, 630717.14244419313],
						[490720.26674257376, 630717.26976901095],
						[490720.24940922152, 630686.52161511406],
						[490691.20033022633, 630686.53801624104],
						[490691.18288006872, 630655.6792616219],
						[490605.47763544257, 630655.727949586],
						[490605.46021398925, 630625.20101367787],
						[490577.13210590207, 630625.21720459952],
						[490577.06183011725, 630502.44587277307],
						[490605.39014947909, 630502.42968172953],
						[490605.37253867288, 630471.57095179253],
						[490577.04416621308, 630471.58714286424],
						[490577.02656561736, 630440.83902182104],
						[490462.37370246009, 630440.90504954732],
						[490462.3025716641, 630318.13381610636],
						[490347.54584068095, 630318.20070325781],
						[490347.58183399582, 630379.58631158713],
						[490227.26283810614, 630379.65729983617],
						[490204.49700075859, 630379.67083062953],
						[490204.53352763737, 630441.05645492824],
						[490176.20510265953, 630441.07333578356],
						[490176.24186719098, 630502.68018585758],
						[490204.57018614886, 630502.66330506455],
						[490204.62500940566, 630594.79709901439],
						[490233.67425029364, 630594.77983924933],
						[490233.69242677715, 630625.41737553698],
						[490262.02053452301, 630625.40059360815],
						[490262.03859285905, 630655.92752914526],
						[490291.08772587043, 630655.91037069459],
						[490291.10592603992, 630686.76912488323],
						[490262.05684748088, 630686.78628329991],
						[490262.09329130442, 630748.393199087],
						[490319.47015730263, 630748.35935767367],
						[490319.48797915771, 630778.66509971709],
						[490291.16013515543, 630778.68178275623],
						[490291.19660074578, 630840.50993300567],
						[490262.14779348695, 630840.52709126659],
						[490262.16591726459, 630871.16466019826],
						[490233.83823243744, 630871.18144187785],
						[490233.89289319876, 630963.31538298819],
						[490262.22041947744, 630963.29860140209],
						[490262.23867412482, 630994.15739666135],
						[490233.91120094818, 630994.17417821637],
						[490233.94775083917, 631055.78117602575],
						[490259.90592001291, 631055.76579620759],
						[490262.32948938932, 631147.67719935416],
						[490291.37775463791, 631147.66004141909],
						[490291.48649927555, 631332.03878716053],
						[490319.81339103333, 631332.02210468496],
						[490319.83140806749, 631362.65973904938],
						[490405.53297216009, 631362.60956390738]
					]
				],
				[
					[
						[531295.26585821109, 630682.79500118655],
						[531295.32389285916, 630652.26811547531],
						[531266.27475335414, 630652.2129157458],
						[531266.33294420189, 630621.57542932371],
						[531238.00482981035, 630621.52164907078],
						[531238.06317781028, 630590.77356199152],
						[531151.63651408779, 630590.60978425969],
						[531151.5787461272, 630621.13666236866],
						[531123.3532240825, 630621.30448362546],
						[531123.2952993433, 630651.94197054603],
						[531094.96723720676, 630651.88843643968],
						[531094.90957410412, 630682.41532285907],
						[531065.86048780254, 630682.36047679349],
						[531065.68599022483, 630774.82599826041],
						[531094.73491335835, 630774.88084402285],
						[531094.67766807391, 630805.1865372404],
						[531123.00546640507, 630805.24007084826],
						[531122.94628693047, 630836.54121062788],
						[531180.2198354596, 630836.64959456131],
						[531180.16201356426, 630867.17650508496],
						[531237.53846529464, 630867.2852835604],
						[531237.36342106038, 630959.52966755698],
						[531265.69095379161, 630959.58344670245],
						[531265.63297293428, 630990.1103731785],
						[531294.68151616817, 630990.16557177494],
						[531294.6228506238, 631021.02431666735],
						[531322.95027752803, 631021.0781943514],
						[531322.8926111788, 631051.38391906011],
						[531351.21998584142, 631051.43784539436],
						[531351.1022316477, 631113.26596015878],
						[531380.15055755479, 631113.32130957814],
						[531379.97471135785, 631205.56579040224],
						[531408.30182069424, 631205.61981496343],
						[531407.83289593342, 631451.38406698627],
						[531436.88062517857, 631451.43951651617],
						[531436.82232499332, 631481.96650754113],
						[531465.14895869, 631482.02062992705],
						[531465.08997169568, 631512.87944009644],
						[531579.73536782805, 631513.09898562473],
						[531579.79414535803, 631482.4613859664],
						[531608.1212029676, 631482.29454429366],
						[531608.41556650284, 631328.99600288668],
						[531580.08866947389, 631328.94163396046],
						[531580.32462813484, 631205.94893824239],
						[531551.27646568022, 631205.89323558402],
						[531551.45327181485, 631113.64875659812],
						[531523.22901245416, 631113.59468295309],
						[531523.34741315339, 631051.76656942652],
						[531494.19596998952, 631051.71077023796],
						[531494.25395171461, 631021.40504612681],
						[531466.02953419636, 631021.35107055865],
						[531466.14687365375, 630959.96540051291],
						[531437.81934158085, 630959.91127641057],
						[531437.93699783855, 630898.3044129702],
						[531408.88829250284, 630898.24896157661],
						[531409.00499586947, 630837.08453333494],
						[531380.67725233478, 630837.03050756431],
						[531380.79469380062, 630775.42367649614],
						[531351.74577162333, 630775.36832594092],
						[531351.86310433934, 630713.76151110278],
						[531323.53514858847, 630713.70758366666],
						[531323.59302531555, 630683.29129864078],
						[531295.26585821109, 630682.79500118655]
					]
				],
				[
					[
						[526286.01840221894, 631595.9286407578],
						[526286.06750376942, 631565.1804063397],
						[526314.39399427385, 631565.22566506593],
						[526314.44297192269, 631534.58803998632],
						[526342.66650946136, 631534.6331826949],
						[526343.53940904688, 631504.10748566838],
						[526371.76335324347, 631503.93146802322],
						[526371.81243747228, 631473.29385129642],
						[526400.96348884958, 631473.11936900089],
						[526401.01244993275, 631442.59236156452],
						[526429.23614520626, 631442.63765270263],
						[526429.28569138166, 631411.77883417474],
						[526457.61244586413, 631411.82433935336],
						[526458.35287871852, 630951.15465622349],
						[526430.02533149102, 630951.10914977023],
						[526430.17343692284, 630858.86471858493],
						[526401.94874071795, 630858.81942583795],
						[526402.04790438456, 630796.99134435505],
						[526372.89601004508, 630796.94461451937],
						[526372.94456252758, 630766.63890612556],
						[526344.71970819344, 630766.59371150355],
						[526344.76909375284, 630735.73498323478],
						[526315.72010154801, 630735.68851950881],
						[526315.76925583184, 630704.94040001486],
						[526287.44128490728, 630704.89513892634],
						[526287.49056289671, 630674.03641871875],
						[526259.16253878991, 630673.99120629474],
						[526259.21123437211, 630643.46430425718],
						[526230.16207933659, 630643.41799150989],
						[526230.21089728002, 630612.78048872738],
						[526156.35173760995, 630612.66296674241],
						[526144.50542883039, 630612.64414817223],
						[526144.55426291749, 630581.89604451181],
						[526116.32909182925, 630581.85124148603],
						[526116.3783996047, 630550.77132783295],
						[526059.00084469758, 630550.68039916083],
						[526059.0488185304, 630520.37472207996],
						[526001.67115767766, 630520.2839932323],
						[526001.71989938151, 630489.42529676366],
						[525944.34213065228, 630489.33476773195],
						[525944.39059047576, 630458.58667983988],
						[525887.01271426142, 630458.49635063554],
						[525887.06124083651, 630427.63766204379],
						[525829.68325674976, 630427.54753265833],
						[525829.63483772997, 630458.40622141422],
						[525801.3064425583, 630458.36179689015],
						[525801.2582499925, 630489.10988520714],
						[525773.0329198119, 630489.06567079225],
						[525772.93715959706, 630550.23004584038],
						[525715.55960280413, 630550.1403142343],
						[525715.51105177065, 630581.22022907983],
						[525658.13360299682, 630581.13069763524],
						[525658.18204570131, 630550.05078261415],
						[525515.09869278537, 630549.82838734693],
						[525515.05052022403, 630580.90830278164],
						[525457.67307036032, 630580.81947003724],
						[525457.57813921105, 630642.20508075424],
						[525430.07414990023, 630642.16256952076],
						[525429.30591485242, 630672.68836006953],
						[525314.55165461905, 630672.51149228949],
						[525314.59859849012, 630641.98458750732],
						[525286.27051923482, 630641.9410492857],
						[525286.45910390012, 630519.16984218382],
						[525314.78739442723, 630519.21338073676],
						[525314.97653044085, 630396.22102995007],
						[525229.26993452129, 630396.0894544269],
						[525229.316888912, 630365.45198129187],
						[525200.26758191653, 630365.18627677357],
						[525200.17361194, 630426.57183182437],
						[525171.84516198968, 630426.52849050704],
						[525171.797976122, 630457.38718117482],
						[525200.12637296913, 630457.43052241288],
						[525200.03206432541, 630519.03731127165],
						[525171.70377349551, 630518.99397019506],
						[525171.65743323474, 630549.29964981391],
						[525143.3291944766, 630549.2563575746],
						[525143.23475995753, 630611.08438066358],
						[525114.18554778968, 630611.04003722721],
						[525114.13880692306, 630641.67754325282],
						[525085.91373833315, 630641.6345069661],
						[525085.86721853993, 630672.16141239984],
						[525056.7151031401, 630672.11701339902],
						[525056.48058578244, 630826.18946405058],
						[525085.63242833153, 630826.23386263207],
						[525085.44533767493, 630949.00523544999],
						[525111.30066590779, 630949.04465660453],
						[525113.5762286298, 631010.43398168334],
						[525085.35179230606, 631010.39094636531],
						[525084.97727349214, 631256.15516357438],
						[525055.82619229332, 631256.11076615134],
						[525055.59251611261, 631409.6305817205],
						[525198.66839577758, 631409.84898300248],
						[525198.62115660275, 631440.70780515042],
						[525341.59375994815, 631440.92729103554],
						[525341.54676357051, 631471.45430155634],
						[525541.99645064911, 631471.76411497465],
						[525541.94856765855, 631502.62294436793],
						[525714.07127747231, 631502.89092374034],
						[525714.02324458165, 631533.63915162976],
						[525914.36916876887, 631533.95333865378],
						[525914.32093575876, 631564.59096491733],
						[526028.24493390694, 631564.77071063919],
						[526028.19631395477, 631595.51894581644],
						[526286.01840221894, 631595.9286407578]
					]
				],
				[
					[
						[529890.73265724187, 631632.93861107295],
						[529890.78869326762, 631602.07977889245],
						[529914.37688157265, 631602.12262922537],
						[529919.89204601792, 631571.38432853948],
						[529948.21852583974, 631571.43584052077],
						[529948.2742669445, 631540.79822700052],
						[529977.32183840591, 631540.85110091418],
						[529977.43363015051, 631479.46528126055],
						[529948.38635282358, 631479.1911970143],
						[529948.4980362124, 631417.80539360491],
						[529920.17129201337, 631417.7538811476],
						[529920.22718140192, 631387.00568298216],
						[529891.1793384559, 631386.9529098192],
						[529891.29040614434, 631325.78834059741],
						[529862.96350359812, 631325.73692658229],
						[529863.0194864457, 631294.87813552632],
						[529834.7955378202, 631294.82695685478],
						[529835.01845562563, 631171.83425329358],
						[529805.86722509598, 631171.78144397982],
						[529806.03364920313, 631079.86877374607],
						[529777.80933192605, 631079.81769278587],
						[529777.86595456721, 631048.51651492389],
						[529806.09032551036, 631048.56759598886],
						[529806.30181017402, 630931.76889245154],
						[529835.46429087676, 630925.84904316301],
						[529835.74213580636, 630772.55083898886],
						[529806.59019817959, 630772.49802839488],
						[529806.70174820931, 630710.89120281604],
						[529778.47679828689, 630710.84012070869],
						[529778.58784249553, 630649.45452071249],
						[529749.43568687781, 630649.40181133372],
						[529749.49105467624, 630618.76431968564],
						[529721.26594679547, 630618.71333566646],
						[529721.32146174612, 630587.96524333872],
						[529663.9440364578, 630587.86174964625],
						[529664.00004215713, 630556.78184733423],
						[529492.69153300056, 630556.47404200607],
						[529492.63585073082, 630587.55394489586],
						[529349.55282364448, 630587.29822113726],
						[529349.49800309807, 630618.04631471413],
						[529292.12068265688, 630617.94411700277],
						[529292.06616608647, 630648.58161018323],
						[529263.01702008303, 630648.52994550951],
						[529262.96275418566, 630679.05683815177],
						[529234.63473871246, 630679.0065053947],
						[529234.57993606513, 630709.86521628348],
						[529206.25197361247, 630709.81493236928],
						[529206.19742029742, 630740.56304275396],
						[529177.14843660523, 630740.5115296056],
						[529177.09374149877, 630771.37024892098],
						[529206.14267073735, 630771.42176197306],
						[529206.08890234423, 630801.72746156075],
						[529177.04002658732, 630801.67594860494],
						[529176.65814080182, 631017.13410345325],
						[529148.33070711233, 631017.08391920768],
						[529148.27704429126, 631047.38965127803],
						[529119.22860204382, 631047.33824033616],
						[529119.17323180533, 631078.63942043576],
						[529093.2150986559, 631078.59352220502],
						[529090.8408203068, 631139.75402642041],
						[529119.0650348186, 631139.80392951309],
						[529118.95605518401, 631201.41087460471],
						[529148.00422554952, 631201.4622850623],
						[529147.95017098822, 631231.98925129755],
						[529205.32535117515, 631232.09094649635],
						[529205.27060149971, 631262.94973150501],
						[529259.55545445136, 631263.04613333568],
						[529261.86996332498, 631293.79852867289],
						[529319.2449280764, 631293.90062093735],
						[529319.29969452356, 631263.15243715513],
						[529348.34775593388, 631263.20420115476],
						[529348.40277383185, 631232.345416622],
						[529405.7779527735, 631232.44781049818],
						[529405.55824124487, 631355.44055262348],
						[529433.88509267243, 631355.49117951468],
						[529433.66556491901, 631478.26277686446],
						[529461.88919902651, 631478.31326776359],
						[529461.77893392835, 631539.9203010354],
						[529490.92951252079, 631539.97250099899],
						[529490.87462264753, 631570.61011605733],
						[529576.47209816275, 631570.76369387633],
						[529576.41685023007, 631601.51191786537],
						[529662.11717024713, 631601.66612612223],
						[529662.1725782617, 631570.91790242214],
						[529691.22009657405, 631570.97027146653],
						[529691.27535934048, 631540.33265708236],
						[529719.60189259646, 631540.38377564633],
						[529719.65700838447, 631509.85677052697],
						[529777.03162022319, 631509.73924824176],
						[529776.97599787242, 631540.4874633369],
						[529805.19952529215, 631540.5385428695],
						[529805.08837539982, 631601.92438008997],
						[529833.41480266966, 631601.97569451004],
						[529834.18291417731, 631632.83602039726],
						[529890.73265724187, 631632.93861107295]
					]
				],
				[
					[
						[498761.04160239501, 632957.66843370709],
						[498761.03928781638, 632926.91997439438],
						[498904.10198043153, 632926.90982740617],
						[498904.09789315856, 632865.52352711512],
						[498989.68863542075, 632865.51805094571],
						[498989.6867412093, 632834.65899811371],
						[499018.01104717475, 632834.65728391404],
						[499018.00921266875, 632803.90884115419],
						[499047.05455522984, 632803.90713393933],
						[499047.0492144837, 632711.66183051758],
						[499075.37373210979, 632711.66021502914],
						[499075.37201720109, 632681.13300052006],
						[499132.74214658159, 632681.1298777659],
						[499132.74052059621, 632650.27084985399],
						[499161.06514386402, 632650.26938182907],
						[499161.06043648475, 632557.9135346713],
						[499132.73565428396, 632557.91500270471],
						[499132.73405160935, 632527.49841451482],
						[499161.05888615514, 632527.49694647861],
						[499161.05575729872, 632466.11075354647],
						[499190.10169595538, 632466.10929875483],
						[499190.10017752793, 632435.25029988401],
						[499218.42517081468, 632435.24893056485],
						[499218.4222506716, 632373.75215670071],
						[499190.09715155698, 632373.75352601998],
						[499190.09565489797, 632343.33696232806],
						[499132.72434813762, 632343.33988518419],
						[499132.72272215469, 632312.48090288613],
						[499104.39751760295, 632312.48241968313],
						[499104.3874731593, 632127.8816411728],
						[499218.41057535243, 632127.87583212403],
						[499218.41349024308, 632189.26193430147],
						[499247.4599174413, 632189.26058072783],
						[499247.46132830955, 632220.11954642204],
						[499361.38079022954, 632220.11473246198],
						[499361.37959293555, 632189.25576676498],
						[499418.75143675326, 632189.25364088977],
						[499418.74601541791, 632035.73311345803],
						[499390.4203346236, 632035.73413805268],
						[499390.41919997678, 632005.09640822292],
						[499418.74493349262, 632005.09538361989],
						[499418.74059018039, 631882.10208342341],
						[499390.41464500921, 631882.10310802935],
						[499390.41123288183, 631789.96878158534],
						[499418.73733659962, 631789.96775697661],
						[499418.73191137053, 631636.33689153334],
						[499390.40554327611, 631636.33791615348],
						[499390.404412726, 631605.81084498682],
						[499333.13354048564, 631605.81306549453],
						[499333.13229028718, 631574.95418246288],
						[499303.98177369003, 631574.95538920746],
						[499303.98047351895, 631544.2071156163],
						[499161.00876820018, 631544.21378172247],
						[499161.00720659987, 631513.57611753221],
						[499104.35404790787, 631513.57910253247],
						[499104.35237484419, 631482.83083717257],
						[499046.97806879098, 631482.83405889012],
						[499046.97628214827, 631451.97519239725],
						[499017.92855390004, 631451.97689975367],
						[499017.92673259752, 631421.44985311048],
						[498989.59999471711, 631421.45156745752],
						[498989.59433248552, 631329.20682070777],
						[498960.54638759402, 631329.20862932468],
						[498960.54832227947, 631359.84626892349],
						[498932.32448509306, 631359.84807532828],
						[498932.32647948375, 631390.59632422309],
						[498903.99968850927, 631390.59818587219],
						[498904.00377575326, 631451.98409073753],
						[498817.58163395972, 631451.99007167143],
						[498817.58385064226, 631482.8489381359],
						[498760.93058620259, 631482.85310509102],
						[498760.93457424804, 631535.83303243504],
						[498760.93520700664, 631544.23903455061],
						[498731.88764157239, 631544.24124667421],
						[498731.88859591779, 631556.62903983076],
						[498731.89238774148, 631605.84840316663],
						[498686.36410451995, 631605.85197351198],
						[498674.51851047081, 631605.85292309732],
						[498674.51950799546, 631618.24071957066],
						[498674.52591174911, 631697.76596464415],
						[498474.90301548713, 631697.78324930649],
						[498474.90587462881, 631728.64214872953],
						[498445.8586345996, 631728.64486558922],
						[498445.86153775133, 631759.39316376322],
						[498417.53538142215, 631759.39586254617],
						[498417.5412829225, 631820.78186580841],
						[498360.16815480281, 631820.78748140577],
						[498360.17122906219, 631851.64639734488],
						[498217.20219407137, 631851.661260981],
						[498217.20884271146, 631913.04728885158],
						[498188.05892484949, 631913.0504717984],
						[498188.06230961112, 631943.79879463464],
						[498159.83947366645, 631943.80192553508],
						[498159.84633626894, 632005.1879780537],
						[498131.52060291561, 632005.19116902491],
						[498131.5275711547, 632066.57723797183],
						[498144.09384963254, 632066.57581633131],
						[498159.85319887195, 632066.57404701202],
						[498159.88069876615, 632312.56091004773],
						[498188.10290244292, 632312.55777921819],
						[498188.1198141122, 632466.18909720075],
						[498217.26875241479, 632466.18591436162],
						[498217.27540107007, 632527.57210701914],
						[498274.64606569341, 632527.56599336746],
						[498274.65252357814, 632589.17341412569],
						[498331.19898138981, 632589.16758398642],
						[498331.20518277452, 632650.33259808295],
						[498388.57541951427, 632650.32688153372],
						[498388.58142936422, 632711.71312374796],
						[498417.62693461956, 632711.71030580904],
						[498417.63285741367, 632773.31777631945],
						[498503.32707702392, 632773.3097611207],
						[498503.32986296044, 632803.9475937743],
						[498531.65422177623, 632803.94504263345],
						[498531.65696485457, 632834.69348532241],
						[498560.70225309359, 632834.69091986062],
						[498560.70495158655, 632865.54997263593],
						[498618.07443818753, 632865.54505600489],
						[498618.07959219295, 632926.93135621096],
						[498646.30074247415, 632926.92901100405],
						[498646.30327140022, 632957.67747029988],
						[498684.82403960801, 632957.67434728227],
						[498761.04160239501, 632957.66843370709]
					]
				],
				[
					[
						[483141.09035676351, 634686.62863427785],
						[483141.05885836942, 634655.87995777489],
						[483170.10093287606, 634655.85023327835],
						[483170.06960185658, 634625.21216764348],
						[483226.71205134614, 634625.15434166475],
						[483227.46417948062, 634655.79167270381],
						[483255.78535157582, 634655.76283411041],
						[483255.81663561828, 634686.51151083154],
						[483282.48998064076, 634686.48439474264],
						[483284.1067484087, 634655.95525774895],
						[483341.3667846492, 634655.67598528962],
						[483341.30487224041, 634594.51046424208],
						[483370.45004150434, 634594.48098904174],
						[483370.38901976135, 634534.0897312453],
						[483341.24251202092, 634532.90253302618],
						[483341.14913965343, 634440.65657766536],
						[483312.93058481853, 634440.68516493728],
						[483312.86834330147, 634379.29848899972],
						[483283.82578077854, 634379.32796156581],
						[483283.79477437754, 634348.80053979426],
						[483255.4730740416, 634348.82933018194],
						[483255.44145244919, 634317.74887969252],
						[483169.75527393149, 634317.83628065628],
						[483169.72405606828, 634287.30886741332],
						[483112.35952511756, 634287.36762924562],
						[483112.39084938669, 634317.89504237811],
						[483084.1720840651, 634317.92402187223],
						[483084.330217688, 634471.77782225981],
						[483026.96632970549, 634471.8368817328],
						[483026.99781274429, 634502.36431960412],
						[482997.85248035198, 634502.39440302155],
						[482997.88436024933, 634533.25366500521],
						[482941.34458131419, 634533.31217178865],
						[482941.47183713998, 634656.08562099573],
						[482969.79300873238, 634656.05629025656],
						[482969.82482710795, 634686.80496642541],
						[483027.18796581973, 634686.74570778513],
						[483027.21956295613, 634717.3837814841],
						[483112.80067559949, 634717.29574409756],
						[483112.76969176036, 634687.10009726696],
						[483141.09035676351, 634686.62863427785]
					]
				],
				[
					[
						[503566.55451161542, 635354.63123709406],
						[503566.58790272137, 635200.55553683941],
						[503595.62901603238, 635200.56185627216],
						[503595.63568579662, 635170.03430723818],
						[503623.95597293356, 635170.04051917337],
						[503623.96267087123, 635139.6235813332],
						[503709.54158755002, 635139.64264884556],
						[503709.56240519456, 635047.28579014237],
						[503681.34489044896, 635047.2794539273],
						[503681.35867155128, 634985.67136682128],
						[503653.03806714696, 634985.66505610687],
						[503653.05169312458, 634924.2781996933],
						[503624.01009227184, 634924.27177892928],
						[503624.0168389199, 634893.63366043777],
						[503566.65442119085, 634893.62112885166],
						[503566.66108501441, 634862.87240760145],
						[503510.01945355762, 634862.86022965948],
						[503509.3051874722, 634831.77953817579],
						[503480.98431824631, 634831.77352354128],
						[503480.99075179634, 634801.35663130647],
						[503423.62801243796, 634801.34459823358],
						[503423.63440899836, 634770.5958895057],
						[503366.27156242641, 634770.58405635064],
						[503366.27785181004, 634739.83535179216],
						[503338.05980991601, 634739.82960417087],
						[503338.06606901152, 634708.97029696405],
						[503467.62213924772, 634708.99708460085],
						[503681.42055038636, 634709.04352081788],
						[503681.42740381573, 634678.40543159423],
						[503709.64555102785, 634678.41176794819],
						[503709.67322472442, 634555.63823918847],
						[503653.13352256792, 634555.62559190486],
						[503653.14034782053, 634524.8769167501],
						[503566.73433910846, 634524.85796396376],
						[503566.74102689436, 634493.99868623726],
						[503481.05576572177, 634493.98033952108],
						[503481.06222265959, 634463.45288610237],
						[503452.74071959697, 634463.4469200701],
						[503452.74719361291, 634432.58765068511],
						[503366.34070037102, 634432.56974998245],
						[503366.34698974784, 634401.82109145995],
						[503166.7568859859, 634401.78147687938],
						[503166.76278118312, 634371.14342912007],
						[503137.72020423977, 634371.13786648982],
						[503137.72602428222, 634340.61042952212],
						[503109.40430982824, 634340.60505431844],
						[503109.41018181987, 634309.52458829584],
						[503080.36749613954, 634309.51912686927],
						[503080.37320977572, 634278.99169820361],
						[503023.8325572235, 634278.98121284391],
						[503023.83822695026, 634248.12196846679],
						[502994.79543291457, 634248.11665804149],
						[502994.80207463191, 634211.61648194201],
						[502994.81219821546, 634155.98137636995],
						[503023.85515483515, 634155.98668682063],
						[503023.88899026788, 633971.82684248604],
						[503052.10834897368, 633971.83205143269],
						[503052.11407160363, 633940.97284893063],
						[503080.43647376652, 633940.97812554752],
						[503080.45367675112, 633849.06418172608],
						[503109.49717497249, 633849.0696433055],
						[503109.50881444919, 633787.46188234328],
						[503137.8314807784, 633787.46725773101],
						[503137.83736406598, 633756.6080803501],
						[503166.88102544134, 633756.61364319292],
						[503166.88694189885, 633725.86507637124],
						[503195.20971423195, 633725.8705504986],
						[503195.22163150558, 633664.48403569113],
						[503223.54450945952, 633664.48955857637],
						[503223.5505534074, 633633.63039795798],
						[503280.91736283508, 633633.6417336677],
						[503280.92344819877, 633603.11439612508],
						[503309.96738043282, 633603.12021146482],
						[503309.97363088425, 633572.03984667431],
						[503366.51671209076, 633572.05131505651],
						[503366.52291094768, 633541.74519834644],
						[503423.89004063763, 633541.75703238812],
						[503423.89646017423, 633510.89788852364],
						[503452.94055514329, 633510.90395616193],
						[503452.94700592762, 633480.15542273223],
						[503566.96074055374, 633480.17973696487],
						[503566.9674283088, 633449.32060152991],
						[503624.33488014474, 633449.33313422347],
						[503624.32808483019, 633480.19226963306],
						[503653.3722339797, 633480.19869096356],
						[503653.36540875857, 633510.94722431398],
						[503681.68855092663, 633510.95353559498],
						[503681.68164805201, 633541.81267935177],
						[503709.9017440562, 633541.81901614461],
						[503709.89491292217, 633572.12513272162],
						[503739.04189270543, 633572.13172844111],
						[503739.03483201383, 633603.21209305886],
						[503910.31163688743, 633603.25189443165],
						[503910.31902101485, 633572.17152988748],
						[503939.36300785129, 633572.17845588899],
						[503939.37764753657, 633511.01319576777],
						[503967.70078958938, 633511.0199992312],
						[503967.71564118267, 633449.41233075457],
						[503995.93589561782, 633449.41915797954],
						[503995.94330709305, 633418.89184550708],
						[504025.0905582367, 633418.89894779515],
						[504025.09810492216, 633388.03982089157],
						[504053.31846458331, 633388.04674650216],
						[504053.32598246203, 633357.51944230043],
						[504110.69375426922, 633357.53367019352],
						[504110.70146142016, 633326.67455166264],
						[504139.02492069534, 633326.68164995126],
						[504139.03265313443, 633295.93314175319],
						[504110.70914094837, 633295.92604345025],
						[504110.71679285122, 633265.28814551968],
						[504082.49622271187, 633265.2811214953],
						[504082.50384951429, 633234.53262157075],
						[504053.35627187329, 633234.52541760856],
						[504053.36387146462, 633203.66631573252],
						[503995.99556335196, 633203.65228766098],
						[503996.00037006527, 633183.85379796242],
						[503996.01046685042, 633142.26591459836],
						[504025.15820787341, 633142.27301700274],
						[504025.17322008015, 633080.88666051568],
						[503996.02537034231, 633080.87955808593],
						[503996.04027383402, 633019.49321811774],
						[503967.81928225339, 633019.4863907143],
						[503967.82669470401, 632988.73792392667],
						[503910.45763746178, 632988.72419399431],
						[503910.46491645824, 632958.08633730153],
						[503767.4025452676, 632957.83175780904],
						[503767.40953264694, 632927.30451116001],
						[503739.18838300335, 632927.2980757663],
						[503739.19539341988, 632896.43901536311],
						[503710.04721704638, 632896.43241937179],
						[503710.06105378724, 632835.04612881585],
						[503739.20933887019, 632835.05272482999],
						[503739.21632415685, 632804.30428280658],
						[503710.06798462116, 632804.29768678115],
						[503710.08877711999, 632712.05238554883],
						[503681.86725840601, 632712.04604843585],
						[503681.8740870349, 632681.51883464633],
						[503624.50395897863, 632681.50610140315],
						[503624.49723675754, 632712.03331522108],
						[503596.17271976813, 632712.02710235957],
						[503596.16597757797, 632742.88613787678],
						[503567.1205273277, 632742.87981749792],
						[503567.10722376697, 632804.2660833745],
						[503538.78286549624, 632804.25996927533],
						[503538.76962001069, 632865.86746355577],
						[503509.72438677837, 632865.8612444601],
						[503509.71129717235, 632927.24754349061],
						[503481.38715053536, 632927.24152815645],
						[503481.3806936426, 632957.76877491875],
						[503453.05655312072, 632957.98402028973],
						[503453.05012555158, 632988.62187716947],
						[503424.00510893809, 632988.61580934143],
						[503423.99871243193, 633019.36427635839],
						[503338.40877011872, 633019.34669372125],
						[503338.41500673402, 632988.59822667018],
						[503310.09096567245, 632988.59250611032],
						[503310.09712712857, 632957.95464917109],
						[503281.05210049916, 632957.72762165766],
						[503281.05818584084, 632927.20037481899],
						[503109.67134882149, 632927.16710231104],
						[503109.67717898439, 632896.30804166431],
						[503052.30779958179, 632896.29730281362],
						[503052.31346064963, 632865.7700641097],
						[503024.09220549947, 632865.76485481462],
						[503024.09787519224, 632834.90580244432],
						[502995.05258732289, 632834.90049156593],
						[502995.05818243173, 632804.15204926219],
						[502937.68848181888, 632804.14170991862],
						[502937.6939500111, 632773.50387762475],
						[502909.36953881074, 632773.49884664442],
						[502909.37497382844, 632742.75041258591],
						[502881.05050969822, 632742.7454303382],
						[502881.05591116595, 632711.88639455754],
						[502852.01040621044, 632711.88133610249],
						[502852.03164092713, 632589.33008102095],
						[502794.66119155334, 632589.3202401991],
						[502794.66648734279, 632558.12940777803],
						[502737.29592921684, 632558.11976690241],
						[502737.30098753213, 632527.70317908935],
						[502708.9761533399, 632527.69849295542],
						[502708.98121391656, 632496.95009192626],
						[502651.61044255324, 632496.94074970821],
						[502651.60548915016, 632527.68915075436],
						[502594.33782432595, 632527.68002474937],
						[502594.34267075057, 632496.93162368622],
						[502537.69289645128, 632496.92279218626],
						[502537.72130592458, 632312.65368389245],
						[502480.34989220003, 632312.6449385985],
						[502480.3452421109, 632343.50392058771],
						[502422.97393591772, 632343.4953752826],
						[502422.9784784466, 632312.63639327348],
						[502394.75627489848, 632312.63226302993],
						[502394.76074842562, 632281.88389082672],
						[502194.3209281725, 632281.8559492284],
						[502194.30459078023, 632404.40704021975],
						[502165.25854323193, 632404.40319363587],
						[502165.25698640617, 632416.23800464009],
						[502165.25446929527, 632435.3727938236],
						[502153.40947219107, 632435.37123989873],
						[502107.88348331029, 632435.36534676829],
						[502107.88744929986, 632404.39574656356],
						[501993.96926271275, 632404.38155211613],
						[501993.97296076769, 632373.85437885625],
						[501936.60176036134, 632373.84752879874],
						[501936.59816870757, 632404.37470206991],
						[501879.22707468015, 632404.36805198702],
						[501879.22353891568, 632435.33765223995],
						[501850.898545779, 632435.3344427275],
						[501850.87436748552, 632650.35206880176],
						[501821.82875394763, 632650.34882825683],
						[501821.82533836627, 632681.20785602438],
						[501793.50076833362, 632681.20474528265],
						[501793.49744201545, 632711.73195965856],
						[501765.2759227549, 632711.72890871577],
						[501765.26273193513, 632834.72265439597],
						[501840.65688422928, 632834.73091307026],
						[501850.85363432986, 632834.73205653764],
						[501850.85016429424, 632865.59110923368],
						[501879.17441702465, 632865.59431865835],
						[501879.17093176575, 632896.12155769079],
						[501936.54031178937, 632896.12820756971],
						[501936.54264116316, 632876.32974411966],
						[501936.54390344961, 632865.60096855147],
						[501980.52374311641, 632865.60620180913],
						[501993.91338985367, 632865.60781840794],
						[501993.91529247718, 632849.90177674498],
						[501993.91712811141, 632834.7487657459],
						[502008.02778227796, 632834.7504811805],
						[502079.50803036458, 632834.7593569092],
						[502079.50413163571, 632865.61840955145],
						[502092.06980010244, 632865.62000191561],
						[502136.87361797679, 632865.62575769436],
						[502136.86965476559, 632896.15299666452],
						[502165.1938549045, 632896.15669828595],
						[502165.18979551026, 632927.01575921872],
						[502222.55906785175, 632927.0234060192],
						[502222.55077874678, 632988.40972241561],
						[502251.59579572448, 632988.41367009562],
						[502251.58739829838, 633049.80000301381],
						[502279.91133403272, 633049.8039020492],
						[502279.8900686971, 633203.32510973897],
						[502308.11074507213, 633203.32904303586],
						[502308.10210572381, 633264.93664611387],
						[502337.24962951208, 633264.94075938815],
						[502337.24527884735, 633295.57865796448],
						[502365.46576525172, 633295.80390188308],
						[502365.46137794846, 633326.33119845123],
						[502530.56140027358, 633326.35575455346],
						[502623.25635966868, 633326.37026743742],
						[502623.25406797492, 633340.74906793435],
						[502623.25144134014, 633357.22938654339],
						[502708.8388256827, 633362.10992178321],
						[502708.83460245054, 633387.77055500972],
						[502737.15795658698, 633387.77524089708],
						[502737.152824683, 633418.63436829648],
						[502766.19708245946, 633418.63922406919],
						[502766.19195186422, 633449.16653700906],
						[502794.51520035136, 633449.17132159928],
						[502794.50996088516, 633480.0304573176],
						[502823.55411031895, 633480.03541430552],
						[502823.54883536982, 633510.78394795896],
						[502851.8719778214, 633510.78883125749],
						[502851.86137958791, 633571.95409221156],
						[502794.49435515061, 633571.94425197318],
						[502794.4838949875, 633633.55195465474],
						[502766.16096379264, 633633.54717011272],
						[502766.15064682008, 633694.9336768646],
						[502737.10687660432, 633694.92882117117],
						[502737.09149925556, 633787.39573478419],
						[502708.76883280126, 633787.39104900719],
						[502708.76384500694, 633817.6971987579],
						[502680.54422202357, 633817.69257850712],
						[502680.5341522044, 633879.52156083158],
						[502623.16819979559, 633879.51231775526],
						[502623.16331670695, 633910.15029916423],
						[502422.74332439905, 633910.11957610911],
						[502422.73879811872, 633940.86816816789],
						[502337.15364772419, 633940.85579215758],
						[502337.14926563343, 633971.7149948806],
						[502308.00299347931, 633971.71088178479],
						[502307.9814648329, 634125.23271268094],
						[502279.76236914616, 634125.22877960512],
						[502279.75812524976, 634155.86679434637],
						[502251.43609288271, 634155.86289557151],
						[502251.4298893435, 634201.21158927423],
						[502251.42348910798, 634247.99817791441],
						[502365.3289161353, 634248.01415414119],
						[502365.33330345247, 634217.4867335367],
						[502451.02000416321, 634217.49927141645],
						[502451.01545790833, 634248.02669199836],
						[502480.05825209973, 634248.03104283684],
						[502480.05360197101, 634278.89028738101],
						[502537.41816235048, 634278.89903162979],
						[502537.39923390886, 634401.67241179571],
						[502565.72084327601, 634401.67680266243],
						[502565.70647986262, 634493.81218488363],
						[502594.02793067123, 634493.81662446877],
						[502594.02306676924, 634524.67590253241],
						[502680.42907645064, 634524.68974844262],
						[502680.41904263227, 634586.29771040194],
						[502651.27385884494, 634586.29298940336],
						[502651.2590519425, 634678.207233225],
						[502623.04090437863, 634678.20271156938],
						[502623.03602127143, 634708.84080116684],
						[502593.99404024967, 634708.83619802422],
						[502593.98917634302, 634739.69550548028],
						[502508.30519436259, 634739.68222324387],
						[502508.29582159378, 634801.17963712511],
						[502537.3376396643, 634801.18408904271],
						[502537.32815836876, 634862.68151967798],
						[502565.64897441072, 634862.68591042585],
						[502565.64418085071, 634893.43463202438],
						[502576.66353231942, 634893.43635359127],
						[502593.96494397119, 634893.43907149904],
						[502593.95530331932, 634954.60470641719],
						[502622.99685064406, 634954.60930949193],
						[502622.99193227879, 634985.46865058353],
						[502651.20955300349, 634985.47317215137],
						[502651.20459954732, 635016.22191048414],
						[502708.56658995309, 635016.23125127179],
						[502708.55652329029, 635077.39691945445],
						[502794.23874700814, 635077.41124426306],
						[502794.23346994485, 635108.49181616877],
						[502823.27474571613, 635108.49677266669],
						[502823.26421471353, 635169.88367994549],
						[503094.31511042448, 635169.93241169094],
						[503223.24965475756, 635169.95715944585],
						[503223.25561209442, 635139.54022144992],
						[503252.29683307279, 635139.54593502218],
						[503252.30295337708, 635108.57596602535],
						[503280.62334627099, 635108.58158713754],
						[503280.61717267346, 635139.55155612866],
						[503309.65839363175, 635139.55737091892],
						[503309.65227660397, 635169.97430888377],
						[503337.97256384062, 635169.98002868448],
						[503337.96637203364, 635200.50757781765],
						[503366.18362405366, 635200.51332528307],
						[503366.17606772459, 635237.4560895483],
						[503366.1710226321, 635262.12147145718],
						[503423.53215595341, 635262.13330426102],
						[503423.52573636972, 635292.99268721347],
						[503452.56668656034, 635292.99875419179],
						[503452.56032854511, 635323.30510571576],
						[503480.88035191863, 635323.31107143918],
						[503480.87373119319, 635354.61289134366],
						[503566.55451161542, 635354.63123709406]
					]
				],
				[
					[
						[513979.05692650651, 635575.09175893478],
						[513979.18752284808, 635421.34778473852],
						[514008.2282465176, 635421.37247877591],
						[514008.28031110135, 635360.20673997444],
						[513979.23947949428, 635360.18204584066],
						[513979.26606851461, 635328.88023653254],
						[513921.9051677743, 635328.83161172667],
						[513921.93080556887, 635298.52527038264],
						[513893.61073952599, 635298.50133719807],
						[513893.63679205766, 635267.64196457563],
						[513808.05854085041, 635267.56993885559],
						[513808.08406169689, 635237.15299852565],
						[513721.68179240276, 635237.08073074359],
						[513721.65643124975, 635267.4976712038],
						[513635.9751970424, 635267.42645446584],
						[513635.94962766056, 635298.2858274905],
						[513607.62956120609, 635298.26238643751],
						[513607.57862009952, 635359.87053816894],
						[513632.80913030932, 635359.89141956938],
						[513635.84789999021, 635421.05971910537],
						[513664.88862417126, 635421.08380727086],
						[513664.83746830025, 635482.69199247914],
						[513692.33337013726, 635482.71484650171],
						[513693.13181651593, 635513.24311291019],
						[513721.45151302381, 635513.26670110109],
						[513721.4257829506, 635544.12610773288],
						[513778.78593328077, 635544.17403376498],
						[513778.76018825168, 635574.92283734062],
						[513807.80064092035, 635574.94717769709],
						[513807.77474882483, 635605.80659266491],
						[513864.31084308826, 635605.85412558541],
						[513865.10896407417, 635636.38241705275],
						[514008.04512594151, 635636.50346455933],
						[514008.0973788742, 635575.11645274272],
						[513979.05692650651, 635575.09175893478]
					]
				],
				[
					[
						[512146.40748000104, 637263.2803139966],
						[512147.25377388974, 637232.75309971417],
						[512175.46754143114, 637232.77395149274],
						[512175.51304503344, 637171.27588735218],
						[512204.65365103271, 637171.29747490212],
						[512204.72198774078, 637079.16101865144],
						[512261.2530203957, 637079.20304437284],
						[512261.99681245093, 637048.34396067844],
						[512276.2068254269, 637048.35455570242],
						[512490.69564336305, 637048.51596972859],
						[512490.71864810347, 637018.20939320815],
						[512518.93295179488, 637018.00961801363],
						[512518.97999082797, 636956.17979052244],
						[512544.92885550583, 636956.19955246639],
						[512548.1674515066, 636895.25703907257],
						[512576.3817977148, 636895.27857825265],
						[512576.40436829731, 636865.74627772102],
						[512633.76093116554, 636864.46291847015],
						[512633.8318389699, 636772.10537544149],
						[512662.14936916757, 636772.12714073702],
						[512662.26758670114, 636618.49294151564],
						[512605.73497130017, 636618.44953813334],
						[512605.85257622343, 636464.92605191295],
						[512576.71071930544, 636464.90375387412],
						[512576.73430425324, 636434.04421854939],
						[512491.1621184611, 636433.97904082481],
						[512491.18529105309, 636403.45133253012],
						[512376.47098027659, 636403.3646562316],
						[512376.4941896213, 636372.50512910122],
						[512348.17597173399, 636372.4838553766],
						[512348.29117191868, 636218.96053618635],
						[512375.78584360715, 636218.98119054246],
						[512376.72486872389, 636065.79041886679],
						[512405.76478871325, 636065.36985526013],
						[512405.85751023307, 635942.37438852282],
						[512432.52881980652, 635942.39451665583],
						[512434.24549953913, 635851.03406475578],
						[512491.60516786104, 635850.30325281783],
						[512491.6277526879, 635820.54987552948],
						[512548.98761430208, 635819.7086563604],
						[512549.01106192655, 635788.95981727412],
						[512634.58660187945, 635789.02529582859],
						[512634.61029431666, 635758.16585376556],
						[512691.14586516487, 635758.20935635187],
						[512691.99324269959, 635727.68237586075],
						[512720.31257019291, 635727.70424124121],
						[512720.33642328589, 635696.84480774635],
						[512777.69604132388, 635696.88924448111],
						[512777.71991609479, 635666.14042258495],
						[512805.93636973272, 635666.16235535254],
						[512805.96021115314, 635635.52414495614],
						[512835.10353682912, 635635.54684897454],
						[512835.12734623766, 635605.01925004111],
						[512892.48728433414, 635605.06408688356],
						[512892.51146009547, 635574.20467051945],
						[512915.27011371392, 635574.22251579654],
						[512920.94517403492, 635297.70892191713],
						[512892.72808865277, 635297.68679195934],
						[512892.75226438104, 635266.82741780742],
						[512863.60828573519, 635266.80461169872],
						[512863.63206099131, 635236.38766995259],
						[512949.31345680915, 635236.4548656072],
						[512949.33799963922, 635205.26367883396],
						[512978.37910462735, 635205.28655555309],
						[512978.42716642539, 635144.3420861609],
						[513005.92363357259, 635144.36379333702],
						[513006.77197446249, 635113.39448451879],
						[513035.8132415624, 635113.4174625834],
						[513035.83786052925, 635082.33689997951],
						[513064.15829856344, 635082.35935706389],
						[513064.18235639494, 635052.05304752558],
						[513092.39986294199, 635052.07547146163],
						[513092.42441269202, 635021.21613130765],
						[513118.37632865412, 635021.23679752892],
						[513121.61794685532, 634959.63128200581],
						[513149.11472261342, 634959.65322842856],
						[513149.85991565511, 634929.23690462066],
						[513179.004580673, 634929.14961075783],
						[513179.02911547601, 634898.5115013473],
						[513205.7021168627, 634898.53288258088],
						[513207.27156137163, 634867.78541013156],
						[513321.99657665216, 634867.87787797127],
						[513322.02173569199, 634836.79734970536],
						[513436.02607235563, 634836.89002891467],
						[513436.05072429101, 634806.69435981533],
						[513522.45543494285, 634806.54391432425],
						[513522.35446631827, 634929.42814540933],
						[513550.57218311477, 634929.45135492273],
						[513550.54704764899, 634959.97886101948],
						[513607.90923402621, 634960.02619145578],
						[513607.88371778745, 634990.88552239013],
						[513665.24579644314, 634990.93305267359],
						[513665.22026447719, 635021.68178080383],
						[513721.86134925438, 635021.72890985222],
						[513721.83561924001, 635052.5882490488],
						[513836.55934624642, 635052.6843039114],
						[513836.58529138379, 635021.82496489899],
						[513887.56226724753, 635021.86790307774],
						[513893.8702375287, 634991.12447761465],
						[513922.19083252305, 634991.14841124113],
						[513922.216938122, 634960.28908080526],
						[513951.25847540074, 634960.3136743129],
						[513951.28426040238, 634929.89677573065],
						[513978.06028922892, 634929.80888914992],
						[513979.63107995811, 634899.172093092],
						[514007.12795673468, 634899.19547307142],
						[514008.69889854599, 634868.44807708159],
						[514037.01970464888, 634868.47220831458],
						[514037.04621403554, 634837.39168116753],
						[514065.36707358039, 634837.4158611868],
						[514065.39288020536, 634807.22019305336],
						[514093.61099597928, 634807.02311998117],
						[514094.54021116608, 634684.02905822382],
						[514065.49818634108, 634684.00421187654],
						[514065.65576731722, 634499.62279297737],
						[514037.33432648319, 634499.5986124652],
						[514037.36036412563, 634469.07116947009],
						[513922.6325687482, 634468.9737148335],
						[513922.58063836559, 634530.36042541778],
						[513866.0408493072, 634530.31269232451],
						[513866.09256880218, 634468.92598156177],
						[513892.04535568331, 634468.94786779757],
						[513894.33712760906, 634438.09052137891],
						[513922.65867428936, 634438.1144558097],
						[513922.68468625733, 634407.36580764549],
						[513951.72719925543, 634407.39040198305],
						[513951.85743658699, 634253.75783066754],
						[513837.2311288573, 634253.66105866549],
						[513837.28273996169, 634192.27442291763],
						[513551.17934928421, 634192.03636635933],
						[513551.20466680516, 634161.2877510261],
						[513522.98563292285, 634161.26454042783],
						[513523.01080683852, 634130.62653573335],
						[513493.86481608334, 634130.60261349333],
						[513493.88984505105, 634100.0752193979],
						[513436.62765087606, 634100.02837046003],
						[513436.65320572775, 634068.72673504229],
						[513408.33102338552, 634068.70363695221],
						[513408.35571338597, 634038.39746398386],
						[513380.03347885562, 634038.37441458937],
						[513380.05856629537, 634007.51521339023],
						[513351.0153476579, 634007.49162785057],
						[513351.03993201698, 633977.18546298309],
						[513323.54169384419, 633976.94196632097],
						[513322.74275108951, 633946.08210642461],
						[513293.69942404539, 633946.05862203217],
						[513293.72426011844, 633915.31003967451],
						[513237.18235810014, 633915.26446697838],
						[513237.20699957781, 633884.62649508659],
						[513208.06057318207, 633884.60307898198],
						[513208.08507163671, 633854.07571756735],
						[513179.86551101349, 633854.05309527973],
						[513179.89057713363, 633822.75149341812],
						[513150.74404115777, 633822.72817881475],
						[513150.79291362397, 633761.56287023856],
						[513122.57319437922, 633761.54034618626],
						[513122.59771045309, 633730.79178857012],
						[513093.45101162372, 633730.76857542549],
						[513093.49984686426, 633669.38207889022],
						[513065.27996956202, 633669.35965307057],
						[513065.35337182152, 633576.89281742391],
						[513037.0303431084, 633576.87035828037],
						[513037.12706605485, 633454.76110173971],
						[513008.08339650114, 633454.07448427053],
						[513008.1560393172, 633362.16076664929],
						[513037.20039673784, 633362.18374716106],
						[513037.22484028741, 633331.32463734853],
						[513065.54829154728, 633331.34709682059],
						[513065.59702144552, 633269.96070811152],
						[513093.81758354936, 633269.98313447216],
						[513093.8420451174, 633239.23464333382],
						[513122.98961440334, 633239.25785716972],
						[513123.01421860541, 633208.39876416768],
						[513149.68995920412, 633208.42005461245],
						[513151.25927824294, 633177.89401833923],
						[513180.40695615613, 633177.9173338546],
						[513180.43166791485, 633147.05824925937],
						[513208.65244074323, 633147.08087251859],
						[513208.6769391197, 633116.55361019762],
						[513237.82472565974, 633116.5770273956],
						[513237.84954497236, 633085.71795120439],
						[513261.43560725072, 633085.73693792359],
						[513266.09520604234, 633054.992206931],
						[513294.41913282668, 633055.01506025973],
						[513294.44387946813, 633024.37720444496],
						[513380.8577657931, 633024.44722919283],
						[513380.80786088394, 633085.83355068474],
						[513409.13173459488, 633085.85660141893],
						[513408.90637159371, 633362.48237404681],
						[513465.45017266227, 633362.52853669354],
						[513466.24914949853, 633393.0565057192],
						[513523.61679738411, 633393.10354235],
						[513523.59144179348, 633423.96265975642],
						[513580.13503164577, 633424.00921639556],
						[513580.1098438169, 633454.53651937656],
						[513637.47727741062, 633454.58395286626],
						[513637.45170823782, 633485.44307843305],
						[513666.49584810587, 633485.46716943383],
						[513666.47031631373, 633516.21569294424],
						[513693.96950371214, 633516.23854969733],
						[513694.76777266018, 633547.09836910083],
						[513723.09085260273, 633547.12196010724],
						[513723.06558386114, 633577.4280669149],
						[513752.10956141289, 633577.45230899355],
						[513752.08359227196, 633608.53266356443],
						[513866.81738578394, 633608.62892932375],
						[513866.7916659211, 633639.15625663835],
						[513895.01159500208, 633639.18005672272],
						[513894.98554265557, 633670.03920693463],
						[513922.48447304871, 633670.06244549213],
						[513923.28258628951, 633700.59047797066],
						[514152.74888915982, 633700.7861961436],
						[514152.72235346545, 633731.64535429492],
						[514467.05351742345, 633731.91864885669],
						[514467.08064247604, 633701.05949122086],
						[514552.66703966737, 633701.13494393812],
						[514552.6940317924, 633670.60760947166],
						[514639.20751753851, 633670.68433181965],
						[514639.23496526113, 633639.82518281159],
						[514700.51546565071, 633639.87980305625],
						[514724.82168087526, 633639.90153075079],
						[514724.84899220325, 633609.37420481839],
						[514810.53885879251, 633609.45109063922],
						[514810.56682669744, 633578.37073779886],
						[514867.10988608666, 633578.42171576223],
						[514867.96120549046, 633548.11635506433],
						[514953.54839799565, 633548.19389240211],
						[514953.40911799995, 633701.49415765901],
						[515010.77569081733, 633701.54637778108],
						[515010.74754636525, 633732.40553450491],
						[515068.11401144066, 633732.45795447985],
						[515067.97325763165, 633886.20076868427],
						[515096.29575402982, 633886.22672277014],
						[515096.23944810155, 633947.61327113374],
						[515239.19027788023, 633947.74501179217],
						[515239.21874863992, 633916.99643257854],
						[515296.58457031992, 633917.04964889144],
						[515296.49893930269, 634009.18479230488],
						[515382.18672433286, 634009.26465432264],
						[515382.15788292128, 634040.12385224178],
						[515467.02158741379, 634040.20338590932],
						[515467.81702454528, 634070.51032986795],
						[515610.7667868727, 634070.6452978889],
						[515610.8248025268, 634009.47993098677],
						[515639.14708677947, 634009.50681924098],
						[515639.9263514367, 633948.12094120192],
						[515668.24874127883, 633948.14787953114],
						[515668.30718068458, 633886.76133315882],
						[515697.35061236535, 633886.78900791099],
						[515697.40916008496, 633825.40247826709],
						[515725.73218383273, 633824.98709013592],
						[515725.76114061545, 633794.68095381104],
						[515954.40219976305, 633794.90100340976],
						[515954.37282196817, 633825.20713932952],
						[516326.06833926484, 633825.57164688292],
						[516355.11187891912, 633825.60048235208],
						[516355.13463056198, 633802.70497107808],
						[516355.17265987833, 633764.43518445152],
						[516380.30262441875, 633764.46017574146],
						[516384.24691701942, 633733.7155191265],
						[516412.56967581826, 633733.74373832019],
						[516412.60044862429, 633702.88458410301],
						[516440.92326048104, 633702.91285208589],
						[516440.98458082811, 633641.52637509455],
						[516462.20102081134, 633641.54758239514],
						[516470.0284452592, 633641.55541335652],
						[516470.05899356771, 633611.02809049457],
						[516498.38196349284, 633611.05645735573],
						[516498.44349777617, 633549.67000542895],
						[516470.12042221561, 633549.6416384601],
						[516470.21295254369, 633457.17486995982],
						[516441.16876274522, 633457.14583138062],
						[516441.22986204911, 633395.9806330693],
						[516384.58340213646, 633395.7029325238],
						[516383.89283238101, 633365.1749248351],
						[516355.56943932874, 633365.14675499429],
						[516355.60010452551, 633334.28765073617],
						[516298.23225162394, 633334.23074323381],
						[516298.29303830792, 633272.84436527395],
						[516269.96948637289, 633272.8163427352],
						[516270.03038607578, 633211.20876915171],
						[516240.98576223454, 633211.18008382269],
						[516241.04633492231, 633149.7937388327],
						[516184.50180300407, 633149.73804080253],
						[516184.5318207586, 633119.21078340721],
						[516069.79461545328, 633119.09836087446],
						[516069.82474436803, 633088.23928941344],
						[515869.49773825909, 633088.04492108943],
						[515869.46798493416, 633118.90399291588],
						[515841.14416809176, 633118.87670831825],
						[515841.11478722282, 633149.40396633104],
						[515812.07005431701, 633149.3760378923],
						[515812.04040854069, 633180.23511813965],
						[515785.26162694924, 633180.20941397315],
						[515783.68742276845, 633210.73519871535],
						[515755.36376395373, 633210.70806173421],
						[515754.61325986992, 633241.56646028755],
						[515726.2896541059, 633241.53937334183],
						[515726.23100090149, 633302.92574507603],
						[515697.90750073403, 633302.8987069705],
						[515697.87817419862, 633333.64720215346],
						[515668.83376641676, 633333.61952647229],
						[515668.80438884033, 633364.47863198235],
						[515611.43664117227, 633364.42411830614],
						[515611.40768588166, 633394.95140970231],
						[515525.7167025244, 633394.87035428663],
						[515525.74549887801, 633364.34306274028],
						[515497.52509855659, 633364.31646661763],
						[515497.55415500107, 633333.45736080164],
						[515468.5097468819, 633333.43003862281],
						[515468.53864491172, 633302.68154303485],
						[515440.21514432575, 633302.65494837938],
						[515440.24367815838, 633272.23827512783],
						[515297.18419206201, 633271.8834803435],
						[515297.21276991209, 633241.13499275711],
						[515325.53637636866, 633241.16134132841],
						[515325.56511011417, 633210.30225189251],
						[515354.60973550851, 633210.32932182366],
						[515354.72426918003, 633087.55664204888],
						[515325.67942713731, 633087.52957191947],
						[515325.70805787377, 633056.78110928147],
						[515182.64649346488, 633056.64852218737],
						[515182.70311838272, 632995.26221481524],
						[515154.48208524199, 632995.23620686727],
						[515154.51029415033, 632964.59836229449],
						[515129.37931166746, 632964.35403076175],
						[515126.21446960227, 632933.82386161922],
						[515068.84522088809, 632933.7712391403],
						[515068.81727275491, 632964.29847379099],
						[515011.44813025894, 632964.24605136877],
						[515011.53195806575, 632872.33254172385],
						[514982.48673622677, 632872.3060772114],
						[514982.59869304474, 632749.31236514123],
						[515011.64413192734, 632749.33882985474],
						[515011.70011795702, 632687.95260457578],
						[514982.65457074787, 632687.92613976309],
						[514982.71054912178, 632626.42932512576],
						[514897.01566468389, 632626.24093717197],
						[514897.04319346341, 632595.82435318828],
						[514811.45104855095, 632595.74710970139],
						[514811.47911586624, 632564.55628946272],
						[514783.15434507478, 632564.53082550294],
						[514783.20927960926, 632503.36586049304],
						[514754.16340667318, 632503.33979888679],
						[514754.19086953625, 632472.7020196279],
						[514696.82001358585, 632472.65069383825],
						[514696.79265751073, 632503.28847319633],
						[514668.46778128284, 632503.26320659684],
						[514668.44037935755, 632534.01159583172],
						[514410.73598492634, 632533.7839552745],
						[514410.84386062605, 632410.56921012129],
						[514382.51882484945, 632410.54443559668],
						[514382.6797403653, 632226.38607553963],
						[514410.18108279171, 632226.41012893093],
						[514411.03211036371, 632195.55189644196],
						[514468.40393214609, 632195.60222612019],
						[514468.37680727267, 632226.46117992094],
						[514525.74852131907, 632226.5117094717],
						[514525.72138649313, 632257.26006175135],
						[514640.46459970658, 632257.36172057013],
						[514640.49194888055, 632226.61336848303],
						[514655.32413336413, 632226.62656770553],
						[514668.71429989656, 632226.63849514758],
						[514668.74741872796, 632189.47502481262],
						[514668.76900510839, 632165.25240900484],
						[514683.70424654195, 632165.26572559332],
						[514697.09446299484, 632165.27767612273],
						[514697.11253575794, 632145.0368621673],
						[514697.12201655022, 632134.41873097233],
						[514726.16854050604, 632134.44469192135],
						[514726.20188780694, 632097.17063116026],
						[514726.30588782381, 631980.92426696804],
						[514753.08662063506, 631980.94824823365],
						[514754.76937347336, 631827.31870582444],
						[514783.81643934833, 631827.34476850415],
						[514783.8715723877, 631765.95878971717],
						[514812.19771739759, 631765.98425490619],
						[514812.25315511128, 631704.37708198559],
						[514840.47640154825, 631704.4025031497],
						[514840.50392391661, 631673.87543620903],
						[514869.65426531225, 631673.90174322529],
						[514869.7097179073, 631612.5158057753],
						[514897.933121846, 631612.54132545809],
						[514897.98887988785, 631550.93419400742],
						[514927.1394389972, 631550.96060282807],
						[514927.16722211125, 631520.32295119693],
						[514955.39078412548, 631520.34856939549],
						[514955.44655589561, 631458.96267327678],
						[514983.77343056031, 631458.76722331811],
						[514983.80121823685, 631428.24018926232],
						[515012.84898835112, 631428.26665610587],
						[515012.87713251932, 631397.40781063552],
						[515041.20391175034, 631397.43366991333],
						[515041.2600030867, 631336.04780692025],
						[515070.30793589092, 631336.07437515748],
						[515070.33588382276, 631305.54735754686],
						[515098.66282113019, 631305.57331570028],
						[515098.69112594647, 631274.71448684519],
						[515125.37000051321, 631274.73897932749],
						[515127.79578386224, 631213.1341163069],
						[515156.12288020272, 631213.16017334722],
						[515156.17939941323, 631151.77435992227],
						[515178.12010491476, 631151.79457585583],
						[515184.46021778393, 631090.41457381367],
						[515213.61159243243, 631090.44148995064],
						[515213.69674325112, 630998.30752282136],
						[515226.98490004538, 630998.31980921258],
						[515241.92120030744, 630998.33363230457],
						[515241.9394295502, 630978.64594665635],
						[515241.97803867667, 630936.94787642383],
						[515271.12968510063, 630936.97489442176],
						[515271.21525960008, 630844.73038402677],
						[515295.52560270298, 630844.75295453705],
						[515296.36499577831, 630828.27358982433],
						[515299.49744346016, 630782.9284578223],
						[515327.82528011489, 630782.95481033064],
						[515327.96802039054, 630629.65650249692],
						[515299.6399199288, 630629.63014974492],
						[515299.66839465522, 630598.99262129469],
						[515242.29100788641, 630598.9393942582],
						[515242.26263994968, 630629.57692280749],
						[515214.03755062539, 630629.55081274081],
						[515214.00933744147, 630660.07774058497],
						[515184.85720065533, 630660.05082374264],
						[515184.74395195767, 630782.82220492198],
						[515156.51912538632, 630782.79619348154],
						[515156.49030572944, 630814.09737593494],
						[515070.78588555544, 630814.0186890146],
						[515070.75793768058, 630844.545641504],
						[515013.38140679064, 630844.49321233481],
						[515013.32562295819, 630905.65773456614],
						[514927.72468902939, 630905.57988641958],
						[514927.75237176829, 630875.05292559427],
						[514841.22419103625, 630874.97468657373],
						[514841.19666875945, 630905.50164754351],
						[514812.97205253883, 630905.47622514446],
						[514812.94408495526, 630936.5562149738],
						[514784.61651262466, 630936.53074849886],
						[514784.58909521531, 630967.05771771958],
						[514755.54051123111, 630967.03165367758],
						[514755.51285025751, 630997.89044194063],
						[514727.18538347119, 630997.86507429311],
						[514727.15827036509, 631028.1708417437],
						[514698.10979422432, 631028.14487904706],
						[514698.05458861607, 631089.97308129771],
						[514669.72728029272, 631089.94781252847],
						[514669.69997709984, 631120.58540731773],
						[514641.47572965734, 631120.56027896772],
						[514641.4483806151, 631151.30848293134],
						[514612.29711375869, 631151.28258004214],
						[514612.26972098561, 631182.14139323658],
						[514526.67022479931, 631182.06563061406],
						[514526.64328530809, 631212.59263281873],
						[514469.26803724893, 631212.54210015782],
						[514469.21388495609, 631274.14914248511],
						[514440.88689357071, 631274.12426751864],
						[514440.85982191609, 631304.9830974784],
						[514411.81183424627, 631304.95763999934],
						[514411.78510754713, 631335.48465870321],
						[514383.45822171355, 631335.45988256123],
						[514383.43145089486, 631366.09751052433],
						[514326.05673787766, 631366.04747702798],
						[514326.02997758536, 631396.79571434099],
						[514268.65537156706, 631396.74588091555],
						[514268.62862257211, 631427.60472762655],
						[514211.25412393367, 631427.5550942691],
						[514211.22776895849, 631458.08212959103],
						[514183.00410018262, 631458.05778733105],
						[514182.97751164931, 631488.91664241767],
						[514154.65088984655, 631488.89226001897],
						[514154.62444951967, 631519.6405140576],
						[514125.57684064843, 631519.61556168844],
						[514125.55054949201, 631550.25321463379],
						[514097.22403324023, 631550.2289310568],
						[514097.0661289405, 631734.60796152288],
						[514068.01889941451, 631734.58311071736],
						[514068.04527286428, 631703.72422243434],
						[514039.71902071283, 631703.70003781503],
						[514039.74505803559, 631673.17296956864],
						[513982.37141533307, 631673.12413398526],
						[513982.39762811241, 631642.26525381161],
						[513954.07127019955, 631642.24121657945],
						[513954.09714858618, 631611.71415636013],
						[513925.0497021944, 631611.68955784477],
						[513925.07580740814, 631580.83068582858],
						[513868.52588542685, 631580.78294417833],
						[513868.55179143487, 631550.03468146955],
						[513839.50423620048, 631550.01023391576],
						[513839.60745718074, 631427.2384344358],
						[513868.65522906196, 631427.26288217097],
						[513868.75866663118, 631304.49114841828],
						[513896.98259871005, 631304.51495187893],
						[513897.03423597279, 631243.35031987005],
						[513924.53759508912, 631242.93114142457],
						[513925.41358422104, 631181.54601282068],
						[513954.46178966353, 631181.57061197341],
						[513954.51401513652, 631119.96359263163],
						[513982.84127180837, 631119.98763062572],
						[513982.89322747767, 631058.82304791862],
						[514011.941649482, 631058.84774850472],
						[514011.96829323564, 631027.54653077014],
						[514040.29570894572, 631027.57066763414],
						[514040.34787777794, 630966.40610964585],
						[514068.67539870139, 630966.43029534712],
						[514068.72805088898, 630904.82333390648],
						[514096.95266823412, 630904.84748023096],
						[514097.82855830714, 630844.34729020169],
						[514126.15685875627, 630843.70794533845],
						[514126.20953581936, 630782.32222663099],
						[514155.25882618787, 630781.90476058656],
						[514155.65476369951, 630321.45708950318],
						[514126.60504045762, 630321.43213531002],
						[514126.68419823929, 630229.187864493],
						[514012.64794310444, 630229.09040107299],
						[514012.62177017698, 630259.8384874441],
						[513967.81085912866, 630259.80040507764],
						[513955.24320129713, 630259.78974640812],
						[513955.21741682541, 630290.20602300472],
						[513926.16763843526, 630290.18142251787],
						[513926.14134623692, 630321.26133114332],
						[513869.58709708438, 630321.21358584205],
						[513869.56137758389, 630351.7404753319],
						[513840.51170778071, 630351.71602599649],
						[513840.48576317547, 630382.57473364205],
						[513816.89582727203, 630382.55491715344],
						[513812.10573291231, 630443.93655418279],
						[513783.05622580188, 630443.91220623523],
						[513783.03048135038, 630474.66032153997],
						[513754.70211416739, 630474.63662738958],
						[513754.67633021221, 630505.49535157683],
						[513725.62693173037, 630505.47110498045],
						[513725.5757493733, 630566.85675145732],
						[513697.24754084647, 630566.83315617964],
						[513697.19646411383, 630628.21881905082],
						[513668.86836118047, 630628.19527261052],
						[513668.81739006838, 630689.5809518788],
						[513639.76831643749, 630689.55685678509],
						[513639.71727034525, 630751.16376221098],
						[513611.38937898417, 630751.14031467738],
						[513611.33843889186, 630812.74723662785],
						[513582.28958260658, 630812.72324296739],
						[513582.26439506363, 630843.25019786158],
						[513553.93666216545, 630843.22684920067],
						[513553.96179718006, 630812.6998942584],
						[513525.73702184041, 630812.67667893833],
						[513525.7623771432, 630781.81791333784],
						[513496.61081868957, 630781.35156667954],
						[513496.63566592633, 630751.04582957877],
						[513468.41078487528, 630751.02271255082],
						[513468.43603261578, 630720.16395509068],
						[513439.3870129509, 630720.14021360432],
						[513439.4121159332, 630689.39206506638],
						[513411.08411827008, 630689.36896223179],
						[513411.13412829454, 630627.98328217049],
						[513382.8060249589, 630627.96022800053],
						[513382.83093218756, 630597.32269644027],
						[513353.78169575083, 630597.29910601466],
						[513353.80663863302, 630566.55097369256],
						[513325.4784295818, 630566.52801817155],
						[513325.50358814752, 630535.44807558204],
						[513296.45424252114, 630535.42458632053],
						[513296.47872088064, 630505.11888116144],
						[513268.15040611295, 630505.09602429497],
						[513268.17527804925, 630474.23729935149],
						[513210.79745646083, 630474.19115308218],
						[513210.82213207183, 630443.44303690223],
						[513182.5967236124, 630443.42040992691],
						[513182.67059227114, 630351.17608578596],
						[513210.89615889179, 630351.19871288596],
						[513210.92065696983, 630320.67182239064],
						[513182.69503800542, 630320.64919524814],
						[513182.71992659452, 630289.56928546412],
						[513125.34146134637, 630289.52343705064],
						[513125.36571248929, 630259.10715919372],
						[513106.51422494825, 630259.0921395116],
						[513039.65840286983, 630259.03904701979],
						[513039.68258326082, 630228.51216840674],
						[512953.25419192127, 630228.22272566217],
						[512953.27760283177, 630198.47008325579],
						[512896.72371168772, 630197.43023865891],
						[512896.69962314086, 630228.17832265352],
						[512867.54672150908, 630228.15550956002],
						[512867.52268741239, 630258.90359767585],
						[512839.2969625413, 630258.8815593227],
						[512839.17731441202, 630412.29024723847],
						[512810.0247388258, 630412.26753601152],
						[512809.97679887165, 630473.87437018403],
						[512753.42307401699, 630473.83045939193],
						[512753.39916701231, 630504.68918509455],
						[512724.349767112, 630504.6667053987],
						[512724.32634202857, 630534.97241139342],
						[512695.99807863374, 630534.95053911023],
						[512695.97410857782, 630566.03048263735],
						[512666.92481692228, 630566.00810427556],
						[512666.90115703002, 630596.75623761164],
						[512638.57299995719, 630596.73446414736],
						[512638.54947789584, 630627.37199680379],
						[512581.1721900595, 630627.32804509404],
						[512581.195605335, 630596.69051235821],
						[512552.97045963182, 630596.66896493849],
						[512553.04071653564, 630504.53518146602],
						[512523.8883043059, 630504.51297696074],
						[512523.93517369888, 630442.90613374417],
						[512466.55724290758, 630442.86258152453],
						[512466.58061211574, 630412.00386363105],
						[512295.27059726336, 630411.8750221607],
						[512295.2475491871, 630442.73374029493],
						[512180.49168625951, 630442.64843002451],
						[512180.46893513366, 630473.39654768573],
						[512152.24357803242, 630473.37568734458],
						[512152.22079797223, 630504.23441389971],
						[512123.89248168684, 630504.21352612623],
						[512123.87016202311, 630534.51923295646],
						[512094.82081476215, 630534.49786415452],
						[512094.79797973082, 630565.57780853985],
						[512037.42047651549, 630565.53575207503],
						[512037.3979924458, 630596.28388629481],
						[512021.63723551633, 630596.27236901014],
						[511923.36428030801, 630596.20089575602],
						[511923.34208934422, 630626.83842939814],
						[511865.96479965246, 630626.79697054566],
						[511865.94279520056, 630657.32390349102],
						[511836.89366464608, 630657.30298984586],
						[511836.87147546571, 630688.16174142295],
						[511780.31848678645, 630688.12117367401],
						[511780.27439959213, 630749.72808447026],
						[511751.22543210286, 630749.70732199633],
						[511751.18145361019, 630811.31424930855],
						[511722.85366576171, 630811.29405166139],
						[511722.76623584208, 630934.06553589972],
						[511693.7175936416, 630934.04487490712],
						[511693.6302231843, 631057.03763471544],
						[511720.3094505461, 631057.05660852999],
						[511722.59121832997, 631179.82991067856],
						[511750.91837198689, 631179.85010787542],
						[511750.85260151169, 631271.98416462389],
						[511779.90064736712, 631272.00492643216],
						[511779.87856414117, 631302.86376036878],
						[511808.20550607546, 631302.88405614381],
						[511808.18360776728, 631333.41107869695],
						[511836.4074902634, 631333.431349113],
						[511836.36335035862, 631394.81722186098],
						[511893.73796311661, 631394.85857753828],
						[511893.71566630545, 631425.71742778691],
						[511980.13794585399, 631425.7800985286],
						[511980.16040468012, 631394.92124839325],
						[512008.48718819721, 631394.94188882783],
						[512008.50961943046, 631364.19364805077],
						[512036.83645582508, 631364.21433726884],
						[512036.79140664457, 631425.82142806228],
						[512065.83918102778, 631425.84269445366],
						[512065.8168047613, 631456.36973295081],
						[512094.1434825348, 631456.39052078663],
						[512094.09821860207, 631517.99763610633],
						[512123.14583032893, 631518.01900363085],
						[512123.12326619105, 631548.65665954456],
						[512151.44978514878, 631548.67754599534],
						[512151.42708663963, 631579.42581123917],
						[512179.65054731816, 631579.44667017832],
						[512179.62771424098, 631610.30554478616],
						[512237.00157591124, 631610.348096909],
						[512236.97888194624, 631640.87515966338],
						[512351.72639203607, 631640.96086367988],
						[512351.65717373905, 631733.20570792293],
						[512322.60994174, 631733.18393716088],
						[512322.51786767197, 631856.17712064297],
						[512351.56488263095, 631856.19889124366],
						[512351.54197583866, 631886.72598653147],
						[512379.86791302881, 631886.74726605415],
						[512379.68307370896, 632132.51265195932],
						[512351.35755944101, 632132.49137275096],
						[512351.33440363227, 632163.35032151546],
						[512379.65986479796, 632163.37160067854],
						[512379.5673618663, 632286.36501469463],
						[512408.61361769354, 632286.38688597223],
						[512408.54424444033, 632378.41077841842],
						[512435.22133022553, 632378.43091090769],
						[512436.84626974008, 632408.95932080306],
						[512494.21734770178, 632409.00276945077],
						[512493.84407363337, 632900.75613668398],
						[512522.0652687726, 632900.77758272714],
						[512521.97169726738, 633023.77139296767],
						[512493.75071301212, 633023.74994708889],
						[512493.7274568071, 633054.3878040706],
						[512464.57956013153, 633054.3657046014],
						[512464.5562744186, 633085.11417175154],
						[512482.6835543912, 633085.12790949864],
						[512579.29371671396, 633085.20146217279],
						[512579.27013211761, 633116.06053933001],
						[512608.41791953443, 633116.08284190646],
						[512608.34751014819, 633207.99646196351],
						[512579.19988550461, 633207.97415951453],
						[512579.17630089557, 633238.83325331518],
						[512521.8081153055, 633238.78950853366],
						[512521.7847223985, 633269.53800050472],
						[512436.196080892, 633269.47310855845],
						[512436.17293144629, 633300.11099869979],
						[512379.52592139039, 633300.06829460687],
						[512378.78183360142, 633330.81625283172],
						[512350.4583814303, 633330.79497517564],
						[512350.43522550259, 633361.65408598236],
						[512321.39086714445, 633361.63231737015],
						[512321.34491259011, 633423.01873312355],
						[512296.21442672069, 633422.99993930059],
						[512292.95280438382, 633515.13251225022],
						[512321.27593933418, 633515.15369094582],
						[512321.25283784326, 633546.0128268312],
						[512377.79600841075, 633546.05525290675],
						[512378.59715948266, 633576.36198134907],
						[512464.18420514039, 633576.42657376814],
						[512464.06769251503, 633730.27991039422],
						[512435.84791963117, 633730.25856379024],
						[512435.778471153, 633822.17243304162],
						[512463.99808644224, 633822.19377952372],
						[512463.97438184085, 633853.4953824532],
						[512493.12086332793, 633853.51748084882],
						[512493.09769099328, 633884.04484329442],
						[512521.31720019662, 633884.06628806016],
						[512521.24702126946, 633976.31203858298],
						[512493.0276702285, 633976.29059393913],
						[512493.00449788384, 634006.81797292642],
						[512463.85828787799, 634006.79587473744],
						[512463.81196753716, 634067.96125161566],
						[512407.27058994881, 634067.91853003507],
						[512407.22397943295, 634129.74756267259],
						[512378.18097649573, 634129.72569384787],
						[512378.157933751, 634160.3637002164],
						[512407.20088262676, 634160.38556900143],
						[512407.17770243273, 634191.13418601989],
						[512435.49967409088, 634191.15556127985],
						[512435.42997475399, 634283.4014372864],
						[512407.10816183966, 634283.38006214832],
						[512407.06171804632, 634344.98794042261],
						[512378.01909492939, 634344.96607188112],
						[512377.99613535235, 634375.49350076774],
						[512349.67448091449, 634375.47222446557],
						[512349.51296956983, 634590.71283674904],
						[512292.14949595887, 634590.66989245208],
						[512292.12669529207, 634621.1973546627],
						[512320.44792687579, 634621.21853193641],
						[512320.3559344433, 634744.10266961821],
						[512263.71389416809, 634744.06036412332],
						[512263.69098117971, 634774.80906078778],
						[512177.28628453158, 634774.7449013046],
						[512177.26353297412, 634805.49360228574],
						[512063.36196399212, 634805.40971825563],
						[512063.33966846566, 634835.82660299563],
						[512034.29791151226, 634835.8053410087],
						[512034.27518438705, 634866.88587114692],
						[512005.95437555597, 634866.86518633051],
						[512005.9319439737, 634897.61390012573],
						[511948.56954006822, 634897.57215337909],
						[511948.54729595996, 634928.21026453166],
						[511690.88038684119, 634928.02520792291],
						[511691.0332877097, 634712.78426723264],
						[511662.71221369633, 634712.76417308347],
						[511662.77742708981, 634620.73933191597],
						[511634.45619468245, 634620.71928639163],
						[511634.52132787852, 634528.58387591387],
						[511605.47902875085, 634528.56337064155],
						[511605.50078961201, 634497.70409986016],
						[510632.78789835359, 634497.04692083714],
						[510632.80762095086, 634466.51947310334],
						[510579.35723053914, 634466.48502758553],
						[510575.42409828061, 634497.00996018189],
						[510547.10265295283, 634496.99178582942],
						[510546.94508034078, 634742.87061940297],
						[510575.26610255108, 634742.88879348629],
						[510575.22658581921, 634804.38619538618],
						[510598.81018525525, 634804.40136657096],
						[510604.22877296113, 634865.90230122092],
						[510632.549583446, 634865.92057387962],
						[510632.52971789864, 634896.66928943666],
						[510661.57136745064, 634896.68807778729],
						[510661.5515192952, 634927.32619059121],
						[510718.91381950217, 634927.36345143919],
						[510718.8337115277, 635050.35837192228],
						[510746.33033570484, 635050.37630380748],
						[510747.13441360119, 635080.68315443082],
						[510775.35187106143, 635080.70160557702],
						[510775.33152116387, 635111.78217126837],
						[510802.107160129, 635111.79972436011],
						[510804.45544201799, 635142.77124216361],
						[510832.67279302509, 635142.78979159333],
						[510832.65277162055, 635173.20672358165],
						[510861.79691602039, 635173.22593305702],
						[510861.77676774905, 635203.75347617106],
						[510889.99401419394, 635203.77212387882],
						[510889.9733744344, 635234.96331348445],
						[510915.9249533352, 635234.98050661013],
						[510918.27337004972, 635265.39902220748],
						[510974.81063378201, 635265.43662842305],
						[510975.59369901411, 635326.60290005861],
						[511004.63458988263, 635326.62229380535],
						[511004.61365871353, 635357.92410740757],
						[511032.93362250581, 635357.94306906522],
						[511032.91315653338, 635388.47063702566],
						[511090.27384942083, 635388.50919225439],
						[511090.25320250285, 635419.14737144276],
						[511118.47007963905, 635419.16641089669],
						[511118.44945491367, 635449.69398706011],
						[511175.80993440666, 635449.73284042231],
						[511175.78882771143, 635480.81345657387],
						[511233.14919873589, 635480.85250979464],
						[511233.12836119579, 635511.38009418058],
						[511290.48862568248, 635511.41934725689],
						[511290.46745408513, 635542.27875735855],
						[511375.32341308653, 635542.33719308116],
						[511376.10466928239, 635603.9459880247],
						[511347.78512882191, 635603.92643582169],
						[511347.76407846517, 635634.45403678599],
						[511175.68457111425, 635634.33627843787],
						[511175.60119583091, 635757.11036860826],
						[511147.38489813393, 635757.09123119642],
						[511147.32241213496, 635849.33775407192],
						[511175.53855166689, 635849.35689137608],
						[511175.51767027454, 635880.10574073566],
						[511203.83673547005, 635880.12499649054],
						[511203.81572585989, 635910.98445742915],
						[511232.85558549711, 635911.00425390655],
						[511232.83474791836, 635941.53189682518],
						[511290.19351311005, 635941.57114887342],
						[511290.1723414734, 635972.43061815086],
						[511318.49124779296, 635972.45007121202],
						[511312.10406686121, 636125.96890948596],
						[511290.06701443932, 636125.95377581706],
						[511290.04584278521, 636156.81327050168],
						[511261.0064169151, 636156.79337310372],
						[511260.98552678135, 636187.32104949083],
						[511175.30908152566, 636187.26264384622],
						[511175.28812498727, 636218.12214714708],
						[511090.43565052899, 636218.06474285095],
						[511089.69424394355, 636248.59194204491],
						[511004.01796976611, 636248.75564332854],
						[511003.99748228118, 636279.39394018857],
						[510946.63989457488, 636279.35568567365],
						[510946.61944030289, 636310.10459439596],
						[510917.58028494037, 636310.08530302579],
						[510917.55995830812, 636340.72360840579],
						[510889.24168572924, 636340.70484528667],
						[510889.22133862827, 636371.45376252336],
						[510861.00609427888, 636371.43511613004],
						[510860.94521112333, 636463.68189332657],
						[510889.16029730724, 636463.70053961512],
						[510889.14009657607, 636494.22825840698],
						[510946.49693534459, 636494.26631250267],
						[510946.47640747624, 636525.12585849152],
						[511032.15109370451, 636525.1830727522],
						[511032.13047932036, 636555.93201518361],
						[511060.34540733416, 636555.95095498592],
						[511060.32481456758, 636586.58929388819],
						[511175.03769789351, 636586.88801078685],
						[511175.01696665882, 636617.41574603808],
						[511227.73955483665, 636617.45163424709],
						[511232.35216091835, 636648.53557470511],
						[511260.66990376817, 636648.55492827063],
						[511260.60715753381, 636740.24877931259],
						[511303.85583282018, 636740.27843135479],
						[511317.96313879179, 636740.28812815726],
						[511317.94191397872, 636771.14770765987],
						[511460.8682198365, 636771.24663147121],
						[511460.8468040197, 636801.99560722092],
						[511546.52004875446, 636802.05549947137],
						[511546.49839523749, 636832.91508719942],
						[511575.53662798676, 636832.93548839306],
						[511575.51499781164, 636863.68447249278],
						[511632.8705488366, 636863.72491894441],
						[511632.84873329086, 636894.58451509336],
						[511746.83881530765, 636894.66549302428],
						[511746.81741765176, 636924.64023013692],
						[511804.17235949828, 636925.23431313271],
						[511804.15053999261, 636955.65148591984],
						[511820.62601015909, 636955.66331273585],
						[511976.11325929052, 636955.77574080043],
						[511976.09071941418, 636986.74595711916],
						[512004.40788024903, 636986.76659054053],
						[512004.36309735093, 637048.15399625327],
						[512032.68015251053, 637048.17467833066],
						[512032.59021363559, 637171.17075640941],
						[512057.71497656812, 637171.18914771138],
						[512061.58277150278, 637232.69007983769],
						[512089.89950910641, 637232.71086037706],
						[512089.87707973155, 637263.23868282],
						[512146.40748000104, 637263.2803139966]
					]
				],
				[
					[
						[503051.13409576128, 639225.47959003714],
						[503051.15122302528, 639133.12103490811],
						[503133.72358934925, 639133.13655474328],
						[503136.80642671196, 639164.10767243337],
						[503337.16243934521, 639164.14709048916],
						[503337.15618011932, 639195.00701482408],
						[503394.40064769826, 639195.01872523152],
						[503394.40696865181, 639164.38001899875],
						[503737.77150521689, 639164.23322262941],
						[503737.77854095644, 639133.26269375975],
						[503908.99779771053, 639133.30248175771],
						[503909.00502434792, 639102.88500236522],
						[504081.04826322821, 639102.92677650449],
						[504081.04071852658, 639133.34425582062],
						[504137.56469421147, 639133.35837312881],
						[504137.55690593593, 639164.32890181709],
						[504281.28608882031, 639164.36567397485],
						[504281.29414764099, 639133.39514535735],
						[504395.16576309397, 639133.42517007492],
						[504395.1738885229, 639103.00769090618],
						[504480.83515349135, 639103.03079677979],
						[504480.84352765075, 639072.28149488079],
						[504509.87780871295, 639072.28942764935],
						[504509.89463523886, 639010.90144572908],
						[504538.20831282379, 639010.90923096042],
						[504538.21682466741, 638980.04933300987],
						[504567.25126848579, 638980.05736702471],
						[504567.25980408024, 638949.30808234704],
						[504595.57358765654, 638949.31596629811],
						[504595.59067199071, 638888.14923654031],
						[504622.25720728375, 638888.15670636576],
						[504623.81027352886, 638857.29725959804],
						[504652.94789375231, 638857.30547377153],
						[504652.97394951608, 638765.16829297447],
						[504623.83616612473, 638765.16007875849],
						[504623.87946548231, 638611.08202200406],
						[504595.66806118825, 638611.07411810674],
						[504595.70229158859, 638488.5196457603],
						[504567.3877150506, 638488.51176159398],
						[504567.41322966362, 638396.59595191712],
						[504538.37775623932, 638396.58791761904],
						[504538.4032611858, 638304.11910309899],
						[504510.08836732263, 638304.11131753353],
						[504510.10525442474, 638242.50233217212],
						[504537.59654521977, 638242.50989058556],
						[504538.42867459514, 638211.98215293232],
						[504567.46447378822, 638211.99018732109],
						[504567.47297864535, 638181.35161817656],
						[504595.78808375925, 638181.35950249014],
						[504595.7966104509, 638150.83154613129],
						[504624.00880387373, 638150.83945024945],
						[504624.01760049333, 638119.53723851382],
						[504653.15652722132, 638119.54545305553],
						[504653.16509775555, 638089.23872225382],
						[504681.37739678734, 638089.24672473769],
						[504681.39492499985, 638027.63779939036],
						[504710.53401447716, 638027.64611554379],
						[504710.55158846127, 637966.25842424261],
						[504738.76409835118, 637966.26652512047],
						[504738.78177758516, 637904.87885086506],
						[504767.09735846374, 637904.88702997554],
						[504767.11514333292, 637843.49937275727],
						[504796.15159276658, 637843.50781069812],
						[504796.16955043614, 637781.89895381988],
						[504824.48534294695, 637781.90723168687],
						[504824.5213405923, 637659.13200247637],
						[504796.20533680532, 637659.12372454698],
						[504796.24118762952, 637536.1273467571],
						[504767.2041957805, 637536.1189086549],
						[504767.23092110403, 637443.87166997674],
						[504738.91454688553, 637443.86349063402],
						[504738.92333870119, 637413.33563589538],
						[504710.70988075872, 637413.32753474545],
						[504710.718715225, 637382.46785974933],
						[504681.5784831997, 637382.45954327297],
						[504681.58723154612, 637351.71048067161],
						[504653.37366794317, 637351.70247783361],
						[504653.38233228435, 637321.06402759021],
						[504624.24199151987, 637321.05581264896],
						[504624.25063268543, 637290.306758511],
						[504567.72032530792, 637290.29096923792],
						[504567.72876872943, 637259.87374358007],
						[504510.3747197928, 637259.41549032484],
						[504510.38308751187, 637228.88766078663],
						[504453.02880930318, 637228.87203975604],
						[504453.0205479876, 637259.39986931987],
						[504395.66637613217, 637259.38444822421],
						[504395.65813258215, 637290.24410631065],
						[504338.30406823335, 637290.22888514702],
						[504338.2959614048, 637320.97793943237],
						[504310.0823451113, 637320.97052519396],
						[504310.07431997539, 637351.60897561023],
						[504224.40393649956, 637351.58675880916],
						[504224.39604248374, 637382.33582163719],
						[504195.35877924191, 637382.32839264732],
						[504195.35091128311, 637413.188067907],
						[504167.85823487124, 637413.18108130782],
						[504167.02675344091, 637443.70872770762],
						[504137.98959850229, 637443.70139995276],
						[504137.98183810664, 637474.5610837664],
						[504109.66551669955, 637474.55398727069],
						[504109.6578922795, 637505.08185075875],
						[504082.1653694, 637505.07500733202],
						[504081.39885737118, 637689.45878899645],
						[504052.25916899985, 637689.45158698864],
						[504052.25156925805, 637720.31130500988],
						[504025.58314121253, 637720.30475900858],
						[504024.0236251413, 637781.69200512348],
						[503994.884100108, 637781.68490471889],
						[503994.87663477845, 637812.43402723817],
						[503966.66386112728, 637812.4272018203],
						[503966.64906257356, 637873.81485128321],
						[503938.33342822699, 637873.80804962676],
						[503938.32604205591, 637904.66779336112],
						[503909.28970055358, 637904.66086918092],
						[503909.23869388161, 638119.35189359449],
						[503880.92348206177, 638119.34519072587],
						[503880.91609909222, 638150.64740282414],
						[503909.23125704442, 638150.65410568146],
						[503909.22400415957, 638181.18206236896],
						[503851.87304517458, 638181.1685366712],
						[503851.86587279942, 638211.80710615555],
						[503624.00692099257, 638211.75534251565],
						[503623.2794518022, 638242.28314904019],
						[503594.96445153531, 638242.27693826344],
						[503594.95770918048, 638273.1367335174],
						[503537.60707070265, 638273.12430319178],
						[503537.57401562715, 638426.87030084711],
						[503508.53859562287, 638426.8640838532],
						[503508.53206245223, 638457.50268754526],
						[503451.9028026234, 638457.49070964579],
						[503451.88983115245, 638519.32097340678],
						[503422.8545742915, 638519.31490761519],
						[503422.84184998536, 638580.48153623147],
						[503394.52743170148, 638580.47567037481],
						[503394.52117922285, 638610.78246914432],
						[503365.48608376487, 638610.77650458761],
						[503365.47968114592, 638642.07878652308],
						[503251.60466514272, 638642.05588820938],
						[503251.5986321774, 638672.5839130769],
						[503108.5858799144, 638672.55627207644],
						[503108.59164753614, 638642.02824715781],
						[503051.24229483365, 638642.01751205721],
						[503051.23663362255, 638672.54553699843],
						[502993.99034823134, 638672.53502054117],
						[502993.9959032333, 638642.00699558586],
						[502965.68159082998, 638642.00186770991],
						[502965.67608836474, 638672.52989267663],
						[502822.66333564033, 638672.50473687169],
						[502822.65280447184, 638733.89262604294],
						[502793.61792625865, 638733.88767063839],
						[502793.60750341549, 638795.2755769121],
						[502765.29345475783, 638795.27079387684],
						[502765.28826827032, 638826.13066674036],
						[502736.25355282775, 638826.12581255939],
						[502736.24843919091, 638856.87508086837],
						[502707.9344965393, 638856.87039653875],
						[502707.91935077595, 638948.89700935676],
						[502679.70852569636, 638948.89239053917],
						[502679.70351769129, 638979.64167599299],
						[502850.92437315005, 638979.67045321257],
						[502850.90838916291, 639071.91833517654],
						[502822.59481656918, 639071.91345353494],
						[502822.57371623936, 639194.91068965395],
						[502879.20043809933, 639194.92050158756],
						[502879.91579829011, 639225.448729333],
						[502965.5764258086, 639225.46394624212],
						[502965.58192829031, 639194.93584466027],
						[502993.89528917708, 639194.94097236055],
						[502993.88973416382, 639225.46907393681],
						[503051.13409576128, 639225.47959003714]
					]
				],
				[
					[
						[505596.0235519089, 639871.55327022215],
						[505596.03401075833, 639840.80386142875],
						[505653.37918507261, 639840.82346638932],
						[505653.38978910894, 639809.9634525883],
						[505709.91144029988, 639809.9829715977],
						[505710.75645571476, 639748.37385228637],
						[505738.96591000684, 639748.38366810605],
						[505738.9870146052, 639687.880373255],
						[505768.12331905233, 639687.44812511257],
						[505768.14507368853, 639625.39631736069],
						[505739.00881368481, 639625.38612827356],
						[505739.05164017633, 639502.60987578833],
						[505710.8417644829, 639502.60005982139],
						[505710.87366886181, 639410.68382918695],
						[505682.56067922898, 639410.67402597447],
						[505682.58191976114, 639349.17534195271],
						[505653.5481273068, 639349.16533977399],
						[505653.55869330943, 639318.41600419697],
						[505625.24554489524, 639318.40629961365],
						[505625.25605798408, 639287.65696832223],
						[505596.22215696616, 639287.64706729644],
						[505596.23265341215, 639256.78713120404],
						[505567.91939894803, 639256.77752527245],
						[505567.929692559, 639226.36002975749],
						[505539.61646021536, 639226.1292543998],
						[505539.62673872605, 639195.60115405556],
						[505510.59267526312, 639195.59140413301],
						[505510.60301103466, 639164.73148089147],
						[505453.2554802032, 639164.71237358311],
						[505453.26574507268, 639133.74184561707],
						[505395.91810622596, 639133.72293815576],
						[505395.92808177217, 639103.30545953638],
						[505310.36977647536, 639103.27762260614],
						[505310.37970094685, 639072.52832117153],
						[505282.06612939783, 639072.51920715347],
						[505282.07603646239, 639041.65930101997],
						[505253.04170134617, 639041.65000558854],
						[505253.05144801136, 639011.12193064019],
						[505196.42409355863, 639011.10394862876],
						[505196.43383995042, 638980.24405105226],
						[505053.52672076883, 638980.1995374501],
						[505053.51724241074, 639011.0594351145],
						[504967.13478681224, 639011.03313007252],
						[504967.12557065056, 639041.56120518513],
						[504938.81194581371, 639041.55268185702],
						[504938.80268257868, 639072.41258818877],
						[504881.45482997323, 639072.39547388768],
						[504881.44570711395, 639103.14477557433],
						[504856.32389401295, 639103.13734144066],
						[504853.12321618747, 639133.55387861223],
						[504824.08904322988, 639133.54534013325],
						[504824.07091457036, 639195.37579211127],
						[504795.7575544265, 639195.36751495791],
						[504795.74865613168, 639225.89561573556],
						[504766.71464613301, 639225.88717850286],
						[504766.69682911126, 639287.38582920935],
						[504795.73073058628, 639287.39426641085],
						[504795.7039389764, 639379.3104472335],
						[504824.01698257984, 639379.31872429629],
						[504823.97177437349, 639533.50792736723],
						[504849.91657481319, 639533.51555487863],
						[504852.9871668549, 639594.79398382944],
						[504881.29983965174, 639594.80235946737],
						[504881.2908480317, 639625.10929715494],
						[504995.9827002167, 639625.14372449112],
						[504995.96385780931, 639687.19553319179],
						[505024.17341699556, 639687.20412343112],
						[505024.15480596013, 639748.14985633886],
						[505053.2908485629, 639748.15877948026],
						[505053.2813701717, 639779.01878498215],
						[505081.49077192257, 639779.0274734993],
						[505081.4812747789, 639809.77687396237],
						[505252.79644518468, 639809.83067795704],
						[505252.78659254266, 639840.69069200731],
						[505391.77399972419, 639840.73565368482],
						[505395.67615343747, 639871.48634518078],
						[505596.0235519089, 639871.55327022215]
					]
				],
				[
					[
						[508111.4206722391, 642299.6063399578],
						[508111.43572565069, 642269.07781156083],
						[508140.56730391621, 642269.09220199462],
						[508140.67382250488, 642053.84407711565],
						[508111.54186305584, 642053.82968649198],
						[508111.57213346689, 641992.4408719528],
						[508140.70420163381, 641992.45526263316],
						[508140.7801767799, 641838.92799733486],
						[508111.64783673413, 641838.91360652423],
						[508111.67810711771, 641777.52485286596],
						[507997.82479122235, 641777.46910633566],
						[507997.83979464084, 641746.60882041161],
						[507740.27963885199, 641746.48561756371],
						[507740.2651186029, 641777.3459037143],
						[507682.92669402185, 641777.31902490067],
						[507682.9122296744, 641808.28992586501],
						[507654.60336595401, 641808.27672907547],
						[507654.58921224019, 641838.69458256243],
						[507625.55981291214, 641838.68110047048],
						[507625.53135646746, 641900.06987237534],
						[507597.22265068383, 641900.05677432823],
						[507597.19419770787, 641961.66678456753],
						[507568.88559792453, 641961.65373528411],
						[507568.87389271706, 641987.09413961438],
						[507568.85735274921, 642023.04254213593],
						[507597.16584689042, 642023.05559136556],
						[507597.15174810268, 642053.58408555214],
						[507625.46018968779, 642053.59718347737],
						[507625.44588454283, 642084.45751347172],
						[507654.4748501599, 642084.47099536262],
						[507654.46054202464, 642115.22071919916],
						[507682.76887754112, 642115.23391574516],
						[507682.75446482963, 642146.09425446624],
						[507711.78332168062, 642146.10783748724],
						[507711.76901006937, 642176.63634891785],
						[507768.2825306899, 642176.66293935291],
						[507768.2679574978, 642207.52328675275],
						[507904.97071593761, 642207.5884102101],
						[507968.58690905839, 642207.61910349037],
						[507968.57212080661, 642238.14762335317],
						[508054.93763352733, 642238.18968634412],
						[508054.92252251238, 642269.05004224973],
						[508083.23059331399, 642269.06392793055],
						[508083.21559224371, 642299.59245634743],
						[508111.4206722391, 642299.6063399578]
					]
				],
				[
					[
						[506052.93178938236, 642667.2750674109],
						[506052.94294145243, 642636.96770688798],
						[506081.14744298655, 642636.97810940945],
						[506081.15885147476, 642606.11769925652],
						[506110.28983287519, 642606.12849425233],
						[506110.30125492479, 642575.37869929546],
						[506138.50586206006, 642575.38920016284],
						[506138.52018488513, 642537.00726802112],
						[506138.52877032215, 642514.00023415219],
						[506167.65991485544, 642514.01113075123],
						[506167.70594879234, 642391.23325115035],
						[506053.03337898408, 642391.19065567385],
						[506053.05604940082, 642329.580520591],
						[505938.38304981432, 642329.53872433573],
						[505938.37194931379, 642360.28848443064],
						[505910.06403550151, 642360.27828972682],
						[505910.03681392298, 642436.04660220537],
						[505910.03089273488, 642452.52759632235],
						[505884.91419367731, 642452.51859167684],
						[505852.69482151017, 642452.5070967885],
						[505852.68258241285, 642486.90702819091],
						[505852.67298003315, 642513.89604573639],
						[505827.55637467804, 642513.887128665],
						[505767.13241010462, 642513.86583364313],
						[505767.12170714559, 642544.39439859299],
						[505795.32636740804, 642544.40431104775],
						[505795.30466195836, 642606.01450775936],
						[505927.26652683312, 642613.03000811569],
						[505938.28039008164, 642613.91886679083],
						[505938.27208465885, 642636.92591141444],
						[505995.60751309141, 642636.94670922915],
						[505995.59646666021, 642667.25406979455],
						[506052.93178938236, 642667.2750674109]
					]
				],
				[
					[
						[504508.82518649474, 642912.55674920965],
						[504508.83349379507, 642882.24935324129],
						[504537.14050937793, 642882.25713663723],
						[504537.15738081862, 642821.0893030325],
						[504566.1850465397, 642821.09733517235],
						[504566.2107151816, 642728.6266468321],
						[504594.51799512829, 642728.63452896476],
						[504594.54373019957, 642636.49571269914],
						[504566.23629170255, 642636.48783052119],
						[504566.24485814164, 642605.62741944776],
						[504508.90932055569, 642605.61160367413],
						[504508.91774911364, 642574.86180774868],
						[504423.37749622937, 642574.83858330525],
						[504423.38579463051, 642543.97818096424],
						[504394.25470316625, 642543.97037331969],
						[504394.26285827253, 642513.44180758519],
						[504336.92699937348, 642513.42659125384],
						[504336.9350772294, 642482.7874190869],
						[504308.73031132529, 642482.7800071711],
						[504308.7383656202, 642452.03022862831],
						[504280.43060968263, 642452.02283827611],
						[504280.43869740813, 642420.94123202364],
						[504251.4103255489, 642420.93370412709],
						[504251.4181583171, 642390.62637704704],
						[504194.08187134715, 642390.61165860854],
						[504194.08973948075, 642359.75128245645],
						[504165.78182474663, 642359.74408939644],
						[504165.78961176606, 642328.99432828184],
						[504136.7610776528, 642328.9870027022],
						[504136.79195303493, 642206.20922307589],
						[504165.82070380944, 642206.2165487092],
						[504165.8362498252, 642144.8276850495],
						[504194.14453439647, 642144.83487820299],
						[504194.15240252239, 642113.97453711694],
						[504251.48965371214, 642113.98925580748],
						[504251.46581239504, 642206.23846044287],
						[504307.9792313411, 642206.25316321512],
						[504308.78666239965, 642267.6422598362],
						[504336.99179717683, 642267.64967184258],
						[504336.98374848964, 642298.17820289358],
						[504423.45188434835, 642298.20122718392],
						[504423.44358595792, 642329.061594425],
						[504594.62958579446, 642329.10851757904],
						[504594.63820532738, 642298.24815042294],
						[504737.51650532277, 642298.2886781831],
						[504737.55186448811, 642175.51091728499],
						[504764.31601088902, 642175.51864699437],
						[504765.87788147596, 642114.13023997273],
						[504823.21513211692, 642114.14695140719],
						[504823.22414792393, 642083.39722556248],
						[504852.25311541773, 642083.40576250909],
						[504852.28933043068, 641960.6281237551],
						[504823.26014627586, 641960.61958674621],
						[504823.27821030689, 641899.00957258674],
						[504794.96950270282, 641899.00129679032],
						[504794.9873962233, 641837.6125208973],
						[504765.95799499418, 641837.60408500151],
						[504765.97578017984, 641776.21532646008],
						[504737.66686126695, 641776.2071492729],
						[504737.68457266199, 641714.70779774478],
						[504709.47848981287, 641714.69969871361],
						[504709.48722945584, 641684.1712500985],
						[504680.3546153566, 641684.16293579468],
						[504680.36342681356, 641653.19205026724],
						[504652.15723848628, 641653.18404951971],
						[504652.16590299853, 641622.54499924206],
						[504594.82693887915, 641622.52888399805],
						[504594.84408521093, 641561.14018610818],
						[504366.31091525411, 641561.07794200873],
						[504366.31910604914, 641530.2176841062],
						[504280.67047786067, 641530.19517441466],
						[504280.67847920593, 641499.44553107372],
						[504223.33908602444, 641499.43071064679],
						[504223.34683821147, 641469.23412265466],
						[504194.31689972337, 641468.78425468761],
						[504194.32468322257, 641438.25584037649],
						[504166.83873184217, 641438.24885549373],
						[504166.02308176336, 641407.05657583533],
						[504081.19736302795, 641407.03531324503],
						[504080.46901936276, 641438.22720560979],
						[504051.33596972004, 641438.22000523913],
						[504051.3057336674, 641560.99735002045],
						[504023.09938726889, 641560.99042784562],
						[504023.0919214575, 641591.51885949995],
						[503996.32682489569, 641591.5123357448],
						[503993.95165096433, 641622.37202754593],
						[503937.43622613524, 641622.35840359866],
						[503937.4288927865, 641652.99745422183],
						[503880.09003481211, 641652.98383019527],
						[503880.07552952279, 641714.48316512804],
						[503851.04591101076, 641714.476343735],
						[503851.0387385225, 641745.1154074074],
						[503822.72976609279, 641745.10880468879],
						[503822.71539804217, 641806.93999692483],
						[503794.40653200581, 641806.93344294734],
						[503794.38535638514, 641898.74007578287],
						[503822.69406443753, 641898.7466297322],
						[503822.67265371408, 641990.88513283804],
						[503794.36410421669, 641990.87857892853],
						[503794.35698614526, 642021.7389026687],
						[503766.87200963474, 642021.73258604284],
						[503765.32092216716, 642052.26072917995],
						[503737.11541808309, 642052.25429735216],
						[503737.10840737756, 642083.11462986458],
						[503707.97649976832, 642083.10803755536],
						[503707.96261258819, 642144.71810524829],
						[503684.38953181461, 642144.71280861716],
						[503679.7504381123, 642175.24028578307],
						[503651.44220586622, 642175.23397782748],
						[503651.43535582244, 642206.09432790952],
						[503623.1271766689, 642206.08806867781],
						[503622.38636422198, 642298.0053229098],
						[503651.41495300789, 642298.01174079604],
						[503651.39442742342, 642390.48224613094],
						[503623.08656557341, 642390.47598696733],
						[503622.35932801221, 642420.78315563349],
						[503594.05151830678, 642420.77694643452],
						[503594.03800916765, 642482.60833186412],
						[503565.00974613044, 642482.60201522987],
						[503564.98313783994, 642605.37995294156],
						[503651.34672259778, 642605.39889642887],
						[503651.33987254038, 642636.25930793292],
						[503707.85181418125, 642636.27194900496],
						[503707.84498276783, 642666.57931081101],
						[503765.18030785577, 642666.5923344749],
						[503765.17314294481, 642697.89519800805],
						[503794.20102606562, 642697.90186786721],
						[503794.19398450595, 642728.43045998318],
						[504022.81387329963, 642728.48478132975],
						[504022.80638039636, 642759.12398853421],
						[504080.14138291928, 642759.13810999482],
						[504080.13381065783, 642789.66671063646],
						[504136.64522526931, 642789.68082480633],
						[504136.63735342078, 642820.9837060197],
						[504165.6650193301, 642820.99103137548],
						[504165.67294642125, 642789.68815017911],
						[504193.98012128705, 642789.69534305215],
						[504193.97214032972, 642820.99822423444],
						[504308.64171399793, 642821.02786019386],
						[504308.63377557643, 642851.33524766192],
						[504365.96845669928, 642851.35036537272],
						[504365.96026585036, 642882.21081170463],
						[504479.80593598215, 642882.24142230826],
						[504479.79768216773, 642912.5488182907],
						[504508.82518649474, 642912.55674920965]
					]
				],
				[
					[
						[499812.5728834222, 645320.72796623362],
						[501405.76649614511, 645295.23556229961],
						[502951.9261748034, 645295.44039344834],
						[503591.87699836644, 645307.62443091325],
						[503707.2491252399, 645310.083499967],
						[503707.2562559272, 645278.44841830619],
						[503679.056233946, 645278.66331036179],
						[503679.07652305398, 645187.96135391342],
						[503707.27702467004, 645186.3085044563],
						[503707.30459996598, 645063.97153760633],
						[503736.43132924737, 645063.53568050358],
						[503736.43823953648, 645033.11736790021],
						[503763.91828591662, 645032.68118552328],
						[503763.92527234182, 645002.15226531762],
						[503793.66953860567, 645002.1590991281],
						[503793.68374943698, 644940.54821191076],
						[503736.45927194023, 644940.53511226899],
						[503736.46623248479, 644909.89559327287],
						[503679.1385779687, 644910.5463415276],
						[503679.14555543265, 644879.35376701842],
						[503650.8419765479, 644879.3474600967],
						[503650.84887578199, 644848.26550208661],
						[503593.52115491201, 644848.25287691597],
						[503593.52782497142, 644817.72398304369],
						[503536.19999764941, 644817.71155766072],
						[503536.20663264638, 644786.85083240212],
						[503364.22282773152, 644786.81475508946],
						[503364.21651543229, 644817.67548041325],
						[503336.01575290191, 644817.66973630991],
						[503336.00956082344, 644848.19863028696],
						[503307.70592832728, 644848.19291384541],
						[503307.69582922023, 644898.41074171918],
						[503307.68737621763, 644940.44329396344],
						[503278.66345040506, 644940.43748263456],
						[503278.65732062957, 644971.18761822022],
						[503250.35389978014, 644971.18200047303],
						[503250.34959351528, 644992.97256687365],
						[503250.34168048116, 645033.01412109344],
						[503225.94869693066, 645036.43829193781],
						[503221.3119604151, 645063.42672375869],
						[503164.70543616585, 645063.41573434556],
						[503164.69951939915, 645094.16588772205],
						[503135.67586485227, 645094.16032871441],
						[503136.4933879883, 645124.80003144941],
						[503078.34326642973, 645124.78904493398],
						[503078.33746970276, 645155.76043141331],
						[503021.83418361488, 645155.74995298171],
						[503021.82859489444, 645186.16828339],
						[502907.1752153752, 645187.80679953552],
						[502907.18635974935, 645124.75790076563],
						[502878.88320317154, 645124.75292226509],
						[502878.16755955701, 645097.32100042584],
						[502827.11942335789, 645094.10439630947],
						[502821.56697748596, 645063.35328843049],
						[502763.51948529482, 645063.78588087275],
						[502763.52467057726, 645032.92511969293],
						[502735.22135596938, 645032.92038841534],
						[502735.22650654597, 645001.94901967584],
						[502706.9231386304, 645001.94433709385],
						[502706.92821770196, 644971.08358485333],
						[502678.72771820589, 644971.07896773238],
						[502678.73272634554, 644940.32883194555],
						[502649.60587860923, 644940.32411391533],
						[502649.61081447336, 644909.6845945284],
						[502564.08259943518, 644910.33471047017],
						[502564.08746219397, 644879.14213556168],
						[502505.21601735987, 644879.13306307315],
						[502505.22075161646, 644848.05110466084],
						[502306.47778842825, 644848.022033446],
						[502306.47346076887, 644878.88276799209],
						[502020.6587394675, 644879.06639442896],
						[502020.65498886106, 644909.59529762005],
						[501979.89791020984, 644909.590340856],
						[501877.7992939289, 644910.24203916336],
						[501877.80288040615, 644878.8282401649],
						[501849.49930062104, 644878.82503307704],
						[501849.50277084846, 644847.96429842035],
						[501820.47868184239, 644847.96106027742],
						[501820.49567497493, 644694.43173696962],
						[501792.19177787553, 644694.42862850241],
						[501792.19511643099, 644663.78914420109],
						[501763.99409004702, 644663.78609547042],
						[501764.00069767586, 644602.17530458793],
						[501734.87325109798, 644602.17220647051],
						[501734.876471191, 644571.64334719384],
						[501706.67528681614, 644571.6403967411],
						[501706.67211907019, 644602.16925602616],
						[501621.03948456491, 644602.16059334099],
						[501621.0424933696, 644571.63173403894],
						[501592.01791673066, 644571.62889904575],
						[501592.02684575698, 644479.37867679214],
						[501621.0515851815, 644479.38151179662],
						[501621.06066609046, 644387.24194108229],
						[501649.36509181693, 644387.24475506146],
						[501649.36818642722, 644356.38409140054],
						[501677.56973987591, 644356.38694359513],
						[501677.57913731929, 644264.24742591591],
						[501649.3774258917, 644264.2445737042],
						[501649.38357074064, 644202.96573276061],
						[501621.07882790064, 644202.96291875315],
						[501621.08190210641, 644171.77044688677],
						[501592.05661985435, 644171.76761182561],
						[501592.06254040834, 644110.59940890491],
						[501935.22087659955, 644110.63620394899],
						[501935.22445542947, 644080.21802642569],
						[501963.42648238939, 644080.22136874939],
						[501963.43015298061, 644049.47136096144],
						[501991.73521353444, 644049.03231798601],
						[501992.56604184018, 643987.8642500178],
						[502019.22431189695, 643987.86750104849],
						[502020.78333823499, 643864.86773905123],
						[501992.58094203175, 643864.86429838731],
						[501992.58465367911, 643834.22493292764],
						[501935.25341139571, 643834.10747621953],
						[501935.25696419302, 643803.91056075529],
						[501877.92565375176, 643803.46146966424],
						[501877.9291770655, 643772.60089017265],
						[501792.29222353711, 643772.59133587405],
						[501792.29555002297, 643742.06259491784],
						[501764.09294325829, 643742.05954602011],
						[501764.08966911671, 643772.58828697912],
						[501734.96075341967, 643772.58518870024],
						[501734.96397349768, 643742.05644773552],
						[501592.09821358818, 643742.04199886229],
						[501592.10120062594, 643711.18142814282],
						[501534.76951646426, 643711.1759787401],
						[501534.7724062553, 643680.20480110659],
						[501506.46676382213, 643680.20218432345],
						[501506.47236590565, 643619.03412162093],
						[501477.44610826299, 643619.0314888088],
						[501477.45990818081, 643465.39243525639],
						[501506.48643694021, 643465.3950680939],
						[501506.48923291091, 643434.86637075758],
						[501563.82188014966, 643434.87172159355],
						[501563.82481407555, 643404.01119500957],
						[501621.15756886092, 643404.01674568688],
						[501621.16059944924, 643373.26683472656],
						[501706.79963200318, 643373.27549806051],
						[501706.79644132149, 643404.02540900663],
						[501734.99962767365, 643404.02835966612],
						[501734.99637259962, 643434.88888621901],
						[501764.1258863273, 643434.89198456029],
						[501764.12261219043, 643465.42068184551],
						[501820.63170530862, 643465.42683949671],
						[501820.63508432492, 643434.89814221987],
						[501877.96773145231, 643434.90458801156],
						[501877.97125476261, 643404.04406148975],
						[501906.99789177859, 643404.04740109155],
						[501907.00503448746, 643342.43697251473],
						[501935.31125815999, 643342.44027855748],
						[501935.31484999368, 643311.91159877961],
						[501963.51819428295, 643311.91494124779],
						[501963.51455010509, 643342.44362102565],
						[501991.8207737687, 643342.44702432095],
						[501992.64048911451, 643373.30764170806],
						[502020.84372813208, 643373.31108247396],
						[502020.82864426158, 643496.08952989266],
						[502049.95804961066, 643496.0931344144],
						[502049.9542173908, 643526.843062851],
						[502106.46309949318, 643526.85020246252],
						[502106.45914746559, 643557.71074656537],
						[502163.79136653064, 643557.71818859584],
						[502163.79542611871, 643526.8576445044],
						[502192.82184640976, 643526.86148848524],
						[502192.82594570954, 643496.11156008265],
						[502220.30845884932, 643496.11524681095],
						[502221.13604221266, 643465.47604521189],
						[502250.16257082077, 643465.47999037686],
						[502250.16674703686, 643434.95129319909],
						[502278.4728115084, 643434.95518977591],
						[502278.46858275967, 643465.48388694797],
						[502306.67166373495, 643465.48781779199],
						[502306.66305500804, 643526.87705891381],
						[502335.79240583349, 643526.88116962195],
						[502335.78368839063, 643588.27042827103],
						[502363.9865588398, 643588.27445738728],
						[502363.98212364281, 643619.13501024805],
						[502393.11131108506, 643619.13922246592],
						[502393.10683733021, 643649.88916842965],
						[502478.64149988285, 643649.9018352658],
						[502478.66003451328, 643526.90207792516],
						[502506.96594074991, 643526.90636770427],
						[502506.9706273218, 643496.15643938375],
						[502535.2765864656, 643496.16077787837],
						[502536.00182556728, 643465.5215762679],
						[502564.30783743295, 643465.52596471866],
						[502564.31740768458, 643404.13674127986],
						[502591.80007449153, 643404.141048691],
						[502592.64775849559, 643250.39166879118],
						[502621.67466664937, 643250.39626954892],
						[502621.67954994465, 643219.75699191249],
						[502649.88305223902, 643219.76151122293],
						[502649.88797024713, 643189.23284904589],
						[502679.01791901048, 643189.2375675746],
						[502679.02795322315, 643127.62720095506],
						[502707.23161348485, 643127.63181859429],
						[502707.23669251066, 643096.77133638645],
						[502735.5433389378, 643096.77601950942],
						[502735.54841588577, 643066.24737480306],
						[502764.57564899378, 643066.25222773198],
						[502764.58600358258, 643004.64189635683],
						[502792.89280855039, 643004.64667816833],
						[502792.9031940354, 642943.47880827414],
						[502821.93064378441, 642943.48376241256],
						[502821.95707657636, 642789.40274941293],
						[502735.59445788054, 642789.38816034421],
						[502735.58925217664, 642820.69104211289],
						[502707.28213065187, 642820.68635891052],
						[502707.27206363372, 642881.85419401363],
						[502649.9374888459, 642881.84485768701],
						[502649.94246030052, 642850.98441066395],
						[502421.42720896413, 642850.94918489107],
						[502421.43167029764, 642820.64179670624],
						[502335.89269551693, 642820.62942737492],
						[502335.88839178585, 642850.93681557942],
						[502278.55370923778, 642850.92877371307],
						[502278.54943453439, 642881.78922083811],
						[502250.24241814966, 642881.7853241337],
						[502250.23827220814, 642912.09272095468],
						[502221.2107670593, 642912.08877565665],
						[502221.20241784147, 642973.92030284822],
						[502192.8955599991, 642973.91650482686],
						[502192.89147545636, 643004.55574760132],
						[502163.86413347651, 643004.55190349859],
						[502163.86008844757, 643035.30176164769],
						[502106.52604850312, 643035.29431938217],
						[502106.52209648979, 643066.15479295945],
						[501992.67769926775, 643066.14060770057],
						[501992.68143770029, 643035.28013410047],
						[501963.5512162908, 643035.27663101198],
						[501963.5585442413, 642973.88752998365],
						[501935.35462037218, 642973.88418744458],
						[501935.36189511797, 642912.05266011436],
						[501963.56592500018, 642912.05600267032],
						[501963.57300208317, 642852.76854412165],
						[501992.70377448387, 642850.89166170522],
						[501992.70744591393, 642820.58427342132],
						[502050.04223422945, 642820.59131897253],
						[502050.04993999592, 642758.7598356643],
						[502135.58923650661, 642758.77071859105],
						[502135.59321425704, 642728.13151073223],
						[502078.25810367113, 642728.12416699377],
						[502078.26196064946, 642697.59557430272],
						[502020.9267436309, 642697.58843039442],
						[502020.9343127195, 642635.97820393066],
						[501992.72980947688, 642635.97476301179],
						[501992.73354790069, 642605.11435097246],
						[501935.3980085394, 642605.10750517505],
						[501935.4016263861, 642574.35770830628],
						[501907.09408095642, 642574.35440210486],
						[501907.11191842717, 642420.4948727166],
						[501935.41972862312, 642420.49817894911],
						[501935.42692526669, 642359.33047412802],
						[501963.63190284092, 642359.33381679724],
						[501963.63557340542, 642328.58405491791],
						[501992.76704630308, 642328.58755815658],
						[501992.78565799718, 642174.94942493015],
						[502020.99095170933, 642174.9528659482],
						[502020.99849360139, 642113.56400953676],
						[502050.13034727727, 642113.56761436164],
						[502050.13417947199, 642082.81788743206],
						[502078.33963115187, 642082.82142677892],
						[502078.3435300439, 642051.96109371423],
						[502262.91458732611, 642051.98544818209],
						[502278.66437636357, 642051.98762229132],
						[502278.66860508849, 642021.45912514476],
						[502306.87416197447, 642021.46305633429],
						[502306.88277063996, 641960.07424359093],
						[502336.01489613042, 641960.07835469279],
						[502336.03668171546, 641806.66170414293],
						[502306.9042845394, 641806.65759300441],
						[502306.92153287196, 641683.65888593171],
						[502278.71539679024, 641683.6549546629],
						[502278.71968679153, 641652.68406817806],
						[502221.38082773756, 641652.67622558377],
						[502221.38496497995, 641622.03717436013],
						[502250.41474661476, 641622.04111996968],
						[502250.42736594146, 641529.79216156015],
						[502278.73670890072, 641529.79605858168],
						[502278.74521229026, 641468.40738496883],
						[502306.95171743468, 641468.41131629143],
						[502306.95599848934, 641437.88290128356],
						[502336.08904873574, 641437.88701251557],
						[502336.0934780938, 641406.6949407513],
						[502364.30008904968, 641406.69897039724],
						[502364.30889576417, 641345.42094175809],
						[502336.10217974288, 641345.41691208957],
						[502336.10654627223, 641314.66729411052],
						[502221.42647181632, 641314.65140872914],
						[502221.4306389268, 641283.79118495504],
						[502164.09049409349, 641283.78354203515],
						[502164.10661587043, 641161.22757107322],
						[502193.13721067493, 641161.23141560366],
						[502193.14542393113, 641099.62162596209],
						[502164.11472040816, 641099.61778141465],
						[502164.11876540096, 641068.8681981276],
						[502135.80862925254, 641068.86449833889],
						[502135.81263569079, 641038.00430939835],
						[502106.78182343225, 641038.00056602363],
						[502106.78573291644, 641007.47221137257],
						[502135.81659904425, 641007.47595475009],
						[502135.82060548011, 640976.61577451089],
						[502164.13090037194, 640976.61947431951],
						[502164.13491626288, 640946.09112828202],
						[502219.93203735311, 640946.09856290848],
						[502221.48040522373, 640915.23859983112],
						[502250.51143411023, 640915.24254561076],
						[502250.51564054069, 640884.49298837665],
						[502278.82609396166, 640884.49688555393],
						[502278.83033798402, 640853.85794256139],
						[502307.03789682762, 640853.86187402566],
						[502307.05942612997, 640700.33539421693],
						[502278.85160405008, 640700.33146271587],
						[502278.85587871185, 640669.47132598888],
						[502250.54505526199, 640669.4674287634],
						[502250.54926168377, 640638.71790617891],
						[502221.51774482772, 640638.71396033419],
						[502221.53020130959, 640546.46541856264],
						[502193.21916618664, 640546.46161998319],
						[502193.23963291175, 640392.93535624305],
						[502221.5509322274, 640392.93915485928],
						[502221.55922160484, 640331.55080150999],
						[502278.90268544422, 640331.55864473875],
						[502278.90692945325, 640300.91977934993],
						[502250.59550204838, 640300.69466280448],
						[502250.59967820218, 640270.16641133151],
						[502221.56751097995, 640270.16246539901],
						[502221.57580035273, 640208.77414651786],
						[502193.26421360433, 640208.54912872321],
						[502193.26812115428, 640179.23759517609],
						[502164.23596807505, 640177.90643577906],
						[502164.24404347292, 640116.51814275258],
						[502190.18792455533, 640116.52157607488],
						[502193.29287876684, 639993.52423424262],
						[502078.60359462717, 639993.50934444589],
						[502078.59969577199, 640024.36938579264],
						[502050.39071469038, 640024.36584600667],
						[502050.38691010157, 640054.89406323514],
						[501963.90698253916, 640054.88351277425],
						[501963.91062665789, 640024.35529552586],
						[501907.38971195457, 640024.34864566952],
						[501907.39328966138, 639993.4886042804],
						[501850.04864748794, 639993.48205594788],
						[501850.05210519768, 639962.73262834153],
						[501821.01939545874, 639962.72938922979],
						[501821.02278666588, 639932.09057536628],
						[501792.71069429792, 639932.08746599546],
						[501792.71402072615, 639901.55926582124],
						[501735.3690581285, 639901.55311720283],
						[501735.37231314956, 639870.69309307192],
						[501707.16306857258, 639870.69014178077],
						[501707.15986646386, 639901.55016591167],
						[501564.15779624734, 639901.53594888956],
						[501564.15489391488, 639932.06414911197],
						[501392.12032504496, 639932.04869281175],
						[501392.11773257231, 639962.68750676012],
						[501334.77298304089, 639962.68275442324],
						[501334.77048838307, 639993.43218212319],
						[501278.24946744379, 639993.42769363848],
						[501278.24706983496, 640024.28773514088],
						[501048.86893044942, 640024.27151260898],
						[501048.86698424304, 640054.79973001592],
						[501020.55510304135, 640054.79794941202],
						[501020.54366552387, 640239.18404871481],
						[500992.33505276288, 640239.1823230579],
						[500992.33319141774, 640270.04239924951],
						[500963.30102397734, 640270.04067371716],
						[500963.29923651711, 640300.56892542797],
						[500877.64420639531, 640300.56413305423],
						[500877.64256017521, 640331.42421792448],
						[500649.09230743826, 640331.41361306608],
						[500649.09109428828, 640362.16309266817],
						[500619.95613903814, 640362.16196895717],
						[500619.95382581349, 640423.55033145822],
						[500591.74552916182, 640423.54929265322],
						[500591.7444192089, 640454.40939491196],
						[500562.71257711382, 640454.40837627684],
						[500562.71047747455, 640515.79676470906],
						[500506.08830168116, 640515.79492541659],
						[500506.08736260654, 640546.32321149646],
						[500477.05568270356, 640546.32234401861],
						[500477.05478787585, 640577.18246363744],
						[500419.71218017291, 640577.18090074218],
						[500419.71139572858, 640607.93041495397],
						[500391.40046638413, 640607.92971702712],
						[500391.3997374851, 640638.56862578366],
						[500305.84941575764, 640638.56681282737],
						[500305.8488441325, 640669.31633568951],
						[500133.82198440691, 640669.31403682742],
						[500133.82223450235, 640638.56451396248],
						[500105.51135786972, 640638.56430800573],
						[500105.51116069348, 640669.31383087358],
						[500076.47969782929, 640669.31367027294],
						[500076.47984074464, 640638.564147408],
						[500048.16896411672, 640638.5640401314],
						[500048.16905379301, 640607.92513136636],
						[499990.82655324624, 640607.92506335326],
						[499990.82651883259, 640546.31542950554],
						[499968.07474131236, 640546.31545790378],
						[499933.48380354297, 640546.31556136231],
						[499933.48368008534, 640515.78727526811],
						[499933.48355528479, 640484.92716431373],
						[499905.27536387678, 640484.92730252084],
						[499905.27501036145, 640423.53892272478],
						[499876.96376370155, 640423.5391100694],
						[499876.96330455021, 640362.15074752027],
						[499847.93129965063, 640362.15099023096],
						[499847.92959515785, 640177.76478691166],
						[499876.96192543214, 640177.76454420097],
						[499876.96169709816, 640147.2363095755],
						[499905.27341922926, 640147.23612223368],
						[499905.27324152051, 640116.37606330309],
						[499962.61745536269, 640116.37583312031],
						[499962.61738546408, 640085.62638804887],
						[500019.96170648391, 640085.62635773863],
						[500019.96174363088, 640054.98752647254],
						[500047.45000679244, 640054.76636383287],
						[500048.17076221434, 640024.23814845679],
						[500076.48269600369, 640024.2382557363],
						[500076.48283943807, 639993.3782141488],
						[500105.51549509395, 639993.37837475503],
						[500105.51529720367, 640024.23841634812],
						[500133.82723099634, 640024.23862230487],
						[500133.82748198818, 639993.37858070899],
						[500158.12431438075, 639993.37879631296],
						[500162.86044199608, 639962.62941471417],
						[500219.38156874757, 639962.63007134944],
						[500219.38197726832, 639931.99125729338],
						[500248.51769431226, 639931.99167162296],
						[500248.51862153894, 639870.60344697209],
						[500219.38279578072, 639870.60303264251],
						[500219.38525131647, 639686.43846182851],
						[500248.52140321466, 639686.43887615809],
						[500248.52186933235, 639655.57888212486],
						[500276.01079918235, 639655.57932034053],
						[500276.7320036281, 639624.60873347637],
						[500419.73648654833, 639624.39054185874],
						[500419.73725969793, 639594.08360284567],
						[500534.42932827404, 639594.08692869579],
						[500534.43033066147, 639563.22694766067],
						[500562.7430577802, 639563.2278917199],
						[500562.74516497814, 639501.61855187314],
						[500591.77868841623, 639501.61957056494],
						[500591.7808884189, 639440.45268473006],
						[500617.72583560471, 639440.45363839972],
						[500619.99202937033, 639409.70437331987],
						[500649.12867133215, 639409.70549709874],
						[500649.12989757129, 639378.62432367471],
						[500705.65303063457, 639378.62665085855],
						[500705.6543351835, 639348.20913664659],
						[500734.68812933553, 639348.21040752647],
						[500734.69087542396, 639286.71173710038],
						[500763.00407838565, 639286.71302577946],
						[500763.00693030318, 639225.21437256341],
						[500792.04094149795, 639225.2157446472],
						[500792.0438966137, 639163.82771766814],
						[500820.35731103871, 639163.82910504146],
						[500820.36037179694, 639102.44109519885],
						[500848.67389186024, 639102.44253130187],
						[500848.67706966243, 639040.83332061814],
						[500877.71140622534, 639040.83484388446],
						[500877.71468094439, 638979.44686834584],
						[500906.02841266722, 638979.44840314589],
						[500906.03179302206, 638918.06044472381],
						[500935.06634623749, 638918.06206920242],
						[500935.068081151, 638887.53400975897],
						[500961.73461744201, 638887.53554688743],
						[500963.38557831419, 638825.9264927085],
						[500992.42029411386, 638825.92821839382],
						[500992.42399676476, 638764.54030275601],
						[501106.29816511908, 638764.54756541806],
						[501106.30024003197, 638733.68770078011],
						[501135.33511859807, 638733.6896786592],
						[501135.33935443999, 638672.30178872601],
						[501163.6536147084, 638672.30376686575],
						[501163.65577371075, 638641.77574147412],
						[501191.97008650587, 638641.77776833787],
						[501191.98566343595, 638426.75440480246],
						[501078.00620924291, 638426.52532501519],
						[501078.00820931135, 638395.99733359623],
						[500963.41075151757, 638395.99022452137],
						[500963.41258429416, 638364.68797681632],
						[500906.06226493936, 638364.68471873563],
						[500906.06393379561, 638334.37795309466],
						[500877.74909200997, 638334.37641823501],
						[500877.75073821773, 638303.51661368494],
						[500820.40020564938, 638303.51365418243],
						[500820.4017387749, 638272.76446253131],
						[500763.05109902035, 638272.76170292124],
						[500763.05394579662, 638211.37394100102],
						[500734.73889233737, 638211.37265223986],
						[500734.74026044016, 638180.73408194247],
						[500677.38929991558, 638180.73162090499],
						[500677.39055666735, 638150.20366337639],
						[500562.79138699279, 638150.19934449939],
						[500562.79245761014, 638118.8971315457],
						[500506.16203242016, 638118.89529198979],
						[500506.16296468198, 638088.58855998993],
						[500477.12694773707, 638088.58769237879],
						[500477.12606895471, 638118.89442438143],
						[500448.81085635535, 638118.89362765837],
						[500448.81168298441, 638088.58689565572],
						[500419.77566603397, 638088.58612925408],
						[500419.77645329112, 638057.72635895689],
						[500276.75835688651, 638057.72333173885],
						[500248.54600381409, 638057.72288137465],
						[500248.54646826017, 638026.97372384334],
						[500191.19497180177, 638026.9729574332],
						[500191.19461453578, 638057.72211496462],
						[500133.8432252538, 638057.72154845251],
						[500133.84347534494, 638026.97239092411],
						[500076.49197888782, 638026.97202431015],
						[500076.49226420483, 637965.5843304937],
						[500048.17678778403, 637965.5842232001],
						[500048.17696746212, 637904.1965463981],
						[500019.96435115451, 637904.19648795878],
						[500019.96442557662, 637842.80882816017],
						[499990.82500878058, 637842.80881858082],
						[499990.82497436734, 637781.19995908544],
						[499962.61214717233, 637781.19999897783],
						[499962.61207702314, 637750.34027148201],
						[499962.61200838577, 637720.14419819613],
						[499933.47237301641, 637719.81246522372],
						[499933.47224822006, 637688.95274627057],
						[499876.94331039255, 637688.95307187049],
						[499876.94308205851, 637658.42518207734],
						[499762.23752000631, 637658.42643960775],
						[499762.23707406776, 637627.56672919448],
						[499704.8841854835, 637627.56765781681],
						[499704.88363396859, 637596.81855995418],
						[499676.67049063422, 637596.81909011712],
						[499676.66988856939, 637566.18060475681],
						[499647.52998189052, 637566.18120312272],
						[499647.52932319988, 637535.43211376877],
						[499561.96286489395, 637535.43416904204],
						[499561.96123066015, 637474.04661130544],
						[499504.60780698282, 637474.04823799338],
						[499504.60687788733, 637443.18855321966],
						[499418.93697127554, 637443.19135534205],
						[499418.93589323282, 637412.66349935706],
						[499333.36879652098, 637412.66674334346],
						[499333.36132648756, 637228.28300669533],
						[499361.57510171481, 637228.28188789601],
						[499361.57390439301, 637197.42223725049],
						[499390.61149393459, 637197.42113629275],
						[499390.61035926576, 637166.78270600957],
						[499402.4519515179, 637166.78227175085],
						[499476.28170495725, 637166.77975641505],
						[499476.28073331923, 637136.25193837378],
						[499504.59763689822, 637136.25106152322],
						[499504.5985560012, 637166.77887956728],
						[499533.63619961747, 637166.77803099889],
						[499533.63533438544, 637136.25021295762],
						[499561.95223796729, 637136.24943480408],
						[499561.95140760369, 637105.05797286297],
						[499590.16539410839, 637105.05724600528],
						[499590.16463650391, 637074.64004442049],
						[499647.51945231756, 637074.63871594821],
						[499647.52010389901, 637105.05591753579],
						[499676.66082719009, 637105.05531915009],
						[499676.661440122, 637136.24678109691],
						[499762.22997423378, 637136.24532226624],
						[499762.23041537532, 637166.77314031892],
						[499786.63439246564, 637166.77280580811],
						[499790.54765644734, 637197.41118584329],
						[499847.90204434108, 637197.41055580205],
						[499847.90119057248, 637105.05284549971],
						[499876.93894311698, 637105.05260274361],
						[499876.93848479452, 637043.77577178786],
						[499905.25554751034, 637043.77558440645],
						[499905.25519400311, 636982.3881623589],
						[499962.61033135612, 636982.38793213363],
						[500019.96546871221, 636982.387901815],
						[500019.96554326947, 636920.88988876354],
						[500048.17984554759, 636920.88994721137],
						[500048.17993457854, 636890.47277077031],
						[500076.49726110132, 636890.47287806962],
						[500076.49740453105, 636859.6132742163],
						[500105.5355901866, 636859.61343485373],
						[500105.53578736202, 636828.86444314593],
						[500162.89145982458, 636828.86491100048],
						[500162.89176527178, 636798.00531567296],
						[500191.20925092202, 636798.00562037213],
						[500191.2096081847, 636767.25663716742],
						[500219.42417387804, 636767.25698922807],
						[500219.42540384317, 636675.01006503543],
						[500248.5668887067, 636675.01047944988],
						[500248.56781591574, 636613.62315895176],
						[500276.06182822661, 636613.62359724962],
						[500276.78315847419, 636583.0958670713],
						[500305.92481021793, 636582.87516755029],
						[500305.9259513932, 636521.48787238845],
						[500334.14093848044, 636521.48842114094],
						[500334.14281149668, 636429.2415985259],
						[500391.49987684155, 636429.24286319141],
						[500391.50060309132, 636398.71514611319],
						[500448.13694861863, 636398.71659105353],
						[500448.85861654195, 636367.85707484791],
						[500562.85234756686, 636367.86057911185],
						[500562.85339925712, 636337.1116551595],
						[500734.82258306368, 636337.11843582732],
						[500734.8212100385, 636367.86735976557],
						[500763.13943588594, 636367.86864867411],
						[500763.13800481561, 636398.72818450304],
						[500792.17700377415, 636398.72955682187],
						[500792.17553422233, 636429.25727387459],
						[500820.493654427, 636429.25866147457],
						[500820.49059370824, 636490.64593121503],
						[500877.84744502808, 636490.64889104315],
						[500877.84579883376, 636521.50844382145],
						[500906.16376028938, 636521.50997885386],
						[500906.16037996847, 636582.89727392502],
						[500991.73179152916, 636582.90220861009],
						[500992.55743167119, 636552.2639125092],
						[501020.77236598905, 636552.26563855133],
						[501020.77427335194, 636521.51668926538],
						[501049.09223479452, 636521.51847025449],
						[501049.09614830045, 636460.13119208463],
						[501078.1350389049, 636460.13306902337],
						[501078.13706068904, 636429.27352474816],
						[501106.45518086536, 636429.2754044485],
						[501106.4593083362, 636367.88815163495],
						[501135.49836171477, 636367.89012980007],
						[501135.50048342813, 636337.1412059071],
						[501163.81876215135, 636337.14318431879],
						[501163.82092895737, 636306.50487227389],
						[501221.17842209723, 636306.50902878575],
						[501221.18070389691, 636275.76011334476],
						[501392.42969720601, 636275.7737126837],
						[501392.43228963419, 636245.1354090824],
						[501564.50543173571, 636244.92965367064],
						[501564.5083340198, 636214.40196189471],
						[501592.82682395668, 636214.40467856755],
						[501592.83276570594, 636153.01748490415],
						[501621.87219825818, 636153.02032134752],
						[501621.8752396474, 636122.16081954783],
						[501650.19388831971, 636122.16363493749],
						[501650.19697172154, 636091.41474490659],
						[501678.41269620595, 636091.41759853461],
						[501678.40641267202, 636153.02599034528],
						[501707.54882191948, 636153.02898848534],
						[501707.54565429164, 636183.55667185737],
						[501764.07976380445, 636183.56263518461],
						[501764.90026634658, 636214.42223375535],
						[501793.11577992729, 636214.42528404947],
						[501793.12246882415, 636153.03809046547],
						[501821.44106436119, 636153.04120054445],
						[501821.444479995, 636122.18169878435],
						[501850.48396695865, 636122.18493864941],
						[501850.48742460529, 636091.43604865251],
						[501936.16436889517, 636091.44590604433],
						[501936.16797361977, 636060.80762779352],
						[501992.70250482543, 636060.81437653955],
						[501993.5337863568, 635999.20611001702],
						[501936.17522210814, 635999.1992614693],
						[501936.17881381768, 635968.67160328641],
						[501878.82014314533, 635968.6649546423],
						[501878.82366633439, 635937.80547830649],
						[501821.46488807589, 635937.79902957752],
						[501821.4682669802, 635907.27137973625],
						[501764.93320828554, 635907.26521925558],
						[501764.93973260955, 635846.43114680122],
						[501793.15596150537, 635845.65994543477],
						[501793.16265039385, 635784.2728529186],
						[501821.48188051709, 635784.27596307115],
						[501821.48867504159, 635722.88888736558],
						[501850.52886662039, 635722.89212730725],
						[501850.53233670251, 635692.03268478811],
						[501821.4920906662, 635692.02944484085],
						[501821.49888518784, 635630.6423943782],
						[501735.81954179914, 635630.63313398138],
						[501735.82276175887, 635600.1055259303],
						[501764.96615017409, 635600.10862574726],
						[501764.96945978247, 635569.24920009251],
						[501735.82601671934, 635569.24610027275],
						[501735.82926000888, 635538.49728609237],
						[501707.61258749256, 635538.49433402228],
						[501707.61578953965, 635507.63491682254],
						[501650.25551192177, 635507.62906484213],
						[501650.25857313484, 635477.10147349967],
						[501564.5784303585, 635477.09310464258],
						[501564.58138520928, 635446.01248146372],
						[501535.54070504144, 635446.00974612217],
						[501535.54355344072, 635415.48216312705],
						[501478.18295462686, 635415.47691090312],
						[501478.18570656201, 635384.83872488304],
						[501306.92744179262, 635384.82423317444],
						[501306.92986610666, 635354.29665845004],
						[501221.2490839705, 635354.29007708258],
						[501221.25137397106, 635323.43068509747],
						[501163.89048560761, 635322.98409981385],
						[501163.89262893511, 635292.67774769804],
						[501135.57255284447, 635292.67576915887],
						[501135.57468218106, 635261.81638561445],
						[501106.53367696807, 635261.81440731604],
						[501106.53781928867, 635200.20625998918],
						[501078.21758407139, 635200.20438014716],
						[501078.21958410565, 635169.67683045031],
						[501049.17841629853, 635169.67495336721],
						[501049.18035541591, 635139.25801485009],
						[501020.86001531075, 635139.25623371359],
						[501020.86193638772, 635108.28626416728],
						[500992.6445262382, 635108.28453797218],
						[500992.64640088554, 635077.20396567276],
						[500963.60506989365, 635077.20223959372],
						[500963.60865120456, 635016.03657069162],
						[500992.65009012865, 635016.03829677356],
						[500992.6538060591, 634954.43021668075],
						[501020.87148000835, 634954.43194289296],
						[501020.87527412607, 634893.26630733174],
						[500992.65749530675, 634893.26458111394],
						[500992.65934993536, 634862.51585919806],
						[500935.29682376259, 634862.51249920262],
						[500935.29859007796, 634831.43196080206],
						[500677.52718210523, 634831.41932985047],
						[500677.5284251803, 634801.22365071566],
						[500620.16569370875, 634801.00017535756],
						[500620.1668523752, 634770.25146598089],
						[500562.90698998043, 634770.24940782983],
						[500562.90804166585, 634739.50070264819],
						[500534.58701364388, 634739.49975831143],
						[500534.58901118662, 634678.00236051576],
						[500506.26787733537, 634678.00146491139],
						[500506.27070469561, 634586.08721994259],
						[500477.22850705858, 634586.08635215019],
						[500477.23118825891, 634493.61911096307],
						[500448.90973711223, 634493.61831406434],
						[500448.9114114581, 634432.23158992396],
						[500419.86894231831, 634432.23082334665],
						[500419.86972673947, 634401.48216418969],
						[500391.54811704188, 634401.48146599939],
						[500391.54957215959, 634340.31598017341],
						[500219.456533255, 634340.3127855286],
						[500219.45612621936, 634370.84022304858],
						[500133.87321174645, 634370.83930429455],
						[500133.87346003798, 634340.31186677457],
						[500076.50911372621, 634340.31150008133],
						[500076.50897183933, 634370.83893760131],
						[500048.18730940856, 634370.83883028501],
						[500048.18721973483, 634401.47687860799],
						[500019.96859769436, 634401.47682014876],
						[500019.96856041811, 634432.22547931992],
						[499990.82310378837, 634432.22546973778],
						[499990.82318972511, 634586.07943512767],
						[499933.45970003679, 634586.07956703822],
						[499933.45982349379, 634616.60703776032],
						[499905.24157031614, 634616.60717601841],
						[499905.24174674816, 634647.24525766796],
						[499847.87847025518, 634647.24568787066],
						[499847.87903772359, 634708.63247048447],
						[499676.6137361438, 634708.63494449749],
						[499676.61313408805, 634677.99685451761],
						[499619.24996478244, 634677.99808159913],
						[499619.24925337621, 634647.2493889766],
						[499561.88597690064, 634647.25081600156],
						[499561.88516126573, 634616.61273435468],
						[499504.52177800389, 634616.61436132598],
						[499504.52085891395, 634586.08689061226],
						[499476.19956688909, 634586.08776759612],
						[499476.19858470408, 634555.22848074615],
						[499418.83498749183, 634555.2304063749],
						[499418.83281190402, 634493.62245205755],
						[499390.51136076206, 634493.62347649923],
						[499390.51023020176, 634463.09602242056],
						[499361.46781552723, 634463.09712355398],
						[499361.46542520594, 634401.48919436336],
						[499304.10129213758, 634401.49151989876],
						[499304.09999662329, 634370.85347160138],
						[499247.55965967482, 634370.85595939145],
						[499247.55826396373, 634340.32852190267],
						[499161.15128640807, 634340.33269908279],
						[499161.15284239023, 634370.86013656319],
						[499075.46694017266, 634370.86472686916],
						[499075.46522525279, 634340.33728940017],
						[499047.14351033483, 634340.33890472725],
						[499047.14171086095, 634309.25843820034],
						[499018.09902471863, 634309.26014526514],
						[499018.09720339591, 634278.73271612066],
						[498960.73264245945, 634278.73623846145],
						[498960.73069377913, 634247.87699361984],
						[498932.51180838328, 634247.87879971019],
						[498932.50982831704, 634217.35137885634],
						[498960.72876605229, 634217.34957276308],
						[498960.72294096951, 634125.10369562916],
						[498904.18175976624, 634125.10736307129],
						[498904.17359991238, 634002.55534465576],
						[498817.76481721987, 634002.11889872397],
						[498817.76703392586, 634032.97811003786],
						[498789.44479009119, 634032.98016882909],
						[498789.44701922574, 634063.28635177063],
						[498703.75951567607, 634063.29287731298],
						[498703.75712875574, 634032.98669438285],
						[498674.71395509323, 634032.98900739593],
						[498674.71147015982, 634002.12979610474],
						[498589.02364821074, 634002.13691899914],
						[498589.03157551459, 634094.6039589257],
						[498618.17763004213, 634094.60148606263],
						[498618.19309215544, 634278.76143290405],
						[498589.04736375704, 634278.76390574151],
						[498589.05264547205, 634340.37180129101],
						[498560.83391866746, 634340.37424465397],
						[498560.83658816235, 634370.90168205788],
						[498331.37962955103, 634370.92334620608],
						[498331.37653444399, 634340.39590883907],
						[498303.05481962801, 634340.39880463376],
						[498303.05796726811, 634370.92624199227],
						[498274.83929285227, 634370.92917571659],
						[498274.84250442759, 634401.5672238752],
						[498245.69699350762, 634401.57030475151],
						[498245.70027113438, 634432.31896374701],
						[498188.33624552476, 634432.32517827395],
						[498188.33964249922, 634463.18444815464],
						[498074.43570475199, 634463.19738059619],
						[498074.43927648052, 634493.72483449348],
						[498045.39691585989, 634493.72825803515],
						[498045.40058086498, 634524.58753626596],
						[498017.07918301388, 634524.59092417522],
						[498017.08288779971, 634555.33959986246],
						[497992.7780245152, 634555.3425461601],
						[497988.86830060155, 634586.20231055154],
						[497959.72311665263, 634586.20589786617],
						[497959.73830964684, 634708.75823192555],
						[497988.88327657199, 634708.75464463921],
						[497988.88704759447, 634739.61395225103],
						[498017.10508986743, 634739.61052823626],
						[498017.1087946581, 634770.35923321126],
						[498045.42976957938, 634770.35584535287],
						[498045.43342145282, 634801.10455452825],
						[498102.79616168182, 634801.09784190741],
						[498102.79966813064, 634831.51473461802],
						[498131.84143267846, 634831.51141237072],
						[498131.84845122468, 634893.34067239822],
						[498160.16921451339, 634893.3374819851],
						[498160.17605247599, 634954.50311727996],
						[498188.39372630179, 634954.49998694891],
						[498188.40050809411, 635016.10806678399],
						[498217.54493071989, 635016.10488444322],
						[498217.55155549332, 635077.27055309038],
						[498274.91333314625, 635077.2644403876],
						[498274.91659110662, 635108.34501257376],
						[498303.13400116039, 635108.34207897983],
						[498303.14347832999, 635200.25653643697],
						[498331.46371346165, 635200.25364079804],
						[498331.46995977155, 635261.86178794364],
						[498274.93268383533, 635261.86761713971],
						[498274.93591861281, 635292.72700059065],
						[498245.79198585695, 635292.73008129979],
						[498245.80507282948, 635415.50401436212],
						[498217.58818943525, 635415.50704625377],
						[498217.59149583522, 635446.03462920361],
						[498160.23100353475, 635446.04094169976],
						[498160.23447816342, 635477.12156482204],
						[498131.91471947957, 635477.12475512188],
						[498131.91818482161, 635507.65234642476],
						[498102.87761342671, 635507.65566853597],
						[498102.88117089041, 635538.51508569322],
						[498045.52100092988, 635538.52179801383],
						[498045.52465281705, 635569.27061214333],
						[498017.20505270397, 635569.27399984305],
						[498017.20877083356, 635600.13342544669],
						[497988.9922040074, 635600.1368492858],
						[497988.99593449768, 635630.66445728031],
						[497959.85260019603, 635630.66804436268],
						[497959.85639846046, 635661.30626380024],
						[497931.6399365181, 635661.30978597677],
						[497931.64767982549, 635722.91805937362],
						[497902.50450889405, 635722.92174801382],
						[497902.50839985593, 635753.44937268866],
						[497788.61339195806, 635753.46428332385],
						[497788.6175387869, 635784.32373420731],
						[497702.21814244339, 635784.33557102468],
						[497702.22671380494, 635845.72266330861],
						[497645.69144369039, 635845.73065422755],
						[497645.70462498645, 635937.86662784661],
						[497673.92061274755, 635937.86261541082],
						[497673.92928975419, 635999.24974973698],
						[497731.28785385145, 635999.24174222548],
						[497731.2963473929, 636060.85010839393],
						[497759.61510157742, 636060.84622869291],
						[497759.62766027782, 636153.09289843729],
						[497788.66709270037, 636153.08897061262],
						[497788.67534178536, 636214.47616400686],
						[497759.63601769245, 636214.48009182012],
						[497759.64017380989, 636245.00778344588],
						[497776.11638539092, 636245.22676379059],
						[497788.67947375961, 636245.22507081449],
						[497788.69597193995, 636367.9995250355],
						[497817.01419756695, 636367.9957441052],
						[497817.01829130127, 636398.85527969326],
						[497846.05729003879, 636398.85145314049],
						[497846.06532516499, 636460.23871404363],
						[497874.38339206489, 636460.23503184156],
						[497874.38733537949, 636490.76275706314],
						[497931.74418630736, 636490.75544824614],
						[497931.74806492601, 636521.61500082619],
						[497989.10480831412, 636521.60789194971],
						[497989.11230987974, 636582.99518665543],
						[498017.32719150791, 636582.99176302028],
						[498017.33089632774, 636613.74072059966],
						[498043.28030102485, 636613.73761456553],
						[498045.65598974493, 636675.12465319131],
						[498074.69450096303, 636675.12123010273],
						[498074.70889154548, 636798.11713666748],
						[498045.6705973749, 636798.12055973057],
						[498045.67426241894, 636828.98015483993],
						[498017.35683007824, 636828.98354227631],
						[498017.3605348969, 636859.73253376025],
						[497960.00497003912, 636859.73954415484],
						[497960.00879574998, 636890.59914777311],
						[497931.79444154253, 636890.60266968329],
						[497931.79826456099, 636921.01984588639],
						[497898.02349375194, 636921.13473342499],
						[497874.4429276053, 636921.13776242756],
						[497874.44685663941, 636951.55494277738],
						[497846.12963522895, 636951.55862487457],
						[497846.13368899905, 636982.52884912991],
						[497788.77855214616, 636982.53645633545],
						[497788.7826989991, 637013.39607691718],
						[497759.74478471989, 637013.40000453778],
						[497759.7489408509, 637043.92780544562],
						[497645.86286427674, 637043.94370407995],
						[497645.85849686339, 637013.41590320051],
						[497616.7176112918, 637013.4200979505],
						[497616.72203277098, 637043.94789882144],
						[497588.50794148905, 637043.95200932841],
						[497588.51246393839, 637074.81163836503],
						[497531.15764873993, 637074.82014350314],
						[497531.16221236886, 637105.2373447537],
						[497503.66902144754, 637105.2414925982],
						[497502.8499888978, 637136.43307917891],
						[497416.45769133564, 637136.446416297],
						[497416.46248437138, 637166.97423397866],
						[497216.90591484372, 637167.00677513098],
						[497216.90075158846, 637136.47895751172],
						[497130.50845426845, 637136.49379591062],
						[497130.5030150087, 637105.3023344368],
						[497102.18605817645, 637105.30729674408],
						[497102.18070159038, 637074.8900956182],
						[497073.14289582777, 637074.89523485512],
						[497073.13740687503, 637044.03560597706],
						[496959.14835992613, 637044.0562756341],
						[496959.14271852415, 637013.52847496711],
						[496901.89066105266, 637013.53915438999],
						[496901.88485096017, 636982.6795340745],
						[496844.52971464215, 636982.69043245795],
						[496844.52377577784, 636951.72020850843],
						[496816.20655465196, 636951.72566293878],
						[496816.19476294634, 636890.78069910663],
						[496787.15663229534, 636890.78634300875],
						[496787.14460346737, 636829.17774861748],
						[496701.47150013514, 636829.19469880301],
						[496701.46531426214, 636798.33510409296],
						[496615.79205035226, 636798.35250035708],
						[496615.7857265604, 636767.60351779812],
						[496558.53281346138, 636767.61539184256],
						[496558.52635955636, 636736.75580571778],
						[496537.31390953431, 636736.7602556725],
						[496472.85277504398, 636736.77394617128],
						[496472.84623159567, 636706.24618778448],
						[496415.49013177207, 636706.25858157978],
						[496415.49678162218, 636736.7863399412],
						[496358.14078824531, 636736.79893363174],
						[496358.13403199066, 636706.27117529302],
						[496329.81638848636, 636706.27746672975],
						[496329.80950568814, 636675.41788918735],
						[496300.7709949963, 636675.42439139029],
						[496300.76418206701, 636645.11785703665],
						[496244.23165823205, 636645.1306625898],
						[496244.2245644728, 636614.04987800866],
						[496186.86814329907, 636614.06306866882],
						[496186.86106935923, 636583.53532719461],
						[496129.50448979752, 636583.3275022934],
						[496129.49728344387, 636552.68915731832],
						[496101.17937564466, 636552.69584220089],
						[496101.16477886809, 636491.08734177088],
						[496072.1259428988, 636491.09424744942],
						[496072.10400347231, 636399.17926316301],
						[496128.63737225771, 636399.16586627997],
						[496129.45391524251, 636368.30613748962],
						[496101.13569015078, 636368.31282245147],
						[496101.12840487168, 636337.56389934313],
						[496072.089297987, 636337.57080508966],
						[496072.0820376511, 636307.15370907076],
						[496043.76365414518, 636306.93927753088],
						[496043.75626169011, 636276.19036289153],
						[495958.18325526721, 636276.21115813137],
						[495958.19080761808, 636306.96007272822],
						[495843.47582459624, 636306.98864790832],
						[495843.46805789473, 636276.23973336257],
						[495786.11045928521, 636276.25432085921],
						[495786.10261373525, 636245.61601815582],
						[495757.78417751566, 636245.62329397467],
						[495757.7762507255, 636214.87438790919],
						[495728.73692733719, 636214.88189955312],
						[495728.72891758097, 636184.02239017375],
						[495614.83688970399, 636184.05234538834],
						[495614.82053146407, 636122.66516208334],
						[495585.67806845461, 636122.67295361403],
						[495585.6863464347, 636153.53245445632],
						[495528.32832012925, 636153.54794044932],
						[495528.34500105021, 636214.93513213843],
						[495500.1294883581, 636214.94282335474],
						[495500.13783608063, 636245.47051412507],
						[495528.35335653886, 636245.68403808214],
						[495528.37003746402, 636307.07125505374],
						[495557.51217392104, 636307.06336203881],
						[495557.52874614217, 636368.45059589203],
						[495528.38671839639, 636368.45848888136],
						[495528.39510394516, 636399.31802359992],
						[495442.82273780537, 636399.34149876144],
						[495442.83119193785, 636429.86921467842],
						[495357.15600968245, 636429.89316383237],
						[495357.16471637657, 636460.75270694343],
						[495185.91764836636, 636460.80191319413],
						[495185.89968978451, 636399.41465439543],
						[495071.18535128474, 636399.4486132114],
						[495071.20373779838, 636460.83587188541],
						[494985.52871677512, 636460.86175585666],
						[494985.51931315707, 636430.00221295224],
						[494928.26522547012, 636430.01975909318],
						[494928.25581675913, 636399.49204345385],
						[494727.86613859033, 636399.55502376088],
						[494727.85625182255, 636368.69548948412],
						[494613.14169918938, 636368.73264132207],
						[494613.1316335086, 636337.98371900106],
						[494527.55894843338, 636338.01195361465],
						[494527.54875963944, 636307.3736431899],
						[494470.19126955379, 636307.39281731891],
						[494470.18093680468, 636276.64390352939],
						[494384.50495682226, 636276.67291664192],
						[494384.49450172769, 636246.03461471177],
						[494298.81836238119, 636246.06407393701],
						[494298.80770945468, 636215.31516869576],
						[494241.44989850331, 636215.33514010592],
						[494241.43909969635, 636184.47563157906],
						[494155.86561637046, 636184.50579902716],
						[494155.85477493552, 636153.97811741708],
						[494098.4967501908, 636153.99858709378],
						[494098.48568335787, 636123.13908712391],
						[494008.89578205725, 636123.17145956354],
						[493983.7694189641, 636123.18062630785],
						[493983.73573485011, 636031.04458206403],
						[493955.4169293897, 636031.05495948147],
						[493955.40559433302, 636000.19547656295],
						[493927.18971345271, 636000.20586472959],
						[493927.17844793713, 635969.6782084133],
						[493812.46111377724, 635969.72094178828],
						[493812.43803236901, 635908.33381955384],
						[493783.29518980766, 635908.34480294236],
						[493783.2835320739, 635877.4853370582],
						[493726.7483710972, 635877.50679126161],
						[493726.73694466281, 635847.53218872496],
						[493697.69667653221, 635846.76903276821],
						[493697.68494305172, 635816.13079015829],
						[493612.00656548742, 635816.16382515582],
						[493612.01845848118, 635846.80206770624],
						[493411.72502874333, 635846.88103510533],
						[493411.71276285016, 635816.24279270228],
						[493354.35356093512, 635816.26585608337],
						[493354.34114358353, 635785.51701056457],
						[493326.02191560715, 635785.52847107255],
						[493326.00940048747, 635754.66902245232],
						[493268.64998395636, 635754.69238455046],
						[493268.6248743285, 635693.30532204697],
						[493240.40846725967, 635693.31688776391],
						[493240.38325238245, 635631.92984209955],
						[493211.23992033047, 635631.94183854305],
						[493211.21459675324, 635570.55480972049],
						[493182.99797921238, 635570.56647386821],
						[493182.98524189141, 635539.817662152],
						[493125.62507649825, 635539.84152276604],
						[493125.61218579835, 635508.98210809578],
						[493097.29248195043, 635508.99396221095],
						[493097.27967733092, 635478.46637339506],
						[493039.91929809842, 635478.49053274037],
						[493039.90615317802, 635447.40991219564],
						[492954.22585593507, 635447.4463718253],
						[492954.21278597676, 635416.9187914955],
						[492867.81146076601, 635416.95600967237],
						[492867.79818259698, 635386.31782640261],
						[492753.9006339279, 635386.36758196075],
						[492753.88719241676, 635355.84001010004],
						[492696.52638577489, 635355.8653663327],
						[492696.5124942587, 635324.56354881322],
						[492610.83155743696, 635324.60179626686],
						[492610.817949916, 635294.29544712789],
						[492553.45692875882, 635294.32130202954],
						[492553.47064191254, 635324.6276511203],
						[492524.42974755552, 635324.6408172457],
						[492524.4439663791, 635355.94263461791],
						[492438.8661746307, 635355.98173060594],
						[492438.880200502, 635386.5093022061],
						[492410.56028589536, 635386.5223380836],
						[492410.57441530784, 635417.16052097385],
						[492381.53368423664, 635417.17393925623],
						[492381.57633709558, 635509.30972733221],
						[492353.25663381122, 635509.32286182174],
						[492353.27097281045, 635540.18227585475],
						[492324.9513226531, 635540.19545905699],
						[492324.96566317545, 635570.94427005947],
						[492182.02893270174, 635571.01155286888],
						[492182.01432510524, 635540.2627419827],
						[492124.65416127339, 635540.29009148048],
						[492124.63939357584, 635509.43067765143],
						[492067.2791222792, 635509.45822712663],
						[492067.26440697064, 635478.93063917174],
						[492038.94465140894, 635478.94431454525],
						[492038.90002685995, 635386.69793274894],
						[491981.53932777501, 635386.72578106856],
						[491981.52445354126, 635356.1982098734],
						[491952.48361489217, 635356.2123852839],
						[491952.42352387711, 635233.32789252757],
						[491924.10334567062, 635233.3417655247],
						[491924.05813240312, 635141.20609184611],
						[491895.01691436931, 635141.22036866436],
						[491894.98635512858, 635079.16983422555],
						[491838.44845160219, 635079.19777556602],
						[491838.43342194322, 635048.89146020426],
						[491695.38917353406, 635048.96302081714],
						[491695.37360138656, 635018.10367482551],
						[491638.01161757135, 635018.1327205085],
						[491637.99599406659, 634987.38398575026],
						[491608.95450459089, 634987.39876736968],
						[491608.90758409654, 634895.37380217435],
						[491637.94923596946, 634895.35902047274],
						[491637.88674199604, 634772.36417361954],
						[491608.84487308533, 634772.37895543431],
						[491608.82919533952, 634741.63025422662],
						[491695.23406612809, 634741.58642621886],
						[491695.21849400306, 634710.72712230333],
						[491780.90262687911, 634710.68410785496],
						[491780.88732589799, 634680.04602168745],
						[491809.10547031596, 634680.03195349418],
						[491809.09027691581, 634649.50447824853],
						[491866.45343626145, 634649.25481528789],
						[491866.46863258397, 634680.00350416021],
						[491923.83179494552, 634679.97525476688],
						[491923.81670580013, 634649.22656583786],
						[491952.1378891826, 634649.21269235085],
						[491952.12290703889, 634618.5746143579],
						[492066.84966008528, 634618.51891260303],
						[492066.83494483749, 634587.99144542147],
						[492152.41673020506, 634587.95041484851],
						[492152.46055794408, 634679.86464941083],
						[492209.82372079184, 634679.83739684266],
						[492209.83822324919, 634710.47548339807],
						[492267.20127940126, 634710.44843081583],
						[492267.21577901382, 634741.30773524963],
						[492294.7129195758, 634741.29483841208],
						[492295.56559340318, 634802.79186055542],
						[492324.60740864463, 634802.77829056373],
						[492324.62159436435, 634833.19518016989],
						[492381.26332798676, 634833.16886137344],
						[492381.23501230701, 634772.00326562254],
						[492495.96069579339, 634771.95055520418],
						[492495.94667549746, 634741.20185320056],
						[492553.20663900452, 634741.17584444815],
						[492553.19267564616, 634710.31653976231],
						[492581.51375389984, 634710.30374934024],
						[492581.49994336371, 634679.66566246189],
						[492667.90513946099, 634679.62694112048],
						[492667.89153905929, 634649.09946512152],
						[492724.53380848642, 634648.85311417445],
						[492724.52026425552, 634618.21503551584],
						[492839.24701978976, 634618.16471814178],
						[492839.23373726237, 634587.63725030306],
						[492867.45204012195, 634587.62499674014],
						[492867.43866613368, 634556.76571277366],
						[492896.58390222519, 634556.75310748687],
						[492896.49114429025, 634341.84430396964],
						[492867.34552761487, 634341.85690941778],
						[492867.27884950442, 634188.00312574173],
						[492839.05986145575, 634188.015379605],
						[492839.03315208119, 634126.62874462188],
						[492810.71106940997, 634126.64109190262],
						[492810.69773437968, 634096.11369045684],
						[492838.19595292391, 634096.1017016609],
						[492838.95292774867, 633942.24772663787],
						[492867.17233718553, 633942.23547259602],
						[492867.15901117324, 633911.4868830893],
						[492896.30538999214, 633911.47427731543],
						[492896.29216616869, 633880.83629836794],
						[492953.5551230968, 633880.81168252346],
						[492953.54205322918, 633850.28431407874],
						[493010.18716972537, 633850.26015984034],
						[493010.17387610616, 633818.95855076169],
						[493039.21742746787, 633818.94624180987],
						[493039.20461009967, 633788.64009435626],
						[493010.16100525425, 633788.65240333357],
						[493010.14789953775, 633757.79322817898],
						[492810.54998622573, 633757.87920621352],
						[492810.56346618285, 633788.73838120664],
						[492695.8309287224, 633788.78889855242],
						[492695.817233646, 633757.92972365278],
						[492581.08448142122, 633757.98104089685],
						[492581.07062108337, 633727.23247663293],
						[492523.70413792843, 633727.25843522535],
						[492523.69012018095, 633696.39926884847],
						[492467.14746622811, 633696.42505032138],
						[492467.16158999305, 633727.28421665006],
						[492409.79510702309, 633727.31057227706],
						[492409.78087569593, 633696.45140599646],
						[492324.09146236401, 633696.4911463043],
						[492324.07722513145, 633665.96380321856],
						[492266.7105284275, 633665.99065756542],
						[492266.6816852495, 633604.60416497861],
						[492151.94786420034, 633604.65847373195],
						[492151.93304405897, 633573.57811184472],
						[492094.66901819722, 633573.60551673127],
						[492094.65446180373, 633543.29940288211],
						[491951.59712701174, 633543.36873651505],
						[491951.5820367636, 633512.50959567283],
						[491865.89166577434, 633512.55172152456],
						[491865.87646953145, 633481.80319117079],
						[491837.65627064207, 633481.81716202386],
						[491837.67151960608, 633512.56569235201],
						[491780.30428823479, 633512.59424206545],
						[491780.31969961396, 633543.45338274911],
						[491751.17266906402, 633543.4679648329],
						[491751.21873455419, 633635.38177420606],
						[491722.99879898928, 633635.39594164887],
						[491723.02967001544, 633696.78244150651],
						[491579.97366928717, 633696.85500524123],
						[491580.02097422804, 633789.32190802845],
						[491551.80130261031, 633789.3363690105],
						[491551.81685882725, 633819.64251517528],
						[491522.6703173822, 633819.65750192432],
						[491522.70216383855, 633881.48647686467],
						[491494.48265024403, 633881.50103612174],
						[491494.5143740832, 633942.88760211167],
						[491379.78291122208, 633942.94729363127],
						[491379.79907400621, 633973.80649243412],
						[491236.74548113998, 633973.88203946396],
						[491236.72905013635, 633943.02284080838],
						[491151.14391109493, 633943.06863304845],
						[491151.01165511837, 633697.08004621672],
						[491121.86489662563, 633697.09574275208],
						[491121.81531630422, 633605.18191036244],
						[491093.59532895993, 633605.19715697842],
						[491093.56211050745, 633543.8106831992],
						[491065.23902489757, 633543.82603416871],
						[491065.18882862793, 633451.3592329931],
						[490950.45393933909, 633451.42191735329],
						[490950.4372761923, 633421.1158209662],
						[490922.11385743675, 633420.91020586318],
						[490922.09683711559, 633390.05108272948],
						[490893.05252890417, 633390.06712766329],
						[490893.03563773044, 633359.53982720617],
						[490864.81522921094, 633359.55546608684],
						[490864.83217272518, 633390.08276651287],
						[490835.68487057131, 633390.09896984359],
						[490835.70205290877, 633420.9580928894],
						[490807.48174969654, 633420.9738300707],
						[490807.49879962084, 633451.50113867968],
						[490750.13135541667, 633451.53327906434],
						[490750.14869822643, 633482.3924103498],
						[490607.09083408705, 633482.47343022376],
						[490607.10838200012, 633513.22195932548],
						[490578.78524375637, 633513.23814740893],
						[490578.80290789629, 633544.09728688025],
						[490522.2597307309, 633544.12974989915],
						[490521.45323965297, 633574.43633670139],
						[490464.18921678967, 633574.46941442089],
						[490464.20722402813, 633605.54977462569],
						[490435.88424466405, 633605.56620861776],
						[490435.90198402357, 633636.09354161145],
						[490406.85810999334, 633636.11044450908],
						[490406.87609662837, 633666.96960047656],
						[490378.5532229612, 633666.9861331291],
						[490378.58910847362, 633728.37263860356],
						[490349.54539728258, 633728.38964263699],
						[490349.56342663348, 633759.13820474246],
						[490321.2407115706, 633759.15483601554],
						[490321.2588588816, 633790.01400862099],
						[490263.89259456797, 633790.04784378584],
						[490263.91052229464, 633820.3539886449],
						[490206.54436373006, 633820.38802370499],
						[490206.56298942294, 633851.68963006174],
						[490178.24043363106, 633851.7065074218],
						[490178.25865115388, 633882.23387322959],
						[490120.99569919205, 633882.26814500417],
						[490120.95858699054, 633820.43917299551],
						[490035.26981921296, 633820.49082970154],
						[490035.30725331884, 633882.31980151474],
						[490006.98475023446, 633882.3369735782],
						[490007.0220221217, 633943.72353645251],
						[489977.97869095049, 633943.74119617522],
						[489978.05331670633, 634066.29315868649],
						[489892.36582893186, 634066.34555939783],
						[489892.38505245507, 634097.6471993447],
						[489863.34199290432, 634097.66506136162],
						[489863.37966483476, 634158.83046915336],
						[489835.0576375848, 634158.84793707589],
						[489835.076628651, 634189.59655697201],
						[489806.85764334025, 634189.61400981457],
						[489806.87675563304, 634220.47324042604],
						[489577.41770059959, 634220.61695226526],
						[489577.43703300384, 634251.14436706319],
						[489549.11516461114, 634251.16232705221],
						[489549.13476025133, 634282.02156572766],
						[489520.91593341326, 634282.03950884356],
						[489520.97459739115, 634374.17482346529],
						[489491.8290379715, 634374.19340664661],
						[489491.84859994601, 634404.83144872112],
						[489463.62998367404, 634404.84949006408],
						[489463.7481664191, 634589.4520767919],
						[489434.60298824124, 634589.4707613159],
						[489434.62258601177, 634619.99822575273],
						[489406.40433866403, 634620.01636521216],
						[489406.42405998055, 634650.65444051987],
						[489378.10287908156, 634650.67269479588],
						[489378.12272450665, 634681.42138102558],
						[489351.44937127305, 634681.43861776264],
						[489349.10052322672, 634712.07823410479],
						[489378.14249854803, 634712.05946462962],
						[489378.22173751466, 634834.8330544089],
						[489406.54260150169, 634834.81480033975],
						[489406.56260761723, 634865.89533234737],
						[489434.7804333833, 634865.87719315989],
						[489434.81984199694, 634927.2640217134],
						[489492.18214254954, 634927.22729680676],
						[489492.20163394848, 634957.75480702752],
						[489521.34615993011, 634957.73622450896],
						[489521.36580854404, 634988.59555973439],
						[489492.22133721411, 634988.61414222186],
						[489492.29986780923, 635111.60909724399],
						[489091.59213110438, 635111.86982121668],
						[489091.55144174938, 635050.48294325662],
						[489063.33393250837, 635050.50167094171],
						[489063.39530818758, 635142.85851159925],
						[489035.07497429871, 635142.87735617417],
						[489035.11557978764, 635203.82183099061],
						[489006.07447225193, 635203.84120578528],
						[489006.09530905692, 635235.03239525505],
						[488920.41390615364, 635235.08985630516],
						[488920.43438409513, 635265.50680044468],
						[488834.8561221211, 635265.56463760883],
						[488834.83548600879, 635235.14769357117],
						[488805.69145129999, 635235.16749184148],
						[488805.60771334794, 635112.06186594279],
						[488834.75196606823, 635112.04206752521],
						[488834.73087972723, 635080.96150232106],
						[488862.94833674509, 635080.94238267723],
						[488862.92782765289, 635050.63607052737],
						[488834.71031867608, 635050.655190208],
						[488834.6685212109, 634989.04711573769],
						[488777.30643613648, 634989.08613241115],
						[488777.28539232857, 634958.22679810622],
						[488748.96474072098, 634958.24613503378],
						[488748.94394627458, 634927.82923263055],
						[488662.53997713263, 634927.77792219853],
						[488662.51887060364, 634897.13981023594],
						[488634.19811386953, 634897.15934465674],
						[488634.17687823542, 634866.41063001473],
						[488605.1351752886, 634866.43071232701],
						[488605.1136556486, 634835.35018133046],
						[488519.43017187173, 634835.40973003465],
						[488519.47330331244, 634897.23897541256],
						[488462.11089824274, 634897.27909068996],
						[488462.21860653954, 635050.91211874271],
						[488405.68060595833, 635050.95185314189],
						[488405.65886522143, 635020.09251088346],
						[488200.61811912601, 635020.23824117403],
						[488176.21095861448, 635020.25575841824],
						[488176.18886710942, 634989.50702762534],
						[488147.86826932861, 634989.52739895065],
						[488147.84604525397, 634958.66806547274],
						[488119.62837858946, 634958.68841122941],
						[488119.60634114518, 634928.16090273648],
						[488090.56474716682, 634928.18189308187],
						[488090.5425758182, 634897.54378187552],
						[488033.18017180957, 634897.58539219666],
						[488033.15781324718, 634866.83667835617],
						[488004.83700436691, 634866.85729581385],
						[488004.81435104361, 634835.77676561614],
						[487975.77259403834, 634835.79795853072],
						[487975.7503707431, 634805.38107373682],
						[487919.10854150966, 634805.42255496851],
						[487919.08596995287, 634774.67385386],
						[487890.04410512501, 634774.69519805908],
						[487890.02147930925, 634743.94650118216],
						[487861.70045895525, 634743.96736495628],
						[487861.67769865203, 634713.10806550761],
						[487832.63572517951, 634713.12951101258],
						[487832.61307397118, 634682.49142939691],
						[487776.07380770461, 634682.53332676808],
						[487776.05096909101, 634651.78464262024],
						[487746.90590129711, 634651.80631590332],
						[487746.83738680842, 634559.78150215396],
						[487718.61903621745, 634559.80253547628],
						[487718.55028143327, 634467.66715266882],
						[487689.50787484203, 634467.68885074148],
						[487689.46179205616, 634406.08093874669],
						[487661.14019028726, 634406.10214765056],
						[487661.11722027435, 634375.46410793834],
						[487632.79556582245, 634375.48536561988],
						[487632.772626205, 634344.95793671906],
						[487575.40829616168, 634345.0011426023],
						[487575.38483264425, 634313.92068488162],
						[487518.02039442095, 634313.96409078757],
						[487517.99724200444, 634283.43667036435],
						[487460.63269753475, 634283.4802762958],
						[487460.56325816881, 634192.34046616009],
						[487489.708298882, 634191.21222036111],
						[487489.66163716419, 634129.82559729984],
						[487517.88072499237, 634129.8041714154],
						[487517.81084837537, 634037.66896467935],
						[487546.13308415934, 634037.64750912203],
						[487546.0866333656, 633976.26092752512],
						[487575.12990715203, 633976.23897636356],
						[487575.06026822084, 633883.99322542711],
						[487546.0168316529, 633884.01517671323],
						[487545.99373181065, 633853.48781420826],
						[487460.30513613194, 633853.55287707085],
						[487460.28128745989, 633822.25127425464],
						[487402.91513552528, 633822.29508135607],
						[487402.93909329909, 633853.59668408998],
						[487374.71953188977, 633853.61830705707],
						[487374.74294941174, 633884.14566931862],
						[487345.59652220237, 633884.1680532773],
						[487345.62007883057, 633914.80602601892],
						[487317.40062237025, 633914.82774726383],
						[487317.42431676737, 633945.5763305251],
						[487117.00475698523, 633945.73199073831],
						[487116.98068815464, 633914.98340776877],
						[487031.39540336264, 633915.05062306661],
						[487031.37126179092, 633884.41265078099],
						[487003.04876231251, 633884.43499216228],
						[487003.02465536859, 633853.90763043601],
						[486973.98116570961, 633853.93059116602],
						[486973.95639212272, 633822.62898906926],
						[486945.63378632284, 633822.65142925235],
						[486945.6097484412, 633792.34528862499],
						[486916.56615014625, 633792.36835067207],
						[486916.54161916266, 633761.50918247958],
						[486830.85254461848, 633761.57752249099],
						[486830.82794147381, 633730.82896494283],
						[486802.60816957161, 633730.85156884207],
						[486802.58342501905, 633699.99240920937],
						[486773.43667169329, 633700.01580641302],
						[486773.41213915433, 633669.48846986459],
						[486745.1922620784, 633669.51117220894],
						[486745.16740997432, 633638.65202100843],
						[486716.02054802037, 633638.67551988608],
						[486715.97082379495, 633577.06783638592],
						[486687.75078825298, 633577.09063722345],
						[486687.72627590585, 633546.7845297897],
						[486659.40319542261, 633546.80746253207],
						[486659.35325957061, 633485.19980413606],
						[486630.30911927012, 633485.22337132425],
						[486630.28405206726, 633454.36424534395],
						[486601.9608125455, 633454.38727693073],
						[486601.88599186926, 633362.47356106271],
						[486572.84163499851, 633362.49722966144],
						[486572.81646024983, 633331.63812043518],
						[486487.12514765374, 633331.70825000387],
						[486487.10008466733, 633301.18096340308],
						[486458.87939410051, 633300.98294444755],
						[486458.75299854297, 633147.35111900128],
						[486429.60526654165, 633147.37512509897],
						[486429.58009717544, 633116.8478633191],
						[486373.03545224428, 633116.89458073722],
						[486372.93380587228, 632994.12193916377],
						[486343.88861545827, 632993.92479988001],
						[486343.86319559364, 632963.28695286578],
						[486315.53911100037, 632963.31047734607],
						[486315.51354645879, 632932.56202857289],
						[486258.14429352008, 632932.6098257734],
						[486258.09304244665, 632871.2235467399],
						[486229.76879942376, 632871.24721881701],
						[486229.79433897784, 632901.77444735798],
						[486200.74916913704, 632901.79877256928],
						[486200.7750407483, 632932.65782292571],
						[486086.03653571103, 632932.75441711722],
						[486085.9846427521, 632871.36813862482],
						[485972.06968843524, 632871.46483074594],
						[485972.2266419059, 633055.62371474027],
						[485999.72659889271, 633055.6003003181],
						[486000.60296801501, 633117.20713931997],
						[485800.17332099291, 633117.37883498392],
						[485800.19965773285, 633147.90609578101],
						[485743.65511950268, 633147.9549753865],
						[485743.62867788959, 633117.42771468568],
						[485628.89146089397, 633117.5274956394],
						[485628.86451675603, 633086.66842123261],
						[485600.54064448323, 633086.69317611691],
						[485600.51374400809, 633055.94471191533],
						[485571.46884622501, 633055.97014758736],
						[485571.44198845251, 633025.3322935485],
						[485543.11801063095, 633025.35714724893],
						[485543.09100298933, 632994.60869142576],
						[485485.7219663189, 632994.65918090008],
						[485485.74908113421, 633025.40763662697],
						[485285.4213125555, 633025.58550977195],
						[485285.39402126335, 632995.05826626997],
						[485257.06979320053, 632994.86240031896],
						[485257.01480834151, 632933.47610798723],
						[484999.31667176029, 632933.70894992258],
						[484999.28854758665, 632902.84990153764],
						[484970.96435898851, 632902.87573982694],
						[484970.93759562436, 632873.56517807732],
						[484913.56702188618, 632872.40099704196],
						[484913.53873705334, 632841.54195711459],
						[484884.49346092524, 632841.56860505999],
						[484884.46522321517, 632810.82017521339],
						[484856.14087625325, 632810.84621109231],
						[484856.11268739443, 632780.20839127817],
						[484827.06730303541, 632780.23514056334],
						[484827.03926403768, 632749.81853655982],
						[484798.71450564673, 632749.51285378728],
						[484798.60142527684, 632627.07223833469],
						[484811.99106194219, 632626.83866604918],
						[484826.92557869205, 632626.49307460734],
						[484826.89753971319, 632596.07649109385],
						[484913.31367507513, 632595.99705694767],
						[484913.285086138, 632564.80623718211],
						[484941.60985649982, 632564.7802996377],
						[484941.58202956372, 632534.3637241344],
						[484970.62784779991, 632534.33717693121],
						[484970.51534088328, 632411.12243591901],
						[484855.77320025227, 632411.22760626127],
						[484855.71712793974, 632350.28389484691],
						[484826.67098490999, 632350.31064482324],
						[484826.64253812889, 632319.451675597],
						[484798.31734559004, 632319.47781098308],
						[484798.26044798095, 632257.87049069512],
						[484770.03815055755, 632257.89657962322],
						[484770.06670334504, 632288.75554044277],
						[484683.54595402983, 632288.83582250029],
						[484683.57456611132, 632319.58418171667],
						[484597.9809851324, 632319.66405097139],
						[484598.00986060558, 632350.52301980392],
						[484512.31344000663, 632350.6034309112],
						[484512.34205986053, 632381.01998117438],
						[484312.00644845789, 632381.20970178978],
						[484311.97745840152, 632350.79315187212],
						[484254.60617772269, 632350.84793239727],
						[484254.57665844087, 632319.98896417662],
						[484226.25146683271, 632320.01608400152],
						[484226.19242806529, 632258.40876572742],
						[484197.14612291026, 632258.43662660057],
						[484197.11660227075, 632227.68827651883],
						[484226.16296168591, 632227.66041559749],
						[484226.04530819203, 632104.88826738787],
						[484196.99873212812, 632104.91612851876],
						[484196.9691053179, 632074.05719355959],
						[484111.27124534873, 632074.13969262969],
						[484111.33050000132, 632135.52574982471],
						[484083.82900576998, 632135.55231935345],
						[484083.03483154427, 632166.41205917904],
						[484053.98836404737, 632166.44017267367],
						[484054.04783268494, 632227.82625438937],
						[484025.82548375305, 632227.85361932975],
						[484025.85532437329, 632258.60196910275],
						[483968.48372235999, 632258.65774690348],
						[483968.54372568638, 632320.26506423997],
						[483940.21853454981, 632320.29267628433],
						[483940.24864318885, 632351.1516439385],
						[483968.57378121791, 632351.12403194804],
						[483968.60340585012, 632381.54058124823],
						[484054.19666507276, 632381.45743917837],
						[484054.2262386895, 632411.98459833546],
						[484083.2722728888, 632411.95648525993],
						[484083.30222046049, 632442.9260712316],
						[484140.67318020732, 632442.87069363217],
						[484140.70291326987, 632473.72967821884],
						[484169.02784036176, 632473.70241117675],
						[484169.05730756663, 632504.34018857195],
						[484197.38218198239, 632504.31297032756],
						[484197.5001585203, 632627.19593849196],
						[484169.17549556872, 632627.22315653809],
						[484169.23464278417, 632688.71996820695],
						[484197.55919990776, 632688.69275026559],
						[484197.63310785237, 632765.67439410603],
						[484198.48650563508, 632903.59921210806],
						[484427.24294372206, 632903.38118947507],
						[484427.38829928002, 633057.01283236081],
						[484454.88825394807, 633056.98683684447],
						[484455.69624009053, 633149.12094913458],
						[484427.4754707996, 633149.14762541314],
						[484427.53355028178, 633210.53397281072],
						[484370.1652662268, 633210.58835055726],
						[484370.1945705078, 633241.44743945776],
						[484198.09004215902, 633241.61177212524],
						[484198.06041520264, 633210.75268353627],
						[484169.73675646342, 633210.77990061371],
						[484169.67771549249, 633149.39355413383],
						[484141.35395116231, 633149.42082005413],
						[484141.38368431956, 633180.27990022232],
						[484112.33900594572, 633180.30791075132],
						[484112.39826088538, 633241.69426534628],
						[483998.48586961697, 633241.80461652868],
						[483998.51576328592, 633272.55310286873],
						[483969.47124773968, 633272.58136550942],
						[483969.5010879467, 633303.21924986411],
						[483943.54667864053, 633303.46576133533],
						[483941.23769794457, 633364.85445959901],
						[483912.19334528467, 633364.88282331615],
						[483912.25334741164, 633426.26922694664],
						[483826.56252752873, 633426.35320832848],
						[483826.59252536559, 633456.88050696161],
						[483769.22509995359, 633456.93697928451],
						[483769.25553141971, 633487.79610044113],
						[483740.93234942807, 633487.8240554285],
						[483740.96272473724, 633518.57257453166],
						[483683.69850755017, 633518.62924322067],
						[483683.72909949085, 633549.48837258003],
						[483655.4060236676, 633549.51647475059],
						[483655.49729979719, 633641.43025033805],
						[483683.82021745213, 633641.40214833186],
						[483683.94214671955, 633764.39633246011],
						[483655.61944072024, 633764.42443425674],
						[483655.68018168653, 633825.589732197],
						[483626.63664205896, 633825.61859982309],
						[483626.69815118582, 633887.44755237561],
						[483655.74158170295, 633887.41868485429],
						[483655.77200712328, 633918.05665154848],
						[483684.09444874758, 633918.0285500125],
						[483684.1857861529, 634010.16368794523],
						[483713.22900012403, 634010.13492187415],
						[483713.32050334191, 634102.60191686661],
						[483827.22693708912, 634102.48959204811],
						[483827.34758095077, 634225.26281445159],
						[483856.3904153441, 634225.23430101061],
						[483856.63148694049, 634471.00215944729],
						[483827.58908624173, 634471.03067246627],
						[483827.61908421683, 634501.55811183015],
						[483799.29764675925, 634501.58596637845],
						[483799.35829218075, 634563.19389088987],
						[483774.22954723262, 634563.21864618489],
						[483770.34648578177, 634594.08177683153],
						[483713.80691581586, 634594.13762986811],
						[483713.83712508722, 634624.6650856518],
						[483656.47376998671, 634624.72195097583],
						[483656.5041955036, 634655.36001752282],
						[483627.46212013118, 634655.38888369023],
						[483627.49270975095, 634686.1375611081],
						[483601.54026540124, 634686.16339971742],
						[483599.20212224091, 634716.80383481923],
						[483541.8390882946, 634716.8610997072],
						[483541.86994862265, 634747.72039211448],
						[483513.54893477069, 634747.74873839493],
						[483513.57973740512, 634778.49742816796],
						[483484.53787933144, 634778.52654654905],
						[483484.56873623206, 634809.27524046029],
						[483456.24782830669, 634809.30368534441],
						[483456.7725174987, 635331.2578734362],
						[483485.09252722032, 635331.22942945291],
						[483485.12393917912, 635362.53123429138],
						[483456.80398332316, 635362.5596782238],
						[483456.92740055511, 635485.33358360454],
						[483485.24714513851, 635485.30513988738],
						[483485.30874814145, 635546.6921178418],
						[483514.34925067209, 635546.66300081473],
						[483514.38005341584, 635577.41179973667],
						[483485.33960514609, 635577.44091670716],
						[483485.40120817698, 635638.8279198535],
						[483428.04138794547, 635638.88558138232],
						[483428.01064651593, 635608.35798863787],
						[483399.69111368916, 635608.38653085101],
						[483399.87688165903, 635792.5476150132],
						[483457.23616630444, 635792.48985531414],
						[483457.26707625954, 635823.23868780921],
						[483485.58623935573, 635823.21024467272],
						[483485.61698540585, 635853.84847410326],
						[483514.65694591531, 635853.81935762276],
						[483514.71866229136, 635915.42765124631],
						[483543.03766674816, 635915.39930697682],
						[483543.09905590588, 635976.78640285227],
						[483572.13879947265, 635976.75738780794],
						[483572.26136118226, 636099.53163024574],
						[483600.58004882012, 636099.50338499644],
						[483600.73304207082, 636253.02658676403],
						[483617.20943596901, 636253.23139080894],
						[483629.05168564036, 636253.21960557345],
						[483629.17382495059, 636375.99400014838],
						[483658.21286405373, 636375.96513700043],
						[483658.33478677698, 636498.73959922313],
						[483686.65278744244, 636498.7115020944],
						[483686.71386248758, 636560.31997398729],
						[483772.28539168782, 636560.23536600848],
						[483772.31560542108, 636590.87369693164],
						[483829.672107502, 636590.81723536074],
						[483829.70232313877, 636621.56617831625],
						[483887.05871823808, 636621.50991676515],
						[483887.02860977547, 636590.76097370777],
						[483972.7029546501, 636590.67730708886],
						[483972.73290302046, 636621.42625030479],
						[483999.40311207704, 636621.40029613674],
						[484001.80172573344, 636652.47876411316],
						[484087.37277569674, 636652.39579461946],
						[484087.34272060683, 636621.31502376171],
						[484144.69911657739, 636621.25966021686],
						[484144.63996907644, 636559.87238508917],
						[484230.31447476428, 636559.79005968582],
						[484230.2554348908, 636498.18158581015],
						[484287.61226004461, 636498.12672038761],
						[484287.55364614597, 636436.73947855819],
						[484315.87175349938, 636436.71246421989],
						[484315.84265750408, 636406.184760998],
						[484344.8816433326, 636406.15710957686],
						[484344.82303296932, 636344.54867762444],
						[484373.1412989716, 636344.52176183579],
						[484373.1124144271, 636314.10467866494],
						[484430.4696718831, 636313.82909604395],
						[484430.41159159946, 636252.44190427836],
						[484487.6660886592, 636252.16661849653],
						[484487.57944503182, 636160.25177347369],
						[484544.21661137434, 636160.19848195335],
						[484544.18762785423, 636129.33899361361],
						[484601.54573860404, 636129.28522240464],
						[484601.60318003286, 636190.67238101631],
						[484658.96107700747, 636190.61880992923],
						[484658.98984541534, 636221.47830693633],
						[484687.20534691773, 636221.45202760468],
						[484687.23375364835, 636251.97970630019],
						[484716.37619313836, 636252.17382969847],
						[484716.46166207764, 636344.19932136335],
						[484744.67695316632, 636344.17314057285],
						[484744.70545858302, 636374.92205132893],
						[484773.8474748967, 636374.89506142051],
						[484773.87602820399, 636405.75458407274],
						[484802.09121375054, 636405.72850172163],
						[484802.20460246707, 636528.50298909086],
						[484830.52255191392, 636528.47686038376],
						[484830.5791406561, 636589.86412946985],
						[484802.26150115393, 636590.111473492],
						[484802.31839985517, 636651.71997489629],
						[484774.10363608843, 636651.74605685368],
						[484774.24548177532, 636805.04843375832],
						[484745.10422722012, 636805.07542295591],
						[484745.13283523457, 636835.93500502466],
						[484774.27403513767, 636835.90801587538],
						[484774.35918354482, 636927.93374848913],
						[484745.21824914985, 636928.07134535967],
						[484745.41778767278, 637143.31437295908],
						[484688.06321131985, 637143.36764270056],
						[484688.12012794171, 637204.53386457823],
						[484631.58952601562, 637204.58656464401],
						[484631.61834765901, 637235.44620185788],
						[484602.58082524, 637235.47334728553],
						[484602.69570868451, 637358.24829023052],
						[484631.73301445111, 637358.22114500415],
						[484631.79055447306, 637419.82985824253],
						[484660.10697007959, 637419.80343627941],
						[484660.16419787478, 637481.19095040171],
						[484688.3775394875, 637481.16467308102],
						[484688.40594638127, 637511.69252430461],
						[484717.54594957939, 637511.66543469345],
						[484717.60316888586, 637573.27419080411],
						[484745.81635261478, 637573.24801197089],
						[484745.84475564951, 637603.8864841715],
						[484888.86679731967, 637603.75451909448],
						[484888.89503563126, 637634.50360399298],
						[484946.24790013296, 637634.45103425451],
						[484946.27613246487, 637665.31073175464],
						[484975.31289636897, 637665.28419283056],
						[484975.34077126189, 637695.81206990033],
						[485031.86968560849, 637695.76055076416],
						[485031.89775747631, 637726.62025695143],
						[485089.25030090072, 637726.56818564679],
						[485089.27796451974, 637757.09607135551],
						[485118.41753313126, 637757.06969165546],
						[485118.39022368175, 637726.87363071926],
						[485346.97636452114, 637726.3366594885],
						[485347.00354998535, 637756.86454562505],
						[485518.23713113647, 637756.71295126795],
						[485518.26429095736, 637787.57266681083],
						[485575.61662192922, 637787.5222907369],
						[485575.6435772336, 637818.27140235109],
						[485604.68007121573, 637818.24597403791],
						[485604.70706902596, 637849.10569829633],
						[485633.02274591004, 637849.0809505753],
						[485633.04940089403, 637879.60885412013],
						[485661.36502528546, 637879.58415517397],
						[485661.39191689464, 637910.44388807425],
						[485718.64085388469, 637910.39410023158],
						[485718.66735012556, 637940.92201237287],
						[485747.80659319577, 637940.89674726035],
						[485747.83332279418, 637971.75648885337],
						[485776.04582328507, 637971.73207643349],
						[485776.07221312955, 638002.25999712315],
						[485833.42379580997, 638002.21051963605],
						[485833.45036494103, 638033.07026992191],
						[485861.765725251, 638033.04591583088],
						[485861.87159931735, 638156.2637431717],
						[485833.55645104521, 638156.28809707868],
						[485833.82071426202, 638463.22687877982],
						[485719.1207628182, 638463.32603087334],
						[485719.14745112997, 638494.07523663295],
						[485605.27141122468, 638494.17446747748],
						[485605.2986026518, 638525.25550336298],
						[485576.26335629099, 638525.28093058569],
						[485576.31697619794, 638586.4475370181],
						[485605.35211461451, 638586.42210989166],
						[485605.37862868689, 638616.7288977023],
						[485633.69298460823, 638616.70415113983],
						[485633.74697079352, 638678.53443562589],
						[485548.08349600766, 638678.60945424309],
						[485548.11040718062, 638709.24808092334],
						[485433.41217075975, 638709.34922469582],
						[485433.43939344148, 638740.09846422693],
						[485318.74137208133, 638740.20040737372],
						[485318.68659670622, 638678.81254173443],
						[485290.47530856926, 638678.83773833257],
						[485290.42003242281, 638617.00745498505],
						[485175.72115299635, 638617.11039512127],
						[485175.69384752028, 638586.80360800738],
						[485147.37944014271, 638586.82914272195],
						[485147.35158329346, 638555.96931637614],
						[485119.14008453098, 638555.99480673997],
						[485119.11267494672, 638525.68802812067],
						[484832.36388629401, 638525.94986312056],
						[484832.39182404953, 638556.25664125558],
						[484804.07736410713, 638556.28276674217],
						[484804.16276399867, 638648.75164823001],
						[484775.95142431773, 638648.77772702358],
						[484776.03647107841, 638740.69360322086],
						[484746.89864437835, 638740.72058924311],
						[484746.92725264124, 638771.58044069028],
						[484718.71612356399, 638771.6066176201],
						[484718.88716614741, 638955.77033674147],
						[484747.09797945927, 638955.74416010617],
						[484747.12648521014, 638986.49343275162],
						[484773.89582011878, 638986.46863838274],
						[484776.29243031621, 639017.32633303839],
						[484804.503138086, 639017.30025483121],
						[484804.53133236343, 639047.8283183137],
						[484890.19288488047, 639047.74942850135],
						[484890.22122495371, 639078.60932320869],
						[484919.25549487869, 639078.58268536103],
						[484919.28367912088, 639109.33197548555],
						[484976.63140310545, 639109.27951165847],
						[484976.65917718137, 639139.69697922829],
						[485004.14896898007, 639139.6719014179],
						[485005.02898388944, 639201.50157968944],
						[485033.2393758712, 639201.47589367046],
						[485033.29501690785, 639262.64268584433],
						[485062.43191933096, 639262.61620700243],
						[485062.51577074785, 639354.97477730224],
						[485176.38585312123, 639354.87179005658],
						[485176.4132583465, 639385.28929195309],
						[485291.10678279918, 639385.18635662366],
						[485291.13456929452, 639416.26751765003],
						[485376.69124729064, 639416.1912527642],
						[485376.71857724048, 639446.94059092156],
						[485405.03150449408, 639446.91545086505],
						[485405.88233066787, 639477.55345359677],
						[485491.43868996878, 639477.4777854085],
						[485491.46561049524, 639508.00591400918],
						[485662.78392420925, 639507.85573317192],
						[485662.75732156803, 639477.32760429638],
						[485749.13732931658, 639477.25255844789],
						[485749.11079114687, 639446.61382453633],
						[485801.72135887179, 639446.56833936612],
						[485805.55410573591, 639354.31695996725],
						[485834.58788913034, 639354.29193736718],
						[485834.56141506921, 639323.54261136672],
						[485862.87455467391, 639323.51825918758],
						[485862.7952912614, 639231.27030686813],
						[486034.83718866651, 639231.12338085414],
						[486034.86319438682, 639261.76208522031],
						[486063.17644030618, 639261.73807772901],
						[486063.22862738644, 639323.34732659999],
						[486120.47264854435, 639323.29893684306],
						[486120.52424805542, 639384.46576671139],
						[486148.83728281892, 639384.44190663542],
						[486148.91512949008, 639476.91114301933],
						[486206.26157227164, 639476.8629650682],
						[486206.31303882762, 639538.25105635542],
						[486235.34677525889, 639538.55856852105],
						[486235.37222303293, 639568.97609767993],
						[486291.9976575732, 639568.92882151355],
						[486292.04862023104, 639630.09572036075],
						[486321.08191697008, 639630.07155624568],
						[486321.10785012308, 639661.2633629879],
						[486347.77313243155, 639661.24121488538],
						[486349.47124981292, 639722.51738212747],
						[486378.50438346382, 639722.49331934936],
						[486378.52965845168, 639753.02148353436],
						[486406.84205898782, 639752.99806744675],
						[486406.89296083496, 639814.60745530366],
						[486435.10230159061, 639814.58417290251],
						[486435.15273303317, 639875.75114071742],
						[486492.49814889842, 639876.14639789157],
						[486492.57370331819, 639968.1734055886],
						[486521.60640347423, 639968.14959533582],
						[486521.65687627491, 640029.75904405664],
						[486549.9688005902, 640029.73587426287],
						[486550.11935846793, 640213.90066752129],
						[486578.43096590217, 640213.87754670926],
						[486578.45605119178, 640244.6269988023],
						[486607.48826350085, 640244.60334010026],
						[486607.51338457409, 640275.46340612613],
						[486693.16854556854, 640275.3939032451],
						[486693.19323758199, 640305.92214501696],
						[486750.5367908444, 640305.87586414325],
						[486750.56164369499, 640336.73593904614],
						[486836.11353514937, 640336.66726330318],
						[486836.0888427805, 640305.80718826724],
						[487179.32656131388, 640305.53613123903],
						[487179.35060985235, 640336.39620678197],
						[487236.69405689585, 640336.35162041115],
						[487236.71791206772, 640367.1010907793],
						[487294.06125208765, 640367.0567043575],
						[487294.08491465863, 640397.69556950557],
						[487350.60454684199, 640397.65201625507],
						[487350.62818920397, 640428.40149542643],
						[487379.76302716951, 640428.37912036735],
						[487379.78669993015, 640459.23921356793],
						[487493.64913970447, 640459.15226398222],
						[487494.49594323221, 640489.67990662064],
						[487665.70108539402, 640489.55065985909],
						[487665.72422189056, 640520.41076213762],
						[487694.03530186589, 640520.38956110808],
						[487694.08122044685, 640581.77794966206],
						[487723.11283780297, 640581.75625964487],
						[487723.13578420418, 640612.50576530269],
						[487751.34375689056, 640612.48473971861],
						[487751.36656822357, 640643.12363998918],
						[487780.50102593639, 640643.10197460023],
						[487780.52386516926, 640673.85148899048],
						[487808.73173267412, 640673.83056180039],
						[487808.75460115052, 640704.69069034723],
						[487837.06536400534, 640704.66973545286],
						[487837.08793405438, 640735.19803899224],
						[487923.46133776533, 640735.13440868922],
						[487923.43892799446, 640704.60610503377],
						[487980.06045403174, 640704.56463867251],
						[487980.03790688846, 640673.70450988773],
						[488009.06936202192, 640673.68332448485],
						[488009.04694996192, 640642.93380978587],
						[488066.38932855858, 640642.89211531798],
						[488066.3002695209, 640520.11531890964],
						[488094.61135000404, 640520.09480721038],
						[488094.56692614272, 640458.70643482124],
						[488123.59876067395, 640458.68545152585],
						[488123.57648313901, 640427.82535728288],
						[488209.12790090829, 640427.76382133842],
						[488209.01787057164, 640274.23768192064],
						[488264.81727042882, 640274.19778588985],
						[488266.40531656088, 640335.5850055042],
						[488323.02811265452, 640335.54471953411],
						[488323.04993742477, 640366.29419141484],
						[488409.42527792579, 640366.23311248783],
						[488409.4468633316, 640396.87197917106],
						[488380.41491972335, 640396.89245804492],
						[488380.47999440134, 640489.03030312201],
						[488409.51177541976, 640489.00982436142],
						[488409.66341889394, 640704.25637049193],
						[488352.32125417632, 640704.29686848016],
						[488352.34286809497, 640734.82517271338],
						[488323.31152085762, 640734.84575236053],
						[488323.3550919682, 640796.23420306994],
						[488295.04448667855, 640796.25432113931],
						[488295.06644310697, 640827.11446771759],
						[488266.755890959, 640827.13463446265],
						[488266.79967337102, 640888.52311100136],
						[488237.76859735185, 640888.54384159599],
						[488237.81264627154, 640950.1535551775],
						[488209.50230585778, 640950.17382044974],
						[488209.6564915143, 641165.31020984915],
						[488237.96646171104, 641165.28994484316],
						[488238.07614921732, 641318.70610171475],
						[488267.10646614875, 641318.6853716583],
						[488267.12839684566, 641349.43498213135],
						[488323.74770357617, 641349.39469864254],
						[488323.76960695197, 641380.25492367428],
						[488438.44922442758, 641380.17392851075],
						[488438.47060173628, 641410.59171747428],
						[488524.01690902578, 641410.53181898955],
						[488524.03866828897, 641441.72388347727],
						[488581.37826269912, 641441.68398400221],
						[488581.39945259492, 641472.21239195438],
						[488638.73894074094, 641472.17269241426],
						[488638.76010062231, 641502.81171493093],
						[488667.06949003233, 641502.79218834755],
						[488667.09067338798, 641533.54182543431],
						[488696.12061120867, 641533.5218524409],
						[488696.14181631274, 641564.38210414874],
						[488753.48098320322, 641564.34280454076],
						[488753.50185388664, 641594.87122997211],
						[488857.98865206359, 641594.80012983526],
						[488867.35643399414, 641594.79378775693],
						[488867.377317951, 641625.65404840687],
						[488896.51003569417, 641625.63435936766],
						[488896.53071569331, 641656.27340388694],
						[488924.73689874547, 641656.25439019408],
						[488924.77830262296, 641717.75371290196],
						[488982.11693493417, 641717.71521020401],
						[488982.13745561754, 641748.35426784318],
						[489010.44642248435, 641748.33533215919],
						[489010.46703823237, 641779.19561484014],
						[489039.4965425579, 641779.17624778929],
						[489039.51717754354, 641810.14714525267],
						[489067.82603807672, 641810.12830831402],
						[489067.9074827921, 641932.68461752834],
						[489039.598833161, 641932.70345433103],
						[489039.63973468402, 641994.09224530414],
						[489067.94827867305, 641994.07340857503],
						[489067.96878687688, 642024.93372632167],
						[489094.63023832015, 642024.91603012546],
						[489096.19457317353, 642055.44349730702],
						[489067.98907456815, 642055.4622170215],
						[489068.09132162132, 642209.32145123906],
						[489096.29655642115, 642209.30273170024],
						[489096.33724709874, 642270.69160126266],
						[489125.46882253751, 642270.67231768742],
						[489125.50940451131, 642332.06120474031],
						[489096.37793778925, 642332.08048824198],
						[489096.418775119, 642393.69061396364],
						[489068.21385647019, 642393.70933329],
						[489068.25465243933, 642455.09825513128],
						[489125.59071473719, 642455.06025251281],
						[489125.67187876673, 642577.83814880531],
						[489268.54775094078, 642577.74431947526],
						[489268.56781143538, 642608.49411000777],
						[489296.87529813324, 642608.47566723148],
						[489297.01549521106, 642823.94554564694],
						[489326.04315591429, 642823.9266842471],
						[489326.06282215659, 642854.234066376],
						[489354.36988597328, 642854.21572254039],
						[489354.35027188674, 642823.9083403775],
						[489383.37793265679, 642823.88958015316],
						[489383.33802617883, 642762.0581092455],
						[489554.51952088048, 642761.94851847691],
						[489554.55878391588, 642823.77998980088],
						[489640.20067745255, 642823.72583022201],
						[489640.1809630752, 642792.42295422882],
						[489668.48813325632, 642792.40515093727],
						[489669.0930170347, 642608.23769289383],
						[489897.61164133676, 642608.09576408588],
						[489897.63059388218, 642638.95617053111],
						[489925.93802815722, 642638.9388102704],
						[489926.0132194999, 642761.71681522753],
						[489955.04099001811, 642761.69906379271],
						[489955.05963237764, 642792.22765968158],
						[489983.36680289835, 642792.21039825107],
						[489983.38586420327, 642823.51327464648],
						[490012.41352567478, 642823.49562445795],
						[490012.43192731263, 642853.80300737708],
						[490069.04605645704, 642853.76873067976],
						[490069.12031426176, 642976.76808055397],
						[490155.48194936081, 642976.71616872528],
						[490155.46367874288, 642946.18754646333],
						[490383.97760821908, 642946.05237425584],
						[490383.95930907846, 642914.74947957695],
						[490441.29376925173, 642914.7160628459],
						[490441.25822476856, 642853.5482286436],
						[490497.76942000352, 642853.51548729581],
						[490497.78724691115, 642884.37592957448],
						[490526.8148009805, 642884.35918711883],
						[490526.7970285308, 642853.49874481466],
						[490555.10409360979, 642853.48246725369],
						[490555.05118962791, 642761.34361014399],
						[490612.38618449488, 642761.31078975915],
						[490612.35127657698, 642700.14299866697],
						[490812.66423061735, 642700.0299018498],
						[490812.73292740184, 642823.029167498],
						[490927.29955226521, 642822.96557963092],
						[490927.31626827689, 642853.27296353586],
						[490955.62333374255, 642853.2573752061],
						[490955.64030168403, 642884.11781796347],
						[491070.30943566747, 642884.05516953021],
						[491070.34288125561, 642945.66545759141],
						[491126.85376002383, 642945.6348774255],
						[491126.87022783025, 642976.16350070992],
						[491156.00055393548, 642976.14781302307],
						[491156.01702714822, 643006.78705164243],
						[491213.35116651992, 643006.75632592198],
						[491213.36759202904, 643037.50617994694],
						[491298.90543918038, 643037.46071115125],
						[491298.88917357719, 643006.7108570413],
						[491327.19597499771, 643006.69590813387],
						[491327.1637245827, 642945.52804586187],
						[491527.37075621897, 642945.42370655516],
						[491527.35463293438, 642914.12081068102],
						[491556.48506891355, 642914.10583221971],
						[491556.46951205656, 642883.79843910364],
						[491642.00815849594, 642883.75475447217],
						[491641.99247823062, 642852.89431103226],
						[491670.29954434937, 642852.87995255413],
						[491670.26834605273, 642791.26968974434],
						[491927.81214606029, 642791.14129093662],
						[491927.82750716101, 642822.44416936848],
						[491956.13462567813, 642822.43030276988],
						[491956.11931844754, 642791.12742430973],
						[492013.45420949714, 642791.09948734241],
						[492013.43938729557, 642760.57088935759],
						[492042.46715983265, 642760.55682150135],
						[492042.45233799855, 642729.9176169706],
						[492070.75961573829, 642729.90394762461],
						[492070.74500658689, 642699.59657988185],
						[492099.0522302466, 642699.36173757748],
						[492099.03740761091, 642668.50132006302],
						[492156.26957916393, 642668.03148709005],
						[492156.25512761506, 642637.72412796062],
						[492185.38605306653, 642637.71026322013],
						[492185.35678439878, 642576.10006082954],
						[492213.5613903164, 642576.08668612468],
						[492213.5178290336, 642484.05855292082],
						[492241.82552986045, 642484.04517794691],
						[492241.72406518291, 642268.90744715917],
						[492213.41599413939, 642268.92082230304],
						[492213.40138646495, 642238.0604661596],
						[492241.70951061841, 642238.04709099291],
						[492241.68055799202, 642176.65822352935],
						[492270.70936093619, 642176.64455844334],
						[492270.69501674647, 642146.11604702973],
						[492328.03215598204, 642146.08920651954],
						[492328.01776344463, 642115.22886778705],
						[492356.32609897241, 642115.21568985609],
						[492356.29747151252, 642053.60563602799],
						[492382.23829797178, 642053.59360297769],
						[492384.59178038361, 642023.06401259196],
						[492413.62085436517, 642023.05059969134],
						[492413.59254367941, 641961.66179287061],
						[492441.90114347264, 641961.64876220212],
						[492441.88696472679, 641930.78844964446],
						[492518.78356016724, 641930.75329942745],
						[492527.43056689133, 641930.74936927739],
						[492527.41659886582, 641899.99967145699],
						[492499.21083373291, 641900.01250803121],
						[492499.16897323838, 641808.20588228805],
						[492556.40434893436, 641808.17988470395],
						[492556.39033508045, 641777.20898353576],
						[492584.69925228739, 641777.19619860011],
						[492584.67153061531, 641715.69685077132],
						[492613.70114698849, 641715.68379093683],
						[492613.68743974745, 641685.15534415434],
						[492641.99651536456, 641685.14265781397],
						[492641.98266276246, 641654.17177413334],
						[492671.01238770981, 641654.15881544049],
						[492670.98498893279, 641592.65950232337],
						[492813.97236050223, 641592.59642119205],
						[492813.98584093672, 641623.45668596611],
						[492842.29502272623, 641623.44434431347],
						[492842.30835380242, 641654.08339291438],
						[492927.85339485388, 641654.04639477422],
						[492927.86670926143, 641685.01727869001],
						[493013.51453154755, 641684.98068174545],
						[493013.50137838512, 641654.00979775889],
						[493042.53110361641, 641653.99749466451],
						[493042.51814545208, 641623.35844590515],
						[493128.16628875129, 641623.3224458734],
						[493128.17908739811, 641653.96149470075],
						[493099.86995812214, 641653.97334439168],
						[493099.8829486802, 641684.94422844623],
						[493070.85327805905, 641684.9564303339],
						[493070.87904236052, 641746.12393928471],
						[493042.57007168094, 641746.13588757929],
						[493042.60908654623, 641838.38493001659],
						[493070.91789847531, 641838.37298178999],
						[493070.94375597103, 641899.76175484492],
						[493099.97304753965, 641899.74955311872],
						[493099.98594531883, 641930.49925140361],
						[493128.29459873837, 641930.48740191385],
						[493128.32024227449, 641991.87620116048],
						[493156.52584989654, 641991.86444325256],
						[493156.53868806385, 642022.72476513754],
						[493184.02366292366, 642022.71335415798],
						[493185.68334867788, 642053.24116663344],
						[493212.3447542371, 642053.23014412588],
						[493213.91426666983, 642114.83956231573],
						[493243.04611809796, 642114.82757059671],
						[493243.05879405543, 642145.68791008531],
						[493195.91263532446, 642145.707342954],
						[493185.72165341949, 642145.71156126726],
						[493185.73429948813, 642176.24007343152],
						[493213.93959100032, 642176.22841396579],
						[493213.96491533925, 642237.61728302971],
						[493243.09654934052, 642237.60529140139],
						[493243.12176497251, 642298.99417793029],
						[493271.32684601552, 642298.98261685856],
						[493271.35204688425, 642360.5927421638],
						[493300.48346310714, 642360.58085215837],
						[493300.50837468391, 642421.74855233147],
						[493328.71324525337, 642421.73708965105],
						[493328.72585046868, 642452.81869440223],
						[493357.03360505425, 642452.80723853665],
						[493357.04602278338, 642483.55701562925],
						[493386.07428415254, 642483.5453187722],
						[493386.11128560774, 642575.57345485094],
						[493414.41882894962, 642575.56209773908],
						[493414.45562777424, 642667.47966228693],
						[493443.48356458399, 642667.46806673578],
						[493443.49604131951, 642698.77092860336],
						[493470.97988665249, 642698.75999706879],
						[493471.82764773292, 642759.92746647005],
						[493500.0319384652, 642759.91629753553],
						[493500.0440017131, 642790.44489673839],
						[493529.17465670925, 642790.43341172673],
						[493529.18697047821, 642821.73629150691],
						[493555.02365066693, 642821.72614833969],
						[493557.41511224234, 642882.89305215795],
						[493586.54560352245, 642882.8816687467],
						[493586.55742005445, 642913.1890635509],
						[493614.76144799922, 642913.1780913308],
						[493614.78544944583, 642975.00961442664],
						[493643.09230541851, 642974.9986508257],
						[493643.10414607555, 643005.63789158361],
						[493843.3104459407, 643005.56173979223],
						[493843.34493198246, 643097.70071071014],
						[493872.47504285467, 643097.68983365234],
						[493872.48653875501, 643128.55031414097],
						[493929.8202537045, 643128.52905666898],
						[493929.83151958609, 643159.05770842242],
						[494101.00888268917, 643158.9954304269],
						[494100.99793449946, 643128.46677855449],
						[494129.30452639633, 643128.4566516513],
						[494129.29351231654, 643097.59617098991],
						[494158.32069011696, 643097.58583688084],
						[494158.30984834052, 643067.05719367566],
						[494186.51361246622, 643067.04720177595],
						[494186.49183814478, 643005.43687337777],
						[494329.46693001606, 643005.38696474757],
						[494329.47753035504, 643036.136821336],
						[494415.1183182263, 643036.10752164351],
						[494415.10787798307, 643005.3576649985],
						[494472.44202231319, 643005.33829883428],
						[494472.45235538174, 643036.08815551328],
						[494501.47964172182, 643036.07842695888],
						[494501.50016236375, 643097.46754248941],
						[494529.80680760497, 643097.45810478623],
						[494529.81707028038, 643128.31858570536],
						[494558.84419386968, 643128.30895837746],
						[494558.85429232306, 643158.83761054161],
						[494815.67187673872, 643158.97588629357],
						[494815.68160314095, 643189.83637621999],
						[494844.70861817105, 643189.82725334191],
						[494844.71818611753, 643220.35591441707],
						[494958.56151619897, 643220.3206290917],
						[494958.55215953686, 643189.79196794855],
						[495073.21916256641, 643189.75722379878],
						[495073.22830641456, 643220.28588500421],
						[495216.20153081394, 643220.24368374108],
						[495216.2104414787, 643250.8829604683],
						[495330.87701863941, 643250.85001245001],
						[495330.88574711635, 643281.59990473592],
						[495387.39547177742, 643281.58396140242],
						[495387.40412563615, 643312.4444692611],
						[495416.43092430226, 643312.43635527173],
						[495416.43943123659, 643342.9650340837],
						[495473.77239883173, 643342.94915805524],
						[495473.78089067061, 643373.80967476813],
						[495502.08706036635, 643373.80191021389],
						[495502.09546885389, 643404.55182017421],
						[495559.42822178919, 643404.53624270135],
						[495559.4365529599, 643435.39676829963],
						[495644.97233098326, 643435.37389944633],
						[495644.9804138171, 643465.90259583376],
						[495702.31295291602, 643465.88751639239],
						[495702.32095824723, 643496.52682839218],
						[495759.65339060378, 643496.51194880088],
						[495759.66131765331, 643527.26187645853],
						[495873.50252363726, 643527.23292338836],
						[495873.51026561856, 643558.09346677747],
						[495988.1747011994, 643558.06510078872],
						[495988.18214712065, 643588.59381479397],
						[496245.8163934063, 643588.53299618443],
						[496245.82343689952, 643619.39354856079],
						[496359.66400523169, 643619.36796018528],
						[496359.67081066209, 643650.11790572142],
						[496446.02891048265, 643650.09902022011],
						[496446.03548277734, 643680.51713617996],
						[496559.97855767456, 643680.49291193171],
						[496559.98503491993, 643711.46408902132],
						[496645.51937735896, 643711.44642310403],
						[496645.52567099198, 643742.30699332501],
						[496760.18882240186, 643742.28400905454],
						[496760.19483554683, 643772.81274959445],
						[496817.52630490263, 643772.80155722413],
						[496817.5322758478, 643803.662136339],
						[496931.37156885234, 643803.64050472155],
						[496931.37728494435, 643834.27986548236],
						[496986.34118122753, 643834.26970333187],
						[496988.7141695997, 643865.01924635551],
						[497074.35188146395, 643871.97231205297],
						[497075.0766092554, 643895.75364445127],
						[497131.68715228228, 643895.74367522541],
						[497131.69245668664, 643926.16182628798],
						[497218.04910722573, 643926.14699400717],
						[497218.05434547586, 643957.11820682255],
						[497271.47391314106, 643957.109258665],
						[497274.56686294771, 643987.96935254533],
						[497331.17708858976, 643987.96006990515],
						[497331.90255244024, 644018.59934025933],
						[497360.92810499016, 644018.59465763497],
						[497360.93300324643, 644049.12343774142],
						[497417.54301841685, 644049.11445234262],
						[497417.54791580478, 644080.30690608977],
						[497474.87831338594, 644080.2980049171],
						[497474.88298318646, 644110.71618229314],
						[497503.90837317938, 644110.71175197582],
						[497503.91305644362, 644141.57237998745],
						[497560.41982670967, 644141.56390195037],
						[497560.42432192573, 644171.87147645722],
						[497589.5525305323, 644171.86718201311],
						[497589.55710176035, 644203.05965369823],
						[497642.15245998156, 644203.05203008431],
						[497646.89583825215, 644264.33019268187],
						[497675.09754954145, 644264.32618227403],
						[497675.10186475673, 644294.8549975201],
						[497703.40644947166, 644294.8510210989],
						[497703.41075848526, 644325.71167572436],
						[497732.43576908449, 644325.70764868439],
						[497732.4400083939, 644356.45769608149],
						[497760.74448709848, 644356.45381833205],
						[497760.74868854985, 644387.31448185991],
						[497789.77359044418, 644387.31055599824],
						[497789.77772257151, 644418.06061227224],
						[497847.1069429089, 644418.05300850538],
						[497847.11098233826, 644448.91368094983],
						[497875.41530194395, 644448.91000053508],
						[497875.41924540012, 644479.43884218531],
						[497903.62058786588, 644479.43522360036],
						[497903.63234580238, 644571.68544554233],
						[497932.75984637422, 644571.68175888481],
						[497932.76368342829, 644602.21061808779],
						[497990.09226191271, 644602.20351269818],
						[497990.09603310522, 644633.06421177904],
						[498018.29711216362, 644633.06078981783],
						[498018.30081712268, 644663.81088151748],
						[498046.60476692143, 644663.80749569566],
						[498046.60840582149, 644694.44697996299],
						[498103.11327671789, 644694.44036631682],
						[498103.94020767469, 644725.19037194073],
						[498132.96451333532, 644725.18705169321],
						[498132.96801649046, 644756.04776858189],
						[498161.27180755947, 644756.04458008334],
						[498161.27522050886, 644786.57346570748],
						[498218.60315639537, 644786.56715679739],
						[498218.60649888113, 644817.42788258556],
						[498275.93432722427, 644817.4217735026],
						[498275.93752735649, 644847.95066793577],
						[498332.44187090168, 644847.94484213297],
						[498332.44499980059, 644878.80557683203],
						[498418.79664880148, 644878.79704866896],
						[498418.79960504221, 644909.54717587063],
						[498447.10313196556, 644909.54447924322],
						[498447.10602484946, 644940.1839988936],
						[498476.12995111692, 644940.18128421204],
						[498476.13280018413, 644970.93142027652],
						[498491.05642231414, 644970.93004436896],
						[498561.76351478446, 644970.9237094823],
						[498561.76621342212, 645001.78446202585],
						[498646.57339667768, 645001.77726479934],
						[498647.29635692295, 645032.3061264382],
						[498847.58091080934, 645032.29087374371],
						[498847.58307316812, 645063.15163521527],
						[498933.21330763173, 645063.14585832343],
						[498933.21530214726, 645093.896012204],
						[498952.0498016795, 645093.89480137802],
						[499105.09297554294, 645093.88576228695],
						[499105.09464269242, 645124.52530853706],
						[499190.72455762251, 645124.5208723339],
						[499190.72607069602, 645155.27103510848],
						[499248.05272148381, 645155.26831434283],
						[499248.05412231683, 645185.90786944143],
						[499304.55730482261, 645185.90538328281],
						[499304.55860507523, 645216.6555549344],
						[499333.68496346159, 645216.65434918692],
						[499333.68621373852, 645247.51513743086],
						[499361.88623068423, 645247.29279487301],
						[499361.8874237588, 645278.04297539848],
						[499390.91075382679, 645278.04187498463],
						[499390.91189673316, 645308.90267214237],
						[499419.21473642113, 645308.90164837195],
						[499419.21636526327, 645355.02693418378],
						[499474.17502777238, 645350.26876042353],
						[499812.5728834222, 645320.72796623362]
					]
				],
				[
					[
						[493158.37930432719, 646447.1895458342],
						[493158.35371949774, 646385.68885599938],
						[493558.7869551687, 646385.52714795817],
						[493558.77486815816, 646354.66619672021],
						[493587.89921124303, 646354.65481571376],
						[493587.88730826334, 646324.12570707011],
						[493501.44033445732, 646324.15963887295],
						[493501.42813988443, 646293.29869663378],
						[493415.90722335177, 646293.33271207346],
						[493415.8949568675, 646262.69299974199],
						[493330.27096773603, 646262.72750169656],
						[493330.20879287517, 646109.41839428688],
						[493411.92283268645, 646109.38545811968],
						[493501.35545326874, 646109.34987619589],
						[493501.36742929096, 646139.65772857564],
						[493616.01386885211, 646139.61282632593],
						[493616.02584828337, 646170.47374625108],
						[493730.67207302072, 646170.42964327929],
						[493730.68375299056, 646201.06934250495],
						[493816.30806313304, 646201.03692524438],
						[493816.29654268146, 646170.39722595655],
						[493901.81809848553, 646170.36529257952],
						[493901.82945960533, 646201.00499192695],
						[493930.95407480962, 646200.99421843514],
						[493930.96550412889, 646231.96576020692],
						[493987.46509299503, 646231.94500751351],
						[493987.44256847637, 646170.33376630081],
						[494102.0887941792, 646170.29225247877],
						[494102.12183755747, 646262.43258956634],
						[494130.42303637334, 646262.42246459192],
						[494130.43397166277, 646293.06217742758],
						[494159.45551058132, 646293.05184532108],
						[494159.4664703724, 646323.91278802196],
						[494216.78904788441, 646323.89253079949],
						[494216.76742123417, 646262.39187516668],
						[494289.73305767326, 646262.36637886881],
						[494302.2884986524, 646262.36202427733],
						[494302.30980549246, 646323.86268001772],
						[494330.6108985988, 646323.8528995415],
						[494330.62142284273, 646354.38200868643],
						[494416.24493477552, 646354.35271490528],
						[494416.22409151477, 646292.96266283281],
						[494387.92294525093, 646292.97229598719],
						[494387.88104746316, 646170.19224533602],
						[494416.18240501283, 646170.18261210807],
						[494416.11987530452, 645986.01266948099],
						[494387.81820082507, 645986.02230281662],
						[494387.80755653617, 645954.82957164408],
						[494359.50582839677, 645954.83925369789],
						[494359.47434148053, 645863.03088721773],
						[494330.4520437246, 645863.04086635716],
						[494330.44132885209, 645831.95876576379],
						[494302.1393892708, 645831.96854653745],
						[494302.10762069642, 645740.27084575058],
						[494244.7830089645, 645740.29080559849],
						[494244.77205485752, 645708.98749827826],
						[494216.57282057806, 645708.99739028548],
						[494216.55131068174, 645647.8287501093],
						[494244.75064984296, 645647.81885806518],
						[494244.72909000277, 645586.20778618276],
						[494216.52964520251, 645586.21767826646],
						[494216.51890971005, 645555.6886798084],
						[494187.39315172931, 645555.69894758973],
						[494187.37145534082, 645494.30912705394],
						[494159.17185297213, 645494.31911748077],
						[494159.16089322785, 645463.45829549362],
						[494130.13789036724, 645463.46862811851],
						[494130.12699459534, 645432.93964735488],
						[494101.82436836575, 645432.94977284188],
						[494101.80227342079, 645371.33876345772],
						[494073.49954118551, 645371.3489376856],
						[494073.48842077551, 645340.48813360825],
						[494044.46520091168, 645340.49861741858],
						[494044.45414620562, 645309.96965436626],
						[494016.15130836482, 645309.97992728278],
						[494016.12897314766, 645248.59017792682],
						[493987.10559111874, 645248.60076296073],
						[493987.08306670177, 645186.98980712704],
						[493958.78001723142, 645187.00017876911],
						[493958.76876296004, 645156.36062570405],
						[493930.56858114712, 645156.37100809254],
						[493930.54592672328, 645094.98130316357],
						[493901.41935286956, 645094.99207737762],
						[493901.4079507931, 645064.24192553922],
						[493873.20761103841, 645064.252406282],
						[493873.19611503283, 645033.3916468753],
						[493815.86903947796, 645033.41310169618],
						[493815.81131278939, 644879.8836555616],
						[493786.68435802142, 644879.89463295939],
						[493786.67269981053, 644849.03390031378],
						[493758.47199106368, 644849.04457776807],
						[493758.44869474432, 644787.65496161697],
						[493730.14495807851, 644787.66572670487],
						[493730.0981541808, 644664.88654746895],
						[493701.07374212029, 644664.89763724175],
						[493700.99143502279, 644449.97893772915],
						[493672.68711726798, 644449.98980169254],
						[493672.66341627768, 644388.37907699612],
						[493700.96784005646, 644388.36821299023],
						[493700.93242643669, 644295.89685333427],
						[493758.2620726045, 644295.87499790709],
						[493758.25048743881, 644265.34618455591],
						[493786.45219699049, 644265.33550671639],
						[493786.41726425278, 644172.86420005001],
						[493758.21539614943, 644172.87487794901],
						[493758.19218385656, 644111.70667914394],
						[493729.88728398527, 644111.71744467074],
						[493729.86379777355, 644050.10681728646],
						[493700.83830083988, 644050.11790746998],
						[493700.82660928078, 644019.58912921592],
						[493643.49600012176, 644019.61118484137],
						[493643.48415940756, 643988.97179948073],
						[493586.9768649452, 643988.99373390817],
						[493586.9648327207, 643958.13313002058],
						[493557.83624561556, 643958.14451268688],
						[493557.82411542075, 643927.17330180597],
						[493529.62182605849, 643927.18437165243],
						[493529.646149148, 643989.01618636143],
						[493444.01032246323, 643989.05009611638],
						[493443.88771473675, 643681.43976016017],
						[493472.19335504959, 643681.42850246769],
						[493472.14471689775, 643558.87118106778],
						[493500.34763776237, 643558.86001267156],
						[493500.32338005718, 643497.47076692421],
						[493529.4526959504, 643497.23805993004],
						[493529.40439799021, 643374.4596210852],
						[493557.6076350463, 643374.44855087053],
						[493557.55946098058, 643251.44895983487],
						[493586.68929958175, 643251.43757667858],
						[493586.66545084701, 643190.26964073151],
						[493614.86900371732, 643190.25866869558],
						[493614.85702444927, 643159.3981795623],
						[493643.16356311733, 643159.38721608324],
						[493643.15167970583, 643128.63734240097],
						[493586.64142961515, 643128.65927797544],
						[493586.62939744274, 643097.79879769357],
						[493557.49928676389, 643097.81018095755],
						[493557.48732990376, 643067.28153817169],
						[493529.28356617945, 643067.29260859312],
						[493529.27142644237, 643036.43213715137],
						[493500.14120709017, 643036.44362199027],
						[493500.12905641249, 643005.69376597402],
						[493471.92518709047, 643005.70493474416],
						[493471.9130275881, 642975.06569410814],
						[493443.60617173498, 642975.07695228211],
						[493443.59400359227, 642944.54832698102],
						[493414.56655573385, 642944.55992233963],
						[493414.55402374413, 642913.25702481973],
						[493386.2470615264, 642913.26838169934],
						[493386.23487593076, 642882.9609870424],
						[493357.20731938962, 642882.97268361622],
						[493357.1948569708, 642852.11223871459],
						[493328.88778952969, 642852.12369430263],
						[493328.87549829984, 642821.81630828185],
						[493300.67131370486, 642821.82777067902],
						[493300.65856507572, 642790.52489107742],
						[493271.52791024587, 642790.53678076831],
						[493271.5154228966, 642760.00818173541],
						[493214.18042346934, 642760.03173373023],
						[493214.16778408369, 642729.39252822241],
						[493185.96344102005, 642729.40418729722],
						[493185.95079492166, 642698.87559698545],
						[493128.61558242125, 642698.89944721851],
						[493128.60250648099, 642667.59658559156],
						[493100.2951215182, 642667.60843455466],
						[493100.2824092696, 642637.3010746463],
						[493013.91899214842, 642637.33752583538],
						[493013.93186351651, 642667.64488567563],
						[492985.62447863433, 642667.6569319705],
						[492985.63782665291, 642698.95979347569],
						[492957.33049566031, 642698.97188845486],
						[492957.34356605227, 642729.50047858828],
						[492928.31573871017, 642729.51293200976],
						[492928.34203479189, 642790.68073605769],
						[492871.00714227714, 642790.70548418653],
						[492870.99491828389, 642762.49971347942],
						[492785.45462253108, 642760.21417926322],
						[492785.46709021879, 642788.64117134945],
						[492785.48174096894, 642822.0456571047],
						[492671.53271952824, 642822.09602805192],
						[492671.54622187681, 642852.40341355139],
						[492600.10947844444, 642852.43539457326],
						[492556.8768672102, 642852.45489976602],
						[492556.86315359018, 642822.14751435991],
						[492413.9894040738, 642822.21278272884],
						[492414.00338093517, 642852.52016801597],
						[492328.36163727421, 642852.55988621071],
						[492328.37602985813, 642883.42033027392],
						[492242.01390491333, 642883.4608340828],
						[492242.02819868526, 642913.76822782203],
						[492156.38677390525, 642913.8088413775],
						[492156.40170015953, 642945.11173784651],
						[492070.86337277235, 642945.15274758404],
						[492070.87808858173, 642975.68137176638],
						[491956.20959330007, 642975.73704523616],
						[491956.22457600909, 643006.37628462026],
						[491842.37976530415, 643006.43234893575],
						[491842.39501492883, 643037.18220356968],
						[491813.26479690499, 643037.19667571434],
						[491813.28015603492, 643068.05714572011],
						[491755.94623032218, 643068.08578039042],
						[491755.9307636281, 643037.22531043855],
						[491727.72694837366, 643037.23946979456],
						[491727.75782071293, 643098.62858098873],
						[491613.0901825031, 643098.68664634437],
						[491613.10591724172, 643129.54712496349],
						[491527.46561589005, 643129.59101290326],
						[491527.48134038586, 643160.11966268264],
						[491413.63770921587, 643160.39991642255],
						[491413.65381821292, 643191.26040367782],
						[491327.29330948734, 643191.30570991011],
						[491327.30940555589, 643221.83436824055],
						[491156.13269652583, 643221.92551055946],
						[491156.09969059844, 643160.53636539856],
						[491126.96969102859, 643160.55205290974],
						[491127.00280566921, 643221.94119801128],
						[490669.98261358531, 643222.19407270791],
						[490669.99999235512, 643252.83334579831],
						[490612.66671068664, 643252.86596537288],
						[490612.64922512363, 643222.22669233917],
						[490527.00940630882, 643222.27578900196],
						[490526.9918249289, 643191.74713149283],
						[490384.12128568185, 643191.83003046957],
						[490384.1032451666, 643160.96954429056],
						[490126.56510280765, 643160.9008901536],
						[490126.54677830165, 643130.37224182161],
						[489868.90535666724, 643130.52890565223],
						[489868.88634961931, 643099.66842887411],
						[489783.24589273112, 643099.72139783099],
						[489783.22693112103, 643069.19275859126],
						[489669.38255521958, 643069.26386208751],
						[489669.3631739234, 643038.40339434217],
						[489583.00186269829, 643038.45785837108],
						[489582.98238943436, 643007.70800611912],
						[489154.16011110455, 643007.9851594388],
						[489154.1803859963, 643038.73501116945],
						[489125.97657333681, 643038.75363145897],
						[489126.01715545368, 643100.14273699943],
						[489096.88704893406, 643100.16201960039],
						[489096.90750432987, 643131.0224954494],
						[489040.39726245997, 643131.06004936644],
						[489040.37670104363, 643100.199573591],
						[488954.01571427035, 643100.25733988406],
						[488953.99521366711, 643069.72870164143],
						[488868.3546009147, 643069.78643383738],
						[488868.33371681185, 643038.92596707493],
						[488754.48913145642, 643039.00340249226],
						[488754.51022914267, 643069.86386911024],
						[488782.81692189415, 643069.84454171103],
						[488782.85878477513, 643131.23365519661],
						[488811.06243886979, 643131.21444659936],
						[488811.10434698727, 643192.82479977887],
						[488897.56778043299, 643192.76621370087],
						[488897.58838592458, 643223.2948693207],
						[488983.1252669908, 643223.23735826625],
						[488983.14578781719, 643253.87662941916],
						[489011.45216391038, 643253.8576954687],
						[489011.49332179682, 643315.46808431181],
						[489040.52011513989, 643315.44871906808],
						[489040.54045548639, 643345.97739229165],
						[489068.84667308413, 643345.95855710341],
						[489068.86593180517, 643374.93867848266],
						[489068.88761624781, 643407.56897249504],
						[489097.09079654416, 643407.55025431863],
						[489097.11125196784, 643438.41077426344],
						[489126.24075948499, 643438.39149205899],
						[489126.28119543265, 643499.55948920141],
						[489154.4843638668, 643499.7620918774],
						[489154.50449294224, 643530.29079143156],
						[489183.63383774291, 643530.27161086723],
						[489183.65413096402, 643561.13214854884],
						[489211.85704796226, 643561.11362715194],
						[489211.89731095074, 643622.50288203685],
						[489240.20305269386, 643622.48434173607],
						[489240.22316754737, 643653.23428144585],
						[489269.24936485314, 643653.21531983069],
						[489269.26920896175, 643683.63343002927],
						[489297.57484550844, 643683.61498845392],
						[489297.59499713266, 643714.58615966048],
						[489354.92666948383, 643714.54895640502],
						[489354.94664157392, 643745.40952080523],
						[489383.97267621575, 643745.39076163457],
						[489383.99237968406, 643775.91949641029],
						[489440.50040617719, 643775.88312289026],
						[489440.5202177965, 643806.74369622697],
						[489469.64907302381, 643806.72502216883],
						[489469.66868836794, 643837.36437718535],
						[489486.96076813445, 643837.46392733883],
						[489497.87120236311, 643837.45695757866],
						[489497.91039861558, 643898.84629226802],
						[489527.03909073881, 643898.82771984162],
						[489527.07817828236, 643960.21707218001],
						[489497.94959487801, 643960.23564453574],
						[489497.9692989472, 643991.09624447767],
						[489469.76711919514, 643991.11427531217],
						[489469.82624853525, 644083.4748786618],
						[489440.69788340671, 644083.4935524055],
						[489440.73722266493, 644144.77234587981],
						[489412.53530640318, 644144.79047483928],
						[489412.55481497332, 644175.09804340359],
						[489384.25002419669, 644175.11628711456],
						[489384.26280291943, 644194.91575938254],
						[489384.27015603706, 644206.3087526334],
						[489326.94019771798, 644206.34585361159],
						[489326.96022295899, 644237.2064888007],
						[489297.93505619915, 644237.2253485776],
						[489297.97471181524, 644298.17235078465],
						[489269.67013283086, 644298.19079166884],
						[489269.73045912746, 644390.66213842598],
						[489298.03487898398, 644390.64369764365],
						[489298.07496645377, 644452.25441385689],
						[489269.77065261995, 644452.27285457391],
						[489269.83061815565, 644544.19120916596],
						[489212.50183752499, 644544.22870901984],
						[489212.52207793004, 644575.08939282247],
						[489126.99222661607, 644575.14571097458],
						[489127.01240813703, 644605.67456375354],
						[489069.68384180346, 644605.71256140107],
						[489069.7043502563, 644636.57325389935],
						[488984.07189504005, 644636.63038364775],
						[488984.09249008587, 644667.38046867133],
						[488755.60247331823, 644667.53508783039],
						[488755.58145109424, 644636.78500309587],
						[488726.55698945199, 644636.80487115518],
						[488726.53583715454, 644605.94417909021],
						[488640.90322247607, 644606.00309549551],
						[488640.94577202515, 644667.61387203727],
						[488611.92136478529, 644667.63394239102],
						[488611.96386989817, 644729.02351292805],
						[488698.31630541274, 644728.96395078395],
						[488698.33751082892, 644759.82466058852],
						[488783.96932465822, 644759.7660432033],
						[488783.99014312122, 644790.294921919],
						[488869.51887564606, 644790.23682012386],
						[488869.6021133411, 644913.2372747286],
						[488898.72900906997, 644913.21758962644],
						[488898.77044436801, 644974.60723162373],
						[488926.97093783214, 644974.58822176326],
						[488926.99171455734, 645005.44896743249],
						[488939.54811510607, 645005.44051876233],
						[488955.29507646238, 645005.42993684695],
						[488955.31557724957, 645035.95885096851],
						[489025.19902124529, 645035.91207140614],
						[489069.96971080016, 645035.88225822244],
						[489069.98036933696, 645051.92100116564],
						[489069.99021929572, 645066.74301295844],
						[489212.84447387105, 645066.64869990619],
						[489212.86464177805, 645097.39884724107],
						[489327.51834702172, 645097.32404986175],
						[489327.53822880099, 645127.96358971042],
						[489413.16812596144, 645127.90824815969],
						[489413.18791941903, 645158.65840460081],
						[489498.71473641362, 645158.6035746776],
						[489498.7342993475, 645189.24312356464],
						[489584.36387746315, 645189.18867332139],
						[489584.38335092808, 645219.93883882929],
						[489641.70977636945, 645219.90263516339],
						[489641.72921232029, 645250.76341731474],
						[489727.35847013927, 645250.70971154701],
						[489727.37753815757, 645281.23866183613],
						[489754.85706874786, 645281.22152145661],
						[489813.72707444418, 645281.18495577388],
						[489813.74618770223, 645312.04574702866],
						[489899.27220706746, 645311.99300005182],
						[489899.29095605895, 645342.52195933985],
						[489984.91973614367, 645342.46959452704],
						[489984.93852826022, 645373.3303948855],
						[490012.41790498322, 645373.31368483603],
						[490070.56714794837, 645373.27847598144],
						[490070.58571261237, 645404.02866870631],
						[490156.93460422824, 645403.9767645367],
						[490156.95307365427, 645434.83757402981],
						[490242.47845448111, 645434.78661175258],
						[490242.4965665568, 645465.31558908615],
						[490267.71158394689, 645465.30064902175],
						[490356.42727796279, 645465.2483916725],
						[490356.44537313492, 645496.10921029747],
						[490442.79378130625, 645496.05880693556],
						[490442.81152162777, 645526.58779330191],
						[490528.33642534405, 645526.53831751714],
						[490528.35419801966, 645557.39914524555],
						[490613.98185937072, 645557.35005555081],
						[490613.99928199931, 645587.87905092712],
						[490699.62678466417, 645587.8304071296],
						[490699.64423600043, 645618.69124396169],
						[490785.99200059293, 645618.64264244144],
						[490786.00922793895, 645649.39287150127],
						[490871.63641034177, 645649.34512324864],
						[490871.65353897889, 645680.20596920967],
						[490985.47984468646, 645680.14318649226],
						[490985.49645660986, 645710.45097517851],
						[491071.84373944992, 645710.40387442638],
						[491071.86073267489, 645741.7071790531],
						[491149.56284785661, 645741.66518159676],
						[491157.48743444833, 645741.66091904335],
						[491157.50384840462, 645772.18994151498],
						[491221.82667220203, 645772.1554841944],
						[491271.32951749134, 645772.12913714699],
						[491271.34577886446, 645802.76877654821],
						[491299.64776869735, 645802.75378023961],
						[491357.69257701695, 645802.72317654442],
						[491357.70861940651, 645833.25220801472],
						[491386.0105567819, 645833.23736032262],
						[491471.53386587766, 645833.19278924982],
						[491471.5499837774, 645864.27488751209],
						[491557.99937495077, 645864.23028578365],
						[491558.0150455836, 645894.75932631793],
						[491671.83986636047, 645894.70129385567],
						[491671.8554937407, 645925.56217636098],
						[491685.23451631534, 645925.55540693516],
						[491700.87768117373, 645925.54750572029],
						[491700.89303082757, 645955.96594271692],
						[491729.19475703215, 645955.95168559556],
						[491729.21044372942, 645987.14441463817],
						[491814.73295249272, 645987.10162823112],
						[491814.74814668082, 646017.63068671466],
						[491900.37341189192, 646017.58829442749],
						[491900.38850161404, 646048.2279699397],
						[491986.73401106149, 646048.1856725004],
						[491986.74899381102, 646078.93596509518],
						[492072.37393984589, 646078.8944683047],
						[492072.38892246387, 646109.97660319915],
						[492157.91079248284, 646109.93560135015],
						[492157.9252442625, 646140.24345265923],
						[492243.54987110436, 646140.20284706575],
						[492243.56442593684, 646171.06376588333],
						[492358.21064659447, 646171.01009549026],
						[492358.22488350037, 646201.64979362814],
						[492443.84919063811, 646201.61023086472],
						[492443.8634204914, 646232.58177147806],
						[492500.36300725007, 646232.55590993701],
						[492529.38465294626, 646232.5427013305],
						[492529.39852076047, 646263.07179586566],
						[492596.90974153992, 646263.04126763856],
						[492615.74290223821, 646263.03280082368],
						[492615.75665943697, 646293.67251252057],
						[492701.38048746902, 646293.6342905591],
						[492701.39418332808, 646324.49523216672],
						[492787.01785088651, 646324.4574560601],
						[492787.0312405341, 646354.98656408349],
						[492901.67617905175, 646354.93668219459],
						[492901.68949911033, 646385.79763291986],
						[492973.11089787597, 646385.76696156571],
						[492987.20993482543, 646385.76094350393],
						[492987.2230472407, 646416.51128605194],
						[493072.84623572376, 646416.47499806643],
						[493072.8591880427, 646447.22534515499],
						[493158.37930432719, 646447.1895458342]
					]
				]
			]
		}
	}, {
		"type": "Feature",
		"properties": {
			"name": "Kowloon City",
			"ID_0": 102,
			"ID_1": 4,
			"ISO": "HKG"
		},
		"geometry": {
			"type": "MultiPolygon",
			"coordinates": [
				[
					[
						[518462.56717311492, 649195.14289466001],
						[518549.87717430631, 649055.31412834942],
						[518636.31257904554, 648962.16410017444],
						[518636.52369480394, 648775.89016398613],
						[518766.07192613318, 648776.03749955702],
						[518939.71839398425, 648636.53106356168],
						[518939.87917776161, 648496.93643055088],
						[518853.70670184947, 648357.13206548907],
						[518853.86713298829, 648217.20577707281],
						[518983.47326978925, 648171.00771963515],
						[519113.85496221471, 648077.91137901507],
						[519114.01734690095, 647938.2065067495],
						[519114.28811637493, 647705.25464631908],
						[519243.89901867445, 647659.05875460652],
						[519244.17162306595, 647426.10720602726],
						[519417.6714218572, 647426.31115439977],
						[519547.88746845018, 647566.17014990316],
						[519720.61825903197, 647519.9187431318],
						[519807.89160196652, 647426.77654502308],
						[520024.78209689673, 647287.33458335034],
						[520241.17213399615, 647473.87237312016],
						[520500.93819418503, 647613.89892355248],
						[520717.37719926459, 647753.87503388594],
						[520846.93348232278, 647754.0387631855],
						[520977.37254218501, 647707.52572764002],
						[521063.82849507616, 647614.61028900626],
						[521064.80426393845, 646852.81792135164],
						[521065.08096963924, 646636.79105282063],
						[520943.50348846184, 646506.00191004283],
						[520848.64548801619, 646403.56448437378],
						[520984.65563077503, 646273.98864860146],
						[521239.37119480717, 646031.4101209793],
						[521369.12242306897, 645891.98508407071],
						[521456.41344030836, 645799.07357934839],
						[521542.88239732326, 645705.9402756514],
						[521629.47481667169, 645519.67198240501],
						[521555.70848997956, 645499.7755211289],
						[521518.05358978623, 645489.66048708162],
						[521518.03043488855, 645507.3584360258],
						[521403.37958721194, 645507.20883338724],
						[521403.33985782799, 645537.7377990596],
						[521375.03741189843, 645537.70099149318],
						[521374.99730377266, 645568.56179827556],
						[521346.79782868474, 645568.52517306583],
						[521346.75820416707, 645599.05414769729],
						[521317.63252294145, 645599.01637029625],
						[521317.59252237075, 645629.8771861312],
						[521232.06815561355, 645629.76655503933],
						[521232.02845831355, 645660.51676330599],
						[521203.72622366686, 645660.48025054217],
						[521203.68643667037, 645691.34107560816],
						[521174.66383590136, 645691.30368407606],
						[521174.62481541233, 645721.6114521987],
						[521117.30013848387, 645721.53774791129],
						[521117.25994540198, 645752.84103135113],
						[521060.75871043856, 645752.76858131436],
						[521060.71961640607, 645783.29758316569],
						[521031.59426145925, 645783.26031231345],
						[521031.55508003855, 645813.8999309811],
						[521003.35602559766, 645813.8638946315],
						[521003.27734402125, 645875.47498251731],
						[520945.953203385, 645875.40187546285],
						[520945.91432214633, 645905.93089525506],
						[520888.59028766584, 645905.85798813554],
						[520888.55109136715, 645936.71884970064],
						[520860.24933202402, 645936.68292800896],
						[520860.17118591897, 645998.2940523118],
						[520831.14912681287, 645998.25726696325],
						[520831.11045836954, 646028.78630473872],
						[520773.78685210214, 646028.71379776939],
						[520773.74815034453, 646059.35345255374],
						[520745.44660203578, 646059.3177284206],
						[520745.3686063207, 646121.15011397807],
						[520688.04532198783, 646121.07790586748],
						[520688.00719716086, 646151.38573663554],
						[520659.80872137297, 646151.35028933012],
						[520659.88583975669, 646089.96034450876],
						[520630.76102788094, 646089.92378349684],
						[520630.79960208648, 646059.17351144878],
						[520602.60096818989, 646059.13816222874],
						[520602.75477692153, 645936.35834321915],
						[520660.07870509481, 645936.43025405728],
						[520660.11747267639, 645905.56939195131],
						[520688.31636987912, 645905.60483978631],
						[520688.35477294779, 645875.07581938803],
						[520717.37704942381, 645875.11235274666],
						[520717.41620304016, 645844.03027497162],
						[520745.71812182461, 645844.06595086795],
						[520745.75663128967, 645813.53693947115],
						[520774.05860254978, 645813.57266413956],
						[520774.09730425989, 645782.93304486305],
						[520803.11974333564, 645782.96972953179],
						[520803.19795444264, 645721.13744287251],
						[520831.50008470687, 645721.17326638824],
						[520831.53847288823, 645690.86549746117],
						[520888.86325672787, 645690.93820572214],
						[520888.90245298378, 645660.07737989712],
						[520946.22734413104, 645660.15028810431],
						[520946.26650707133, 645629.40007915208],
						[521003.59150514659, 645629.4731873027],
						[521003.63091652055, 645598.61237070581],
						[521031.83034002827, 645598.64840752562],
						[521031.8693799653, 645568.11943214084],
						[521060.99511590577, 645568.15670348308],
						[521061.07372882083, 645506.76692944777],
						[521089.27330980572, 645506.80306476075],
						[521089.31288163713, 645475.94226619811],
						[521117.61543384317, 645475.97858207475],
						[521117.65463270072, 645445.44962453155],
						[521146.67766731908, 645445.48691546312],
						[521146.71734670165, 645414.62612595013],
						[521204.04309336888, 645414.69993277267],
						[521204.12252464553, 645353.0889795674],
						[521260.62513268, 645353.16192212678],
						[521260.66459667671, 645322.63298258383],
						[521306.25786028482, 645322.69198313309],
						[521317.99066398782, 645322.70718657109],
						[521318.11023539462, 645230.45672237431],
						[521375.43662398175, 645230.53112658544],
						[521375.47658828326, 645199.78098087932],
						[521432.80308379419, 645199.85558503948],
						[521432.84301112877, 645169.21605592291],
						[521461.14609116607, 645169.2529629654],
						[521461.22619560355, 645107.86330612039],
						[521518.5530114877, 645107.93820916465],
						[521518.5932430455, 645077.18808153528],
						[521547.61692751385, 645077.22607998154],
						[521547.65735824214, 645046.36534491414],
						[521575.96064968535, 645046.40244953206],
						[521576.00069820153, 645015.87355479598],
						[521633.32783471787, 645015.94885788846],
						[521633.36842610617, 644985.08813192754],
						[521661.56890155433, 644985.1252484899],
						[521661.60940016771, 644954.37513895996],
						[521718.93675103883, 644954.45074044098],
						[521719.05856838764, 644862.20043888967],
						[521809.42427049833, 644862.32001602056],
						[521890.32112854824, 644862.42748460744],
						[521890.2800553618, 644893.28819212911],
						[521947.50469713076, 644893.36445329874],
						[521947.54587768775, 644862.50374592154],
						[522033.17715648067, 644862.61823545117],
						[522033.21805317368, 644832.0893682437],
						[522062.24217015493, 644832.12827482505],
						[522062.28356582863, 644801.2675766137],
						[522033.259394389, 644801.22866996145],
						[522033.34163227229, 644739.83912213787],
						[522090.66973090492, 644739.91601929127],
						[522090.75218274037, 644678.52648941136],
						[522119.77657070651, 644678.56549751945],
						[522119.81792515941, 644647.81543340802],
						[522148.12190244556, 644647.85352262622],
						[522148.32879025175, 644494.21388047701],
						[522205.65774501022, 644494.29117841809],
						[522205.71464079514, 644452.14814272965],
						[522205.74062469532, 644432.90171975177],
						[522229.31042648212, 644432.93355741992],
						[522234.0865392306, 644402.18992837647],
						[522267.84596900287, 644402.23559856578],
						[522291.41581473406, 644402.26752522984],
						[522291.44129919558, 644383.46355326439],
						[522291.49931381672, 644340.65687030833],
						[522314.96632231498, 644340.68869122816],
						[522320.69076301891, 644218.0280338953],
						[522291.66556236311, 644217.98867124238],
						[522291.70783655148, 644186.79622787051],
						[522234.37781001779, 644186.71863000025],
						[522234.41877929604, 644156.41108285217],
						[522206.11395631602, 644156.37284513086],
						[522206.15562009311, 644125.51224488579],
						[522177.85074393702, 644125.47405579512],
						[522177.17126894515, 644095.05493426637],
						[522148.86634037673, 644095.01679505804],
						[522148.82537995727, 644125.43494520849],
						[522120.52050367091, 644125.39685477526],
						[522120.47900056222, 644156.25745523837],
						[522091.45369090192, 644156.21844588965],
						[522091.41298505483, 644186.52599339746],
						[522034.08295758173, 644186.44909365801],
						[522034.0411719571, 644217.64153768704],
						[522005.73645434174, 644217.60364478396],
						[522005.65447028569, 644278.88243118569],
						[521948.32476472011, 644278.80583035864],
						[521948.2840270765, 644309.33461872744],
						[521891.05735332932, 644309.25835484429],
						[521890.97535438137, 644370.86900289706],
						[521862.67090044741, 644370.83135618293],
						[521862.62988046458, 644401.69199273735],
						[521834.32547957101, 644401.6543948038],
						[521834.28465952358, 644432.40442426014],
						[521805.25983716815, 644432.36591994204],
						[521805.21892473829, 644463.22656553471],
						[521776.91462973907, 644463.1890664004],
						[521776.87420975382, 644493.71788154438],
						[521747.84949559666, 644493.67947853485],
						[521747.80898322683, 644524.31890978699],
						[521719.50479336095, 644524.28150944598],
						[521719.46418764855, 644555.03155684879],
						[521691.26297476457, 644554.99434102001],
						[521691.2222758946, 644585.85500462435],
						[521662.09480038501, 644585.8166172104],
						[521662.05459319823, 644616.34545017628],
						[521633.8534854399, 644616.30833278387],
						[521633.81289412442, 644647.1690053955],
						[521604.68552719906, 644647.13071965275],
						[521604.64513582067, 644677.88078504452],
						[521548.14020789758, 644677.80666063237],
						[521548.10006706358, 644708.44611882116],
						[521519.0757318298, 644708.40811952238],
						[521519.03550034028, 644739.1581939751],
						[521490.73168017785, 644739.12118731788],
						[521490.69135707401, 644769.98187806283],
						[521461.66713042691, 644769.94398006704],
						[521461.62729477219, 644800.47283989307],
						[521433.32358012174, 644800.43593202927],
						[521433.28336457122, 644831.29663179559],
						[521375.95558445359, 644831.2220259615],
						[521375.91590772732, 644861.75089478341],
						[521347.71522074705, 644861.71426799323],
						[521347.67516566213, 644892.57497685461],
						[521290.34759912803, 644892.50066940603],
						[521290.26813361835, 644953.8902651011],
						[521261.14130986371, 644953.85258774261],
						[521261.10155996727, 644984.60269824695],
						[521232.90108362242, 644984.56626831833],
						[521232.8612436484, 645015.42699526227],
						[521175.53410531295, 645015.35308799788],
						[521175.49480012746, 645045.88198369998],
						[521147.19150778791, 645045.84556822258],
						[521147.15182847407, 645076.70630426425],
						[521118.12814308651, 645076.66901249718],
						[521118.08866024879, 645107.41914109816],
						[521089.78547380673, 645107.38282440568],
						[521089.74618571659, 645138.02234551485],
						[521061.54597242386, 645137.98620939185],
						[521061.46735964116, 645199.37587700016],
						[521032.34097062214, 645199.33860482241],
						[521032.30164785759, 645230.08875135845],
						[520974.97525772935, 645230.01554314268],
						[520974.89696760458, 645291.40523773024],
						[520918.39414740918, 645291.33327678009],
						[520918.35489676276, 645322.19404899236],
						[520889.33164458105, 645322.15716097271],
						[520889.29286985093, 645352.68610139645],
						[520831.96690703655, 645352.61339164001],
						[520831.88886986434, 645414.22434662399],
						[520774.56312154175, 645414.15183694963],
						[520774.52414046176, 645445.01262734924],
						[520746.22153497109, 645444.97690187918],
						[520746.1440975857, 645506.36665967875],
						[520717.84159767214, 645506.33098304598],
						[520717.80314079981, 645536.85995035269],
						[520688.78026742756, 645536.82341623202],
						[520688.74144699704, 645567.68422466295],
						[520660.54197040159, 645567.64877609722],
						[520660.50361973449, 645598.17775235442],
						[520574.87617053691, 645598.07040942961],
						[520574.79909519671, 645659.68143687071],
						[520545.77643855917, 645659.6451551083],
						[520545.73788614932, 645690.50598174345],
						[520517.43570311443, 645690.47064997978],
						[520517.39789375808, 645720.77841963759],
						[520460.07321393274, 645720.7070061143],
						[520459.99629282602, 645782.53929439373],
						[520431.69426816789, 645782.50411018147],
						[520431.65620434668, 645813.14373025682],
						[520374.33184645709, 645813.07261558657],
						[520374.29402645386, 645843.60162784997],
						[520345.27169437293, 645843.56569990155],
						[520345.23324406636, 645874.64777856041],
						[520316.93137790787, 645874.6127918358],
						[520316.8936643012, 645905.14181309519],
						[520259.67254276254, 645905.07122520311],
						[520259.63452659192, 645935.9320882496],
						[520231.33276589587, 645935.89724882995],
						[520231.29534709913, 645966.31566667918],
						[520202.27323156595, 645966.27999108029],
						[520202.23491533136, 645997.47270053346],
						[520144.91119992686, 645997.40238551225],
						[520144.94940743531, 645966.2096759259],
						[520115.10396927927, 645966.1731456886],
						[520088.34599019145, 645966.14044049429],
						[520088.38314459467, 645935.72202231374],
						[520059.36097507324, 645935.68659890303],
						[520059.39861543907, 645904.82573539775],
						[520031.09680121398, 645904.79124055267],
						[520031.13398430456, 645874.26221864182],
						[520002.11170632811, 645874.22689626226],
						[520002.18663738063, 645812.61580369994],
						[519973.88466447114, 645812.58140730276],
						[519973.99696913693, 645720.10949565668],
						[519945.79775389069, 645720.0752725834],
						[519945.87877808174, 645653.26544746559],
						[519945.90922922443, 645628.1564623334],
						[519929.44244212849, 645628.13650030713],
						[519888.5842265648, 645628.08704073832],
						[519888.66033624409, 645565.14867228409],
						[519888.73270061548, 645505.30746403162],
						[519859.70977156283, 645505.27239293652],
						[519859.74703624292, 645474.41159150179],
						[519831.44448134082, 645474.37744022289],
						[519831.51850434928, 645412.98768712522],
						[519789.93932293536, 645412.93760394468],
						[519774.19275171851, 645412.91866423585],
						[519774.2213444006, 645389.13705283729],
						[519745.92700908938, 645382.13448402181],
						[519746.07441578328, 645259.35504796379],
						[519717.05105271051, 645259.32022861217],
						[519717.08804911055, 645228.45946251531],
						[519746.11146664439, 645228.4942819376],
						[519746.22208799364, 645136.35445872089],
						[519774.52522458066, 645136.38846334629],
						[519774.59903349407, 645074.99880746705],
						[519803.62272183236, 645075.03372837091],
						[519803.69663905707, 645013.64409031929],
						[519831.99998680985, 645013.67819385137],
						[519832.03719829989, 644982.81746362464],
						[519860.34059910057, 644982.85161592043],
						[519860.56325160153, 644798.4616115971],
						[519917.78822331131, 644798.53081089503],
						[519917.82519339054, 644768.00194746314],
						[519946.9523462666, 644768.03724593401],
						[519947.10151595098, 644645.0369421239],
						[519917.97414525133, 644645.00164338958],
						[519918.34639058774, 644337.61180466856],
						[519890.14480491797, 644337.57767701801],
						[519890.18212385487, 644306.71704465849],
						[519861.1570797094, 644306.68197100575],
						[519861.23067369382, 644245.73500032956],
						[519890.25582539081, 644245.7700741099],
						[519890.33086450084, 644183.71700577694],
						[519861.30560330447, 644183.68193186633],
						[519861.49072341761, 644030.37442806293],
						[519833.18568354991, 644030.34027378447],
						[519833.22262811812, 643999.70090841257],
						[519804.91753546597, 643999.66680278443],
						[519804.9546936691, 643968.80621891958],
						[519775.92905322637, 643968.77129566483],
						[519775.96628995705, 643937.80010478967],
						[519662.12792491965, 643937.66363040067],
						[519662.1642861797, 643907.24550060998],
						[519633.03560891643, 643907.21070647298],
						[519633.07231238578, 643876.46074686514],
						[519604.86993603391, 643876.42710834672],
						[519604.90645493584, 643845.78776441934],
						[519575.77780048194, 643845.6424603404],
						[519575.81426511781, 643815.0031207467],
						[519461.97505021107, 643814.86803160119],
						[519462.04768623854, 643753.4787537423],
						[519433.02166581975, 643753.44443560019],
						[519432.9855979929, 643783.97315543192],
						[519232.68584139255, 643783.73773263174],
						[519232.72153745929, 643753.20901236671],
						[519176.21343289758, 643753.14303655666],
						[519176.2494109433, 643722.28248666425],
						[519118.91776536632, 643722.21574772976],
						[519118.95376441057, 643691.24459088373],
						[519089.92763416941, 643691.21087818034],
						[519089.96293668938, 643660.79278199677],
						[519061.65726082376, 643660.75995540887],
						[519061.79979966261, 643537.76027925778],
						[519002.10023720231, 643537.58059298946],
						[518986.93501958647, 643745.73371555388],
						[518988.36532146373, 643933.33245609677],
						[518988.20417428063, 644072.92407877103],
						[518771.2804104744, 644212.1563738113],
						[518771.06783177675, 644398.42628520576],
						[518554.81549021602, 644677.8076655498],
						[518510.70986131061, 644817.5714829166],
						[518424.15076351585, 644910.49900002475],
						[518207.19083582761, 645189.66359139443],
						[518077.46067603311, 645329.33433644299],
						[517990.08453069639, 645515.28842623415],
						[517946.70623170398, 645655.16570660134],
						[517903.43182518845, 645794.82208087039],
						[517816.00966336933, 646027.34535573144],
						[517772.63418606058, 646167.22343305114],
						[517729.31263247598, 646353.2273021338],
						[517815.35362324805, 646632.94959692331],
						[517902.36739262397, 646772.63765858999],
						[517945.33434477332, 646912.38876451505],
						[518031.62504612788, 647052.18752181681],
						[518055.0043919374, 647128.53626471909],
						[518074.59077233647, 647191.38608507707],
						[518087.92301990901, 647232.99132220692],
						[518118.37768220232, 647331.80250438838],
						[518118.22388403834, 647471.39637042827],
						[518117.81330824894, 647844.05271563795],
						[518030.60372132098, 647983.66185183451],
						[518006.954947069, 648060.40182325081],
						[517987.23190316343, 648123.20882105664],
						[517962.75778256479, 648202.27089291287],
						[517943.86069783603, 648262.86661130982],
						[517813.48710390448, 648355.97231113981],
						[517683.83552253118, 648448.8586332195],
						[517683.6852830319, 648588.56386078056],
						[517711.11723156186, 648627.64011693152],
						[517813.03320319351, 648774.97746995394],
						[517769.61485989066, 648961.2046574736],
						[517812.68007547816, 649100.95698549226],
						[517899.73097416037, 649194.52056744287],
						[518462.56717311492, 649195.14289466001]
					]
				]
			]
		}
	}, {
		"type": "Feature",
		"properties": {
			"name": "Kwai Tsing",
			"ID_0": 102,
			"ID_1": 5,
			"ISO": "HKG"
		},
		"geometry": {
			"type": "MultiPolygon",
			"coordinates": [
				[
					[
						[510308.22310991993, 650842.69404379569],
						[510308.24232029135, 650812.05366868258],
						[510422.03310834011, 650812.12540525361],
						[510422.05246065283, 650781.59564986289],
						[510678.75096093817, 650781.76037122903],
						[510736.88108188938, 650781.79822940903],
						[510736.90123549791, 650750.93663382018],
						[510765.0918973182, 650750.84445237054],
						[510765.11195899412, 650720.20409146231],
						[510822.41921313573, 650720.24171317136],
						[510822.43952722516, 650689.38012688153],
						[510937.05425025715, 650689.45596968825],
						[510937.07441156666, 650659.14746304392],
						[510994.38187852531, 650659.18568413018],
						[510994.4026632469, 650628.10287726263],
						[511022.69634938333, 650628.12182132504],
						[511022.71696511703, 650597.37086400273],
						[511050.90781781694, 650597.3897876374],
						[511050.92841192713, 650566.74944985332],
						[511103.60630775261, 650566.78494041879],
						[511108.25682710437, 650536.25834951003],
						[511123.99849315046, 650536.26899229223],
						[511137.37376494292, 650536.27804702963],
						[511137.38732697978, 650516.25674875127],
						[511137.70689615584, 650044.48472791794],
						[511108.58908739738, 650044.46502980916],
						[511108.67218971433, 649921.46157486644],
						[511137.79021629936, 649921.48127312248],
						[511137.83180142439, 649860.09018760966],
						[511166.02391825971, 649860.1093086215],
						[511166.06560863293, 649798.71824132989],
						[511194.36072201392, 649798.73748080095],
						[511194.38173298258, 649767.87603223952],
						[511223.39714003593, 649767.89581204788],
						[511223.43904437171, 649706.50477216311],
						[511251.73431643925, 649706.5241103624],
						[511251.75535926974, 649675.77329003206],
						[511280.77092885488, 649675.7931710839],
						[511280.81304714642, 649614.4021585607],
						[511309.1084777111, 649614.42159549403],
						[511309.21415161976, 649460.77822214412],
						[511280.91845665954, 649460.75878502673],
						[511280.93955373211, 649430.00800107082],
						[511309.23530160845, 649430.0274382222],
						[511309.25637551356, 649399.38727315306],
						[511338.27243282355, 649399.40725567774],
						[511338.31491758727, 649337.79509631719],
						[511366.6108241466, 649337.81463220809],
						[511366.63192837912, 649307.2850950443],
						[511394.92788744014, 649307.30467966199],
						[511394.97058423265, 649245.6925477084],
						[511423.98691276397, 649245.7126814893],
						[511424.00820024149, 649215.07254369394],
						[511481.32070051506, 649215.1124619965],
						[511481.34217202524, 649184.36171459628],
						[511509.53544745489, 649184.38142458722],
						[511509.55704911088, 649153.52006758237],
						[511531.57665589626, 649153.53549516713],
						[511566.86976392375, 649153.56028406648],
						[511566.95613392064, 649030.77858669334],
						[511537.93942610925, 649030.75820062519],
						[511537.98250275059, 648969.36737896735],
						[511509.68596215069, 648969.3475481777],
						[511509.70748635911, 648938.59683705564],
						[511481.5137895057, 648938.57712677005],
						[511481.53665122238, 648905.83536735037],
						[511481.59967540437, 648815.57432744571],
						[511452.47969035967, 648815.55402033799],
						[511452.58669834258, 648661.91123679141],
						[511481.70695547597, 648661.93154408887],
						[511481.79253232415, 648539.37136305904],
						[511509.98691364273, 648539.39107382041],
						[511510.0086700836, 648508.30858449452],
						[511567.32363378053, 648508.34880255628],
						[511567.36681865255, 648446.95813450566],
						[511595.664258209, 648446.97806455905],
						[511595.68594246078, 648416.22743043746],
						[511653.00122710731, 648416.26794712851],
						[511653.02278337884, 648385.84915890102],
						[511681.32032809313, 648385.86923635565],
						[511681.34232959338, 648354.89738383179],
						[511653.04473157862, 648354.87730634038],
						[511653.06660139124, 648324.01607209991],
						[511681.36425251223, 648324.03614962543],
						[511681.38593969459, 648293.50676112331],
						[511653.08823603723, 648293.48668355821],
						[511653.17540169036, 648170.48426467576],
						[511624.87748633133, 648170.4642356562],
						[511624.89930301462, 648139.60302854516],
						[511653.19727147982, 648139.62305760151],
						[511653.24077589496, 648078.23249790387],
						[511681.53884997073, 648078.2525757323],
						[511681.60430432367, 647986.11146322754],
						[511738.92108813848, 647986.15227938886],
						[511738.98694258119, 647893.90059408429],
						[511768.00565654947, 647893.92133493233],
						[511768.02750397485, 647863.39200919762],
						[511739.00873612904, 647863.37126831268],
						[511739.03076656297, 647832.51010655775],
						[511710.732269603, 647832.48992979422],
						[511710.79772892839, 647740.57015219354],
						[511681.77874435019, 647740.54951229435],
						[511681.80066720472, 647709.6883685143],
						[511625.20325053151, 647709.6482606522],
						[511625.2902042729, 647586.64618392824],
						[511596.27094807004, 647586.62569492555],
						[511596.3142383931, 647525.23529680003],
						[511625.33360292733, 647525.25578588201],
						[511625.42055659503, 647402.25381705491],
						[511653.71979392733, 647402.27384701208],
						[511653.74127170595, 647371.96581900842],
						[511568.12305759045, 647371.90536839201],
						[511568.14507786423, 647340.60182569141],
						[511539.12538747635, 647340.58143752429],
						[511539.18973026844, 647248.88310061186],
						[511510.89022897155, 647248.86326774315],
						[511510.9333544579, 647187.25174165575],
						[511482.73665476794, 647187.23202926852],
						[511482.82253995328, 647064.23025714734],
						[511453.69945343386, 647064.2099478757],
						[511453.74221005366, 647002.81970170024],
						[511396.52490765107, 647002.77995084447],
						[511396.54644745158, 646971.69768880645],
						[511368.24646916619, 646971.67810140725],
						[511368.28875360632, 646910.50910792116],
						[511310.96822064038, 646910.46958360274],
						[511310.98937036906, 646879.71917397063],
						[511253.66873008525, 646879.67984937469],
						[511253.71073948225, 646818.28965635621],
						[511225.4104972026, 646818.27031475503],
						[511225.45240094687, 646756.88013952156],
						[511196.4316804969, 646756.86035609338],
						[511196.49448655144, 646664.60920730769],
						[511168.1939798086, 646664.58996416861],
						[511168.27750950563, 646541.58849498769],
						[510997.13534621929, 646541.47316335619],
						[510997.09429534653, 646602.8632765956],
						[510968.07330311224, 646602.84389613883],
						[510968.05272118113, 646633.70487875759],
						[510939.75216125825, 646633.68602873292],
						[510939.7111771839, 646695.2973946787],
						[510910.69034806103, 646695.2781154851],
						[510910.67009384441, 646725.80727299443],
						[510882.36969241453, 646725.78852171497],
						[510882.34927114582, 646756.64952241327],
						[510825.02820190409, 646756.61169183848],
						[510824.98779291578, 646818.00186807197],
						[510767.66693752055, 646817.964237432],
						[510767.64694864443, 646848.49341287359],
						[510567.48742018663, 646848.36357679591],
						[510567.50703748816, 646817.83440111356],
						[510539.20679442614, 646817.81624036829],
						[510539.22643007833, 646787.17645613768],
						[510511.02918581915, 646786.93718396919],
						[510511.04869823786, 646756.40801710158],
						[510481.92506659357, 646756.38942875096],
						[510481.94473644526, 646725.52842756826],
						[510368.12566531787, 646725.45627644949],
						[510368.10620905319, 646756.31727777096],
						[510310.78513865656, 646756.28123959166],
						[510310.7659980047, 646786.81040669442],
						[510253.44489596528, 646786.99579423934],
						[510253.42579275521, 646817.63557880698],
						[510167.90760259476, 646817.58248234703],
						[510167.89809645875, 646832.95768282644],
						[510167.85063416034, 646909.72308903094],
						[510138.72727402748, 646909.70510845853],
						[510138.68956295744, 646970.87410493277],
						[510110.4924922692, 646970.85674538591],
						[510110.47338315222, 647001.93900901289],
						[510082.17345690948, 647001.92163475417],
						[510082.15460471617, 647032.67206381401],
						[509852.87417534617, 647032.53309655644],
						[509852.89259881451, 647001.78266723594],
						[509824.59267230181, 647001.76573622902],
						[509824.62934731814, 646940.37550400081],
						[509767.4118276657, 646940.34142122499],
						[509767.57613388088, 646663.69845160795],
						[509795.77373121632, 646663.7152231955],
						[509795.79204747203, 646632.96484755294],
						[509539.02877304872, 646632.81391213671],
						[509539.04667336307, 646601.95292784681],
						[509453.52736164327, 646601.90354623005],
						[509453.50962181133, 646632.76453061053],
						[509424.48868234211, 646632.74787404365],
						[509424.47106035374, 646663.49825009401],
						[509396.17055170698, 646663.48205633997],
						[509396.13547675032, 646724.87220902706],
						[509367.11469982041, 646724.85565370356],
						[509367.07973318972, 646786.24582430325],
						[509338.77931014489, 646786.4509551829],
						[509338.76191105368, 646817.09074076451],
						[509321.47303451248, 646817.080932162],
						[509310.46166671108, 646817.07469449658],
						[509309.7249537101, 646845.94426925655],
						[509281.42382261757, 646847.58746748266],
						[509281.40640545927, 646878.44848797424],
						[509253.10626670672, 646878.43254041194],
						[509253.08896489115, 646909.18295244873],
						[509224.0685132083, 646909.16664955136],
						[509224.0342042222, 646970.33564803388],
						[509195.73422359227, 646970.31979919993],
						[509195.71684339701, 647001.40206384659],
						[509166.69655444485, 647001.3858621926],
						[509166.67941406363, 647032.13629225246],
						[509138.37953978591, 647032.12054211553],
						[509138.34554924828, 647093.28957645979],
						[509110.14868845651, 647093.27393209259],
						[509110.13159243151, 647124.13498873776],
						[509081.00861200684, 647124.11888128868],
						[509080.95785435912, 647216.03839946422],
						[509110.08067200531, 647216.0545068254],
						[509110.01253296202, 647339.0563795924],
						[509138.20897233894, 647339.07202373294],
						[509138.15758692927, 647431.54470195062],
						[509166.45677385747, 647431.56045170513],
						[509166.42243136739, 647493.17205527169],
						[509195.44185248454, 647493.18825644406],
						[509195.39045397978, 647585.10793544375],
						[509223.68937665288, 647585.12378368876],
						[509223.65494347154, 647646.51420535485],
						[509252.67409399443, 647646.53050751577],
						[509252.65672988392, 647677.39164515224],
						[509280.95549374673, 647677.40759193851],
						[509280.92072172428, 647739.01926731644],
						[509309.21937953663, 647739.03526274161],
						[509309.92242518597, 647769.56498133868],
						[509338.22103043372, 647769.58102667192],
						[509338.16864446562, 647861.83266662888],
						[509309.87019797019, 647861.81662138633],
						[509309.13259138365, 647892.34554225765],
						[509280.83419739234, 647892.32954697963],
						[509280.81678015017, 647923.19072071312],
						[509223.4997768965, 647923.15847227012],
						[509223.5342101219, 647861.76796973159],
						[509195.23576351139, 647861.75212175294],
						[509195.25302007323, 647830.89095695876],
						[509166.23419488361, 647830.87475611782],
						[509166.21699277707, 647861.735920946],
						[509137.91854611278, 647861.720171605],
						[509137.86734496959, 647953.86123919836],
						[509166.16563307575, 647953.87698844867],
						[509166.14855427324, 647984.51694423298],
						[509252.48389767174, 647984.56529460452],
						[509252.44923162024, 648046.1770602162],
						[509195.13265703683, 648046.1449106487],
						[509195.14991361776, 648015.28371873091],
						[509137.83323135343, 648015.25176888029],
						[509137.76500408188, 648138.03288217448],
						[509109.56993459677, 648138.01723879576],
						[509109.53580365336, 648199.62904983445],
						[509137.73076750344, 648199.64469315077],
						[509137.71386433998, 648230.06345749774],
						[509166.01167714153, 648230.07920648751],
						[509165.96019403555, 648322.44166339678],
						[509137.6625401745, 648322.42591449758],
						[509137.61127745511, 648414.67779844836],
						[509308.8368474383, 648414.77383721422],
						[509308.8194396632, 648445.52447405213],
						[509280.52199761133, 648445.50847931521],
						[509280.50483003125, 648475.92727922928],
						[509223.18975334038, 648475.89503187127],
						[509223.17238157446, 648506.86690547992],
						[509165.85741272138, 648506.83485795197],
						[509165.84008725133, 648537.91735006508],
						[509023.01598193456, 648537.83835947944],
						[509022.99929060554, 648568.25717310549],
						[508851.77531881159, 648568.16411067266],
						[508851.75888467662, 648598.69354279176],
						[508737.12958699669, 648598.63223663066],
						[508737.113189361, 648629.4935150519],
						[508708.91896252742, 648629.47855862707],
						[508708.88633166102, 648691.09051524568],
						[508680.58931219182, 648691.07555289834],
						[508680.57862628618, 648711.31790528796],
						[508680.55684572842, 648752.57691376575],
						[508651.53964699263, 648752.56162119017],
						[508651.52340982633, 648783.42292243242],
						[508623.22654924594, 648783.4080587991],
						[508623.14609297313, 648936.82972099481],
						[508651.4426895408, 648936.84458449227],
						[508651.41050616151, 648998.01417550573],
						[508623.11401486001, 648997.99931206508],
						[508623.08158869203, 649059.8326058992],
						[508611.3514509481, 649059.82645862631],
						[508393.82942213427, 649059.71398083505],
						[508393.78249947337, 649151.63435022172],
						[508365.58916790312, 649151.61998246447],
						[508365.54223400011, 649243.87223518186],
						[508337.24616578466, 649243.85786367452],
						[508337.21492625587, 649305.47000249964],
						[508308.19870318146, 649305.45531579887],
						[508308.09010857978, 649520.37895195663],
						[508337.10595238896, 649520.39363846486],
						[508337.09030455892, 649551.25505372218],
						[508365.38584379322, 649551.26942495769],
						[508365.37031168333, 649581.79900152097],
						[508393.56290567672, 649581.81336889579],
						[508393.51581350417, 649674.06581218401],
						[508365.32337768719, 649674.05144488846],
						[508365.29203206854, 649735.66371103842],
						[508336.99681015138, 649735.64933996159],
						[508336.91907568194, 649888.96109064925],
						[508307.90388226975, 649888.94640446967],
						[508307.87275136838, 649950.55873448309],
						[508279.5778992477, 649950.54446221946],
						[508279.54698576406, 650011.93558128283],
						[508250.53200935904, 650011.92099634383],
						[508250.51652352075, 650042.78248470975],
						[508194.03002646414, 650042.75423754565],
						[508193.96883793391, 650165.53654875827],
						[508136.65965038131, 650165.50808851374],
						[508136.62237293244, 650240.83673177951],
						[508136.61416203738, 650257.42894763569],
						[508152.25320659199, 650257.43669430306],
						[508164.80559760524, 650257.44292278832],
						[508164.79878641234, 650271.15915554785],
						[508164.79005270818, 650288.74690695351],
						[508181.25217351096, 650288.75508996425],
						[508222.09881071188, 650288.77546524652],
						[508222.08354390872, 650319.30515042064],
						[508279.39219540131, 650319.33390841342],
						[508279.3767664819, 650349.97421285661],
						[508307.67093124078, 650349.98848477472],
						[508307.65539370128, 650380.73940856638],
						[508322.57410720864, 650380.74695335294],
						[508393.15505515115, 650380.78283149819],
						[508393.13930123468, 650411.64437463554],
						[508408.05798670411, 650411.65199698333],
						[508450.44751717796, 650411.89495855675],
						[508450.43995596771, 650426.60673521017],
						[508450.43193994905, 650442.20343189978],
						[508479.54904435057, 650442.21842265106],
						[508479.53312821378, 650473.07997485227],
						[508507.72419402277, 650473.09453796991],
						[508507.70845391089, 650503.51363512257],
						[508565.01646334713, 650503.5433886575],
						[508565.00021384889, 650534.73679468641],
						[508583.10827581317, 650534.74623767217],
						[508622.30811445392, 650534.76674791262],
						[508622.29210427782, 650565.29646894569],
						[508707.89369253506, 650565.3415825055],
						[508707.87746482831, 650595.98192291532],
						[508878.97743525001, 650596.0734313156],
						[508878.96082894906, 650626.8243910626],
						[508907.97472026304, 650626.84008495812],
						[508907.92473854462, 650719.09299156046],
						[508965.23199657415, 650719.1241400484],
						[508965.18175360298, 650811.26647257351],
						[509050.78206124902, 650811.31337132864],
						[509050.79886733164, 650780.78361443384],
						[509164.589871826, 650780.84664831683],
						[509164.60707417235, 650749.98505093507],
						[509193.62081000273, 650749.89063386084],
						[509193.70672287868, 650596.24640603107],
						[509222.00046384055, 650596.26225136989],
						[509222.01764965401, 650565.62191148405],
						[509279.32544260367, 650565.65415474074],
						[509279.3426727819, 650535.12443437055],
						[509393.9584711623, 650535.18952024973],
						[509393.94102816278, 650565.71924050094],
						[509422.23482165433, 650565.73543041141],
						[509422.21726272156, 650596.37577009329],
						[509565.02348841447, 650596.45822790009],
						[509565.00559900043, 650627.20918693033],
						[509594.01948963694, 650627.22609145381],
						[509594.00135232095, 650658.30889998109],
						[509622.29498647823, 650658.32543417159],
						[509622.2772488207, 650688.63394232839],
						[509679.58461300959, 650688.66758069105],
						[509679.56644410099, 650719.529168315],
						[509707.85997291259, 650719.54584974516],
						[509707.84188151715, 650750.18621187995],
						[510050.86162706016, 650750.50293947989],
						[510050.84276117588, 650781.36453589005],
						[510108.14980214846, 650781.39966801333],
						[510108.13103270793, 650811.92942376668],
						[510136.3215175292, 650811.94677926321],
						[510136.30262754491, 650842.58715457458],
						[510308.22310991993, 650842.69404379569]
					]
				],
				[
					[
						[514777.63526191167, 652683.54009186861],
						[514777.76064668037, 652544.05330489553],
						[514907.27919120481, 652544.17023964343],
						[514988.15803245571, 652522.5630310378],
						[515007.81186634849, 652517.27139084332],
						[515080.76771222812, 652497.75911422388],
						[515297.29126500082, 652637.66726814606],
						[515297.44637907972, 652470.968996668],
						[515297.551469567, 652358.03016520757],
						[515167.3370415041, 652218.53345022385],
						[514907.61721620557, 652171.39475904219],
						[514821.51387139247, 651938.36003975407],
						[514874.98518217559, 651852.57054086472],
						[514907.95483937883, 651799.06241799891],
						[515081.57958204352, 651612.72285531659],
						[515032.12334293622, 651580.93089869362],
						[514865.04048018716, 651473.03947071137],
						[514778.93265707116, 651240.22699592425],
						[514812.7444247813, 651166.58760844986],
						[514908.71474004356, 650961.04057654564],
						[514926.04856620659, 650906.74424288131],
						[514952.77348625631, 650821.15239422338],
						[514908.96850766049, 650681.18451612606],
						[514736.40951388719, 650588.00170503696],
						[514692.49868751096, 650448.58754330548],
						[514476.84614099341, 650215.66256196913],
						[514477.0400506804, 649995.42876576935],
						[514477.13315841864, 649889.68122997368],
						[514477.1621815362, 649856.71809698362],
						[514477.2565553232, 649749.53264365601],
						[514520.75881539535, 649423.70076427213],
						[514563.99480689398, 649284.25430722046],
						[514589.93061076343, 649277.08736939135],
						[514737.61993222072, 649237.50854385947],
						[514867.14574205264, 649144.5985482356],
						[514867.27195700078, 649005.00353723567],
						[514997.72660295642, 648911.87428326672],
						[515047.98997815332, 648857.60867929959],
						[515127.40228617628, 648772.28748393082],
						[515056.78132067475, 648696.00960444543],
						[515063.15548724309, 648589.71541133453],
						[515080.50154008088, 648525.35400239611],
						[515170.77411757695, 648493.02716415096],
						[515110.43208546814, 648427.70941540471],
						[515041.35144520964, 648353.20296584081],
						[514911.16413493233, 648259.83696738025],
						[514694.3298898536, 648399.34701559017],
						[514564.86118424183, 648306.09499551053],
						[514434.62982374395, 648259.41175992275],
						[514304.99640450248, 648352.54590646375],
						[514131.46645362891, 648398.85367269872],
						[514001.87559819594, 648445.31124870724],
						[513871.60446289834, 648445.20083953021],
						[513785.24662322307, 648352.10197787837],
						[513698.30946824362, 648212.10289793252],
						[513568.71827741934, 648258.67445976555],
						[513438.38090929872, 648211.88842598756],
						[513525.69111736817, 648026.12900838675],
						[513915.15293911664, 647932.98545040796],
						[513898.74913440691, 647861.18336714967],
						[513942.76233945752, 647774.61022843048],
						[513935.0262768133, 647674.71969411592],
						[513935.1111983775, 647574.50399635674],
						[514132.22672817734, 647514.16668640717],
						[514262.50523926754, 647514.27916029806],
						[514392.10426211852, 647467.71323176241],
						[514392.22643075802, 647328.1193344607],
						[514392.26224880299, 647287.19245660724],
						[514407.20043706766, 647268.18005748279],
						[514415.24820191605, 647126.82342709857],
						[514383.88179081515, 646985.65360082127],
						[514364.35547123017, 646955.43915992696],
						[514299.20024901489, 646852.84407588525],
						[514121.94083716522, 646669.84764975333],
						[513874.7932001783, 646495.09014784824],
						[513627.63325301325, 646328.85368006979],
						[513511.56039341161, 646187.61608585599],
						[513423.64573384781, 646093.52333940729],
						[513440.16954561189, 646023.18721548875],
						[513570.67796744721, 645883.70134273497],
						[513633.59727495705, 645714.07384477742],
						[513599.01756853872, 645713.60276618449],
						[513599.04262872844, 645683.29498330201],
						[513541.71781829395, 645683.24768370262],
						[513541.74322822044, 645652.38684344897],
						[513484.41831005341, 645652.33974356088],
						[513484.44352171995, 645621.58952001017],
						[513170.44234769238, 645621.33507185592],
						[513170.41772311507, 645652.08529588534],
						[513113.09280389926, 645652.03949025623],
						[513113.06819830474, 645682.90033116401],
						[513055.743386499, 645682.85472542734],
						[513055.71932749456, 645713.16250911716],
						[512998.39462116663, 645713.11710327002],
						[512998.36988101137, 645744.42040273594],
						[512970.06779076223, 645744.3980588424],
						[512970.04371508601, 645774.92707623821],
						[512912.71922403626, 645774.88196900894],
						[512912.6951679202, 645805.52160328906],
						[512884.49609913107, 645805.49948745675],
						[512884.47218220157, 645836.02851377497],
						[512827.14790412271, 645835.98370480374],
						[512827.1236622454, 645867.06579779205],
						[512797.99845565733, 645867.04310788785],
						[512797.97469919262, 645897.57214319904],
						[512741.4739614983, 645897.52827355126],
						[512741.45005282667, 645928.38915074593],
						[512712.42787037801, 645928.36669210927],
						[512712.40435815934, 645958.78512389143],
						[512655.08050795086, 645958.74091466842],
						[512655.05650595861, 645989.93363842275],
						[512626.75483820221, 645989.91188532102],
						[512626.73139942106, 646020.44093858718],
						[512569.407764117, 646020.39702797355],
						[512569.38434720517, 646051.03669825708],
						[512541.1856993704, 646051.01517106104],
						[512541.16225064284, 646081.76545836194],
						[512512.03742427006, 646081.74327487359],
						[512511.99071986502, 646143.1332503591],
						[512483.79222994077, 646143.11182157136],
						[512483.76880441938, 646173.97273493069],
						[512511.96724143234, 646173.99416367884],
						[512511.9439312981, 646204.63385626511],
						[512483.74554681964, 646204.61242755677],
						[512483.67560608161, 646296.75275735918],
						[512511.8738325719, 646296.77418594866],
						[512511.82712812332, 646358.16422379087],
						[512540.95146497985, 646358.18640691112],
						[512540.90448310383, 646419.79768794239],
						[512569.10249862634, 646419.81921465683],
						[512569.07908167294, 646450.45894274244],
						[512598.20317035133, 646450.59183999943],
						[512598.15605844109, 646512.09253499773],
						[512711.97660619084, 646512.18012001761],
						[512712.00046047079, 646481.31915769062],
						[512741.02166714991, 646481.34161557094],
						[512741.04540449363, 646450.70188326784],
						[512797.54424179823, 646450.74575143983],
						[512797.52039919095, 646481.38548365794],
						[512883.96654628974, 646481.45297992742],
						[512883.9423693135, 646512.31394200237],
						[512911.41984300449, 646512.33549130568],
						[512969.4621468609, 646512.38116208976],
						[512969.45124298107, 646526.20775940653],
						[512969.43807109608, 646542.91029017547],
						[513028.30356060347, 646542.95681791496],
						[513055.06060123123, 646542.97803653707],
						[513055.03610310046, 646573.83900733024],
						[513113.90148189949, 646573.88584145717],
						[513197.87726675003, 646573.95301846007],
						[513197.85276686942, 646604.48215507704],
						[513210.40794666007, 646604.49223552796],
						[513226.97666751954, 646604.50555308512],
						[513226.95184668124, 646635.36653259094],
						[513310.10402866924, 646635.43362051586],
						[513312.4460925567, 646666.18590737274],
						[513398.06798087026, 646666.25543955271],
						[513398.04283886921, 646697.11642779107],
						[513483.56165542157, 646697.18632124574],
						[513483.53662500699, 646727.71547521162],
						[513569.15819297649, 646727.78589814401],
						[513569.13272981782, 646758.64689509501],
						[513655.47450916033, 646758.71836181474],
						[513655.44915950904, 646789.24752439116],
						[513741.07022227655, 646789.54006819602],
						[513741.0446212549, 646820.17984802218],
						[513826.66570781934, 646820.25161162904],
						[513826.61409372633, 646881.64179732569],
						[513798.31396046357, 646881.61802815204],
						[513798.21075790637, 647004.6196793695],
						[513769.1904746237, 647004.59535591432],
						[513769.16472823912, 647035.34577997774],
						[513626.22466342204, 647035.22672159516],
						[513626.25014252739, 647004.47629731079],
						[513540.63001510198, 647004.40557712875],
						[513540.65560733585, 646973.32331816107],
						[513426.11788809189, 646973.22940976848],
						[513426.14263170405, 646942.92144618346],
						[513340.52218380937, 646942.85176783428],
						[513340.54721827101, 646911.99074356991],
						[513226.72943757044, 646911.89880823833],
						[513226.75416947738, 646881.14840128017],
						[513112.1128986883, 646881.05659708031],
						[513112.13750442339, 646850.1955814804],
						[513026.51657376601, 646850.12753795402],
						[513026.46777125547, 646911.73896093422],
						[512969.14724256354, 646911.69365703582],
						[512969.12290506059, 646942.55468186107],
						[512911.80248377979, 646942.50957783824],
						[512911.73014132713, 647034.650227468],
						[512883.53317998862, 647034.62811328704],
						[512883.46108214668, 647126.65819021605],
						[512854.33776033804, 647127.07785293309],
						[512854.28994784516, 647188.246904884],
						[512826.09324985952, 647188.2248891904],
						[512825.97367881751, 647341.53474323405],
						[512796.85108337563, 647341.51205536351],
						[512796.77912487608, 647433.98471986072],
						[512768.5828482341, 647433.9628027766],
						[512768.48751572007, 647556.74355666246],
						[512740.18854420632, 647556.72160836181],
						[512740.04551948223, 647741.33532760153],
						[512825.66181020514, 647741.40187965019],
						[512825.63799946354, 647771.93118605902],
						[512939.44982794754, 647772.02034544013],
						[512939.42571887455, 647802.66026957438],
						[513025.76201699593, 647802.72843022586],
						[513025.73765944189, 647833.47897217062],
						[513139.54906195402, 647833.56951642956],
						[513139.52440318454, 647864.43067619891],
						[513156.81217866275, 647864.44449864235],
						[513225.96328042611, 647864.49997015484],
						[513225.91390533769, 647925.89046249655],
						[513196.79234474117, 647925.86706636916],
						[513196.71840077604, 648018.00814548228],
						[513168.52312548907, 648017.98554266209],
						[513168.49841205205, 648048.84672950977],
						[513092.35073100362, 648048.78592710174],
						[513053.86528128741, 648048.75533138285],
						[513053.88977959112, 648017.8941443623],
						[512939.25643306144, 648017.80354516779],
						[512939.28062919178, 647987.05297606823],
						[512853.66561741347, 647986.98583247699],
						[512853.68956698279, 647956.3458812898],
						[512768.17729818384, 647956.27926321654],
						[512768.20117430593, 647925.52870287199],
						[512682.58584221191, 647925.46244997648],
						[512682.60964354326, 647894.601280506],
						[512653.59093077079, 647894.57892570179],
						[512653.49628372653, 648017.58117671835],
						[512625.19810524175, 648017.55942629615],
						[512625.15063276334, 648079.39241974219],
						[512625.12727867527, 648109.81116202427],
						[512596.93216079497, 648109.78953925264],
						[512596.92055219342, 648124.94360525848],
						[512596.83827515581, 648232.34946216026],
						[512567.71725727123, 648232.32718006533],
						[512567.69358649774, 648263.29901312746],
						[512539.49358650815, 648270.02492450783],
						[512539.42838485196, 648355.52933315095],
						[512510.30758510914, 648355.50715272431],
						[512510.28654686286, 648383.1605912355],
						[512510.21434358676, 648478.06721998274],
						[512482.01985711488, 648478.04579423985],
						[512482.0036521838, 648499.39426097786],
						[512481.94966372533, 648570.51896122692],
						[512452.82405112102, 648577.35494206473],
						[512452.78275372944, 648631.88758430211],
						[512424.58853099658, 648631.86625702691],
						[512424.57214973232, 648653.54658124386],
						[512424.5652963469, 648662.61692163709],
						[512396.26822787087, 648662.59556517052],
						[512396.22178100143, 648724.20752198738],
						[512367.20453219645, 648724.18567255943],
						[512367.1581940357, 648785.7976476287],
						[512338.86133753892, 648785.77638995554],
						[512338.78738269565, 648884.33346520085],
						[512338.76937123941, 648908.3367105521],
						[512309.75244735827, 648908.3149625035],
						[512309.74267614144, 648921.36741967627],
						[512309.70632390794, 648969.92699208914],
						[512281.40978426725, 648969.90583327739],
						[512281.36393205909, 649031.29665292415],
						[512253.06749802758, 649031.2755428846],
						[512253.04450110102, 649062.13688070525],
						[512195.83436355536, 649062.09434887697],
						[512195.85725310922, 649031.23301097692],
						[512166.73764997395, 649031.21143898275],
						[512166.76056671346, 649000.23949152045],
						[512138.56697555626, 649000.2186546576],
						[512138.58943091112, 648969.79978211632],
						[512081.27607559244, 648969.75757290528],
						[512081.29866873287, 648939.00686255086],
						[512053.00207588106, 648938.98609679402],
						[512052.97953566187, 648969.73680718814],
						[512023.96272013226, 648969.71556345921],
						[512023.94047682598, 649000.13443615346],
						[511938.3307395163, 649000.0720581268],
						[511938.30825303186, 649031.04400590633],
						[511910.01181856479, 649031.02348621679],
						[511909.98946550017, 649061.88482451334],
						[511880.97281257599, 649061.86383311136],
						[511880.9507537327, 649092.39333358628],
						[511852.65442483861, 649092.37291259947],
						[511852.63217933202, 649123.23426005896],
						[511823.61563467217, 649123.21336987219],
						[511823.59368223301, 649153.74287941668],
						[511795.40035427298, 649153.72263094655],
						[511795.37821613136, 649184.5839875692],
						[511767.08204588474, 649184.56371383916],
						[511767.06004000548, 649215.31446086266],
						[511738.04365783522, 649215.29372167995],
						[511737.89015438, 649430.32784960081],
						[511709.59440701868, 649430.30767479725],
						[511709.48507092474, 649583.84040842205],
						[511737.78055407957, 649583.86058303295],
						[511737.75852346094, 649614.72200350487],
						[511766.77420077956, 649614.74274218048],
						[511766.73026808747, 649676.13375343755],
						[511795.02559242205, 649676.15402656142],
						[511794.98139537545, 649737.76628483145],
						[511766.68617706752, 649737.74601178407],
						[511766.5323729263, 649952.67006502161],
						[511737.51729192893, 649952.64932677371],
						[511737.49526127119, 649983.51080202265],
						[511709.20046585356, 649983.49062789883],
						[511709.15674706484, 650044.88174831052],
						[511680.14182879293, 650044.86111130891],
						[511680.09821832128, 650106.25224996719],
						[511651.80363412446, 650106.23217461421],
						[511651.73833767098, 650198.37422414531],
						[511623.44391200208, 650198.35419759573],
						[511623.40066918172, 650259.52415233117],
						[511594.38612967893, 650259.50366665656],
						[511594.36405522533, 650290.80764689879],
						[511537.05530428438, 650290.76733457844],
						[511537.07726962538, 650259.46335425973],
						[511508.78294908302, 650259.44352502783],
						[511508.80416372186, 650229.13508211391],
						[511451.49519782304, 650229.0950680091],
						[511451.40968324675, 650351.87747391383],
						[511394.20403302758, 650351.83773115312],
						[511394.14017912705, 650443.97989099717],
						[511423.15439309395, 650444.000023311],
						[511423.13295178651, 650474.8615721669],
						[511451.32401454035, 650474.88118235336],
						[511451.24836101755, 650583.50502162264],
						[511483.46254620911, 650568.1520064387],
						[511489.7197621204, 650595.14643530454],
						[511510.19530486863, 650593.50153171876],
						[511617.68410402699, 650632.40299907071],
						[511790.26027724257, 650725.55309802608],
						[511920.54878563422, 650818.67433753831],
						[511991.92842365225, 650849.58786509174],
						[512137.15579282463, 650911.86014674767],
						[512309.72609119635, 651005.01582379302],
						[512360.68459098443, 651100.62562797277],
						[512482.94062715798, 651331.12973592873],
						[512533.91414071439, 651404.39592194802],
						[512596.60273035977, 651494.48481687834],
						[512613.148873289, 651517.50552442111],
						[512742.42807867751, 651704.10302606178],
						[512872.77627587138, 651704.20457017142],
						[513002.30143707962, 651704.30649680214],
						[513175.75609967444, 651704.44459094806],
						[513264.40743851743, 651742.56764634897],
						[513294.23201843287, 651755.42314852076],
						[513392.34423708176, 651797.75795135961],
						[513981.01679178566, 651798.24801923241],
						[513991.89106742793, 651834.53920804546],
						[513971.42644655058, 651945.91181746742],
						[513954.89368739916, 652031.07190818002],
						[513954.7752883932, 652170.55835266039],
						[513954.65651373542, 652310.48735536728],
						[513969.5527037232, 652334.94612831634],
						[514041.67310590035, 652449.93756695068],
						[514084.6575452839, 652590.1248644751],
						[514041.4340728721, 652729.79604813876],
						[513867.9509435033, 652776.21819447109],
						[513867.83308976999, 652915.92637936212],
						[513985.49172024644, 652947.44107347413],
						[514000.40452505427, 652951.65718549653],
						[514041.2353823242, 652962.42178847489],
						[514110.24603442027, 652981.28564589017],
						[514170.72040451173, 652997.59825939033],
						[514213.81343853613, 653009.25017423136],
						[514344.1512879337, 653009.36338405509],
						[514372.33133221016, 653017.02052227373],
						[514405.34503350221, 653026.11995615065],
						[514483.81328676583, 653051.63065826939],
						[514572.43118736194, 653115.86645760085],
						[514603.77703300625, 653149.30041991582],
						[514777.21645029931, 653149.4554101273],
						[514863.6088885364, 653056.39431767946],
						[514847.98789215769, 653039.34528600797],
						[514777.38399494311, 652963.06703211938],
						[514739.02062546054, 652839.69546943216],
						[514739.04978262755, 652807.17432947666],
						[514750.9136673428, 652769.79669744766],
						[514760.30269574159, 652739.05382835912],
						[514768.24746138713, 652712.84493389388],
						[514777.63526191167, 652683.54009186861]
					]
				]
			]
		}
	}, {
		"type": "Feature",
		"properties": {
			"name": "Kwun Tong",
			"ID_0": 102,
			"ID_1": 6,
			"ISO": "HKG"
		},
		"geometry": {
			"type": "MultiPolygon",
			"coordinates": [
				[
					[
						[522926.9499669536, 647524.07635493646],
						[523186.8893968027, 647524.44081059925],
						[523403.54237296234, 647571.2053673187],
						[523532.9971898137, 647571.39011192333],
						[523577.24093635316, 647431.74871627416],
						[523620.55926785956, 647292.10620212858],
						[523837.82142949651, 646919.87433834013],
						[523881.31384339853, 646733.66500480741],
						[523968.13082698447, 646407.81493801356],
						[524098.62281179923, 646268.30162868649],
						[524271.41443170857, 646268.55573015311],
						[524488.255014161, 646129.283872406],
						[524618.78715811833, 646036.12163137039],
						[524792.30162146373, 646036.38228395954],
						[524878.43552584213, 646176.4374402843],
						[525008.89836155728, 646130.06734706089],
						[524965.20466071693, 645897.05068167194],
						[524922.29466602637, 645757.28192405147],
						[524705.9022096718, 645524.00557162834],
						[524879.49218521966, 645477.92065336998],
						[525009.8897457897, 645478.1184253603],
						[525182.87195737788, 645292.11119360849],
						[525096.73565032845, 645152.27624976856],
						[525053.72222546919, 645012.2862579237],
						[524880.40812119911, 644872.43068312958],
						[524837.49503959843, 644732.44159591605],
						[524707.16118696856, 644685.89887232787],
						[524620.94794040825, 644592.63432847965],
						[524664.38530249533, 644453.10720128927],
						[524707.72097085021, 644313.24829075125],
						[524881.32371992851, 644267.16365489201],
						[524924.76431032864, 644127.52681659884],
						[525055.14075375895, 644081.04677074286],
						[525055.35338925244, 643941.45521701081],
						[525055.56653007725, 643801.53192038136],
						[525185.36802465271, 643661.91723511636],
						[525185.5815901194, 643522.43656704354],
						[525229.02705090912, 643382.5797955998],
						[525229.24115232984, 643242.98869844631],
						[525099.64932948467, 643242.79044390656],
						[524882.7324184021, 643335.9273928504],
						[524796.58326462819, 643196.09529761656],
						[524883.08480122057, 643102.98069455463],
						[524796.86405893019, 643009.82652697596],
						[524840.37787412829, 642823.40192465624],
						[524926.88144462253, 642730.39832390565],
						[524753.6821389962, 642497.52203682135],
						[524884.14127809706, 642404.58455260599],
						[524927.6576622976, 642218.16070403811],
						[525068.21435741102, 642256.20316290471],
						[525068.26222808531, 642224.78979113488],
						[525010.925362963, 642224.70251560095],
						[525010.97228327545, 642193.84220042615],
						[524982.66408300237, 642193.79918468045],
						[524982.71044625482, 642163.27070510364],
						[524868.03628686303, 642163.09695026337],
						[524867.99013642583, 642193.62543016579],
						[524725.00798770133, 642193.4099026816],
						[524724.96160385781, 642224.27021866373],
						[524610.39080841956, 642224.09841459594],
						[524610.34513594117, 642254.62690387375],
						[524553.00837482023, 642254.54122440901],
						[524552.96231346391, 642285.40154963615],
						[524439.00957382424, 642285.23186106258],
						[524438.96421921684, 642315.76035948086],
						[524409.93566171871, 642315.71725881798],
						[524409.84423956659, 642377.32732144359],
						[524381.5363550483, 642377.28534014942],
						[524381.49061500106, 642408.14568340522],
						[524353.28572108236, 642408.1039032978],
						[524352.92186131421, 642653.88070181117],
						[524380.40578160854, 642653.92141333874],
						[524381.08141343505, 642684.22981058201],
						[524352.87699289015, 642684.18803117145],
						[524352.83065067674, 642715.49086122203],
						[524323.69986291858, 642715.44776034378],
						[524323.65472103795, 642745.97631989792],
						[524295.45040636428, 642745.93463895505],
						[524295.40515345056, 642776.57381365413],
						[524238.07021157834, 642776.48923190683],
						[524238.02522843622, 642807.01780035195],
						[524209.71808335005, 642806.97611472989],
						[524209.67201318988, 642838.27896302997],
						[524180.64437775523, 642838.23626698693],
						[524180.59982620156, 642868.54362275137],
						[524152.2927869921, 642868.5020359453],
						[524152.24747555167, 642899.36245010048],
						[524123.21994790819, 642899.31985539431],
						[524123.17550197948, 642929.62721991388],
						[524094.86856788304, 642929.58573192963],
						[524094.82271590753, 642960.88859837456],
						[524065.79529683763, 642960.84610500257],
						[524065.75063288043, 642991.3747000586],
						[524037.44380504475, 642991.33331089036],
						[524037.39903197659, 643021.97252122196],
						[523980.06494544295, 643021.88883875823],
						[523980.0201179125, 643052.63866449823],
						[523951.81632903568, 643052.59757274401],
						[523951.77139316424, 643083.45801385574],
						[523923.46472378878, 643083.41682083253],
						[523922.59685840766, 643113.94423606386],
						[523894.39317464619, 643113.90324276325],
						[523894.34834632336, 643144.76369283115],
						[523866.04178244574, 643144.72259862407],
						[523865.95239248185, 643206.33290121017],
						[523836.92540653457, 643206.29081171588],
						[523836.88116662554, 643236.81944223447],
						[523808.57476116193, 643236.77844691707],
						[523808.4859060999, 643298.16755415709],
						[523779.45908220886, 643298.12556606776],
						[523779.37033545057, 643359.51469098229],
						[523751.06414112693, 643359.47379463399],
						[523751.01958098618, 643390.33428034559],
						[523722.81637112325, 643390.29358123278],
						[523722.72751617694, 643451.90395499009],
						[523693.59803253761, 643451.86196997121],
						[523693.50992398727, 643513.02991701872],
						[523665.30660621828, 643513.21053877822],
						[523665.26268394338, 643543.73921336979],
						[523640.14765099395, 643543.70309894346],
						[523636.0890178869, 643574.55784260528],
						[523615.70882442349, 643574.52856985235],
						[523607.88612389204, 643574.51734054973],
						[523607.84230801096, 643605.04602402111],
						[523577.99258501909, 643605.00320963492],
						[523550.51025377813, 643604.96383876796],
						[523550.46606919647, 643635.82436031871],
						[523539.4525713285, 643635.80859539914],
						[523522.16035036003, 643635.78385787492],
						[523522.14010366081, 643649.94209150632],
						[523522.11637705576, 643666.53377272421],
						[523500.91285999183, 643666.50346468412],
						[523493.09020320047, 643666.49228997994],
						[523493.04675809969, 643696.91037562117],
						[523464.74114438437, 643696.8699719935],
						[523464.69696266111, 643727.84111824608],
						[523435.65939243603, 643735.87435785006],
						[523435.62692751247, 643758.66027636151],
						[523379.11884165474, 643758.57986172778],
						[523379.07544983632, 643789.10857202543],
						[523349.94656336139, 643789.06719558057],
						[523349.90275453863, 643819.92774417857],
						[523321.70028125175, 643819.88773281558],
						[523321.65683899866, 643850.52706330852],
						[523294.17476133344, 643850.59873203374],
						[523292.4845166537, 643881.23573482444],
						[523264.28214848367, 643881.19582190935],
						[523264.23865656828, 643911.94577266579],
						[523206.907672039, 643911.86478504492],
						[523206.86475547473, 643942.28290629294],
						[523178.55956400733, 643942.24299513688],
						[523178.51592043182, 643973.21417764493],
						[523151.03420439479, 643973.17547422182],
						[523149.44685451267, 644004.03387690196],
						[523121.14176930935, 644003.9940645562],
						[523121.09870012361, 644034.63342192932],
						[523063.7681432268, 644034.5529332211],
						[523063.72533592739, 644065.08168370568],
						[523035.5232829795, 644065.04216302128],
						[523035.47959856322, 644096.23458656308],
						[523006.35125597974, 644096.19381859037],
						[523006.30870979209, 644126.61196656828],
						[522978.10676233954, 644126.57254432887],
						[522978.06365020754, 644157.43314258265],
						[522949.75882897736, 644157.39362516126],
						[522949.71654161083, 644187.70117050223],
						[522920.69128743908, 644187.66069783899],
						[522920.6478204428, 644218.85313957091],
						[522892.34310491249, 644218.81372094853],
						[522892.30015342636, 644249.67433274724],
						[522863.27500861575, 644249.63396140398],
						[522863.1473937775, 644341.44154274289],
						[522834.84288920189, 644341.4022230726],
						[522834.80019882374, 644372.15224113106],
						[522806.49574709398, 644372.11297023855],
						[522805.72343197331, 644409.49868990097],
						[522805.68984452006, 644433.72263239382],
						[522749.08115290629, 644433.64423951413],
						[522749.03846961691, 644464.50488270773],
						[522720.01370390621, 644464.46476417012],
						[522719.97153344256, 644494.9935769462],
						[522691.66729310685, 644494.95450366312],
						[522691.58259943104, 644556.3439774859],
						[522634.35678508063, 644556.26512748946],
						[522634.31431670318, 644587.12578870892],
						[522606.01023491315, 644587.08686282707],
						[522605.92586043029, 644648.4763636007],
						[522576.90141936659, 644648.43649760808],
						[522576.85921036807, 644679.18656056398],
						[522548.55528699805, 644679.14773355203],
						[522548.5969881597, 644648.72950570716],
						[522519.57300187665, 644648.35790569417],
						[522519.53090005874, 644679.10796879721],
						[522491.22697655356, 644679.06924043433],
						[522491.14302998193, 644740.45876828907],
						[522462.83921205479, 644740.42008878326],
						[522462.79706498364, 644771.28077709512],
						[522405.46907567192, 644771.20258288702],
						[522405.42748819507, 644801.73144037917],
						[522376.40331757342, 644801.69192819786],
						[522376.31979889871, 644863.08149195963],
						[522348.01619198552, 644863.04301004345],
						[522347.8490652616, 644986.04341467796],
						[522319.64859138802, 644986.00512142631],
						[522319.56528353866, 645047.3947385631],
						[522290.54154642724, 645047.35537789855],
						[522290.49972179736, 645078.21611110494],
						[522262.1964851009, 645078.17777687323],
						[522255.87670251232, 645108.91940603778],
						[522204.8280508474, 645108.85040778527],
						[522204.78668554389, 645139.48992615822],
						[522119.15684823744, 645139.37454316276],
						[522119.11549369048, 645170.12467816786],
						[522032.7653738769, 645170.00877608429],
						[522032.72432894097, 645200.64830372506],
						[521976.94163761538, 645200.57367131684],
						[521976.18010947504, 645231.32285289292],
						[521943.14282072638, 645231.27874251991],
						[521603.91881649016, 645230.82966000843],
						[521603.8381787996, 645292.21935155964],
						[521575.63822989207, 645292.18233398616],
						[521575.56814489502, 645345.60797197523],
						[521575.43639085034, 645446.04378324479],
						[521547.13378712774, 645446.00667952187],
						[521547.09379106626, 645476.5356360341],
						[521518.07081124006, 645476.49763850833],
						[521518.05358978623, 645489.66048708162],
						[521555.70848997956, 645499.7755211289],
						[521629.47481667169, 645519.67198240501],
						[521542.88239732326, 645705.9402756514],
						[521456.41344030836, 645799.07357934839],
						[521369.12242306897, 645891.98508407071],
						[521239.37119480717, 646031.4101209793],
						[520984.65563077503, 646273.98864860146],
						[520848.64548801619, 646403.56448437378],
						[520943.50348846184, 646506.00191004283],
						[521065.08096963924, 646636.79105282063],
						[521064.80426393845, 646852.81792135164],
						[521063.82849507616, 647614.61028900626],
						[521194.16622765886, 647568.20948556438],
						[521323.72397344117, 647568.37697118579],
						[521497.22227112309, 647568.60285957973],
						[521713.81765719672, 647662.13459129189],
						[521823.87693744077, 647543.92386631109],
						[521887.56303547445, 647475.98125062301],
						[522017.24635090143, 647382.90728307376],
						[522147.52590159926, 647383.08222333854],
						[522320.24245331087, 647429.99458369589],
						[522580.01652273652, 647476.9174623884],
						[522796.67153320782, 647523.89523994923],
						[522914.39548920147, 647524.05885658483],
						[522926.9499669536, 647524.07635493646]
					]
				]
			]
		}
	}, {
		"type": "Feature",
		"properties": {
			"name": "North",
			"ID_0": 102,
			"ID_1": 7,
			"ISO": "HKG"
		},
		"geometry": {
			"type": "MultiPolygon",
			"coordinates": [
				[
					[
						[529425.14600469568, 668258.03520109202],
						[529425.20209342637, 668226.72842449427],
						[529453.36271897366, 668226.778900826],
						[529453.41707592923, 668196.46775112185],
						[529596.17320990039, 668196.72437622619],
						[529596.22882702621, 668165.86010881665],
						[529653.47527423466, 668165.96336626494],
						[529653.69697458553, 668043.17009488714],
						[529625.43325706886, 668043.11908967549],
						[529625.48832999903, 668012.58672094299],
						[529368.33940712223, 668012.124899716],
						[529368.28481222852, 668042.65726931242],
						[529311.037935236, 668042.55500589649],
						[529310.98324932926, 668073.19800515438],
						[529282.71958348923, 668073.14758970356],
						[529282.50026177685, 668196.16213517543],
						[529253.51737415476, 668196.11048732093],
						[529253.46338612156, 668226.42163768783],
						[529282.44622025103, 668226.47328544618],
						[529282.3904036365, 668257.78006252833],
						[529425.14600469568, 668258.03520109202]
					]
				],
				[
					[
						[532875.56449143204, 670046.64687284327],
						[532875.74896747037, 669954.49571827019],
						[532904.72875214601, 669954.55375809409],
						[532904.856868712, 669890.61216743418],
						[532904.97478910652, 669831.75937311444],
						[532933.2354286419, 669831.8160219111],
						[532933.3585527197, 669770.41885971581],
						[532961.61929781141, 669770.47555735824],
						[532961.74297157, 669708.8571645075],
						[532990.72318971844, 669708.91535608331],
						[532990.84697217145, 669647.2969836375],
						[533019.10792913451, 669647.35378020653],
						[533019.60148091021, 669401.87612059724],
						[532962.35934145038, 669401.76113051223],
						[532962.42195533984, 669370.56480351079],
						[532905.89908868901, 669370.45145409484],
						[532906.39116091956, 669124.8635265606],
						[532877.4099121287, 669124.80548379943],
						[532877.84087070846, 668909.52912134689],
						[532906.82249938708, 668909.58716486429],
						[532906.94551720354, 668848.19030301762],
						[532935.20784931292, 668848.24695520755],
						[532935.33097274404, 668786.85011353076],
						[532963.59341040661, 668786.90681456926],
						[532963.65469188406, 668756.37433867622],
						[532992.63659082993, 668756.4325336311],
						[532992.76037266012, 668694.81447252957],
						[533021.02296870458, 668694.87127239536],
						[533021.14641168865, 668633.4744812611],
						[533050.12852750975, 668633.53277766623],
						[533050.19063708, 668602.66845247173],
						[532963.96354149457, 668602.495160277],
						[532964.14805181907, 668510.56596249202],
						[532935.88513861597, 668510.50926049892],
						[532935.94703299343, 668479.64495491353],
						[532898.3315940327, 668479.56956501736],
						[532878.70167909935, 668479.53025641339],
						[532878.76324443112, 668448.7765803705],
						[532736.00930113625, 668448.49142349057],
						[532735.94800310943, 668479.24510006607],
						[532707.78781043482, 668479.18899544189],
						[532707.7263448236, 668510.05330188549],
						[532735.8864845786, 668510.1094064021],
						[532735.8256275265, 668540.64184343372],
						[532707.6655401208, 668540.5857390248],
						[532707.54326976847, 668601.98250253696],
						[532678.56109827524, 668601.92481067521],
						[532678.49968708889, 668632.78913726623],
						[532592.99216390669, 668632.61922417488],
						[532593.05341440137, 668601.75489726383],
						[532479.38574673852, 668601.52971602487],
						[532479.32470985258, 668632.39404336363],
						[532420.43551288254, 668632.27769033238],
						[532392.99499687133, 668632.22354559554],
						[532392.93717685388, 668661.53913029551],
						[532364.77489874815, 668662.70048722287],
						[532364.71734698489, 668691.90545188601],
						[532364.65347323532, 668724.31854294846],
						[532307.40897215693, 668724.20583568828],
						[532307.35152216349, 668753.41081007244],
						[532250.10386406723, 668754.9576762314],
						[532250.0439091255, 668785.49015475856],
						[532221.78146902751, 668785.43468162871],
						[532221.7209155017, 668816.29904003954],
						[532210.7242776294, 668816.27746913594],
						[532192.73912220448, 668816.24220548454],
						[532192.67927366169, 668846.77469414624],
						[532164.41693902377, 668846.71931973333],
						[532164.35649306129, 668877.58368838916],
						[532096.93810474512, 668877.4517918831],
						[532078.95301630744, 668877.4166528401],
						[532078.89337906265, 668907.94915184029],
						[532049.80897574697, 668907.8923687709],
						[532049.7487449164, 668938.756747887],
						[531993.32716367184, 668938.64673982607],
						[531993.26725436805, 668969.40049915481],
						[531936.02360752365, 668969.28908635746],
						[531935.96445074794, 668999.71097572462],
						[531878.7209095523, 668999.59976265556],
						[531878.66078515188, 669030.57478253357],
						[531736.01466977061, 669030.29851695523],
						[531735.89602786105, 669091.69544741558],
						[531650.39089392242, 669091.53044183739],
						[531649.85812350316, 669367.98281702492],
						[531620.87730373361, 669367.92699161055],
						[531620.58080986037, 669521.91744667036],
						[531649.56135788781, 669521.97327156365],
						[531649.50187681883, 669552.83775282116],
						[531620.52138325502, 669552.78192803275],
						[531620.46280863625, 669583.20391282265],
						[531649.44324851839, 669583.25973750907],
						[531649.38440701191, 669613.79235254391],
						[531677.64542163454, 669613.84684065997],
						[531677.5265665882, 669675.46521269495],
						[531705.68470814347, 669675.51955083513],
						[531705.56574740913, 669737.13794285315],
						[531734.64868219919, 669737.19411630335],
						[531734.5300398455, 669798.59127723519],
						[531791.77079616173, 669798.70198772103],
						[531791.82990310842, 669768.16934322577],
						[531819.9878857166, 669768.22387735231],
						[531820.04768804193, 669737.3593614283],
						[531877.28865777887, 669737.47036998521],
						[531877.34835294168, 669706.71648481325],
						[531934.58942948142, 669706.82769309264],
						[531934.64944694878, 669675.96318769967],
						[532020.15153812652, 669676.12967322161],
						[532020.21150057518, 669645.37579864869],
						[532077.45279091957, 669645.48750487179],
						[532077.51307663287, 669614.62301012047],
						[532105.67132250569, 669614.67803407589],
						[532105.7904858659, 669553.72343764163],
						[532134.87374547613, 669553.78031984717],
						[532134.99474845221, 669491.94074058952],
						[532163.15320467344, 669491.9958631061],
						[532163.2130008766, 669461.46326985012],
						[532191.47427763359, 669461.51864218689],
						[532191.59440877847, 669400.2322201503],
						[532220.57517154235, 669400.28905268572],
						[532220.64744532376, 669363.45083400118],
						[532220.69627895101, 669338.56014978269],
						[532248.95776720822, 669338.61562104034],
						[532249.07854634698, 669277.10798900807],
						[532278.05952638073, 669277.16492298536],
						[532278.18019659445, 669215.7679364254],
						[532306.44189615699, 669215.82350660674],
						[532306.56267198618, 669154.42654025636],
						[532363.80567353335, 669154.53924456518],
						[532363.86627743253, 669123.78545653238],
						[532506.51158080238, 669124.06717535993],
						[532506.45070978708, 669154.82096286584],
						[532563.69370995695, 669154.93436388357],
						[532563.63295108685, 669185.57753103273],
						[532591.89470260078, 669185.63359243353],
						[532591.71182865743, 669277.78437387804],
						[532620.69280749699, 669277.84191247809],
						[532620.57063658908, 669339.34954176284],
						[532648.83212348726, 669339.40570114413],
						[532648.64892820292, 669431.55655709933],
						[532676.91025642422, 669431.61276480253],
						[532676.72646224941, 669523.98491625686],
						[532648.4652929852, 669523.9287088766],
						[532648.28275729204, 669615.7477789151],
						[532620.02174593916, 669615.6916204798],
						[532619.77696417982, 669738.92837089451],
						[532590.79679899709, 669738.87083390891],
						[532590.55311269686, 669861.66516329302],
						[532619.53306119051, 669861.7226998508],
						[532619.34980424412, 669953.98443764145],
						[532647.61023344914, 669954.0405949211],
						[532647.54909485579, 669984.79451748729],
						[532675.80947103875, 669984.85072329268],
						[532675.74849963002, 670015.49402513669],
						[532704.72817666782, 670015.55171203031],
						[532704.66693086561, 670046.30564443651],
						[532875.56449143204, 670046.64687284327]
					]
				],
				[
					[
						[523226.86322894553, 670337.37439365673],
						[523226.9064136761, 670306.84163254907],
						[523255.06347268936, 670306.88148134016],
						[523255.15073011111, 670245.26284468523],
						[523284.23276507802, 670245.30405321333],
						[523284.27621306258, 670214.66068137647],
						[523312.43343012966, 670214.70062853035],
						[523312.47708768432, 670183.94663591171],
						[523284.3198178868, 670183.90668868413],
						[523284.4068706684, 670122.50934424275],
						[523312.56424573855, 670122.54929162329],
						[523312.60806031601, 670091.68468829803],
						[523255.36832524481, 670091.6035319278],
						[523255.45526925457, 670030.20621751889],
						[523227.29773585661, 670030.16636805655],
						[523227.38394870184, 669969.21157652524],
						[523170.14441107248, 669968.68821424688],
						[523170.18748929654, 669938.15551296645],
						[523112.94753048784, 669937.85360155615],
						[523112.99065797945, 669907.21027942607],
						[523084.73045921128, 669906.94927836501],
						[523084.77337845741, 669876.41658687638],
						[522885.61348374881, 669876.13783872547],
						[522884.85157632775, 669906.66952828481],
						[522856.59106562135, 669906.63017122599],
						[522856.505305584, 669968.24869898683],
						[522827.52554508683, 669968.20839077071],
						[522827.48295008618, 669998.8517236698],
						[522799.22259801277, 669998.81246533641],
						[522799.17990215408, 670029.56642908661],
						[522770.20024986006, 670029.52622202889],
						[522770.11512005155, 670090.92353897844],
						[522741.85492641845, 670090.88437936478],
						[522741.76959584258, 670152.50296825019],
						[522799.00911865459, 670152.58233447676],
						[522798.96657634078, 670183.22569755011],
						[522969.86271259381, 670183.46384290897],
						[522969.81969665631, 670214.21783643402],
						[522998.90178660024, 670214.25853966794],
						[522998.8588711202, 670244.90191225836],
						[523055.995308496, 670244.98203028529],
						[523055.95213107998, 670275.73603365314],
						[523141.45109975385, 670275.85629358259],
						[523141.4076063215, 670306.72092770226],
						[523198.64659160451, 670306.80168686248],
						[523198.60345941613, 670337.33444804943],
						[523226.86322894553, 670337.37439365673]
					]
				],
				[
					[
						[531703.96393837035, 670566.83100721007],
						[531704.02352579415, 670535.9663594804],
						[531761.26171198778, 670536.07696363272],
						[531761.32076509867, 670505.54419904388],
						[531818.55905732827, 670505.65500290459],
						[531818.61885988864, 670474.79036571155],
						[531847.70048836851, 670474.84673936013],
						[531847.76013103535, 670444.09273326467],
						[531875.91695470922, 670444.14736328705],
						[531876.03613074427, 670382.74999232241],
						[531904.29582210747, 670382.80487047124],
						[531904.35535547778, 670352.16150555969],
						[531876.09604084399, 670351.88537559682],
						[531876.15530674427, 670321.35264146549],
						[531818.91637212585, 670321.24163685425],
						[531818.97617462603, 670290.37703002244],
						[531761.73713204393, 670290.26622471435],
						[531761.79661299801, 670259.51224856079],
						[531733.63947275083, 670259.45781420486],
						[531733.69868719531, 670228.81446878344],
						[531704.61662301363, 670228.75829701847],
						[531704.67599675665, 670198.00433071912],
						[531676.51875104744, 670197.94999430678],
						[531676.57785866526, 670167.30665870558],
						[531648.31779646268, 670167.25217242492],
						[531648.37706452899, 670136.49821599096],
						[531591.13748560473, 670136.38800530427],
						[531591.25559451885, 670074.99073283852],
						[531534.01580120798, 670074.88072124834],
						[531534.07506728545, 670044.01615382452],
						[531505.81479291641, 670043.96191276703],
						[531505.87379363796, 670013.20797597338],
						[531391.49654078158, 670012.9889439363],
						[531391.43775425188, 670043.74288113788],
						[531334.19785203179, 670043.63356601587],
						[531334.08070440998, 670105.03083022218],
						[531363.06022344739, 670105.08614954376],
						[531362.9425449007, 670166.70468514203],
						[531333.96313459589, 670166.64936602442],
						[531333.61169138493, 670350.8413396856],
						[531305.35194501432, 670350.78744359629],
						[531305.29310761299, 670381.65206238965],
						[531359.34619353875, 670381.75519316457],
						[531362.41457549075, 670443.1586514276],
						[531389.85206581699, 670443.21107428311],
						[531390.61537624395, 670473.96665345947],
						[531447.85377853678, 670474.07616522501],
						[531447.79467282351, 670504.94080375775],
						[531475.95139216713, 670504.9947480046],
						[531475.89286964003, 670535.52751361299],
						[531533.13105736196, 670535.637322617],
						[531533.07179113047, 670566.50197096146],
						[531703.96393837035, 670566.83100721007]
					]
				],
				[
					[
						[533959.44856757286, 670632.73803105648],
						[533959.51239443175, 670601.87338168384],
						[533987.77170871396, 670601.93184517871],
						[533987.83490178885, 670571.39907887066],
						[534016.81359785015, 670571.45908114244],
						[534017.00471359119, 670479.19705700979],
						[534073.42100235983, 670479.31401728094],
						[534073.48481323756, 670448.56001955539],
						[534045.32799713034, 670448.50162160362],
						[534045.4552840516, 670387.10426691722],
						[534017.19560008124, 670387.04570415313],
						[534017.28840800677, 670342.24224164407],
						[534017.38671563682, 670294.78377081221],
						[533960.14768839965, 670294.6653029439],
						[533960.21128637111, 670263.91133502719],
						[533902.97215152974, 670263.79306644236],
						[533902.84494158346, 670325.41163356882],
						[533874.68791432097, 670325.35352819611],
						[533874.49782827916, 670417.50485252147],
						[533817.25922878843, 670417.38688268757],
						[533817.13279477716, 670478.78424921655],
						[533788.05117326591, 670478.72438787948],
						[533787.86134384037, 670570.98641466617],
						[533816.94280196528, 670571.0462756661],
						[533816.87992662238, 670601.57904262561],
						[533845.03648027277, 670601.63704888476],
						[533844.97286857385, 670632.50169869931],
						[533959.44856757286, 670632.73803105648]
					]
				],
				[
					[
						[530103.58220840013, 672008.16286550148],
						[530103.63879332866, 671977.29797329078],
						[530131.79298818368, 671977.34961285465],
						[530131.84942302026, 671946.59535268741],
						[530189.08269247727, 671946.70047701639],
						[530189.1955731191, 671885.30259911495],
						[530160.21919554344, 671885.2493512542],
						[530160.38825232233, 671793.2078854416],
						[530132.13098805072, 671793.15600829362],
						[530132.300495364, 671700.78270765045],
						[530104.14582631004, 671700.73106721125],
						[530104.20241114637, 671669.86622597626],
						[530131.63785190484, 671669.91654662183],
						[530132.41336485883, 671639.27428376977],
						[530160.67089393886, 671639.32616140204],
						[530160.72738159494, 671608.57195717306],
						[530189.70424741111, 671608.62520593172],
						[530189.76058594277, 671577.98163348855],
						[530503.36894695414, 671578.56120103132],
						[530503.42566521629, 671548.02826128609],
						[530803.67641978932, 671548.58875532867],
						[530846.01156984747, 671548.66822622041],
						[530846.06954852864, 671517.80341297865],
						[531245.89084541728, 671518.55933430605],
						[531245.83211522375, 671549.42414612311],
						[531303.06676901516, 671549.53315324336],
						[531303.00856389594, 671580.06609018729],
						[531531.12470940955, 671580.50253425806],
						[531531.18333868647, 671549.96959811845],
						[531655.82540774543, 671550.2094088369],
						[531673.91032445442, 671550.24428272189],
						[531673.9698592741, 671519.3794724457],
						[531816.59456987225, 671519.54457248631],
						[531816.65394405834, 671488.90102091851],
						[532187.49886867218, 671489.62374915171],
						[532187.55936859094, 671458.75895095314],
						[532530.14713527798, 671459.43405187421],
						[532530.20718334999, 671429.12239247723],
						[532359.32400944713, 671428.78475793358],
						[532359.38526808715, 671397.69871755422],
						[532330.30527389329, 671397.64143775613],
						[532330.4261564021, 671336.24375734804],
						[532302.27086230996, 671336.18834802788],
						[532302.33092448593, 671305.65545491898],
						[532274.07282120618, 671305.59989181033],
						[532274.13413538877, 671274.40324521379],
						[532245.15667978686, 671274.34631816181],
						[532245.21641828958, 671243.92406132258],
						[532216.95820878225, 671243.86859649746],
						[532217.01876308687, 671213.00383906648],
						[532188.04119913524, 671212.94701280771],
						[532188.09909681999, 671183.40977649763],
						[532074.45124135178, 671182.19176075794],
						[532074.51195971738, 671151.10576029366],
						[531989.01754777879, 671150.93899173231],
						[531989.13672125526, 671089.76264232537],
						[531960.15893982758, 671089.70621819678],
						[531960.09929941734, 671120.34970365511],
						[531902.86314970336, 671120.23840645619],
						[531902.80383101292, 671150.77127082122],
						[531874.54546119913, 671150.71639523585],
						[531874.48512137844, 671181.80239643669],
						[531817.24918586086, 671181.69139764039],
						[531817.19002611435, 671212.2242723892],
						[531791.29518050666, 671212.17411954433],
						[531788.97476950206, 671243.03450205806],
						[531731.7390474081, 671242.92380131036],
						[531731.68026018632, 671273.3460600049],
						[531646.18648467655, 671273.18107633875],
						[531646.3045951135, 671211.89405782823],
						[531617.32702920039, 671211.83823867934],
						[531617.44567044999, 671150.21936107543],
						[531646.42334509629, 671150.27518043411],
						[531646.48218708637, 671119.74231514288],
						[531617.50445855758, 671119.68649568222],
						[531617.56345965725, 671089.04300898337],
						[531446.67674678937, 671088.71487182868],
						[531446.61806457909, 671119.35835913941],
						[531361.12348735845, 671119.1948596118],
						[531361.18201002677, 671088.55137199815],
						[531332.20422646252, 671088.49605598766],
						[531332.49762467679, 670934.7255617287],
						[531275.26082797383, 670934.61645203386],
						[531275.37776211346, 670873.21891551756],
						[531247.11891467648, 670873.16511964076],
						[531247.17722365505, 670842.52167191659],
						[531189.94052580837, 670842.19160729193],
						[531189.99851785344, 670811.65879056044],
						[531132.76129220217, 670811.55017754878],
						[531132.70340658189, 670842.08299448143],
						[531104.44408648578, 670842.25069643778],
						[531104.38604385534, 670872.89414466615],
						[531076.22995531035, 670872.84083750215],
						[531075.3501005132, 670903.37210897054],
						[531047.19406422286, 670903.31885159551],
						[531047.13570988504, 670934.18356247491],
						[531018.87696735794, 670934.13015936699],
						[531018.81887508649, 670964.88424921269],
						[530989.8408732895, 670964.82953735767],
						[530989.78262650885, 670995.69425861526],
						[530961.52398983366, 670995.64095420158],
						[530961.46683905367, 671025.95254931308],
						[530904.23036032449, 671025.84473284613],
						[530904.17144143966, 671057.15196966217],
						[530846.93507145508, 671057.04435289511],
						[530846.87771634141, 671087.57721101446],
						[530818.61923778569, 671087.52415252081],
						[530818.56172758411, 671118.16764204926],
						[530789.58399628184, 671118.11328357772],
						[530789.52674757154, 671148.64615189401],
						[530761.26837410498, 671148.59319209168],
						[530761.21014176193, 671179.67919730896],
						[530733.05457922677, 671179.62647855189],
						[530732.9974353927, 671210.15935713868],
						[530706.28052783303, 671210.10937677091],
						[530703.85939877119, 671240.96972040343],
						[530675.70394132298, 671240.91709997808],
						[530675.6471105474, 671271.33936238592],
						[530618.41148711683, 671271.23254214088],
						[530618.35331846646, 671302.42919476493],
						[530590.0952096387, 671302.37652952725],
						[530590.15332460427, 671271.179876804],
						[530561.17586331419, 671271.12592139165],
						[530561.23248201504, 671240.70365858439],
						[530475.73853657208, 671240.54476868315],
						[530475.79581811849, 671209.68000500381],
						[530446.81824830407, 671209.62625139579],
						[530446.76102122455, 671240.49101517431],
						[530418.50280580949, 671240.4386452178],
						[530418.44645153312, 671270.86090851505],
						[530390.29104533768, 671270.80877745966],
						[530390.34734745114, 671240.38651406323],
						[530361.26707467216, 671240.33272124827],
						[530361.32414106035, 671209.46795717243],
						[530333.16862960521, 671209.41592405504],
						[530333.2231908656, 671179.8786813973],
						[530304.96670857607, 671178.83086950693],
						[530304.20201541157, 671147.74334560346],
						[530276.04639812023, 671147.69141042978],
						[530276.10269208683, 671117.15854033746],
						[530247.84426443442, 671117.10646405898],
						[530247.95695103123, 671055.93011235492],
						[530218.97910990089, 671055.8767608006],
						[530219.0925028167, 670994.25792389084],
						[530190.83386367501, 670994.20594572031],
						[530191.22965559887, 670778.927367258],
						[530218.66658493003, 670778.97783331072],
						[530219.54485264106, 670748.44653602736],
						[530304.93859989627, 670748.60390246403],
						[530304.99392533163, 670718.62422813126],
						[530391.31430924439, 670717.89874173235],
						[530391.37122539198, 670687.14469010232],
						[530505.02445869974, 670687.35542027],
						[530505.19584563724, 670595.09329688223],
						[530534.17449988786, 670595.14715350978],
						[530534.40282136132, 670472.35231199977],
						[530562.6623585372, 670472.40488140401],
						[530562.7766248727, 670411.00749102572],
						[530591.75560397189, 670411.06144926208],
						[530591.86997861625, 670349.66407920106],
						[530619.30803767848, 670349.49396289466],
						[530620.18707018788, 670318.96275717625],
						[530648.44687131979, 670319.01547420281],
						[530648.50447396771, 670288.15086318739],
						[530677.48366986448, 670288.20497270545],
						[530677.54112031066, 670257.45099269412],
						[530734.78027727548, 670257.55801904039],
						[530734.83762786328, 670226.91467006982],
						[530762.27547948656, 670226.96604437951],
						[530763.052434262, 670196.21342223859],
						[530791.3124466266, 670196.26638511126],
						[530791.36990246887, 670165.62304636883],
						[530820.34931458428, 670165.67740799289],
						[530820.40703211038, 670134.92344861326],
						[530848.66714994691, 670134.97651018586],
						[530848.72512819117, 670104.11193021433],
						[530905.96481961815, 670104.21955322404],
						[530906.02228085243, 670073.68685565703],
						[530934.28250407032, 670073.7400645602],
						[530934.34064298868, 670042.87549498654],
						[530963.32027170912, 670042.93010890635],
						[530963.37825650326, 670012.17617018102],
						[531020.61826837156, 670012.28419281426],
						[531020.67615138763, 669981.64088497951],
						[531048.93653300242, 669981.69429118338],
						[531048.99425958446, 669951.16161408368],
						[531106.13213798089, 669951.04848922242],
						[531106.1901803232, 669920.40519170358],
						[531191.69141909527, 669920.34611274896],
						[531191.63279698032, 669951.21066118684],
						[531248.87302134384, 669951.31947940169],
						[531248.81450214167, 669982.07340705779],
						[531363.29473534354, 669982.29164161836],
						[531363.41241377732, 669920.67316654406],
						[531390.85077706282, 669920.72559106792],
						[531391.79026181065, 669859.32995903329],
						[531417.58447496046, 669859.37928529235],
						[531420.06555485551, 669797.98662400793],
						[531391.90762328287, 669797.93277558614],
						[531392.0837711452, 669705.78172526741],
						[531363.82291472889, 669705.72772855777],
						[531363.9405929856, 669644.10934415064],
						[531334.96026048227, 669644.05402327958],
						[531335.07740781794, 669582.65690967813],
						[531306.81633952004, 669582.60301106516],
						[531306.87433312996, 669552.18102515931],
						[531277.89383840654, 669552.12580498517],
						[531277.95262108557, 669521.26132239355],
						[531221.43027309899, 669521.15377041325],
						[531221.48915985215, 669490.17866731761],
						[531249.75038719585, 669490.23241909302],
						[531249.80848524044, 669459.69982255984],
						[531221.54720535746, 669459.64607068524],
						[531221.60588178295, 669428.78160303202],
						[531192.62516929884, 669428.72653332958],
						[531192.56654733839, 669459.59100108198],
						[531107.0633287977, 669459.4288242599],
						[531107.00549613906, 669489.96142129728],
						[530907.12153746432, 669489.58403143671],
						[530907.17899851466, 669459.05143369129],
						[530821.67577716475, 669458.89074269892],
						[530821.61847508035, 669489.42334073898],
						[530764.37664078083, 669489.31601172162],
						[530764.26079881238, 669551.15560085885],
						[530736.10244403174, 669551.10287687299],
						[530735.98836437811, 669612.05748303398],
						[530764.14661465434, 669612.11020682147],
						[530763.91575945087, 669735.34698411054],
						[530792.17656490183, 669735.3999484732],
						[530792.06144604972, 669796.79711611802],
						[530763.800746258, 669796.74415195372],
						[530763.74292879994, 669827.60868173698],
						[530739.49015557382, 669827.56326771539],
						[530735.52790459117, 669858.08861684776],
						[530621.0468055933, 669857.87475845357],
						[530621.10373616917, 669827.34209984983],
						[530604.66117779445, 669827.31144958618],
						[530506.62242283626, 669827.12903911062],
						[530506.6789350647, 669796.70701062144],
						[530478.41905635316, 669796.21203535725],
						[530478.47572152794, 669765.67938623368],
						[530421.23485012329, 669765.57325323997],
						[530421.29202363663, 669734.70873233362],
						[530364.05104428157, 669734.60279865167],
						[530364.1079056724, 669703.84890811215],
						[530335.94981269236, 669703.79687022488],
						[530336.06363433332, 669642.17847857217],
						[530278.8223324659, 669642.07284195872],
						[530278.87923786673, 669611.20834078337],
						[530164.39641787158, 669610.99766569282],
						[530164.33972762583, 669641.86216726468],
						[529936.19665078109, 669641.44471067516],
						[529936.25291226048, 669610.58020831854],
						[529879.01150025846, 669610.47596523911],
						[529879.06705034489, 669579.94334404357],
						[529793.56445841677, 669579.78800575098],
						[529793.50906729116, 669610.32062723814],
						[529650.86798742623, 669610.06247240945],
						[529650.92311335413, 669579.52985044359],
						[529536.44007254473, 669579.32355284214],
						[529536.5502966065, 669518.03707220475],
						[529503.56179253187, 669517.97777527245],
						[529365.64723527792, 669517.73059106618],
						[529365.5920465159, 669548.59508029709],
						[529337.33091960836, 669548.54457087093],
						[529337.27657443273, 669578.96656351234],
						[529308.2961269744, 669578.91481899447],
						[529308.02170801302, 669732.68423937098],
						[529337.00188411807, 669732.73598340747],
						[529336.94674840872, 669763.60050802142],
						[529365.20750523789, 669763.65101678204],
						[529365.15290983755, 669794.1836696812],
						[529422.39368152828, 669794.28612170229],
						[529422.33838510828, 669825.15065610525],
						[529446.5911618988, 669825.19412495976],
						[529450.44151582569, 669855.73379011452],
						[529479.42147478973, 669855.78578546667],
						[529479.36607096891, 669886.65032976342],
						[529507.62661604781, 669886.70108361123],
						[529507.57175541634, 669917.23375598073],
						[529535.83224786702, 669917.28455836547],
						[529535.66631452681, 670009.54635909339],
						[529507.40598084207, 670009.49555699469],
						[529507.18494795053, 670132.51136220084],
						[529535.4450699439, 670132.56216392003],
						[529535.38975877478, 670163.31612772681],
						[529792.50500131655, 670163.78056412248],
						[529792.44940932817, 670194.42390630348],
						[529820.70942477637, 670194.4751989193],
						[529820.65357916534, 670225.22917182406],
						[529849.63288609951, 670225.28182046919],
						[529849.57718728692, 670255.92517248739],
						[529877.8370968994, 670255.97656340664],
						[529877.78114407707, 670286.73054618528],
						[529906.76034248283, 670286.78329564061],
						[529906.70413391676, 670317.64790922788],
						[529992.20288429002, 670317.80383655056],
						[529992.2592535466, 670286.93922326074],
						[529963.99939721462, 670286.88763543451],
						[529964.11142392736, 670225.49030133151],
						[529935.13211736211, 670225.43745066389],
						[529935.24403569591, 670164.04013645346],
						[530077.88030392549, 670164.30076123052],
						[530077.82417943573, 670194.94410244573],
						[530135.06355427462, 670195.04903847841],
						[530135.00711996853, 670225.80301030667],
						[530163.26708141749, 670225.8548924115],
						[530163.2107973668, 670256.49824335612],
						[530192.1900491229, 670256.55149649945],
						[530192.07676268881, 670318.1700908005],
						[530163.09761967068, 670318.11683785554],
						[530163.04153878673, 670348.64957800019],
						[530134.78178864869, 670348.59769628628],
						[530134.66871693451, 670410.21632126567],
						[530106.51183508674, 670410.16467677604],
						[530106.45565625548, 670440.8080580536],
						[530049.9364730746, 670440.70453800505],
						[530049.04851703846, 670532.8546482129],
						[529991.81031962647, 670532.75001197937],
						[529991.75395029329, 670563.61466575647],
						[529963.49457007775, 670563.56307879975],
						[529963.38254316431, 670624.960523666],
						[529906.14466678258, 670624.85618601914],
						[529906.08906250971, 670655.38897710561],
						[529848.85129218805, 670655.28483915853],
						[529848.68318994483, 670747.76825181954],
						[529791.4457416127, 670747.66431395756],
						[529791.39035014622, 670778.19712549716],
						[529763.23409923527, 670778.14606958441],
						[529763.17815859709, 670809.0107646673],
						[529705.94092372607, 670808.90712483681],
						[529705.88569101878, 670839.43994668091],
						[529648.64816274168, 670839.55775889393],
						[529648.59283670771, 670870.20121215004],
						[529621.15605979867, 670870.15169856604],
						[529620.22323791962, 670931.54776371515],
						[529591.24517730018, 670931.49551989092],
						[529591.13414074667, 670993.11434077751],
						[529533.89754757099, 670993.01130059885],
						[529533.84303199477, 671023.32290056802],
						[529477.32585365348, 671023.22135127219],
						[529477.269655162, 671054.52859309036],
						[529448.29181156238, 671054.4766015308],
						[529448.23705700855, 671085.00946442294],
						[529391.00078413018, 671084.90692231827],
						[529390.78100351954, 671207.70218293904],
						[529444.11206904158, 671207.79772229947],
						[529447.96149863873, 671238.66949148173],
						[529533.45545385894, 671238.82303041685],
						[529533.51096430805, 671207.95826350851],
						[529647.98265190516, 671208.16454065382],
						[529647.9269263004, 671239.02930718265],
						[529675.36308689613, 671239.0788654912],
						[529675.97102982819, 671300.69908711466],
						[529733.20655055891, 671300.80262248684],
						[529733.15126534947, 671331.33552461141],
						[529712.80546282197, 671331.29869751236],
						[529704.99596284563, 671331.28456855426],
						[529704.88489674614, 671392.6822675037],
						[529675.80489367282, 671392.62968858238],
						[529675.74871524703, 671423.71573855821],
						[529620.15771894308, 671423.61536900769],
						[529619.28099609655, 671453.92555577715],
						[529590.3038572917, 671453.87331361568],
						[529590.19301977579, 671515.38168033725],
						[529561.9352774045, 671515.33078440186],
						[529561.8795132417, 671546.30622866191],
						[529532.90253745916, 671546.25408779201],
						[529532.73719955853, 671638.18481187965],
						[529559.35065598704, 671638.23269794008],
						[529561.38181767531, 671822.76229669864],
						[529589.63903100381, 671822.81319167942],
						[529589.58401083655, 671853.34617984563],
						[529618.56044471101, 671853.39842073258],
						[529618.61551875854, 671822.86543266266],
						[529646.87273190287, 671822.91642613383],
						[529646.76187951642, 671884.31428747671],
						[529674.91623380361, 671884.36514368677],
						[529674.86105484515, 671914.89814163907],
						[529732.09443478426, 671915.00167313928],
						[529732.03854846675, 671945.86655639671],
						[529760.29554995126, 671945.9177450526],
						[529761.00589033146, 672007.53838972398],
						[530103.58220840013, 672008.16286550148]
					]
				],
				[
					[
						[516749.24508596899, 672711.50702747935],
						[516879.51549165719, 672525.34374994272],
						[517008.87661642372, 672525.47724243859],
						[517181.91666271962, 672711.95408575283],
						[517441.35520636186, 672712.22761870024],
						[517527.7627893273, 672619.28189078008],
						[517701.04676096287, 672573.11487118294],
						[518003.64199671673, 672573.44386724755],
						[518169.68839056487, 672662.57127270114],
						[518176.77348843875, 672666.67233263876],
						[518190.04369614861, 672652.5267063335],
						[518350.21543512057, 672480.34734501876],
						[518379.43482736149, 672262.33352911181],
						[518393.63262893021, 672154.37723346881],
						[518566.97673602914, 672061.53485979908],
						[518826.52830846177, 672061.83039529459],
						[519093.73829426663, 672103.40287435101],
						[519129.07870909641, 672108.75411208114],
						[519259.21700403566, 672062.33219201979],
						[519343.20096816856, 672032.22969671723],
						[519388.6369002526, 672015.79983875097],
						[519429.42956139025, 672015.84805622627],
						[519561.87726888841, 672016.00530991401],
						[519604.22930851532, 672000.89990162151],
						[519691.29825773358, 671969.58598079812],
						[519821.2704546483, 672063.00103999162],
						[519927.90715977177, 672079.50293202512],
						[520054.88445298397, 672099.34916451829],
						[520123.81801207899, 672109.94308522495],
						[520297.04513510427, 672203.19379871036],
						[520427.12805562455, 672203.35511048744],
						[520599.4855916925, 672250.47639758466],
						[520619.92425406195, 672257.471570567],
						[520729.61264941038, 672296.77174719167],
						[520895.93103440624, 672162.79167026794],
						[520903.0277799301, 672157.3799683284],
						[521032.45131777105, 672111.0818020174],
						[521094.35360277089, 672155.52272498375],
						[521162.41506073572, 672204.28629250196],
						[521342.07419145538, 672165.90990947967],
						[521378.86954731756, 672157.99261395331],
						[521508.29442677973, 672111.69819824258],
						[521838.41202301893, 672052.61649377167],
						[522027.4183316881, 672019.12766589248],
						[522152.05683987495, 672019.29533823254],
						[522330.74304188171, 672019.53736966825],
						[522592.82402224239, 671824.97090981866],
						[522709.77530094655, 671737.95814118721],
						[522893.3821902796, 671601.25691788702],
						[523109.8495308705, 671554.98620920011],
						[523456.15307187708, 671182.77558150713],
						[523444.36280829838, 671163.95221005916],
						[523283.29996497819, 670903.19743641],
						[523283.57916225813, 670706.28274601966],
						[523283.62276719941, 670675.52867263905],
						[523198.12587935798, 670675.40767250257],
						[523198.16948045214, 670644.5429778106],
						[523083.69386400026, 670644.38166231161],
						[523083.78016934125, 670582.98416588886],
						[523055.52082246525, 670582.94446650171],
						[523055.4774896552, 670613.80915145553],
						[523026.4988683507, 670613.76849212195],
						[523026.412776999, 670675.16599896806],
						[522998.25634944049, 670675.12654221512],
						[522998.21327892749, 670705.88061635487],
						[522969.13205959887, 670705.83991433587],
						[522969.08888880594, 670736.70461979695],
						[522849.9897013068, 670736.53846615716],
						[522712.70193924644, 670736.34800961183],
						[522712.74462815665, 670705.48330348521],
						[522683.76616862038, 670705.44324895274],
						[522683.72353417822, 670736.30795515585],
						[522598.32972308603, 670736.19021971943],
						[522598.37219702901, 670705.32551329269],
						[522572.47655209148, 670705.28989780706],
						[522541.13460080535, 670705.24684638367],
						[522541.17681531422, 670674.49277105997],
						[522427.42073248664, 670674.33701784303],
						[522427.46288503095, 670643.4723211315],
						[522398.48431607126, 670643.43277002638],
						[522398.56805954449, 670582.0352700518],
						[522370.30871103925, 670581.99674981809],
						[522370.35030389007, 670551.46394644724],
						[522341.37157256517, 670551.42449611833],
						[522341.4135630377, 670520.55981943232],
						[522313.15410874516, 670520.52139755292],
						[522313.23753250705, 670459.12393739983],
						[522256.10184018454, 670459.0464035999],
						[522256.14352021168, 670428.29236791364],
						[522198.90495839267, 670428.21489384747],
						[522198.94638167723, 670397.57148906612],
						[522170.68671573815, 670397.5333123476],
						[522170.81112605636, 670305.38187595317],
						[522142.55130147433, 670305.34374765272],
						[522141.95635728032, 670213.08076053439],
						[522113.69637386216, 670213.04268188693],
						[522113.90313917649, 670059.49400527426],
						[522085.64289145631, 670059.45597490051],
						[522085.80833024136, 669936.44012259343],
						[522028.56805407151, 669936.36324223084],
						[522028.60945494729, 669905.49866588763],
						[521999.62958372076, 669905.45981861511],
						[521999.71183193766, 669844.06255802873],
						[521943.29336087056, 669843.98707624187],
						[521943.37421561568, 669783.4748405607],
						[521914.29254374723, 669782.55100143782],
						[521914.37447225518, 669721.15378053416],
						[521857.23621236393, 669721.07763447566],
						[521857.31822169363, 669659.45918219991],
						[521829.05728557735, 669659.42159337283],
						[521829.09816369368, 669628.66768751247],
						[521714.61546561273, 669628.51591583202],
						[521714.57480187929, 669659.26982197841],
						[521658.15569597116, 669659.19531976129],
						[521658.1149919969, 669690.05985666532],
						[521511.46669786406, 669689.86711220816],
						[521486.39158643788, 669689.83428630291],
						[521486.47220417933, 669628.21584226401],
						[521458.21121429728, 669628.17889160442],
						[521458.29143688321, 669566.78171865433],
						[521429.31096794026, 669566.74387779494],
						[521429.39093780937, 669505.45735021518],
						[521458.37151490425, 669505.49519121344],
						[521458.53195995186, 669382.70094537851],
						[521515.77416591463, 669382.77583888301],
						[521515.85460240068, 669321.37874627288],
						[521515.89242927928, 669292.50552585535],
						[521515.9761991257, 669228.56408029678],
						[521458.73345565924, 669228.48918609275],
						[521458.8133889889, 669167.31339401775],
						[521429.83221512497, 669167.27555224055],
						[521429.95260271162, 669075.01408760389],
						[521401.69066085224, 669074.97723420826],
						[521402.09099068708, 668767.77121905773],
						[521430.35346120253, 668767.80807314732],
						[521430.47370418499, 668675.65742877696],
						[521459.4557455873, 668675.69527168432],
						[521459.49607349781, 668644.83090031205],
						[521512.83546251984, 668644.90068118216],
						[521573.16344174248, 668644.97981358343],
						[521573.0825040018, 668706.59793579543],
						[521602.16726380278, 668706.63616553484],
						[521602.0865079267, 668768.03305759816],
						[521749.46244201838, 668768.22756397922],
						[521801.97924935084, 668768.29719512258],
						[521802.01978064474, 668737.76468463673],
						[521972.93095904985, 668737.99245540774],
						[521972.8901100239, 668768.52496547159],
						[522030.13445668947, 668768.60165177658],
						[522030.09305606352, 668799.46604182327],
						[522058.35547203349, 668799.50397660432],
						[522058.31446402741, 668830.03649638058],
						[522087.29623300233, 668830.07544721069],
						[522087.25472478248, 668860.93984714546],
						[522115.51703496528, 668860.97788029502],
						[522115.4759205248, 668891.51040986029],
						[522172.71983853035, 668891.58759314613],
						[522172.63665002771, 668953.20579255396],
						[522200.89880143339, 668953.24397263187],
						[522200.94037393318, 668922.49018305249],
						[522229.92197976192, 668922.5293855666],
						[522230.04686003248, 668830.26804710191],
						[522201.06509139336, 668830.22884436976],
						[522201.09814001597, 668805.78070342529],
						[522201.14808679331, 668768.83193533425],
						[522230.12996377528, 668768.87113821646],
						[522230.21306749107, 668707.47424928588],
						[522248.19834203343, 668707.49860312487],
						[522258.47564176063, 668707.51252844604],
						[522258.51732139854, 668676.75877903937],
						[522326.65594597108, 668676.85126675747],
						[522372.9038809769, 668676.91420227755],
						[522372.94592549978, 668646.04983319971],
						[522401.20860547514, 668646.08835797664],
						[522401.16650783806, 668676.9527269837],
						[522430.14854695316, 668676.9922828275],
						[522430.12951051776, 668690.93103174353],
						[522430.06439381558, 668738.61041079217],
						[522458.32691451086, 668738.64903386403],
						[522458.28516309941, 668769.18154271273],
						[522486.5476311837, 668769.22021434724],
						[522486.50537283375, 668800.08460322965],
						[522515.48719465866, 668800.12430966692],
						[522515.36116612295, 668892.05375569162],
						[522543.62342276151, 668892.09252554446],
						[522543.53884268692, 668953.71072306018],
						[522572.52039342042, 668953.75053014327],
						[522572.4785811638, 668984.17244828818],
						[522600.7406792813, 668984.21131643304],
						[522600.69805349101, 669015.18636533525],
						[522628.85732716339, 669015.22514043387],
						[522628.77273146552, 669076.62212724588],
						[522657.75406530447, 669076.66208473546],
						[522657.71148434101, 669107.52652341255],
						[522685.97337018483, 669107.56553823361],
						[522685.80405629991, 669230.13834071218],
						[522714.78511923621, 669230.17839884199],
						[522714.74227765558, 669261.15348782344],
						[522743.00389912934, 669261.19260077795],
						[522742.96115743701, 669292.05706943385],
						[522857.44620094437, 669292.21600971604],
						[522857.48915779672, 669261.35154136328],
						[522942.99340770836, 669261.47076803935],
						[522943.03667978675, 669230.49567965826],
						[522971.19558429398, 669230.53504173341],
						[522971.23813581042, 669200.11308495654],
						[523000.32202164276, 669200.15379070293],
						[523000.36509181315, 669169.39996310347],
						[523057.50527111604, 669169.48008638178],
						[523057.54829296964, 669138.83688920294],
						[523171.31501248933, 669138.99700747442],
						[523171.22838816012, 669200.39403151069],
						[523228.47122954048, 669200.47489461931],
						[523228.42820153094, 669230.89685072203],
						[523256.58710534865, 669230.93670212175],
						[523256.54324189574, 669261.91178967291],
						[523313.78586885676, 669261.99295014737],
						[523313.74205447518, 669292.85741729639],
						[523342.82577606, 669292.89872958604],
						[523342.78222148551, 669323.54195099953],
						[523428.18337846873, 669323.66355767916],
						[523428.13982234919, 669354.19615847524],
						[523485.38212765212, 669354.27791704645],
						[523485.33751591761, 669385.47427499259],
						[523513.59892345173, 669385.51471402601],
						[523513.2916505225, 669600.12809619599],
						[523542.27206055069, 669600.16961455275],
						[523542.22781577351, 669631.03413647029],
						[523655.88835851761, 669631.19746417215],
						[523655.93281690753, 669600.33294256055],
						[523668.47044095822, 669600.35100702208],
						[523713.17426429951, 669600.41549510183],
						[523713.2183510536, 669569.88285520079],
						[523746.20675087563, 669569.93052107422],
						[523770.45990458026, 669569.96560741356],
						[523770.49849354173, 669543.30486443685],
						[523798.76508003619, 669539.5845278604],
						[523798.8032339426, 669513.25566565106],
						[523856.0515733792, 669508.80307223578],
						[523856.09656828264, 669477.8279458459],
						[523913.33844266448, 669477.91119605908],
						[523913.36421573145, 669460.21112621366],
						[523913.3829011973, 669447.37857661978],
						[524027.04471500375, 669447.54447306355],
						[524027.02594072069, 669460.37702253275],
						[524027.00004515657, 669478.07709219982],
						[524084.24191866891, 669478.16093809647],
						[524084.19649346231, 669509.13606385468],
						[524141.43825871707, 669509.2201091086],
						[524141.3928881617, 669540.0846143344],
						[524170.37340414338, 669540.12724107562],
						[524170.328630367, 669570.5492493069],
						[524198.5897194182, 669570.59086710576],
						[524198.49925211252, 669631.98802581988],
						[524226.76023543818, 669632.02969209629],
						[524226.62396796048, 669724.40203147021],
						[524255.60415868869, 669724.44480860664],
						[524255.55857291829, 669755.30934880208],
						[524312.79948014044, 669755.39399133972],
						[524312.75427811092, 669785.926659588],
						[524340.91223028093, 669785.96837016405],
						[524340.82122960594, 669847.36559834424],
						[524398.06181596417, 669847.45053805807],
						[524397.87905781879, 669970.46630542818],
						[524426.13945867715, 669970.50831480906],
						[524425.956817806, 670093.30291084095],
						[524454.93635754986, 670093.34603973222],
						[524454.61577995575, 670308.62396630086],
						[524482.87559889094, 670308.66607331671],
						[524482.69252968812, 670431.4608900029],
						[524510.95213723963, 670431.50304533204],
						[524510.81459421769, 670523.65452344017],
						[524539.79337454482, 670523.69780207507],
						[524539.74725223414, 670554.56247286394],
						[524596.98537365464, 670554.64810593298],
						[524596.93964085483, 670585.180903384],
						[524625.19898387603, 670585.22325531987],
						[524625.10691549582, 670646.62074337271],
						[524653.2633919277, 670646.66298950487],
						[524653.17088608933, 670708.28174985037],
						[524710.40847172064, 670708.36777825747],
						[524710.17725268926, 670862.02757522697],
						[524739.15543590439, 670862.0712056678],
						[524739.06293977506, 670923.4687838665],
						[524710.08486490394, 670923.42515359004],
						[524709.94653286343, 671015.35561943101],
						[524738.92444551061, 671015.39924946381],
						[524738.83128266421, 671077.23938353267],
						[524796.06758229085, 671077.32571050362],
						[524795.92826635041, 671169.58813056897],
						[524824.18660369667, 671169.63082492957],
						[524824.09378775489, 671231.02850366652],
						[524795.8355560659, 671230.98580946459],
						[524795.7896185253, 671261.4080902749],
						[524824.04779786209, 671261.45078439754],
						[524823.95448016748, 671323.18037289777],
						[524852.21255320485, 671323.22311548679],
						[524852.16617608548, 671353.86666423641],
						[524909.40151153249, 671353.95338623936],
						[524909.35485978262, 671384.70756641508],
						[524966.59008773079, 671384.79448775249],
						[524966.63684667181, 671354.04030773544],
						[525023.87218151288, 671354.12742872175],
						[525023.96540800913, 671292.95096373069],
						[525052.12077624898, 671292.99389373779],
						[525052.07419494481, 671323.52681039006],
						[525081.05156377424, 671323.57104415633],
						[525081.00475961168, 671354.21459226019],
						[525137.52079879842, 671354.30101075373],
						[525137.47371981607, 671385.05519027798],
						[525166.45098007179, 671385.09957474528],
						[525166.40333817853, 671416.18563897687],
						[525194.66125116358, 671416.22897086781],
						[525194.70894655515, 671385.14290671831],
						[525337.33460897265, 671385.36235711561],
						[525337.38206226681, 671354.60817816341],
						[525354.64514294546, 671354.63482397888],
						[525366.46213268093, 671354.65307413647],
						[525366.50946953753, 671324.00952685403],
						[525394.66478452145, 671324.05304418341],
						[525394.90190248459, 671170.72475722339],
						[525366.74666638649, 671170.45998663548],
						[525366.84185267694, 671108.84107841272],
						[525394.99753658532, 671108.88459631416],
						[525395.14055997925, 671016.40095915797],
						[525424.2212293261, 671016.44595741387],
						[525424.26815907902, 670986.13434475532],
						[525452.42405338038, 670986.17796111875],
						[525452.47189242754, 670955.31322197418],
						[525480.73059850733, 670955.35704614967],
						[525480.77831900341, 670924.60293846228],
						[525509.756391795, 670924.64792874199],
						[525509.80433840398, 670893.78319993592],
						[525538.06315036758, 670893.82712276885],
						[525538.11063395452, 670863.29427786288],
						[525595.34767928708, 670863.38339072629],
						[525595.30008927779, 670893.916235468],
						[525623.45614169131, 670893.96014508186],
						[525623.43629070546, 670906.68216515868],
						[525623.40798146953, 670924.82487355371],
						[525680.6448123341, 670924.91428372357],
						[525680.54844971292, 670986.5331293036],
						[525709.62917195121, 670986.57863298955],
						[525709.43692116311, 671109.37387922988],
						[525680.35641638143, 671109.32837588096],
						[525680.26005366247, 671170.94728227961],
						[525737.49602666858, 671171.03689059988],
						[525737.4481713823, 671201.56978516188],
						[525794.68403765198, 671201.65959281102],
						[525794.73199936072, 671171.1266984219],
						[525937.46227819228, 671171.35152268573],
						[525937.48604226403, 671156.30633038841],
						[525937.51137895847, 671140.26550170593],
						[525965.66700899124, 671140.30999807245],
						[525965.71528841997, 671109.77711425407],
						[525994.79579240666, 671109.82312294515],
						[525994.8443010198, 671079.17961784103],
						[526023.00003578851, 671079.22421251377],
						[526023.04842162505, 671048.69133886392],
						[526052.1290337902, 671048.73744908464],
						[526052.17870223732, 671017.43019622832],
						[526137.57105081098, 671017.56589198508],
						[526137.5511535299, 671030.06666713068],
						[526137.47262087965, 671079.40601789637],
						[526165.73111341242, 671079.45102085138],
						[526165.69744535221, 671100.58065705653],
						[526165.24160409498, 671386.66067892907],
						[526194.21886151074, 671386.70687705232],
						[526194.26791963319, 671355.95270061842],
						[526424.75057670765, 671356.32197743841],
						[526450.64519501326, 671356.36366766039],
						[526450.69455508795, 671325.72012357018],
						[526479.67192004598, 671325.76682541263],
						[526479.72115579725, 671295.23391292698],
						[526507.97927692381, 671295.27950484119],
						[526508.02963669447, 671264.08283863275],
						[526536.28781142726, 671264.12847925688],
						[526536.33697347739, 671233.70620348537],
						[526593.57272772945, 671233.79879566748],
						[526593.52345964382, 671264.2210712661],
						[526650.75910754001, 671264.31386276556],
						[526650.70847661002, 671295.51052853512],
						[526736.09937913564, 671295.64933669614],
						[526736.19970460946, 671234.03039602481],
						[526707.94147808081, 671233.9844113813],
						[526707.99167775305, 671203.11963537219],
						[526679.8361554133, 671203.07386622229],
						[526679.88540346932, 671172.76222728135],
						[526650.90812759579, 671172.49391930946],
						[526651.00813258358, 671110.87501871167],
						[526622.7496941234, 671110.82918067067],
						[526622.79937455687, 671080.18567744445],
						[526593.82157623605, 671080.13872302859],
						[526593.87102342967, 671049.60585107817],
						[526565.6124795347, 671049.5601113633],
						[526565.66312694119, 671018.25286007335],
						[526536.68521933071, 671018.20600648469],
						[526536.73420254502, 670987.89439707482],
						[526480.21690229001, 670987.80316291633],
						[526480.26667311869, 670956.9384268279],
						[526451.28865731112, 670956.89172393456],
						[526451.33819547517, 670926.13761911937],
						[526423.07943911164, 670926.09212467854],
						[526423.12910235033, 670895.22739858879],
						[526394.15097764041, 670895.18079652544],
						[526394.24930611579, 670834.00449051743],
						[526423.22789478814, 670833.82984033343],
						[526423.27702399029, 670803.29700805165],
						[526480.51427843526, 670803.38920616754],
						[526480.46504281228, 670833.92203827365],
						[526508.72360062297, 670834.18888388842],
						[526508.6741338704, 670864.83234716009],
						[526536.93299565767, 670864.87798889738],
						[526536.88365493121, 670895.41083085758],
						[526551.78375431395, 670895.43491603481],
						[526565.86177923111, 670895.45768479758],
						[526565.81184772227, 670926.32241045393],
						[526680.28549867857, 670926.50799978338],
						[526680.23553174082, 670957.26210390474],
						[526736.65017818997, 670957.35385915684],
						[526736.59992547543, 670988.21859446343],
						[526793.83653537184, 670988.31188466016],
						[526793.78707758244, 671018.62349329947],
						[526936.51868190803, 671018.85700120311],
						[526936.56840316392, 670988.5453929943],
						[526908.30975419527, 670988.49906354677],
						[526908.41072382242, 670926.88022534829],
						[526879.43265496928, 670926.83276692149],
						[526879.53315366851, 670865.43520130171],
						[526851.27429284598, 670865.38897000183],
						[526851.32439891109, 670834.74550776684],
						[526794.08725375752, 670834.65201720188],
						[526794.13743350818, 670803.89793362166],
						[526623.24775355856, 670803.61999115569],
						[526623.29779261351, 670772.75528594397],
						[526566.06043139054, 670772.6625901591],
						[526566.25944135257, 670649.64632391324],
						[526537.28088327881, 670649.59946927091],
						[526537.47931848711, 670526.80453557288],
						[526509.21987493197, 670526.75889289798],
						[526509.26916301507, 670496.22611098597],
						[526481.00966684183, 670496.18051685661],
						[526481.10902984778, 670434.56183791033],
						[526452.13009222632, 670434.51513353281],
						[526452.17945205641, 670403.87174050335],
						[526423.91979695274, 670403.82624461805],
						[526423.96928205143, 670373.07223057747],
						[526394.99023591843, 670373.02562702994],
						[526395.03984454507, 670342.16099202354],
						[526366.78008324932, 670342.11559446703],
						[526366.87866139493, 670280.71821719175],
						[526338.72155751393, 670280.67303291394],
						[526338.77088265261, 670249.91903879412],
						[526281.53169909003, 670249.82733473298],
						[526281.58073998592, 670219.18397133681],
						[526309.73794929171, 670219.22905763984],
						[526309.83631337248, 670157.83172022016],
						[526338.91850316583, 670157.87833832088],
						[526338.96782827226, 670127.12436433136],
						[526395.38532661402, 670127.21494718827],
						[526395.43493517302, 670096.35035262944],
						[526481.65418788197, 670096.48915904295],
						[526481.60441728053, 670127.35375333542],
						[526516.12601411319, 670131.83450075798],
						[526538.11288012005, 670134.74629485654],
						[526538.07498087338, 670158.19896566146],
						[526595.31448380626, 670158.29156390496],
						[526595.26485769101, 670188.93491633108],
						[526652.50425349339, 670189.02771390893],
						[526652.45434102393, 670219.78169701051],
						[526681.4336575747, 670219.82875489327],
						[526681.33390380361, 670281.22611017176],
						[526709.49100673327, 670281.27188189351],
						[526709.44080730958, 670312.13650583057],
						[526737.70062019688, 670312.18249305733],
						[526737.60065545246, 670373.57987819833],
						[526823.81845265871, 670373.72048103216],
						[526823.86886725738, 670342.85584732878],
						[526950.88364258967, 670343.06380594766],
						[526966.60634525155, 670343.08961672802],
						[526966.65648313262, 670312.55686624488],
						[526994.91629529488, 670312.60329609748],
						[526994.96703126095, 670281.73867303564],
						[527052.20610359346, 670281.83286377368],
						[527052.25676489354, 670251.0788718235],
						[527080.41391951276, 670251.12527952623],
						[527080.51516512025, 670189.72793675878],
						[527052.35790523107, 670189.68152888608],
						[527052.50988902897, 670097.41961349454],
						[527023.42759216891, 670097.3717316885],
						[527023.52862369723, 670035.9744388432],
						[526995.37110017997, 670035.92812867626],
						[526995.47202640283, 669974.5308557346],
						[526967.21163246804, 669974.4844249275],
						[526967.26213357074, 669943.73048305535],
						[526938.28232979972, 669943.68292079051],
						[526938.33295808767, 669912.81835820456],
						[526910.07245795394, 669912.77202572348],
						[526910.17306445539, 669851.37479246757],
						[526881.19309770886, 669851.32733093924],
						[526881.49495413864, 669666.91449995211],
						[526938.73616944114, 669667.00829518505],
						[526938.68554122071, 669697.87281740853],
						[526962.9385059753, 669697.91261839611],
						[526967.61527772807, 669728.67428203265],
						[526995.87609465944, 669728.72071353649],
						[526995.77516857127, 669790.11790615239],
						[527023.9331135524, 669790.16421700758],
						[527023.88232479908, 669821.0287591602],
						[527052.96511103876, 669821.07664177346],
						[527052.86397089844, 669882.473864167],
						[527081.02175752551, 669882.52027291479],
						[527080.97140844318, 669913.05295305664],
						[527109.95126626128, 669913.10076712433],
						[527109.849547219, 669974.71927060816],
						[527138.1099407468, 669974.76594687346],
						[527138.16076188581, 669944.012005531],
						[527166.42120826, 669944.05873052031],
						[527166.37033419812, 669974.812671775],
						[527223.6104763227, 669974.90745994134],
						[527223.66145757469, 669944.15351886791],
						[527395.38220353436, 669944.43908095965],
						[527395.48148741003, 669884.92247651704],
						[527423.64241028437, 669883.08883681707],
						[527423.74493662326, 669821.69161671784],
						[527452.82772169355, 669821.74020745209],
						[527452.93035672384, 669760.34300759085],
						[527481.08835275075, 669760.39010228426],
						[527481.34622151381, 669606.28875066014],
						[527424.10479456757, 669606.19306415902],
						[527424.20658182632, 669545.23843623349],
						[527338.80657700216, 669545.09604987537],
						[527338.8579566821, 669514.23155406467],
						[527224.37446073326, 669514.04137386847],
						[527224.42580863263, 669483.06625735818],
						[527196.16456896311, 669483.01943255577],
						[527196.1132743659, 669513.99454915093],
						[527167.13271226175, 669513.94658304239],
						[527167.18395219999, 669482.97146635083],
						[527138.92271236482, 669482.92474005301],
						[527138.97316775192, 669452.39212992962],
						[527110.71187529829, 669452.34545217722],
						[527110.76282599382, 669421.48097080644],
						[527081.78210063698, 669421.43315530836],
						[527081.83226716379, 669391.01118032157],
						[527053.67363779736, 669390.96477019438],
						[527053.77532437968, 669329.23583224521],
						[527024.69166713348, 669329.18794819585],
						[527024.84385092533, 669236.70520418533],
						[526996.68495698879, 669236.65889176948],
						[526996.78551908745, 669175.48313012929],
						[526968.52375011449, 669175.43669706187],
						[526968.67525275063, 669083.17527827155],
						[526939.69393039844, 669083.12771351135],
						[526939.84545161133, 668990.7557144633],
						[526968.82693696779, 668990.80327949254],
						[526969.07889609481, 668837.36629882688],
						[526997.34124683565, 668837.4127328461],
						[526997.44217241742, 668776.01585067366],
						[527020.87431802216, 668776.0543857211],
						[527023.29251155269, 668742.98140437575],
						[527025.70288698224, 668714.6653023446],
						[527282.94358370919, 668715.09061651223],
						[527282.89231182612, 668745.95498170401],
						[527311.8742291634, 668746.00315209245],
						[527311.77212833764, 668807.40002240543],
						[527340.03453064663, 668807.44704615418],
						[527339.98370362469, 668837.9795511649],
						[527368.14328112977, 668838.02645220025],
						[527368.09184871439, 668868.8908371937],
						[527625.33012979012, 668869.32151412754],
						[527625.37423034315, 668843.10338100477],
						[527653.54162231414, 668838.50452032103],
						[527653.60160058422, 668802.88326609111],
						[527653.64500100573, 668777.10764222452],
						[527671.73297185637, 668777.13810833858],
						[527682.72963593481, 668777.15664009098],
						[527682.75667318248, 668761.11601761449],
						[527682.78109993367, 668746.62414607021],
						[527710.94083407801, 668746.67163486662],
						[527710.88931772311, 668777.2041287967],
						[527739.97395248129, 668777.25322803413],
						[527740.02552290377, 668746.72073419462],
						[528025.42545069114, 668747.20526469406],
						[528025.37334969221, 668777.73775762995],
						[528082.61766421376, 668777.83553985762],
						[528082.51268187875, 668839.23241523502],
						[528110.67225723201, 668839.28058940487],
						[528110.61942939565, 668870.14497204171],
						[528138.88172372757, 668870.19337048009],
						[528138.82941138244, 668900.72588291182],
						[528167.81105560577, 668900.77556372993],
						[528167.7053744673, 668962.39372866962],
						[528195.9675100504, 668962.44222534902],
						[528195.91528118204, 668992.86412739707],
						[528167.65319794766, 668992.81563080545],
						[528167.54713729036, 669054.65507609048],
						[528110.30378762656, 669054.55699783668],
						[528110.25152776949, 669085.08954019903],
						[528082.09237387276, 669085.04136674874],
						[528081.93461636431, 669177.30277505331],
						[528138.35537774523, 669177.39934577234],
						[528138.30268623785, 669208.15315838798],
						[528167.2837879617, 669208.2028382828],
						[528167.3365337376, 669177.44902575202],
						[528195.59829924593, 669177.49752179417],
						[528195.65090801241, 669146.85433957342],
						[528252.89393597736, 669146.95271530084],
						[528252.99993802758, 669085.33449068118],
						[528310.24318041827, 669085.43306630105],
						[528310.29581207922, 669054.90052457876],
						[528338.45501764969, 669054.94908929965],
						[528338.5082743041, 669024.08467723918],
						[528538.50066981721, 669024.43098291149],
						[528538.4470373136, 669055.29539431771],
						[528738.33628192614, 669055.6439548725],
						[528738.28285449487, 669086.17649521527],
						[528766.5447770711, 669086.22597376734],
						[528766.49071578344, 669117.09039447247],
						[528880.97697884066, 669117.29132477578],
						[528881.12210507412, 669034.76496487157],
						[528881.13922452007, 669025.02995429013],
						[528852.87719663465, 669024.98027853644],
						[528852.93161428743, 668994.0052481133],
						[528823.95013458095, 668993.95435829321],
						[528824.00352679286, 668963.53245826182],
						[528795.74139308231, 668963.48288082867],
						[528795.79531482491, 668932.7291104194],
						[528766.81372699153, 668932.6783214293],
						[528766.86778822099, 668901.81393088982],
						[528738.60554830229, 668901.76445177686],
						[528738.65897568141, 668871.23194127972],
						[528710.49945510947, 668871.18269037257],
						[528710.66074046667, 668778.92143836874],
						[528681.67888120865, 668778.87079960678],
						[528681.78610300506, 668717.4739480617],
						[528653.52354587067, 668717.42461536441],
						[528653.68431651848, 668625.27406272897],
						[528624.70218612778, 668625.22352451354],
						[528624.7559791957, 668594.35918370367],
						[528596.49321019568, 668594.30994914542],
						[528596.65327431704, 668502.38070554822],
						[528624.91620151594, 668502.429940384],
						[528624.94608653442, 668485.28309489158],
						[528625.02359476918, 668440.81192865781],
						[528682.26908363914, 668440.91180096683],
						[528682.3229842335, 668410.0474904388],
						[528796.71140123229, 668410.24765382777],
						[528796.65728567471, 668441.1119639792],
						[528824.92031830619, 668441.16154298722],
						[528824.86634377867, 668471.91523328598],
						[528882.11172424082, 668472.01580215385],
						[528882.05744797655, 668502.88012207719],
						[528910.32037431689, 668502.92984804476],
						[528910.26662911836, 668533.46229842585],
						[528939.24892142985, 668533.51334056421],
						[528939.14073847258, 668594.91013051465],
						[528996.38569023414, 668595.01109767752],
						[528996.3311987794, 668625.87543726666],
						[529052.75385454937, 668625.97514933208],
						[529052.64524661703, 668687.37196850486],
						[529138.87189664028, 668687.524725692],
						[529138.81733335357, 668718.27845493704],
						[529195.34244460764, 668718.37883919931],
						[529196.00698796799, 668749.24447708367],
						[529252.53199264745, 668749.34505817934],
						[529252.47761038155, 668779.87754713849],
						[529281.45946785959, 668779.9291931605],
						[529281.51390400331, 668749.39670429472],
						[529367.02081924363, 668749.54937668086],
						[529367.18618698209, 668657.06694138027],
						[529395.34607467649, 668657.11731823883],
						[529395.62049969495, 668503.79127567832],
						[529367.46034910926, 668503.74089834956],
						[529367.51553756162, 668472.87658004358],
						[529310.27016009681, 668472.77431930718],
						[529310.43461298279, 668380.62389296258],
						[529253.18891397293, 668380.52183118393],
						[529253.24388723448, 668349.65753255785],
						[529195.99808029307, 668349.55567011633],
						[529196.10722168209, 668288.15896163322],
						[529167.84392575326, 668288.10874386842],
						[529167.89814891538, 668257.5763339944],
						[529053.40589278343, 668257.37340358563],
						[529053.46127292153, 668226.06662573025],
						[529025.30064615631, 668226.0168350609],
						[529025.35421310761, 668195.70568395173],
						[528997.09075808246, 668195.6557600263],
						[528997.14603065269, 668164.34899215819],
						[528997.25403674156, 668103.1735914388],
						[528983.89305546589, 668103.15000783373],
						[528968.27098502894, 668103.12244694366],
						[528966.88370229723, 667957.31641033699],
						[528940.27753491746, 667949.74701919197],
						[528940.33191860036, 667918.88278961275],
						[528858.00679455709, 667918.73793648148],
						[528768.58999233495, 667918.5810728604],
						[528768.64308444154, 667888.26997001085],
						[528740.3798746753, 667887.77799002582],
						[528740.48730958311, 667826.38142787898],
						[528712.32599751675, 667826.3321738391],
						[528712.70232782012, 667611.05717705761],
						[528626.47002618492, 667610.90665734187],
						[528626.5232405503, 667580.37435456878],
						[528655.50721473282, 667580.42489599902],
						[528655.72144562658, 667457.63198911084],
						[528626.73725475476, 667457.5814473012],
						[528626.80936401943, 667416.20799911954],
						[528626.89844013948, 667365.09963437996],
						[528541.3843169848, 667364.95081534749],
						[528541.330684955, 667395.81495632441],
						[528513.06585343892, 667395.76586532942],
						[528513.01246654964, 667426.51938721864],
						[528484.02822077903, 667426.46909724583],
						[528483.9217473598, 667487.86553191778],
						[528455.65707424888, 667487.81653971621],
						[528455.60360287258, 667518.68070094532],
						[528426.61951973743, 667518.6305122755],
						[528426.51326025988, 667580.0269771273],
						[528370.08701120073, 667579.92941647174],
						[528370.03427352826, 667610.46172007464],
						[528312.7858901259, 667610.36293605936],
						[528312.73268678866, 667641.22711770202],
						[528283.74881990277, 667641.17718114948],
						[528283.69586152059, 667671.93074356555],
						[528227.16714871337, 667671.83349691657],
						[528227.06201395998, 667733.008763941],
						[528169.81405769347, 667732.91047826048],
						[528169.86604413541, 667702.59940298204],
						[528140.88228554651, 667702.54971854121],
						[528140.77709288383, 667763.9462448461],
						[528117.24072435952, 667763.90593603509],
						[527998.01719732664, 667763.70226983796],
						[527998.22689247609, 667640.68798661511],
						[528024.1273700397, 667640.73215809558],
						[528084.56181743485, 667640.83538370696],
						[528084.66679910291, 667579.43889681576],
						[528055.58004312683, 667579.38918716041],
						[528055.68491603481, 667517.99271992652],
						[528027.52307521168, 667517.94464004366],
						[528027.6278428199, 667456.54819246137],
						[527998.54086921306, 667456.49858381716],
						[527998.59348150389, 667425.63443108264],
						[528027.68050976715, 667425.68403982313],
						[528027.73298793263, 667394.93051636766],
						[528227.64244103071, 667395.27286109829],
						[528227.6954836098, 667364.40871910169],
						[528198.71112823335, 667364.35893261014],
						[528198.76354657311, 667333.82666794502],
						[528227.74795583088, 667333.87645453005],
						[528227.90651314042, 667241.6159457101],
						[528212.28362324624, 667241.58910388278],
						[528198.92194107769, 667241.56615884474],
						[528199.08014558395, 667149.4163185081],
						[528170.8148900551, 667149.36781647801],
						[528170.9201907235, 667087.97148885333],
						[528141.9353475332, 667087.92180254869],
						[528142.04072935763, 667026.41487057344],
						[528113.77526216465, 667026.36646669952],
						[528113.82752145408, 666995.8342559532],
						[528142.0930411882, 666995.88265992049],
						[528142.14611114934, 666964.90795846214],
						[528153.86347595032, 666964.92803840362],
						[528171.13117141603, 666964.95764513779],
						[528171.18372683809, 666934.31482052372],
						[528199.44935244042, 666934.36332319386],
						[528199.50234042667, 666903.49925582693],
						[528228.48750906088, 666903.54904371197],
						[528228.5396009211, 666873.23810078308],
						[528256.80533162446, 666873.28670215036],
						[528256.85880778509, 666842.20139716845],
						[528314.10986861552, 666842.29998624802],
						[528313.84461568273, 666996.17782575998],
						[528427.52339398768, 666996.37417758559],
						[528427.4705515895, 667026.90638732642],
						[528513.70591931278, 667027.05586227193],
						[528513.6527245685, 667057.69870060077],
						[528627.43386040302, 667057.89661442651],
						[528627.38006776804, 667088.76070530014],
						[528999.04384686204, 667089.41267903615],
						[528998.98916053528, 667120.38739769044],
						[529227.16725983331, 667120.79183489596],
						[529227.27729624079, 667058.95302812126],
						[529255.54270735825, 667059.00334816345],
						[529255.64378651488, 667002.25326246745],
						[529227.38615153951, 666997.77798499994],
						[529227.44126813475, 666966.80328711611],
						[529198.45621112315, 666966.75173641776],
						[529198.51068310044, 666936.10891516029],
						[529170.24506049929, 666936.05869325995],
						[529170.35370250489, 666874.88368918421],
						[529142.08797454706, 666874.83351573604],
						[529142.11348950677, 666860.45241451322],
						[529142.14312610961, 666843.74821368],
						[529570.34400964342, 666844.51351022371],
						[529570.50950555713, 666752.5851241994],
						[529598.77544388652, 666752.63603489473],
						[529598.848004748, 666712.36898217478],
						[529598.94209463301, 666660.1545748132],
						[529630.29176627658, 666660.21109661076],
						[529656.19378997805, 666660.25784173037],
						[529656.24931450491, 666629.50444766739],
						[529684.41267863649, 666629.55532015278],
						[529684.46845580079, 666598.69130744948],
						[529713.55694850232, 666598.74390171992],
						[529713.16752635734, 666814.01772808598],
						[529798.58173300198, 666814.1724613735],
						[529798.52594130847, 666844.92588468164],
						[529855.7769926372, 666845.02984724555],
						[529855.72049051535, 666876.1151468741],
						[529998.48810077296, 666876.37526878749],
						[529998.54487307952, 666845.28996965173],
						[530026.70786722947, 666845.34142903727],
						[530026.82010282227, 666783.94521271973],
						[530055.90826745541, 666783.99841326708],
						[530055.96413597232, 666753.46624828759],
						[530141.37865748291, 666753.62276414759],
						[530141.49172701314, 666692.00533073349],
						[530169.75776959152, 666692.05722400092],
						[530169.83030759229, 666652.56455284974],
						[530169.9837142328, 666569.0436645908],
						[530198.96947306022, 666569.09692969278],
						[530199.02581008396, 666538.45417597529],
						[530213.92986278178, 666538.48158401728],
						[530227.29211689788, 666538.50616825139],
						[530227.40550710459, 666476.88880492654],
						[530312.82146684278, 666477.04621229798],
						[530312.87781176739, 666446.5140973737],
						[530455.64915603388, 666446.77819284739],
						[530455.59254572762, 666477.31030727876],
						[530484.57846643066, 666477.36407637468],
						[530484.52077571081, 666508.44931373722],
						[530512.78713415947, 666508.50179730658],
						[530512.73041741515, 666539.033921391],
						[530541.71622919745, 666539.0877913225],
						[530541.65925287467, 666569.73054385884],
						[530569.92550586758, 666569.78312575142],
						[530569.86868268403, 666600.31525942357],
						[530598.85438632604, 666600.36923018226],
						[530598.79689102946, 666631.23323973303],
						[530569.81124185293, 666631.17926907632],
						[530569.75400689128, 666661.93266000389],
						[530484.23622277635, 666661.77372579998],
						[530484.06458756223, 666754.25517675816],
						[530512.33052301512, 666754.30765954289],
						[530512.21688387799, 666815.4826150646],
						[530541.2022078248, 666815.5364840898],
						[530541.14502572967, 666846.28990484867],
						[530626.66184918594, 666846.44913533924],
						[530626.54737100785, 666907.84536728065],
						[530598.28169976862, 666907.79268794297],
						[530598.16712112911, 666969.29956375901],
						[530569.18206852046, 666969.24559421267],
						[530569.12442169653, 667000.22028749378],
						[530511.87391128228, 667000.11383856169],
						[530511.81719439302, 667030.64604134602],
						[530483.55173447391, 667030.59355944779],
						[530483.48501013941, 667066.54634086043],
						[530483.43758452893, 667092.1004757738],
						[530435.6434401609, 667092.01184464106],
						[530368.93720382964, 667091.88837477146],
						[530368.82368714327, 667153.28468775237],
						[530340.66122099466, 667153.23264178401],
						[530340.60441310133, 667183.98611781001],
						[530283.35454320535, 667183.88046537724],
						[530283.2978424927, 667214.63394656952],
						[530255.03269919043, 667214.58185791888],
						[530254.91940358456, 667276.08883540623],
						[530283.18444104132, 667276.14092386991],
						[530283.24134573317, 667245.27680867678],
						[530311.40365406382, 667245.32875619153],
						[530311.29035128688, 667306.72511910601],
						[530740.30141901062, 667307.52243319037],
						[530740.35856166005, 667276.99018685136],
						[530768.52081561985, 667277.04291813925],
						[530768.46362061752, 667307.57516437909],
						[530825.7130593675, 667307.68250765512],
						[530825.65513509524, 667338.54663090943],
						[530853.92006507213, 667338.59970151761],
						[530853.8627110899, 667369.13195731142],
						[530968.36115910893, 667369.34743872273],
						[530968.41872593411, 667338.81518332544],
						[531025.66805579863, 667338.92322354834],
						[531025.72635591787, 667308.05910099926],
						[531053.99133835768, 667308.11251590168],
						[531054.04906412575, 667277.58027066162],
						[531038.3234264882, 667277.55054649652],
						[531025.7840291434, 667277.52685566293],
						[531025.90021140652, 667216.01988356013],
						[531054.16556138441, 667215.9626747265],
						[531054.22349627584, 667185.31982025842],
						[531082.38590740704, 667185.37308969407],
						[531082.4441041688, 667154.61961626832],
						[531111.4288296561, 667154.67449154216],
						[531111.48645207041, 667124.2528951196],
						[531139.75175081263, 667124.30645759869],
						[531139.81047419715, 667093.33174633433],
						[531164.17006843281, 667093.37794656213],
						[531226.04549314117, 667093.4954614772],
						[531226.10416883335, 667062.63137950038],
						[531254.36957361526, 667062.6851392237],
						[531254.31084481592, 667093.54922109284],
						[531282.5761963916, 667093.60302935319],
						[531282.45926459588, 667154.99933592998],
						[531311.44398941146, 667155.0545641596],
						[531311.20948725112, 667278.06848443369],
						[531339.47452130239, 667278.12239060947],
						[531339.35737539374, 667339.51875626855],
						[531368.34177459811, 667339.57408490323],
						[531368.28346436296, 667370.10633888422],
						[531396.5483400271, 667370.16034327552],
						[531396.48934286402, 667401.02447446343],
						[531424.65138415096, 667401.07833074254],
						[531424.53349560266, 667462.69598378288],
						[531567.29600733065, 667462.969741554],
						[531567.06000942166, 667585.76260853559],
						[531596.04397408979, 667585.81833898893],
						[531595.86670664081, 667677.96835314238],
						[531624.13105252082, 667678.0227491667],
						[531624.01326544839, 667739.19799314346],
						[531681.26119977748, 667739.30831843149],
						[531681.20123939228, 667770.39375716506],
						[531709.36264736194, 667770.44810161297],
						[531709.24411497125, 667831.84462346812],
						[531766.49172637879, 667831.95524583035],
						[531766.43267410807, 667862.48757740378],
						[531795.51892873563, 667862.54385864618],
						[531795.39964525367, 667924.16165849846],
						[531823.56078957673, 667924.21619874611],
						[531823.32243988488, 668047.23060909263],
						[531852.40836735186, 668047.28699107992],
						[531852.34893997898, 668077.9299815062],
						[531823.2630667832, 668077.87359962938],
						[531823.08451872284, 668170.0238501149],
						[531794.92379585921, 668169.96931068017],
						[531794.86404695129, 668200.83357036568],
						[531765.7783914014, 668200.77729028743],
						[531765.71976693196, 668231.088432041],
						[531737.55914876645, 668231.03399096359],
						[531737.26136944978, 668385.1341411852],
						[531765.42172339396, 668385.18858174991],
						[531765.24349623779, 668477.33898248337],
						[531794.32866202085, 668477.39526161551],
						[531794.20980646031, 668538.7920119029],
						[531765.12474940671, 668538.73573298322],
						[531765.06548295589, 668569.37880329334],
						[531794.1504857447, 668569.43508211395],
						[531794.0909508625, 668600.18878211954],
						[531765.00600253569, 668600.1325034094],
						[531764.94630814728, 668630.996833371],
						[531736.78637566348, 668630.94239361922],
						[531736.66773400351, 668692.33919421956],
						[531679.42312146374, 668692.22867580305],
						[531679.24537321297, 668784.37922719796],
						[531707.40504261293, 668784.43356828659],
						[531707.34545574395, 668815.29792858101],
						[531821.83382252185, 668815.51935958222],
						[531821.8936245488, 668784.65499970701],
						[531879.13791493862, 668784.76601470215],
						[531879.19718033483, 668754.23353482946],
						[531936.44157675689, 668754.34474955848],
						[531936.50159391842, 668723.48040012934],
						[531993.74609752628, 668723.59181459481],
						[531993.80600675475, 668692.83809530025],
						[532050.2284324622, 668692.94810500683],
						[532050.28866321046, 668662.08376605774],
						[532164.77809803956, 668662.30758772395],
						[532164.83789397706, 668631.77512876061],
						[532250.34542155825, 668631.94281273638],
						[532250.4060281351, 668601.0784845564],
						[532307.65095837542, 668601.190993128],
						[532307.71145490382, 668570.43729499751],
						[532335.87149112823, 668570.49271365348],
						[532335.93182257749, 668539.84964541392],
						[532393.17696622771, 668539.96245209058],
						[532393.29806089704, 668478.56570618227],
						[532450.54341815331, 668478.67871281086],
						[532450.60418175755, 668447.92503517331],
						[532422.44393537962, 668447.86941980291],
						[532422.5048646311, 668417.00512234657],
						[532450.66516392992, 668417.06073782453],
						[532450.78647251218, 668355.66403226182],
						[532479.87185377197, 668355.72152542626],
						[532479.93267179991, 668324.96786789061],
						[532508.09312890097, 668325.02358183067],
						[532508.21421350958, 668263.84815582586],
						[532536.47755117819, 668263.90412186063],
						[532536.53957057709, 668232.59735644818],
						[532565.5223938087, 668232.65479769092],
						[532565.64369158237, 668171.47940198204],
						[532593.90718820482, 668171.53546684701],
						[532593.96734087588, 668141.22433787643],
						[532565.7037920939, 668141.16827291518],
						[532565.76586669672, 668109.86152789928],
						[532508.51922392647, 668109.7481196702],
						[532508.57965668652, 668079.21575121523],
						[532536.84331207816, 668079.27171788167],
						[532536.96450180048, 668018.09637146327],
						[532565.9477035515, 668018.15381345374],
						[532566.0097781166, 667986.84708876372],
						[532708.76773395808, 667987.13076805347],
						[532708.73821291677, 668001.95444598189],
						[532708.70538728102, 668018.43749220541],
						[532794.11333079345, 668018.6078025382],
						[532794.17584026966, 667987.30107871199],
						[532822.43965383468, 667987.35753684433],
						[532822.50022752827, 667957.04643824056],
						[532851.48353700934, 667957.1043841088],
						[532851.54527051363, 667926.24016835203],
						[532879.8091891564, 667926.2967252098],
						[532879.87075430702, 667895.54313898704],
						[532908.85417231987, 667895.60118609306],
						[532908.91601338517, 667864.73698058131],
						[532937.18003786157, 667864.79363616451],
						[532937.24126649904, 667834.26130887936],
						[532965.50534342462, 667834.31801320356],
						[532965.56684662576, 667803.67506658984],
						[532994.5504267537, 667803.73326491821],
						[532994.59020563727, 667783.93150789093],
						[532994.61220625008, 667772.97969902959],
						[532965.62857185036, 667772.92150058795],
						[532965.81374746514, 667680.66083249031],
						[532852.03692553041, 667680.432865849],
						[532852.09843768436, 667649.67931935145],
						[532823.11458570394, 667649.62137240113],
						[532823.17626464355, 667618.75720653811],
						[532794.91181677347, 667618.70074713684],
						[532795.095368915, 667526.77202443487],
						[532737.8466937854, 667526.65781687957],
						[532738.03058690566, 667434.397265604],
						[532709.86860274384, 667434.34115741367],
						[532709.92984770192, 667403.58765016554],
						[532652.68074321118, 667403.47373945499],
						[532652.74210088816, 667372.6096128698],
						[532595.49288842781, 667372.49590148521],
						[532595.61472999095, 667311.09953510948],
						[532567.34975269053, 667311.04346730723],
						[532567.41029161762, 667280.51122752251],
						[532538.42578818218, 667280.4537829461],
						[532538.48693066591, 667249.58967585664],
						[532510.22184751637, 667249.53370636632],
						[532510.28249895968, 667218.89085220685],
						[532424.87039684888, 667218.72201782989],
						[532424.93110732257, 667187.96854429087],
						[532367.68125129468, 667187.85562694422],
						[532367.74185456743, 667157.10215816367],
						[532338.6543506661, 667157.04486356885],
						[532338.5938018536, 667187.79833245417],
						[532310.43139487621, 667187.74290913588],
						[532310.49189095513, 667156.9894401459],
						[532253.24192695285, 667156.87692167761],
						[532253.30166415079, 667126.45532933087],
						[532110.53622746665, 667126.17560891504],
						[532110.59678156138, 667095.20090117701],
						[532053.34660219261, 667095.08907944045],
						[532053.40683243738, 667064.2250004604],
						[532025.24421358143, 667064.17006612127],
						[532025.36348975264, 667002.99504243059],
						[531968.1129890061, 667002.88351777382],
						[531968.29298282473, 666910.40196347341],
						[531940.02731598169, 666910.34697520128],
						[531940.14670378366, 666848.95075260988],
						[531882.89566611638, 666848.83952497621],
						[531882.95536037115, 666818.08610899281],
						[531772.35889271682, 666817.87180664437],
						[531768.39358961536, 666848.61766836094],
						[531740.23060108023, 666848.56322270352],
						[531740.1705326282, 666879.6485156446],
						[531682.91960195918, 666879.53798503149],
						[531682.80160215322, 666940.71297177265],
						[531654.53598747251, 666940.65847478528],
						[531654.59546772239, 666909.79441924661],
						[531625.61031010502, 666909.73858547083],
						[531625.55088432203, 666940.60264111706],
						[531568.30016610667, 666940.4925100056],
						[531568.24127310852, 666971.13532309141],
						[531511.71014836116, 666971.02677204274],
						[531511.76893589471, 666940.38395875576],
						[531471.06644991087, 666940.30592232989],
						[531397.37028161203, 666940.16488573025],
						[531397.42927863623, 666909.30082926527],
						[531340.17845131713, 666909.19149327092],
						[531340.20567976777, 666894.92101714935],
						[531340.23628538847, 666878.8805607598],
						[531311.97056430543, 666878.82665327552],
						[531312.0884478048, 666816.98794073402],
						[531283.10312642343, 666816.93271136854],
						[531283.16148687457, 666786.28992196487],
						[531254.89560645586, 666786.23611269332],
						[531255.01306386606, 666724.50805348123],
						[531197.7615924594, 666724.39921388694],
						[531197.93640521239, 666632.36028035672],
						[531169.67025990167, 666632.30661774997],
						[531169.72882787557, 666601.44261021307],
						[531112.47692751826, 666601.33406787424],
						[531112.5347592996, 666570.80193609686],
						[531055.38553851785, 666570.69378743903],
						[531055.32781296654, 666601.22591942025],
						[530998.07591185474, 666601.11777582392],
						[530998.13353098894, 666570.58564364433],
						[530969.86727937637, 666570.53232487012],
						[530969.92505453364, 666539.88957382925],
						[530912.67293963721, 666539.78172791039],
						[530912.73039978824, 666509.24960521399],
						[530855.47817809787, 666509.14195864089],
						[530855.53657083726, 666478.05672259256],
						[530770.01782939653, 666477.89630050561],
						[530770.07502415252, 666447.3641871619],
						[530741.91134763625, 666447.31145321159],
						[530741.9525481296, 666425.29735995573],
						[530741.96911114501, 666416.44747393404],
						[530712.88029561017, 666416.39305843657],
						[530712.93779761053, 666385.63970759697],
						[530627.52136254625, 666385.48021958477],
						[530627.63584041235, 666324.08415567339],
						[530570.38297332835, 666323.97750280413],
						[530570.49723715917, 666262.58145822154],
						[530599.48353678221, 666262.63543008768],
						[530599.54103196925, 666231.77148008649],
						[530627.8078665369, 666231.82416158542],
						[530627.86479603022, 666201.29208701523],
						[530656.13168304821, 666201.34481726075],
						[530656.18928444234, 666170.48087736871],
						[530685.17574658943, 666170.53500045429],
						[530685.11809072981, 666201.39894024434],
						[530770.53548303514, 666201.55872776662],
						[530770.59329938854, 666170.69478827959],
						[530856.11364022701, 666170.85521336622],
						[530856.22897087084, 666109.45922010206],
						[530913.48258565902, 666109.56686929241],
						[530913.54046205792, 666078.8135685703],
						[530941.80755984364, 666078.86679041781],
						[530941.86569753522, 666048.00287137262],
						[530999.11952652759, 666048.11081905046],
						[530999.17317897163, 666019.6806186469],
						[531028.16387746041, 666017.63350354112],
						[531028.21883382194, 665988.53956783714],
						[531056.48943335412, 665986.82301390613],
						[531056.54360317311, 665958.17157619644],
						[531084.71209580998, 665956.12300686841],
						[531084.76652408799, 665927.36095057218],
						[531113.75697734812, 665925.53523411811],
						[531113.81166590587, 665896.66255924944],
						[531199.33700532489, 665894.9441757442],
						[531199.45361670223, 665833.54827360599],
						[531284.97571283521, 665833.71093149041],
						[531284.91714198445, 665864.46419142222],
						[531313.9041441445, 665864.519423994],
						[531313.8457298961, 665895.16206549224],
						[531342.11314371624, 665895.21597620554],
						[531342.05446565617, 665925.96924578748],
						[531371.04135928256, 665926.02457918646],
						[531370.98283821309, 665956.66723030363],
						[531427.41466386861, 665956.77510035795],
						[531427.29677621159, 666018.39228690322],
						[531484.55070840858, 666018.50192654878],
						[531484.49218726566, 666049.03396868159],
						[531513.47886372416, 666049.08955343592],
						[531513.41965200915, 666079.95347043325],
						[531627.20756080747, 666080.172164249],
						[531627.14834827743, 666110.92546243034],
						[531684.40195794892, 666111.03579866304],
						[531684.34285159793, 666141.67847818416],
						[531741.59635407827, 666141.7890137569],
						[531741.53692714532, 666172.54232139862],
						[531769.70107478183, 666172.59676929947],
						[531769.6413811543, 666203.46070521767],
						[531969.66812411824, 666203.84879318683],
						[532055.08550366794, 666204.01526048186],
						[532055.02592132916, 666234.54732999322],
						[532084.11505889136, 666234.60412230785],
						[532112.27910011157, 666234.65915758745],
						[532112.21876255376, 666265.52310216147],
						[532169.47183337237, 666265.63512909866],
						[532169.41203817795, 666296.16720799392],
						[532197.67876192939, 666296.2225910062],
						[532197.618263665, 666327.0865451796],
						[532254.87111990247, 666327.19886977994],
						[532254.81116572826, 666357.73095816968],
						[532769.26359481551, 666358.7492171484],
						[532769.202022315, 666389.61317911104],
						[532854.61843585595, 666389.78380405647],
						[532854.55692411412, 666420.53714713524],
						[532940.07596415817, 666420.70842205966],
						[532940.01407045254, 666451.57239332981],
						[533025.53294891259, 666451.74411317159],
						[533025.47156176041, 666482.27621837473],
						[533139.8734050768, 666482.50663071009],
						[533139.81068932591, 666513.59185833472],
						[533225.32924488978, 666513.76461838931],
						[533225.26748610742, 666544.2967326903],
						[533310.78588180977, 666544.46993766213],
						[533310.7237397182, 666575.11268015183],
						[533453.39117977396, 666575.40262309765],
						[533453.32899682014, 666605.93474632083],
						[533525.484872484, 666606.08186050656],
						[533567.83276502381, 666606.16834862763],
						[533567.76969100512, 666637.03234728193],
						[533596.03582817607, 666637.09013665398],
						[533595.97292729968, 666667.84351651208],
						[533610.87686259393, 666667.87400679849],
						[533624.95851177443, 666667.90282728954],
						[533624.89533016155, 666698.76683569036],
						[533653.16136109794, 666698.82472336851],
						[533653.09903295164, 666729.24624180503],
						[533682.08450906922, 666729.30565338687],
						[533682.02053933125, 666760.50154267403],
						[533710.28646403039, 666760.55952865561],
						[533710.22380279866, 666791.09168044431],
						[533739.2091697806, 666791.15119283623],
						[533739.14622743009, 666821.79397317045],
						[533767.41204665543, 666821.85205745534],
						[533767.34882414411, 666852.60546638886],
						[533795.51180574403, 666852.66338772513],
						[533795.4478476661, 666883.74867290817],
						[533824.53583555319, 666883.80854734813],
						[533824.47341704718, 666914.11947076977],
						[533881.72422717465, 666914.23746576719],
						[533881.66056206147, 666945.10151296144],
						[533938.08899199998, 666945.21800828981],
						[533938.02567798481, 666975.86081255821],
						[533995.27627290832, 666975.97920333827],
						[533995.21216521016, 667006.95388392708],
						[534052.46265175845, 667007.0724740302],
						[534052.39935345482, 667037.60466388427],
						[534083.7483046978, 667037.66968544957],
						[534109.64973317343, 667037.72345331614],
						[534109.58609870973, 667068.36627174693],
						[534122.1256557384, 667068.39231684827],
						[534166.83637120842, 667068.48526050476],
						[534166.7721697042, 667099.34933148033],
						[534223.20006972831, 667099.46680628776],
						[534223.13553168892, 667130.44150598161],
						[534304.64234397619, 667130.61153373378],
						[534366.97014624276, 666963.58840253297],
						[534150.79703021958, 666823.75093333621],
						[534021.25071818917, 666543.82423697179],
						[533762.00120286318, 666403.90304527723],
						[533632.87792514195, 666263.92010634788],
						[533459.67241225531, 666216.66184626368],
						[533330.16641030903, 666263.30308460491],
						[533200.02844476094, 666216.13500875398],
						[532983.93835138308, 666076.31364822132],
						[532897.78196927044, 665982.8850406704],
						[532810.9048503933, 665889.56611642742],
						[532465.48577898042, 665702.36836678954],
						[532292.63591492607, 665469.49706308614],
						[532163.31038696168, 665422.67088021676],
						[532033.26499767404, 665375.62307770993],
						[531904.02844509494, 665282.22671226005],
						[531773.96827664052, 665188.71919521689],
						[531644.00899678958, 665095.43419677753],
						[531514.67868069466, 665048.61321083095],
						[531168.49210628646, 664815.42294812342],
						[531082.31919367309, 664721.78322875616],
						[530952.99938614469, 664721.53905462311],
						[530865.75389793678, 664814.85134209576],
						[530649.08908813854, 664907.47967317351],
						[530519.58162724366, 664953.70026022638],
						[530389.44127348927, 664953.45899466542],
						[530260.02049326571, 664953.22008556465],
						[530129.43525790377, 665139.49071213568],
						[529912.79728486924, 665278.48010010191],
						[529740.03676107212, 665371.3112548046],
						[529609.81536961696, 665417.86969291151],
						[529479.40933891677, 665510.44818026503],
						[529349.90914271388, 665557.12062717055],
						[529219.60768803942, 665650.14392081543],
						[528570.90909696999, 665695.13283334218],
						[528397.76287312899, 665601.79823673307],
						[528267.78813018592, 665508.31850098225],
						[527965.06269149762, 665507.8003510834],
						[527835.48825551383, 665600.83582582849],
						[527662.41511091299, 665461.04733503051],
						[527532.17598322139, 665460.82853209146],
						[527402.86199363647, 665460.61230500648],
						[527446.16564573825, 665321.07795526448],
						[527360.07664184156, 665227.67893238564],
						[527099.77485641406, 665180.34320496232],
						[526927.20784436981, 665226.96367329801],
						[526667.6243772126, 665179.63597319066],
						[526537.48581347871, 665179.42522343365],
						[526408.06681361399, 665179.21666140156],
						[526277.82545148721, 665179.00780346501],
						[526147.68688279169, 665178.80014175875],
						[526018.2678780132, 665178.59465069778],
						[525844.88157736638, 665225.2251862993],
						[525758.49052056286, 665318.34489050996],
						[525628.10511676292, 665411.17515040433],
						[525498.39911889937, 665597.0418258002],
						[525281.51923631434, 665922.7141285328],
						[525194.31305358722, 666015.61462691799],
						[524978.51849026582, 666108.31959088345],
						[524891.31467039522, 666201.44303535041],
						[524847.79133666796, 666434.12970284745],
						[524631.49340379401, 666387.67376506072],
						[524545.29157341481, 666294.06757233816],
						[524588.67138970667, 666154.63585854589],
						[524588.88086643885, 666014.69718601846],
						[524502.77895997523, 665921.53404594841],
						[524372.47421779938, 665968.02335940977],
						[524242.47936469049, 665874.68591810926],
						[524113.27077638212, 665734.88883239555],
						[523853.85708483198, 665641.47573969758],
						[523810.8875304471, 665501.25354906998],
						[523680.9842511391, 665268.31435953174],
						[523507.93927715789, 665081.77639410691],
						[523378.68858346529, 665035.01961476146],
						[523205.33739849098, 664988.31213199662],
						[523119.22225845867, 664895.15674092795],
						[523032.74083728873, 664475.99577256758],
						[522903.18689912453, 664568.62716217898],
						[522600.22612790915, 664801.40060677903],
						[522469.98177042592, 664801.22193899553],
						[522340.55979106267, 664801.04542221408],
						[522167.18105470354, 664846.94032421045],
						[522036.97693495743, 664893.66928766225],
						[521907.49372307409, 664939.95776285545],
						[521647.82957645389, 664939.61352813698],
						[521517.74996977136, 664892.98096392979],
						[521344.49539366795, 664845.85079540208],
						[521215.01319235098, 664892.5872086708],
						[521084.81272065768, 664938.88123902527],
						[520955.2731486283, 665031.74945988669],
						[520651.59904618957, 665124.84140020492],
						[520435.87687435973, 665170.7014644189],
						[520132.32285410434, 665170.3266387796],
						[519959.60613722668, 665356.51595185522],
						[519699.28446897329, 665309.96120030386],
						[519569.7556644468, 665402.84052697266],
						[519179.85366971052, 665495.19359828182],
						[519050.53995090426, 665495.04312148353],
						[518920.30109301466, 665494.89259706589],
						[518703.87147143681, 665448.40420031629],
						[518531.4366982248, 665401.63637011894],
						[518358.23051688215, 665308.40774799057],
						[518228.09365834855, 665215.00748785888],
						[518141.95152230572, 665121.87807995128],
						[518011.91499443102, 665028.25849050144],
						[517925.66785575415, 664935.13019429799],
						[517882.74793103506, 664795.58787827101],
						[517752.75552813994, 664562.25393789215],
						[517666.90789029538, 664189.58425224177],
						[517536.76148349786, 664189.44480761257],
						[517450.30912425026, 664282.82883227931],
						[517407.08794495254, 664422.16751820617],
						[517276.79125319241, 664468.93399802782],
						[517104.34249174013, 664421.84951725358],
						[516887.89372766286, 664375.2746816451],
						[516843.66404829599, 664701.01328218472],
						[516843.52090702223, 664840.61921890697],
						[516670.97122920892, 664794.31345091097],
						[516497.70177346026, 664747.23442438582],
						[516151.93583115557, 664700.31859908463],
						[516021.69067245087, 664700.19105602859],
						[515675.87794944574, 664699.85742830974],
						[515545.76500198804, 664560.01719056361],
						[515545.89721678064, 664420.30082275521],
						[515719.48520414921, 664140.92270035308],
						[515805.87003956252, 664001.40001661982],
						[515806.00446155487, 663861.68405530357],
						[515806.13888345408, 663721.96819491638],
						[515632.76658873144, 663768.48491354473],
						[515503.29273306264, 663814.71297264087],
						[515287.06446532288, 663628.22243148042],
						[515244.0591042061, 663442.11598138651],
						[515157.11157046159, 663302.09860813618],
						[515070.9419882751, 663208.98622595589],
						[514941.50746494421, 663208.86800148385],
						[514725.22299942345, 663069.06783539522],
						[514551.82677698584, 663022.2309025859],
						[514378.61379591568, 662882.36302231252],
						[514292.43779186264, 662789.03368086461],
						[514162.36048400222, 662695.88817873842],
						[514076.07927173155, 662602.78121593385],
						[513902.77899908856, 662556.06195467198],
						[513816.59867238894, 662462.62464385526],
						[513686.47719528503, 662416.16531011206],
						[513556.99818022235, 662462.40838519682],
						[513426.73527851736, 662462.30141595576],
						[513253.46916119754, 662369.12803419144],
						[513081.06066383689, 662229.38558716176],
						[512950.83271116234, 662182.60018912109],
						[512821.39010166953, 662182.49866764562],
						[512691.22779457533, 662182.39761003945],
						[512649.59500718105, 662173.51579343074],
						[512610.42936979403, 662165.0784616546],
						[512494.37152990536, 662139.87874449953],
						[512474.73722935375, 662135.66021359805],
						[512430.78822851082, 662198.23860285047],
						[512397.02834911272, 662247.21837902558],
						[512384.47126991331, 662265.57206597831],
						[512345.15427878097, 662321.84879409743],
						[512214.88928619144, 662461.35576882667],
						[512085.44887285272, 662461.26004537335],
						[511912.00624119723, 662601.06967994256],
						[511824.8245903629, 662740.72185853263],
						[511695.35338351538, 662786.97968204599],
						[511478.86780982924, 662740.47650622623],
						[511348.74216883566, 662693.70375587139],
						[511046.05872186925, 662553.89296915336],
						[510872.68770537153, 662600.34901773743],
						[510569.90867949254, 662600.15143770585],
						[510483.70957440982, 662506.84221013507],
						[510267.27523467509, 662366.99055066018],
						[510093.96167769749, 662320.31152149499],
						[509920.64707010298, 662273.74495306669],
						[509791.20517877099, 662273.66730447265],
						[509661.0435940242, 662273.5902524601],
						[509531.60170148278, 662273.51464911539],
						[509401.337302275, 662273.43959489418],
						[509283.74262315466, 662231.44721237291],
						[509271.9216900224, 662226.7944385088],
						[509141.75973395637, 662226.72150034842],
						[509141.68205793004, 662366.3257102014],
						[509141.60432029923, 662506.04064160364],
						[509141.52658261533, 662645.75567325531],
						[509141.44890642446, 662785.36018355587],
						[509141.37104552181, 662925.29665936541],
						[509141.29330766894, 663065.01199227187],
						[509141.21563131176, 663204.61680379626],
						[509141.13789334177, 663344.33233776491],
						[509141.06015531841, 663484.04797239357],
						[509140.98247879336, 663623.65308561176],
						[509140.90461755812, 663763.59016619145],
						[509147.98576940451, 663785.71856343083],
						[509183.90142339189, 663903.21950427827],
						[509227.82265457627, 664042.96019775397],
						[509246.61820766859, 664073.61318227497],
						[509288.93384915363, 664142.22298539628],
						[509308.55102133099, 664173.87212379312],
						[509324.15912341845, 664205.07652481506],
						[509400.13805553777, 664369.28372238821],
						[509407.21821616049, 664392.07603627921],
						[509415.01751232252, 664415.64312658668],
						[509425.99634106288, 664451.82303119916],
						[509443.23393004929, 664508.80361302046],
						[509443.0550532678, 664819.98541703459],
						[509442.99292642676, 664928.06396430859],
						[509482.94403971091, 664991.80580271967],
						[509529.98069701879, 665067.7204005972],
						[509442.83223585639, 665207.60824694729],
						[509313.30784142727, 665393.82369571493],
						[509270.05562779581, 665533.51639376325],
						[509226.90712684969, 665672.87749518547],
						[509313.07026523078, 665812.86473288969],
						[509399.25877267582, 665905.94816851465],
						[509389.03919748549, 665981.71943948732],
						[509376.4438106551, 666078.06537962041],
						[509374.06961557776, 666095.65317835938],
						[509370.97356589878, 666117.33364136703],
						[509368.59856209066, 666136.35955131869],
						[509359.10194220132, 666206.60016037757],
						[509356.00372769858, 666232.15246673627],
						[509312.75334981421, 666371.84566392936],
						[509312.67432465206, 666511.23162463459],
						[509182.39151525754, 666604.1929606467],
						[509226.30551141396, 666743.93561516819],
						[509221.56956298603, 666757.87157875265],
						[509214.46447628294, 666780.87738412654],
						[509200.35702331812, 666827.11031799845],
						[509194.07551155088, 666847.90412084735],
						[509182.23518017109, 666883.85031687049],
						[509193.22673463554, 666895.25074465445],
						[509269.24094785878, 666977.15529977484],
						[509356.31674366567, 666945.78742087097],
						[509398.67262238445, 666930.32422819396],
						[509463.68136587, 667023.39644414082],
						[509528.7918983915, 667116.91151913581],
						[509407.12496896379, 667247.26737035497],
						[509355.39367230085, 667303.21371849463],
						[509355.26128944731, 667535.63546919776],
						[509268.87306010351, 667629.0641736642],
						[509293.87307185528, 667767.35898071434],
						[509304.12012811023, 667821.79208548763],
						[509308.01342488267, 667843.47671738476],
						[509311.90846747096, 667862.06386375497],
						[509318.9872393994, 667884.85655572289],
						[509324.42405574128, 667903.22333465272],
						[509354.99576714233, 668001.80732012074],
						[509397.92632063589, 668234.58638529759],
						[509181.37601334794, 668420.75625175866],
						[509052.08532516373, 668420.68448385492],
						[508930.57366525184, 668290.19117376849],
						[508921.94556201657, 668280.89399412705],
						[508853.04301708913, 668169.67873490602],
						[508835.79194252501, 668141.12824445264],
						[508733.85220217804, 668113.63877128984],
						[508662.53525679931, 668094.46291543078],
						[508756.486174636, 668263.10496558319],
						[508877.95175830059, 668481.76504773227],
						[508921.07302511641, 668562.76593107521],
						[508880.89794466947, 668735.20868532278],
						[508878.6307827222, 668746.60185014724],
						[508705.1544050466, 668932.80183623021],
						[508575.8434284915, 668979.30704595242],
						[508316.1251610613, 669212.15048472374],
						[508272.99421527504, 669351.84866601706],
						[508584.11491945811, 669473.91768912424],
						[508748.81804692786, 669538.38870362798],
						[509008.25570308376, 669631.56513117149],
						[509137.56188573071, 669771.35684767226],
						[509168.02803007589, 669870.71578394866],
						[509180.54293706268, 669910.99057669099],
						[509270.72998653312, 669983.72243223106],
						[509353.82857019681, 670051.03010234353],
						[509656.47028615396, 670051.20527031855],
						[509872.92980697105, 669818.35592400236],
						[510041.62421916699, 669727.96633352956],
						[510061.97112712869, 669729.41692185448],
						[510392.00110026536, 669818.6761841625],
						[510565.26464984752, 669818.78673768463],
						[510591.95490139694, 669704.30627175071],
						[510608.54672759509, 669632.5209004198],
						[510586.5773648445, 669597.10650896071],
						[510522.31179218279, 669492.74523871834],
						[510614.92707158753, 669459.94903958635],
						[510652.54916299984, 669446.25582833868],
						[510824.93302515132, 669539.62592914305],
						[510837.44368475303, 669580.56566683075],
						[510866.46548366162, 669673.3997887685],
						[510890.69875033404, 669703.17415858898],
						[510954.98455066321, 669772.46863179747],
						[511063.17775040818, 669801.85699072923],
						[511128.21702871035, 669819.15855675726],
						[511257.5036961016, 669958.96710234729],
						[511267.74591128336, 669859.18961287139],
						[511288.22941975074, 669661.51544804941],
						[511300.85065687058, 669539.946521973],
						[511431.21960730728, 669307.05931590754],
						[511690.7781781783, 669214.20601451583],
						[511863.9808960745, 669307.36624074262],
						[512036.35970526666, 669540.46911101218],
						[512036.18911709171, 669773.22546208708],
						[512468.93812176608, 669773.54832823877],
						[512555.83876808296, 669959.90843160497],
						[512685.22010439495, 669960.00786072167],
						[512641.91532715911, 670146.26854670874],
						[512771.22267024551, 670239.62633305497],
						[512944.40844396304, 670332.79846082942],
						[513031.37473037926, 670425.90381807892],
						[513117.6665692284, 670332.93594314111],
						[513247.04496668262, 670333.03979853028],
						[513463.27247002814, 670566.19437110564],
						[513722.70609179215, 670612.87214442296],
						[513775.2170006425, 670612.91610881651],
						[513852.90437237849, 670612.98145998956],
						[514069.13653287292, 670706.4232644235],
						[514371.76616997737, 670706.68532936252],
						[514501.88154602557, 670799.83648752805],
						[514761.51776278502, 670613.77307810844],
						[514934.85763641249, 670520.78250364447],
						[515107.35149920289, 670567.62455801899],
						[515323.62079909211, 670614.28797414969],
						[515409.80908536719, 670753.97904708213],
						[515323.40350273455, 670847.15624168445],
						[515625.85317036865, 671033.84686710907],
						[515755.9141586512, 671173.58188065654],
						[515712.57772292232, 671359.83567134326],
						[515496.084841598, 671452.77767066564],
						[515603.4937379327, 671530.42877140874],
						[515625.36567570432, 671546.15857941296],
						[515712.22110019502, 671732.53714398621],
						[515712.08116077649, 671878.78589230485],
						[515711.99838264298, 671965.29617422365],
						[515795.9300257783, 671983.29828850599],
						[515928.35020204651, 672012.07862772001],
						[516057.80613680504, 671919.3885882661],
						[516187.79980423598, 672012.33235375816],
						[516188.43586540216, 672200.95231064945],
						[516273.54740820057, 672478.15785875672],
						[516291.61461891979, 672494.99113970646],
						[516575.8619549108, 672758.23716007755],
						[516749.24508596899, 672711.50702747935]
					]
				]
			]
		}
	}, {
		"type": "Feature",
		"properties": {
			"name": "Sai Kung",
			"ID_0": 102,
			"ID_1": 8,
			"ISO": "HKG"
		},
		"geometry": {
			"type": "MultiPolygon",
			"coordinates": [
				[
					[
						[535569.37797210563, 638895.09482929099],
						[535569.4444462856, 638864.34563241107],
						[535626.79302386334, 638864.46970967646],
						[535626.99276787636, 638772.22214547219],
						[535655.30685614329, 638772.28347849357],
						[535655.3734903757, 638741.53429911262],
						[535741.03663687629, 638741.72015643539],
						[535741.10319092416, 638711.08159022243],
						[535770.13810932823, 638711.14468645363],
						[535770.40454169689, 638588.59046461293],
						[535713.05596284906, 638588.02345289919],
						[535712.98898140737, 638618.88321912894],
						[535655.63954784011, 638618.75884143007],
						[535655.57387240545, 638649.06556967972],
						[535540.87521523924, 638648.8174144153],
						[535540.74165876023, 638710.64757822442],
						[535512.53042513621, 638710.58666457445],
						[535512.13246082305, 638894.97117436538],
						[535569.37797210563, 638895.09482929099]
					]
				],
				[
					[
						[530505.75792264263, 638976.9541436882],
						[530506.63840274035, 638946.31705087051],
						[530650.36948909098, 638946.58417409763],
						[530650.42635846348, 638916.05616757867],
						[530677.19580790889, 638916.10605711513],
						[530678.85507420369, 638854.49989312841],
						[530650.54112742736, 638854.44712382322],
						[530650.5986149176, 638823.58730407129],
						[530621.56389494613, 638823.53324204509],
						[530621.73537059454, 638731.39624287118],
						[530593.42121197295, 638731.34357185801],
						[530593.47818054492, 638700.704986325],
						[530536.12903219857, 638700.59845267679],
						[530536.47122911504, 638516.21398503846],
						[530556.96065180399, 638516.252023904],
						[530564.78575794585, 638516.26655804564],
						[530564.84287786344, 638485.51739375887],
						[530593.87819431897, 638485.57135569153],
						[530593.99192566972, 638424.4048655543],
						[530564.9565012753, 638424.35090342327],
						[530565.0146485084, 638393.0487096709],
						[530594.05012814025, 638393.10267190658],
						[530594.10647963884, 638362.79595860955],
						[530622.42127247737, 638362.84863080084],
						[530622.47870538023, 638331.98887965118],
						[530708.14398418204, 638332.14853398269],
						[530708.20137131994, 638301.39939584793],
						[530737.23701267934, 638301.4536107562],
						[530737.35168883461, 638240.06595588324],
						[530765.56372921856, 638240.11868206144],
						[530765.85099281534, 638086.48370744812],
						[530737.63868901168, 638086.43098078005],
						[530737.75377829745, 638024.82216902578],
						[530708.71764878009, 638024.76795320259],
						[530708.77462298295, 637994.24007427483],
						[530680.45919583028, 637994.18725348392],
						[530680.51673620683, 637963.32755396434],
						[530652.20125585317, 637963.27478179557],
						[530652.25812497269, 637932.74691112991],
						[530594.90629990876, 637932.64017260983],
						[530594.96367960167, 637901.78048133838],
						[530565.92733295751, 637901.72651749093],
						[530565.98404178408, 637871.19865498284],
						[530537.66840289475, 637871.14607991371],
						[530537.78274183907, 637809.53732651658],
						[530566.09848675167, 637809.58990178409],
						[530566.3838798923, 637655.95522195357],
						[530538.06787059782, 637655.90264619607],
						[530538.18179888267, 637594.51516868046],
						[530509.1449100225, 637594.46130502853],
						[530509.20192252786, 637563.7122685198],
						[530480.88575450133, 637563.6597911648],
						[530481.05663322832, 637471.41270688141],
						[530452.84327482909, 637471.36046852381],
						[530452.89977226476, 637440.83266480058],
						[530481.11318300792, 637440.88490325445],
						[530481.1703474489, 637410.02527993661],
						[530452.95688379533, 637409.97304138355],
						[530453.12739953748, 637317.83662850922],
						[530423.98705301841, 637317.78272457118],
						[530424.04410986789, 637286.92311812332],
						[530281.12228224741, 637286.65948795225],
						[530281.06549343048, 637317.51909488719],
						[530223.71152399154, 637317.41365015879],
						[530223.65504588536, 637348.16265364387],
						[529966.74680737546, 637347.69278356002],
						[529966.69101077225, 637378.3311842184],
						[529937.6537404249, 637378.27832905296],
						[529937.76542672678, 637316.89092383592],
						[529909.44883395918, 637316.83942983486],
						[529909.61650646396, 637224.59244167106],
						[529852.26221313013, 637224.48829163495],
						[529852.31779611728, 637193.84991174983],
						[529880.63460053259, 637193.90130743897],
						[529880.74667532928, 637132.18212919286],
						[529909.78437994933, 637132.23488393356],
						[529909.8362498245, 637103.69806546031],
						[529880.80190931156, 637101.76497774827],
						[529881.02565707802, 636978.54790495522],
						[529852.70848207362, 636978.49650859763],
						[529852.76386433502, 636947.96877030144],
						[529824.54960844608, 636947.91760920815],
						[529824.60473788518, 636917.50048272603],
						[529795.46368240705, 636917.44769184594],
						[529795.51955907349, 636886.58813857764],
						[529709.94972631615, 636886.43342162215],
						[529710.00524280407, 636855.68448003195],
						[529624.33227703429, 636855.53002237692],
						[529624.27692063607, 636886.27896425314],
						[529566.92144811002, 636886.17580876779],
						[529566.86600014369, 636917.03536281222],
						[529538.54871928471, 636916.98450707528],
						[529538.4941186076, 636947.40163450618],
						[529509.45608781918, 636947.34953495907],
						[529509.401342456, 636977.87727440242],
						[529481.18713784718, 636977.82670203317],
						[529481.02167159447, 637070.18420038256],
						[529507.69115327368, 637070.23200267286],
						[529509.18037739699, 637101.09435221751],
						[529538.21813687542, 637101.14645127463],
						[529538.16353615443, 637131.56360386056],
						[529566.48044775287, 637131.61445894057],
						[529566.42440350715, 637162.80587053462],
						[529594.74126134627, 637162.85677424516],
						[529594.63125369861, 637224.02292367979],
						[529623.66879625607, 637224.07517352863],
						[529623.61324063805, 637254.93477419252],
						[529594.57575254096, 637254.88252444007],
						[529594.52084816527, 637285.41030574997],
						[529566.20420122088, 637285.35940242186],
						[529566.14875315514, 637316.2190117928],
						[529537.83215923177, 637316.16815729067],
						[529537.7769628102, 637346.91716310405],
						[529365.81833006989, 637346.60938460217],
						[529365.76365236915, 637377.24778727733],
						[529280.09340204229, 637377.09512185911],
						[529280.03868702869, 637407.8441370253],
						[529222.68503242626, 637407.74218137609],
						[529222.63022814831, 637438.60180897661],
						[529137.78404658975, 637438.45134740276],
						[529136.90624120156, 637468.97769690095],
						[529079.65576815594, 637468.87642211304],
						[529079.60123189958, 637499.73605871515],
						[529051.28495377791, 637499.68604148005],
						[529051.23105646088, 637530.21385834017],
						[529022.19405413489, 637530.16261864046],
						[529022.13962542336, 637561.02226396371],
						[528993.82345276873, 637560.97234561271],
						[528993.76927205047, 637591.72138724534],
						[528964.73237826396, 637591.67024894769],
						[528964.67844650184, 637622.30868684733],
						[528879.00947204861, 637622.15810961276],
						[528872.67449881346, 637652.8961377762],
						[528821.60270523001, 637652.80660244555],
						[528821.49518053315, 637714.19410849246],
						[528793.1792714654, 637714.14453542128],
						[528793.1252716037, 637745.00420712889],
						[528819.89662633371, 637745.05107487144],
						[528821.33360282495, 637806.44131167699],
						[528850.37011761428, 637806.49219692824],
						[528850.31620410108, 637837.24127308873],
						[528878.63190133916, 637837.29094448325],
						[528878.36226321489, 637990.92578053812],
						[528852.41503020236, 637990.88026203273],
						[528849.9391971716, 638052.26370905829],
						[528820.90311608196, 638052.21282456897],
						[528820.79520371777, 638113.82165790093],
						[528792.47998234828, 638113.77208603628],
						[528792.31875663821, 638205.90884751012],
						[528820.63381945435, 638205.95841910003],
						[528820.58015384537, 638236.59694243234],
						[528849.61590955884, 638236.64782634948],
						[528849.56238380878, 638267.17574541341],
						[528906.91304286255, 638267.27640053816],
						[528906.85882774007, 638298.13614890922],
						[528935.17373184825, 638298.18591760448],
						[528935.06538988475, 638359.79481861799],
						[528962.55648467492, 638359.84318593331],
						[528963.3268400355, 638390.15135458566],
						[528992.36232478265, 638390.20249040215],
						[528992.30716938397, 638421.50468957308],
						[529020.62186119088, 638421.55460530706],
						[529020.56801751931, 638452.08254930784],
						[529049.60339297948, 638452.13378613268],
						[529049.54930014559, 638482.77234277187],
						[529020.51397875324, 638482.72110603773],
						[529020.45974489744, 638513.47027555597],
						[529048.67131650494, 638513.52005796309],
						[529049.44013805478, 638544.60251152935],
						[529077.75461803155, 638544.65252558351],
						[529077.70105886797, 638574.95926927298],
						[529105.91252504825, 638575.00914982485],
						[529105.85793560359, 638605.8689404648],
						[529134.89303968288, 638605.92032779811],
						[529134.83937505994, 638636.22707969323],
						[529192.18874778517, 638636.32872915058],
						[529192.13321134157, 638667.63096247532],
						[529248.76174778037, 638667.73153041699],
						[529248.70747995749, 638698.25950764818],
						[529306.05663646408, 638698.36155399005],
						[529306.00206521899, 638729.00014388224],
						[529363.3511145775, 638729.10238992388],
						[529363.29623914149, 638759.85159253667],
						[529392.33107149729, 638759.90343416273],
						[529392.27594419778, 638790.76324962918],
						[529420.59000056889, 638790.81385365105],
						[529420.64518097218, 638759.95403827808],
						[529448.85632996168, 638760.00450684037],
						[529448.91136529751, 638729.25530451373],
						[529478.04921223014, 638729.30748167878],
						[529478.1587972953, 638668.1409158865],
						[529706.73215332045, 638668.55201243423],
						[529706.45536734397, 638821.85558526916],
						[529792.01513573062, 638822.01028402604],
						[529791.95925857627, 638852.87010673503],
						[529821.09688660025, 638852.92289140914],
						[529821.04115526204, 638883.67210963741],
						[529848.53137475974, 638883.72195723071],
						[529849.19610739197, 638914.58309585298],
						[529877.50995068718, 638914.63448616315],
						[529877.45451540151, 638945.16249532474],
						[529906.48902074224, 638945.21524425317],
						[529906.43333052844, 638975.85386629391],
						[529934.74706838466, 638975.90535510296],
						[529934.69112419919, 639006.65459007386],
						[530039.91507255472, 639006.84636786021],
						[530049.38728702196, 639006.86366463127],
						[530049.33092646522, 639037.72351228585],
						[530106.67889976944, 639037.82834919647],
						[530106.56657069549, 639099.21623064927],
						[530134.77713798964, 639099.26787528617],
						[530134.66510880226, 639160.43455598294],
						[530335.02116415184, 639160.80273628933],
						[530334.9640633642, 639191.77321331645],
						[530363.17447195807, 639191.82524956088],
						[530363.11752217927, 639222.68512198515],
						[530420.46485079546, 639222.79105259688],
						[530420.40840696683, 639253.31910249486],
						[530505.24523052864, 639253.47617761861],
						[530506.29653053114, 639130.70187883452],
						[530477.98305905273, 639130.64940647327],
						[530478.04001904093, 639099.90015619295],
						[530449.82945282897, 639099.84792300186],
						[530449.99894636427, 639008.26385019766],
						[530478.21089895361, 639007.65243111621],
						[530478.26703934313, 638977.34563298977],
						[530505.75792264263, 638976.9541436882]
					]
				],
				[
					[
						[536254.59399337822, 639541.55334812799],
						[536254.66126352106, 639511.025281779],
						[536282.87112472369, 639511.08746787533],
						[536283.07357997075, 639419.28207685857],
						[536311.38801942067, 639418.68088560947],
						[536311.93043659127, 639172.90808943415],
						[536340.24383534025, 639172.97060113039],
						[536341.03172450548, 639142.55478691892],
						[536369.34517548396, 639142.61734868737],
						[536369.61558963917, 639020.2841148735],
						[536342.12706417067, 639019.55971985881],
						[536341.57457469939, 638896.78230011929],
						[536312.53998387756, 638896.71819550369],
						[536312.81143600936, 638773.72144586267],
						[536341.84624387627, 638773.78555095405],
						[536341.91416114615, 638743.03637438291],
						[536312.8792990176, 638742.97226916405],
						[536313.01429267239, 638681.80575416912],
						[536256.48876551935, 638681.68110010133],
						[536256.55774152151, 638650.37889350648],
						[536113.54479501338, 638650.06437848345],
						[536113.4760910864, 638681.36658567307],
						[536027.09190412296, 638681.17721117602],
						[536027.16044371249, 638649.87500362378],
						[535998.84614479472, 638649.81303069857],
						[535998.91245251533, 638619.50630382262],
						[535884.21358928178, 638619.25575514848],
						[535884.14749283064, 638649.56248248322],
						[535855.93615446752, 638649.5009800354],
						[535855.86794062634, 638680.8031882986],
						[535827.55369493284, 638680.74151014187],
						[535827.48722088523, 638711.26946323202],
						[535798.45230269991, 638711.20626580564],
						[535798.31874035916, 638772.59401058091],
						[535827.35355021898, 638772.65720777796],
						[535827.08572706929, 638895.65396537539],
						[535798.77185110399, 638895.5923367471],
						[535797.91757180728, 638956.97856476787],
						[535769.60380137223, 638956.91698633356],
						[535769.47034452297, 639018.30479978188],
						[535797.7840093202, 639018.36637798662],
						[535797.58330453373, 639110.61404299538],
						[535826.61751790228, 639110.6772388895],
						[535826.55056202773, 639141.42646903102],
						[535883.0745097606, 639141.54964607232],
						[535883.14108881238, 639111.02163362503],
						[535912.27874251164, 639110.86398776341],
						[535912.34609989368, 639080.00415354886],
						[536083.56590913038, 639080.37876414205],
						[536083.43079465057, 639141.98782674188],
						[536109.37621244951, 639142.04474799288],
						[536112.2624819479, 639234.29923975095],
						[536140.57577504846, 639234.36140784412],
						[536140.30608823407, 639357.13720010826],
						[536111.99300641194, 639357.0750324796],
						[536111.92551611678, 639387.82429580332],
						[536140.23854502267, 639387.88646331581],
						[536140.035915341, 639480.13427876227],
						[536167.52513827663, 639480.19468404783],
						[536168.17847669008, 639510.83493969915],
						[536197.31493950833, 639510.89901607507],
						[536197.24777577247, 639541.42708265618],
						[536254.59399337822, 639541.55334812799]
					]
				],
				[
					[
						[538026.10614412196, 640098.71118572808],
						[538026.24803051399, 640037.32309063687],
						[538049.82413113397, 640037.3775990447],
						[538054.63106565014, 640006.63920686755],
						[538083.6636978446, 640006.70638566057],
						[538083.73461998405, 639976.06765368918],
						[538111.2230143114, 639976.1313064819],
						[538112.11735523294, 639945.60509594146],
						[538141.15009513241, 639945.67237617914],
						[538141.22163688508, 639914.81243480695],
						[538163.9742876956, 639914.86519742466],
						[538169.81962502492, 639791.65959095175],
						[538084.16194484441, 639791.46108852921],
						[538084.09051069687, 639822.32101280743],
						[538055.05755312403, 639822.25383325526],
						[538054.98642926349, 639853.00315293088],
						[538026.67420074716, 639852.93769042508],
						[538026.60287414188, 639883.79762362549],
						[537998.29069861816, 639883.73220996268],
						[537998.14840704214, 639945.34148051334],
						[537969.1156665642, 639945.27445262531],
						[537969.04521328665, 639975.80257168633],
						[537940.83614887751, 639975.73749449151],
						[537940.62341555662, 640067.98553264874],
						[537968.8323217982, 640068.05060948094],
						[537968.76186847989, 640098.57874565583],
						[538026.10614412196, 640098.71118572808]
					]
				],
				[
					[
						[536109.09334297688, 640678.19115368673],
						[536109.16059089743, 640647.55231872422],
						[536137.47145200439, 640647.61448148102],
						[536137.67383980216, 640555.47678381938],
						[536165.88191019732, 640555.53876932932],
						[536166.21964840288, 640401.90228726051],
						[536138.01131458278, 640401.84030117001],
						[536138.14664457669, 640340.23088526307],
						[536126.30733601784, 640340.20488351537],
						[536109.83525450923, 640340.16872134502],
						[536110.0374834676, 640248.0311529371],
						[536081.00527713168, 640247.9674569068],
						[536081.13942198432, 640186.80052092602],
						[536052.82776788413, 640186.73845511302],
						[536052.89539363456, 640155.87847027683],
						[536023.86302467878, 640155.81487507652],
						[536023.93035377155, 640125.06550371705],
						[535995.61859343748, 640125.00353634625],
						[535995.68611160119, 640094.14355995925],
						[535967.37429805251, 640094.08164119627],
						[535967.97882327077, 639817.55874828249],
						[535938.94585730403, 639817.49530293921],
						[535939.01326780953, 639786.63536960562],
						[535910.80387906171, 639786.57377308316],
						[535910.87051237409, 639756.04567114997],
						[535881.7344836886, 639755.9821020395],
						[535881.80082170526, 639725.56461328291],
						[535825.27888032107, 639725.44144061487],
						[535825.34607722273, 639694.58151973831],
						[535768.00039299903, 639694.45675041212],
						[535768.06820371991, 639663.26500659867],
						[535653.3766165321, 639663.0160671107],
						[535653.30902324885, 639694.20781139727],
						[535538.61765176465, 639693.95967189269],
						[535538.68502760911, 639662.76792713592],
						[535482.16287049931, 639662.64593322482],
						[535482.09560181096, 639693.83767821104],
						[535510.408104114, 639693.89876188512],
						[535510.3414979357, 639724.7586840447],
						[535538.55099267163, 639724.81959393888],
						[535538.48528925818, 639755.23708407208],
						[535567.51836509362, 639755.29982275038],
						[535567.25246723928, 639878.29713450186],
						[535595.56465211953, 639878.35836472188],
						[535595.29902106978, 640001.13452665333],
						[535624.33166298305, 640001.19736558362],
						[535623.86583038094, 640216.33233699366],
						[535680.48903662013, 640216.45504098851],
						[535680.42258890753, 640247.09381738701],
						[535737.76586638147, 640247.43950007658],
						[535737.69955213193, 640277.96767123789],
						[535766.73170552845, 640278.03076145856],
						[535766.66461601167, 640308.89076478232],
						[535794.97605990688, 640308.9523381578],
						[535794.90963923803, 640339.48051765794],
						[535823.94168408576, 640339.54370883317],
						[535823.87448698364, 640370.40372058633],
						[535852.18582502683, 640370.46539240959],
						[535851.85126113915, 640523.99124983046],
						[535880.05938551959, 640524.05274527357],
						[535879.99208234169, 640554.91278283892],
						[535937.33476744848, 640555.03794250381],
						[535937.26808155084, 640585.56615576404],
						[535994.61065980978, 640585.69151506643],
						[535994.54314149159, 640616.55156083452],
						[536022.8540559489, 640616.61352635012],
						[536022.78672670608, 640647.36296685843],
						[536051.81822825084, 640647.42656015814],
						[536051.7510871233, 640678.06539535569],
						[536109.09334297688, 640678.19115368673]
					]
				],
				[
					[
						[532361.32552450476, 641315.47068540414],
						[532361.38557770627, 641284.94235508959],
						[532389.59239737503, 641284.99786581192],
						[532389.71282621368, 641223.83060839213],
						[532418.84625547729, 641223.88799344446],
						[532418.90706896747, 641193.02784669353],
						[532447.11404623056, 641193.08345604211],
						[532447.17469446792, 641162.3339235977],
						[532476.30823263386, 641162.39141040901],
						[532476.63183460897, 640998.46771777363],
						[532476.73315123399, 640947.14480562962],
						[532504.94055008434, 640947.20051412284],
						[532505.00130543194, 640916.4510166226],
						[532476.79385385616, 640916.39530802169],
						[532476.91504072119, 640855.00693548808],
						[532419.57340118231, 640854.89383710467],
						[532419.63421456935, 640824.03374263807],
						[532304.95071918098, 640823.80814504717],
						[532304.76957595663, 640916.05661373842],
						[532276.45917680208, 640916.00104647735],
						[532276.33830343583, 640977.6106572377],
						[532247.30738456058, 640977.55372634495],
						[532247.24754425383, 641008.0820139969],
						[532161.59619726939, 641007.914346523],
						[532161.53586718556, 641038.77446805383],
						[532133.32862535131, 641038.71934835555],
						[532133.26899631089, 641069.24764502607],
						[532075.92810350854, 641069.13574441965],
						[532075.80797991226, 641130.74540006882],
						[532104.01506395952, 641130.80042114353],
						[532103.89483469655, 641192.41009402263],
						[532133.02831960353, 641192.46697291697],
						[532132.96804238099, 641223.3271207161],
						[532161.17496769235, 641223.38223980251],
						[532161.11571873736, 641253.68934251764],
						[532190.24909512431, 641253.74632274336],
						[532190.18871032167, 641284.60647901148],
						[532246.70529531117, 641284.71716353775],
						[532246.64545492129, 641315.24549427419],
						[532361.32552450476, 641315.47068540414]
					]
				],
				[
					[
						[537697.73977938306, 646274.05138330581],
						[537697.81077226019, 646243.07992078911],
						[537726.11200431839, 646243.14481736359],
						[537726.25308169553, 646181.64435547683],
						[537697.95174380706, 646181.5794586587],
						[537698.09246176714, 646120.18962667696],
						[537669.07061773795, 646120.12312826933],
						[537669.35259692173, 645997.01168047951],
						[537698.37465819833, 645997.07817938272],
						[537698.44438325649, 645966.65981842356],
						[537753.40115380322, 645966.78588242526],
						[537755.1186440516, 645935.92885731522],
						[537784.14081311924, 645935.99550756812],
						[537784.21095064864, 645905.46654358401],
						[537841.53498639213, 645905.59834036487],
						[537841.60650285415, 645874.51632020483],
						[537869.90836915013, 645874.58146422869],
						[537869.978665606, 645844.0525094755],
						[537898.17766825703, 645844.11746517196],
						[537898.31862071098, 645782.94895696861],
						[537927.44397618016, 645783.01609725715],
						[537927.72813826741, 645659.79423782032],
						[537955.20703630208, 645659.85762995295],
						[537956.06913292175, 645598.46961391007],
						[537985.09189748962, 645598.53661876731],
						[537985.16317287576, 645567.67586822913],
						[538013.4655671973, 645567.74125929177],
						[538013.8204199227, 645414.21185786754],
						[537985.51776139659, 645414.14646619302],
						[537985.65954564395, 645352.75685879716],
						[537956.63634736184, 645352.68985293712],
						[537956.77802323317, 645291.30026300054],
						[537985.80132984649, 645291.3672691097],
						[537985.8726051324, 645260.50656314881],
						[538014.17552804551, 645260.57195543509],
						[538014.24660077156, 645229.82186589658],
						[538042.54957648565, 645229.88730700884],
						[538042.62044626998, 645199.24783383915],
						[538071.64391532098, 645199.31499142828],
						[538071.71509520453, 645168.56491100194],
						[538129.04169941507, 645168.69770988752],
						[538129.11273004068, 645138.05824592337],
						[538230.3864876657, 645138.29333807621],
						[538242.94278678391, 645138.32252913248],
						[538243.01428664569, 645107.57245831098],
						[538214.81402111868, 645107.50691136101],
						[538214.95665835962, 645046.11739451322],
						[538185.82999790949, 645046.04974506993],
						[538185.90164736926, 645015.18907558825],
						[538157.70122344396, 645015.12362656486],
						[538157.84364665276, 644953.73413579271],
						[538129.54019571701, 644953.66849627788],
						[538129.6109698416, 644923.13967489114],
						[537929.42851587594, 644922.45559076359],
						[537929.49968366686, 644891.59493797075],
						[537872.17211361614, 644891.46283458453],
						[537872.24240974325, 644860.93402091344],
						[537843.9387991156, 644860.86887287872],
						[537844.29230747581, 644707.22936544428],
						[537871.77279704483, 644707.29261816887],
						[537872.73753870709, 644645.90510923276],
						[537900.93910546508, 644645.74884661753],
						[537901.15142503672, 644553.6094671397],
						[537872.95020968933, 644553.54450634774],
						[537873.02076040232, 644522.90512954118],
						[537844.71656807582, 644522.83998016105],
						[537844.78681155015, 644492.31121906883],
						[537787.45784979302, 644492.1794109554],
						[537787.38771273184, 644522.70817229396],
						[537672.73000066471, 644522.44515601348],
						[537672.65982305794, 644553.08453367825],
						[537644.35568266455, 644553.01972909085],
						[537644.28530461492, 644583.76972276461],
						[537529.73094216944, 644583.5079388991],
						[537529.66052588844, 644614.36854900676],
						[537472.33198956912, 644614.23783926503],
						[537472.19212811312, 644675.62723869889],
						[537499.67267047905, 644675.68986972654],
						[537501.07655134285, 644737.08280652738],
						[537529.38037499192, 644737.1473645519],
						[537529.31021104869, 644767.8973852701],
						[537557.51105886663, 644767.96175686212],
						[537557.0900112245, 644952.35136181116],
						[537528.88947955926, 644952.28699094721],
						[537528.74940391118, 645013.67648711521],
						[537500.44605612929, 645013.61193017266],
						[537500.37569281028, 645044.47260261711],
						[537443.04865561717, 645044.34199494589],
						[537442.97915529273, 645074.87083684246],
						[537357.34898135439, 645074.67611853103],
						[537357.27888625534, 645105.53680047567],
						[537329.07861723669, 645105.47277220059],
						[537321.90731174569, 645136.20673069276],
						[537270.85874470358, 645136.09097073355],
						[537270.65019865811, 645228.11999868345],
						[537214.8676004241, 645227.99368479929],
						[537214.00775700924, 645289.60285691055],
						[537184.88152774749, 645289.53698005527],
						[537184.60393826512, 645412.31619080529],
						[537127.38110196241, 645412.1869160817],
						[537127.31168651115, 645442.9370360577],
						[537156.3347255385, 645443.00257845025],
						[537156.19603597326, 645504.39221951563],
						[537127.17310527992, 645504.32667736674],
						[537127.10344010522, 645535.18742267054],
						[537098.80098976614, 645535.12355689658],
						[537098.45467581146, 645688.65306667949],
						[537126.75686194946, 645688.71693185298],
						[537126.68719671422, 645719.57770393766],
						[537098.38506368292, 645719.51383888605],
						[537098.24608889886, 645781.1247846249],
						[537126.54811590852, 645781.18864944146],
						[537126.20203674561, 645934.49711210083],
						[537155.22420833691, 645934.56265253341],
						[537155.08576834644, 645995.84182348417],
						[537212.40948908823, 645995.97142745298],
						[537212.33891089726, 646027.16408059408],
						[537268.83920309134, 646027.29201838479],
						[537268.77002167166, 646057.82100226416],
						[537326.09352638572, 646057.95100248291],
						[537326.16281421413, 646027.4220188472],
						[537383.48642488476, 646027.55221910845],
						[537383.41703064623, 646058.08120249782],
						[537440.74053445261, 646058.2116023202],
						[537440.6707819826, 646088.85120214918],
						[537497.9941785424, 646088.98180152685],
						[537497.92406706838, 646119.73201784631],
						[537526.22551138583, 646119.79657044099],
						[537526.15458981891, 646150.87862803764],
						[537554.35306638933, 646150.94299421681],
						[537554.28385957191, 646181.25076995022],
						[537579.39486533287, 646181.30812933191],
						[537583.23507154745, 646212.1779074698],
						[537611.53635678091, 646212.24260687106],
						[537611.39545513864, 646273.85369108035],
						[537697.73977938306, 646274.05138330581]
					]
				],
				[
					[
						[536695.81053725362, 646670.9877538397],
						[536695.94751885568, 646609.59777073492],
						[536724.96849913429, 646609.66255191772],
						[536725.10336594842, 646549.26809969451],
						[536696.08450041793, 646548.20780546602],
						[536696.15336140594, 646517.3469107385],
						[536667.85260121338, 646517.28378656507],
						[536667.98947707447, 646455.89384785062],
						[536638.96822544909, 646455.82916721446],
						[536639.03673241346, 646425.07889818575],
						[536610.73581344169, 646425.01587230165],
						[536610.80451371591, 646394.15499516658],
						[536582.60645415576, 646394.09224678995],
						[536582.74301070429, 646332.70234305633],
						[536553.61862867756, 646332.63758411678],
						[536553.68672965234, 646301.9979450102],
						[536525.48851208203, 646301.93529456598],
						[536525.55631485151, 646271.40627217363],
						[536468.23355414055, 646271.27906222898],
						[536468.30223159702, 646240.30759448931],
						[536440.00099465693, 646240.24486241629],
						[536440.1372626028, 646178.74438968406],
						[536411.11552190955, 646178.68011112988],
						[536411.25143639534, 646117.29026832525],
						[536382.94998776785, 646117.22763442551],
						[536383.83335604437, 645717.91755772126],
						[536354.81080215261, 645717.8533785271],
						[536354.94699138193, 645656.24244444096],
						[536326.64474935876, 645656.17990743672],
						[536326.71291310177, 645625.31914094894],
						[536183.86350913253, 645625.00424230867],
						[536184.06573605468, 645533.08564004907],
						[536154.9399379855, 645533.02158712875],
						[536155.00777899241, 645502.16083776322],
						[535926.52935440314, 645501.66016152548],
						[535926.39525466529, 645563.0498305189],
						[535898.19577009999, 645562.98825561674],
						[535898.12841069873, 645593.84901495255],
						[535869.00272023119, 645593.78546839987],
						[535869.07002498209, 645562.92470894789],
						[535840.87054020108, 645562.86323234055],
						[535841.60693510901, 645224.94373871316],
						[535813.30395088578, 645224.8820850855],
						[535813.37018607871, 645194.46382627904],
						[535756.04415262712, 645194.11787497299],
						[535755.97754252004, 645224.75735769945],
						[535699.474493274, 645224.63461726217],
						[535698.51740680903, 645286.24364494625],
						[535669.49409116444, 645286.1806750939],
						[535669.42788177566, 645316.70955954259],
						[535641.12505547167, 645316.6482022102],
						[535640.99202264403, 645378.03782029299],
						[535612.68930187798, 645377.97651189135],
						[535612.62247900991, 645408.83724562463],
						[535583.59937969514, 645408.77442734852],
						[535583.46608215768, 645470.38529649761],
						[535612.48907275335, 645470.44811453857],
						[535612.35614547308, 645531.83777726663],
						[535583.3332632127, 645531.77495945501],
						[535582.93432751333, 645716.16527898307],
						[535611.95688438648, 645716.22809608653],
						[535611.82347793831, 645777.83905413526],
						[535640.12551060179, 645777.9003610441],
						[535640.05935360212, 645808.42931624479],
						[535665.99425893533, 645808.48553832842],
						[535668.29488418973, 645839.13024340756],
						[535697.31722407369, 645839.19321114128],
						[535697.25096063979, 645869.72217491583],
						[535725.55283519148, 645869.78362882941],
						[535725.48531783791, 645900.86565794004],
						[535754.50754878169, 645900.92872659711],
						[535754.24014552392, 646023.9295407969],
						[535725.21813163359, 646023.86647261283],
						[535725.01846270624, 646115.78529348178],
						[535754.04031439056, 646115.84836131183],
						[535753.90685311507, 646177.2382095037],
						[535778.29746712372, 646177.29125272774],
						[535782.07439086027, 646238.80023905006],
						[535811.09602546727, 646238.86340756284],
						[535810.96210928471, 646300.36390332866],
						[535839.26324276603, 646300.42555292288],
						[535839.12922071014, 646361.92606632644],
						[535867.32733542717, 646361.98753994552],
						[535867.26075413264, 646392.51657830167],
						[535896.38503011758, 646392.5801217698],
						[535896.317670458, 646423.44100185635],
						[535923.79529260192, 646423.50099993614],
						[535924.38133775594, 646485.00312196219],
						[535951.13847264578, 646485.06159212464],
						[535953.33555446891, 646515.70620987331],
						[536009.9370801819, 646515.8300477704],
						[536009.8695068903, 646546.6909453416],
						[536210.03270514472, 646547.13044290163],
						[536210.10065404314, 646516.26954615745],
						[536235.211148281, 646516.32485314924],
						[536239.29222693841, 646485.6940296524],
						[536267.49012943963, 646485.75618938985],
						[536267.55745409778, 646455.2271393328],
						[536295.85880932049, 646455.06834967237],
						[536295.926674744, 646424.31807921897],
						[536324.9479819733, 646424.38215450442],
						[536324.88006228884, 646455.13242483884],
						[536353.18092943507, 646455.19495880662],
						[536353.11295682297, 646485.94523349742],
						[536379.76717812754, 646486.00417354808],
						[536382.06637311727, 646516.64907621127],
						[536410.3671344039, 646516.71170859295],
						[536410.23121966037, 646578.10166726494],
						[536439.25225551904, 646578.16594426124],
						[536439.18387633422, 646609.02684902411],
						[536465.11751919286, 646609.0843312582],
						[536467.41678218788, 646639.61865108332],
						[536495.61442076834, 646639.6812019581],
						[536495.54593554302, 646670.54211544781],
						[536695.81053725362, 646670.9877538397]
					]
				],
				[
					[
						[537953.30350639333, 646796.84359916218],
						[537953.37472773052, 646765.98267389229],
						[538010.69576414221, 646766.11506029801],
						[538010.83765493287, 646704.72506156645],
						[538039.13809256698, 646704.79049680696],
						[538039.35121506127, 646612.6502262539],
						[537810.88821713324, 646612.12337273522],
						[537810.95917036058, 646581.2624737873],
						[537782.65852015663, 646581.19743119949],
						[537782.7286578971, 646550.66837418592],
						[537697.10616746417, 646550.47188700549],
						[537697.03618866729, 646581.00094438158],
						[537668.01515781204, 646580.93444784067],
						[537667.73343120038, 646703.93562274869],
						[537696.75424500532, 646704.00211879401],
						[537696.68350551627, 646734.86303619819],
						[537753.28427694517, 646734.99287416798],
						[537753.21419301664, 646765.52195794822],
						[537810.535231038, 646765.65364669333],
						[537810.46427774604, 646796.51457258069],
						[537953.30350639333, 646796.84359916218]
					]
				],
				[
					[
						[530348.20517817792, 647303.36671091965],
						[530348.26151771029, 647272.83751858247],
						[530377.38423473574, 647272.89128840354],
						[530377.44205859583, 647241.58780965139],
						[530434.76143733354, 647241.69379014825],
						[530434.81752790418, 647211.38583302405],
						[530463.01418615109, 647211.43804045964],
						[530463.07135317707, 647180.57702300162],
						[530491.37097195094, 647180.62946968665],
						[530491.42716662493, 647150.32152155833],
						[530520.4480138605, 647149.93290215998],
						[530520.50528843852, 647119.07189392729],
						[530548.80501305452, 647119.12443944823],
						[530548.86172430299, 647088.5952745548],
						[530606.18163629365, 647088.70185253664],
						[530606.23865980713, 647058.06207937247],
						[530635.25884870556, 647058.11611434293],
						[530635.3161323315, 647027.36573285703],
						[530663.61601476232, 647027.4184759506],
						[530663.6739700326, 646996.33626047545],
						[530691.97390585765, 646996.38905236952],
						[530692.03046955261, 646966.0811314669],
						[530721.05082077044, 646966.13531782955],
						[530721.10847109789, 646935.27433725586],
						[530749.30560276646, 646935.32703556819],
						[530749.36309918039, 646904.57667241688],
						[530778.48646836018, 646904.63115255395],
						[530778.54422624072, 646873.77018119418],
						[530835.04161001125, 646873.87601607142],
						[530835.09885171161, 646843.34688775637],
						[530864.11941951106, 646843.40132658486],
						[530864.17692266649, 646812.76159001887],
						[530892.47717439663, 646812.814726952],
						[530892.53493805311, 646782.06438219466],
						[530921.55561399343, 646782.11892237421],
						[530921.61363988323, 646751.25796947081],
						[530949.91399745306, 646751.31120523985],
						[530949.97145193582, 646720.78209507803],
						[530978.27186195122, 646720.83537964744],
						[530978.32999403821, 646689.97443591268],
						[531007.35083248501, 646690.02912749583],
						[531007.40881046827, 646659.27880105027],
						[531064.73021884356, 646659.38697729923],
						[531064.78851293551, 646628.52604287479],
						[531093.08908171067, 646628.57952502545],
						[531093.16436840536, 646588.75897126715],
						[531093.26767846593, 646534.1163347119],
						[531093.43728257506, 646444.40952678572],
						[531121.63525587239, 646444.46286348952],
						[531121.9260001519, 646290.82206924818],
						[531065.42661333526, 646290.71524879639],
						[531065.44959663111, 646278.54787597083],
						[531065.54278343439, 646229.21471694775],
						[531036.52113180805, 646229.15992267942],
						[531036.57895384158, 646198.5202757892],
						[531008.27764500387, 646198.46689088549],
						[531008.21987569914, 646229.10653787479],
						[530722.42864067364, 646228.57017745869],
						[530722.37078390364, 646259.54166730016],
						[530579.42397527758, 646259.27525428997],
						[530579.36721038003, 646289.80429920042],
						[530464.72181691066, 646289.59152997518],
						[530464.66505992517, 646320.23119219183],
						[530407.34246943286, 646320.12510747463],
						[530407.22896450735, 646381.51505815343],
						[530379.03088328277, 646381.46294636722],
						[530378.97387695382, 646412.32384731772],
						[530321.65160744952, 646412.21806127485],
						[530321.5949126163, 646442.96835435391],
						[530264.27274992119, 646442.86276830558],
						[530264.21616225713, 646473.61306605255],
						[530293.23738251009, 646473.66649747104],
						[530293.12409863435, 646535.16710618406],
						[530264.1029869112, 646535.11367496103],
						[530264.04680632707, 646565.64276085154],
						[530206.72507121775, 646565.5373753896],
						[530206.66838753503, 646596.39830384881],
						[530178.36776338611, 646596.34634709172],
						[530178.19868352043, 646688.4867089917],
						[530150.00112862675, 646688.43498989218],
						[530149.83200388274, 646780.68600502517],
						[530120.70841520303, 646780.63263818133],
						[530120.54006152751, 646872.55185552395],
						[530092.34282223403, 646872.50023528864],
						[530092.28635205445, 646903.3612090305],
						[530120.48353843519, 646903.41282916942],
						[530120.37069482042, 646965.02417715453],
						[530149.49395695946, 646965.07754339802],
						[530149.2128931242, 647118.38700758165],
						[530177.40971082775, 647118.43872532714],
						[530177.29665234743, 647180.05013572844],
						[530149.09994028357, 647179.99841817829],
						[530148.987798566, 647241.16739481688],
						[530177.18440574757, 647241.21911217435],
						[530177.12696308456, 647272.52259162336],
						[530205.42642363452, 647272.5745462476],
						[530205.4839201686, 647241.27106689778],
						[530234.50378577283, 647241.32439467078],
						[530234.44623399642, 647272.62787392142],
						[530291.76550454891, 647272.73335600155],
						[530291.70926989627, 647303.26254853699],
						[530348.20517817792, 647303.36671091965]
					]
				],
				[
					[
						[538093.35868463642, 647688.04829306295],
						[538094.32413190277, 647626.65993347659],
						[538119.43293072493, 647626.71811741882],
						[538123.4146052961, 647595.97674932214],
						[538151.71350922144, 647596.04237829451],
						[538151.92804479634, 647503.5698806775],
						[538266.56497543794, 647503.83623737551],
						[538266.6355009845, 647473.52827500843],
						[538294.8317097543, 647473.59391080425],
						[538294.90357516892, 647442.73288804095],
						[538324.02599131397, 647442.80073063541],
						[538324.09662247973, 647412.4927773294],
						[538352.29293589643, 647412.55851164949],
						[538352.36594072683, 647381.25504633447],
						[538408.86158101982, 647381.38690060575],
						[538409.75613806024, 647350.85965349793],
						[538438.05546379567, 647350.92577521934],
						[538438.12708032026, 647320.28599693975],
						[538467.14680647803, 647320.35385246156],
						[538467.21821831947, 647289.82469166094],
						[538495.5176490841, 647289.89091226645],
						[538495.59092595789, 647258.58746587799],
						[538523.78750325623, 647258.65349423862],
						[538523.85850172455, 647228.34556837077],
						[538552.98129753093, 647228.41381642618],
						[538553.05364623119, 647197.55283082486],
						[538610.37317840441, 647197.68730740552],
						[538610.44433616148, 647167.37939070899],
						[538637.92175487813, 647167.00147220935],
						[538638.71357900847, 647136.58463973377],
						[538667.01431379654, 647136.20870422013],
						[538667.15813789866, 647075.0398295162],
						[538719.74431232607, 647075.1635576071],
						[538724.55050642358, 647044.42435422156],
						[538781.87057232228, 647044.55942855333],
						[538781.94387138181, 647013.47724547586],
						[538896.58421844034, 647013.74799402361],
						[538896.65590280853, 646983.44010511355],
						[538924.85295187519, 646983.50682113913],
						[538924.99878081365, 646921.89554239635],
						[538896.80162610754, 646921.82882612152],
						[538896.94682612189, 646860.43879044335],
						[538867.82337866724, 646860.36993325863],
						[538867.89579358697, 646829.73022830859],
						[538754.07744295534, 646829.46161980415],
						[538754.00524009112, 646860.10132525268],
						[538553.84585084429, 646859.63086475362],
						[538553.91768079391, 646828.99115843268],
						[538524.79417764372, 646828.9229087173],
						[538524.72240195947, 646859.56261516863],
						[538410.90425780416, 646859.29638174211],
						[538410.83295251639, 646889.82548045227],
						[538267.99453145417, 646889.49247995357],
						[538267.92271914217, 646920.35342180752],
						[538238.79937778926, 646920.28567856736],
						[538238.72787731746, 646951.03601234336],
						[538210.53077257634, 646950.9704727435],
						[538210.38864806271, 647012.13931573252],
						[538181.26546925702, 647012.07167437882],
						[538181.1219121638, 647073.90421207342],
						[538152.92501809401, 647073.83877124148],
						[538152.71150944417, 647165.86862874555],
						[538124.41186525137, 647165.80299805675],
						[538124.19877130864, 647257.7222832425],
						[538095.17893462733, 647257.65503290715],
						[538095.03569890303, 647319.48764347809],
						[538066.73631906917, 647319.42211203871],
						[538066.5222651267, 647411.89452991076],
						[538094.82148582826, 647411.96006097901],
						[538094.5370640147, 647534.74048673292],
						[538066.2380545995, 647534.67495615175],
						[538066.16738601006, 647565.20415434637],
						[538008.84913482249, 647565.07157459133],
						[538008.70724345371, 647626.46182400419],
						[538037.00609491637, 647626.52725558239],
						[538036.86409786146, 647687.91752267827],
						[538093.35868463642, 647688.04829306295]
					]
				],
				[
					[
						[534377.72009389556, 647956.50585418544],
						[534377.7846103973, 647925.6447429785],
						[534435.10160483082, 647925.76466665533],
						[534435.16553400818, 647895.2354000397],
						[534463.36101972603, 647895.294466438],
						[534463.71338156599, 647727.16235363949],
						[534463.7474586498, 647710.9022156616],
						[534474.75822796882, 647710.92529511696],
						[534492.86939989601, 647710.96327362838],
						[534492.92253082141, 647685.63285720034],
						[534492.99816696811, 647649.57296833955],
						[534578.51203037077, 647649.75255742623],
						[534578.64158181741, 647588.14104451542],
						[534550.44556945434, 647588.08178046229],
						[534550.50994374615, 647557.44195031188],
						[534464.06945218914, 647557.26056583866],
						[534464.13343359937, 647526.73135289818],
						[534435.93731594668, 647526.67228517996],
						[534436.0028663883, 647495.36878509645],
						[534235.74830362294, 647494.9506651049],
						[534235.68313437095, 647526.25416598143],
						[534207.48701590172, 647526.19548995851],
						[534207.42351094517, 647556.72470389609],
						[534178.30129655555, 647556.66415142443],
						[534178.23761576088, 647587.30398302223],
						[534150.04160196462, 647587.24540549819],
						[534149.78617001802, 647710.24722973094],
						[534207.10391521954, 647710.36635872396],
						[534206.97575473459, 647771.97791061504],
						[534235.17145178898, 647772.03658575704],
						[534234.98008879565, 647863.95618747314],
						[534263.27853157488, 647864.01512503973],
						[534263.15062027657, 647925.40549495397],
						[534292.16927861597, 647925.46598309476],
						[534292.10492278915, 647956.32709464151],
						[534377.72009389556, 647956.50585418544]
					]
				],
				[
					[
						[537750.03983737738, 648148.2949895463],
						[537750.1106835563, 648117.43386508059],
						[537836.44532872434, 648117.63228555722],
						[537836.51557339041, 648087.10300597746],
						[537864.81363216124, 648087.16814123769],
						[537864.95550003264, 648025.55652920785],
						[537893.15076229954, 648025.62147628784],
						[537893.57566301653, 647841.2292022683],
						[537865.3800845911, 647841.16425446025],
						[537865.45063639793, 647810.52440206939],
						[537837.15210156655, 647810.45926571009],
						[537837.29335420695, 647749.06896095094],
						[537808.27438458148, 647749.00221689825],
						[537808.48622812366, 647656.86148647533],
						[537780.1874288593, 647656.79644814471],
						[537780.32897566794, 647595.18496162398],
						[537723.01082897873, 647595.0533781586],
						[537723.081114389, 647564.41356099781],
						[537694.78215603728, 647564.34866963793],
						[537694.85213516059, 647533.81946985703],
						[537665.83278569521, 647533.75297716819],
						[537666.25563056464, 647349.1399025938],
						[537695.27530580654, 647349.20639602758],
						[537695.41551744984, 647288.03745042707],
						[537723.71495129121, 647288.10234288033],
						[537723.78675902099, 647256.79889308731],
						[537735.51818298397, 647256.82580828667],
						[537752.08624662168, 647256.86383435794],
						[537752.226668727, 647195.69491610199],
						[537781.24661474291, 647195.7615612481],
						[537781.45829916827, 647103.62107271166],
						[537695.83868759905, 647103.42459213373],
						[537695.90892012022, 647072.78484640201],
						[537666.88875708939, 647072.71835184935],
						[537667.17048419337, 646949.71696203679],
						[537581.55007134879, 646949.52107649087],
						[537581.47954690887, 646980.38203032617],
						[537552.45922081964, 646980.31573769404],
						[537552.39001373458, 647010.62363236537],
						[537495.89309971372, 647010.49472044886],
						[537495.82223133289, 647041.57690916292],
						[537438.50215504121, 647041.44631735061],
						[537438.432150434, 647072.19667250314],
						[537381.11218087305, 647072.06628072495],
						[537381.04253486311, 647102.7060277937],
						[537352.74278198218, 647102.64172503049],
						[537352.67343993194, 647133.1708638483],
						[537238.03392540361, 647132.91087789868],
						[537237.96404475276, 647163.77186016063],
						[537209.76730476797, 647163.70803645998],
						[537209.83713250351, 647132.84705407638],
						[537123.49731707107, 647132.65192340396],
						[537123.56623367907, 647102.12278362876],
						[537066.96672580333, 647101.99511295324],
						[537066.89791426598, 647132.52425296931],
						[537037.87785665935, 647132.45886840147],
						[537037.66959063755, 647224.93121841329],
						[537066.68948506401, 647224.99660261581],
						[537066.48180371919, 647317.1371540667],
						[537123.08057114156, 647317.26482307108],
						[537122.87182349095, 647409.73725307162],
						[537151.89139179909, 647409.80278762395],
						[537151.82292100543, 647440.11074588681],
						[537122.80340618012, 647440.04521145625],
						[537122.7337403663, 647470.90623926127],
						[537066.13550172967, 647470.77857145225],
						[537065.58151775203, 647716.56082747772],
						[537093.88021417207, 647716.62463607849],
						[537093.81085088477, 647747.37509146321],
						[537122.10949427413, 647747.43894864339],
						[537121.76266278781, 647901.0806792737],
						[537150.78136404883, 647901.14621187153],
						[537150.64267287345, 647962.53656740533],
						[537121.62407994375, 647962.47103505395],
						[537121.48549706035, 648023.86140879756],
						[537150.5039816536, 648023.9269409026],
						[537150.43451107992, 648054.67744104879],
						[537178.62972341746, 648054.74116301874],
						[537178.55995002901, 648085.60228088754],
						[537207.68122771406, 648085.6681465432],
						[537207.7510557546, 648054.80702879617],
						[537264.24438210693, 648054.93495081284],
						[537264.17444804357, 648085.79606831912],
						[537321.49088425352, 648085.9260525062],
						[537321.42159574851, 648116.4553342727],
						[537378.73792509537, 648116.58551798959],
						[537378.80732000759, 648086.05623646954],
						[537407.10538058181, 648086.12058408477],
						[537407.2455335597, 648024.50896812906],
						[537436.26401700848, 648024.57500450558],
						[537436.33377012017, 647993.93512335664],
						[537459.07524802373, 647993.98691115458],
						[537493.65052651044, 647994.06570761185],
						[537493.70147127018, 647971.72182616277],
						[537493.72063860518, 647963.31521791755],
						[537550.21427927422, 647963.44412236486],
						[537549.9334082572, 648086.44610721222],
						[537578.95178241085, 648086.51239538053],
						[537578.81149108871, 648147.90280124999],
						[537694.26714330364, 648148.16704973031],
						[537722.56509699137, 648148.2319402037],
						[537750.03983737738, 648148.2949895463]
					]
				],
				[
					[
						[529513.50943507859, 650865.95192704687],
						[529513.785235969, 650712.30785425473],
						[529484.77149543981, 650712.25579829351],
						[529484.88158826984, 650650.86456984049],
						[529456.69082722883, 650650.81403949379],
						[529456.6351398346, 650681.896803424],
						[529399.32775192487, 650681.79423217056],
						[529399.27355739521, 650712.1026970672],
						[529370.98001574853, 650712.0521297087],
						[529370.92488536425, 650742.91367344069],
						[529341.91119884653, 650742.86186957429],
						[529341.85651772504, 650773.50218825624],
						[529427.3539385075, 650773.76560578321],
						[529427.29870208772, 650804.62715852249],
						[529456.41516463563, 650804.67929739552],
						[529456.30557333934, 650865.84934188321],
						[529484.49596567894, 650865.89987156715],
						[529484.44082002982, 650896.65082292154],
						[529570.04068285844, 650896.80455205915],
						[529570.0959886089, 650866.0536009965],
						[529513.50943507859, 650865.95192704687]
					]
				],
				[
					[
						[530283.04985054838, 652004.36901462986],
						[530283.10669773398, 651973.50728533475],
						[530311.39806860418, 651973.55942232697],
						[530311.45435705571, 651943.02954424534],
						[530339.64290247404, 651943.08154015837],
						[530339.58656167623, 651973.61141814373],
						[530426.00383914832, 651973.77112259273],
						[530426.11745583091, 651912.37952532782],
						[530454.30605380121, 651912.43171784491],
						[530454.36301721598, 651881.68061846052],
						[530426.17436652142, 651881.62842585007],
						[530426.23107248347, 651850.98794640601],
						[530368.92775943654, 651850.88199561881],
						[530368.87116026925, 651881.52247525542],
						[530339.75660470978, 651881.46872050315],
						[530339.81314961298, 651850.82824076735],
						[530311.62444602069, 651850.77624455979],
						[530311.567953652, 651881.41672439745],
						[530283.27642421564, 651881.36458711349],
						[530283.21978081018, 651912.11568708986],
						[530254.20815752621, 651912.0622733403],
						[530254.26474666398, 651881.31117326475],
						[530225.973217046, 651881.25913459575],
						[530225.91668082355, 651912.01023476757],
						[530168.6135804723, 651911.90498217347],
						[530168.67000950919, 651881.15388180339],
						[530083.17814982985, 651880.99722422974],
						[530083.2342165442, 651850.35674361314],
						[530111.42292085872, 651850.40834822459],
						[530111.59168374829, 651758.26570328185],
						[530168.89531961083, 651758.37075712497],
						[530169.06501253915, 651665.89630801883],
						[530185.62863413175, 651665.92671105673],
						[530197.35691275995, 651665.94824876112],
						[530197.38677908422, 651649.68779376009],
						[530197.41298830777, 651635.41841593373],
						[530226.42509976926, 651635.47172946227],
						[530226.47553489148, 651608.03913000762],
						[530197.46926701046, 651604.77797232894],
						[530197.58284026117, 651542.94402240613],
						[530169.29072836752, 651542.8920812814],
						[530169.34634537564, 651512.58349712961],
						[530197.63850942848, 651512.63543835073],
						[530197.80836128572, 651420.16109997383],
						[530255.11317561101, 651420.26645432692],
						[530255.22574293485, 651359.09625130927],
						[530284.23834201228, 651359.14966685744],
						[530284.29498526547, 651328.39864951523],
						[530312.58746627357, 651328.45078854682],
						[530312.64355060284, 651298.03162132762],
						[530340.83442672621, 651297.41992841521],
						[530340.89035907073, 651267.11138100049],
						[530398.1957068484, 651267.21723406774],
						[530398.25276742165, 651236.35561575415],
						[530340.9473120718, 651236.24976248853],
						[530341.06101391721, 651174.63715439255],
						[530398.36668401514, 651174.74300805759],
						[530398.48019154347, 651113.35164885246],
						[530478.62612215534, 651113.50002751674],
						[530541.38480929518, 651113.61648894614],
						[530541.43494628288, 651086.62642012711],
						[530598.74751082039, 651083.19329132198],
						[530599.14812390471, 650867.93656235852],
						[530581.86350593541, 650867.9044031041],
						[530570.85485042527, 650867.88393019827],
						[530570.88981507614, 650849.07939612516],
						[530570.91182223626, 650837.24360202474],
						[530456.29812895996, 650837.03089163546],
						[530456.46881337836, 650744.88870350062],
						[530428.27821355022, 650744.83650727873],
						[530428.33532862936, 650713.97496716096],
						[530399.21870544949, 650713.92110710335],
						[530399.27474327607, 650683.6126455575],
						[530428.39142013201, 650683.66650571418],
						[530428.56256057974, 650591.19254131569],
						[530456.75342384051, 650591.24473802478],
						[530456.86775973253, 650529.5217084277],
						[530428.67679064348, 650529.46951152326],
						[530428.79020181694, 650468.18895893765],
						[530456.98127598362, 650468.24115603755],
						[530457.15196009388, 650376.09913216007],
						[530485.44607986545, 650376.15156865679],
						[530485.50289067649, 650345.51131299417],
						[530457.20871817891, 650345.45887640119],
						[530457.26527135528, 650314.92923978972],
						[530485.5594963883, 650314.98167648178],
						[530485.73095421796, 650222.50787738571],
						[530457.43657005287, 650222.455440399],
						[530457.4935329986, 650191.70459280908],
						[530485.7879700826, 650191.75702989206],
						[530485.84519103041, 650160.89557241695],
						[530514.85990451532, 650160.94939493015],
						[530514.95269476098, 650110.95163144905],
						[530514.9734288624, 650099.77956647996],
						[530485.95901762287, 650099.50451476418],
						[530486.01562326762, 650068.97491447616],
						[530515.03049895773, 650069.0287372896],
						[530515.08777433273, 650038.16729819146],
						[530543.38247563096, 650038.21983438509],
						[530543.49651613436, 649976.82881346089],
						[530572.51155443152, 649976.88273770479],
						[530572.56873167481, 649946.13192693971],
						[530543.55363911204, 649946.07800259662],
						[530543.6109675609, 649915.21658188396],
						[530572.62611458474, 649915.27050633181],
						[530572.74026335031, 649853.87952198042],
						[530543.7250079955, 649853.82559733139],
						[530543.78171998262, 649823.29603339231],
						[530572.79702921677, 649823.3499581432],
						[530572.9111779331, 649761.95900096069],
						[530515.60058357683, 649761.8525389313],
						[530515.71492885833, 649700.24037091201],
						[530486.69940238539, 649700.18654688902],
						[530486.75662319653, 649669.3251624913],
						[530458.46128708543, 649669.27272373997],
						[530458.57500776404, 649607.88181120832],
						[530401.26387637504, 649607.77574770059],
						[530401.15036967315, 649669.16666062875],
						[530315.64700745943, 649669.00879416359],
						[530315.42022454855, 649792.01190426841],
						[530343.61245807935, 649792.06390698219],
						[530343.55550547957, 649822.92531014781],
						[530315.36332486081, 649822.87330752751],
						[530315.30703698704, 649853.40287225682],
						[530343.49916525884, 649853.45487477514],
						[530343.44221263693, 649884.3162870612],
						[530372.56030497141, 649884.37004834239],
						[530372.50391067285, 649914.89962189482],
						[530429.81397158466, 649915.00558515615],
						[530429.58633095119, 650038.00883923494],
						[530400.4685106969, 650037.95497696812],
						[530400.41145045694, 650068.81641646847],
						[530343.10192565422, 650068.71055568277],
						[530343.04558536806, 650099.24015646079],
						[530286.55887463223, 650099.35724079085],
						[530286.50243547256, 650129.99746080977],
						[530257.48766737001, 650129.94404126785],
						[530257.4620192725, 650143.88147140993],
						[530257.43148582126, 650160.47365137038],
						[530171.82778938918, 650160.31634344673],
						[530171.88381198887, 650129.78673304967],
						[530114.57449969684, 650129.68166879716],
						[530114.34921414091, 650252.6850548489],
						[530143.46665413072, 650252.73841042817],
						[530143.29772929579, 650344.8803829333],
						[530114.18045247963, 650344.82702765428],
						[530114.12433364033, 650375.4672845914],
						[530085.93310040748, 650375.41567534895],
						[530085.82036055671, 650437.02804707608],
						[530056.70324692968, 650436.97479358723],
						[530056.64743706898, 650467.50444966345],
						[530028.45636164502, 650467.45293897355],
						[530028.39999806159, 650498.31444381317],
						[530056.59102057607, 650498.36595440959],
						[530056.31035343616, 650651.89924352802],
						[530085.42708645295, 650651.95249632292],
						[530085.37021044106, 650683.03525810619],
						[530056.25353247044, 650682.98200541036],
						[530056.19266729616, 650716.2770686961],
						[530056.14171040081, 650744.15200952126],
						[530030.31747363845, 650744.10482165974],
						[529999.65762272978, 650744.04885047837],
						[529999.6017158404, 650774.68916695099],
						[529970.58808539307, 650774.63625369174],
						[529970.47597645875, 650836.13813025679],
						[529944.54899934668, 650836.09088956134],
						[529942.12684814259, 650866.72691027273],
						[529916.19991926535, 650866.67971427913],
						[529913.05743280554, 650897.42504833662],
						[529887.13055233692, 650897.37789818645],
						[529855.75079611642, 650897.3208862202],
						[529855.69515685143, 650927.96122594737],
						[529799.21170064155, 650927.85875552101],
						[529799.15576566348, 650958.72032992588],
						[529741.84934262233, 650958.61656481284],
						[529741.79371529981, 650989.36752903217],
						[529712.6775798148, 650989.314884783],
						[529712.56623415905, 651050.92744218069],
						[529656.08320039418, 651050.82546346961],
						[529656.02793267078, 651081.46582670335],
						[529627.01484358043, 651081.41351972381],
						[529626.90421691677, 651142.80487510783],
						[529598.61141644407, 651142.75391603122],
						[529598.50089539273, 651204.14528986311],
						[529512.90263269015, 651203.99141254812],
						[529512.84743268602, 651234.74241416738],
						[529569.43271695042, 651234.84408583411],
						[529569.37721215771, 651265.70570698869],
						[529626.68256484356, 651265.80887094873],
						[529626.62794911361, 651296.11742075975],
						[529683.93319579388, 651296.2207842666],
						[529683.87707642454, 651327.30364452885],
						[529741.1822144076, 651327.40720757423],
						[529741.07115965907, 651388.7986353616],
						[529769.26065535191, 651388.84965330234],
						[529769.14949530654, 651450.24109918636],
						[529826.45420479064, 651450.3449594531],
						[529826.34242938145, 651511.95765377767],
						[529798.15314476565, 651511.90653796401],
						[529798.09821205027, 651542.21512336214],
						[529826.28744469921, 651542.266239085],
						[529826.17526789429, 651604.10019155708],
						[529854.46727446129, 651604.1515422326],
						[529854.41163500282, 651634.79198700725],
						[529883.42374757817, 651634.84469526168],
						[529883.31135519664, 651696.6786751207],
						[529911.60320244997, 651696.73012412235],
						[529911.49191113189, 651757.90042999526],
						[529854.18827363162, 651757.79627332836],
						[529854.13323672465, 651788.10489474679],
						[529883.14507875347, 651788.15760250541],
						[529883.03268629068, 651849.99162846571],
						[529911.32426971453, 651850.04307698575],
						[529911.21257581399, 651911.43465943402],
						[529940.22420020995, 651911.48746792064],
						[529940.16799690737, 651942.34918916877],
						[529968.45942140045, 651942.40073600924],
						[529968.40376989183, 651972.93061526073],
						[529997.4152857688, 651972.983524665],
						[529997.35897488357, 652003.84525494301],
						[530111.14151413937, 652004.05325862358],
						[530111.02866775729, 652065.66611674649],
						[530140.14289712417, 652065.71946644271],
						[530140.08692634385, 652096.24936339702],
						[530196.56636861549, 652096.35300486186],
						[530196.51008977299, 652126.99352175673],
						[530311.11479073227, 652127.2044211356],
						[530311.34116831422, 652004.42115152022],
						[530283.04985054838, 652004.36901462986]
					]
				],
				[
					[
						[529453.93815558276, 652187.25947196863],
						[529453.99344702926, 652156.39771212824],
						[529482.18162660988, 652156.44823785243],
						[529482.29172020778, 652095.05657903827],
						[529454.10343536432, 652095.0060531327],
						[529454.32380829914, 651972.00155916391],
						[529397.02091704973, 651971.89899596036],
						[529397.13069130818, 651910.50739170494],
						[529339.82758571988, 651910.40502784145],
						[529339.77250947524, 651941.26675112324],
						[529254.17808448372, 651941.11422082759],
						[529254.12375940068, 651971.64410246396],
						[529225.11224116385, 651971.59250470996],
						[529225.00271554256, 652033.20535956707],
						[529282.30539311108, 652033.30732320109],
						[529282.25042440335, 652064.16906516009],
						[529368.56434873468, 652064.32302803523],
						[529368.45507524244, 652125.49344727444],
						[529396.74618457153, 652125.54401028517],
						[529396.69119849242, 652156.29515007464],
						[529424.87937824766, 652156.3455775436],
						[529424.82414145442, 652187.20733748307],
						[529453.93815558276, 652187.25947196863]
					]
				],
				[
					[
						[533196.80532164755, 652286.53438540176],
						[533196.92973428499, 652224.92148502404],
						[533225.94080547709, 652224.98009164596],
						[533226.00250725134, 652194.45018747461],
						[533311.59561323409, 652194.62339646567],
						[533311.53375251056, 652225.15330031421],
						[533368.83576101996, 652225.26950755296],
						[533368.89772815676, 652194.73960391688],
						[533454.49083262938, 652194.91355686798],
						[533454.55363398872, 652164.05181139673],
						[533482.7418004371, 652164.10919643776],
						[533482.80442941794, 652133.35807126935],
						[533569.11799044267, 652133.53408768249],
						[533569.18055499461, 652102.89358297584],
						[533597.47170320712, 652102.95137479506],
						[533597.5340944234, 652072.42149029218],
						[533625.8252950738, 652072.47933090338],
						[533625.88841755735, 652041.61760455114],
						[533654.89981221617, 652041.67696813704],
						[533654.96276270971, 652010.92586201418],
						[533683.25406918454, 652010.98380145559],
						[533683.31729921629, 651980.12208458083],
						[533769.63166474632, 651980.29915372329],
						[533769.69437516329, 651949.76928815269],
						[533855.28875503363, 651949.94532779476],
						[533855.47872979462, 651857.69206692232],
						[533883.66742152523, 651857.75013938465],
						[533883.92093197792, 651734.74585639173],
						[533913.03574736323, 651734.80588753475],
						[533913.09826672007, 651704.4972896456],
						[533883.98339765565, 651704.43725838931],
						[533884.30142534629, 651550.12895459333],
						[533770.51574441325, 651549.89483711566],
						[533770.70455687237, 651457.97360013495],
						[533798.99681489635, 651458.03173874936],
						[533799.12302267482, 651396.64032195474],
						[533770.83065900544, 651396.58218312217],
						[533771.02060737915, 651304.10793905507],
						[533799.31313018, 651304.16607821046],
						[533799.50210059609, 651212.24495120568],
						[533771.20941961033, 651212.18681172165],
						[533771.33552159707, 651150.79546791106],
						[533799.62830822659, 651150.85360761033],
						[533799.69175313017, 651119.99202016485],
						[533771.39891339256, 651119.933880358],
						[533771.52456089994, 651058.76379393565],
						[533685.20535716938, 651058.5867148682],
						[533685.26858690742, 651027.72514074377],
						[533627.9624043589, 651027.60783058731],
						[533628.02530027507, 650996.85687579436],
						[533599.73224864213, 650996.79903139896],
						[533599.48132869648, 651119.58164848341],
						[533627.77416903933, 651119.63949244819],
						[533627.64860336855, 651181.03082817502],
						[533599.35586866969, 651180.97298442549],
						[533599.22995649814, 651242.58556877694],
						[533570.9373277243, 651242.52777393255],
						[533570.87431170605, 651273.38938066154],
						[533541.86156128382, 651273.33016534941],
						[533541.7997280577, 651303.63870129548],
						[533570.81242499338, 651303.69791649701],
						[533570.62360271311, 651396.17216287274],
						[533541.61106896226, 651396.11294800241],
						[533541.54878436262, 651426.64273234375],
						[533484.24399224063, 651426.52592312219],
						[533484.1185094167, 651488.13858182565],
						[533513.23376152827, 651488.19790495548],
						[533513.17085280607, 651519.05954871594],
						[533484.05565535021, 651519.00022569951],
						[533483.86799422756, 651611.14272400283],
						[533512.98302850476, 651611.20204668795],
						[533512.60805609287, 651795.15532031516],
						[533483.49334758008, 651795.09599829011],
						[533483.42959228449, 651826.40014974889],
						[533540.7329906479, 651826.51695612678],
						[533540.67070591403, 651857.04680432309],
						[533512.48201297806, 651856.98931995896],
						[533512.41955510387, 651887.62978821481],
						[533455.1163697521, 651887.51308051986],
						[533455.05379357433, 651918.26416899357],
						[533426.76232754078, 651918.20662224735],
						[533426.69957936637, 651949.06833088258],
						[533397.68802128336, 651949.00936999056],
						[533397.62600168481, 651979.53923696617],
						[533340.32313668658, 651979.42292938463],
						[533340.7589963486, 651764.49718538602],
						[533312.46726570569, 651764.43983533431],
						[533312.52979868709, 651733.57815394748],
						[533284.23801483982, 651733.52085246681],
						[533284.29937499366, 651703.21225220978],
						[533255.28738306195, 651703.15354259673],
						[533255.35070344445, 651671.84940895415],
						[533227.05881337018, 651671.79220586759],
						[533227.12051497702, 651641.26238389977],
						[533255.41245758976, 651641.31958708831],
						[533255.4744354703, 651610.67915447906],
						[533198.17028481269, 651610.5633423687],
						[533198.23237924813, 651579.81229884597],
						[533169.94033079606, 651579.75519405724],
						[533169.6917183199, 651702.98062677658],
						[533084.19893208181, 651702.80836362357],
						[533084.07583656639, 651763.9786468792],
						[533026.77222022857, 651763.86343217723],
						[533026.71133458719, 651794.17204240744],
						[532969.40782349266, 651794.0570276489],
						[532969.34504705819, 651825.36118107918],
						[532941.05342115206, 651825.30447016947],
						[532940.99225002294, 651855.83432061481],
						[532969.28382338793, 651855.89103142254],
						[532969.22237788478, 651886.53150172043],
						[532997.51389842445, 651886.58826110768],
						[532997.32895964233, 651978.7309300527],
						[532969.03759766754, 651978.67417098838],
						[532968.91404110298, 652040.28699930536],
						[533026.2166939606, 652040.40201234166],
						[533026.15469718457, 652071.26374097972],
						[532997.14335473452, 652071.20548690285],
						[532997.08207845362, 652101.73537366884],
						[532968.7909281468, 652101.67861502653],
						[532968.54470213433, 652224.4619015631],
						[532996.83564114722, 652224.51865978329],
						[532996.89691746468, 652193.98875474802],
						[533083.2101601772, 652194.16222007968],
						[533083.02473735332, 652286.30502602505],
						[533196.80532164755, 652286.53438540176]
					]
				],
				[
					[
						[529624.19136180077, 652648.28150161135],
						[529624.30198927352, 652586.88969653158],
						[529738.90348430607, 652587.09660703514],
						[529739.01453970897, 652525.70482113399],
						[529767.20208607614, 652525.75583554839],
						[529767.36892715201, 652433.61288360367],
						[529739.18122279481, 652433.56186890043],
						[529739.23705060908, 652402.70007303683],
						[529710.123418006, 652402.6474333111],
						[529710.01247139298, 652464.03918254317],
						[529653.53429228603, 652463.93721259572],
						[529653.47862513619, 652494.79901800188],
						[529596.17755609425, 652494.69576063566],
						[529596.06703432126, 652556.08753828018],
						[529538.76617890201, 652555.98448102176],
						[529538.65547356964, 652617.5975091944],
						[529595.95611423405, 652617.70056606189],
						[529595.90115202568, 652648.23054719984],
						[529624.19136180077, 652648.28150161135]
					]
				],
				[
					[
						[531652.88447409123, 652744.31635162269],
						[531652.9434696387, 652713.67574794707],
						[531710.24377540953, 652713.78617416695],
						[531710.30309111183, 652683.03495941637],
						[531738.4903677234, 652683.08935378375],
						[531738.54994969792, 652652.22752789594],
						[531767.66314031288, 652652.28375978558],
						[531767.72213567782, 652621.75378617062],
						[531795.90951736132, 652621.80827898858],
						[531795.96920688683, 652590.94646256696],
						[531825.08250602498, 652591.0027961334],
						[531825.02276184456, 652621.86461245024],
						[531967.81139412441, 652622.14165173494],
						[531967.75202717795, 652652.67162462475],
						[532025.05254557543, 652652.78314810898],
						[532024.99242575781, 652683.64497294859],
						[532196.07066978153, 652683.97912930942],
						[532196.13111076341, 652653.11730509286],
						[532253.43162760872, 652653.229624592],
						[532253.61240512657, 652561.08664369397],
						[532281.90276485798, 652561.14217161783],
						[532282.02331646264, 652499.75041284878],
						[532253.73285108281, 652499.69488471537],
						[532253.75520411436, 652488.30146120512],
						[532253.85329700552, 652438.30314413644],
						[532224.84260225447, 652438.24625290954],
						[532224.96293980745, 652376.85453050933],
						[532196.67226294125, 652376.79910056607],
						[532196.73270383116, 652345.93732263194],
						[532168.54484914406, 652345.88214257103],
						[532168.60502066778, 652315.1309848465],
						[532139.49123298272, 652315.0740429298],
						[532139.61125083582, 652253.68235673988],
						[532225.20404844871, 652253.84990960103],
						[532225.14377130195, 652284.60105790768],
						[532254.15473718324, 652284.65794967278],
						[532254.09462278197, 652315.29848682252],
						[532282.38540548261, 652315.3540155791],
						[532282.26441956498, 652376.96695050143],
						[532311.27522245247, 652377.02394306532],
						[532311.21521863318, 652407.55387807661],
						[532339.50584257487, 652407.60950513091],
						[532339.44513342099, 652438.47129178047],
						[532424.93409415486, 652438.63968213531],
						[532424.87387901917, 652469.16962587624],
						[532483.82103077311, 652469.28599492484],
						[532502.64708438597, 652469.32320444018],
						[532511.28855160356, 652469.34029143921],
						[532511.2275197251, 652500.20208669943],
						[532567.7055742282, 652500.31387407274],
						[532567.7667121304, 652469.45207902486],
						[532625.06786913855, 652469.56569385936],
						[532625.22482433543, 652390.47545232647],
						[532625.25028839044, 652377.64403140335],
						[532645.61957469746, 652377.68446706608],
						[532654.26109008398, 652377.70162921597],
						[532654.38347015344, 652316.08869704674],
						[532682.67425148841, 652316.14491463802],
						[532682.73516467027, 652285.50437907176],
						[532711.02599863743, 652285.56064545212],
						[532711.14859070606, 652223.9477414235],
						[532740.15966361726, 652224.00549081236],
						[532740.22046327917, 652193.47558483109],
						[532711.20933648956, 652193.41783533152],
						[532711.33192850184, 652131.8049589732],
						[532683.04082994058, 652131.74869206315],
						[532683.22378918866, 652039.71656618],
						[532625.92113394139, 652039.60274864326],
						[532626.04340508149, 651977.98991776002],
						[532597.75204183464, 651977.93379762245],
						[532597.8125760603, 651947.40392766707],
						[532626.10399184574, 651947.46004790673],
						[532626.27038588433, 651863.61354461254],
						[532626.46992692689, 651763.06415503309],
						[532655.48181314091, 651763.12175500125],
						[532655.60331399366, 651701.95146855619],
						[532683.8951521666, 651702.00768824923],
						[532683.95738458075, 651670.7035524199],
						[532712.2492765279, 651670.75982090761],
						[532712.37098785676, 651609.5895623765],
						[532741.38314489706, 651609.64731392951],
						[532741.44438495208, 651578.89626869606],
						[532798.7486459919, 651579.01048888988],
						[532798.87111976382, 651517.61902786628],
						[532827.06039458187, 651517.67528868653],
						[532827.12201538077, 651486.81364232313],
						[532855.41422377562, 651486.87015716976],
						[532855.59836122638, 651394.72770680021],
						[532884.61089742149, 651394.78571109648],
						[532884.73369032715, 651333.39430567133],
						[532913.02616273321, 651333.4509196626],
						[532913.21084264654, 651241.19792350917],
						[532942.22364976804, 651241.25602947106],
						[532942.35374884226, 651176.32498881535],
						[532942.53127749788, 651087.72235812899],
						[532970.82417266793, 651087.77907158213],
						[532971.25584210164, 650872.52240265836],
						[532942.96257651027, 650872.46568846016],
						[532943.02396898367, 650841.82536882651],
						[532914.01045700244, 650841.76726145134],
						[532914.25669628417, 650718.76356872905],
						[532885.96316609334, 650718.70695261902],
						[532886.02378798346, 650688.39849990199],
						[532857.01000525733, 650688.34049310745],
						[532857.25581562892, 650565.33689072658],
						[532886.26981540956, 650565.39489795163],
						[532886.39305031602, 650503.78250971413],
						[532914.68695035775, 650503.8391265606],
						[532914.74873152969, 650472.97763209348],
						[533086.67307747633, 650473.32270409586],
						[533086.73406836914, 650443.0142881216],
						[533144.04273447883, 650442.90848253481],
						[533144.10494590318, 650412.04699808045],
						[533229.60444421228, 650412.21957276738],
						[533229.66659255698, 650381.46870785125],
						[533286.97502722265, 650381.58462975069],
						[533287.09886641998, 650320.41475778539],
						[533343.68729749834, 650320.52941928222],
						[533343.75078043726, 650289.22549562971],
						[533372.76526746002, 650289.28436134814],
						[533372.8267849806, 650258.97597344639],
						[533401.12110629503, 650259.0334273756],
						[533401.18379949592, 650228.17197136767],
						[533458.49276848277, 650228.28849108913],
						[533458.55534414551, 650197.53765440418],
						[533544.05595792329, 650197.71186426515],
						[533544.11891915265, 650166.85041796975],
						[533601.42810187221, 650166.96743589279],
						[533601.49049250316, 650136.43783784797],
						[533658.79978122399, 650136.55505574285],
						[533658.92545459967, 650075.16403023282],
						[533716.23495688732, 650075.28144831175],
						[533716.43841798697, 649976.060316463],
						[533716.4871851264, 649952.27822390571],
						[533687.47210340598, 649952.21875164134],
						[533687.59788231191, 649890.82778089133],
						[533659.30292736972, 649890.7698339835],
						[533659.3661036446, 649859.90843380895],
						[533630.35085892526, 649859.84906234045],
						[533630.53886685136, 649767.92857469013],
						[533602.24370042107, 649767.87072597235],
						[533602.27127883537, 649754.37578411214],
						[533602.36961169564, 649706.25858050224],
						[533630.66488415492, 649706.31642944086],
						[533630.72800591029, 649675.45505654579],
						[533602.43268034724, 649675.3972074996],
						[533602.5581394633, 649614.00631783437],
						[533630.85357067478, 649614.06416709593],
						[533631.02732509072, 649529.11247969582],
						[533631.18569494109, 649451.68258649809],
						[533631.23026473133, 649429.89160746755],
						[533602.93451658951, 649429.83375755441],
						[533603.06042766606, 649368.22171220905],
						[533574.76457339711, 649368.16391077358],
						[533574.82691125292, 649337.63442995877],
						[533545.81074489828, 649337.57520767313],
						[533545.99895079271, 649245.32310772454],
						[533517.80577981554, 649245.26561422576],
						[533517.93137038883, 649183.65362276218],
						[533537.48145272036, 649183.69348552846],
						[533546.12464700139, 649183.71111647901],
						[533546.24989184132, 649122.32037132327],
						[533533.69663423067, 649122.29476586787],
						[533518.05650997139, 649122.26287739386],
						[533518.18164951704, 649060.87215009669],
						[533447.49213937996, 649060.72820762719],
						[533432.57222813379, 649060.69786559185],
						[533432.63520033483, 649029.7259736656],
						[533318.0089067854, 649029.49331425107],
						[533318.13285044068, 648968.32384034293],
						[533346.42939277249, 648968.38120014942],
						[533346.5976326596, 648885.42082143517],
						[533346.61692416226, 648875.9080334485],
						[533375.63390519621, 648875.96690423135],
						[533375.74099883158, 648823.20412311167],
						[533375.75761293608, 648815.01870333811],
						[533404.05441908271, 648815.07616230636],
						[533404.16205289413, 648762.09216927341],
						[533404.19755631906, 648744.61519748252],
						[533404.30474068108, 648691.85244974052],
						[533376.00772248779, 648691.79499033326],
						[533376.31957341346, 648538.15259896638],
						[533347.30199625518, 648538.09372697957],
						[533347.48885429907, 648445.95259144681],
						[533376.50659405568, 648446.01146376214],
						[533376.56833555026, 648415.59273055801],
						[533404.86582904554, 648415.65019092837],
						[533404.99143903714, 648353.81721617933],
						[533519.62244271603, 648354.05048196716],
						[533519.68467405019, 648323.52114919084],
						[533547.87942543754, 648323.57864591293],
						[533548.0055724266, 648261.74569953675],
						[533577.02363724122, 648261.80492569716],
						[533577.21155323333, 648169.77452801459],
						[533599.2324773632, 648169.81950711459],
						[533605.63492795534, 648108.44188674435],
						[533633.93295001157, 648108.49974129698],
						[533634.058513831, 648047.10931257799],
						[533663.07695740392, 648047.1686905867],
						[533663.13990668696, 648016.41817640001],
						[533691.43808710179, 648016.47612991591],
						[533691.56386484101, 647955.08572860388],
						[533720.58247080201, 647955.14520809392],
						[533720.64575405885, 647924.28409433225],
						[533748.94409302366, 647924.34214680584],
						[533749.00674834207, 647893.81287754746],
						[533778.02546242694, 647893.87245840579],
						[533778.15201681817, 647832.2608671661],
						[533806.45051413961, 647832.31901860307],
						[533806.51350323518, 647801.6791497271],
						[533834.70914936857, 647801.73713824665],
						[533834.77196340391, 647771.20788716991],
						[533863.89379785524, 647771.26783128269],
						[533864.02067293983, 647709.65627673187],
						[533892.21647685335, 647709.71436384937],
						[533892.28008118726, 647678.85328686994],
						[533921.40207919409, 647678.9133328239],
						[533921.46505366277, 647648.38409995986],
						[533949.66096263286, 647648.44228557055],
						[533949.78815803118, 647586.83076774818],
						[533978.08707770018, 647586.88921454293],
						[533978.15038557351, 647556.24938216899],
						[534007.16969534371, 647556.30936738639],
						[534007.80583043734, 647248.69454787404],
						[533978.78597783553, 647248.63456153776],
						[533979.35643309762, 646972.54483548645],
						[533951.05645623279, 646972.48638650798],
						[533951.12016791233, 646941.62541785033],
						[533979.42019788164, 646941.68386693927],
						[533979.48944779905, 646908.1681965359],
						[533979.61057798995, 646849.54343932634],
						[533923.11311060388, 646849.4268014743],
						[533923.17631299864, 646818.78707613901],
						[533836.73193877749, 646818.60898919415],
						[533836.66889744287, 646849.24871486356],
						[533816.29276134528, 646849.20680348016],
						[533780.17142904643, 646849.13256807812],
						[533780.23436512286, 646818.49284219334],
						[533751.21420738462, 646818.21203199949],
						[533751.30296861485, 646774.96246248647],
						[533751.3401983825, 646756.82198072865],
						[533723.03985029436, 646756.76392412814],
						[533723.07999750588, 646737.18547902897],
						[533717.63708128384, 646731.64366164058],
						[533694.08167816349, 646726.17534015537],
						[533694.14490658941, 646695.31440644176],
						[533665.84445265622, 646695.25644826936],
						[533665.90740153356, 646664.50613160152],
						[533636.88651803695, 646664.44674859359],
						[533636.94963888125, 646633.5858236663],
						[533608.64907872397, 646633.52796391619],
						[533608.71146830171, 646602.99888121791],
						[533523.19216169685, 646602.82433519186],
						[533523.12993087305, 646633.35341821588],
						[533494.00608127681, 646633.29407756741],
						[533493.9432286761, 646664.15500304406],
						[533465.74563205603, 646664.09759880463],
						[533465.68305744475, 646694.84791623452],
						[533408.3617726604, 646694.7313714684],
						[533408.29908051575, 646725.59230627795],
						[533379.99867868656, 646725.53483999916],
						[533379.93671317818, 646756.06394134066],
						[533322.61564176017, 646755.94769544457],
						[533322.67750085937, 646725.41859389062],
						[533265.3563226274, 646725.30254756962],
						[533265.41874652961, 646694.44161222177],
						[533179.797004694, 646694.26864372077],
						[533179.73474146181, 646725.12957939436],
						[533118.5029611123, 646725.00615558331],
						[533094.21606995596, 646724.95726407866],
						[533094.27817270975, 646694.09632808506],
						[533065.25734143169, 646694.03795380134],
						[533065.31916731969, 646663.2876348563],
						[532894.07535836031, 646662.94422720501],
						[532894.01385266986, 646693.69454679312],
						[532864.99302068318, 646693.63652590988],
						[532864.93134819367, 646724.4974627702],
						[532893.95212572045, 646724.55548354867],
						[532893.89106249425, 646755.08458670578],
						[532864.87033884472, 646755.02656603791],
						[532864.62497505301, 646877.80669984152],
						[532836.32483516249, 646877.75016914716],
						[532836.20181714068, 646939.36148864625],
						[532778.8813846095, 646939.24713793269],
						[532778.8198727225, 646970.10811104858],
						[532807.94312584901, 646970.16618517064],
						[532807.88266264612, 647000.47409854177],
						[532778.7594631908, 647000.41602452728],
						[532778.69751033629, 647031.49823229248],
						[532750.50054356549, 647031.44205440674],
						[532750.25602920668, 647154.22235094651],
						[532721.23600989638, 647154.16458374704],
						[532721.17482540908, 647184.91497562802],
						[532750.19479045435, 647184.97274272272],
						[532750.13333141222, 647215.8337519326],
						[532721.11342081928, 647215.7759849428],
						[532720.93008735985, 647307.91658806067],
						[532692.63068762328, 647307.86030464305],
						[532692.5697759022, 647338.50010607229],
						[532664.27042879653, 647338.44387145515],
						[532664.08741234895, 647430.58452894504],
						[532606.76869197888, 647430.47077813826],
						[532606.22016697947, 647707.11422112468],
						[532577.20112332678, 647707.05670809327],
						[532577.07906944817, 647768.6682723877],
						[532548.78046259668, 647768.61223651015],
						[532548.6593904522, 647829.78136600531],
						[532520.46379240765, 647829.72558253969],
						[532520.40298063972, 647860.47607400152],
						[532491.28130417003, 647860.41850909067],
						[532491.16000807553, 647921.80889243074],
						[532462.96456781926, 647921.75320755749],
						[532462.84294022457, 647983.36483576638],
						[532433.72148138122, 647983.30737279018],
						[532433.53953083127, 648075.55892926035],
						[532462.66082630819, 648075.61639191373],
						[532462.60055837687, 648106.14569282194],
						[532490.79568247683, 648106.20137707493],
						[532490.73470653326, 648137.06252261694],
						[532519.85589309153, 648137.12008656177],
						[532519.67367624794, 648229.26109620871],
						[532547.86858925538, 648229.31687832042],
						[532547.4429746985, 648444.34959560772],
						[532575.74041871016, 648444.40562917688],
						[532575.67950112082, 648475.1562106061],
						[532604.69718934712, 648475.21372094948],
						[532604.7581611952, 648444.46313963074],
						[532718.66823444376, 648444.68939378322],
						[532718.60704957903, 648475.43997468275],
						[532747.62473730044, 648475.49773724552],
						[532747.44057928771, 648567.9707340498],
						[532547.19907809305, 648567.57317618094],
						[532547.07844336284, 648628.52131154516],
						[532518.88421482872, 648628.46553078177],
						[532518.82318408054, 648659.32675321074],
						[532489.70292230393, 648659.26919109852],
						[532489.58118864312, 648720.88103609264],
						[532432.26696559752, 648720.76789352007],
						[532432.20631521242, 648751.5185161673],
						[532404.01229756698, 648751.46293236746],
						[532403.89088423958, 648813.07480523305],
						[532318.28017275117, 648812.90632211522],
						[532318.22038736579, 648843.325117353],
						[532260.90659110132, 648843.21257205575],
						[532261.08714826836, 648751.18190269195],
						[532232.06994703552, 648751.12499869906],
						[532232.19071608421, 648689.51314273197],
						[532175.69956981437, 648689.40250802587],
						[532175.87986472319, 648597.26129171136],
						[532146.75949303096, 648597.20433691819],
						[532146.81896027492, 648566.78557683702],
						[532118.62462589121, 648566.73048236466],
						[532118.68533729902, 648535.64804471692],
						[532033.07318143453, 648535.4810464771],
						[532033.01263185521, 648566.56348444487],
						[531975.69787093869, 648566.45193324226],
						[531975.63872024824, 648596.87069393811],
						[531946.62124670763, 648596.81429366441],
						[531946.56193478871, 648627.3436725901],
						[531918.26480558654, 648627.28872174048],
						[531918.20490207116, 648658.14994637319],
						[531890.01072433626, 648658.09524387657],
						[531889.94443817716, 648692.27488519589],
						[531889.89123762632, 648719.70709327527],
						[531860.77108277613, 648719.65064493474],
						[531860.71150112245, 648750.40126967523],
						[531826.96099594946, 648750.33591009816],
						[531803.39738097857, 648750.29031902226],
						[531803.36101169058, 648769.09466024442],
						[531803.3379064973, 648781.04094848724],
						[531793.15103521151, 648781.02124930208],
						[531689.53306093649, 648780.82123330026],
						[531689.4735860955, 648811.68248150474],
						[531632.15967954311, 648811.572127708],
						[531632.10116341105, 648841.99092540995],
						[531574.78736249893, 648841.88077157922],
						[531574.66905544675, 648903.49267764133],
						[531546.37240145286, 648903.43836676364],
						[531546.31383145438, 648933.96779204521],
						[531517.29695277323, 648933.91214937833],
						[531517.23780059069, 648964.77342088555],
						[531489.04414859659, 648964.71940588101],
						[531488.92700916168, 649025.88889319531],
						[531431.61384923069, 649025.7792384018],
						[531431.55464606348, 649056.75113776326],
						[531403.25825580826, 649056.6970731623],
						[531403.19931717985, 649087.55836326745],
						[531374.18270953675, 649087.50297314557],
						[531374.06557433621, 649148.89372532314],
						[531345.76934264193, 649148.83975964878],
						[531345.71114414849, 649179.36922161642],
						[531374.00732330757, 649179.4231871888],
						[531373.94843910658, 649210.28449557745],
						[531345.652313055, 649210.23053010693],
						[531345.5352834363, 649271.62131864484],
						[531316.51900059637, 649271.56603028486],
						[531316.34351326444, 649363.70755437459],
						[531259.75178910838, 649363.59987038188],
						[531259.634658447, 649425.21193304786],
						[531230.61864664091, 649425.15679626702],
						[531230.5604507993, 649455.7969133174],
						[531202.26474723744, 649455.74319459684],
						[531202.08989803307, 649547.88480151061],
						[531173.07410270453, 649547.82976627629],
						[531173.01559420745, 649578.69113004243],
						[531202.03133507899, 649578.74616517185],
						[531201.68142648251, 649763.14014311775],
						[531229.97660106223, 649763.19386083842],
						[531229.80201322364, 649855.11437495542],
						[531258.81726630451, 649855.16951029166],
						[531258.75859569246, 649886.0309193572],
						[531287.05355879315, 649886.08473529632],
						[531286.99546650425, 649916.61430566513],
						[531372.60043171735, 649916.77741953882],
						[531372.48287394445, 649978.38964526681],
						[531401.49790948583, 649978.44503238611],
						[531401.38066545397, 650039.8360472772],
						[531429.67536387919, 650039.89010864915],
						[531429.49902213563, 650132.14258649899],
						[531457.69067248271, 650132.19649940461],
						[531457.51438411768, 650224.33840343787],
						[531429.32289176015, 650224.28449082968],
						[531429.2059648271, 650285.45434910292],
						[531400.91168897925, 650285.40028853831],
						[531400.73508328013, 650377.8741052465],
						[531371.72075259301, 650377.81871947262],
						[531371.54494316294, 650469.96073371125],
						[531400.55911125417, 650470.01611917361],
						[531400.5001722275, 650500.87761920085],
						[531456.98509529128, 650500.98559075349],
						[531456.80880661239, 650593.12765883154],
						[531485.92564370995, 650593.18339177745],
						[531485.86696762417, 650623.82368030213],
						[531456.75018479163, 650623.76794745831],
						[531456.51485088724, 650746.77160671214],
						[531428.32425428729, 650746.71769581758],
						[531428.1481233862, 650838.8598737045],
						[531399.85479986772, 650838.80581495841],
						[531399.67903870111, 650930.83741930057],
						[531342.3725184619, 650930.72807556496],
						[531342.31368687178, 650961.58964457968],
						[531313.30038623908, 650961.53436189878],
						[531313.12447613513, 651053.89786693465],
						[531284.83152266324, 651053.84400612651],
						[531284.71512694075, 651115.01411085506],
						[531199.1164001649, 651114.85145452281],
						[531199.05783676787, 651145.71305161563],
						[531141.75206548115, 651145.60440714681],
						[531141.69423820125, 651176.13416385744],
						[531084.49145564844, 651176.02591383993],
						[531084.43310717703, 651206.8875205263],
						[531056.14041697467, 651206.83405326586],
						[531056.08233054681, 651237.58504956856],
						[530998.77687948081, 651237.47690343717],
						[530998.71869166428, 651268.33851964911],
						[530969.70593233558, 651268.28384329623],
						[530969.59029069089, 651329.67524431972],
						[530913.00533279683, 651329.56875373621],
						[530912.48537581996, 651606.10682479129],
						[530940.7773789349, 651606.16004484298],
						[530940.66225908871, 651667.33031613147],
						[530912.37036124384, 651667.27709627803],
						[530912.0806408244, 651821.36431646859],
						[530883.06885739486, 651821.30979299766],
						[530882.89618557016, 651913.23122660222],
						[530854.60471088206, 651913.17810615688],
						[530854.54679112113, 651944.03982422978],
						[530825.53522416716, 651943.98540228559],
						[530825.36245782615, 652036.12812249525],
						[530797.07119462371, 652036.07510105008],
						[530796.95619179937, 652097.46673250571],
						[530825.24734935747, 652097.51975374972],
						[530825.18989880895, 652128.16026847204],
						[530854.20114075718, 652128.21468980145],
						[530853.97029181349, 652251.2192566297],
						[530882.26118478412, 652251.27237598738],
						[530881.45309490908, 652681.45709204336],
						[530938.75351298274, 652681.56482923822],
						[530938.69564049924, 652712.31604674191],
						[531053.29626115563, 652712.53211987414],
						[531053.23838324635, 652743.17272568261],
						[531138.72575952427, 652743.33442764543],
						[531138.84204352275, 652681.94260534726],
						[531196.14245990536, 652682.05123966455],
						[531196.20102373895, 652651.18941182818],
						[531310.08195621264, 652651.40590853512],
						[531310.14010180824, 652620.87593329162],
						[531339.15047428303, 652620.9312103925],
						[531339.20930634788, 652590.06939232803],
						[531452.9877883537, 652590.28668285767],
						[531453.10524474375, 652528.89490886987],
						[531482.21865377133, 652528.95063525857],
						[531482.39510728174, 652436.80770122074],
						[531510.58280607115, 652436.8617048189],
						[531510.70047635399, 652375.46997724671],
						[531482.5126723029, 652375.4159734475],
						[531482.80732610333, 652221.54957976006],
						[531453.6933726978, 652221.49385232897],
						[531453.81082887657, 652160.1021887958],
						[531482.92489100108, 652160.15791643644],
						[531483.04245586507, 652098.76627147582],
						[531511.23073425563, 652098.82027618424],
						[531511.28925127909, 652068.29038400552],
						[531568.59180653968, 652068.40031649359],
						[531568.53318310832, 652098.93020846555],
						[531596.82433814416, 652098.98455747659],
						[531596.64703461202, 652191.23795399279],
						[531625.65816524881, 652191.29373667669],
						[531625.54006711184, 652252.68540821713],
						[531653.83095755707, 652252.73985532764],
						[531653.71275373898, 652314.13154503843],
						[531682.72366751137, 652314.18742842204],
						[531682.60492897115, 652375.80036771763],
						[531653.59412392671, 652375.74448454089],
						[531653.47592003376, 652437.13621108769],
						[531625.18534690666, 652437.08176458615],
						[531625.00809307676, 652529.22469708603],
						[531595.99755877152, 652529.16891554638],
						[531595.93867007236, 652559.80949182366],
						[531624.94915031025, 652559.86527326412],
						[531624.71252799476, 652682.87008730392],
						[531567.41211446247, 652682.75995920319],
						[531567.35306604626, 652713.51117446925],
						[531595.64316348184, 652713.56552145234],
						[531595.58427473099, 652744.20612532925],
						[531652.88447409123, 652744.31635162269]
					]
				],
				[
					[
						[528824.02663296636, 652831.25642428338],
						[528824.08055028052, 652800.50518113165],
						[528852.37049801659, 652800.55480735982],
						[528852.42427410197, 652769.91418488219],
						[528909.72438387212, 652770.01484989224],
						[528909.77846127038, 652739.2636162549],
						[528967.07867787022, 652739.36448117718],
						[528967.13266753498, 652708.72386827623],
						[528995.42277321522, 652708.77374066773],
						[528995.47701069748, 652678.02251654177],
						[529024.48728233459, 652678.07370906975],
						[529024.43299058336, 652708.82493310224],
						[529052.72309608955, 652708.87490410032],
						[529052.77744075644, 652678.12368016411],
						[529080.96472579008, 652678.17351795721],
						[529081.07332487404, 652616.78170000389],
						[529052.88593458128, 652616.73186202114],
						[529053.15785319079, 652462.86524192942],
						[529024.8673243419, 652462.81527018081],
						[529024.81283735763, 652493.67707769142],
						[528995.80224032467, 652493.62588459137],
						[528995.85667284857, 652462.76407698425],
						[528967.56614382705, 652462.71420384501],
						[528967.51176441158, 652493.57601154258],
						[528881.92021493614, 652493.42541935551],
						[528881.70411722956, 652616.43023428461],
						[528852.69373681862, 652616.37929372094],
						[528852.64015490981, 652646.90927731746],
						[528767.04940374207, 652646.75928318745],
						[528767.10282670241, 652616.2292993163],
						[528738.915435459, 652616.1799996625],
						[528738.70079273521, 652738.96365848917],
						[528709.6906285492, 652738.91297027515],
						[528709.63692542829, 652769.66420456406],
						[528681.34692453558, 652769.61482396419],
						[528681.29346730874, 652800.25544699689],
						[528738.59347132815, 652800.35551553033],
						[528738.53971392463, 652831.1067589568],
						[528824.02663296636, 652831.25642428338]
					]
				],
				[
					[
						[539676.64487423841, 655281.24953967903],
						[539676.71856994496, 655250.71920584305],
						[539705.7243016531, 655250.7892470333],
						[539705.79885285138, 655219.92706656689],
						[539734.08463711175, 655219.99541856511],
						[539734.75313397846, 654943.45279430365],
						[539620.16806485399, 654943.17620269209],
						[539619.87157503923, 655066.18231732142],
						[539591.58552608744, 655066.11416186474],
						[539591.36358380003, 655158.25818024226],
						[539563.18055107992, 655158.19032141217],
						[539562.95850043267, 655250.444999328],
						[539591.14137497509, 655250.51285777288],
						[539591.06783821608, 655281.04319199396],
						[539676.64487423841, 655281.24953967903]
					]
				],
				[
					[
						[537866.71542784665, 659497.64594106539],
						[537866.81127171451, 659456.05300391419],
						[537895.91241336358, 659456.12008838053],
						[537896.05501411774, 659394.28379665269],
						[537924.23078367708, 659394.3487970368],
						[537924.30073295499, 659364.03906551469],
						[537953.29920608806, 659364.10601429211],
						[537953.51279110531, 659271.62817639275],
						[537981.7916030098, 659271.69351297023],
						[537982.07591326174, 659148.68478168803],
						[538010.35493673442, 659148.75016741711],
						[538010.49643004138, 659087.57768855966],
						[538035.58772963099, 659087.6357444973],
						[538039.56657573371, 659056.89262830769],
						[538067.02309007128, 659056.95620727795],
						[538067.91622602521, 659026.53781450749],
						[538182.47385816323, 659026.36110825138],
						[538182.54479609232, 658995.83019577479],
						[538239.82320538105, 658995.96338087495],
						[538239.75216103648, 659026.4942931023],
						[538267.92856120237, 659026.55988278845],
						[538267.85669170949, 659057.42265741457],
						[538296.95853929722, 659057.49045209785],
						[538297.02943227824, 659027.07015461638],
						[538382.48516509659, 659026.82704784244],
						[538382.41308045946, 659057.68982196727],
						[538439.69127413793, 659057.82370370557],
						[538439.76346634724, 659026.96092983289],
						[538496.21909853537, 659027.0930842883],
						[538496.14680030022, 659057.95585791173],
						[538525.24864694593, 659058.02405687503],
						[538525.17655336997, 659088.77621589438],
						[538582.45463869465, 659088.91059523949],
						[538582.31101628521, 659150.0830691345],
						[538610.48720454378, 659150.14924617391],
						[538610.41365149722, 659181.45451576379],
						[538638.69261857972, 659181.52098277071],
						[538638.62083231681, 659212.05192172225],
						[538724.89722905925, 659212.25500684557],
						[538724.96917561418, 659181.72406827647],
						[538753.24814223009, 659181.79073241423],
						[538753.32196737733, 659150.48546346172],
						[538781.49815494963, 659150.55193371186],
						[538781.71404811658, 659059.06978072342],
						[538810.81693779223, 659058.69600834604],
						[538810.96193244215, 658997.30232637003],
						[538981.97447342495, 658997.70710015134],
						[538982.04715897562, 658967.0655766594],
						[539009.50382339244, 658967.13073031092],
						[539011.11933484103, 658936.38225416769],
						[539182.13250977255, 658936.78911087546],
						[539182.20504074183, 658906.36883610464],
						[539211.30821161449, 658905.99577332381],
						[539211.23457098857, 658936.85852465581],
						[539292.78204222687, 658937.0533049528],
						[539296.61620283301, 658967.81478538865],
						[539381.35137269949, 658968.01762851793],
						[539382.10061262071, 658998.6611217258],
						[539410.37989426311, 658998.72891668673],
						[539410.30667518266, 659029.25982377597],
						[539467.58496794361, 659029.39728823467],
						[539467.51084542228, 659060.26005753293],
						[539496.50985461706, 659060.32972953736],
						[539496.43594349094, 659091.08188424003],
						[539524.71506608848, 659091.14987595507],
						[539524.64083597052, 659122.01265459484],
						[539639.09394145198, 659122.28833213716],
						[539639.02083051181, 659152.59801855241],
						[539752.85672625864, 659152.87300015916],
						[539752.78099699388, 659184.17826456553],
						[540010.06813410739, 659184.80267178325],
						[540010.14435350045, 659153.49740856653],
						[540152.97908717813, 659153.84579146095],
						[540152.90259568184, 659185.1510540148],
						[540179.53623505228, 659185.2161524673],
						[540181.7518072587, 659246.3944236961],
						[540210.03066257935, 659246.46359473735],
						[540209.7296734004, 659369.47234381305],
						[540237.90548549651, 659369.54131120327],
						[540237.83126889542, 659399.85103257955],
						[540295.10826995992, 659399.99138137558],
						[540294.95664170035, 659461.82765162771],
						[540323.23512629699, 659461.8970174772],
						[540324.13269194751, 659431.36806676874],
						[540352.30839791894, 659431.43723031529],
						[540352.38527053106, 659400.13192981202],
						[540324.20951088518, 659400.06276613241],
						[540324.28388680262, 659369.75304514985],
						[540352.45969841862, 659369.82220895693],
						[540352.53548446682, 659338.95939578093],
						[540324.35961993376, 659338.89023184637],
						[540324.51081471948, 659277.27523902792],
						[540295.4093563488, 659277.20385373582],
						[540295.7109850446, 659154.19516369991],
						[540323.9899990313, 659154.26453084662],
						[540324.88703707897, 659123.95686618821],
						[540295.78530719539, 659123.88548023044],
						[540295.93639270251, 659062.27055403986],
						[540324.21556487354, 659062.33992157178],
						[540325.18888338085, 659000.94827191206],
						[540353.36532734463, 659001.01743727142],
						[540353.44056998461, 658970.37591995148],
						[540380.89722886868, 658970.44336490799],
						[540381.64460492542, 659001.08690362785],
						[540467.92210924975, 659001.29913990293],
						[540467.84692539624, 659031.83004221087],
						[540496.12614995707, 659031.89970557636],
						[540495.97431416856, 659093.51462032658],
						[540524.15059941995, 659093.58407850564],
						[540524.07449229178, 659124.44685257098],
						[540610.45418191305, 659124.66009074694],
						[540610.53045126726, 659093.79731708381],
						[540638.70673603378, 659093.86697167996],
						[540639.0103836573, 658971.07964071771],
						[540667.28971275478, 658971.14959863084],
						[540667.36581433006, 658940.39746832685],
						[540696.36503504124, 658940.46925765532],
						[540696.44036904455, 658910.04898969945],
						[540724.72089969681, 658909.67656985321],
						[540724.94925174257, 658817.53084180516],
						[540753.94868926646, 658817.60273275094],
						[540754.10094086523, 658756.20914445305],
						[540782.38063972723, 658756.2793004174],
						[540782.304872885, 658786.81016344763],
						[540811.30436462269, 658786.88215560582],
						[540811.22771975514, 658817.74488047697],
						[540954.0653717079, 658818.10022627981],
						[540954.1422848308, 658787.23750207713],
						[541067.87787639094, 658787.52133680391],
						[541067.95417378109, 658756.99047509918],
						[541096.95371813839, 658757.0629713306],
						[541096.80018568935, 658818.45655643928],
						[541152.53669002606, 658818.59603633825],
						[541153.12861483009, 658910.74381856073],
						[541210.30448637041, 658910.88709974976],
						[541210.38104898529, 658880.35621977854],
						[541295.93934571312, 658880.5709981221],
						[541296.01690120075, 658849.70826593472],
						[541345.48038387997, 658849.83263810177],
						[541353.29581977706, 658849.85230304254],
						[541353.4508675019, 658788.23747269111],
						[541296.17173416575, 658788.09343503951],
						[541296.2478997329, 658757.78381250484],
						[541211.51220062899, 658757.34985752136],
						[541210.76691329526, 658726.48508099967],
						[541182.58999861719, 658726.41444555065],
						[541182.74218736682, 658665.68460380367],
						[541125.46428782854, 658664.87744714133],
						[541125.54013793217, 658634.56784256431],
						[541097.26078289398, 658634.27585809969],
						[541097.33796400751, 658603.41316320444],
						[541068.33814851195, 658603.34066629608],
						[541068.41499871062, 658572.588595015],
						[541040.13498374703, 658572.51794682839],
						[541040.21205726219, 658541.65526124346],
						[541011.21213278151, 658541.58286513959],
						[541011.82497214014, 658296.00897750235],
						[540983.54448122787, 658295.93842669856],
						[540983.62117119948, 658265.18640254671],
						[540898.16250891215, 658264.97350617242],
						[540898.31529370917, 658203.58009008807],
						[540755.47230044159, 658203.2252288796],
						[540755.54883750307, 658172.36259917356],
						[540726.5482613527, 658172.29070540087],
						[540726.62446980807, 658141.53869907092],
						[540698.34371307108, 658141.46863905061],
						[540698.49575016799, 658080.07525906304],
						[540726.77661255095, 658080.14531934122],
						[540726.85309510084, 658049.28270856733],
						[540783.31208602979, 658049.42272018723],
						[540784.21057012561, 658018.8940120904],
						[540813.2114169636, 658018.96600761358],
						[540813.36415665131, 657957.46204792359],
						[540841.64523003018, 657957.53230587079],
						[540841.87257391342, 657866.05073227361],
						[540870.05261431169, 657865.45707214996],
						[540870.12826447492, 657835.03696954739],
						[540898.41064965376, 657834.66485099297],
						[540899.30880667223, 657804.35741919675],
						[540927.48785325361, 657804.20633188426],
						[540927.79363262362, 657681.41980322218],
						[540899.61492608848, 657681.34965296241],
						[540899.84506610211, 657588.87264123536],
						[540870.74061772064, 657588.80023707869],
						[540871.19919443259, 657404.39943287079],
						[540899.48121954931, 657404.46979034785],
						[540900.45675350609, 657343.07868672418],
						[540928.63604003598, 657343.14883842575],
						[540928.71262245812, 657312.39696094161],
						[540985.99689933518, 657312.53971781675],
						[540986.0733130679, 657281.89846357284],
						[541043.35769624461, 657282.04142038],
						[541043.43394051946, 657251.51078931696],
						[541071.71678160969, 657251.36020674324],
						[541071.94733060477, 657159.1046330051],
						[541100.94969467469, 657159.1771362836],
						[541101.10322584503, 657097.78406250221],
						[541214.85051000537, 657098.06891437701],
						[541214.77367067593, 657128.71013930766],
						[541272.05858779151, 657128.85389324871],
						[541272.13497835305, 657098.43390485086],
						[541328.70063783647, 657098.35481211543],
						[541329.49788842094, 657067.60478465317],
						[541357.78049311065, 657067.67593079212],
						[541357.85759874526, 657037.03471593361],
						[541472.42862980266, 657037.10218473664],
						[541472.97098063072, 656822.17134412099],
						[541501.25400766858, 656822.24273715424],
						[541501.33193817886, 656791.38032466103],
						[541557.79525055294, 656791.52299695881],
						[541558.69523000531, 656760.99452375516],
						[541587.6982966013, 656761.06788597186],
						[541587.77638911724, 656730.20548334136],
						[541615.95672647259, 656730.27681351942],
						[541616.18948215863, 656638.35334174964],
						[541588.00898719614, 656638.28201116936],
						[541588.16489221784, 656576.66786628764],
						[541559.16150022275, 656576.59450324671],
						[541559.31673706218, 656515.20161261782],
						[541588.32023739431, 656515.2749759336],
						[541588.39832981722, 656484.41261111642],
						[541644.86269675801, 656484.55558252765],
						[541644.94061491347, 656453.80384049471],
						[541673.94422359241, 656453.87735491362],
						[541674.09932696668, 656392.70573845552],
						[541702.38309305441, 656392.7774776041],
						[541702.69575553003, 656269.54935979389],
						[541674.41177738539, 656269.47762010992],
						[541674.4900302008, 656238.61529350828],
						[541617.20201015554, 656238.47013689869],
						[541617.27931511553, 656207.93966766261],
						[541560.09403936972, 656207.79497052915],
						[541560.1715177981, 656177.1538880429],
						[541502.88328353118, 656177.00912988978],
						[541502.96037582948, 656146.47866940883],
						[541360.09950253007, 656146.11855279573],
						[541360.02267559769, 656176.64901394793],
						[541217.16206453694, 656176.2901397259],
						[541217.23862610711, 656145.75967790524],
						[541160.05313402205, 656145.61637261196],
						[541160.13152844156, 656114.31159202952],
						[541017.27037555841, 656113.95445523341],
						[541017.19225324318, 656145.25923649268],
						[541046.19640639273, 656145.33164315601],
						[541046.12016253849, 656175.86210576422],
						[541017.11606326327, 656175.78969923966],
						[541017.03959722095, 656206.43078426935],
						[540962.93985298334, 656206.29586515075],
						[540960.42127754784, 656267.68277197937],
						[540903.13335882418, 656267.54010425031],
						[540902.98002493591, 656329.15416123788],
						[540873.87334571045, 656329.0817515353],
						[540873.72012088937, 656390.69582769298],
						[540817.25543150364, 656390.55550549366],
						[540817.17961168254, 656421.08600651275],
						[540730.88856085169, 656420.87193661858],
						[540730.81262718118, 656451.51306045882],
						[540702.52896217245, 656451.44299323822],
						[540702.45280728058, 656482.19473968982],
						[540645.16563623725, 656482.05297110858],
						[540645.08931496704, 656512.91534035292],
						[540616.90860492864, 656512.8456748121],
						[540616.83315665217, 656543.37619542622],
						[540559.54619885981, 656543.23472527298],
						[540559.31798938371, 656635.71125887777],
						[540530.21185304085, 656635.63945776911],
						[540530.1365652004, 656666.16999749665],
						[540559.24264747382, 656666.24179847224],
						[540559.09114468913, 656727.6347454217],
						[540529.98517113435, 656727.56294471526],
						[540529.75767078204, 656819.81832778349],
						[540501.57748695277, 656819.74885999097],
						[540501.42619803711, 656881.14185453719],
						[540473.1432723559, 656881.07218205405],
						[540465.97111459007, 656911.80652174167],
						[540444.06474393921, 656911.75260024518],
						[540443.98879813473, 656942.61503664148],
						[540415.70597823698, 656942.54546299705],
						[540415.55500886054, 657003.93849603354],
						[540386.55237085221, 657003.86720224132],
						[540386.40150976554, 657065.26025436854],
						[540358.11890092154, 657065.19077982625],
						[540358.04338737112, 657095.9426221539],
						[540329.86367698468, 657095.87344877864],
						[540329.93913781096, 657065.12160632084],
						[540187.08624925755, 657064.77168539446],
						[540187.16117229895, 657034.13046512031],
						[540085.13789495802, 657033.88131716615],
						[540072.59067727521, 657033.85071972222],
						[540072.66565641586, 657003.09888551524],
						[539987.09758493595, 657002.8904759828],
						[539987.02276589745, 657033.64231057779],
						[539972.11008892383, 657033.60603486258],
						[539844.27244979574, 657033.29561956332],
						[539844.12361405767, 657094.68868606817],
						[539786.83857786923, 657094.54990919156],
						[539786.68995607109, 657155.94299505907],
						[539729.40513338486, 657155.80441836384],
						[539729.33052835776, 657186.66689592996],
						[539614.76109667891, 657186.39034206397],
						[539614.83548656106, 657155.52786397934],
						[539586.55303305376, 657155.45971718151],
						[539586.77497754677, 657063.31478367269],
						[539558.59521121811, 657063.24693270843],
						[539558.66896253056, 657032.60570959048],
						[539529.66637510736, 657032.53592790174],
						[539529.74033839256, 657001.78409123351],
						[539501.45762031316, 657001.71609087382],
						[539501.53073307371, 656971.2961130864],
						[539473.2490252289, 656970.7856888948],
						[539472.67654661147, 656909.39092771441],
						[539444.3936695389, 656909.32302554767],
						[539444.4674726727, 656878.57120738667],
						[539415.46461343253, 656878.50162722473],
						[539415.53809700371, 656847.8604316836],
						[539387.25511405035, 656847.79262784857],
						[539387.32880997355, 656817.04081885621],
						[539359.04577398323, 656816.97306356963],
						[539359.11968188139, 656786.11064117413],
						[539330.11665948201, 656786.04121161986],
						[539330.18971878302, 656755.51064777956],
						[539301.90657690866, 656755.4429908162],
						[539302.05338395352, 656694.05002300278],
						[539244.76695134002, 656693.91313551646],
						[539244.69405101403, 656724.44369038625],
						[539216.5137036622, 656724.37642595102],
						[539216.4400638435, 656755.2388395262],
						[539101.86762469157, 656754.96586103295],
						[539101.94104936579, 656724.10344694229],
						[539073.65785344737, 656724.03618275619],
						[539073.73043606034, 656693.50562713295],
						[539016.44400154951, 656693.36953546049],
						[539016.663005649, 656601.11418833327],
						[538987.65965679591, 656601.04536309582],
						[538987.87823559402, 656508.90067585534],
						[538959.59466934064, 656508.83360795607],
						[538959.66782567382, 656477.97123104706],
						[538931.48705572437, 656477.90445531602],
						[538931.55989710789, 656447.15270084003],
						[538902.45342685154, 656447.08378234098],
						[538902.52595194452, 656416.44265024422],
						[538874.34507649485, 656416.37597248517],
						[538874.56301736657, 656324.23136838025],
						[538845.45632942638, 656324.16255081876],
						[538845.67489132902, 656231.68613550602],
						[538874.78174303775, 656231.75495345553],
						[538874.85264571721, 656201.77756014315],
						[538903.03519822878, 656201.29115037958],
						[538903.1066759415, 656171.09252641734],
						[538931.39187144896, 656170.71702646255],
						[538932.28700027149, 656140.18850326876],
						[538960.46834926412, 656140.2552803678],
						[538960.54202988313, 656109.17172482703],
						[538988.826808688, 656109.0175591053],
						[538988.89870599261, 656078.70833179227],
						[539017.90297658707, 656078.77715922205],
						[539017.97624033818, 656047.9148486465],
						[538988.97191527847, 656047.84602109203],
						[538989.33612475102, 655894.30886113248],
						[538961.05150088505, 655894.24179072643],
						[538961.12518141011, 655863.15827319445],
						[538875.65402838797, 655862.95589401096],
						[538875.58050949743, 655894.03941192816],
						[538848.83868285618, 655893.97618373262],
						[538846.4003801815, 655924.72226282931],
						[538818.21866163553, 655924.65568130324],
						[538818.14629605622, 655955.29673884669],
						[538789.03895476391, 655955.22802119469],
						[538788.96690448665, 655985.75846596679],
						[538760.78529059037, 655985.69198291679],
						[538760.63999038865, 656047.30597459059],
						[538675.06694273837, 656047.10439593135],
						[538674.99432286434, 656077.96670802799],
						[538645.99005084275, 656077.89848571958],
						[538646.06261624908, 656047.03617348697],
						[538617.77825519885, 656046.96969380486],
						[538617.84972788428, 656016.54985651595],
						[538589.66816678538, 656016.48366686644],
						[538589.81308549282, 655954.759065449],
						[538560.70574325137, 655954.6907521534],
						[538560.77762890595, 655924.04969348258],
						[538532.59590920468, 655923.98360168329],
						[538532.66800163686, 655893.23193003691],
						[538503.56055043254, 655893.16371794231],
						[538503.84870221617, 655770.15707781212],
						[538532.95637125126, 655770.22529042233],
						[538533.02872295224, 655739.36302482337],
						[538561.21075920085, 655739.42911736201],
						[538561.28212574893, 655709.00932627334],
						[538590.39016278309, 655708.96702317765],
						[538591.11163826101, 655401.67208327295],
						[538562.00331654761, 655401.60376767465],
						[538562.29189636698, 655278.59742851043],
						[538534.10906998476, 655278.53133411938],
						[538534.25299504679, 655217.13880952948],
						[538562.43592669582, 655217.20490417257],
						[538562.50807159906, 655186.45334043168],
						[538534.32508722623, 655186.38724566961],
						[538534.46849358024, 655125.21598327195],
						[538505.35968228721, 655125.14776798792],
						[538505.43249736098, 655094.06436675403],
						[538477.2493545803, 655093.99836985348],
						[538477.32082165126, 655063.46805857809],
						[538449.034768029, 655063.40186927409],
						[538449.10592380539, 655032.98217953672],
						[538391.81473499909, 655032.40579682146],
						[538391.95812627359, 654971.01334564609],
						[538362.95190086588, 654970.94562279689],
						[538363.02367140306, 654940.1940955749],
						[538249.26145279477, 654939.9289810583],
						[538249.33275309112, 654909.28807499749],
						[538077.45479152002, 654908.88901941385],
						[538077.52551516518, 654878.3587342141],
						[538020.23275397008, 654878.22611482721],
						[538020.30516220711, 654846.92151532974],
						[537992.01873594313, 654846.85611248121],
						[537992.16012094112, 654785.68494768441],
						[538020.44665247004, 654785.75035077648],
						[538020.51778137672, 654754.99885008053],
						[538049.52438785834, 654755.0659686554],
						[538049.66649811727, 654693.67359838937],
						[538077.95318798488, 654693.73910044483],
						[538078.02416779718, 654663.09823083784],
						[538163.50156019593, 654663.29646229022],
						[538163.57192887377, 654632.9874481794],
						[538220.86605925846, 654632.89933351474],
						[538221.15258612856, 654509.67222177761],
						[538250.2624873654, 654509.73993375874],
						[538250.40534504573, 654448.34763969434],
						[538392.35521521431, 654448.67856515199],
						[538393.10680509894, 654479.2107061093],
						[538421.39386402536, 654479.27679916914],
						[538421.17771421093, 654571.75241765112],
						[538478.47154362139, 654571.88643453177],
						[538478.40059459372, 654602.19543803786],
						[538592.98804071965, 654602.46407039731],
						[538593.13165986771, 654541.29298503976],
						[538620.59571881162, 654541.35748890194],
						[538621.02674281644, 654664.36507036933],
						[538649.3134831175, 654664.43155564554],
						[538649.2414383844, 654695.07242276845],
						[538763.8282370622, 654695.34224605886],
						[538764.04631631891, 654602.86657608266],
						[538792.23030119413, 654602.93306472385],
						[538792.37466179987, 654541.76198111114],
						[538818.29579534521, 654541.82317413238],
						[538821.55713253049, 654511.07924478012],
						[538878.85117340949, 654511.21465718595],
						[538878.99637875508, 654449.82236862788],
						[538907.18062603695, 654449.88905436313],
						[538907.25367405266, 654419.02699212346],
						[539079.13675781689, 654419.43472452345],
						[539079.06338708953, 654450.29678599548],
						[539107.35049576871, 654450.36405948619],
						[539107.49655392522, 654388.97179153142],
						[539135.78376813931, 654389.03911394998],
						[539135.92993189557, 654327.64686482539],
						[539164.93729250273, 654327.71595171141],
						[539165.01082386426, 654296.85390929901],
						[539193.19533342519, 654296.9210854324],
						[539193.415031221, 654204.77745304001],
						[539222.52547239442, 654204.84688680898],
						[539222.59911128099, 654173.98486334865],
						[539250.78383151197, 654174.05213822727],
						[539250.85673091654, 654143.52196921781],
						[539279.14436750975, 654143.58953833533],
						[539279.4382897208, 654020.58397686295],
						[539251.15044145123, 654020.51640723855],
						[539251.37072424067, 653928.26228460972],
						[539279.65873126301, 653928.32985461375],
						[539279.80542791425, 653866.93774609535],
						[539337.10171394772, 653867.07475572592],
						[539337.02786158002, 653897.93673202861],
						[539479.90827580774, 653898.27926450328],
						[539480.12718397472, 653807.13136422751],
						[539537.42633896938, 653806.16290850285],
						[539537.64795918949, 653714.01950354292],
						[539566.65640263166, 653714.08929932583],
						[539566.80416904134, 653652.69725820585],
						[539594.9897830626, 653652.76512325043],
						[539594.91624688555, 653683.29521693615],
						[539623.20467546105, 653683.3633781285],
						[539623.13028685877, 653714.22532518045],
						[539652.13872993761, 653714.29527180898],
						[539652.06508732832, 653744.82537443959],
						[539709.36126456992, 653745.18491422769],
						[539709.28724832623, 653775.82563755498],
						[539736.0325211609, 653775.89026568586],
						[539737.42711229657, 653837.28607216896],
						[539765.71527587692, 653837.35447860148],
						[539765.64088655601, 653868.10583191889],
						[539822.93716851657, 653868.24453492765],
						[539823.38173560682, 653684.73203287018],
						[539937.97772728803, 653684.1251108388],
						[539937.90274773061, 653714.98705645744],
						[539995.09669656947, 653715.12610961508],
						[539995.17178350175, 653684.26416425419],
						[540023.46021040529, 653684.33301423036],
						[540023.5345424799, 653653.80292247352],
						[540109.12005047384, 653654.01152174966],
						[540109.19535117142, 653623.14958621748],
						[540138.20395497163, 653623.22039058316],
						[540138.27904002811, 653592.46907608467],
						[540195.57628271799, 653592.60907793255],
						[540195.95197327435, 653438.96319252404],
						[540224.24082230323, 653439.03238800657],
						[540224.39050047914, 653377.86166842445],
						[540196.10154618218, 653377.79247268138],
						[540197.00385123712, 653008.77745229553],
						[540223.64750081161, 653008.84262223076],
						[540225.51917531178, 652916.5929990625],
						[540197.22942724545, 652916.52380137623],
						[540197.52965414966, 652793.74022984027],
						[540225.81961350911, 652793.80942804203],
						[540225.96820855094, 652733.08136474923],
						[540254.15702446608, 652732.48666541558],
						[540254.53351213457, 652578.73081275611],
						[540283.64683288941, 652578.80212567607],
						[540283.79726574523, 652517.41043285525],
						[540311.98482632497, 652517.47952725017],
						[540312.20995530859, 652425.66856189072],
						[540340.50163378508, 652425.29549505957],
						[540341.47527958767, 652363.90586830094],
						[540312.36157826963, 652363.83445297903],
						[540312.4369828715, 652333.08332883334],
						[540284.24910613184, 652333.01423366519],
						[540284.32418694824, 652302.37372953631],
						[540227.02244714624, 652302.23341836664],
						[540227.09769182233, 652271.48230304115],
						[540198.80683361471, 652271.41310264147],
						[540198.88175488613, 652240.77260729042],
						[539912.37251454685, 652239.85330676124],
						[539912.44663327117, 652209.32343020907],
						[539884.25854433852, 652209.25502085907],
						[539884.33341577509, 652178.39330231026],
						[539908.61225328769, 652178.4522214575],
						[539912.67060065584, 652117.07013518002],
						[539940.96172446595, 652117.13884318189],
						[539941.85891171859, 652086.61098453449],
						[539970.04721093946, 652086.67949264392],
						[539970.19700574875, 652025.0667132719],
						[539999.20842960814, 652025.13727235212],
						[539999.28351592377, 651994.27558204578],
						[540027.57485103793, 651994.34443909745],
						[540027.7991919691, 651902.20185765845],
						[540056.09068553464, 651902.27076377964],
						[540056.16533900483, 651871.63032281469],
						[540085.17703362182, 651871.70103360154],
						[540085.32779717969, 651809.86708928691],
						[540113.61944963923, 651809.93609440548],
						[540113.69340019638, 651779.62751323637],
						[540142.70525716757, 651779.69832554425],
						[540142.8546156534, 651718.52810077323],
						[540170.32339083217, 651718.59519390133],
						[540171.29751066631, 651656.76330746035],
						[540228.6015002554, 651656.90342440247],
						[540228.67647402768, 651626.26302083733],
						[540256.86556255608, 651626.3320207271],
						[540257.01696940279, 651564.49815186928],
						[540286.13208627654, 651564.5694691852],
						[540286.43186625815, 651442.22916852299],
						[540314.62235528056, 651441.85580716969],
						[540314.84775432921, 651349.93470741319],
						[540286.65819189115, 651349.86560811533],
						[540286.73435654456, 651318.78279049858],
						[540257.6188044101, 651318.7114721206],
						[540257.69301803666, 651288.40296396101],
						[540229.50335010095, 651288.33396265493],
						[540229.65410935099, 651226.72142487194],
						[540201.36145327287, 651226.6522200763],
						[540201.51156551088, 651165.26093027787],
						[540229.80432723544, 651165.33013533696],
						[540230.02951864747, 651073.2985427184],
						[540172.72349490528, 651073.15842080233],
						[540172.79890222417, 651042.29687403108],
						[540144.50592877693, 651042.22776707145],
						[540144.58047271601, 651011.69806930143],
						[540058.26156080631, 651011.26630105427],
						[540058.33648346097, 650980.5153777923],
						[539972.73705632042, 650980.30704294331],
						[539972.66229376581, 651011.05796659621],
						[539887.16590937611, 651010.85032739956],
						[539887.09130672319, 651041.6012560206],
						[539819.49681800825, 651041.43740862445],
						[539801.49219761672, 651041.39381273114],
						[539801.41748726834, 651072.25536119635],
						[539744.11145989143, 651072.11673321365],
						[539744.03739188961, 651102.75705675909],
						[539715.74452248309, 651102.6886876385],
						[539715.67077439849, 651133.2184009559],
						[539686.657776615, 651133.14834222139],
						[539686.50958713691, 651194.53962750197],
						[539658.21687567816, 651194.47135737585],
						[539657.99381598562, 651286.94547242729],
						[539628.98108947824, 651286.87551547168],
						[539628.83311387163, 651348.26684707718],
						[539600.54066695157, 651348.19867619767],
						[539600.17085863464, 651501.73239342286],
						[539571.98155647377, 651501.6645194958],
						[539571.75950980512, 651593.9175433449],
						[539542.74732500059, 651593.8477385632],
						[539542.67336368619, 651624.59875582892],
						[539485.36926150334, 651624.46102968778],
						[539485.22235019959, 651685.63123288669],
						[539456.93048383133, 651685.56330914237],
						[539456.78261586081, 651747.17599176313],
						[539427.77070149756, 651747.10638987063],
						[539427.69668922282, 651777.96804586449],
						[539399.40498175088, 651777.90022111742],
						[539399.18416451931, 651870.04275601613],
						[539370.89261549525, 651869.97498033009],
						[539370.81923918333, 651900.61542438529],
						[539341.80759558722, 651900.54597419093],
						[539341.21942903101, 652146.3333849468],
						[539283.91714535491, 652146.19636096992],
						[539284.13705624128, 652054.16431596188],
						[539227.65746898064, 652054.02945470484],
						[539227.80448125419, 651992.41667789337],
						[539170.50166110357, 651992.2800492259],
						[539170.57440097176, 651961.75020590704],
						[539084.98008249351, 651961.54649304517],
						[539085.05345232377, 651930.68480783445],
						[538998.73882623389, 651930.47983192722],
						[538998.6656184335, 651961.34151752596],
						[538942.18571228755, 651961.20763698581],
						[538942.11339653679, 651991.73748131585],
						[538912.9990361433, 651991.66854413389],
						[538912.85320365243, 652053.28132374957],
						[538884.66484716896, 652053.21462829341],
						[538884.59185291268, 652084.07633287809],
						[538827.28935224505, 652083.94090047793],
						[538827.21724927588, 652114.47076359286],
						[538769.91485454445, 652114.33553117572],
						[538769.84259712044, 652144.97601455403],
						[538741.55152121815, 652144.90932186786],
						[538741.62320458086, 652114.49006927828],
						[538712.61245934723, 652114.20049847825],
						[538712.75702104508, 652052.8089295181],
						[538684.46578653355, 652052.74233506748],
						[538684.61076310498, 651991.12955343234],
						[538655.59927924105, 651991.06131415744],
						[538655.67106292932, 651960.53146857535],
						[538627.37966962496, 651960.46497236297],
						[538627.45218045707, 651929.60328511859],
						[538599.26361191552, 651929.53707900969],
						[538599.4794273614, 651837.61573657067],
						[538626.94800356962, 651837.68025104329],
						[538627.74170387408, 651806.37781308172],
						[538656.03336234286, 651806.44430991728],
						[538656.24845310277, 651714.96548428305],
						[538685.26042418473, 651715.03372470802],
						[538685.69483248529, 651530.41696909],
						[538742.99926246493, 651530.55190796498],
						[538743.07198827644, 651499.69028577372],
						[538771.36417450372, 651499.75698107702],
						[538771.43669256137, 651469.00597874401],
						[538828.741336587, 651469.14121647202],
						[538828.81422305573, 651438.2796038969],
						[538856.28346646926, 651438.34450154204],
						[538857.07578897628, 651407.81644098554],
						[538914.38064628013, 651407.95197720663],
						[538914.45316957484, 651377.31160431984],
						[538963.11609203974, 651377.42685764807],
						[538971.75813320035, 651377.44734052988],
						[538971.83102548367, 651346.69635741226],
						[539029.13609581825, 651346.83229361381],
						[539029.28183213202, 651285.44095665205],
						[539057.57438704674, 651285.50814447785],
						[539057.64770217997, 651254.64656049642],
						[539114.95309335354, 651254.78279581154],
						[539115.02625287476, 651224.03183167707],
						[539200.52152871201, 651224.23545567901],
						[539200.66790380608, 651162.84415685921],
						[539229.78373197024, 651162.91360347625],
						[539230.29734873911, 650947.65705047373],
						[539201.18113937124, 650947.58760294749],
						[539201.40056983253, 650855.55609236541],
						[539173.21015974064, 650855.48890216602],
						[539173.28289920615, 650824.95922729932],
						[539144.26935745496, 650824.89012568735],
						[539144.34283309907, 650794.02861098235],
						[539087.75629460206, 650793.78337065165],
						[539087.82913807069, 650763.14308976312],
						[539058.81548723311, 650763.07413894858],
						[539058.88880218088, 650732.21263306099],
						[538915.9808690052, 650731.87376014853],
						[538915.90782230615, 650762.73526667338],
						[538773.10303972289, 650762.39787915442],
						[538773.17529666203, 650731.75760141853],
						[538744.88231015741, 650731.46967357607],
						[538745.02697921777, 650670.07851686934],
						[538716.0131641581, 650670.01017098059],
						[538716.08557474078, 650639.25929200137],
						[538687.79190772795, 650639.19269182626],
						[538687.93584218377, 650578.02279122476],
						[538658.92186467536, 650577.95454608381],
						[538658.99520838156, 650546.76122205169],
						[538630.70138219511, 650546.69472011481],
						[538630.77285295108, 650516.27570285753],
						[538602.5818611359, 650516.20949105523],
						[538602.79845421237, 650423.95693476032],
						[538573.68131742161, 650423.88859847374],
						[538573.75346063799, 650393.13775538735],
						[538602.87065188563, 650393.20609179582],
						[538602.94258984434, 650362.56586791633],
						[538745.75084520504, 650362.9017775082],
						[538745.82278861559, 650332.37217328302],
						[538916.925500646, 650332.77626966138],
						[538916.99959445733, 650301.47236932581],
						[538974.30830792082, 650301.60811441834],
						[538974.38015102257, 650271.29974923562],
						[539002.6744511202, 650271.36684258468],
						[539002.74765832373, 650240.5054097207],
						[539031.76223131292, 650240.57426160027],
						[539031.9084920201, 650178.96202433005],
						[538889.09863902093, 650178.62362929911],
						[538889.02564542787, 650209.48505349283],
						[538859.90812882909, 650209.41621032881],
						[538859.98106776678, 650178.55478600191],
						[538802.67192540574, 650178.41943939694],
						[538802.74397363584, 650147.8898626155],
						[538746.25783748762, 650147.75665516721],
						[538746.33004148642, 650117.11646824284],
						[538660.00589389598, 650116.91327071318],
						[538659.93385076278, 650147.55345801148],
						[538603.44771346229, 650147.42074118229],
						[538603.59081008646, 650086.47221372044],
						[538631.0633516371, 650086.09427758574],
						[538632.00032909983, 649993.84360530786],
						[538603.80844152637, 649993.77739140124],
						[538603.88063904992, 649963.02661223779],
						[538574.76268599217, 649962.95827403362],
						[538574.83508855302, 649932.09688500769],
						[538517.52508716483, 649931.96253228211],
						[538517.59660478192, 649901.43299041071],
						[538489.40455876361, 649901.36697266041],
						[538489.54826607276, 649839.97605940932],
						[538517.74041735148, 649840.04207740608],
						[538517.88422987831, 649778.65118254628],
						[538489.69197333953, 649778.58516430308],
						[538489.76421535562, 649747.72380226478],
						[538461.46901414753, 649747.65759155317],
						[538461.61106325639, 649686.93040841632],
						[538232.36969438591, 649685.51086130273],
						[538232.58342698053, 649593.59051141748],
						[538204.39085313759, 649593.5249823489],
						[538204.53400743857, 649531.91292916599],
						[538061.61564147484, 649531.58148221835],
						[538061.54446011561, 649562.33220009576],
						[538032.52869026712, 649562.2650603198],
						[538032.45730731008, 649593.12639699061],
						[537975.8663727066, 649592.99559817638],
						[537975.58279845933, 649715.77730652527],
						[537918.37493493094, 649715.6452797713],
						[537918.30402059562, 649746.39602553425],
						[537746.37207328063, 649746.00043163425],
						[537746.30122654769, 649776.86179690715],
						[537718.00607548398, 649776.79686558689],
						[537717.9360430704, 649807.3263928541],
						[537660.62560680124, 649807.19502685103],
						[537660.55492072366, 649838.05640160979],
						[537574.94954557519, 649837.86055046134],
						[537575.08983803215, 649776.46964745526],
						[537546.07444606361, 649776.40336610202],
						[537546.14491698588, 649745.541999968],
						[537517.95260367973, 649745.47764785774],
						[537518.02276928257, 649714.72690037254],
						[537489.72751129058, 649714.66236188635],
						[537489.79787616699, 649683.80100465473],
						[537460.78232067346, 649683.73487380997],
						[537460.99173981359, 649591.81451399706],
						[537490.00745751977, 649591.88064521004],
						[537490.0778223573, 649561.01930620254],
						[537661.18856148887, 649561.41033479013],
						[537661.25899411889, 649530.6596151907],
						[537746.86596865696, 649530.85591570055],
						[537746.93579958065, 649500.43704323005],
						[537775.95218678634, 649500.28245088866],
						[537776.02283375605, 649469.53174084867],
						[537804.31851357617, 649469.59677200753],
						[537804.45965900668, 649408.2059798243],
						[537833.4757007109, 649408.27271713864],
						[537833.68796304357, 649316.0206422148],
						[537804.67175854277, 649315.95390452654],
						[537804.8129038678, 649254.56315763167],
						[537776.51685400237, 649254.4981256231],
						[537776.44646123378, 649285.13818995294],
						[537719.13420487521, 649285.00662000407],
						[537719.0636651481, 649315.75730305922],
						[537661.75151551142, 649315.62593312748],
						[537661.82194805704, 649284.87524982868],
						[537633.52595035813, 649284.81046387891],
						[537633.59607681062, 649254.17039894289],
						[537604.5797631673, 649254.10401434638],
						[537604.79048619349, 649161.96261839999],
						[537548.30096296291, 649161.8335264523],
						[537547.40808753436, 649192.36108460964],
						[537490.91866873484, 649192.23218979558],
						[537490.84830402723, 649223.09347414225],
						[537437.44583853299, 649222.97180143499],
						[537433.39607254427, 649284.35364065669],
						[537404.37981216155, 649284.28760934179],
						[537404.23965834139, 649345.89959667565],
						[537347.64787285845, 649345.77095999778],
						[537347.57853006304, 649376.30042570713],
						[537261.25049310015, 649376.10457183956],
						[537254.0112176796, 649437.70050071168],
						[537232.8151400534, 649437.6524912694],
						[537232.74575957586, 649468.29258503695],
						[537204.55297089845, 649468.22877027281],
						[537204.48339266563, 649498.97948275437],
						[537147.17188165535, 649498.84990638494],
						[537147.10266048857, 649529.49000954791],
						[537061.49567884603, 649529.29683161934],
						[537061.56474048982, 649498.65672809398],
						[537032.54885827913, 649498.59135292994],
						[537032.61811496725, 649467.84063972882],
						[537004.32243212499, 649467.77693654667],
						[537004.66820189508, 649314.13405205682],
						[537032.96414913342, 649314.19775583385],
						[537033.17166986095, 649222.05632547592],
						[537062.18804005685, 649222.12170173612],
						[537062.53434494056, 649068.47899970203],
						[537033.51770361769, 649068.41362282727],
						[537033.58745841146, 649037.44174543722],
						[537005.29103492072, 649037.3780405838],
						[537005.35949173383, 649006.95923679206],
						[537032.11252343864, 649007.01946568326],
						[537033.72522410192, 648976.27230109414],
						[537005.42869534134, 648976.20859600569],
						[537005.77346856124, 648823.00852867751],
						[537034.07075920003, 648822.85100690601],
						[537034.14026478899, 648791.98977966164],
						[537005.84341890889, 648791.92607386236],
						[537005.98182597244, 648730.42486016394],
						[537091.59296682442, 648730.61774908507],
						[537091.73194355075, 648669.00594057015],
						[537120.02900095494, 648669.06979417021],
						[537120.23525286047, 648577.70294495043],
						[537149.25375969999, 648577.32602047175],
						[537149.39395065268, 648515.27180340595],
						[537177.58837326081, 648515.33552359138],
						[537178.00426337798, 648331.38525280613],
						[537092.49394449242, 648331.19214611687],
						[537092.56355748314, 648300.33099168376],
						[537035.24786858272, 648300.2018054208],
						[537035.29246166535, 648280.40199890547],
						[537035.31762312271, 648269.23004186165],
						[537007.01987765136, 648269.16633403709],
						[537007.15753756999, 648207.9971142232],
						[536978.13937779667, 648207.93183507398],
						[536978.89802721806, 647870.56123142061],
						[536950.60108698078, 647869.83394134196],
						[536950.67018303287, 647839.0834673706],
						[536921.65137225576, 647839.01828790409],
						[536921.72016568203, 647808.37843151367],
						[536893.42162715527, 647808.31491917418],
						[536893.49011968495, 647777.78568031103],
						[536807.97692203207, 647777.59405312373],
						[536808.04599855293, 647746.73297886073],
						[536750.72838008893, 647746.60478428763],
						[536750.79611303296, 647716.29678004538],
						[536693.47937574412, 647715.72633242921],
						[536693.54823711503, 647684.86526673438],
						[536636.23040301178, 647684.73747124081],
						[536636.16164920852, 647715.59853717638],
						[536579.6671570919, 647715.47277290293],
						[536579.59875534673, 647746.2232304404],
						[536550.47687653813, 647746.15847706096],
						[536550.40828338813, 647777.01955240604],
						[536522.21259487281, 647776.95690758131],
						[536522.0767426953, 647838.12600603281],
						[536492.95502663811, 647838.06135452562],
						[536492.68206599622, 647961.06328506349],
						[536464.48669304058, 647961.00073921634],
						[536464.35056339263, 648022.3911184466],
						[536436.05239314714, 648022.32839316863],
						[536435.8482345189, 648114.46930274752],
						[536464.14624619868, 648114.53202767135],
						[536463.53280352592, 648391.17622543219],
						[536435.23526790738, 648391.11350156204],
						[536435.16664304561, 648422.08528587455],
						[536409.23585915542, 648422.02785086329],
						[536406.08151531545, 648452.43973740027],
						[536377.78408512229, 648452.37711239432],
						[536377.71605760069, 648483.12767891912],
						[536321.22420228063, 648483.00280251168],
						[536320.33381844568, 648513.41971480881],
						[536291.31619763782, 648513.35564766382],
						[536291.17924481991, 648575.40987195808],
						[536262.88202623976, 648575.34744468343],
						[536262.74761949247, 648636.29555122741],
						[536234.55340428383, 648636.23339962203],
						[536234.14610993431, 648821.06887385959],
						[536262.34000822844, 648821.13102477102],
						[536262.272926745, 648851.54980478995],
						[536234.07908060797, 648851.4876539947],
						[536233.87604262575, 648943.62893140828],
						[536204.75628431537, 648943.56479027099],
						[536204.68833463162, 648974.42604366166],
						[536178.03814637812, 648974.36738736113],
						[536176.4270457516, 649005.11463583366],
						[536119.11381338211, 649004.98864275962],
						[536118.97896384145, 649066.37933142774],
						[536147.17244152632, 649066.44128487131],
						[536147.10459936946, 649097.30255669006],
						[536171.49088275037, 649097.35618304403],
						[536176.15691867482, 649127.89603029203],
						[536204.35029088752, 649127.95808177278],
						[536204.07946603, 649250.96077600156],
						[536146.76709055679, 649250.83468654461],
						[536146.5642933565, 649343.08675557119],
						[536175.68334415264, 649343.15079365228],
						[536175.61617732514, 649373.68026422779],
						[536203.80912811472, 649373.74231477664],
						[536203.7411782908, 649404.60363185522],
						[536232.86012014479, 649404.6677711911],
						[536232.79235939938, 649435.41847865912],
						[536260.98520433309, 649435.48062724515],
						[536260.7822517294, 649527.51154832693],
						[536233.30981572764, 649527.45098721632],
						[536232.18324347667, 649711.84320771939],
						[536203.06484560505, 649711.77906958165],
						[536202.86196995736, 649803.92072795844],
						[536117.35930839845, 649803.732692071],
						[536117.42636895424, 649773.20315813331],
						[536089.13121159701, 649773.14102985896],
						[536089.40118583303, 649650.13802503655],
						[535946.4838475422, 649649.82496249385],
						[535947.22285214171, 649311.78829584352],
						[535890.01358305162, 649311.66332623968],
						[535890.08070220612, 649280.91263553116],
						[535832.76843113068, 649280.78764051723],
						[535832.83520204341, 649250.14756808092],
						[535804.53914458363, 649250.08592954464],
						[535804.47242639912, 649280.72600209713],
						[535747.16015467374, 649280.60130546312],
						[535747.02621043846, 649342.21330661094],
						[535718.01005216315, 649342.15025115304],
						[535717.94373509346, 649372.67972357816],
						[535604.04009014287, 649372.43269283744],
						[535604.10619573155, 649341.90321995353],
						[535546.79413723794, 649341.77922169969],
						[535546.92733120266, 649280.16721892613],
						[535489.71795209625, 649280.04364205175],
						[535489.85045417096, 649218.65288495424],
						[535518.04367077257, 649218.71375970321],
						[535518.11033282604, 649187.85246713681],
						[535489.91706331004, 649187.79159227444],
						[535490.04956532863, 649126.40086235164],
						[535461.75329492264, 649126.33981369517],
						[535461.81913526717, 649095.81037624809],
						[535432.80254217191, 649095.74782407889],
						[535432.93578358204, 649033.91466530215],
						[535404.63935402152, 649033.85371493211],
						[535404.70484976016, 649003.43490461423],
						[535375.6880936583, 649003.37245323253],
						[535375.82064354792, 648941.76054897194],
						[535319.22746715334, 648941.63889349462],
						[535319.16117944289, 648972.50015049952],
						[535265.86079660535, 648972.38575148408],
						[535261.78189045377, 649003.12779337505],
						[535232.76513381279, 649003.06559420121],
						[535232.69995614444, 649033.48440519883],
						[535204.40352584247, 649033.42379940336],
						[535204.33721641847, 649064.3956843646],
						[535176.14373523032, 649064.33534749702],
						[535176.07771552785, 649095.19662326982],
						[535151.69142894272, 649095.1444731662],
						[535146.99586540891, 649125.66401404282],
						[535118.69959373295, 649125.60355573066],
						[535118.63368158054, 649156.46484082227],
						[535089.61719552369, 649156.40289425314],
						[535089.48618825641, 649217.79363647162],
						[535036.80397026939, 649217.68129741156],
						[535032.76316587045, 649279.06372722681],
						[535003.74689615401, 649279.00193219143],
						[535003.61573748419, 649340.61393933266],
						[534946.30367450172, 649340.49203408894],
						[534946.1732007165, 649401.88283178117],
						[534917.87740437523, 649401.82271905197],
						[534917.74703619583, 649463.2135350703],
						[534860.43540053733, 649463.09192911861],
						[534860.24005190597, 649555.23349485407],
						[534832.04741230002, 649555.17374797119],
						[534831.78731418506, 649677.95549007156],
						[534802.668856301, 649677.89383190637],
						[534802.60353491898, 649708.75520022423],
						[534774.41115853994, 649708.69555216585],
						[534774.28085550945, 649770.30768850411],
						[534746.80882516771, 649770.24961101427],
						[534745.07121297892, 649862.16682429158],
						[534774.08645360917, 649862.22816285049],
						[534774.1510203178, 649831.69861451257],
						[534802.34318579303, 649831.75826212624],
						[534802.27856674534, 649862.28781035356],
						[534974.20929826132, 649862.65261934325],
						[534974.27423654636, 649832.12307179277],
						[535117.18999036681, 649832.42768403108],
						[535117.05887433642, 649893.81862546504],
						[535089.58705035329, 649893.75997526862],
						[535087.84705981216, 649985.89843538904],
						[535059.55226847006, 649985.83807886147],
						[535059.42136632616, 650047.22906615306],
						[534916.50747953099, 650046.9249560223],
						[534916.44194289413, 650077.78637868084],
						[534859.1324493275, 650077.66477727797],
						[534859.0022947049, 650139.05579344928],
						[534830.81065611239, 650138.99604869075],
						[534830.74598290003, 650169.52564198826],
						[534773.43680909229, 650169.40433927695],
						[534773.37154046772, 650200.26578077709],
						[534744.35689635854, 650200.20444347593],
						[534744.22670174239, 650261.8167259607],
						[534715.93238521414, 650261.75696075452],
						[534715.86839189008, 650292.06534352398],
						[534658.55964519235, 650291.94444121793],
						[534658.49365899945, 650323.24835969822],
						[534572.89080997324, 650323.06813831558],
						[534572.95663318853, 650291.76421949244],
						[534458.3391372778, 650291.52361086709],
						[534458.2735322821, 650322.82753014902],
						[534372.77356910717, 650322.64856627141],
						[534372.6456908331, 650383.81842992909],
						[534287.04315715691, 650383.63969676686],
						[534286.85101004178, 650475.78167838685],
						[534261.74656135181, 650475.72934625787],
						[534257.77254996309, 650506.58268894488],
						[534229.47865464189, 650506.52376084705],
						[534229.41532671836, 650536.94279615011],
						[534201.22437034524, 650536.8841308679],
						[534201.15948391147, 650568.07747364242],
						[534143.8516992596, 650567.95836535189],
						[534143.72467059991, 650629.1283033957],
						[534114.60789715732, 650629.06786372687],
						[534114.4795997137, 650690.90150868136],
						[534057.99532907864, 650690.784407467],
						[534057.67775139178, 650844.09653109068],
						[534028.66424341791, 650844.03645674139],
						[534028.60082774784, 650874.67677225382],
						[534057.61428165226, 650874.73684648983],
						[534057.55058277166, 650905.48778131395],
						[534084.19764121273, 650905.54300088482],
						[534085.78026905225, 650936.18673794204],
						[534142.26369662001, 650936.30393460474],
						[534143.02268153522, 650967.16720236512],
						[534200.32907474902, 650967.28630776377],
						[534200.20114235522, 651028.78820835659],
						[534171.08507667249, 651028.7276686735],
						[534170.82965949911, 651151.62091027282],
						[534199.94550754654, 651151.6814495055],
						[534199.75383886416, 651243.82377463789],
						[534227.94358312676, 651243.88243739353],
						[534228.00760211982, 651213.13145287102],
						[534256.30028147926, 651213.19037843659],
						[534256.23620956845, 651243.94136284571],
						[534285.24901184929, 651244.00183878432],
						[534285.18465499172, 651274.86344274867],
						[534313.47722811718, 651274.92246670253],
						[534313.34910074156, 651336.31384294201],
						[534285.05663326278, 651336.25481920619],
						[534284.92861149169, 651397.64621395012],
						[534255.91608033958, 651397.58573858091],
						[534255.78816686745, 651458.97715184628],
						[534284.80058968638, 651459.03762698895],
						[534284.73646343697, 651489.78864796797],
						[534313.02866670489, 651489.84767115139],
						[534312.90100092068, 651551.01788098691],
						[534341.91326131707, 651551.07845691405],
						[534341.78410121088, 651612.9123762435],
						[534370.07609260804, 651612.97149759717],
						[534369.75489175052, 651766.61614626832],
						[534341.46316475375, 651766.55702546693],
						[534341.1424591156, 651920.09117406455],
						[534368.6108975336, 651920.14857376635],
						[534369.24106238107, 652012.40357677219],
						[534398.25250859384, 652012.46425212442],
						[534398.05971763434, 652104.6069601574],
						[534426.35086289723, 652104.6661783501],
						[534425.77155054314, 652381.31578104396],
						[534368.47008592647, 652381.19588985562],
						[534368.5346038061, 652350.33412018092],
						[534322.24069419538, 652350.23740583076],
						[534311.23303120583, 652350.21442849119],
						[534311.29721064307, 652319.46327887313],
						[534283.00643501361, 652319.40425866656],
						[534283.07033085346, 652288.7637291702],
						[534254.05937221437, 652288.70325707528],
						[534254.1872862028, 652227.31159600359],
						[534225.89681256504, 652227.03144289542],
						[534225.96037129592, 652196.50154253072],
						[534168.65826251067, 652196.38234779355],
						[534168.59481019434, 652226.9122483735],
						[534140.4067514264, 652226.85368737672],
						[534140.27880290407, 652288.46658051747],
						[534082.97701466735, 652288.34768441226],
						[534082.91349175468, 652318.98821468477],
						[533997.32103324786, 652318.8109899438],
						[533997.25744109962, 652349.56214078271],
						[533985.52965014498, 652349.53789234522],
						[533939.95586581214, 652349.44374318491],
						[533939.8921524781, 652380.30551453074],
						[533854.40288838209, 652380.12924626097],
						[533854.34001888428, 652410.65917550249],
						[533797.03865655011, 652410.54127604119],
						[533796.97521124955, 652441.40305718733],
						[533596.78087809589, 652440.99271848705],
						[533596.7184867661, 652471.5226578603],
						[533568.42797280871, 652471.46486733551],
						[533568.36495641223, 652502.3266586049],
						[533511.1667879913, 652502.20996561041],
						[533511.10410444159, 652532.96114598622],
						[533481.99070251454, 652532.90182662359],
						[533481.92829869629, 652563.54239594447],
						[533425.45046140417, 652563.42746781395],
						[533425.38793793705, 652594.17865773221],
						[533368.08721526247, 652594.06225338252],
						[533368.0245744487, 652624.9240639552],
						[533310.72395893629, 652624.80785953766],
						[533310.66209808295, 652655.33782748191],
						[533282.37190044124, 652655.28052921337],
						[533282.30942028994, 652686.14234936808],
						[533253.29916288576, 652686.08364327298],
						[533253.2369609297, 652716.83485231898],
						[533227.31294952636, 652716.78243496129],
						[533224.88494362833, 652747.41825076682],
						[533195.87479435874, 652747.35964599729],
						[533195.75082812668, 652808.75147168874],
						[533167.46089449187, 652808.6943711685],
						[533167.21272686857, 652931.699310233],
						[533195.50244883576, 652931.75641032564],
						[533195.44080071279, 652962.28642455232],
						[533169.51717636886, 652962.23409832898],
						[533167.08886617736, 652993.0911915059],
						[533138.90212109115, 652993.03434767737],
						[533138.84013187047, 653023.7856033541],
						[533081.54090659355, 653023.67019776138],
						[533081.6027886282, 652992.91894186928],
						[533052.59307258064, 652992.86058995081],
						[533052.77855583944, 652900.60684970696],
						[532995.47890122503, 652900.49174408591],
						[532995.54017774086, 652869.96173828584],
						[532967.25034943863, 652869.90498229477],
						[532967.18912545894, 652900.43498819973],
						[532938.89934959274, 652900.37828099774],
						[532938.96052103478, 652869.84827498801],
						[532909.95058781328, 652869.79017478181],
						[532910.01236969302, 652838.92832540162],
						[532852.71250009642, 652838.81371739577],
						[532852.77395334432, 652808.06248838105],
						[532738.9969785203, 652807.83551001071],
						[532738.87427737529, 652869.44858946791],
						[532709.86434344738, 652869.39084234205],
						[532709.74219118233, 652930.78270859725],
						[532681.45246754284, 652930.72644442332],
						[532681.26928759343, 653022.86958671222],
						[532709.5588526713, 653022.92585057172],
						[532709.374853794, 653115.4008823859],
						[532738.38435360254, 653115.45862864505],
						[532738.26297401264, 653176.40810411738],
						[532766.44940468995, 653176.4642610118],
						[532766.26508393243, 653268.93936167471],
						[532795.37718240405, 653268.99741355062],
						[532795.25448690599, 653330.50001544668],
						[532737.95633068401, 653330.38580742397],
						[532738.01757125335, 653299.63450394094],
						[532709.00839645101, 653299.57675832475],
						[532709.13098912337, 653237.9635488973],
						[532680.84179409407, 653237.90728577436],
						[532680.90292745212, 653207.15599599748],
						[532652.61367940903, 653207.09978145116],
						[532652.67497955216, 653176.23788008117],
						[532623.66558699659, 653176.18028506706],
						[532623.78610266792, 653115.45204093854],
						[532596.32010001992, 653115.17632428277],
						[532595.6193012296, 653053.56153780897],
						[532566.60969219066, 653053.50404347468],
						[532566.67083026213, 653022.64216497121],
						[532510.1945701855, 653022.53038114705],
						[532510.1335381394, 653053.39225986577],
						[532452.83441606036, 653053.27904562908],
						[532452.77414667653, 653083.80908098305],
						[532395.4751306182, 653083.6960666728],
						[532395.41387772944, 653114.77918727789],
						[532366.30150614947, 653114.721843704],
						[532366.24161501438, 653145.14127247268],
						[532338.05513063702, 653145.08580176742],
						[532337.93436466635, 653206.4777538405],
						[532366.12074378575, 653206.53322433901],
						[532366.06019926397, 653237.28451527702],
						[532395.17235379526, 653237.3418584232],
						[532394.9903388212, 653329.7063749365],
						[532423.17650665517, 653329.76194325974],
						[532423.05651219352, 653390.60086899134],
						[532452.16730337532, 653391.21139430115],
						[532452.04589093279, 653452.71403580625],
						[532480.23184785631, 653452.76970195421],
						[532480.11054848286, 653514.16174549598],
						[532507.5763235474, 653514.21603580995],
						[532509.10080455872, 653575.61135244439],
						[532622.87246565847, 653575.8367396968],
						[532622.01875540009, 654006.02415125282],
						[532707.60242970975, 654006.19421567139],
						[532707.54124319472, 654036.94562597503],
						[532764.73407190712, 654037.05952295661],
						[532764.6729988677, 654067.70032109774],
						[532710.56577478652, 654067.81379797729],
						[532707.41909023107, 654098.33784392558],
						[532650.84366122226, 654098.22537224961],
						[532650.78236080171, 654129.08741335338],
						[532478.89624137431, 654128.74689904111],
						[532479.01754111541, 654067.35467007512],
						[532336.24189653387, 654066.85195738019],
						[532336.30173578672, 654036.4323908576],
						[532051.36665686476, 654035.6531213508],
						[532050.70656085666, 654004.90030468209],
						[531936.11494927108, 654004.67727856641],
						[531936.23357619985, 653943.61693244684],
						[531907.94623963709, 653943.23014969821],
						[531908.0654055872, 653881.83797225473],
						[531879.88018434076, 653881.78328713251],
						[531880.11830561748, 653758.99898741336],
						[531908.3041668142, 653758.83244003891],
						[531908.3636423857, 653728.19168503617],
						[531880.17815769615, 653728.13699940685],
						[531880.23779524607, 653697.38563249377],
						[531851.12645541236, 653697.32920124987],
						[531851.18625282182, 653666.46722247731],
						[531823.00066230283, 653666.41263488238],
						[531823.05976437347, 653635.88250984123],
						[531793.94831562089, 653635.82617985224],
						[531794.06748131895, 653574.21286153374],
						[531765.88173262042, 653574.1583718739],
						[531766.00036512967, 653512.76630462171],
						[531736.88869835355, 653512.71007568075],
						[531737.06680430868, 653420.45608475851],
						[531763.81265533692, 653420.50774222368],
						[531766.23784380103, 653389.87160934671],
						[531794.42412241653, 653389.81548336288],
						[531794.48295639909, 653359.39601589437],
						[531823.59489468299, 653359.45234682655],
						[531823.65463907504, 653328.5904191148],
						[531880.95280156564, 653328.7014403413],
						[531881.01243899728, 653297.95013371133],
						[531906.11257855268, 653297.99883078178],
						[531909.25835143088, 653267.25351887697],
						[531937.547495957, 653267.30845422449],
						[531937.66719696939, 653205.69524839148],
						[531909.37794641498, 653205.64031284279],
						[531909.49711193505, 653144.24835764267],
						[531794.89950075233, 653144.0263159204],
						[531794.84045288886, 653174.55636742234],
						[531652.05661865976, 653174.2808304748],
						[531651.99719701754, 653205.14273551852],
						[531594.69860386988, 653205.03251231229],
						[531594.75791794294, 653174.17060705903],
						[531480.98347696033, 653173.95233533671],
						[531481.04194194195, 653143.42228271312],
						[531451.92962108902, 653143.36655840627],
						[531452.04728943051, 653081.86400228285],
						[531434.04490348056, 653081.82956946013],
						[531366.56167353108, 653081.70067101484],
						[531366.61992566544, 653051.1706317463],
						[531309.32079584594, 653051.06140322401],
						[531309.26265012659, 653081.59144269652],
						[531280.97318600805, 653081.53758853895],
						[531280.91404040554, 653112.62071322277],
						[531252.62462968112, 653112.5669078487],
						[531252.39162581507, 653235.12959548738],
						[531080.59902861551, 653234.80389798223],
						[531080.71551757306, 653173.19069531024],
						[530995.12750638148, 653173.02910104045],
						[530995.18506905274, 653142.49904670613],
						[530880.58744569647, 653142.28337864974],
						[530880.6445877474, 653111.86394459289],
						[530852.35517572262, 653111.81082801661],
						[530852.41351101047, 653080.72770179482],
						[530766.92788921425, 653080.56748868118],
						[530766.98502773955, 653050.03744730249],
						[530709.68589397916, 653049.93030881346],
						[530709.62886186235, 653080.4603503847],
						[530680.61930029723, 653080.40618416923],
						[530680.44753975712, 653172.43880118139],
						[530709.45693891682, 653172.49296709371],
						[530709.34184142482, 653234.10617238004],
						[530680.33255098586, 653234.05200666888],
						[530680.16017098667, 653326.41654166405],
						[530651.87112817715, 653326.36377009295],
						[530651.81358364073, 653357.22570198262],
						[530623.52459384652, 653357.17297918932],
						[530623.41064127698, 653418.3437757605],
						[530594.40167595842, 653418.28976168786],
						[530594.3442389667, 653449.15170771163],
						[530566.05540736322, 653449.09908381361],
						[530565.94125659741, 653510.49114106735],
						[530536.93245388684, 653510.43722840538],
						[530536.87532991788, 653541.1885722453],
						[530508.58665669721, 653541.13604724559],
						[530508.52979092835, 653571.77677945269],
						[530479.52109636704, 653571.72296810779],
						[530479.40685765701, 653633.3362957621],
						[530393.82124214992, 653633.17783210659],
						[530393.87830338068, 653602.31585746096],
						[530365.69260287192, 653602.26376855257],
						[530365.74940684089, 653571.51241485565],
						[530280.16346946266, 653571.35454294644],
						[530280.21990956843, 653540.71380994911],
						[530251.21116019087, 653540.66040148772],
						[530251.26774977904, 653509.90905665932],
						[530080.19810084917, 653509.59513872745],
						[530080.14183127158, 653540.34648414236],
						[530051.03021333751, 653540.29324070585],
						[530050.97420042194, 653570.93397448212],
						[529908.19380903407, 653570.67358402035],
						[529908.08171168854, 653632.28691560891],
						[529879.79319523263, 653632.23547266307],
						[529879.73770221591, 653662.76560447947],
						[529850.72916821914, 653662.71290272847],
						[529850.61728557223, 653724.32626258791],
						[529822.32892750483, 653724.27491852897],
						[529822.16196488577, 653816.30783578474],
						[529793.97663128644, 653816.25672713434],
						[529793.92089600291, 653847.00811991934],
						[529764.80982113897, 653846.95538334607],
						[529764.69865975867, 653908.34756649984],
						[529707.40251763829, 653908.24392146606],
						[529707.34674406878, 653939.10594505677],
						[529679.16162101924, 653939.05503326526],
						[529678.77357335552, 654153.98316327529],
						[529621.47828740219, 654153.87981773738],
						[529621.42267425323, 654184.74187894026],
						[529593.13510849001, 654184.69092929305],
						[529593.08014585648, 654215.22114509181],
						[529507.49755985709, 654215.06729595701],
						[529507.44216047635, 654245.92936687521],
						[529478.43465555809, 654245.8773220994],
						[529478.49000048335, 654215.01525108202],
						[529450.30535049771, 654214.96473168558],
						[529450.2500584909, 654245.82680279925],
						[529421.1396899044, 654245.7746748426],
						[529421.08465052524, 654276.52613397781],
						[529392.90010601224, 654276.47571301216],
						[529392.8449215584, 654307.3377936855],
						[529192.67331086262, 654306.98108545761],
						[529192.72811949567, 654276.11900411593],
						[529135.43325925095, 654276.01735268719],
						[529135.48776424211, 654245.26589259738],
						[529107.20030263218, 654245.21577917179],
						[529107.25495057122, 654214.35370691097],
						[529078.2473899324, 654214.30236832437],
						[529078.3013963768, 654183.77215082326],
						[529050.1166928279, 654183.72231758479],
						[529050.17123337381, 654152.86025446991],
						[529021.88361274928, 654152.8102878537],
						[529022.04590323532, 654060.88782628393],
						[528993.0384619846, 654060.61540474603],
						[528993.09211452829, 654030.19582668133],
						[528850.21323556872, 654029.72321071627],
						[528850.15945915121, 654060.36402253259],
						[528823.51712590049, 654060.53851921426],
						[528821.81776171294, 654091.06583331258],
						[528792.80998351309, 654091.01499841968],
						[528792.75592637248, 654121.87705306255],
						[528764.46825242834, 654121.8275294234],
						[528764.41482907871, 654152.35773871886],
						[528707.22240154212, 654152.25775981857],
						[528707.16850487061, 654183.1198240692],
						[528621.585751754, 654182.97058729967],
						[528621.63948774675, 654152.1085227686],
						[528593.35186582536, 654152.05929358921],
						[528592.68492157443, 654121.52783126966],
						[528564.3972470283, 654121.47865192464],
						[528564.50392718695, 654060.08639581234],
						[528537.03944821924, 654059.81746021251],
						[528536.26972219266, 654029.17521880218],
						[528507.26183478581, 654029.12488780683],
						[528507.36830090813, 653967.73265919776],
						[528479.08036170935, 653967.68362666771],
						[528479.2399981895, 653875.54000995576],
						[528450.23183966358, 653875.48977959785],
						[528450.28525286785, 653844.62776114803],
						[528478.57340382715, 653844.67674412427],
						[528479.34674186574, 653813.92659446108],
						[528450.33847461618, 653813.87636391341],
						[528450.55097864952, 653691.09205436276],
						[528479.55946256919, 653691.14228528435],
						[528479.61293018574, 653660.28029489866],
						[528422.31592343631, 653660.18112903368],
						[528422.90001459839, 653322.35878520773],
						[528451.18906430842, 653322.40772106021],
						[528451.29550752556, 653260.90508888243],
						[528480.30475057522, 653260.95532111835],
						[528480.41149393609, 653199.34209147841],
						[528508.70075533504, 653199.39112629998],
						[528508.75427593268, 653168.52921045618],
						[528537.76368199347, 653168.57954408857],
						[528537.86468727491, 653110.39544321562],
						[528508.85997428873, 653107.57970577828],
						[528508.91387851979, 653076.4965715576],
						[528480.62440563657, 653076.44753637072],
						[528480.67729817028, 653045.91748734436],
						[528423.37815006101, 653045.81831777736],
						[528423.43150993669, 653014.95642484247],
						[528395.24480234866, 653014.90771443967],
						[528395.29791824031, 652984.15644215897],
						[528366.18531534565, 652984.10618242552],
						[528366.23856763751, 652953.2442986141],
						[528338.05175423995, 652953.19568627665],
						[528338.10400021402, 652922.88688726583],
						[528309.094541559, 652922.61567387159],
						[528309.14768645761, 652891.75379914383],
						[528280.85789566056, 652891.70510772418],
						[528280.96236658434, 652830.97691604437],
						[528252.67361181788, 652830.26457713894],
						[528252.72646037256, 652799.51333213493],
						[528223.71640303382, 652799.4635014938],
						[528223.76900741435, 652768.82287698251],
						[528195.47900507064, 652768.77433248819],
						[528195.58429805911, 652707.38248112891],
						[528166.57407814811, 652707.33275132626],
						[528166.62676521996, 652676.58152450377],
						[528138.33660414827, 652676.53307834128],
						[528138.38942762942, 652645.6712401465],
						[528110.20208686776, 652645.62301847921],
						[528110.25429000123, 652615.09303250059],
						[528081.14103353198, 652615.04327754851],
						[528081.19374942849, 652584.18144842901],
						[528023.89299194107, 652584.08367126575],
						[528023.94541170041, 652553.33246246621],
						[527995.75791261706, 652553.28443701763],
						[527995.81009127339, 652522.64384858054],
						[527967.5196652934, 652522.59569636511],
						[527967.57197939313, 652491.84449659823],
						[527938.56137913186, 652491.79516916093],
						[527938.61382694496, 652460.93335812096],
						[527967.62448166532, 652460.98268565186],
						[527967.72892164777, 652399.59092500212],
						[528081.50872202392, 652399.78488173278],
						[528081.45600617491, 652430.64668307151],
						[528167.04788250383, 652430.79310776258],
						[528167.10075903276, 652399.93130670139],
						[528196.11152140261, 652399.98103743594],
						[528196.32134810276, 652277.64003701427],
						[528224.61295523983, 652277.24612016336],
						[528224.66574938933, 652246.49495809944],
						[528252.95665049634, 652246.54355281894],
						[528253.72944082518, 652215.90424871305],
						[528282.02077515936, 652215.73166211846],
						[528282.12638749112, 652154.33997706999],
						[528306.40526053833, 652154.38176207175],
						[528310.47040139907, 652123.63752732077],
						[528282.17928879079, 652123.5888336238],
						[528282.23161920626, 652093.16954158363],
						[528253.94083437289, 652092.89966528385],
						[528253.99330253573, 652062.36976210657],
						[528224.98194439569, 652062.31992923922],
						[528225.03492839425, 652031.45818380755],
						[528196.74365716206, 652031.4096371351],
						[528196.90169092419, 651939.26689047879],
						[528167.89011555444, 651939.21715835342],
						[528168.10048398084, 651816.43397035543],
						[528139.80884272477, 651816.38552166056],
						[528139.86242330889, 651785.08135113935],
						[528111.67360698816, 651785.03312694537],
						[528111.77820195316, 651723.86280023982],
						[528082.6633671911, 651723.81304259691],
						[528082.7151381342, 651693.50442444149],
						[528025.41127619159, 651693.40664197598],
						[528025.51668092853, 651631.57264980697],
						[527997.3276014009, 651631.52462166757],
						[527997.48507849267, 651539.05020623934],
						[527969.19295989897, 651539.00205114321],
						[527969.50590198569, 651355.04888119258],
						[527993.88883700815, 651355.09037969378],
						[527997.85070385633, 651324.34601190779],
						[528026.04031006421, 651324.3940409394],
						[528026.1449603755, 651263.00262019353],
						[528055.26061118569, 651263.05227774859],
						[528055.41841031204, 651170.57802830543],
						[528083.60828017013, 651170.62615604547],
						[528083.76529305952, 651078.70502362214],
						[528055.57526559429, 651078.65689560736],
						[528055.6275506746, 651048.01652714482],
						[528083.81763067679, 651048.06465524179],
						[528083.97539924947, 650955.70111743722],
						[528113.09159426251, 650955.75087740843],
						[528113.1443643854, 650924.88929743215],
						[528141.33465550025, 650924.93752414978],
						[528141.38709987409, 650894.29717878881],
						[528198.69374710752, 650894.39536549186],
						[528198.79903913976, 650833.00407385523],
						[528227.0923726469, 650833.05262406543],
						[528227.14478661062, 650802.52290753881],
						[528252.24873634183, 650802.56602566387],
						[528256.36937974591, 650679.79023452988],
						[528312.95657399169, 650679.88758178218],
						[528313.01009927632, 650648.80481404788],
						[528370.21471617417, 650648.90342141397],
						[528370.26777699345, 650618.15250296146],
						[528455.86908979737, 650618.30043132952],
						[528455.92211926903, 650587.66013251164],
						[528484.21587497543, 650587.7091251947],
						[528484.98897155968, 650557.18069350068],
						[528513.28277971782, 650557.22973620216],
						[528513.33687510923, 650526.03637284983],
						[528542.35094424826, 650526.08671457169],
						[528542.40375051799, 650495.66765918653],
						[528598.99157846125, 650495.76599088334],
						[528599.81857377966, 650434.3760731091],
						[528628.112593267, 650434.42531341722],
						[528628.27322047995, 650342.17267004959],
						[528656.56739863008, 650342.22195932246],
						[528656.72799173661, 650250.07997192419],
						[528628.43365502288, 650250.030682371],
						[528628.48738998687, 650219.16920946457],
						[528600.19300007785, 650219.11996851349],
						[528599.57994782133, 650157.50639807759],
						[528571.2854518001, 650157.4572068702],
						[528571.39174547535, 650096.28736542747],
						[528543.09714410151, 650096.23822272592],
						[528543.15052633046, 650065.48738691618],
						[528571.44518061657, 650065.5365297083],
						[528571.49803911534, 650035.11754202191],
						[528544.02721932973, 650034.62737009302],
						[528543.31067295792, 649973.23490682303],
						[528563.78582858457, 649973.27046366525],
						[528571.60548599786, 649973.28404988418],
						[528571.87227705028, 649819.75123672397],
						[528543.57719980634, 649819.7020931982],
						[528543.68377208407, 649758.31112239161],
						[528486.37316502538, 649758.21173323807],
						[528486.42663161957, 649727.35033295595],
						[528429.11591664609, 649727.25114336913],
						[528429.16908441391, 649696.50036180089],
						[528400.97668703226, 649696.4516415695],
						[528401.02999312605, 649665.59025015868],
						[528371.91151335684, 649665.53998027928],
						[528372.17643439665, 649512.00739097979],
						[528343.98372068652, 649511.95876846544],
						[528344.08954561152, 649450.56788712763],
						[528315.0735785584, 649450.51789527142],
						[528315.1263416016, 649419.87776838662],
						[528337.04269798996, 649419.91552353022],
						[528344.24856895849, 649358.31567786867],
						[528258.6406962421, 649358.16833065369],
						[528258.58765846654, 649389.02967695752],
						[528229.57158281479, 649388.9798359808],
						[528229.51878939802, 649419.73057278479],
						[528172.20700221637, 649419.63227865216],
						[528172.15450548986, 649450.27240599284],
						[528116.38622730284, 649450.17695086123],
						[528115.61339217692, 649480.92646552064],
						[528086.49458538287, 649480.87670108548],
						[528086.33700687613, 649573.12896735058],
						[528029.02575436665, 649573.03117227484],
						[528028.86906300986, 649664.95163709554],
						[528000.67661153304, 649664.90360321198],
						[528000.57169055508, 649726.51577885344],
						[527972.2764528679, 649726.46761845215],
						[527972.22395128896, 649757.32902038563],
						[527943.20852556149, 649757.27968474256],
						[527943.15664238238, 649787.80924824835],
						[527914.86151017074, 649787.76118664898],
						[527914.75728548993, 649849.15217050188],
						[527828.43173119577, 649849.00584036135],
						[527828.48340156872, 649818.47626747168],
						[527800.18832212803, 649818.4284032071],
						[527800.1367042918, 649848.95797618455],
						[527742.8264131858, 649848.86117865623],
						[527742.87792460981, 649818.33160550031],
						[527714.68573612382, 649818.28406197799],
						[527714.53079952777, 649910.20463848836],
						[527742.72283041163, 649910.25218174164],
						[527742.61887433508, 649971.86443192209],
						[527771.7368116338, 649971.91358738113],
						[527771.6846856114, 650002.77502647927],
						[527885.48107420444, 650002.96762645256],
						[527885.42929737479, 650033.49722627888],
						[527857.13458795357, 650033.44926401973],
						[527857.03020231379, 650095.06154999114],
						[527771.52905482857, 650094.91691316932],
						[527771.58099403977, 650064.1660748868],
						[527685.15367894107, 650064.0203231941],
						[527685.10190136626, 650094.77116175136],
						[527456.68727783381, 650094.3881484532],
						[527456.73862822144, 650063.6373091822],
						[527399.42908538075, 650063.54170856974],
						[527399.48051290819, 650032.6802591728],
						[527285.68432996329, 650032.49102276948],
						[527285.6331160313, 650063.35247252625],
						[527228.32357219898, 650063.25746830262],
						[527228.17135211895, 650155.17815820477],
						[527256.46585206152, 650155.22503811284],
						[527256.15981175972, 650339.84084236377],
						[527285.17420947354, 650339.88896560308],
						[527285.07233213494, 650401.28011711792],
						[527312.54330817098, 650401.32572763297],
						[527313.31514144235, 650432.18859952595],
						[527456.12279251846, 650432.42645205359],
						[527456.0718114716, 650462.9561165733],
						[527505.56053765991, 650463.03883166378],
						[527513.37996215071, 650463.05191461672],
						[527513.32831938367, 650493.91342771577],
						[527541.62223641528, 650493.9607983391],
						[527541.57128169388, 650524.37985688529],
						[527570.585353759, 650524.42848377582],
						[527570.53304695711, 650555.6218501844],
						[527598.8268577964, 650555.66931924701],
						[527598.77561135998, 650586.19900146965],
						[527627.78957433579, 650586.24772930902],
						[527627.6864160751, 650647.63895158167],
						[527655.98006856698, 650647.68651899579],
						[527655.92778538761, 650678.76928884583],
						[527684.11849849939, 650678.81673162046],
						[527684.01550178742, 650739.98675123067],
						[527713.13207881292, 650740.03580290242],
						[527712.87329062982, 650893.56931296422],
						[527741.06363544229, 650893.61685337941],
						[527740.90798052587, 650985.86975193187],
						[527712.71779388934, 650985.82221178291],
						[527712.56229708064, 651078.07515181974],
						[527683.44631869078, 651078.02610115055],
						[527683.34294927702, 651139.41746917868],
						[527569.55442598811, 651139.22626815492],
						[527569.50323194521, 651169.75603671093],
						[527454.89185668272, 651169.56424912706],
						[527454.94283790526, 651139.03448021982],
						[527426.75291388121, 651138.98743038403],
						[527426.80439632642, 651108.12582066411],
						[527397.68847115396, 651108.07727604522],
						[527397.63704336446, 651138.93888585863],
						[527369.44711917278, 651138.89193427248],
						[527369.39629670908, 651169.42170345166],
						[527312.09060808085, 651169.32640726073],
						[527311.98825718008, 651230.93903525767],
						[527341.00108241639, 651230.98725701566],
						[527340.84766884253, 651323.24031046405],
						[527369.14015873289, 651323.28738427663],
						[527368.78274373827, 651537.99159243063],
						[527340.49062332255, 651537.94451923552],
						[527340.43893354887, 651569.02742427331],
						[527283.13463774882, 651568.93222901155],
						[527283.08360699611, 651599.68329287693],
						[527254.07143238245, 651599.63517332263],
						[527253.97002949438, 651660.80546889093],
						[527225.67812042148, 651660.75859327137],
						[527225.62628094153, 651692.06274803565],
						[527140.03055853606, 651691.92122471996],
						[527140.23342984961, 651569.02755510458],
						[527168.52604514721, 651568.74243769224],
						[527168.62749510456, 651507.35093832575],
						[527140.33532196505, 651507.30420956924],
						[527140.48797747993, 651414.82984120236],
						[527083.28602543124, 651414.73551234789],
						[527083.33631742711, 651384.20570589637],
						[527054.22088117013, 651384.15776952868],
						[527054.5243108354, 651199.7622587767],
						[527026.33449093392, 651199.71589549549],
						[527026.23321068613, 651261.32853448228],
						[526883.32987696014, 651261.0942475386],
						[526883.28031850688, 651291.40280604234],
						[526825.97505504533, 651291.30920420983],
						[526826.22520679759, 651137.99661371729],
						[526855.23819604679, 651138.0439782762],
						[526855.53938913508, 650953.64868358441],
						[526798.23294843198, 650953.55517844926],
						[526798.28325047845, 650922.69359434897],
						[526769.26988121227, 650922.64633029979],
						[526769.31976859865, 650892.00598067325],
						[526741.02653653943, 650891.95993906318],
						[526741.27552979393, 650738.8688735388],
						[526768.74666216504, 650738.47111592465],
						[526769.71994797746, 650646.21965815441],
						[526484.00547168625, 650645.75695133023],
						[526484.15353625885, 650553.83603640029],
						[526455.85972226504, 650553.79048552271],
						[526456.00780657865, 650461.75899642776],
						[526484.30249165022, 650461.36208858027],
						[526484.35166829161, 650430.83242109767],
						[526513.36590544088, 650430.87918236526],
						[526513.4156710665, 650400.01767533331],
						[526570.00382821599, 650400.10902387521],
						[526570.05352130183, 650369.35813630791],
						[526599.06786692643, 650369.4050488146],
						[526599.11743531819, 650338.76478057879],
						[526627.41161934228, 650338.81057798525],
						[526627.51175724389, 650276.976982055],
						[526656.5262658901, 650277.02399595245],
						[526656.6752913706, 650185.10324637871],
						[526684.96973982011, 650185.14914283075],
						[526685.0693750825, 650123.75805136689],
						[526656.77482098434, 650123.7121547421],
						[526656.82449611649, 650093.07192301378],
						[526581.40650736552, 650092.94982527324],
						[526570.50022245373, 650092.93219720339],
						[526570.54991546459, 650062.18135520746],
						[526456.6510470442, 650061.99769023224],
						[526456.7007050137, 650031.1362379347],
						[526427.68576246023, 650031.089576656],
						[526427.73483259277, 650000.55997236003],
						[526399.44006649498, 650000.51451856783],
						[526399.48961688229, 649969.65307522949],
						[526313.98781727755, 649969.51601775864],
						[526314.03703015042, 649938.7651932193],
						[526228.43217948452, 649938.62841597502],
						[526228.48140869953, 649907.76698128134],
						[526199.46624844009, 649907.72072273609],
						[526199.51454192237, 649877.41236472805],
						[526142.20470174134, 649877.09991729376],
						[526142.25376891601, 649846.2384914658],
						[526028.4562956508, 649846.05795625784],
						[526028.50462391926, 649815.52837789292],
						[525999.38640967803, 649815.48230954178],
						[525999.43520859675, 649784.62089240935],
						[526028.55347748951, 649784.66696085117],
						[526028.6018057476, 649754.13739151065],
						[526085.91242701851, 649754.22821410699],
						[526085.86399235472, 649784.75778328045],
						[526142.35137563525, 649784.84749673051],
						[526142.30230847513, 649815.70891343802],
						[526199.61271514173, 649815.80013233819],
						[526199.5640691705, 649846.32971019601],
						[526228.57933775976, 649846.37596891681],
						[526228.62803761032, 649815.84639114409],
						[526256.92312149273, 649815.89155099762],
						[526256.97240378638, 649785.03013462992],
						[526313.45978613291, 649785.12043591472],
						[526314.33142211498, 649754.81341346016],
						[526371.64239585213, 649754.68400322879],
						[526371.5934306616, 649785.21357155533],
						[526628.30748529895, 649785.62730977242],
						[526628.25750603783, 649816.48872501566],
						[526657.27282728662, 649816.53574023023],
						[526656.92438435263, 650031.45962959016],
						[526685.21909719938, 650031.50552646979],
						[526685.16901031148, 650062.36697807617],
						[526742.37566757668, 650062.45992179203],
						[526742.42514220637, 650032.04092841235],
						[526769.89745553769, 650031.64317423408],
						[526770.82052887173, 649970.2534689029],
						[526792.0159199459, 649970.28799208673],
						[526799.83557877515, 649970.3007356911],
						[526799.93600209348, 649908.68847965577],
						[526828.23092620925, 649908.7346226396],
						[526828.28073966282, 649878.20503764111],
						[526885.59092849377, 649878.2986475178],
						[526885.64139095554, 649847.43722394155],
						[526940.58519366174, 649847.52715614252],
						[526943.00171328778, 649817.0014581217],
						[527056.79938762402, 649817.18832284329],
						[527056.85017123085, 649786.32690891146],
						[527085.14530590794, 649786.37349400553],
						[527086.06956694147, 649724.98387904698],
						[527171.57263812074, 649725.1249514207],
						[527171.6744527563, 649663.51277056744],
						[527228.9853898962, 649663.60757734021],
						[527229.03594663611, 649633.07802967937],
						[527286.34698985587, 649633.17303639266],
						[527286.39820368309, 649602.31165055046],
						[527343.70935413742, 649602.40685720148],
						[527343.76012368384, 649571.87731890194],
						[527372.05562739959, 649571.92439772224],
						[527372.15819222818, 649510.31226360169],
						[527429.46966334968, 649510.40776916815],
						[527429.5204072987, 649479.98885887011],
						[527599.80921503773, 649480.05258280004],
						[527600.68397907645, 649449.30321662116],
						[527657.99566284218, 649449.39951871242],
						[527658.04720147001, 649418.75938974577],
						[527629.75143418147, 649418.711818774],
						[527630.06127877615, 649234.31806870527],
						[527601.04493011604, 649234.26933685504],
						[527601.19959677884, 649142.12782976567],
						[527543.88684202079, 649142.03172563529],
						[527543.98967722023, 649080.64094784099],
						[527515.69332808151, 649080.59357314743],
						[527515.74423010391, 649050.17472589435],
						[527487.55146417604, 649049.68511588324],
						[527487.70549299836, 648957.54368920182],
						[527430.39209487312, 648957.44798065838],
						[527430.54635603377, 648864.97475247318],
						[527401.42645844514, 648864.92620122922],
						[527401.5280226079, 648803.97795941262],
						[527373.33409491635, 648803.93100116728],
						[527373.53922379017, 648680.70720508054],
						[527401.7333627562, 648680.7541636799],
						[527401.98939263308, 648527.11166914913],
						[527431.10988845921, 648527.16022139019],
						[527431.16155477974, 648496.18838600558],
						[527459.35601012246, 648496.23544340394],
						[527459.45815596008, 648435.06608216534],
						[527431.26359574089, 648435.01902459131],
						[527431.31433942181, 648404.60027104733],
						[527402.19362655317, 648404.55171844945],
						[527402.34753922059, 648312.1893481568],
						[527429.82200568309, 648312.23515461315],
						[527431.62230729824, 648219.98618529295],
						[527459.81723621453, 648220.03324347595],
						[527459.86858613777, 648189.28268068144],
						[527431.67360449675, 648189.23562240775],
						[527431.77527626371, 648128.28757765389],
						[527459.97110125097, 648127.89218212245],
						[527460.02189701959, 648097.47347328602],
						[527488.32067756786, 648097.07829826453],
						[527489.24651710945, 648035.68920302286],
						[527603.05651978299, 648035.87984830933],
						[527603.10813694261, 648005.12931301235],
						[527660.42485437519, 648005.22562356119],
						[527660.47639264807, 647974.58570636646],
						[527716.96999465476, 647974.68082930974],
						[527717.94852458558, 647882.54126594577],
						[527775.26566929673, 647882.63797676959],
						[527775.36898612604, 647821.46879676031],
						[527775.47305024031, 647759.85718137957],
						[527794.30449684139, 647759.88899914967],
						[527803.66876808752, 647759.90482913365],
						[527803.72094646422, 647729.04372167133],
						[527832.01962141553, 647729.09159202012],
						[527832.17556698143, 647636.950750035],
						[527861.19473435276, 647636.99988975108],
						[527861.29911876388, 647575.38832905667],
						[527832.27984267089, 647575.33918915654],
						[527832.74767881748, 647298.91698649572],
						[527861.76744269929, 647298.96612722008],
						[527861.87145213503, 647237.57589157019],
						[527890.17172321072, 647237.18140990683],
						[527890.275463067, 647176.0124184431],
						[527918.57508970215, 647176.0604377368],
						[527919.34764940501, 647145.31125224335],
						[527946.8240654727, 647145.35792249825],
						[527947.69902341464, 647114.94075657416],
						[527976.71986465051, 647114.5476483258],
						[527976.82392559655, 647053.37869304954],
						[528002.7568677573, 647053.42283080111],
						[528005.17612890759, 647022.67647103022],
						[527976.87623831665, 647022.62830270664],
						[527977.03317644296, 646930.37715859176],
						[528002.14303840278, 646930.41989483591],
						[528005.5946770201, 646776.89473597077],
						[527977.29436348006, 646776.84656692774],
						[527977.60805111961, 646592.45514656091],
						[528005.90868197195, 646592.50331614213],
						[528006.16994442698, 646439.08358316682],
						[527977.86942591763, 646438.81418793218],
						[527977.97423922573, 646377.20297813998],
						[528032.20924884907, 646377.29533255112],
						[528034.52537002647, 646346.77012523147],
						[528091.84786766593, 646346.86793950282],
						[528091.90058197477, 646316.00703987223],
						[528121.02499346458, 646316.05681388115],
						[528121.07738414523, 646285.41714389226],
						[528263.92105234007, 646285.66201246809],
						[528263.97351904237, 646255.13295986759],
						[528435.1186611735, 646255.42797777045],
						[528435.17221055576, 646224.45648017945],
						[528463.47347467055, 646224.50543716492],
						[528463.52650303033, 646193.86578160455],
						[528492.54821693979, 646193.91603543516],
						[528492.60168262559, 646163.05515949812],
						[528520.90305240522, 646163.10421530833],
						[528520.95561207295, 646132.79640613485],
						[528549.97743374854, 646132.84676130523],
						[528550.13796141127, 646040.3747866624],
						[528560.32653054257, 646040.39247678872],
						[528635.76310771203, 646040.523651561],
						[528635.87057547248, 645978.80194986984],
						[528693.19435566373, 645978.90186012536],
						[528693.1399352767, 646010.09454563865],
						[528806.96395693882, 646010.29352305073],
						[528806.91048313968, 646040.82253847807],
						[528832.84502201795, 646040.86798521457],
						[528835.87874549709, 646071.51303039293],
						[528864.18027280888, 646071.56267693546],
						[528864.23404715327, 646040.92304489296],
						[528893.25603095407, 646040.97400583327],
						[528893.20220253873, 646071.61363777658],
						[529036.15064235823, 646071.86539441883],
						[529036.09635233099, 646102.61564273655],
						[529092.59638536547, 646102.71549154748],
						[529092.48778968048, 646164.10538875521],
						[529235.43542556709, 646164.35887755197],
						[529236.10096306517, 646195.22103166813],
						[529350.0266173355, 646195.42395052896],
						[529350.13577977836, 646134.25527094188],
						[529379.15759887954, 646134.30708932469],
						[529379.26805480744, 646072.47475323337],
						[529406.74626334896, 646072.5238627072],
						[529407.6243671485, 646041.88570461515],
						[529435.82303061173, 646041.9361508406],
						[529435.87767185166, 646011.40713747812],
						[529493.20133838872, 646011.50983615557],
						[529493.14659074135, 646042.03884932818],
						[529522.16857257206, 646042.09092008055],
						[529522.2233740926, 646011.5619070041],
						[529578.82663495233, 646011.66361096944],
						[529578.77172836033, 646042.19262385601],
						[529636.09528759506, 646042.29582059046],
						[529635.98466360033, 646103.68569639325],
						[529665.0065366457, 646103.73801920342],
						[529664.95047215722, 646134.82010714698],
						[529693.25189052336, 646134.87118039164],
						[529693.19717049808, 646165.17898574681],
						[529750.52030106203, 646165.28258130886],
						[529750.57512672641, 646134.97477614612],
						[529778.77363057819, 646135.02581039048],
						[529778.93305605534, 646046.97834288818],
						[529807.24264452665, 646042.60511740192],
						[529808.23296218889, 645950.46652482427],
						[529779.10790326935, 645950.4137629231],
						[529779.21906038944, 645889.02393254451],
						[529807.52090173459, 645889.0752024299],
						[529808.51062552491, 645797.26851329347],
						[529836.71051108034, 645796.87719790498],
						[529836.87766792299, 645704.73722016322],
						[529865.17982639617, 645704.78858926962],
						[529865.23586599366, 645673.92778943246],
						[529836.93365441519, 645673.87642022967],
						[529836.98944022798, 645643.12623694527],
						[529865.29170472163, 645643.17760624154],
						[529865.4031812984, 645581.78786534886],
						[529837.1008111611, 645581.73649586004],
						[529837.15679761814, 645550.87571379659],
						[529865.45922086213, 645550.92708338168],
						[529865.84948900447, 645336.00785508542],
						[529923.17550964258, 645336.11205243482],
						[529923.23165670666, 645305.25130633509],
						[530037.06055651116, 645305.4587971475],
						[530037.93966816261, 645274.93139552616],
						[530066.13964663341, 645274.98292248556],
						[530066.19606172887, 645244.12218577834],
						[530095.32237142604, 645244.17545609479],
						[530095.37863876042, 645213.42533589783],
						[530066.25227460486, 645213.37206548778],
						[530066.36449813587, 645151.98245011573],
						[530095.4909710068, 645152.03572072391],
						[530095.94070446282, 644906.25621341215],
						[530066.81379634142, 644906.20294200513],
						[530066.87021133525, 644875.34225871798],
						[530010.36596173025, 644875.23906285304],
						[530010.53327401029, 644783.54193290044],
						[529981.50947453547, 644783.26777693059],
						[529981.62178186746, 644721.657061434],
						[529953.31793157174, 644721.60549195076],
						[529953.42972997134, 644660.21601734066],
						[529924.40530961391, 644660.1631855655],
						[529924.51699964772, 644598.77372841188],
						[530124.70390662272, 644599.13916076103],
						[530124.81674898125, 644537.52849944087],
						[530153.94430999272, 644537.58187356708],
						[530154.00048153556, 644506.94246702245],
						[530124.87286626326, 644506.88909279997],
						[530125.21098791482, 644322.27846484585],
						[530154.33893011708, 644322.3318396688],
						[530154.39489881694, 644291.80307542987],
						[530297.25588264898, 644292.0656046432],
						[530297.19964878762, 644322.59436839796],
						[530382.83373842284, 644322.75232913019],
						[530382.66292538587, 644415.22353779338],
						[530353.53514768858, 644415.16975863092],
						[530353.19486954331, 644599.55923850148],
						[530410.52345707209, 644599.66513449757],
						[530410.46701183915, 644630.19394176162],
						[530467.79549258901, 644630.30003737542],
						[530467.73832625174, 644661.16068374144],
						[530439.5372953203, 644661.10846820497],
						[530439.48038659838, 644691.85850746732],
						[530467.6813648009, 644691.9107229074],
						[530467.62460824207, 644722.55015482521],
						[530495.1050722209, 644722.60108271346],
						[530495.87144252798, 644753.35265725735],
						[530553.19949400646, 644753.45905055152],
						[530553.14216696483, 644784.3197143994],
						[530582.16636823094, 644784.37365567498],
						[530582.10960372468, 644814.90248871734],
						[530610.41329346818, 644814.95514025725],
						[530610.35585884517, 644845.81581278099],
						[530639.37995159079, 644845.86985501961],
						[530639.3230806638, 644876.39869665005],
						[530753.15494851442, 644876.61114349577],
						[530753.21203072823, 644846.08230225916],
						[530782.3390453154, 644846.13678921398],
						[530782.39680263808, 644815.2761172906],
						[530838.90125823626, 644815.38196542102],
						[530838.84339489625, 644846.24263714324],
						[530867.86748689215, 644846.29708257969],
						[530867.81019185786, 644876.82592341991],
						[530896.11377503886, 644876.8790666014],
						[530896.05580412119, 644907.73974700505],
						[530953.38331748114, 644907.84753514174],
						[530953.44139596622, 644876.98685493623],
						[530981.74497886747, 644877.04014548229],
						[530981.80248537974, 644846.51130504149],
						[531038.30683367269, 644846.61783821671],
						[531039.01436007652, 644908.0089121873],
						[531068.03834307217, 644908.06371085718],
						[531067.9802583881, 644938.81378334144],
						[531239.13909855636, 644939.13798103016],
						[531239.19750324055, 644908.38790915208],
						[531268.22148556844, 644908.44306108099],
						[531268.28015479003, 644877.58238199435],
						[531324.88731845189, 644877.6900953654],
						[531325.06238071958, 644785.77175568056],
						[531354.08657942084, 644785.82705912902],
						[531354.26074951678, 644694.46181759145],
						[531325.95853778068, 644693.52299281559],
						[531325.41355834971, 644601.38213707902],
						[531354.43808243563, 644601.43744114204],
						[531354.49691224273, 644570.57680677157],
						[531382.80102243111, 644570.63078746933],
						[531382.85969428997, 644539.8807692352],
						[531411.88432690164, 644539.9361746721],
						[531411.94284177013, 644509.29677251505],
						[531439.42366204993, 644509.34927815769],
						[531440.30541356117, 644478.82206594013],
						[531525.8357651931, 644478.98578079697],
						[531525.89491611661, 644448.12516477518],
						[531552.65536497766, 644448.17647867696],
						[531555.09690233273, 644355.82022453425],
						[531640.73081896559, 644355.98473431834],
						[531640.84891265118, 644294.59537743102],
						[531698.17856312077, 644294.70576155209],
						[531698.23718402022, 644264.28761847143],
						[531726.54182128387, 644264.34219069744],
						[531726.65852767334, 644203.83775188331],
						[531754.86333229067, 644202.34361485962],
						[531754.92184411618, 644172.03609649488],
						[531784.05005237879, 644172.09235738881],
						[531784.10968657909, 644141.23178663536],
						[531812.31160888274, 644141.28630756272],
						[531812.37044026214, 644110.86818672542],
						[531824.92752374616, 644110.89247806615],
						[531869.70073111285, 644110.9791686798],
						[531869.87968644325, 644018.61871977302],
						[531897.36132653686, 644018.67199052847],
						[531899.06801567762, 643987.81463604304],
						[531955.57531396707, 643987.92432043294],
						[531955.63548416051, 643956.95316562627],
						[532012.96631148248, 643957.06464692939],
						[532013.02551322139, 643926.64655301464],
						[532042.05122797657, 643926.70307048142],
						[532042.11112980742, 643895.9531473075],
						[532069.59297485149, 643896.00670582976],
						[532070.47635565884, 643865.25839263236],
						[532098.67875113816, 643865.31340456114],
						[532098.85834176838, 643773.28489767364],
						[532127.16382397246, 643773.34015930363],
						[532128.28778156184, 643619.48169637658],
						[532099.15859467816, 643619.42482587183],
						[532099.33796924213, 643527.50703543809],
						[532013.80310038407, 643527.11911625532],
						[532013.86273256317, 643496.47986124165],
						[531928.22434104583, 643496.31340881414],
						[531928.34350104153, 643434.92430027691],
						[531956.64956551429, 643434.97926847823],
						[531956.76926090592, 643373.36895576038],
						[531985.79595200194, 643373.42537395214],
						[531985.91532590368, 643312.03630094812],
						[532014.22160184651, 643312.0913682261],
						[532014.34108135407, 643250.70231294481],
						[531986.03469977132, 643250.64724546857],
						[531986.45304575318, 643035.50916220667],
						[531957.42575835285, 643035.45274285635],
						[531957.48528359761, 643004.81355762889],
						[531929.17847887916, 643004.75858799159],
						[531929.23773669032, 642974.23001777893],
						[531871.90348370234, 642974.11882831284],
						[531871.96413531899, 642942.81598704285],
						[531843.76015812973, 642942.7613638381],
						[531843.87857033825, 642881.59363392415],
						[531786.54399446677, 642881.48274197965],
						[531786.48436061351, 642912.34313178423],
						[531729.14989192097, 642912.23243989074],
						[531729.20941820904, 642881.37204987672],
						[531500.69458621403, 642880.93285679771],
						[531500.75262468774, 642850.62552385451],
						[531471.6220762321, 642850.569764663],
						[531471.74037366931, 642788.73839403864],
						[531443.53613229934, 642788.68445705716],
						[531443.59469941584, 642758.04530491563],
						[531357.9524633598, 642757.88182151341],
						[531358.01023837517, 642727.57450532413],
						[531329.70337789971, 642727.29934602021],
						[531329.04244638723, 642695.99516610638],
						[531272.42777399393, 642695.88743844558],
						[531272.4853912011, 642665.58013064042],
						[531215.1500624168, 642665.4712302871],
						[531215.26697460387, 642603.86113187321],
						[531186.23892549134, 642603.80607339868],
						[531186.29743206268, 642572.94572540128],
						[531157.98988416384, 642572.89208285697],
						[531158.10574351379, 642511.72445252666],
						[531129.07753181353, 642511.66949492448],
						[531129.25189147401, 642419.53094490455],
						[531101.04701707303, 642419.47759514593],
						[531101.16350002657, 642357.86756600847],
						[531072.85558201105, 642357.81406996469],
						[531072.91387492965, 642326.95375666209],
						[530958.24085642421, 642326.73754702229],
						[530958.29789339285, 642296.43028981611],
						[530872.65366918687, 642296.04811220721],
						[530872.59637483687, 642326.57659055176],
						[530787.05483049492, 642326.41627262579],
						[530786.99707384279, 642357.27658693667],
						[530700.63218603563, 642357.11517721019],
						[530700.57479783567, 642387.86488575721],
						[530529.28647033323, 642387.54610169714],
						[530529.2291970303, 642418.40642570355],
						[530471.89300672687, 642418.30011597276],
						[530471.83686545317, 642448.6073920629],
						[530328.95987009897, 642448.34334657935],
						[530328.90256451198, 642479.42490106006],
						[530271.56658688956, 642479.31928956765],
						[530271.45361720398, 642540.7081384589],
						[530185.81024963246, 642540.55075763329],
						[530185.7542290407, 642571.07927305764],
						[530214.0617800632, 642571.13124252972],
						[530213.94861797569, 642632.74133913917],
						[530242.9766160252, 642632.79468186479],
						[530242.86415861943, 642693.96235332522],
						[530213.8362685109, 642693.90901080077],
						[530213.77877319686, 642725.2118223554],
						[530185.4714873276, 642725.15985336201],
						[530185.41546669195, 642755.6883948989],
						[529899.563872698, 642755.16633323836],
						[529899.6193628232, 642724.6377907386],
						[529870.59152684663, 642724.58505392168],
						[529870.64756566135, 642693.72468372912],
						[529814.13662314962, 642693.1797194354],
						[529814.19155355718, 642662.87240664219],
						[529785.06067260785, 642662.81963419018],
						[529785.11655073822, 642631.9592725148],
						[529756.91204056272, 642631.90822739946],
						[529756.96766568162, 642601.1584806341],
						[529727.83667544147, 642601.10580951907],
						[529727.94761685503, 642539.71693948633],
						[529699.74294852314, 642539.66599239106],
						[529699.79826673411, 642509.0268690926],
						[529671.49060884421, 642508.97578459186],
						[529671.93432857457, 642262.9780704577],
						[529700.2424097918, 642263.02915572608],
						[529700.29752823256, 642232.50068204093],
						[529871.48453154997, 642232.81064717146],
						[529871.37305671477, 642294.19942900422],
						[529928.70967957214, 642294.30364562571],
						[529928.82136838045, 642232.91486418387],
						[529900.51323533827, 642232.86338556604],
						[529900.62481847289, 642171.47462134843],
						[529871.5960063535, 642171.42188276129],
						[529871.81875501038, 642048.7550164701],
						[529815.30539626617, 642048.32065978146],
						[529815.36132888705, 642017.46038590954],
						[529700.68615293573, 642017.25294267398],
						[529700.7412713113, 641986.72450364672],
						[529643.40357638721, 641986.62108160695],
						[529643.51459689392, 641925.01116483042],
						[529615.20593400055, 641924.96017718571],
						[529615.31645019783, 641863.57149816281],
						[529643.6252187331, 641863.62248599739],
						[529643.90167353069, 641710.20617002074],
						[529672.93129953777, 641710.25850681192],
						[529673.04242862167, 641648.64866875508],
						[529701.35156700364, 641648.69975592685],
						[529701.40728439763, 641617.83953850879],
						[529728.89293568849, 641617.88918621535],
						[529729.66830411472, 641587.58332589408],
						[529758.80148938997, 641587.41478010511],
						[529758.85731433006, 641556.55457160366],
						[529872.71215863456, 641556.76092487993],
						[529872.76799629722, 641526.01133119781],
						[529930.10729667346, 641526.11555268266],
						[529930.16304026416, 641495.47657357052],
						[530216.03652442724, 641495.99916715582],
						[530215.98024841363, 641526.63814529357],
						[530387.99814188317, 641526.95499812218],
						[530388.05473827582, 641496.31602057372],
						[530444.57059596351, 641496.42051398323],
						[530445.45064062392, 641465.89367506141],
						[530473.65715003957, 641465.9459007408],
						[530473.88540216244, 641342.7263925015],
						[530445.67868147581, 641342.67416643398],
						[530445.73579402547, 641311.81399522745],
						[530416.60252046993, 641311.76010436972],
						[530416.76980844245, 641221.28120441257],
						[530502.42230051756, 641220.22307905601],
						[530502.36610740284, 641250.53018758632],
						[530588.73680494644, 641250.69055640884],
						[530588.67942438077, 641281.55071840994],
						[530616.98919448256, 641281.60338125704],
						[530616.87494467979, 641342.99188838061],
						[530645.90521868796, 641343.04594212468],
						[530645.79044842056, 641404.65568631946],
						[530673.27645589225, 641404.70691188809],
						[530673.98513035895, 641466.31820890016],
						[530702.29458249989, 641466.37101854524],
						[530702.2376074004, 641496.89938068809],
						[530731.2676098115, 641496.95358507102],
						[530731.21037420118, 641527.59256143274],
						[530759.41677782801, 641527.64527707128],
						[530759.35928285727, 641558.39486770285],
						[530815.97787015571, 641558.50082954229],
						[530816.64066099806, 641589.36238425027],
						[531102.61545622768, 641589.90057715529],
						[531102.67380205204, 641559.04037331603],
						[531188.21933681297, 641559.20233250305],
						[531188.27763339947, 641528.45274337824],
						[531159.96828808845, 641528.39909742936],
						[531160.02632224164, 641497.76012256881],
						[531130.99632125453, 641497.70516157616],
						[531131.05409201537, 641467.17680093157],
						[531102.84758471465, 641467.12344808853],
						[531102.90655787766, 641435.93143175542],
						[531017.25743843871, 641435.76972211385],
						[531017.31478935468, 641405.35197970469],
						[530959.97506804916, 641405.24396876106],
						[530960.0331455894, 641374.3837906064],
						[530931.72353514424, 641374.33053743478],
						[530931.9548009088, 641251.33230777632],
						[530960.26462301263, 641251.38556134724],
						[530960.61163074162, 641066.99895763409],
						[531017.95253099722, 641067.10697080125],
						[531018.06827536807, 641005.71854451043],
						[531046.37852013693, 641005.77194627014],
						[531046.61022005824, 640882.99514598132],
						[531075.64130580355, 640883.04995806015],
						[531075.9895982981, 640698.6636686736],
						[531101.10897521582, 640698.71113660047],
						[531104.41643524449, 640637.32884819573],
						[531132.62436530169, 640637.38220373262],
						[531132.68255446816, 640606.63274456677],
						[531190.02505933132, 640606.74135749624],
						[531190.08356536331, 640575.88129332848],
						[531262.35378731042, 640576.01846565271],
						[531276.45780490816, 640576.04527277104],
						[531276.51584211364, 640545.51704184478],
						[531304.82687881379, 640545.57088835468],
						[531305.06092145271, 640422.57313201739],
						[531333.37216972711, 640422.6270276506],
						[531333.43052261963, 640391.98820893513],
						[531305.11922162061, 640391.93431319995],
						[531305.23645334295, 640330.32486019912],
						[531362.57992127864, 640330.43407455925],
						[531362.46247481264, 640392.04352715495],
						[531448.11702824628, 640392.20703406376],
						[531448.05846177321, 640422.84585237701],
						[531533.60990484385, 640423.00960760494],
						[531533.66863064549, 640392.37078960042],
						[531591.01188231481, 640392.48080016521],
						[531591.07092729316, 640361.73137722944],
						[531619.38228026126, 640361.78576503671],
						[531619.4415907287, 640330.92573711881],
						[531647.65004614228, 640330.97997571772],
						[531648.70983362163, 640208.20514843334],
						[531619.67755701102, 640208.14932508674],
						[531619.79554010637, 640146.76114490838],
						[531591.48381711368, 640146.70675638434],
						[531591.60211931344, 640085.09737464553],
						[531563.29029020679, 640085.04303463874],
						[531563.52583366679, 639962.26675966103],
						[531534.49312306603, 639962.21108663583],
						[531534.55163673533, 639931.68294235459],
						[531477.20677895576, 639931.57312858629],
						[531477.26582107286, 639900.71316076745],
						[531449.05662792688, 639900.65921431419],
						[531449.11540569388, 639869.9098599155],
						[531391.77033260488, 639869.80034393806],
						[531391.82794795861, 639839.6040394837],
						[531248.8265986999, 639838.6681528904],
						[531248.76798530004, 639869.5281128491],
						[531221.27941286971, 639869.47592576197],
						[531220.39743482426, 639900.22371801594],
						[531163.05246739299, 639900.11499923468],
						[531162.99401464569, 639930.97496818076],
						[531133.96124882263, 639930.92000195384],
						[531133.90347846842, 639961.44814764848],
						[531105.69438945479, 639961.39478991937],
						[531105.63646230986, 639992.03354921553],
						[531048.29181488499, 639991.92523043149],
						[531048.23378578282, 640022.67460348189],
						[530990.88924515503, 640022.56648477167],
						[530990.83111486922, 640053.42647161894],
						[530962.51923126145, 640053.37316544342],
						[530962.57730843918, 640022.51317849988],
						[530934.265371633, 640022.45992095489],
						[530934.38079584367, 639961.07178760564],
						[530905.34808313393, 639961.01722480031],
						[530905.63689213467, 639807.27044327278],
						[530934.66987615381, 639807.32500658499],
						[530934.72790016374, 639776.46505418047],
						[530963.04026028968, 639776.51831252698],
						[530963.09771290887, 639745.99019193929],
						[530991.41012548131, 639746.04349910608],
						[530991.58430771483, 639653.57429050014],
						[530963.27173601952, 639653.520983033],
						[530963.5602478527, 639500.21685409267],
						[530935.24741225399, 639500.16359485104],
						[530935.42127604201, 639407.69448915124],
						[530878.07459190348, 639407.58676365449],
						[530878.13167790486, 639377.1693029817],
						[530763.43809646054, 639376.9544512406],
						[530763.38122250058, 639407.37191231269],
						[530735.17118347902, 639407.31918987911],
						[530735.11312191398, 639438.40030909283],
						[530677.766544807, 639438.29328176938],
						[530677.70921028394, 639469.04257861804],
						[530620.36273997708, 639468.93575137679],
						[530620.30571848038, 639499.57444372203],
						[530591.99288177676, 639499.52177517035],
						[530591.93611865758, 639530.04986286757],
						[530562.9026453424, 639529.99590435647],
						[530562.84470328153, 639561.18765062012],
						[530537.72358952125, 639561.14100454596],
						[530534.41824858449, 639622.41249627317],
						[530505.38493825984, 639622.35863926611],
						[530505.10069332551, 639775.66286208562],
						[530448.57892408245, 639775.55816073657],
						[530448.40779232979, 639868.02742689243],
						[530391.06271268439, 639867.92139888101],
						[530390.94890778547, 639929.53072864143],
						[530305.29194551136, 639929.37272572238],
						[530305.23571278306, 639959.90087428642],
						[530218.85823840089, 639959.74199391075],
						[530218.801962781, 639990.38075628574],
						[530133.14531731687, 639990.22364961985],
						[530133.08899862121, 640020.97302584536],
						[530075.74445207196, 640020.8680968741],
						[530075.68803834275, 640051.72808690509],
						[529990.13466459746, 640051.57191300532],
						[529990.02276294143, 640112.96007872967],
						[529936.59071042377, 640112.86276657437],
						[529932.62259253627, 640143.60504259937],
						[529875.27847341949, 640143.5008123538],
						[529875.22243525845, 640174.36082040775],
						[529846.91075976181, 640174.30943402892],
						[529846.52087079885, 640389.22351831547],
						[529818.31251525169, 640389.17236791761],
						[529818.25698399602, 640419.81119188154],
						[529789.1221307884, 640419.75841223798],
						[529789.06645350542, 640450.50785008934],
						[529617.86090276926, 640450.19874272996],
						[529617.80534634215, 640481.05879500427],
						[529532.15125552763, 640480.90481732949],
						[529532.0964554185, 640511.43304565281],
						[529474.8565678047, 640511.33039588353],
						[529474.80127939978, 640542.1904573096],
						[529417.45854955493, 640542.08782279876],
						[529417.51373039582, 640511.22776117735],
						[529159.83128069399, 640510.76901702269],
						[529159.7765832094, 640541.6290795051],
						[529131.46553972666, 640541.57892430364],
						[529131.41148291295, 640572.10716253496],
						[529102.37984846905, 640572.05578133953],
						[529102.32525853184, 640602.91585268476],
						[529016.77475101862, 640602.76474035019],
						[529016.82918048208, 640571.90466872172],
						[528988.51818909915, 640571.85475950805],
						[528988.68014874007, 640479.93822763581],
						[529046.02309521125, 640480.03936764388],
						[529046.13186769944, 640418.42987311934],
						[529073.6195229491, 640418.47842600336],
						[529074.60614759848, 640326.23158670787],
						[529046.29473344958, 640326.18157806643],
						[529046.34863145172, 640295.65337388427],
						[528989.00504230335, 640295.55223274883],
						[528989.11321016599, 640234.16400860786],
						[528846.11441782024, 640233.69144222792],
						[528846.22166420403, 640172.52445317816],
						[528788.87764589244, 640172.42400957877],
						[528789.41552107292, 639865.04078977508],
						[528761.92694115255, 639864.99271173892],
						[528761.15251265536, 639895.74081547023],
						[528732.11968465743, 639895.69008765556],
						[528732.22727752302, 639834.08075540839],
						[528703.91501645662, 639834.0313359499],
						[528703.96808445931, 639803.61380836589],
						[528674.93567223032, 639803.23135391227],
						[528674.98945766175, 639772.37139382889],
						[528646.67709040956, 639772.32207286928],
						[528646.73024496227, 639741.79394449224],
						[528618.41782508173, 639741.74467216036],
						[528617.75005358714, 639711.32590351091],
						[528561.12510888372, 639711.22750731616],
						[528561.17868052504, 639680.3675597749],
						[528532.14547247265, 639680.31718484522],
						[528532.19918146462, 639649.3466324436],
						[528503.88698575436, 639649.07633898745],
						[528503.9394916778, 639618.76944544958],
						[528474.9061749276, 639618.71917152824],
						[528475.0122283845, 639557.44174244185],
						[528446.69949126604, 639557.39276561211],
						[528446.75342146726, 639526.2010121569],
						[528389.40715039964, 639526.10196091025],
						[528389.3008434173, 639587.71120907879],
						[528361.09111360717, 639587.66255722009],
						[528361.0379175886, 639618.52249242028],
						[528332.0046004015, 639618.47247067024],
						[528331.95241118979, 639648.7793647605],
						[528217.9814070625, 639648.58349844697],
						[528218.03338633256, 639618.2766039999],
						[528189.00006870774, 639618.22683460498],
						[528189.05294203945, 639587.36689884402],
						[528132.53052593477, 639587.27015413833],
						[528132.47775862319, 639618.13009007776],
						[528075.13180797349, 639618.03213424014],
						[528074.97420616425, 639710.39075035497],
						[528103.18372554879, 639710.43891164276],
						[528103.02690998861, 639802.24452041625],
						[528074.81754801178, 639802.19635939482],
						[528074.76507695566, 639832.94571655802],
						[528017.41987504472, 639832.84796187608],
						[528017.36732279754, 639863.70793275395],
						[527989.05511271604, 639863.65974346153],
						[527988.95030258049, 639925.26908918004],
						[527961.46182328719, 639925.22234855266],
						[527959.8135771408, 639986.38665012107],
						[527931.50157816941, 639986.33855987422],
						[527931.39698271453, 640047.94794048299],
						[527902.36442331295, 640047.89867689763],
						[527902.31264890346, 640078.42685046373],
						[527931.34515443351, 640078.4761139584],
						[527931.29276279383, 640109.33611972933],
						[527877.86069851869, 640109.24549372843],
						[527873.89642755745, 640139.98826606013],
						[527844.86403057631, 640139.93910394213],
						[527844.76013291162, 640201.32730957866],
						[527816.44850382197, 640201.27941731515],
						[527816.39670130238, 640231.91822197591],
						[527788.90836070012, 640232.09298846649],
						[527788.08401558222, 640293.4800031042],
						[527758.94893865811, 640293.43081871455],
						[527758.89742953959, 640323.95902701514],
						[527701.55393905705, 640323.86237328802],
						[527701.39861342101, 640416.11068134475],
						[527729.7098728189, 640416.15837561921],
						[527730.48164340935, 640446.90920840111],
						[527758.68989996321, 640446.95677902445],
						[527758.58632176265, 640508.34507143614],
						[527787.72101809329, 640508.39425518853],
						[527787.61733114661, 640569.78256466868],
						[527815.82537702553, 640569.83023325563],
						[527815.77320039493, 640600.69030877308],
						[527901.42666758923, 640600.83535039332],
						[527901.37451786944, 640631.58482038474],
						[527930.40604726982, 640631.63408222236],
						[527930.35403106478, 640662.27294682944],
						[527958.66486685455, 640662.32103511039],
						[527958.61260994675, 640693.07051357091],
						[528187.15783592465, 640693.46050048713],
						[528187.21052000357, 640662.71102275455],
						[528301.89513850107, 640662.90791558591],
						[528301.68354472122, 640785.90585105936],
						[528244.34166435327, 640785.80730544659],
						[528244.2892528635, 640816.33558093314],
						[528073.08750917274, 640816.04254917742],
						[528073.03484912764, 640846.90265863913],
						[528043.90075226407, 640846.85296961828],
						[528043.79610709578, 640908.24137258378],
						[527958.24718732084, 640908.0957646895],
						[527958.19493035157, 640938.84527780511],
						[527984.13751465443, 640938.88938619255],
						[527987.1734181341, 640969.75476706238],
						[528015.48372479435, 640969.80295311718],
						[528015.43173735484, 641000.33125515236],
						[528043.63904501894, 641000.37931434414],
						[528043.58643957705, 641031.23945000884],
						[528072.7202099103, 641031.28913846612],
						[528072.66811604716, 641061.81744892511],
						[528100.87531828869, 641061.86560625595],
						[528100.66484403948, 641185.08498944214],
						[527986.80742742901, 641184.89090040163],
						[527986.85973871697, 641154.14135264209],
						[527957.82913136482, 641154.09199118114],
						[527957.88157636207, 641123.2318378163],
						[527929.57153372571, 641123.18375088344],
						[527929.62373782403, 641092.43421164399],
						[527872.2829258627, 641092.33696284238],
						[527872.33521017386, 641061.47681793524],
						[527843.30443929997, 641061.42765857046],
						[527843.35573312582, 641031.12056701793],
						[527815.04590601381, 641030.85145754181],
						[527815.09808274591, 640999.99132114905],
						[527786.89077441697, 640999.94365381415],
						[527786.94233776059, 640969.41535105952],
						[527757.8084578563, 640969.36616868374],
						[527757.86052700947, 640938.50604080537],
						[527672.31176462013, 640938.36191980005],
						[527672.36274302972, 640908.05484480062],
						[527586.71161723707, 640907.46855674288],
						[527586.81455679797, 640846.08015089959],
						[527501.26531378133, 640845.93691934936],
						[527501.21391116828, 640876.68642525352],
						[527386.53078293859, 640876.4951139621],
						[527386.47977880237, 640907.13401479635],
						[527300.82790631091, 640906.99165417114],
						[527300.77687813342, 640937.74116934882],
						[527271.74588890758, 640937.6930185922],
						[527271.64412440849, 640999.08145234943],
						[527214.30298707017, 640998.98649693769],
						[527214.20143650926, 641060.37494834955],
						[527185.89128571202, 641060.32814117929],
						[527185.73847853835, 641152.79798561032],
						[527214.04847021168, 641152.84479251446],
						[527213.99760341237, 641183.59434269858],
						[527243.02815870568, 641183.64239155455],
						[527242.77410280285, 641337.05837727757],
						[527271.08377738926, 641337.10528233217],
						[527271.03280337201, 641367.85485837376],
						[527300.06303351093, 641367.90300787846],
						[527300.01182166894, 641398.76319818711],
						[527327.49783898913, 641398.80883367313],
						[527328.27086009516, 641429.22795623867],
						[527357.30098193442, 641429.27620675182],
						[527357.2491106902, 641460.46823569771],
						[527385.5585729056, 641460.51533774426],
						[527385.45674848708, 641521.68269812397],
						[527413.66316224798, 641521.72967716807],
						[527413.61192110903, 641552.47927885479],
						[527442.74476837227, 641552.52785168495],
						[527442.69328824943, 641583.3880677378],
						[527470.89959621336, 641583.43514492107],
						[527470.54052714061, 641798.46128761896],
						[527414.02570711938, 641798.36701130669],
						[527413.04863672133, 641890.50396442483],
						[527442.18088537361, 641890.55253625801],
						[527442.07847851643, 641951.94123805384],
						[527470.28415456135, 641951.98831418052],
						[527470.18164242117, 642013.37703318917],
						[527499.31367347646, 642013.42570620077],
						[527499.1594647856, 642105.67473261768],
						[527527.36487723794, 642105.72190661146],
						[527527.31342160504, 642136.4715907285],
						[527555.62172052253, 642136.51898542489],
						[527555.51888868248, 642197.90775617701],
						[527584.54765406705, 642197.95640769857],
						[527584.49590575765, 642228.81671515212],
						[527612.80404576182, 642228.86420825962],
						[527612.59795402107, 642351.64181879652],
						[527641.62644811976, 642351.69057104038],
						[527641.26531521312, 642566.60686193302],
						[527612.23720036529, 642566.55811032641],
						[527611.82464478747, 642812.33500643505],
						[527583.51750884776, 642812.28751501581],
						[527583.46501847461, 642843.59035320696],
						[527554.43739240873, 642843.54170359718],
						[527554.38662481634, 642873.8490495868],
						[527526.0795947304, 642873.80165700905],
						[527526.02795381891, 642904.66206122236],
						[527468.69345837727, 642904.56621914543],
						[527468.64284856105, 642934.87357399776],
						[527440.43885776156, 642934.82650068379],
						[527440.38663923962, 642966.12935715565],
						[527411.25629533583, 642966.08078849479],
						[527411.20542249747, 642996.60937383841],
						[527383.00153755234, 642996.56239900622],
						[527382.95053291577, 643027.20159960259],
						[527354.64376672904, 643027.15450203698],
						[527354.59263086866, 643057.9043179343],
						[527382.89934414078, 643057.95141540631],
						[527382.84797122749, 643088.81184647698],
						[527354.5413110588, 643088.76474909275],
						[527354.3884552446, 643180.6824035825],
						[527382.69458897074, 643180.95072254154],
						[527382.59239547444, 643242.33979151491],
						[527354.28599950648, 643242.29269456968],
						[527354.23504753853, 643272.93193022907],
						[527325.20817910985, 643272.88368512876],
						[527325.10583204858, 643334.49400270986],
						[527296.79959466285, 643334.44700468832],
						[527296.74893302284, 643364.97564264783],
						[527267.72222702194, 643364.92749899207],
						[527267.62009465566, 643426.53784332867],
						[527239.31401566346, 643426.4909442364],
						[527239.26291089668, 643457.35142864229],
						[527210.23636790703, 643457.30338642269],
						[527210.13518214563, 643518.47131324362],
						[527181.82889578538, 643518.64573526161],
						[527181.72744968545, 643580.03490198334],
						[527153.42163483985, 643579.98815069743],
						[527153.26953280054, 643672.12723953067],
						[527124.24336881144, 643672.07934906299],
						[527123.9394897226, 643856.35764593375],
						[527010.10037921346, 643856.28092795331],
						[527010.05006632709, 643886.92025233107],
						[526981.02428137301, 643886.87261459825],
						[526981.07454019156, 643856.23329013551],
						[526923.74336145655, 643856.13934748142],
						[526923.69320942997, 643886.77867211984],
						[526809.7515627821, 643886.59256099723],
						[526809.70144270617, 643917.34250167001],
						[526695.14243903069, 643917.15617788339],
						[526695.19234494003, 643886.40623686789],
						[526666.88705731346, 643886.3603228291],
						[526666.83720431756, 643917.11026393529],
						[526552.17527089734, 643916.92476900609],
						[526552.12616792123, 643947.3428808985],
						[526494.79530675116, 643947.25043334474],
						[526494.59718081763, 644070.2502614148],
						[526523.62264217099, 644070.29704077321],
						[526523.47352812928, 644162.76818078046],
						[526466.14341781882, 644162.67583309929],
						[526466.09465113457, 644192.98336870235],
						[526437.06940627855, 644192.93669085926],
						[526437.01927078643, 644224.12912258692],
						[526380.51278399781, 644224.038396855],
						[526380.5628123316, 644192.8459649547],
						[526351.43464083271, 644192.7992731476],
						[526351.38466773927, 644223.99170513579],
						[526294.15769703162, 644223.90012180549],
						[526294.20756160037, 644192.70768964174],
						[526265.90280107013, 644192.66246564151],
						[526266.09886514314, 644069.88378711662],
						[526294.40383695427, 644069.92901145399],
						[526294.50162094308, 644008.76092146628],
						[526321.98327751737, 644008.80487695744],
						[526323.57657930686, 643977.94678101852],
						[526351.77878158283, 643977.99193936808],
						[526351.82840020268, 643947.0207658587],
						[526323.62614482245, 643946.97560742428],
						[526323.67482523213, 643916.55749485199],
						[526351.87713276828, 643916.60265337152],
						[526351.9263969498, 643885.85271131934],
						[526323.72403669148, 643885.80755271774],
						[526323.82228257449, 643824.41829292988],
						[526381.15357187693, 643824.51014455652],
						[526381.35120112344, 643701.28923358617],
						[526324.01948233333, 643701.19738126849],
						[526324.06816268456, 643670.77930355258],
						[526352.27089162683, 643670.82446274615],
						[526352.32015575457, 643640.07455592125],
						[526266.7854417779, 643639.93774381804],
						[526266.83472263033, 643609.07722998853],
						[526209.50268243742, 643608.98577682115],
						[526209.60050024732, 643547.59659548686],
						[526181.29462958034, 643547.55151707795],
						[526181.34322157234, 643517.02284956176],
						[526096.52873310796, 643516.66684744658],
						[526095.85682739201, 643486.02642985503],
						[526066.72740417928, 643485.98024223454],
						[526066.77578333695, 643455.45158310537],
						[526009.44320768048, 643455.36082724459],
						[526009.54062766919, 643393.7504664344],
						[525981.33742365765, 643393.70589488302],
						[525981.38616817771, 643362.84541549906],
						[525924.05326974578, 643362.75495726475],
						[525924.10138371645, 643332.22631518415],
						[525895.79514243314, 643332.18172807968],
						[525895.89213596226, 643270.57140183402],
						[525866.86526336905, 643270.52573020011],
						[525866.91309697251, 643240.10771199991],
						[525838.60704466468, 643239.84200136922],
						[525838.7034759121, 643178.45292307693],
						[525809.67644076329, 643178.40735236078],
						[525809.72468898632, 643147.65751423442],
						[525781.41813008953, 643147.61312395765],
						[525781.51434732019, 643086.22407159943],
						[525753.31061603117, 643086.17989102111],
						[525753.35893177183, 643055.31945501629],
						[525724.22874581302, 643055.27387392765],
						[525724.27683391678, 643024.5240531161],
						[525696.07299683767, 643024.47997067973],
						[525696.12085942086, 642993.84076501045],
						[525666.99056459276, 642993.79528528987],
						[525667.0382003166, 642963.26669472887],
						[525638.83425820235, 642963.22271042876],
						[525638.88304840203, 642931.91984842508],
						[525553.24171767314, 642931.78658636415],
						[525553.28879844269, 642901.47922582703],
						[525537.64275719633, 642901.45492799429],
						[525524.26127453509, 642901.43415876781],
						[525524.29542938445, 642879.42261120328],
						[525524.35618725035, 642840.26639647316],
						[525499.96062425163, 642840.22856044024],
						[525496.09761746787, 642808.9196526676],
						[525480.45148818253, 642808.89540924085],
						[525467.89341071586, 642808.87596146495],
						[525467.9257774069, 642787.97053062252],
						[525467.98811325117, 642747.70822507027],
						[525443.59241298342, 642747.67047263752],
						[525411.37259364408, 642748.28433370241],
						[525410.69988825184, 642717.31222119264],
						[525381.56944506068, 642717.04602551716],
						[525381.71212587378, 642624.57549640373],
						[525434.31253138976, 642624.65674233646],
						[525439.0951508889, 642593.91430400289],
						[525381.75957235019, 642593.82573592651],
						[525381.85429461452, 642532.43683872488],
						[525353.64961380395, 642532.39334339532],
						[525353.69683705701, 642501.75420655764],
						[525324.56567078782, 642501.70933323586],
						[525324.61301005899, 642470.95959007624],
						[525268.10050037678, 642470.87268595723],
						[525268.1947977175, 642409.4838229859],
						[525239.16640560608, 642409.4392590198],
						[525239.11990508845, 642439.74655143614],
						[525210.81212798157, 642439.70314308023],
						[525210.85857634631, 642409.39585058729],
						[525153.52235466999, 642409.30807803292],
						[525153.59153048194, 642364.06836806843],
						[525153.61656230805, 642347.6980108018],
						[525125.30862680229, 642347.65474958648],
						[525125.35576207167, 642316.79441722704],
						[525096.32720639859, 642316.75010532164],
						[525096.37378095929, 642286.22160874167],
						[525068.1686779923, 642286.17860289826],
						[525068.21435741102, 642256.20316290471],
						[524927.6576622976, 642218.16070403811],
						[524884.14127809706, 642404.58455260599],
						[524753.6821389962, 642497.52203682135],
						[524926.88144462253, 642730.39832390565],
						[524840.37787412829, 642823.40192465624],
						[524796.86405893019, 643009.82652697596],
						[524883.08480122057, 643102.98069455463],
						[524796.58326462819, 643196.09529761656],
						[524882.7324184021, 643335.9273928504],
						[525099.64932948467, 643242.79044390656],
						[525229.24115232984, 643242.98869844631],
						[525229.02705090912, 643382.5797955998],
						[525185.5815901194, 643522.43656704354],
						[525185.36802465271, 643661.91723511636],
						[525055.56653007725, 643801.53192038136],
						[525055.35338925244, 643941.45521701081],
						[525055.14075375895, 644081.04677074286],
						[524924.76431032864, 644127.52681659884],
						[524881.32371992851, 644267.16365489201],
						[524707.72097085021, 644313.24829075125],
						[524664.38530249533, 644453.10720128927],
						[524620.94794040825, 644592.63432847965],
						[524707.16118696856, 644685.89887232787],
						[524837.49503959843, 644732.44159591605],
						[524880.40812119911, 644872.43068312958],
						[525053.72222546919, 645012.2862579237],
						[525096.73565032845, 645152.27624976856],
						[525182.87195737788, 645292.11119360849],
						[525009.8897457897, 645478.1184253603],
						[524879.49218521966, 645477.92065336998],
						[524705.9022096718, 645524.00557162834],
						[524922.29466602637, 645757.28192405147],
						[524965.20466071693, 645897.05068167194],
						[525008.89836155728, 646130.06734706089],
						[524878.43552584213, 646176.4374402843],
						[524792.30162146373, 646036.38228395954],
						[524618.78715811833, 646036.12163137039],
						[524488.255014161, 646129.283872406],
						[524271.41443170857, 646268.55573015311],
						[524098.62281179923, 646268.30162868649],
						[523968.13082698447, 646407.81493801356],
						[523881.31384339853, 646733.66500480741],
						[523837.82142949651, 646919.87433834013],
						[523620.55926785956, 647292.10620212858],
						[523577.24093635316, 647431.74871627416],
						[523532.9971898137, 647571.39011192333],
						[523403.54237296234, 647571.2053673187],
						[523186.8893968027, 647524.44081059925],
						[522926.9499669536, 647524.07635493646],
						[522926.92961069691, 647538.67730140151],
						[522937.20411162439, 647550.19542815664],
						[522958.36725879594, 647575.55544310738],
						[522984.02656722476, 647697.15552403068],
						[522963.497173435, 647807.62979258492],
						[522963.30409490445, 647945.89655794029],
						[522908.81533692841, 648205.54160260444],
						[522866.69439341599, 648526.15262993239],
						[522794.85447486321, 648834.66608881147],
						[522794.67046831961, 648967.40283517074],
						[522778.13270891679, 649021.02781325718],
						[522758.17043617438, 649244.33042487095],
						[522721.68751687958, 649509.75457844557],
						[522726.83522546687, 649730.88017651625],
						[522731.25475548353, 649957.64635605027],
						[522756.86942272412, 650184.3314914417],
						[522752.8472904563, 650265.51724079996],
						[522751.27090345352, 650289.40787774674],
						[522750.39422832389, 650328.12188539316],
						[522749.52061803901, 650364.62360562303],
						[522922.98941422522, 650364.8645365343],
						[522922.79494756553, 650504.34976147884],
						[522922.59986391012, 650644.2775399565],
						[522912.36975232611, 650676.12043094286],
						[522879.29636203015, 650783.81352338265],
						[522879.10226070392, 650923.29903142585],
						[523008.37289385375, 651109.75558704603],
						[523138.29538055323, 651342.67274221068],
						[523150.07116716774, 651382.17904687161],
						[523181.30838139087, 651482.6619545765],
						[523202.40503584594, 651551.27336575661],
						[523224.21839152923, 651622.20876760257],
						[523348.14955344674, 651722.38084993872],
						[523397.57781645365, 651762.27276831504],
						[523830.80142152682, 651762.8950232421],
						[523895.88944140065, 651786.66126034001],
						[523960.25808949588, 651809.76301531377],
						[524047.25998536311, 651903.13912475074],
						[524263.03027322039, 651949.5829332401],
						[524393.13496052986, 652043.24584042141],
						[524609.51549505163, 652229.95613141544],
						[524695.68880557909, 652323.11339916242],
						[524756.08283646964, 652387.47214724158],
						[524782.68380457303, 652416.49363306176],
						[524805.30867667915, 652489.75560389471],
						[524825.68047416653, 652556.15602891613],
						[524837.3481217908, 652595.88485116407],
						[524853.01289885526, 652645.46457243874],
						[524868.57370380394, 652695.70786080253],
						[524941.58933647291, 652711.85782749043],
						[525085.15308007062, 652742.93819409935],
						[525171.24969659059, 652882.66754452919],
						[525204.82636348938, 652990.56993207603],
						[525214.24166532885, 653022.44189037697],
						[525387.39474700356, 653208.98648225632],
						[525363.71941828553, 653285.49656929658],
						[525343.24944913469, 653351.50308495341],
						[525300.6569589643, 653488.15961194632],
						[525430.16806515539, 653488.35944977507],
						[525560.39924739057, 653488.56142755074],
						[525689.91035040666, 653488.76331171638],
						[525820.14152943681, 653488.9673472154],
						[525950.47557506722, 653489.17257681477],
						[526079.98667325894, 653489.37753414107],
						[526079.76467695157, 653629.30730387848],
						[525954.775425556, 653762.84516053356],
						[525906.0367596061, 653815.31126917689],
						[525905.37641836703, 654234.32722963474],
						[526121.68220810662, 654374.37893781788],
						[526251.7862902066, 654514.18508393108],
						[526343.48584477196, 654547.51695580303],
						[526381.21439509385, 654561.07276705327],
						[526468.01028021425, 654700.92192658968],
						[527983.45605247642, 654703.43196746032],
						[528052.34886399412, 654777.77364412439],
						[528156.55998537235, 654890.00726042059],
						[528285.81963109341, 655029.93906545395],
						[528545.13318519178, 655263.23736855714],
						[528675.61545834085, 655170.4350610812],
						[528935.331165532, 655170.89020254661],
						[528940.76217377326, 655182.51461288903],
						[529065.05512200098, 655450.42872617184],
						[529122.23672338983, 655512.14404099504],
						[529151.288936864, 655543.72161444812],
						[529281.33771401271, 655637.20361402933],
						[529453.69709131576, 655823.79214330611],
						[529490.30552903574, 655942.66151967121],
						[529496.5422339252, 655963.46890245669],
						[529501.990454674, 656022.43810810812],
						[529539.6233699813, 656429.2487889129],
						[529570.18266427098, 656479.30321985378],
						[529625.76539631106, 656569.11480142188],
						[529842.09312881273, 656662.75747915299],
						[530015.41083269124, 656709.42221501796],
						[530144.89656049025, 656709.65919724363],
						[530318.38391231361, 656663.62917715963],
						[530492.06210122199, 656570.69914759893],
						[530687.2410952081, 656641.30510052363],
						[530751.5812083137, 656664.43399210763],
						[530793.16013082932, 656649.46773173567],
						[530881.15499927336, 656617.99595918728],
						[530976.85281911935, 656592.40195386845],
						[531054.64581189281, 656571.75249627349],
						[531228.04912015994, 656572.08104891062],
						[531487.38580262417, 656758.85731616803],
						[531356.82470364671, 656945.11059234664],
						[531486.67204626906, 657131.41942816984],
						[531510.1504829441, 657169.62788489927],
						[531572.69054925768, 657271.51717070339],
						[531545.09049650433, 657344.69382591825],
						[531485.95765281375, 657504.31408958673],
						[531485.5124012779, 657736.72372202226],
						[531614.72042391717, 657877.12615333288],
						[531787.93044544454, 657970.26973948337],
						[531878.99143148412, 657945.99928725394],
						[531961.40956837381, 657924.03553360421],
						[532013.99768372078, 657905.33263427101],
						[532090.97601538792, 657878.04921993613],
						[532221.27526236069, 657878.30416717846],
						[532437.84763850656, 657831.82769514038],
						[532460.69080615288, 657825.56750872708],
						[532610.60973446304, 657785.82019123435],
						[532740.80687130941, 657786.07905347017],
						[532793.43450509757, 657748.24163734843],
						[532871.29291918629, 657693.30888971256],
						[532913.84899395925, 657600.91656473221],
						[532957.95085337828, 657507.20006437076],
						[533118.85628537927, 657478.32012905227],
						[533217.72443540324, 657460.82063410128],
						[533279.82858870702, 657416.69871262019],
						[533348.21530875843, 657368.27564585535],
						[533257.34659315262, 657294.86183950957],
						[533175.10330723831, 657227.77124340483],
						[533117.94200030225, 657166.48378033109],
						[533088.18102563114, 657134.56563891331],
						[533175.47887845221, 657041.71128825622],
						[533208.49867038417, 656987.79606276273],
						[533262.04964036809, 656902.06429435557],
						[533347.75829046662, 656833.21197485586],
						[533435.73368401977, 656762.70545782871],
						[533522.21268382377, 656669.85144814325],
						[533557.61893235263, 656656.98133876931],
						[533782.19921587745, 656577.13241086341],
						[533873.3210340573, 656528.53723146243],
						[533955.79466260213, 656484.46005270979],
						[534129.19889167452, 656484.81921352586],
						[534258.68638884649, 656485.08860564209],
						[534387.25504194631, 656531.26373358618],
						[534561.80886261689, 656718.35384510865],
						[534591.43130840338, 656815.09677664971],
						[534604.70994076482, 656858.59783477476],
						[534690.80233198253, 656951.80959306797],
						[534768.51045457332, 656924.09789924789],
						[534821.20805797935, 656905.29367700045],
						[534869.96703502955, 656852.41073639027],
						[534907.69438806642, 656812.33627465356],
						[535038.29635733389, 656626.33257675357],
						[535124.78466940578, 656533.7083003663],
						[535255.2950740325, 656440.51517891535],
						[535292.30412190291, 656400.55075624085],
						[535341.78606027854, 656347.670894932],
						[535428.37912020017, 656207.92518222227],
						[535559.09365825797, 656022.36887680064],
						[535688.5847987266, 656022.6495341463],
						[535905.08904373297, 656023.12106131332],
						[536008.92732925841, 655948.90221623809],
						[536035.60792726872, 655929.93437432719],
						[536099.22158620681, 655907.06540024071],
						[536165.20250744501, 655883.53817461152],
						[536165.50966820715, 655743.93887579255],
						[536165.81707214564, 655604.22905630816],
						[536296.23692123278, 655511.4868766329],
						[536469.6514153966, 655511.87073001347],
						[536515.18030902406, 655528.23264140007],
						[536599.04312896624, 655558.61784857395],
						[536815.34316725086, 655698.92199137725],
						[536901.42915002909, 655792.14478930866],
						[537161.32611342531, 656072.15171966376],
						[537204.20798834809, 656211.84894927568],
						[537255.03513151465, 656294.48533252475],
						[537290.18265848106, 656351.97595749237],
						[537392.08534664917, 656407.0741854806],
						[537463.37623700558, 656445.39987689839],
						[537592.65025145689, 656539.1676294168],
						[537592.3312060748, 656678.65683315601],
						[537592.01190745656, 656818.25675196946],
						[537721.68202422932, 657051.51680277265],
						[537738.83415597002, 657106.42308642017],
						[537764.55578269577, 657191.54802974244],
						[537777.82876449695, 657233.7243117271],
						[537807.4300774819, 657331.02637485461],
						[537846.22677418543, 657499.145859143],
						[537850.0920138408, 657517.73875330156],
						[537893.68461406417, 657657.21920884913],
						[537806.46614970337, 657750.04901283619],
						[537633.36833780631, 657936.04505695938],
						[537714.51767913613, 658156.6953500685],
						[537719.11699958111, 658169.09527462965],
						[537718.58281862969, 658401.83733841195],
						[537607.86924187234, 658472.933194043],
						[537501.79058090854, 658541.27490580198],
						[537472.54732389946, 658602.8233107524],
						[537414.98370914673, 658727.36048958392],
						[537434.47736619075, 658792.33864371793],
						[537457.85614351975, 658867.17085565045],
						[537508.6724763423, 658950.36221688869],
						[537543.81592118111, 659006.7479556402],
						[537543.49622757151, 659146.6813643903],
						[537485.86810006993, 659300.09030342638],
						[537456.68847616471, 659379.44894019072],
						[537499.5595857735, 659518.92801633268],
						[537534.80037805811, 659532.17226805445],
						[537629.63558944443, 659566.1283006547],
						[537758.99281751725, 659612.55363460758],
						[537866.71542784665, 659497.64594106539]
					]
				],
				[
					[
						[544000.60768954526, 662298.03015337628],
						[544000.93593369646, 662175.46213307744],
						[544029.92944564007, 662175.5398049939],
						[544030.01215360628, 662144.67657028546],
						[544058.28602142248, 662144.75236359204],
						[544058.45124690665, 662083.13652998302],
						[544087.44492177141, 662083.21430339513],
						[544087.60966226901, 662021.81973119371],
						[544001.34801608871, 662021.58849097812],
						[544001.26536263619, 662052.45170637476],
						[543972.99133598467, 662052.37601119035],
						[543972.90962380881, 662082.9073690006],
						[543944.73846401682, 662082.83199760038],
						[543943.83340249781, 662113.6930230998],
						[543915.6622954919, 662113.61770155653],
						[543915.49760515289, 662175.23354634247],
						[543887.22378979297, 662175.15799875744],
						[543887.14489568083, 662204.6937877622],
						[543858.14818701195, 662205.83319817623],
						[543857.9030975987, 662297.64860181487],
						[544000.60768954526, 662298.03015337628]
					]
				]
			]
		}
	}, {
		"type": "Feature",
		"properties": {
			"name": "Sha Tin",
			"ID_0": 102,
			"ID_1": 9,
			"ISO": "HKG"
		},
		"geometry": {
			"type": "MultiPolygon",
			"coordinates": [
				[
					[
						[523844.55405378086, 657954.72329329897],
						[523844.59851121093, 657924.08187222318],
						[523901.05793236324, 657924.16388589726],
						[523901.10233417171, 657893.63308850932],
						[523958.38458525424, 657893.71649566339],
						[523958.43006104807, 657862.52199027711],
						[524015.71242056933, 657862.60559724155],
						[524015.66683604976, 657893.80010246928],
						[524043.948019006, 657893.84145413863],
						[524043.90335182595, 657924.37225114135],
						[524072.90436549194, 657924.4147058588],
						[524072.72434696445, 658047.31227268255],
						[524130.00606239866, 658047.39627802139],
						[524129.96091005293, 658078.14833615138],
						[524243.80424909038, 658078.31588350621],
						[524243.75904689968, 658108.95732713118],
						[524272.75973483571, 658109.00013452687],
						[524272.71431518777, 658139.75220174901],
						[524329.9957084175, 658139.83690415067],
						[524329.95001780917, 658170.69959494169],
						[524357.4080128069, 658170.74026806385],
						[524358.08263366797, 658201.27217354742],
						[524386.36328751373, 658201.31411445921],
						[524386.31749086443, 658232.17681461433],
						[524415.31796136079, 658232.21987357212],
						[524415.27227458218, 658262.97195941198],
						[524472.5532383339, 658263.05715870101],
						[524472.50760908984, 658293.69863009825],
						[524500.7881038835, 658293.74076791713],
						[524500.7422569847, 658324.49286301073],
						[524529.02269878355, 658324.53504942043],
						[524528.9310642354, 658385.92863462819],
						[524557.93126341316, 658385.97194525017],
						[524557.79340107366, 658478.22828709229],
						[524528.79336469609, 658478.18497671676],
						[524528.6097652131, 658601.19349947036],
						[524500.32979949866, 658601.15131377161],
						[524500.28428236488, 658631.68221799145],
						[524472.00436911429, 658631.6400810394],
						[524471.95841033303, 658662.50284776301],
						[524442.95869913592, 658662.45968885045],
						[524442.91328839946, 658692.99060267524],
						[524385.63382318581, 658692.90550669737],
						[524385.58802642184, 658723.76828321],
						[524357.30827163754, 658723.72634362662],
						[524357.12595278025, 658846.735020619],
						[524385.40549588006, 658846.77695988235],
						[524385.3601915196, 658877.30790224136],
						[524471.63834592153, 658877.43615561631],
						[524471.68265748164, 658847.67954892037],
						[524499.96335338196, 658846.94734990073],
						[524500.00936531881, 658816.08455456642],
						[524557.28840119275, 658816.17004920461],
						[524557.19665807777, 658877.56378625496],
						[524585.47614812956, 658877.60606981523],
						[524585.4299754973, 658908.46887445985],
						[524612.88673783559, 658908.50997443381],
						[524614.38319116086, 658939.2644747569],
						[524642.66257503245, 658939.30685672536],
						[524642.61662657023, 658969.94843197765],
						[524670.79312370787, 658969.99070814811],
						[524670.74728876958, 659000.52166862634],
						[524842.58246692643, 659000.780536782],
						[524842.62862111162, 658970.24957678246],
						[524870.90795166616, 658970.29235152551],
						[524870.95432579645, 658939.65077691618],
						[524899.95354784722, 658939.69469108735],
						[524899.90711964399, 658970.3362656174],
						[524957.18561787112, 658970.42315409542],
						[524957.27885587339, 658909.0293907231],
						[524984.73561727721, 658909.07111198036],
						[524985.60454312165, 658878.65203668585],
						[525042.88403520314, 658878.29674642486],
						[525042.97759279772, 658816.90301211341],
						[525067.24662657583, 658816.94001353066],
						[525071.20126814488, 658786.19380513497],
						[525100.20076099597, 658786.23807267274],
						[525100.24790001009, 658755.37528863142],
						[525156.80730056937, 658755.4617734272],
						[525156.85403778544, 658724.93085216149],
						[525271.41274465516, 658725.1066199441],
						[525271.36579461058, 658755.63754088397],
						[525299.54265920387, 658755.68089510314],
						[525299.49514590413, 658786.54367857228],
						[525328.59747321415, 658786.58850746695],
						[525328.55007574905, 658817.3406763348],
						[525385.82910724229, 658817.42905884818],
						[525385.87661189411, 658786.6768901475],
						[525414.0534232714, 658786.72044070158],
						[525414.10115171026, 658755.85765756946],
						[525471.3803975007, 658755.94633827021],
						[525471.42737623292, 658725.63665644638],
						[525443.25080265582, 658725.37176897144],
						[525443.29858574038, 658694.50899547257],
						[525299.63717488141, 658694.28720032447],
						[525299.68417726073, 658663.75628891296],
						[525271.5071550518, 658663.71293445025],
						[525271.55461540387, 658632.85016999824],
						[525243.27470416995, 658632.80670580314],
						[525243.321261812, 658602.49704207876],
						[525186.04182023753, 658602.18791786896],
						[525186.08911989129, 658571.32516271318],
						[525157.08924779494, 658571.28074361035],
						[525157.18356881896, 658509.66586667078],
						[525128.90344560111, 658509.62259929487],
						[525128.95013021911, 658479.09171574621],
						[525100.66995438526, 658479.04849695263],
						[525100.90429737384, 658325.61981583096],
						[525157.46551569435, 658325.48506478779],
						[525157.51259148424, 658294.73297155509],
						[525243.79261505522, 658295.63961207157],
						[525250.08188848826, 658285.14044151385],
						[525409.33432939043, 658313.81505558582],
						[525509.67660813604, 658331.78021431714],
						[525509.89313212386, 658192.28964305448],
						[525445.72610185714, 658122.94253485603],
						[525379.91531566612, 658052.15511448402],
						[525380.13090511819, 657912.55411853106],
						[525596.85816472524, 657819.74899934186],
						[525597.07524908439, 657680.36940664612],
						[525597.29319473612, 657540.43681829562],
						[525597.58298469009, 657354.37640610128],
						[525584.2697405736, 657318.07272168854],
						[525511.55594887817, 657121.05840714113],
						[525494.52505868836, 657028.00172236771],
						[525468.82451675879, 656888.14002469089],
						[525482.98881464975, 656840.26416913746],
						[525489.2920046699, 656821.24756429857],
						[525512.13425811008, 656748.49606027151],
						[525425.62928552472, 656422.36974242423],
						[525470.29595767334, 656403.191324624],
						[525642.27340430045, 656329.67637470411],
						[525749.16665216687, 656244.00377756427],
						[525815.89905426628, 656190.01618340216],
						[525859.4627823456, 655957.34424812917],
						[525816.77646491211, 655631.3967665825],
						[525903.32147232804, 655538.28212250944],
						[525915.89110982884, 655524.80656807381],
						[525990.48442030128, 655445.27957052272],
						[525990.7051583312, 655305.68039843952],
						[525990.92607111961, 655165.9707055802],
						[526077.47450848448, 655072.85719361901],
						[526034.49529461772, 654933.07918220153],
						[525948.34363708016, 654839.69247188582],
						[525923.37285243266, 654759.12362559047],
						[525904.64251058584, 654700.02444128087],
						[525905.37641836703, 654234.32722963474],
						[525906.0367596061, 653815.31126917689],
						[525954.775425556, 653762.84516053356],
						[526079.76467695157, 653629.30730387848],
						[526079.98667325894, 653489.37753414107],
						[525950.47557506722, 653489.17257681477],
						[525820.14152943681, 653488.9673472154],
						[525689.91035040666, 653488.76331171638],
						[525560.39924739057, 653488.56142755074],
						[525430.16806515539, 653488.35944977507],
						[525300.6569589643, 653488.15961194632],
						[525343.24944913469, 653351.50308495341],
						[525363.71941828553, 653285.49656929658],
						[525387.39474700356, 653208.98648225632],
						[525214.24166532885, 653022.44189037697],
						[525204.82636348938, 652990.56993207603],
						[525171.24969659059, 652882.66754452919],
						[525085.15308007062, 652742.93819409935],
						[524941.58933647291, 652711.85782749043],
						[524868.57370380394, 652695.70786080253],
						[524853.01289885526, 652645.46457243874],
						[524837.3481217908, 652595.88485116407],
						[524825.68047416653, 652556.15602891613],
						[524805.30867667915, 652489.75560389471],
						[524782.68380457303, 652416.49363306176],
						[524756.08283646964, 652387.47214724158],
						[524695.68880557909, 652323.11339916242],
						[524609.51549505163, 652229.95613141544],
						[524393.13496052986, 652043.24584042141],
						[524263.03027322039, 651949.5829332401],
						[524047.25998536311, 651903.13912475074],
						[523960.25808949588, 651809.76301531377],
						[523895.88944140065, 651786.66126034001],
						[523830.80142152682, 651762.8950232421],
						[523397.57781645365, 651762.27276831504],
						[523348.14955344674, 651722.38084993872],
						[523224.21839152923, 651622.20876760257],
						[523202.40503584594, 651551.27336575661],
						[523181.30838139087, 651482.6619545765],
						[523150.07116716774, 651382.17904687161],
						[523138.29538055323, 651342.67274221068],
						[523008.37289385375, 651109.75558704603],
						[522879.10226070392, 650923.29903142585],
						[522879.29636203015, 650783.81352338265],
						[522912.36975232611, 650676.12043094286],
						[522922.59986391012, 650644.2775399565],
						[522922.79494756553, 650504.34976147884],
						[522922.98941422522, 650364.8645365343],
						[522749.52061803901, 650364.62360562303],
						[522620.08778981102, 650364.44502853486],
						[522489.7289701433, 650364.26620373118],
						[522360.19325133227, 650364.08953182423],
						[522306.84131358983, 650329.50520356698],
						[522143.69958002336, 650224.20052938559],
						[521927.11895104108, 650223.91027199128],
						[521904.51126710314, 650125.76477699599],
						[521900.51994895114, 650109.7203131502],
						[521895.91658905213, 650089.69290391088],
						[521884.15363906557, 650037.57768300909],
						[521808.85647861921, 650023.76140711771],
						[521775.83672718116, 650017.74444657471],
						[521623.59538479784, 649990.33229921013],
						[521596.11064634612, 650000.25150308886],
						[521559.25831002998, 650013.6981397667],
						[521493.9954098856, 650037.06302418071],
						[521320.64435569331, 649943.36787625798],
						[521147.17111265007, 649943.14385068859],
						[521017.63207612437, 649942.97775594424],
						[520996.44611368253, 649935.53950321977],
						[520949.44701587933, 649918.33427579037],
						[520887.4315416785, 649896.5748995404],
						[520757.89213827543, 649896.41085111594],
						[520627.52960789547, 649896.24679059128],
						[520497.97739595448, 649988.89050925663],
						[520454.02807214233, 649918.37420911051],
						[520411.00287941494, 649849.07595914963],
						[520281.75030890974, 649616.0723084542],
						[520104.40237978502, 649584.21875788923],
						[520022.00340470677, 649569.29587227176],
						[519891.41320298053, 649755.1910448022],
						[519717.9379746858, 649754.98209815298],
						[519680.32863707718, 649714.00964336609],
						[519631.72299518657, 649661.85208066017],
						[519636.47334042675, 649647.36724792013],
						[519660.84982252237, 649568.86006936536],
						[519667.14996350155, 649549.06760965602],
						[519675.00185324717, 649522.30829903577],
						[519675.14757913142, 649400.52197461482],
						[519667.34881813702, 649382.81434017536],
						[519502.51275087259, 649382.61800655955],
						[519438.95176629256, 649359.31371951732],
						[519372.20140231051, 649335.56346563669],
						[519338.46042410476, 649328.44442893099],
						[519249.78784126829, 649309.31471084675],
						[519155.66306140507, 649288.9623625786],
						[519117.16456731776, 649302.6337372011],
						[519086.48957390001, 649313.32769451384],
						[519026.06524297467, 649335.15931084729],
						[518912.95001297101, 649365.0053109111],
						[518852.53180999763, 649381.85992925637],
						[518691.68491948338, 649311.9892436571],
						[518635.94287528185, 649288.36511713732],
						[518462.56717311492, 649195.14289466001],
						[517899.73097416037, 649194.52056744287],
						[517812.68007547816, 649100.95698549226],
						[517769.61485989066, 648961.2046574736],
						[517596.9544273786, 648961.01897751389],
						[517466.53489718877, 649007.55910596461],
						[517250.03606431343, 648914.08282544208],
						[517120.440434672, 648960.5159380351],
						[516990.07048424659, 648960.38071676658],
						[516859.66018587525, 649099.95221218013],
						[516730.01940697851, 649193.28884292953],
						[516599.79256062122, 649053.22984647308],
						[516470.34940916917, 649053.09968067706],
						[516296.99475487025, 648819.97357810976],
						[516167.50365405099, 648866.7461242046],
						[515906.73023021402, 649005.97622073966],
						[515690.94280927826, 648912.52116488933],
						[515517.26779791294, 649005.60407973803],
						[515474.28551753785, 648866.07915193937],
						[515387.21908906894, 648772.52855749056],
						[515257.67083020112, 648772.40784171899],
						[515127.40228617628, 648772.28748393082],
						[515047.98997815332, 648857.60867929959],
						[514997.72660295642, 648911.87428326672],
						[514867.27195700078, 649005.00353723567],
						[514867.14574205264, 649144.5985482356],
						[514737.61993222072, 649237.50854385947],
						[514589.93061076343, 649277.08736939135],
						[514563.99480689398, 649284.25430722046],
						[514520.75881539535, 649423.70076427213],
						[514477.2565553232, 649749.53264365601],
						[514477.1621815362, 649856.71809698362],
						[514477.13315841864, 649889.68122997368],
						[514477.0400506804, 649995.42876576935],
						[514476.84614099341, 650215.66256196913],
						[514692.49868751096, 650448.58754330548],
						[514736.40951388719, 650588.00170503696],
						[514908.96850766049, 650681.18451612606],
						[514952.77348625631, 650821.15239422338],
						[514926.04856620659, 650906.74424288131],
						[514908.71474004356, 650961.04057654564],
						[514812.7444247813, 651166.58760844986],
						[514778.93265707116, 651240.22699592425],
						[514865.04048018716, 651473.03947071137],
						[515032.12334293622, 651580.93089869362],
						[515081.57958204352, 651612.72285531659],
						[514907.95483937883, 651799.06241799891],
						[514874.98518217559, 651852.57054086472],
						[514821.51387139247, 651938.36003975407],
						[514907.61721620557, 652171.39475904219],
						[515167.3370415041, 652218.53345022385],
						[515297.551469567, 652358.03016520757],
						[515297.44637907972, 652470.968996668],
						[515297.29126500082, 652637.66726814606],
						[515376.4244443283, 652722.69428631198],
						[515513.62036681565, 652870.71704302332],
						[515606.99641208549, 652904.32214953355],
						[515643.09191896673, 652917.51979232323],
						[515816.53378157405, 652917.68574769911],
						[515989.98802886478, 653010.88184884796],
						[516004.7781154461, 653034.89998418558],
						[516076.16036001104, 653150.67435226287],
						[516183.54629203433, 653266.15265213256],
						[516249.41563329799, 653337.12279269844],
						[516315.33117356163, 653360.97062886902],
						[516378.88153041841, 653383.82082686923],
						[516552.13091083191, 653570.27267039614],
						[516570.07533921726, 653627.25831915298],
						[516581.04566230159, 653663.44103113073],
						[516595.09144734772, 653710.02483115508],
						[516682.07788674528, 653849.82182018831],
						[516898.57011410239, 653989.64137161686],
						[517071.0324276273, 654129.74994076509],
						[517158.01259345212, 654269.54973637627],
						[517157.86688099953, 654409.14830013469],
						[517070.40383002302, 654735.04605499434],
						[517070.25874226232, 654874.75555747817],
						[517243.68499028205, 654968.18701592938],
						[517216.12861009972, 655056.98391679791],
						[517204.26041148539, 655094.69204152422],
						[517200.33802602824, 655107.85141497105],
						[517216.00614754931, 655173.90645788936],
						[517229.21403224801, 655231.88387810159],
						[517243.3430102804, 655294.17637715279],
						[517218.0297369535, 655402.33385531558],
						[517208.62627270236, 655443.91624102299],
						[517199.94817058631, 655480.41098662373],
						[517199.8019746113, 655620.12100333232],
						[517113.40985904902, 655713.06037600327],
						[517026.19566079654, 655806.22062880429],
						[517026.05105316086, 655945.82025529642],
						[517056.46278207336, 656076.49160144536],
						[517068.9528330121, 656132.25604717643],
						[517068.88540063851, 656197.18877152342],
						[517111.21970715775, 656236.05973522272],
						[517236.05523154885, 656260.63677166938],
						[517411.82739330339, 656260.82203903305],
						[517537.31219895184, 656254.65022067912],
						[517633.88921499456, 656254.7535522331],
						[517724.08267397794, 656261.15579814126],
						[517769.58629645011, 656316.07151874411],
						[517803.95531222777, 656395.42193184048],
						[517820.31860854011, 656480.94753685384],
						[517956.84280849592, 656535.96277698549],
						[518036.13951239979, 656536.04960349784],
						[518211.81923985295, 656524.18593797903],
						[518439.43837272236, 656512.16110326909],
						[518847.46251466504, 656494.37192188273],
						[518949.47511254711, 656506.65722643421],
						[518983.97614689107, 656555.47969421837],
						[518983.8708658971, 656646.62905322562],
						[519017.60516394081, 656646.66805231245],
						[519036.30766477482, 656749.2329190718],
						[519050.30857822619, 656826.23955145187],
						[519148.413217981, 656836.41983397282],
						[519261.44238058227, 656836.55190893519],
						[519466.21852204134, 656830.70915653394],
						[520021.79972190293, 656831.37657778943],
						[520214.74128099292, 656831.61275260244],
						[520368.60085916793, 656831.80271144188],
						[520385.01842441381, 656862.46437608474],
						[520419.47651694366, 656941.82059992943],
						[520430.17351181526, 657106.54490854533],
						[520492.79906714434, 657277.52867381077],
						[520492.56306953443, 657466.797042066],
						[520531.58635300206, 657594.94234836148],
						[520599.76661753433, 657680.53606572142],
						[520696.2324131428, 657680.65726245614],
						[520763.08727431309, 657593.35266763507],
						[520791.56251407781, 657440.40283676737],
						[520796.24898044008, 657394.17012186744],
						[520870.09882962937, 657387.95846616838],
						[520886.48706665239, 657440.52319870226],
						[520921.76238774601, 657440.56806665089],
						[520961.38122419122, 657744.26733328914],
						[521050.84080647636, 657754.22676416324],
						[521159.19561071158, 657705.69357692264],
						[521232.11047686171, 657705.78761486639],
						[521300.39745973004, 657705.87597760081],
						[521327.80455187685, 657745.73434090859],
						[521352.85075914342, 657782.04988328298],
						[521363.01192342391, 657797.54974531359],
						[521403.75994979206, 657858.99630809459],
						[521416.30653753888, 657859.01265318715],
						[521416.34531412477, 657829.25619056984],
						[521444.6274742044, 657828.62935633818],
						[521444.66774539847, 657797.76671038498],
						[521473.66898248572, 657797.8045783597],
						[521473.70887452457, 657767.27379358746],
						[521501.16754356876, 657767.30969454255],
						[521502.0307987039, 657736.33751586929],
						[521531.0321441869, 657736.3754850704],
						[521531.07257739973, 657705.51285362802],
						[521557.70861487847, 657705.54777120368],
						[521559.39413535676, 657675.01915926894],
						[521587.57285276928, 657675.05614897667],
						[521587.61281078839, 657644.63600200647],
						[521616.71716031741, 657644.67425750138],
						[521616.75775419048, 657613.81164047902],
						[521644.93657655263, 657613.84872853837],
						[521644.9770776513, 657583.09673503099],
						[521672.43605441059, 657583.13292213832],
						[521674.12223759148, 657552.2724847598],
						[521702.30116547196, 657552.30967117636],
						[521702.34177374275, 657521.55768730503],
						[521759.6253217046, 657521.63343068375],
						[521759.66559777822, 657491.21330755437],
						[521787.94806012674, 657490.80830250261],
						[521787.98853519402, 657460.27756554238],
						[522130.86835353379, 657460.73570394982],
						[522130.90991242562, 657429.87311675609],
						[522102.62793105061, 657429.83505713718],
						[522102.71049629257, 657368.44175256114],
						[522073.70850153134, 657368.40277454513],
						[522073.74980426009, 657337.65081999253],
						[522102.75185328524, 657337.68979808223],
						[522102.79306151049, 657307.04846684646],
						[522073.79095841153, 657307.00948868878],
						[522073.95616923511, 657184.0017366535],
						[522045.67376475036, 657183.96377504338],
						[522045.71471776051, 657153.43308565428],
						[522073.99717478262, 657153.47104733519],
						[522074.07992871723, 657091.85659068462],
						[522045.79736566596, 657091.81862886203],
						[522045.83817027416, 657061.39857191301],
						[522074.12108281412, 657061.21529704973],
						[522074.32729893189, 656907.67704434087],
						[522046.04441893956, 656907.63908209349],
						[522046.16757453838, 656815.82591784932],
						[522074.45120681252, 656815.42140733683],
						[522074.49221228715, 656784.89077422873],
						[522046.2094177563, 656784.63157524448],
						[522046.37382294959, 656662.06661654415],
						[522074.65742267983, 656661.88334304327],
						[522074.73987926892, 656600.49027387588],
						[522046.45647065103, 656600.45231091755],
						[522046.53911832441, 656538.83802421461],
						[522017.53565960593, 656538.79914532613],
						[522017.78238718351, 656354.62010624225],
						[521989.49855546182, 656354.58224129828],
						[521989.58098827902, 656292.9680297632],
						[521961.39990114718, 656292.93035077606],
						[521961.56425980775, 656169.92321988521],
						[521932.45729862718, 656169.88435370324],
						[521932.49759577849, 656139.68567204091],
						[521961.60520165524, 656139.28206680273],
						[521961.64599569316, 656108.75153624394],
						[521989.82739861362, 656108.78921565309],
						[521989.90983133129, 656047.17507947003],
						[522047.19851825328, 656047.25182517455],
						[522047.2399161692, 656016.38945540332],
						[522075.5243298678, 656016.42741971277],
						[522075.5651866105, 655986.00752589654],
						[522104.5696208147, 655986.04650718416],
						[522104.61097752478, 655955.29476473201],
						[522190.18510076107, 655954.96760077111],
						[522190.26768634724, 655893.79598373512],
						[522216.9066601214, 655893.83196968108],
						[522218.59388072341, 655863.08246611361],
						[522247.59853185114, 655863.12169980176],
						[522247.64060500241, 655832.03812341695],
						[522275.10250740522, 655832.07531744998],
						[522275.9664131602, 655801.76718485774],
						[522304.97117248795, 655801.80651978368],
						[522305.09666613099, 655709.33015731326],
						[522333.27875389491, 655709.36842559965],
						[522333.36187069502, 655648.19688394386],
						[522305.17967803916, 655648.15861551883],
						[522305.22140915244, 655617.40692520374],
						[522276.21632442635, 655617.36758983589],
						[522276.25785134919, 655586.72652171017],
						[522247.97269820434, 655586.68821197085],
						[522248.01447184506, 655555.82591332844],
						[522190.72407205729, 655555.74846768589],
						[522190.76558878162, 655524.99679115636],
						[522162.48032940418, 655524.95862853504],
						[522161.78599401301, 655505.9314429306],
						[522161.80180343607, 655494.2059858446],
						[522133.51649107371, 655494.16787306895],
						[522133.55804955831, 655463.30558827438],
						[522105.27268401452, 655463.26752409514],
						[522105.31389185379, 655432.62647892092],
						[522076.30848105496, 655432.5874963135],
						[522076.34948624496, 655402.05707318417],
						[522048.064312067, 655401.79787252587],
						[522048.10541309312, 655371.15683652321],
						[522019.09989382321, 655371.11795487604],
						[522019.14079258696, 655340.58754089277],
						[521990.85521586821, 655340.54967360641],
						[521990.89650606859, 655309.68741191912],
						[521962.71373301075, 655309.64973067725],
						[521962.75452687941, 655279.11932583433],
						[521933.64628338243, 655278.85922274552],
						[521933.68746599986, 655247.99697032897],
						[521905.50458716962, 655247.95938717807],
						[521905.54527461343, 655217.42899150669],
						[521876.53948406252, 655217.39036142733],
						[521876.58055929019, 655186.52811825008],
						[521820.00887556665, 655186.45292301476],
						[521820.04969772854, 655155.70130174374],
						[521791.04379825381, 655155.66282253549],
						[521791.0844194938, 655125.02182319318],
						[521762.79847182217, 655124.98434836138],
						[521762.83889387071, 655094.45397089981],
						[521733.83288631722, 655094.41559264611],
						[521733.87398579204, 655063.33213329571],
						[521705.5879319646, 655063.2947569117],
						[521705.62824758852, 655032.76438861317],
						[521677.44499972032, 655032.72719649202],
						[521677.48570063961, 655001.86498097959],
						[521648.37667093473, 655001.82661787653],
						[521648.45752638311, 654940.43405248784],
						[521620.27412020887, 654940.39695839258],
						[521620.35487036832, 654879.00441149704],
						[521563.0621115262, 654878.92915356241],
						[521563.14322811988, 654817.09415641648],
						[521505.85025348479, 654817.01909789559],
						[521505.88990802428, 654786.71000050753],
						[521477.60337816732, 654786.67301645339],
						[521477.64370321645, 654755.81083794124],
						[521448.63709807239, 654755.77296295913],
						[521448.67664695764, 654725.46387458965],
						[521420.3905883017, 654724.98452058539],
						[521420.43080576591, 654694.12235132128],
						[521391.42409176723, 654694.08457729663],
						[521391.46382290253, 654663.55426387419],
						[521363.17708111473, 654663.51747673261],
						[521363.21690347302, 654632.87655079365],
						[521335.03296996548, 654632.83994576812],
						[521335.07259620511, 654602.30964142655],
						[521305.96285892336, 654602.2718847025],
						[521306.04272014077, 654540.65820467018],
						[521248.74878199259, 654540.58404227486],
						[521248.86832313694, 654448.10824844649],
						[521192.39696022624, 654448.035346227],
						[521192.47610973654, 654386.6429463079],
						[521163.46885314299, 654386.6055745465],
						[521163.58720123192, 654294.68293460808],
						[521135.29982467298, 654294.64653960953],
						[521135.33950574766, 654263.78443510679],
						[521078.04460255848, 654263.71086769528],
						[521078.08403421676, 654232.95938458317],
						[520963.49401269847, 654232.81284859916],
						[520963.57230619318, 654171.4205126086],
						[520935.38758147688, 654171.38459280913],
						[520935.46576968266, 654109.99227524665],
						[520907.17807529826, 654109.95627281],
						[520907.25615783624, 654048.56397366698],
						[520849.9607851053, 654048.26996776846],
						[520849.99936861329, 654017.85036685702],
						[520793.5268074295, 654017.55760148005],
						[520792.74278528854, 653986.80511397729],
						[520763.73482311738, 653986.76844760636],
						[520763.81236930547, 653925.37618493964],
						[520707.23634508863, 653925.3048195258],
						[520707.31367995986, 653863.9125751314],
						[520650.12024890166, 653863.84062882792],
						[520650.23613920383, 653771.5863716912],
						[520621.12493078661, 653771.54982775613],
						[520621.16350641812, 653740.79841793969],
						[520592.97804336192, 653740.76308522723],
						[520593.01642768987, 653710.12229654647],
						[520564.72804519319, 653710.08688341477],
						[520564.80512351939, 653648.47347018332],
						[520535.79656431248, 653648.43720604433],
						[520535.83470363991, 653617.90704762272],
						[520478.5375492454, 653617.83556979126],
						[520478.57599555311, 653586.97356634226],
						[520450.2874011338, 653586.93835014023],
						[520450.32565671805, 653556.18696777313],
						[520422.03700932232, 653556.15180018742],
						[520422.07507456135, 653525.51103885984],
						[520364.77759812528, 653525.43995753326],
						[520364.8539260932, 653463.8265991552],
						[520307.55623465509, 653463.75571727916],
						[520307.59394963039, 653433.22558596148],
						[520250.39902011189, 653433.1550303821],
						[520250.51239140006, 653341.12219803501],
						[520222.22337390826, 653341.08737429872],
						[520222.26133832533, 653310.22541211022],
						[520193.25218222913, 653310.18975244113],
						[520193.2899563018, 653279.43841117865],
						[520135.99162217724, 653279.368127289],
						[520136.06709142786, 653217.75484211871],
						[520079.48863179213, 653217.68563721259],
						[520079.52619282593, 653186.93430961389],
						[520050.51681916678, 653186.89890182146],
						[520050.59169776895, 653125.50687663117],
						[520022.30230923754, 653125.47239692847],
						[520022.4144012655, 653033.43970166112],
						[519993.40475674323, 653033.40439465328],
						[519993.44229082251, 653002.54247841286],
						[519965.15269069083, 653002.50809705607],
						[519965.19003731653, 652971.75680158031],
						[519937.00325566874, 652971.72259360133],
						[519937.04068371508, 652940.86068653804],
						[519907.92800416215, 652940.82540560863],
						[519907.96497568459, 652910.29535152926],
						[519879.77808865823, 652910.26124166651],
						[519879.81540912425, 652879.39934374939],
						[519850.8054927708, 652879.36428837734],
						[519850.91675647249, 652787.22108662664],
						[519822.62678580172, 652787.18695053249],
						[519822.66373191576, 652756.54630314629],
						[519765.36357525608, 652756.47731107695],
						[519765.43658890447, 652695.74910988286],
						[519737.97024322627, 652695.05241288326],
						[519737.18417702412, 652664.30017500254],
						[519679.88369884115, 652664.231480874],
						[519679.92064344545, 652633.36961958907],
						[519651.73328160401, 652633.33590073069],
						[519651.76977660356, 652602.80589193094],
						[519622.65649838548, 652602.77111618512],
						[519622.7300404, 652541.15803245094],
						[519594.54252045351, 652541.12441165233],
						[519594.57904086582, 652510.48380054708],
						[519565.46559915773, 652510.44912608434],
						[519565.50219694839, 652479.69790360401],
						[519537.31457162177, 652479.66438092478],
						[519537.35124814225, 652448.80254710896],
						[519508.23769719846, 652448.7679739889],
						[519508.27392527618, 652418.23799236096],
						[519480.08619457373, 652418.20456780377],
						[519480.12276350911, 652387.34274311131],
						[519451.8321047104, 652387.3092450999],
						[519451.86822789215, 652356.77927249344],
						[519394.56667784578, 652356.71157283348],
						[519394.6030860981, 652325.84975719359],
						[519349.13211166579, 652325.79617705115],
						[519337.3014282473, 652325.78225713153],
						[519337.33759881399, 652295.03106181161],
						[519365.62841640954, 652295.06436279428],
						[519365.66450958728, 652264.42378793319],
						[519480.26825278241, 652264.55918549979],
						[519480.23194600799, 652295.19976011151],
						[519537.53371045587, 652295.26775835827],
						[519537.49716541602, 652326.01895323338],
						[519549.22497315716, 652326.03289488656],
						[519594.79882244585, 652326.08715107793],
						[519594.76203837851, 652356.94896627311],
						[519622.9498741104, 652356.98258745123],
						[519622.91343322041, 652387.51255968097],
						[519652.02709263918, 652387.54733587441],
						[519651.99020099326, 652418.40916018724],
						[519680.17793134734, 652418.44287948473],
						[519680.14138403424, 652448.97286073584],
						[519708.43193671625, 652449.00675163511],
						[519708.39493903931, 652479.86858506571],
						[519737.40556036099, 652479.90338913049],
						[519737.36864101765, 652510.65461123129],
						[519794.66965449229, 652510.72350572795],
						[519794.63276115176, 652541.3641163829],
						[519851.21354847553, 652541.43234090344],
						[519851.17641610402, 652572.18357196334],
						[519879.36388279765, 652572.21763279045],
						[519880.11263499124, 652633.61048786063],
						[519937.41321990377, 652633.67987988761],
						[519937.37579191622, 652664.54174059187],
						[519965.56310025073, 652664.57594921114],
						[519965.48854144354, 652725.96783636417],
						[519993.77861746156, 652726.00221829885],
						[519993.70395298721, 652787.39412374399],
						[520022.71403163439, 652787.42943128431],
						[520022.60180501541, 652879.57263186248],
						[520079.90153262625, 652879.64252053318],
						[520079.86383653735, 652910.5044179972],
						[520108.15359499713, 652910.53899675678],
						[520108.07850249216, 652971.9309570468],
						[520165.37790818495, 652972.00114364992],
						[520165.34018709138, 653002.75243866956],
						[520222.63948535692, 653002.82282485638],
						[520222.60152099701, 653033.68474056711],
						[520250.89106748329, 653033.71956495475],
						[520250.85345879936, 653064.24963663518],
						[520279.86304889276, 653064.28539794998],
						[520279.78717792727, 653125.78801983746],
						[520307.97369541292, 653125.82281555212],
						[520307.89785562118, 653187.21483956417],
						[520335.36417696392, 653187.24879270094],
						[520336.14909675514, 653218.00113774231],
						[520365.15841552796, 653218.03704957408],
						[520365.12018307653, 653248.89899746154],
						[520422.41862339852, 653248.97007998056],
						[520422.38042079157, 653279.72141607082],
						[520478.95866691304, 653279.7918011049],
						[520478.92035846354, 653310.54314170731],
						[520507.92951393314, 653310.57930548082],
						[520507.89101321693, 653341.44126700656],
						[520536.18003010063, 653341.47658233345],
						[520536.14258175442, 653371.45361746976],
						[520593.43990205153, 653372.0783779521],
						[520593.40151778987, 653402.7191157873],
						[520565.11260629905, 653402.68370198994],
						[520565.03580482816, 653464.07580803277],
						[520621.51054807461, 653464.14655499859],
						[520621.47183373565, 653495.00853948435],
						[520678.76941623754, 653495.08051551168],
						[520678.73073347262, 653525.83188807557],
						[520707.73950903228, 653525.86840444524],
						[520707.70091133413, 653556.50916511007],
						[520735.9895581145, 653556.54482428345],
						[520735.95076815138, 653587.29620597931],
						[520764.2393619545, 653587.33191375772],
						[520764.20037934434, 653618.19391653826],
						[520793.2089919158, 653618.23058373644],
						[520793.17037459294, 653648.76074155187],
						[520821.45886262221, 653648.79654780368],
						[520821.38110255718, 653710.18872671155],
						[520877.85471931833, 653710.48158744618],
						[520878.63873727998, 653741.12342064502],
						[520907.64713292359, 653741.16028977779],
						[520907.60802137072, 653771.91169891728],
						[520964.08170706657, 653771.98362277076],
						[520964.04263093369, 653802.62441982131],
						[520993.15378431615, 653802.66157103609],
						[520993.07509971585, 653864.27502874855],
						[521021.26035099651, 653864.31104746042],
						[521021.22130950476, 653894.84124161629],
						[521050.33229958086, 653894.87849408586],
						[521050.29277906101, 653925.74054276932],
						[521106.76593628398, 653925.81295679987],
						[521106.6871092745, 653987.20521783491],
						[521135.69507066789, 653987.24248939811],
						[521135.57659649069, 654079.38622388372],
						[521163.86434347858, 654079.42261936108],
						[521163.82460933487, 654110.28469576861],
						[521192.83235353581, 654110.32206815598],
						[521192.79299275629, 654140.85229882249],
						[521221.08063397161, 654140.88879276172],
						[521221.04079224356, 654171.75087835209],
						[521249.22551632748, 654171.78728793515],
						[521249.14615599538, 654233.17962255469],
						[521306.44116560015, 654233.25378633803],
						[521306.40130674432, 654264.00526889774],
						[521335.51164306275, 654264.04302639503],
						[521335.43195999134, 654325.43538846401],
						[521391.90374408307, 654325.50878207292],
						[521391.86358115292, 654356.3708952883],
						[521449.15816137503, 654356.44555651117],
						[521449.07805337058, 654417.83794594463],
						[521505.54952002229, 654417.911729977],
						[521506.33247543534, 654448.44308270304],
						[521535.33962290676, 654448.48105950363],
						[521535.25890271238, 654510.09471031057],
						[521563.54590851458, 654510.13179357455],
						[521563.46566270699, 654571.30299490155],
						[521620.75949377846, 654571.37825424399],
						[521620.71831853961, 654602.68287240737],
						[521678.01204023883, 654602.75833130232],
						[521677.97177704878, 654633.28863481386],
						[521706.15570978785, 654633.32582783862],
						[521706.11524816992, 654663.96675293916],
						[521733.57910217176, 654664.00304219918],
						[521734.36162109295, 654694.5344428079],
						[521763.36833429855, 654694.5728219992],
						[521763.32747295767, 654725.4349904136],
						[521791.61410819559, 654725.47246615472],
						[521791.53242592781, 654787.08619982528],
						[521848.82550488703, 654787.16225409217],
						[521848.74360783712, 654848.7760062333],
						[521877.03003082378, 654848.81362895924],
						[521876.98939733213, 654879.34396903508],
						[521934.17929520155, 654879.4201839054],
						[521934.09737293539, 654940.81272924307],
						[521963.20651068725, 654940.85159833124],
						[521963.16497787082, 654971.93503823108],
						[521991.34832996828, 654971.97272024606],
						[521991.30777980277, 655002.28184410627],
						[522019.59393863031, 655002.31971216307],
						[522019.5525953836, 655033.18192682299],
						[522048.55871099408, 655033.2208092775],
						[522048.47606393602, 655094.83463528357],
						[522076.76206349029, 655094.87260172016],
						[522076.72105836263, 655125.40297841118],
						[522105.72701123764, 655125.44196174387],
						[522105.6858034624, 655156.08296030422],
						[522133.97169761756, 655156.12102518301],
						[522133.93028815248, 655186.87264567229],
						[522162.93613255356, 655186.91172995942],
						[522162.89451966737, 655217.77397241432],
						[522191.18030766159, 655217.81213575229],
						[522191.13908968301, 655248.34253070713],
						[522219.42482507206, 655248.38074264443],
						[522219.38310595212, 655279.24299433606],
						[522248.38878735551, 655279.2822294177],
						[522248.34716349433, 655310.03386834636],
						[522272.62137621833, 655310.06674265838],
						[522276.59096602409, 655340.9344396966],
						[522305.59653855953, 655340.97377572721],
						[522305.55510772712, 655371.50418899662],
						[522333.73777472414, 655371.54245807044],
						[522333.69614123803, 655402.18349335087],
						[522361.98161189124, 655402.22195060761],
						[522361.89808894583, 655463.61465248128],
						[522390.90344499471, 655463.65413905156],
						[522390.86140331207, 655494.51642319455],
						[522419.14671507821, 655494.55497881991],
						[522419.10477115866, 655525.30665008386],
						[522448.11001834128, 655525.34623760299],
						[522448.06802014937, 655556.09791347827],
						[522471.62188243103, 655556.1300983862],
						[522476.31102356, 655586.99886560463],
						[522676.36419243994, 655587.27364436747],
						[522676.32191964297, 655617.9147114763],
						[522761.89720202587, 655618.03299512132],
						[522761.76990501728, 655709.95622373],
						[522790.05484603852, 655709.99541763624],
						[522789.96941575204, 655771.60944618029],
						[522761.68458075653, 655771.57025242411],
						[522761.59986921196, 655832.74182917969],
						[522733.31513941602, 655832.7026842382],
						[522733.22961514117, 655894.53798610601],
						[522704.22501945414, 655894.49789544824],
						[522704.18269386527, 655925.13900921051],
						[522676.72094695148, 655925.10109827877],
						[522675.85600281542, 655955.6304638125],
						[522704.14052107139, 655955.66950987559],
						[522704.01278024737, 656048.14598218305],
						[522761.30146378221, 656048.2252168901],
						[522761.04640960519, 656232.40396277467],
						[522732.76236756967, 656232.36481879058],
						[522732.71983484185, 656263.11660188285],
						[522761.00382396224, 656263.15574579895],
						[522760.96108512417, 656294.01815147733],
						[522789.245021065, 656294.05734398996],
						[522789.22845643898, 656306.0040829198],
						[522789.92233587237, 656324.81013463391],
						[522818.20621882484, 656324.84937698382],
						[522817.99290808354, 656478.49779110588],
						[522846.27652656287, 656478.53708175756],
						[522846.148442898, 656570.68193922902],
						[522875.15184535843, 656570.72228032723],
						[522875.02344507637, 656662.97779804782],
						[522903.30674609361, 656663.01718684437],
						[522903.1356422432, 656785.80337311001],
						[522932.13866508665, 656785.84381477477],
						[522932.05300478602, 656847.23693596595],
						[522903.77002078027, 656847.19749769766],
						[522902.87867797521, 656970.20403023669],
						[522988.34407342417, 656970.32334954559],
						[522988.21518911206, 657062.46843194554],
						[523017.32056960854, 657062.50916777272],
						[523017.148609469, 657185.29559771775],
						[523044.60825086862, 657185.33407743031],
						[523045.2417709704, 657246.94956692087],
						[523017.06231952447, 657246.9100779033],
						[523017.01940692111, 657277.55139737879],
						[523045.19880583102, 657277.59088632546],
						[523045.15568557224, 657308.34282893629],
						[523074.1577863181, 657308.38352121157],
						[523074.02826270636, 657400.63937720726],
						[523102.31029432255, 657400.67910845974],
						[523102.26737784047, 657431.20983270509],
						[523130.54935685085, 657431.24961255118],
						[523130.3762352292, 657554.25750504539],
						[523159.37790201872, 657554.29834770155],
						[523159.33441144915, 657585.16095125559],
						[523187.61612553167, 657585.20082930592],
						[523187.52919422468, 657646.81543188216],
						[523216.53069768031, 657646.85637539381],
						[523216.48772458534, 657677.27651825419],
						[523244.76928014826, 657677.31649465894],
						[523244.72609823802, 657707.84726081626],
						[523272.18486656481, 657707.88612075825],
						[523272.81719430984, 657769.72301767825],
						[523301.92132232373, 657769.76425751066],
						[523301.83427510201, 657831.15767885768],
						[523330.01272480364, 657831.19765613764],
						[523329.96954113152, 657861.61782679579],
						[523387.25190380937, 657861.69924326811],
						[523387.20751217654, 657892.89375021518],
						[523444.48976584052, 657892.97536618623],
						[523444.44621229323, 657923.50616479781],
						[523492.3698756597, 657923.57460000832],
						[523501.728359256, 657923.5879802733],
						[523501.68454110116, 657954.22940226959],
						[523701.81173841702, 657954.51680908375],
						[523701.76722804795, 657985.37947301159],
						[523815.50836963439, 657985.54390515515],
						[523815.55309360201, 657954.68124153884],
						[523844.55405378086, 657954.72329329897]
					]
				]
			]
		}
	}, {
		"type": "Feature",
		"properties": {
			"name": "Sham Shui Po",
			"ID_0": 102,
			"ID_1": 10,
			"ISO": "HKG"
		},
		"geometry": {
			"type": "MultiPolygon",
			"coordinates": [
				[
					[
						[517769.61485989066, 648961.2046574736],
						[517813.03320319351, 648774.97746995394],
						[517711.11723156186, 648627.64011693152],
						[517683.6852830319, 648588.56386078056],
						[517683.83552253118, 648448.8586332195],
						[517813.48710390448, 648355.97231113981],
						[517943.86069783603, 648262.86661130982],
						[517962.75778256479, 648202.27089291287],
						[517987.23190316343, 648123.20882105664],
						[518006.954947069, 648060.40182325081],
						[518030.60372132098, 647983.66185183451],
						[518117.81330824894, 647844.05271563795],
						[518118.22388403834, 647471.39637042827],
						[518118.37768220232, 647331.80250438838],
						[518087.92301990901, 647232.99132220692],
						[518074.59077233647, 647191.38608507707],
						[518055.0043919374, 647128.53626471909],
						[518031.62504612788, 647052.18752181681],
						[517945.33434477332, 646912.38876451505],
						[517902.36739262397, 646772.63765858999],
						[517863.02515690489, 646800.69058433198],
						[517829.2446273815, 646824.65695417172],
						[517771.87956746062, 646865.52168935048],
						[517642.31628444418, 646865.38218644052],
						[517577.99773607135, 646865.3133127453],
						[517512.03263258893, 646865.24293717742],
						[517382.46934738185, 646865.10548143426],
						[517252.18569333741, 646864.96829071315],
						[517122.62240597984, 646864.83288213401],
						[516992.23584010464, 646864.69764362986],
						[516861.95218284277, 646864.56354440679],
						[516732.38889230334, 646864.43121022603],
						[516602.00232325838, 646864.2990656558],
						[516515.75452056521, 646771.18667041219],
						[516640.72748905024, 646630.17051109707],
						[516472.82169719797, 646584.87140274723],
						[516423.35664585448, 646549.42580534657],
						[516342.52535249176, 646491.71597937145],
						[516256.27434235095, 646398.38388352236],
						[516198.170122954, 646356.29369148263],
						[516122.06795359077, 646301.79743161681],
						[516048.9382028309, 646470.07857809181],
						[516039.4494642588, 646491.41759998887],
						[515822.53754049394, 646677.47959690273],
						[515649.20709014824, 646491.04163071793],
						[515658.70416909439, 646460.41091407859],
						[515666.54773038859, 646437.07907801424],
						[515646.23759132967, 646367.15245296853],
						[515646.29641695513, 646305.31997271348],
						[515613.26527598948, 646301.08529650699],
						[515599.16774019104, 646299.41272764944],
						[515599.96103819669, 646331.0487279878],
						[515582.67238432978, 646330.25804846722],
						[515570.83738635934, 646330.24683899456],
						[515570.80848189571, 646360.77593627432],
						[515542.61036513111, 646360.74926286796],
						[515542.55213819974, 646422.3605342973],
						[515513.42791497853, 646422.33303561376],
						[515513.39890823094, 646453.08337174915],
						[515460.81074472709, 646453.03384938743],
						[515449.77034925018, 646483.66322900332],
						[515399.54926105007, 646483.6161263223],
						[515399.52036353591, 646514.47708434402],
						[515342.19845017756, 646514.42350917531],
						[515342.16996979475, 646544.95263346832],
						[515313.14887536288, 646544.925585469],
						[515313.12013986765, 646575.78655260825],
						[515287.18644453119, 646575.76242543128],
						[515284.79110628919, 646606.2893586487],
						[515227.4695129419, 646606.23618336406],
						[515227.44093810994, 646637.09715961828],
						[515141.921809069, 646637.01819783868],
						[515141.89349655638, 646667.76856590726],
						[515084.57211749436, 646667.71588869672],
						[515084.54381069989, 646698.57687419606],
						[515056.24336240708, 646698.55094031687],
						[515056.21541252034, 646729.08009174769],
						[515027.19464300707, 646729.05354835698],
						[515027.16644377034, 646759.91454293148],
						[514826.90292655968, 646759.73277109093],
						[514826.95827424084, 646698.34262435767],
						[514798.76073626982, 646698.3172263545],
						[514798.78850677947, 646667.45624036796],
						[514770.48800493195, 646667.43079822953],
						[514770.51562298357, 646636.6804295266],
						[514741.49469041888, 646636.6543902969],
						[514741.54971883242, 646575.26427903166],
						[514713.24905833794, 646575.238935392],
						[514713.2764702398, 646544.59919278999],
						[514684.25557271094, 646544.35202900588],
						[514684.28194289352, 646514.81841848651],
						[514713.30398109643, 646513.84884186368],
						[514713.35900279495, 646452.34815343376],
						[514739.29289274814, 646452.37137573014],
						[514770.68123186886, 646452.28892405285],
						[514770.70875054819, 646421.64919937192],
						[514799.00967534853, 646421.67464188987],
						[514799.03734628338, 646390.9243089977],
						[514856.35969010269, 646390.97599098063],
						[514856.38756813906, 646360.11504996498],
						[514911.3430240525, 646360.1647855544],
						[514913.73770401976, 646329.63783343602],
						[514970.23695721693, 646329.68916575739],
						[514970.26504882792, 646298.82823389908],
						[514999.28657754022, 646298.85467682814],
						[514999.31452184432, 646268.21497478429],
						[515027.61571067997, 646268.24081069708],
						[515027.64360662998, 646237.71172575839],
						[515056.66524319415, 646237.73826994502],
						[515056.69359808619, 646206.76673904143],
						[515084.9948926635, 646206.79267369956],
						[515085.05130319949, 646145.29207587161],
						[515027.72810304514, 646145.23959678598],
						[515027.7557968382, 646114.93175468524],
						[514999.45434418105, 646114.9059185317],
						[514999.51073714782, 646053.07350949594],
						[514970.48877471877, 646053.04706617317],
						[514970.51666492084, 646022.40739963693],
						[514914.01635607745, 646022.35606635548],
						[514914.04404070677, 645991.82701664697],
						[514884.91905505484, 645991.80063099309],
						[514884.94728628104, 645960.6079107793],
						[514856.74848339718, 645960.58241334278],
						[514856.77596169361, 645930.16398488602],
						[514827.65086684085, 645930.13770065119],
						[514827.67869016214, 645899.27682673384],
						[514799.47978211939, 645899.25142749015],
						[514799.53522338817, 645837.64030544192],
						[514771.23329355626, 645837.61486202315],
						[514771.26071280922, 645807.08583864802],
						[514742.23831630067, 645807.05979810678],
						[514742.26578082528, 645776.42016670166],
						[514771.28823140473, 645776.44620728819],
						[514771.39870312379, 645653.44527681579],
						[514799.70094988745, 645653.47072052059],
						[514799.72862072207, 645622.72049908573],
						[514771.42632104584, 645622.69505532715],
						[514771.45403830771, 645591.83422601246],
						[514742.43126194994, 645591.80818512861],
						[514742.51306053827, 645500.55307075405],
						[514714.21114438394, 645499.86405204621],
						[514714.23835822765, 645469.44568934222],
						[514599.5876391778, 645468.90106703981],
						[514599.56024462532, 645499.76187881303],
						[514571.36065158108, 645499.73687070108],
						[514571.30626229325, 645561.12667098187],
						[514513.98102603795, 645561.07598255551],
						[514513.92685070593, 645622.46580075729],
						[514456.60182824975, 645622.41531233373],
						[514456.57479895366, 645653.16553433798],
						[514428.27255166665, 645653.14068109926],
						[514428.24547824438, 645684.00151994231],
						[514399.22286453674, 645683.9760847009],
						[514399.19632977666, 645714.28386632865],
						[514370.89418766904, 645714.25911182957],
						[514370.8668351979, 645745.56240911444],
						[514027.74260565889, 645745.26616965327],
						[514027.71656667365, 645775.79518543754],
						[513741.91745681944, 645775.55390268075],
						[513741.94278044713, 645745.2461111875],
						[513656.31609703478, 645745.17478868831],
						[513656.34190578677, 645714.09271491552],
						[513633.59727495705, 645714.07384477742],
						[513570.67796744721, 645883.70134273497],
						[513440.16954561189, 646023.18721548875],
						[513423.64573384781, 646093.52333940729],
						[513511.56039341161, 646187.61608585599],
						[513627.63325301325, 646328.85368006979],
						[513874.7932001783, 646495.09014784824],
						[514121.94083716522, 646669.84764975333],
						[514299.20024901489, 646852.84407588525],
						[514364.35547123017, 646955.43915992696],
						[514383.88179081515, 646985.65360082127],
						[514415.24820191605, 647126.82342709857],
						[514407.20043706766, 647268.18005748279],
						[514392.26224880299, 647287.19245660724],
						[514392.22643075802, 647328.1193344607],
						[514392.10426211852, 647467.71323176241],
						[514262.50523926754, 647514.27916029806],
						[514132.22672817734, 647514.16668640717],
						[513935.1111983775, 647574.50399635674],
						[513935.0262768133, 647674.71969411592],
						[513942.76233945752, 647774.61022843048],
						[513898.74913440691, 647861.18336714967],
						[513915.15293911664, 647932.98545040796],
						[513525.69111736817, 648026.12900838675],
						[513438.38090929872, 648211.88842598756],
						[513568.71827741934, 648258.67445976555],
						[513698.30946824362, 648212.10289793252],
						[513785.24662322307, 648352.10197787837],
						[513871.60446289834, 648445.20083953021],
						[514001.87559819594, 648445.31124870724],
						[514131.46645362891, 648398.85367269872],
						[514304.99640450248, 648352.54590646375],
						[514434.62982374395, 648259.41175992275],
						[514564.86118424183, 648306.09499551053],
						[514694.3298898536, 648399.34701559017],
						[514911.16413493233, 648259.83696738025],
						[515041.35144520964, 648353.20296584081],
						[515110.43208546814, 648427.70941540471],
						[515170.77411757695, 648493.02716415096],
						[515080.50154008088, 648525.35400239611],
						[515063.15548724309, 648589.71541133453],
						[515056.78132067475, 648696.00960444543],
						[515127.40228617628, 648772.28748393082],
						[515257.67083020112, 648772.40784171899],
						[515387.21908906894, 648772.52855749056],
						[515474.28551753785, 648866.07915193937],
						[515517.26779791294, 649005.60407973803],
						[515690.94280927826, 648912.52116488933],
						[515906.73023021402, 649005.97622073966],
						[516167.50365405099, 648866.7461242046],
						[516296.99475487025, 648819.97357810976],
						[516470.34940916917, 649053.09968067706],
						[516599.79256062122, 649053.22984647308],
						[516730.01940697851, 649193.28884292953],
						[516859.66018587525, 649099.95221218013],
						[516990.07048424659, 648960.38071676658],
						[517120.440434672, 648960.5159380351],
						[517250.03606431343, 648914.08282544208],
						[517466.53489718877, 649007.55910596461],
						[517596.9544273786, 648961.01897751389],
						[517769.61485989066, 648961.2046574736]
					]
				]
			]
		}
	}, {
		"type": "Feature",
		"properties": {
			"name": "Southern",
			"ID_0": 102,
			"ID_1": 11,
			"ISO": "HKG"
		},
		"geometry": {
			"type": "MultiPolygon",
			"coordinates": [
				[
					[
						[519014.72657671047, 634658.22952880047],
						[519014.7619750055, 634627.59146759263],
						[519043.90708562738, 634627.62516683619],
						[519043.94241018593, 634597.09771654755],
						[519100.48196977272, 634597.16323800245],
						[519100.51778430439, 634566.30397192016],
						[519157.88134280266, 634566.37064677873],
						[519157.91713613761, 634535.62199170329],
						[519215.28080157493, 634535.68886663276],
						[519215.24490107084, 634566.43752158363],
						[519243.46324023651, 634566.47049207182],
						[519243.49919346458, 634535.72183718055],
						[519272.64446678018, 634535.75594149437],
						[519272.68060398183, 634504.896684204],
						[519300.89904866734, 634504.92975317128],
						[519300.95858722663, 634454.16130690742],
						[519301.00710011821, 634412.7944331934],
						[519330.15259112685, 634412.82863935409],
						[519330.22443106049, 634351.66319570341],
						[519358.443138476, 634351.69636333094],
						[519358.55190128833, 634259.22928662202],
						[519330.33303532837, 634259.19611880765],
						[519330.3688903185, 634228.66871894524],
						[519273.00415475934, 634228.60144287976],
						[519272.96840617381, 634259.12884286686],
						[519215.6037767838, 634259.0617668723],
						[519215.63941896614, 634228.53436676064],
						[519158.2746829394, 634228.46749058773],
						[519158.31060497375, 634197.60827496857],
						[519129.98864440725, 634197.57533077407],
						[519130.0243847688, 634166.82672579074],
						[519015.2944823209, 634166.69377021049],
						[519015.25895630906, 634197.44237544318],
						[518987.03998440778, 634197.40979622817],
						[518987.00438351056, 634228.26901222125],
						[518957.85856566671, 634228.23541374819],
						[518957.78785537096, 634289.62203884032],
						[518929.56904152012, 634289.58955816668],
						[518929.53392981878, 634320.11696717795],
						[518900.38827462541, 634320.08347048087],
						[518900.31752422155, 634381.69133395259],
						[518872.09886823321, 634381.65895181196],
						[518871.9930912907, 634473.90486872487],
						[518843.67160619295, 634473.87241723982],
						[518843.49582904269, 634627.39448266104],
						[518871.81704995496, 634627.42693384585],
						[518871.78191776946, 634658.06499535963],
						[519014.72657671047, 634658.22952880047]
					]
				],
				[
					[
						[526651.19633052195, 635652.12207048992],
						[526651.24576913007, 635621.59450230002],
						[526680.2861394129, 635621.64155810385],
						[526680.48554381263, 635498.64647069818],
						[526651.44495648379, 635498.59941454313],
						[526651.4952906809, 635467.51883198461],
						[526623.17551542877, 635467.47299315617],
						[526623.22490146034, 635436.94544997683],
						[526565.86437730701, 635436.85275465925],
						[526565.81509767659, 635467.38029801415],
						[526422.77448539913, 635467.15001355298],
						[526422.72458316595, 635498.23059680837],
						[526365.36427262053, 635498.13860033825],
						[526365.31536472379, 635528.66615265794],
						[526337.09867531888, 635528.62097111333],
						[526337.04928871605, 635559.48034895607],
						[526308.00880874088, 635559.43389884569],
						[526307.9596534064, 635590.18267390982],
						[526337.0000791233, 635590.22912393231],
						[526336.95069251081, 635621.08851024136],
						[526365.16722337436, 635621.13369153661],
						[526365.11831545201, 635651.66126057901],
						[526479.83786601422, 635651.84545173496],
						[526479.88698674552, 635621.31788303237],
						[526565.56637829589, 635621.4559696269],
						[526565.51709862752, 635651.98353806895],
						[526651.19633052195, 635652.12207048992]
					]
				],
				[
					[
						[519270.0180950028, 636778.53845998913],
						[519270.05423256423, 636747.67889434856],
						[519298.26883179339, 636747.7119588065],
						[519298.30463312141, 636717.18422071706],
						[519355.66069472471, 636717.2515849513],
						[519355.69699274865, 636686.3920279867],
						[519413.05316167901, 636686.45959226345],
						[519413.07129922719, 636671.08511930436],
						[519413.08891482995, 636656.15307823278],
						[519439.03825261677, 636656.18371165183],
						[519441.44336458744, 636625.10574589903],
						[519457.91916570324, 636625.12521933427],
						[519470.4819640381, 636625.14007891715],
						[519470.50565176725, 636605.12008754746],
						[519470.51808455429, 636594.61235799245],
						[519498.83618230798, 636594.42467282875],
						[519498.87746675988, 636559.58325742197],
						[519498.94548780099, 636502.17788960482],
						[519470.62749304634, 636502.14435922122],
						[519470.65445255046, 636479.3591883718],
						[519441.6247431793, 636471.58232178038],
						[519441.6612018313, 636440.72279897798],
						[519413.34310132317, 636440.68936717813],
						[519413.3699814009, 636417.904202495],
						[519384.3401365928, 636410.12743908167],
						[519384.37648767396, 636379.26792463497],
						[519356.05828141537, 636379.23459141329],
						[519356.09444928408, 636348.4856887128],
						[519327.87916554534, 636348.45252510463],
						[519327.91515077662, 636317.81423411903],
						[519298.77303331863, 636317.7800319182],
						[519298.73710234626, 636348.41832296888],
						[519155.80712368025, 636348.251322667],
						[519155.84278854227, 636317.61303130188],
						[519098.4853339991, 636317.5463635386],
						[519098.52102043509, 636286.79746872094],
						[519041.98726547824, 636286.73195399297],
						[519042.05829907517, 636225.34478429507],
						[518898.20046511758, 636225.17894905515],
						[518898.16540717188, 636255.70662083384],
						[518869.94971068786, 636255.8954574212],
						[518869.89618762094, 636302.57183333533],
						[518869.8793189734, 636317.28263629624],
						[518841.56100605091, 636317.25018844241],
						[518841.53783063445, 636337.49137007678],
						[518841.525926325, 636347.88848048158],
						[518812.48683762166, 636347.8552573577],
						[518812.45434089046, 636376.28140215867],
						[518784.13347811293, 636378.57181220711],
						[518784.09825265472, 636409.43132796232],
						[518726.7411181503, 636409.36595591123],
						[518726.70637785888, 636439.89365323307],
						[518698.38827593025, 636439.86145175504],
						[518698.31852336426, 636501.24868194305],
						[518669.27970529231, 636501.21571152844],
						[518669.20981006237, 636562.82417404314],
						[518698.24851941818, 636562.85714433587],
						[518698.14345062518, 636655.32517365238],
						[518726.46118177613, 636655.35737470828],
						[518726.42669319216, 636685.66389019764],
						[518869.45671462396, 636685.82727914583],
						[518869.49146662891, 636655.52076395112],
						[518897.70622387726, 636655.55314161372],
						[518897.67141990911, 636685.85965674615],
						[518955.02759069914, 636685.92562457151],
						[518954.99204405578, 636716.78518240573],
						[518984.13345490728, 636716.8187758032],
						[518984.09823641949, 636747.34651457239],
						[519097.98636521306, 636747.47829653369],
						[519098.0217949801, 636716.95055800816],
						[519155.37785740034, 636717.01722415397],
						[519155.30639878806, 636778.40452845045],
						[519270.0180950028, 636778.53845998913]
					]
				],
				[
					[
						[516236.49886247225, 637758.35089457652],
						[516236.52898571902, 637727.8230111989],
						[516322.91817820829, 637727.90848227101],
						[516323.00968709198, 637635.66120849317],
						[516351.32573123602, 637635.68932229653],
						[516351.47829070187, 637482.16516773996],
						[516379.79459899053, 637482.19333053636],
						[516380.54609796137, 637451.33437854284],
						[516408.86245930375, 637451.36259136349],
						[516408.8929017245, 637420.83475053788],
						[516437.20931555593, 637420.86301213619],
						[516437.27085789491, 637359.25430276699],
						[516466.30816183402, 637359.28333446616],
						[516466.3388213297, 637328.64489833685],
						[516494.6553938032, 637328.67325879377],
						[516494.68621689326, 637297.92421888607],
						[516523.72362906119, 637297.95335190243],
						[516523.75461747538, 637267.09370827291],
						[516552.07129587035, 637267.12216752896],
						[516552.10200360889, 637236.59435228887],
						[516580.31576455623, 637236.62275657535],
						[516580.37773050327, 637175.12470682082],
						[516609.51832968229, 637175.15409498801],
						[516609.54914381017, 637144.62629248283],
						[516637.76306244894, 637144.65479526529],
						[516638.04276170523, 636868.02442835737],
						[516609.82836876001, 636867.99592509633],
						[516609.92159252713, 636775.63840190344],
						[516580.78028584347, 636775.6090130196],
						[516580.84214021289, 636714.22169829404],
						[516552.62748356303, 636714.19329310965],
						[516552.68901014054, 636653.02721062582],
						[516495.33272469771, 636652.96961614699],
						[516495.42541542434, 636560.5015735944],
						[516467.10752104688, 636560.47321181477],
						[516467.23060129973, 636437.47750142054],
						[516495.54870733805, 636437.50586340704],
						[516495.57930855674, 636406.97816165816],
						[516524.61829292978, 636407.00729625206],
						[516524.64928122668, 636376.14777595084],
						[516581.18272901594, 636376.20464251831],
						[516581.21371186874, 636345.45573416143],
						[516638.57106915046, 636345.51362797758],
						[516638.69520556653, 636222.73925228941],
						[516667.73451505415, 636222.76863943704],
						[516667.91084982816, 636048.67247837479],
						[516667.92126858816, 636038.38598770648],
						[516696.24006140325, 636038.41469505487],
						[516696.26026100287, 636018.50535965455],
						[516696.27137078228, 636007.55522594182],
						[516724.59021664975, 636007.5839820765],
						[516724.68362961186, 635915.66924457962],
						[516696.36462557572, 635915.64048828348],
						[516696.42713207641, 635854.03219545865],
						[516581.70899119659, 635853.91620444157],
						[516581.67800840526, 635884.66504527826],
						[516553.46192940441, 635884.63663866068],
						[516553.43088807637, 635915.49609113589],
						[516525.11188373854, 635915.46762953745],
						[516525.08122871513, 635945.99526417686],
						[516496.04143081274, 635945.96612876712],
						[516496.0104970368, 635976.825589802],
						[516467.69159823784, 635976.79722701968],
						[516467.66104961274, 636007.32487012527],
						[516438.62135993969, 636007.2958360468],
						[516438.59053371201, 636038.15530564706],
						[516410.27174045355, 636038.12704167515],
						[516410.21052509249, 636099.51417137298],
						[516381.17099810019, 636099.48523866828],
						[516381.1096708448, 636161.09360027942],
						[516352.79108914454, 636161.06543522258],
						[516352.73008771474, 636222.45259886468],
						[516324.41161160532, 636222.42448264512],
						[516324.25931719091, 636375.94776951987],
						[516295.22027800628, 636375.91898849339],
						[516295.09870294435, 636498.69345105882],
						[516237.74187957158, 636498.63675441057],
						[516237.71142906341, 636529.49629220797],
						[516181.1785079054, 636529.44060560968],
						[516181.20885239495, 636498.5810677103],
						[516066.49520467274, 636498.46866826212],
						[516066.4650753063, 636529.32820637967],
						[516009.10835871496, 636529.27230663295],
						[516009.07844450913, 636560.0212414253],
						[515980.7605493032, 636559.99371657544],
						[515980.730795421, 636590.63204795471],
						[515923.37429250334, 636590.57644703542],
						[515923.34453838028, 636621.32539043843],
						[515808.73472009413, 636621.21488748433],
						[515808.64610017184, 636713.46174373478],
						[515780.32846901659, 636713.43456379941],
						[515780.26960094005, 636774.82188145944],
						[515751.95207537629, 636774.79475035565],
						[515751.20183281909, 636805.54302950401],
						[515722.88436011784, 636805.51594842155],
						[515722.85487452865, 636836.37552966608],
						[515694.53745488945, 636836.3484973642],
						[515694.47088893433, 636906.14204643317],
						[515694.42056885548, 636958.90200215613],
						[515637.06534954417, 636958.84739916958],
						[515637.09435916285, 636928.31962442538],
						[515551.52474360168, 636928.23853254458],
						[515551.55348993704, 636897.82136968803],
						[515494.1980577301, 636897.7672646651],
						[515494.22711462667, 636866.90767448978],
						[515408.55420747743, 636866.82722910971],
						[515408.43924395269, 636989.60196863592],
						[515208.15972172102, 636989.41564980044],
						[515208.1029870889, 637050.80304563069],
						[515178.96216769767, 637050.77613924304],
						[515178.93370168761, 637081.63575548271],
						[515150.71967499913, 637081.60975399264],
						[515150.60663359729, 637204.38461385039],
						[515122.28984724788, 637204.35856630164],
						[515122.17681376275, 637327.35471025784],
						[515093.13945348281, 637327.32805048407],
						[515093.08314669266, 637388.71553997532],
						[515035.72942549968, 637388.66303294466],
						[515035.70122748072, 637419.52269632777],
						[515007.38481135003, 637419.49684651033],
						[515007.35696906451, 637450.02468981722],
						[514978.31982525188, 637449.9982326607],
						[514978.29173478775, 637480.85790466866],
						[514949.97542420443, 637480.83215364185],
						[514949.91321943566, 637549.29860981554],
						[514949.89171406388, 637572.96876274049],
						[515035.56094480283, 637573.04682015209],
						[515035.53294889716, 637603.68529272382],
						[515064.56982150173, 637603.7118508491],
						[515064.54167026503, 637634.460935827],
						[515092.85771647643, 637634.48688399873],
						[515092.82941086212, 637665.34658143646],
						[515150.18216767447, 637665.39928748435],
						[515150.15406001452, 637695.92716433888],
						[515521.65919496474, 637696.27341147559],
						[515521.68799186987, 637665.74553526123],
						[515579.04074728774, 637665.7997360921],
						[515579.06996476307, 637634.94003950688],
						[515750.40778050479, 637635.10315179452],
						[515751.09901241085, 637665.96353801026],
						[515807.73099635984, 637666.01784600737],
						[515807.70166876749, 637696.54572171473],
						[516093.64117074606, 637696.82290372439],
						[516093.61098810734, 637727.68260792037],
						[516150.96352764271, 637727.73880219203],
						[516150.93356314232, 637758.26668572542],
						[516236.49886247225, 637758.35089457652]
					]
				],
				[
					[
						[513848.22634514002, 640767.39051891491],
						[513921.26063230605, 640715.13368715171],
						[514094.99081736786, 640529.0146839791],
						[514118.6314252271, 640453.04605694313],
						[514130.50295331841, 640415.44894398854],
						[514138.34958915471, 640389.35179497325],
						[514151.75195402943, 640367.46259888983],
						[514229.58985962055, 640239.88619581121],
						[514312.20719367289, 640063.53558137571],
						[514441.90591350838, 639970.40510224563],
						[514450.57804413518, 639942.98156560387],
						[514462.34881327301, 639904.16798633942],
						[514485.98977065005, 639830.744118931],
						[514506.50652167492, 639797.91120151174],
						[514572.49155951617, 639691.23146734666],
						[514606.30956020841, 639636.17800704355],
						[514659.09786761779, 639551.60884191177],
						[514630.04438978591, 639458.33938000794],
						[514615.98087956157, 639411.64979014802],
						[514702.44435645471, 639318.70450321655],
						[514832.97481181793, 639225.57815965218],
						[514919.44049143925, 639132.63409186853],
						[514919.56716765265, 638992.93499727082],
						[514895.2381954455, 638913.05327185232],
						[514880.45465061354, 638865.92048382503],
						[514876.45062176051, 638853.30744490901],
						[515006.98575055023, 638760.18267898005],
						[515310.07422763098, 638900.0503677536],
						[515569.87064769946, 639086.67033126834],
						[515612.98048548657, 639226.52106619114],
						[515634.8439998423, 639296.44680283836],
						[515655.98673682759, 639366.26129586552],
						[515743.10197091999, 639459.36677125981],
						[515915.96512976236, 639459.53308533574],
						[515980.36614344176, 639404.51211650646],
						[516132.87019151991, 639273.47846010257],
						[516182.4056519029, 639260.25400891714],
						[516251.50789568387, 639242.18222118006],
						[516306.50226470473, 639226.97257400863],
						[516523.23706543643, 639320.43231802364],
						[516534.2574543184, 639316.46145895624],
						[516582.14958740433, 639299.47584560921],
						[516653.73057968961, 639273.99742891116],
						[516790.2419950568, 639384.63474137173],
						[516829.53765778942, 639417.6364356972],
						[516902.61343123578, 639340.06368500134],
						[516916.83727325621, 639324.70362751512],
						[517046.40536784625, 639278.1602902601],
						[517176.90069780324, 639231.72955963365],
						[517393.82753408857, 639138.82458866225],
						[517523.44780400669, 639045.93990675313],
						[517913.96836236014, 638953.11705806083],
						[518087.60874564532, 638906.74064565101],
						[518217.18317147478, 638953.44998370321],
						[518260.27098825993, 639093.19695788063],
						[518433.8587023252, 639093.39052621287],
						[518607.65706697223, 638907.3205649287],
						[518954.16921504121, 638861.26032715163],
						[519127.81351103738, 638814.8949122245],
						[519517.96948313649, 638954.94163433043],
						[519821.07192944409, 639048.5474010366],
						[520124.2281588593, 639095.37121321564],
						[520254.61899787106, 639142.09764306783],
						[520289.19774798595, 639154.41785887862],
						[520384.1852984521, 639188.93470459548],
						[520388.07000500598, 639211.28256401513],
						[520443.89871060679, 639190.66793033481],
						[520458.73135909939, 639185.26651983068],
						[520500.44853673223, 639169.83316810394],
						[520511.44572007353, 639185.33215217362],
						[520627.68500359397, 639185.47747343709],
						[520640.96655142255, 639185.49413017393],
						[520814.59761875687, 639232.05810431438],
						[520988.06492307165, 639325.52201162209],
						[521204.90928186529, 639232.55651211343],
						[521421.61624823092, 639326.08077809587],
						[521594.35871614882, 639419.32896069798],
						[521811.01978831657, 639466.29186684173],
						[521941.46501167218, 639466.46531090164],
						[522071.08658584708, 639466.63868425763],
						[522158.37548321183, 639327.0565258495],
						[522244.98530339036, 639233.92984612868],
						[522375.39243840484, 639187.76143824053],
						[522548.32241902442, 639141.32046595088],
						[522678.73144667241, 639094.93326412234],
						[522808.35594788421, 639095.11244593805],
						[522938.70115577435, 639095.29365375638],
						[523068.32565413753, 639095.47488370468],
						[523372.36150526843, 639095.90396753501],
						[523502.05235661415, 639049.6328863739],
						[523675.84186950355, 638909.96159142],
						[523762.42645022681, 638770.49787007994],
						[523979.2609072557, 638770.81245376472],
						[524152.71514699503, 638864.30952770007],
						[524326.09889576107, 639004.15356543614],
						[524498.86387798365, 639004.40990399173],
						[524672.62531564769, 638958.10313416843],
						[524846.28494129214, 638911.68744500284],
						[525106.61248467222, 638679.47194679419],
						[525409.90441976406, 638633.26057507936],
						[525453.36422721785, 638493.62875403464],
						[525540.68680858659, 638354.17577128182],
						[525584.14845597453, 638214.54447223991],
						[525677.03181462036, 638076.31772737927],
						[525766.02032130468, 637927.68828764511],
						[525761.48817383114, 637862.97519989579],
						[525732.34879270487, 637862.92960442102],
						[525732.39705264207, 637832.06990608538],
						[525675.04487669445, 637831.98031573975],
						[525675.09285647434, 637801.23122974788],
						[525561.21202048508, 637801.05392801785],
						[525561.16425352171, 637831.80301434116],
						[525503.81207664357, 637831.71402082336],
						[525503.76424540998, 637862.57371982746],
						[525418.19948792411, 637862.44132036704],
						[525418.29465857532, 637800.83253437968],
						[525389.15516740328, 637800.78754667169],
						[525389.20278350217, 637769.92785591295],
						[525418.34232932248, 637769.972843703],
						[525418.5319870715, 637647.19777278451],
						[525446.74504398927, 637647.24137936183],
						[525446.79259656125, 637616.49231825874],
						[525475.93241410586, 637616.53740804293],
						[525475.979849878, 637585.89895939687],
						[525504.19301189936, 637585.94266447867],
						[525504.2406716327, 637555.19361204864],
						[525532.55685423955, 637555.23752535321],
						[525532.65210789361, 637493.85004149855],
						[525561.6891743053, 637493.89512337162],
						[525561.73711301805, 637463.03547581914],
						[525590.05345421366, 637463.07948806719],
						[525590.10092998715, 637432.55166898062],
						[525619.13810456649, 637432.59685222746],
						[525619.18615082861, 637401.73721336783],
						[525675.71607521374, 637401.82532365061],
						[525675.76405489934, 637371.07629723963],
						[525733.11783732614, 637371.16589010041],
						[525733.16575120378, 637340.52747609536],
						[525818.83619196515, 637340.66167497868],
						[525818.88443890179, 637309.9126574758],
						[525847.92182989721, 637309.95824445307],
						[525848.11486088089, 637187.07282521296],
						[525876.43167696195, 637187.11733027524],
						[525876.52873298572, 637125.39812658227],
						[525848.21181069536, 637125.35362135293],
						[525848.25959061214, 637094.93645728973],
						[525819.22182017704, 637094.89086971758],
						[525819.31814038719, 637033.50351472863],
						[525848.35601914953, 637033.54910246783],
						[525848.453142641, 636971.71933336789],
						[525873.57821009599, 636971.75881957554],
						[525876.8181615409, 636941.34669601545],
						[525905.85637705855, 636941.28177743556],
						[525905.95284536551, 636880.0050730739],
						[525934.27018986456, 636880.04967766604],
						[525934.31865105359, 636849.30072414828],
						[525962.53307603579, 636849.34521509078],
						[525962.58176444925, 636818.48565817415],
						[526019.93747292855, 636818.57625074079],
						[526019.98609400273, 636787.82730596967],
						[526049.12737903406, 636787.87341082282],
						[526049.22455497237, 636726.4861418528],
						[526105.75679914095, 636726.5757295076],
						[526106.62954227196, 636695.71749693644],
						[526134.84423059004, 636695.76228332159],
						[526134.99056109076, 636603.62612121913],
						[526106.77571479953, 636603.58133458195],
						[526106.8731046227, 636542.19411666715],
						[526077.73138451821, 636542.1479095479],
						[526077.78028798488, 636511.28839548083],
						[526049.56528337102, 636511.24370693741],
						[526049.66245919291, 636449.85651403316],
						[526020.52057556575, 636449.8104082311],
						[526020.66626362782, 636357.67434649984],
						[525963.30894867273, 636357.58375139534],
						[525963.35728795722, 636326.94547740743],
						[525935.14196727367, 636326.90098505444],
						[525935.33581150824, 636203.90550106741],
						[525988.78055920242, 636203.98981833376],
						[525992.74188090931, 636173.4683532163],
						[526135.67337741039, 636173.69473632786],
						[526135.722388361, 636142.8352732989],
						[526164.04100141942, 636142.88027329405],
						[526164.08988960553, 636112.13142196869],
						[526393.52256959071, 636112.49780120386],
						[526393.47325270018, 636143.24665184086],
						[526650.4002964074, 636143.66073332669],
						[526650.35032030905, 636174.52019480639],
						[526707.70827332523, 636174.61318459222],
						[526707.65872819233, 636205.14082792448],
						[526793.23210377013, 636205.27993270662],
						[526793.33205177775, 636143.89282858861],
						[526822.37150038988, 636143.94013512472],
						[526822.52167498029, 636051.80420711101],
						[526793.4820637817, 636051.75690030586],
						[526793.58201172343, 635990.36983827827],
						[526765.26313621551, 635990.32375494333],
						[526765.31332719803, 635959.46431921935],
						[526737.09737643495, 635959.41845183971],
						[526737.14697538258, 635928.89084210317],
						[526679.78816590388, 635928.79774971143],
						[526679.8381964009, 635897.9383221789],
						[526593.43939615437, 635897.79847573955],
						[526593.38952766999, 635928.65790352982],
						[526536.75156418898, 635928.56647459138],
						[526536.70233698655, 635959.09408493119],
						[526393.76897653739, 635958.86421865737],
						[526393.86743283027, 635897.47717949341],
						[526364.72457098775, 635897.43046413735],
						[526364.82291854289, 635836.04344161414],
						[526078.85107944417, 635835.58777309849],
						[526078.80252668553, 635866.22597948124],
						[526021.44349879248, 635866.13518175099],
						[526021.39487792004, 635896.88399975805],
						[525993.17881985579, 635896.8394078922],
						[525993.13007699116, 635927.698837484],
						[525878.41244941566, 635927.51803916029],
						[525878.46097715653, 635896.65860923147],
						[525850.14194039244, 635896.61410067964],
						[525850.19024127536, 635865.86528216559],
						[525821.15030196216, 635865.81969119154],
						[525821.19698663836, 635836.06634196162],
						[525792.87923247169, 635835.13707403641],
						[525792.92742616904, 635804.38826377608],
						[525764.71120951802, 635804.34406363964],
						[525764.75952365366, 635773.48465030617],
						[525792.97579322103, 635773.5288505248],
						[525793.02364018653, 635743.00126309402],
						[525821.34294129768, 635743.04567335662],
						[525821.39136144216, 635712.18626863102],
						[525850.43157186604, 635712.23186003265],
						[525850.47987271193, 635681.48306679819],
						[525878.79927968374, 635681.52757593361],
						[525879.04087445571, 635527.89428045414],
						[525908.08141009056, 635527.93997358647],
						[525908.1294698125, 635497.41241992137],
						[525936.44919354317, 635497.4570282608],
						[525936.49817739229, 635466.37644354382],
						[525993.85859864461, 635466.46694520256],
						[525993.90681729175, 635435.93940015102],
						[526022.12366561196, 635435.9839932688],
						[526022.1721114883, 635405.34584542736],
						[526051.31584477087, 635405.3919541582],
						[526051.41372047248, 635343.56263620127],
						[526079.63072718086, 635343.60732791701],
						[526079.67875398404, 635313.30101378157],
						[526108.82265026821, 635313.34722434497],
						[526108.87160811725, 635282.48787956277],
						[526137.08871954237, 635282.53266979719],
						[526137.18656537787, 635220.92460003158],
						[526165.50676490425, 635220.96960254479],
						[526165.6036615941, 635160.0251912321],
						[526194.64484639047, 635160.0713900493],
						[526194.84096739488, 635036.8553351548],
						[526223.16148367641, 635036.90043688635],
						[526223.21047879895, 635006.15173719684],
						[526252.25193512952, 635006.19803766534],
						[526252.59492775728, 634791.17847134685],
						[526280.91586680594, 634791.22367246659],
						[526281.3576101372, 634514.59643590671],
						[526309.67902514536, 634514.64168651798],
						[526309.87529186253, 634391.86841173656],
						[526281.55366558151, 634391.82316078828],
						[526281.79882304813, 634238.30135741783],
						[526310.12071351812, 634238.34660879103],
						[526310.41546682757, 634053.9657338406],
						[526282.09325906739, 634053.92048196041],
						[526282.14253777708, 634023.06130991573],
						[526253.82027683523, 634023.01610669156],
						[526254.01541483658, 633900.68552302453],
						[526339.7044726446, 633900.38000854838],
						[526339.6554404255, 633931.01795110712],
						[526482.6064139175, 633931.24734745023],
						[526482.55693760817, 633961.99590003875],
						[526653.9329980046, 633962.27254719473],
						[526653.98279448657, 633931.52399513032],
						[526683.02614715847, 633931.5710557662],
						[526683.22519142367, 633808.79810201307],
						[526711.54782100418, 633808.84404417826],
						[526711.59790413466, 633777.98490688228],
						[526797.18390114268, 633778.12403218553],
						[526797.23396465322, 633747.37550554518],
						[526826.27764228405, 633747.42281897552],
						[526826.32794032549, 633716.56369040627],
						[526883.6944605445, 633716.65729357582],
						[526883.7443241491, 633686.12998789828],
						[526912.06716481852, 633686.17627512512],
						[526912.26791442162, 633563.40345712623],
						[526883.9448624762, 633563.35716955108],
						[526883.99526803882, 633532.49806619086],
						[526854.95121114596, 633532.45065091655],
						[526855.05173287098, 633470.84306265519],
						[526826.72852164193, 633470.7968735391],
						[526826.92863185622, 633348.02417079872],
						[526852.16222645179, 633348.06531904067],
						[526855.55289732816, 633163.69021908147],
						[526827.22915753594, 633163.64402910729],
						[526827.278914614, 633133.11679750145],
						[526741.68956351164, 633132.97751571331],
						[526741.63996518054, 633163.50474757398],
						[526712.59525713942, 633163.45758350496],
						[526712.54517414304, 633194.31663735386],
						[526686.59037725138, 633194.27453418449],
						[526684.17199511256, 633224.79793373973],
						[526626.80376051937, 633224.70502600458],
						[526626.75383816974, 633255.56408843864],
						[526597.70929258282, 633255.51712710585],
						[526597.51053590095, 633378.5109949304],
						[526654.87823440239, 633378.60380055814],
						[526654.82879628905, 633409.13106565492],
						[526712.19638806535, 633409.22407106753],
						[526712.09676048544, 633470.61043142085],
						[526741.14092650753, 633470.65759460605],
						[526741.04083116353, 633532.26518356428],
						[526540.61623543152, 633531.94076881546],
						[526540.66581882094, 633501.19227468327],
						[526454.25443529384, 633501.05315895658],
						[526454.20501334127, 633531.80165334651],
						[526425.88190701732, 633531.75615402532],
						[526425.83236038359, 633562.61525877914],
						[526398.33325045428, 633562.57112979412],
						[526397.56369325961, 633592.87605183444],
						[526340.19674160273, 633592.78414307709],
						[526340.24524271709, 633562.47806454008],
						[526311.20123872405, 633562.43160879321],
						[526311.34905701189, 633469.96491214959],
						[526283.02584427386, 633469.91965866624],
						[526283.12351830781, 633408.75450782687],
						[526254.80055310577, 633408.48809082294],
						[526254.84924926516, 633377.96082453663],
						[526197.48154852365, 633377.86941320752],
						[526197.43295876705, 633408.39667966391],
						[526111.84503915056, 633408.26067312667],
						[526111.89347016532, 633377.73340641544],
						[526082.7461460866, 633377.68719041371],
						[526082.64886633842, 633439.07354628888],
						[526054.42859413626, 633439.02884940384],
						[526054.38026951253, 633469.5561245248],
						[526025.23310804355, 633469.51001037261],
						[526025.18431279785, 633500.36910795467],
						[525967.81703870918, 633500.27849712432],
						[525967.7685255215, 633531.02699295606],
						[525882.18124359811, 633530.89218069764],
						[525882.22959689074, 633500.14368460258],
						[525796.53916106059, 633500.00915572909],
						[525796.58752761758, 633469.15005747019],
						[525625.30932604079, 633468.88249796478],
						[525625.35685484309, 633438.3552215948],
						[525510.62187406246, 633438.17698708153],
						[525510.66936148761, 633407.53910842584],
						[525482.44937770534, 633407.27418014361],
						[525482.40160032525, 633438.13327098708],
						[525395.88689205004, 633437.99955238448],
						[525395.93450721959, 633407.14046129165],
						[525367.71418026497, 633407.09694183792],
						[525367.66661800479, 633437.95603301295],
						[525310.29912638071, 633437.86771395511],
						[525310.25218193547, 633468.39499123429],
						[525195.51741057495, 633468.21895331435],
						[525195.47017097869, 633499.0780533182],
						[525109.77972961369, 633498.94709994504],
						[525109.73281941214, 633529.69559826935],
						[525081.51270258985, 633529.6525695367],
						[525081.46567655739, 633560.51167823328],
						[524966.7315473411, 633560.33723518136],
						[524966.68557532446, 633590.64331765834],
						[524938.36257025762, 633590.60037813685],
						[524938.31547725212, 633621.68070787576],
						[524909.2715777345, 633621.63672604831],
						[524909.17867316236, 633683.02315510588],
						[524880.85582706856, 633682.98031454207],
						[524880.80967839633, 633713.50762606016],
						[524852.48688476044, 633713.46483431943],
						[524852.39385739388, 633775.07250103157],
						[524823.35022856342, 633775.02867082588],
						[524823.11851569498, 633928.66078912595],
						[524852.16187342233, 633928.70461892663],
						[524852.11544320628, 633959.45317626244],
						[524880.43781353242, 633959.49596736289],
						[524880.39116318827, 633990.35513513896],
						[524908.71348033811, 633990.39797490113],
						[524908.66727907688, 634020.92532771919],
						[524966.03273845406, 634021.01224688697],
						[524965.89247316471, 634113.47918076615],
						[524994.93550474639, 634113.52326250868],
						[524994.84261363768, 634174.68861136807],
						[524965.79968998756, 634174.64452978433],
						[524965.6131168782, 634297.63891637675],
						[524937.29132844182, 634297.59597869928],
						[524937.19798008108, 634359.20380375162],
						[524908.15538203856, 634359.15982389287],
						[524908.01627581241, 634451.07386363856],
						[524879.69475141307, 634451.03102507733],
						[524879.50881842384, 634574.02556306496],
						[524855.2039827042, 634573.98883891734],
						[524851.14090824546, 634604.84202523832],
						[524879.46216795687, 634604.88481466763],
						[524879.3697030294, 634666.05029716261],
						[524822.00649192964, 634665.96368005697],
						[524821.91390652931, 634727.35039285338],
						[524650.64879839355, 634727.09297616396],
						[524650.6946888516, 634696.45492054184],
						[524564.28958066576, 634696.32572742715],
						[524564.24385105819, 634726.9637832928],
						[524535.92280142661, 634726.92153630534],
						[524535.87679474032, 634757.78080985113],
						[524507.55579814152, 634757.73861168104],
						[524507.51000926259, 634788.48728279106],
						[524478.4681687525, 634788.44406117918],
						[524478.4224341294, 634819.19273656048],
						[524450.10154320858, 634819.1506372632],
						[524450.01017976739, 634880.64800075779],
						[524392.64771664911, 634880.56288018567],
						[524392.60214209568, 634911.31156838674],
						[524420.9228744203, 634911.35356873204],
						[524420.83211184503, 634972.5191370704],
						[524392.51148477709, 634972.47713687515],
						[524392.4657462663, 635003.33644445869],
						[524364.24815613776, 635003.294645541],
						[524357.09675805445, 635034.03283220902],
						[524306.84070582129, 635033.95852907712],
						[524306.79512776656, 635064.8178453393],
						[524277.75377488771, 635064.77497792104],
						[524277.70906711713, 635095.08126403484],
						[524249.38865096145, 635095.03951013344],
						[524249.34285450215, 635126.12004874635],
						[524221.02249176078, 635126.07834366523],
						[524220.93214530009, 635187.46518536133],
						[524191.89100884594, 635187.42246946273],
						[524191.71020731924, 635310.41741742077],
						[524220.75112673413, 635310.46013299923],
						[524220.6604546234, 635372.0682390685],
						[524246.61181730119, 635372.10645365424],
						[524248.89026781323, 635433.27563809918],
						[524277.21010191599, 635433.31739114237],
						[524277.11921772058, 635494.92553055251],
						[524306.15981153504, 635494.96839684912],
						[524306.0691453258, 635556.35533875774],
						[524334.28578718309, 635556.39703792182],
						[524334.14954816503, 635648.53278559842],
						[524276.89274137834, 635648.44822076929],
						[524276.80218343495, 635709.83520481351],
						[524248.48282517464, 635709.79345247569],
						[524248.39237284422, 635771.18045346928],
						[524220.07312014978, 635771.13875001692],
						[524220.0277026156, 635801.99816775194],
						[524248.34690219915, 635802.03987112513],
						[524247.89431414625, 636109.19638528489],
						[524219.57564312714, 636109.15468269063],
						[524219.34969454532, 636262.67779441446],
						[524190.31013028609, 636262.85629624117],
						[524190.17485368357, 636354.88172816951],
						[524161.85660545295, 636354.84012490115],
						[524161.72132475988, 636446.97620250273],
						[524132.68241090089, 636446.93359108514],
						[524132.54713052942, 636539.18031452433],
						[524104.22919945134, 636539.13881042332],
						[524104.18415889289, 636569.8877267763],
						[524075.1454619352, 636569.84521689394],
						[524075.10063745698, 636600.48352993012],
						[524046.78281186987, 636600.44212468481],
						[524046.60307826265, 636723.43784997484],
						[524103.95911804267, 636723.52176439739],
						[524103.86919886968, 636784.90904443094],
						[524132.18670701719, 636784.95054791449],
						[524131.91663242981, 636969.1124889499],
						[524103.59944119566, 636969.07098593097],
						[524103.50887385762, 637030.9007649842],
						[524074.47099042195, 637030.85825629428],
						[524074.42632767267, 637061.38602481282],
						[523988.75443293288, 637061.2609079351],
						[523988.70944537688, 637092.12050451175],
						[523960.49543665518, 637092.07939786452],
						[523960.45114623063, 637122.49656721298],
						[523932.13421894476, 637122.45535926276],
						[523931.26509120397, 637153.64559017681],
						[523874.73431421904, 637153.56347284594],
						[523874.69002166425, 637184.09125876997],
						[523817.33558720152, 637184.00814346131],
						[523817.29124095035, 637214.64654167241],
						[523788.25368176366, 637214.6045380556],
						[523788.20906977699, 637245.4641564819],
						[523759.89235409989, 637245.42324492882],
						[523759.84827433602, 637275.95104378869],
						[523388.33364744531, 637275.4187988448],
						[523388.37703796971, 637244.89099899924],
						[523331.02281542995, 637244.80957873713],
						[523331.06657001964, 637213.94995908439],
						[523301.92603953398, 637213.90866766998],
						[523301.96942620928, 637183.27026807948],
						[523273.75557377434, 637183.23033891164],
						[523273.71223962877, 637213.86873857304],
						[523246.21923017275, 637213.82987610158],
						[523245.30875048286, 637275.21613249509],
						[523216.27129818517, 637275.17513822578],
						[523216.0977644478, 637398.17124566296],
						[523187.78131155856, 637398.13131862797],
						[523187.4349788382, 637643.90252201981],
						[523158.39817714482, 637643.86162987479],
						[523158.26834815938, 637736.10885768465],
						[523129.95247681206, 637736.06903016265],
						[523129.90956434619, 637766.59689824784],
						[523101.59374546283, 637766.557119529],
						[523101.55041965569, 637797.41681661271],
						[523044.30108936556, 637797.33654028247],
						[523044.25802582299, 637828.08563355089],
						[522986.90583600849, 637828.0054127085],
						[522987.20637590805, 637612.87245643302],
						[522958.89029248856, 637612.83292328578],
						[522959.14724985632, 637428.67042926897],
						[522987.46365019277, 637428.70996285812],
						[522987.7212332983, 637244.32640598062],
						[523158.96014610381, 637244.5665173874],
						[523159.00357801258, 637213.70689727867],
						[523188.04113877774, 637213.74779049156],
						[523188.08431340655, 637183.10939060361],
						[523245.43875100568, 637183.19031266123],
						[523245.48187616665, 637152.66252506617],
						[523273.79875147028, 637152.70255139295],
						[523273.88588904805, 637091.09394947591],
						[523331.24064736639, 637091.17517059343],
						[523331.28440192586, 637060.31557224365],
						[523359.49846511043, 637060.35560004902],
						[523359.5418015297, 637029.82782961859],
						[523387.85888821166, 637029.86805222649],
						[523388.72652011405, 636999.00963337859],
						[523416.94068841316, 636999.04975967424],
						[523416.98476083128, 636968.07956651086],
						[523467.33787841414, 636968.15129911364],
						[523474.38333933713, 636937.74413674185],
						[523531.73879033147, 636937.71544888359],
						[523531.78228776756, 636907.29830354301],
						[523560.09958530136, 636907.33882255096],
						[523560.40807592939, 636691.87494509493],
						[523589.44655754924, 636691.91654664953],
						[523589.62255671626, 636569.14204866427],
						[523617.94043616805, 636569.18266720488],
						[523617.9845681375, 636538.43374953198],
						[523646.19952613517, 636538.47426891385],
						[523646.55268557474, 636292.70429545024],
						[523675.69484742754, 636292.746197175],
						[523675.827564682, 636200.49957143294],
						[523646.68523946754, 636200.45766947593],
						[523646.77344976319, 636139.07054737187],
						[523618.55780695443, 636139.03002700431],
						[523618.60193883895, 636108.28116849018],
						[523646.8176343707, 636108.32168893144],
						[523646.90584462747, 636046.93459209008],
						[523618.69004384329, 636046.89407149598],
						[523618.77814882481, 635985.50699133216],
						[523361.02481417416, 635985.13907242788],
						[523361.06862142822, 635954.27962698275],
						[523332.85266178043, 635954.23959648656],
						[523332.89594564016, 635923.71197713958],
						[523280.99495989532, 635923.63847060339],
						[523275.45029388671, 635985.01781542972],
						[523247.13140917791, 635984.97778625903],
						[523247.08828424249, 636015.50541419396],
						[523218.04860899469, 636015.46441678912],
						[523217.96168657375, 636077.07272221823],
						[523160.60339360154, 636076.99189594307],
						[523160.56027325254, 636107.6301440649],
						[523132.24159953848, 636107.59031260572],
						[523132.1549978347, 636169.19864387263],
						[523103.83643007203, 636169.15886129322],
						[523103.75024494162, 636230.54599474126],
						[523074.71094916441, 636230.50525027514],
						[523074.66814339405, 636261.03291217703],
						[523046.45239989, 636261.21458769974],
						[523046.40949155361, 636291.85286136484],
						[522989.05194719584, 636291.77263302775],
						[522981.98940235819, 636261.12443459802],
						[522960.77664784732, 636260.87360786402],
						[522960.81924233766, 636230.34594566759],
						[522931.77994621021, 636230.30545342644],
						[522931.86548983294, 636168.91831907199],
						[522903.54692158813, 636168.87888116343],
						[522903.58987148007, 636138.01940910169],
						[522874.55041243118, 636137.97901785187],
						[522874.59315411648, 636107.23015737208],
						[522846.27447971579, 636107.19081801618],
						[522846.31701492693, 636076.55256907572],
						[522817.99828773615, 636076.51327838143],
						[522817.36286975932, 636014.90397136286],
						[522789.044036482, 636014.86473049445],
						[522789.12904645677, 635953.47765442356],
						[522731.77032269537, 635953.39832284069],
						[522731.8121859387, 635923.09191656252],
						[522674.45366107242, 635922.79157013225],
						[522674.49618068157, 635891.93213134352],
						[522445.88425270928, 635891.61872642417],
						[522445.96798192104, 635830.23168222408],
						[522475.0079840399, 635830.27131718129],
						[522475.17596116528, 635707.27606506238],
						[522446.13574200269, 635707.23642981052],
						[522446.2611094141, 635615.32185624517],
						[522417.9415885121, 635615.28325398616],
						[522418.02551332914, 635553.67507096741],
						[522388.98502311314, 635553.63553656824],
						[522389.02700639149, 635522.77614776394],
						[522332.49062667246, 635522.69932870986],
						[522332.53205363743, 635492.17176531814],
						[522303.49145488709, 635492.13238178438],
						[522303.53357749025, 635461.05178700935],
						[522275.21379111701, 635461.01343036164],
						[522275.2551116682, 635430.48587519536],
						[522217.89456502517, 635430.40833473334],
						[522217.93592849106, 635399.77017651091],
						[522189.61603666167, 635399.73196716246],
						[522189.69940381352, 635337.90262794506],
						[522160.65853283479, 635337.86349645781],
						[522160.82385732955, 635215.0897244974],
						[522132.50364769332, 635215.05161343247],
						[522132.58560926805, 635154.10718020226],
						[522103.5444139532, 635154.06814950518],
						[522103.9160992977, 634877.3297502856],
						[522132.95778295927, 634877.36878163693],
						[522132.99958181556, 634846.28827129479],
						[522190.36216440779, 634846.36551586376],
						[522190.40317677357, 634815.94865060248],
						[522247.04496956978, 634816.02512074262],
						[522247.08653516677, 634785.27643944137],
						[522333.49117638124, 634785.39346689289],
						[522333.57478052331, 634723.78551057575],
						[522360.2480650848, 634723.82172881754],
						[522361.83447934798, 634693.18576601287],
						[522390.15558703692, 634693.2242717247],
						[522390.19741967763, 634662.47560754849],
						[522447.56064295105, 634662.55374858563],
						[522447.60243189771, 634631.91569542768],
						[522476.64454863034, 634631.95533326839],
						[522476.68624057894, 634601.42789100972],
						[522533.32877169386, 634601.50534644967],
						[522533.37102301989, 634570.64608850784],
						[522676.31644110737, 634570.84242500982],
						[522676.35713166796, 634541.31045127893],
						[522705.40108682646, 634540.13381980185],
						[522705.44366062619, 634509.27457072283],
						[522733.76508479781, 634509.31366773346],
						[522733.80725334439, 634478.7862427556],
						[522759.76002466568, 634478.8221126867],
						[522762.89232164598, 634447.96714509896],
						[522791.21385131829, 634448.00634096528],
						[522791.25643259706, 634417.25771128293],
						[522847.79660999222, 634417.33610640594],
						[522848.66304546117, 634386.69923141296],
						[522906.0272299475, 634386.77897043107],
						[522906.06971767964, 634356.25156247627],
						[522934.39140518033, 634356.29100473551],
						[522934.56279924, 634233.29656256165],
						[522963.60561939038, 634233.33705971995],
						[522963.6915792303, 634171.72925740387],
						[522934.64865036233, 634171.68876009539],
						[522934.77750407229, 634079.22178463277],
						[522906.45533978025, 634079.18234171357],
						[522906.53985329787, 634018.45943204663],
						[522877.49726894387, 634017.97661008185],
						[522877.45437390939, 634048.83579166047],
						[522763.44457801274, 634048.67770985758],
						[522763.48725927959, 634017.81852797861],
						[522734.44405881321, 634017.77838396304],
						[522734.52885407041, 633956.39185171621],
						[522706.20647840318, 633956.35275338846],
						[522706.33328389982, 633864.43889543018],
						[522677.28981276666, 633864.39885227277],
						[522677.37469880271, 633802.79114869051],
						[522649.15505023091, 633802.75229045074],
						[522649.19751652819, 633771.8931417343],
						[522534.46486091474, 633771.73565401451],
						[522534.5069606466, 633740.98711544392],
						[522506.1842143035, 633740.94836132822],
						[522506.31035473075, 633648.70277039753],
						[522534.63325981318, 633648.74152473127],
						[522534.67505664902, 633618.21421519597],
						[522563.71896221238, 633618.25400668918],
						[522563.80311850517, 633556.86758160847],
						[522592.12618162192, 633556.90643487731],
						[522592.16854031378, 633526.04731942527],
						[522621.21260851558, 633526.08721237152],
						[522621.25486964139, 633495.33870730607],
						[522649.57803863985, 633495.3776594447],
						[522649.66251448722, 633433.9912680363],
						[522677.88279533049, 633434.03012714558],
						[522678.09417177708, 633280.61952451465],
						[522707.13897826162, 633280.43835705321],
						[522707.2239727953, 633218.8308120009],
						[522735.54761762038, 633218.86991207348],
						[522735.58978592826, 633188.34266081324],
						[522764.63445006212, 633188.38280685409],
						[522764.67713116994, 633157.52374187927],
						[522793.00088149769, 633157.56294082163],
						[522793.04315619561, 633127.03569794272],
						[522821.3669589886, 633127.07494569686],
						[522822.17335245165, 633065.46844245493],
						[522850.49726119381, 633065.50774033798],
						[522850.66770682036, 632942.73520820239],
						[522878.99182676768, 632942.77455512097],
						[522879.03472159465, 632911.9155237393],
						[522908.07987352443, 632911.95592290862],
						[522908.20810557634, 632819.82127721794],
						[522965.57775141671, 632819.90122379025],
						[522965.62049958383, 632789.26342082652],
						[522993.94488363521, 632789.30296556698],
						[522994.03094894456, 632727.69555488671],
						[523022.25244079635, 632727.73500444798],
						[523022.33830230555, 632666.3488219874],
						[523048.29393169959, 632666.38514691661],
						[523051.5725464985, 632605.22466386249],
						[523079.07325595821, 632605.26320112497],
						[523079.83798396395, 632574.0734098769],
						[523108.88373206824, 632574.1141633956],
						[523109.09942429524, 632420.48293419648],
						[523080.05340508802, 632420.44218030106],
						[523080.1388600783, 632359.49850300082],
						[523051.91673685174, 632359.45895418734],
						[523052.08929659292, 632236.24438186805],
						[522966.39228050271, 632236.12458769709],
						[522966.43533721368, 632205.26565201569],
						[522880.01714992878, 632205.14530155226],
						[522880.05958338379, 632174.6181862473],
						[522823.40869966359, 632174.53953748022],
						[522822.73047553579, 632143.67960996449],
						[522594.06647706975, 632143.36414614914],
						[522594.10838003317, 632112.8370382993],
						[522481.73320500547, 632112.68317017285],
						[522480.04348160513, 632143.20802747668],
						[522422.67147715547, 632143.12977323739],
						[522422.62944004498, 632173.98870205856],
						[522365.25754288695, 632173.91064793547],
						[522365.29947243736, 632143.05171896704],
						[522337.07697809429, 632143.01339581306],
						[522337.11840444332, 632112.48628731177],
						[522250.69973006018, 632112.36924085743],
						[522250.7414446763, 632081.51031987369],
						[522079.34580071963, 632081.2795218986],
						[522079.3870456412, 632050.53121007211],
						[521964.64239042933, 632050.37769453891],
						[521964.5601816813, 632111.98492836324],
						[521936.33763407206, 632111.94729231042],
						[521936.29695100902, 632142.4744018116],
						[521907.25044121419, 632142.43571750482],
						[521907.2093703947, 632173.29464762041],
						[521878.88392629096, 632173.25697299233],
						[521878.84334962058, 632203.78409082384],
						[521821.4715563163, 632203.70793206757],
						[521821.43064614682, 632234.56687067193],
						[521793.10530748469, 632234.52934365487],
						[521793.06459685712, 632265.27768095653],
						[521764.01830376615, 632265.23924940149],
						[521763.89604213735, 632357.70549747103],
						[521735.57091537683, 632357.66806946264],
						[521735.2875672605, 632572.24300019932],
						[521707.06580880296, 632572.20575725532],
						[521706.82235809159, 632756.80672276753],
						[521735.04380003153, 632756.84396529221],
						[521734.96273898531, 632818.23017909413],
						[521763.28707318584, 632818.26760605455],
						[521763.12444726872, 632941.26129466924],
						[521792.16954741388, 632941.29972464941],
						[521791.9254292479, 633125.6797756257],
						[521762.88065447053, 633125.64134607604],
						[521762.67766427132, 633279.16246258887],
						[521791.72216813877, 633279.2008917788],
						[521791.60003567766, 633371.44633847778],
						[521762.55569459125, 633371.40790950309],
						[521762.39336076879, 633494.18068466673],
						[521734.07018971175, 633494.14325924148],
						[521733.82671361044, 633678.52375924494],
						[521762.14956737665, 633678.56118425378],
						[521762.02774373046, 633770.69618706673],
						[521791.07138021098, 633770.73461510963],
						[521791.03052286932, 633801.59376600129],
						[521819.35316485073, 633801.63128944393],
						[521819.31298755982, 633831.93741297454],
						[521876.67910567555, 633832.01356419362],
						[521876.59692261164, 633893.84249272128],
						[521904.91940584948, 633893.88016340928],
						[521904.87862913252, 633924.51811807125],
						[521933.92199417209, 633924.55679819733],
						[521933.88101598062, 633955.30536327988],
						[521962.10040299007, 633955.34299511788],
						[521962.05922447593, 633986.2021706719],
						[521991.20547093905, 633986.24108931958],
						[521991.16468113824, 634016.76844984759],
						[522042.96869078238, 634016.83775053057],
						[522047.50042742077, 634170.47641811497],
						[522076.54335842951, 634170.51534991653],
						[522076.41977086174, 634262.65055022854],
						[522047.37700243696, 634262.61161864502],
						[522047.2531328958, 634355.07867635088],
						[522018.93144330627, 634355.04076072585],
						[522018.89060110092, 634385.56817092397],
						[521990.67195175384, 634385.53044171724],
						[521990.63101409416, 634416.16846268985],
						[521961.48552899447, 634416.12954506185],
						[521961.44449799275, 634446.87817685725],
						[521933.22595376731, 634446.84054614662],
						[521933.1441445924, 634508.22721579904],
						[521904.10180952627, 634508.18853705237],
						[521904.06073827954, 634539.04778816784],
						[521875.73936527572, 634539.01011895272],
						[521875.65747599618, 634600.61802730488],
						[521789.97276966885, 634600.50435801339],
						[521789.85107582394, 634692.41852246667],
						[521675.12483721483, 634692.26702522626],
						[521675.16533392831, 634661.51835926273],
						[521646.94715772459, 634661.48121940345],
						[521646.98745622911, 634630.84316425142],
						[521617.84235130454, 634630.80485519185],
						[521617.88245025766, 634600.27741079463],
						[521589.66416905221, 634600.24036915076],
						[521589.70465094864, 634569.38110883825],
						[521564.57591540483, 634569.34816351079],
						[521417.6140061082, 634569.15625572577],
						[521417.65402137948, 634538.40760585631],
						[521389.33264727471, 634538.37077367306],
						[521389.37275338027, 634507.51152128563],
						[521361.15431311837, 634507.47487144207],
						[521361.19393562642, 634476.94744305382],
						[521332.04855816183, 634476.90964010684],
						[521332.08855669264, 634446.05039596488],
						[521303.87001105282, 634446.01384433964],
						[521303.94947275723, 634384.62718827452],
						[521332.16812365263, 634384.66374003573],
						[521332.20769207797, 634354.13632816076],
						[521361.35328696296, 634354.1741313911],
						[521361.39362724189, 634323.09369099652],
						[521332.24797731626, 634323.0558876954],
						[521332.32754423039, 634261.66926515824],
						[521304.10868245107, 634261.63271312509],
						[521304.18814408942, 634200.24610711518],
						[521246.82330945262, 634200.17195130244],
						[521246.86300467659, 634169.42335116828],
						[521218.5409956089, 634169.38681289251],
						[521218.58049531421, 634138.74882331758],
						[521189.53750825132, 634138.7114055258],
						[521189.61711153318, 634076.88240656059],
						[521132.25184691173, 634076.80865008803],
						[521132.29075969552, 634046.50249204948],
						[521075.74930833321, 634046.42999044212],
						[521075.71049966308, 634076.73614861933],
						[520990.02306584234, 634076.62664413883],
						[520989.15922932356, 634107.92721377243],
						[520760.5225182327, 634107.63722162112],
						[520760.56200226984, 634076.33560067439],
						[520732.23983301566, 634076.2998992491],
						[520732.3168820673, 634015.13455336099],
						[520675.05439231417, 634015.06252018304],
						[520675.1315064262, 633953.67597780447],
						[520645.98520229658, 633953.63938981609],
						[520646.06220767385, 633892.25286392518],
						[520617.84271249652, 633892.21748855594],
						[520617.88095471403, 633861.69014126388],
						[520560.5149400449, 633861.61837758054],
						[520560.55404306483, 633830.31679010508],
						[520503.18791904429, 633830.24522623187],
						[520503.22567286843, 633799.93909958843],
						[520331.84792248078, 633799.72649787215],
						[520331.81048421853, 633830.03262490931],
						[520274.54735046002, 633829.9619851918],
						[520274.47118605528, 633891.79092142929],
						[520246.14869922196, 633891.75605648919],
						[520246.03522444709, 633984.00176391343],
						[520216.99196430587, 633983.96606232389],
						[520216.87933159061, 634075.65877534822],
						[520245.92242992489, 634075.6944767395],
						[520245.65738303389, 634291.15590705979],
						[520273.97918255953, 634291.19077115017],
						[520273.90329050017, 634352.7986201793],
						[520302.94589977653, 634352.83442219929],
						[520302.87044476595, 634413.99986150209],
						[520331.08904530207, 634414.03469682031],
						[520331.05106039759, 634444.78333253018],
						[520359.37259555236, 634444.81834357139],
						[520359.44853435818, 634383.43168305082],
						[520388.49108957639, 634383.46763602691],
						[520388.45313452731, 634414.1056608404],
						[520416.7747224723, 634414.14077066095],
						[520416.73657748109, 634444.88940616685],
						[520445.77902425174, 634444.92546024197],
						[520445.70276313735, 634506.31213703798],
						[520502.3456216238, 634506.38260244869],
						[520502.30717873666, 634537.24185695185],
						[520531.34946253733, 634537.27806202555],
						[520531.31110317656, 634568.02671401075],
						[520674.35953071923, 634568.20579081285],
						[520674.39815734129, 634537.45713916468],
						[520702.61654619826, 634537.49261150334],
						[520702.5778668588, 634568.24126308644],
						[520731.62009594945, 634568.27782156621],
						[520731.58122300915, 634599.13708394649],
						[520759.90249254531, 634599.1727842415],
						[520759.70897839783, 634752.58430503181],
						[520731.38797286223, 634752.54860507371],
						[520731.31050557113, 634814.04597087391],
						[520702.26871017163, 634814.00941293803],
						[520702.15267197567, 634906.25549329247],
						[520673.93491539854, 634906.22002174694],
						[520673.85807885154, 634967.38560915901],
						[520644.71356991061, 634967.34902342246],
						[520644.67485891894, 634998.20834062225],
						[520616.45726000075, 634998.17296762927],
						[520616.41874047049, 635028.92168222892],
						[520585.7295843226, 635028.88326586725],
						[520387.69184006623, 635028.63674049987],
						[520387.65361086128, 635059.49606674083],
						[520273.03291473998, 635059.3544710672],
						[520272.99558171449, 635089.66076716257],
						[520215.63384713803, 635089.59020557278],
						[520215.59566867579, 635120.6707544789],
						[520187.27529656043, 635120.63599085598],
						[520187.23730725533, 635151.60593715915],
						[520129.87578858924, 635151.53567447618],
						[520129.83858367812, 635181.95259030245],
						[520072.4771707856, 635181.88252768177],
						[520072.43993698375, 635212.41005473875],
						[520044.11972273537, 635212.37553746346],
						[520044.08173317503, 635243.56671075698],
						[520015.04069572699, 635243.53136554197],
						[520015.00370283838, 635273.94829408033],
						[519986.68359449063, 635273.91387564945],
						[519986.6461166197, 635304.77323650871],
						[519958.429043337, 635304.73899176146],
						[519958.39228907356, 635335.04532167083],
						[519901.03140978527, 635334.97585662291],
						[519900.8826751411, 635457.97093139018],
						[519958.24312572886, 635458.04039591411],
						[519958.28014829336, 635427.5128352358],
						[519986.49701107055, 635427.54707972251],
						[519986.53422030434, 635396.90891617513],
						[520043.89488372183, 635396.97867924033],
						[520043.93206502224, 635366.45112706232],
						[520157.93273251102, 635366.59037023841],
						[520157.97107364458, 635335.28857311548],
						[520272.69282978977, 635335.42949426686],
						[520272.65427045408, 635366.73129112367],
						[520299.32651297416, 635366.76416917448],
						[520301.61963514419, 635427.93280535692],
						[520329.83649720211, 635427.967638531],
						[520329.64657177322, 635581.71155088325],
						[520301.42997332703, 635581.6767180321],
						[520301.39190449839, 635612.53612038132],
						[520272.3515181588, 635612.50032110303],
						[520272.27617065865, 635673.6661025869],
						[520243.95675016532, 635673.6312414282],
						[520243.91892494494, 635704.38004932902],
						[520215.59955730569, 635704.3452369622],
						[520214.80329460773, 635765.73137279204],
						[520186.48403254355, 635765.69661052874],
						[520186.29530651169, 635919.55136335408],
						[520214.61430381919, 635919.58612528886],
						[520214.57680454967, 635950.11375228921],
						[520243.61659512459, 635950.14944961586],
						[520243.57863379794, 635981.00890280772],
						[520300.11343903776, 635981.07854553009],
						[520300.89960178337, 636011.60719696071],
						[520357.43430190557, 636011.67703660717],
						[520356.90217868541, 636441.82955413393],
						[520328.58408008184, 636441.79454734421],
						[520328.50824622111, 636503.18177031784],
						[520300.29322772007, 636503.14693941828],
						[520300.21722619626, 636564.75539470452],
						[520271.17852019035, 636564.719597494],
						[520271.02727952151, 636687.49412846891],
						[520242.70960367203, 636687.45926945715],
						[520242.67164221621, 636718.31882441649],
						[520213.63320719369, 636718.28312875528],
						[520213.59570779419, 636748.81086481106],
						[520185.27813746152, 636748.77610462671],
						[520185.24028355756, 636779.63566821371],
						[520156.20195673796, 636779.60007389798],
						[520156.16429276718, 636810.3490340407],
						[520127.84682833246, 636810.31437268946],
						[520127.80908197514, 636841.17394493241],
						[520099.49167058809, 636841.13933237316],
						[520099.45411243418, 636871.88830114086],
						[520013.06042566214, 636871.78300269484],
						[520013.0978223767, 636841.03403372888],
						[519984.78041074506, 636840.9996185723],
						[519984.81788886921, 636810.14004600642],
						[519956.60339667369, 636810.1058043947],
						[519956.64068774442, 636779.35684379307],
						[519870.24651516636, 636779.25229514483],
						[519870.28377835389, 636748.39273083839],
						[519857.61810112884, 636748.37744177785],
						[519813.64863619179, 636748.32444077742],
						[519813.68539362727, 636717.79670382384],
						[519784.64695768012, 636717.76176517177],
						[519784.68406019051, 636686.90220916737],
						[519699.01021581749, 636686.7994261845],
						[519699.04649561655, 636656.49291277991],
						[519613.4754664799, 636656.39069839101],
						[519613.51251150941, 636625.30993507616],
						[519584.37093860307, 636625.27522710816],
						[519584.33394861344, 636656.35599048832],
						[519526.97767475597, 636656.28782921366],
						[519526.90509269357, 636717.45389957738],
						[519470.37281722768, 636717.3869131594],
						[519470.3366966903, 636747.91465087491],
						[519441.29831389396, 636747.88031811756],
						[519441.26185519702, 636778.73988338129],
						[519412.94433636486, 636778.70645226701],
						[519412.90806125104, 636809.45541408379],
						[519355.55232102121, 636809.38785030833],
						[519355.47985502623, 636870.99639472354],
						[519327.98627270781, 636870.96407878585],
						[519327.19349652959, 636932.23997020302],
						[519298.05246717017, 636932.20576928242],
						[519298.01666581014, 636962.73353681806],
						[519269.80243525101, 636962.70047278784],
						[519269.76616813045, 636993.67067607737],
						[519240.62524755532, 636993.63657685346],
						[519240.58916460874, 637024.49617661943],
						[519212.37503994338, 637024.46321105689],
						[519212.33939731441, 637054.99099143781],
						[519184.02235387528, 637054.95795426494],
						[519183.87896186003, 637177.95398164261],
						[519154.84133793361, 637177.92015438597],
						[519154.80567293399, 637208.55856392416],
						[519183.84324279171, 637208.59239112702],
						[519183.69985067612, 637331.58850343595],
						[519212.01641808142, 637331.62154005363],
						[519211.94474530593, 637393.00901352451],
						[519240.15823806502, 637393.04197834781],
						[519240.1221550458, 637423.90163351677],
						[519297.47575338779, 637423.9687949525],
						[519297.43995194871, 637454.49662996305],
						[519326.58005638386, 637454.53082980169],
						[519326.47171038645, 637546.77800872328],
						[519297.33176931523, 637546.74380907731],
						[519297.29570842785, 637577.49287729547],
						[519269.08253192907, 637577.45981450309],
						[519269.01064510806, 637638.84735564422],
						[519211.65779572527, 637638.78029342392],
						[519211.62176557921, 637669.63998280617],
						[519183.30577985488, 637669.60694686824],
						[519183.27018965886, 637700.13481591933],
						[519096.88085131691, 637700.03432756418],
						[519096.91628123698, 637669.50645832904],
						[519068.6002952804, 637669.47361977969],
						[519068.63605720148, 637638.6139300802],
						[518896.57750591857, 637638.41543835017],
						[518896.54206668702, 637669.27512841788],
						[518696.99158712832, 637669.04717450275],
						[518697.02665211959, 637638.18748400733],
						[518525.07106381975, 637637.99299393001],
						[518525.10568178457, 637607.24391555181],
						[518439.43662904424, 637607.14769035624],
						[518439.47096296598, 637576.50922422833],
						[518411.1548169789, 637576.47751704033],
						[518411.18922193331, 637545.72844692436],
						[518382.15224700171, 637545.69598318893],
						[518382.22082480846, 637484.30846373597],
						[518353.90452015668, 637484.27685506945],
						[518353.97299230722, 637422.88935246388],
						[518382.28940259753, 637422.92096124939],
						[518382.35822749365, 637361.31225958723],
						[518354.04171118414, 637361.28065067995],
						[518354.07588555489, 637330.64221826964],
						[518325.03853107122, 637330.60985532159],
						[518325.07277455181, 637299.8608190394],
						[518296.75615249248, 637299.82930871309],
						[518296.79046603898, 637268.96966860443],
						[518267.7530027249, 637268.93740673841],
						[518267.82115251583, 637207.54996321513],
						[518211.29056075332, 637207.48730229936],
						[518211.35825480649, 637146.32109140023],
						[518182.3205750605, 637146.28898029763],
						[518182.35504030733, 637115.09753739065],
						[518125.00036540162, 637115.03426271165],
						[518125.10148565256, 637023.22968625673],
						[518096.78438755212, 637023.19852005178],
						[518096.85238500807, 636961.36871205643],
						[518068.53518045828, 636961.33759446512],
						[518068.56870090158, 636930.80982434051],
						[518039.53064085363, 636930.77796521084],
						[518039.59781649231, 636869.50122173293],
						[518011.28045385523, 636869.47020267148],
						[518011.34788722498, 636807.86165254028],
						[517982.30961021909, 636807.82989438495],
						[517982.34321210312, 636777.08092953754],
						[517954.02569042228, 636777.05000900035],
						[517954.15940353577, 636654.49662263086],
						[517925.94464448118, 636654.46586276789],
						[517926.01175741502, 636592.8573716454],
						[517940.94322261884, 636592.65242833132],
						[517954.22686346504, 636592.66691624431],
						[517954.26029172528, 636562.02858865494],
						[517926.04537412198, 636561.99782861921],
						[517926.24623083381, 636377.61491309595],
						[517897.10421928478, 636377.58319312218],
						[517897.13766101329, 636346.83428733714],
						[517868.92237444001, 636346.80362524511],
						[517869.05520980386, 636224.47168921109],
						[517811.69790949987, 636223.96707651264],
						[517811.76435339497, 636162.57991851843],
						[517840.08293248556, 636162.61059425166],
						[517840.1163871109, 636131.75111043523],
						[517811.79775491974, 636131.72043464822],
						[517811.86419878743, 636070.33330195362],
						[517783.54546090041, 636070.30267478584],
						[517783.57868977595, 636039.55381098925],
						[517754.53905697237, 636039.52245477145],
						[517754.57235091296, 636008.66298773454],
						[517726.25350690208, 636008.63245915901],
						[517726.28639030369, 635978.10481847229],
						[517639.88801106537, 635978.01197952917],
						[517639.85528793844, 636008.53962038294],
						[517583.32057704992, 636008.47911680816],
						[517583.28760424769, 636039.33858419349],
						[517525.92917978746, 636039.27739756787],
						[517525.8638026783, 636100.66452297452],
						[517440.18690617249, 636100.5735002025],
						[517440.15431880346, 636131.32237311965],
						[517428.4149582464, 636131.30993601878],
						[517382.79621495347, 636131.26168538665],
						[517382.76361791848, 636162.12117012078],
						[517325.40562141797, 636162.06068241911],
						[517325.3734812875, 636192.58834903699],
						[517268.01559098071, 636192.52806137223],
						[517267.95117532439, 636253.91522990027],
						[517224.80396628234, 636254.09122583747],
						[517210.59326741763, 636254.07635743148],
						[517210.56122440082, 636284.71464438923],
						[517154.02746230224, 636284.6556156259],
						[517153.99540924071, 636315.40451444872],
						[517124.95626321842, 636315.37426922121],
						[517124.92437951989, 636346.01256475283],
						[517096.60611603328, 636345.98311970697],
						[517096.54210932931, 636407.59154628613],
						[517067.50312598376, 636407.56140244671],
						[517067.43945741345, 636468.94863085297],
						[517095.75750929385, 636468.97802571335],
						[517096.41455551446, 636530.36601974803],
						[517124.73250170349, 636530.39546446537],
						[517124.66861913423, 636591.78272639669],
						[517137.95226068277, 636591.79655538581],
						[517153.70704679523, 636592.03418650292],
						[517153.64282527787, 636653.64268070715],
						[517067.24799272406, 636653.55284821731],
						[517067.21655992098, 636683.85936703486],
						[517038.89887781744, 636683.8300212922],
						[517038.86692452669, 636714.68958305789],
						[517009.82848310086, 636714.65954099433],
						[517009.70134503255, 636837.65539971029],
						[516981.38392759254, 636837.62615294242],
						[516981.22549776483, 636991.14985625108],
						[516953.01131593011, 636991.12076456891],
						[516952.85280736431, 637144.97639787593],
						[516923.71215474536, 637144.94640169549],
						[516923.64924704516, 637206.11261770432],
						[516866.29488938139, 637206.05373024114],
						[516866.23196811782, 637267.44117935281],
						[516838.01826001098, 637267.41228484106],
						[516837.95521762141, 637329.02096712065],
						[516752.28471638128, 637328.9335258255],
						[516752.22221994185, 637390.32100932044],
						[516637.51478852471, 637390.20462931856],
						[516637.32835923141, 637574.58839925088],
						[516609.11517775652, 637574.55989721336],
						[516609.05321443494, 637635.94744917168],
						[516579.91343128023, 637635.91806182871],
						[516579.88233679539, 637666.77775658132],
						[516551.66931338888, 637666.74935303407],
						[516551.63860559091, 637697.27722738753],
						[516523.32266742608, 637697.24876887363],
						[516523.16816927469, 637851.10489549348],
						[516436.77962358762, 637851.01837307413],
						[516436.74912857142, 637881.54627302173],
						[515721.85690648615, 637880.84767947427],
						[515721.82742075308, 637911.70741000364],
						[515493.24355203682, 637911.49059092021],
						[515493.2148074478, 637942.01850102213],
						[514949.55687317124, 637941.51558169909],
						[514949.52883574454, 637972.37532212795],
						[514778.29749728728, 637972.22064160637],
						[514778.27007902029, 638002.74856138974],
						[514520.65130633028, 638002.51920060534],
						[514520.62407319678, 638033.37895030773],
						[514492.3087134175, 638033.35398685792],
						[514492.28163080738, 638064.10313246469],
						[514434.93026368227, 638064.05271952623],
						[514434.95723911887, 638033.3035738261],
						[514262.90281516308, 638033.15353412461],
						[514262.92956494511, 638002.29378399742],
						[514177.36553416669, 638002.21983788302],
						[514177.39183756476, 637971.69191711978],
						[514120.04014833836, 637971.64260172588],
						[514120.01395134797, 638002.17052258551],
						[514034.34695478837, 638002.09723182046],
						[514034.32063370798, 638032.95698231598],
						[513948.65379743715, 638032.88413770031],
						[513948.6015703663, 638094.49304340454],
						[513891.2503091672, 638094.44452546176],
						[513891.17252408812, 638186.5813951639],
						[513862.96039193578, 638186.55760165362],
						[513862.93457835232, 638217.19616111112],
						[513833.8987883355, 638217.17172346241],
						[513833.87312181224, 638247.69967866002],
						[513805.55813084473, 638247.67589700641],
						[513805.54142606718, 638267.58543530735],
						[513805.50643883331, 638309.28486299957],
						[513776.47081131709, 638309.26052668504],
						[513776.45488254249, 638328.28520190751],
						[513776.41959844937, 638370.42707553064],
						[513719.0692990165, 638370.37915772689],
						[513719.04319972079, 638401.68139460078],
						[513666.32632803434, 638401.63752448],
						[513662.36295852746, 638462.8008500163],
						[513605.0129810666, 638462.7533297569],
						[513604.98755588348, 638493.50253658439],
						[513547.63768543233, 638493.45521630521],
						[513547.61209420708, 638524.53625354741],
						[513575.92660873779, 638524.55959131755],
						[513575.90160285897, 638554.86637201591],
						[513547.58714048163, 638554.84303429397],
						[513547.35936926154, 638831.4755574438],
						[513519.14834283636, 638831.45235343103],
						[513519.12307751225, 638862.20161178103],
						[513489.98546594416, 638862.17769642104],
						[513489.88480378955, 638984.95355508663],
						[513461.6740405176, 638984.93044961803],
						[513461.64879185276, 639015.79033840832],
						[513404.30074183748, 639015.74351773562],
						[513404.27587106347, 639046.27158410731],
						[513346.92792729218, 639046.22496340633],
						[513346.87794991827, 639107.83415389748],
						[513297.35504554253, 639107.7940553542],
						[513289.53022072231, 639107.787733256],
						[513289.50565209094, 639138.20520358754],
						[513261.19219355268, 639138.18235870812],
						[513261.16723151307, 639169.15287831554],
						[513232.95678406785, 639169.13016500673],
						[513232.90741097822, 639230.51817219541],
						[513203.77045167092, 639230.49476369878],
						[513203.69642193691, 639322.74272037169],
						[513175.48623783281, 639322.72010560136],
						[513175.43725582963, 639383.88693762233],
						[513146.30056812323, 639383.86363089876],
						[513146.22668310668, 639476.33287053439],
						[513118.01676235074, 639476.31035430264],
						[513117.99242202513, 639506.83848506457],
						[513088.85595205222, 639506.8152800689],
						[513088.83140180691, 639537.67524269584],
						[513060.62132281164, 639537.98465245159],
						[513060.59717669181, 639568.40218267264],
						[513032.28445845743, 639568.37973170646],
						[513032.26001422148, 639599.23970307992],
						[513003.22666303086, 639599.2167312752],
						[513003.15366851236, 639691.57545301528],
						[512974.84116223926, 639691.55310089909],
						[512974.79309946147, 639752.49881769577],
						[512945.76001871715, 639752.47594729881],
						[512945.73573648161, 639783.33594470262],
						[512889.21399370511, 639783.29156746657],
						[512889.1419849479, 639875.20792979619],
						[512860.00582149316, 639875.62756752805],
						[512859.95783769822, 639937.01577343361],
						[512831.74870682508, 639936.9937480361],
						[512831.70082827099, 639998.38197122258],
						[512802.56522877986, 639998.35927322041],
						[512802.54121474508, 640029.21930547198],
						[512774.33224196202, 640029.19737851666],
						[512774.28457735776, 640090.58562773059],
						[512745.97275772208, 640090.56366946246],
						[512745.90137640387, 640182.70138044236],
						[512716.86905481998, 640182.67891396268],
						[512716.845372235, 640213.31775326165],
						[512690.07803335396, 640213.29708491603],
						[512688.48624815419, 640274.90541409259],
						[512659.45408927451, 640274.88304893009],
						[512659.43059858383, 640305.41129164794],
						[512631.11914863187, 640305.38953103172],
						[512631.07184770075, 640366.9990774102],
						[512602.8634540718, 640366.97744445305],
						[512602.79278820317, 640459.22588221938],
						[512573.65800482366, 640459.20358959341],
						[512573.61108767171, 640520.59196013014],
						[512516.26828264788, 640520.54823469999],
						[512516.24505727785, 640551.07651195966],
						[512430.69428041839, 640551.01164872607],
						[512430.67096307041, 640581.87175954448],
						[512373.32837163814, 640581.8285323357],
						[512373.30524503911, 640612.57803785475],
						[512344.99432367354, 640612.55676961644],
						[512344.97133298416, 640643.19566975394],
						[512287.6289552942, 640643.1527412479],
						[512281.3261350891, 640673.89756636601],
						[512230.26371812209, 640673.85952698218],
						[512230.21808166546, 640735.2479589209],
						[512172.87602482701, 640735.20543038682],
						[512172.85319081816, 640766.06556764338],
						[512144.64548142278, 640766.04472034576],
						[512144.62147553108, 640798.56400953152],
						[512274.12350088684, 640806.84525095986],
						[512295.33070426399, 640806.86108687229],
						[512664.50075583596, 640807.14113471494],
						[512837.99745124299, 640900.74099702318],
						[513010.77207295166, 640993.67849958444],
						[513487.51693899016, 640994.06244800542],
						[513791.57091208524, 640808.04736886104],
						[513848.22634514002, 640767.39051891491]
					]
				]
			]
		}
	}, {
		"type": "Feature",
		"properties": {
			"name": "Tai Po",
			"ID_0": 102,
			"ID_1": 12,
			"ISO": "HKG"
		},
		"geometry": {
			"type": "MultiPolygon",
			"coordinates": [
				[
					[
						[522871.30289024801, 659336.19396551233],
						[522871.43160017184, 659243.71597053041],
						[522899.71046013653, 659243.75535314367],
						[522899.75300540921, 659213.22435000865],
						[522928.75174470374, 659213.26478570537],
						[522928.83709733386, 659152.09217417822],
						[522871.55923232483, 659152.0123555084],
						[522871.64498754829, 659090.39728458482],
						[522842.6460314368, 659090.35694966977],
						[522842.73167790321, 659028.74189776345],
						[522757.17415285716, 659028.62319322315],
						[522757.13156661467, 659059.37540726026],
						[522728.85238936427, 659059.33627000614],
						[522728.72448336525, 659151.81418005098],
						[522757.00350147393, 659151.85331708984],
						[522756.74844332808, 659336.03492887551],
						[522785.02714442083, 659336.07411413419],
						[522784.94171258231, 659397.68926202704],
						[522928.49414320657, 659397.88893043215],
						[522928.53782280377, 659366.58356602292],
						[522899.53935406735, 659366.54313070572],
						[522899.58159106952, 659336.23334790184],
						[522871.30289024801, 659336.19396551233]
					]
				],
				[
					[
						[523867.92515327432, 661334.86298238963],
						[523867.96998557, 661303.99979557807],
						[523911.87383754621, 661304.06362966239],
						[523925.24034982396, 661304.08308722451],
						[523925.2848064655, 661273.55176757323],
						[524010.72782410518, 661273.6764034282],
						[524010.81753984484, 661212.28191682661],
						[524039.09301220143, 661212.32326014584],
						[524039.18315724423, 661150.70755164372],
						[524068.17847755353, 661150.74999803375],
						[524068.2684072298, 661089.35555027367],
						[524096.54409111995, 661089.3969924571],
						[524096.58902765915, 661058.75508616096],
						[524068.31361510733, 661058.49240271724],
						[524068.40354473738, 660997.09798384539],
						[524039.40795328456, 660997.05553706456],
						[524039.45294483926, 660966.30302448315],
						[524011.17704912188, 660966.26168054366],
						[524011.22182610194, 660935.61979323067],
						[523983.04869920987, 660935.57864795148],
						[523983.13830952998, 660874.18426703173],
						[523954.03967916133, 660874.14182082028],
						[523954.08451058232, 660843.38932724472],
						[523925.91122555814, 660843.34827993182],
						[523925.95616531221, 660812.48517064482],
						[523896.85742568405, 660812.44282569375],
						[523896.94703498879, 660750.82724192762],
						[523868.773591256, 660750.78629258671],
						[523868.81794135296, 660720.25505888078],
						[523840.54162222211, 660720.21400858252],
						[523840.63037781982, 660659.040934894],
						[523811.63418981456, 660658.99889005069],
						[523811.72347864305, 660597.38335390948],
						[523754.45065118984, 660597.30045792111],
						[523754.49526817456, 660566.43738677865],
						[523726.21868434444, 660566.39653321181],
						[523726.26260930009, 660535.97594804002],
						[523698.08879718697, 660535.93529134896],
						[523698.13155321695, 660506.28905279899],
						[523669.85709673964, 660504.69961223984],
						[523669.07848037506, 660474.16723126546],
						[523640.9045622854, 660474.12667261995],
						[523640.94864733587, 660443.48486097052],
						[523555.39848791785, 660443.36200061534],
						[523555.44209627638, 660412.94143397908],
						[523441.71822799445, 660412.44694097526],
						[523440.93997187645, 660381.36148399219],
						[523411.94329386443, 660381.32014446566],
						[523411.8990055999, 660412.40442803106],
						[523383.62215670559, 660412.3641640211],
						[523383.66639148275, 660381.279880382],
						[523326.39281080104, 660381.19847639243],
						[523326.43583798892, 660350.88853891345],
						[523269.1621513812, 660350.8073344056],
						[523269.20585615741, 660319.9443005186],
						[523241.03167363652, 660319.90442749299],
						[523241.11882087914, 660258.28899424104],
						[523183.84481151495, 660258.20808710181],
						[523183.88788756332, 660227.67692788679],
						[523098.33660458052, 660227.55644714995],
						[523098.29368748929, 660258.08760659164],
						[523041.01967742405, 660258.00719726877],
						[523040.97640140995, 660288.8702220975],
						[522983.70234391215, 660288.9006327294],
						[522983.65948491055, 660319.54242218658],
						[522955.48530170368, 660319.50303875748],
						[522955.44218616531, 660350.3660734744],
						[522927.1652305118, 660350.32659495401],
						[522927.03666056984, 660442.47324732761],
						[522983.48742994858, 660442.55210876151],
						[522983.44457091874, 660473.19392214727],
						[523012.54391132592, 660473.23464952805],
						[523012.50115294737, 660503.76584732113],
						[523069.67148208787, 660503.84601287683],
						[523069.5849763212, 660565.46152401017],
						[523097.86156175868, 660565.50124760927],
						[523097.81817810115, 660596.36432051333],
						[523155.09100882389, 660596.44492779975],
						[523155.047673469, 660627.19738503755],
						[523166.04979447508, 660627.21289256855],
						[523240.59687578032, 660627.31816102448],
						[523240.55322385073, 660658.18124322477],
						[523268.72682636674, 660658.22111543175],
						[523268.55294680782, 660781.00976973947],
						[523297.65174210328, 660781.0510020206],
						[523297.56469355797, 660842.4453578078],
						[523325.73798013641, 660842.48532776581],
						[523325.65051222953, 660904.1009436266],
						[523354.74908954039, 660904.14227701805],
						[523354.57456433697, 661026.93108414556],
						[523411.02332584577, 661027.01141435502],
						[523410.93585228309, 661088.40584643453],
						[523468.2069679923, 661088.48754508793],
						[523468.11928041454, 661149.88199608843],
						[523497.11460218416, 661149.9234347482],
						[523497.07062511629, 661180.67597770772],
						[523525.34615186392, 661180.71643694793],
						[523525.30196348863, 661211.57960534841],
						[523581.75009064656, 661211.66052207828],
						[523582.52883022156, 661242.19301362918],
						[523610.70143139357, 661242.23347218102],
						[523610.65708251967, 661273.0966500222],
						[523667.92755448155, 661273.17904480384],
						[523667.88357605383, 661303.71036514337],
						[523696.98144569225, 661303.75230460218],
						[523696.93693457107, 661334.61549187824],
						[523867.92515327432, 661334.86298238963]
					]
				],
				[
					[
						[522781.53361985122, 661855.67371986504],
						[522782.29597208131, 661824.92206671182],
						[522810.57039017789, 661824.96129593044],
						[522810.61323778308, 661794.09802874213],
						[522867.88189380383, 661794.17763496889],
						[522867.92438709363, 661763.64623581315],
						[522896.19891063776, 661763.68561238481],
						[522896.28446473065, 661702.29096562741],
						[522925.27881168673, 661702.33139519463],
						[522925.32187441265, 661671.46814769204],
						[522953.59655658121, 661671.50762303721],
						[522953.6823246206, 661610.11300554755],
						[522981.85429496283, 661610.1523858835],
						[522982.02635094739, 661487.14196731569],
						[522868.30944372131, 661486.9833035667],
						[522868.35193694563, 661456.45195237023],
						[522696.5424366197, 661456.21372761473],
						[522696.50026264769, 661486.74507925299],
						[522639.23053506942, 661486.66607037815],
						[522639.14563785074, 661548.28189266007],
						[522610.97356142645, 661548.24309992953],
						[522610.84690681956, 661640.27969667944],
						[522582.57217091433, 661640.2408111518],
						[522582.48748530517, 661701.85668212944],
						[522610.76211518014, 661701.89556750422],
						[522610.72009992111, 661732.42695773195],
						[522638.89186054294, 661732.46575002919],
						[522638.84933567408, 661763.32900796668],
						[522667.84357492364, 661763.36898324976],
						[522667.75887408276, 661824.76365048019],
						[522725.02742321813, 661824.84275878582],
						[522724.98488929356, 661855.59541001893],
						[522781.53361985122, 661855.67371986504]
					]
				],
				[
					[
						[533116.40005153243, 663747.74221500393],
						[533117.28403037973, 663717.21220223606],
						[533144.73275832098, 663717.26755711623],
						[533145.5767016348, 663655.65257262811],
						[533173.84796931001, 663655.70963547379],
						[533173.9714955471, 663594.53570660017],
						[533202.96250333637, 663594.59427269816],
						[533203.08747890603, 663532.75663208729],
						[533231.35895806248, 663532.81379389635],
						[533231.42093963956, 663502.17153575469],
						[533260.41211041925, 663502.23020322644],
						[533260.47347419173, 663471.91981557314],
						[533288.74595462228, 663471.53458876337],
						[533288.93289210624, 663379.27599326242],
						[533314.84008958458, 663379.32850777637],
						[533317.26700078009, 663348.58044749789],
						[533374.53023859125, 663348.69667464891],
						[533374.5929358874, 663317.83320268779],
						[533346.32108678191, 663317.77579438942],
						[533346.50767208869, 663225.84913784871],
						[533317.51601359248, 663225.79031844949],
						[533317.57860327454, 663194.92686579737],
						[533289.30654266605, 663194.86955561256],
						[533289.43094334251, 663133.47452977835],
						[533261.15877698129, 663133.41726803163],
						[533261.28351987829, 663071.80101816414],
						[533232.29158953845, 663071.74234915152],
						[533232.41577614401, 663010.34736178222],
						[533261.40781482053, 663010.40603100997],
						[533261.4696263473, 662979.87447705469],
						[533289.74205693626, 662979.93173933402],
						[533289.86645747116, 662918.53678144771],
						[533318.13899361016, 662918.5940925983],
						[533318.26394843205, 662856.97791133029],
						[533375.52889972203, 662857.09414195945],
						[533375.59069797676, 662826.67323402583],
						[533428.84617282706, 662826.78150575142],
						[533432.91878470581, 662795.81565423787],
						[533603.89179699263, 662796.16446153971],
						[533603.82844485249, 662827.13847112132],
						[533661.09350015002, 662827.25569708575],
						[533661.03117325797, 662857.67660393449],
						[533717.47364529176, 662857.79234133032],
						[533718.23300809122, 662888.54680519109],
						[533747.22526170511, 662888.6063317199],
						[533747.16186618223, 662919.46973390318],
						[533771.42484127742, 662919.51958966255],
						[533775.37163431349, 662950.05937434721],
						[533803.54130718217, 662950.11730944365],
						[533803.47780560865, 662980.980721161],
						[533918.00684335188, 662981.21676444018],
						[533917.94381174853, 663011.7483159001],
						[534003.48059911572, 663011.92512722919],
						[534003.54378967825, 662981.3935761007],
						[534032.53587944829, 662981.45360610215],
						[534032.91786648775, 662797.04756478162],
						[534061.19061168493, 662797.10615460423],
						[534061.50824282097, 662643.8955099748],
						[533946.97776786867, 662643.21598091465],
						[533946.91445526807, 662673.85810055735],
						[533890.4713513396, 662673.74157493305],
						[533890.53455866978, 662643.0994550722],
						[533861.43906087324, 662643.03946375917],
						[533861.56513898692, 662581.86585961306],
						[533833.39483472169, 662581.80782502645],
						[533833.52217470494, 662519.97051212564],
						[533861.69258499704, 662520.02854693029],
						[533861.8186630311, 662458.85498142743],
						[533833.64814785135, 662458.79694641312],
						[533833.90146082221, 662335.78614548012],
						[533804.80541880452, 662335.72625445889],
						[533805.05805856932, 662212.9367729564],
						[533776.88712173933, 662212.8788352597],
						[533777.14046046336, 662089.64694643277],
						[533748.86649783165, 662089.58884541644],
						[533748.92989308573, 662058.72557474428],
						[533719.93617502297, 662058.66604520741],
						[533719.99883471755, 662028.13464235258],
						[533691.72476623522, 662028.07663966517],
						[533691.84975367901, 661967.12446905242],
						[533662.85678054171, 661966.62255631236],
						[533663.04580010835, 661874.36467896483],
						[533634.7714670127, 661874.30677428911],
						[533635.02328128484, 661751.29633849696],
						[533663.29782606533, 661751.35424361192],
						[533663.36037924304, 661720.82288855198],
						[533691.53215974616, 661720.88063159911],
						[533692.41798104206, 661690.0191056038],
						[533704.96164406755, 661690.04483222333],
						[533863.40250071627, 661690.37061342772],
						[533863.27596720587, 661751.7651797178],
						[533920.54477071064, 661751.88330998784],
						[533920.35430681915, 661844.1411262732],
						[533948.62869182741, 661844.19952240074],
						[533948.56515092042, 661874.9521373983],
						[533977.55919317517, 661875.01207038225],
						[533977.49536923075, 661905.87531105592],
						[534005.76964800386, 661905.93380551238],
						[534005.7064577915, 661936.46518806985],
						[534062.97461752628, 661936.58381478535],
						[534062.91063288087, 661967.44706482871],
						[534119.35616323689, 661967.56418285379],
						[534120.2418579607, 661937.14512493927],
						[534177.51093575102, 661936.82166704396],
						[534177.57444521459, 661906.29028514365],
						[534205.74590771506, 661906.34890985931],
						[534205.81016040698, 661875.48567007796],
						[534405.88960643904, 661875.90342443285],
						[534405.95400331228, 661845.15081121423],
						[534434.12557064148, 661845.20982750342],
						[534434.06112104026, 661875.96244061447],
						[534520.42634765839, 661876.1436671525],
						[534520.36150398781, 661907.00690569892],
						[534576.80724198208, 661907.1255952724],
						[534576.54883984511, 662029.91487131105],
						[534548.27477442368, 662029.85539463651],
						[534548.016118214, 662152.86599051638],
						[534519.84507838893, 662152.80677894596],
						[534519.78046703886, 662183.55944014364],
						[534547.95145413966, 662183.61865160358],
						[534547.82235855877, 662245.0133671955],
						[534599.6403307094, 662245.12240742717],
						[534605.0253705146, 662275.55469541834],
						[534662.29234834947, 662275.67541105393],
						[534662.22700310696, 662306.64933333918],
						[534718.77418120229, 662306.76872753829],
						[534718.57922813308, 662399.02679598064],
						[534747.57234557369, 662399.08808777551],
						[534747.5080087852, 662429.50892316131],
						[534775.67857418186, 662429.56852507312],
						[534775.41774030123, 662552.80061185232],
						[534804.51339789981, 662552.86222174112],
						[534804.31819454907, 662645.00978428917],
						[534832.4883904513, 662645.0694836094],
						[534832.35822767846, 662706.4643421981],
						[534860.63112875575, 662706.52430773852],
						[534860.500860292, 662767.91918547743],
						[534832.22806486452, 662767.85922016087],
						[534831.96727006161, 662890.87027721072],
						[534803.79749560833, 662890.81057878549],
						[534803.66743794212, 662952.20551520179],
						[534746.40281815012, 662952.08430679154],
						[534746.27297443617, 663013.4792630577],
						[534717.28094117646, 663013.41797355714],
						[534717.21572283271, 663044.28139144927],
						[534660.67108302901, 663044.16200260923],
						[534660.47668012057, 663136.30979985779],
						[534688.7488415034, 663136.36946961563],
						[534688.68367623363, 663167.23290717369],
						[534745.94754612434, 663167.35391439695],
						[534746.01281896862, 663136.49047707126],
						[534859.71830977197, 663136.73134562024],
						[534859.65282332513, 663167.59478249564],
						[534887.92493086832, 663167.65479500953],
						[534888.38383024477, 663290.44638905488],
						[534916.65572638169, 663290.50645100942],
						[534916.32987183938, 663443.82820932544],
						[534945.3211455734, 663443.88985007675],
						[534945.25502638426, 663474.97457909188],
						[534972.70415905293, 663475.03298811847],
						[534973.39590801147, 663536.4298586807],
						[535002.38701833319, 663536.4916001372],
						[535002.32196919236, 663567.02323439275],
						[535058.86480946478, 663567.14379908936],
						[535058.79800276982, 663598.44979115506],
						[535087.78900365043, 663598.51168331271],
						[535087.72426805331, 663628.8220831682],
						[535115.17314367811, 663628.88073023199],
						[535116.06036965095, 663598.5720884141],
						[535145.05137031828, 663598.63408161979],
						[535145.11834137188, 663567.32808989985],
						[535173.28695587162, 663567.38837354816],
						[535173.35232273804, 663536.85673997249],
						[535230.61490430101, 663536.97943650943],
						[535230.87822066457, 663414.18922051869],
						[535259.14990385831, 663414.24987184885],
						[535259.41390618123, 663291.23849066347],
						[535288.40544918377, 663291.30073683627],
						[535288.59529736661, 663202.91401054396],
						[535316.05320731294, 663199.10123518016],
						[535317.00764466356, 663137.70799314487],
						[535344.45734083117, 663137.76702329051],
						[535345.4109349132, 663076.8162886675],
						[535374.40428539179, 663076.21495707845],
						[535374.60221538902, 662984.28844066802],
						[535402.87463837641, 662984.34933932871],
						[535403.40430332709, 662738.54844736168],
						[535375.13145735371, 662738.48754779459],
						[535375.33010155731, 662646.22932705656],
						[535403.60310629045, 662646.29022696917],
						[535403.80167078681, 662554.14267160418],
						[535432.79451450484, 662554.2051725738],
						[535432.86107494496, 662523.3418355654],
						[535461.13429114735, 662523.40283448389],
						[535461.2663244229, 662462.22928154853],
						[535489.43683371518, 662462.29010726209],
						[535489.56992762559, 662400.67408896808],
						[535517.84335492435, 662400.73518546764],
						[535518.69576648041, 662339.34198504116],
						[535546.96929931978, 662339.40313166683],
						[535547.10308657645, 662277.56591047253],
						[535573.83452723001, 662277.62376678688],
						[535576.22839846788, 662216.67643172038],
						[535604.50214239326, 662216.7376773546],
						[535604.7691888907, 662093.50581746968],
						[535633.04314477916, 662093.56711221323],
						[535633.17629417847, 662032.17245366424],
						[535661.34754084179, 662032.23357413488],
						[535662.30235627294, 661971.28320421395],
						[535690.57748366287, 661970.90211415105],
						[535690.77788904752, 661878.64426083409],
						[535719.77192478417, 661878.70726821665],
						[535719.97225238651, 661786.56007967237],
						[535748.24673648167, 661786.62157266261],
						[535748.31388609146, 661755.75835847808],
						[535720.0393488853, 661755.69686537457],
						[535720.10572390701, 661725.16551838722],
						[535662.83682726522, 661725.04111574288],
						[535662.90381616936, 661694.17791090265],
						[535633.90945480543, 661694.1150038715],
						[535633.97518969397, 661663.8049076841],
						[535605.7014531251, 661663.30112821073],
						[535605.76785499707, 661632.65917438862],
						[535548.49863592908, 661632.53517027432],
						[535548.565170318, 661601.78260027338],
						[535491.29584362626, 661601.65879553324],
						[535491.36203187378, 661571.01685086568],
						[535405.92056027707, 661570.83251468779],
						[535405.98682754626, 661540.07995375921],
						[535292.16746855271, 661539.83508371329],
						[535292.10141431377, 661570.58764509507],
						[535177.56254304654, 661570.34202304203],
						[535177.49694000767, 661600.98396897002],
						[535120.3304280031, 661600.86167735595],
						[535120.26469511259, 661631.61424908193],
						[535091.98994427687, 661631.55383674917],
						[535091.9245005569, 661662.19579263311],
						[535062.93008275528, 661662.13389318192],
						[535062.86445703229, 661692.88647478749],
						[535036.95460016746, 661692.83120377641],
						[535034.52400295576, 661723.68936861481],
						[535006.24941056478, 661723.62910383346],
						[535006.18436203117, 661754.1604536731],
						[534948.91556645429, 661754.03853940521],
						[534948.84991843323, 661784.90175681585],
						[534891.58123000932, 661784.78004238359],
						[534891.51639428677, 661815.31140226719],
						[534806.07619304908, 661815.13018533401],
						[534806.01081307395, 661845.99341301795],
						[534776.91390367632, 661845.93180048093],
						[534776.9792289969, 661815.06857268361],
						[534748.80760998453, 661815.00896854256],
						[534748.87171262037, 661784.69884981739],
						[534719.87797850405, 661784.41631400899],
						[534720.07152842858, 661692.82226094371],
						[534777.23912532651, 661692.27943509561],
						[534777.30327989138, 661661.96933552355],
						[534806.40145241539, 661661.58846557967],
						[534806.53150922328, 661600.19393559045],
						[534834.70349655522, 661600.25363870896],
						[534834.7684603146, 661569.61169142148],
						[534806.59642044432, 661569.55198819237],
						[534806.66156599298, 661538.79942487041],
						[534834.83365858742, 661538.85912820708],
						[534834.8990913789, 661507.99594912527],
						[534806.72694586404, 661507.93624567252],
						[534807.18226132344, 661293.00033338834],
						[534778.08437262685, 661292.93871877505],
						[534778.2796455787, 661200.68117325311],
						[534750.10697314644, 661200.62156688015],
						[534750.23587985733, 661139.66966292658],
						[534721.24147499853, 661139.16588444461],
						[534721.37167664175, 661077.5502765628],
						[534693.09597234568, 661077.49055066844],
						[534693.22560078336, 661016.09620277816],
						[534664.94979073538, 661016.03652532457],
						[534665.07931348484, 660954.64219642302],
						[534636.08364709851, 660954.58105020248],
						[534636.21306146798, 660893.18674028688],
						[534662.84393258416, 660893.242897694],
						[534665.40323686914, 660801.10114804411],
						[534693.67941678944, 660801.16082628234],
						[534693.80951217632, 660739.54532427795],
						[534722.08579802222, 660739.60505140154],
						[534722.15054808545, 660708.96323814325],
						[534751.14664790279, 660709.02453624038],
						[534751.21121807548, 660678.49334811163],
						[534779.38478574634, 660678.55295637948],
						[534779.57912152878, 660586.73818040849],
						[534808.67966685607, 660586.13607655745],
						[534809.07030368887, 660401.7323139715],
						[534779.97130491771, 660401.44945585472],
						[534780.16470386682, 660310.07728935801],
						[534793.53296166018, 660309.66310806468],
						[534809.26550480362, 660309.58580750646],
						[534809.46047148679, 660217.54996415146],
						[534780.36067826161, 660217.48834550474],
						[534780.42576890078, 660186.73599385261],
						[534837.70002731169, 660186.85732086352],
						[534837.76452155283, 660156.43683407153],
						[534952.31466093461, 660156.01636777981],
						[534952.37936722813, 660125.59588623361],
						[535008.93405184918, 660125.71627906221],
						[535009.71582287829, 660096.62477484741],
						[535037.99675316608, 660095.02574700559],
						[535038.0623254322, 660064.27341557713],
						[535095.33701068477, 660064.39564058022],
						[535095.46836956218, 660002.89099257393],
						[535122.92330334103, 660002.94965257647],
						[535124.14008053835, 659818.54820237204],
						[535095.8622096919, 659818.48778337729],
						[535095.991914607, 659757.7575500455],
						[535066.99555250257, 659757.03192512237],
						[535067.19171951176, 659665.10696263402],
						[535038.91358461627, 659665.04664163967],
						[535039.04496472364, 659603.4314979671],
						[535010.76672369544, 659603.37122540502],
						[535010.17771390942, 659541.97580632893],
						[534981.89936712408, 659541.91558344522],
						[534981.96506750374, 659511.05271837302],
						[534953.68666750449, 659510.99254403496],
						[534953.81725613144, 659449.59868674946],
						[534896.54042800947, 659449.47695501382],
						[534896.60526294913, 659418.94596258248],
						[534867.60688659025, 659418.88440780493],
						[534867.67331064551, 659387.57908339007],
						[534839.39469816838, 659387.51910573523],
						[534839.58864912589, 659296.03679000493],
						[534583.12590934639, 659295.49506608327],
						[534582.23946930177, 659325.80307058606],
						[534353.95308200491, 659325.32424180792],
						[534354.2736011314, 659172.0056946727],
						[534383.27241314203, 659172.06634359807],
						[534383.3379134573, 659140.76105611841],
						[534411.61695056944, 659140.82024896913],
						[534411.74504759151, 659079.64774058887],
						[534436.83635929192, 659079.70030173357],
						[534439.98580530914, 659048.95459082292],
						[534469.08766790037, 659049.01560669648],
						[534469.15240305662, 659018.15281627933],
						[534497.32881753158, 659018.2119409329],
						[534497.45723257528, 658957.0394711307],
						[534524.91391375114, 658957.09713199106],
						[534526.62386822817, 658926.34843218536],
						[534554.8004401112, 658926.40765537741],
						[534554.86440531327, 658895.98736138828],
						[534612.14409457042, 658895.66542524961],
						[534612.20676787943, 658865.90885157161],
						[534640.48791020713, 658865.19410369778],
						[534640.61778955546, 658803.57920556283],
						[534669.61725171248, 658803.64035978797],
						[534669.87629426655, 658680.85309786978],
						[534698.15612280997, 658680.91278381227],
						[534698.22128659289, 658650.05005166179],
						[534669.94140493823, 658649.99036560592],
						[534670.2653245402, 658496.45110936463],
						[534641.26532030257, 658496.38995399815],
						[534641.65402481146, 658311.98813596461],
						[534584.37323154951, 658311.86749228486],
						[534584.56737869675, 658219.61133729457],
						[534556.28675632388, 658219.55184682296],
						[534556.35095390095, 658189.02104225184],
						[534528.17311770073, 658188.96181640297],
						[534528.23796015361, 658158.09915990743],
						[534499.13451983046, 658158.03803929233],
						[534499.26339874661, 658096.64459682931],
						[534471.08540416392, 658096.58546885895],
						[534471.14967496053, 658065.94406401028],
						[534442.04630326922, 658065.7724257065],
						[534442.11098345544, 658034.90978794498],
						[534413.93288301898, 658034.85075796919],
						[534414.06144260429, 657973.45735277003],
						[534468.15537024429, 657973.57071616128],
						[534471.40768615645, 657942.93601690908],
						[534556.86802315048, 657943.11549358675],
						[534556.8035930543, 657973.75687917741],
						[534585.0846384028, 657973.81637053553],
						[534585.0196899873, 658004.67899821931],
						[534642.30155395449, 658004.79964415368],
						[534642.23719748447, 658035.33042010851],
						[534671.23801533144, 658035.39157719153],
						[534671.17290485976, 658066.25421404955],
						[534727.73467710603, 658066.37363906018],
						[534727.66969416011, 658097.12566167675],
						[534756.67040295992, 658097.18696951761],
						[534756.60559968173, 658127.8283779606],
						[534727.60494495602, 658127.76707023312],
						[534727.53996198485, 658158.51910233847],
						[534756.54056244914, 658158.58040994976],
						[534756.47529125947, 658189.4430655418],
						[534727.47474525694, 658189.38175804366],
						[534727.28003001667, 658281.52727828827],
						[534756.28041340923, 658281.58858544077],
						[534756.15057277551, 658342.98208277998],
						[534784.32814489375, 658343.04169951973],
						[534784.26328899793, 658373.68314570817],
						[534898.82444417814, 658373.9260261571],
						[534898.88951367675, 658343.28458041907],
						[535070.01169871644, 658343.64886294771],
						[535069.94631015661, 658374.29030801158],
						[535127.22688584356, 658374.41264415474],
						[535126.89869957056, 658527.95179626055],
						[535155.89864810917, 658528.01380860235],
						[535155.83262533986, 658558.87651980692],
						[535126.83273125929, 658558.81450758409],
						[535126.30734887463, 658804.61017906503],
						[535183.48358971474, 658804.73249148345],
						[535183.28630966484, 658896.878291292],
						[535211.56576646492, 658896.93886073562],
						[535211.43374563102, 658958.55378295225],
						[535268.71228486742, 658958.67661224958],
						[535268.6465231668, 658989.31815138226],
						[535297.64565755578, 658989.38041385589],
						[535297.51378837996, 659050.77412541967],
						[535325.79298034846, 659050.83489143057],
						[535325.72687402228, 659081.58706390415],
						[535353.1833471033, 659081.64610862278],
						[535353.87440839293, 659142.82037939713],
						[535411.15230536461, 659142.94370516809],
						[535411.08484706038, 659174.24898848683],
						[535468.36263448873, 659174.37251366593],
						[535468.29673833796, 659204.90346589894],
						[535496.47283260804, 659204.96430367301],
						[535496.53878110554, 659174.43335155619],
						[535553.81656789198, 659174.55717458553],
						[535553.7505129776, 659205.08812646731],
						[535582.74926661002, 659205.15089205396],
						[535582.81537540222, 659174.61994028545],
						[535639.37333298556, 659174.7425028868],
						[535639.44122617948, 659143.43722050847],
						[535696.71912099817, 659143.56154162041],
						[535696.85200180695, 659082.38904344547],
						[535722.66314191162, 659082.44513152807],
						[535726.11791129049, 658959.66464530118],
						[535697.11872446153, 658959.60162671632],
						[535697.5197692943, 658774.97816760931],
						[535726.51928191795, 658775.04118689662],
						[535726.71912539401, 658683.11668900284],
						[535754.99895004043, 658683.17819361179],
						[535755.1325251098, 658621.78459982458],
						[535784.13230806531, 658621.84772077738],
						[535784.26647317363, 658560.23290814017],
						[535840.72370879527, 658560.3559397998],
						[535840.791017793, 658529.49323137396],
						[535869.89380029938, 658529.55672793952],
						[535870.02780323953, 658468.16318265803],
						[535897.48530122032, 658468.22313679219],
						[535898.54055186, 658314.68562012655],
						[535927.54087673652, 658314.74899414566],
						[535927.74159673753, 658222.93533071713],
						[535956.02318137547, 658222.55470587173],
						[535956.22478534293, 658130.40922897519],
						[535984.50556111452, 658130.47112852265],
						[535984.70756577014, 658038.21507589472],
						[536013.7083785272, 658038.27860197157],
						[536013.84291436872, 657976.88520957797],
						[536040.47851200693, 657976.94359974889],
						[536042.52787855989, 657792.7671452997],
						[536014.24652165093, 657792.70514589944],
						[536014.31439551152, 657761.73193869437],
						[535957.03168432496, 657761.60651060857],
						[535957.09920819546, 657730.74392655038],
						[535928.81774455681, 657730.68207416334],
						[535928.88424798276, 657700.26196898881],
						[535871.70440586819, 657700.02644458262],
						[535871.77080344514, 657669.60634383524],
						[535728.92316914571, 657669.29517259751],
						[535729.12421393383, 657576.81809303863],
						[535757.40594235191, 657576.87960178591],
						[535757.60642416496, 657484.73442073981],
						[535786.60821361479, 657484.79754606308],
						[535786.67541622662, 657453.93500405282],
						[535814.95735611033, 657453.99661183706],
						[535815.02388863626, 657423.46592992567],
						[535843.2030373438, 657423.52736219927],
						[535843.27034595993, 657392.66482990433],
						[535872.37514168583, 657392.72833086865],
						[535872.44178060733, 657362.19765857351],
						[535899.90160968644, 657362.03638000123],
						[535900.68845053145, 657331.39666672098],
						[536128.28262791957, 657331.89540027571],
						[536128.93517862645, 657362.53826773632],
						[536386.35368083569, 657363.1061658148],
						[536386.42151932861, 657332.46488197171],
						[536529.16923710087, 657332.78153950791],
						[536529.1011324717, 657363.42282276182],
						[536500.9213893601, 657363.58145117597],
						[536500.85358293192, 657394.11212090496],
						[536443.56959039997, 657393.98499698506],
						[536443.50115450844, 657424.84752680163],
						[536415.21916446404, 657424.78483739123],
						[536415.15151696955, 657455.31551685254],
						[536386.14967548801, 657455.25128237146],
						[536386.08134714293, 657486.11382190906],
						[536357.79946252983, 657486.05123130616],
						[536357.66364617425, 657547.44446953456],
						[536328.66196726821, 657547.38033650094],
						[536328.45779386966, 657639.74677589559],
						[536357.45930977853, 657639.81090856949],
						[536357.39103447879, 657670.67347676586],
						[536500.23865677312, 657670.99011054903],
						[536500.17109591782, 657701.41020874144],
						[536487.62438784936, 657701.38234817144],
						[536471.06660135696, 657701.45621455763],
						[536470.93060543726, 657762.73889945669],
						[536442.75203833892, 657762.67639088747],
						[536442.615656871, 657824.1803320843],
						[536414.33435401495, 657824.11764419498],
						[536414.19856854575, 657885.40036730096],
						[536385.19748601527, 657885.33613449964],
						[536385.06082902243, 657947.0613514306],
						[536356.77973762865, 657946.99876258383],
						[536356.50785953295, 658069.89616052504],
						[536384.78873944038, 658069.95874890441],
						[536384.44881090592, 658223.49763829377],
						[536356.16819521424, 658223.43505050358],
						[536355.55616251787, 658500.09296050796],
						[536383.83630212327, 658500.15554725018],
						[536383.5639668759, 658623.16390555678],
						[536412.56374739774, 658623.22813547193],
						[536412.22403717518, 658776.54621333908],
						[536383.22452720499, 658776.48198402161],
						[536383.08811450726, 658838.09685845464],
						[536412.08751574997, 658838.16108752566],
						[536411.88310118101, 658930.41750585276],
						[536382.88386274001, 658930.35327713855],
						[536382.74793975055, 658991.74696084508],
						[536411.74706985173, 658991.81118931854],
						[536411.67942182324, 659022.34210925864],
						[536439.95866271469, 659022.40479257645],
						[536439.8220350889, 659084.01974292216],
						[536467.99833662354, 659084.08224646933],
						[536467.92984723358, 659114.94503838196],
						[536497.03159295721, 659115.0096455554],
						[536496.96427729004, 659145.31934539939],
						[536525.14047372097, 659145.38194691855],
						[536525.003033872, 659207.2181735225],
						[536554.10461618693, 659207.28288176935],
						[536554.03645665501, 659237.92445369356],
						[536524.93492860091, 659237.85974556278],
						[536524.86706918431, 659268.39070292807],
						[536496.69108366175, 659268.32810187631],
						[536496.55424111115, 659329.9431282368],
						[536467.45287601126, 659329.87852190458],
						[536467.38438653492, 659360.74135213764],
						[536381.93142129236, 659360.55194058339],
						[536382.20375755406, 659237.54312472674],
						[536411.20245391212, 659237.6073522456],
						[536411.47451686335, 659114.81985198718],
						[536382.47560383077, 659114.75562399253],
						[536382.54393273278, 659083.89283172577],
						[536325.26582993334, 659083.76612017537],
						[536325.19760860223, 659114.62891267717],
						[536267.91961293248, 659114.50240099942],
						[536267.64862260723, 659237.28990362864],
						[536239.36975150451, 659237.22751682694],
						[536239.09848441777, 659360.23633504589],
						[536210.92265637068, 659360.17422396736],
						[536210.71960788488, 659452.32026864775],
						[536181.61845950678, 659452.25616850471],
						[536181.5509934302, 659482.89778002945],
						[536209.82944177184, 659482.96006733237],
						[536210.44903892884, 659575.10798196099],
						[536238.6244984474, 659575.17009222391],
						[536238.28565793252, 659728.82077010814],
						[536266.5636830806, 659728.88315504033],
						[536266.360317652, 659821.02937091189],
						[536295.35798436054, 659821.09339400358],
						[536295.15372323862, 659913.57151189155],
						[536323.43143045867, 659913.63399468816],
						[536323.29572077794, 659975.02798421844],
						[536352.29311573645, 659975.09210778307],
						[536352.08951098705, 660067.12781762728],
						[536323.09227844339, 660067.06369442225],
						[536322.88908053609, 660158.98882767966],
						[536265.61472498439, 660158.86232404318],
						[536265.47825257771, 660220.69887029601],
						[536209.02672096016, 660220.57437940629],
						[536208.68814278115, 660374.22556078038],
						[536236.86223214562, 660374.28766801814],
						[536236.79539078427, 660404.5975623359],
						[536265.07225302584, 660404.65994470473],
						[536265.00365053583, 660435.74418412056],
						[536294.00023248699, 660435.80820481875],
						[536293.93230813148, 660466.56058873562],
						[536379.48234659561, 660466.74977031944],
						[536379.41450703156, 660497.39153858135],
						[536408.41098019516, 660497.45576117164],
						[536408.47887383006, 660466.81399302883],
						[536436.7556290077, 660466.8766708374],
						[536436.68768263911, 660497.51843886706],
						[536464.86156060535, 660497.58093703259],
						[536464.92955951067, 660466.9391691247],
						[536522.20284125826, 660467.06636746752],
						[536522.27119282377, 660436.31398449396],
						[536607.82138875779, 660436.50435488997],
						[536607.75287708594, 660467.25673750672],
						[536694.02268384758, 660467.44916025863],
						[536693.88607863849, 660528.62207882747],
						[536722.16272744827, 660528.68524777913],
						[536722.02502806229, 660590.30066576414],
						[536779.29787983582, 660590.42876021552],
						[536779.16095605388, 660651.60171627183],
						[536835.61001497379, 660652.17064657842],
						[536836.36341372528, 660683.03552614513],
						[536864.53697360377, 660683.0987095962],
						[536864.468476724, 660713.62988916528],
						[536921.7408986314, 660713.7584800988],
						[536921.80950192618, 660683.22730076767],
						[536979.08202980412, 660683.35609156534],
						[536979.1514863522, 660652.49305665586],
						[537002.69904192351, 660652.10358380585],
						[537007.49718251009, 660621.80430672702],
						[537179.31540705217, 660622.19217398518],
						[537179.10691109882, 660714.33879536029],
						[537150.00799763901, 660714.27298028674],
						[537149.79941467277, 660806.53026551404],
						[537121.6260664271, 660806.46659295924],
						[537121.55709129781, 660836.99779053708],
						[537092.56121730374, 660836.93230948993],
						[537092.42212619097, 660898.54782075924],
						[537064.14611385926, 660898.48401464545],
						[537063.86914166354, 661021.27261410549],
						[537035.59334051993, 661021.20885712921],
						[537035.45496000606, 661082.60318591178],
						[537006.45951942133, 661082.53785680642],
						[537006.32074892905, 661144.1534459854],
						[537035.31608078128, 661144.21877484431],
						[537035.24701515364, 661174.86064585089],
						[537062.69999081956, 661174.92254681187],
						[537063.10659389535, 661359.32883107814],
						[537005.83642212069, 661359.19974740408],
						[537005.69814970926, 661420.59418233309],
						[537034.69299373985, 661420.65951009595],
						[537034.62367867993, 661451.41204497148],
						[537005.62888891809, 661451.3467173333],
						[537005.55937897495, 661482.20987781999],
						[537034.5541142755, 661482.27520533919],
						[537034.34641833371, 661574.42223280424],
						[537062.6212674866, 661574.48598763638],
						[537062.48278092872, 661635.88048957009],
						[537177.02119528153, 661636.13925140374],
						[537177.09077770601, 661605.38668814686],
						[537205.26275612705, 661605.45045579865],
						[537205.3321407811, 661574.8085182067],
						[537262.6015610504, 661574.93829721585],
						[537262.67029987823, 661544.62822672178],
						[537290.94620454614, 661544.24989171722],
						[537291.01625083108, 661513.38672275865],
						[537320.01093111746, 661513.45255400846],
						[537320.08027808368, 661482.921251992],
						[537375.80774554599, 661483.04792262753],
						[537376.70049813588, 661452.1866348139],
						[537405.69528642157, 661452.25261726044],
						[537405.76529598876, 661421.50008395966],
						[537447.30400638981, 661421.59470133705],
						[537519.48265606794, 661421.75936052506],
						[537519.51221009868, 661408.8167492405],
						[537519.55262586439, 661391.11745313276],
						[537576.8226863842, 661391.24832736119],
						[537576.89301595499, 661360.49580442719],
						[537776.97873294388, 661360.95460966672],
						[537777.40270270593, 661176.55019906478],
						[537806.397977388, 661176.6168886153],
						[537806.46848110505, 661145.97502088593],
						[537833.9215050342, 661146.03821039281],
						[537834.81436926627, 661115.50886203512],
						[537862.98769744358, 661115.35251654778],
						[537863.05830640683, 661084.7106586583],
						[537949.32538239495, 661084.68843111093],
						[537949.46717752505, 661023.29411011771],
						[537975.37809019815, 661023.35397393582],
						[537977.81405329285, 660992.60697638255],
						[538006.08990365197, 660992.67235477571],
						[538006.16077890515, 660962.0305167106],
						[538035.15643214178, 660962.09760994348],
						[538035.2271053961, 660931.56639711559],
						[538063.50306079921, 660931.63187431055],
						[538063.57455534081, 660900.76880542294],
						[538090.20541416528, 660900.83051765128],
						[538092.92677928205, 660747.07383006182],
						[538063.93074660329, 660747.00663488579],
						[538064.0017285709, 660716.36483543005],
						[538035.72540272458, 660716.29935737979],
						[538036.36478961108, 660440.08089591388],
						[538007.36898279586, 660439.6819403983],
						[538007.51098876016, 660378.28782149253],
						[537979.23408113606, 660378.22244065511],
						[537979.37623708369, 660316.71772067319],
						[537951.09922350431, 660316.65238825092],
						[537951.17075951293, 660285.67879541207],
						[537893.9996712259, 660285.54685352999],
						[537894.14074197167, 660224.3740214929],
						[537865.04096083168, 660224.30694016197],
						[537865.11182437977, 660193.5546012728],
						[537836.93742512958, 660193.48970224825],
						[537837.00900008855, 660162.40550834453],
						[537779.73465643404, 660162.27372724423],
						[537779.80459705356, 660131.85325728275],
						[537751.52726535732, 660131.7882682936],
						[537751.66856670624, 660070.2836231282],
						[537722.67133972934, 660070.21703015896],
						[537723.23585661058, 659824.30926007405],
						[537780.51137823774, 659824.44084425026],
						[537780.651004905, 659763.71063292096],
						[537809.65029990359, 659763.11361015367],
						[537809.72105763841, 659732.36134292011],
						[537837.17644341476, 659732.42453786533],
						[537838.06963262195, 659701.78478936618],
						[537809.7915608394, 659701.71970011364],
						[537809.86180950503, 659671.18868168606],
						[537838.13993382687, 659671.25377106329],
						[537838.35287508718, 659578.77578788425],
						[537866.52832832106, 659578.84068933339],
						[537866.71542784665, 659497.64594106539],
						[537758.99281751725, 659612.55363460758],
						[537629.63558944443, 659566.1283006547],
						[537534.80037805811, 659532.17226805445],
						[537499.5595857735, 659518.92801633268],
						[537456.68847616471, 659379.44894019072],
						[537485.86810006993, 659300.09030342638],
						[537543.49622757151, 659146.6813643903],
						[537543.81592118111, 659006.7479556402],
						[537508.6724763423, 658950.36221688869],
						[537457.85614351975, 658867.17085565045],
						[537434.47736619075, 658792.33864371793],
						[537414.98370914673, 658727.36048958392],
						[537472.54732389946, 658602.8233107524],
						[537501.79058090854, 658541.27490580198],
						[537607.86924187234, 658472.933194043],
						[537718.58281862969, 658401.83733841195],
						[537719.11699958111, 658169.09527462965],
						[537714.51767913613, 658156.6953500685],
						[537633.36833780631, 657936.04505695938],
						[537806.46614970337, 657750.04901283619],
						[537893.68461406417, 657657.21920884913],
						[537850.0920138408, 657517.73875330156],
						[537846.22677418543, 657499.145859143],
						[537807.4300774819, 657331.02637485461],
						[537777.82876449695, 657233.7243117271],
						[537764.55578269577, 657191.54802974244],
						[537738.83415597002, 657106.42308642017],
						[537721.68202422932, 657051.51680277265],
						[537592.01190745656, 656818.25675196946],
						[537592.3312060748, 656678.65683315601],
						[537592.65025145689, 656539.1676294168],
						[537463.37623700558, 656445.39987689839],
						[537392.08534664917, 656407.0741854806],
						[537290.18265848106, 656351.97595749237],
						[537255.03513151465, 656294.48533252475],
						[537204.20798834809, 656211.84894927568],
						[537161.32611342531, 656072.15171966376],
						[536901.42915002909, 655792.14478930866],
						[536815.34316725086, 655698.92199137725],
						[536599.04312896624, 655558.61784857395],
						[536515.18030902406, 655528.23264140007],
						[536469.6514153966, 655511.87073001347],
						[536296.23692123278, 655511.4868766329],
						[536165.81707214564, 655604.22905630816],
						[536165.50966820715, 655743.93887579255],
						[536165.20250744501, 655883.53817461152],
						[536099.22158620681, 655907.06540024071],
						[536035.60792726872, 655929.93437432719],
						[536008.92732925841, 655948.90221623809],
						[535905.08904373297, 656023.12106131332],
						[535688.5847987266, 656022.6495341463],
						[535559.09365825797, 656022.36887680064],
						[535428.37912020017, 656207.92518222227],
						[535341.78606027854, 656347.670894932],
						[535292.30412190291, 656400.55075624085],
						[535255.2950740325, 656440.51517891535],
						[535124.78466940578, 656533.7083003663],
						[535038.29635733389, 656626.33257675357],
						[534907.69438806642, 656812.33627465356],
						[534869.96703502955, 656852.41073639027],
						[534821.20805797935, 656905.29367700045],
						[534768.51045457332, 656924.09789924789],
						[534690.80233198253, 656951.80959306797],
						[534604.70994076482, 656858.59783477476],
						[534591.43130840338, 656815.09677664971],
						[534561.80886261689, 656718.35384510865],
						[534387.25504194631, 656531.26373358618],
						[534258.68638884649, 656485.08860564209],
						[534129.19889167452, 656484.81921352586],
						[533955.79466260213, 656484.46005270979],
						[533873.3210340573, 656528.53723146243],
						[533782.19921587745, 656577.13241086341],
						[533557.61893235263, 656656.98133876931],
						[533522.21268382377, 656669.85144814325],
						[533435.73368401977, 656762.70545782871],
						[533347.75829046662, 656833.21197485586],
						[533262.04964036809, 656902.06429435557],
						[533208.49867038417, 656987.79606276273],
						[533175.47887845221, 657041.71128825622],
						[533088.18102563114, 657134.56563891331],
						[533117.94200030225, 657166.48378033109],
						[533175.10330723831, 657227.77124340483],
						[533257.34659315262, 657294.86183950957],
						[533348.21530875843, 657368.27564585535],
						[533279.82858870702, 657416.69871262019],
						[533217.72443540324, 657460.82063410128],
						[533118.85628537927, 657478.32012905227],
						[532957.95085337828, 657507.20006437076],
						[532913.84899395925, 657600.91656473221],
						[532871.29291918629, 657693.30888971256],
						[532793.43450509757, 657748.24163734843],
						[532740.80687130941, 657786.07905347017],
						[532610.60973446304, 657785.82019123435],
						[532460.69080615288, 657825.56750872708],
						[532437.84763850656, 657831.82769514038],
						[532221.27526236069, 657878.30416717846],
						[532090.97601538792, 657878.04921993613],
						[532013.99768372078, 657905.33263427101],
						[531961.40956837381, 657924.03553360421],
						[531878.99143148412, 657945.99928725394],
						[531787.93044544454, 657970.26973948337],
						[531614.72042391717, 657877.12615333288],
						[531485.5124012779, 657736.72372202226],
						[531485.95765281375, 657504.31408958673],
						[531545.09049650433, 657344.69382591825],
						[531572.69054925768, 657271.51717070339],
						[531510.1504829441, 657169.62788489927],
						[531486.67204626906, 657131.41942816984],
						[531356.82470364671, 656945.11059234664],
						[531487.38580262417, 656758.85731616803],
						[531228.04912015994, 656572.08104891062],
						[531054.64581189281, 656571.75249627349],
						[530976.85281911935, 656592.40195386845],
						[530881.15499927336, 656617.99595918728],
						[530793.16013082932, 656649.46773173567],
						[530751.5812083137, 656664.43399210763],
						[530687.2410952081, 656641.30510052363],
						[530492.06210122199, 656570.69914759893],
						[530318.38391231361, 656663.62917715963],
						[530144.89656049025, 656709.65919724363],
						[530015.41083269124, 656709.42221501796],
						[529842.09312881273, 656662.75747915299],
						[529625.76539631106, 656569.11480142188],
						[529570.18266427098, 656479.30321985378],
						[529539.6233699813, 656429.2487889129],
						[529501.990454674, 656022.43810810812],
						[529496.5422339252, 655963.46890245669],
						[529490.30552903574, 655942.66151967121],
						[529453.69709131576, 655823.79214330611],
						[529281.33771401271, 655637.20361402933],
						[529151.288936864, 655543.72161444812],
						[529122.23672338983, 655512.14404099504],
						[529065.05512200098, 655450.42872617184],
						[528940.76217377326, 655182.51461288903],
						[528935.331165532, 655170.89020254661],
						[528675.61545834085, 655170.4350610812],
						[528545.13318519178, 655263.23736855714],
						[528285.81963109341, 655029.93906545395],
						[528156.55998537235, 654890.00726042059],
						[528052.34886399412, 654777.77364412439],
						[527983.45605247642, 654703.43196746032],
						[526468.01028021425, 654700.92192658968],
						[526381.21439509385, 654561.07276705327],
						[526343.48584477196, 654547.51695580303],
						[526251.7862902066, 654514.18508393108],
						[526121.68220810662, 654374.37893781788],
						[525905.37641836703, 654234.32722963474],
						[525904.64251058584, 654700.02444128087],
						[525923.37285243266, 654759.12362559047],
						[525948.34363708016, 654839.69247188582],
						[526034.49529461772, 654933.07918220153],
						[526077.47450848448, 655072.85719361901],
						[525990.92607111961, 655165.9707055802],
						[525990.7051583312, 655305.68039843952],
						[525990.48442030128, 655445.27957052272],
						[525915.89110982884, 655524.80656807381],
						[525903.32147232804, 655538.28212250944],
						[525816.77646491211, 655631.3967665825],
						[525859.4627823456, 655957.34424812917],
						[525815.89905426628, 656190.01618340216],
						[525749.16665216687, 656244.00377756427],
						[525642.27340430045, 656329.67637470411],
						[525470.29595767334, 656403.191324624],
						[525425.62928552472, 656422.36974242423],
						[525512.13425811008, 656748.49606027151],
						[525489.2920046699, 656821.24756429857],
						[525482.98881464975, 656840.26416913746],
						[525468.82451675879, 656888.14002469089],
						[525494.52505868836, 657028.00172236771],
						[525511.55594887817, 657121.05840714113],
						[525584.2697405736, 657318.07272168854],
						[525597.58298469009, 657354.37640610128],
						[525597.29319473612, 657540.43681829562],
						[525597.07524908439, 657680.36940664612],
						[525596.85816472524, 657819.74899934186],
						[525380.13090511819, 657912.55411853106],
						[525379.91531566612, 658052.15511448402],
						[525445.72610185714, 658122.94253485603],
						[525509.89313212386, 658192.28964305448],
						[525509.67660813604, 658331.78021431714],
						[525409.33432939043, 658313.81505558582],
						[525250.08188848826, 658285.14044151385],
						[525243.79261505522, 658295.63961207157],
						[525243.74656723719, 658325.61737184203],
						[525300.20460892969, 658325.70419220231],
						[525300.11009342619, 658387.09777304239],
						[525329.2131281211, 658387.14260303031],
						[525329.16556025459, 658418.0053291251],
						[525471.90384988906, 658418.22594784736],
						[525471.8565283193, 658448.75682097534],
						[525500.13675627997, 658448.80067852559],
						[525500.0888672315, 658479.66341366165],
						[525581.63860737649, 658479.79015514837],
						[525586.32157489378, 658510.32840176695],
						[525785.61930580239, 658510.63990301185],
						[525785.57088042249, 658541.50264684635],
						[525814.57080506452, 658541.54817499919],
						[525814.52249897807, 658572.30030436837],
						[525842.80251433875, 658572.34475158888],
						[525842.75398137176, 658603.20750483277],
						[525871.75379712868, 658603.25313389767],
						[525871.70573213545, 658633.78403420874],
						[525928.16271513538, 658633.87301188172],
						[525928.11402166553, 658664.73577441613],
						[525957.21656468522, 658664.78171653871],
						[525957.2653128102, 658633.91895409208],
						[525985.44238609995, 658633.96348434908],
						[525985.39358505805, 658664.82624671073],
						[526014.49612791883, 658664.87229026947],
						[526014.44779754069, 658695.40319961042],
						[526071.72725404135, 658695.49397282279],
						[526071.678290757, 658726.35674447205],
						[526099.85520555102, 658726.40147089958],
						[526099.95271089533, 658665.0077902436],
						[526128.23256671871, 658665.05272864969],
						[526128.33017768327, 658603.65906714962],
						[526157.3299926403, 658603.70520015177],
						[526157.37911638618, 658572.84244784829],
						[526185.65913081064, 658572.88748507609],
						[526185.75730823842, 658511.27261416102],
						[526213.21473420598, 658511.31638794136],
						[526214.80598815111, 658480.78796810971],
						[526243.08616099134, 658480.83310416213],
						[526243.18419983599, 658419.43950034515],
						[526271.46447824617, 658419.48468522914],
						[526271.51381573582, 658388.62196191296],
						[526471.53288553457, 658388.94293221366],
						[526471.48317240935, 658419.80565492925],
						[526614.32428373687, 658420.03636189445],
						[526614.27483978448, 658450.56723166315],
						[526728.73262202367, 658450.75299187214],
						[526728.68242567801, 658481.61572333728],
						[526863.70738884038, 658481.8358881321],
						[526871.52299975359, 658481.84866583638],
						[526871.47307777661, 658512.37954426114],
						[526986.03326629673, 658512.5672646577],
						[526985.98258653993, 658543.43000487227],
						[527214.27983657352, 658543.8064783524],
						[527214.22891125025, 658574.55860349559],
						[527442.52572882664, 658574.93824775144],
						[527442.47419156099, 658605.80099612346],
						[527557.03372883168, 658605.99269696895],
						[527556.87958452443, 658697.91725441534],
						[527584.33669864794, 658697.96331904759],
						[527585.26132363582, 658637.23475308635],
						[527614.26219461311, 658636.61974190339],
						[527614.31349696324, 658606.08884685498],
						[527642.59345417493, 658606.13639124972],
						[527642.79980399611, 658483.45976281399],
						[527670.97769403481, 658483.17532574467],
						[527671.02928748901, 658452.53383538965],
						[527699.30988184363, 658452.36023920123],
						[527700.23606107559, 658390.96804053115],
						[527722.14046012342, 658391.00497609656],
						[527728.46543779992, 658360.26346427505],
						[527785.74606242205, 658360.36021169147],
						[527785.84986349219, 658298.96665534365],
						[527814.13034921547, 658299.01449492341],
						[527814.18220895529, 658268.37303343974],
						[527840.09746593516, 658268.41691470623],
						[527843.2347167891, 658237.67006574385],
						[527814.23425590771, 658237.62095771171],
						[527814.44244362658, 658114.61270231404],
						[527843.44312157994, 658114.66181072011],
						[527843.80707998911, 657899.84002244216],
						[527872.08825255116, 657899.88796175562],
						[527872.40173948521, 657715.04406518699],
						[527899.86049578001, 657715.09065699391],
						[527901.76820457575, 657500.05068242899],
						[527872.76644205069, 657500.00147109979],
						[527872.97393212072, 657377.65738258197],
						[527844.6926105381, 657377.16696778371],
						[527844.74433669297, 657346.63626657485],
						[527815.7426778808, 657346.36591892806],
						[527815.79453737265, 657315.72460387123],
						[527787.51235955965, 657315.6767614336],
						[527787.56435334147, 657284.92483254313],
						[527759.38496700185, 657284.87721238856],
						[527759.48866224906, 657223.48398703639],
						[527730.38356681692, 657223.43485325435],
						[527730.43564003403, 657192.57231997373],
						[527702.25609534641, 657192.52479776845],
						[527702.30755627807, 657161.99412428355],
						[527673.2023519543, 657161.94509176491],
						[527673.25431758154, 657131.0825677719],
						[527645.07466746564, 657131.03514361789],
						[527645.12639410235, 657100.28324263566],
						[527616.8438455452, 657100.23569388734],
						[527616.94700707949, 657038.8425242441],
						[527587.9444306806, 657038.79381552944],
						[527587.99586442637, 657008.15254682023],
						[527559.71315732633, 657008.10509638675],
						[527559.81647580699, 656946.49071809615],
						[527587.27651618968, 656946.53678763984],
						[527588.15053697664, 656916.00753236259],
						[527701.89907952608, 656916.1988619488],
						[527702.67039291747, 656946.73088474153],
						[527759.95594440645, 656946.82754225843],
						[527760.16333452135, 656824.04131783103],
						[527788.34351100563, 656824.08893931983],
						[527788.4476853346, 656762.47461920511],
						[527816.73081512703, 656762.5224632544],
						[527816.78248725098, 656731.99185572634],
						[527788.49930492009, 656731.94401158637],
						[527788.55148557783, 656701.08155426383],
						[527845.83789327403, 656701.17851112643],
						[527845.94190746825, 656639.78546535235],
						[527902.50858923164, 656639.88140000263],
						[527903.28036119288, 656609.35203368147],
						[527988.8504817395, 656609.49753067363],
						[527988.90303818649, 656578.63509289222],
						[528017.08363544289, 656578.68310657481],
						[528017.13530198298, 656548.37376378523],
						[528046.24234792101, 656547.98093325668],
						[528046.29501192679, 656517.11850512843],
						[528074.47571465629, 656517.16661721631],
						[528074.6331095706, 656425.02183344553],
						[528103.73961891886, 656425.07157686376],
						[528103.79201216984, 656394.43040373037],
						[528131.97292526159, 656394.478614402],
						[528132.02518170653, 656363.94806396216],
						[528160.30899729929, 656363.99649925937],
						[528160.36187485349, 656333.13409981818],
						[528189.36569649074, 656333.18381865358],
						[528189.41843877756, 656302.43204194272],
						[528217.70236023259, 656302.48057600507],
						[528217.91354096774, 656179.47351658856],
						[528246.19767401309, 656179.52209968644],
						[528247.12865122478, 656056.73758873367],
						[528302.87452237075, 656056.83348725864],
						[528303.43332530104, 656210.15117351268],
						[528332.43736396276, 656210.20114481659],
						[528332.17174408387, 656364.29185615119],
						[528303.16797733994, 656364.24188531458],
						[528303.11540298839, 656394.77243521065],
						[528274.83164035343, 656394.72375416337],
						[528274.77892823447, 656425.36492675031],
						[528246.49521824729, 656425.31629446673],
						[528246.33685982251, 656517.46107658907],
						[528274.62041124271, 656517.50970860058],
						[528274.40880141163, 656640.51697432506],
						[528302.69214107387, 656640.56565464148],
						[528302.58642075909, 656701.95869750378],
						[528331.58959155076, 656702.00866731501],
						[528331.27172403096, 656886.40914459736],
						[528359.45179358043, 656886.45774530189],
						[528359.34585953318, 656947.85086310538],
						[528416.63140711316, 656947.94980946032],
						[528416.57804619707, 656978.81230263331],
						[528444.86080370285, 656978.86122760072],
						[528444.75454997411, 657040.25437314261],
						[528473.75712379161, 657040.3045938306],
						[528473.70384692587, 657071.05648272659],
						[528501.98644569214, 657071.10550600023],
						[528501.93330773141, 657101.74678120145],
						[528616.5033297356, 657101.94586756418],
						[528616.44978555746, 657132.69776542776],
						[528702.01718137099, 657132.84697542212],
						[528701.96328390122, 657163.70949609834],
						[528759.14523387386, 657163.80945668672],
						[528759.09180971386, 657194.34012680373],
						[528816.37649815192, 657194.4404664773],
						[528816.3223857187, 657225.30299625138],
						[528873.60696623533, 657225.4035354068],
						[528873.55294055806, 657256.15545134433],
						[528959.11969360197, 657256.30599990301],
						[528959.06570272567, 657286.94730186253],
						[529016.35006838152, 657287.04833854525],
						[529016.29577539407, 657317.80026345898],
						[529044.57794955629, 657317.85022045043],
						[529044.46945321315, 657379.24346581101],
						[529069.5633611962, 657379.28783186746],
						[529072.59408341127, 657410.15584676154],
						[529101.59600448585, 657410.2071753667],
						[529101.54194329877, 657440.73788190912],
						[529129.10400139983, 657440.78670962679],
						[529129.76920397813, 657471.65055229189],
						[529158.77101653081, 657471.70198179199],
						[529158.71684891754, 657502.23269753437],
						[529186.99870569538, 657502.28289960732],
						[529186.94389618258, 657533.14547560434],
						[529244.2274037149, 657533.24730655446],
						[529244.11776635784, 657594.8618538864],
						[529301.40105877735, 657594.96388411708],
						[529301.34623131342, 657625.71585541801],
						[529329.62787559803, 657625.76630293508],
						[529329.57279779844, 657656.62889751024],
						[529415.03462368972, 657656.78163619002],
						[529414.9801773408, 657687.20176068181],
						[529443.26171581342, 657687.25240374927],
						[529443.97446009796, 657748.64723381796],
						[529501.15437492379, 657748.74977603578],
						[529501.0987760023, 657779.72300770483],
						[529529.38015526102, 657779.77379896934],
						[529529.32529806043, 657810.30456051813],
						[529557.60662469559, 657810.35540035379],
						[529557.55111810355, 657841.21802266722],
						[529529.26984457951, 657841.16718292504],
						[529529.21518612537, 657871.58733513253],
						[529557.49640729825, 657871.63817477832],
						[529557.4403038423, 657902.83266285853],
						[529529.15913634899, 657902.78182330891],
						[529528.93891233625, 658025.34744827484],
						[529443.47900301858, 658025.19411727076],
						[529443.42370996776, 658056.0567732791],
						[529386.14202468749, 658055.95424802485],
						[529386.19721016777, 658025.09159182664],
						[529328.91541696002, 658024.98926604004],
						[529328.96990262566, 657994.45847087551],
						[529271.68800264527, 657994.35634455062],
						[529271.57865305908, 658055.74979648832],
						[529295.84881090256, 658055.79304270574],
						[529300.25066645897, 658240.20318296831],
						[529271.25021004141, 658240.15150380367],
						[529271.19543667173, 658270.90357480431],
						[529242.91490257031, 658270.85322783398],
						[529242.86037894688, 658301.49468469783],
						[529214.5798974908, 658301.44438649109],
						[529213.77724482014, 658348.01370566385],
						[529213.75089492113, 658362.83665390487],
						[529157.19014304026, 658362.73620634573],
						[529150.86249280965, 658393.47716817679],
						[529128.13539674005, 658393.43687009509],
						[529128.02658055397, 658454.83044621639],
						[529099.74636296683, 658454.78034562187],
						[529099.2564795824, 658731.43884114409],
						[529070.25689002732, 658731.38751666597],
						[529070.20288235787, 658761.91842593614],
						[529042.02602845524, 658761.8686065767],
						[529041.9171403416, 658823.48353580083],
						[528984.63812993024, 658823.38240999461],
						[528984.47541249159, 658915.63891128451],
						[528956.19598788326, 658915.58905772306],
						[528955.97963269276, 659038.37655447214],
						[528926.98058477207, 659038.32548282505],
						[528926.87212602596, 659099.94049879326],
						[528898.59301857406, 659099.89074435388],
						[528898.48466582166, 659161.50577968184],
						[528870.20566431177, 659161.45607408823],
						[528869.93631056801, 659314.77471965435],
						[528898.21504823596, 659314.82442477776],
						[528898.16077454307, 659345.68728328438],
						[528926.43945901771, 659345.73703697883],
						[528926.38610580284, 659376.04680225556],
						[528955.38455776183, 659376.09787285165],
						[528955.32939681516, 659407.40321913885],
						[529012.60637162393, 659407.50424278947],
						[529012.49837038852, 659468.67689451494],
						[529068.95248514973, 659468.77666218439],
						[529068.84349100129, 659530.39181116491],
						[529097.84167059627, 659530.44313314767],
						[529097.73295943683, 659591.83706173464],
						[528869.45026839478, 659591.43442334572],
						[528869.396242077, 659622.18670540443],
						[528790.93706632277, 659622.0490536663],
						[528783.12199766946, 659622.03536312783],
						[528783.0679390335, 659652.89827001002],
						[528697.61649313418, 659652.74881758261],
						[528697.67039127904, 659621.88591042277],
						[528640.39416370192, 659621.78598448948],
						[528640.44776146661, 659591.03370167455],
						[528583.89123667497, 659590.9352272416],
						[528583.22510933736, 659560.07107727439],
						[528554.94679370208, 659560.02191419899],
						[528554.89316382562, 659590.88481220149],
						[528526.61490121612, 659590.83569788409],
						[528526.50793969969, 659652.45088878227],
						[528497.50997540669, 659652.40057500266],
						[528497.45702859235, 659682.93162834027],
						[528469.17892438022, 659682.88261285308],
						[528468.85945044423, 659867.28585113352],
						[528572.407564183, 659867.46557205985],
						[528583.41019387997, 659867.48470687435],
						[528583.35650946165, 659898.34765283321],
						[528611.6342428925, 659898.39686479699],
						[528611.58108317992, 659928.92795578646],
						[528668.85624021548, 659929.02778129478],
						[528668.80239509849, 659959.89073658665],
						[528697.08002261887, 659959.94009558624],
						[528696.97319205652, 660021.11292069231],
						[528725.97050570045, 660021.1635864561],
						[528725.86279364116, 660082.77891031001],
						[528782.31479869329, 660082.87769325462],
						[528782.2609336914, 660113.6300522146],
						[528811.25808407215, 660113.68086848408],
						[528811.15024551144, 660175.18560061161],
						[528837.8851067092, 660175.23249765032],
						[528839.37353033142, 660205.98757775268],
						[528868.37051773712, 660206.03849479835],
						[528868.20882692304, 660298.0744026372],
						[528896.48567794752, 660298.23472489126],
						[528896.43179304502, 660328.87649694853],
						[528923.88618218154, 660328.92479968665],
						[528924.60110502911, 660390.09918573929],
						[528981.87465464952, 660390.20010228036],
						[528981.71154571068, 660482.67857584904],
						[529009.88544912694, 660482.72829178686],
						[529010.65414159279, 660513.26092422428],
						[529067.10466774367, 660513.36068554898],
						[529067.04948550381, 660544.55559171166],
						[529124.32249676564, 660544.65700475487],
						[529124.26857825392, 660575.07757385238],
						[529238.81438765756, 660575.28099842928],
						[529238.75946972403, 660606.14405296487],
						[529267.03598514257, 660606.19439277775],
						[529266.98199923348, 660636.50435059937],
						[529295.97743802448, 660636.99850339338],
						[529295.81334754301, 660729.03460826678],
						[529324.08965148556, 660729.08504625829],
						[529324.0351650652, 660759.61626355292],
						[529353.03117550991, 660759.66803586017],
						[529352.97564715473, 660790.75235969457],
						[529409.42522000545, 660790.85329704301],
						[529409.37057480821, 660821.38452363096],
						[529495.63852243836, 660821.53915378859],
						[529495.69332793576, 660791.00792748388],
						[529523.96952523128, 660791.05870944099],
						[529524.02537705842, 660759.97438618424],
						[529549.1141231386, 660760.01948445453],
						[529552.35653831589, 660729.49400035816],
						[529638.62496838451, 660729.64938121708],
						[529638.68023876077, 660699.00754938915],
						[529694.41036501492, 660699.1081675248],
						[529695.24107795942, 660637.71519903443],
						[529719.61104655359, 660637.31677574385],
						[529724.45038643223, 660576.81604356179],
						[529752.62533022836, 660576.20331147616],
						[529752.84766037483, 660453.41486980964],
						[529781.12443861505, 660453.46609428781],
						[529782.00217144121, 660423.047037257],
						[529924.72365030297, 660422.97447091364],
						[529924.66764607595, 660453.72687885538],
						[529952.94442378159, 660453.77839901124],
						[529952.55202352186, 660669.04538855318],
						[529928.18290162866, 660669.00098523009],
						[529924.16421201953, 660730.16690571129],
						[529952.44051401399, 660730.21842500055],
						[529952.048314846, 660945.37509695301],
						[529923.7723831035, 660945.32357833511],
						[529923.66057580267, 661006.71794205601],
						[529951.93640189222, 661006.76946047565],
						[529951.60025953408, 661191.17390753992],
						[529980.59550842387, 661191.22678727703],
						[529980.48348699138, 661252.6212275594],
						[529951.4883464413, 661252.56834802055],
						[529951.43208741443, 661283.43150644796],
						[529980.4271735017, 661283.48438588774],
						[529980.37146552629, 661314.01568707987],
						[529992.91541559889, 661314.03857981367],
						[530036.81924073072, 661314.11877980072],
						[530036.76282119367, 661344.98194760922],
						[530065.86061773519, 661345.03516576882],
						[530065.91709192679, 661314.17199806229],
						[530123.18742068915, 661314.2768926532],
						[530123.2433940405, 661283.74559194245],
						[530179.69127323641, 661283.84917549207],
						[530179.74796101241, 661252.98601785197],
						[530208.7431008236, 661253.03930019517],
						[530208.85597514373, 661191.64486147626],
						[530236.30892277893, 661191.69535699231],
						[530237.18807476212, 661160.94434833433],
						[530266.18337699864, 661160.9977320343],
						[530266.23981924704, 661130.35583518166],
						[530294.51543257805, 661130.40794312698],
						[530294.57213150465, 661099.65543061646],
						[530322.74497706036, 661099.70739757328],
						[530322.80193284736, 661068.8442694617],
						[530351.9002184018, 661068.89799417288],
						[530351.95661582262, 661038.36673253321],
						[530408.40533799969, 661038.47110180731],
						[530409.17140206345, 661069.00388555485],
						[530580.16238447349, 661069.3212265186],
						[530580.10494528338, 661100.18435373507],
						[530779.37126790173, 661100.55641581875],
						[530780.2060200799, 661039.1633774006],
						[530808.48179033841, 661039.21636980737],
						[530808.76988538541, 660885.56455704663],
						[530824.50164282031, 660885.59406143823],
						[531008.03881074872, 660885.9393922314],
						[531008.68769890082, 660977.97714700468],
						[531091.04761251109, 660978.13278021035],
						[531094.01565431408, 661039.75422336371],
						[531123.0111704024, 661039.809119071],
						[531122.77859266324, 661162.59790681885],
						[531151.0541505079, 661162.65148874291],
						[531150.58815254353, 661408.45053562499],
						[531122.31301768287, 661408.39695450547],
						[531122.13847929519, 661500.54402173264],
						[531093.14377623808, 661500.48912756902],
						[531092.85301020497, 661654.14141711791],
						[531064.68111527653, 661654.08812974149],
						[531064.50689727312, 661746.23531335162],
						[531036.23234368756, 661746.18188036967],
						[531036.11637367262, 661807.57648679568],
						[531121.55661423865, 661807.73809960403],
						[531121.49815529515, 661838.601341167],
						[531236.03515662567, 661838.81868839683],
						[531235.97669282684, 661869.57131346932],
						[531264.25103407644, 661869.62509018742],
						[531264.19230685197, 661900.48834097572],
						[531292.46659490047, 661900.54216624785],
						[531292.11580884724, 662084.72618307592],
						[531321.10948092677, 662084.781428357],
						[531320.93339807296, 662177.15005447948],
						[531349.20721002878, 662177.20397739497],
						[531348.97292437998, 662299.99347585265],
						[531377.96621658897, 662300.04882146511],
						[531377.90727408952, 662330.91213989258],
						[531406.18082144402, 662330.96616084804],
						[531406.0634645517, 662392.36094839592],
						[531434.23409364675, 662392.41482110601],
						[531434.17589166516, 662422.83566884696],
						[531463.2717794237, 662422.89136169362],
						[531463.2120406843, 662454.08656312048],
						[531520.37558413553, 662454.19613072521],
						[531520.31701019558, 662484.72760909062],
						[531543.14126020612, 662484.77141278738],
						[531548.47219020932, 662546.28733137099],
						[531604.91573201283, 662546.39581120026],
						[531605.62012016424, 662607.79224729701],
						[531629.98636671063, 662607.83913835348],
						[531633.77498110128, 662669.24153317465],
						[531662.76762171451, 662669.29738136206],
						[531662.70835596335, 662700.05013577035],
						[531690.98126808321, 662700.10464682092],
						[531690.92173602525, 662730.96802743222],
						[531719.09178454627, 662731.0223885522],
						[531719.03284025728, 662761.55390956881],
						[531805.39341188164, 662761.72086479771],
						[531805.33366465615, 662792.58425473352],
						[531940.2203975732, 662792.84593063686],
						[531948.03395825275, 662792.86112262041],
						[531947.97372784372, 662823.8351384307],
						[532033.51149357879, 662824.00169341033],
						[532033.45218031947, 662854.42260628927],
						[532090.71714052651, 662854.53435870714],
						[532090.65707301104, 662885.28714071773],
						[532118.82685693994, 662885.34218721953],
						[532118.76652042917, 662916.20559553523],
						[532168.21776332229, 662916.30234490312],
						[532176.03126529232, 662916.31764532172],
						[532175.97147113446, 662946.84919364611],
						[532204.2439585512, 662946.90458794578],
						[532204.12361462263, 663008.2995635746],
						[532261.38803849195, 663008.41191086301],
						[532261.20687570621, 663100.67034252035],
						[532290.19875499699, 663100.72729791387],
						[532290.01764673949, 663192.87515138683],
						[532318.28971078678, 663192.93074194773],
						[532318.16850350227, 663254.54703791917],
						[532375.43206907541, 663254.65978271514],
						[532375.37168502773, 663285.3020051989],
						[532402.82113459997, 663285.35612050374],
						[532403.4805646789, 663315.88914532482],
						[532460.7439164411, 663316.00218747812],
						[532460.68293589796, 663346.8656628778],
						[532517.94617969112, 663346.97890440817],
						[532517.88531051506, 663377.73176271399],
						[532552.42824371275, 663377.80016996805],
						[532888.9134158236, 663378.47032947687],
						[532888.79095276864, 663439.64419245603],
						[532917.78223388793, 663439.70225531072],
						[532917.41230416473, 663624.33017881226],
						[532945.68362573872, 663624.38684901944],
						[532945.49816912727, 663716.86680942611],
						[533002.76012328011, 663716.98174077435],
						[533002.69878953742, 663747.51341183495],
						[533116.40005153243, 663747.74221500393]
					]
				],
				[
					[
						[534030.81750615465, 663811.0064053],
						[534030.88120915042, 663780.25348443922],
						[534087.32051172364, 663780.37049242319],
						[534087.38409083278, 663749.72819866054],
						[534116.47762878146, 663749.78859009815],
						[534117.11648889969, 663442.14908031281],
						[534088.02240614814, 663442.08868774201],
						[534088.21314310725, 663350.16198152001],
						[534031.77236257668, 663350.04497047421],
						[534031.83629456663, 663319.18150104256],
						[533974.57295387902, 663319.06298284989],
						[533974.44553379447, 663380.67930528498],
						[533945.45414852002, 663380.61937779025],
						[533944.75519249146, 663718.90108172921],
						[533973.74598082062, 663718.96100799181],
						[533973.55587971839, 663810.88789065648],
						[534030.81750615465, 663811.0064053]
					]
				],
				[
					[
						[538170.55021802033, 664158.16606518917],
						[538170.76457952557, 664065.90720707376],
						[538285.28605414345, 664066.17369467684],
						[538285.50028527807, 663974.24674825359],
						[538199.14608709642, 663974.04573092295],
						[538199.07509501628, 664004.57741984213],
						[538113.64627811278, 664004.37900328287],
						[538113.57518814504, 664035.02131948143],
						[538028.86614521407, 664034.82501330657],
						[538027.90109821688, 664096.43962365226],
						[537998.91097599815, 664096.37254321924],
						[537998.7689673272, 664157.76783288864],
						[538170.55021802033, 664158.16606518917]
					]
				],
				[
					[
						[536970.64584043226, 664431.9789718918],
						[536970.71504936449, 664401.22596510558],
						[537084.51458690164, 664401.48246270674],
						[537084.58425857557, 664370.61883900501],
						[537199.00080894073, 664370.87752205948],
						[537199.06994408998, 664340.34577061364],
						[537284.59981427062, 664340.53966461087],
						[537284.66986156476, 664309.67605157348],
						[537341.92974945519, 664309.80610709614],
						[537341.99914995837, 664279.27436596609],
						[537399.25964748696, 664279.18337682949],
						[537399.3989131375, 664218.00928740064],
						[537427.66921307857, 664218.07367042731],
						[537427.80959205888, 664156.45711193769],
						[537456.79960824759, 664156.52318457258],
						[537456.93959147576, 664095.12789025228],
						[537485.21010287444, 664095.19237229601],
						[537485.35069653357, 664033.57585352613],
						[537513.51851160743, 664033.64014971512],
						[537513.72867637582, 663941.60258590919],
						[537485.5617131443, 663941.09580117487],
						[537485.77045794763, 663849.61139098695],
						[537457.49952394399, 663849.54690798582],
						[537457.57039822929, 663818.4621302099],
						[537428.57978548075, 663818.3960562126],
						[537428.64984882018, 663787.64314918558],
						[537400.37880817743, 663787.57876447367],
						[537400.72860826855, 663633.92492388608],
						[537428.9999133274, 663633.98930920428],
						[537429.068968495, 663603.67891888565],
						[537458.05996014446, 663603.74499374686],
						[537458.13133878261, 663572.43901176762],
						[537486.40274964925, 663572.50349586504],
						[537486.4724152612, 663541.97187179211],
						[537543.63217366301, 663542.10239576979],
						[537543.70219829003, 663511.46015494864],
						[537571.97371409065, 663511.52478629712],
						[537572.04404442688, 663480.77192866546],
						[537601.03525296529, 663480.83825582801],
						[537601.10639710329, 663449.75353790773],
						[537629.37801908888, 663449.81826804113],
						[537629.51813396474, 663388.64444294875],
						[537658.50950507738, 663388.71087153058],
						[537658.57999682461, 663357.95803377987],
						[537686.85177677753, 663358.02286282287],
						[537686.99261232256, 663296.62782386586],
						[537715.26449781668, 663296.692701797],
						[537715.33484142285, 663266.05050055392],
						[537744.32642887207, 663266.11708057602],
						[537744.39708068455, 663235.36426265817],
						[537772.66907160264, 663235.42923937435],
						[537772.81022670213, 663174.03424001229],
						[537801.80197652278, 663174.10092145356],
						[537801.87299002067, 663143.23749680026],
						[537772.88118573686, 663143.17081523151],
						[537773.02284944023, 663081.55460194533],
						[537744.7505937235, 663081.48962461739],
						[537744.82073718135, 663050.95807901793],
						[537715.828770058, 663050.89149812621],
						[537715.96971103409, 662989.49655657751],
						[537687.69729690079, 662989.43167743122],
						[537687.85183506855, 662922.0631960649],
						[537687.90893043787, 662897.173368952],
						[537659.63635743444, 662897.1085380991],
						[537659.73119141138, 662855.73612125614],
						[537659.77657986025, 662835.93488743552],
						[537602.51155479101, 662835.80372406379],
						[537602.58244551532, 662804.82973082247],
						[537573.5900440563, 662804.7634009294],
						[537573.66062711971, 662773.90003387141],
						[537516.39538583253, 662773.76917066402],
						[537516.46510351344, 662743.23767234385],
						[537402.75688929891, 662742.97841662262],
						[537402.89716118423, 662681.36232675519],
						[537373.90454185114, 662681.29634924],
						[537374.18386147101, 662558.50671257521],
						[537403.17669748235, 662558.5726905833],
						[537403.24695927941, 662527.70936178043],
						[537431.52016796824, 662527.7737514266],
						[537431.58997881692, 662497.13167008711],
						[537460.5829231363, 662497.19774939818],
						[537460.65253582795, 662466.66629419941],
						[537431.65953762992, 662466.60021476669],
						[537431.87023020443, 662374.12090830156],
						[537403.59675710369, 662374.05651804933],
						[537403.80703860137, 662281.68787620671],
						[537346.54008170625, 662281.55760501768],
						[537346.6092300379, 662251.13680417102],
						[537261.06848169747, 662250.94258736097],
						[537261.13772250968, 662220.41116983397],
						[537232.14428976015, 662220.34544247319],
						[537232.35385591537, 662127.86625005153],
						[537204.07995905075, 662127.80220313603],
						[537204.14959437458, 662097.04956261814],
						[537175.97845884191, 662096.98579686973],
						[537176.04829172499, 662066.1225400964],
						[537146.95177215105, 662066.05673043849],
						[537147.0208000635, 662035.52534132102],
						[537004.31392836524, 662035.20331719762],
						[537004.24516563595, 662065.73470691557],
						[536939.88325140893, 662065.58987709833],
						[536918.70345203381, 662065.54227257881],
						[536918.63410255965, 662096.40553044272],
						[536861.36649986473, 662096.27695032908],
						[536861.29750612995, 662127.02959229448],
						[536804.03001017938, 662126.9012120252],
						[536803.89198925905, 662188.51713203557],
						[536775.72101055633, 662188.45405256981],
						[536775.51549939218, 662280.26955332793],
						[536803.68632066762, 662280.33263244526],
						[536802.92856735038, 662618.61228312762],
						[536832.02410839673, 662618.67748355155],
						[536831.88647399435, 662680.07231613831],
						[536860.05660977564, 662680.13549190771],
						[536859.8498760995, 662772.28308745683],
						[536842.68058308435, 662772.24457698374],
						[536745.3193818084, 662772.02653660253],
						[536744.56330046908, 663110.08580187254],
						[536773.65797116328, 663110.15089893423],
						[536773.58913698769, 663140.90370148025],
						[536744.49452075514, 663140.83860454313],
						[536744.42549361847, 663171.70203370007],
						[536716.25620067515, 663171.63905619155],
						[536716.18796810578, 663202.17062546476],
						[536658.92421955662, 663202.04275097395],
						[536658.78673304932, 663263.65901276888],
						[536545.08212065999, 663263.40569297364],
						[536545.21918073017, 663201.78943022981],
						[536516.1246723173, 663201.72473770869],
						[536516.056073913, 663232.58817758923],
						[536458.79243138409, 663232.46100065135],
						[536458.65618615306, 663293.856030536],
						[536430.48710265546, 663293.79354299791],
						[536430.41940060223, 663324.32513277815],
						[536402.14756266261, 663324.26246586605],
						[536401.87549386348, 663447.05260419915],
						[536372.88422570832, 663446.988393137],
						[536372.54257347854, 663601.30584005732],
						[536344.27121217805, 663601.24327274575],
						[536344.06882726355, 663692.72758102743],
						[536315.07799264044, 663692.66347197618],
						[536315.0087915964, 663723.96947869123],
						[536286.73764138529, 663723.90701038833],
						[536286.60252338264, 663785.08095355181],
						[536314.8735683253, 663785.14342162525],
						[536314.66987749725, 663877.29154938518],
						[536429.19266699441, 663877.54509815667],
						[536429.05603598082, 663939.1615768699],
						[536457.22401293542, 663939.22406194662],
						[536457.15552184742, 663970.08761958685],
						[536514.41659337678, 663970.21479081444],
						[536514.28062537941, 664031.38880983111],
						[536599.81210410525, 664031.57913857861],
						[536599.74359117018, 664062.33208818885],
						[536657.00434118195, 664062.45975640859],
						[536656.86734773417, 664123.85504766426],
						[536685.85742145265, 664123.91975985398],
						[536685.71982556174, 664185.53631478036],
						[536742.15773579525, 664185.66244329698],
						[536741.9518902892, 664277.70013394905],
						[536771.04399803304, 664277.98647089163],
						[536770.975658654, 664308.51821441506],
						[536828.23555057927, 664308.64647945971],
						[536828.09791497781, 664370.0418474297],
						[536856.26515315264, 664370.10501669871],
						[536856.19591042865, 664400.96864136902],
						[536913.45548012143, 664401.0972034483],
						[536913.38637837616, 664431.85021047248],
						[536970.64584043226, 664431.9789718918]
					]
				],
				[
					[
						[536908.76051352569, 666490.54291000927],
						[536908.82911886903, 666460.01082017506],
						[537051.60034557362, 666460.33224663779],
						[537051.66996487987, 666429.46829182713],
						[537108.92246424034, 666429.5975352152],
						[537108.99194119312, 666398.84420909733],
						[537251.66091209976, 666399.16714224243],
						[537251.73090703262, 666368.30319823185],
						[537337.25021896383, 666368.4973663718],
						[537337.18006334128, 666399.36131001124],
						[537394.43266763526, 666399.49154855323],
						[537394.36265626457, 666430.24487345887],
						[537422.62914927967, 666430.30924781528],
						[537422.55883294728, 666461.17320105119],
						[537479.81122179411, 666461.30373717158],
						[537479.88164570532, 666430.43978418503],
						[537508.04535113845, 666430.50407099293],
						[537508.32624791644, 666307.49080300343],
						[537480.1623315661, 666307.42651571392],
						[537480.2319981734, 666276.89445774769],
						[537451.96524115338, 666276.82998426643],
						[537452.03561188199, 666245.96606093855],
						[537394.78247247473, 666245.835621626],
						[537394.85198009922, 666215.30357310036],
						[537309.33187059104, 666215.10910507094],
						[537309.40197303006, 666184.24519103917],
						[537280.41553506511, 666184.17937850638],
						[537280.48533196328, 666153.42609265191],
						[537223.2318700091, 666153.29625128035],
						[537223.64975734404, 665968.887261722],
						[537167.2179732623, 665968.7594790596],
						[537167.28680633556, 665938.3380968984],
						[537138.1976443138, 665938.05105634988],
						[537138.2671738225, 665907.29780938791],
						[537110.10257130174, 665907.23415659799],
						[537110.93479226832, 665538.85931437695],
						[537081.94771486439, 665538.57260613272],
						[537082.01738694741, 665507.70880003762],
						[537053.74930627784, 665507.6450118249],
						[537053.81817665172, 665477.11307938199],
						[536911.03840395599, 665476.79163367546],
						[536910.96979896363, 665507.32356671593],
						[536825.54879649181, 665507.13184839708],
						[536825.61724271672, 665476.59991499968],
						[536739.27094153385, 665476.40657138359],
						[536739.20265579852, 665506.93850514351],
						[536711.03736682888, 665506.87553658837],
						[536710.96839176468, 665537.73934424133],
						[536682.70036277245, 665537.67619454756],
						[536682.63218190719, 665568.20813830895],
						[536710.90015835606, 665568.27128788666],
						[536710.83118327241, 665599.13510541921],
						[536738.99631405482, 665599.19807362324],
						[536738.85900025128, 665660.59385421756],
						[536710.69397473626, 665660.5308862488],
						[536710.6252468396, 665691.28409556451],
						[536682.35748207709, 665691.22094646259],
						[536682.28905412345, 665721.86353774695],
						[536653.30180021457, 665721.79883185099],
						[536653.23317948892, 665752.55205125595],
						[536595.97832029103, 665752.4243961731],
						[536595.77277961501, 665844.68408471229],
						[536540.88243253203, 665844.56188890059],
						[536533.00192698569, 665875.29775229353],
						[536482.01772960031, 665875.18444083538],
						[536481.81331868772, 665967.22294358234],
						[536509.25828733598, 665967.28391986666],
						[536509.90946483682, 665998.03877857246],
						[536567.16346794518, 665998.16613366082],
						[536567.09476096695, 666029.03002108156],
						[536681.60255069681, 666029.28532945702],
						[536681.32834427152, 666152.07718701754],
						[536652.34184954094, 666152.01248281251],
						[536652.2732286572, 666182.76577130961],
						[536681.25966912019, 666182.83047539287],
						[536681.19074692612, 666213.69439208147],
						[536623.93749503931, 666213.56663954793],
						[536623.86942035286, 666244.09869130538],
						[536594.88308800827, 666244.0340884967],
						[536594.67754680174, 666336.29401400522],
						[536651.93037092383, 666336.42166454764],
						[536651.86224364873, 666366.95373579813],
						[536766.36767770955, 666367.20963507867],
						[536766.29859476187, 666398.07358114549],
						[536823.55120354379, 666398.20182987244],
						[536823.48226100358, 666428.95515719417],
						[536850.92645819788, 666429.01670433534],
						[536851.50822659407, 666490.4143642846],
						[536908.76051352569, 666490.54291000927]
					]
				],
				[
					[
						[534366.62041126459, 667130.74109414511],
						[534366.68521988811, 667099.76639501494],
						[534423.11311848077, 667099.88455661491],
						[534423.17780166201, 667069.02048664493],
						[534452.26546144858, 667069.08147273795],
						[534452.32973521005, 667038.43865564419],
						[534509.58011201792, 667038.55883903487],
						[534509.64426015236, 667008.02665095672],
						[534566.07247390924, 667008.14530367986],
						[534566.33088271564, 666885.35285843187],
						[534595.31608335942, 666885.41388155648],
						[534595.40904869791, 666841.27499505645],
						[534595.51576076541, 666790.6093183863],
						[534595.57517467928, 666762.40026843443],
						[534566.58975696075, 666762.33924485091],
						[534566.65540669428, 666731.14335905621],
						[534538.38943137322, 666731.08389939903],
						[534538.45339914667, 666700.66238436708],
						[534510.29015692614, 666700.60318919085],
						[534510.35500220954, 666669.73918424291],
						[534474.2772042728, 666669.66342433379],
						[534453.10333988105, 666669.61899815279],
						[534453.143481893, 666650.48110497452],
						[534453.16784554138, 666638.86562161427],
						[534440.62796060124, 666638.83932378364],
						[534424.0794238844, 666638.80463392369],
						[534424.11072212493, 666623.87044201163],
						[534424.14410691313, 666607.94063859747],
						[534407.6983252028, 666607.90618065663],
						[534395.98070571292, 666607.88163941633],
						[534396.04464086331, 666577.34951981006],
						[534367.77840088797, 666577.29035374592],
						[534367.84251494298, 666546.64761531528],
						[534338.8567164992, 666546.5869936042],
						[534338.92054520932, 666516.05488356028],
						[534307.57059842278, 666515.98937498452],
						[534281.66834721796, 666515.93529500614],
						[534281.71914034127, 666491.5981091588],
						[534253.4668247326, 666484.79110246187],
						[534253.50673365989, 666465.65322728106],
						[534253.53049446282, 666454.25900193222],
						[534240.99046858319, 666454.23285651067],
						[534224.54453298019, 666454.19858194899],
						[534224.60884029849, 666423.33461561019],
						[534168.17861746415, 666423.2171359621],
						[534168.24258862599, 666392.46379789687],
						[534139.15373061423, 666392.4033147837],
						[534139.21787722199, 666361.53935806674],
						[534081.96514066414, 666361.42046557576],
						[534082.02849109739, 666330.88838404068],
						[534053.86461486924, 666330.82997144794],
						[534053.92860095983, 666299.96602431044],
						[534025.66188364755, 666299.90744697617],
						[534025.72512916673, 666269.37537503452],
						[533996.73884143203, 666269.3153570455],
						[533996.80271992716, 666238.45141959784],
						[533883.11869595037, 666238.21652315662],
						[533883.18167626159, 666207.68446046871],
						[533854.09249102301, 666207.62448217091],
						[533854.15610123437, 666176.76055407885],
						[533825.99196073797, 666176.70253219013],
						[533826.05529021483, 666145.94923234056],
						[533796.96599564876, 666145.88935520966],
						[533797.02904304874, 666115.24668354867],
						[533768.86479708005, 666115.18875960924],
						[533768.92801934737, 666084.4354694098],
						[533711.6743169477, 666084.31786756637],
						[533711.73765904701, 666053.4539587663],
						[533683.47051752685, 666053.39597028925],
						[533683.53312597424, 666022.86393626872],
						[533654.54640323599, 666022.80452212912],
						[533654.60963773495, 665991.94062301028],
						[533626.34239035845, 665991.88273283956],
						[533626.4053452824, 665961.12946185551],
						[533597.41851360304, 665961.0701485289],
						[533597.48118798272, 665930.42750562006],
						[533540.94648142636, 665930.31197055266],
						[533541.00927621534, 665899.55870909698],
						[533426.6033728082, 665899.32550296944],
						[533426.66572829243, 665868.68286923494],
						[533398.3982688071, 665868.62537132599],
						[533398.46079646726, 665837.87211918924],
						[533369.47374727938, 665837.81320810039],
						[533369.59846931021, 665776.41734157759],
						[533341.33085105126, 665776.35994187288],
						[533341.39349602628, 665745.49608115945],
						[533312.40628382703, 665745.43727077311],
						[533312.46864998923, 665714.68403804989],
						[533284.20092549687, 665714.62673665711],
						[533284.22782329354, 665701.35196141864],
						[533284.2630145764, 665683.98413187044],
						[533255.99523725547, 665683.9268790147],
						[533256.05749755446, 665653.17365592194],
						[533227.0701224372, 665653.11499613186],
						[533227.19431070634, 665591.71918758389],
						[533198.9263746076, 665591.6620329353],
						[533198.98875126138, 665560.79820135934],
						[533141.73322372918, 665560.68258604547],
						[533141.79482323432, 665530.15062829456],
						[533113.62957406789, 665530.09382781957],
						[533113.6917902017, 665499.23000579758],
						[533084.70414343174, 665499.17159722699],
						[533084.82779834047, 665437.77583677694],
						[533056.55959733285, 665437.71892711928],
						[533056.6214832511, 665406.96574267535],
						[533027.63367366826, 665406.90743481286],
						[533027.69572772132, 665376.04363224423],
						[532999.42742048204, 665375.98682090116],
						[532999.48875473626, 665345.4548919535],
						[532942.23247662769, 665345.33997199743],
						[532942.29436997604, 665314.47617897415],
						[532914.02595678729, 665314.41951459623],
						[532914.08757536404, 665283.66634931101],
						[532856.83108189213, 665283.55172701832],
						[532857.01517346513, 665191.51350573299],
						[532828.02698368451, 665191.45555011253],
						[532828.15011889953, 665129.83864032698],
						[532799.88138798054, 665129.78217237175],
						[532799.9427921155, 665099.02903617034],
						[532771.7768037566, 665098.97282182786],
						[532771.83837584127, 665068.10906767438],
						[532742.74717252015, 665068.05105746677],
						[532742.80802846549, 665037.51917640469],
						[532714.64193464117, 665037.46306002862],
						[532714.70251792017, 665007.04180643859],
						[532685.71400260762, 665006.98410194414],
						[532685.75428230118, 664986.74014306196],
						[532685.77563273394, 664976.00973948883],
						[532571.9800751647, 664975.78371279419],
						[532572.04171005834, 664944.69873219985],
						[532543.05308473227, 664944.64127945737],
						[532543.09187357489, 664925.06106287194],
						[532543.11313073919, 664914.3306625362],
						[532518.03072771011, 664914.28099284414],
						[532514.90511757741, 664883.4109595269],
						[532486.73875951709, 664883.35523390863],
						[532486.8606121164, 664821.73842004722],
						[532457.76897249708, 664821.68091451051],
						[532457.88984165585, 664760.50661052275],
						[532429.72327286622, 664760.45098265831],
						[532429.78420094075, 664729.58728140674],
						[532400.69239812763, 664729.52987694927],
						[532400.75348971994, 664698.55555797496],
						[532372.58681470971, 664698.50002808543],
						[532372.64676320949, 664668.07882669754],
						[532315.38812410855, 664667.9660915999],
						[532315.44861939678, 664637.21302722697],
						[532258.18987271073, 664637.10049149767],
						[532258.25004357216, 664606.45805433602],
						[532200.99140653189, 664606.23509545729],
						[532201.0514705783, 664575.59266297484],
						[532172.78178588324, 664575.5372741645],
						[532172.84223048389, 664544.67360150092],
						[532087.41622221423, 664544.50652187597],
						[532087.35593810747, 664575.37019485398],
						[532058.26386218914, 664575.31339680357],
						[532058.20406448201, 664605.95582981],
						[532001.76738266787, 664605.95641524007],
						[532001.70769022417, 664636.59885333921],
						[531912.27301954234, 664636.42487502913],
						[531888.01257997286, 664636.37776486191],
						[531801.76466078346, 664636.21057432913],
						[531801.8239802781, 664605.56813550484],
						[531744.56533706398, 664605.34676749748],
						[531744.62454974756, 664574.7043333581],
						[531715.5324726532, 664574.64814225037],
						[531715.65100302536, 664513.2526659104],
						[531659.21421823872, 664513.14380564191],
						[531659.39201713062, 664420.88469355961],
						[531630.40246745548, 664420.82885132323],
						[531630.46167946595, 664390.07582365884],
						[531659.45128340553, 664390.131666],
						[531659.51076286298, 664359.26802097005],
						[531687.78081972396, 664359.32252651989],
						[531687.8397121483, 664328.79075360403],
						[531745.09953344322, 664328.90130137908],
						[531745.15917356848, 664298.03766647785],
						[531773.32653520978, 664298.09212059306],
						[531773.50433056278, 664206.16497951467],
						[531745.33681130549, 664206.1105250963],
						[531745.39645139291, 664175.24690982688],
						[531688.13609452918, 664175.13636101235],
						[531688.19541365374, 664144.38337271637],
						[531630.9349492169, 664144.2730232788],
						[531631.05316006485, 664082.87768317736],
						[531602.78262748709, 664082.82327524549],
						[531602.80582291598, 664070.7654539448],
						[531602.84199927491, 664051.95967910648],
						[531545.58121269452, 664051.84962716792],
						[531545.64026447991, 664021.09665794007],
						[531488.37937033072, 664020.98680537567],
						[531488.43810288503, 663990.34446299938],
						[531460.27021358581, 663990.29049735342],
						[531460.32868175174, 663959.7587818742],
						[531403.06757381128, 663959.64922666713],
						[531403.12656991556, 663928.7856494179],
						[531345.8653540134, 663928.67629358778],
						[531345.80646548409, 663959.53987104376],
						[531317.5357206586, 663959.48595398013],
						[531317.57515515119, 663938.79961292027],
						[531317.59455607622, 663928.62237642216],
						[531203.07212276035, 663928.40446058707],
						[531203.13053291279, 663897.65150966542],
						[531174.85968158825, 663897.5978381224],
						[531174.9182487271, 663866.73426988593],
						[531117.65681654762, 663866.62570947886],
						[531117.71422844217, 663836.31525637594],
						[531060.55549371953, 663836.20708971482],
						[531060.61426417984, 663805.12228670169],
						[531003.35261724982, 663805.01412469998],
						[531003.41065306857, 663774.26119262562],
						[530946.14889857918, 663774.15322999796],
						[530946.20661882032, 663743.51092464209],
						[530889.66438557161, 663743.40451446653],
						[530889.72179234913, 663712.87283577246],
						[530860.7309932838, 663712.81835173513],
						[530860.76112433337, 663696.77816009568],
						[530860.78980077617, 663681.5123237709],
						[530832.51857750816, 663681.45924134855],
						[530832.57546263176, 663651.14881616808],
						[530803.58455464127, 663651.0944329804],
						[530803.64242334, 663620.23090262816],
						[530718.10880307097, 663620.07075075794],
						[530718.16547687759, 663589.76033475739],
						[530518.20970637258, 663589.38767793344],
						[530518.26786069234, 663558.08166859555],
						[530461.00535270979, 663557.97539694433],
						[530461.06196215446, 663527.44374586968],
						[530404.62179068709, 663527.33919567196],
						[530404.56528612948, 663557.87084694218],
						[530347.30277741409, 663557.76497160038],
						[530347.35917555238, 663527.2333201319],
						[530307.36786961125, 663527.15949669993],
						[530290.09656004631, 663527.12764418405],
						[530290.14163421036, 663502.68020193977],
						[530261.88151404553, 663496.43327498704],
						[530261.9381607367, 663465.6803891072],
						[530232.94692546525, 663465.62701289065],
						[530233.01064282423, 663431.00236652617],
						[530233.059906721, 663404.23187740904],
						[530204.78820629395, 663404.17987521365],
						[530204.90148861858, 663342.56351535313],
						[530175.9100360875, 663342.5102397881],
						[530175.96672445955, 663311.64675620268],
						[530147.69486471021, 663311.59485225682],
						[530147.80712024332, 663250.42100842774],
						[530090.54353991209, 663250.31602801906],
						[530090.59986496565, 663219.56318052183],
						[530033.33617708366, 663219.45839950989],
						[530033.39259715937, 663188.5949349642],
						[529976.95126160304, 663188.49185400375],
						[529977.00697011396, 663157.96025930915],
						[529833.48738588474, 663157.69901741808],
						[529833.59927383822, 663096.08273307106],
						[529777.15762046189, 663095.98033849243],
						[529777.21355882927, 663065.11689262395],
						[529662.68510605814, 663064.90971480694],
						[529662.74023009569, 663034.37813839584],
						[529634.46789321129, 663034.32711763401],
						[529634.41282171395, 663064.85869413847],
						[529605.42087912909, 663064.80642528948],
						[529605.47589674883, 663034.27484868583],
						[529548.21156304493, 663034.17175857374],
						[529548.26707109937, 663003.30832169275],
						[529462.73023893568, 663003.15470574878],
						[529462.78499116364, 662972.62313831947],
						[529291.81381540559, 662972.3174251687],
						[529291.86884157592, 662941.45399717602],
						[529261.23173595592, 662941.39940301538],
						[529234.60418434814, 662941.35200013604],
						[529234.65516612213, 662912.70100846817],
						[529177.39374841191, 662910.71864396869],
						[529177.42459188204, 662893.35105654213],
						[529177.50317396515, 662849.10243316658],
						[529149.23051825154, 662849.05224742263],
						[529149.28449107136, 662818.63132460171],
						[529092.01940574485, 662818.52982454817],
						[529092.07425192196, 662787.5557987364],
						[528977.64667432825, 662787.35357836052],
						[528977.70110965776, 662756.49017859891],
						[528949.42829457158, 662756.44033668458],
						[528949.48209202732, 662725.9088061623],
						[528892.21668351779, 662725.80800251733],
						[528892.27095814724, 662694.9446122162],
						[528835.00544171245, 662694.84400797659],
						[528835.0594146091, 662664.09124382737],
						[528777.7937906353, 662663.99083900149],
						[528777.84746257833, 662633.34870095341],
						[528578.59972871095, 662633.0009118052],
						[528578.54642837506, 662663.64305050194],
						[528521.28080283536, 662663.54353975365],
						[528521.22741726367, 662694.29630492814],
						[528378.52626770292, 662694.04920087499],
						[528378.4729581509, 662724.91259285866],
						[528263.94213384623, 662724.71516566945],
						[528263.9952282469, 662693.85177331185],
						[528206.72970800684, 662693.75335892988],
						[528206.78250490641, 662663.00059273862],
						[528093.07373560558, 662662.80576875375],
						[528093.12613050884, 662632.16362849344],
						[528064.03061335767, 662632.11390386289],
						[528064.08314294636, 662601.36114691664],
						[528035.91287211608, 662601.31305263925],
						[528036.01763704093, 662539.9181745263],
						[528006.92195653275, 662539.86855102878],
						[528006.97456747771, 662509.00518709212],
						[527978.80413829361, 662508.95719073003],
						[527978.85631954949, 662478.31507429364],
						[527950.5830257677, 662478.26695124118],
						[527950.63496609649, 662447.73546086904],
						[528036.17468999117, 662447.88120432198],
						[528036.22792186285, 662416.68599111773],
						[528149.9383945486, 662416.88042168797],
						[528149.88494677679, 662448.0756345212],
						[528178.87797767611, 662448.12533485773],
						[528178.98365522665, 662386.50926344097],
						[528149.99051559251, 662386.45956291747],
						[528150.0957053164, 662325.06475331902],
						[528121.82214781526, 662325.01633558865],
						[528121.87497385161, 662294.15300608624],
						[528093.70417628263, 662294.1048127237],
						[528093.75713854237, 662263.13086679031],
						[528036.49011702335, 662263.03304577491],
						[528036.54202748672, 662232.61221062427],
						[527979.2748995939, 662232.51458903111],
						[527979.32689240109, 662201.98313725402],
						[527922.05965775368, 662201.88571508881],
						[527922.11210811418, 662171.02240438259],
						[527836.57094279805, 662170.8772547805],
						[527836.62304504553, 662140.12456984399],
						[527807.62947063544, 662140.07547346456],
						[527807.68170583132, 662109.21217214223],
						[527722.14021870983, 662109.06761830579],
						[527722.19210656802, 662078.31494271918],
						[527664.92444087553, 662078.21841679839],
						[527664.97640779591, 662047.3551247695],
						[527579.53741330525, 662047.21148648637],
						[527579.58866266836, 662016.68006234558],
						[527522.32078214968, 662016.58403346513],
						[527522.37248098792, 661985.72075069544],
						[527465.92701304273, 661985.6262961959],
						[527465.97805108503, 661955.09488130023],
						[527436.88133490505, 661955.04626729456],
						[527436.98385700269, 661893.65158857848],
						[527379.71554766397, 661893.55605674675],
						[527379.81822441355, 661831.94015499146],
						[527323.37222816551, 661831.8461902272],
						[527323.42355266621, 661800.98293597205],
						[527294.42937978881, 661800.93474521243],
						[527294.4800985303, 661770.40335861593],
						[527179.94262036972, 661770.21348795947],
						[527179.99367524509, 661739.35024295503],
						[527123.4445443087, 661739.25679494778],
						[527123.49494512298, 661708.72541740944],
						[527066.32880802301, 661708.63114761747],
						[527066.37964927847, 661677.76791195455],
						[527037.28244198626, 661677.72000559955],
						[527037.3330465469, 661646.96739560424],
						[526980.88641483581, 661646.87460743007],
						[526980.9872309916, 661585.48002245708],
						[526950.34759679018, 661585.42973757698],
						[526923.71784752794, 661585.38608000695],
						[526923.76805796276, 661554.74410499248],
						[526894.77345055644, 661554.69661949016],
						[526894.87430647144, 661493.08082126151],
						[526838.32432795491, 661492.98835455184],
						[526838.42461039708, 661431.59381692053],
						[526809.42978567886, 661431.54648201738],
						[526809.52995974699, 661370.15196346561],
						[526781.2547589842, 661370.10585264734],
						[526781.3048833349, 661339.35329014389],
						[526752.30989584047, 661339.30605603382],
						[526752.40985587495, 661277.91156602476],
						[526724.13449637929, 661277.86555349571],
						[526724.18469343637, 661247.00238461653],
						[526696.01210043905, 661246.95658771973],
						[526696.06170538336, 661216.42528556741],
						[526667.06650096527, 661216.37820188375],
						[526667.11659062887, 661185.51504249894],
						[526638.84107213293, 661185.46917674795],
						[526638.9406071807, 661124.07473418547],
						[526609.94523979619, 661124.02775130339],
						[526609.9950427115, 661093.27522685123],
						[526581.71936548885, 661093.22945940087],
						[526581.81868649705, 661031.8350453442],
						[526552.82315634168, 661031.78816326091],
						[526552.87303080864, 661000.92503255757],
						[526524.59719466546, 661000.87936340203],
						[526524.61790891644, 660988.04738213599],
						[526524.64648029883, 660970.34809900925],
						[526490.09884196636, 660970.07112452271],
						[526467.37530916743, 660970.03450610233],
						[526467.42466656084, 660939.39262582525],
						[526439.14872453117, 660939.34710371692],
						[526439.19785119407, 660908.81584861735],
						[526410.20210395043, 660908.76921821246],
						[526410.30113849672, 660847.15361985343],
						[526353.85175908508, 660847.06298581394],
						[526353.88032367546, 660829.25309464324],
						[526353.90125921695, 660816.19988350046],
						[526324.80252616084, 660816.15323888499],
						[526324.85143996112, 660785.62200257322],
						[526267.68209116638, 660785.53051145654],
						[526267.73178292764, 660754.44617774535],
						[526239.45552262967, 660754.40099927969],
						[526239.50427764957, 660723.86977228953],
						[526182.23189104861, 660723.77841428434],
						[526182.28071590478, 660693.13657151186],
						[526154.00435010763, 660693.0915400933],
						[526154.052946151, 660662.56032235967],
						[526125.05676435388, 660662.51419513859],
						[526124.95950412948, 660723.68725589686],
						[526096.68319090421, 660723.64232311887],
						[526096.63470125978, 660754.17355052824],
						[526068.46126325871, 660754.12882962404],
						[526068.41194846854, 660785.2131639329],
						[525968.7768756774, 660785.05539639993],
						[525896.5954291597, 660784.94147779816],
						[525896.64441892051, 660753.8571429681],
						[525808.73095168557, 660753.71882396739],
						[525782.09985445079, 660753.67701665137],
						[525782.12207136292, 660739.5176058209],
						[525782.14775966259, 660723.14578831871],
						[525753.87144550728, 660723.10144546861],
						[525754.01569699903, 660631.0653073648],
						[525668.56933770189, 660630.93160626676],
						[525668.61737718992, 660600.17915601947],
						[525639.51826158178, 660600.1337249775],
						[525639.47027655493, 660630.88617530989],
						[525611.2966271711, 660630.8422382524],
						[525611.34455946751, 660600.08978783502],
						[525583.06803354796, 660600.04573891242],
						[525583.11608514853, 660569.18267292506],
						[525525.84315939248, 660569.09360275813],
						[525525.89041603985, 660538.67302257707],
						[525496.89401562721, 660538.62800384243],
						[525496.94242011616, 660507.43308642367],
						[525468.66573474871, 660507.38923436822],
						[525468.71305680857, 660476.8580433079],
						[525440.53914333123, 660476.81439902773],
						[525440.5865843012, 660446.17259239173],
						[525411.48719596316, 660446.12756517087],
						[525411.58282471169, 660384.29086506169],
						[525383.40875251964, 660384.2473187393],
						[525383.45557402086, 660353.93738688575],
						[525326.18189802603, 660353.84901263448],
						[525325.9455907282, 660507.16864369879],
						[525354.11945216451, 660507.21209149389],
						[525354.02438025828, 660568.82759000303],
						[525325.85062446725, 660568.78414236638],
						[525325.51883905614, 660784.05136834236],
						[525353.69222575217, 660784.09481540672],
						[525353.64511645015, 660814.62605455669],
						[525325.47178210528, 660814.5826075715],
						[525325.42421365681, 660845.44571291865],
						[525410.86945746467, 660845.57762962871],
						[525410.85217924684, 660856.75029611052],
						[525410.72695488681, 660937.72449200659],
						[525382.55383160524, 660937.68094714871],
						[525382.5064973163, 660968.3228306208],
						[525353.40769228665, 660968.49914730596],
						[525353.36058294296, 660999.03041514021],
						[525325.18756477349, 660998.98696863942],
						[525325.13999627763, 661029.85010298819],
						[525296.04164157819, 661029.80528021441],
						[525295.99463863776, 661060.33655776409],
						[525267.82172558457, 661060.29320962331],
						[525267.77426464995, 661091.15635379776],
						[525210.50315823068, 661091.06838275027],
						[525210.45597458619, 661121.82091133506],
						[525182.18034649093, 661121.77755227801],
						[525182.13338529458, 661152.41946513136],
						[525153.13806792838, 661152.37505300785],
						[525153.09099145699, 661183.12759138434],
						[525124.81546886009, 661183.08433104423],
						[525124.76827615092, 661213.94749499497],
						[525096.49280658911, 661213.90428339585],
						[525096.44617386116, 661244.43559023028],
						[525067.45101887395, 661244.391329312],
						[525067.40393372613, 661275.25450309424],
						[525039.23138917086, 661275.21154689533],
						[525039.18486265664, 661305.74286345916],
						[525010.08699653728, 661305.69854708423],
						[525010.0400189471, 661336.56173070357],
						[524981.86757950729, 661336.51887286175],
						[524981.82082301762, 661367.27144067048],
						[524953.54561730055, 661367.22847506206],
						[524953.49908172258, 661397.87042700616],
						[524924.50419749459, 661397.82641834125],
						[524924.45754817571, 661428.57899595296],
						[524896.18244796107, 661428.53612905589],
						[524896.1356839462, 661459.39933238924],
						[524867.14090829412, 661459.35542495071],
						[524867.0947009857, 661489.88677075133],
						[524838.81970627245, 661489.84400257107],
						[524838.77304981276, 661520.70721574721],
						[524810.49810813949, 661520.66449630237],
						[524810.45167182176, 661551.41709356569],
						[524781.45705854904, 661551.3733373268],
						[524781.41084333509, 661582.01531862654],
						[524753.13600716251, 661581.97269789292],
						[524753.08967801847, 661612.72530497087],
						[524724.09517293074, 661612.68164995569],
						[524724.04906450748, 661643.32364103582],
						[524695.77433383733, 661643.28111901064],
						[524695.72811186826, 661674.03373590019],
						[524666.73371496866, 661673.99018211151],
						[524666.68738118769, 661704.85342487262],
						[524638.51557321905, 661704.81115573808],
						[524638.46978999395, 661735.34254054725],
						[524610.19521767308, 661735.30016579304],
						[524610.1489899077, 661766.16341840266],
						[524581.15475558757, 661766.12001562945],
						[524581.10907876526, 661796.65141018806],
						[524552.83461194905, 661796.60913414229],
						[524552.78849174164, 661827.4723966145],
						[524523.79436561058, 661827.42909505928],
						[524523.74846496654, 661858.18174144602],
						[524495.47410403728, 661858.13956411148],
						[524495.42809138924, 661889.00283647748],
						[524467.15378349461, 661888.96070786985],
						[524467.10831813933, 661919.49212197238],
						[524438.1143543924, 661919.4489716168],
						[524438.06844930514, 661950.3122538398],
						[524409.79424691352, 661950.27022394608],
						[524409.74888796115, 661980.80164780654],
						[524380.75503240433, 661980.75859866315],
						[524380.709234874, 662011.62189075444],
						[524352.43513799086, 662011.57995956647],
						[524352.3898854428, 662042.11139318463],
						[524295.12209358322, 662042.02661270334],
						[524295.0764567249, 662072.88991474221],
						[524266.9052797886, 662072.84828276688],
						[524266.85985922435, 662103.60096858151],
						[524237.86622036312, 662103.55817159242],
						[524237.82069087256, 662134.42148353928],
						[524209.54680530773, 662134.37979823712],
						[524209.50149191765, 662165.13249392295],
						[524181.22765920183, 662165.0908573562],
						[524181.18223591906, 662195.95417920523],
						[524152.18876003177, 662195.91153341008],
						[524152.14387904067, 662226.44299646607],
						[524123.87015183101, 662226.40145860205],
						[524123.8254857937, 662256.82230524684],
						[524094.83211731492, 662256.77976066677],
						[524094.7866938223, 662287.75371857593],
						[524075.97188375163, 662287.72613728081],
						[524066.51307212049, 662287.71227940905],
						[524066.46786395478, 662318.57562101458],
						[524028.01581055101, 662318.51934194192],
						[523923.76345120673, 662318.36720918212],
						[523923.71899432619, 662348.89869209356],
						[523894.62297554512, 662348.85635110515],
						[523894.5780900903, 662379.7197028962],
						[523866.40743924066, 662379.67875761422],
						[523866.3452521619, 662422.48922153166],
						[523866.09505749261, 662594.72676446906],
						[523837.82196404366, 662594.68571885],
						[523837.73288657115, 662656.08064109262],
						[523808.74022264715, 662656.03860136471],
						[523808.65093287727, 662717.65478620457],
						[523751.38549562567, 662717.5719009171],
						[523751.34135791217, 662748.10344693298],
						[523723.06852839742, 662748.06259878469],
						[523723.02396403003, 662778.9260143768],
						[523694.85399765451, 662778.88536323747],
						[523694.89850910514, 662748.02194756875],
						[523665.80319713533, 662747.98001180065],
						[523665.75874034234, 662778.84342754865],
						[523580.32354970899, 662778.72058554506],
						[523580.35054028803, 662759.91491931467],
						[523580.3678460095, 662747.85716956761],
						[523465.83718176931, 662747.69318995776],
						[523465.88078892417, 662717.16164317995],
						[523380.34246706008, 662717.03969425685],
						[523380.38638751354, 662686.17628748482],
						[523294.95071500796, 662686.05492944713],
						[523294.99431811622, 662655.30214884132],
						[523209.45567419374, 662655.18108961685],
						[523209.4989609156, 662624.53893513477],
						[523180.50624133251, 662624.49800401798],
						[523180.54963005078, 662593.74523282168],
						[523152.27653491247, 662593.70536692254],
						[523152.31940304907, 662563.28446486348],
						[523095.05342774646, 662563.20386722451],
						[523095.140351423, 662501.36648429953],
						[523066.86709731509, 662501.32676537964],
						[523066.91011766612, 662470.68463471299],
						[523037.91712658532, 662470.64395521779],
						[523037.95993774128, 662440.11245067476],
						[523009.78939044429, 662440.07297413994],
						[523009.83307878696, 662408.87774611055],
						[522980.73716622213, 662408.83702352515],
						[522980.77971622231, 662378.41614986723],
						[522895.34244334319, 662378.29686982196],
						[522895.38545175391, 662347.43351535418],
						[522752.57847689977, 662347.23513268807],
						[522752.62075747637, 662316.70364668639],
						[522581.64275629458, 662316.46776246978],
						[522581.68517525482, 662285.60441691009],
						[522552.69185757142, 662285.56459366507],
						[522552.6494930716, 662316.42793929833],
						[522524.37592071341, 662316.38915392081],
						[522524.41823210212, 662285.52580821107],
						[522467.15128867311, 662285.44739912392],
						[522467.10908486118, 662316.31074497825],
						[522409.84224873735, 662316.23253563908],
						[522409.80060513713, 662346.76402251609],
						[522381.52708498423, 662346.7254829593],
						[522381.56867603917, 662316.1939960171],
						[522296.13107960741, 662316.07783191965],
						[522295.92271715199, 662469.62028685049],
						[522266.92972419027, 662469.58096787415],
						[522266.72148259886, 662623.23416571959],
						[522238.44843821053, 662623.19587238017],
						[522238.3698290824, 662681.27216678753],
						[522238.32356198499, 662715.4542224569],
						[522209.33100283454, 662715.41500512336],
						[522209.28973075363, 662745.94655514159],
						[522165.28692120459, 662745.88713166909],
						[522152.74406424753, 662745.87021478196],
						[522152.66068613657, 662807.70768070652],
						[522093.85341402725, 662807.62849347445],
						[521952.69539782935, 662807.439275451],
						[521952.77802331111, 662745.60180851526],
						[521923.68270705949, 662745.56295788346],
						[521923.76463255344, 662684.16799660388],
						[521895.59450370941, 662684.13043045625],
						[521895.63548752246, 662653.37764625321],
						[521866.64281883423, 662653.33903365012],
						[521866.724530679, 662591.94410115969],
						[521781.18555690796, 662591.83047800057],
						[521781.22588637, 662561.40957246895],
						[521723.95990453812, 662561.33375377499],
						[521724.00085929723, 662530.35974561807],
						[521695.72765508696, 662530.32238621754],
						[521695.76841045736, 662499.4590043457],
						[521638.50221269997, 662499.38348351337],
						[521638.5827798227, 662438.2098411459],
						[521610.41222926037, 662438.17276396893],
						[521610.53386832157, 662345.69329748955],
						[521581.43784386641, 662345.65505293931],
						[521581.47794813878, 662315.12356400595],
						[521553.30718653399, 662315.08658473869],
						[521553.34767379827, 662284.22323658154],
						[521525.07404601824, 662284.18617085053],
						[521525.19447887846, 662192.25988304534],
						[521496.20099647617, 662192.22192414012],
						[521496.44255070185, 662007.59512999456],
						[521525.4363589047, 662007.63308932737],
						[521525.47679298895, 661976.76978974137],
						[521553.75094978191, 661976.80685616354],
						[521553.79100162955, 661946.27542488498],
						[521525.51679229538, 661946.23835839203],
						[521525.63765972474, 661853.98036658473],
						[521496.64358037186, 661853.9424068951],
						[521496.76414021, 661761.79507946386],
						[521468.48961341329, 661761.75811110158],
						[521468.65034106356, 661638.74758056935],
						[521439.65588190779, 661638.70972144045],
						[521439.89621455467, 661454.52593281236],
						[521468.89099873189, 661454.56379236048],
						[521468.97150698263, 661392.94799319701],
						[521497.24666844681, 661392.98496238072],
						[521497.28675848217, 661362.34300132748],
						[521554.55691939528, 661362.41802996304],
						[521554.59726134193, 661331.66545306786],
						[521640.03997682128, 661331.77776113525],
						[521640.08062437054, 661300.91456852853],
						[521697.35099938896, 661300.99009486998],
						[521697.39131627942, 661270.45876947441],
						[521782.9371695646, 661270.57195638644],
						[521782.97808536183, 661239.70877380657],
						[521925.69186697388, 661239.8985916971],
						[521925.65068311442, 661270.76177392015],
						[521941.38207175239, 661270.78277346259],
						[522040.1916430823, 661270.91501692811],
						[522040.27399593568, 661209.52052001061],
						[522097.5446895081, 661209.59744123148],
						[522097.58619607409, 661178.73426910629],
						[522211.40805679734, 661178.8877377254],
						[522211.36633643624, 661209.75090956176],
						[522297.63224518765, 661209.86774910777],
						[522297.6741275877, 661179.00457748957],
						[522468.66396571789, 661179.23750667041],
						[522468.70601801958, 661148.48496101168],
						[522496.98160016199, 661148.52365059534],
						[522497.02355392242, 661117.88173047104],
						[522526.01893215894, 661117.92145548365],
						[522526.0610916302, 661087.16891960241],
						[522554.33677929069, 661087.20770788053],
						[522554.37914352416, 661056.34455629054],
						[522583.37463034963, 661056.38438251545],
						[522583.41659292264, 661025.85309762124],
						[522611.6923860996, 661025.89198459918],
						[522611.73485789198, 660995.02884281811],
						[522639.90788284678, 660995.06763685727],
						[522639.9502551317, 660964.31512055418],
						[522668.94590436341, 660964.35509778024],
						[522668.98817829433, 660933.7132069068],
						[522726.25983318646, 660933.79231951211],
						[522726.30206091655, 660903.26105409116],
						[522811.84982594784, 660903.37959787506],
						[522811.89267335268, 660872.51647592685],
						[522926.43640946236, 660872.67589693435],
						[522926.39334691339, 660903.53901858791],
						[523040.11429211806, 660903.69808434532],
						[523040.33036258561, 660749.6037669566],
						[522926.60835090122, 660749.44469970372],
						[522926.65095037967, 660718.91346351081],
						[522783.11005976278, 660718.71381115448],
						[522783.1525459002, 660688.0719589385],
						[522612.15759646863, 660687.83575707837],
						[522612.11542920372, 660718.47760973906],
						[522526.56670150335, 660718.36010583944],
						[522526.52484541404, 660748.89134306042],
						[522469.25254604954, 660748.81292664015],
						[522469.00008139922, 660933.43851752509],
						[522440.72412912804, 660933.39987609605],
						[522440.64028153062, 660994.79428436595],
						[522354.37324360787, 660994.67669400829],
						[522354.33125522273, 661025.53983645211],
						[522326.0554614428, 661025.50139235216],
						[522326.09739671845, 660994.63824983744],
						[522268.92877516715, 660994.56067134975],
						[522268.97015329468, 660964.02939521347],
						[522240.69455312833, 660963.76985689474],
						[522240.77735401382, 660902.59669827775],
						[522211.78159580339, 660902.55747661623],
						[522211.82331609784, 660871.69435312436],
						[522183.54725757346, 660871.65615426167],
						[522183.58877540973, 660840.9036560324],
						[522155.31266389799, 660840.86550575774],
						[522154.634521042, 660810.00142134214],
						[522129.44302886556, 660809.9674749379],
						[522098.08219159819, 660809.92526910035],
						[522098.16505578824, 660748.30967589084],
						[522126.44132657198, 660748.34772782528],
						[522126.48243927618, 660717.81648959313],
						[522154.75876253407, 660717.85459026007],
						[522155.51983921806, 660687.21370691003],
						[522212.07259099215, 660687.29005683761],
						[522212.11386263708, 660656.75882832357],
						[522241.11005459772, 660656.79805056867],
						[522241.14404333994, 660631.68722493725],
						[522268.60062501923, 660629.73324146133],
						[522326.59881585481, 660625.60836252698],
						[522326.61534944456, 660613.44012265676],
						[522326.6399995192, 660595.29838460614],
						[522383.91283395805, 660595.37630395801],
						[522383.95487672032, 660564.51322919852],
						[522469.50440539629, 660564.6299906082],
						[522469.54600376432, 660534.20940216782],
						[522526.81905112788, 660534.28781961347],
						[522526.86181708612, 660503.09289396065],
						[522595.85694731632, 660503.18762620573],
						[522612.41166553961, 660503.21039939555],
						[522612.45261493698, 660473.4535425111],
						[522669.6241178349, 660472.75797426701],
						[522669.66639166127, 660442.11616006831],
						[522755.21655757236, 660442.23440899304],
						[522755.25914411451, 660411.48197954439],
						[522783.53599452646, 660411.52116223983],
						[522783.62112004921, 660350.12693811662],
						[522812.61785310606, 660350.16716887639],
						[522812.66070038901, 660319.30413378845],
						[522755.38690369303, 660319.22472004441],
						[522755.47222990502, 660257.6092842404],
						[522727.19511463284, 660257.57014983566],
						[522727.23734221503, 660227.03898943949],
						[522698.24039187998, 660226.99890934967],
						[522698.28271838214, 660196.3571334912],
						[522670.005497707, 660196.31809750595],
						[522669.9632239347, 660226.95987343532],
						[522498.24369350245, 660226.72386398423],
						[522498.20189139451, 660257.25502497249],
						[522441.64765956381, 660257.17769028025],
						[522441.60535822174, 660288.15133683675],
						[522298.88331010914, 660287.95703797601],
						[522298.92534242425, 660256.98339104559],
						[522327.09963282896, 660257.02164874133],
						[522327.18275152275, 660195.8487105153],
						[522355.45997300744, 660195.88715655846],
						[522355.5854861305, 660103.62999472453],
						[522327.30810588662, 660103.59154846892],
						[522327.3916754268, 660042.08679776895],
						[522270.21973971894, 660042.00921478891],
						[522270.26156740641, 660011.146226465],
						[522212.98669663357, 660011.0687032555],
						[522212.9449765177, 660041.93169172108],
						[522184.66749009927, 660041.89349092671],
						[522184.62597243686, 660072.64586423873],
						[522156.34853886766, 660072.60771217966],
						[522156.30707411759, 660103.36009036063],
						[522127.30990553339, 660103.32101776311],
						[522127.26894191763, 660133.7415405442],
						[522098.9916134901, 660133.70348718786],
						[522098.90845202352, 660195.54012811568],
						[522069.91144610761, 660195.50115680695],
						[522069.87029135699, 660226.14293426007],
						[521727.04816753435, 660225.68606784858],
						[521727.00779832015, 660256.21723076282],
						[521670.55638880946, 660256.14268589171],
						[521670.59665313177, 660225.61152283871],
						[521641.49687420746, 660225.57317192375],
						[521641.45666395302, 660256.10433505336],
						[521584.18264698394, 660256.02900353412],
						[521584.14196192008, 660287.00265226024],
						[521555.96772292291, 660286.96566842985],
						[521555.8870394461, 660348.47049977002],
						[521527.61008053529, 660348.43342967704],
						[521527.57037140284, 660378.74337168504],
						[521555.84727815742, 660378.78044171282],
						[521555.80650106102, 660409.86473007919],
						[521613.07998183597, 660409.93996269454],
						[521613.03953288862, 660440.69239502377],
						[521655.40332072234, 660440.74817118165],
						[521670.31290621212, 660440.76782711793],
						[521670.28504210117, 660461.89629950724],
						[521670.23223157978, 660501.94084501546],
						[521698.40610198642, 660501.97802476725],
						[521698.24337427592, 660625.20908034639],
						[521640.97064381815, 660625.13355090062],
						[521640.92999641021, 660655.99663719942],
						[521527.2073369089, 660655.8472551133],
						[521527.24777071935, 660624.98416853114],
						[521469.97503947996, 660624.90923508606],
						[521470.01522116963, 660594.15677356836],
						[521355.46954354027, 660594.00750527636],
						[521355.50965461176, 660563.14442794514],
						[521155.51704759279, 660562.8857250493],
						[521155.4773121546, 660593.74880286492],
						[521127.20077532972, 660593.71242181049],
						[521127.08229723532, 660685.85920289112],
						[521098.08615655918, 660685.8219465185],
						[521098.00761095394, 660746.99504367961],
						[521069.73133784393, 660746.95876152057],
						[521069.69147936074, 660778.04310939694],
						[521097.96769897931, 660778.07939148799],
						[521097.80975545512, 660901.08938553231],
						[521126.805516258, 660901.12664142053],
						[521126.76626055356, 660931.65791080706],
						[521240.48701119359, 660931.80452146044],
						[521240.44740118145, 660962.44641588861],
						[521383.26641246444, 660962.63165539503],
						[521383.18622788461, 661024.24731972197],
						[521354.91043187922, 661024.21054681635],
						[521354.87075201416, 661054.74183475832],
						[521326.69782937673, 661054.70524403662],
						[521326.65777111857, 661085.56839870533],
						[521097.57326608733, 661085.27265925857],
						[521097.53378015279, 661116.02519868873],
						[521041.08532446157, 661115.95281632803],
						[521041.04608582507, 661146.59474004374],
						[520983.77517266577, 661146.52150125441],
						[520983.73589955398, 661177.27405058686],
						[520954.63780593965, 661177.23691604403],
						[520954.59844620596, 661208.10009097622],
						[520898.15030683053, 661208.02819966222],
						[520898.11147520767, 661238.55951741571],
						[520811.84571711294, 661238.45002556231],
						[520811.72886240005, 661330.70773264777],
						[520783.45359377121, 661330.671943133],
						[520783.37593636184, 661392.06648465316],
						[520668.83582097641, 661391.92200290295],
						[520668.87436611409, 661361.28003986692],
						[520583.43180406501, 661361.17278194986],
						[520583.58590150747, 661238.16249402647],
						[520526.31530750898, 661238.09084971156],
						[520526.3534482845, 661207.55953108554],
						[520498.07796773413, 661207.52423265716],
						[520498.11646996805, 661176.661056643],
						[520469.12119538826, 661176.62491017301],
						[520469.1595053451, 661145.8723596253],
						[520440.88391864189, 661145.83715961932],
						[520440.92203805689, 661115.1952344873],
						[520412.64639856439, 661115.16008307785],
						[520412.83741902799, 660961.39742605423],
						[520441.11332312005, 660961.43257779232],
						[520441.30447042076, 660807.78066208854],
						[520413.02830191451, 660807.74551001342],
						[520413.10484742397, 660746.12990863784],
						[520355.8325384474, 660746.05885853642],
						[520355.87036121479, 660715.52761605266],
						[520326.87427289295, 660715.49172059249],
						[520326.91217862401, 660684.84986237169],
						[520298.63579856884, 660684.81490714976],
						[520298.67351490789, 660654.28367403871],
						[520270.49990564905, 660654.24889425933],
						[520270.5379790251, 660623.38580467482],
						[520184.26899118192, 660623.27960768447],
						[520184.30676663184, 660592.52714311623],
						[520098.75738322781, 660592.42227923498],
						[520098.79513387091, 660561.55919892958],
						[520041.52218157257, 660561.48924435605],
						[520041.55928495456, 660531.06865009759],
						[519984.28622638306, 660530.99889502279],
						[519984.32416547561, 660499.8039631187],
						[519898.77429932397, 660499.70014041895],
						[519898.8483791101, 660438.5271141798],
						[519870.67439991643, 660438.49301993812],
						[519870.63734558248, 660469.13484089228],
						[519839.99562966404, 660469.09781520092],
						[519825.08606988168, 660469.07982001011],
						[519756.09079646302, 660468.99672186049],
						[519756.06858562486, 660487.47031313274],
						[519756.05408872652, 660499.5279275307],
						[519710.50289728242, 660499.47322428634],
						[519613.23105228262, 660499.35683151567],
						[519613.19421380264, 660530.2199032529],
						[519498.64769671101, 660530.41543987358],
						[519498.61159843655, 660560.83603534417],
						[519355.89191885811, 660560.66729809798],
						[519355.85634541046, 660590.86665783729],
						[518956.59080447699, 660591.06491468824],
						[518956.55532672827, 660621.8173819927],
						[518899.2825844693, 660621.7514086978],
						[518899.25026747945, 660649.84899106133],
						[518870.14806393383, 660652.58105824573],
						[518870.18350707437, 660621.7179655286],
						[518784.73709925934, 660621.62006097264],
						[518784.70333414437, 660651.15570892079],
						[518756.42538086121, 660652.45085256593],
						[518756.46061040153, 660621.58775960235],
						[518727.46435631369, 660621.55468655354],
						[518727.49940531026, 660590.80221875338],
						[518696.85791627975, 660590.76732475229],
						[518670.94632147241, 660590.73786166357],
						[518670.97774516884, 660563.08276872616],
						[518613.81125614012, 660559.80991674238],
						[518613.87453763105, 660503.94664156053],
						[518613.95035008399, 660437.02135257772],
						[518584.85094555066, 660436.98841470527],
						[518584.92088422499, 660375.15168020711],
						[518556.74679636513, 660375.11983881146],
						[518556.78102559876, 660344.80989012169],
						[518584.95516542508, 660344.84173157404],
						[518584.99007218838, 660313.97868648183],
						[518556.81587944715, 660313.9468449729],
						[518556.85048344161, 660283.30504507525],
						[518499.57656129799, 660283.24046495184],
						[518499.61143210111, 660252.26680913323],
						[518356.78624654515, 660252.10663393489],
						[518356.82035381591, 660221.57546338427],
						[518328.54317654151, 660221.54389839433],
						[518328.61165614723, 660160.1497109544],
						[518299.61458778282, 660160.11739290366],
						[518299.68308222201, 660098.61260437057],
						[518271.40569334599, 660098.58113770373],
						[518271.47223690536, 660038.73566933663],
						[518271.50839920074, 660006.21337066963],
						[518299.78594702634, 660006.24483751191],
						[518299.85407183517, 659945.07195705106],
						[518357.12917266472, 659945.13584104343],
						[518357.16365061328, 659914.27285804157],
						[518375.98117864097, 659914.2938904661],
						[518386.16115280747, 659914.30527764733],
						[518386.1953138953, 659883.77415949164],
						[518414.47307242255, 659883.80582369422],
						[518414.56976307946, 659797.5222546166],
						[518442.85462258325, 659791.35925133142],
						[518442.91595401621, 659736.71301224851],
						[518500.19937791117, 659730.02958101535],
						[518500.23088608554, 659702.04274889105],
						[518529.2318811221, 659699.30992393568],
						[518529.2664322803, 659668.66821950045],
						[518585.71986004559, 659668.73197267274],
						[518585.75439135125, 659638.20089295355],
						[518614.85521046317, 659638.23383242358],
						[518614.89017175813, 659607.37089800695],
						[518672.06361969979, 659607.4357632118],
						[518672.09856267722, 659576.683453548],
						[518723.9249504105, 659576.74242422334],
						[518900.48428975634, 659576.94454926148],
						[518900.54663321277, 659522.74085049261],
						[518900.66101432918, 659423.293694878],
						[518928.8367341751, 659423.32612594392],
						[518928.87190240098, 659392.79508492746],
						[519015.25018177682, 659392.89480990032],
						[519015.28640650335, 659361.58943597414],
						[519071.740889212, 659361.65485883679],
						[519071.77606603777, 659331.34506701434],
						[519100.77459689381, 659331.37874765717],
						[519100.81047008967, 659300.51586228178],
						[519129.08923231077, 659300.54875622841],
						[519129.12451476906, 659270.23897389765],
						[519230.31125376181, 659270.35707322869],
						[519243.67942044325, 659270.37272237707],
						[519243.71608003799, 659239.06736838561],
						[519357.44854503596, 659239.200946606],
						[519357.48450915312, 659208.66993501026],
						[519386.48325648886, 659208.7041198368],
						[519386.44723849377, 659239.23513136734],
						[519472.00366706931, 659239.33628673013],
						[519471.96657258394, 659270.64164020889],
						[519529.24402413529, 659270.70960960421],
						[519529.20800367737, 659301.01939106546],
						[519614.66127872246, 659301.12116694963],
						[519614.62444046885, 659331.98405119206],
						[519700.18038615561, 659332.08639452583],
						[519700.20372598822, 659312.61733449344],
						[519700.21738509601, 659301.22351047897],
						[519843.05083552841, 659301.3953626079],
						[519843.08743484592, 659271.0855818406],
						[519929.3635219158, 659271.18998759403],
						[519929.3267634674, 659301.49976816599],
						[519967.78587777086, 659301.54645486886],
						[520043.05879635696, 659301.63809145789],
						[520043.09576458007, 659271.32831113809],
						[520128.65202605847, 659271.43288524169],
						[520128.69037154509, 659240.12753327261],
						[520214.96662114415, 659240.23343848274],
						[520215.05425483146, 659168.99442322622],
						[520215.0794290991, 659148.52980402147],
						[520238.62814344047, 659148.55878906441],
						[520243.43435383786, 659086.94953160826],
						[520272.43331596366, 659086.98527982295],
						[520272.4713890386, 659056.12243540213],
						[520300.64773843077, 659056.15721856337],
						[520300.68572776322, 659025.40499850153],
						[520328.96496340516, 659025.4399572527],
						[520329.0031424943, 658994.5771225614],
						[520358.00226762763, 658994.61302177468],
						[520358.040090058, 658964.08205031778],
						[520386.31943123386, 658964.11710776598],
						[520386.35744342313, 658933.47552164551],
						[520413.81416399038, 658933.50960586313],
						[520471.91546387703, 658933.58188289322],
						[520471.95377339789, 658902.82968228473],
						[520529.23250695009, 658902.9011371393],
						[520529.2710618375, 658872.03832203161],
						[520614.7265676129, 658872.14529834525],
						[520614.76486669166, 658841.61434639269],
						[520786.60170668428, 658841.83080318745],
						[520786.64074476989, 658810.9679982512],
						[520814.92034942715, 658811.00379325519],
						[520814.95930050628, 658780.25161252788],
						[520843.95880384865, 658780.28836928564],
						[520843.99794949306, 658749.42557406751],
						[520872.27766005544, 658749.46146777435],
						[520872.55064621096, 658534.52822820877],
						[520844.27056577988, 658534.49233403173],
						[520844.30971137714, 658503.62957702915],
						[520815.30971982848, 658503.59281965392],
						[520815.34839062393, 658473.06192490016],
						[520787.06820442009, 658473.0261291624],
						[520787.10724243446, 658442.16338156641],
						[520758.10714242206, 658442.12672512594],
						[520758.22353413358, 658349.98098731157],
						[520787.22379675234, 658350.01764395309],
						[520787.26255490014, 658319.37615363498],
						[520901.82408899837, 658319.52146101079],
						[520901.8632014342, 658288.76935661829],
						[520930.14370471315, 658288.80534990318],
						[520930.28402370424, 658178.62878494023],
						[520930.33939051628, 658135.15551856498],
						[520958.51731898962, 658135.1914297028],
						[520958.59561400302, 658073.79790189199],
						[520987.69920352643, 658073.83504345082],
						[520987.73847601988, 658043.08297724836],
						[521015.91656236118, 658043.11898680287],
						[521015.95602903084, 658012.25630650343],
						[521101.51884566178, 658012.36594567308],
						[521101.55804691027, 657981.83512705576],
						[521139.19752877462, 657981.88349892572],
						[521187.84090271901, 657981.94613998884],
						[521187.88069209585, 657951.08346961427],
						[521301.62207110168, 657951.23050330707],
						[521301.66178730724, 657920.58907571668],
						[521330.76564815157, 657920.62682481576],
						[521330.80527504097, 657890.09602085641],
						[521387.26481296442, 657890.16939855251],
						[521387.30540846521, 657858.97488643334],
						[521403.75994979206, 657858.99630809459],
						[521363.01192342391, 657797.54974531359],
						[521352.85075914342, 657782.04988328298],
						[521327.80455187685, 657745.73434090859],
						[521300.39745973004, 657705.87597760081],
						[521232.11047686171, 657705.78761486639],
						[521159.19561071158, 657705.69357692264],
						[521050.84080647636, 657754.22676416324],
						[520961.38122419122, 657744.26733328914],
						[520921.76238774601, 657440.56806665089],
						[520886.48706665239, 657440.52319870226],
						[520870.09882962937, 657387.95846616838],
						[520796.24898044008, 657394.17012186744],
						[520791.56251407781, 657440.40283676737],
						[520763.08727431309, 657593.35266763507],
						[520696.2324131428, 657680.65726245614],
						[520599.76661753433, 657680.53606572142],
						[520531.58635300206, 657594.94234836148],
						[520492.56306953443, 657466.797042066],
						[520492.79906714434, 657277.52867381077],
						[520430.17351181526, 657106.54490854533],
						[520419.47651694366, 656941.82059992943],
						[520385.01842441381, 656862.46437608474],
						[520368.60085916793, 656831.80271144188],
						[520214.74128099292, 656831.61275260244],
						[520021.7997219