var chart1;
var chart2;


function isBiggerThan0(element, index, array) {
    return element > 0;
}


function bindCompanyMonthlyFootfallDailyData(data, colorScheme, containerID) {

    var highChartId = containerID.replace('#', '');

    // Uncomment code below to find out which graph allow y Axis label to be decimal
    //console.log(highchartIds[index][2] + ": " + highchartIds[index][3]);

    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: highChartId,
                events: {
                    //load: function () {
                    //    chartEvent[3] = this;
                    //}
                }
            },
            series: [{
                type: 'column',
                name: 'Last 12 Months',
                data: data.map(m => m.ValueIn),
                color: colorScheme.time.year.thisYear,
                pointWidth: 17,
                borderWidth: 0
            }, {
                type: 'line',
                name: 'Last Year Same Month',
                dashStyle: 'dash',
                data: data.map(m => m.LastValuein),
                color: colorScheme.time.year.lastYear,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //text: LanguageMonthlyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageTotalvisitorsforeachmonthoftheyear + "'></i>",
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.visitorCount,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    },
                    point: {
                        events: {
                            click: function () {
                                //location.href = "Analytics?type=" + this.category.name + "&range=day&parameter=1&branchId=-1&compare=1";
                            }
                        }
                    },

                    cursor: 'pointer'
                }
            },
            yAxis: {
                allowDecimals: false,
                lineWidth: 0,
                min: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: 'No. of Visitor',
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            xAxis: {
                categories: data.map(m => m.Month),
                tickWidth: 0,
                title: {
                    text: "",
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 100,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            }
        },
            function (chart) {
                //if (!HasLastYearDataForVisitorCount) {
                //    chart.series[1].remove(true);
                //}
            });

        var newHeight = $(".grid-stack").find("[data-widget-function-name='GetCompanyMonthlyFootfallDailyData']").height();
        chart.update({
            chart: {
                height: newHeight - 65

            }
        });

        $("#CompanyMonthlyFootfallDailyData").addClass("g01");
    });
}

function bindFootfallSummaryHour(data, colorScheme, containerID) {
    var hourList = data.categories;
    var visitorByHour = data.series[0].ValueInInt;
    var transactionCountByHour = data.series[0].TransactionCountInt;
    var isContainsTransactionCount = transactionCountByHour.some(isBiggerThan0);
    var series = [];
    var yaxis = [];
    var legendPosition = 0;

    if (isContainsTransactionCount) {
        series = [{
            type: 'column',
            name: "Number of Visitor",
            data: visitorByHour,
            color: '#179BD8',
            borderWidth: 0
        }, {
            type: 'column',
            name: "Number of Transaction",
            data: transactionCountByHour,
            color: colorScheme.time.year.thisYear
        }];
        yaxis = [{
            allowDecimals: false,
            lineWidth: 0,
            //tickInterval: dynamicTickIntervalVisitorTotal,
            tickWidth: 1,
            tickLength: 5,
            min: 0,
            tickPosition: 'inside',
            title: {
                text: "Number of Visitor",
                style: {
                    color: colorScheme.chart.axisLabel.y.title.color,
                    fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                    "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                }
            },
            labels: {
                style: {
                    "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                    color: colorScheme.chart.axisLabel.y.label.color,
                    fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                }
            }
        },
        {
            allowDecimals: false,
            opposite: true,
            linkedTo: 0,
            lineWidth: 0,
            tickWidth: 0,
            //tickInterval: dynamicTickIntervalTransactionCount,
            tickWidth: 1,
            tickLength: 5,
            min: 0,
            tickPosition: 'inside',
            labels: {
                style: {
                    "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                    color: colorScheme.chart.axisLabel.y.label.color,
                    fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                }
            },
            title: {
                text: "Number of Transaction",
                style: {
                    color: colorScheme.chart.axisLabel.y.title.color,
                    fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                    "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                }
            }
        }];
        //legendPosition = 300;
    } else {
        series = [{
            type: 'column',
            name: "Number of Visitor",
            data: visitorByHour,
            color: '#179BD8',
            borderWidth: 0
        }];
        yaxis = [{
            allowDecimals: false,
            lineWidth: 0,
            //tickInterval: dynamicTickIntervalVisitorTotal,
            tickWidth: 1,
            tickLength: 5,
            min: 0,
            tickPosition: 'inside',
            title: {
                text: "Number of Visitor",
                style: {
                    color: colorScheme.chart.axisLabel.y.title.color,
                    fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                    "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                }
            },
            labels: {
                style: {
                    "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                    color: colorScheme.chart.axisLabel.y.label.color,
                    fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                }
            }
        }];
        //legendPosition = 350;
    }
    var chartEvent = [7];

    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: $(containerID)[0],
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
                alignTicks: false,
                type: 'column'
            },
            title: {
                text: ''
            },
            series: series,
            credits: {
                enabled: false
            },
            yAxis: yaxis,
            xAxis: {
                categories: hourList,
                tickWidth: 0,
                gridLineWidth: 0,
                minorTickLength: 0,
                tickLength: 0,
                title: {
                    text: "Hour",
                    //align: 'high',
                    //y: -20,
                    y: 10,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    //x: 6,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                //x: legendPosition,
                //y: -15,
                verticalAlign: 'top',
                align: 'right',
                floating: false
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            },
        });

        var newHeight = $(".grid-stack").find("[data-widget-function-name='GetCompanyNthDayFootfallHourlyData']").height();
        chart.update({
            chart: {
                height: newHeight - 65

            }
        });
        $("#CompanyNthDayFootfallHourlyData").addClass("g01");
    });
}

function bindTop5VisitorCount(data, colorScheme, containerID) {
    var thisWeekVisitorList = data.series[0].ValueInInt;
    var lastWeekVisitorList = data.series[0].LastValueInList;
    var branchNameList = data.series[0].branchName;
    var changesVisitorList = data.series[0].DifferencesInFFList;
    $(containerID).html('');

    if (thisWeekVisitorList.length <= 0) {
        $("#top5BranchesVisitCompanyTop5VisitorSiteorTotalTable").html('');
    }
    else {
        $(containerID).append('<thead><tr><th class="rankBranchTh">' + "Rank" + '</th><th class="rankBranchTh">' + "Site" + '</th><th class="thisWeekLastWeekChangesThTd">'
            + "This Week" + '</th><th class="thisWeekLastWeekChangesThTd">' + "Last Week" + '</th><th class="thisWeekLastWeekChangesThTd">' + "Changes" + ' (%)</th></tr></thead><tbody>');
        for (var i = 0; i < thisWeekVisitorList.length; i++) {
            var firstColumn = branchNameList[i];
            var secondColumn = thisWeekVisitorList[i] > 0 ? numberify(thisWeekVisitorList[i]) : " - ";
            var thirdColumn = lastWeekVisitorList[i] > 0 ? numberify(lastWeekVisitorList[i]) : " - ";
            var fourthColumn = changesVisitorList[i] > 0 ? "<i class='fa fa-caret-up rise'></i> " + Math.abs(changesVisitorList[i]) :
                changesVisitorList[i] < 0 ? "<i class='fa fa-caret-down drop'></i> " + Math.abs(changesVisitorList[i]) :
                    changesVisitorList[i] == 0 ? " - " : " - ";
            var rank = i + 1;
            $(containerID).append('<tr><td class="rankBranchTd">' + rank + '</td><td class="rankBranchTd">' + firstColumn + '</td><td class="thisWeekLastWeekChangesThTd">' + secondColumn + '</td>' +
                '<td class="thisWeekLastWeekChangesThTd">' + thirdColumn + '</td><td class="thisWeekLastWeekChangesThTd">' + fourthColumn + '</td></tr></tbody>');
        }
    }
}

function bindCustomHeader(headerContainer, headerText) {
    $(headerContainer)
        .html("<h3 class='custom-header'>" + headerText + "</h3>")
        .addClass("header-widget");
}

function bindBranchDailyVisitorIn(data, containerID) {
    console.log(data);
    var elementInsideContainer = "";
    elementInsideContainer += '<p class="totalBranchVisitorIn" is-template="true"></p>';
    elementInsideContainer += '<div class="branchDailyVisitorInSparkLine spark-cont" is-template="true"></div>';
    $(containerID).html(elementInsideContainer);
    $(containerID).find(".totalBranchVisitorIn").text(data.reduce((a, b) => a + b, 0));

    var chart = new Highcharts.Chart({
        chart: {
            renderTo: $(containerID).find('.branchDailyVisitorInSparkLine')[0],
            type: 'area',
            margin: [0, 0, 0, 0],
            backgroundColor: 'transparent'
        },
        title: {
            text: ''
        },
        credits: {
            enabled: false
        },
        xAxis: {
            labels: {
                enabled: false
            },
            tickLength: 0,
            lineWidth: 0,
            maxPadding: 0,
            minPadding: 0
        },
        yAxis: {
            maxPadding: 0,
            minPadding: 0,
            gridLineWidth: 0,
            endOnTick: false,
            lineWidth: 0,
            title: {
                text: null
            },
            labels: {
                enabled: false
            }
        },
        legend: {
            enabled: false
        },
        tooltip: {
            enabled: false
        },
        plotOptions: {
            area: {
                fillColor: "#cdddff"
            },
            series: {
                enableMouseTracking: false,
                lineWidth: 1,
                marker: {
                    enabled: false
                }
            }
        },
        series: [{
            color: "#2232a3",
            data: data
        }]

    });
}

function bindBranchDailyVisitorIn_v2(data, containerID) {

    var elementInsideContainer = "";
    elementInsideContainer +=
        `<div class="one-row" style="margin-bottom: 0px;">
                <div class="col-xs-4">
                    <i class="fa fa-user" style="font-size: 5em;"></i>
                </div>
                <div class="col-xs-8">
                    <p class="title-right-mb-0">Today Visitor</p>
                    <p class="totalBranchVisitorIn_v2"></p>
                </div>
            </div>`;
    $(containerID).html(elementInsideContainer);
    $(containerID).find(".totalBranchVisitorIn_v2").text(data);
}

function bindBranchDailyVisitDuration(data, containerID) {
    var elementInsideContainer = "";
    elementInsideContainer +=
        `<div class="one-row" style="margin-bottom: 0px;">
                <div class="col-xs-4">
                    <i class="fas fa-clock" style="font-size: 5em;"></i>
                </div>
                <div class="col-xs-8">
                    <p class="title-right-mb-0">Visit Duration</p>
                    <p class="averageBranchVisitDuration"></p>
                </div>
            </div>`;
    $(containerID).html(elementInsideContainer);
    $(containerID).find(".averageBranchVisitDuration").text(data + ' mins');
}

function bindBranchHourlyVisitorOrderCount(data, containerID, isDemo) {
    var elementInsideContainer = "";
    elementInsideContainer +=
        `<div class="branchHourlyVisitorOrderCountGraph">
        </div>`;
    $(containerID).html(elementInsideContainer);

    chart2 = new Highcharts.Chart({
        chart: {
            renderTo: $(containerID).find('.branchHourlyVisitorOrderCountGraph')[0],
            type: 'column',
            backgroundColor: 'transparent',
            height: $(containerID).parents('.grid-stack-item-content').height() - 20
        },
        title: {
            text: ''
        },
        credits: {
            enabled: false
        },
        xAxis: {
            categories: isDemo ?
                ['00:00', '01:00', '02:00', '03:00', '04:00', '05:00', '06:00', '07:00', '08:00', '09:00', '10:00', '11:00', '12:00', '13:00', '14:00', '15:00', '16:00', '17:00', '18:00', '19:00', '20:00', '21:00', '22:00', '23:00'] : data.map(m => m.DateTimeString),
            title: {
                text: 'Time',
                align: 'high'
            },
            labels: {
                rotation: 90
            }
        },
        yAxis: {
            allowDecimals: false,
            lineWidth: 0,
            //tickInterval: dynamicTickIntervalVisitorTotal,
            tickWidth: 1,
            tickLength: 5,
            min: 0,
            tickPosition: 'inside',
            title: {
                text: "Number of Visitor",
                style: {
                    color: '#6E6E6F'
                }
            },
            labels: {
                style: {
                    color: '#6E6E6F'
                }
            }
        },
        legend: {
            verticalAlign: 'top',
            borderWidth: 1,
            margin: 0
        },
        series: [{
            name: 'Visitor Count',
            type: 'column',
            color: "#B7C9DB",
            data: isDemo ? [10, 14, 13, 5, 8, 10, 11, 7, 10, 14, 13, 5, 8, 10, 11, 7, 10, 14, 13, 5, 8, 10, 11, 7] : data.map(m => m.ValueIn)
        }]
        //    {
        //    name: 'Order Count',
        //    color: "#F7CDC6",
        //    type: 'line',
        //    data: isDemo ? [8, 10, 5, 2, 6, 7, 10, 2, 4, 8, 8, 4, 8, 9, 5, 6, 5, 8, 11, 4, 6, 5, 9, 8] :data.map(m => m.OrderCount)
        //}]

    });

    chart2.reflow();
}

function bindBranchDailyAverageQueueTime(data, containerID) {
    var elementInsideContainer = "";
    elementInsideContainer +=
        `<div class="one-row" style="margin-bottom: 0px;">
                <div class="col-xs-4">
                    <i class="fa fa-users" style="font-size: 5em;"></i>
                </div>
                <div class="col-xs-8">
                    <p class="title-right-mb-0">Average Queue Time</p>
                    <p class="averageBranchQueueTime"></p>
                </div>
            </div>`;
    $(containerID).html(elementInsideContainer);
    $(containerID).find(".averageBranchQueueTime").text(data + ' mins');
    if (data < 2) {
        $(containerID).parents('.custom-widget').css({ 'background-color': '#12B394 !important', 'color': 'white' });
        $(containerID).parents('.grid-stack-item-content').css({ 'background-color': '#12B394 !important', 'color': 'white' });
        $(containerID).siblings('.addWidgetButton').css({ 'background-color': 'white', 'color': '#12B394' });
    }
    else if (data < 4) {
        $(containerID).parents('.custom-widget').css({ 'background-color': '#F8AC3A !important', 'color': 'white' });
        $(containerID).parents('.grid-stack-item-content').css({ 'background-color': '#F8AC3A !important', 'color': 'white' });
    }
    else {
        $(containerID).parents('.custom-widget').css({ 'background-color': '#ED5565 !important', 'color': 'white' });
        $(containerID).parents('.grid-stack-item-content').css({ 'background-color': '#ED5565 !important', 'color': 'white' });
    }
}

function bindBranchDailyAverageOrderTime(data, containerID) {
    var elementInsideContainer = "";
    elementInsideContainer +=
        `<div class="one-row" style="margin-bottom: 0px;">
                <div class="col-xs-4">
                    <i class="fas fa-cash-register" style="font-size: 5em;"></i>
                </div>
                <div class="col-xs-8">
                    <p class="title-right-mb-0">Average Order Time</p>
                    <p class="averageBranchOrderTime"></p>
                </div>
            </div>`;
    $(containerID).html(elementInsideContainer);
    $(containerID).find(".averageBranchOrderTime").text(data + ' mins');
    if (data < 2) {
        $(containerID).parents('.custom-widget').css({ 'background-color': '#12B394 !important', 'color': 'white' });
        $(containerID).parents('.grid-stack-item-content').css({ 'background-color': '#12B394 !important', 'color': 'white' });
        $(containerID).siblings('.addWidgetButton').css({ 'background-color': 'white', 'color': '#12B394' });
    }
    else if (data < 4) {
        $(containerID).parents('.custom-widget').css({ 'background-color': '#F8AC3A !important', 'color': 'white' });
        $(containerID).parents('.grid-stack-item-content').css({ 'background-color': '#F8AC3A !important', 'color': 'white' });
    }
    else {
        $(containerID).parents('.custom-widget').css({ 'background-color': '#ED5565 !important', 'color': 'white' });
        $(containerID).parents('.grid-stack-item-content').css({ 'background-color': '#ED5565 !important', 'color': 'white' });
    }
}

function bindBranchQueueCustomerJourneyTime(data, containerID) {
    var elementInsideContainer = "";
    elementInsideContainer +=
        `<div class="one-row" style="margin-bottom: 0px;">
                <div class="col-xs-4">
                    <i class="fas fa-route" style="font-size: 5em;"></i>
                </div>
                <div class="col-xs-8">
                    <p class="title-right-mb-0">Customer Journey</p>
                    <p class="branchCustomerJourneyTime"></p>
                </div>
            </div>`;
    $(containerID).html(elementInsideContainer);
    $(containerID).find(".branchCustomerJourneyTime").text(data + ' mins');
}

function bindBranchDailyAveragePickupTime(data, containerID) {
    var elementInsideContainer = "";
    elementInsideContainer +=
        `<div class="one-row" style="margin-bottom: 0px;">
                <div class="col-xs-4">
                    <i class="fas fa-concierge-bell" style="font-size: 5em;"></i>
                </div>
                <div class="col-xs-8">
                    <p class="title-right-mb-0">Average Pick Up Time</p>
                    <p class="averageBranchPickupTime"></p>
                </div>
            </div>`;
    $(containerID).html(elementInsideContainer);
    $(containerID).find(".averageBranchPickupTime").text(data + ' mins');
    if (data < 2) {
        $(containerID).parents('.custom-widget').css({ 'background-color': '#12B394 !important', 'color': 'white' });
        $(containerID).parents('.grid-stack-item-content').css({ 'background-color': '#12B394 !important', 'color': 'white' });
        $(containerID).siblings('.addWidgetButton').css({ 'background-color': 'white', 'color': '#12B394' });
    }
    else if (data < 4) {
        $(containerID).parents('.custom-widget').css({ 'background-color': '#F8AC3A !important', 'color': 'white' });
        $(containerID).parents('.grid-stack-item-content').css({ 'background-color': '#F8AC3A !important', 'color': 'white' });
    }
    else {
        $(containerID).parents('.custom-widget').css({ 'background-color': '#ED5565 !important', 'color': 'white' });
        $(containerID).parents('.grid-stack-item-content').css({ 'background-color': '#ED5565 !important', 'color': 'white' });
    }
}

function bindBranchQueueOrderingPickupTimeGraph(data, containerID, isDemo) {
    var elementInsideContainer = "";
    elementInsideContainer +=
        `<div class="branchQueueOrderingPickupTimeGraph">
        </div>`;
    $(containerID).html(elementInsideContainer);

    chart1 = new Highcharts.Chart({
        chart: {
            renderTo: $(containerID).find('.branchQueueOrderingPickupTimeGraph')[0],
            type: 'column',
            backgroundColor: 'transparent',
            height: $(containerID).parents('.grid-stack-item-content').height() - 20
        },
        title: {
            text: ''
        },
        credits: {
            enabled: false
        },
        xAxis: {
            categories: isDemo ?
                ['00:00', '01:00', '02:00', '03:00', '04:00', '05:00', '06:00', '07:00', '08:00', '09:00', '10:00', '11:00', '12:00', '13:00', '14:00', '15:00', '16:00', '17:00', '18:00', '19:00', '20:00', '21:00', '22:00', '23:00'] : data.map(m => m.DateTimeString),
            title: {
                text: 'Time',
                align: 'high'
            },
            labels: {
                rotation: 90
            }
        },
        yAxis: {
            allowDecimals: false,
            lineWidth: 0,
            //tickInterval: dynamicTickIntervalVisitorTotal,
            tickWidth: 1,
            tickLength: 5,
            min: 0,
            tickPosition: 'inside',
            title: {
                text: "Minutes",
                style: {
                    color: '#6E6E6F'
                }
            },
            labels: {
                style: {
                    color: '#6E6E6F'
                }
            }
        },
        plotOptions: {
            column: {
                stacking: 'normal',
                dataLabels: {
                    enabled: false
                }
            }
        },
        legend: {
            verticalAlign: 'top',
            borderWidth: 1,
            margin: 0
        },
        series: [{
            name: 'Pick Up Time',
            color: "#FBD7DA",
            type: 'column',
            data: isDemo ? [5, 4, 6, 8, 5, 10, 9, 12, 3, 6, 7, 8, 7, 5, 4, 9, 2, 5, 11, 4, 5, 8, 7, 4] : data.map(m => m.PickUpTime)
        }, {
            name: 'Ordering Time',
            color: "#F9BEC1",
            type: 'column',
            data: isDemo ? [8, 10, 5, 2, 6, 7, 10, 2, 4, 8, 8, 4, 8, 9, 5, 6, 5, 8, 11, 4, 6, 5, 9, 8] : data.map(m => m.OrderingTime)
        }, {
            name: 'Queue Time',
            type: 'column',
            color: "#F7A6AD",
            data: isDemo ? [10, 14, 13, 5, 8, 10, 11, 7, 10, 14, 13, 5, 8, 10, 11, 7, 10, 14, 13, 5, 8, 10, 11, 7] : data.map(m => m.QueueTime)
        }]

    });
    chart1.reflow();

}

function bindBranchLatestHourQueueLength(data, containerID) {
    var elementInsideContainer = "";
    elementInsideContainer +=
        `<div class="one-row" style="margin-bottom: 0px;">
                <div class="col-xs-4">
                    <i class="fas fa-ruler" style="font-size: 5em;"></i>
                </div>
                <div class="col-xs-8">
                    <p class="title-right-mb-0">Queue Length</p>
                    <p class="branchLastHourQueueLength"></p>
                </div>
            </div>`;
    $(containerID).html(elementInsideContainer);
    $(containerID).find(".branchLastHourQueueLength").text(data);
}

//TO BE IMPLEMENTED for KFC DASHBOARD (KELVIN)
function bindBranchMaleToiletCount(data, containerID) {
    var elementInsideContainer = "";
    elementInsideContainer +=
        `<div class="one-row" style="margin-bottom: 0px;">
                <div class="col-xs-4">
                    <i class="fas fa-male" style="font-size: 5em;"></i>
                </div>
                <div class="col-xs-8">
                    <p class="title-right-mb-0">Male Toilet</p>
                    <p class="branchMaleToiletCount"></p>
                </div>
            </div>`;
    $(containerID).html(elementInsideContainer);
    $(containerID).find(".branchMaleToiletCount").text("-");
}

//TO BE IMPLEMENTED for KFC DASHBOARD (KELVIN)
function bindBranchFemaleToiletCount(data, containerID) {
    var elementInsideContainer = "";
    elementInsideContainer +=
        `<div class="one-row" style="margin-bottom: 0px;">
                <div class="col-xs-4">
                    <i class="fas fa-female" style="font-size: 5em;"></i>
                </div>
                <div class="col-xs-8">
                    <p class="title-right-mb-0">Female Toilet</p>
                    <p class="branchFemaleToiletCount"></p>
                </div>
            </div>`;
    $(containerID).html(elementInsideContainer);
    $(containerID).find(".branchFemaleToiletCount").text("-");
}

//What Gary Try To Build

function bindWhatGaryTryToBuild(data, containerID) {


    var elementInsideContainer = "";
    elementInsideContainer +=
        `<div class="one-row" style="margin-bottom: 0px;">
                <div class="col-xs-4">
                    <i class="fas fa-laugh-wink" style="font-size: 5em;"></i>
                </div>
                <div class="col-xs-8">
                    <p class="title-right-mb-0">Sample</p>
                    <p class="whatGaryTryToBuild"></p>
                </div>
            </div>`;
    $(containerID).html(elementInsideContainer);
    $(containerID).find(".whatGaryTryToBuild").text("Meta");
    //$(containerID).parents('.custom-widget').css({ 'background-color': '#12B394 !important', 'color': 'white' });
    //$(containerID).parents('.grid-stack-item-content').css({ 'background-color': '#12B394 !important', 'color': 'white' });
    //$(containerID).siblings('.addWidgetButton').css({ 'background-color': 'white', 'color': '#12B394' });
}


//What Gary Try To Build2

function bindWhatGaryTryToBuild2(containerID) {


    var thisWeekVisitorList = [50,60,70];  // need do manual list later
    var lastWeekVisitorList = [80,90,100];
    var branchNameList = ["ali","abu","ahmad"];
    var changesVisitorList = [30,30,30];
    $(containerID).html('');

    if (thisWeekVisitorList.length <= 0) {
        $("#garytable").html('');
    }
    else {
        $(containerID).append('<thead><tr><th class="rankBranchTh">' + "Rank" + '</th><th class="rankBranchTh">' + "Site" + '</th><th class="thisWeekLastWeekChangesThTd">'
            + "This Week" + '</th><th class="thisWeekLastWeekChangesThTd">' + "Last Week" + '</th><th class="thisWeekLastWeekChangesThTd">' + "Changes" + ' (%)</th></tr></thead><tbody>');
        for (var i = 0; i < thisWeekVisitorList.length; i++) {
            var firstColumn = branchNameList[i];
            var secondColumn = thisWeekVisitorList[i] > 0 ? numberify(thisWeekVisitorList[i]) : " - ";
            var thirdColumn = lastWeekVisitorList[i] > 0 ? numberify(lastWeekVisitorList[i]) : " - ";
            var fourthColumn = changesVisitorList[i] > 0 ? "<i class='fa fa-caret-up rise'></i> " + Math.abs(changesVisitorList[i]) :
                changesVisitorList[i] < 0 ? "<i class='fa fa-caret-down drop'></i> " + Math.abs(changesVisitorList[i]) :
                    changesVisitorList[i] == 0 ? " - " : " - ";
            var rank = i + 1;
            $(containerID).append('<tr><td class="rankBranchTd">' + rank + '</td><td class="rankBranchTd">' + firstColumn + '</td><td class="thisWeekLastWeekChangesThTd">' + secondColumn + '</td>' +
                '<td class="thisWeekLastWeekChangesThTd">' + thirdColumn + '</td><td class="thisWeekLastWeekChangesThTd">' + fourthColumn + '</td></tr></tbody>');

        }
    }
}

//What Gary Try To Build3

function bindWhatGaryTryToBuild3(averageQueueTimeQuarterHourly, averageQueueTimeHourly, containerID) {


    var averageQueueTimeQuarterHourlyString = moment.duration(averageQueueTimeQuarterHourly, 'seconds').format('mm:ss').length <= 2 ?
        "00:" + moment.duration(averageQueueTimeQuarterHourly, 'seconds').format('mm:ss') :
        moment.duration(averageQueueTimeQuarterHourly, 'seconds').format('mm:ss');

    var averageQueueTimeHourlyString = moment.duration(averageQueueTimeHourly, 'seconds').format('mm:ss').length <= 2 ?
        "00:" + moment.duration(averageQueueTimeHourly, 'seconds').format('mm:ss') :
        moment.duration(averageQueueTimeHourly, 'seconds').format('mm:ss');

    var averageQueueTimeQuarterHourlyColor;
    var averageQueueTimeHourlyColor;

    if (averageQueueTimeQuarterHourly < (3 * 60)) {
        averageQueueTimeQuarterHourlyColor = 'rgba(20,177,147,1)';
    } else if (averageQueueTimeQuarterHourly < (5 * 60)) {
        averageQueueTimeQuarterHourlyColor = 'rgba(249,172,57,1)';
    } else {
        averageQueueTimeQuarterHourlyColor = 'rgba(235,87,101,1)';
    }

    if (averageQueueTimeHourly < (3 * 60)) {
        averageQueueTimeHourlyColor = 'rgba(20,177,147,1)';
    } else if (averageQueueTimeHourly < (5 * 60)) {
        averageQueueTimeHourlyColor = 'rgba(249,172,57,1)';
    } else {
        averageQueueTimeHourlyColor = 'rgba(235,87,101,1)';
    }

    $(containerID).html(`
        <div class="queue-widget-container">
            <div class="queue-widget-inner-container-1">
                <div class="avg-queue-time-quarter-hourly-container">
                    <strong style="font-size:55px;color:${averageQueueTimeQuarterHourlyColor}">${averageQueueTimeQuarterHourlyString}</strong>
                </div>
                <div class="widget-name-container">
                    <span>Footfallcam</span>
                </div>
            </div>
            <div class="queue-widget-inner-container-2">
                <div class="queue-time-threshold-container">
                    <div>
                        <p style="font-size:10px;margin:0px">GOAL</p>
                        <strong style="font-size:20px">3:00</strong>
                    </div>
                </div>
                <div class="avg-queue-time-hourly-container">
                    <div>
                        <p style="font-size:10px;margin:0px">HOURLY AVG.</p>
                        <strong style="font-size:20px;color:${averageQueueTimeHourlyColor}">${averageQueueTimeHourlyString}</strong>
                    </div>
                </div>
            </div>
        </div>
    `);
}

//what gary try to build 4

function bindWhatGaryTryToBuild4(containerID) {


    var highChartId = containerID;



    // Uncomment code below to find out which graph allow y Axis label to be decimal
    //console.log(highchartIds[index][2] + ": " + highchartIds[index][3]);


    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: highChartId,
                type: 'variablepie'
            },

            title: {
                text: ''
            },
            tooltip: {
                headerFormat: '',
                pointFormat: '<span style="color:{point.color}">\u25CF</span> <b> {point.name}</b><br/>' +
                    'Area (square km): <b>{point.y}</b><br/>' +
                    'Population density (people per square km): <b>{point.z}</b><br/>'
            },

            plotOptions: {
                pie: {
                    allowPointSelect: true,
                    cursor: 'pointer',
                    dataLabels: {
                        enabled: false
                    },
                    showInLegend: true
                }
            },

            series: [{
                minPointSize: 10,
                innerSize: '20%',
                zMin: 0,
                name: 'countries',
                data: [{
                    name: 'Spain',
                    y: 505370,
                    z: 92.9
                }, {
                    name: 'France',
                    y: 551500,
                    z: 118.7
                }, {
                    name: 'Poland',
                    y: 312685,
                    z: 124.6
                }, {
                    name: 'Czech Republic',
                    y: 78867,
                    z: 137.5
                }, {
                    name: 'Italy',
                    y: 301340,
                    z: 201.8
                }, {
                    name: 'Switzerland',
                    y: 41277,
                    z: 214.5
                }, {
                    name: 'Germany',
                    y: 357022,
                    z: 235.6
                }]
            }]
        },
            function (chart) {
                //if (!HasLastYearDataForVisitorCount) {
                //    chart.series[1].remove(true);
                //}
            });
    });
}

// What Gary Try To Build 5

function bindWhatGaryTryToBuild5(containerID) {


    var highChartId = containerID;



    // Uncomment code below to find out which graph allow y Axis label to be decimal
    //console.log(highchartIds[index][2] + ": " + highchartIds[index][3]);


    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: highChartId,
                type: 'pie'
            },
            title: {
                text: 'Browser market shares. January, 2018'
            },
            subtitle: {
                text: 'Click the slices to view versions.'
            },
            plotOptions: {
                series: {
                    dataLabels: {
                        enabled: true,
                        format: '{point.name}: {point.y:.1f}%'
                    }
                },
                
                pie: {
                    
                    cursor: 'pointer',
                    dataLabels: {
                        enabled: true,
                    },
                    showInLegend: true
                }
            },

            tooltip: {
                headerFormat: '<span style="font-size:11px">{series.name}</span><br>',
                pointFormat: '<span style="color:{point.color}">{point.name}</span>: <b>{point.y:.2f}%</b> of total<br/>'
            },

            series: [
                {
                    name: "Browsers",
                    colorByPoint: true,
                    data: [
                        {
                            name: "Chrome",
                            y: 62.74,
                            drilldown: "Chrome"
                        },
                        {
                            name: "Firefox",
                            y: 10.57,
                            drilldown: "Firefox"
                        },
                        {
                            name: "Internet Explorer",
                            y: 7.23,
                            drilldown: "Internet Explorer"
                        },
                        {
                            name: "Safari",
                            y: 5.58,
                            drilldown: "Safari"
                        },
                        {
                            name: "Edge",
                            y: 4.02,
                            drilldown: "Edge"
                        },
                        {
                            name: "Opera",
                            y: 1.92,
                            drilldown: "Opera"
                        },
                        {
                            name: "Other",
                            y: 7.62,
                            drilldown: null
                        }
                    ]
                }
            ],
            drilldown: {
                series: [
                    {
                        name: "Chrome",
                        id: "Chrome",
                        data: [
                            [
                                "v65.0",
                                0.1
                            ],
                            [
                                "v64.0",
                                1.3
                            ],
                            [
                                "v63.0",
                                53.02
                            ],
                            [
                                "v62.0",
                                1.4
                            ],
                            [
                                "v61.0",
                                0.88
                            ],
                            [
                                "v60.0",
                                0.56
                            ],
                            [
                                "v59.0",
                                0.45
                            ],
                            [
                                "v58.0",
                                0.49
                            ],
                            [
                                "v57.0",
                                0.32
                            ],
                            [
                                "v56.0",
                                0.29
                            ],
                            [
                                "v55.0",
                                0.79
                            ],
                            [
                                "v54.0",
                                0.18
                            ],
                            [
                                "v51.0",
                                0.13
                            ],
                            [
                                "v49.0",
                                2.16
                            ],
                            [
                                "v48.0",
                                0.13
                            ],
                            [
                                "v47.0",
                                0.11
                            ],
                            [
                                "v43.0",
                                0.17
                            ],
                            [
                                "v29.0",
                                0.26
                            ]
                        ]
                    },
                    {
                        name: "Firefox",
                        id: "Firefox",
                        data: [
                            [
                                "v58.0",
                                1.02
                            ],
                            [
                                "v57.0",
                                7.36
                            ],
                            [
                                "v56.0",
                                0.35
                            ],
                            [
                                "v55.0",
                                0.11
                            ],
                            [
                                "v54.0",
                                0.1
                            ],
                            [
                                "v52.0",
                                0.95
                            ],
                            [
                                "v51.0",
                                0.15
                            ],
                            [
                                "v50.0",
                                0.1
                            ],
                            [
                                "v48.0",
                                0.31
                            ],
                            [
                                "v47.0",
                                0.12
                            ]
                        ]
                    },
                    {
                        name: "Internet Explorer",
                        id: "Internet Explorer",
                        data: [
                            [
                                "v11.0",
                                6.2
                            ],
                            [
                                "v10.0",
                                0.29
                            ],
                            [
                                "v9.0",
                                0.27
                            ],
                            [
                                "v8.0",
                                0.47
                            ]
                        ]
                    },
                    {
                        name: "Safari",
                        id: "Safari",
                        data: [
                            [
                                "v11.0",
                                3.39
                            ],
                            [
                                "v10.1",
                                0.96
                            ],
                            [
                                "v10.0",
                                0.36
                            ],
                            [
                                "v9.1",
                                0.54
                            ],
                            [
                                "v9.0",
                                0.13
                            ],
                            [
                                "v5.1",
                                0.2
                            ]
                        ]
                    },
                    {
                        name: "Edge",
                        id: "Edge",
                        data: [
                            [
                                "v16",
                                2.6
                            ],
                            [
                                "v15",
                                0.92
                            ],
                            [
                                "v14",
                                0.4
                            ],
                            [
                                "v13",
                                0.1
                            ]
                        ]
                    },
                    {
                        name: "Opera",
                        id: "Opera",
                        data: [
                            [
                                "v50.0",
                                0.96
                            ],
                            [
                                "v49.0",
                                0.82
                            ],
                            [
                                "v12.1",
                                0.14
                            ]
                        ]
                    }
                ]
            }
        },
            function (chart) {
                //if (!HasLastYearDataForVisitorCount) {
                //    chart.series[1].remove(true);
                //}
            });
    });

}



//build by gary
function bindCompanyCurrentWeekVisitorCount(data, containerID) {
    if (data == 'demo') {


        var highChartId = containerID.replace('#', '');





        $(function () {
            var chart = new Highcharts.Chart({
                chart: {
                    renderTo: highChartId,
                    plotBackgroundColor: null,
                    plotBorderWidth: 0,
                    plotShadow: false
                },
                title: {
                    text: 'Browser<br>shares<br>2017',
                    align: 'center',
                    verticalAlign: 'middle',
                    y: 45
                },
                tooltip: {
                    pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
                },
                plotOptions: {
                    pie: {
                        dataLabels: {
                            enabled: true,
                            distance: -50,
                            style: {
                                fontWeight: 'bold',
                                color: 'white'
                            }
                        },
                        allowPointSelect: true,
                        cursor: 'pointer',
                        showInLegend: true,
                        startAngle: -90,
                        endAngle: 90,
                        center: ['50%', '75%'],
                        size: '110%'
                    },

                    series: {
                        dataLabels: {
                            enabled: true,
                            format: '{point.y:.1f}%'
                        }
                    },
                },
                series: [{
                    type: 'pie',
                    name: 'Browser share',
                    innerSize: '50%',
                    data: [
                        ['Chrome', 58.9],
                        ['Firefox', 13.29],
                        ['Internet Explorer', 13],
                        ['Edge', 3.78],
                        ['Safari', 3.42],
                        {
                            name: 'Other',
                            y: 7.61,
                            dataLabels: {
                                enabled: true,
                            }
                        }
                    ]
                }]
            },
                function (chart) {
                    //if (!HasLastYearDataForVisitorCount) {
                    //    chart.series[1].remove(true);
                    //}
                });
        });


    }
    else {


        var thisWeekVisitorList = data.series[0].ValueInInt;

        //var lastWeekVisitorList = data.series[0].LastValueInList;
        var branchNameList = data.series[0].branchName;

        //var changesVisitorList = data.series[0].DifferencesInFFList;

        var highChartId = containerID.replace('#', '');

        var final = [];

        for (var i = 0; i < branchNameList.length; i++) {
            final.push({
                name: branchNameList[i],
                y: thisWeekVisitorList[i]
            });
        }





        $(function () {
            var chart = new Highcharts.Chart({
                chart: {
                    renderTo: highChartId,
                    plotBackgroundColor: null,
                    plotBorderWidth: 0,
                    plotShadow: false,
                    colorCount: 45
                },
                title: {
                    text: 'Visitor Count<br>______________ <br>Total: ' + thisWeekVisitorList.reduce((a, b) => a + b, 0),
                    align: 'center',
                    verticalAlign: 'middle',
                    y: 40,
                    style: {
                        fontSize: '15px'
                    }
                },
                tooltip: {
                    pointFormat: '{series.name}: <b>{point.y}</b><br/>' +
                        'Percentage: <b>{point.percentage:.1f}%</b><br/>'
                },

                credits: {
                    enabled: false
                },

                plotOptions: {
                    pie: {
                        dataLabels: {
                            enabled: false,
                            distance: -50,
                            style: {
                                fontWeight: 'bold',
                                color: 'white'
                            }
                        },
                        allowPointSelect: true,
                        cursor: 'pointer',
                        showInLegend: true,
                        startAngle: -90,
                        endAngle: 90,
                        center: ['50%', '75%'],
                        size: '110%'
                    },

                    series: {
                        dataLabels: {
                            enabled: true,
                            format: '{point.percentage:.1f}%'
                        }
                    },
                },
                series: [{
                    type: 'pie',
                    name: 'This Week Visitor',
                    innerSize: '50%',
                    data: final
                }]
            },
                function (chart) {
                    //if (!HasLastYearDataForVisitorCount) {
                    //    chart.series[1].remove(true);
                    //}
                });
        });

    }
}


//build by gary

function bindCompanyCurrentAndLastWeekVisitorCountComparison(data, containerID) {


    var highChartId = containerID.replace('#', '');

    var thisWeekVisitorList = data.series[0].ValueInInt;

    var lastWeekVisitorList = data.series[0].LastValueInList;
    var branchNameList = data.series[0].branchName;

    //var changesVisitorList = data.series[0].DifferencesInFFList + '%';

    var final = [];

    final.push({
        name: "This Week",
        data: thisWeekVisitorList,
        color:'#000000',
        //pointPlacement: 'on',
    });

    final.push({
        name: "Last Week",
        data: lastWeekVisitorList,
        color:'#999999',
        //pointPlacement: 'on',
    });

    console.log(final);


    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: highChartId,
                type: 'line'
            },


            title: {
                text: null,
                align: 'left'
                
            },

            pane: {
                size: '80%'
            },

            xAxis: {
                categories: branchNameList,
                tickmarkPlacement: 'on',
                lineWidth: 0,
                

                labels: {
                    rotation: -90
                }
            },

            yAxis: {
                gridLineInterpolation: 'polygon',
                lineWidth: 0,
                min: 0,
                title : { enabled: true, text: 'Total Visitor'}
            },

            tooltip: {
                shared: true,
                pointFormat: '<span style="color:{series.color}">{series.name}: <b>{point.y:,.0f}</b><br/>'
            },

            legend: {
                align: 'center',
                verticalAlign: 'top'
            },

            credits: {
                enabled: false
            },

            series: final,

            responsive: {
                rules: [{
                    condition: {
                        maxWidth: 500
                    },
                    chartOptions: {
                        legend: {
                            align: 'center',
                            verticalAlign: 'top'
                        },
                        pane: {
                            size: '70%'
                        }
                    }
                }]
            }
        },
            function (chart) {
                //if (!HasLastYearDataForVisitorCount) {
                //    chart.series[1].remove(true);
                //}
            });
    });
}




function bindSiteHourlyPasserByCountForEachZone(data, containerID) {


    var highChartId = containerID.replace('#', '');

    var thisWeekVisitorList = data.series[0].ValueInInt;

    var lastWeekVisitorList = data.series[0].LastValueInList;
    var branchNameList = data.series[0].branchName;

    //var changesVisitorList = data.series[0].DifferencesInFFList + '%';

    var final = [];

    final.push({
        name: "Zone 1",
        data: thisWeekVisitorList,
        color: '#357EC7',
        marker: {
            //enabled: false,
            symbol: 'circle',
            radius: 3,
            states: {
                hover: {
                    fillColor: '#FFA500',
                }
            }
        },
        //pointPlacement: 'on',
    });

    final.push({
        name: "Zone 2",
        data: lastWeekVisitorList,
        color: '#C2DFFF',
        marker: {
            //enabled: false,
            symbol: 'circle',
            radius: 3,
            states: {
                hover: {
                    fillColor: '#FFA500',
                }
            }
        },
        //pointPlacement: 'on',
    });

    console.log(final);


    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: highChartId,
                type: 'line'
            },

            title: {
                text: "HOURLY PASSER-BY",
                align: 'left'

            },

            pane: {
                size: '80%'
            },

            xAxis: {
                //categories: branchNameList,
                tickmarkPlacement: 'on',
                lineWidth: 0,
                title: { enabled: true, text: 'Date' , align: 'high' },

                labels: {
                    rotation: -90
                }
            },

            yAxis: {
                gridLineInterpolation: 'polygon',
                lineWidth: 0,
                min: 0,
                title: { enabled: true, text: 'Passer-By' }
            },

            tooltip: {
                //backgroundColor: '#d3d3d3',
                useHTML: true,

                //pointFormatter: function () {
                //    var point = this,
                //        series = point.series,
                //        legendSymbol = "<svg width='20' height='20'>" + series.legendSymbol.element.outerHTML + "</svg>";

                //    return legendSymbol + series.name + ": <b>" + point.y + "</b><br/>";

                    
                formatter: function() {
                    var s = '<b>' + this.x + '</b>';

                    $.each(this.points, function (i, point) {
                        s += '<br/><span style="color:' + point.color + '">\u25A0 </span> ' + '<span style="color: black ">' + point.series.name + ': ' + point.y + '</span>';
                    });

                    return s;
                },
                shared: true
                    
                //},

                //shared: true
                /*
                pointFormat:
                    '<svg width="10" height="10" style="color:{series.color}"></svg> <b>{series.name}: {point.y:,.0f}</b><br/>',
                shared: true
                //pointFormat: '<span>{series.name}: <b>{point.y:,.0f}</b><br/>'
                */
            },

            legend: {
                align: 'right',
                verticalAlign: 'top'
            },

            credits: {
                enabled: false
            },

            series: final,


            responsive: {
                rules: [{
                    condition: {
                        maxWidth: 500
                    },
                    chartOptions: {
                        legend: {
                            align: 'center',
                            verticalAlign: 'top'
                        },
                        pane: {
                            size: '70%'
                        }
                    }
                }]
            }
        },
            function (chart) {
                //if (!HasLastYearDataForVisitorCount) {
                //    chart.series[1].remove(true);
                //}
            });
    });
}




function bindGetLiveAvgQueueTime(averageQueueTimeQuarterHourly, averageQueueTimeHourly, containerID) {

    var averageQueueTimeQuarterHourlyString = moment.duration(averageQueueTimeQuarterHourly, 'seconds').format('mm:ss').length <= 2 ?
        "00:" + moment.duration(averageQueueTimeQuarterHourly, 'seconds').format('mm:ss') :
        moment.duration(averageQueueTimeQuarterHourly, 'seconds').format('mm:ss');

    var averageQueueTimeHourlyString = moment.duration(averageQueueTimeHourly, 'seconds').format('mm:ss').length <= 2 ?
        "00:" + moment.duration(averageQueueTimeHourly, 'seconds').format('mm:ss') :
        moment.duration(averageQueueTimeHourly, 'seconds').format('mm:ss');

    var averageQueueTimeQuarterHourlyColor;
    var averageQueueTimeHourlyColor;

    //if (averageQueueTimeQuarterHourly < (3 * 60)) {
    //    averageQueueTimeQuarterHourlyColor = 'rgba(20,177,147,1)';
    //} else if (averageQueueTimeQuarterHourly < (5 * 60)) {
    //    averageQueueTimeQuarterHourlyColor = 'rgba(249,172,57,1)';
    //} else {
    //    averageQueueTimeQuarterHourlyColor = 'rgba(235,87,101,1)';
    //}

    //if (averageQueueTimeHourly < (3 * 60)) {
    //    averageQueueTimeHourlyColor = 'rgba(20,177,147,1)';
    //} else if (averageQueueTimeHourly < (5 * 60)) {
    //    averageQueueTimeHourlyColor = 'rgba(249,172,57,1)';
    //} else {
    //    averageQueueTimeHourlyColor = 'rgba(235,87,101,1)';
    //}

    if (averageQueueTimeQuarterHourly < (3 * 60)) {
        averageQueueTimeQuarterHourlyColor = 'green-text';
    } else if (averageQueueTimeQuarterHourly < (5 * 60)) {
        averageQueueTimeQuarterHourlyColor = 'yellow-text';
    } else {
        averageQueueTimeQuarterHourlyColor = 'red-text';
    }

    if (averageQueueTimeHourly < (3 * 60)) {
        averageQueueTimeHourlyColor = 'green-text';
    } else if (averageQueueTimeHourly < (5 * 60)) {
        averageQueueTimeHourlyColor = 'yellow-text';
    } else {
        averageQueueTimeHourlyColor = 'red-text';
    }

    $(containerID).html(`<div class="mainColumn">
						<div class="mainTime">
							<h2 class="${averageQueueTimeQuarterHourlyColor}">${averageQueueTimeQuarterHourlyString}</h2>
						</div>
						<div class="labelWrapper">
							<p class="mainLabel">Avg. Queue Time</p>
							<p class="subLabel"></p>
						</div>
					</div>
					<div class="goalColumn">
					<p class="subLabel">GOAL</p>
					<h5 class="subTime">03:00</h5>
					</div>
					<div class="hourlyAvgColumn">
					<p class="subLabel">HOURLY<br>AVG.</p>
					<h5 class="${averageQueueTimeHourlyColor} subTime">${averageQueueTimeHourlyString}</h5>
					</div>`);

    $(containerID).addClass("b01");
}

function bindGetLiveAvgOrderingTime(averageOrderingTimeQuarterHourly, averageOrderingTimeHourly, containerID) {

    var averageOrderingTimeQuarterHourlyString = moment.duration(averageOrderingTimeQuarterHourly, 'seconds').format('mm:ss').length <= 2 ?
        "00:" + moment.duration(averageOrderingTimeQuarterHourly, 'seconds').format('mm:ss') :
        moment.duration(averageOrderingTimeQuarterHourly, 'seconds').format('mm:ss');

    var averageOrderingTimeHourlyString = moment.duration(averageOrderingTimeHourly, 'seconds').format('mm:ss').length <= 2 ?
        "00:" + moment.duration(averageOrderingTimeHourly, 'seconds').format('mm:ss') :
        moment.duration(averageOrderingTimeHourly, 'seconds').format('mm:ss');

    var averageOrderingTimeQuarterHourlyColor;
    var averageOrderingTimeHourlyColor;

    //if (averageOrderingTimeQuarterHourly < (1 * 60)) {
    //    averageOrderingTimeQuarterHourlyColor = 'rgba(20,177,147,1)';
    //} else if (averageOrderingTimeQuarterHourly < (2 * 60)) {
    //    averageOrderingTimeQuarterHourlyColor = 'rgba(249,172,57,1)';
    //} else {
    //    averageOrderingTimeQuarterHourlyColor = 'rgba(235,87,101,1)';
    //}

    //if (averageOrderingTimeHourly < (1 * 60)) {
    //    averageOrderingTimeHourlyColor = 'rgba(20,177,147,1)';
    //} else if (averageOrderingTimeHourly < (2 * 60)) {
    //    averageOrderingTimeHourlyColor = 'rgba(249,172,57,1)';
    //} else {
    //    averageOrderingTimeHourlyColor = 'rgba(235,87,101,1)';
    //}

    if (averageOrderingTimeQuarterHourly < (1 * 60)) {
        averageOrderingTimeQuarterHourlyColor = 'green-text';
    } else if (averageOrderingTimeQuarterHourly < (2 * 60)) {
        averageOrderingTimeQuarterHourlyColor = 'yellow-text';
    } else {
        averageOrderingTimeQuarterHourlyColor = 'red-text';
    }

    if (averageOrderingTimeHourly < (1 * 60)) {
        averageOrderingTimeHourlyColor = 'green-text';
    } else if (averageOrderingTimeHourly < (2 * 60)) {
        averageOrderingTimeHourlyColor = 'yellow-text';
    } else {
        averageOrderingTimeHourlyColor = 'red-text';
    }

    $(containerID).html(`
        <div class="mainColumn">
						<div class="mainTime">
							<h2 class="${averageOrderingTimeQuarterHourlyColor}">${averageOrderingTimeQuarterHourlyString}</h2>
						</div>
						<div class="labelWrapper">
							<p class="mainLabel">Avg. Ordering Time</p>
							<p class="subLabel"></p>
						</div>
					</div>
					<div class="goalColumn">
					<p class="subLabel">GOAL</p>
					<h5 class="subTime">01:00</h5>
					</div>
					<div class="hourlyAvgColumn">
					<p class="subLabel">HOURLY<br>AVG.</p>
					<h5 class="${averageOrderingTimeHourlyColor} subTime">${averageOrderingTimeHourlyString}</h5>
					</div>`);

    $(containerID).addClass("b01");
}

function bindGetLiveAvgPickupTime(averagePickupTimeQuarterHourly, averagePickupTimeHourly, containerID) {

    var averagePickupTimeQuarterHourlyString = moment.duration(averagePickupTimeQuarterHourly, 'seconds').format('mm:ss').length <= 2 ?
        "00:" + moment.duration(averagePickupTimeQuarterHourly, 'seconds').format('mm:ss') :
        moment.duration(averagePickupTimeQuarterHourly, 'seconds').format('mm:ss');

    var averagePickupTimeHourlyString = moment.duration(averagePickupTimeHourly, 'seconds').format('mm:ss').length <= 2 ?
        "00:" + moment.duration(averagePickupTimeHourly, 'seconds').format('mm:ss') :
        moment.duration(averagePickupTimeHourly, 'seconds').format('mm:ss');

    var averagePickupTimeQuarterHourlyColor;
    var averagePickupTimeHourlyColor;

    //if (averagePickupTimeQuarterHourly < (3 * 60)) {
    //    averagePickupTimeQuarterHourlyColor = 'rgba(20,177,147,1)';
    //} else if (averagePickupTimeQuarterHourly < (5 * 60)) {
    //    averagePickupTimeQuarterHourlyColor = 'rgba(249,172,57,1)';
    //} else {
    //    averagePickupTimeQuarterHourlyColor = 'rgba(235,87,101,1)';
    //}

    //if (averagePickupTimeHourly < (3 * 60)) {
    //    averagePickupTimeHourlyColor = 'rgba(20,177,147,1)';
    //} else if (averagePickupTimeHourly < (5 * 60)) {
    //    averagePickupTimeHourlyColor = 'rgba(249,172,57,1)';
    //} else {
    //    averagePickupTimeHourlyColor = 'rgba(235,87,101,1)';
    //}

    if (averagePickupTimeQuarterHourly < (3 * 60)) {
        averagePickupTimeQuarterHourlyColor = 'green-text';
    } else if (averagePickupTimeQuarterHourly < (5 * 60)) {
        averagePickupTimeQuarterHourlyColor = 'yellow-text';
    } else {
        averagePickupTimeQuarterHourlyColor = 'red-text';
    }

    if (averagePickupTimeHourly < (3 * 60)) {
        averagePickupTimeHourlyColor = 'green-text';
    } else if (averagePickupTimeHourly < (5 * 60)) {
        averagePickupTimeHourlyColor = 'yellow-text';
    } else {
        averagePickupTimeHourlyColor = 'red-text';
    }

    $(containerID).html(`<div class="mainColumn">
						<div class="mainTime">
							<h2 class="${averagePickupTimeQuarterHourlyColor}">${averagePickupTimeQuarterHourlyString}</h2>
						</div>
						<div class="labelWrapper">
							<p class="mainLabel">Avg. Pickup Time</p>
							<p class="subLabel"></p>
						</div>
					</div>
					<div class="goalColumn">
					<p class="subLabel">GOAL</p>
					<h5 class="subTime">03:00</h5>
					</div>
					<div class="hourlyAvgColumn">
					<p class="subLabel">HOURLY<br>AVG.</p>
					<h5 class="${averagePickupTimeHourlyColor} subTime">${averagePickupTimeHourlyString}</h5>
					</div>`);

    $(containerID).addClass("b01");
}

function bindGetMaleWashroomManagement(WM03, WM01, SecondsAfterLastCleanedTime, containerID) {
    var timezoneOffset = $('#selectorSite option:selected').data('offset');
    var timezone = $('#selectorSite option:selected').data('timezone');

    var WM01_String = WM01 == 0 ? "-" : ParseTimestampToMoment(WM01, timezone, timezoneOffset).format("HH:mm");

    var WM03_Color;
    var WM01_Color;

    if (WM03 < 15) {
        WM03_Color = 'rgba(20,177,147,1)';
    } else if (WM03 < 30) {
        WM03_Color = 'rgba(249,172,57,1)';
    } else {
        WM03_Color = 'rgba(235,87,101,1)';
    }

    if (WM01 == 0) {
        WM01_Color = 'rgba(134,137,138,1)';
    } else if (SecondsAfterLastCleanedTime < 3600) {
        WM01_Color = 'rgba(20,177,147,1)';
    } else if (SecondsAfterLastCleanedTime < 5400) {
        WM01_Color = 'rgba(249,172,57,1)';
    } else {
        WM01_Color = 'rgba(235,87,101,1)';
    }

    $(containerID).html(`<div class="mainColumn">
						<div class="mainTime">
							<h2 style="color:${WM03_Color}">${WM03}</h2>
						</div>
						<div class="labelWrapper">
							<p class="mainLabel">Washroom Usage</p>
							<p class="subLabel">MALE WASHROOM</p>
						</div>
					</div>
					<div class="goalColumn">
					</div>
					<div class="hourlyAvgColumn">
					<p class="subLabel">LAST<br>CLEANED</p>
					<h5 class="subTime" style="color:${WM01_Color}">${WM01_String}</h5>
					</div>`);

    $(containerID).addClass("b01");
}

function bindGetFemaleWashroomManagement(WM03, WM01, SecondsAfterLastCleanedTime, containerID) {
    var timezoneOffset = $('#selectorSite option:selected').data('offset');
    var timezone = $('#selectorSite option:selected').data('timezone');

    var WM01_String = WM01 == 0 ? "-" : ParseTimestampToMoment(WM01, timezone, timezoneOffset).format("HH:mm");

    var WM03_Color;
    var WM01_Color;

    if (WM03 < 15) {
        WM03_Color = 'rgba(20,177,147,1)';
    } else if (WM03 < 30) {
        WM03_Color = 'rgba(249,172,57,1)';
    } else {
        WM03_Color = 'rgba(235,87,101,1)';
    }
    

    if (WM01 == 0) {
        WM01_Color = 'rgba(134,137,138,1)';
    } else if (SecondsAfterLastCleanedTime < 3600) {
        WM01_Color = 'rgba(20,177,147,1)';
    } else if (SecondsAfterLastCleanedTime < 5400) {
        WM01_Color = 'rgba(249,172,57,1)';
    } else {
        WM01_Color = 'rgba(235,87,101,1)';
    }

    $(containerID).html(`<div class="mainColumn">
						<div class="mainTime">
							<h2 style="color:${WM03_Color}">${WM03}</h2>
						</div>
						<div class="labelWrapper">
							<p class="mainLabel">Washroom Usage</p>
							<p class="subLabel">FEMALE WASHROOM</p>
						</div>
					</div>
					<div class="goalColumn">
					</div>
					<div class="hourlyAvgColumn">
					<p class="subLabel">LAST<br>CLEANED</p>
					<h5 class="subTime" style="color:${WM01_Color}">${WM01_String}</h5>
					</div>`);

    $(containerID).addClass("b01");
}


function bindLiveDustbinUsagePercentage(SB02, SB03, SecondsAfterLastCleanedTime, containerID) {
    var timezoneOffset = $('#selectorSite option:selected').data('offset');
    var timezone = $('#selectorSite option:selected').data('timezone');

    var SB02_string = SB02 == -1 ? "N/A" : SB02 == -2 ? "N/A " : SB02;
    var SB03_String = SB03 == 0 ? "-" : ParseTimestampToMoment(SB03, timezone, timezoneOffset).format("HH:mm");

    var SB02_Color;
    var SB03_Color;

    if (SB02 == -1) {
        SB02_Color = 'rgba(134,137,138,1)';
    } else if (SB02 == -2) {
        SB02_Color = 'rgba(134,137,138,1)';
    } else if (SB02 < 60) {
        SB02_Color = 'rgba(20,177,147,1)';
    } else if (SB02 < 90) {
        SB02_Color = 'rgba(249,172,57,1)';
    } else {
        SB02_Color = 'rgba(235,87,101,1)';
    }

    if (SB03 == 0) {
        SB03_Color = 'rgba(134,137,138,1)';
    } else if (SecondsAfterLastCleanedTime < 3600) {
        SB03_Color = 'rgba(20,177,147,1)';
    } else if (SecondsAfterLastCleanedTime < 5400) {
        SB03_Color = 'rgba(249,172,57,1)';
    } else {
        SB03_Color = 'rgba(235,87,101,1)';
    }

    $(containerID).html(`<div class="mainColumn">
						<div class="mainTime">
							<h2 style="color:${SB02_Color}">${SB02_string}</h2>
						</div>
						<div class="labelWrapper">
							<p class="mainLabel">Dustbin Usage (%)</p>
							<p class="subLabel">DUSTBIN 1</p>
						</div>
					</div>
					<div class="goalColumn">

					</div>
					<div class="hourlyAvgColumn">
					<p class="subLabel">LAST <br>CLEANED</p>
					<h5 style="color:${SB03_Color}" class="subTime">${SB03_String}</h5>
					</div>`);

    $(containerID).addClass("b01");
}

function bindLiveDustbinUsagePercentage2(SB02, SB03, SecondsAfterLastCleanedTime, containerID) {
    var timezoneOffset = $('#selectorSite option:selected').data('offset');
    var timezone = $('#selectorSite option:selected').data('timezone');

    var SB02_string = SB02 == -1 ? "N/A" : SB02 == -2 ? "N/A " : SB02;
    var SB03_String = SB03 == 0 ? "-" : ParseTimestampToMoment(SB03, timezone, timezoneOffset).format("HH:mm");

    var SB02_Color;
    var SB03_Color;

    if (SB02 == -1) {
        SB02_Color = 'rgba(134,137,138,1)';
    } else if (SB02 == -2) {
        SB02_Color = 'rgba(134,137,138,1)';
    } else if (SB02 < 60) {
        SB02_Color = 'rgba(20,177,147,1)';
    } else if (SB02 < 90) {
        SB02_Color = 'rgba(249,172,57,1)';
    } else {
        SB02_Color = 'rgba(235,87,101,1)';
    }

    if (SB03 == 0) {
        SB03_Color = 'rgba(134,137,138,1)';
    } else if (SecondsAfterLastCleanedTime < 3600) {
        SB03_Color = 'rgba(20,177,147,1)';
    } else if (SecondsAfterLastCleanedTime < 5400) {
        SB03_Color = 'rgba(249,172,57,1)';
    } else {
        SB03_Color = 'rgba(235,87,101,1)';
    }

    $(containerID).html(`<div class="mainColumn">
						<div class="mainTime">
							<h2 style="color:${SB02_Color}">${SB02_string}</h2>
						</div>
						<div class="labelWrapper">
							<p class="mainLabel">Dustbin Usage (%)</p>
							<p class="subLabel">DUSTBIN 2</p>
						</div>
					</div>
					<div class="goalColumn">

					</div>
					<div class="hourlyAvgColumn">
					<p class="subLabel">LAST <br>CLEANED</p>
					<h5 style="color:${SB03_Color}" class="subTime">${SB03_String}</h5>
					</div>`);

    $(containerID).addClass("b01");
}

function GetLiveAvgQueueTimeAPICall(timezone, timezoneOffset, thisWidgetID) {

    var currentTime = GetMomentOfTimeZone(timezone, timezoneOffset);
    //console.log("Queue: " + currentTime.format());

    var param = {
        currentTime: currentTime.format(),
        branchId: parseInt($("#selectorSite").val()) != 0 ? parseInt($("#selectorSite").val()) : 0
    };

    if (param.BranchId != 0) {
        var requestURL = "/Report/GetLiveAvgQueueTime";
        var ajaxMethod = "POST";
        $.ajax({
            type: ajaxMethod,
            url: requestURL,
            data: JSON.stringify(param),
            dataType: 'json',
            contentType: 'application/json',
            success: function (response) {

                if (response.statusCode = 200) {
                    if (widgetPullDataParam.IsExportExcelFlag) {
                        page.GetJsonFileData(response.URL);
                        
                    }
                    else {
                        bindGetLiveAvgQueueTime(response.Data.AverageQueueTimeQuarterHourly, response.Data.AverageQueueTimeHourly, thisWidgetID);
                    }
                }
            },
            error: function (request, status, error) {
                console.log(request);
                console.log(status);
                console.log(error);
            },
            complete: function () {
                setTimeout(function () {
                    GetLiveAvgQueueTimeAPICall(timezone, timezoneOffset, thisWidgetID);
                }, 1 * 60 * 1000);
            }
        });
    }
}

function GetLiveAvgOrderingTimeAPICall(timezone, timezoneOffset, thisWidgetID) {

    var currentTime = GetMomentOfTimeZone(timezone, timezoneOffset);

    var param = {
        currentTime: currentTime.format(),
        branchId: parseInt($("#selectorSite").val()) != 0 ? parseInt($("#selectorSite").val()) : 0
    };

    if (param.BranchId != 0) {
        var requestURL = "/Report/GetLiveAvgOrderingTime";
        var ajaxMethod = "POST";
        $.ajax({
            type: ajaxMethod,
            url: requestURL,
            data: JSON.stringify(param),
            dataType: 'json',
            contentType: 'application/json',
            success: function (response) {
                if (response.statusCode = 200) {
                    if (widgetPullDataParam.IsExportExcelFlag) {
                        page.GetJsonFileData(response.URL);
                    }
                    else {
                        bindGetLiveAvgOrderingTime(response.Data.AverageOrderingTimeQuarterHourly, response.Data.AverageOrderingTimeHourly, thisWidgetID);
                    }
                }
            },
            error: function (request, status, error) {
                console.log(request);
                console.log(status);
                console.log(error);
            },
            complete: function () {
                setTimeout(function () {
                    GetLiveAvgOrderingTimeAPICall(timezone, timezoneOffset, thisWidgetID);
                }, 1 * 60 * 1000);
            }
        });
    }
}

function GetLiveAvgPickupTimeAPICall(timezone, timezoneOffset, thisWidgetID) {

    var currentTime = GetMomentOfTimeZone(timezone, timezoneOffset);

    var param = {
        currentTime: currentTime.format(),
        branchId: parseInt($("#selectorSite").val()) != 0 ? parseInt($("#selectorSite").val()) : 0
    };

    if (param.BranchId != 0) {
        var requestURL = "/Report/GetLiveAvgPickupTime";
        var ajaxMethod = "POST";
        $.ajax({
            type: ajaxMethod,
            url: requestURL,
            data: JSON.stringify(param),
            dataType: 'json',
            contentType: 'application/json',
            success: function (response) {
                if (response.statusCode = 200) {
                    if (widgetPullDataParam.IsExportExcelFlag) {
                        page.GetJsonFileData(response.URL);
                    }
                    else {
                        bindGetLiveAvgPickupTime(response.Data.AveragePickupTimeQuarterHourly, response.Data.AveragePickupTimeHourly, thisWidgetID);
                    }
                }
            },
            error: function (request, status, error) {
                console.log(request);
                console.log(status);
                console.log(error);
            },
            complete: function () {
                setTimeout(function () {
                    GetLiveAvgPickupTimeAPICall(timezone, timezoneOffset, thisWidgetID);
                }, 1 * 60 * 1000);
            }
        });
    }
}
//here
function GetMaleWashroomManagementAPICall(thisWidgetID) {

    var param = {
        cameraId: 21468, //21468,
    };

    if (param.BranchId != 0) {
        var requestURL = "/Report/GetWashroomManagement";
        var ajaxMethod = "POST";
        $.ajax({
            type: ajaxMethod,
            url: requestURL,
            data: JSON.stringify(param),
            dataType: 'json',
            contentType: 'application/json',
            success: function (response) {
                if (response.statusCode = 200) {
                    if (widgetPullDataParam.IsExportExcelFlag) {
                        page.GetJsonFileData(response.URL);
                    }
                    else {
                        bindGetMaleWashroomManagement(response.Data.WM03, response.Data.WM01, response.Data.SecondsAfterLastCleanedTime, thisWidgetID);
                    }
                }
            },
            error: function (request, status, error) {
                console.log(request);
                console.log(status);
                console.log(error);
            },
            complete: function () {
                setTimeout(function () {
                    GetMaleWashroomManagementAPICall(thisWidgetID);
                }, 15 * 1000);
            }
        });
    }
}

function GetFemaleWashroomManagementAPICall(thisWidgetID) {

    var param = {
        cameraId: 21469, //21469,
    };

    if (param.BranchId != 0) {
        var requestURL = "/Report/GetWashroomManagement";
        var ajaxMethod = "POST";
        $.ajax({
            type: ajaxMethod,
            url: requestURL,
            data: JSON.stringify(param),
            dataType: 'json',
            contentType: 'application/json',
            success: function (response) {
                if (response.statusCode = 200) {
                    if (widgetPullDataParam.IsExportExcelFlag) {
                        page.GetJsonFileData(response.URL);
                    }
                    else {
                        bindGetFemaleWashroomManagement(response.Data.WM03, response.Data.WM01, response.Data.SecondsAfterLastCleanedTime, thisWidgetID);
                    }
                }
            },
            error: function (request, status, error) {
                console.log(request);
                console.log(status);
                console.log(error);
            },
            complete: function () {
                setTimeout(function () {
                    GetFemaleWashroomManagementAPICall(thisWidgetID);
                }, 15 * 1000);
            }
        });
    }
}




//still working on (Gary)

function GetLiveDustbinUsagePercentageAPICall(thisWidgetID) {

    var param = {
        sensorId: '0000640100000001'
    };

    if (param.BranchId != 0) {

        var requestURL = "/Report/GetLiveDustbinUsagePercentage";
        var ajaxMethod = "POST";

        $.ajax({
            type: ajaxMethod,
            url: requestURL,
            data: JSON.stringify(param),
            dataType: 'json',
            contentType: 'application/json',
            success: function (response) {
                if (response.statusCode = 200) {
                    if (widgetPullDataParam.IsExportExcelFlag) {
                        page.GetJsonFileData(response.URL);
                    }
                    else {
                        bindLiveDustbinUsagePercentage(response.Data.SB02, response.Data.SB03, response.Data.SecondsAfterLastCleanedTime, thisWidgetID);
                    }
                }
            },
            error: function (request, status, error) {
                console.log(request);
                console.log(status);
                console.log(error);
            },
            complete: function () {
                setTimeout(function () {
                    GetLiveDustbinUsagePercentageAPICall(thisWidgetID);
                }, 5 * 60 * 1000);
            }
        });
    }
}

function GetLiveDustbinUsagePercentage2APICall(thisWidgetID) {

    var param = {
        sensorId: '0000640100000002'
    };

    if (param.BranchId != 0) {

        var requestURL = "/Report/GetLiveDustbinUsagePercentage";
        var ajaxMethod = "POST";

        $.ajax({
            type: ajaxMethod,
            url: requestURL,
            data: JSON.stringify(param),
            dataType: 'json',
            contentType: 'application/json',
            success: function (response) {
                if (response.statusCode = 200) {
                    if (widgetPullDataParam.IsExportExcelFlag) {
                        page.GetJsonFileData(response.URL);
                    }
                    else {
                        bindLiveDustbinUsagePercentage2(response.Data.SB02, response.Data.SB03, response.Data.SecondsAfterLastCleanedTime, thisWidgetID);
                    }
                }
            },
            error: function (request, status, error) {
                console.log(request);
                console.log(status);
                console.log(error);
            },
            complete: function () {
                setTimeout(function () {
                    GetLiveDustbinUsagePercentage2APICall(thisWidgetID);
                }, 5 * 60 * 1000);
            }
        });
    }
}


//function checkAndSetSuperComp() {
//    //if (ViewBag.CheckParentCompanyResponse != null && ViewBag.CheckParentCompanyResponse.IsParentCompany) {
//    //    return getCompanyCode($("#selectorCompany").val());
//    //}
//    //else {
//    //    return "";
//    //}

//    return getCompanyCode($("#selectorCompany").val());
//}

function BindGetDriveThroughDashboard(widgetId) {
    var dashboardUIDOM = `<div class="driveThruDashboardContainer">
        <div class="top-wrapper">
            <div class="subGridWrapper">
                <div class="pickupCarGrid">
                    <div class="car-wrapper">
                        <p class="carTime">4:07</p>
                        <img src="../Content/images/img/yellow-car.png" />
                    </div>
                    <div class="car-wrapper">
                        <p class="carTime">3:30</p>
                        <img src="../Content/images/img/green-car.png" />
                    </div>
                </div>
                <div class="cashierCarGrid">
                    <div class="car-wrapper">
                        <p class="carTime">2:30</p>
                        <img src="../Content/images/img/green-car.png" />
                    </div>
                </div>
            </div>
        </div>
        <div class="empty-grid"></div>
        <div class="centerLeft-wrapper">
            <div class="subGridWrapper">
                <div class="pickupTextGrid">PICKUP</div>
                <div class="cashierTextGrid">CASHIER</div>
                <div class="bayGrid">
                    <div class="bay1Area">
                        <div class="car-wrapper">
                            <p class="carTime">5:58</p>
                            <img src="../Content/images/img/yellow-car.png" />
                            <p class="bayLabel">BAY 1</p>
                        </div>
                    </div>
                    <div class="bay2Area">
                        <div class="car-wrapper">
                            <p class="carTime">7:01</p>
                            <img src="../Content/images/img/red-car.png" />
                            <p class="bayLabel">BAY 2</p>
                        </div>
                    </div>
                </div>
                <div class="dashboardGrid">
                    <div class="dashboardRow">
                        <div class="dashboardColumn">
                            <div class="mainColumn">
                                <div class="mainTime">
                                    <h2 class="red-text">00:35</h2>
                                </div>
                                <div class="labelWrapper">
                                    <p class="mainLabel">Order Time</p>
                                    <p class="subLabel">PHYTO CAFE</p>
                                </div>
                            </div>
                            <div class="goalColumn">
                                <p class="subLabel">GOAL</p>
                                <h5 class="subTime">00:20</h5>
                            </div>
                            <div class="hourlyAvgColumn">
                                <p class="subLabel">HOURLY<br />AVG.</p>
                                <h5 class="yellow-text subTime">00:30</h5>
                            </div>
                        </div>
                        <div class="dashboardColumn">
                            <div class="mainColumn">
                                <div class="mainTime">
                                    <h2 class="green-text">00:19</h2>
                                </div>
                                <div class="labelWrapper">
                                    <p class="mainLabel">Payment Time</p>
                                    <p class="subLabel">PHYTO CAFE</p>
                                </div>
                            </div>
                            <div class="goalColumn">
                                <p class="subLabel">GOAL</p>
                                <h5 class="subTime">00:20</h5>
                            </div>
                            <div class="hourlyAvgColumn">
                                <p class="subLabel">HOURLY<br />AVG.</p>
                                <h5 class="yellow-text subTime">00:30</h5>
                            </div>
                        </div>
                        <div class="dashboardColumn">
                            <div class="mainColumn">
                                <div class="mainTime">
                                    <h2 class="red-text">00:35</h2>
                                </div>
                                <div class="labelWrapper">
                                    <p class="mainLabel">Pickup Time</p>
                                    <p class="subLabel">PHYTO CAFE</p>
                                </div>
                            </div>
                            <div class="goalColumn">
                                <p class="subLabel">GOAL</p>
                                <h5 class="subTime">00:20</h5>
                            </div>
                            <div class="hourlyAvgColumn">
                                <p class="subLabel">HOURLY<br />AVG.</p>
                                <h5 class="yellow-text subTime">00:25</h5>
                            </div>
                        </div>
                    </div>
                    <div class="dashboardRow">
                        <div class="dashboardColumn">
                            <div class="mainColumn">
                                <div class="mainTime">
                                    <h2 class="green-text">01:00</h2>
                                </div>
                                <div class="labelWrapper">
                                    <p class="mainLabel">Order Waiting Time</p>
                                    <p class="subLabel">PHYTO CAFE</p>
                                </div>
                            </div>
                            <div class="goalColumn">
                                <p class="subLabel">GOAL</p>
                                <h5 class="subTime">01:30</h5>
                            </div>
                            <div class="hourlyAvgColumn">
                                <p class="subLabel">HOURLY<br />AVG.</p>
                                <h5 class="green-text subTime">01:29</h5>
                            </div>
                        </div>
                        <div class="dashboardColumn">
                            <div class="mainColumn">
                                <div class="mainTime">
                                    <h2 class="green-text">00:43</h2>
                                </div>
                                <div class="labelWrapper">
                                    <p class="mainLabel">Payment Waiting Time</p>
                                    <p class="subLabel">PHYTO CAFE</p>
                                </div>
                            </div>
                            <div class="goalColumn">
                                <p class="subLabel">GOAL</p>
                                <h5 class="subTime">00:45</h5>
                            </div>
                            <div class="hourlyAvgColumn">
                                <p class="subLabel">HOURLY<br />AVG.</p>
                                <h5 class="yellow-text subTime">00:50</h5>
                            </div>
                        </div>
                        <div class="dashboardColumn">
                            <div class="mainColumn">
                                <div class="mainTime">
                                    <h2 class="yellow-text">00:55</h2>
                                </div>
                                <div class="labelWrapper">
                                    <p class="mainLabel">Pickup Waiting Time</p>
                                    <p class="subLabel">PHYTO CAFE</p>
                                </div>
                            </div>
                            <div class="goalColumn">
                                <p class="subLabel">GOAL</p>
                                <h5 class="subTime">00:45</h5>
                            </div>
                            <div class="hourlyAvgColumn">
                                <p class="subLabel">HOURLY<br />AVG.</p>
                                <h5 class="green-text subTime">00:40</h5>
                            </div>
                        </div>
                    </div>
                    <div class="dashboardRow">
                        <div class="dashboardColumn">
                            <div class="mainColumn">
                                <div class="mainTime">
                                    <h2 class="green-text">00:58</h2>
                                </div>
                                <div class="labelWrapper">
                                    <p class="mainLabel">Bay 1 Waiting Time</p>
                                    <p class="subLabel">PHYTO CAFE</p>
                                </div>
                            </div>
                            <div class="goalColumn">
                                <p class="subLabel">GOAL</p>
                                <h5 class="subTime">02:00</h5>
                            </div>
                            <div class="hourlyAvgColumn">
                                <p class="subLabel">HOURLY<br />AVG.</p>
                                <h5 class="green-text subTime">01:00</h5>
                            </div>
                        </div>
                        <div class="dashboardColumn">
                            <div class="mainColumn">
                                <div class="mainTime">
                                    <h2 class="yellow-text">02:01</h2>
                                </div>
                                <div class="labelWrapper">
                                    <p class="mainLabel">Bay 2 Waiting Time</p>
                                    <p class="subLabel">PHYTO CAFE</p>
                                </div>
                            </div>
                            <div class="goalColumn">
                                <p class="subLabel">GOAL</p>
                                <h5 class="subTime">02:00</h5>
                            </div>
                            <div class="hourlyAvgColumn">
                                <p class="subLabel">HOURLY<br />AVG.</p>
                                <h5 class="yellow-text subTime">02:08</h5>
                            </div>
                        </div>
                        <div class="dashboardColumn">
                            <div class="mainColumn">
                                <div class="mainTime">
                                    <h2 class="yellow-text">04:07</h2>
                                </div>
                                <div class="labelWrapper">
                                    <p class="mainLabel">Total Drive Thru Time</p>
                                    <p class="subLabel">PHYTO CAFE</p>
                                </div>
                            </div>
                            <div class="goalColumn">
                                <p class="subLabel">GOAL</p>
                                <h5 class="subTime">04:00</h5>
                            </div>
                            <div class="hourlyAvgColumn">
                                <p class="subLabel">HOURLY<br />AVG.</p>
                                <h5 class="yellow-text subTime">04:24</h5>
                            </div>
                        </div>
                    </div>
                    <div class="satisfactionContainer">
                        <div class="satisfactionRow">
                            <div class="satisfactionColumn">
                                <div class="emojiColumn">
                                    <img src="../Content/images/img/emoji-1.png" />
                                </div>
                                <div class="percentageColumn">
                                    <h2 class="green-text">90<span>%</span></h2>
                                </div>
                            </div>
                            <div class="satisfactionColumn">
                                <div class="emojiColumn">
                                    <img src="../Content/images/img/emoji-2.png" />
                                </div>
                                <div class="percentageColumn">
                                    <h2 class="yellow-text">6<span>%</span></h2>
                                </div>
                            </div>
                            <div class="satisfactionColumn">
                                <div class="emojiColumn">
                                    <img src="../Content/images/img/emoji-3.png" />
                                </div>
                                <div class="percentageColumn">
                                    <h2 class="red-text">4<span>%</span></h2>
                                </div>
                            </div>
                        </div>
                        <div class="serveColumn">
                            <h4>Total Number of Serve(s): 66</h4>
                        </div>
                    </div>
                    <div class="queueColumn">
                        <h4>In-Queue: 2</h4>
                    </div>
                </div>
                <div class="startTextGrid">START</div>
                <div class="orderTextGrid">ORDER</div>
            </div>
        </div>
        <div class="centerRight1-wrapper">
            <div class="car-wrapper">
                <img src="../Content/images/img/green-car-vertical.png" />
                <p class="carTime">1:30</p>
            </div>
        </div>
        <div class="centerRight2-wrapper">
            <div class="car-wrapper">
                <img src="../Content/images/img/green-car-vertical.png" />
                <p class="carTime">1:00</p>
            </div>
        </div>
        <div class="bottom-wrapper">
            <div class="subGridWrapper">
                <div class="startCarGrid">
                    <div class="car-wrapper">
                        <img src="../Content/images/img/green-car-right.png" />
                        <p class="carTime">0:01</p>
                    </div>
                </div>
                <div class="orderCarGrid">
                    <div class="car-wrapper">
                        <img src="../Content/images/img/green-car-right.png" />
                        <p class="carTime">0:10</p>
                    </div>
                </div>
            </div>
        </div>
        <div class="empty-grid"></div>
</div>`;
    $("#DriveThroughDashboard").html(dashboardUIDOM);
}

var isEditorMode = function () {
    return $("#rightPanelContent").is(":visible");
}

var oneGsGridWidth = $(".grid-stack-container").width() / 12;
var tmz = getClientTimeZone();
var panel = {
    InitializeDemoWidgetContainerWidth: function () {
        var demoWidgetContainerList = $(".demo-widget-container");
        $.each(demoWidgetContainerList, function (i, widget) {
            var thisWidgetGSWidth = parseInt($(widget).data("gs-width"));
            $(widget).css({ "width": (thisWidgetGSWidth * oneGsGridWidth) + "px" });
        })
    },

    BindCloseRightPanelButton: function () {
        $(".closeRightPanelButton").unbind("click").click(function () {
            //location.reload();
            HideRightPanel();
            page.getCustomDashboardWidget(false);
        })
    },

    GetCompanyMonthlyFootfallDailyData: function (widgetPullDataParam) {
        //var requestURL = "/FootfallCam/GetCompanyMonthlyFootfallDailyDataAsync?selectedMonth=" + reportStartMonthString + "&IsExportExcelFlag=" + widgetPullDataParam.IsExportExcelFlag + "&tmz=" + tmz; //Original working code
        var requestURL = "/FootfallCam/GetCompanyMonthlyFootfallDailyDataAsync?selectedMonth=" + reportStartMonthString + "&IsExportExcelFlag=" + widgetPullDataParam.IsExportExcelFlag + "&tmz=" + tmz + "&compCodeToPass=" + widgetPullDataParam.compCodeToPass;
        var ajaxMethod = "POST"; //or POST etc
        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "CompanyMonthlyFootfallDailyData" : "#CompanyMonthlyFootfallDailyData";
        $.ajax({
            beforeSend: widgetPullDataParam.IsExportExcelFlag ? "" : widget.Loading(thisWidgetID),
            type: ajaxMethod,
            url: requestURL,
            success: function (response) {
                if (response.IsSuccessful) {
                    if (widgetPullDataParam.IsExportExcelFlag) {
                        page.GetJsonFileData(response.URL);//response.Data[0].JsonStoreUrl);
                    }
                    else {
                        //var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "CompanyMonthlyFootfallDailyData" : "#CompanyMonthlyFootfallDailyData";
                        jQuery.get("../../Scripts/chart-color-scheme.txt", function (colorScheme) {
                            colorScheme = JSON.parse(colorScheme);
                            bindCompanyMonthlyFootfallDailyData(response.Result, colorScheme, thisWidgetID);
                            if (isEditorMode()) {
                                widget.BindWidgetClick(thisWidgetID);
                            }
                        });
                    }
                }
            },
            error: function (request, status, error) {
                console.log(request);
                console.log(status);
                console.log(error);
            }
        });
    },

    GetCompanyNthDayFootfallHourlyData: function (widgetPullDataParam) {

        //var requestURL = "/FootfallCam/GetCompanyNthDayFootfallHourlyData?selectedDate=" + $("#reportEndDate").val() + "&IsExportExcelFlag=" + widgetPullDataParam.IsExportExcelFlag + "&tmz=" + tmz;
        var requestURL = "/FootfallCam/GetCompanyNthDayFootfallHourlyData?selectedDate=" + $("#reportEndDate").val() + "&IsExportExcelFlag=" + widgetPullDataParam.IsExportExcelFlag + "&tmz=" + tmz + "&compCodeToPass=" + widgetPullDataParam.compCodeToPass;
        var ajaxMethod = "POST"; //or POST etc
        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "CompanyNthDayFootfallHourlyData" : "#CompanyNthDayFootfallHourlyData";
        $.ajax({
            beforeSend: widgetPullDataParam.IsExportExcelFlag ? "" : widget.Loading(thisWidgetID),
            type: ajaxMethod,
            url: requestURL,
            success: function (response) {
                if (response.statusCode == 200) {
                    if (widgetPullDataParam.IsExportExcelFlag) {
                        page.GetJsonFileData(response.URL);//response.Data[0].JsonStoreUrl);
                    }
                    else {
                        jQuery.get("../../Scripts/chart-color-scheme.txt", function (colorScheme) {
                            colorScheme = JSON.parse(colorScheme);
                            bindFootfallSummaryHour(response.Data[0], colorScheme, thisWidgetID);
                            if (isEditorMode()) {
                                widget.BindWidgetClick(thisWidgetID);
                            }
                        });
                    }
                }
            },
            error: function (request, status, error) {
                console.log(request);
                console.log(status);
                console.log(error);
            }
        });
    },

    GetCompanyTop5VisitorSite: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "CompanyTop5VisitorSite" : "#CompanyTop5VisitorSite";
        //var requestURL = "/FootfallCam/GetCompanyTop5VisitorSite?selectedDate=" + $("#reportEndDate").val() + "&IsExportExcelFlag=" + widgetPullDataParam.IsExportExcelFlag + "&tmz=" + tmz; //Original working code
        var requestURL = "/FootfallCam/GetCompanyTop5VisitorSite?selectedDate=" + $("#reportEndDate").val() + "&IsExportExcelFlag=" + widgetPullDataParam.IsExportExcelFlag + "&tmz=" + tmz + "&compCodeToPass=" + widgetPullDataParam.compCodeToPass;
        
        var ajaxMethod = "POST"; //or POST etc
        $.ajax({
            type: ajaxMethod,
            url: requestURL,
            beforeSend: widgetPullDataParam.IsExportExcelFlag ? "" : widget.Loading(thisWidgetID),
            success: function (response) {
                
                if (response.statusCode == 200) {
                    if (widgetPullDataParam.IsExportExcelFlag) {
                        page.GetJsonFileData(response.URL);
                    }
                    else {
                        jQuery.get("../../Scripts/chart-color-scheme.txt", function (colorScheme) {
                            colorScheme = JSON.parse(colorScheme);
                            if (response.Data != null) {
                                bindTop5VisitorCount(response.Data[0], colorScheme, thisWidgetID);
                            } else {

                            }
                            if (isEditorMode()) {
                                widget.BindWidgetClick(thisWidgetID);

                                //if no need border
                                $(thisWidgetID).parents(".custom-widget").css({ "border": "0px" });
                            }
                        });
                    }

                }
            },
            error: function (request, status, error) {
                console.log(request);
                console.log(status);
                console.log(error);
            }
        });
    },

    GetCustomMetrics: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "CustomMetricsWidget" : "#CustomMetricsWidget";
        if (widgetPullDataParam.IsDemo) {
            widget.BindWidgetClick(thisWidgetID);
        }
    },

    GetBranchDailyVisitorIn: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "BranchDailyVisitorIn" : "#BranchDailyVisitorIn";
        if (widgetPullDataParam.IsDemo) {
            bindBranchDailyVisitorIn([1, 4, 3, 4, 6, 7, 4, 6, 2, 1], thisWidgetID);
            widget.BindWidgetClick(thisWidgetID);
        } else {
            var isSpecificWidgetApply = parseInt($(".widget-specific-controller-section").attr("is-hidden")) == 0 ? true : false;
            if (
                !widgetPullDataParam.IsDemo &&
                widgetPullDataParam.IsTriggerFromPage &&
                widget.HasSpecificController(thisWidgetID) &&
                !isSpecificWidgetApply
            ) {
                //console.log("has controller, no need update when apply in page");
            }
            else {
                var param = {
                    RangeStartDate: !isSpecificWidgetApply ? $("#reportStartDate").val() : $("#right-sidebar .getBranchDailyVisitorSpecificStartDate").val(),
                    RangeEndDate: !isSpecificWidgetApply ? $("#reportEndDate").val() : $("#right-sidebar .getBranchDailyVisitorSpecificEndDate").val(),
                    BranchId: parseInt($("#selectorSite").val()) != 0 ? parseInt($("#selectorSite").val()) : 0
                };

                if (param.BranchId != 0) {
                    var requestURL = "/FootfallCam/GetBranchDailyVisitorIn?IsExportExcelFlag=" + widgetPullDataParam.IsExportExcelFlag + "&tmz=" + tmz;
                    var ajaxMethod = "POST"; //or POST etc
                    $.ajax({
                        type: ajaxMethod,
                        url: requestURL,
                        beforeSend: widgetPullDataParam.IsExportExcelFlag ? "" : widget.Loading(thisWidgetID),
                        data: JSON.stringify(param),
                        dataType: 'json',
                        contentType: 'application/json',
                        success: function (response) {
                            if (response.statusCode == 200) {
                                if (widgetPullDataParam.IsExportExcelFlag) {
                                    page.GetJsonFileData(response.URL);//response.Data[0].JsonStoreUrl);
                                }
                                else {
                                    jQuery.get("../../Scripts/chart-color-scheme.txt", function (colorScheme) {
                                        colorScheme = JSON.parse(colorScheme);
                                        //bindTop5VisitorCount(response.Data[0], colorScheme, thisWidgetID);
                                        bindBranchDailyVisitorIn(response.Data, thisWidgetID);
                                        if (isEditorMode()) {
                                        }
                                    });
                                }
                            }
                        },
                        error: function (request, status, error) {
                            console.log(request);
                            console.log(status);
                            console.log(error);
                        }
                    });
                }
            }
        }
    },

    GetBranchDailyVisitorIn_v2: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "BranchDailyVisitorIn_v2" : "#BranchDailyVisitorIn_v2";
        if (widgetPullDataParam.IsDemo) {
            bindBranchDailyVisitorIn_v2(139, thisWidgetID);
            widget.BindWidgetClick(thisWidgetID);
        } else {
            var isSpecificWidgetApply = parseInt($(".widget-specific-controller-section").attr("is-hidden")) == 0 ? true : false;
            //SAME DATES
            var param = {
                //selectedDate: !isSpecificWidgetApply ? $("#reportStartDate").val() : $("#right-sidebar .getBranchDailyVisitorSpecificStartDate").val(),
                //dateFormat: 'dd/MM/yyyy',
                BranchId: parseInt($("#selectorSite").val()) != 0 ? parseInt($("#selectorSite").val()) : 0
            };

            if (param.BranchId != 0) {
                var requestURL = "/FootfallCam/GetBranchLatestDayVisitorCount?IsExportExcelFlag=" + widgetPullDataParam.IsExportExcelFlag + "&tmz=" + tmz;
                var ajaxMethod = "POST"; //or POST etc
                $.ajax({
                    type: ajaxMethod,
                    url: requestURL,
                    beforeSend: widgetPullDataParam.IsExportExcelFlag ? "" : widget.Loading(thisWidgetID),
                    data: JSON.stringify(param),
                    dataType: 'json',
                    contentType: 'application/json',
                    success: function (response) {

                        if (response.IsSuccessful) {
                            if (widgetPullDataParam.IsExportExcelFlag) {
                                page.GetJsonFileData(response.URL);//response.Data[0].JsonStoreUrl);
                            }
                            else {
                                jQuery.get("../../Scripts/chart-color-scheme.txt", function (colorScheme) {
                                    colorScheme = JSON.parse(colorScheme);
                                    //bindTop5VisitorCount(response.Data[0], colorScheme, thisWidgetID);
                                    bindBranchDailyVisitorIn_v2(response.Result, thisWidgetID);
                                    if (isEditorMode()) {
                                    }
                                });
                            }
                        }
                    },
                    error: function (request, status, error) {
                        console.log(request);
                        console.log(status);
                        console.log(error);
                    }
                });
            }
        }
    },

    GetBranchDailyVisitDuration: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "BranchDailyVisitDuration" : "#BranchDailyVisitDuration";
        if (widgetPullDataParam.IsDemo) {
            bindBranchDailyVisitDuration(43, thisWidgetID);
            widget.BindWidgetClick(thisWidgetID);
        } else {
            var isSpecificWidgetApply = parseInt($(".widget-specific-controller-section").attr("is-hidden")) == 0 ? true : false;
            var param = {
                //selectedDate: !isSpecificWidgetApply ? $("#reportStartDate").val() : $("#right-sidebar .getBranchDailyVisitorSpecificStartDate").val(),
                //dateFormat: 'dd/MM/yyyy',
                branchId: parseInt($("#selectorSite").val()) != 0 ? parseInt($("#selectorSite").val()) : 0
            };

            if (param.BranchId != 0) {
                var requestURL = "/FootfallCam/GetBranchLatestVisitDuration?IsExportExcelFlag=" + widgetPullDataParam.IsExportExcelFlag + "&tmz=" + tmz;
                var ajaxMethod = "POST"; //or POST etc
                $.ajax({
                    type: ajaxMethod,
                    url: requestURL,
                    beforeSend: widgetPullDataParam.IsExportExcelFlag ? "" : widget.Loading(thisWidgetID),
                    data: JSON.stringify(param),
                    dataType: 'json',
                    contentType: 'application/json',
                    success: function (response) {
                        if (response.IsSuccessful) {
                            if (widgetPullDataParam.IsExportExcelFlag) {
                                page.GetJsonFileData(response.URL);//response.Data[0].JsonStoreUrl);
                            }
                            else {
                                jQuery.get("../../Scripts/chart-color-scheme.txt", function (colorScheme) {
                                    colorScheme = JSON.parse(colorScheme);
                                    //bindTop5VisitorCount(response.Data[0], colorScheme, thisWidgetID);
                                    bindBranchDailyVisitDuration(response.Result, thisWidgetID);
                                    if (isEditorMode()) {
                                    }
                                });
                            }
                        }
                    },
                    error: function (request, status, error) {
                        console.log(request);
                        console.log(status);
                        console.log(error);
                    }
                });
            }
        }
    },

    GetBranchHourlyVisitorOrderCount: function (widgetPullDataParam) {

        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "BranchHourlyVisitorOrderCount" : "#BranchHourlyVisitorOrderCount";
        if (widgetPullDataParam.IsDemo) {
            bindBranchHourlyVisitorOrderCount([], thisWidgetID, true);
            widget.BindWidgetClick(thisWidgetID);
        } else {
            var isSpecificWidgetApply = parseInt($(".widget-specific-controller-section").attr("is-hidden")) == 0 ? true : false;
            var param = {
                //selectedDate: !isSpecificWidgetApply ? $("#reportStartDate").val() : $("#right-sidebar .getBranchDailyVisitorSpecificStartDate").val(),
                //dateFormat: 'dd/MM/yyyy',
                branchId: parseInt($("#selectorSite").val()) != 0 ? parseInt($("#selectorSite").val()) : 0
            };

            if (param.BranchId != 0) {
                var requestURL = "/FootfallCam/GetBranchLatestHourlyVisitorVsOrderCount?IsExportExcelFlag=" + widgetPullDataParam.IsExportExcelFlag + "&tmz=" + tmz;
                var ajaxMethod = "POST"; //or POST etc
                $.ajax({
                    type: ajaxMethod,
                    url: requestURL,
                    beforeSend: widgetPullDataParam.IsExportExcelFlag ? "" : widget.Loading(thisWidgetID),
                    data: JSON.stringify(param),
                    dataType: 'json',
                    contentType: 'application/json',
                    success: function (response) {
                        if (response.IsSuccessful) {
                            if (widgetPullDataParam.IsExportExcelFlag) {
                                page.GetJsonFileData(response.URL);//response.Data[0].JsonStoreUrl);
                            }
                            else {
                                jQuery.get("../../Scripts/chart-color-scheme.txt", function (colorScheme) {
                                    colorScheme = JSON.parse(colorScheme);
                                    //bindTop5VisitorCount(response.Data[0], colorScheme, thisWidgetID);
                                    bindBranchHourlyVisitorOrderCount(response.Result, thisWidgetID, false);
                                    if (isEditorMode()) {
                                    }
                                });
                            }
                        }
                    },
                    error: function (request, status, error) {
                        console.log(request);
                        console.log(status);
                        console.log(error);
                    }
                });
            }
        }
    },

    GetBranchDailyAverageQueueTime: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "BranchDailyAverageQueueTime" : "#BranchDailyAverageQueueTime";
        if (widgetPullDataParam.IsDemo) {
            bindBranchDailyAverageQueueTime(5, thisWidgetID);
            widget.BindWidgetClick(thisWidgetID);
        } else {
            var isSpecificWidgetApply = parseInt($(".widget-specific-controller-section").attr("is-hidden")) == 0 ? true : false;
            var param = {
                selectedDate: !isSpecificWidgetApply ? $("#reportStartDate").val() : $("#right-sidebar .getBranchDailyVisitorSpecificStartDate").val(),
                dateFormat: 'dd/MM/yyyy',
                branchId: parseInt($("#selectorSite").val()) != 0 ? parseInt($("#selectorSite").val()) : 0
            };

            if (param.BranchId != 0) {
                var requestURL = "/FootfallCam/GetBranchLatestHourQueueTime?IsExportExcelFlag=" + widgetPullDataParam.IsExportExcelFlag + "&tmz=" + tmz;
                var ajaxMethod = "POST"; //or POST etc
                $.ajax({
                    type: ajaxMethod,
                    url: requestURL,
                    beforeSend: widgetPullDataParam.IsExportExcelFlag ? "" : widget.Loading(thisWidgetID),
                    data: JSON.stringify(param),
                    dataType: 'json',
                    contentType: 'application/json',
                    success: function (response) {
                        if (response.IsSuccessful) {
                            if (widgetPullDataParam.IsExportExcelFlag) {
                                page.GetJsonFileData(response.URL);//response.Data[0].JsonStoreUrl);
                            }
                            else {
                                jQuery.get("../../Scripts/chart-color-scheme.txt", function (colorScheme) {
                                    colorScheme = JSON.parse(colorScheme);
                                    //bindTop5VisitorCount(response.Data[0], colorScheme, thisWidgetID);
                                    bindBranchDailyAverageQueueTime(response.Result, thisWidgetID);
                                    if (isEditorMode()) {
                                    }
                                });
                            }
                        }
                    },
                    error: function (request, status, error) {
                        console.log(request);
                        console.log(status);
                        console.log(error);
                    }
                });
            }
        }
    },

    GetBranchDailyAverageOrderTime: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "BranchDailyAverageOrderTime" : "#BranchDailyAverageOrderTime";
        if (widgetPullDataParam.IsDemo) {
            bindBranchDailyAverageOrderTime(4, thisWidgetID);
            widget.BindWidgetClick(thisWidgetID);
        } else {
            var isSpecificWidgetApply = parseInt($(".widget-specific-controller-section").attr("is-hidden")) == 0 ? true : false;
            var param = {
                //selectedDate: !isSpecificWidgetApply ? $("#reportStartDate").val() : $("#right-sidebar .getBranchDailyVisitorSpecificStartDate").val(),
                //dateFormat: 'dd/MM/yyyy',
                branchId: parseInt($("#selectorSite").val()) != 0 ? parseInt($("#selectorSite").val()) : 0
            };

            if (param.BranchId != 0) {
                var requestURL = "/FootfallCam/GetBranchLatestHourOrderTime?IsExportExcelFlag=" + widgetPullDataParam.IsExportExcelFlag + "&tmz=" + tmz;
                var ajaxMethod = "POST"; //or POST etc
                $.ajax({
                    type: ajaxMethod,
                    url: requestURL,
                    beforeSend: widgetPullDataParam.IsExportExcelFlag ? "" : widget.Loading(thisWidgetID),
                    data: JSON.stringify(param),
                    dataType: 'json',
                    contentType: 'application/json',
                    success: function (response) {
                        if (response.IsSuccessful) {
                            if (widgetPullDataParam.IsExportExcelFlag) {
                                page.GetJsonFileData(response.URL);//response.Data[0].JsonStoreUrl);
                            }
                            else {
                                jQuery.get("../../Scripts/chart-color-scheme.txt", function (colorScheme) {
                                    colorScheme = JSON.parse(colorScheme);
                                    //bindTop5VisitorCount(response.Data[0], colorScheme, thisWidgetID);
                                    bindBranchDailyAverageOrderTime(response.Result, thisWidgetID);
                                    if (isEditorMode()) {
                                    }
                                });
                            }
                        }
                    },
                    error: function (request, status, error) {
                        console.log(request);
                        console.log(status);
                        console.log(error);
                    }
                });
            }
        }
    },

    GetBranchQueueCustomerJourneyTime: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "BranchQueueCustomerJourneyTime" : "#BranchQueueCustomerJourneyTime";
        if (widgetPullDataParam.IsDemo) {
            bindBranchQueueCustomerJourneyTime(9, thisWidgetID);
            widget.BindWidgetClick(thisWidgetID);
        } else {
            var isSpecificWidgetApply = parseInt($(".widget-specific-controller-section").attr("is-hidden")) == 0 ? true : false;
            var param = {
                //selectedDate: !isSpecificWidgetApply ? $("#reportStartDate").val() : $("#right-sidebar .getBranchDailyVisitorSpecificStartDate").val(),
                //dateFormat: 'dd/MM/yyyy',
                branchId: parseInt($("#selectorSite").val()) != 0 ? parseInt($("#selectorSite").val()) : 0
            };

            if (param.BranchId != 0) {
                var requestURL = "/FootfallCam/GetBranchLatestHourJourneyTime?IsExportExcelFlag=" + widgetPullDataParam.IsExportExcelFlag + "&tmz=" + tmz;
                var ajaxMethod = "POST"; //or POST etc
                $.ajax({
                    type: ajaxMethod,
                    url: requestURL,
                    beforeSend: widgetPullDataParam.IsExportExcelFlag ? "" : widget.Loading(thisWidgetID),
                    data: JSON.stringify(param),
                    dataType: 'json',
                    contentType: 'application/json',
                    success: function (response) {
                        if (response.IsSuccessful) {
                            if (widgetPullDataParam.IsExportExcelFlag) {
                                page.GetJsonFileData(response.URL);//response.Data[0].JsonStoreUrl);
                            }
                            else {
                                jQuery.get("../../Scripts/chart-color-scheme.txt", function (colorScheme) {
                                    colorScheme = JSON.parse(colorScheme);
                                    //bindTop5VisitorCount(response.Data[0], colorScheme, thisWidgetID);
                                    bindBranchQueueCustomerJourneyTime(response.Result, thisWidgetID);
                                    if (isEditorMode()) {
                                    }
                                });
                            }
                        }
                    },
                    error: function (request, status, error) {
                        console.log(request);
                        console.log(status);
                        console.log(error);
                    }
                });
            }
        }
    },

    GetBranchDailyAveragePickupTime: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "BranchDailyAveragePickupTime" : "#BranchDailyAveragePickupTime";
        if (widgetPullDataParam.IsDemo) {
            bindBranchDailyAveragePickupTime(4, thisWidgetID);
            widget.BindWidgetClick(thisWidgetID);
        } else {
            var isSpecificWidgetApply = parseInt($(".widget-specific-controller-section").attr("is-hidden")) == 0 ? true : false;
            var param = {
                //selectedDate: !isSpecificWidgetApply ? $("#reportStartDate").val() : $("#right-sidebar .getBranchDailyVisitorSpecificStartDate").val(),
                //dateFormat: 'dd/MM/yyyy',
                branchId: parseInt($("#selectorSite").val()) != 0 ? parseInt($("#selectorSite").val()) : 0
            };

            if (param.BranchId != 0) {
                var requestURL = "/FootfallCam/GetBranchLatestHourPickupTime?IsExportExcelFlag=" + widgetPullDataParam.IsExportExcelFlag + "&tmz=" + tmz;
                var ajaxMethod = "POST"; //or POST etc
                $.ajax({
                    type: ajaxMethod,
                    url: requestURL,
                    beforeSend: widgetPullDataParam.IsExportExcelFlag ? "" : widget.Loading(thisWidgetID),
                    data: JSON.stringify(param),
                    dataType: 'json',
                    contentType: 'application/json',
                    success: function (response) {
                        if (response.IsSuccessful) {
                            if (widgetPullDataParam.IsExportExcelFlag) {
                                page.GetJsonFileData(response.URL);//response.Data[0].JsonStoreUrl);
                            }
                            else {
                                jQuery.get("../../Scripts/chart-color-scheme.txt", function (colorScheme) {
                                    colorScheme = JSON.parse(colorScheme);
                                    //bindTop5VisitorCount(response.Data[0], colorScheme, thisWidgetID);
                                    bindBranchDailyAveragePickupTime(response.Result, thisWidgetID);
                                    if (isEditorMode()) {
                                    }
                                });
                            }
                        }
                    },
                    error: function (request, status, error) {
                        console.log(request);
                        console.log(status);
                        console.log(error);
                    }
                });
            }
        }
    },

    GetBranchQueueOrderingPickupTimeGraph: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "BranchQueueOrderingPickupTimeGraph" : "#BranchQueueOrderingPickupTimeGraph";
        if (widgetPullDataParam.IsDemo) {
            bindBranchQueueOrderingPickupTimeGraph([], thisWidgetID, true);
            widget.BindWidgetClick(thisWidgetID);
        } else {
            var isSpecificWidgetApply = parseInt($(".widget-specific-controller-section").attr("is-hidden")) == 0 ? true : false;
            var param = {
                selectedDate: !isSpecificWidgetApply ? $("#reportStartDate").val() : $("#right-sidebar .getBranchDailyVisitorSpecificStartDate").val(),
                dateFormat: 'dd/MM/yyyy',
                branchId: parseInt($("#selectorSite").val()) != 0 ? parseInt($("#selectorSite").val()) : 0
            };

            if (param.BranchId != 0) {
                var requestURL = "/FootfallCam/GetBranchLatestQueueOrderingPickupTimeGraph?IsExportExcelFlag=" + widgetPullDataParam.IsExportExcelFlag + "&tmz=" + tmz;
                var ajaxMethod = "POST"; //or POST etc
                $.ajax({
                    type: ajaxMethod,
                    url: requestURL,
                    beforeSend: widgetPullDataParam.IsExportExcelFlag ? "" : widget.Loading(thisWidgetID),
                    data: JSON.stringify(param),
                    dataType: 'json',
                    contentType: 'application/json',
                    success: function (response) {
                        if (response.IsSuccessful) {
                            if (widgetPullDataParam.IsExportExcelFlag) {
                                page.GetJsonFileData(response.URL);//response.Data[0].JsonStoreUrl);
                            }
                            else {
                                jQuery.get("../../Scripts/chart-color-scheme.txt", function (colorScheme) {
                                    colorScheme = JSON.parse(colorScheme);
                                    //bindTop5VisitorCount(response.Data[0], colorScheme, thisWidgetID);
                                    bindBranchQueueOrderingPickupTimeGraph(response.Result, thisWidgetID, false);
                                    if (isEditorMode()) {
                                    }
                                });
                            }
                        }
                    },
                    error: function (request, status, error) {
                        console.log(request);
                        console.log(status);
                        console.log(error);
                    }
                });
            }
        }
    },

    GetBranchLatestHourQueueLength: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "BranchLatestHourQueueLength" : "#BranchLatestHourQueueLength";
        if (widgetPullDataParam.IsDemo) {
            bindBranchLatestHourQueueLength(7, thisWidgetID);
            widget.BindWidgetClick(thisWidgetID);
        } else {
            var isSpecificWidgetApply = parseInt($(".widget-specific-controller-section").attr("is-hidden")) == 0 ? true : false;
            var param = {
                //selectedDate: !isSpecificWidgetApply ? $("#reportStartDate").val() : $("#right-sidebar .getBranchDailyVisitorSpecificStartDate").val(),
                //dateFormat: 'dd/MM/yyyy',
                branchId: parseInt($("#selectorSite").val()) != 0 ? parseInt($("#selectorSite").val()) : 0
            };

            if (param.BranchId != 0) {
                var requestURL = "/FootfallCam/GetBranchLatestHourQueueLength?IsExportExcelFlag=" + widgetPullDataParam.IsExportExcelFlag + "&tmz=" + tmz;
                var ajaxMethod = "POST"; //or POST etc
                $.ajax({
                    type: ajaxMethod,
                    url: requestURL,
                    beforeSend: widgetPullDataParam.IsExportExcelFlag ? "" : widget.Loading(thisWidgetID),
                    data: JSON.stringify(param),
                    dataType: 'json',
                    contentType: 'application/json',
                    success: function (response) {
                        if (response.IsSuccessful) {
                            if (widgetPullDataParam.IsExportExcelFlag) {
                                page.GetJsonFileData(response.URL);//response.Data[0].JsonStoreUrl);
                            }
                            else {
                                jQuery.get("../../Scripts/chart-color-scheme.txt", function (colorScheme) {
                                    colorScheme = JSON.parse(colorScheme);
                                    //bindTop5VisitorCount(response.Data[0], colorScheme, thisWidgetID);
                                    bindBranchLatestHourQueueLength(response.Result, thisWidgetID);
                                    if (isEditorMode()) {
                                    }
                                });
                            }
                        }
                    },
                    error: function (request, status, error) {
                        console.log(request);
                        console.log(status);
                        console.log(error);
                    }
                });
            }
        }
    },

    //To-be implemented for KFC DASHBOARD (KELVIN)
    GetBranchMaleToiletCount: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "BranchMaleToiletCount" : "#BranchMaleToiletCount";
        if (widgetPullDataParam.IsDemo) {
            bindBranchMaleToiletCount(0, thisWidgetID);
            widget.BindWidgetClick(thisWidgetID);
        } else {
            //var isSpecificWidgetApply = parseInt($(".widget-specific-controller-section").attr("is-hidden")) == 0 ? true : false;
            //var param = {
            //    //selectedDate: !isSpecificWidgetApply ? $("#reportStartDate").val() : $("#right-sidebar .getBranchDailyVisitorSpecificStartDate").val(),
            //    //dateFormat: 'dd/MM/yyyy',
            //    branchId: parseInt($("#selectorSite").val()) != 0 ? parseInt($("#selectorSite").val()) : 0
            //};

            //if (param.BranchId != 0) {
            //    var requestURL = "/FootfallCam/GetBranchLatestHourQueueLength?IsExportExcelFlag=" + widgetPullDataParam.IsExportExcelFlag + "&tmz=" + tmz;
            //    var ajaxMethod = "POST"; //or POST etc
            //    $.ajax({
            //        type: ajaxMethod,
            //        url: requestURL,
            //        beforeSend: widgetPullDataParam.IsExportExcelFlag ? "" : widget.Loading(thisWidgetID),
            //        data: JSON.stringify(param),
            //        dataType: 'json',
            //        contentType: 'application/json',
            //        success: function (response) {
            //            if (response.IsSuccessful) {
            //                if (widgetPullDataParam.IsExportExcelFlag) {
            //                    page.GetJsonFileData(response.URL);//response.Data[0].JsonStoreUrl);
            //                }
            //                else {
            //                    jQuery.get("../../Scripts/chart-color-scheme.txt", function (colorScheme) {
            //                        colorScheme = JSON.parse(colorScheme);
            //                        //bindTop5VisitorCount(response.Data[0], colorScheme, thisWidgetID);
            //                        bindBranchMaleToiletCount(response.Result, thisWidgetID);
            //                        if (isEditorMode()) {
            //                        }
            //                    });
            //                }
            //            }
            //        },
            //        error: function (request, status, error) {
            //            console.log(request);
            //            console.log(status);
            //            console.log(error);
            //        }
            //    });
            //}
            bindBranchMaleToiletCount(0, thisWidgetID);
        }
    },

    //To-be implemented for KFC DASHBOARD (KELVIN)
    GetBranchFemaleToiletCount: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "BranchFemaleToiletCount" : "#BranchFemaleToiletCount";
        if (widgetPullDataParam.IsDemo) {
            bindBranchFemaleToiletCount(0, thisWidgetID);
            widget.BindWidgetClick(thisWidgetID);
        } else {
            //var isSpecificWidgetApply = parseInt($(".widget-specific-controller-section").attr("is-hidden")) == 0 ? true : false;
            //var param = {
            //    //selectedDate: !isSpecificWidgetApply ? $("#reportStartDate").val() : $("#right-sidebar .getBranchDailyVisitorSpecificStartDate").val(),
            //    //dateFormat: 'dd/MM/yyyy',
            //    branchId: parseInt($("#selectorSite").val()) != 0 ? parseInt($("#selectorSite").val()) : 0
            //};

            //if (param.BranchId != 0) {
            //    var requestURL = "/FootfallCam/GetBranchLatestHourQueueLength?IsExportExcelFlag=" + widgetPullDataParam.IsExportExcelFlag + "&tmz=" + tmz;
            //    var ajaxMethod = "POST"; //or POST etc
            //    $.ajax({
            //        type: ajaxMethod,
            //        url: requestURL,
            //        beforeSend: widgetPullDataParam.IsExportExcelFlag ? "" : widget.Loading(thisWidgetID),
            //        data: JSON.stringify(param),
            //        dataType: 'json',
            //        contentType: 'application/json',
            //        success: function (response) {
            //            if (response.IsSuccessful) {
            //                if (widgetPullDataParam.IsExportExcelFlag) {
            //                    page.GetJsonFileData(response.URL);//response.Data[0].JsonStoreUrl);
            //                }
            //                else {
            //                    jQuery.get("../../Scripts/chart-color-scheme.txt", function (colorScheme) {
            //                        colorScheme = JSON.parse(colorScheme);
            //                        //bindTop5VisitorCount(response.Data[0], colorScheme, thisWidgetID);
            //                        bindBranchMaleToiletCount(response.Result, thisWidgetID);
            //                        if (isEditorMode()) {
            //                        }
            //                    });
            //                }
            //            }
            //        },
            //        error: function (request, status, error) {
            //            console.log(request);
            //            console.log(status);
            //            console.log(error);
            //        }
            //    });
            //}
            bindBranchFemaleToiletCount(0, thisWidgetID);
        }
    },

    GetDriveThroughDashboard: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "DriveThroughDashboard" : "#DriveThroughDashboard";

        if (widgetPullDataParam.IsDemo) {
            //bindGetLiveAvgQueueTime(8, 18, thisWidgetID);
            //widget.BindWidgetClick(thisWidgetID);
        } else {
            $(thisWidgetID).parent().find(".widget-name").remove();
            BindGetDriveThroughDashboard(thisWidgetID);
        }
    },

    GetLiveAvgQueueTime: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "LiveAvgQueueTime" : "#LiveAvgQueueTime";

        if (widgetPullDataParam.IsDemo) {
            bindGetLiveAvgQueueTime(8, 18, thisWidgetID);
            widget.BindWidgetClick(thisWidgetID);
        } else {
            var timezoneOffset = $('#selectorSite option:selected').data('offset');
            var timezone = $('#selectorSite option:selected').data('timezone');

            $(thisWidgetID).parent().find(".widget-name").remove();

            GetLiveAvgQueueTimeAPICall(timezone, timezoneOffset, thisWidgetID);
        }
    },

    GetLiveAvgOrderingTime: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "LiveAvgOrderingTime" : "#LiveAvgOrderingTime";

        if (widgetPullDataParam.IsDemo) {
            bindGetLiveAvgOrderingTime(8, 18, thisWidgetID);
            widget.BindWidgetClick(thisWidgetID);
        } else {
            var timezoneOffset = $('#selectorSite option:selected').data('offset');
            var timezone = $('#selectorSite option:selected').data('timezone');

            $(thisWidgetID).parent().find(".widget-name").remove();

            GetLiveAvgOrderingTimeAPICall(timezone, timezoneOffset, thisWidgetID);
        }
    },

    GetLiveAvgPickupTime: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "LiveAvgPickupTime" : "#LiveAvgPickupTime";

        if (widgetPullDataParam.IsDemo) {
            bindGetLiveAvgPickupTime(8, 18, thisWidgetID);
            widget.BindWidgetClick(thisWidgetID);
        } else {
            var timezoneOffset = $('#selectorSite option:selected').data('offset');
            var timezone = $('#selectorSite option:selected').data('timezone');

            $(thisWidgetID).parent().find(".widget-name").remove();

            GetLiveAvgPickupTimeAPICall(timezone, timezoneOffset, thisWidgetID);
        }
    },

    GetMaleWashroomManagement: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "MaleWashroomManagement" : "#MaleWashroomManagement";

        if (widgetPullDataParam.IsDemo) {
            bindGetMaleWashroomManagement(11, 1576237800, 3660, thisWidgetID);
            widget.BindWidgetClick(thisWidgetID);
        } else {
            $(thisWidgetID).parent().find(".widget-name").remove();

            GetMaleWashroomManagementAPICall(thisWidgetID);
        }
    },

    GetFemaleWashroomManagement: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "FemaleWashroomManagement" : "#FemaleWashroomManagement";

        if (widgetPullDataParam.IsDemo) {
            bindGetFemaleWashroomManagement(30, 1576196100, 1200, thisWidgetID);
            widget.BindWidgetClick(thisWidgetID);
        } else {
            $(thisWidgetID).parent().find(".widget-name").remove();

            GetFemaleWashroomManagementAPICall(thisWidgetID);
        }
    },

    GetLiveDustbinUsagePercentage: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "LiveDustbinUsagePercentage" : "#LiveDustbinUsagePercentage";

        if (widgetPullDataParam.IsDemo) {
            bindLiveDustbinUsagePercentage(25, 1576231200, 4000, thisWidgetID);
            widget.BindWidgetClick(thisWidgetID);
        } else {
            $(thisWidgetID).parent().find(".widget-name").remove();

            GetLiveDustbinUsagePercentageAPICall(thisWidgetID);
        }
    },

    GetLiveDustbinUsagePercentage2: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "LiveDustbinUsagePercentage2" : "#LiveDustbinUsagePercentage2";

        if (widgetPullDataParam.IsDemo) {
            bindLiveDustbinUsagePercentage2(82, 1576236600, 1220, thisWidgetID);
            widget.BindWidgetClick(thisWidgetID);
        } else {
            $(thisWidgetID).parent().find(".widget-name").remove();

            GetLiveDustbinUsagePercentage2APICall(thisWidgetID);
        }
    },

    //What Gary Try To Build
    GetWhatGaryTryToBuild: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "WhatGaryTryToBuild" : "#WhatGaryTryToBuild";
        if (widgetPullDataParam.IsDemo) {
            bindWhatGaryTryToBuild(0, thisWidgetID);
            widget.BindWidgetClick(thisWidgetID);
        } else {
            bindWhatGaryTryToBuild(0, thisWidgetID);
        }
    },

    //What Gary Try To Build2
    GetWhatGaryTryToBuild2: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "WhatGaryTryToBuild2" : "#WhatGaryTryToBuild2";
        bindWhatGaryTryToBuild2(thisWidgetID);
        widget.BindWidgetClick(thisWidgetID);
        $(thisWidgetID).parents(".custom-widget").css({ "border": "0px" });
        

    },

    GetWhatGaryTryToBuild3: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "WhatGaryTryToBuild3" : "#WhatGaryTryToBuild3";

        if (widgetPullDataParam.IsDemo) {
            bindWhatGaryTryToBuild3(188, 68, thisWidgetID);
            widget.BindWidgetClick(thisWidgetID);
        } else {
            bindWhatGaryTryToBuild3(188, 68, thisWidgetID);
        }

            //GetLiveAvgQueueTimeAPICall(timezone, timezoneOffset, thisWidgetID);
        
    },

    GetWhatGaryTryToBuild4: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "Demo_" + "WhatGaryTryToBuild4" : "#WhatGaryTryToBuild4";

        if (widgetPullDataParam.IsDemo) {
            bindWhatGaryTryToBuild4(thisWidgetID);
            widget.BindWidgetClick(thisWidgetID);
        } else { // if without ELSE widget wont appear at main dashboard if it is demo
            bindWhatGaryTryToBuild4(thisWidgetID);
        }


    },
    GetWhatGaryTryToBuild5: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "Demo_" + "WhatGaryTryToBuild5" : "WhatGaryTryToBuild5";

        if (widgetPullDataParam.IsDemo) {
            bindWhatGaryTryToBuild5(thisWidgetID);
            widget.BindWidgetClick(thisWidgetID);
        } else {
            bindWhatGaryTryToBuild5(thisWidgetID);
        }


    },

    GetWhatGaryTryToBuild6: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "Demo_" + "WhatGaryTryToBuild6" : "WhatGaryTryToBuild6";

        if (widgetPullDataParam.IsDemo) {
            //bindWhatGaryTryToBuild6(thisWidgetID);
            bindCompanyCurrentWeekVisitorCount('demo', thisWidgetID);
            widget.BindWidgetClick(thisWidgetID);
        } else {
            bindCompanyCurrentWeekVisitorCount('demo', thisWidgetID);
        }


    },


    //build by gary
    GetCompanyCurrentWeekVisitorCount: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "CompanyCurrentWeekVisitorCount" : "#CompanyCurrentWeekVisitorCount";
        var requestURL = "/FootfallCam/GetCompanyAllVisitorSite?selectedDate=" + $("#reportEndDate").val() + "&IsExportExcelFlag=" + widgetPullDataParam.IsExportExcelFlag + "&tmz=" + tmz + "&compCodeToPass=" + widgetPullDataParam.compCodeToPass;
        
        var ajaxMethod = "POST"; 
        $.ajax({
            type: ajaxMethod,
            url: requestURL,
            beforeSend: widgetPullDataParam.IsExportExcelFlag ? "" : widget.Loading(thisWidgetID),
            success: function (response) {

                if (response.statusCode == 200) { //200 equal good 
                    if (widgetPullDataParam.IsExportExcelFlag) {
                        page.GetJsonFileData(response.URL);
                    }
                    else {

                        if (response.Data != null) {

                            bindCompanyCurrentWeekVisitorCount(response.Data[0], thisWidgetID);
                            widget.BindWidgetClick(thisWidgetID);
                        } else {
                            bindCompanyCurrentWeekVisitorCount(thisWidgetID);

                        }


                    }

                }
            },
            error: function (request, status, error) {
                console.log(request);
                console.log(status);
                console.log(error);
            }
        });

    },

    //build by gary
    GetCompanyCurrentAndLastWeekVisitorCountComparison: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "CompanyCurrentAndLastWeekVisitorCountComparison" : "#CompanyCurrentAndLastWeekVisitorCountComparison";
        var requestURL = "/FootfallCam/GetCompanyAllVisitorSite?selectedDate=" + $("#reportEndDate").val() + "&IsExportExcelFlag=" + widgetPullDataParam.IsExportExcelFlag + "&tmz=" + tmz + "&compCodeToPass=" + widgetPullDataParam.compCodeToPass;
        
        var ajaxMethod = "POST"; 
        $.ajax({
            type: ajaxMethod,
            url: requestURL,
            beforeSend: widgetPullDataParam.IsExportExcelFlag ? "" : widget.Loading(thisWidgetID),
            success: function (response) {

                if (response.statusCode == 200) { //200 equal good 
                    if (widgetPullDataParam.IsExportExcelFlag) {
                        page.GetJsonFileData(response.URL);
                    }
                    else {

                        if (response.Data != null) {

                            bindCompanyCurrentAndLastWeekVisitorCountComparison(response.Data[0], thisWidgetID);
                            widget.BindWidgetClick(thisWidgetID);
                        } else {
                            //bindWhatGaryTryToBuild8(thisWidgetID);

                        }


                    }

                }
            },
            error: function (request, status, error) {
                console.log(request);
                console.log(status);
                console.log(error);
            }
        });
    },


    GetSiteHourlyPasserByCountForEachZone: function (widgetPullDataParam) {
        var thisWidgetID = widgetPullDataParam.IsDemo ? "#Demo_" + "SiteHourlyPasserByCountForEachZone" : "#SiteHourlyPasserByCountForEachZone";
        var requestURL = "/FootfallCam/GetCompanyAllVisitorSite?selectedDate=" + $("#reportEndDate").val() + "&IsExportExcelFlag=" + widgetPullDataParam.IsExportExcelFlag + "&tmz=" + tmz + "&compCodeToPass=" + widgetPullDataParam.compCodeToPass;

        var ajaxMethod = "POST";
        $.ajax({
            type: ajaxMethod,
            url: requestURL,
            beforeSend: widgetPullDataParam.IsExportExcelFlag ? "" : widget.Loading(thisWidgetID),
            success: function (response) {

                if (response.statusCode == 200) { //200 equal good 
                    if (widgetPullDataParam.IsExportExcelFlag) {
                        page.GetJsonFileData(response.URL);
                    }
                    else {

                        if (response.Data != null) {

                            bindSiteHourlyPasserByCountForEachZone(response.Data[0], thisWidgetID);
                            $(thisWidgetID).parent().find(".widget-name").remove();
                            widget.BindWidgetClick(thisWidgetID);
                        } else {
                            //bindWhatGaryTryToBuild8(thisWidgetID);

                        }


                    }

                }
            },
            error: function (request, status, error) {
                console.log(request);
                console.log(status);
                console.log(error);
            }
        });
    },

    GetHeaderText: function (widgetId, IsExportExcelFlag) {
        var requestURL = "/FootfallCam/GetCustomDashboardHeaderText?id=" + widgetId + "&IsExportExcelFlag=" + IsExportExcelFlag + "&tmz=" + tmz;
        var ajaxMethod = "GET"; //or POST etc
        $.ajax({
            type: ajaxMethod,
            url: requestURL,
            success: function (response) {
                var thisWidgetID = widgetId == 0 ? "#Demo_" + "CustomHeader" : "header_" + response.Data;
                if (response.statusCode == 200 && response.Data) {
                    if (IsExportExcelFlag) {
                        page.GetJsonFileData(response.URL);//response.Data[0].JsonStoreUrl);
                    }
                    else {
                        $(thisWidgetID).parents(".custom-widget").css({ "border": "0px" });
                        bindCustomHeader("div[data-widget-db-id=" + widgetId + "]", response.Data);
                    }
                }
                else if (isEditorMode()) {
                    widget.BindWidgetClick(thisWidgetID);
                }
            },
            error: function (request, status, error) {
                console.log(request);
                console.log(status);
                console.log(error);
            }
        });
    }
};

var widget = {
    HasSpecificController: function (widgetId) {
        return $(widgetId).parents(".grid-stack-item").data("widget-controller") != undefined;
    },

    Loading: function (elemSelector) {
        $(elemSelector).html(loadingAnimation);
    },

    //GetTemplateTag: function (widgetContainer) {
    //    console.log(widgetContainer);
    //    return "";
    //},

    BindWidgetClick: function (widgetID) {
        var tmpWidgetID = widgetID.indexOf("#") > -1 ? widgetID : "#" + widgetID;
        var thisWidgetElem = $(tmpWidgetID);
        var thisWidgetAddButton = $(tmpWidgetID).parents('.custom-widget').find(".addWidgetButton");

        $(thisWidgetAddButton).click(function () {

            if (widgetID == "#Demo_CustomHeader" && !$("#Demo_CustomHeader input").val()) {
                Alert({
                    Header: "Information",
                    Body: "Please insert custom header text",
                    Footer: "<button class='btn not-primary-button' id='' data-dismiss='modal'>Close</button>"
                });
                return;
            }

            if ($(this).parents(".custom-widget").find(".demo-widget-container").attr("id") == "Demo_CustomMetricsWidget") {
                $("#WidgetMetricsDesignerDialog").modal("show");
                return;
            }

            var thisCustomWidget = thisWidgetElem.parents(".custom-widget");
            var thisDemoWidgetContainer = thisCustomWidget.find(".demo-widget-container");
            var widgetDetails = {
                ReportId: GetURLParam().cId ? parseInt(GetURLParam().cId) : 0,
                WidgetName: widgetID != "#Demo_CustomHeader" ? thisCustomWidget.find(".widget-name").text() : encodeURIComponent($("#Demo_CustomHeader input").val()),
                WidgetFunctionName: thisDemoWidgetContainer.data("widget-function-name"),
                WidgetWidth: thisDemoWidgetContainer.data("gs-width"),
                WidgetHeight: thisDemoWidgetContainer.data("gs-height"),
                WidgetCSSClasses: thisDemoWidgetContainer.attr("class").replace("demo-widget-container", ""),
                //WidgetHtml: GetTemplateTag(thisDemoWidgetContainer.html()),
                WidgetHTMLTag: thisDemoWidgetContainer.prop("tagName"),
                WidgetPagePlacement: -1,
                WidgetController:
                    thisDemoWidgetContainer.data("widget-controller") &&
                        thisDemoWidgetContainer.data("widget-controller").length > 0 &&
                        thisDemoWidgetContainer.data("widget-controller") ?
                        thisDemoWidgetContainer.data("widget-controller").trim() :
                        ""
            };

            Alert({
                Header: "Confirmation",
                Body: "Confirm to add this widget to dashboard?",
                Footer: "<button class='btn not-primary-button' id='' data-dismiss='modal'>Cancel</button>" + "<button class='btn btn-primary' id='confirmAddWidgetButton' data-dismiss='modal'>Confirm</button>"
            });
            $("#confirmAddWidgetButton").unbind().click(function () {
                var requestURL = "/FootfallCam/AddDashboardWidget";
                var ajaxMethod = "POST"; //or POST etc
                ShowLoadingPrompt("Adding widget");
                $.ajax({
                    type: ajaxMethod,
                    url: requestURL,
                    data: JSON.stringify(widgetDetails),
                    dataType: 'json',
                    contentType: 'application/json',
                    success: function (response) {
                        if (response.statusCode == 200) {
                            toastr.success("Widget added", "Information");
                        } else {
                            toastr.error("Add widget failed. " + response.errorMessage, "Information");
                        }
                    },
                    error: function (request, status, error) {
                        console.log(request);
                        console.log(status);
                        console.log(error);
                        toastr.error("Add widget failed.", "Information");
                    },
                    complete: function () {
                        HideLoadingPrompt();
                    }
                });
            })

        })
    },

    //GenerateWidgetController: function (grid, widgetController) {
    //    if (widgetController) {
    //        console.log(grid);
    //        console.log(widgetController);
    //        switch (widgetController) {
    //            case "singleDatePicker":
    //                break;
    //            case "dateRangePicker":
    //                break;
    //        }
    //    }
    //}
};

$(function () {
    if ($("#rightPanelContent").is(":visible")) {
        panel.InitializeDemoWidgetContainerWidth();
        panel.BindCloseRightPanelButton();
        widgetPullDataParam.IsDemo = true;
        panel.GetCustomMetrics(widgetPullDataParam);
        panel.GetBranchDailyVisitorIn(widgetPullDataParam);
        panel.GetBranchDailyVisitorIn_v2(widgetPullDataParam);
        panel.GetCompanyNthDayFootfallHourlyData(widgetPullDataParam);
        panel.GetCompanyMonthlyFootfallDailyData(widgetPullDataParam);
        panel.GetCompanyTop5VisitorSite(widgetPullDataParam);
        panel.GetBranchDailyVisitDuration(widgetPullDataParam);
        panel.GetBranchHourlyVisitorOrderCount(widgetPullDataParam);
        panel.GetBranchDailyAverageQueueTime(widgetPullDataParam);
        panel.GetBranchDailyAverageOrderTime(widgetPullDataParam);
        panel.GetBranchQueueCustomerJourneyTime(widgetPullDataParam);
        panel.GetBranchDailyAveragePickupTime(widgetPullDataParam);
        panel.GetBranchQueueOrderingPickupTimeGraph(widgetPullDataParam);
        panel.GetBranchLatestHourQueueLength(widgetPullDataParam);
        panel.GetBranchMaleToiletCount(widgetPullDataParam);
        panel.GetBranchFemaleToiletCount(widgetPullDataParam);
        panel.GetWhatGaryTryToBuild(widgetPullDataParam);
        panel.GetWhatGaryTryToBuild2(widgetPullDataParam);
        panel.GetWhatGaryTryToBuild3(widgetPullDataParam);
        //panel.GetWhatGaryTryToBuild4(widgetPullDataParam);
        //panel.GetWhatGaryTryToBuild5(widgetPullDataParam);
        //panel.GetWhatGaryTryToBuild6(widgetPullDataParam);
        panel.GetCompanyCurrentWeekVisitorCount(widgetPullDataParam);
        panel.GetCompanyCurrentAndLastWeekVisitorCountComparison(widgetPullDataParam); // gary build
        panel.GetSiteHourlyPasserByCountForEachZone(widgetPullDataParam);
        panel.GetLiveAvgQueueTime(widgetPullDataParam);
        panel.GetLiveAvgOrderingTime(widgetPullDataParam);
        panel.GetLiveAvgPickupTime(widgetPullDataParam);
        panel.GetMaleWashroomManagement(widgetPullDataParam);
        panel.GetFemaleWashroomManagement(widgetPullDataParam);
        panel.GetLiveDustbinUsagePercentage(widgetPullDataParam);
        panel.GetLiveDustbinUsagePercentage2(widgetPullDataParam);//smartbin
        panel.GetDriveThroughDashboard(widgetPullDataParam);
        panel.GetHeaderText(0);
    }
});