﻿var FloorplanUtility = {
    InitFloorplanEditor: function () {
        if ($("body #floorplanEditorContainer").length == 0) {
            $("body").append("<div id='floorplanEditorContainer'></div>");
        }
        ShowLoadingPrompt("Initializing editor");
        $("#floorplanEditorContainer")
            .load("/FootfallCam/FloorplanEditor", function () {
                HideLoadingPrompt();
                $("#floorplanEditorContainer").append("<div id='closeImageMapProEditor'><i class='fa fa-times'></i></div>");
                FloorplanUtility.InitCloseFloorplanEditor();
                $("body div#wrapper").css({ "height": "100%" });
            })
            .css({
                "position": "absolute",
                "top": 0,
                "z-index": 2500,
                "height": "inherit",
                "width": "100%"
            });
    },

    InitCloseFloorplanEditor: function () {
        $("#closeImageMapProEditor").unbind().click(function () {
            $("#floorplanEditorContainer").remove();
            $("body div#wrapper").css({ "height": "fit-content" });
        })
    },

    RenderFloorplan: function (floorplanObj) {
        $('head').append('<link rel="stylesheet" href="/Content/imagemappro/css/image-map-pro-editor.css">');
        $('head').append('<link rel="stylesheet" href="/Content/imagemappro/css/image-map-pro.css">');
        $('head').append('<script src="/Content/imagemappro/submodules/svg-path-parser/svg-path-parser.js"></script>');
        $('head').append('<script src="/Content/imagemappro/submodules/squares/js/squares-renderer.js"></script>');
        $('head').append('<script src="/Content/imagemappro/submodules/squares/js/squares.js"></script>');
        $('head').append('<script src="/Content/imagemappro/submodules/squares/js/squares-elements-jquery.js"></script>');
        $('head').append('<script src="/Content/imagemappro/submodules/squares/js/squares-controls.js"></script>');
        $('head').append('<script src="/Content/imagemappro/submodules/wcp-form/js/wcp-form.js"></script>');
        $('head').append('<script src="/Content/imagemappro/submodules/wcp-form/js/wcp-form-controls.js"></script>');
        $('head').append('<script src="/Content/imagemappro/submodules/wcp-editor/js/wcp-editor.js"></script>');
        $('head').append('<script src="/Content/imagemappro/submodules/wcp-tour/js/wcp-tour.js"></script>');
        $('head').append('<script src="/Content/imagemappro/submodules/wcp-compress/js/wcp-compress.js"></script>');
        $('head').append('<script src="/Content/imagemappro/submodules/wcp-fontawesome/js/wcp-fontawesome.js"></script>');
        $('head').append('<script src="/Content/imagemappro/js/image-map-pro-defaults.js"></script>');
        $('head').append('<script src="/Content/imagemappro/js/image-map-pro-editor-countries-jquery.js"></script>');
        $('head').append('<script src="/Content/imagemappro/js/image-map-pro-editor.js"></script>');
        $('head').append('<script src="/Content/imagemappro/js/image-map-pro-editor-content.js"></script>');
        $('head').append('<script src="/Content/imagemappro/js/image-map-pro-editor-storage-jquery.js"></script>');
        $('head').append('<script src="/Content/imagemappro/js/image-map-pro-editor-init-jquery.js"></script>');
        $('head').append('<script src="/Content/imagemappro/js/image-map-pro.js"></script>');
        $(floorplanObj.container).imageMapPro({ "id": 3558, "editor": { "selected_shape": "oval-2256", "tool": "oval", "shapeCounter": { "ovals": 1, "polys": 5 } }, "general": { "name": "Untitled", "shortcode": "Untitled", "width": 3508, "height": 2482, "naturalWidth": 3508, "naturalHeight": 2482 }, "image": { "url": "http://portal.footfallcam.com/floorplan/AmwayMalaysia/d7d6bf3c.png" }, "spots": [{ "id": "poly-3111", "title": "Poly 0", "type": "poly", "x": 18.727, "y": 28.866, "width": 7.112, "height": 15.206, "default_style": { "background_color": "", "background_opacity": 0.5375573394495413 }, "tooltip_content": { "squares_settings": { "containers": [{ "id": "sq-container-403761", "settings": { "elements": [{ "settings": { "name": "Heading", "iconClass": "fa fa-header" }, "options": { "heading": { "text": "Poly 0" } } }] } }] } }, "points": [{ "x": 3.846153846153827, "y": 17.795941390709626 }, { "x": 0, "y": 100 }, { "x": 100, "y": 16.948476868964356 }, { "x": 32.04677204074468, "y": 0 }] }, { "id": "poly-3181", "title": "Poly 2", "type": "poly", "x": 33.131, "y": 24.355, "width": 20.151, "height": 12.887, "x_image_background": 33.131, "y_image_background": 24.355, "width_image_background": 20.151, "height_image_background": 12.887, "tooltip_content": { "squares_settings": { "containers": [{ "id": "sq-container-403761", "settings": { "elements": [{ "settings": { "name": "Heading", "iconClass": "fa fa-header" }, "options": { "heading": { "text": "Poly 2" } } }] } }] } }, "points": [{ "x": 1.0797549361059806, "y": 7.998515238009903 }, { "x": 0, "y": 100 }, { "x": 100, "y": 89.99985600368632 }, { "x": 96.7711516699187, "y": 0 }] }, { "id": "poly-3256", "title": "Poly 3", "type": "poly", "x": 58.754, "y": 23.71, "width": 25.802, "height": 57.345, "x_image_background": 58.754, "y_image_background": 26.417, "tooltip_content": { "squares_settings": { "containers": [{ "id": "sq-container-403761", "settings": { "elements": [{ "settings": { "name": "Heading", "iconClass": "fa fa-header" }, "options": { "heading": { "text": "Poly 3" } } }] } }] } }, "points": [{ "x": 51.58700089809095, "y": 1.7989448237414798 }, { "x": 87.98555215690294, "y": 0 }, { "x": 95.75851881055156, "y": 25.168993774902315 }, { "x": 93.14181885119464, "y": 41.67324800660866 }, { "x": 93.99274744470692, "y": 52.135476189320485 }, { "x": 100, "y": 100 }, { "x": 0, "y": 94.83223589177706 }, { "x": 58.66957611194219, "y": 79.52867156442963 }, { "x": 49.112566039233016, "y": 23.82150201627583 }] }, { "id": "poly-1131", "title": "Poly 4", "type": "poly", "x": 44.256, "y": 43.298, "width": 23.159, "height": 27.836, "x_image_background": 50.274, "y_image_background": 43.298, "tooltip_content": { "squares_settings": { "containers": [{ "id": "sq-container-403761", "settings": { "elements": [{ "settings": { "name": "Heading", "iconClass": "fa fa-header" }, "options": { "heading": { "text": "Poly 4" } } }] } }] } }, "points": [{ "x": 1.1797721217548107, "y": 9.259678313592588 }, { "x": 97.24440964489283, "y": 0 }, { "x": 100, "y": 100 }, { "x": 0, "y": 93.51623635273431 }] }, { "id": "oval-2256", "title": "Oval 0", "type": "oval", "x": 19.547, "y": 64.046, "width": 10.485, "height": 14.562, "x_image_background": 19.547, "y_image_background": 64.046, "width_image_background": 10.485, "height_image_background": 14.562, "tooltip_content": { "squares_settings": { "containers": [{ "id": "sq-container-403761", "settings": { "elements": [{ "settings": { "name": "Heading", "iconClass": "fa fa-header" }, "options": { "heading": { "text": "Oval 0" } } }] } }] } } }] });
    }
}