function GetDimension(selector) {
    var thisElement = selector;
    var thisImage = {
        naturalWidth: thisElement.naturalWidth,
        naturalHeight: thisElement.naturalHeight,
        viewWidth: thisElement.width,
        viewHeight: thisElement.height,
        left: $(thisElement).position().left,
        top: $(thisElement).position().top
    };
    return thisImage;
}
function GetFloorplanImageDimension(selector) {
    var thisElement = selector.parents(".floorplanHolderContainer").find(".iv-large-image")[0];
    return GetDimension(thisElement);
}
function GetZoomRatio(selector) {
    var thisFloorPlanDimension = GetFloorplanImageDimension(selector);
    var widthRatio = thisFloorPlanDimension.viewWidth / thisFloorPlanDimension.naturalWidth;
    var heightRatio = thisFloorPlanDimension.viewHeight / thisFloorPlanDimension.naturalHeight;
    var thisImageZoomRatio = {
        floorplanID: selector.parents('.floorplanHolderContainer').find(".floorplanHolder").attr("id"),
        widthRatio: widthRatio,
        heightRatio: heightRatio,
        left: thisFloorPlanDimension.left,
        top: thisFloorPlanDimension.top,
        width: thisFloorPlanDimension.viewWidth,
        height: thisFloorPlanDimension.viewHeight,
        naturalWidth: thisFloorPlanDimension.naturalWidth,
        naturalHeight: thisFloorPlanDimension.naturalHeight
    };
    return thisImageZoomRatio;
}
function PlotTrafficPoints(floorplanID) {
    var zoomableFloorplanContainer = $(".floorplanHolderContainer").find(floorplanID).parents(".floorplanHolderContainer").find(".iv-large-image");
    var playTrafficButton = GetZoomRatio(zoomableFloorplanContainer).floorplanID + "";
    var playHumanTrafficFlowDOM = "<div class='containerPlayTrafficFlow playbutton' data-floorplan-id='" + GetZoomRatio(zoomableFloorplanContainer).floorplanID + "'><i class='fa fa-play-circle'></i></div>";
    var thisFloorplanIVContainer = zoomableFloorplanContainer.parents(".iv-container");
    $(thisFloorplanIVContainer).prepend(playHumanTrafficFlowDOM);
    $(".playbutton[data-floorplan-id='" + GetZoomRatio(zoomableFloorplanContainer).floorplanID + "']").unbind("click").click(function () {
        while ($(this).is(":visible")) {
            ////console.log($(this));
            ////console.log("current: " + $(this).is(":visible"));
            $(this).hide();
            ////console.log("after: " + $(this).is(":visible"));
        }
        var floorplanDOM = $(this).parents(".floorplanHolderContainer").find(".iv-image-wrap");
        var currentDimension = GetZoomRatio(floorplanDOM);
        ReplotTrafficPoints(floorplanDOM, currentDimension);
        BindResizeSensor("#" + GetZoomRatio(zoomableFloorplanContainer).floorplanID);
    })
}
function SmoothenRawData(tmpRawDataSet, fps) {
    var SmoothenDataSet = [];
    var smoothenRawDataSet = [];
    var smoothenRawDataCount = tmpRawDataSet.length * fps;
    for (var frameCount = 0; frameCount < tmpRawDataSet.length; frameCount++) {
        tmpRawDataSet[frameCount].timestamp = frameCount * fps;
    }
    var SmoothenDataSetLength = fps * (tmpRawDataSet.length - 1);
    for (var frameCount = 0; frameCount < SmoothenDataSetLength; frameCount++) {
        var originalFrameCount = frameCount / fps;
        var existingBatch = tmpRawDataSet.filter(function (data) {
            if (data.timestamp == frameCount) {
                return data;
            }
        });
        existingBatch = existingBatch[0];
        if (existingBatch != undefined) {
            existingBatch.isArtificial = false;
            SmoothenDataSet.push(existingBatch);
        } else {
            var placeHolderBatch = {
                timestamp: frameCount,
                blobs: [],
                isArtificial: true
            }
            SmoothenDataSet.push(placeHolderBatch);
        }
        actualLoop = frameCount != 0 ? parseInt(frameCount / fps) : 0;
        var thisBatch = SmoothenDataSet[frameCount];
        if (thisBatch.isArtificial) {
            var
                previousBatchBlobs = SmoothenDataSet[actualLoop * fps],
                nextNotArtificialBatch = tmpRawDataSet[actualLoop + 1]
                ;
            var previousBatchBlobCount = Object.keys(previousBatchBlobs).length;
            thisBatch.blobs = {};
            $.each(previousBatchBlobs.blobs, function (previousBlobID, previousBlobCoor) {
                var possibleExistingNextBatchBlob = nextNotArtificialBatch.blobs[previousBlobID];
                if (possibleExistingNextBatchBlob != undefined) {
                    var lastNotArtificialBlob = previousBatchBlobs.blobs[previousBlobID];
                    var newBlob = SmoothenDataSet[frameCount - 1].blobs[previousBlobID];
                    if (newBlob != undefined) {
                        var increment = {
                            x: (possibleExistingNextBatchBlob.x - lastNotArtificialBlob.x) / fps,
                            y: (possibleExistingNextBatchBlob.y - lastNotArtificialBlob.y) / fps,
                        }
                        thisBatch.blobs[previousBlobID] = {
                            x: newBlob.x + increment.x,
                            y: newBlob.y + increment.y,
                        }
                    }
                }
            })
        }
    }
    return SmoothenDataSet;
}
function ReplotTrafficPoints(floorplanDOM, currentDimension) {
    ////console.log("Replotting...");
    var $thisZoomableFloorplanContainer = $(floorplanDOM.parent());
    var floorplanHumanTrafficCanvasID = currentDimension.floorplanID + " humanTrafficCanvas";
    if ($("." + currentDimension.floorplanID + ".humanTrafficCanvas").length > 0) {
        $("." + currentDimension.floorplanID + ".humanTrafficCanvas").remove();
    }

    var humanTrafficFlowDOM = "<canvas class='" + floorplanHumanTrafficCanvasID + "'></canvas>";
    $thisZoomableFloorplanContainer.prepend(humanTrafficFlowDOM);
    $("." + currentDimension.floorplanID + ".humanTrafficCanvas").css({
        "position": "relative",
        "width": currentDimension.width,
        "height": currentDimension.height,
        "left": currentDimension.left,
        "top": currentDimension.top
    });

    let resizeReset = function () {
        w = currentDimension.width;
        h = currentDimension.height;
    }

    const opts = {
        particleColor: "black",
        defaultSpeed: 1,
        variantSpeed: 1,
        defaultRadius: 10,
        variantRadius: 10,
        linkRadius: 10,
        direction: 10
    };

    window.addEventListener("resize", function () {
        deBouncer();
    });

    let delay = 200, tid;
    let deBouncer = function () {
        clearTimeout(tid);
        tid = setTimeout(function () {
            //resizeReset();
        }, delay);
    };

    let checkDistance = function (x1, y1, x2, y2) {
        return Math.sqrt(Math.pow(x2 - x1, 2) + Math.pow(y2 - y1, 2));
    };

    Particle = function (xPos, yPos, name) {
        this.speed = 1;
        this.x = xPos * currentDimension.widthRatio;
        this.y = yPos * currentDimension.heightRatio;
        this.color = opts.particleColor;
        this.radius = 10;
        this.name = name;
    };
    var
        loopCount = 0,
        fps = 24,
        playSpeed = 1000 / fps;
    var timestamp = 0;

    const
        canvasBody = $("." + currentDimension.floorplanID + ".humanTrafficCanvas")[0],
        drawArea = canvasBody.getContext("2d");
    canvasBody.width = currentDimension.width;
    canvasBody.height = currentDimension.height;

    $.getJSON("/DummyData/sperm-with-object-identifier.json", function (rawTrafficData) {
        AnimateParticles(SmoothenRawData(rawTrafficData, fps));
    });

    function AnimateParticles(trafficData, loopCount) {
        loopCount = loopCount == undefined ? 0 : loopCount;
        var $thisFloorplanPlayButton = $("#" + currentDimension.floorplanID).parents(".floorplanHolderContainer").find(".playbutton");
        if ($thisFloorplanPlayButton.is(":visible")) {
            ClearPreviousChunkDataSet(trafficData, loopCount);
        } else {
            $thisFloorplanPlayButton.hide();
        }

        for (var batchCount = loopCount; batchCount < trafficData.length; batchCount++) {
            particles = [];
            var thisBatchBlobs = trafficData[batchCount];
            drawArea.fillStyle = '#000000';
            drawArea.clearRect(0, 0, canvasBody.width, canvasBody.height);
            $.each(thisBatchBlobs.blobs, function (thisBlobID, thisBlobCoor) {
                drawArea.beginPath();
                var thisParticle = {
                    x: thisBlobCoor.x * currentDimension.widthRatio,
                    y: thisBlobCoor.y * currentDimension.heightRatio,
                    nameX: (thisBlobCoor.x + 15) * currentDimension.widthRatio,
                    nameY: thisBlobCoor.y * currentDimension.heightRatio
                };
                drawArea.arc(thisParticle.x, thisParticle.y, 10 * currentDimension.widthRatio, 10, 0, true);
                //drawArea.fillText(thisBlobID, thisParticle.nameX, thisParticle.nameY);
                drawArea.fill();
            })
            loopCount++;
            break;
        }
        if (loopCount == trafficData.length) {
            ClearPreviousChunkDataSet(trafficData, loopCount);
        } else {
            setTimeout(function () {
                window.requestAnimationFrame(function () {
                    AnimateParticles(trafficData, loopCount);
                });
            }, playSpeed);
        }
    }

    function ClearPreviousChunkDataSet(trafficData, lastPlayedTimestamp) {
        window.cancelAnimationFrame(AnimateParticles);
        trafficData.length = 0;
        console.log("Clear previous chunk particles: " + lastPlayedTimestamp);
    }
}
function debounce(func, wait, immediate) {
    var timeout;
    return function () {
        var context = this, args = arguments;
        var later = function () {
            timeout = null;
            if (!immediate) {
                func.apply(context, args);
            }
        };
        var callNow = immediate && !timeout;
        clearTimeout(timeout);
        timeout = setTimeout(later, wait);
        if (callNow) func.apply(context, args);
    };
};
function BindResizeSensor(specificFloorplan) {
    if (specificFloorplan != undefined) {
        var fpi = $(specificFloorplan).parents(".floorplanHolderContainer").find(".iv-large-image");

        fpi.attrchange({
            callback: function (e) {
                var $this = $(this);
                $this.parents(".floorplanHolderContainer").find(".humanTrafficCanvas").remove();
                var showPlayButton = debounce(function (a = $this) {
                    $this.parents(".floorplanHolderContainer").find(".playbutton").show();
                }, 750, false);
                showPlayButton();
            }
        });
    } else {
        $.each($(".floorplanHolderContainer"), function (i, floorplanItem) {
            var fpi = $(floorplanItem).find(".iv-large-image");

            fpi.attrchange({
                callback: function (e) {
                    var currentDimension = GetZoomRatio($(this));
                    //var zoomRatioDetails = "Width: " + parseFloat(currentDimension.width).toFixed(2) + " | Height: " + parseFloat(currentDimension.height).toFixed(2);
                    //var thisFloorplanZoomRatioDetailsContainer = $(this).parents(".floorplanHolderContainer").find(".zoomRatioDetails");
                    //thisFloorplanZoomRatioDetailsContainer.html(zoomRatioDetails);
                    var Counter1 = {
                        x: 250,
                        y: 300,
                        width: 80,
                        height: 50,
                        rotate: -52,
                        floorplanHolderID: "FloorplanHolder1",
                        counterID: "counterID1"
                    };
                    var Counter2 = {
                        x: 390,
                        y: 478,
                        width: 80,
                        height: 50,
                        rotate: 60,
                        floorplanHolderID: "FloorplanHolder1",
                        counterID: "counterID2"
                    }

                    //For heatmap report
                    ReplotCounter(Counter1);
                    ReplotCounter(Counter2);

                    //Traffic flow report

                }
            });
        })
    }
}
function PlotCounterLiveView(floorplanID) {
    var floorplanHolderContainer = $(floorplanID).parents(".floorplanHolderContainer").find(".iv-container");
    var counterLiveViewDOM = "";
    counterLiveViewDOM += "<div class='counterLiveViewHolder' id='counterID1'>";
    counterLiveViewDOM += "</div>";
    counterLiveViewDOM += "<div class='counterLiveViewHolder' id='counterID2'>";
    counterLiveViewDOM += "</div>";
    $(floorplanHolderContainer).append(counterLiveViewDOM);
    var Counter1 = {
        x: 250,
        y: 300,
        width: 80,
        height: 50,
        rotate: -52,
        floorplanHolderID: "FloorplanHolder1",
        counterID: "counterID1"
    };
    var Counter2 = {
        x: 390,
        y: 478,
        width: 80,
        height: 50,
        rotate: 60,
        floorplanHolderID: "FloorplanHolder1",
        counterID: "counterID2"
    }
    //ReplotCounter(Counter1);
    //ReplotCounter(Counter2);
}
function ReplotCounter(Counter) {
    var FloorplanHolder = $("#" + Counter.floorplanHolderID);
    var counterInFloorplan = FloorplanHolder.find("#" + Counter.counterID);
    var floorplanImgElement = FloorplanHolder.find(".floorplanHolder");
    var floorplanZoomRatio = GetZoomRatio($("#" + $(floorplanImgElement).attr("id")));
    var floorplanElement = FloorplanHolder.find(".iv-large-image");

    var counterPositionX = Counter.x * floorplanZoomRatio.widthRatio + floorplanZoomRatio.left;
    var counterPositionY = Counter.y * floorplanZoomRatio.heightRatio + floorplanZoomRatio.top;
    var counterWidth = Counter.width * floorplanZoomRatio.widthRatio;
    var counterHeight = Counter.height * floorplanZoomRatio.heightRatio;
    $(counterInFloorplan).css({
        "left": counterPositionX,
        "top": counterPositionY,
        "width": counterWidth,
        "height": counterHeight,
        "transform": "rotate(" + Counter.rotate + "deg)"
    });
}
function BindLongPressSensor(selector) {
    var elementList = $(selector);
    $.each(elementList, function (i, element) {

        var longpressThreshold = 500;
        // holds the start time
        var start;
        var clicking = false;
        //////console.log($(this)[0]);
        var touchStartFingerPosition = {
            x: 0,
            y: 0
        }

        var movedX = 0;
        var movedY = 0;

        function MouseDownOrTouchDown(isTouch, event) {
            clicking = true;
            start = new Date().getTime();
            var isTouching = isTouch ? "touch" : "click";
            $(".h2").html(isTouching);
            if (isTouch) {
                touchStartFingerPosition = {
                    x: event.originalEvent.touches[0].pageX,
                    y: event.originalEvent.touches[0].pageY
                }
                //$(".h2").append(" x: " + touchStartFingerPosition.x + " | y: " + touchStartFingerPosition.y);
            }

        }

        function MouseLeaveOrTouchLeave() {
            clicking = false;
            start = 0;
        }

        function MouseUpOrTouchEnd(isTouch, e) {
            var isTouching = isTouch ? "touch" : "click";
            var currTime = new Date().getTime();
            var holdDuration = (start + longpressThreshold);
            ////console.log(movedX + " | " + movedY);
            var passLongPressThreshold = currTime >= holdDuration;
            if (isTouch) { //mobile trigger
                if (passLongPressThreshold && movedX <= 10 && movedY <= 10) {
                    //$(".h2").html("long " + isTouching + ": " + (currTime - holdDuration));
                    PlotNewCounterToFloorplan();
                    clicking = false;
                } else {
                    $(".h2").html("Short touch");
                }
            } else { //desktop trigger
                if (passLongPressThreshold && movedX <= 10 && movedY <= 10) {
                    //$(".h2").html("long " + isTouching + ": " + (currTime - holdDuration));
                    PlotNewCounterToFloorplan();
                    clicking = false;
                } else {
                    $(".h2").html("Short click");
                }
            }
        }

        function MouseMoveOrTouchMove(isTouch, event) {
            var currentFingerPosition = {
                x: isTouch ? event.originalEvent.touches[0].pageX : event.originalEvent.pageX,
                y: isTouch ? event.originalEvent.touches[0].pageY : event.originalEvent.pageY
            }
            movedX = touchStartFingerPosition.x - currentFingerPosition.x;
            movedY = touchStartFingerPosition.y - currentFingerPosition.y
            if (!isTouch) {
                if (clicking == false) return;
                //if (clicking) clicking = false;
            } else {

            }
        }

        $(this)
            .on('mousedown', function (e) {
                MouseDownOrTouchDown(false, e);
            })
            .on('touchstart', function (e) {
                MouseDownOrTouchDown(true, e);
            })
            .on('mousemove', function (e) {
                MouseMoveOrTouchMove(false, e);
            })
            .on('touchmove', function (e) {
                $(".h2").html("touch move");
                MouseMoveOrTouchMove(true, e);
            })
            .on('mouseup', function (e) {
                MouseUpOrTouchEnd(false, e);
            })
            .on('touchend', function (e) {
                MouseUpOrTouchEnd(true, e);
            })
            .on('mouseleave', function (e) {
                $(".h2").html("mouse leave");
                MouseLeaveOrTouchLeave();
            })
    })
}
function PlotNewCounterToFloorplan() {
    $(".h2").html("PlotNewCounterToFloorplan");
}
$(function () {
    var imageViewerOptions = {
        zoomValue: 100,
        maxZoom: 300,
        snapView: true,
        zoomOnMouseWheel: true
    };
    var viewer1 = ImageViewer('#floorplan1', imageViewerOptions);
    var viewer2 = ImageViewer('#floorplan2', imageViewerOptions);
    BindResizeSensor();
    setTimeout(function () {
        PlotCounterLiveView("#floorplan1");
        PlotTrafficPoints("#floorplan1");
    }, 0);
    BindLongPressSensor(".floorplanHolderContainer");
})
