﻿var HeatmapUtil = {
    GenerateRaster: function (obj) {
        if ($(obj.HTMLContainerSelector).length == 0)
            return `HTML element: ${obj.HTMLContainerSelector} could not be found in DOM`;

        // get dynamic scale for canvas drawing
        obj.XYValueString = obj.XYValueString.replace(/'/g, '"');
        var XYValueArray = JSON.parse(obj.XYValueString);

        var rescaleImageContainerRatio = 1;
        $.each(XYValueArray, function (i, xyValueObj) {
            if (xyValueObj.scale > 4) {
                rescaleImageContainerRatio = xyValueObj.scale / 4;
                return false;
            }
            if (xyValueObj.scaled > 4) {
                rescaleImageContainerRatio = xyValueObj.scaled / 4;
                return false;
            }
        })

        // must set the size first
        var rasterSize = {
            width: 640 * rescaleImageContainerRatio,
            height: 480 * rescaleImageContainerRatio
        };

        // set container size
        // $(obj.HTMLContainerSelector).css({ 'height': rasterSize.height, 'width': rasterSize.width });

        // heatmapjs do its thing
        var heatmap = h337.create({
            container: $(obj.HTMLContainerSelector).parents('.F01R_HeatmapContainer')[0],
            radius: 50,
        });

        var heatmapJSClass = ".heatmap-canvas";
        //var heatmapJSGeneratedCanvas = $(obj.HTMLContainerSelector).parent().find(heatmapJSClass)[0];

        // set heatmapjs canvas
        $(obj.HTMLContainerSelector).parents('.F01R_HeatmapContainer').find(heatmapJSClass)
            .css({ 'zIndex': 10 })
            .attr({ 'height': rasterSize.height, 'width': rasterSize.width });

        window.h = heatmap;

        var tmpDetailsRasterList = [];
        $.each(XYValueArray, function (i, dataObj) {

            var tmpDetailedRaster = {};
            tmpDetailedRaster.x = 0;
            tmpDetailedRaster.y = 0;
            tmpDetailedRaster.value = 0;
            // if (dataObj.scaled == 4) {
            //     console.log("4");
            // }
            var xCoor = 0;
            var yCoor = 0;

            if (dataObj.scale != undefined && dataObj.scaled != undefined) {
                if (dataObj.scale > dataObj.scaled) {
                    xCoor = dataObj.x * dataObj.scale;
                    yCoor = dataObj.y * dataObj.scale;
                }
                else if (dataObj.scaled > dataObj.scale) {
                    xCoor = dataObj.x * dataObj.scaled;
                    yCoor = dataObj.y * dataObj.scaled;
                }
            }

            tmpDetailedRaster.x = xCoor;
            tmpDetailedRaster.y = yCoor;

            tmpDetailedRaster.value = xCoor == 0 && yCoor == 0 ? -1 : dataObj.value;

            tmpDetailsRasterList.push(tmpDetailedRaster);
        });

        var canvasLength = $(obj.HTMLContainerSelector).parents('.F01R_HeatmapContainer').find("canvas").length - 1;
        $(obj.HTMLContainerSelector).parents('.F01R_HeatmapContainer').find("canvas").each(function (i, elem) {
            if (i < canvasLength) {
                $(this).remove();
            }
        });

        // update canvas drawing
        h.setData({
            max: obj.MaxHeatValue,
            data: tmpDetailsRasterList,
        });


        // turn to img object
        var rasterImage = $(obj.HTMLContainerSelector).parents('.F01R_HeatmapContainer').find(heatmapJSClass)[0].toDataURL("image/png");
        var tmpRasterImageObject = new Image();
        tmpRasterImageObject.src = rasterImage;
        $(obj.HTMLContainerSelector)
            .html(tmpRasterImageObject)
            .find(".tempCanvas, .heatmap-canvas").remove();

        //clean up canvas
        $(obj.HTMLContainerSelector).parents('.F01R_HeatmapContainer').find("canvas").remove();
    }
};