var SSI = {
    SetupSsiEditor: function (NewWidgetID, ExistedWidgetSetting) {
        var ssiTextarea = `
        <hr>
        <div class="widgetSetting" id="${NewWidgetID}_SSI_Wrapper">
            <section>
                <b>SSI:</b>
                <br>
                <textarea id='ssiTextarea' data-optional='true'></textarea>
            </section>
        </div>
        `;
        $(".metricsSettingWrapper").append(ssiTextarea);
        if (ExistedWidgetSetting.SSI) {
            var jsCodeConversionResponse = SSI.ConvertToExecutableCode(undefined, ExistedWidgetSetting.SSI);
            if (jsCodeConversionResponse.success) {
                $("#ssiTextarea").val(jsCodeConversionResponse.code);
            }
        }
    },
    ConvertToStorableCode: function (ssiEditorValue) {
        var storableCode = "";
        storableCode = ssiEditorValue
            .replace(/\r?\n/g, '##nextLine##') // convert \n to ##nextLine## as json cannot have multiple line
            .replace(/"/g, '\'\''); // convert double quote to 2 single quotes
        return storableCode;
    },
    ConvertToExecutableCode: function (widgetId, ssiCodeContent) {
        var conversionResult = {
            success: false,
            code: "",
            error: ""
        };
        try {
            var thisWidgetId = widgetId ? "#" + widgetId + " " : "#thisWidgetId#";
            conversionResult.code = ssiCodeContent
                .replace(/\r?##nextLine##/g, '\n')
                .replace(/\'/g, '"')
                .replace(/""/g, '"')
                .replace(/#thisWidgetId#/g, thisWidgetId);
            conversionResult.success = true;
        } catch (e) {
            conversionResult.error = e;
        }
        return (conversionResult);
    },
    ExecuteSsiCode: function (widgetId, codeContent) {
        var jsConversionResponse = SSI.ConvertToExecutableCode(widgetId, codeContent);
        if (jsConversionResponse.success) {
            try {
                eval(`${jsConversionResponse.code}`);
            } catch (e) {
                console.log("SSI error:\n" + e);
            }
        } else {
            console.log("SSI conversion error:\n" + jsConversionResponse.error);
        }
    }
}