﻿use retailcamcontrolpanel
--Remarks
--[meta]   : to be ran on meta server
--[client] : to be ran on client server
--[]       : steps to be carried out on meta server
--()       : steps to be carried out on client server

declare @destinationServer nvarchar(max)
select @destinationServer = 'http://pcounter.watsons.com.tw'

--[1][meta] sync branches between two server
select 'if not exists (select * from ffbranches where branchcode=''', branchcode,''') begin insert into ffbranches (branchcode, branchname, country, countryabbr, timezone, storetype, companyid, updateddatetime, userid, latitude, longitude, offset) values (''', branchcode,''',N''', branchname, ''',''', country, ''',''', countryabbr, ''',''',timezone, ''',''',storetype, ''',',1, ',''', updateddatetime, ''',',5, ',',latitude, ',',longitude, ',''',offset, ''') end' ,
' else begin update ffbranches ',
' set ',
' branchcode=''', branchcode,''', ' , 
' branchname=N''', branchname,''',' , 
' country=''', country,''',' , 
' countryabbr=''', countryabbr,''',' , 
' timezone=''', timezone,''',' , 
' storetype=''', storetype,''',' , 
' companyid=', 1, ',', 
' updateddatetime=''', updateddatetime,''',' , 
' userid=', 5, ',', 
' latitude=', latitude,',' , 
' longitude=', longitude,',' , 
' offset=''', offset,'''' , 
' where branchcode=''', branchcode,''' end'
from ffbranches where companyid = (select id from companies where companycode = 'watsontw')
--and branchname != 'SongShan' and branchname != 'ChongGuang'
------(1)[client] copy and paste the result above to section below (remove the white spaces too)--------




--------------------------------------------------------------------------------------------------------

--[2][meta] Get counters to be migrated
--start F5 here
select id as cameraid, serial, branchcode, branchname into #tmpSerial from ffcameras where serial in (
-- copy and paste the verified counter details below from spreadsheet (FFC Production Forecast > sheet CountersToBeMoved, remove the white spaces too) --
--------------------------------------------------------------------------------------------------------
'00000000e7fc1230',
'000000007211a9f3',
'000000000f76ee27',
'0000000063ef59c3',
'00000000f2e40413',
'00000000e3cbd3aa',
'0000000035f1111b'
--------------------------------------------------------------------------------------------------------
)


select * from #tmpSerial
--ffcameras
--[3][meta] Get the list of counters ready to be inserted in client server if ever pointed to their server
select 'if not exists (select * from ffcameras where serial=''',serial,''') 
begin insert into ffcameras (branchid, branchcode, branchname, cameraid, cameraname, camerafirmwareversion, camerastatus, https, cameramodel, dstvalue, dateupdated, companycode, countercameratype, iscountinallowup, serial, updateddatetime, companyserial, server, healthcheckstatus, resellercompanycode, iszonerep) 
values 
((select id from ffbranches where branchcode=''',b.branchcode,''' and companyid = (select id from companies where companycode=''WatsonTw'')),''', b.branchcode, ''', N''''+(select branchname from ffbranches where branchcode=''',b.branchcode,''' and companyid = (select id from companies where companycode=''WatsonTw'')) + '''', ', cameraid, ', N''',cameraname,''',''', camerafirmwareversion, ''',',camerastatus,',',https,',',cameramodel,',',dstvalue,',''', dateupdated,''',''', companycode,''',''', countercameratype, ''',',iscountinallowup,',''', serial,''',''', c.updateddatetime,''',''', companyserial,''',''', @destinationServer, ''',', healthcheckstatus,',''WatsonTw''', ',', iszonerep, ') end' ,
' else begin update ffcameras ',
' set ',
' branchid=', '(select id from ffbranches where branchcode=''',b.branchcode,''' and companyid = (select id from companies where companycode=''WatsonTw''))',', ' , 
' branchcode=''', b.branchcode,''', ' , 
' branchname=N''', b.branchname,''', ' , 
' cameraid=', cameraid,', ' , 
' cameraname=N''', cameraname,''', ' , 
' camerafirmwareversion=''', camerafirmwareversion,''', ' , 
' camerastatus=', camerastatus,', ' , 
' https=', https,', ' , 
' cameramodel=', cameramodel,', ' , 
' dstvalue=', dstvalue,', ' , 
' dateupdated=''', dateupdated,''', ' , 
' companycode=''', companycode,''', ' , 
' countercameratype=''', countercameratype,''', ' , 
' iscountinallowup=', iscountinallowup,', ' , 
' updateddatetime=''', c.updateddatetime,''', ' , 
' companyserial=''', companyserial,''',' ,
' server=''', @destinationServer,'''' ,
' where serial=''', serial,''' end'
from ffcameras c
join ffbranches b
on c.branchid = b.id
where c.serial in (select serial from #tmpSerial);



--(2)[client] copy and paste the generated SQL script above to section below --



-------------------------------------------------------------------------------


--ffcamerasettings
--[4][meta] run the script below
select 'if not exists (select * from ffcamerasettings where cameraid = (select id from ffcameras where serial=''',(select serial from ffcameras where id=fc.cameraid) as counterserial, '''))
begin insert into ffcamerasettings (cameraid, invertin, linein, lineout, ignoreleft, ignoreright, sensitivity, radius, minsize, watershed, convexhull, morph, secondmorph, recording, roix, roiy, roiw, roih, enable, autoupdate, topline1y, bottomline1y, lastupdatedtimestamp, shoulderwidth, updatesource, timezone, ntpflag, netntp, localntp, heartbeat, liveview, softether, dataadjustment, whiteoptions, resolutionoption, fps, customline, inline, outline, rebootflag, engineeringlog, offset, wifithreshold, shopperthreshold, noisefilter, ceilingheight, humanminheight, humanmaxheight, floorspace, customfloorspace, startingzone, model, ratio, mode, prevzoomx, prevzoomy, prevzoomw, prevzoomh, maxarea, rotation, contrast, brightness, threshold, gaussian, morphy, sgbmsadwindow, offshifty, offshiftx, resolution, rotateleft, rotateright, leftup, dualscreen, floorcreation, personrecording, blobrecording, linecreation, floorthes, writefloor, zone, iszone, greennoise, debugmode, floorundefperc, floorundefstatus, floorundefpercref, floorundefpercthresh, floorundefpercthreshmaj, floorundefcountenable, floorundefenable, dooravgenable, dooravgref, dooravgthresh, doorzone, drawflag, idealsetting, cameradegree, leftintrinsic, rightintrinsic, leftdistortion, rightdistortion, scaledleftrrect, scaledleftintrinsicrect, scaledrightrrect, scaledrightintrinsicrect, q, isoui, xuturn, autodetectceilingheight, dmapadvance, disparity, mindisparity, uniquenessratio, prefiltercap, specklewindowsize, specklerange, disp12maxdiff, texturethreshold) values (
',
'(select id from ffcameras where serial=''',(select serial from ffcameras where id=fc.cameraid) as counterserial, '''), ',
invertin,',', linein,',', lineout,',', ignoreleft,',', ignoreright,',', sensitivity,',', radius,',', minsize,',', watershed,',', convexhull,',''',morph,''',''', secondmorph,''',', recording,',', roix,',', roiy,',', roiw,',', roih,',', enable,',', autoupdate,',', topline1y,',', bottomline1y,',''', lastupdatedtimestamp,''',', shoulderwidth,',', updatesource,',''', timezone,''',', ntpflag,',''', netntp,''',''', localntp, ''',', heartbeat,',', liveview,',', softether,',', dataadjustment,',''', whiteoptions,''',''', resolutionoption,''',', fps,',', customline, ',''', inline,''',''', outline,''',', rebootflag,',', engineeringlog,',''', offset,''',', wifithreshold,',', shopperthreshold,',', noisefilter,',', ceilingheight,',', humanminheight,',', humanmaxheight,',''', floorspace,''',', customfloorspace,',''', startingzone,''',', model,',', ratio,',', mode,',''', prevzoomx,''',''', prevzoomy,''',''', prevzoomw,''',''', prevzoomh,''',', maxarea,',', rotation,',', contrast,',', brightness,',', threshold,',', gaussian,',', morphy,',', sgbmsadwindow,',', offshifty,',', offshiftx,',''', resolution,''',''',rotateleft,''',''', rotateright,''',''', leftup,''',''', dualscreen,''',''', floorcreation,''',''', personrecording,''',''', blobrecording,''',''', linecreation,''',''', floorthes,''',''', writefloor,''',''', zone,''',''', iszone,''',''', greennoise,''',''', debugmode,''',''', floorundefperc,''',''', floorundefstatus,''',''', floorundefpercref,''',''', floorundefpercthresh,''',''', floorundefpercthreshmaj,''',''', floorundefcountenable,''',''', floorundefenable,''',''', dooravgenable,''',''', dooravgref,''',''', dooravgthresh,''',''', doorzone,''',''', drawflag,''',''', idealsetting,''',''', cameradegree,''',''', leftintrinsic,''',''', rightintrinsic,''',''', leftdistortion,''',''', rightdistortion,''',''',scaledleftrrect,''',''',  scaledleftintrinsicrect,''',''',  scaledrightrrect,''',''',  scaledrightintrinsicrect,''',''',  q,''',''',isoui,''',''', xuturn,''',''', autodetectceilingheight,''',''', dmapadvance,''',''', disparity,''',''', mindisparity,''',''', uniquenessratio,''',''', prefiltercap,''',''', specklewindowsize,''',''', specklerange,''',''', disp12maxdiff,''',''', texturethreshold,'''',') end', 
' else begin update ffcamerasettings ',
' set ',
' invertin=', invertin,', ' , ' linein=', linein,', ' , ' lineout=', lineout,', ' , ' ignoreleft=', ignoreleft,', ' , ' ignoreright=', ignoreright,', ' , ' sensitivity=', sensitivity,', ' , ' radius=', radius,', ' , ' minsize=', minsize,', ' , ' watershed=', watershed,', ' , ' convexhull=', convexhull,', ' , ' morph=''', morph,''', ' , ' secondmorph=''', secondmorph,''', ' , ' recording=', recording,', ' , ' roix=', roix,', ' , ' roiy=', roiy,', ' , ' roiw=', roiw,', ' , ' roih=', roih,', ' , ' enable=', enable,', ' , ' autoupdate=', autoupdate,', ' , ' topline1y=', topline1y,', ' , ' bottomline1y=', bottomline1y,', ' , ' lastupdatedtimestamp=''', lastupdatedtimestamp,''', ' , ' shoulderwidth=', shoulderwidth,', ' , ' updatesource=', updatesource,', ' , ' timezone=''', timezone,''', ' , ' ntpflag=', ntpflag,', ' , ' netntp=''', netntp,''', ' , ' localntp=''', localntp,''', ' , ' heartbeat=', heartbeat,', ' , ' liveview=', liveview,', ' , ' softether=', softether,', ' , ' dataadjustment=', dataadjustment,', ' , ' whiteoptions=''', whiteoptions,''', ' , ' resolutionoption=''', resolutionoption,''', ' , ' fps=', fps,', ' , ' customline=', customline,', ' , ' inline=''', inline,''', ' , ' outline=''', outline,''', ' , ' rebootflag=', rebootflag,', ' , ' engineeringlog=', engineeringlog,', ' , ' offset=''', offset,''', ' , ' wifithreshold=', wifithreshold,', ' , ' shopperthreshold=', shopperthreshold,', ' , ' noisefilter=', noisefilter,', ' , ' ceilingheight=', ceilingheight,', ' , ' humanminheight=', humanminheight,', ' , ' humanmaxheight=', humanmaxheight,', ' , ' floorspace=''', floorspace,''', ' , ' customfloorspace=', customfloorspace,', ' , ' startingzone=''', startingzone,''', ' , ' model=', model,', ' , ' ratio=', ratio,', ' , ' mode=', mode,', ' , ' prevzoomx=''', prevzoomx,''', ' , ' prevzoomy=''', prevzoomy,''', ' , ' prevzoomw=''', prevzoomw,''', ' , ' prevzoomh=''', prevzoomh,''', ' , ' maxarea=', maxarea,', ' , ' rotation=', rotation,', ' , ' contrast=', contrast,', ' , ' brightness=', brightness,', ' , ' threshold=', threshold,', ' , ' gaussian=', gaussian,', ' , ' morphy=', morphy,', ' , ' sgbmsadwindow=', sgbmsadwindow,', ' ,
' offshifty=', offshifty,', ' , ' offshiftx=', offshiftx,', ' , ' resolution=''', resolution,''', ' , ' rotateleft=''', rotateleft,''', ' , ' rotateright=''', rotateright,''', ' , ' leftup=''', leftup,''', ' , ' dualscreen=''', dualscreen,''', ' ,
' floorcreation=''', floorcreation,''', ' , ' personrecording=''', personrecording,''', ' , ' blobrecording=''', blobrecording,''', ' , ' linecreation=''', linecreation,''', ' , ' floorthes=''', floorthes,''', ' , ' writefloor=''', writefloor,''', ' , ' zone=''', zone,''', ' , ' iszone=''', iszone,''', ' , ' greennoise=''', greennoise,''', ' , ' debugmode=''', debugmode,''', ' , ' floorundefperc=''', floorundefperc,''', ' , ' floorundefstatus=''', floorundefstatus,''', ' , ' floorundefpercref=''', floorundefpercref,''', ' , ' floorundefpercthresh=''', floorundefpercthresh,''', ' , ' floorundefpercthreshmaj=''', floorundefpercthreshmaj,''', ' , ' floorundefcountenable=''', floorundefcountenable,''', ' , ' floorundefenable=''', floorundefenable,''', ' , ' dooravgenable=''', dooravgenable,''', ' , ' dooravgref=''', dooravgref,''', ' , ' dooravgthresh=''', dooravgthresh,''', ' , ' doorzone=''', doorzone,''', ' , ' drawflag=''', drawflag,''', ' , ' idealsetting=''', idealsetting,''', ' , ' cameradegree=''', cameradegree,''', ' , ' leftintrinsic=''', leftintrinsic,''', ' , ' rightintrinsic=''', rightintrinsic,''', ' , ' leftdistortion=''', leftdistortion,''', ' , ' rightdistortion=''', rightdistortion,''', ' , ' scaledleftrrect=''', scaledleftrrect,''', ' , ' scaledleftintrinsicrect=''', scaledleftintrinsicrect,''', ' , ' scaledrightrrect=''', scaledrightrrect,''', ' , ' scaledrightintrinsicrect=''', scaledrightintrinsicrect,''', ' , ' q=''', q,''', ' , ' isoui=''', isoui,''', ' , ' xuturn=''', xuturn,''', ' , ' autodetectceilingheight=''', autodetectceilingheight,''', ' , ' dmapadvance=''', dmapadvance,''', ' , ' disparity=''', disparity,''', ' , ' mindisparity=''', mindisparity,''', ' , ' uniquenessratio=''', uniquenessratio,''', ' , ' prefiltercap=''', prefiltercap,''', ' , ' specklewindowsize=''', specklewindowsize,''', ' , ' specklerange=''', specklerange,''', ' , ' disp12maxdiff=''', disp12maxdiff,''', ' , ' texturethreshold=''', texturethreshold,'''' ,
' where cameraid=(select id from ffcameras where serial=''',(select serial from ffcameras where id=fc.cameraid) as counterserial, ''') end'
--, *
from ffcamerasettings fc where cameraid in (select cameraid from #tmpSerial);


----------(3)[client]copy and paste the generated script above to section below ----------------



------------------------------------------------------------------------------------------------


--FFVideoSchedules
--[5][meta] run the script below
select 
'if not exists (select * from FFVideoSchedules where ffcameraid = (select id from ffcameras fc where fc.serial =''',(select serial from ffcameras where serial = fc.serial) as ffcameraid, ''') and filename = ''',fvs.filename,''')',' begin insert into FFVideoSchedules (ffcameraid, scheduledatetime, duration, sessionkey, timestamp, progress, status, verificationstudytimestamp, systemcountin, systemcountout, manualcountin, manualcountout, accuracyin, accuracyout, verifyby, companycode, overallcomment, filename) values (',
'(select id from ffcameras fc where fc.serial =''',
(select serial from ffcameras where serial = fc.serial) as ffcameraid, '''),',
'''',fvs.scheduledatetime,''',',
fvs.duration,',',
'''',fvs.sessionkey,''',',
fvs.timestamp,',',
fvs.progress,',',
fvs.status,',',
fvs.verificationstudytimestamp,',',
fvs.systemcountin,',',
fvs.systemcountout,',',
fvs.manualcountin,',',
fvs.manualcountout,',',
fvs.accuracyin,',',
fvs.accuracyout,',',
'''',fvs.verifyby,''',',
'''',fvs.companycode,''',',
'''',fvs.overallcomment,''',',
'''',fvs.filename,''') end'
from FFVideoSchedules fvs
right join ffcameras fc
on fvs.ffcameraid = fc.id
where ffcameraid in (select id from ffcameras where serial in (select serial from #tmpSerial)) 


----------(4)[client]copy and paste the generated script above to section below ----------------

------------------------------------------------------------------------------------------------


--FFVerificationStudyReports
--[6][meta] run the script below
select 
'if not exists (select * from ffverificationstudyreports where ffcameraid = (select id from ffcameras fc where fc.serial =''',(select serial from ffcameras where serial = fc.serial) as ffcameraid, ''') and timestamp = ''',fvsr.timestamp,''')',' begin insert into ffverificationstudyreports (ffcameraid, summary, createdby, timestamp, nooflog, overallaccuracyin, overallaccuracyout, overallsamplesizein, overallsamplesizeout, companycode, reporttype, reportdatatype, verifiedby) values (',
'(select id from ffcameras where serial =''',
(select serial from ffcameras where serial = fc.serial) as ffcameraid, '''),',
'N''',fvsr.summary,''',',
'''',fvsr.createdby,''',',
fvsr.timestamp,',',
fvsr.nooflog,',',
fvsr.overallaccuracyin,',',
fvsr.overallaccuracyout,',',
fvsr.overallsamplesizein,',',
fvsr.overallsamplesizeout,',',
'''',fvsr.companycode,''',',
fvsr.reporttype,',',
fvsr.reportdatatype,',',
'''',fvsr.verifiedby,''') end '
--,* 
from FFVerificationStudyReports fvsr
right join ffcameras fc
on fvsr.ffcameraid = fc.id
where ffcameraid in (
select id from ffcameras where serial in (select serial from #tmpSerial))



----------(5)[client]copy and paste the generated script above to section below ----------------


------------------------------------------------------------------------------------------------

--FFVerificationStudyReportVideos
--two sql scripts above must be run first as this table will take the foreign key from both the table above
--(6)[client] run the script below ON CLIENT SERVER
select 
'if not exists (select * from FFVerificationStudyReportVideos where ffvideoscheduleid=', fvs.id as ffvideoscheduleid,' and ffverificationstudyreportid=', fvsr.id as ffverificationstudyreportid, ') begin insert into FFVerificationStudyReportVideos values (', 
fvs.id as ffvideoscheduleid, ', ', 
fvsr.id as ffverificationstudyreportid,
') end '
from ffvideoschedules fvs
join ffverificationstudyreports fvsr
on fvs.ffcameraid = fvsr.ffcameraid
where fvs.status = 4 
and fvs.ffcameraid in (
select id from ffcameras where serial in (select serial from #tmpSerial)) 
and fvsr.ffcameraid in (
select id from ffcameras where serial in (select serial from #tmpSerial)) 

-- get input for file list --
select fvs.id as ffvideoscheduleid
into #tmpVerifiedVideoIDList
from ffvideoschedules fvs
join ffverificationstudyreports fvsr
on fvs.ffcameraid = fvsr.ffcameraid
where fvs.status = 4 
and fvs.ffcameraid in (
select id from ffcameras where serial in (select serial from #tmpSerial)) 
and fvsr.ffcameraid in (
select id from ffcameras where serial in (select serial from #tmpSerial)) 

--select * from #tmpVerifiedVideoIDList

select filename from ffvideoschedules where id in (select * from #tmpVerifiedVideoIDList)

drop table #tmpVerifiedVideoIDList

-----------------------------

--[7][meta] run the script below
-- verified counter and verified datetime
select row_number() over (order by ffcameraid) as row, ffcameraid, verifiedDateTime 
into #tmpVerifiedCounterDateTime
from (select id, ffcameraid, dateadd(s, vr.timestamp, '19700101') as verifiedDateTime, rank() over(partition by ffcameraid order by id desc) as [rowNumber]
from ffverificationstudyreports vr where id in (
select fvsr.id from ffcameras c 
join ffverificationstudyreports fvsr
on c.id = fvsr.ffcameraid
where 
c.serial in (select serial from #tmpSerial)
)) as tmpTable
where rowNumber = 1


--select * from #tmpVerifiedCounterDateTime 
declare @total int
declare @loop int
declare @tmpCameraID int
declare @tmpDateTime DateTime

create table #tmpFFCameraHourlyValues (ValueDateTime DateTime, OutsideTraffic int, ValueIn int, ValueOut int, ValueTimestamp DateTime, Timestamp nvarchar(max), Day int, CameraId int, PatchStatus nvarchar(max), ZoneCounting int, HeatMapStay int, HeatMapPassBy int, HeatMapAvgDwell int)

create table #tmpFFReportSummaryDailies (ID int, Date nvarchar(max), CameraId int, CameraName nvarchar(max), ValueIn int, ValueOut int, OutsideTraffic int, TurnInRate float, FifteenMinWifiCount int, ThirteenMinWifiCount int, OverWifiCount int, NewCustomer int, WeeklyCustomer int, MonthlyCustomer int, CustomerMacs nvarchar(max), WeeklyCustomerMacs nvarchar(max), MonthlyCustomerMacs nvarchar(max), BranchId int, CompanyId int, AverageDwellTime float, PatchStatus nvarchar(max), CrossShopper1 int, CrossShopper2 int, CrossShopper3 int, TopCrossShop1 int, TopCrossShop2 int, TopCrossShop3 int)

--getting hourly and daily data
set @loop = 1
select @total = count(row) from #tmpVerifiedCounterDateTime
while (@loop <= @total)
begin
	select @tmpCameraID = ffcameraid from #tmpVerifiedCounterDateTime where row = @loop
	select @tmpDateTime = verifiedDateTime from #tmpVerifiedCounterDateTime where row = @loop

	insert into #tmpFFCameraHourlyValues 
	select valuedatetime, outsidetraffic, valuein, valueout, valuetimestamp, timestamp, day, cameraid, patchstatus,zonecounting,heatmapstay,heatmappassby,heatmapavgdwell
	from ffcamerahourlyvalues where cameraid = @tmpCameraID and valuedatetime >= '2017-02-10 09:00:00.000'

	insert into #tmpFFReportSummaryDailies 
	select * from ffreportsummarydailies where cameraid = @tmpCameraID and date >=  DATEDIFF(day,'1970-01-01', @tmpDateTime)*86400

	select @loop = @loop + 1
end


--ffcamerahourlyvalues
--[8][meta] run the script below
select 
'if not exists (select * from ffcamerahourlyvalues where cameraid=(select id from ffcameras where serial=''',c.serial,''') and ValueDateTime=''',tchv.ValueDateTime,''')',
' begin insert into ffcamerahourlyvalues (valuedatetime, outsidetraffic, valuein, valueout, valuetimestamp, timestamp, day, cameraid, patchstatus, zonecounting, heatmapstay, heatmappassby, heatmapavgdwell) values (',
'''',tchv.valuedatetime,''',', tchv.outsidetraffic, ',',tchv.valuein, ',', tchv.valueout, ',''',tchv.valuetimestamp,''',', tchv.timestamp, ',',tchv.day, ', (select id from ffcameras where serial=''',c.serial,'''), ''', tchv.patchstatus, ''', ', tchv.zonecounting, ', ',tchv.heatmapstay, ', ', tchv.heatmappassby,', ', tchv.heatmapavgdwell
,') end'
--,tchv.*, c.serial 
from #tmpFFCameraHourlyValues tchv 
join ffcameras c 
on tchv.cameraid = c.id
order by tchv.cameraid, tchv.ValueDateTime


----------(7)[client]copy and paste the generated script above to section below ----------------



------------------------------------------------------------------------------------------------

--ffreportsummarydailies
--[9][meta] run the script below
select 
'if not exists (select * from ffreportsummarydailies where cameraid=(select id from ffcameras where serial=''',c.serial,''') and Date=',tcdv.Date,')',
' begin insert into ffreportsummarydailies (Date, CameraId, CameraName, ValueIn, ValueOut, OutsideTraffic, TurnInRate, FifteenMinWifiCount, ThirteenMinWifiCount, OverWifiCount, NewCustomer, WeeklyCustomer, MonthlyCustomer, CustomerMacs, WeeklyCustomerMacs, MonthlyCustomerMacs, BranchId, CompanyId, AverageDwellTime, PatchStatus, CrossShopper1, CrossShopper2, CrossShopper3, TopCrossShop1, TopCrossShop2, TopCrossShop3) values (',
Date, ', (select id from ffcameras where serial=''',c.serial,'''), ''', c.CameraName,''',', ValueIn, ',' ,ValueOut, ',', OutsideTraffic, ',', TurnInRate, ',', FifteenMinWifiCount, ',', ThirteenMinWifiCount, ',', OverWifiCount, ',', NewCustomer, ',', WeeklyCustomer, ',', MonthlyCustomer, ',''', CustomerMacs, ''',''', WeeklyCustomerMacs, ''',''', MonthlyCustomerMacs, ''',', '(select branchid from ffcameras where serial=''',c.serial,'''), ', '(select id from companies where companycode=''',c.companycode,'''), ', AverageDwellTime, ',''' , PatchStatus, ''',' , CrossShopper1, ',' , CrossShopper2, ',' , CrossShopper3, ',' , TopCrossShop1, ',' , TopCrossShop2, ',' , TopCrossShop3
, ') end'
--* 
from #tmpFFReportSummaryDailies tcdv
join ffcameras c
on tcdv.cameraid = c.id
order by tcdv.cameraid, tcdv.date

----------(8)[client]copy and paste the generated script above to section below ----------------



------------------------------------------------------------------------------------------------

drop table #tmpFFCameraHourlyValues 
drop table #tmpFFReportSummaryDailies
drop table #tmpVerifiedCounterDateTime

--[10][meta] run the script below, copy to section [final]--
select 'update ffcameras set server=''',@destinationServer, ''' where serial=''', serial,'''' from ffcameras where serial in (select serial from #tmpSerial)


--[final][meta] run the script below when ready to migrate to client server-- 


--------------------------------------

drop table #tmpSerial







