﻿function UpdateCounterData(DataPayload) {
    //console.log(dataPayload);
    if ((DataPayload.FFCamera !== undefined && DataPayload.FFCamera.Serial === "") || (DataPayload.CounterHealthCheck !== undefined && DataPayload.CounterHealthCheck.Serial === "")) {
        Alert(Message = {
            "Header": "Error",
            "Body": "Counter serial cannot be empty, update aborted.",
            "Footer": "<button class='btn btn-primary' data-dismiss='modal'>Close</button>"
        })
        return;
    }
    ShowLoadingPrompt("Update counter setting");
    var requestURL = "/Footfallcam/UpdateCounterData";
    var ajaxMethod = "POST"; //or POST etc
    $.ajax({
        type: ajaxMethod,
        url: requestURL,
        data: JSON.stringify(DataPayload),
        dataType: 'json',
        contentType: 'application/json',
        success: function (response) {
            if (response.IsSuccessful) {
                toastr.success("Update success", "Success");
            } else {
                toastr.error("Update failed", "Error");
            }
        },
        error: function (request, status, error) {
            toastr.error("Update failed", "Error");
            console.log(request);
            console.log(status);
            console.log(error);
        },
        complete: function () {
            HideLoadingPrompt();
        }
    });
}