﻿function DataTableGeneratePagingDOM(pagingDetails, filterDetails, tablePagingContainerSelector) {
    if (pagingDetails.TotalResult > 0) {
        console.log(pagingDetails);
        console.log(filterDetails);
        //console.log(tablePagingContainerSelector);
        var foundResult = "Found result: " + pagingDetails.TotalResult;
        var paging = pagingDetails;
        var pagingDOM = {
            pageCount: Math.ceil(paging.TotalResult / filterDetails.ItemPerPage),
            currentPage: filterDetails.PageNumber,
            HTML: "<div class='page-number-container'><span class='page-number' page-number=0>First</span>",
            NewHtml: "",
            pageFirstItemIndex: ((filterDetails.PageNumber - 1) * filterDetails.ItemPerPage) + 1,
            pageLastItemIndex: filterDetails.PageNumber == Math.ceil(paging.TotalResult / filterDetails.ItemPerPage) ? pagingDetails.TotalResult : filterDetails.PageNumber * filterDetails.ItemPerPage
        };
        pagingDOM.NewHtml = '<div id="tableInfoContainer">\
                                <div id="tableInfo">\
                                    <div class="info"><span class="rowStart">' + pagingDOM.pageFirstItemIndex + ' - <span class="rowEnd">' + pagingDOM.pageLastItemIndex + ' of <span class="rowTotal">' + pagingDetails.TotalResult + '</span></div>\
                                    </div>\
                                    <div id="pagination">\
                                        <div class="paginate_button previous"><span><i class="fa fa-chevron-left" aria-hidden="true"></i></span></div>\
                                        <div class="paginate_button next"><span><i class="fa fa-chevron-right" aria-hidden="true"></i></span></div>\
                                    </div>\
                                </div>';
        console.log(pagingDOM);
        for (var i = 0; i < pagingDOM.pageCount; i++) {
            var thisPageNumber = (i + 1);
            var isPageSelectedClass = filterDetails.PageNumber == thisPageNumber ? "page-selected" : "";
            pagingDOM.HTML += "<span class='page-number " + isPageSelectedClass + "' page-number=" + thisPageNumber + ">" + thisPageNumber + "</span>";
        }
        pagingDOM.HTML += "<span class='page-number' page-number=-1>Last</span></div>";
        $(tablePagingContainerSelector).html(pagingDOM.NewHtml);
    }
}