﻿function goBack() {
    window.history.back();
}

function enableExportCSV(enable, link) {
    enableExportCSV(enable, link, null);
}
function enableExportCSV(enable, link, filename) {
    if (enable) {
        if (link.indexOf(".csv") >= 0) {
            link = link.replace(".csv","");
        }

        if (link.indexOf(".xlsx") >= 0) {
            link = link.replace(".xlsx", "");
        }
        $("#divExport").show();

        $("#selectExport").off("change");
        $("#selectExport").val('export'); //reset to export text
        $("#selectExport").change(
            function () {
                switch (this.value) {
                    case "pdf":
                        window.open(link, '_blank');
                        break;
                    case "excel":
                        window.open(link + ".xlsx", '_blank');
                        break;
                    case "csv":
                    default:
                        window.open(link + ".csv", '_blank');
                        break;
                }
            });
    }
}

function setCookie(cookieName, cookieValue) {
    var today = new Date();
    var expire = new Date();
    expire.setTime(today.getTime() + 3600000 * 24 * 365);
    document.cookie = cookieName + "=" + escape(cookieValue) + ";path=/;expires=" + expire.toGMTString();
}

function getCookie(cookieName) {
    var theCookie = " " + document.cookie;
    var ind = theCookie.indexOf(" " + cookieName + "=");
    if (ind == -1) ind = theCookie.indexOf(";" + cookieName + "=");
    if (ind == -1 || cookieName == "") return "";
    var ind1 = theCookie.indexOf(";", ind + 1);
    if (ind1 == -1) ind1 = theCookie.length;
    return unescape(theCookie.substring(ind + cookieName.length + 2, ind1));
}

//call before generate chart for showing "generating report.."
function loadingChart(loadChart) {
    $('#' + loadChart).highcharts({
        chart: {
            plotBackgroundColor: null,
            plotBorderWidth: null,
            plotShadow: false,
            backgroundColor: 'rgba(255, 255, 255, 0.0)'
        }, credits: {
            enabled: false
        }, title: {
            text: ''
        }, loading: {
            labelStyle: {
                color: 'grey'
            }
        },
        exporting: {
            enabled: false
        }
    });

    chart = $('#' + loadChart).highcharts();
    if (chart)
        chart.showLoading(" ");
}
