﻿/*----------------------------------------------------------------------

[-----*** TABLE OF CONTENT ***-----]

Grid SparkLine Graph  (B03R / B04R)
G01R - Line Chart (Report) Template
G02R - Stacked Column Chart (Report) Template
G04R - Basic Column Chart (Report) Template
G05R - 100% Stacked Column Chart Template
G06R - Clustered Chart Template
G07R - Column Chart with Plot Band (Report) Template
T03R - Heatmap Table

-----------------------------------------------------------------------*/
//Grid SparkLine Graph (B03R / B04R)
var GridSparklineUtility = {

    RenderMultiSeriesChart: function (obj) {

        chart = new Highcharts.Chart({
            chart: {
                renderTo: $(obj.renderTo)[0],
                margin: [0, 0, 0, 0],
                backgroundColor: 'transparent'
            },
            title: {
                text: ''
            },
            credits: {
                enabled: false
            },
            xAxis: {
                maxPadding: 0,
                minPadding: 0,
                //min: 0.5,
                //max: 5.5,
                labels: {
                    enabled: false
                }
            },
            yAxis: {
                maxPadding: 0,
                minPadding: 0,
                gridLineWidth: 0,
                endOnTick: false,
                labels: {
                    enabled: false
                },
            },
            legend: {
                enabled: false
            },
            tooltip: {
                enabled: false
            },
            plotOptions: {
                series: {
                    enableMouseTracking: false,
                    lineWidth: 1,
                    shadow: false,
                    states: {
                        hover: {
                            lineWidth: 1
                        }
                    },
                    marker: {
                        radius: 0,
                        states: {
                            hover: {
                                radius: 2
                            }
                        }
                    }
                }
            },
            exporting: {
                enabled: false,
            },
            series: [{
                type: 'areaspline',
                data: obj.data,
                color: '#A0C1DB',
                borderWidth: 2,
                fillOpacity: 0.6
            }]
        });
        chart.reflow();

        $(obj.renderTo).addClass("g01");
    }
}

//G01D Line Chart (Dashboard) Template
var G01DUtility = {
    LineColorGenerator: function (counterCount) {
        var colorList = [
            //"rgba(35,31,32,1)",
            "rgba(63,123,172,1)",
            "rgba(94,145,186,1)",
            "rgba(139,181,215,1)",
            "rgba(203,221,234,1)",
            "rgba(64,171,175,1)",
            "rgba(142,210,206,1)",
            "rgba(234,114,71,1)",
            "rgba(249,170,123,1)",
            "rgba(241,189,87,1)",
            "rgba(249,222,168,1)",
            "rgba(140,116,169,1)",
            "rgba(202,189,219,1)",
            "rgba(138,199,89,1)",
            "rgba(193,222,155,1)",
        ];
        return colorList[counterCount];
    },
    ProcessCounterList: function (objList) {
        var PocessedCounterList = [];
        $.each(objList, function (i, counter) {
            var processedCounter = {
                name: counter.Name,
                data: counter.Data,
                color: G01DUtility.LineColorGenerator(i),
                zIndex: objList.length - i
            };
            PocessedCounterList.push(processedCounter);
        })
        return PocessedCounterList;
    },
    RenderMultiSeriesChart: function (obj) {

        chart = new Highcharts.Chart({
            chart: {
                renderTo: $(obj.renderTo)[0],
                //type: 'line',
                type: 'spline',
                backgroundColor: 'transparent',
            },
            credits: {
                enabled: false
            },
            exporting: {
                enabled: false
            },
            title: {
                text: obj.titleText,
                y: 17,
                floating: true,
                align: 'left',
                style: {
                    color: '#000',
                    fontSize: '14px',
                    "text-transform": 'uppercase',
                    fontFamily: "'Open Sans', sans-serif",
                    "font-weight": 'normal'
                }
            },
            xAxis: {
                type: 'datetime',
                dateTimeLabelFormats: {
                    millisecond: '%H:%M:%S.%L',
                    second: '%H:%M:%S',
                    minute: '%H:%M',
                    hour: '%H:%M',
                    day: '%e %b',
                    week: '%e %b',
                    month: '%b',
                    year: '%Y'
                },
                tickInterval: obj.xAxisTickInterval,
                tickWidth: 0,
                title: {
                    text: obj.xAxisText,
                    align: 'high',
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold'
                    }
                },
                labels: {
                    overflow: 'justify',
                    autoRotation: [-90],
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold',
                    },
                    formatter: obj.xAxisFormatter,
                },
            },
            yAxis: [{
                min: 0,
                max: obj.yAxisMaxValue,
                //tickAmount: 6,
                lineWidth: 1,
                gridLineWidth: 0,
                tickWidth: 0,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                startOnTick: false,
                endOnTick: false,
                maxPadding: 0.2,
                title: {
                    text: obj.yAxisText,
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold'
                    }
                },
                labels: {
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold',
                    },
                    formatter: function () {
                        if (this.value != 0) {
                            return this.value;
                        }
                    }
                },
                plotBands: [{ 
                    from: 0,
                    to: obj.plotBand1,
                    color: "rgba(201, 223, 185, 1)",
                    //label: {
                    //    text: 'Light air',
                    //    style: {
                    //        color: '#C9DFB9'
                    //    }
                    //}
                }, { 
                    from: obj.plotBand1,
                    to: obj.plotBand2,
                    color: "rgba(247, 206, 178, 1)",
                    //label: {
                    //    text: 'Light breeze',
                    //    style: {
                    //        color: '#606060'
                    //    }
                    //}
                }, {
                    from: obj.plotBand2,
                    to: obj.yAxisMaxValue,
                    color: "rgba(246, 156, 158, 1)",
                    //label: {
                    //    text: 'Gentle breeze',
                    //    style: {
                    //        color: '#606060'
                    //    }
                    //}
                }]
            }],
            legend: {
                itemStyle: {
                    color: '#4D5256',
                    fontSize: '9px',
                    fontFamily: "'Open Sans', sans-serif",
                    "font-weight": 'bold',
                },
                shadow: false,
                symbolRadius: 0,
                align: 'right',
                verticalAlign: 'top',
                borderWidth: 0,
                maxHeight: 40,
                navigation: {
                    activeColor: '#3E576F',
                    animation: true,
                    enabled: true,
                    arrowSize: 9,
                    inactiveColor: '#CCC',
                    style: {
                        fontWeight: 'bold',
                        color: '#333',
                        fontSize: '9px',
                    }
                }
            },
            tooltip: {
                shared: true,
                backgroundColor: 'rgba(60, 74, 89, 0.9)',
                style: {
                    color: '#fff',
                    fontSize: '9px',
                    fontFamily: "'Open Sans', sans-serif",
                    'font-weight': 'normal',
                },
                useHTML: true,
                headerFormat: '<span style="font-weight:bold; display:block; margin-bottom:5px;">{point.key}</span>',
                pointFormatter: function () {
                    var point = this,
                        series = point.series,
                        legendSymbol = "<svg width='9' height='9' style='margin:0px 5px;'><rect width='9' height='9' style='fill: " + this.series.color + "' /></svg>";

                    return "<span style='display:block; margin:2px 0px;'>" + legendSymbol + series.name + ": " + point.y + "</span>";

                },
                shadow: false,
            },
            plotOptions: {
                spline: {
                    marker: {
                        enabled: false,
                        symbol: 'circle',
                        radius: 2,
                        lineColor: null,
                        states: {
                            hover: {
                                radius: 2,
                                fillColor: '#F2BA4A',
                                lineColor: '#F2BA4A',
                            }
                        },
                    },
                    pointIntervalUnit: obj.plotOption.pointIntervalUnit, // For Day, Month or Year (default = undefined)
                    pointInterval: obj.plotOption.pointInterval, // For Hour or Week (default = undefined)
                    pointStart: obj.plotOption.pointStart,
                    lineWidth: 2,
                    dashStyle: 'shortdash',
                    states: {
                        hover: {
                            lineWidth: 2,
                            halo: {
                                size: 0
                            }
                        }
                    },
                },
            },
            series: G01DUtility.ProcessCounterList(obj.CounterList),
            responsive: {
                rules: [{
                    condition: {
                        maxWidth: 425
                    },
                    chartOptions: {
                        legend: {
                            align: 'left',
                            verticalAlign: 'top',
                            layout: 'horizontal'
                        },
                        title: {
                            floating: false,
                        },
                        yAxis: {
                            tickPixelInterval: 3,
                            title: {
                                text: null
                            }
                        }
                    }
                }]
            }
        });
        chart.reflow();

        var newHeight = $(obj.renderTo).closest(".grid-stack-item-content").height();
        var newWidth = $(obj.renderTo).closest(".grid-stack-item-content").width();
        chart.update({
            chart: {
                height: newHeight

            }
        });

        var chartTitle = $(obj.renderTo + " .highcharts-title")[0].getBoundingClientRect().width;
        var chartLegend = $(obj.renderTo + " .highcharts-legend")[0].getBoundingClientRect().width;
        var containerHalfWidth = newWidth / 2;

        if (chartTitle > containerHalfWidth || chartLegend > containerHalfWidth) {
            chart.update({
                legend: {
                    align: 'left',
                    verticalAlign: 'top',
                    layout: 'horizontal'
                },
                title: {
                    floating: false,
                },
            });
        } else {
            chart.update({
                legend: {
                    align: 'right',
                    verticalAlign: 'top',
                    layout: 'horizontal'
                },
                title: {
                    floating: true,
                },
            });
        }

        $(obj.renderTo).addClass("g01");
    }
}

//G01R Line Chart (Report) Template
var G01RUtility = {
    LineColorGenerator: function (counterCount) {
        var colorList = [
            "rgba(63,123,172,1)",
            "rgba(94,145,186,1)",
            "rgba(139,181,215,1)",
            "rgba(203,221,234,1)",
            "rgba(64,171,175,1)",
            "rgba(142,210,206,1)",
            "rgba(234,114,71,1)",
            "rgba(249,170,123,1)",
            "rgba(241,189,87,1)",
            "rgba(249,222,168,1)",
            "rgba(140,116,169,1)",
            "rgba(202,189,219,1)",
            "rgba(138,199,89,1)",
            "rgba(193,222,155,1)",
        ];
        return colorList[counterCount];
    },
    ProcessCounterList: function (objList) {
        var PocessedCounterList = [];
        $.each(objList, function (i, counter) {
            var processedCounter = {
                name: counter.Name,
                data: counter.Data,
                color: G01RUtility.LineColorGenerator(i),
                zIndex: objList.length - i
            };
            PocessedCounterList.push(processedCounter);
        })
        return PocessedCounterList;
    },
    RenderMultiSeriesChart: function (obj) {

        chart = new Highcharts.Chart({
            chart: {
                renderTo: $(obj.renderTo)[0],
                type: 'line',
                backgroundColor: 'transparent',
            },
            credits: {
                enabled: false
            },
            exporting: {
                enabled: false
            },
            title: {
                text: obj.titleText,
                y: 17,
                floating: true,
                align: 'left',
                style: {
                    color: '#000',
                    fontSize: '14px',
                    "text-transform": 'uppercase',
                    fontFamily: "'Open Sans', sans-serif",
                    "font-weight": 'normal'
                }
            },
            xAxis: {
                type: 'datetime',
                dateTimeLabelFormats: {
                    millisecond: '%H:%M:%S.%L',
                    second: '%H:%M:%S',
                    minute: '%H:%M',
                    hour: '%H:%M',
                    day: '%e %b',
                    week: '%e %b',
                    month: '%b',
                    year: '%Y'
                },
                tickInterval: obj.xAxisTickInterval,
                tickWidth: 0,
                title: {
                    text: obj.xAxisText,
                    align: 'high',
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold'
                    }
                },
                labels: {
                    overflow: 'justify',
                    autoRotation: [-90],
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold',
                    },
                    formatter: obj.xAxisFormatter,
                },
            },
            yAxis: [{
                min: 0,
                //tickAmount: 6,
                lineWidth: 1,
                gridLineWidth: 1,
                tickWidth: 1,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                startOnTick: false,
                endOnTick: false,
                maxPadding: 0.2,
                title: {
                    text: obj.yAxisText,
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold'
                    }
                },
                labels: {
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold',
                    },
                    formatter: function () {
                        if (this.value != 0) {
                            return this.value;
                        }
                    }
                },
            }],
            legend: {
                itemStyle: {
                    color: '#4D5256',
                    fontSize: '9px',
                    fontFamily: "'Open Sans', sans-serif",
                    "font-weight": 'bold',
                },
                shadow: false,
                symbolRadius: 0,
                align: 'right',
                verticalAlign: 'top',
                borderWidth: 0,
                maxHeight: 40,
                navigation: {
                    activeColor: '#3E576F',
                    animation: true,
                    enabled: true,
                    arrowSize: 9,
                    inactiveColor: '#CCC',
                    style: {
                        fontWeight: 'bold',
                        color: '#333',
                        fontSize: '9px',
                    }
                }
            },
            tooltip: {
                shared: true,
                backgroundColor: 'rgba(60, 74, 89, 0.9)',
                style: {
                    color: '#fff',
                    fontSize: '9px',
                    fontFamily: "'Open Sans', sans-serif",
                    'font-weight': 'normal',
                },
                useHTML: true,
                headerFormat: '<span style="font-weight:bold; display:block; margin-bottom:5px;">{point.key}</span>',
                pointFormatter: function () {
                    var point = this,
                        series = point.series,
                        legendSymbol = "<svg width='9' height='9' style='margin:0px 5px;'><rect width='9' height='9' style='fill: " + this.series.color + "' /></svg>";

                    return "<span style='display:block; margin:2px 0px;'>" + legendSymbol + series.name + ": " + point.y + "</span>";

                },
                shadow: false,
            },
            plotOptions: {
                line: {
                    marker: {
                        enabled: true,
                        symbol: 'circle',
                        radius: 1.8,
                        lineColor: null,
                        states: {
                            hover: {
                                radius: 2,
                                fillColor: '#F2BA4A',
                                lineColor: '#F2BA4A',
                            }
                        },
                    },
                    pointIntervalUnit: obj.plotOption.pointIntervalUnit, // For Day, Month or Year (default = undefined)
                    pointInterval: obj.plotOption.pointInterval, // For Hour or Week (default = undefined)
                    pointStart: obj.plotOption.pointStart,
                    lineWidth: 1.5,
                    states: {
                        hover: {
                            lineWidth: 1.5,
                            halo: {
                                size: 0
                            }
                        }
                    },
                },
            },
            series: G01RUtility.ProcessCounterList(obj.CounterList),
            responsive: {
                rules: [{
                    condition: {
                        maxWidth: 425
                    },
                    chartOptions: {
                        legend: {
                            align: 'left',
                            verticalAlign: 'top',
                            layout: 'horizontal'
                        },
                        title: {
                            floating: false,
                        },
                        yAxis: {
                            tickPixelInterval: 3,
                            title: {
                                text: null
                            }
                        }
                    }
                }]
            }
        });
        chart.reflow();
        
        var newHeight = $(obj.renderTo).closest(".grid-stack-item-content").height();
        var newWidth = $(obj.renderTo).closest(".grid-stack-item-content").width();
        chart.update({
            chart: {
                height: newHeight

            }
        });

        var chartTitle = $(obj.renderTo + " .highcharts-title")[0].getBoundingClientRect().width;
        var chartLegend = $(obj.renderTo + " .highcharts-legend")[0].getBoundingClientRect().width;
        var containerHalfWidth = newWidth / 2;

        if (chartTitle > containerHalfWidth || chartLegend > containerHalfWidth) {
            chart.update({
                legend: {
                    align: 'left',
                    verticalAlign: 'top',
                    layout: 'horizontal'
                },
                title: {
                    floating: false,
                },
            });
        } else {
            chart.update({
                legend: {
                    align: 'right',
                    verticalAlign: 'top',
                    layout: 'horizontal'
                },
                title: {
                    floating: true,
                },
            });
        }
        
        $(obj.renderTo).addClass("g01");
    }
}

//G02R - Stacked Column Chart (Report) Template
var G02RUtility = {
    columnColorGenerator: function (counterCount) {
        var colorList = [
            "rgba(63,123,172,1)",
            "rgba(94,145,186,1)",
            "rgba(139,181,215,1)",
            "rgba(203,221,234,1)",
            "rgba(64,171,175,1)",
            "rgba(142,210,206,1)",
            "rgba(234,114,71,1)",
            "rgba(249,170,123,1)",
            "rgba(241,189,87,1)",
            "rgba(249,222,168,1)",
            "rgba(140,116,169,1)",
            "rgba(202,189,219,1)",
            "rgba(138,199,89,1)",
            "rgba(193,222,155,1)",
        ];
        return colorList[counterCount];
    },
    ProcessCounterList: function (objList) {
        //console.log(objList);

        var PocessedCounterList = [];
        $.each(objList, function (i, counter) {
            var processedCounter = {
                name: counter.Name,
                data: counter.Data,
                color: G02RUtility.columnColorGenerator(i),
            };
            PocessedCounterList.push(processedCounter);
        })
        return PocessedCounterList;
    },
    RenderMultiSeriesChart: function (obj) {

        chart = new Highcharts.Chart({
            chart: {
                renderTo: $(obj.renderTo)[0],
                type: 'column',
                backgroundColor: 'transparent',
            },
            credits: {
                enabled: false
            },
            exporting: {
                enabled: false
            },
            title: {
                text: obj.titleText,
                y: 17,
                floating: true,
                align: 'left',
                style: {
                    color: '#000',
                    fontSize: '14px',
                    "text-transform": 'uppercase',
                    fontFamily: "'Open Sans', sans-serif",
                    "font-weight": 'normal'
                }
            },
            xAxis: {
                type: 'datetime',
                dateTimeLabelFormats: {
                    millisecond: '%H:%M:%S.%L',
                    second: '%H:%M:%S',
                    minute: '%H:%M',
                    hour: '%H:%M',
                    day: '%e %b',
                    week: '%e %b',
                    month: '%b',
                    year: '%Y'
                },
                tickInterval: obj.xAxisTickInterval,
                tickWidth: 0,
                title: {
                    text: obj.xAxisText,
                    align: 'high',
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold'
                    }
                },
                labels: {
                    autoRotation: [-90],
                    overflow: 'justify',
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold',
                    },
                    formatter: obj.xAxisFormatter,
                },
            },
            yAxis: [{
                min: 0,
                //tickAmount: 6,
                lineWidth: 1,
                gridLineWidth: 1,
                tickWidth: 1,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                startOnTick: false,
                endOnTick: false,
                maxPadding: 0.2,
                reversedStacks: false,
                title: {
                    text: obj.yAxisText,
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold,'
                    }
                },
                labels: {
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold',
                    },
                    formatter: function () {
                        if (this.value != 0) {
                            return this.value;
                        }
                    }
                },
            }],
            legend: {
                itemStyle: {
                    color: '#4D5256',
                    fontSize: '9px',
                    fontFamily: "'Open Sans', sans-serif",
                    "font-weight": 'bold',
                },
                shadow: false,
                symbolRadius: 0,
                align: 'right',
                verticalAlign: 'top',
                borderWidth: 0,
                maxHeight: 40,
                navigation: {
                    activeColor: '#3E576F',
                    animation: true,
                    enabled: true,
                    arrowSize: 9,
                    inactiveColor: '#CCC',
                    style: {
                        fontWeight: 'bold',
                        color: '#333',
                        fontSize: '9px',
                    }
                }
            },
            tooltip: {
                shared: true,
                backgroundColor: 'rgba(60, 74, 89, 0.9)',
                style: {
                    color: '#fff',
                    fontSize: '9px',
                    fontFamily: "'Open Sans', sans-serif",
                    'font-weight': 'normal',
                },
                shape: 'square',
                useHTML: true,
                headerFormat: '<span style="font-weight:bold; display:block; margin-bottom:5px;">{point.key}</span>',
                pointFormatter: function () {
                    var point = this,
                        series = point.series,
                        legendSymbol = "<svg width='9' height='9' style='margin:0px 5px;'><rect width='9' height='9' style='fill: " + this.series.color + "' /></svg>";

                    return "<span style='display:block; margin:2px 0px;'>" + legendSymbol + series.name + ": " + point.y + "</span>";

                },
                shadow: false,
            },
            plotOptions: {
                column: {
                    stacking: 'normal',
                    borderWidth: 0,
                    pointIntervalUnit: obj.plotOption.pointIntervalUnit, // For Day, Month or Year (default = undefined)
                    pointInterval: obj.plotOption.pointInterval, // For Hour or Week (default = undefined)
                    pointStart: obj.plotOption.pointStart,
                },
            },
            series: G02RUtility.ProcessCounterList(obj.CounterList),
            responsive: {
                rules: [{
                    condition: {
                        maxWidth: 425
                    },
                    chartOptions: {
                        legend: {
                            align: 'left',
                            verticalAlign: 'top',
                            layout: 'horizontal'
                        },
                        title: {
                            floating: false,
                        },
                        yAxis: {
                            tickPixelInterval: 3,
                            title: {
                                text: null
                            }
                        }
                    }
                }]
            }
        });
        chart.reflow();

        var newHeight = $(obj.renderTo).closest(".grid-stack-item-content").height();
        var newWidth = $(obj.renderTo).closest(".grid-stack-item-content").width();
        chart.update({
            chart: {
                height: newHeight

            }
        });

        var chartTitle = $(obj.renderTo + " .highcharts-title")[0].getBoundingClientRect().width;
        var chartLegend = $(obj.renderTo + " .highcharts-legend")[0].getBoundingClientRect().width;
        var containerHalfWidth = newWidth / 2;

        if (chartTitle > containerHalfWidth || chartLegend > containerHalfWidth) {
            chart.update({
                legend: {
                    align: 'left',
                    verticalAlign: 'top',
                    layout: 'horizontal'
                },
                title: {
                    floating: false,
                },
            });
        } else {
            chart.update({
                legend: {
                    align: 'right',
                    verticalAlign: 'top',
                    layout: 'horizontal'
                },
                title: {
                    floating: true,
                },
            });
        }

        $(obj.renderTo).addClass("g01");

    }
}

//G04R - Basic Column Chart (Report) Template
var G04RUtility = {
    columnColorGenerator: function (counterCount) {
        var colorList = [
            "rgba(63,123,172,1)",
            "rgba(94,145,186,1)",
            "rgba(139,181,215,1)",
            "rgba(203,221,234,1)",
            "rgba(64,171,175,1)",
            "rgba(142,210,206,1)",
            "rgba(234,114,71,1)",
            "rgba(249,170,123,1)",
            "rgba(241,189,87,1)",
            "rgba(249,222,168,1)",
            "rgba(140,116,169,1)",
            "rgba(202,189,219,1)",
            "rgba(138,199,89,1)",
            "rgba(193,222,155,1)",
        ];
        return colorList[counterCount];
    },
    ProcessCounterList: function (objList) {
        var PocessedCounterList = [];
        $.each(objList, function (i, counter) {
            var processedCounter = {
                name: counter.Name,
                data: counter.Data,
                color: G04RUtility.columnColorGenerator(i),
            };
            PocessedCounterList.push(processedCounter);
        })
        return PocessedCounterList;
    },
    RenderMultiSeriesChart: function (obj) {

        chart = new Highcharts.Chart({
            chart: {
                renderTo: $(obj.renderTo)[0],
                backgroundColor: 'transparent',
                type: 'column'
            },
            credits: {
                enabled: false
            },
            title: {
                text: obj.titleText,
                y: 17,
                floating: true,
                align: 'left',
                style: {
                    color: '#4D5256',
                    fontSize: '14px',
                    "text-transform": 'uppercase',
                    fontFamily: "'Open Sans', sans-serif",
                    "font-weight": 'normal'
                }
            },
            xAxis: {
                type: 'datetime',
                dateTimeLabelFormats: {
                    millisecond: '%H:%M:%S.%L',
                    second: '%H:%M:%S',
                    minute: '%H:%M',
                    hour: '%H:%M',
                    day: '%e %b',
                    week: '%e %b',
                    month: '%b %y',
                    year: '%Y'
                },
                tickInterval: obj.xAxisTickInterval,
                tickmarkPlacement: 'on',
                tickWidth: 0,
                title: {
                    text: obj.xAxisText,
                    align: 'high',
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold'
                    }
                },
                labels: {
                    overflow: 'justify',
                    autoRotation: [-90],
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold',
                    },
                    formatter: obj.xAxisFormatter,
                },
            },
            yAxis: [{
                min: 0,
                //tickAmount: 6,
                lineWidth: 1,
                gridLineWidth: 1,
                tickWidth: 1,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                startOnTick: false,
                endOnTick: false,
                maxPadding: 0.2,
                title: {
                    text: obj.yAxisText,
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold'
                    }
                },
                labels: {
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold',
                    },
                    formatter: obj.xAxisFormatter,
                },
            }],
            legend: {
                enabled: true,
                itemStyle: {
                    color: '#4D5256',
                    fontSize: '9px',
                    fontFamily: "'Open Sans', sans-serif",
                    "font-weight": 'bold',
                },
                shadow: false,
                symbolRadius: 0,
                align: 'right',
                verticalAlign: 'top',
                borderWidth: 0
            },
            tooltip: {
                shared: true,
                backgroundColor: 'rgba(60, 74, 89, 0.9)',
                style: {
                    color: '#fff',
                    fontSize: '9px',
                    fontFamily: "'Open Sans', sans-serif",
                    'font-weight': 'normal',
                },
                shape: 'square',
                useHTML: true,
                headerFormat: '<span style="font-weight:bold; display:block; margin-bottom:5px;">{point.key}</span>',
                pointFormatter: function () {
                    var point = this,
                        series = point.series,
                        legendSymbol = "<svg width='9' height='9' style='margin:0px 5px;'><rect width='9' height='9' style='fill: " + this.series.color + "' /></svg>";

                    return "<span style='display:block; margin:2px 0px;'>" + legendSymbol + series.name + ": " + point.y + "</span>";

                },
                shadow: false,
            },
            plotOptions: {
                column: {
                    //pointPadding: 0.2,
                    //borderWidth: 0
                },
                series: {
                    pointIntervalUnit: obj.plotOption.pointIntervalUnit, // For Day, Month or Year (default = undefined)
                    pointInterval: obj.plotOption.pointInterval, // For Hour or Week (default = undefined)
                    pointStart: obj.plotOption.pointStart,
                }
            },
            series: G04RUtility.ProcessCounterList(obj.CounterList),
            responsive: {
                rules: [{
                    condition: {
                        maxWidth: 425
                    },
                    chartOptions: {
                        legend: {
                            align: 'left',
                            verticalAlign: 'top',
                            layout: 'horizontal'
                        },
                        title: {
                            floating: false,
                        },
                        yAxis: {
                            tickPixelInterval: 3,
                            title: {
                                text: null
                            }
                        }
                    }
                }]
            }
        });
        chart.reflow();

        var newHeight = $(obj.renderTo).closest(".grid-stack-item-content").height();
        var newWidth = $(obj.renderTo).closest(".grid-stack-item-content").width();
        chart.update({
            chart: {
                height: newHeight

            }
        });

        var chartTitle = $(obj.renderTo + " .highcharts-title")[0].getBoundingClientRect().width;
        var chartLegend = $(obj.renderTo + " .highcharts-legend")[0].getBoundingClientRect().width;
        var containerHalfWidth = newWidth / 2;

        if (chartTitle > containerHalfWidth || chartLegend > containerHalfWidth) {
            chart.update({
                legend: {
                    align: 'left',
                    verticalAlign: 'top',
                    layout: 'horizontal'
                },
                title: {
                    floating: false,
                },
            });
        } else {
            chart.update({
                legend: {
                    align: 'right',
                    verticalAlign: 'top',
                    layout: 'horizontal'
                },
                title: {
                    floating: true,
                },
            });
        }

        $(obj.renderTo).addClass("g01");

    }
}

//G05R - 100% Stacked Column Chart Template
var G05RUtility = {
    columnColorGenerator: function (counterCount) {
        var colorList = [
            "rgba(63,123,172,1)",
            "rgba(94,145,186,1)",
            "rgba(139,181,215,1)",
            "rgba(203,221,234,1)",
            "rgba(64,171,175,1)",
            "rgba(142,210,206,1)",
            "rgba(234,114,71,1)",
            "rgba(249,170,123,1)",
            "rgba(241,189,87,1)",
            "rgba(249,222,168,1)",
            "rgba(140,116,169,1)",
            "rgba(202,189,219,1)",
            "rgba(138,199,89,1)",
            "rgba(193,222,155,1)",
        ];
        return colorList[counterCount];
    },
    ProcessCounterList: function (objList) {
        var PocessedCounterList = [];
        $.each(objList, function (i, counter) {
            var processedCounter = {
                name: counter.Name,
                data: counter.Data,
                color: G05RUtility.columnColorGenerator(i),
            };
            PocessedCounterList.push(processedCounter);
        })
        return PocessedCounterList;
    },
    RenderMultiSeriesChart: function (obj) {

        chart = new Highcharts.Chart({
            chart: {
                renderTo: $(obj.renderTo)[0],
                type: 'column',
                backgroundColor: 'transparent',
            },
            credits: {
                enabled: false
            },
            title: {
                text: obj.titleText,
                y: 17,
                floating: true,
                align: 'left',
                style: {
                    color: '#000',
                    fontSize: '14px',
                    "text-transform": 'uppercase',
                    fontFamily: "'Open Sans', sans-serif",
                    "font-weight": 'normal'
                }
            },
            xAxis: {
                type: 'datetime',
                dateTimeLabelFormats: {
                    millisecond: '%H:%M:%S.%L',
                    second: '%H:%M:%S',
                    minute: '%H:%M',
                    hour: '%H:%M',
                    day: '%e %b',
                    week: '%e %b',
                    month: '%b %y',
                    year: '%Y'
                },
                tickInterval: obj.xAxisTickInterval,
                tickWidth: 0,
                title: {
                    text: obj.xAxisText,
                    align: 'high',
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold'
                    }
                },
                labels: {
                    overflow: 'justify',
                    autoRotation: [-90],
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold',
                    },
                    formatter: obj.xAxisFormatter,
                },
            },
            yAxis: [{
                min: 0,
                //tickAmount: 6,
                lineWidth: 1,
                gridLineWidth: 1,
                tickWidth: 1,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                startOnTick: false,
                endOnTick: false,
                maxPadding: 0.2,
                reversedStacks: false,
                title: {
                    text: obj.yAxisText,
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold'
                    }
                },
                labels: {
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold',
                    },
                    formatter: function () {
                        return this.value + "%";
                    }
                },
            }],
            legend: {
                itemStyle: {
                    color: '#4D5256',
                    fontSize: '9px',
                    fontFamily: "'Open Sans', sans-serif",
                    "font-weight": 'bold',
                },
                shadow: false,
                symbolRadius: 0,
                align: 'right',
                verticalAlign: 'top',
                borderWidth: 0
            },
            tooltip: {
                xDateFormat: '%H:%M',
                shared: true,
                backgroundColor: 'rgba(60, 74, 89, 0.9)',
                style: {
                    color: '#fff',
                    fontSize: '9px',
                    fontFamily: "'Open Sans', sans-serif",
                    'font-weight': 'normal',
                },
                shape: 'square',
                useHTML: true,
                headerFormat: '<span style="font-weight:bold; display:block; margin-bottom:5px;">{point.key}</span>',
                pointFormatter: function () {
                    var point = this,
                        series = point.series,
                        legendSymbol = "<svg width='9' height='9' style='margin:0px 5px;'><rect width='9' height='9' style='fill: " + this.series.color + "' /></svg>";

                    return "<span style='display:block; margin:2px 0px;'>" + legendSymbol + series.name + ": " + point.y + "</span>";

                },
                shadow: false,
            },
            plotOptions: {
                column: {
                    stacking: 'percent',
                    borderWidth: 0,
                    pointIntervalUnit: obj.plotOption.pointIntervalUnit, // For Day, Month or Year (default = undefined)
                    pointInterval: obj.plotOption.pointInterval, // For Hour or Week (default = undefined)
                    pointStart: obj.plotOption.pointStart,
                },
            },
            series: G05RUtility.ProcessCounterList(obj.CounterList),
            responsive: {
                rules: [{
                    condition: {
                        maxWidth: 425
                    },
                    chartOptions: {
                        legend: {
                            align: 'left',
                            verticalAlign: 'top',
                            layout: 'horizontal'
                        },
                        title: {
                            floating: false,
                        },
                        yAxis: {
                            tickPixelInterval: 3,
                            title: {
                                text: null
                            }
                        }
                    }
                }]
            }
        });
        chart.reflow();

        var newHeight = $(obj.renderTo).closest(".grid-stack-item-content").height();
        var newWidth = $(obj.renderTo).closest(".grid-stack-item-content").width();
        chart.update({
            chart: {
                height: newHeight

            }
        });

        var chartTitle = $(obj.renderTo + " .highcharts-title")[0].getBoundingClientRect().width;
        var chartLegend = $(obj.renderTo + " .highcharts-legend")[0].getBoundingClientRect().width;
        var containerHalfWidth = newWidth / 2;

        if (chartTitle > containerHalfWidth || chartLegend > containerHalfWidth) {
            chart.update({
                legend: {
                    align: 'left',
                    verticalAlign: 'top',
                    layout: 'horizontal'
                },
                title: {
                    floating: false,
                },
            });
        } else {
            chart.update({
                legend: {
                    align: 'right',
                    verticalAlign: 'top',
                    layout: 'horizontal'
                },
                title: {
                    floating: true,
                },
            });
        }

        $(obj.renderTo).addClass("g01");

    }
}

//G06R - Clustered Chart Template
var G06RUtility = {
    columnColorGenerator: function (counterCount) {
        var colorList = [
            //"rgba(139,181,215,1)",
            //"rgba(94,145,186,1)",
            "rgba(63,123,172,1)",
            "rgba(94,145,186,1)",
            "rgba(139,181,215,1)",
            "rgba(203,221,234,1)",
            "rgba(64,171,175,1)",
            "rgba(142,210,206,1)",
            "rgba(234,114,71,1)",
            "rgba(249,170,123,1)",
            "rgba(241,189,87,1)",
            "rgba(249,222,168,1)",
            "rgba(140,116,169,1)",
            "rgba(202,189,219,1)",
            "rgba(138,199,89,1)",
            "rgba(193,222,155,1)",
        ];
        return colorList[counterCount];
    },
    ProcessCounterList: function (objList) {
        var PocessedCounterList = [];
        $.each(objList, function (i, counter) {
            var processedCounter = {
                type: counter.type,
                yAxis: counter.yAxis,
                name: counter.Name,
                data: counter.Data,
                color: G06RUtility.columnColorGenerator(i),
                zIndex: i + 1,
            };
            PocessedCounterList.push(processedCounter);
        })
        return PocessedCounterList;
    },
    RenderMultiSeriesChart: function (obj) {

        chart = new Highcharts.Chart({
            chart: {
                renderTo: $(obj.renderTo)[0],
                backgroundColor: 'transparent',
                //events: {
                //    load: function () {
                //        chartEvent[3] = this;
                //    }
                //}
            },
            credits: {
                enabled: false
            },
            title: {
                text: obj.titleText,
                y: 17,
                floating: true,
                align: 'left',
                style: {
                    color: '#000',
                    fontSize: '14px',
                    "text-transform": 'uppercase',
                    fontFamily: "'Open Sans', sans-serif",
                    "font-weight": 'normal'
                }
            },
            xAxis: {
                type: 'datetime',
                dateTimeLabelFormats: {
                    millisecond: '%H:%M:%S.%L',
                    second: '%H:%M:%S',
                    minute: '%H:%M',
                    hour: '%H:%M',
                    day: '%e %b',
                    week: '%e %b',
                    month: '%b %y',
                    year: '%Y'
                },
                tickInterval: obj.xAxisTickInterval,
                tickWidth: 0,
                title: {
                    text: obj.xAxisText,
                    align: 'high',
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold'
                    }
                },
                labels: {
                    overflow: 'justify',
                    autoRotation: [-90],
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold',
                    }
                },
            },
            yAxis: [{
                min: 0,
                tickAmount: 6,
                lineWidth: 1,
                //gridLineWidth: 1,
                tickWidth: 1,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                startOnTick: false,
                endOnTick: false,
                maxPadding: 0.2,
                title: {
                    text: obj.yAxisText1,
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold'
                    }
                },
                labels: {
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold',
                    },
                    formatter: function () {
                        if (this.value != 0) {
                            return this.value;
                        }
                    }
                },
            }, {
                min: 0,
                //max: 100,
                tickAmount: 6,
                lineWidth: 1,
                //gridLineWidth: 1,
                tickWidth: 1,
                //tickPixelInterval: 15,
                tickPosition: 'inside',
                startOnTick: false,
                endOnTick: false,
                maxPadding: 0.2,
                title: {
                    text: obj.yAxisText2,
                    rotation: "-90",
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold'
                    }
                },
                labels: {
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold',
                    },
                    //formatter: function () {
                    //    if (this.value != 0) {
                    //        var value = this.value
                    //        return value + "%";
                    //    }
                    //}
                    formatter: function () {
                        if (this.value != 0) {
                            return this.value;
                        }
                    }
                },
                opposite: true
            }],
            legend: {
                itemStyle: {
                    color: '#4D5256',
                    fontSize: '9px',
                    fontFamily: "'Open Sans', sans-serif",
                    "font-weight": 'bold',
                },
                shadow: false,
                symbolRadius: 0,
                align: 'right',
                verticalAlign: 'top',
                borderWidth: 0
            },
            tooltip: {
                shared: true,
                backgroundColor: 'rgba(60, 74, 89, 0.9)',
                style: {
                    color: '#fff',
                    fontSize: '9px',
                    fontFamily: "'Open Sans', sans-serif",
                    'font-weight': 'normal',
                },
                shape: 'square',
                useHTML: true,
                headerFormat: '<span style="font-weight:bold; display:block; margin-bottom:5px;">{point.key}</span>',
                pointFormatter: function () {
                    var point = this,
                        series = point.series,
                        legendSymbol = "<svg width='9' height='9' style='margin:0px 5px;'><rect width='9' height='9' style='fill: " + this.series.color + "' /></svg>";

                    return "<span style='display:block; margin:2px 0px;'>" + legendSymbol + series.name + ": " + point.y + "</span>";

                },
                shadow: false,
            },
            plotOptions: {
                column: {
                    //stacking: 'normal',
                    pointPadding: 0.2, // if series spacing too large remove this
                    borderWidth: 0,
                },
                series: {
                    marker: {
                        enabled: false,
                        states: {
                            hover: {
                                enabled: true,
                                radius: 5,
                                halo: {
                                    size: 0
                                },
                            }
                        },
                    },
                    lineWidth: 1,
                    states: {
                        hover: {
                            lineWidth: 1,
                        }
                    },
                    pointIntervalUnit: obj.plotOption.pointIntervalUnit, // For Day, Month or Year (default = undefined)
                    pointInterval: obj.plotOption.pointInterval, // For Hour or Week (default = undefined)
                    pointStart: obj.plotOption.pointStart,
                }
            },
            series: G06RUtility.ProcessCounterList(obj.CounterList),
            responsive: {
                rules: [{
                    condition: {
                        maxWidth: 425
                    },
                    chartOptions: {
                        legend: {
                            align: 'left',
                            verticalAlign: 'top',
                            layout: 'horizontal'
                        },
                        title: {
                            floating: false,
                        },
                        yAxis: {
                            tickPixelInterval: 3,
                            title: {
                                text: null
                            }
                        }
                    }
                }]
            }
        });
        chart.reflow();

        var newHeight = $(obj.renderTo).closest(".grid-stack-item-content").height();
        var newWidth = $(obj.renderTo).closest(".grid-stack-item-content").width();
        chart.update({
            chart: {
                height: newHeight

            }
        });

        var chartTitle = $(obj.renderTo + " .highcharts-title")[0].getBoundingClientRect().width;
        var chartLegend = $(obj.renderTo + " .highcharts-legend")[0].getBoundingClientRect().width;
        var containerHalfWidth = newWidth / 2;

        if (chartTitle > containerHalfWidth || chartLegend > containerHalfWidth) {
            chart.update({
                legend: {
                    align: 'left',
                    verticalAlign: 'top',
                    layout: 'horizontal'
                },
                title: {
                    floating: false,
                },
            });
        } else {
            chart.update({
                legend: {
                    align: 'right',
                    verticalAlign: 'top',
                    layout: 'horizontal'
                },
                title: {
                    floating: true,
                },
            });
        }

        $(obj.renderTo).addClass("g01");

    }
}

//G07R - Column Chart with Plot Band (Report) Template
var G07RUtility = {
    columnColorGenerator: function (counterCount) {
        var colorList = [
            "rgba(139,181,215,1)",//remove this when migrate to master
            "rgba(63,123,172,1)",
            "rgba(94,145,186,1)",
            "rgba(139,181,215,1)",
            "rgba(203,221,234,1)",
            "rgba(64,171,175,1)",
            "rgba(142,210,206,1)",
            "rgba(234,114,71,1)",
            "rgba(249,170,123,1)",
            "rgba(241,189,87,1)",
            "rgba(249,222,168,1)",
            "rgba(140,116,169,1)",
            "rgba(202,189,219,1)",
            "rgba(138,199,89,1)",
            "rgba(193,222,155,1)",
        ];
        return colorList[counterCount];
    },
    ProcessCounterList: function (objList) {
        var PocessedCounterList = [];
        $.each(objList, function (i, counter) {
            var processedCounter = {
                name: counter.Name,
                data: counter.Data,
                color: G07RUtility.columnColorGenerator(i),
            };
            PocessedCounterList.push(processedCounter);
        })
        return PocessedCounterList;
    },
    RenderMultiSeriesChart: function (obj) {

        chart = new Highcharts.Chart({
            chart: {
                renderTo: $(obj.renderTo)[0],
                backgroundColor: 'transparent',
                type: 'column',
                marginTop: 65
            },
            credits: {
                enabled: false
            },
            title: {
                text: obj.titleText,
                y: 17,
                floating: true,
                align: 'left',
                style: {
                    color: '#4D5256',
                    fontSize: '14px',
                    "text-transform": 'uppercase',
                    fontFamily: "'Open Sans', sans-serif",
                    "font-weight": 'normal'
                }
            },
            xAxis: {
                type: 'datetime',
                dateTimeLabelFormats: {
                    millisecond: '%H:%M:%S.%L',
                    second: '%H:%M:%S',
                    minute: '%H:%M',
                    hour: '%H:%M',
                    day: '%e %b',
                    week: '%e %b',
                    month: '%b %y',
                    year: '%Y'
                },
                tickInterval: obj.xAxisTickInterval,
                tickmarkPlacement: 'on',
                tickWidth: 0,
                title: {
                    text: obj.xAxisText,
                    align: 'high',
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold'
                    }
                },
                labels: {
                    overflow: 'justify',
                    autoRotation: [-90],
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold',
                    }
                },
                plotLines: [{
                    color: "#2A3033",
                    width: 2,
                    value: obj.plotBandStartDate,
                    zIndex: 3,
                    dashStyle: 'shortDot',
                    label: {
                        useHTML: true,
                        text: "Start",
                        align: 'center',
                        style: {
                            "background-color": "#2A3033",
                            "padding": "2px 10px",
                            "font-size": "10px",
                            color: 'white',
                            "text-transform": 'uppercase',
                            fontFamily: "'Open Sans', sans-serif",
                            "font-weight": '600'
                        },
                        rotation: 0,
                        y: -10,
                        x: -12,
                        zIndex: 3
                    }
                }, {
                    color: "#2A3033",
                    width: 2,
                    value: obj.plotBandEndDate,
                    dashStyle: 'shortDot',
                    zIndex: 3,
                    label: {
                        useHTML: true,
                        text: "End",
                        align: 'center',
                        style: {
                            "background-color": "#2A3033",
                            "padding": "2px 10px",
                            "font-size": "10px",
                            color: 'white',
                            "text-transform": 'uppercase',
                            fontFamily: "'Open Sans', sans-serif",
                            "font-weight": '600'
                        },
                        rotation: 0,
                        y: -10,
                        x: -10,
                        zIndex: 3
                    }
                }],

                plotBands: [{
                    color: 'transparent',
                    from: obj.startDate,
                    to: obj.plotBandStartDate,
                    zIndex: 5,
                    label: {
                        text: obj.plotBandLabel1,
                        align: 'center',
                        style: {
                            fontSize: '12px',
                            color: '#292F33',
                            fontFamily: "'Open Sans', sans-serif",
                            "font-weight": '600'
                        },
                        rotation: 0,
                        y: -8,
                        x: 0
                    }
                }, {
                    color: 'transparent',
                    from: obj.plotBandStartDate,
                    to: obj.plotBandEndDate,
                    zIndex: 5,
                    label: {
                        text: obj.plotBandLabel2,
                        align: 'center',
                        style: {
                            fontSize: '12px',
                            color: '#292F33',
                            fontFamily: "'Open Sans', sans-serif",
                            "font-weight": '600'
                        },
                        rotation: 0,
                        y: -8,
                        x: 0
                    }
                }, {
                    color: 'transparent',
                    from: obj.plotBandEndDate,
                    to: obj.endDate,
                    zIndex: 5,
                    label: {
                        text: obj.plotBandLabel3,
                        align: 'center',
                        style: {
                            fontSize: '12px',
                            color: '#292F33',
                            fontFamily: "'Open Sans', sans-serif",
                            "font-weight": '600'
                        },
                        rotation: 0,
                        y: -8,
                        x: 0
                    }
                }],
            },
            yAxis: [{
                min: 0,
                //tickAmount: 6,
                lineWidth: 1,
                gridLineWidth: 1,
                tickWidth: 1,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                startOnTick: false,
                endOnTick: false,
                maxPadding: 0.2,
                title: {
                    text: obj.yAxisText,
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold'
                    }
                },
                labels: {
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold',
                    },
                    formatter: function () {
                        if (this.value != 0) {
                            return this.value;
                        }
                    }
                },
            }],
            legend: {
                enabled: true,
                itemStyle: {
                    color: '#4D5256',
                    fontSize: '9px',
                    fontFamily: "'Open Sans', sans-serif",
                    "font-weight": 'bold',
                },
                shadow: false,
                symbolRadius: 0,
                align: 'right',
                verticalAlign: 'top',
                borderWidth: 0
            },
            tooltip: {
                shared: true,
                backgroundColor: 'rgba(60, 74, 89, 0.9)',
                style: {
                    color: '#fff',
                    fontSize: '9px',
                    fontFamily: "'Open Sans', sans-serif",
                    'font-weight': 'normal',
                },
                shape: 'square',
                useHTML: true,
                headerFormat: '<span style="font-weight:bold; display:block; margin-bottom:5px;">{point.key}</span>',
                pointFormatter: function () {
                    var point = this,
                        series = point.series,
                        legendSymbol = "<svg width='9' height='9' style='margin:0px 5px;'><rect width='9' height='9' style='fill: " + this.series.color + "' /></svg>";

                    return "<span style='display:block; margin:2px 0px;'>" + legendSymbol + series.name + ": " + point.y + "</span>";

                },
                shadow: false,
                zIndex: 10
            },
            plotOptions: {
                column: {
                    //pointPadding: 0.2,
                    //borderWidth: 0
                },
                series: {
                    pointIntervalUnit: obj.plotOption.pointIntervalUnit, // For Day, Month or Year (default = undefined)
                    pointInterval: obj.plotOption.pointInterval, // For Hour or Week (default = undefined)
                    pointStart: obj.plotOption.pointStart,
                }
            },
            series: G07RUtility.ProcessCounterList(obj.CounterList),
            responsive: {
                rules: [{
                    condition: {
                        maxWidth: 425
                    },
                    chartOptions: {
                        legend: {
                            align: 'left',
                            verticalAlign: 'top',
                            layout: 'horizontal'
                        },
                        title: {
                            floating: false,
                        },
                        yAxis: {
                            tickPixelInterval: 3,
                            title: {
                                text: null
                            }
                        }
                    }
                }]
            }
        });
        chart.reflow();

        var newHeight = $(obj.renderTo).closest(".grid-stack-item-content").height();
        var newWidth = $(obj.renderTo).closest(".grid-stack-item-content").width();
        chart.update({
            chart: {
                height: newHeight

            }
        });

        var chartTitle = $(obj.renderTo + " .highcharts-title")[0].getBoundingClientRect().width;
        var chartLegend = $(obj.renderTo + " .highcharts-legend")[0].getBoundingClientRect().width;
        var containerHalfWidth = newWidth / 2;

        if (chartTitle > containerHalfWidth || chartLegend > containerHalfWidth) {
            chart.update({
                legend: {
                    align: 'left',
                    verticalAlign: 'top',
                    layout: 'horizontal'
                },
                title: {
                    floating: false,
                },
            });
        } else {
            chart.update({
                legend: {
                    align: 'right',
                    verticalAlign: 'top',
                    layout: 'horizontal'
                },
                title: {
                    floating: true,
                },
            });
        }

        $(obj.renderTo).addClass("g01");

    }
}

//T03R - Heatmap Table
var T03RUtility = {
    RenderMultiSeriesChart: function (obj) {
        chart = new Highcharts.Chart({

            chart: {
                renderTo: $(obj.renderTo)[0],
                type: 'heatmap',
                plotBorderWidth: 0
            },
            credits: {
                enabled: false
            },
            title: {
                text: obj.titleText,
                y: 17,
                floating: true,
                align: 'left',
                style: {
                    color: '#4D5256',
                    fontSize: '14px',
                    "text-transform": 'uppercase',
                    fontFamily: "'Open Sans', sans-serif",
                    "font-weight": 'normal'
                }
            },
            xAxis: {
                categories: obj.xAxisCategories,
                //type: 'datetime',
                //dateTimeLabelFormats: {
                //    millisecond: '%H:%M:%S.%L',
                //    second: '%H:%M:%S',
                //    minute: '%H:%M',
                //    hour: '%H:%M',
                //    day: '%e %b %Y',
                //    week: '%e %b',
                //    month: '%b %y',
                //    year: '%Y'
                //},
                //tickInterval: 24 * 3600 * 1000,
                lineColor: '#FFFFFF',
                tickColor: '#FFFFFF',
                gridLineWidth: 0,
                opposite: true,
                labels: {
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold',
                    },
                },
            },

            yAxis: {
                categories: obj.yAxisCategories,
                reversed: true,
                title: null,
                gridLineWidth: 0,
                labels: {
                    style: {
                        color: '#7B7B7A',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold',
                    },
                },
            },

            colorAxis: {
                min: 0,
                max: obj.maxValue,
                tickInterval: obj.maxValue,
                gridLineWidth: 0,
                //step: 4,
                stops: [
                    [0.0, '#CADDEA'],
                    [0.25, '#B4CEE0'],
                    [0.5, '#A8C5DB'],
                    [0.75, '#95B7D2'],
                    [0.99, '#86ADCC']
                ],
                labels: {
                    style: {
                        color: '#4D5256',
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold',
                    },
                }
            },
            tooltip: {
                enabled: false
            },
            legend: {
                align: 'right',
                layout: 'horizontal',
                margin: 0,
                verticalAlign: 'top',
                symbolWidth: 150,
                itemStyle: {
                    color: '#4D5256',
                    fontSize: '9px',
                    fontFamily: "'Open Sans', sans-serif",
                    "font-weight": 'bold',
                },
            },
            plotOptions: {
                //heatmap: {
                //    /*pointIntervalUnit: 'day',*/ // For Day, Month or Year (default = undefined)
                //    //pointStart: Date.UTC(2020, 5, 5, 0, 0, 0),
                //    pointStart: Date.UTC(2010, 0, 1),
                //    pointInterval: 24 * 3600 * 1000 // one day
                //},
            },
            series: [{
                name: 'Visitor Total By Hour',
                borderWidth: 5,
                borderColor: '#FFFFFF',
                data: obj.data,
                dataLabels: {
                    enabled: true,
                    color: '#4D5256',
                    style: {
                        fontSize: '9px',
                        fontFamily: "'Open Sans', sans-serif",
                        "font-weight": 'bold',
                        textOutline: 0,
                    },
                    states: {
                        hover: {
                            color: '#e0ebf3',
                            //borderColor: 'gray'
                        }
                    },
                    format: '{point.value:,.0f}'
                },
            }],
            responsive: {
                rules: [{
                    condition: {
                        maxWidth: 500
                    },
                    chartOptions: {
                        legend: {
                            align: 'left',
                            verticalAlign: 'top',
                            layout: 'horizontal'
                        },
                        title: {
                            floating: false,
                        },
                    }
                }]
            }

        });
        chart.reflow();

        var newHeight = $(obj.renderTo).closest(".grid-stack-item-content").height();
        var newWidth = $(obj.renderTo).closest(".grid-stack-item-content").width();
        chart.update({
            chart: {
                height: newHeight
            }
        });

        $(obj.renderTo).addClass("g01");
    }
}