﻿function graph(labels, data, options, isShowOut) {

    isShowOut = isShowOut || false;

    var data;

    if (!isShowOut) {
        data =
            { labels: labels,
                datasets: [{
                    label: "My First dataset",
                    fillColor: "#a4cd76",
                    strokeColor: "#75b03a",
                    highlightFill: "#a4cd76",
                    highlightStroke: "#75b03a",
                    data: data[0],
                    title: "In"
                }
            ]
            };
    }
    else {
        data =
            { labels: labels,
                datasets: [{
                    label: "My First dataset",
                    fillColor: "#a4cd76",
                    strokeColor: "#75b03a",
                    highlightFill: "#a4cd76",
                    highlightStroke: "#75b03a",
                    data: data[0],
                    title: "In"
                }
            , {
                label: "My Second dataset",
                fillColor: "#6da2b2",
                strokeColor: "#6da2b2",
                highlightFill: "#6da2b2",
                highlightStroke: "#6da2b2",
                data: data[1],
                title: "Out"
            }
            ]
            };
    }
        var ctx = document.getElementById("chartContainer").getContext("2d");
        ctx.canvas.width = 650;
        ctx.canvas.height = 350;
        if (data.labels[0] == undefined) {
            ctx.clearRect(0, 0, 650, 350);
        } else {
            $(function () {
                new Chart(ctx).Bar(data, options);
            });
        }
}

function getMonth(date) {
    var month = date.getMonth() + 1;
    return getTwoDigit(month);
}
function getDate(date) {
    var date = date.getDate();
    return getTwoDigit(date);
}

function getHours(date) {
    var hours = date.getHours();
    return getTwoDigit(hours);
}
function getMinutes(date) {
    var minutes = date.getMinutes();
    return getTwoDigit(minutes);
}
function getSeconds(date) {
    var seconds = date.getSeconds();
    return getTwoDigit(seconds);
}

function getTwoDigit(number) {
    return number < 10 ? '0' + number : number; // add 0 in font of the number
}

function weekToDate(year, wn, dayNb) {
    var j10 = new Date(year, 0, 10, 12, 0, 0),
        j4 = new Date(year, 0, 4, 12, 0, 0),
        mon1 = j4.getTime() - j10.getDay() * 86400000;
    return new Date(mon1 + ((wn - 1) * 7 + dayNb) * 86400000);
}

function addMinutes(theDate, minutes) {
    return (new Date(theDate.getTime() + minutes * 60000));
}

function getWeek(date) {

    var wk = getWeekOnly(date);

    return wk + ", " + date.getFullYear();
}

function getWeekOnly(dateText) {
    //if ($.datepicker.company == "Talarius")
        return $.datepicker.iso8601Week(new Date(dateText));
    //else
        //return $.datepicker.iso8601Week2(new Date(dateText));
}

function getMaxLabel(value) {
    var temp = value;
    var i = 0;
    while(temp > 10) {
        temp = temp / 10;
        i++;
    }
    temp = Math.floor(temp);
    if (temp != 10) {
        temp = (temp + 1) * Math.pow(10,(i-1));
    } else {
        temp = temp * Math.pow(10, (i - 1));
    }
    return temp;
}