﻿var GridStackUtility = {
    CalculateOuterInnerDifference: function (el) {
        var childDivHeight = el.find(".grid-stack-item-content > div > div").outerHeight();
        var parentDivHeight = el.find(".grid-stack-item-content").outerHeight();
        var widgetTitleElementHeight = 15;
        if (childDivHeight < parentDivHeight) { // If child is not longer than parent, return 0, no need to resize
            return 0;
        } else {
            return childDivHeight - parentDivHeight + widgetTitleElementHeight;
        }
    },
    CalculateRowToAdd: function (heightDifference) {
        return Math.ceil(heightDifference / 30);
    },
    GetMaxGridHeight: function (el) {
        var newGridRow = parseInt(el.data("gs-height")) + GridStackUtility.CalculateRowToAdd(GridStackUtility.CalculateOuterInnerDifference(el));
        return newGridRow;
    },
    ResizeGridHeight: function (el) {
        var grid = $('.grid-stack').data("gridstack");
        grid.update(el, null, null, null, GridStackUtility.GetMaxGridHeight(el));
    }
};