function getWeather(datas, data, startDateLine, endDateLine, colorScheme) {
    /*var key = "af5e7de1e9fa15bbbdd8c71be3168"; //key for get the free weather of 60 days before today
    var latitude = data.series[0].data[0].toFixed(3);
    var longitude = data.series[0].data[1].toFixed(3);
    var startDate = data.series[0].dateInFormat[0];
    var endDate = data.series[0].dateInFormat[1];
    var weatherList = [];
    var weatherNameList = [];
    var tempCount = 0;

    if ((latitude != 0 || longitude != 0) && !isMoreThan50days) {
        //get the weather by key in (start date, end date, city, key and country)
        $.post("//api.worldweatheronline.com/free/v2/past-weather.ashx?key=" + key + "&q=" + latitude + "," + longitude + "&date=" + startDate + "&enddate=" + endDate + "&format=json", function (data) {
            var symbol = [];
            $.each(data.data.weather, function () {
                var totalTempC = 0;
                var i = 0;
                var weatherCode = 0;
                var url = "//footfallcounter.com/Content/themes/base/images/";
                var weather = "sunny.png";

                $.each(this.hourly, function () {
                    totalTempC = totalTempC + parseInt(this.tempC);
                    i++;

                    $.each(this.weatherDesc, function () {
                        var weathers = 0;
                        var level = 0;
                        if (this.value.toLowerCase().indexOf("sunny") > -1) {
                            level = 1;
                        } else if (this.value.toLowerCase().indexOf("cloud") > -1) {
                            level = 2;
                        }
                        else if (this.value.toLowerCase().indexOf("rain") > -1) {
                            level = 4;
                        } else if (this.value.toLowerCase().indexOf("thundery") > -1) {
                            level = 5;
                        } else if (this.value.toLowerCase().indexOf("snow") > -1) {
                            level = 6;
                        } else {
                            level = 0;
                        }
                        if (weathers < level) {
                            weathers = level;
                            if (level == 1)
                                weather = "sunny.png";
                            else if (level == 2)
                                weather = "cloudy.png";
                            else if (level == 4)
                                weather = "rainy.png";
                            else if (level == 5)
                                weather = "thundery.png";
                            else if (level == 6)
                                weather = "snowy.png";
                            else if (level == 0)
                                weather = "sunny.png";
                        }
                    });
                });
                url = url + weather;

                //combine symbol and average temparature
                var json = jQuery.parseJSON('{"y":' + (totalTempC / i) + ', "marker":{ "symbol": "url(' + url + ')"}}');

                if (tempCount <= 30) {
                    symbol.push(url);
                }
                tempCount++;
            });

            for (var x = 0; x < tempCount && x < 31; x++) {
                var jsonSymbol = jQuery.parseJSON('{"y":' + 0 + ', "marker":{ "symbol": "url(' + symbol[x] + ')"}}');
                weatherList.push(jsonSymbol);

                var weather = (weatherList[x].marker.symbol).split("/")[7].split(".")[0] + " day";
                weatherNameList.push(weather);
            }
            callVisitorTrafficChart(datas[0], startDateLine, endDateLine, datas[5], weatherList, weatherNameList, colorScheme);
            callTurnInRateChart(datas[1], startDateLine, endDateLine, datas[6], weatherList, weatherNameList, colorScheme);
            callVisitDurationChart(datas[2], startDateLine, endDateLine, datas[7], weatherList, weatherNameList, colorScheme);
            callReturningCust(datas[3], startDateLine, endDateLine, datas[8], weatherList, weatherNameList, colorScheme);
            callSalesConversionChart(datas[4], startDateLine, endDateLine, weatherList, weatherNameList, colorScheme);
        });
    }
    else {
        callVisitorTrafficChart(datas[0], startDateLine, endDateLine, datas[5], weatherList, weatherNameList, colorScheme);
        callTurnInRateChart(datas[1], startDateLine, endDateLine, datas[6], weatherList, weatherNameList, colorScheme);
        callVisitDurationChart(datas[2], startDateLine, endDateLine, datas[7], weatherList, weatherNameList, colorScheme);
        callReturningCust(datas[3], startDateLine, endDateLine, datas[8], weatherList, weatherNameList, colorScheme);
        callSalesConversionChart(datas[4], startDateLine, endDateLine, weatherList, weatherNameList, colorScheme);
    }*/

        var weatherList = [];
        var weatherNameList = [];
        callVisitorTrafficChart(datas[0], startDateLine, endDateLine, datas[5], weatherList, weatherNameList, colorScheme);
        callTurnInRateChart(datas[1], startDateLine, endDateLine, datas[6], weatherList, weatherNameList, colorScheme);
        callVisitDurationChart(datas[2], startDateLine, endDateLine, datas[7], weatherList, weatherNameList, colorScheme);
        callReturningCust(datas[3], startDateLine, endDateLine, datas[8], weatherList, weatherNameList, colorScheme);
        callSalesConversionChart(datas[4], startDateLine, endDateLine, weatherList, weatherNameList, colorScheme);
}

function callVisitorTrafficChart(datas, startDateLine, endDateLine, datas1, weatherList, weatherNameList, colorScheme) {
    $(function () {
        var VisitorCountBeforeCampaign = datas.series[0].dataForCampaignTable[0] == " - " ? "0.00%" : datas.series[0].dataForCampaignTable[0];
        var VisitorCountDuringCampaign = datas.series[0].dataForCampaignTable[1] == " - " ? "0.00%" : datas.series[0].dataForCampaignTable[1];
        var VisitorCountAfterCampaign = datas.series[0].dataForCampaignTable[2] == " - " ? "0.00%" : datas.series[0].dataForCampaignTable[2];

        var visitorCount = datas.series[0].data;
        var outsideTraffic = datas.series[1].data;
        //var lastyearVC = datas1.series[0].data;

        Highcharts.setOptions({
            global: {
                useUTC: true
            }
        });

        var chart = new Highcharts.Chart({
            chart: {
                backgroundColor: 'rgba(255, 255, 255, 0.0)',
                renderTo: "visitorCount",
                events: {
                    load: function () {
                        chartEvent[0] = this;
                    }
                }
            },
            series: [{
                type: 'column',
                color: colorScheme.chart.matrices.noOfVisitor,
                borderWidth: 0,
                name: LanguageNoofVisitor,
                data: visitorCount,
            }, {
                yAxis: 1,
                type: 'areaspline',
                name: LanguageOutsideTraffic,
                data: outsideTraffic,
                color: colorScheme.chart.matrices.outsideTraffic,
                fillOpacity: 0.15,
                lineWidth: 1.25,
                marker: {
                    enabled: false
                }
            }/*, {
                yAxis: 0,
                type: 'line',
                color: colorScheme.time.year.lastYear,
                name: LanguageLastYearVisitor,
                dashStyle: 'dash',
                data: lastyearVC,
                lineWidth: 1,
                marker: {
                    enabled: false
                },
            }, {
                type: 'line',
                lineWidth: 0,
                name: 'Weather',
                data: weatherList,
                //showInLegend: false,
                marker: {
                    enabled: true
                },
                yAxis: 2
            }*/],
            credits: {
                enabled: false
            },
            title: {
                text: '',
            },
            plotOptions: {
                column: {
                    stacking: 'normal',
                    dataLabels: {
                        enabled: false,
                        style: {
                            textShadow: '0 0 3px black, 0 0 3px black'
                        }
                    }
                },
            },
            xAxis: {
                categories: datas.categories,
                lineWidth: 1,
                tickWidth: 0,
                title: {
                    text: null
                },
                labels: {
                    y: 13,
                    formatter: function () {
                        var format = this.value.split(" ");
                        return '<label style="font-size:11px;">' + format[0] + ' ' + '</label>' + '<label style="font-size:11px;">' + format[1] + '</label>';
                    },
                    rotation: -90,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                },

                plotLines: [{
                    color: colorScheme.chart.dottedLine.color.dateLine,
                    width: 3,
                    value: startDateLine,
                    zIndex: 3,
                    dashStyle: 'shortDot',
                    label: {
                        useHTML: true,
                        text: LanguageStart,
                        align: 'center',
                        style: {
                            "background-color": colorScheme.chart.dottedLine.color.dateLine,
                            "padding": "1px 5px",
                            "font-size": "11px",
                            color: 'white'
                        },
                        rotation: 0,
                        y: -10,
                        x: 0,
                        zIndex: 3
                    }
                }, {
                    color: colorScheme.chart.dottedLine.color.dateLine,
                    width: 3,
                    value: endDateLine,
                    dashStyle: 'shortDot',
                    zIndex: 3,
                    label: {
                        useHTML: true,
                        text: LanguageEnd,
                        align: 'center',
                        style: {
                            "background-color": colorScheme.chart.dottedLine.color.dateLine,
                            "padding": "1px 5px",
                            "font-size": "11px",
                            color: 'white'
                        },
                        rotation: 0,
                        y: -10,
                        x: 0,
                        zIndex: 3
                    }
                }],

                plotBands: [{
                    color: 'transparent',
                    from: 0,
                    to: startDateLine,
                    zIndex: 5,
                    label: {
                        text: numberify(VisitorCountBeforeCampaign),
                        align: 'center',
                        style: {
                            fontSize: '18px'
                        },
                        rotation: 0,
                        y: -5,
                        x: 0
                    }
                }, {
                    color: 'transparent',
                    from: startDateLine,
                    to: endDateLine,
                    zIndex: 5,
                    label: {
                        text: numberify(VisitorCountDuringCampaign),
                        align: 'center',
                        style: {
                            fontSize: '18px'
                        },
                        rotation: 0,
                        y: -5,
                        x: 0
                    }
                }, {
                    color: 'transparent',
                    from: endDateLine,
                    to: Date.UTC(2015, 0, 1),
                    zIndex: 5,
                    label: {
                        text: numberify(VisitorCountAfterCampaign),
                        align: 'center',
                        style: {
                            fontSize: '18px'
                        },
                        rotation: 0,
                        y: -5,
                        x: 0
                    }
                }],
            },

            yAxis: [{
				allowDecimals: false,
                lineWidth: 0,
                gridLineWidth: 0,
                tickWidth: 0,
                tickLength: 5,
                tickPosition: 'inside',
                min: 0,
                tickPixelInterval: 15,

                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                stackLabels: {
                    enabled: false,
                    style: {
                        fontWeight: 'bold',
                        color: (Highcharts.theme && Highcharts.theme.textColor) || 'gray'
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
            }, {
				allowDecimals: false,
                opposite: true,
                gridLineWidth: 1,
                lineWidth: 0,
                tickWidth: 1,
                tickLength: 5,
                tickPosition: 'inside',
                tickPixelInterval: 15,
                min: 0,
                //tickInterval: 2000,
                labels: {
                    align: 'left',
                    x: 5,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                title: {
                    text: LanguageOutsideTraffic,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                }
            }, {
                min: 0,
                max: 0,
                gridLineWidth: 0,
                lineWidth: 0,
                title: {
                    text: null
                },
                labels: {
                    enabled: false
                },
                height: '10%'
            }],
            legend: {
                enabled: true,
                align: 'top',
                backgroundColor: 'transparent',
                borderColor: 'transparent',
                x: 400,
                y: -15, layout: 'horizontal',
                verticalAlign: 'top',
                shadow: false,
                symbolHeight: 10,
                symbolWidth: 10,
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                }
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
                formatter: function () {
                    /*var i = datas.categories.indexOf(this.x);
                    if (weatherList.length != 0) {
                        var weather = weatherNameList[i];
                        return '<b>' + this.x + "</b><br/>" +
                        "<span style='color:" + this.points[0].series.color + "'>\u25CF</span> " + this.points[0].series.name + ': ' + this.points[0].y + '<br/>' +
                        "<span style='color:" + this.points[1].series.color + "'>\u25CF</span> " + this.points[1].series.name + ': ' + this.points[1].y + '<br/>' +
                        "<span style='color:" + this.points[2].series.color + "'>\u25CF</span> " + this.points[2].series.name + ': ' + this.points[2].y + '<br/>' +
                        "<span style='color:" + this.points[3].series.color + "'>\u25CF</span> " + this.points[3].series.name + ': ' + weather + '<br/>';
                    }
                    else {*/
                        return '<b>' + this.x + "</b><br/>" +
                         "<span style='color:" + this.points[0].series.color + "'>\u25CF</span> " + this.points[0].series.name + ': ' + numberify(this.points[0].y) + '<br/>'+
                         "<span style='color:" + this.points[1].series.color + "'>\u25CF</span> " + this.points[1].series.name + ': ' + numberify(this.points[1].y) + '<br/>';
                    
                }
            },
        });
    });
}

function callTurnInRateChart(datas, startDateLine, endDateLine, datas1, weatherList, weatherNameList, colorScheme) {
    var TIRBeforeCampaign = datas.series[0].dataForCampaignTable[0] == " - " ? "0.00%" : datas.series[0].dataForCampaignTable[0];
    var TIRDuringCampaign = datas.series[0].dataForCampaignTable[1] == " - " ? "0.00%" : datas.series[0].dataForCampaignTable[1];
    var TIRAfterCampaign = datas.series[0].dataForCampaignTable[2] == " - " ? "0.00%" : datas.series[0].dataForCampaignTable[2];

    Highcharts.setOptions({
        global: {
            useUTC: true
        }
    });

    $('#turnInRate').highcharts({
        chart: {
            type: 'line',
            backgroundColor: 'rgba(255, 255, 255, 0.0)',
            events: {
                load: function () {
                    chartEvent[1] = this;
                }
            }
        },
        title: {
            text: null,
        },
        xAxis: {
            categories: datas.categories,
            lineWidth: 1,
            tickWidth: 0,
            title: {
                text: LanguageDay,
                align: 'high',
                y: -20,
                style: {
                    color: colorScheme.chart.axisLabel.x.title.color,
                    fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                    "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                }
            },

            plotLines: [{
                color: colorScheme.chart.dottedLine.color.dateLine,
                width: 3,
                value: startDateLine,
                zIndex: 3,
                dashStyle: 'shortDot',
            }, {
                color: colorScheme.chart.dottedLine.color.dateLine,
                width: 3,
                value: endDateLine,
                zIndex: 3,
                dashStyle: 'shortDot',
            }],
            plotBands: [{
                color: 'transparent',
                from: 0,
                to: startDateLine,
                zIndex: 5,
                label: {
                    text: TIRBeforeCampaign,
                    align: 'center',
                    style: {
                        fontSize: '18px'
                    },
                    rotation: 0,
                    y: -5,
                    x: 0
                }
            }, {
                color: 'transparent',
                from: startDateLine,
                to: endDateLine,
                zIndex: 5,
                label: {
                    text: TIRDuringCampaign,
                    align: 'center',
                    style: {
                        fontSize: '18px'
                    },
                    rotation: 0,
                    y: -5,
                    x: 0
                }
            }, {
                color: 'transparent',
                from: endDateLine,
                to: Date.UTC(2015, 0, 1),
                zIndex: 5,
                label: {
                    text: TIRAfterCampaign,
                    align: 'center',
                    style: {
                        fontSize: '18px'
                    },
                    rotation: 0,
                    y: -5,
                    x: 0
                }
            }],
            labels: {
                y: 13,
                formatter: function () {
                    var format = this.value.split(" ", 2);
                    return '<label style="font-size:11px;">' + format[0] + ' ' + '</label>' + '<label style="font-size:11px;">' + format[1] + '</label>';
                },
                rotation: -90,
                style: {
                    color: colorScheme.chart.axisLabel.x.label.color,
                    "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                    fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                }
            }
        },
        yAxis: [{
            lineWidth: 0,
            tickWidth: 1,
            tickLength: 5,
            tickPosition: 'inside',
            gridLineWidth: 1,
            tickPixelInterval: 15,
            min: 0,
            title: {
                text: LanguageTurnInRatepercent,
                style: {
                    color: colorScheme.chart.axisLabel.y.title.color,
                    fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                    "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                }
            },
            stackLabels: {
                enabled: false,
                style: {
                    fontWeight: 'bold',
                    color: (Highcharts.theme && Highcharts.theme.textColor) || 'gray'
                }
            },
            labels: {
                formatter: function () {
                    return this.value + '%';
                },
                style: {
                    "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                    color: colorScheme.chart.axisLabel.y.label.color,
                    fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                }
            }
        }, {
            min: 0,
            max: 0,
            gridLineWidth: 0,
            lineWidth: 0,
            title: {
                text: null
            },
            labels: {
                enabled: false
            },
            height: '10%'
        }],

        legend: {
            enabled: true,
            align: 'top',
            backgroundColor: 'transparent',
            x: 590,
            y: -15, layout: 'horizontal',
            verticalAlign: 'top',
            shadow: false,
            symbolHeight: 10,
            symbolWidth: 10,
            itemStyle: {
                color: colorScheme.chart.legend.text.color,
                "font-family": colorScheme.chart.legend.text.fontFamily,
                fontSize: colorScheme.chart.legend.text.fontSize,
                "font-weight": colorScheme.chart.legend.text.fontWeight
            }
        },
        tooltip: {
            useHTML: true,
            shared: true,
            formatter: function () {
                var i = datas.categories.indexOf(this.x);
                /*if (weatherList.length != 0) {
                    var weather = weatherNameList[i];
                    return '<b>' + this.x + "</b><br/>" +
                    "<span style='color:" + this.points[0].series.color + "'>\u25CF</span> " + this.points[0].series.name + ': ' + this.points[0].y + '<br/>' +
                    "<span style='color:" + this.points[1].series.color + "'>\u25CF</span> " + this.points[1].series.name + ': ' + this.points[1].y + '<br/>' +
                    "<span style='color:" + this.points[2].series.color + "'>\u25CF</span> " + this.points[2].series.name + ': ' + weather + '<br/>';
                }
                else {*/
                    return '<b>' + this.x + "</b><br/>" +
                     "<span style='color:" + this.points[0].series.color + "'>\u25CF</span> " + this.points[0].series.name + ': ' + this.points[0].y + '<br/>';
                
            }
        },

        plotOptions: {
            column: {
                stacking: 'normal',
                dataLabels: {
                    enabled: false,
                    style: {
                        textShadow: '0 0 3px black, 0 0 3px black'
                    }
                }
            },
            series: {
                marker: {
                    enabled: false
                }
            }
        },

        credits: {
            enabled: false
        },

        series: [{
            name: LanguageTurnInRatepercent,
            data: datas.series[0].data,
            color: colorScheme.chart.line.color.thisYear,
            marker: {
                symbol: 'circle'
            },
            lineWidth: 1
        }/*, {
            name: LanguageLastYear,
            dashStyle: 'dash',
            data: datas1.series[0].data,
            color: colorScheme.chart.line.color.lastYear,
            lineWidth: 1,
            marker: {
                symbol: 'circle'
            }
        }, {
            type: 'line',
            lineWidth: 0,
            name: 'Weather',
            data: weatherList,
            //showInLegend: false,
            marker: {
                enabled: true
            },
            yAxis: 1
        }*/],
        exporting: {
            enabled: false
        }
    });
}

function callVisitDurationChart(datas, startDateLine, endDateLine, datas2, weatherList, weatherNameList, colorScheme) {
    var VDBeforeCampaign = datas.series[3].dataForCampaignTable[0] == " - " ? "0.00" + Languagemin + "" : datas.series[3].dataForCampaignTable[0];
    var VDDuringCampaign = datas.series[3].dataForCampaignTable[1] == " - " ? "0.00" + Languagemin + "" : datas.series[3].dataForCampaignTable[1];
    var VDAfterCampaign = datas.series[3].dataForCampaignTable[2] == " - " ? "0.00" + Languagemin + "" : datas.series[3].dataForCampaignTable[2];
    Highcharts.setOptions({
        global: {
            useUTC: true
        }
    });

    $('#visitDuration').highcharts({
         chart: {
            type: 'line',
            backgroundColor: 'rgba(255, 255, 255, 0.0)',
            events: {
                load: function () {
                    chartEvent[2] = this;
                }
            }
        },
        title: {
            text: null,
            align: 'left',
            style: {
                fontWeight: 'bold',
                color: '#494b4b'
            }
        },
        xAxis: {
            categories: datas.categories,
            lineWidth: 1,
            tickWidth: 0,
            title: {
                text: LanguageDay,
                align: 'high',
                y: -20,
                style: {
                    color: colorScheme.chart.axisLabel.x.title.color,
                    fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                    "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                }
            },
            plotLines: [{
                color: colorScheme.chart.dottedLine.color.dateLine,
                width: 3,
                value: startDateLine,
                zIndex: 3,
                dashStyle: 'shortDot',
            }, {
                color: colorScheme.chart.dottedLine.color.dateLine,
                width: 3,
                value: endDateLine,
                zIndex: 3,
                dashStyle: 'shortDot',
            }],

            plotBands: [{
                color: 'transparent',
                from: 0,
                to: startDateLine,
                zIndex: 5,
                label: {
                    text: VDBeforeCampaign,
                    align: 'center',
                    style: {
                        fontSize: '15px',
                        marginTop: '-10px'
                    },
                    rotation: 0,
                    y: -5,
                    x: 0
                }
            }, {
                color: 'transparent',
                from: startDateLine,
                to: endDateLine,
                zIndex: 5,
                label: {
                    text: VDDuringCampaign,
                    align: 'center',
                    style: {
                        fontSize: '15px'
                    },
                    rotation: 0,
                    y: -5,
                    x: 0
                }
            }, {
                color: 'transparent',
                from: endDateLine,
                to: Date.UTC(2015, 0, 1),
                zIndex: 5,
                label: {
                    text: VDAfterCampaign,
                    align: 'center',
                    style: {
                        fontSize: '15px'
                    },
                    rotation: 0,
                    y: -5,
                    x: 0
                }
            }],
            labels: {
                y: 13,
                formatter: function () {
                    var format = this.value.split(" ", 2);

                    return '<label style="font-size:11px;">' + format[0] + ' ' + '</label>' + '<label style="font-size:11px;">' + format[1] + '</label>';
                },
                rotation: -90,
                style: {
                    color: colorScheme.chart.axisLabel.x.label.color,
                    "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                    fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                }
            }
        },

        yAxis: [{
            gridLineWidth: 1,
            lineWidth: 0,
            tickWidth: 1,
            tickLength: 5,
            tickPixelInterval: 15,
            tickPosition: 'inside',
            min: 0,
            title: {
                text: Languagemins,
                style: {
                    color: colorScheme.chart.axisLabel.y.title.color,
                    fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                    "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                }
            },
            stackLabels: {
                enabled: false,
                style: {
                    fontWeight: 'bold',
                    color: (Highcharts.theme && Highcharts.theme.textColor) || 'gray'
                }
            },
            labels: {
                style: {
                    "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                    color: colorScheme.chart.axisLabel.y.label.color,
                    fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                }
            }
        }, {
            min: 0,
            max: 0,
            gridLineWidth: 0,
            lineWidth: 0,
            title: {
                text: null
            },
            labels: {
                enabled: false
            },
            height: '10%'
        }],

        legend: {
            enabled: true,
            align: 'top',
            backgroundColor: 'transparent',
            borderColor: 'transparent',
            x: 590,
            y: -15,
            layout: 'horizontal',
            verticalAlign: 'top',
            shadow: false,
            symbolHeight: 10,
            symbolWidth: 10,
            itemStyle: {
                color: colorScheme.chart.legend.text.color,
                "font-family": colorScheme.chart.legend.text.fontFamily,
                fontSize: colorScheme.chart.legend.text.fontSize,
                "font-weight": colorScheme.chart.legend.text.fontWeight
            }
        },
        tooltip: {
            useHTML: true,
            shared: true,
            formatter: function () {
                /*var i = datas.categories.indexOf(this.x);
                if (weatherList.length != 0) {
                    var weather = weatherNameList[i];
                    return '<b>' + this.x + "</b><br/>" +
                    "<span style='color:" + this.points[0].series.color + "'>\u25CF</span> " + this.points[0].series.name + ': ' + this.points[0].y + '<br/>' +
                    "<span style='color:" + this.points[1].series.color + "'>\u25CF</span> " + this.points[1].series.name + ': ' + this.points[1].y + '<br/>' +
                    "<span style='color:" + this.points[2].series.color + "'>\u25CF</span> " + this.points[2].series.name + ': ' + weather + '<br/>';
                }
                else {*/
                    return '<b>' + this.x + "</b><br/>" +
                     "<span style='color:" + this.points[0].series.color + "'>\u25CF</span> " + this.points[0].series.name + ': ' + this.points[0].y.toFixed(2) + '<br/>';
                
            }
        },
        plotOptions: {
            column: {
                stacking: 'normal',
                dataLabels: {
                    enabled: false,
                    style: {
                        textShadow: '0 0 3px black, 0 0 3px black'
                    }
                }
            }
        },

        credits: {
            enabled: false
        },
        series: [{
            name: LanguageVisitDuration,
            data: datas.series[3].data,
            color: colorScheme.chart.line.color.thisYear,
            lineWidth: 1,
            marker: {
                    enabled: false
                }
        }/*, {
            name: LanguageLastYear,
            dashStyle: 'dash',
            data: datas2.series[3].data,
            color: colorScheme.chart.line.color.lastYear,
            lineWidth: 1
        }, {
            type: 'line',
            lineWidth: 0,
            name: 'Weather',
            data: weatherList,
            //showInLegend: false,
            marker: {
                enabled: true
            },
            yAxis: 1
        }*/],
        exporting: {
            enabled: false
        }
    });

}

//function for returning customer
function callReturningCust(data, startDateLine, endDateLine, data2, weatherList, weatherNameList, colorScheme) {
    var RRBeforeCampaign = data.series[1].dataForCampaignTable[0] == " - " ? "0.00%" : data.series[1].dataForCampaignTable[0];
    var RRDuringCampaign = data.series[1].dataForCampaignTable[1] == " - " ? "0.00%" : data.series[1].dataForCampaignTable[1];
    var RRAfterCampaign = data.series[1].dataForCampaignTable[2] == " - " ? "0.00%" : data.series[1].dataForCampaignTable[2];

    $('#returningCustomer').highcharts({
        chart: {
            type: 'line',
            backgroundColor: 'rgba(255, 255, 255, 0.0)',
            events: {
                load: function () {
                    chartEvent[2] = this;
                }
            }
        },
        title: {
            text: null,
        },
        xAxis: {
            categories: data.categories,
            lineWidth: 1,
            tickWidth: 0,
            title: {
                text: LanguageDay,
                align: 'high',
                y: -20,
                style: {
                    color: colorScheme.chart.axisLabel.x.title.color,
                    fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                    "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                }
            },
            plotLines: [{
                color: colorScheme.chart.dottedLine.color.dateLine,
                width: 3,
                value: startDateLine,
                zIndex: 3,
                dashStyle: 'shortDot',
            }, {
                color: colorScheme.chart.dottedLine.color.dateLine,
                width: 3,
                value: endDateLine,
                zIndex: 3,
                dashStyle: 'shortDot',
            }],

            plotBands: [{
                color: 'transparent',
                from: 0,
                to: startDateLine,
                zIndex: 5,
                label: {
                    text: RRBeforeCampaign,
                    align: 'center',
                    style: {
                        fontSize: '15px',
                        marginTop: '-10px'
                    },
                    rotation: 0,
                    y: -5,
                    x: 0
                }
            }, {
                color: 'transparent',
                from: startDateLine,
                to: endDateLine,
                zIndex: 5,
                label: {
                    text: RRDuringCampaign,
                    align: 'center',
                    style: {
                        fontSize: '15px'
                    },
                    rotation: 0,
                    y: -5,
                    x: 0
                }
            }, {
                color: 'transparent',
                from: endDateLine,
                to: Date.UTC(2015, 0, 1),
                zIndex: 5,
                label: {
                    text: RRAfterCampaign,
                    align: 'center',
                    style: {
                        fontSize: '15px'
                    },
                    rotation: 0,
                    y: -5,
                    x: 0
                }
            }],
            labels: {
                y: 13,
                formatter: function () {
                    var format = this.value.split(" ", 2);

                    return '<label style="font-size:11px;">' + format[0] + ' ' + '</label>' + '<label style="font-size:11px;">' + format[1] + '</label>';
                },
                rotation: -90,
                style: {
                    color: colorScheme.chart.axisLabel.x.label.color,
                    "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                    fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                }
            }
        },

        yAxis: [{
            gridLineWidth: 1,
            lineWidth: 0,
            tickWidth: 1,
            tickLength: 5,
            tickPixelInterval: 15,
            tickPosition: 'inside',
            min: 0,
            title: {
                text: LanguageReturningRate,
                style: {
                    color: colorScheme.chart.axisLabel.y.title.color,
                    fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                    "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                }
            },
            stackLabels: {
                enabled: false,
                style: {
                    fontWeight: 'bold',
                    color: (Highcharts.theme && Highcharts.theme.textColor) || 'gray'
                }
            },
            labels: {
                style: {
                    "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                    color: colorScheme.chart.axisLabel.y.label.color,
                    fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                }
            }
        }, {
            min: 0,
            max: 0,
            gridLineWidth: 0,
            lineWidth: 0,
            title: {
                text: null
            },
            labels: {
                enabled: false
            },
            height: '10%'
        }],

        legend: {
            enabled: true,
            align: 'top',
            backgroundColor: 'transparent',
            borderColor: 'transparent',
            x: 590,
            y: -15,
            layout: 'horizontal',
            verticalAlign: 'top',
            shadow: false,
            symbolHeight: 10,
            symbolWidth: 10,
            itemStyle: {
                color: colorScheme.chart.legend.text.color,
                "font-family": colorScheme.chart.legend.text.fontFamily,
                fontSize: colorScheme.chart.legend.text.fontSize,
                "font-weight": colorScheme.chart.legend.text.fontWeight
            }
        },
        tooltip: {
            useHTML: true,
            shared: true,
            formatter: function () {
                var i = data.categories.indexOf(this.x);
                /*if (weatherList.length != 0) {
                    var weather = weatherNameList[i];
                    return '<b>' + this.x + "</b><br/>" +
                    "<span style='color:" + this.points[0].series.color + "'>\u25CF</span> " + this.points[0].series.name + ': ' + this.points[0].y + '<br/>' +
                    "<span style='color:" + this.points[1].series.color + "'>\u25CF</span> " + this.points[1].series.name + ': ' + this.points[1].y + '<br/>' +
                    "<span style='color:" + this.points[2].series.color + "'>\u25CF</span> " + this.points[2].series.name + ': ' + weather + '<br/>';
                }
                else {*/
                    return '<b>' + this.x + "</b><br/>" +
                     "<span style='color:" + this.points[0].series.color + "'>\u25CF</span> " + this.points[0].series.name + ': ' + numberify(this.points[0].y) + '<br/>';
                
            }
        },
        plotOptions: {
            column: {
                stacking: 'normal',
                dataLabels: {
                    enabled: false,
                    style: {
                        textShadow: '0 0 3px black, 0 0 3px black'
                    }
                }
            }
        },

        credits: {
            enabled: false
        },
        series: [{
            name: LanguageReturningRate,
            data: data.series[1].data,
            color: colorScheme.chart.line.color.thisYear,
            marker: {
                    enabled: false
                },
            lineWidth: 1
        }/*, {
            name: LanguageLastYear,
            dashStyle: 'dash',
            data: data2.series[1].data,
            color: colorScheme.chart.line.color.lastYear,
            lineWidth: 1
        }, {
            type: 'line',
            lineWidth: 0,
            name: 'Weather',
            data: weatherList,
            //showInLegend: false,
            marker: {
                enabled: true
            },
            yAxis: 1
        }*/],
        exporting: {
            enabled: false
        }
    });
}


function callSalesConversionChart(datas, startDateLine, endDateLine, weatherList, weatherNameList, colorScheme) {
    var SCBeforeCampaign = datas.series[2].dataForCampaignTable[0] == " - " ? "0.00%" : datas.series[2].dataForCampaignTable[0];
    var SCDuringCampaign = datas.series[2].dataForCampaignTable[1] == " - " ? "0.00%" : datas.series[2].dataForCampaignTable[1];
    var SCAfterCampaign = datas.series[2].dataForCampaignTable[2] == " - " ? "0.00%" : datas.series[2].dataForCampaignTable[2];
    Highcharts.setOptions({
        global: {
            useUTC: true
        }
    });

    $('#salesConversion').highcharts({
        chart: {
            type: 'line',
            backgroundColor: 'rgba(255, 255, 255, 0.0)',
            events: {
                load: function () {
                    chartEvent[1] = this;
                }
            }
        },
        title: {
            text: null,
        },
        xAxis: {
            categories: datas.categories,
            lineWidth: 1,
            tickWidth: 0,
            title: {
                text: LanguageDay,
                align: 'high',
                y: -20,
                style: {
                    color: colorScheme.chart.axisLabel.x.title.color,
                    fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                    "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                }
            },

            plotLines: [{
                color: colorScheme.chart.dottedLine.color.dateLine,
                width: 3,
                value: startDateLine,
                zIndex: 3,
                dashStyle: 'shortDot',
            }, {
                color: colorScheme.chart.dottedLine.color.dateLine,
                width: 3,
                value: endDateLine,
                zIndex: 3,
                dashStyle: 'shortDot',
            }],
            plotBands: [{
                color: 'transparent',
                from: 0,
                to: startDateLine,
                zIndex: 5,
                label: {
                    text: SCBeforeCampaign,
                    align: 'center',
                    style: {
                        fontSize: '18px'
                    },
                    rotation: 0,
                    y: -5,
                    x: 0
                }
            }, {
                color: 'transparent',
                from: startDateLine,
                to: endDateLine,
                zIndex: 5,
                label: {
                    text: SCDuringCampaign,
                    align: 'center',
                    style: {
                        fontSize: '18px'
                    },
                    rotation: 0,
                    y: -5,
                    x: 0
                }
            }, {
                color: 'transparent',
                from: endDateLine,
                to: Date.UTC(2015, 0, 1),
                zIndex: 5,
                label: {
                    text: SCAfterCampaign,
                    align: 'center',
                    style: {
                        fontSize: '18px'
                    },
                    rotation: 0,
                    y: -5,
                    x: 0
                }
            }],

            labels: {
                y: 13,
                formatter: function () {
                    var format = this.value.split(" ", 2);
                    return '<label style="font-size:11px;">' + format[0] + ' ' + '</label>' + '<label style="font-size:11px;">' + format[1] + '</label>';
                },
                rotation: -90,
                style: {
                    color: colorScheme.chart.axisLabel.x.label.color,
                    "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                    fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                }
            }
        },

        yAxis: [{
            lineWidth: 0,
            tickWidth: 1,
            tickLength: 5,
            tickPosition: 'inside',
            gridLineWidth: 1,
            tickPixelInterval: 15,
            min: 0,
            title: {
                text: LanguageReturningRate,
                style: {
                    color: colorScheme.chart.axisLabel.y.title.color,
                    fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                    "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                }
            },
            stackLabels: {
                enabled: false,
                style: {
                    fontWeight: 'bold',
                    color: (Highcharts.theme && Highcharts.theme.textColor) || 'gray'
                }
            },
            labels: {
                formatter: function () {
                    return this.value + '%';
                },
                style: {
                    "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                    color: colorScheme.chart.axisLabel.y.label.color,
                    fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                }
            }
        }, {
            min: 0,
            max: 0,
            gridLineWidth: 0,
            lineWidth: 0,
            title: {
                text: null
            },
            labels: {
                enabled: false
            },
            height: '10%'
        }],

        legend: {
            enabled: true,
            align: 'top',
            backgroundColor: 'transparent',
            x: 550,
            y: -15, layout: 'horizontal',
            verticalAlign: 'top',
            shadow: false,
            symbolHeight: 10,
            symbolWidth: 10,
            itemStyle: {
                color: colorScheme.chart.legend.text.color,
                "font-family": colorScheme.chart.legend.text.fontFamily,
                fontSize: colorScheme.chart.legend.text.fontSize,
                "font-weight": colorScheme.chart.legend.text.fontWeight
            }
        },
        tooltip: {
            useHTML: true,
            shared: true,
            formatter: function () {
                /*var i = datas.categories.indexOf(this.x);
                if (weatherList.length != 0) {
                    var weather = weatherNameList[i];
                    return '<b>' + this.x + "</b><br/>" +
                    "<span style='color:" + this.points[0].series.color + "'>\u25CF</span> " + this.points[0].series.name + ': ' + this.points[0].y + '<br/>' +
                    "<span style='color:" + this.points[1].series.color + "'>\u25CF</span> " + this.points[1].series.name + ': ' + this.points[1].y + '<br/>' +
                    "<span style='color:" + this.points[2].series.color + "'>\u25CF</span> " + this.points[2].series.name + ': ' + weather + '<br/>';
                }
                else {*/
                    return '<b>' + this.x + "</b><br/>" +
                     "<span style='color:" + this.points[0].series.color + "'>\u25CF</span> " + this.points[0].series.name + ': ' + this.points[0].y + '<br/>';
                
            }
        },

        plotOptions: {
            column: {
                stacking: 'normal',
                dataLabels: {
                    enabled: false,
                    style: {
                        textShadow: '0 0 3px black, 0 0 3px black'
                    }
                }
            },
            series: {
                marker: {
                    enabled: false
                }
            }
        },
        credits: {
            enabled: false
        },
        series: [{
            type: 'column',
            name: LanguageSalesConversion,
            data: datas.series[1].data,
            color: colorScheme.time.year.thisYear,
            pointWidth: 10,
            borderWidth: 0
        }/*, {
            type: 'line',
            name: LanguageSalesVolume,
            dashStyle: 'dash',
            data: datas.series[0].data,
            color: colorScheme.time.year.lastYear,
            lineWidth: 1,
            marker: {
                enabled: false
            }
        }, {
            type: 'line',
            lineWidth: 0,
            name: 'Weather',
            data: weatherList,
            //showInLegend: false,
            marker: {
                enabled: true
            },
            yAxis: 1
        }*/],
        exporting: {
            enabled: false
        }
    });
}

