﻿function chartLoading() {
    loadingChart("7daysVisitorGraph");
    $("#7daysVisitorGraph").addClass("chartLoading");

    loadingChart("thisWeekTotalTrend");
    $("#thisWeekTotalTrend").addClass("chartLoading");

    loadingChart("yearToDateTrend");
    $("#yearToDateTrend").addClass("chartLoading");

    loadingChart("monthToDateTrend");
    $("#monthToDateTrend").addClass("chartLoading");
}

var tempArr = [];
var sparkObject = {};
function bindLastThreeWeekSalesConversionDataIntoTable(data, data1, colorScheme, dateRangeData) {
    var fourWeeksDateRange = dateRangeData.series[0].startAndEndDate;
    var compareA = 0;
    var index = 0;
    var num = [];
    //console.log(data);
    for (var i = 1; i <= data1.series[0].data.length; i++) {

        if (compareA != data1.series[0].branchId[i - 1]) {
            compareA = data1.series[0].branchId[i - 1];
            tempArr.push(data1.series[0].data[i - 1]);
        }
        else {
            tempArr.push(data1.series[0].data[i - 1]);
        }

        if (i % 28 == 0) {
            num[index] = tempArr;
            index++;
            tempArr = [];
        }
    }

    var sparkLineValue = [];
    var branchId = data.series[1].branchId[0];
    var i = 0;
    $("#statisticsTableHead").empty();
    $("#statisticsTableContent").empty();
    $("#statisticsTable").append("<colgroup><col width='17%'/><col width='17%'/><col width='17%'/><col width='17%'/><col width='17%' /><col width='17%' /></colgroup>");
    $("#statisticsTableHead").append("<tr><th rowspan='2'>" + LanguageBranches + "</th><th colspan='5'>" + LanguageSalesConversion + "</th></tr>");
    $("#statisticsTableHead").append("<tr class=''><th>" + LanguageWeek + " " + data.series[1].weekNumber + "</th><th>" + LanguageWeek + " " + data.series[2].weekNumber + "</th><th>" + LanguageWeek + " " + data.series[3].weekNumber + "</th><th>" + LanguageWeek + " " + data.series[4].weekNumber + "</th><th>" + LanguageFootfallTrend + "</th></tr>");
    var menuIdAndIndexlist = $('#salesConversionMenuIDAndIndexID').val();
    while (branchId != null && branchId != "") {
        var tableRowStart = "<tr class='tableRow' data-branchId='" + data.series[1].branchId[i] + "' data-branchName='" + data.series[1].branchName[i] + "'>";
        var displayBranchName = tableRowStart + "<td >" + data.series[1].branchName[i] + "</td>";

        var firstCondition = data.series[0].data[i] == 0 || data.series[1].data[i] == 0 ?
            "<td data-startdate='" + fourWeeksDateRange[0] + "' data-enddate='" + fourWeeksDateRange[1] + "' data-weeknumber='" + data.series[1].weekNumber + "' class='statistic-cell rowLink'><span>" + data.series[1].data[i] + "&nbsp;&nbsp;&nbsp;( - )</span></td>" :
            data.series[1].changes[i] < 0 ?
            "<td data-startdate='" + fourWeeksDateRange[0] + "' data-enddate='" + fourWeeksDateRange[1] + "' data-weeknumber='" + data.series[1].weekNumber + "' class='statistic-cell rowLink'><span>" + data.series[1].data[i] + "% &nbsp;&nbsp;&nbsp;<span class='drop'><i class='fa fa-caret-down'></i> " + Number(data.series[1].changes[i] * -1).toFixed(2) + "%</span></span></td>" :
            "<td data-startdate='" + fourWeeksDateRange[0] + "' data-enddate='" + fourWeeksDateRange[1] + "' data-weeknumber='" + data.series[1].weekNumber + "' class='statistic-cell rowLink'><span>" + data.series[1].data[i] + "% &nbsp;&nbsp;&nbsp;<span class='rise'><i class='fa fa-caret-up'></i> " + Number(data.series[1].changes[i]).toFixed(2) + "%</span></span></td>";

        var secondCondition = data.series[1].data[i] == 0 || data.series[2].data[i] == 0 ?
            "<td data-startdate='" + fourWeeksDateRange[2] + "' data-enddate='" + fourWeeksDateRange[3] + "' data-weeknumber='" + data.series[2].weekNumber + "' class='statistic-cell rowLink'><span>" + data.series[2].data[i] + "&nbsp;&nbsp;&nbsp;( - )</span></td>" :
            data.series[2].changes[i] < 0 ?
            "<td data-startdate='" + fourWeeksDateRange[2] + "' data-enddate='" + fourWeeksDateRange[3] + "' data-weeknumber='" + data.series[2].weekNumber + "' class='statistic-cell rowLink'><span>" + data.series[2].data[i] + "% &nbsp;&nbsp;&nbsp;<span class='drop'><i class='fa fa-caret-down'></i> " + Number(data.series[2].changes[i] * -1).toFixed(2) + "%</span></span></td>" :
            "<td data-startdate='" + fourWeeksDateRange[2] + "' data-enddate='" + fourWeeksDateRange[3] + "' data-weeknumber='" + data.series[2].weekNumber + "' class='statistic-cell rowLink'><span>" + data.series[2].data[i] + "% &nbsp;&nbsp;&nbsp;<span class='rise'><i class='fa fa-caret-up'></i> " + Number(data.series[2].changes[i]).toFixed(2) + "%</span></span></td>";

        var thirdCondition = data.series[2].data[i] == 0 || data.series[3].data[i] == 0 ?
            "<td data-startdate='" + fourWeeksDateRange[4] + "' data-enddate='" + fourWeeksDateRange[5] + "' data-weeknumber='" + data.series[3].weekNumber + "' class='statistic-cell rowLink'><span>" + data.series[3].data[i] + "&nbsp;&nbsp;&nbsp;( - )</span></td>" :
            data.series[3].changes[i] < 0 ?
            "<td data-startdate='" + fourWeeksDateRange[4] + "' data-enddate='" + fourWeeksDateRange[5] + "' data-weeknumber='" + data.series[3].weekNumber + "' class='statistic-cell rowLink'><span>" + data.series[3].data[i] + "% &nbsp;&nbsp;&nbsp;<span class='drop'><i class='fa fa-caret-down'></i> " + Number(data.series[3].changes[i] * -1).toFixed(2) + "%</span></span></td>" :
            "<td data-startdate='" + fourWeeksDateRange[4] + "' data-enddate='" + fourWeeksDateRange[6] + "' data-weeknumber='" + data.series[3].weekNumber + "' class='statistic-cell rowLink'><span>" + data.series[3].data[i] + "% &nbsp;&nbsp;&nbsp;<span class='rise'><i class='fa fa-caret-up'></i> " + Number(data.series[3].changes[i]).toFixed(2) + "%</span></span></td>";

        var forthCondition = data.series[3].data[i] == 0 || data.series[4].data[i] == 0 ?
            "<td data-startdate='" + fourWeeksDateRange[6] + "' data-enddate='" + fourWeeksDateRange[7] + "' data-weeknumber='" + data.series[4].weekNumber + "' class='statistic-cell rowLink'><span>" + data.series[4].data[i] + "&nbsp;&nbsp;&nbsp;( - )</span></td>" :
            data.series[4].changes[i] < 0 ?
            "<td data-startdate='" + fourWeeksDateRange[6] + "' data-enddate='" + fourWeeksDateRange[7] + "' data-weeknumber='" + data.series[4].weekNumber + "' class='statistic-cell rowLink'><span>" + data.series[4].data[i] + "% &nbsp;&nbsp;&nbsp;<span class='drop'><i class='fa fa-caret-down'></i> " + Number(data.series[4].changes[i] * -1).toFixed(2) + "%</span></span></td>" :
            "<td data-startdate='" + fourWeeksDateRange[6] + "' data-enddate='" + fourWeeksDateRange[7] + "' data-weeknumber='" + data.series[4].weekNumber + "' class='statistic-cell rowLink'><span>" + data.series[4].data[i] + "% &nbsp;&nbsp;&nbsp;<span class='rise'><i class='fa fa-caret-up'></i> " + Number(data.series[4].changes[i]).toFixed(2) + "%</span></span></td>";

        var sparkLineTrend = "<td id=\"trend[" + i + "]\" class=\"tableHighchart\" ></td></tr>";

        $("#statisticsTableContent").append(displayBranchName + firstCondition + secondCondition + thirdCondition + forthCondition + sparkLineTrend);
        i++;
        branchId = data.series[1].branchId[i];
    }

    $('.statistic-cell').click(function () {
        var bName = $(this).parent().data("branchname");
        var bID = $(this).parent().data("branchid");
        var sD = $(this).data("startdate");
        var eD = $(this).data("enddate");
        var wN = $(this).data("weeknumber");
        var d = bID + "," + sD + "," + eD + "," + bName + "," + wN;
        $.cookie("siteSalesConversion", d);
        window.open("/FootfallCam/StoreSalesConversionReport?" + menuIdAndIndexlist);
    })
    drawSparkLine(num, colorScheme);
}

function getCookie(name) {
    var nameEQ = name + "=";
    var ca = document.cookie.split(';');
    for (var i = 0; i < ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0) == ' ') c = c.substring(1, c.length);
        if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length, c.length);
    }
    return null;
}

function setCookie(name, value, days) {
    if (days) {
        var date = new Date();
        date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
        //date.setTime(date.getTime() + (days * 1000));
        var expires = "; expires=" + date.toGMTString();
    }
    else var expires = "";
    document.cookie = name + "=" + value + expires + "; path=/";

    var x = getCookie('branchName')
    if (x) {
        //alert(x);
        window.location('/Footfallcam/NewWeeklyStandardReport?MenuId=0&indexlist=position2');
    }
}

function numberWithCommas(x) {
    var parts = x.toString().split(".");
    parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    return parts.join(".");
}

function eraseCookie(name) {
    setCookie(name, "", -1);
}

//draw highchart in table
function drawSparkLine(num, colorScheme) {
    for (var i = 0; i < num.length; i++) {

        $(function () {
            Highcharts.setOptions({
                global: {
                    useUTC: false
                }
            });
            var chart = new Highcharts.Chart({

                chart: {
                    renderTo: "trend[" + i + "]",
                    margin: [0, 0, 0, 0],
                    backgroundColor: 'transparent'
                },
                title: {
                    text: ''
                },
                credits: {
                    enabled: false
                },
                xAxis: {
                    labels: {
                        enabled: false
                    }
                },
                yAxis: {
                    maxPadding: 0,
                    minPadding: 0,
                    gridLineWidth: 0,
                    endOnTick: false,
                    labels: {
                        enabled: false
                    }
                },
                legend: {
                    enabled: false
                },
                tooltip: {
                    enabled: false
                },
                plotOptions: {
                    series: {
                        enableMouseTracking: false,
                        lineWidth: 1,
                        shadow: false,
                        states: {
                            hover: {
                                lineWidth: 1
                            }
                        },
                        marker: {
                            //enabled:false,
                            radius: 0,
                            states: {
                                hover: {
                                    radius: 2
                                }
                            }
                        }
                    }
                },
                exporting: {
                    enabled: false,
                },
                series: [{
                    type: 'areaspline',
                    data: num[i],
                    color: colorScheme.chart.sparkLine.color,
                    fillOpacity: 0.5
                }]
            });
        });

    }
}


//draw highchart in this week and last week total
function drawSparkLineWeeks(data, colorScheme) {
    $("#last7daysSalesConversionGraph").removeClass("chartLoading");
    $("#this7daysSalesConversionGraph").removeClass("chartLoading");
    $('#totalSalesConversionLastUpDownPercent').empty();
    $('#totalSalesConversionThisUpDownPercent').empty();
    $('#totalSalesConversionLastWeek').empty();
    $('#totalSalesConversionThisWeek').empty();
    $('#totalSalesConversionLastWeekVal').empty();
    $("#totalSalesConversionLastUpDownPercent").removeClass("rise").removeClass("drop");
    $("#totalSalesConversionThisUpDownPercent").removeClass("rise").removeClass("drop");

    var totalSalesConversionLastTwoWeek = data.series[0].total == null || data.series[0].total == 0 ? "-" : data.series[0].total + "%";
    var totalSalesConversionLastWeekVal = data.series[1].total == null || data.series[1].total == 0 ? "-" : data.series[1].total + "%";
    var totalSalesConversionThisWeekVal = data.series[2].total == null || data.series[2].total == 0 ? "-" : data.series[2].total + "%";

    var totalSalesConversionChangesLastWeek = data.series[1].changes[0];
    var totalSalesConversionChangesThisWeek = data.series[2].changes[0];
    if (totalSalesConversionChangesLastWeek > 0) {
        $("#totalSalesConversionLastUpDownPercent").addClass("rise");
        $('#totalSalesConversionLastUpDownPercent').append("<i class='fa fa-caret-up'></i> " + totalSalesConversionChangesLastWeek + "%");
    }
    else if (totalSalesConversionChangesLastWeek < 0) {
        $("#totalSalesConversionLastUpDownPercent").addClass("drop");
        $('#totalSalesConversionLastUpDownPercent').append("<i class='fa fa-caret-down'></i> " + totalSalesConversionChangesLastWeek * -1 + "%");
    } else {
        $('#totalSalesConversionLastUpDownPercent').append(" - ");
    }


    if (totalSalesConversionChangesThisWeek > 0) {
        $("#totalSalesConversionThisUpDownPercent").addClass("rise");
        $('#totalSalesConversionThisUpDownPercent').append("<i class='fa fa-caret-up'></i> " + totalSalesConversionChangesThisWeek + "%");
    }
    else if (totalSalesConversionChangesThisWeek < 0) {
        $("#totalSalesConversionThisUpDownPercent").addClass("drop");
        $('#totalSalesConversionThisUpDownPercent').append("<i class='fa fa-caret-down'></i> " + totalSalesConversionChangesThisWeek * -1 + "%");
    } else {
        $('#totalSalesConversionThisUpDownPercent').append(" - ");
    }

    var thisWeekVisitorCountList = data.series[2].ValueIn;
    var thisWeekTransactionCountList = data.series[2].TransactionCount;
    var thisWeekTotalVisitorCount = data.series[2].visitorTotal;
    var thisWeekTotalTransactionCount = data.series[2].transactionTotal;
    var thisWeekTotalVisitorCountChanges = data.series[2].changesOfVisitorTotal;
    var thisWeekTotalTransactionCountChanges = data.series[2].changesOfTransactionCountTotal;

    $('#totalVisitorThisWeek').html(thisWeekTotalVisitorCount);
    $('#totalTransactionCountThisWeek').html(thisWeekTotalTransactionCount);

    //display value, changes and percentage
    $('#totalSalesConversionLastWeek').append(numberWithCommas(totalSalesConversionLastWeekVal));
    $('#totalSalesConversionThisWeek').append(numberWithCommas(totalSalesConversionThisWeekVal));

    var miniChartId = ['last7daysSalesConversionGraph', 'this7daysSalesConversionGraph', 'thisWeekVisitorGraph', 'thisWeekTransactionGraph'];
    var miniChartData = [data.series[1].data, data.series[2].data, thisWeekVisitorCountList, thisWeekTransactionCountList];
    //draw graph under each box, footfallcount
    for (var i = 0; i < miniChartData.length; i++) {
        $(function () {
            Highcharts.setOptions({
                global: {
                    useUTC: false
                }
            });

            var chart = new Highcharts.Chart({

                chart: {
                    renderTo: miniChartId[i],
                    margin: [0, 0, 0, 0],
                    backgroundColor: 'transparent'
                },
                title: {
                    text: ''
                },
                credits: {
                    enabled: false
                },
                xAxis: {
                    labels: {
                        enabled: false
                    }
                },
                yAxis: {
                    maxPadding: 0,
                    minPadding: 0,
                    gridLineWidth: 0,
                    endOnTick: false,
                    labels: {
                        enabled: false
                    }
                },
                legend: {
                    enabled: false
                },
                tooltip: {
                    enabled: false
                },
                plotOptions: {
                    series: {
                        enableMouseTracking: false,
                        lineWidth: 1,
                        shadow: false,
                        states: {
                            hover: {
                                lineWidth: 1
                            }
                        },
                        marker: {
                            //enabled:false,
                            radius: 0,
                            states: {
                                hover: {
                                    radius: 2
                                }
                            }
                        }
                    }
                },
                exporting: {
                    enabled: false,
                },
                series: [{
                    type: 'areaspline',
                    data: miniChartData[i],
                    color: colorScheme.chart.sparkLine.color,
                    fillOpacity: 0.5
                }]
            });
        });
    }
}