﻿//--------------General Function--------------//
function chartLoading() {
    loadingChart("newMonthlyTrend");
    $("#newMonthlyTrend").addClass("chartLoading");

    loadingChart("newWeeklyTrend");
    $("#newWeeklyTrend").addClass("chartLoading");

    loadingChart("newDailyTrend");
    $("#newDailyTrend").addClass("chartLoading");

    loadingChart("weekdaysTrafficProfile");
    $("#weekdaysTrafficProfile").addClass("chartLoading");

    loadingChart("weekendsTrafficProfile");
    $("#weekendsTrafficProfile").addClass("chartLoading");

}

var weekDay//share to all table

function showDayAndDate(startDate) {
    if (startDate != null) {
        var tempDate = startDate.split("/");
        //console.log(tempDate[2], tempDate[1], tempDate[0]);
        startDate = new Date(tempDate[2], tempDate[1] - 1, tempDate[0] - 1);
        var date = new Array();
        for (var i = 0 ; i < 7; i++)
            date.push(new Date(startDate.setDate(startDate.getDate() + 1)));
        var day = new Array(7);
        weekDay = new Array(7);
        day[0] = LanguageSun;
        day[1] = LanguageMon;
        day[2] = LanguageTue;
        day[3] = LanguageWed;
        day[4] = LanguageThu;
        day[5] = LanguageFri;
        day[6] = LanguageSat;
        for (var i = 0 ; i < 7; i++) {
            weekDay[i] = day[date[i].getDay()] + " " + date[i].getDate() + "/" + (date[i].getMonth() + 1);
        }
        return weekDay;
    }
    else
        return new Array(7);

}

//Centralized bind function
function bindData(data, colorScheme) {
    //bind Top Matric
    bindTopMatric(data[0].series[0], colorScheme);
    bindLeagueStatistics(data[1]);
    bindSalesConversionMonthlyTrend(data[2], colorScheme);
    bindSalesConversionWeeklyTrend(data[3],colorScheme);
    bindSalesConversionDailyTrend(data[4],colorScheme);
    bindWeekdaysWeekendsTrend(data[5], data[6], colorScheme);
    bindSiteStatistics(data[7].series[0], colorScheme);
    bindThisWeekScTableTrend(data[8].series[0]);
}

//function to bind top matric data only
function bindTopMatric(data, colorScheme) {
    bindLastTwoWeekSalesConversion(data, colorScheme);
    bindBestPerformDayTrend(data);
    bindOutsideTraffic(data, colorScheme);
    bindTurnInRate(data, colorScheme);
    bindTotalVisitor(data, colorScheme);
}

//Sales Conversion This Week and Last Week Highchart
function bindLastTwoWeekSalesConversion(data, colorScheme) {
    $("#lastWeekSalesConversion").empty();
    $("#thisWeekSalesConversion").empty();
    $("#changesInTwoWeeksSC").empty();
    $("#changesInTwoWeeksSC").removeClass("rise");
    $("#changesInTwoWeeksSC").removeClass("drop");
    $("#thisWeekGraph").empty();
    $("#lastWeekGraph").empty();


    var lastWeekTotal = data.LastWeekSalesConversion;
    var thisWeekTotal = data.SalesConversionTotal;
    var changesInTwoWeeks = data.DiffInSC;
    //$('#totalSCUpDownIcon').empty();

    if (lastWeekTotal >= 100)
        $("#lastWeekSalesConversion").append("100%");
    else if (lastWeekTotal == 0)
        $("#lastWeekSalesConversion").append("-");
    else
        $("#lastWeekSalesConversion").append(lastWeekTotal.toFixed(2) + "%");

    if (thisWeekTotal >= 100)
        $("#thisWeekSalesConversion").append("100%");
    else if (thisWeekTotal == 0)
        $("#thisWeekSalesConversion").append("-");
    else
        $("#thisWeekSalesConversion").append(thisWeekTotal.toFixed(2) + "%");
    $("#changesInTwoWeeksSC").removeClass("drop");
    $("#changesInTwoWeeksSC").removeClass("rise");

    if (lastWeekTotal != 0 && thisWeekTotal != 0) {
        if (changesInTwoWeeks > 0) {
            $("#changesInTwoWeeksSC").addClass("rise");
            //$('#totalSCUpDownIcon').append("<i class=\"fa fa-caret-up\" style=\"color: " + colorScheme.chart.arrow.up + "\">");
            $("#changesInTwoWeeksSC").append("<i class='fa fa-caret-up'></i> " + changesInTwoWeeks.toFixed(2) + "%");
        }
        else if (changesInTwoWeeks < 0) {
            $("#changesInTwoWeeksSC").addClass("drop");
            //$('#totalSCUpDownIcon').append("<i class=\"fa fa-caret-down\" style=\"color: " + colorScheme.chart.arrow.down + "\">");
            $("#changesInTwoWeeksSC").append("<i class='fa fa-caret-down'></i> " + changesInTwoWeeks.toFixed(2) + "%");
        }
        else
            $('#changesInTwoWeeksSC').append(LanguageNoChanges);

    }
    var miniChartId = ["thisWeekGraph", "lastWeekGraph"];
    var miniChartData = [data.SalesConversion, data.LWSalesConversionList];

    //draw graph under each box, footfallcount
    for (var i = 0; i < miniChartId.length; i++) {
        $(function () {
            Highcharts.setOptions({
                global: {
                    useUTC: false
                }
            });
            var chart = new Highcharts.Chart({

                chart: {
                    renderTo: miniChartId[i],
                    margin: [0, 0, 0, 0],
                    backgroundColor: 'transparent'
                },
                title: {
                    text: ''
                },
                credits: {
                    enabled: false
                },
                xAxis: {
                    labels: {
                        enabled: false
                    }
                },
                yAxis: {
                    maxPadding: 0,
                    minPadding: 0,
                    gridLineWidth: 0,
                    endOnTick: false,
                    labels: {
                        enabled: false
                    }
                },
                legend: {
                    enabled: false
                },
                tooltip: {
                    enabled: false
                },
                plotOptions: {
                    series: {
                        enableMouseTracking: false,
                        lineWidth: 1,
                        shadow: false,
                        states: {
                            hover: {
                                lineWidth: 1
                            }
                        },
                        marker: {
                            enabled: false,
                            radius: 0,
                            states: {
                                hover: {
                                    radius: 2
                                }
                            }
                        }
                    }
                },
                exporting: {
                    enabled: false,
                },
                series: [{
                    type: 'areaspline',
                    data: miniChartData[i],
                    color: colorScheme.chart.sparkLine.color,
                    fillOpacity: 0.5
                }]
            });
        });
    }
}

//OutsideTraffic HighChart
function bindOutsideTraffic(data, colorScheme) {

    $("#thisWeekOutsideTraffic").empty();
    $("#diffInOutsideTraffic").empty();
    $("#diffInOutsideTraffic").removeClass("rise");
    $("#diffInOutsideTraffic").removeClass("drop");
    $("#outsideTrafficGraph").empty();

    var total = data.OutsideTrafficTotal;
    var diff = data.DifferencesInOT;
    var graphData = data.OutsideTrafficInt;

    if (total > 0) {
        $("#thisWeekOutsideTraffic").append(numberWithCommas(total));
        plotMatricHighChartGraph("outsideTrafficGraph", graphData, colorScheme);
    } else {
        $("#thisWeekOutsideTraffic").append("-");
    }

    if (diff > 0) {
        $("#diffInOutsideTraffic").addClass("rise");
        $("#diffInOutsideTraffic").append("<i class='fa fa-caret-up'></i> " + diff.toFixed(2) + "%");
    }
    else if (diff < 0) {
        $("#diffInOutsideTraffic").addClass("drop");
        $("#diffInOutsideTraffic").append("<i class='fa fa-caret-down'></i> " + diff.toFixed(2) + "%");
    }
    else {
        $("#diffInOutsideTraffic").append(LanguageNoChanges);
    }
}

//TurnInRate
function bindTurnInRate(data, colorScheme) {

    $("#thisWeekTurnInRate").empty();
    $("#diffInTurnInRate").empty();
    $("#diffInTurnInRate").removeClass("rise");
    $("#diffInTurnInRate").removeClass("drop");
    $("#turnInRateGraph").empty();

    var total = data.TurnInRateTotal;
    var diff = data.DifferencesInTIR;
    var graphData = data.TIR;

    if (total > 0) {
        $("#thisWeekTurnInRate").append(total);
        plotMatricHighChartGraph("turnInRateGraph", graphData, colorScheme);
    } else {
        $("#thisWeekTurnInRate").append("-");
    }

    if (diff > 0) {
        $("#diffInTurnInRate").addClass("rise");
        $("#diffInTurnInRate").append("<i class='fa fa-caret-up'></i> " + diff.toFixed(2) + "%");
    }
    else if (diff < 0) {
        $("#diffInTurnInRate").addClass("drop");
        $("#diffInTurnInRate").append("<i class='fa fa-caret-down'></i> " + diff.toFixed(2) + "%");
    }
    else {
        $("#diffInTurnInRate").append(LanguageNoChanges);
    }
}

//Visitor
function bindTotalVisitor(data, colorScheme) {

    $("#thisWeekTotalVisitor").empty();
    $("#diffInTotalVisitor").empty();
    $("#diffInTotalVisitor").removeClass("rise");
    $("#diffInTotalVisitor").removeClass("drop");
    $("#totalVisitorGraph").empty();

    var total = data.visitorTotal;
    var diff = data.DifferencesInFF;
    var graphData = data.ValueInInt;

    if (total > 0) {
        $("#thisWeekTotalVisitor").append(numberWithCommas(total));
        plotMatricHighChartGraph("totalVisitorGraph", graphData, colorScheme);
    } else {
        $("#thisWeekTotalVisitor").append("-");
    }

    if (diff > 0) {
        $("#diffInTotalVisitor").addClass("rise");
        $("#diffInTotalVisitor").append("<i class='fa fa-caret-up'></i> " + diff.toFixed(2) + "%");
    }
    else if (diff < 0) {
        $("#diffInTotalVisitor").addClass("drop");
        $("#diffInTotalVisitor").append("<i class='fa fa-caret-down'></i> " + diff.toFixed(2) + "%");
    }
    else {
        $("#diffInTotalVisitor").append(LanguageNoChanges);
    }
}


//LeagueStatistics
function bindLeagueStatistics(data) {
    bindTopLeague(data.series[0]);
    bindBottomLeague(data.series[1]);
}

function bindTopLeague(data) {
    $("#topLeagueContent").empty();
    var html = "";
    for (var i = 0; i < data.branchCode.length; i++) {
        var index = i + 1;
        html += "<tr>";
        html += "<td width='20%'>" + index + "</td>";
        html += "<td>" + data.branchCode[i] + "</td>";
        html += "<td>" + data.branchName[i] + "</td>";
        html += "<td>" + data.SalesConversion[i].toFixed(2)+ "%</td>";
        if (data.DiffInScList[i] > 0) {
            html += "<td class='rise'>";
            html += "<i class='fa fa-caret-up'></i> " + data.DiffInScList[i].toFixed(2) + "%";
            html += "</td>"
        } else if (data.DiffInScList[i] < 0) {
            html += "<td class='drop'>";
            html += "<i class='fa fa-caret-down'></i> " + data.DiffInScList[i].toFixed(2) + "%";
            html += "</td>"
        } else {
            html += "<td>" + LanguageNoChanges + "</td>";
        }

        html += "</tr>";
    }
    $("#topLeagueContent").append(html);
}

function bindBottomLeague(data) {
    $("#bottomLeagueContent").empty();
    var html = "";
    for (var i = 0; i < data.branchCode.length; i++) {
        var index = i + 1;
        html += "<tr>";
        html += "<td width='80'>" + index + "</td>";
        html += "<td>" + data.branchCode[i] + "</td>";
        html += "<td>" + data.branchName[i] + "</td>";
        html += "<td>" + data.SalesConversion[i].toFixed(2) + "%</td>";
        if (data.DiffInScList[i] > 0) {
            html += "<td class='rise'>";
            html += "<i class='fa fa-caret-up'></i> " + data.DiffInScList[i].toFixed(2) + "%";
            html += "</td>"
        } else if (data.DiffInScList[i] < 0) {
            html += "<td class='drop'>";
            html += "<i class='fa fa-caret-down'></i> " + data.DiffInScList[i].toFixed(2) + "%";
            html += "</td>"
        } else {
            html += "<td>" + LanguageNoChanges + "</td>";
        }

        html += "</tr>";
    }
    $("#bottomLeagueContent").append(html);
}


//Sales Conversion Monthly Trend
function bindSalesConversionMonthlyTrend(data, colorScheme) {
    $(function () {
        var footfall = data.series[0].ValueInInt;
        var salesConversion = data.series[0].SalesConversion;

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < footfall.length; i++) {
            if (footfall[i] != null && footfall[i] != undefined && footfall[i]> largestValue)
                largestValue = footfall[i]
        }

        for (var i = 0; i < salesConversion.length; i++) {
            if (salesConversion[i] != null && salesConversion[i] != undefined && salesConversion[i] > largestValue)
                largestValue = salesConversion[i]
        }

        //var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
        //                       : largestValue >= 10 && largestValue < 100 ? 10
        //                       : largestValue >= 100 && largestValue < 1000 ? 100
        //                       : largestValue > 1000 && largestValue < 10000 ? 1000
        //                       : largestValue >= 10000 && largestValue < 100000 ? 10000
        //                       : largestValue >= 100000 && largestValue < 1000000 ? 100000
        //                       : 1000000;
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "newMonthlyTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'column',
                name: LanguageNoofVisitor,
                data: footfall,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageSalesConversion +" (%)",
                dashStyle: 'dash',
                data: salesConversion,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1,
                yAxis: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //text: LanguageMonthlyTrend,
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.salesConversion,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    },
                    point: {
                        events: {
                            click: function () {
                                location.href = "Analytics?type=" + this.category.name + "&range=day&parameter=19&branchId=-1&compare=1";
                            }
                        }
                    },
                    cursor: 'pointer'
                }
            },
            yAxis: [{
                lineWidth: 0,
                tickWidth: 1,
                min: 0,
                gridLineWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                labels: {
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
            },
            {
                opposite: true,
                lineWidth: 0,
                tickWidth: 0,
                min: 0,
                gridLineWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                title: {
                    text: LanguageSalesConversion + " (%)",
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                title: {
                    text: LanguageMonth,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 6,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 18,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            },
        });
    });
}

//SC Table Content
function bindThisWeekScTableTrend(data) {
    var weekNo = $('#weekpicker').val();
    weekNo = LanguageWeek + " " + weekNumber;

    $("#lastTwoWeeksSCTableHead").html("");
    $("#lastTwoWeeksSCTableContent").html("");
    $("#lastTwoWeeksSCTableFoot").html("");
    $("#lastTwoWeeksSCTableHead").append("<tr><th>" + weekNo + "</th><th>" + LanguageNoofVisitor + "</th><th>" + LanguageNumberofTransaction + "</th><th>" + LanguageConversion + "</th></tr>");

    var visitor = 0;
    var sales = 0;
    var salesConversion = 0;

    for (var i = 0; i < 7; i++) {
        visitor = data.ValueInInt[i];
        sales = data.TransactionCountInt[i];
        salesConversion = data.SalesConversion[i];

        if (visitor == 0 || sales == 0 || salesConversion == 0) {
            salesConversion = " - ";
        }
        

        visitor = visitor == 0 ? " - " : visitor;
        sales = sales == 0 ? " - " : sales;
        $("#lastTwoWeeksSCTableContent").append("<tr><td>" + data.dayOfTheWeek[i] + "</td><td>" + numberWithCommas(visitor) + "</td><td>" + numberWithCommas(sales) + "</td><td>" + salesConversion.toFixed(2) + "% </td></tr>");
    }

    var totalVisitor = data.visitorTotal;
    var totalSales = data.transactionTotal;
    var totalSalesConversion = data.SalesConversionTotal;

    if (totalVisitor == 0 || totalSales == 0 || totalSalesConversion == 0) {
        totalSalesConversion = " - ";
    }
    else {
        totalSalesConversion = totalSalesConversion.toFixed(2) + "%";
    }

    $("#lastTwoWeeksSCTableFoot").append("<tr><td>" + LanguageTotal + "</td><td>" + numberWithCommas(totalVisitor) + "</td><td>" + numberWithCommas(totalSales) + "</td><td>" + totalSalesConversion + "</td></tr>");
}


//Sales Conversion Weekly Trend
function bindSalesConversionWeeklyTrend(data, colorScheme) {
    var tempWeek = [];
    for (var i = 1; i <= data.categories.length; i++) {
        tempWeek.push(i);
    }

    var footfall = data.series[0].ValueInInt;
    var salesConversion = data.series[0].SalesConversion;

    //identify largest value of yaxis data
    //var largestValue = 0;
    //for (var i = 0; i < footfall.data.length; i++) {
    //    if (footfall[i] != null && footfall[i] != undefined && footfall[i] > largestValue)
    //        largestValue = footfall[i]
    //}

    //for (var i = 0; i < salesConversion.length; i++) {
    //    if (salesConversion[i] != null && salesConversion[i] != undefined && salesConversion[i] > largestValue)
    //        largestValue = salesConversion[i]
    //}

    //var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
    //                           : largestValue >= 10 && largestValue < 100 ? 10
    //                           : largestValue >= 100 && largestValue < 1000 ? 100
    //                           : largestValue >= 1000 && largestValue < 10000 ? 1000
    //                           : largestValue >= 10000 && largestValue < 100000 ? 10000
    //                           : largestValue >= 100000 && largestValue < 1000000 ? 100000
    //                           : 1000000;

    $(function () {

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "newWeeklyTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
                alignTicks: false
            },
            series: [{
                type: 'column',
                name: LanguageNoofVisitor,
                data: footfall,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            },
            {
                type: 'line',
                name: LanguageSalesConversion + " (%)",
                dashStyle: 'dash',
                data: salesConversion,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1,
                yAxis:1

            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //text: LanguageWeeklyTrend,
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.salesConversion,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    },
                    point: {
                        events: {
                            click: function () {
                                location.href = "Analytics?type=w" + this.category.name + "&range=day&parameter=19&branchId=" + $("#selectBoxBranch").val() + "&compare=1";
                            }
                        }
                    },
                    cursor: 'pointer'
                }
            },
            yAxis: [{
                lineWidth: 0,
                min: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                min: 0
            },
           {
               opposite: true,
               lineWidth: 0,
               tickWidth: 0,
               min: 0,
               gridLineWidth: 1,
               // tickInterval: dynamicTickInterval,
               tickPixelInterval: 15,
               tickPosition: 'inside',
               title: {
                   text: LanguageSalesConversion + " (%)",
                   color: colorScheme.chart.axisLabel.y.title.color,
                   fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                   "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
               },
               labels: {
                   style: {
                       "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                       color: colorScheme.chart.axisLabel.y.label.color,
                       fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                   }
               },
               min: 0
           }],
            xAxis: {
                min: 0,
                categories: tempWeek,
                tickWidth: 0,
                tickInterval: 1,
                title: {
                    text: LanguageWeek,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 206,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            },
        });
    });
}

//Sales Conversion Daily Trend
function bindSalesConversionDailyTrend(data, colorScheme) {
    var footfall = data.series[0].ValueInInt;
    var salesConversion = data.series[0].SalesConversion;

    //identify largest value of yaxis data
    //var largestValue = 0;
    //for (var i = 0; i < footfall.data.length; i++) {
    //    if (footfall[i] != null && footfall[i] != undefined && footfall[i] > largestValue)
    //        largestValue = footfall[i]
    //}

    //for (var i = 0; i < salesvolume.data.length; i++) {
    //    if (salesConversion[i] != null && salesConversion[i] != undefined && salesConversion[i] > largestValue)
    //        largestValue = salesConversion[i]
    //}

    //var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
    //                       : largestValue >= 10 && largestValue < 100 ? 10
    //                       : largestValue >= 100 && largestValue < 1000 ? 100
    //                       : largestValue > 1000 && largestValue < 10000 ? 1000
    //                       : largestValue >= 10000 && largestValue < 100000 ? 10000
    //                       : largestValue >= 100000 && largestValue < 1000000 ? 100000
    //                       : 1000000;

    $(function () {


        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "newDailyTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                }
            },
            series: [{
                type: 'column',
                name: LanguageNoofVisitor,
                data: footfall,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageSalesConversion + " (%)",
                dashStyle: 'dash',
                data: salesConversion,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1,
                yAxis:1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //text: LanguageDailyTrend,
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.salesConversion,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    }
                }
            },
            yAxis: [{
                lineWidth: 0,
                min: 0,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickWidth: 1,
                gridLineWidth: 1,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            {
                opposite: true,
                lineWidth: 0,
                min: 0,
                gridLineWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickWidth: 0,
                tickPosition: 'inside',
                title: {
                    text: LanguageSalesConversion + " (%)",
                    margin: 25,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                tickInterval: 1,
                title: {
                    text: LanguageDay,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 206,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            },
        });
    });
}

function bindBestPerformDayTrend(data) {
    //var weekDay = ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"];
    //var salesConversionByDay = 0;
    //var salesConversion = [];
    //var index = 0;
    //var valuesIn = 0;
    //var transactionCount = 0;
    //var count = 0;
    //for (var i = 1; i <= data.series[0].data.length; i++) {
    //    valuesIn += data.series[0].data[i - 1];
    //    transactionCount += data.series[1].data[i - 1];
    //    if (i % 24 == 0) {
    //        if (valuesIn != 0)
    //            salesConversionByDay = +((transactionCount * 100.0 / valuesIn).toFixed(2));
    //        else
    //            salesConversionByDay = 0;
    //        salesConversion.push(salesConversionByDay);
    //        index++;
    //        tempArr = [];
    //        valuesIn = 0;
    //        transactionCount = 0;
    //    }
    //}
    //var highestSC = salesConversion[0];
    //var highestIndex = 0;
    //for (var i = 0; i < salesConversion.length; i++) {
    //    if (highestSC <= salesConversion[i]) {
    //        highestSC = salesConversion[i];
    //        highestIndex = i;
    //    }
    //}
    //console.log(salesConversion);
    //console.log("The best perform day = " + weekDay[highestIndex]);
    //console.log("The best perform sales conversion = " + highestSC); 3
    $("#bestPerformDay").empty();
    $("#totalBestPerformSC").empty();
    var highestSC = data.BestNumber;
    var bestDay = data.BestDay;

    if (highestSC >= 100)
        $("#totalBestPerformSC").append("100%");
    else
        $("#totalBestPerformSC").append(highestSC.toFixed(2) + "%");
    $("#bestPerformDay").append(bestDay);
}

//Weekdays and Weekends Trend
function bindWeekdaysWeekendsTrend(data, data1, colorScheme) {
    var weekdaysnoofvisitor = data.series[0].ValueInInt;
    var weekdayssalesvolume = data.series[0].SalesConversion;
    var weekendsnoofvisitor = data1.series[0].ValueInInt;
    var weekendssalesvolume = data1.series[0].SalesConversion;
    //identify largest value of yaxis data
    //var largestValue = 0;

    //identify largest value of yaxis data
    //var largestValue = 0;
    //for (var i = 0; i < weekdaysnoofvisitor.data.length; i++) {
    //    if (weekdaysnoofvisitor.data[i] != null && weekdaysnoofvisitor.data[i] != undefined && weekdaysnoofvisitor.data[i] > largestValue)
    //        largestValue = weekdaysnoofvisitor.data[i]
    //}
    //for (var i = 0; i < weekdayssalesvolume.data.length; i++) {
    //    if (weekdayssalesConversion[i] != null && weekdayssalesConversion[i] != undefined && weekdayssalesConversion[i] > largestValue)
    //        largestValue = weekdayssalesConversion[i]
    //}
    //for (var i = 0; i < weekendsnoofvisitor.data.length; i++) {
    //    if (weekendsnoofvisitor.data[i] != null && weekendsnoofvisitor.data[i] != undefined && weekendsnoofvisitor.data[i] > largestValue)
    //        largestValue = weekendsnoofvisitor.data[i]
    //}
    //for (var i = 0; i < weekendssalesvolume.data.length; i++) {
    //    if (weekendssalesConversion[i] != null && weekendssalesConversion[i] != undefined && weekendssalesConversion[i] > largestValue)
    //        largestValue = weekendssalesConversion[i]
    //}

    //var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
    //                           : largestValue >= 10 && largestValue < 100 ? 10
    //                           : largestValue >= 100 && largestValue < 1000 ? 100
    //                           : largestValue >= 1000 && largestValue < 10000 ? 1000
    //                           : largestValue >= 10000 && largestValue < 100000 ? 10000
    //                           : largestValue >= 100000 && largestValue < 1000000 ? 100000
    //                           : 1000000;

    //weekdays trend
    $(function () {

        var showMarker = true;
        var showPopUp = true;
        //if (data.series[0].isDayOff) {
        //    showMarker = false;
        //    showPopUp = false;
        //}

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "weekdaysTrafficProfile",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'column',
                name: LanguageNoofVisitor,
                data: weekdaysnoofvisitor,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageSalesConversion + " (%)",
                dashStyle: 'dash',
                data: weekdayssalesvolume,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1,
                yAxis: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
            },
            subtitle: {
                //useHTML: true,
                text: LanguageWeekdays,// + " " + "<i class='fa fa-question-circle' title='" + LanguageHourlyaveragepercentofspendingvisitorsfromMondaytoFriday + "'></i>",
                align: 'center',
                style: {
                    color: colorScheme.chart.subtitle.color,
                    fontSize: colorScheme.chart.subtitle.fontSize,
                    "font-family": colorScheme.chart.subtitle.fontFamily
                },
                margin: 0,
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false,
                        states: {
                            hover: {
                                enabled: showMarker
                            }
                        }
                    }
                }
            },
            yAxis: [{
                lineWidth: 0,
                min: 0,
                tickWidth: 1,
                gridLineWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
            },
            {
                opposite: true,
                lineWidth: 0,
                tickWidth: 0,
                min: 0,
                max: 100,
                gridLineWidth: 0,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                title: {
                    text: LanguageSalesConversion + " (%)",
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                //itemStyle: {
                //    color: colorScheme.chart.legend.text.color,
                //    "font-family": colorScheme.chart.legend.text.fontFamily,
                //    fontSize: colorScheme.chart.legend.text.fontSize,
                //    "font-weight": colorScheme.chart.legend.text.fontWeight
                //},
                enabled: false,
                //x: 60,
                //y: 15,
                //verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
                enabled: showPopUp
            },
        });
        //if (data.series[0].isDayOff) {
        //    $("#weekdaysTrafficProfile").append("<div class='weekday-notice'>" + LanguageCloseonWeekdays + "</div>");
        //}
    });


    //weekends trend
    $(function () {
        var showMarker = true;
        var showPopUp = true;
        //if (data1.series[0].isDayOff) {
        //    showMarker = false;
        //    showPopUp = false;
        //}

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "weekendsTrafficProfile",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'column',
                name: LanguageNoofVisitor,
                data: weekendsnoofvisitor,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageSalesConversion + " (%)",
                dashStyle: 'dash',
                data: weekendssalesvolume,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1,
                yAxis: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
            },
            subtitle: {
                //useHTML: true,
                text: LanguageWeekends,// + " " + "<i class='fa fa-question-circle' title='" + LanguageHourlyaveragepercentofspendingvisitorsforSaturdayandSunday + "'></i>",
                align: 'center',
                style: {
                    color: colorScheme.chart.subtitle.color,
                    fontSize: colorScheme.chart.subtitle.fontSize,
                    "font-family": colorScheme.chart.subtitle.fontFamily
                },
                margin: 0,
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false,
                        states: {
                            hover: {
                                enabled: showMarker
                            }
                        }
                    }
                }
            },
            yAxis: [{
                lineWidth: 0,
                min: 0,
                tickWidth: 1,
                gridLineWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            {
                opposite: true,
                tickWidth: 0,
                lineWidth: 0,
                min: 0,
                max: 100,
                gridLineWidth: 0,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                title: {
                    text: LanguageSalesConversion + " (%)",
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                }
            }],
            xAxis: {
                categories: data1.categories,
                tickWidth: 0,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                //itemStyle: {
                //    color: colorScheme.chart.legend.text.color,
                //    "font-family": colorScheme.chart.legend.text.fontFamily,
                //    fontSize: colorScheme.chart.legend.text.fontSize,
                //    "font-weight": colorScheme.chart.legend.text.fontWeight
                //},
                enabled: false,
                //x: 60,
                //y: 15,
                //verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
                enabled: showPopUp
            },
        });
        //if (data1.series[0].isDayOff) {
        //    $("#weekendsTrafficProfile").append("<div class='weekend-notice'>" + LanguageCloseonWeekends + "</div>");
        //}
    });

}


//Site Statistics
function bindSiteStatistics(data, colorScheme) {
    var html = "";
    var indexCount = data.branchCode.length;
    var dayTrendData = [];
    for (var index = 0; index < indexCount; index++) {
        html += "<tr>";
        html += "<td>" + data.branchCode[index] + "</td>";
        html += "<td>" + data.branchName[index] + "</td>";
        if (data.SalesConversion[index] === 0) {
            html += "<td>-</td>";
        } else {
            html += "<td>" + data.SalesConversion[index].toFixed(2) + "</td>";
        }

        if (data.DiffInScList[index] < 0) {
            html += "<td class='drop'><i class='fa fa-caret-down'></i> " + data.DiffInScList[index].toFixed(2) + "%</td>";
        } else if (data.DiffInScList[index] > 0){
            html += "<td class='rise'><i class='fa fa-caret-up'></i> " + data.DiffInScList[index].toFixed(2)+ "%</td>";
        } else {
            html += "<td>" + LanguageNoChanges + "</td>";
        }

        if (data.TIR[index] === 0) {
            html += "<td>-</td>";
        } else {
            html += "<td>" + data.TIR[index].toFixed(2) + "</td>";
        }

        if (data.DiffInTIRList[index] < 0) {
            html += "<td class='drop'><i class='fa fa-caret-down'></i> " + data.DiffInTIRList[index].toFixed(2) + "%</td>";
        } else if (data.DiffInTIRList[index] > 0) {
            html += "<td class='rise'><i class='fa fa-caret-up'></i> " + data.DiffInTIRList[index].toFixed(2) + "%</td>";
        } else {
            html += "<td>" + LanguageNoChanges + "</td>";
        }
        html += "<td id='trend[" + index + "]' class='highchartTable'></td>";


        if (data.SalesConversion[index] === 0) {
            html += "<td>-</td>";
        } else {
            html += "<td>" + data.Rank[index] + "</td>";
        }
        html += "</tr>";

    }
    $("#SalesConversionTableContent").append(html);
    drawSparkLine(data.SevenDayTrend, colorScheme);

    
}

function drawSparkLine(num, colorScheme) {
    //draw graph under each box, footfallcount
    for (var i = 0; i < num.length; i++) {

        $(function () {
            Highcharts.setOptions({
                global: {
                    useUTC: false
                }
            });
            var chart = new Highcharts.Chart({

                chart: {
                    renderTo: "trend[" + i + "]",
                    margin: [0, 0, 0, 0],
                    backgroundColor: 'transparent'
                },
                title: {
                    text: ''
                },
                credits: {
                    enabled: false
                },
                xAxis: {
                    labels: {
                        enabled: false
                    }
                },
                yAxis: {
                    maxPadding: 0,
                    minPadding: 0,
                    gridLineWidth: 0,
                    endOnTick: false,
                    labels: {
                        enabled: false
                    }
                },
                legend: {
                    enabled: false
                },
                tooltip: {
                    enabled: false
                },
                plotOptions: {
                    series: {
                        enableMouseTracking: false,
                        lineWidth: 1,
                        shadow: false,
                        states: {
                            hover: {
                                lineWidth: 1
                            }
                        },
                        marker: {
                            //enabled:false,
                            radius: 0,
                            states: {
                                hover: {
                                    radius: 2
                                }
                            }
                        }
                    }
                },
                exporting: {
                    enabled: false,
                },
                series: [{
                    type: 'areaspline',
                    data: num[i],
                    color: colorScheme.chart.sparkLine.color,
                    fillOpacity: 0.5
                }]
            });
        });

    }
}























function CompanyWideSalesConversionTable(data, colorScheme) {
    var temp = new Array();
    for (var i = 0; i < data.series[0].data.length; i++) {
        temp[i] = data.series[0].data[i];
    }
    temp.sort(function (a, b) { return b - a });
    var changes = "";
    var compareA = 0;
    var index = 0;
    var num = [];
    var tempArr = [];
    var sparkObject = {};
    for (var i = 1; i <= data.series[4].data.length; i++) {
        tempArr.push(data.series[4].data[i - 1]);
        if (i % 7 == 0) {
            num[index] = tempArr;
            index++;
            tempArr = [];
        }
    }
    $("#SalesConversionTableHead").html("");
    $("#SalesConversionTableContent").html("");
    //$("#SalesConversionTable").append("<colgroup><col width=\"60\" /><col width=\"180\" /><col width=\"100\" /><col width=\"80\" /><col width=\"80\" /><col width=\"80\" /><col width=\"180\" /></colgroup>");
    $("#SalesConversionTable").append("<colgroup><col width='4%' /><col width='16%' /><col width='16%' /><col width='16%' /><col width='16%' /><col width='16%' /><col width='16%' /></colgroup>");
    $("#SalesConversionTableHead").append("<tr><th>" + LanguageRank + "</th><th>" + LanguageBranch + "</th><th>" + LanguageThisWeek + " (%)</th><th>" + LanguageChangesfromLastWeek + " (%)</th><th>" + LanguageNumberofTransaction + "</th><th>" + LanguageSalesAmount + " (£)</th><th>" + LanguageTrend + "</th></tr>");
    for (var i = 0; i < data.series[0].data.length; i++) {
        var ranking = 0;
        for (var a = 0; a < temp.length; a++) {
            if (data.series[0].data[i] == temp[a]) {
                ranking = a + 1;
            }
        }
        var SCtrend = "<td id=\"trend[" + i + "]\" class='highchartTable'></td>";
        if (data.series[1].data[i] != 0) {
            var aChanges = data.series[1].data[i];
            if (data.series[1].data[i] < 0) {
                changes = "<td class='drop'><i class='fa fa-caret-down'></i> " + aChanges.toFixed(2).substring(1) + "%</td>";
            }
            else {
                changes = "<td class='rise'><i class='fa fa-caret-up'></i> " + Number(aChanges).toFixed(2) + "%</td>";
            }
        }
        else
            changes = "<td> - </td>";

        $("#SalesConversionTableContent").append("<tr><td>" + ranking + "</td><td><div class=\"branchNameClass\" onclick=\"setCookie('branchName'," + data.series[0].branchId[i] + ",1)\">" + data.series[0].branchName[i] + "</div></td><td>" + Number(data.series[0].data[i]).toFixed(2) + "</td>" + changes + "<td>" + Number(data.series[2].data[i]).toFixed(0) + "</td><td>" + Number(data.series[3].data[i]).toFixed(2) + "</td>" + SCtrend + "</tr>");
    }

    drawSparkLine(num, colorScheme);

}

function setCookie(name, value, days) {
    if (days) {
        var date = new Date();
        date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
        var expires = "; expires=" + date.toGMTString();
    }
    else var expires = "";
    document.cookie = name + "=" + value + expires + "; path=/";

    var x = getCookie('branchName')
    if (x) {
        //alert(x);
        window.open('/Footfallcam/NewWeeklyStandardReport?MenuId=0&indexlist=position2');
    }
}

//draw highchart in table

function bindBestStoreThisWeek(data) {
    var bestStore = data.series[0].branchName[0];
    var bestSalesConversion = data.series[0].data[0];
    for (var i = 0; i < data.series[0].data.length; i++) {
        if (data.series[0].data[i] > bestSalesConversion) {
            bestStore = data.series[0].branchName[i];
            bestSalesConversion = data.series[0].data[i];
        }
    }
    $("#bestPerformStore").html('');
    $("#totalBestPerformSC").html('');

    $("#bestPerformStore").append(bestStore);
    $("#totalBestPerformSC").append(bestSalesConversion.toFixed(2) + "%");

}

function plotMatricHighChartGraph(matricGraphId, data, colorScheme) {
    var chart = new Highcharts.Chart(
        {
            chart: {
                margin: [0, 0, 0, 0],
                backgroundColor: "transparent",
                renderTo: matricGraphId
            },
            title: {
                text: ''
            },
            credits: {
                enabled: false
            },
            xAxis: {
                labels: {
                    enabled: false
                }
            },
            yAxis: {
                maxPadding: 0,
                minPadding: 0,
                gridLineWidth: 0,
                endOnTick: false,
                labels: {
                    enabled: false
                }
            },
            legend: {
                enabled: false
            },
            tooltip: {
                enabled: false
            },
            plotOptions: {
                series: {
                    enableMouseTracking: false,
                    lineWidth: 1,
                    shadow: false,
                    states: {
                        hover: {
                            lineWidth: 1
                        }
                    },
                    marker: {
                        enabled: false,
                        radius: 0,
                        states: {
                            hover: {
                                radius: 2
                            }
                        }
                    }
                }
            },
            exporting: {
                enabled: false,
            },
            series: [{
                type: "areaspline",
                data: data,
                color: colorScheme.chart.sparkLine.color,
                fillOpacity: 0.5
                //data[miniChartData[i]].series[1].data
            }]
        });
}

function emptyAll() {
    $("#thisWeekSalesConversion").empty();
    $("#thisWeekGraph").empty();
    $("#lastWeekSalesConversion").empty();
    $("#lastWeekGraph").empty();
    $("#changesInTwoWeeksSC").empty();
    $("#bestPerformDay").empty();
    $("#totalBestPerformSC").empty();

    $("#thisWeekOutsideTraffic").empty();
    $("#diffInOutsideTraffic").empty();
    $("#outsideTrafficGraph").empty();

    $("#thisWeekTurnInRate").empty();
    $("#diffInTurnInRate").empty();
    $("#turnInRateGraph").empty();

    $("#thisWeekTotalVisitor").empty();
    $("#diffInTotalVisitor").empty();
    $("#totalVisitorGraph").empty();

    $("#topLeagueContent").empty();
    $("#bottomLeagueContent").empty();
    $("#SalesConversionTableContent").empty();

    $("#lastTwoWeeksSCTableHead").html("");
    $("#lastTwoWeeksSCTableContent").html("");
    $("#lastTwoWeeksSCTableFoot").html("");
}

function numberWithCommas(x) {
    var parts = x.toString().split(".");
    parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    return parts.join(".");
}

