﻿function tagRightPanel(eslId) {
    var param = "id=" + eslId;
    ShowRightPanel("EShelfLabel", "Details", param);
}

function UpdateTag(tagId) {
    var tag = {
        Id: tagId,
        Serial: $("#detailTagSerial").val(),
        ProductId: $("#detailTagProduct").val(),
        Price: $("#detailTagPrice").val(),
        Channel: $("#detailTagChannel").val(),
        BranchId: $("#branchESLFilter").val(),
        ESLTemplateId: $("#templateSelection input[name='modalTemplateRadio']").val()
    };
    var requestURL = "/EShelfLabel/Edit/";
    var ajaxMethod = "POST";
    prompt(
        "Updating Tag",
        "Please wait . . . ",
        ""
    );
    $.ajax({
        type: ajaxMethod,
        url: requestURL,
        data: JSON.stringify(tag),
        dataType: 'json',
        contentType: 'application/json',
        success: function (response) {
            $("#generalDialog").modal("hide");
            if (response.IsSuccessful) {
                prompt(
                    "Success",
                    "Tag is updated.",
                    $("<button></button>")
                        .addClass("btn btn-primary")
                        .text("Refresh List")
                        .attr("data-dismiss", "modal")
                        .click(closeRightPanel)
                );
            }
            else {
                prompt(
                    "Failed",
                    "Failed to update tag.",
                    $("<button></button>")
                        .addClass("btn btn-primary")
                        .text("Close")
                        .attr("data-dismiss", "modal")
                );
            }
        },
        error: function (request, status, error) {
            $("#generalDialog").modal("hide");
            prompt(
                "Error",
                "Error " + status + ": " + error,
                $("<button></button>")
                    .addClass("btn btn-primary")
                    .text("Close")
                    .attr("data-dismiss", "modal")
            );
            console.log(request);
            console.log(status);
            console.log(error);
        }
    });
}

function DeleteTag(tagId) {
    var tag = {
        Id: tagId,
        Serial: $("#detailTagSerial").val()
    };
    var requestURL = "/EShelfLabel/Delete/";
    var ajaxMethod = "POST";
    prompt(
        "Deleting Tag",
        "Please wait . . . ",
        ""
    );
    $.ajax({
        type: ajaxMethod,
        url: requestURL,
        data: JSON.stringify(tag),
        dataType: 'json',
        contentType: 'application/json',
        success: function (response) {
            $("#generalDialog").modal("hide");
            if (response.IsSuccessful) {
                prompt(
                    "Success",
                    "Tag is deleted.",
                    $("<button></button>")
                        .addClass("btn btn-primary")
                        .text("Refresh List")
                        .attr("data-dismiss", "modal")
                        .click(closeRightPanel)
                );
            }
            else {
                prompt(
                    "Failed",
                    "Failed to delete tag.",
                    $("<button></button>")
                        .addClass("btn btn-primary")
                        .text("Close")
                        .attr("data-dismiss", "modal")
                );
            }
        },
        error: function (request, status, error) {
            $("#generalDialog").modal("hide");
            prompt(
                "Error",
                "Error " + status + ": " + error,
                $("<button></button>")
                    .addClass("btn btn-primary")
                    .text("Close")
                    .attr("data-dismiss", "modal")
            );
            console.log(request);
            console.log(status);
            console.log(error);
        }
    });

}

function closeRightPanel() {
    getTags($("#branchESLFilter").val());
    $(".closeRightPanelButton").click();
}
