function getTags(branchId) {
    var requestURL = "/EShelfLabel/GetTags?branchId=" + branchId;
    var ajaxMethod = "GET";
    prompt(
        "Please wait",
        "Updating tag list",
        ''
    );
    $.ajax({
        type: ajaxMethod,
        url: requestURL,
        dataType: 'json',
        contentType: 'application/json',
        success: function (response) {
            $("#generalDialog").modal("hide");
            if (response.IsSuccessful) {
                var data = response.Data;
                var headArray = ["Serial", "Price", "Product", "Channel","Updated"/*, "TemplateId"*/];
                var bodyArray = [];
                for (var i = 0; i < data.length; i++) {
                    bodyArray.push([
                        data[i].Id,
                        data[i].Serial,
                        data[i].Price,
                        data[i].ProductName,
                        data[i].Channel === null ? "N/A" : data[i].Channel,
                        data[i].Updated === true ? "<span class='fa fa-check'/>" : "<span class='fa fa-times'/>"
                        //data[i].ImagePath === null ? "N/A" : '<img src="' + data[i].ImagePath+'"/>'

                    ]);
                }
                recreateTable("refreshTableTagList", "tableTagList", headArray, bodyArray);
                BindTagListTable();
            }
            else {
                prompt("Error", "No ESL Tag retrieved.", $("<button></button>")
                    .addClass("btn btn-primary")
                    .text("Close")
                    .attr("data-dismiss", "modal"));
            }
        },
        error: function (request, status, error) {
            $("#generalDialog").modal("hide");
            prompt(
                "Error",
                "Error " + status + ": " + error,
                $("<button></button>")
                    .addClass("btn btn-primary")
                    .text("Close")
                    .attr("data-dismiss", "modal")
            );
            console.log(request);
            console.log(status);
            console.log(error);
        }
    });
}

function recreateTable(parentId, childId, headArray, bodyArray) {
    //Recreate empty table
    var parentElement = $("#" + parentId);
    parentElement.html('');
    var tableElement = $("<table></table>").attr("id", childId).addClass("table-bordered");
    //thead section
    var tableHead = $("<thead></thead>");
    var tableHeadRow = $("<tr></tr>");
    for (var i = 0; i < headArray.length; i++) {
        tableHeadRow.append(
            $("<th></th>").append(headArray[i])
        );
    }
    tableHead.append(tableHeadRow);
    tableElement.append(tableHead);
    //tbody section
    var tableBody = $("<tbody></tbody>");
    for (var i = 0; i < bodyArray.length; i++) {
        var trElement = $("<tr>");
        trElement.attr("onclick", "tagRightPanel('" + bodyArray[i][0] + "')");
        for (var j = 1; j <= headArray.length; j++) {
            trElement.append($("<td>").append(bodyArray[i][j]));
        }
        tableBody.append(trElement);
    }
    tableElement.append(tableBody);
    parentElement.append(tableElement);
}

function addSingleTag() {
    //if (validateSingleProductForm()) {
    //    return;
    //}
    $("#modalAddSingleTag").modal("toggle");
    var tagObject = {
        Serial: $("#tagSerial").val(),
        Price: $("#tagPrice").val(),
        BranchId: $("#tagBranch").val(),
        Channel: $("#tagChannel").val(),
        ProductId: $("#tagProduct").val(),
        ESLTemplateId: $("input[name=modalTemplateRadio]:checked").val()
    };
    var requestURL = "/EShelfLabel/Create";
    var ajaxMethod = "POST";
    prompt(
        "Creating tag",
        "Please wait . . . "
    );
    $.ajax({
        type: ajaxMethod,
        url: requestURL,
        data: JSON.stringify(tagObject),
        dataType: 'json',
        contentType: 'application/json',
        success: function (response) {
            $("#generalDialog").modal("hide");
            if (response.IsSuccessful) {
                prompt(
                    "Success",
                    "Tag is created",
                    $("<button></button>")
                        .addClass("btn btn-primary")
                        .text("Refresh List")
                        .attr("data-dismiss", "modal")
                        .click(function () {
                            getTags($("#branchESLFilter").val());
                        })
                );
            }
            else {
                prompt(
                    "Failed",
                    "Failed to create Tag",
                    $("<button></button>")
                        .addClass("btn btn-primary")
                        .text("Close")
                        .attr("data-dismiss", "modal")
                );
            }
        },
        error: function (request, status, error) {
            $("#generalDialog").modal("hide");
            prompt(
                "Error",
                "Error " + status + ": " + error,
                $("<button></button>")
                    .addClass("btn btn-primary")
                    .text("Close")
                    .attr("data-dismiss", "modal")
            );
            console.log(request);
            console.log(status);
            console.log(error);
        }
    });
}

function BindAddTag() {
    $("#addTag")
        .on('change', function (event) {
            modalPopup($(this).val());
            $("#addTag").val(-1);
        });
}

function modalPopup(value) {
    switch (value) {
        case "1":
            //clearSingleProductInput();
            $("#modalAddSingleTag").modal("show");
            break;
        case "2":
            //clearProductFileInput();
            $("#modalBulkImport").modal("show");
            break;
    }
}

function BindTagListTable() {
    $("#tableTagList").DataTable();
}

function createTemplate(CompanyId, Label, Price, StartPointX, StartPointY, EndPointX, EndPointY, FontType, FontSize, FontStyle) {
    var CounterObject = {
        CompanyId: 10,
        FontType: "Arial",
        StartPointX: 0,
        StartPointY: 0,
        EndPointX: 200,
        EndPointY: 122
    };
    var requestURL = "/EShelfLabel/ajaxCreateTemplate";
    var ajaxMethod = "POST";
    prompt(
        "Please wait",
        "Create Template",
        ''
    );
    $.ajax({
        type: ajaxMethod,
        url: requestURL,
        data: JSON.stringify(CounterObject),
        dataType: 'json',
        contentType: 'application/json',
        success: function (response) {
            $("#generalDialog").modal("hide");
            if (response.IsSuccessful) {
                prompt(
                    "Ajax called successful",
                    "Template Created",
                    '<button class="btn btn-primary" data-dismiss="modal">Close</button>'
                );
            }
            else {
                prompt(
                    "Ajax called failed",
                    "<p>Error message: " + "Error" + "</p>",
                    '<button class="btn btn-primary" data-dismiss="modal">Close</button>'
                );
            }
        },
        error: function (request, status, error) {
            console.log(request);
            console.log(status);
            console.log(error);
        }
    });
}