﻿function validateEmail(email) {

    var re = new RegExp(/^[a-zA-Z0-9._+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,9}$/);
    return re.test(email);
}

function loadSystemNotifications() {
    $.ajax({
        type: "GET",
        url: "/footfallcam/allNotifications",
        contentType: 'application/json',
        success: function (data) {
            console.log(data);
            for (var x = 0; x < data.length; x++) {
				var freq = LanguageNoDataAvailable + ".";
				if (data[x].notificationCat == 1)
					freq = LanguageReportWillBeSentOnceTheVerificationStudyIsDone + ".";
				else if (data[x].notificationCat == 2) {
					freq = data[x].notificationMessage + "<br/> <a class='form-control-static span-link' href='javascript: editHCFrequency()'>" + LanguageEdit + "</a>";
					hcNotificationStatus = data[x].notificationMode;
					hcNotificationHour = data[x].hoursToSend;
				}
				else if (data[x].notificationCat == 3)
					freq = LanguageReportWillBeSentWhenThereIsAnAutoExportImportFailure;
				else if (data[x].notificationCat == 4)
					freq = LanguageReportWillBeSentOnceTheCounterIsSuccessfullyInstalledAndAddedToServer;
				else if (data[x].notificationCat == 5)
					freq = LanguageOtherSystemAlert;
                var allRecipient = data[x].UserGroupName;
                var allRecipientList = data[x].UserGroupNameList;
                var email = data[x].singleEmail;
                var userGroupOptions = "";
                $.each(allRecipientList, function (key, val) {
                    if (val == allRecipient)
                        userGroupOptions = userGroupOptions + "<option value='" + val + "' selected>" + val + "</option>";
                    else
                        userGroupOptions = userGroupOptions + "<option value='" + val + "'>" + val + "</option>";
                });
				var stat = data[x].Status == 1 ? "<option selected value='1'>" + LanguageActive + "</option><option value='0'>" + LanguageInactive + "</option>" : "<option value='1'>" + LanguageActive + "</option><option selected value='0'>" + LanguageInactive + "</option>";
                var selectBox = "<select class='form-control notificationPowerButton' notVal='" + data[x].notificationCat + "'>" + stat + "</select>";
				var userGroupSelectBox = allRecipient != "" ? "<select id='notificationUserGroup' category='" + data[x].notificationCat + "' class='form-control notificationUserGroup'>" + userGroupOptions + "<option class='newEmail' value='addNew'>+ " + LanguageAddSingleEmail + "</option></select>" : "<select id='notificationUserGroup' category='" + data[x].notificationCat + "' class='form-control notificationUserGroup hidden'>" + userGroupOptions + "<option class='newEmail' value='addNew'>+ " + LanguageAddSingleEmail + "</option></select>";
				var singleMailSection = allRecipient == "" ? "<div id='notificationSingleEmail' class='form-control' type=text placeholder='" + LanguageInputEmail + "' style='display: inline-block; width: 80%; overflow: hidden;'>" + email + "</div><br/><button class='btn not-primary-button notificationbackToGroupSelection' id='notificationbackToGroupSelection'>" + LanguageGroup + "</button>" : "<div id='notificationSingleEmail' class='form-control hidden' type=text placeholder='" + LanguageInputEmail + "' style='display: inline-block; width: 80%; overflow: hidden;'></div><br/><button class='btn not-primary-button hidden notificationbackToGroupSelection' id='notificationbackToGroupSelection'>" + LanguageGroup + "</button>";
                if (data[x].notificationCat == 2)
                    $("#sysNotificationTable").append("<tr class='tableHeight'><td id='healthCheckMod'>" + data[x].Name + "</td><td>" + freq + "</td><td>" + userGroupSelectBox + singleMailSection + "</td><td>" + selectBox + "</td></tr>");
                else
                    $("#sysNotificationTable").append("<tr class='tableHeight'><td>" + data[x].Name + "</td><td>" + freq + "</td><td>" + userGroupSelectBox + singleMailSection + "</td><td>" + selectBox + "</td></tr>");
            }
            $(".notificationUserGroup").on("change", function () {
                var notificationsThis = $(this);
                console.log($(this).val());
                var recipientSelection = $(this).val();
                if (recipientSelection == "addNew") {
					var modalSingleMail = "<div><span>" + LanguageInputYourEmailAddressHere + ": </span><input id='tempEmail' placeholder='" + LanguageSingleEmail + "'></div>";
					ShowModal(LanguageAddNewMail, modalSingleMail);
                    $("#btnMyModal2").show();
                    $(this).prop("selectedIndex", 0);
                    $("#btnMyModal").on("click", function () {
                        notificationsThis.addClass("hidden");
                        notificationsThis.siblings().removeClass("hidden");
                        notificationsThis.siblings("#notificationSingleEmail").html($("#tempEmail").val());
                        var group = notificationsThis.is(":visible") ? true : false;
                        var userGroup = notificationsThis.val();
                        var singleMail = notificationsThis.siblings("#notificationSingleEmail").html();
                        var category = notificationsThis.attr("category");
                        console.log(group + "," + userGroup + "," + singleMail + "," + category);
                        $.ajax({
                            type: "GET",
                            url: "/footfallcam/saveNotificationsSingleMail",
                            data: { group: group, userGroup: userGroup, singleMail: singleMail, category: category },
                            contentType: 'application/json',
                            success: function (data) {
								toastr.info(LanguageSaveSuccess, LanguageInformation);
                            }
                        });
                    });
                }
                else {
                    var group = notificationsThis.is(":visible") ? true : false;
                    var userGroup = notificationsThis.val();
                    var singleMail = notificationsThis.siblings("#notificationSingleEmail").html();
                    var category = notificationsThis.attr("category");
                    $.ajax({
                        type: "GET",
                        url: "/footfallcam/saveNotificationsSingleMail",
                        data: { group: group, userGroup: userGroup, singleMail: singleMail, category: category },
                        contentType: 'application/json',
						success: function (data) {
							toastr.info(LanguageSaveSuccess, LanguageInformation);
                        }
                    });
                }
            });
            $(document).delegate(".notificationbackToGroupSelection", "click", function () {
                $(this).addClass("hidden");
                $(this).siblings().addClass("hidden");
                $(this).siblings("#notificationUserGroup").removeClass("hidden");
                $(this).siblings("#notificationUserGroup").change();
            });

            $(".notificationPowerButton").on("change", function () {
                var thisCat = $(this).attr("notVal");
                var val = $(":selected", this).val();
                console.log(thisCat + ":" + val);
                $.ajax({
                    type: "GET",
                    url: "/footfallcam/saveNotificationStatus",
                    data: { Status: val, cat: thisCat },
                    contentType: 'application/json',
                    success: function (data) {
                        var message = "";
						if (data)
							message = LanguageDataSavedSuccessfully;
						else
							message = LanguageDataSavedFailedPleaseTryAgainOrComtactFootfallcam + ".";


						toastr.info(message, LanguageInformation);
                    }
                });
            });
        }
    });
}

function editHCFrequency() {
	var scheduleOption = "<div id='optionSection' style='display:none;'><div class='col-xs-6'><h3>" + LanguageSendReportAfterOfflineFor + ": </h3></div><div class='col-xs-6'><select id='hoursToSend' class='form-control' style='width: 80%'>[option]</select></div></div>";
    var options = "";
    for (var x = 1; x < 24; x++) {
		options = options + "<option value='" + x + "'>" + x + " " + LanguageHour_s + "</option>";
    }
	options = options + "<option value='24'>1 " + LanguageDay_s + "</option>";
    scheduleOption = scheduleOption.replace("[option]", options);
	ShowModal(LanguageHealthCheckReportSchedule, "<div><input type='radio' id='defaultCheckBox' class='radioCheckBox' name='hcSchedule' value='0'> " + LanguageSentOnDaily9am + " (" + LanguageDefault + ")</div><br/><div><input type='radio' id='customCheckBox' class='radioCheckBox' name='hcSchedule' value='1'>" + LanguageCustom + "</input> </div><br/>" + scheduleOption + "<br/><br/>");
	$("#btnMyModal").html(LanguageSave);
    $("#btnMyModal2").show();
    
    $(".radioCheckBox").iCheck({
        checkboxClass: 'iradio_square',
        radioClass: 'iradio_square',
    }).on('ifChanged', function (event) {
        var $box = $(this);
        
        if ($box.val() == "1")
            $("#optionSection").slideDown();
        else
            $("#optionSection").slideUp();
        });

    if (hcNotificationStatus == 0)
        $("#defaultCheckBox").iCheck("check");
    else {
        console.log(hcNotificationHour);
        $("#customCheckBox").iCheck("check");
        $("#hoursToSend").val(hcNotificationHour);
    }

    $("#btnMyModal").on("click", function () {
        var object = {};
        object.notificationMode = $(".checked input[name=hcSchedule]").val();
        object.hoursToSend = $("#hoursToSend").val();
        var stringified = JSON.stringify(object);
        console.log($(this));
        $.ajax({
            type: "GET",
            url: "/footfallcam/setHcEmailSchedule",
            data: { data: stringified },
            contentType: 'application/json',
            success: function (data) {
                
				if (data == "OK") {
					toastr.info(LanguageNotifications, LanguageSavedSuccessfully);
					hcNotificationStatus = object.notificationMode;
					hcNotificationHour = object.hoursToSend;
					if (hcNotificationStatus == 0)
						$("#healthCheckMod").next().html(LanguageReportWillBeSentDailyAt9amLocalTimeIfThereIsAnyOfflineCounter + "<br/> <a class='form-control-static span-link' href='javascript: editHCFrequency()'>" + LanguageEdit + "</a>");
					else {
						var total = parseInt(hcNotificationHour) + 1;
						$("#healthCheckMod").next().html(LanguageReportWillBeSentOnceAnyCounterHasGoneOfflineBetween + " " + hcNotificationHour + "-" + total + " " + LanguageHour_s + "<br/> <a class='form-control-static span-link' href='javascript: editHCFrequency()'>" + LanguageEdit + "</a>");
					}
				}
				else
					toastr.info(LanguageNotifications, LanguageFailedToSave);            }
        });
    });
}