﻿function chartLoading() {

}

$(function () {
    $("#selectBoxVersion").change(function () {
        //calculateCameraCount($('#selectBoxVersion').find(":selected").text(), $('#datepicker').val().split(" ")[1]);
    });

    $("#datepicker").change(function () {
        calculateCameraCount($('#selectBoxVersion').find(":selected").text(), $('#datepicker').val().split(" ")[1]);
    });

    function calculateCameraCount(cameraVersion,selectedDate)
    {
        $.ajax({
            url: "/FootfallCam/GetCameraCount?cameraVersion=" + cameraVersion + "&date=" + selectedDate,
            type: "GET",
            dataType: 'json',
            data: {
                getPara: 'Data',
            },
            success: function (data) {
                var cameraCount = data.length;
                cameraIDs = data;
                $("#inputAvailableResult").val(cameraCount);
                if (cameraCount < 50)
                {
                    $("#inputReportShow").attr({
                        "max": cameraCount
                    });
                    $("#inputReportShow").val(cameraCount);
                } else {
                    $("#inputReportShow").attr({
                        "max": 50
                    });
                    $("#inputReportShow").val(50);
                }
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
            }
        });
    }
});

function bindData(data, colorScheme, texts) {
    var dataWifiValueInId = data[0].series[0].data;
    drawGraphTrend(dataWifiValueInId, colorScheme, texts[0]);
    var dataMemoryStorageSerial = data[0].series[1].data;
    drawGraphTrend(dataMemoryStorageSerial, colorScheme, texts[1]);
    bindFUARBeforeAfterTable(data);
    bindFUARLatestCountTable(data);
}

function bindData(data, colorScheme, texts) {
    bindFUARBeforeAfterTable(data);
    bindFUARLatestCountTable(data);
}

function bindGraphWifiValueIn(data, colorScheme, texts, middleLine) {
    var dataWifiValueInId = data[0].series[0].data;
    drawGraphTrend(dataWifiValueInId, colorScheme, texts[0], 0, middleLine);
}

function bindGraphMemoryStorage(data, colorScheme, texts, middleLine) {
    var dataMemoryStorageSerial = data[0].series[1].data;
    drawGraphTrend(dataMemoryStorageSerial, colorScheme, texts[1], 1, middleLine);
}

function drawGraphTrend(data, colorScheme, texts, graphType, middleLine) {
    var graphData = $.extend(true, [], data);
    var maxDays = graphData[0].DateTimeArray.length;
    var dataSet1 = [];
    var dataSet2 = [];
    var dates = [];
    var useTooltip = false;
    if (graphType == 0) {
        $.each(graphData, function (i, data1) {
            dataSet1[i] = {
                name: data1.CounterSerial + " " + texts[2],
                data: data1.WifiArray,
                yAxis: 1,
                type: 'column',
            }
        });
        $.each(graphData, function (i, data2) {
            dataSet2[i] = {
                name: data2.CounterSerial + " " + texts[1],
                data: data2.ValueInArray,
                type: 'line',
                marker: {
                    lineWidth: 2,
                    lineColor: Highcharts.getOptions().colors[3],
                },
            }
        });
    }
    if (graphType == 1) {
        $.each(graphData, function (i, data1) {
            dataSet1[i] = {
                name: data1.CounterSerial + " " + texts[2],
                data: data1.MemoryArray,
                yAxis: 1,
                type: 'column',
            }
        });
        $.each(graphData, function (i, data2) {
            dataSet2[i] = {
                name: data2.CounterSerial + " " + texts[1],
                data: data2.StorageArray,
                type: 'line',
                marker: {
                    lineWidth: 2,
                    lineColor: Highcharts.getOptions().colors[3],
                },
            }
        });
    }
    if (graphData.length == 1) {
        var tempDates = graphData[0].DateTimeArray;
        for (var i = 0; i < tempDates.length; i++) {
            dates[i] = new Date(parseInt(tempDates[i].substr(6))).toDateString();
        }
        useTooltip = true;
    } 
    var data = dataSet1.concat(dataSet2);

    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: texts[0],
                marginTop: 30,
                marginBottom: 70,
                type: 'column',
                alignTicks: false,
                events: {
                    load: function () {
                        $('#container').removeClass("chartLoading");
                    }
                },
                //height: 500,
                marginTop: 25,
                marginBottom: 75,
            },
            title: {
                text: null,
            },
            scrollbar: {
                enabled: false
            },
            rangeSelector: {
                enabled: false
            },
            navigator: {
                enabled: false
            },
            tooltip: {
                enabled: useTooltip,
                shared: true,
            },
            legend: {
                //width: 700,
                itemWidth: 170,
                itemStyle: {
                    font: '8pt Arial'
                },
                enabled: true,
                borderColor: 'black',
                align: 'center',
                verticalAlign: 'bottom',
                x: 0,
                y: 10,
            },
            rangeSelector: {
                selected: 1,
                enabled: false
            },
            yAxis: [
                {
                    tickAmount: 5,
                    lineWidth: 0,
                    tickWidth: 0,
                    gridLineWidth: 0,
                    //tickPixelInterval: 10,
                    tickPosition: 'inside',
                    title: {
                        text: texts[1],
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily,
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    },
                    min: 0
                },
                {
                    tickAmount: 5,
                    lineWidth: 0,
                    tickWidth: 0,
                    gridLineWidth: 1,
                    tickPixelInterval: 10,
                    tickPosition: 'inside',
                    opposite: true,
                    title: {
                        text: texts[2],
                        margin: 30,
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily,
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize
                        }
                    },
                    labels: {
                        align: 'right',
                        x: 25,
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    },
                    min: 0
                }
            ],
            xAxis: {
                categories: dates,
                tickWidth: 0,
                title: {
                    enabled: false,
                },
                labels: {
                    enabled: false,
                    rotation: 0,
                    x: 3,
                    style: {
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        color: colorScheme.chart.axisLabel.x.label.color,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                },
                plotBands: [{
                    color: 'transparent',
                    from: 0,
                    to: middleLine - 1,
                    zIndex: 5,
                    label: {
                        text: texts[3][0],
                        align: 'center',
                        style: {
                            fontSize: '18px'
                        },
                        rotation: 0,
                        y: -5,
                        x: 0
                    }
                }, {
                    color: 'transparent',
                    from: middleLine,
                    to: maxDays - 1,
                    zIndex: 5,
                    label: {
                        text: texts[3][1],
                        align: 'center',
                        style: {
                            fontSize: '18px'
                        },
                        rotation: 0,
                        y: -5,
                        x: 0
                    }
                }],
                plotLines: [{
                    color: 'grey',
                    width: 1,
                    value: middleLine - 0.5, 
                }],
                align: 'center',
            },
            credits: {
                enabled: false
            },
            plotOptions: {
                line: {
                    findNearestPointBy: 'x', //or "xy" to both axis 
                    marker: {
                        enabled: true
                    },
                },
                column: {
                    findNearestPointBy: 'x', //or "xy" to both axis 
                    marker: {
                        enabled: true
                    },
                },
            },
            series: data,
            navigation: {
                buttonOptions: {
                    enabled: true
                }
            },
            exporting: {
                enabled: false,
            }
        });
    });
}

function bindFUARBeforeAfterTable(data) {
    var latestBeforeAfterData = $.extend(true, [], data[0].series[2].data);
    $("#FUARBeforeAfterTableHead").html('');
    $("#FUARBeforeAfterTableContent").html('');
    $("#FUARBeforeAfterTableHead").append("<tr>" +
        "<th rowspan=\"2\">" + LanguageBranch + "</th>" +
        "<th rowspan=\"2\">" + LanguangeCounterName + "</th>" +
        "<th rowspan=\"2\">" + LanguageSerial + "</th>" +
        "<th colspan=\"4\">" + LanguageBeforeUpgrade + "</th>" +
        "<th colspan=\"4\">" + LanguageAfterUpgrade + "</th>" +
        "</tr>");
    $("#FUARBeforeAfterTableHead").append("<tr>" +
        "<th>" + LanguageWifi + "</th>" +
        "<th>" + LanguageValueIn + "</th>" +
        "<th>" + LanguageStorage + "</th>" +
        "<th>" + LanguageMemory + "</th>" +
        "<th>" + LanguageWifi + "</th>" +
        "<th>" + LanguageValueIn + "</th>" +
        "<th>" + LanguageStorage + "</th>" +
        "<th>" + LanguageMemory + "</th>" +
        "</tr>");
    for (var counterNo = 0; counterNo < latestBeforeAfterData.length; counterNo++) {
        //console.log(latestBeforeAfterData[counterNo].CounterName);
        if (latestBeforeAfterData[counterNo].MemoryBefore == 0 ||
            latestBeforeAfterData[counterNo].StorageBefore == 0 ||
            latestBeforeAfterData[counterNo].MemoryAfter == 0 ||
            latestBeforeAfterData[counterNo].StorageAfter == 0) {
            var tableRow = $("#FUARBeforeAfterTableContent").append("<tr bgcolor=\"#ff9999\">" +
                "<td>" + latestBeforeAfterData[counterNo].BranchName + "</td>" +
                "<td>" + latestBeforeAfterData[counterNo].CounterName + "</td>" +
                "<td>" + latestBeforeAfterData[counterNo].CounterSerial + "</td>" +
                "<td>" + latestBeforeAfterData[counterNo].WifiBefore + "</td>" +
                "<td>" + latestBeforeAfterData[counterNo].ValueInBefore + "</td>" +
                "<td>" + latestBeforeAfterData[counterNo].StorageBefore + "</td>" +
                "<td>" + latestBeforeAfterData[counterNo].MemoryBefore + "</td>" +
                "<td>" + latestBeforeAfterData[counterNo].WifiAfter + "</td>" +
                "<td>" + latestBeforeAfterData[counterNo].ValueInAfter + "</td>" +
                "<td>" + latestBeforeAfterData[counterNo].StorageAfter + "</td>" +
                "<td>" + latestBeforeAfterData[counterNo].MemoryAfter + "</td>" +
                "</tr>"
            );
        } else {
            var tableRow = $("#FUARBeforeAfterTableContent").append("<tr>" +
                "<td>" + latestBeforeAfterData[counterNo].BranchName + "</td>" +
                "<td>" + latestBeforeAfterData[counterNo].CounterName + "</td>" +
                "<td>" + latestBeforeAfterData[counterNo].CounterSerial + "</td>" +
                "<td>" + latestBeforeAfterData[counterNo].WifiBefore + "</td>" +
                "<td>" + latestBeforeAfterData[counterNo].ValueInBefore + "</td>" +
                "<td>" + latestBeforeAfterData[counterNo].StorageBefore + "</td>" +
                "<td>" + latestBeforeAfterData[counterNo].MemoryBefore + "</td>" +
                "<td>" + latestBeforeAfterData[counterNo].WifiAfter + "</td>" +
                "<td>" + latestBeforeAfterData[counterNo].ValueInAfter + "</td>" +
                "<td>" + latestBeforeAfterData[counterNo].StorageAfter + "</td>" +
                "<td>" + latestBeforeAfterData[counterNo].MemoryAfter + "</td>" +
                "</tr>"
            );
        }
    }
}

function bindFUARLatestCountTable(data) {
    var latestBeforeAfterData = $.extend(true, [], data[0].series[2].data);
    $("#FUARLatestCountTableHead").html('');
    $("#FUARLatestCountTableContent").html('');
    $("#FUARLatestCountTableHead").append("<tr>" +
        "<th>" + LanguageBranch + "</th>" +
        "<th>" + LanguangeCounterName + "</th>" +
        "<th>" + LanguageSerial + "</th>" +
        "<th>" + LanguageRebootCount + "</th>" +
        "<th>" + LanguageRaspiCamNotRunningCount + "</th>" +
        "<th>" + LanguageWifiNotRunningCount + "</th>" +
        "<th>" + LanguageCameraError + "</th>" +
        "</tr>");
    for (var counterNo = 0; counterNo < latestBeforeAfterData.length; counterNo++) {
        //console.log(latestBeforeAfterData[counterNo].CounterName);
        $("#FUARLatestCountTableContent").append("<tr>" +
            "<td>" + latestBeforeAfterData[counterNo].BranchName + "</td>" +
            "<td>" + latestBeforeAfterData[counterNo].CounterName + "</td>" +
            "<td>" + latestBeforeAfterData[counterNo].CounterSerial + "</td>" +
            "<td>" + latestBeforeAfterData[counterNo].RebootCount + "</td>" +
            "<td>" + latestBeforeAfterData[counterNo].RasPiNotRunningCount + "</td>" +
            "<td>" + latestBeforeAfterData[counterNo].WifiNotRunningCount + "</td>" +
            "<td>" + latestBeforeAfterData[counterNo].CameraError + "</td>" +
            "</tr>");
    }
}

