﻿var chart = null;
var colorSequence = [
    'rgba(227, 144, 116, 1)',
    'rgba(253, 230, 60, 1)',
    'rgba(129, 117, 46, 1)',
    'rgba(68, 87, 166, 1)',
    'rgba(173, 177, 62, 1)',
    'rgba(294, 167, 79, 1)',
    'rgba(29, 187, 208, 1)',
    'rgba(91, 132, 195, 1)',
    'rgba(176, 156, 202, 1)',
    'rgba(42, 50, 119, 1)',
    'rgba(159, 82, 159, 1)',
    'rgba(241, 123, 44, 1)',
    'rgba(128, 201, 193, 1)',
    'rgba(139, 109, 100, 1)',
    'rgba(216, 48, 38, 1)',
    'rgba(146, 200, 61, 1)',
    'rgba(169, 30, 87, 1)',
    'rgba(143, 163, 171, 1)',
    'rgba(37, 94, 47, 1)',
    'rgba(133, 213, 247, 1)',
];

(function (H) {
    function symbolWrap(proceed, symbol, x, y, w, h, options) {
        if (symbol.indexOf('text:') === 0) {
            var text = symbol.split(':')[1],
                svgElem = this.text(text, x, y + h)
                    .css({
                        fontFamily: 'FontAwesome',
                        fontSize: h * 3
                    });

            if (svgElem.renderer.isVML) {
                svgElem.fillSetter = function (value, key, element) {
                    element.style.color = H.Color(value).get('rgb');
                };
            }
            return svgElem;
        }
        return proceed.apply(this, [].slice.call(arguments, 1));
    }
    H.wrap(H.SVGRenderer.prototype, 'symbol', symbolWrap);
    if (H.VMLRenderer) {
        H.wrap(H.VMLRenderer.prototype, 'symbol', symbolWrap);
    }

    // Load the font for SVG files also
    H.wrap(H.Chart.prototype, 'getSVG', function (proceed) {
        var svg = proceed.call(this);
        svg = '<?xml-stylesheet type="text/css" ' +
            'href="~/Content/inspinia/font-awesome/css/font-awesome.min.css" ?>' +
            svg;
        return svg;
    });
}(Highcharts));

function campaignOngoingPastDisplay() {
    if ($("#countOngoing").val() == "0") {
        $("#ReportListOngoing").hide();
        $("#noOngoingCampaign").show();
    } else {
        $("#ReportListOngoing").show();
        $("#noOngoingCampaign").hide();
    }

    if ($("#countHistory").val() == "0") {
        $("#ReportListHistory").hide();
        $("#noPastCampaign").show();
    } else {
        $("#ReportListHistory").show();
        $("#noPastCampaign").hide();
    }
}

function clearCampaignForm() {
    $("#name").val("");
    $('#cStart').val("");
    $('#cEnd').val("");
    $('#budget').val("");
    $("#branch").val("");
    $("#branch").fSelect('reload');
    $(".iradio_square").each(function (i) {
        $(this).removeClass("checked");
        if ($(this)[0].children[0].value == "1") {
            $(this).addClass("checked");
        }
    });
    $(".has-error").removeClass("has-error");
    $(".has-error-date").removeClass("has-error-date");
}

function returnToList() {
    $("#createNewCampaignSection").hide();
    $("#listView").show();
    $("#newCampaign").show();
}

function getModel() {

    var model = {};
    var compareInitiatives = 1;
    var siteList = [];
    model.name = $("#name").val();
    model.budget = $("#budget").val();
    model.compare = $("#campaignComparison").prop('checked');
    $('input.radioComparison:checked').each(function (e, value) {
        //compareInitiatives.push({ Initiatives: $(value).val() });
        compareInitiatives = $(value).val();
    });
    model.Initiatives = compareInitiatives;
    $($("#branch").val()).each(function (e, value) {
        siteList.push({ branchID: value });
    });
    model.SiteList = siteList;
    return model;
}

function getModelDateParam() {
    var model = {};
    model.startDate = $("#cStart").val();
    model.endDate = $("#cEnd").val();
    model.compareStartDate = $("#compareDate").val();
    return model;
}

function initializeDatePicker() {
    var today = new Date();
    $(".datepicker").datepicker({
        autoclose: true,
        format: "dd/mm/yyyy",
        todayHighlight: true
    });
}

function initializeSelectBox() {
    //$("#branch").select2({ width: 'resolve' });
    $("#branch").fSelect();
}

function checkTimeComparison() {
    var compare = $("#campaignComparison").prop('checked');
    if (!compare)
        $("#compareSection").slideUp();
    else
        $("#compareSection").slideDown();
}

function checkEmptyAll() {

    //check if compare is checked
    checkCompareSection();

    // check all text input
    $("input.required").filter(function () {
        return !this.value;
    }).parent().addClass("has-error");
    $("input.required").filter(function () {
        return this.value;
    }).parent().removeClass("has-error");
    // check all select box
    $("select.required").filter(function () {
        if (!this.value) {
            $("#siteSelectError").addClass("has-error");
        }
        return !this.value;
    }).parent().addClass("has-error");
    $("select.required").filter(function () {
        if (this.value) {
            $("#siteSelectError").removeClass("has-error");
        }
        return this.value;
    }).parent().removeClass("has-error");

    var hasError = $(".has-error .required").length > 0 ? true : false;

    return hasError;
}

function checkEmptyThis(thisEle) {

    var value = $(thisEle).val();
    if (value) {
        $(thisEle).parent().removeClass("has-error");
    }

    if (thisEle.id == "branch") {
        $("select.required").filter(function () {
            if (!this.value) {
                $("#siteSelectError").addClass("has-error");
            }
            return !this.value;
        }).parent().addClass("has-error");
        $("select.required").filter(function () {
            if (this.value) {
                $("#siteSelectError").removeClass("has-error");
            }
            return this.value;
        }).parent().removeClass("has-error");
    }
}

function checkCompareSection() {
    var comparison = $("#campaignComparison").is(":checked");

    if (comparison)
        $("#compareDate").addClass("required");
    else
        $("#compareDate").removeClass("required");
}

//function ValidateFormDataBeforeSave() {
//    var validation = checkEmptyAll();

//    if (validation)
//        saveMarketingTrackerReport();
//}

function appendSavedReport(data) {
    var table = $("#ReportListOngoing tbody");

    var creationDate = "<td>" + data.CreationDate + "</td>";
    var campaignDate = "<td><div class='overflowHide'>" + data.CampaignDate + "</div></td>";
    var campaignList = "<td><div class='pull-left'>" + data.campaignList + "</div>";
    var reportLink = "<div class='pull-right'><a href='MarketingTrackerReport?ReportID=" + btoa(data.reportID) + "'>View Report</a></div></td>";

    table.append("<tr>" + creationDate + campaignDate + campaignList + reportLink + "</tr>");
}

//start change
function setEndDateBasedOnStartDate(startID, endID) {
    var startDate = moment($("#cStart").val(), "DD/MM/YYYY");
    var endDate = moment($("#cEnd").val(), "DD/MM/YYYY");
    var dateValid = (endDate >= startDate); //Jason Optimize for client who wants to utilize for a single-ay campaign
    if (!dateValid) {
        $("#" + startID).parent().addClass("has-error-date");
        $("#" + endID).val("");
    }
    else {
        $("#" + startID).parent().removeClass("has-error-date");
    }

    return;
    //if ($("#" + startID).val()) {
    //    var startValidity = $("#" + startID).data('datepicker').viewDate <= $("#" + endID).data('datepicker').viewDate;
    //    if (!startValidity) {
    //        $("#" + startID).parent().addClass("has-error-date");
    //        $("#" + endID).val("");
    //        $('#' + endID).datepicker('setStartDate', $('#' + startID).data('datepicker').viewDate);
    //    }
    //    else {
    //        $("#" + startID).parent().removeClass("has-error-date");
    //    }
    //}
}

function deleteReportConfirmation(thisEle, ID) {
    prompt(
        "<div class='middle'>Confirmation Message</div>",
        "<div class='middle' id='modalMsg'>Confirm to delete this report ?</div>",
        "<button id='btnDeleteReport' class='btn btn-primary'>Delete</button>" +
        "<button data-dismiss='modal' class='btn not-primary-button'>Cancel</button>"
    );
    //display message
    //ShowModal(
    //    "<div class='middle'>Confirmation Message</div>",
    //    "<div class='middle' id='modalMsg'>Confirm to delete this report ?</div>");
    //$("#btnMyModal").html("Delete");
    //$("#btnMyModal").show();
    //$("#btnMyModal2").html("Cancel");
    //$("#btnMyModal2").show();

    $("#btnDeleteReport").on("click", function () {
        deleteReportConfirmed(thisEle, ID);
    });

}

function deleteReportConfirmed(thisEle, ID) {
    //ShowModal("<div class='middle'>Confirmation Message</div>", "<div class='middle' id='modalMsg'>Deleting... <i class='fa fa-spinner fa-spin'></i></div>");
    //$("#btnMyModal").hide();
    HideGeneralDialog();
    ShowLoadingPrompt("Deleting...");
    $.ajax({
        type: "POST",
        url: "/FootfallCam/deleteMarketingTrackerReport",
        data: { id: ID },
        success: function (data) {
            HideLoadingPrompt();
            var results = JSON.parse(data);
            if (results.result == "OK") {
               
                //$("#modalMsg").html("Delete Successfully.");
                //$("#btnMyModal").html("Back To Report List");
                //$("#btnMyModal").show();
                //$("#btnMyModal").on("click", function () {
                //    returnToList();
                //});
                //$(thisEle).parents().eq(2).remove();
                location.reload();
            }
        },
        error: function (data) {
            HideLoadingPrompt();
        }
    });
}

function campaignNotStarted() {
    ShowModal("<div class='middle middleText'>Notification</div>", "<div class='middle middleText'>Campaign has not started yet, report will be available for view once the campaign starts</div>");
}

function selectAll(thisElement) {
    var selectedVal = $(thisElement).attr("data-value");
    if (selectedVal.indexOf("-1") != -1) {
        if (!$(thisElement).hasClass("selected")) {
            $(thisElement).siblings().addClass("tempSelected");
            var value = $.map($(".tempSelected"), function (a) {
                return $(a).attr("data-value");
            });
            value.push("-1");
            $("#branch").val(value);
            $(".tempSelected").removeClass("tempSelected");
            $("#branch").fSelect('reload');
        }
        else {
            $("#branch").val("");
            $("#branch").fSelect('reload');
        }
    }
}

function limitInputChar(inputID, limit) {
    $('input#' + inputID).bind("change keyup input", function () {
        var name = $("#" + inputID).val();
        var length = name.length;
        $("#" + inputID + "Count").html(length);
        if (length > limit)
            $("#name").val(name.substring(0, limit));
    });
}

function generateOverviewTable(data) {
    var tableData = $.extend(true, [], data);
    $("#CampaignHead").html('');
    $("#CampaignBody").html('');
    $("#CampaignHead").append(
        "<th><div class=\"pull-left\">" + LanguageCampaignName + "</div></th>" +
        "<th><div class=\"pull-left\">" + LanguageCreatedDate + "</div></th>" +
        "<th><div class=\"pull-left\">" + LanguageCampaignDate + "</div></th>" +
        "<th><div class=\"pull-left\">" + LanguageSales + "<i class='fa fa-question-circle pull-right' data-toggle=\"tooltip\" title=\"" + LanguageSalesFormula + "\"></i></div></th>" +
        "<th><div class=\"pull-left\">" + LanguageFootfall + "<i class='fa fa-question-circle pull-right' data-toggle=\"tooltip\" title=\"" + LanguageFootfallFormula + "\"></i></div></th>" +
        "<th><div class=\"pull-left\">" + LanguageSalesConversion + "</div></th>" +
        "<th><div class=\"pull-left\">" + LanguageBudget + "</div></th>" +
        "<th><div class=\"pull-left\">" + "</div></th>");
    var tableBody = $("#CampaignBody");
    for (var i = 0; i < tableData.length; i++) {
        var tableRow = $("<tr></tr>");

        tableRow.append(
            "<td><div class=\"pull-left\">" +
            "<i class=\"fa fa-map-marker\" style=\"color:" + colorSequence[i] + "\"></i>&nbsp;&nbsp;" +
            "<a href=\"MarketingTrackerReport?ReportID=" + tableData[i].ID + "\">" + tableData[i].Name + "</a>" +
            "</div></td>" +
            "<td><div class=\"pull-left\">" + tableData[i].CreatedDate + "</div></td>" +
            "<td><div class=\"pull-left\">" + tableData[i].CampaignDate + "</div></td>");

        tableRow.append("<td>" +
            checkRiseOrDropWithoutID(tableData[i].SalesBy, true, "div", "pull-right") +
            "</td>");

        tableRow.append("<td>" +
            checkRiseOrDropWithoutID(tableData[i].FootfallBy, true, "div", "pull-right") +
            "</td>");

        tableRow.append(
            "<td><div class=\"pull-right\">" + tableData[i].SalesConverison + "%</div></td>" +
            "<td><div class=\"pull-right\">" + tableData[i].Budget + "</div></td>" +
            "<td><div class=\"pull-right\">" +
            "<a href=\"MarketingTrackerReport?ReportID=" + tableData[i].ID + "\">View Report</a>" +
            "</div></td>");
        tableBody.append(tableRow);
    }

    InitializeBootstrapTooltip();
}

function generateOverviewGraph(colorScheme, data) {
    var graphData = data[1];
    var graphWeek = data[0];
    $(function () {
        chart = new Highcharts.Chart({
            chart: {
                height: 200,
                renderTo: "CampaignOverviewGraph",
                //type: 'line',
            },
            title: {
                text: "",
            },
            scrollbar: {
                enabled: false
            },
            rangeSelector: {
                enabled: false
            },
            navigator: {
                enabled: false
            },
            tooltip: {
                formatter: function () {
                    if (this.series.name == 'Footfall Marker') {
                        return '<b>' + this.key + '</b>';
                    }
                    else if (this.series.name == 'Sales Marker') {
                        return '<b>' + this.key + '</b>';
                    }
                    else if (this.series.name == 'Sales Conversion Marker') {
                        return '<b>' + this.key + '</b>';
                    } else {
                        return '<b>' + this.series.name + '</b><br/>' +
                            "Week " + this.x + ': ' + numberify(this.y);
                    }
                }
            },
            yAxis: [{
                title: {
                    text: 'No. of Visitor'
                },
                min: 0,
            }, {
                title: {
                    text: 'Sales'
                },
                min: 0,
                //opposite: true,
            }, {
                title: {
                    text: 'Sales Conversion (%)'
                },
                min: 0,
                //max: 100,
                //opposite: true,
            }],
            xAxis: {
                categories: graphWeek,
                title: {
                    text: 'Week',
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                },
            },
            legend: {
                enabled: false,
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                layout: 'vertical',
                align: 'right',
                verticalAlign: 'top',
                floating: true,
                y: 20,
            },
            rangeSelector: {
                selected: 1,
                enabled: false
            },
            credits: {
                enabled: false
            },
            plotOptions: {
                series: {
                    label: {
                        connectorAllowed: false
                    },
                },
            },
            series: graphData,
            navigation: {
                buttonOptions: {
                    enabled: true
                }
            },
            exporting: {
                enabled: false,
            }
        });
    });
    toggleGraphLinesMarker();
}

function toggleFootfall() {
    if (!$("#cbxFootfall").is(':checked')) {
        chart.series[0].hide();
        //chart.series[3].hide();
        chart.yAxis[0].update({
            labels: {
                enabled: false
            },
            title: {
                text: null
            }
        });
    } else {
        chart.series[0].show();
        //chart.series[3].show();
        chart.yAxis[0].update({
            labels: {
                enabled: true
            },
            title: {
                text: 'No. of Visitor'
            }
        });
    }
}

function toggleSales() {
    if (!$("#cbxSales").is(':checked')) {
        chart.series[1].hide();
        //chart.series[4].hide();
        chart.yAxis[1].update({
            labels: {
                enabled: false
            },
            title: {
                text: null
            }
        });
    } else {
        chart.series[1].show();
        //chart.series[4].show();
        chart.yAxis[1].update({
            labels: {
                enabled: true
            },
            title: {
                text: 'Sales'
            }
        });
    }
}

function toggleSalesConversion() {
    if (!$("#cbxSalesConversion").is(':checked')) {
        chart.series[2].hide();
        //chart.series[5].hide();
        chart.yAxis[2].update({
            labels: {
                enabled: false
            },
            title: {
                text: null
            }
        });
    } else {
        chart.series[2].show();
        //chart.series[5].show();
        chart.yAxis[2].update({
            labels: {
                enabled: true
            },
            title: {
                text: 'Sales Conversion (%)'
            }
        });
    }
}

function toggleYAxis() {
    if ($("#cbxFootfall").is(':checked')) {
        chart.yAxis[1].update({ opposite: true });
    } else {
        chart.yAxis[1].update({ opposite: false });
    }
    if ($("#cbxSales").is(':checked') || $("#cbxFootfall").is(':checked')) {
        chart.yAxis[2].update({ opposite: true });
    } else {
        chart.yAxis[2].update({ opposite: false });
    }
}

function toggleCampaignMarker() {
    chart.series[3].hide();
    chart.series[4].hide();
    chart.series[5].hide();
    if ($("#cbxFootfall").is(':checked')) {
        chart.series[3].show();
    } else if ($("#cbxSales").is(':checked')) {
        chart.series[4].show();
    } else if ($("#cbxSalesConversion").is(':checked')) {
        chart.series[5].show();
    } else {
        //chart.series[3].show();
    }
}

function toggleGraphLinesMarker() {
    toggleFootfall();
    toggleSales();
    toggleSalesConversion();
    toggleCampaignMarker();
    toggleYAxis();
}

function shuffle(a) {
    var j, x, i;
    for (i = a.length - 1; i > 0; i--) {
        j = Math.floor(Math.random() * (i + 1));
        x = a[i];
        a[i] = a[j];
        a[j] = x;
    }
    return a;
}

function checkRiseOrDropWithoutID(value, percent, element, addClass) {

    if (percent) {
        if (value > 0)
            return '<' + element + ' class="rise ' + addClass + '" data-order="' + value + '"><i class="fa fa-caret-up"></i> ' + Math.abs(value).toFixed(2) + ' %</' + element + '>';
        else
            return '<' + element + ' class="drop ' + addClass + '" data-order="' + value + '"><i class="fa fa-caret-down"></i> ' + Math.abs(value).toFixed(2) + ' %</' + element + '>';
    }
    else {
        if (value > 0)
            return '<' + element + ' class="rise ' + addClass + '" data-order="' + value + '"><i class="fa fa-caret-up"></i> ' + Math.abs(value).toFixed(2) + '</' + element + '>';
        else
            return '<' + element + ' class="drop ' + addClass + '" data-order="' + value + '"><i class="fa fa-caret-down"></i> ' + Math.abs(value).toFixed(2) + '</' + element + '>';
    }
}

function saveMarketingTrackerReport() {

    var validation = checkEmptyAll();
    if (validation)
        return;
    //display message
    $('#addCampaignModal').modal('hide');
    //ShowModal(
    //    "<div class='middle'>Confirmation Message</div>",
    //    "<div class='middle' id='modalMsg'>Saving... <i class='fa fa-spinner fa-spin'></i></div>"
    //);
    //$("#btnMyModal").hide();
    ShowLoadingPrompt("Saving... ");

    var model = getModel();

    var json = JSON.stringify(model);
    var dateModel = getModelDateParam();
    var dateJSON = JSON.stringify(dateModel);

    $.ajax({
        type: "POST",
        url: "/FootfallCam/saveMarketingTrackerReport",
        data: {
            marketingTrackerReportJSON: json,
            dateJSON: dateJSON,
            throwError: 0
        },
        success: function (data) {
            HideLoadingPrompt()
            var results = JSON.parse(data);
            if (results.result == "OK") {
                //$("#modalMsg").html("Save Successfully.");
                //$("#btnMyModal").html("Back To Report List");
                //$("#btnMyModal").show();
                //$("#btnMyModal2").html("Go to Report");
                //$("#btnMyModal2").show();
                //$("#btnMyModal").on("click", function () {
                //    //appendSavedReport(results);
                //    //returnToList();
                //    location.reload();
                //});
                //$("#btnMyModal2").on("click", function () {
                //    location.href = "MarketingTrackerReport?reportID=" + results.reportID;
                //});
                //ShowModal("<div class='middle'>Report Saved</div>", "<div class='middle'>Press OK to go to the Report List</div>");
                //$("#btnMyModal").show();
                prompt(
                    "Success",
                    "Save Successfully.",
                    "<button class='btn btn-primary' data-dismiss='modal' onclick='location.reload();'>Refresh</button>"
                );
            }
            else {
                //$("#modalMsg").html("<div class='middle'>Failed to save report.</div> <div class='middle'>Error Code : <b>" + results.message + "</b>.</div> <div class='middle'>This issue has been reported to Footfallcam support team.</div>");
                //$("#btnMyModal").html("Back To Report List");
                //$("#btnMyModal").show();
                //$("#btnMyModal").on("click", function () {
                //    returnToList();
                //});
                prompt(
                    "Failed",
                    "Failed to save campaign",
                    '<button class="btn btn-primary button-close-dialog" data-dismiss="modal">Close</button>'
                );
            }
        },
        error: function (request, status, error) {
            HideLoadingPrompt();
            prompt(
                "Error",
                "Failed to save campaign",
                '<button class="btn btn-primary button-close-dialog" data-dismiss="modal">Close</button>'
            );
        }
    });
}

function getSelectedYear() {
    selectedYear = $("#selectedYear").val();
    generateGraphTable();
}

function generateGraphTable() {
    jQuery.get("../../Scripts/chart-color-scheme.txt", function (colorScheme) {
        var graphCampaignWeek = [];
        colorScheme = JSON.parse(colorScheme);
        $.ajax({
            url: "/FootfallCam/GetMarketingTrackerData?selectedYear=" + selectedYear,
            type: "GET",
            dataType: 'json',
            success: function (data) {
                dataCheck = data;
                var marketingReportDetails = data.Result.marketingReportDetails;
                var topGraphData = data.Result.topGraphData;

                var tableData = [];
                var footfallData = {
                    name: 'Footfall',
                    type: 'line',
                    data: [],
                    yAxis: 0,
                    color: colorScheme.analytics.chart.stackColumn.color[1],
                };
                var salesData = {
                    name: 'Sales',
                    type: 'line',
                    data: [],
                    yAxis: 1,
                    color: colorScheme.analytics.chart.stackColumn.color[2],
                };
                var salesConversionData = {
                    name: 'Sales Conversion',
                    type: 'line',
                    data: [],
                    yAxis: 2,
                    color: colorScheme.analytics.chart.stackColumn.color[3],
                };
                var graphWeek = generateWeekCount(topGraphData.length);

                if (marketingReportDetails.length == 0) {
                    $("#CampaignOverviewTable").hide();
                } else {
                    $("#CampaignOverviewTable").show();
                }

                for (var i = 0; i < marketingReportDetails.length; i++) {
                    var tempTableData = null;
                    var createdDate = formatDate(getDateValue(marketingReportDetails[i].creationDate));
                    var startDate = formatDate(getDateValue(marketingReportDetails[i].startDate));
                    var endDate = formatDate(getDateValue(marketingReportDetails[i].endDate));
                    tempTableData = {
                        "Name": marketingReportDetails[i].Name,
                        "CreatedDate": createdDate,
                        "CampaignDate": startDate + " - " + endDate,
                        "SalesBy": (marketingReportDetails[i].salesBy * 100).toFixed(2),
                        "FootfallBy": (marketingReportDetails[i].footfallBy * 100).toFixed(2),
                        "SalesConverison": (marketingReportDetails[i].salesConversion).toFixed(2),
                        "Budget": suffixify(marketingReportDetails[i].budget),
                        "ID": marketingReportDetails[i].encodedID,
                    }
                    tableData.push(tempTableData);

                    graphCampaignWeek.push({
                        name: marketingReportDetails[i].Name,
                        week: parseInt(marketingReportDetails[i].weekNumberString),
                        dayWeek: marketingReportDetails[i].dayInWeek,
                    });
                }

                var salesConversionCheck = false;
                for (var i = 0; i < topGraphData.length; i++) {
                    footfallData.data.push(topGraphData[i].ValueIn);
                    salesData.data.push(topGraphData[i].SalesAmount);
                    salesConversionData.data.push(topGraphData[i].SalesConversion);

                    if (topGraphData[i].ValueIn > highestFootfall) {
                        highestFootfall = topGraphData[i].ValueIn;
                    }
                    if (topGraphData[i].SalesAmount > highestSales) {
                        highestSales = topGraphData[i].SalesAmount;
                    }
                    if (topGraphData[i].SalesConversion > highestSalesConversion) {
                        highestSalesConversion = topGraphData[i].SalesConversion;
                    }

                    if (topGraphData[i].SalesConversion > 0) {
                        salesConversionCheck = true;
                    }
                }

                if (salesConversionCheck) {
                    $("#cbxCheckSC").show();
                } else {
                    $("#cbxCheckSC").hide();
                }

                var footfallMarker = getMarkerData(footfallData, graphCampaignWeek, footfallData.yAxis);
                var salesMarker = getMarkerData(salesData, graphCampaignWeek, salesData.yAxis);
                var salesConversionMarker = getMarkerData(salesConversionData, graphCampaignWeek, salesConversionData.yAxis);
                var graphData = [
                    footfallData,
                    salesData,
                    salesConversionData,
                    footfallMarker,
                    salesMarker,
                    salesConversionMarker,
                ];
                var graphAll = [graphWeek, graphData];
                if (selectedYear == "" || selectedYear == null) {
                    $("#mtTitle").text(LanguageTitle + " " + "PAST 12 MONTH");
                } else {
                    $("#mtTitle").text(LanguageTitle + " " + selectedYear);
                }
                generateOverviewGraph(colorScheme, graphAll);
                generateOverviewTable(tableData);
            },
            error: function (data) {
                console.log(data);
            }
        });
    });
}

function generateWeekCount(noOfWeek) {
    var weekArray = [];
    for (var i = 1; i <= noOfWeek; i++) {
        weekArray.push(i);
    }
    return weekArray;
}

function getMarkerData(campaignData, campaignWeek, axisValue) {
    var markerData = {
        name: campaignData.name + " Marker",
        type: 'scatter',
        data: [],
        yAxis: axisValue,
    }
    console.log(campaignData.data.length);
    var multiplyXheight = 1;
    if (axisValue == 0) {
        multiplyXheight = highestFootfall;
    } else if (axisValue == 1) {
        multiplyXheight = highestSales;
    } else if (axisValue == 2) {
        multiplyXheight = highestSalesConversion;
    }
    multiplyXheight = multiplyXheight * 12 / 100;
    for (var i = 0; i < campaignData.data.length; i++) {
        var data = null;
        var dataHeight = 0;
        for (var j = 0; j < campaignWeek.length; j++) {
            if (campaignWeek[j].week == i + 1) {
                data = {
                    name: campaignWeek[j].name,
                    x: i,
                    y: campaignData.data[i] + dataHeight * multiplyXheight,
                    marker: {
                        symbol: 'text:\uf041',
                    },
                    color: colorSequence[j % 20],
                }
                dataHeight = dataHeight + 1;
                markerData.data.push(data);
                data = null;
                weekExist = true;
            }
        }
    }
    return markerData;
}



function getDateValue(jsonDateValue) {
    var tempValue = jsonDateValue.split("(")[1];
    tempValue = tempValue.split(")")[0];
    var dateObj = new Date();
    dateObj.setTime(tempValue);
    return dateObj;
}

function formatDate(dateObj) {
    var dayName = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
    var monthName = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
    return "" + get2DigitDate(dateObj.getDate()) + "/" + get2DigitMonth(dateObj.getMonth()) + "/" + dateObj.getFullYear() /*+ " (" + dayName[dateObj.getDay()] + ")"*/;
}

function decodeHtml(html) {
    var txt = document.createElement("textarea");
    txt.innerHTML = html;
    return txt.value;
}

function get2DigitDate(dateValue) {
    return ("0" + dateValue).slice(-2);
}

function get2DigitMonth(dateValue) {
    return ("0" + (dateValue + 1)).slice(-2);
}

function getSelectYearList() {
    var currentDate = new Date();
    var currentYear = currentDate.getFullYear();
    for (var i = currentYear; i >= minYear; i--) {
        $("#selectedYear").append("<option value=\"" + i + "\">" + i + "</option>")
    }
}

function BindGraphLineToggle() {
    $(".showGraphLine")
        .iCheck({
            checkboxClass: 'icheckbox_square',
        })
        .on('ifChanged', function (event) {
            toggleGraphLinesMarker();
        })
}

function BindSelectYear() {
    $("#selectedYear").select2();
}

function BindCheckBox() {
    $(":checkbox ").iCheck({
        checkboxClass: 'icheckbox_square',
    })
}

function BindRadioButton() {
    $(".radioComparison")
        .iCheck({
            radioClass: 'iradio_square',
        })
        .on('ifChanged', function (event) {
        })
}