﻿

function appendTopGraphData(topGraph) {
    $("#budgetAmount").html("$ " + suffixify(topGraph.budget));
    $("#visitor").html(topGraph.totalVisitor);
    $("#salesVal").html(topGraph.totalSalesValue);
    $("#salesConv").html(topGraph.totalSalesConversion);

    $("#visitorPerform").html(checkRiseOrDrop(topGraph.totalVisitorChanges, "visitorPerform"));
    $("#salesValPerform").html(checkRiseOrDrop(topGraph.totalSalesValChanges, "salesValPerform"));
    $("#salesConvPerform").html(checkRiseOrDrop(topGraph.totalSalesConvChanges, "salesConvPerform"));

    jQuery.get("../../Scripts/chart-color-scheme.txt", function (colorScheme) {
        drawTopMatricGraph("visitorGraph", topGraph.totalVisitorSpline, colorScheme, 'areaspline');
        drawTopMatricGraph("salesValGraph", topGraph.totalSalesValSpline, colorScheme, 'areaspline');
        drawTopMatricGraph("salesConvGraph", topGraph.totalSalesConvSpline, colorScheme, 'areaspline');
    });
}

function appendTopTableData(topTable) {
    var visitorCount = topTable.visitorCount;
    var turnInRate = topTable.turnInRate;
    var visitDuration = topTable.visitDuration;
    var returningRate = topTable.returningRate;
    var salesConv = topTable.salesConv;

    var html = "<div class='tableElement textMiddle'>[metrics]</div>";

    //visitors
    $("#topTableVisitor").nextAll().slice().html(html.replace("[metrics]", visitorCount.avgBeforeCampaign));
    $("#topTableVisitor").nextAll().slice(1, 2).html(html.replace("[metrics]", visitorCount.avgDuringCampaign));
    $("#topTableVisitor").nextAll().slice(2, 3).html(html.replace("[metrics]", visitorCount.avgAfterCampaign));
    $("#topTableVisitor").nextAll().slice(3, 4).html(html.replace("[metrics]", checkRiseOrDropWithoutID(visitorCount.percentDuringCampaign, true, "div")));
    $("#topTableVisitor").nextAll().slice(4, 5).html(html.replace("[metrics]", checkRiseOrDropWithoutID(visitorCount.percentAfterCampaign, true, "div")));
    $("#topTableVisitor").nextAll().slice(5, 6).html(html.replace("[metrics]", checkRiseOrDropWithoutID(visitorCount.campaignCompared, true, "div")));

    //turn in rate
    $("#topTableTurnInRate").nextAll().slice().html(html.replace("[metrics]", turnInRate.avgBeforeCampaign));
    $("#topTableTurnInRate").nextAll().slice(1, 2).html(html.replace("[metrics]", turnInRate.avgDuringCampaign));
    $("#topTableTurnInRate").nextAll().slice(2, 3).html(html.replace("[metrics]", turnInRate.avgAfterCampaign));
    $("#topTableTurnInRate").nextAll().slice(3, 4).html(html.replace("[metrics]", checkRiseOrDropWithoutID(turnInRate.percentDuringCampaign, true, "div")));
    $("#topTableTurnInRate").nextAll().slice(4, 5).html(html.replace("[metrics]", checkRiseOrDropWithoutID(turnInRate.percentAfterCampaign, true, "div")));
    $("#topTableTurnInRate").nextAll().slice(5, 6).html(html.replace("[metrics]", checkRiseOrDropWithoutID(turnInRate.campaignCompared, true, "div")));

    //visit duration
    $("#topTableVisitDuration").nextAll().slice().html(html.replace("[metrics]", visitDuration.avgBeforeCampaign));
    $("#topTableVisitDuration").nextAll().slice(1, 2).html(html.replace("[metrics]", visitDuration.avgDuringCampaign));
    $("#topTableVisitDuration").nextAll().slice(2, 3).html(html.replace("[metrics]", visitDuration.avgAfterCampaign));
    $("#topTableVisitDuration").nextAll().slice(3, 4).html(html.replace("[metrics]", checkRiseOrDropWithoutID(visitDuration.percentDuringCampaign, true, "div")));
    $("#topTableVisitDuration").nextAll().slice(4, 5).html(html.replace("[metrics]", checkRiseOrDropWithoutID(visitDuration.percentAfterCampaign, true, "div")));
    $("#topTableVisitDuration").nextAll().slice(5, 6).html(html.replace("[metrics]", checkRiseOrDropWithoutID(visitDuration.campaignCompared, true, "div")));

    //returning rate
    $("#topTableReturningRate").nextAll().slice().html(html.replace("[metrics]", returningRate.avgBeforeCampaign));
    $("#topTableReturningRate").nextAll().slice(1, 2).html(html.replace("[metrics]", returningRate.avgDuringCampaign));
    $("#topTableReturningRate").nextAll().slice(2, 3).html(html.replace("[metrics]", returningRate.avgAfterCampaign));
    $("#topTableReturningRate").nextAll().slice(3, 4).html(html.replace("[metrics]", checkRiseOrDropWithoutID(returningRate.percentDuringCampaign, true, "div")));
    $("#topTableReturningRate").nextAll().slice(4, 5).html(html.replace("[metrics]", checkRiseOrDropWithoutID(returningRate.percentAfterCampaign, true, "div")));
    $("#topTableReturningRate").nextAll().slice(5, 6).html(html.replace("[metrics]", checkRiseOrDropWithoutID(returningRate.campaignCompared, true, "div")));

    //sales Conv
    $("#topTableSalesConv").nextAll().slice().html(html.replace("[metrics]", salesConv.avgBeforeCampaign));
    $("#topTableSalesConv").nextAll().slice(1, 2).html(html.replace("[metrics]", salesConv.avgDuringCampaign));
    $("#topTableSalesConv").nextAll().slice(2, 3).html(html.replace("[metrics]", salesConv.avgAfterCampaign));
    $("#topTableSalesConv").nextAll().slice(3, 4).html(html.replace("[metrics]", checkRiseOrDropWithoutID(salesConv.percentDuringCampaign, true, "div")));
    $("#topTableSalesConv").nextAll().slice(4, 5).html(html.replace("[metrics]", checkRiseOrDropWithoutID(salesConv.percentAfterCampaign, true, "div")));
    $("#topTableSalesConv").nextAll().slice(5, 6).html(html.replace("[metrics]", checkRiseOrDropWithoutID(salesConv.campaignCompared, true, "div")));
}

function checkRiseOrDrop(value, id) {
    if (value < 0) {
        $("#" + id).removeClass('rise');
        $("#" + id).addClass('drop');
        return '<i class="fa fa-caret-down"></i> ' + Math.abs(value) + ' %';
    }
    else if (value > 0) {
        $("#" + id).removeClass('drop');
        $("#" + id).addClass('rise');
        return '<i class="fa fa-caret-up"></i> ' + Math.abs(value) + ' %';
    }
    else
        return "No Changes";
}

function checkRiseOrDropWithoutID(value, percent, element, addClass) {

    if (percent) {
        if (value > 0)
            return '<' + element + ' class="rise ' + addClass + '" data-order="' + value + '"><i class="fa fa-caret-up"></i> ' + Math.abs(value) + ' %</' + element + '>';
        else
            return '<' + element + ' class="drop ' + addClass + '" data-order="' + value + '"><i class="fa fa-caret-down"></i> ' + Math.abs(value) + ' %</' + element + '>';
    }
    else {
        if (value > 0)
            return '<' + element + ' class="rise ' + addClass + '" data-order="' + value + '"><i class="fa fa-caret-up"></i> ' + Math.abs(value) + '</' + element + '>';
        else
            return '<' + element + ' class="drop ' + addClass + '" data-order="' + value + '"><i class="fa fa-caret-down"></i> ' + Math.abs(value) + '</' + element + '>';
    }
}

function appendGraph(graph) {
    console.log(graph);
    var visitorCount = graph.visitorCount;
    var turnInRate = graph.turnInRate;
    var visitDuration = graph.visitDuration;
    var returningRate = graph.returningRate;
    var salesConv = graph.salesConv;

    drawGraph("VisitorCountTrend", colorScheme, visitorCount);
    drawGraph("TurnInRateTrend", colorScheme, turnInRate);
    drawGraph("VisitDurationTrend", colorScheme, visitDuration);
    drawGraph("ReturningCustomerTrend", colorScheme, returningRate);
    drawGraph("SalesConversionTrend", colorScheme, salesConv);
}

function appendBottomTable(bottomTable) {
    for (var x = 0; x < bottomTable.DataRow.length; x++) {
        var storeCode = "<td>" + bottomTable.DataRow[x].StoreCode + "</td>";
        var storeName = "<td>" + bottomTable.DataRow[x].Sites + "</td>";
        var VC = checkRiseOrDropWithoutID(bottomTable.DataRow[x].thisCampaign.VisitorCount, false, "td");
        var TIR = checkRiseOrDropWithoutID(bottomTable.DataRow[x].thisCampaign.TurnInRate, false, "td");
        var VD = checkRiseOrDropWithoutID(bottomTable.DataRow[x].thisCampaign.VisitDuration, false, "td");
        var RR = checkRiseOrDropWithoutID(bottomTable.DataRow[x].thisCampaign.ReturningRate, false, "td");
        var SV = checkRiseOrDropWithoutID(bottomTable.DataRow[x].thisCampaign.SalesValue, false, "td", "salesData");
        var SC = checkRiseOrDropWithoutID(bottomTable.DataRow[x].thisCampaign.SalesConv, false, "td", "salesData");
        var status = bottomTable.DataRow[x].thisCampaign.Status == "Success" ? "<td class='success bold'>" + bottomTable.DataRow[x].thisCampaign.Status + "</td>" : "<td class='failed bold'>" + bottomTable.DataRow[x].thisCampaign.Status + "</td>";

        var table = storeCode + storeName + VC + TIR + VD + RR + SV + SC + status;

        $("#bottomDataTable tbody").append("<tr>" + table + "</tr>");
    }

    var table = $('#bottomDataTable').DataTable({
        paging: false,
        searching: false
    });
}

function drawTopMatricGraph(topMatricGraphId, data, colorScheme, graphType) {
    colorScheme = JSON.parse(colorScheme);
    $(function () {
        Highcharts.setOptions({
            global: {
                useUTC: false
            }
        });

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: topMatricGraphId,
                margin: [0, 0, 0, 0],
                backgroundColor: 'transparent'
            },
            title: {
                text: ''
            },
            credits: {
                enabled: false
            },
            xAxis: {
                labels: {
                    enabled: false
                }
            },
            yAxis: {
                maxPadding: 0,
                minPadding: 0,
                gridLineWidth: 0,
                endOnTick: false,
                labels: {
                    enabled: false
                },
            },
            legend: {
                enabled: false
            },
            tooltip: {
                enabled: false
            },
            plotOptions: {
                series: {
                    enableMouseTracking: false,
                    lineWidth: 1,
                    shadow: false,
                    states: {
                        hover: {
                            lineWidth: 1
                        }
                    },
                    marker: {
                        radius: 0,
                        states: {
                            hover: {
                                radius: 2
                            }
                        }
                    }
                }
            },
            exporting: {
                enabled: false,
            },
            series: [{
                type: graphType,
                data: data,
                color: colorScheme.chart.sparkLine.color,
                fillOpacity: 0.5
            }]
        });
    });
}

function drawGraph(graphID, colorScheme, count, prevCount) {

    var divide = count.Date.length / 3; 
    var campaignEndYear = parseInt($("#cEnd").val().split("/")[2]);
    var dateNow = new Date();
    var numberOfPop = 0;
    for (var i = divide * 2; i < count.Date.length; i++) {
        var countDate = count.Date[i].split(" ")[1].split("/");
        if (i != divide * 2 && countDate[0] == "01" && countDate[1] == "01") {
            campaignEndYear++;
        }
        var countDateValue = new Date(campaignEndYear + "-" + countDate[1] + "-" + countDate[0]);
        if (countDateValue > dateNow) {
            numberOfPop++;
        }
    }
    var start = count.count.length - 1;
    var end = count.count.length - numberOfPop;
    for (var i = start; i >= end; i--) {
        count.count.pop();
    }

    colorScheme = JSON.parse(colorScheme);
    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: graphID,
                width: 760,
            },
            series: [
                {
                    type: 'column',
                    name: "This Campaign",
                    data: count.count,
                    color: colorScheme.chart.column.color,
                    pointPadding: 1,
                    pointWidth: 5,
                    //borderWidth: 10
                },
                //{
                //    yAxis: 0,
                //    type: 'line',
                //    color: colorScheme.time.year.lastYear,
                //    name: "Prev Campaign",
                //    dashStyle: 'dash',
                //    data: count.prevCount,
                //    lineWidth: 1,
                //    marker: {
                //        enabled: false
                //    },
                //}
            ],
            credits: {
                enabled: false
            },
            title: {
                text: '',
            },
            plotOptions: {
                column: {
                    stacking: 'normal',
                    pointPadding: 10,
                },
                series: {
                    marker: {
                        enabled: false
                    }
                }
            },
            yAxis: {
                lineWidth: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 10,
                tickPosition: 'inside',
                title: {
                    text: "Visitor",
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                min: 0, // this sets minimum values of y to 0
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            xAxis: {
                categories: count.Date,
                tickWidth: 0,
                tickInterval: 1,
                lineWidth: 0,
                title: {
                    text: "hour",
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 4,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                },
                plotLines: [{
                    color: colorScheme.chart.dottedLine.color.dateLine,
                    width: 3,
                    value: divide - 0.5,
                    zIndex: 3,
                    dashStyle: 'shortDot',
                    label: {
                        useHTML: true,
                        text: "Start",
                        align: 'center',
                        style: {
                            "background-color": colorScheme.chart.dottedLine.color.dateLine,
                            "padding": "1px 5px",
                            "font-size": "11px",
                            color: 'white'
                        },
                        rotation: 0,
                        y: -10,
                        x: 0,
                        zIndex: 3
                    }
                }, {
                    color: colorScheme.chart.dottedLine.color.dateLine,
                    width: 3,
                    value: divide * 2 - 0.5,
                    dashStyle: 'shortDot',
                    zIndex: 3,
                    label: {
                        useHTML: true,
                        text: "End",
                        align: 'center',
                        style: {
                            "background-color": colorScheme.chart.dottedLine.color.dateLine,
                            "padding": "1px 5px",
                            "font-size": "11px",
                            color: 'white'
                        },
                        rotation: 0,
                        y: -10,
                        x: 0,
                        zIndex: 3
                    }
                }],
                plotBands: [{
                    color: 'transparent',
                    from: 0,
                    to: divide,
                    zIndex: 5,
                    label: {
                        text: count.avgBefore,
                        align: 'center',
                        style: {
                            fontSize: '18px'
                        },
                        rotation: 0,
                        y: -5,
                        x: 0
                    }
                }, {
                    color: 'transparent',
                    from: divide,
                    to: divide * 2,
                    zIndex: 5,
                    label: {
                        text: count.avgDuring,
                        align: 'center',
                        style: {
                            fontSize: '18px'
                        },
                        rotation: 0,
                        y: -5,
                        x: 0
                    }
                }, {
                    color: 'transparent',
                    from: divide * 2,
                    to: divide * 3,
                    zIndex: 5,
                    label: {
                        text: count.avgAfter,
                        align: 'center',
                        style: {
                            fontSize: '18px'
                        },
                        rotation: 0,
                        y: -5,
                        x: 0
                    }
                }],
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                borderColor: '#474b4b',
                x: 260,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                shared: true,
            },
        });
    });
}

function editGraphDetails() {

    var validation = checkEmptyAll();
    if (validation)
        return;

    ShowModal("<div class='middle'>Confirmation Message</div>", "<div class='middle' id='modalMsg'>Saving... <i class='fa fa-spinner fa-spin'></i></div>");
    $("#btnMyModal").hide();

    var model = getModel();
    model.ID = $("#topTitle").attr("repID");
    var json = JSON.stringify(model);
    var dateModel = getModelDateParam();
    var dateJSON = JSON.stringify(dateModel);

    $.ajax({
        type: "POST",
        url: "/FootfallCam/saveMarketingTrackerReport?edit=true",
        data: { marketingTrackerReportJSON: json, dateJSON: dateJSON },
        success: function (data) {
            var results = JSON.parse(data);
            if (results.result == "OK") {
                $("#modalMsg").html("Save Successfully.");
                $("#btnMyModal").html("Refresh");
                $("#btnMyModal").show();
                $("#btnMyModal").on("click", function () {
                    location.reload();
                });
                //ShowModal("<div class='middle'>Report Saved</div>", "<div class='middle'>Press OK to go to the Report List</div>");
                //$("#btnMyModal").show();
            }
        }
    })
}

function saveComment() {

    //display message
    ShowModal("<div class='middle'>Confirmation Message</div>", "<div class='middle' id='modalMsg'>Saving... <i class='fa fa-spinner fa-spin'></i></div>");
    $("#btnMyModal").hide();

    var commentObj = {};
    commentObj.reportID = $("#topTitle").attr("repid");
    commentObj.comment = encodeURIComponent($(".click2edit").html());
    var json = JSON.stringify(commentObj);
    
    $.ajax({
        type: "POST",
        url: "/FootfallCam/saveMarketingTrackerReportComment",
        data: { comment: json },
        success: function (data) {
            data = JSON.parse(data);

            if (data.result == "OK") {
                $("#modalMsg").html("<div class='middleText'>Comment Saved Successfully</div>");
                $("#btnMyModal").html("Ok");
                $("#btnMyModal").show();
            } else {
                $("#modalMsg").html("<div class='middleText'>Failed to save comment</div> <div class='middleText'>Error Code : <b>" + data.error + "</b>.</div> <div class='middleText'>This issue has been reported to Footfallcam support team.</div>");
                $("#btnMyModal").html("Return");
                $("#btnMyModal").show();
                
            }
            
        }
    });
}

function checkIntHasVal(number) {
    if (number > 0)
        return true;
    else
        return false;
}

function hideSalesData() {
    $(".salesData").hide();
    $(".includeSales").attr("colspan", 5);
}