﻿function readyInitialization(data) {
    $("#nestable1").empty();
    var selectedGroup = $("#reportCat1 :selected").val();
    $("#reportCat1").empty();
    setUniqueControllerName();
    setUniqueGroup();
    appendGroupSelect(uniqueGroup);
    appendPage(data.allPage);

    if (selectedGroup && uniqueGroup.indexOf(selectedGroup) != -1)
        $("#reportCat1").val(selectedGroup);
    $("#reportCat1").change();
    $(".pageBox input[type=text]").attr("disabled", "disabled");
    $(".pageBox select.pagefullsetting").attr("disabled", "disabled");

    $(document).delegate("input[type=checkbox]", "ifChanged", function () {
        var thisReport = allPages.allPage.find(f => f.pageID == $(this).attr("reportid"));
        let ID;
        if (thisReport !== undefined)
            ID = thisReport.pageID;
        else
            ID = "addNewPage";

        let page = new PageModel();
        page.SetUserAccess(ID);

        $("#" + ID + " #summaryMessage").html(page.GetUASummaryMessage());
    });

    $(document).delegate("select[id=ControllerName]", "change", function () {

        var thisID = $(this).attr("reportid");
        console.log(thisID);
        var value = $("#" + thisID + " #ControllerName :selected").val();
        if (value == "addNew") {
            ShowModal("<div style='text-align:center;'>Notifications</div>", '<div class="row container-row form-horizontal"><div class="one-row"><div class="one-row"><label class="col-sm-3 control-label">New Controller Name</label><div class="col-sm-9"><input type="text" class="form-control" value="0" id="newController" ></div></div></div>');
            $("#btnMyModal2").show();
            $("#btnMyModal").on("click", function () {
                var newControllerName = $("#newController").val();
                $("select[id=ControllerName]").prepend("<option value='" + newControllerName + "'>" + newControllerName + "</option>");
                $("#" + thisID + " #ControllerName").val(newControllerName);
            });
        }
    })
    $(document).delegate("select[id=Group]", "change", function () {
        var thisID = $(this).attr("reportid");
        var value = $("#" + thisID + " #Group :selected").val();
        if (value == "addNew") {
            ShowModal("<div style='text-align:center;'>Notifications</div>", '<div class="row container-row form-horizontal"><div class="one-row"><div class="one-row"><label class="col-sm-3 control-label">New Group Name</label><div class="col-sm-9"><input type="text" class="form-control" value="0" id="newGroup" ></div></div></div>');
            $("#btnMyModal2").show();
            $("#btnMyModal").on("click", function () {
                var newControllerName = $("#newGroup").val();
                $("select[id=Group]").prepend("<option value='" + newControllerName + "'>" + newControllerName + "</option>");
                $("#" + thisID + " #Group").val(newControllerName);
            });
        }
    })
}

function setUniqueControllerName() {
    uniqueControllerName = [];
    $.each(allPages.allPage, function (key, eee) {
        if (uniqueControllerName.indexOf(eee.ControllerName) == -1) {
            uniqueControllerName.push(eee.ControllerName);
        }
    });
}

function setUniqueGroup() {
    uniqueGroup = [];
    $.each(allPages.allPage, function (key, eee) {
        if (uniqueGroup.indexOf(eee.Group) == -1) {
            uniqueGroup.push(eee.Group);
        }
    });
}

function appendGroupSelect(options) {
    $.each(options, function (key, val) {
        $("#reportCat1").append("<option value='" + val + "'>" + val + "</option>");
    });
}

function appendPage(pages) {
    $.each(pages, function (key, val) {
        InitPageDivision(val);
    });
    $(".logoName").on("keyup", function () {
        $(this).siblings().children().removeClass();
        $(this).siblings().children().addClass("fa " + $(this).val());
    });
    BindCheckBox();
}

function InitPageDivision(pageActualModel) {
    let page = new PageModel(pageActualModel);
    let division = "<div id='" + page.PageID + "' class='one-row pageBox " + page.PageGroup + "'><div id='PageTitle-" + page.PageID + "' class='col-xs-12 middle " + (page.IsDeleted ? "pageTitleInactive" : "pageTitle") + "' style='padding-top: 10px; padding-bottom: 10px; margin-bottom: 10px;'><i class='fa fa-circle " + page.PageGroup + "C'></i>&nbsp;&nbsp;" + page.PageID + "-" + page.PageName + "</div><div class='one-row innerPageBox'>"
        + InitPageDetails(page)
        + InitUserSettings(page)
        + "</div></div>";
    if (pageActualModel) {
        $("#nestable1").append(division);
    } else {
        $("#nestable1").prepend(division);
    }

}

function InitPageDetails(page) {
    let IsNew = page.ID === null;
    let reportIDString = "reportid='" + page.PageID + "'";

    let outerDetails = "<div class='col-xs-6'><div style='border: 1px solid; margin: 5px 5px 5px 5px;'><div class='subTitle'>Page Detail Settings</div>[pageID][pageName][pageURL][pageController][TelerikModel][group][pageFrequency][ParamString][logo][button]</div></div>";
    var pageIDDiv = "<div class='form-group' style='margin: 5px 5px 5px 5px;'><div style='font-weight: 1000; font-size: 12px;'><div class='formDetailsItem'>Page ID:</div><div class='formDetailsItem2' style='text-align: left;'>" + page.PageID + "</div></div></div>";
    let pageName = "<div class='form-group' style='margin: 5px 5px 5px 5px;'><div style='font-weight: 1000; font-size: 12px;'><div class='formDetailsItem'>Page Name:</div><div class='formDetailsItem2'>"
        + "<input id='Description' " + reportIDString + " style='font-weight: 500;' class='form-control' type='text' placeholder='Page Name' value='" + page.PageName + "'/></div></div></div>";
    let PageURLName = "<div class='form-group' style='margin: 5px 5px 5px 5px;'><div style='font-weight: 1000; font-size: 12px;'><div class='formDetailsItem'>URL Name:</div><div class='formDetailsItem2'>"
        + "<input id='ActionName' " + reportIDString + " style='font-weight: 500;' class='form-control' type='text' placeholder='Action Name' value='" + page.ActionName + "'/></div></div></div>";
    let Logo = "<div class='form-group' style='margin: 5px 5px 5px 5px;'><div style='font-weight: 1000; font-size: 12px;'><div class='formDetailsItem'>Logo:</div><div class='formDetailsItem2'><div class='formDetailsItemLogo'>"
        + "<i class='fa " + page.Logo + "'></i></div><input id='Logo' " + reportIDString + " style='font-weight: 500;' class='logoName form-control' type='text' placeholder='Font Awesome Logo' value='" + page.Logo + "'/></div></div></div>";
    let TelerikModel = "<div class='form-group' style='margin: 5px 5px 5px 5px;'><div style='font-weight: 1000; font-size: 12px;'><div class='formDetailsItem'>Telerik Model:</div><div class='formDetailsItem2'>"
        + "<input id='TelerikModelName' " + reportIDString + " style='font-weight: 500;' class='form-control' type='text' placeholder='Telerik Name' value='" + page.TelerikModelName + "'/></div></div></div>";
    let ParamString = "<div class='form-group' style='margin: 5px 5px 5px 5px;'><div style='font-weight: 1000; font-size: 12px;'><div class='formDetailsItem'>Param String:</div><div class='formDetailsItem2'>"
        + "<input id='paramString' " + reportIDString + " style='font-weight: 500;' class='form-control' type='text' placeholder='Param String' value='" + page.ParamString + "'/></div></div></div>";

    let controllerSelection = "";
    $.each(uniqueControllerName, function (key, val) {
        let selected = page.ControllerName === val ? "selected" : "";
        let tempSelection = "<option value='" + val + "' " + selected + " >" + val + "</option>";
        controllerSelection = controllerSelection + tempSelection;
    });
    let pageControllerName = "<div class='form-group' style='margin: 5px 5px 5px 5px;'><div style='font-weight: 1000; font-size: 12px;'><div class='formDetailsItem'>Controller:</div><div class='formDetailsItem2' style='font-weight: 500;'>"
        + "<select id='ControllerName' " + reportIDString + " class='form-control pagefullsetting'>" + controllerSelection + "<option value='addNew'>+ Add New Controller</option></select></div></div></div>";


    let groupSelection = "";
    $.each(allPages.allGroup, function (key, val) {
        let selected = page.PageGroup === val ? "selected" : "";
        let tempSelection = "<option value='" + val + "' " + selected + " >" + val + "</option>";
        groupSelection = groupSelection + tempSelection;
    });
    let pageGroup = "<div class='form-group' style='margin: 5px 5px 5px 5px;'><div style='font-weight: 1000; font-size: 12px;'><div class='formDetailsItem'>Group:</div><div class='formDetailsItem2' style='font-weight: 500;'>"
        + "<select id='Group' " + reportIDString + " class='form-control pagefullsetting'>" + groupSelection + "<option value='addNew'>+ Add New Group</option></select></div></div></div>";

    let Frequencies = ["Daily", "Weekly", "Monthly"];
    let FrequencySelection = "";
    $.each(Frequencies, function (key, val) {
        let selected = page.Frequency === val ? "selected" : "";
        let tempSelection = "<option value='" + val + "' " + selected + " >" + val + "</option>";
        FrequencySelection = FrequencySelection + tempSelection;
    });
    let pageFrequency = "<div class='form-group' style='margin: 5px 5px 5px 5px;'><div style='font-weight: 1000; font-size: 12px;'><div class='formDetailsItem'>Frequency:</div><div class='formDetailsItem2' style='font-weight: 500;'>"
        + "<select id='frequency' " + reportIDString + " class='form-control pagefullsetting'>"
        + FrequencySelection
        + "</select></div></div></div>";

    var saveButton;
    if (IsNew) {
        saveButton = "<div class='form-group' style='margin: 20px 5px 5px 5px;'><div><button id='cancelAdd' onclick='removeAddNew(this)' class='pull-right btn btn-white'>Cancel Edit</button><button style='margin-left: 5px; margin-right: 5px;' onclick='saveNewPage(this)' class='pull-right btn btn-primary'>Save All Settings</button></div></div>";
    } else {
        saveButton = "<div class='form-group' style='margin: 20px 5px 5px 5px;'><div>"
            + "<button id='editDetails' onclick='enableEdit(this)' class='pull-right btn btn-primary' " + reportIDString + ">Enable Edit</button>"
            + "<button style='margin-left: 5px; margin-right: 5px;display: " + (page.IsDeleted ? "block" : "none") + ";' id='activatePage-" + page.PageID + "' onclick='activatePage(this)' class='pull-right btn btn-blue' " + reportIDString + ">Activate Page</button>"
            + "<button style='margin-left: 5px; margin-right: 5px;display: " + (!page.IsDeleted ? "block" : "none") + ";' id='deletePage-" + page.PageID + "' onclick='DeletePage(this)' class='pull-right btn btn-danger' " + reportIDString + ">Delete Page</button>"
            + "<button id='cancelEdit' style='display: none;' onclick='cancelEdit(this)' class='pull-right btn btn-white' " + reportIDString + ">Cancel Edit</button>"
            + "<button id='saveEdit' style='display: none; margin-left: 5px; margin-right: 5px;' onclick='SaveAll(this)' class='pull-right btn btn-primary' " + reportIDString + ">Save All Settings</button></div></div>";
    }


    var results = outerDetails.replace("[pageID]", pageIDDiv).replace("[pageURL]", PageURLName).replace("[pageController]", pageControllerName).replace("[ParamString]", ParamString).replace("[TelerikModel]", TelerikModel).replace("[pageName]", pageName).replace("[logo]", Logo).replace("[group]", pageGroup).replace("[pageFrequency]", pageFrequency).replace("[button]", saveButton);

    return results;
}

function InitUserSettings(page) {
    let IsNew = page.ID === null;
    let reportIDString = "reportid='" + page.PageID + "'";

    let outerAccess = "<div class='col-xs-6'><div style='border: 1px solid; margin: 5px 5px 5px 5px;'><div class='subTitle'>User Settings</div>[metaOnlyAccess][adminAccess][userAccess][retailAccess][mallAccess][emailSchedule][reporttype][reportLevel][summary][saveButton]</div></div>";
    let metaOnlyAccess = "<div class='form-group middle' style='margin: 5px 5px 5px 5px;'><div style='font-weight: 1000; font-size: 12px;'><div class='formItem'>Meta Only Access:</div>"
        + "<input id='metaOnlyAccessCheck' " + reportIDString + " type='checkbox' class='ios-tgl-btn' " + page.MetaChecked + "/></div></div>";
    let adminAccess = "<div class='form-group middle' style='margin: 5px 5px 5px 5px;'><div style='font-weight: 1000; font-size: 12px;'><div class='formItem'>Admin Access:</div>"
        + "<input id='adminAccessCheck' " + reportIDString + " type='checkbox' class='ios-tgl-btn' " + page.AdminChecked + "/></div></div>";
    let userAccess = "<div class='form-group middle' style='margin: 5px 5px 5px 5px;'><div style='font-weight: 1000; font-size: 12px;'><div class='formItem'>User Access:</div>"
        + "<input id='userAccessCheck' " + reportIDString + " type='checkbox' class='ios-tgl-btn' " + page.UserChecked + "/></div></div>";
    let retailAccess = "<div class='form-group middle' style='margin: 5px 5px 5px 5px;'><div style='font-weight: 1000; font-size: 12px;'><div class='formItem'>Retail Access:</div>"
        + "<input id='retailAccessCheck' " + reportIDString + " type='checkbox' class='ios-tgl-btn' " + page.RetailChecked + "/></div></div>";
    let mallAccess = "<div class='form-group middle' style='margin: 5px 5px 5px 5px;'><div style='font-weight: 1000; font-size: 12px;'><div class='formItem'>Mall Access:</div>"
        + "<input id='mallAccessCheck' " + reportIDString + " type='checkbox' class='ios-tgl-btn' " + page.MallChecked + "/></div></div>";
    let mailAccess = "<div class='form-group middle' style='margin: 5px 5px 5px 5px;'><div style='font-weight: 1000; font-size: 12px;'><div class='formItem'>Mail Schedule:</div>"
        + "<input id='mailAccessCheck' " + reportIDString + " type='checkbox' class='ios-tgl-btn' " + page.EmailSchedule + "/></div></div>";
    let reporttype = "<div class='form-group middle' style='margin: 5px 5px 5px 5px;'><div style='font-weight: 1000; font-size: 12px;'><div class='formItem'>Telerik Report:</div>"
        + "<input id='telerikCheck' " + reportIDString + " type='checkbox' class='ios-tgl-btn' " + page.ReportType + "/></div></div>";
    let reportLevelSelection = "";
    $.each(["None", "Branch", "SiteTag"], function (key, val) {
        let selected = page.ReportLevel === key ? "selected" : "";
        let tempSelection = "<option value='" + key + "' " + selected + " >" + val + "</option>";
        reportLevelSelection = reportLevelSelection + tempSelection;
    });
    let reportLevelName = "<div class='form-group middle' style='margin: 5px 5px 5px 5px;'><div style='font-weight: 1000; font-size: 12px;'><div class='formDetailsItem'>Report Level:</div><div class='formDetailsItem2' style='font-weight: 500;'>"
        + "<select id='reportLevel' " + reportIDString + " class='form-control'>" + reportLevelSelection + "</select></div></div></div>";

    let summary = "<div class='form-group middle' style='margin: 20px 5px 5px 5px; border: 1px solid;'><div class='subTitle'>Access Summary</div>"
        + "<div class='col-xs-12' id='summaryMessage'>" + page.GetUASummaryMessage() + "</div></div>";

    let saveButton;
    if (IsNew) {
        saveButton = "";
    } else {
        saveButton = "<div class='form-group' style='margin: 20px 5px 5px 5px;'><div>"
            + "<button onclick='saveUserSettings(" + page.PageID + ")' class='pull-right btn btn-primary' " + reportIDString + ">Save User Settings</button></div></div>";
    }

    var normalUserUsage = outerAccess.replace("[adminAccess]", adminAccess).replace("[userAccess]", userAccess)
        .replace("[saveButton]", saveButton).replace("[retailAccess]", retailAccess)
        .replace("[mallAccess]", mallAccess).replace("[summary]", summary).replace("[emailSchedule]", mailAccess)
        .replace("[reporttype]", reporttype).replace("[reportLevel]", reportLevelName).replace("[metaOnlyAccess]", metaOnlyAccess);

    return normalUserUsage;
}

class PageModel {
    ID = null;
    PageID = "addNewPage";
    PageName = "";
    ControllerName = "";
    ActionName = "";
    TelerikModelName = "";
    PageGroup = "";
    Frequency = "";
    ParamString = "";
    Logo = "";
    MetaChecked = "";
    AdminChecked = "";
    UserChecked = "";
    RetailChecked = "";
    MallChecked = "";
    EmailSchedule = "";
    ReportType = "";
    ReportLevel = "";
    IsDeleted = false;
    constructor(page) {
        if (page) {
            this.ID = page.ID;
            this.PageID = page.pageID;
            this.PageName = String.EmptyStringIfNull(page.Description);
            this.ControllerName = String.EmptyStringIfNull(page.ControllerName);
            this.ActionName = String.EmptyStringIfNull(page.ActionName);
            this.TelerikModelName = String.EmptyStringIfNull(page.TelerikModelName);
            this.PageGroup = String.EmptyStringIfNull(page.Group);
            this.Frequency = String.EmptyStringIfNull(page.frequency);
            this.ParamString = String.EmptyStringIfNull(page.paramString);
            this.Logo = String.EmptyStringIfNull(page.Logo);
            this.MetaChecked = page.MetaOnly ? "checked" : "";
            this.AdminChecked = page.AdminDefault ? "checked" : "";
            this.UserChecked = page.UserDefault ? "checked" : "";
            this.RetailChecked = page.AccType !== null && page.AccType.indexOf("Retail") > -1 ? "checked" : "";
            this.MallChecked = page.AccType !== null && page.AccType.indexOf("Mall") > -1 ? "checked" : "";
            this.EmailSchedule = page.emailSchedulerStatus ? "checked" : "";
            this.ReportType = page.reportType === "Telerik" ? "checked" : "";
            this.IsDeleted = page.IsDeleted;
            this.ReportLevel = page.reportLevel;
        }
    }

    SetUserAccess(pageID) {
        this.RetailChecked = $("#" + pageID + " #retailAccessCheck").prop("checked") ? "checked" : "";
        this.MallChecked = $("#" + pageID + " #mallAccessCheck").prop("checked") ? "checked" : "";
        this.AdminChecked = $("#" + pageID + " #adminAccessCheck").prop("checked") ? "checked" : "";
        this.MetaChecked = $("#" + pageID + " #metaOnlyAccessCheck").prop("checked") ? "checked" : "";
        this.UserChecked = $("#" + pageID + " #userAccessCheck").prop("checked") ? "checked" : "";
    }

    GetUASummaryMessage() {
        let userSummaryMessage;
        let typeSummaryMessage = "With ";
        typeSummaryMessage = typeSummaryMessage + (this.RetailChecked === "checked" && this.MallChecked === "checked" ? "Any account type" : this.MallChecked === "checked" ? "Mall account type" : "Retail account type");

        if (this.MetaChecked) {
            userSummaryMessage = "Only Meta Account";
            typeSummaryMessage = "";
        }
        else if (!this.AdminChecked) {
            userSummaryMessage = "Only Superadmin";
            typeSummaryMessage = "";
        }
        else if (!this.UserChecked) {
            userSummaryMessage = "Only Admin";
        }
        else {
            userSummaryMessage = "Any User Role";
        }

        let sumSummaryMessage = userSummaryMessage + " " + typeSummaryMessage + " can access this page";

        return sumSummaryMessage;
    }
}

class PageActualModel {
    constructor(pageID) {
        let allInput = $("input[reportid=" + pageID + "]");
        let typeAccess = [];
        var obj = {};
        $.each(allInput, function (key, value) {
            let parsedVal = $(value).prop("checked") ? true : false;
            switch ($(value).attr("id")) {
                case "adminAccessCheck":
                    obj.AdminDefault = parsedVal;
                    break;
                case "metaOnlyAccessCheck":
                    obj.MetaOnly = parsedVal;
                    break;
                case "userAccessCheck":
                    obj.UserDefault = parsedVal;
                    break;
                case "retailAccessCheck":
                    if (parsedVal)
                        typeAccess.push("Retail");
                    break;
                case "mallAccessCheck":
                    if (parsedVal)
                        typeAccess.push("Mall");
                    break;
                case "mailAccessCheck":
                    obj.emailSchedulerStatus = parsedVal ? 1 : 0;
                    break;
                case "telerikCheck":
                    obj.reportType = parsedVal ? "Telerik" : "";
                    break;
            }

        });

        this.AdminDefault = obj.AdminDefault;
        this.UserDefault = obj.UserDefault;
        this.emailSchedulerStatus = obj.emailSchedulerStatus;
        this.reportType = obj.reportType;
        this.reportLevel = obj.reportLevel;
        this.MetaOnly = obj.MetaOnly;
        this.AccType = typeAccess.join(",");
        this.pageID = pageID;
        this.ActionName = $("#" + pageID + " #ActionName").val();
        this.TelerikModelName = $("#" + pageID + " #TelerikModelName").val();
        this.paramString = $("#" + pageID + " #paramString").val();
        this.ControllerName = $("#" + pageID + " #ControllerName :selected").val();
        this.Description = $("#" + pageID + " #Description").val();
        this.Logo = $("#" + pageID + " #Logo").val();
        this.Group = $("#" + pageID + " #Group :selected").val().replace("-", " ");
        this.reportLevel = $("#" + pageID + " #reportLevel :selected").val();
        this.frequency = $("#" + pageID + " #frequency :selected").val();
    }
}

function removeAddNew(self) {
    $($(self).parent().parent().parent().parent().parent().parent()[0]).remove();
}

function saveUserSettings(pageID) {
    var page = new PageActualModel(pageID);

    CallAPI("/FootfallCam/SavePageAccessUserSettings", "POST", page,
        function (response) {
            if (response.IsSuccessful) {
                checkSyncStatus();
                toastr.info("Saved Successfully", "Notifications");
            }
            else
                ShowModal("Error", response.ErrorMessage);
        },
        function () {
            toastr.info("Save Failed. Please Check the data.", "Error");
        }
    );
}

function SaveAll(self) {
    var pageID = $(self).attr("reportid");
    var userSettingsObj = new PageActualModel(pageID);

    CallAPI("/FootfallCam/SavePageAccessFullSettings", "POST", userSettingsObj,
        function (response) {
            if (response.IsSuccessful) {
                toastr.info("Saved Successfully", "Notifications");
                InitializePageObject(userSettingsObj, false, response.ErrorMessage);
            }
            else
                ShowModal("Error", response.ErrorMessage);
        },
        function () {
            toastr.info("Save Failed. Please Check the data.", "Error");
        }
    );

}

function enableEdit(self) {
    var myID = $(self).attr("reportid");
    $(self).hide();
    $(self).siblings().hide();
    $("#" + myID + " #cancelEdit").show();
    $("#" + myID + " #saveEdit").show();
    $("input[reportid='" + myID + "'][type=text]").attr("disabled", false);
    $("select[reportid='" + myID + "'].pagefullsetting").attr("disabled", false);
    var page = new PageActualModel(myID);
    allPages.allPage.find(f => f.pageID == myID).savedSettings = page;
}

function cancelEdit(self) {
    var myID = $(self).attr("reportid");
    $(self).hide();
    $(self).siblings().hide();
    $("#" + myID + " #editDetails").show();
    $("#" + myID + " #deletePage").show();
    $("input[reportid='" + myID + "'][type=text]").attr("disabled", true);
    $("select[reportid='" + myID + "'].pagefullsetting").attr("disabled", true);

    resetFullSettings(myID);
}

//reset page details with details before editing is done
function resetFullSettings(pageID) {
    console.log(":::" + pageID);
    var thisPage = allPages.allPage.find(f => f.pageID == pageID).savedSettings;

    $("#" + pageID + " #ActionName").val(thisPage.actionName);
    $("#" + pageID + " #TelerikModelName").val(thisPage.TelerikModelName);
    $("#" + pageID + " #paramString").val(thisPage.paramString);
    $("#" + pageID + " #ControllerName").val(thisPage.ControllerName);
    $("#" + pageID + " #Description").val(thisPage.Description);
    $("#" + pageID + " #Logo").val(thisPage.Logo);
    $("#" + pageID + " #Logo").keyup();
    $("#" + pageID + " #Group").val(thisPage.Group);
    $("#" + pageID + " #frequency").val(thisPage.frequency);
}

//run after settings is saved to initialize local global page object to new value
function InitializePageObject(newPage, deleted, pageID) {
    console.log(pageID);
    if (deleted)
        allPages.allPage.splice(allPages.allPage.indexOf(allPages.allPage.find(f => f.pageID == newPage)), 1);
    else {
        var page = allPages.allPage.find(f => f.pageID == newPage.pageID);
        page.ActionName = newPage.actionName;
        page.TelerikModelName = newPage.TelerikModelName;
        page.paramString = newPage.paramString;
        page.ControllerName = newPage.ControllerName;
        page.Description = newPage.Description;
        page.Logo = newPage.Logo;
        page.Group = newPage.Group;
        page.frequency = newPage.frequency;
        page.AdminDefault = newPage.AdminDefault;
        page.UserDefault = newPage.UserDefault;
        page.AccType = newPage.AccType;
        page.emailSchedulerStatus = newPage.emailSchedulerStatus;
        page.reportType = newPage.reportType;
        page.savedSettings = newPage;
        $("[id=" + page.pageID + "]").attr("id", pageID);
        $("[reportid=" + page.pageID + "]").attr("reportid", pageID);
        if (pageID)
            page.pageID = pageID;
        console.log($("#" + page.pageID + " #cancelEdit")[0]);
        cancelEdit($("#" + page.pageID + " #cancelEdit")[0]);
    }
}

function addNewPage() {
    var checkExist = $("[id=addNewPage]").length > 0 ? true : false;
    if (checkExist) {
        toastr.info("Already Exist", "Notifications");
        return;
    }
    appendPage([null]);
}

function saveNewPage() {
    var thisPage = new PageActualModel("addNewPage");

    CallAPI("/FootfallCam/AddNewPageAccess", "POST", thisPage,
        function (response) {
            if (response.IsSuccessful) {
                thisPage.pageID = response.ErrorMessage;
                allPages.allPage.push(thisPage);
                $("#addNewPage").remove();

                readyInitialization(allPages);
                checkSyncStatus();
                toastr.info("Notifications", "Save Successful");
            }
            else
                ShowModal("Error", response.ErrorMessage);
        },
        function () {
            toastr.info("Save Failed. Please Check the data.", "Error");
        }
    );
}

function DeletePage(self) {
    var pageID = $(self).attr("reportid");
    ShowModal("Confirmation", "Are you sure you want to delete this Page ?");
    $("#btnMyModal2").show();
    $("#btnMyModal").on("click", function () {
        $.ajax({
            type: "DELETE",
            url: "/FootfallCam/DeletePage",
            data: { pageID: pageID },
            success: function (response) {
                if (response.IsSuccessful) {
                    //InitializePageObject(pageID, true);
                    //$("#" + pageID).remove();
                    checkSyncStatus();
                    $("#deletePage-" + pageID).hide();
                    $("#activatePage-" + pageID).show();
                    $("#PageTitle-" + pageID).removeClass("pageTitle").addClass("pageTitleInactive");
                    toastr.success("Notifications", "Deleted Successfully");
                }
                else {
                    toastr.error("An error has occured", response.ErrorMessage);
                }
            }
        });
    });
}

function activatePage(self) {
    var pageID = $(self).attr("reportid");
    ShowModal("Confirmation", "Are you sure you want to re-activate this Page ?");
    $("#btnMyModal2").show();
    $("#btnMyModal").on("click", function () {
        $.ajax({
            type: "GET",
            url: "/FootfallCam/ActivatePage",
            data: { pageID: pageID },
            success: function (data) {
                console.log(response);
                if (response.IsSuccessful) {
                    checkSyncStatus();
                    $("#deletePage-" + pageID).show();
                    $("#activatePage-" + pageID).hide();
                    $("#PageTitle-" + pageID).removeClass("pageTitleInactive").addClass("pageTitle");
                    toastr.success("Notifications", "Deleted Successfully");
                    //InitializePageObject(pageID, true);
                    //$("#" + pageID).remove();
                    //readyInitialization(allPages);
                }
                else {
                    toastr.error("An error has occured", response.ErrorMessage);
                }
            }
        });
    });
}

function sortingFunction(myButton) {
    var Div = "";
    if ($(".temporaryClass").length == 0) {
        Div = '<div class="temporaryClass dd col-xs-4"></div>';
        $("#nestable1").removeClass("col-xs-12").addClass("col-xs-4");
        $("#forSorting").append(Div);
        $("#forSorting").prepend(Div);
        $(".innerPageBox").hide();
        $("#nestable1").sortable({
            stop: function (event, ui) {
                savePageSort();
            }
        });
        $(myButton).html("Disable Sorting");
    }
    else {
        Div = '<div class="dd col-xs-4"></div>';
        $("#nestable1").removeClass("col-xs-4").addClass("col-xs-12");
        $(".temporaryClass").remove();
        $(".innerPageBox").show();
        $("#nestable1").sortable('destroy');
        $(myButton).html("Sort Page");
    }
}

function savePageSort() {
    var selectedGroup = $("#reportCat1 :selected").val();
    var dataList = $("#nestable1 " + "." + selectedGroup).map(function () {
        return $(this).attr("id");
    }).get();
    var obj = { sortOrder: dataList };
    var json = JSON.stringify(obj);
    $.ajax({
        type: "GET",
        url: "/FootfallCam/savePageSort",
        data: { sort: json },
        success: function (data) {
            data = JSON.parse(data);
            if (data.result == "OK") {
                toastr.info("Saved Successfully", "Notifications");
                checkSyncStatus();
            }
            else
                ShowModal("Error", data.result + ", error code is <b>" + data.errorCode + "</b>");
        }
    });
}

function appendAllGroupSorting() {
    $("#allGroup").empty();
    $("#allGroup").append('<div class="col-xs-4"></div>');
    $("#allGroup").append('<div id="tempGroupApp" class="col-xs-4" style="text-align: center;"></div>');
    $("#allGroup").append('<div class="col-xs-4"></div>');
    $("#tempGroupApp").append("<div class='one-row' style='text-decoration: underline;'><h3>Drag to Sort</h3></div>");
    $("#tempGroupApp").append("<div class='one-row' id='tempGroupApp2'></div>");
    setUniqueGroup();
    for (var x = 0; x < uniqueGroup.length; x++) {
        $("#tempGroupApp2").append("<div style='margin-top: 15px; margin-bottom: 15px; border: 1px solid; font-size: 16px; font-weight: 600; background-color: #D3D3D3;'>" + uniqueGroup[x] + "</div>");
    }

    $("#tempGroupApp2").sortable({
        stop: function (event, ui) {
            saveGroupSort();
        }
    });
}

function saveGroupSort() {
    var allGroup = $('#tempGroupApp2 div').map(function () {
        return $(this).html();
    }).get();
    var obj = { sortGroup: allGroup };
    var json = JSON.stringify(obj);
    $.ajax({
        type: "GET",
        url: "/FootfallCam/saveGroupSort",
        data: { sort: json },
        success: function (data) {
            data = JSON.parse(data);
            if (data.result == "OK") {
                toastr.info("Saved Successfully", "Notifications");
                checkSyncStatus();
            }
            else
                ShowModal("Error", data.result + ", error code is <b>" + data.errorCode + "</b>");
        }
    });
}

function refreshListing() {
    readyInitialization(allPages);
    appendAllGroupSorting()
}

function SyncPage() {
    $.ajax({
        type: "GET",
        url: "/FootfallCam/syncServerPA",
        success: function (data) {
            if (data.IsSuccessful) {
                toastr.success("Success", "Sync-ed Successfully");
                ShowPageSynced(true);
            }
            else
                toastr.error("Error", data.ErrorMessage);

        }
    });
}

function checkSyncStatus() {
    $.ajax({
        type: "GET",
        url: "/FootfallCam/syncServerPA?status=1",
        success: function (data) {
            if (data.IsSuccessful) {
                if (data.ErrorMessage == "Synced") {
                    ShowPageSynced(true);
                }
                else {
                    ShowPageSynced(false);
                }
            }
            else {
                toastr.error("Error Occured", data.ErrorMessage);
            }
        }
    });
}

function ShowPageSynced(syncStatus) {
    if (syncStatus) {
        $("#syncStatus").removeClass("unsync");
        $("#syncStatus").addClass("sync");
        $("#syncStatusMsg").empty();
        $("#syncStatusMsg").html("All Pages Synced");
    }
    else {
        $("#syncStatus").removeClass("sync");
        $("#syncStatus").addClass("unsync");
        $("#syncStatusMsg").html("Pages not synced");
    }
}

function BindCheckBox() {
    $(":checkbox ").iCheck({
        checkboxClass: 'icheckbox_square',
    });
}
