
function addSingleProduct() {
    if (validateSingleProductForm()) {
        return;
    }
    $("#modalAddSingleProduct").modal("toggle");
    var ProductObject = {
        ProductSerial: $("#productSerial").val(),
        Name: $("#productName").val(),
        Price: $("#productPrice").val(),
        ProductBrand: $("#productBrand").val(),
        Description: $("#productDescription").val()
        //ProductBarcode :
    };
    var requestURL = "/Product/Create";
    var ajaxMethod = "POST";
    //prompt(
    //    "Creating product",
    //    "Please wait . . . "
    //);
    ShowLoadingPrompt("Please Wait while we're creating/updating" + $("#productName").val());
    $.ajax({
        type: ajaxMethod,
        url: requestURL,
        data: JSON.stringify(ProductObject),
        dataType: 'json',
        contentType: 'application/json',
        success: function (response) {
            HideLoadingPrompt();
            if (response.IsSuccessful) {
                prompt(
                    "Success",
                    "Entry is successfully created/updated",
                    $("<button></button>")
                        .addClass("btn btn-primary")
                        .text("Refresh List")
                        .attr("data-dismiss", "modal")
                        .click(refreshProductList)
                );
                refreshProductList();
                //window.location.reload();//refresh whole page
            }
            else {
                prompt(
                    "Product Creation Error",
                    "Failed to create product, with reason being: \n" + response.error,
                    $("<button></button>")
                        .addClass("btn btn-primary")
                        .text("Close")
                        .attr("data-dismiss", "modal")
                );
            }
        },
        error: function (request, status, error) {
            HideLoadingPrompt();
            prompt(
                "Error",
                "Error " + status + ": " + error,
                $("<button></button>")
                    .addClass("btn btn-primary")
                    .text("Close")
                    .attr("data-dismiss", "modal")
            );
            console.log(request);
            console.log(status);
            console.log(error);
        }
    });
}

function AjaxSaveBrand(callback) {
    var newCategory = {
        Brand: $("#modalProductCategory").val()
    };
    var requestURL = "/Product/CreateCategory";
    var ajaxMethod = "POST";
    ShowLoadingPrompt("Creating " + Brand);
    $.ajax({
        type: ajaxMethod,
        url: requestURL,
        data: JSON.stringify(newCategory),
        dataType: 'json',
        contentType: 'application/json',
        success: function (response) {
            HideLoadingPrompt();
            if (response.IsSuccessful) {
                ClearProductCategoryModal();
                prompt(
                    "Success",
                    "New category created successfully.",
                    $("<button></button>")
                        .addClass("btn btn-primary")
                        .text("Close")
                        .attr("data-dismiss", "modal")
                        .click(GetCategoryList())
                );
                GetCategoryList($("#detailProductCategory"));
                GetCategoryList($("#productCategory"));
            }
            else {
                prompt("Error", "Unable to create new category. Please try again", $("<button></button>")
                    .addClass("btn btn-primary")
                    .text("Close")
                    .attr("data-dismiss", "modal"));
            }
        },
        error: function (request, status, error) {
            console.log(request);
            console.log(status);
            console.log(error);
        }
    });
    callback();
}

function AjaxSaveCategory(callback) {
    var newCategory = {
        Name: $("#modalProductCategory").val()
    };
    var requestURL = "/Product/CreateCategory";
    var ajaxMethod = "POST";
    ShowLoadingPrompt("Creating category");
    $.ajax({
        type: ajaxMethod,
        url: requestURL,
        data: JSON.stringify(newCategory),
        dataType: 'json',
        contentType: 'application/json',
        success: function (response) {
            HideLoadingPrompt();
            if (response.IsSuccessful) {
                ClearProductCategoryModal();
                //prompt(
                //    "Success",
                //    "New category created successfully.",
                //    $("<button></button>")
                //        .addClass("btn btn-primary")
                //        .text("Close")
                //        .attr("data-dismiss", "modal")
                //        .click(GetCategoryList())
                //);
                GetCategoryList($("#detailProductCategory"));
                GetCategoryList($("#productCategory"));
            }
            else {
                prompt("Error", "Unable to create new category. Please try again", $("<button></button>")
                    .addClass("btn btn-primary")
                    .text("Close")
                    .attr("data-dismiss", "modal"));
            }
        },
        error: function (request, status, error) {
            console.log(request);
            console.log(status);
            console.log(error);
        }
    });
    callback();
}

function BindAddProduct() {
    $("#addProduct")
        .on('change', function (event) {
            modalPopup($(this).val());
            $("#addProduct").val(-1);
        })
}

function BindCheckBox() {
    $(".checkbox")
        .iCheck({
            checkboxClass: 'icheckbox_square'
        });
}

function BindFileInputOnChange() {
    $("#productFile")
        .on("change", function (event) {
            if (validateEmptyElement(document.getElementById("productFile").files[0])) {
                $("#tempProductFile").val(
                    document.getElementById("productFile").files[0].name
                );
            }
        })
}

function BindProductListTable() {
    $("#tableProductList").DataTable();
}

function BindRadioButton() {
    $(".radio1")
        .iCheck({
            radioClass: 'iradio_square',
        });

}

function BindProductCategory($elem) {
    $elem.select2({
        width: '100%'
    });
}

function bulkImport() {
    if (validateFile()) {
        $("#modalBulkImport").modal("toggle");
        var requestURL = "/Product/BulkImport";
        var ajaxMethod = "POST";
        var file = document.getElementById("productFile").files[0];
        var formData = new FormData();
        formData.append("productFile", file);
        prompt(
            "Importing product list.",
            "Please wait . . . "
        );
        $.ajax({
            type: ajaxMethod,
            url: requestURL,
            data: formData,
            dataType: 'json',
            cache: false,
            contentType: false,
            processData: false,
            success: function (response) {
                $("#generalDialog").modal("hide");
                if (response.IsSuccessful) {
                    //prompt(
                    //    "Success",
                    //    "Product list successfully imported",
                    //    $("<button></button>")
                    //        .addClass("btn btn-primary")
                    //        .text("Refresh List")
                    //        .attr("data-dismiss", "modal")
                    //        .click(refreshProductList)
                    //);
                    refreshProductList();
                }
                else {
                    prompt(
                        "Failed",
                        "Failed to import product list",
                        $("<button></button>")
                            .addClass("btn btn-primary")
                            .text("Close")
                            .attr("data-dismiss", "modal")
                    );
                }
            },
            error: function (request, status, error) {
                $("#generalDialog").modal("hide");
                prompt(
                    "Error",
                    "Error " + status + ": " + error,
                    $("<button></button>")
                        .addClass("btn btn-primary")
                        .text("Close")
                        .attr("data-dismiss", "modal")
                );
                console.log(request);
                console.log(status);
                console.log(error);
            }
        });
    }
}

function clearBrandInput() {
    $("#modalAddBrand input").each(function () {
        $(this).val('');
    });

    $("#modalAddBrand select").val('');

}

function ClearProductCategoryModal() {
    $("#modalProductCategory").val("");
    $("#modalCreateCategory").modal("hide");
}

function clearProductFileInput() {
    $("#tempProductFile").val('');
    $("#productFile").val('');
}

function clearSingleProductInput() {
    $("#modalAddSingleProduct input").each(function () {
        $(this).val('');
    });

    $("#modalAddSingleProduct select").val('');

}

function customButtonUpload() {
    $("#productFile").click();
}

function CreateCategory(button) {
    $(button).addClass("disabled");
    AjaxSaveCategory(function () {
        $(button).removeClass("disabled");
    });
}

function downloadCSV(csvValue, filename) {
    var data, link;
    filename = filename + ".csv";
    if (!csvValue.match(/^data:text\/csv/i)) {
        csvValue = 'data:text/csv;charset=utf-8,' + csvValue;
    }
    data = encodeURI(csvValue);
    link = document.createElement('a');
    link.setAttribute('href', data);
    link.setAttribute('download', filename);
    link.click();
}

function exportProduct() {
    var requestURL = "/Product/BulkExport";
    var ajaxMethod = "POST";
    prompt(
        "Please wait",
        "Exporting product list.",
        ''
    );
    $.ajax({
        type: ajaxMethod,
        url: requestURL,
        contentType: 'application/json',
        success: function (response) {
            $("#generalDialog").modal("hide");
            downloadCSV(response, "ProductList");
        },
        error: function (request, status, error) {
            $("#generalDialog").modal("hide");
            prompt(
                "Error",
                "Error " + status + ": " + error,
                $("<button></button>")
                    .addClass("btn btn-primary")
                    .text("Close")
                    .attr("data-dismiss", "modal")
            );
            console.log(request);
            console.log(status);
            console.log(error);
        }
    });
}

function GetCategoryList($elem) {
    var requestURL = "/Product/GetCategories";
    var ajaxMethod = "GET";
    $.ajax({
        type: ajaxMethod,
        url: requestURL,
        success: function (response) {
            $("#generalDialog").modal("hide");
            if (response.IsSuccessful) {
                //$("#productCategory")
                //    .empty()
                //    .append('<option value="" selected disabled>-- Select Category --</option>');
                if (response.Data.length !== 0 || response.Data !== null) {
                    $.each(response.Data, function (index, category) {
                        //$("#productCategory").append($('<option>').val(category.Id).text(category.Name));
                        $elem.append($('<option>').val(category.Id).text(category.Name));
                    });
                }
                BindProductCategory($elem);
            }
            else {
                prompt("Error", "Unable to retrieve category list. Please try again", $("<button></button>")
                    .addClass("btn btn-primary")
                    .text("Close")
                    .attr("data-dismiss", "modal"));
            }
        },
        error: function (request, status, error) {
            $("#generalDialog").modal("hide");
            console.log(request);
            console.log(status);
            console.log(error);
        }
    });
}

function modalPopup(value) {
    switch (value) {
        case "1":
            clearSingleProductInput();
            $("#modalAddSingleProduct").modal("show");
            break;
        case "2":
            clearProductFileInput();
            $("#modalBulkImport").modal("show");
            break;
        case "3":
            exportProduct();
            break;
        case "4":
          //  clearBrandInput();
            $("#modalAddBrand").modal("show");
            break;
    }
}

function recreateTable(parentId, childId, headArray, bodyArray, rightPanelFunction, isTemplateTable = false) {
    //Recreate empty table
    var parentElement = $("#" + parentId);
    parentElement.html('');
    var tableElement = $("<table></table>").attr("id", childId).addClass("table-bordered");
    //thead section
    var tableHead = $("<thead></thead>");
    var tableHeadRow = $("<tr></tr>");
    for (var i = 0; i < headArray.length; i++) {
        tableHeadRow.append(
            $("<th></th>").append(headArray[i])
        );
    }
    tableHead.append(tableHeadRow);
    tableElement.append(tableHead);
    //tbody section
    var tableBody = $("<tbody></tbody>");
    for (var i = 0; i < bodyArray.length; i++) {
        var trElement = $("<tr>");
        trElement.attr("onclick", rightPanelFunction + "('" + bodyArray[i][0] + "')");
        if (!isTemplateTable) {
            for (var j = 1; j <= headArray.length; j++) {
                trElement.append($("<td>").append(bodyArray[i][j]));
            }
        } else {
            trElement.append($("<td>").append(bodyArray[i][1]));
            trElement.append($("<td>").append("<img src='" + bodyArray[i][2] + "'/>"));

        }
        tableBody.append(trElement);
    }
    tableElement.append(tableBody);
    parentElement.append(tableElement);
}

function refreshProductList() {
    var requestURL = "/Product/GetProduct";
    var ajaxMethod = "GET";
    prompt(
        "Please wait",
        "Updating product list",
        ''
    );
    $.ajax({
        type: ajaxMethod,
        url: requestURL,
        dataType: 'json',
        contentType: 'application/json',
        success: function (response) {
            $("#generalDialog").modal("hide");
            if (response.IsSuccessful) {
                var data = response.Data;
                var headArray = ["Product Name", "Category", "Price", "Barcode"];
                var bodyArray = [];
                for (var i = 0; i < data.length; i++) {
                    bodyArray.push([
                        data[i].Id,
                        data[i].Name,
                        data[i].ProductCategoryName === null ? "N/A" : data[i].ProductCategoryName,
                        data[i].Price,
                        data[i].ProductSerial
                    ]);
                }
                recreateTable("refreshTableProductList", "tableProductList", headArray, bodyArray, "productRightPanel");
                BindProductListTable();
            }

        },
        error: function (request, status, error) {
            $("#generalDialog").modal("hide");
            prompt(
                "Error",
                "Error " + status + ": " + error,
                $("<button></button>")
                    .addClass("btn btn-primary")
                    .text("Close")
                    .attr("data-dismiss", "modal")
            );
            console.log(request);
            console.log(status);
            console.log(error);
        }
    });
}

function validateEmptyElement(element) {
    if (element !== null) {
        return true;
    } else {
        return false;
    }
}

function validateFile() {
    if (validateEmptyElement(document.getElementById("productFile").files[0])) {
        var tempFileName = document.getElementById("productFile").files[0].name;
        if (validateNullorEmptyString(tempFileName)) {
            prompt(
                "Error",
                "File not found, please try again.",
                $("<button></button>")
                    .addClass("btn btn-primary")
                    .text("Close")
                    .attr("data-dismiss", "modal")
            );
            clearProductFileInput();
            return false;
        } else if (validateFileExtension(tempFileName)) {
            prompt(
                "Error",
                "Invalid file type selected, please select .CSV file.",
                $("<button></button>")
                    .addClass("btn btn-primary")
                    .text("Close")
                    .attr("data-dismiss", "modal")
            );
            clearProductFileInput();
            return false;
        } else {
            return true;
        }
    } else {
        prompt(
            "Error",
            "No file selected, please try again.",
            $("<button></button>")
                .addClass("btn btn-primary")
                .text("Close")
                .attr("data-dismiss", "modal")
        );
        clearProductFileInput();
        return false;
    }
}

function validateFileExtension(filename) {
    var validExtension = ["csv"];
    var splitValue = filename.split(".");
    var splitLength = splitValue.length;
    if (splitLength > 1) {
        for (var i = 0; i < validExtension.length; i++) {
            if (splitValue[splitLength - 1].toLowerCase() === validExtension[i].toLowerCase()) {
                return false;
            }
        }
    } else {
        return true;
    }
    return true;
}

function validateNullorEmptyString(filename) {
    if (filename !== null && filename !== "") {
        return false;
    } else {
        return true;
    }
}

function productRightPanel(productId) {
    var param = "productId=" + productId;
    ShowRightPanel("Product", "Details", param);
}

function validateSingleProductForm() {
    var emptyVal = false;
    $("#modalAddSingleProduct input").each(function () {
        if ($(this).val() === null || $(this).val() === "") {
            $(this).effect("highlight", { color: '#ffbcbc' }, 3000);
            emptyVal = true;
        }
    });
    if ($("#modalAddSingleProduct select").val() === null || $("#modalAddSingleProduct select").val() === "") {
        $("#modalAddSingleProduct select").effect("highlight", { color: '#ffbcbc' }, 3000);
        emptyVal = true;
    }

    return emptyVal;
}


//Tag Template
function eslTemplateRightPanel(templateId) {
    var param = "templateId=" + templateId;
    ShowRightPanel("Product", "EslTemplateForm", param);
}

function GetEslTemplate() {
    var requestURL = "/Product/GetEslTemplate";
    var ajaxMethod = "GET";

    $.ajax({
        type: ajaxMethod,
        url: requestURL,
        success: function (response) {
            $("#generalDialog").modal("hide");
            if (response.IsSuccessful) {
                BindTemplateTable(response.Data);
            }
            else {
                prompt("Failed", "ESL Template " + templateDetail.Name + " failed to be created/updated Please contact Footfallcam Support",
                    $("<button></button>")
                        .addClass("btn btn-primary")
                        .text("Close")
                        .attr("data-dismiss", "modal"));
            }
        },
        error: function (request, status, error) {
            $("#generalDialog").modal("hide");
            console.log(request);
            console.log(status);
            console.log(error);
        }
    });
}

function RefreshTemplateTable() {
    HideRightPanel();
    GetEslTemplate();
}

function BindTemplateTable(templates) {
    var headArray = ["Template Name", "Image"];
    var bodyArray = [];
    $.each(templates, function (index, template) {
        bodyArray.push([
            template.Id,
            template.Name,
            template.TemplateUrl
        ]);
    });
    recreateTable("eslTemplateContainer", "tableEslTemplateList", headArray, bodyArray, "eslTemplateRightPanel", true);

}
// Below adds in  ALL VALIDATION CHECKS for PRODUCT PAGE ONLY for Events
function setTwoNumberDecimal(event) {
    this.value = parseFloat(this.value).toFixed(2);
}

//EOL Tag Template



