﻿function chartLoading() {

}

function bindCrossShopChart(data, colorScheme) {

    var crossShopData = [{
        name: LanguageNo + ' ' + LanguageCrossShopping,
        y: data[0].MonthlyCustomer
    }, {
        name: '1 '+ LanguageBranch,
        y: data[0].CrossOneCustomer
    }, {
        name: '2 '+ LanguageBranches,
        y: data[0].CrossTwoCustomer
    }, {
        name: '3 '+ LanguageBranches,
        y: data[0].CrossThreeCustomer
    }, {
        name: '4> '+ LanguageBranches,
        y: data[0].CrossMoreCustomer
    }];

    $(function () {
        jQuery.get("../../Scripts/chart-color-scheme.txt", function (colorScheme) {
            colorScheme = JSON.parse(colorScheme);
            var options = new Highcharts.Chart({
                chart: {
                    renderTo: "CrossShopperChart",
                    events: {
                        load: function (event) {
                            $("#container").removeClass("chartLoading");
                        }
                    },
                    type: 'pie'
                },
                title: {
                    text: null
                },
                scrollbar: {
                    enabled: false
                },
                rangeSelector: {
                    enabled: false
                },
                credits: {
                    enabled: false
                },
                navigator: {
                    enabled: false
                },
                tooltip: {
                    shared: true,
                    pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b><br/>'
                },
                plotOptions: {
                    pie: {
                        allowPointSelect: true,
                        cursor: 'pointer',
                        size:'70%',
                        dataLabels: {
                            enabled: true,
                            format: '<b>{point.name}</b>: {point.percentage:.1f} %',
                            style: {
                                color: (Highcharts.theme && Highcharts.theme.contrastTextColor) || 'black'
                            }
                        }
                    }
                },
                series: [{
                    name: LanguageTypeOfCrossShopper,
                    color: colorScheme.chart.sparkLine.color,
                    colorByPoint: true,
                    fillOpacity: 0.5,
                    data: crossShopData
                }],
                exporting: {
                    enabled: false,
                }
            });
        });
    });
}

function bindTop5Chart(top5CrossShopData, allWifiCount, colorScheme) {

    var top5Data = [];
    console.log(top5CrossShopData);
    if(top5CrossShopData.length >= 5)
    {
        top5Data = [{
            name: top5CrossShopData[0].FromBranchName,
            y: top5CrossShopData[0].WifiCount 
        }, {
            name: top5CrossShopData[1].FromBranchName,
            y: top5CrossShopData[1].WifiCount
        }, {
            name: top5CrossShopData[2].FromBranchName,
            y: top5CrossShopData[2].WifiCount
        }, {
            name: top5CrossShopData[3].FromBranchName,
            y: top5CrossShopData[3].WifiCount
        }, {
            name: top5CrossShopData[4].FromBranchName,
            y: top5CrossShopData[4].WifiCount
        }, {
            name: LanguageOthers,
            y: allWifiCount - top5CrossShopData[0].WifiCount - top5CrossShopData[1].WifiCount - top5CrossShopData[2].WifiCount - top5CrossShopData[3].WifiCount
        }];
    }else{
        for(var i = 0; i < top5CrossShopData.length; i++)
        {
            top5Data.push({name: top5CrossShopData[i].FromBranchName, y: top5CrossShopData[i].WifiCount });
        }
    }

    $(function () {
        jQuery.get("../../Scripts/chart-color-scheme.txt", function (colorScheme) {
            colorScheme = JSON.parse(colorScheme);
            var options = new Highcharts.Chart({
                chart: {
                    renderTo: "Top5Chart",
                    events: {
                        load: function (event) {
                            $("#container").removeClass("chartLoading");
                        }
                    },
                    type: 'pie'
                },
                title: {
                    text: null
                },
                scrollbar: {
                    enabled: false
                },
                rangeSelector: {
                    enabled: false
                },
                credits: {
                    enabled: false
                },
                navigator: {
                    enabled: false
                },
                tooltip: {
                    shared: true,
                    pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b><br/>'
                },
                plotOptions: {
                    pie: {
                        allowPointSelect: true,
                        cursor: 'pointer',
                        size:'70%',
                        dataLabels: {
                            enabled: true,
                            format: '<b>{point.name}</b>: {point.percentage:.1f} %',
                            style: {
                                color: (Highcharts.theme && Highcharts.theme.contrastTextColor) || 'black'
                            }
                        }
                    }
                },
                series: [{
                    name: 'Top 5 Cross Shop',
                    color: colorScheme.chart.sparkLine.color,
                    colorByPoint: true,
                    fillOpacity: 0.5,
                    data: top5Data
                }],
                exporting: {
                    enabled: false,
                }
            });
        });
    });
}

function bindCrossShopperChartTable(aggregation) {
    var totalNonCrossShopper = aggregation[0].MonthlyCustomer;
    var totalCrossShopper = aggregation[0].CrossOneCustomer + aggregation[0].CrossTwoCustomer + aggregation[0].CrossThreeCustomer + aggregation[0].CrossMoreCustomer;
    var totalCrossShopperPercentage = (totalCrossShopper / (totalNonCrossShopper + totalCrossShopper) * 100).toFixed(2);
    var oneCrossShopperPercentage = (aggregation[0].CrossOneCustomer / (totalNonCrossShopper + totalCrossShopper) * 100).toFixed(2);
    var twoCrossShopperPercentage = (aggregation[0].CrossTwoCustomer / (totalNonCrossShopper + totalCrossShopper) * 100).toFixed(2);
    var threeCrossShopperPercentage = (aggregation[0].CrossThreeCustomer / (totalNonCrossShopper + totalCrossShopper) * 100).toFixed(2);
    var fourOrAboveCrossShopperPercentage = (aggregation[0].CrossMoreCustomer / (totalNonCrossShopper + totalCrossShopper) * 100).toFixed(2);
    $("#CrossShopperPieTableHead").html('');
    $("#CrossShopperPieTableContent").html('');
    $("#CrossShopperPieTableHead").append("<tr><th colspan='2'>" + LanguageCrossShopping + " : " + totalCrossShopperPercentage + "%</th></tr><tr><th>"+LanguageType+"</th><th>%</th></tr>");
    var row1Store = "<tr><td>1 " + LanguageBranch + "</td><td>" + oneCrossShopperPercentage + "</td></tr>";
    var row2Store = "<tr><td>2 " + LanguageBranches + "</td><td>" + twoCrossShopperPercentage + "</td></tr>";
    var row3Store = "<tr><td>3 " + LanguageBranches + "</td><td>" + threeCrossShopperPercentage + "</td></tr>";
    var row4OrAboveStore = "<tr><td>4 > " + LanguageBranches + "</td><td>" + fourOrAboveCrossShopperPercentage + "</td></tr>";
    $("#CrossShopperPieTableContent").append(row1Store + row2Store + row3Store + row4OrAboveStore);
}

function bindTop5ReportTable(top5CrossShopData,allWifiCount,aggregation) {
    var numOfVisitorIn = aggregation[0].ValueIn;
    $("#Top5TableHead").html('');
    $("#Top5TableContent").html('');
    $("#Top5TableHead").append("<tr><th>" + LanguageRank + "</th><th>" + LanguageBranch + "</th><th>" + LanguageCrossShopper+ "</th></tr>");
    for (var i = 0; i < top5CrossShopData.length; i++) {
        var branchName = top5CrossShopData[i].FromBranchName;
        var rank =i+1;
        var crossShopPercentage =  top5CrossShopData[i].WifiCount == 0 ? "-" : Math.ceil((top5CrossShopData[i].WifiCount / allWifiCount) * numOfVisitorIn);
        var firstColumn = "<td>" + rank + "</td>";
        var secondColumn = "<td>" + branchName + "</td>";
        var thirdColumn = "<td>" + crossShopPercentage + "</td>";
        $("#Top5TableContent").append("<tr>" + firstColumn + secondColumn + thirdColumn + "</tr>");
    }
}
