﻿function chartLoading() {

}



function bindHighchart(data, colorScheme) {
    var miniChartId = ['FFGraph', 'TIRGraph'];
    var miniChartData = [data.series[0].data, data.series[1].data];
    //draw graph under each box, footfallcount
    for (var i = 0; i < miniChartId.length; i++) {
        $(function () {
            Highcharts.setOptions({
                global: {
                    useUTC: false
                }
            });
            var chart = new Highcharts.Chart({

                chart: {
                    renderTo: miniChartId[i],
                    margin: [0, 0, 0, 0],
                    backgroundColor: 'transparent'
                },
                title: {
                    text: ''
                },
                credits: {
                    enabled: false
                },
                xAxis: {
                    labels: {
                        enabled: false
                    }
                },
                yAxis: {
                    maxPadding: 0,
                    minPadding: 0,
                    gridLineWidth: 0,
                    endOnTick: false,
                    labels: {
                        enabled: false
                    }
                },
                legend: {
                    enabled: false
                },
                tooltip: {
                    enabled: false
                },
                plotOptions: {
                    series: {
                        enableMouseTracking: false,
                        lineWidth: 1,
                        shadow: false,
                        states: {
                            hover: {
                                lineWidth: 1
                            }
                        },
                        marker: {
                            radius: 0,
                            states: {
                                hover: {
                                    radius: 2
                                }
                            }
                        }
                    }
                },
                exporting: {
                    enabled: false,
                },
                series: [{
                    type: 'areaspline',
                    data: miniChartData[i],
                    color: colorScheme.chart.sparkLine.color,
                    fillOpacity: 0.5
                }]
            });
        });
    }
}

function bindStoreDailyReportTable(data) {
    $("#StoreDailyTableHead").html('');
    $("#StoreDailyTableContent").html('');
    if (data.series[3].hasSalesData > 0) {
        $("#StoreDailyTableHead").append("<tr><th>" + LanguageTime + "</th><th>" + LanguageVisitorCounts + "</th><th>" + LanguageOutsideTraffic + "</th><th>" + LanguageTurnInRatepercent + "</th><th>" + LanguageTransactionCount + "</th><th>" + LanguageSalesConversion + " (%)</th></tr>");
    } else {
        $("#StoreDailyTableHead").append("<tr><th>" + LanguageTime + "</th><th>" + LanguageVisitorCounts + "</th><th>" + LanguageOutsideTraffic + "</th><th>" + LanguageTurnInRatepercent + "</th></tr>");
    }
    for (var i = 0; i < data.series[0].data.length; i++) {
        var visitorCount = data.series[0].data[i] == 0 ? "-" : numberify(data.series[0].data[i]);
        var outsideTraffic = data.series[1].data[i] == 0 ? "-" : numberify(data.series[1].data[i]);
        var turnInRate = data.series[2].data[i] == 0 ? "-" : data.series[2].data[i].toFixed(2) > 100 ? 100 : data.series[2].data[i].toFixed(2);
        var transactionCount = data.series[3].data[i] == 0 ? "-" : data.series[3].data[i];
        var salesConversion = data.series[4].data[i] == 0 ? "-" : data.series[4].data[i].toFixed(2);
        var firstColumn = "<td>" + data.categories[i] + "</td>";
        var secondColumn = "<td>" + visitorCount + "</td>";
        var thirdColumn = "<td>" + outsideTraffic + "</td>";
        var forthColumn = "<td>" + turnInRate + "</td>";
        var fifthColumn = "<td>" + transactionCount + "</td>";
        var sixthColumn = "<td>" + salesConversion + "</td>";
        if (data.series[3].hasSalesData > 0) {
            $("#StoreDailyTableContent").append("<tr>" + firstColumn + secondColumn + thirdColumn + forthColumn + fifthColumn + sixthColumn + "</tr>");
        } else {
            $("#StoreDailyTableContent").append("<tr>" + firstColumn + secondColumn + thirdColumn + forthColumn + "</tr>");
        }
    }
}

function bindVisitorCountandOutsideTrafficGraph(data, colorScheme) {
    var footfall = $.extend(true, [], data.series[0].data);
    var outsideTraffic = $.extend(true, [], data.series[1].data);

    //identify largest value of yaxis data
    var largestValue = 0;
    for (var i = 0; i < footfall.length; i++) {
        footfall[i] = footfall[i] == -1 ? 0 : footfall[i];
        if (footfall[i] != null && footfall[i] != undefined && footfall[i] > largestValue)
            largestValue = footfall[i];
    }

    for (var i = 0; i < outsideTraffic.length; i++) {
        outsideTraffic[i] = outsideTraffic[i] == -1 ? 0 : outsideTraffic[i];
        if (outsideTraffic[i] != null && outsideTraffic[i] != undefined && outsideTraffic[i] > largestValue)
            largestValue = outsideTraffic[i];
    }

    //start here
    //identify largest value of yaxis data
    var outsideTrafficLargestValue = 0;

    for (var i = 0; i < outsideTraffic.length; i++) {
        if (outsideTraffic[i] != null && outsideTraffic[i] != undefined && outsideTraffic[i] > outsideTrafficLargestValue)
            outsideTrafficLargestValue = outsideTraffic[i]
    }

    var outsideTrafficDynamicTickInterval = outsideTrafficLargestValue >= 0 && outsideTrafficLargestValue < 10 ? 1
        : outsideTrafficLargestValue >= 10 && outsideTrafficLargestValue < 100 ? 10
            : outsideTrafficLargestValue >= 100 && outsideTrafficLargestValue < 1000 ? 100
                : outsideTrafficLargestValue >= 1000 && outsideTrafficLargestValue < 10000 ? 1000
                    : outsideTrafficLargestValue >= 10000 && outsideTrafficLargestValue < 100000 ? 10000
                        : outsideTrafficLargestValue >= 100000 && outsideTrafficLargestValue < 1000000 ? 100000
                            : 1000000;

    var visitorLargestValue = 0;

    for (var i = 0; i < footfall.length; i++) {
        if (footfall[i] != null && footfall[i] != undefined && footfall[i] > visitorLargestValue)
            visitorLargestValue = footfall[i]
    }

    var visitorCountDynamicTickInterval = visitorLargestValue >= 0 && visitorLargestValue < 10 ? 1
        : visitorLargestValue >= 10 && visitorLargestValue < 100 ? 10
            : visitorLargestValue >= 100 && visitorLargestValue < 1000 ? 100
                : visitorLargestValue >= 1000 && visitorLargestValue < 10000 ? 1000
                    : visitorLargestValue >= 10000 && visitorLargestValue < 100000 ? 10000
                        : visitorLargestValue >= 100000 && visitorLargestValue < 1000000 ? 100000
                            : 1000000;
    //end here

    var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
        : largestValue >= 10 && largestValue < 100 ? 10
            : largestValue >= 100 && largestValue < 1000 ? 100
                : largestValue >= 1000 && largestValue < 10000 ? 1000
                    : largestValue >= 10000 && largestValue < 100000 ? 10000
                        : largestValue >= 100000 && largestValue < 1000000 ? 100000
                            : 1000000;

    $(function () {
        var options = new Highcharts.Chart({
            chart: {
                renderTo: "VisitorCountAndOutsideTraffic",
                marginTop: 50,
                marginBottom: 50,
                events: {
                    load: function (event) {
                        $("#container").removeClass("chartLoading");
                    }
                }
            },
            title: {
                text: null
            },
            scrollbar: {
                enabled: false
            },
            rangeSelector: {
                enabled: false
            },
            navigator: {
                enabled: false
            },
            tooltip: {
                shared: true,
                pointFormat: '{series.name}: <b>{point.y:#,###.0f}</b><br/>'
            },
            legend: {
                itemStyle: {
                    font: '8pt Arial'
                },
                enabled: true,
                borderColor: 'black',
                verticalAlign: 'top',
                x: 260,
                y: -15,
            },
            rangeSelector: {
                selected: 1,
                enabled: false
            },
            yAxis: [{
                lineWidth: 0,
                tickWidth: 0,
                gridLineWidth: 0,
                //tickInterval: visitorCountDynamicTickInterval,
                tickPixelInterval: 10,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                min: 0,
            },
            {
                opposite: true,
                //tickInterval: outsideTrafficDynamicTickInterval,
                tickPixelInterval: 10,
                gridLineWidth: 1,
                lineWidth: 0,
                tickWidth: 0,
                tickPosition: 'inside',
                labels: {
                    align: 'right',
                    x: 25,
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                title: {
                    text: LanguageOutsideTraffic,
                    margin: 30,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                min: 0
            }],
            //xAxis: {
            //    categories: data.categories,
            //    tickWidth: 0,
            //    tickInterval: data.tickInterval,
            //    labels: {
            //        rotation: -90,
            //        style: {
            //            color: colorScheme.chart.axisLabel.x.label.color,
            //            "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
            //            fontSize: colorScheme.chart.axisLabel.x.label.fontSize
            //        }
            //    }

            //},
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            credits: {
                enabled: false
            },
            plotOptions: {
                series: {
                    marker: {
                        enabled: false
                    }
                }
            },
            series: [{
                type: 'areaspline',
                name: LanguageOutsideTraffic,
                data: outsideTraffic,
                color: colorScheme.chart.matrices.outsideTraffic,
                fillOpacity: 0.15,
                lineWidth: 1.25,
                yAxis: 1
            }, {
                type: 'column',
                name: LanguageVisitor,
                data: footfall,
                color: colorScheme.chart.matrices.noOfVisitor,
                borderWidth: 0
            }],
            navigation: {
                buttonOptions: {
                    enabled: true
                }
            },
            exporting: {
                enabled: false,
            }
        })
    });
}

function bindVisitDurationBox(data, colorScheme) {
    $("#visitDurationThisWeek").empty();
    //$("#visitDurationLastWeek").empty();
    $("#visitDurationUpDownPercent").empty();
    //$("#visitDurationUpDownIcon").html();

    var changes = data.series[2].data[0];
    //var LastWeek = data.series[0].data[0];
    var ThisWeek = data.series[1].data[0];

    if (ThisWeek == 0)
        $("#visitDurationThisWeek").append("-");
    else
        $("#visitDurationThisWeek").append(ThisWeek.toFixed(2) + "m");

    //if (LastWeek == 0)
    //    $("#visitDurationLastWeek").append("(" + LanguageLastWeek + ": - )");
    //else
    //    $("#visitDurationLastWeek").append("(" + LanguageLastWeek + ": " + LastWeek.toFixed(2) + " " + Languageminutes + ")");
    $("#visitDurationUpDownPercent").removeClass("rise");
    $("#visitDurationUpDownPercent").removeClass("drop");

    //if (ThisWeek == 0 || LastWeek == 0)
    //    $("#visitDurationUpDownPercent").append("-");
    //else if (ThisWeek == LastWeek)
    //    $("#visitDurationUpDownPercent").append(LanguageNoChanges);
    //else if (ThisWeek > LastWeek) {
    //    $("#visitDurationUpDownPercent").addClass("rise");
    //    //$("#visitDurationUpDownIcon").append("<i class=\"fa fa-caret-up\" style=\"color: " + colorScheme.chart.arrow.up + "\">");
    //    $("#visitDurationUpDownPercent").append("<i class='fa fa-caret-up'></i> " + changes.toFixed(2) + "%");
    //}
    //else {
    //    $("#visitDurationUpDownPercent").addClass("drop");
    //    //$('#visitDurationUpDownIcon').append("<i class=\"fa fa-caret-down\" style=\"color: " + colorScheme.chart.arrow.down + "\">");
    //    $("#visitDurationUpDownPercent").append("<i class='fa fa-caret-down'></i> " + changes.toFixed(2) + "%");
    //}


    if (changes == 0) {
        $("#visitDurationUpDownPercent").append(LanguageNoChanges);
    } else if (changes > 0) {
        $("#visitDurationUpDownPercent").addClass("rise");
        $("#visitDurationUpDownPercent").append("<i class='fa fa-caret-up'></i> " + changes.toFixed(2) + "%");
    } else if (changes < 0) {
        $("#visitDurationUpDownPercent").addClass("drop");
        $("#visitDurationUpDownPercent").append("<i class='fa fa-caret-down'></i> " + changes.toFixed(2) + "%");
    }
}

function bindReturningRateBox(data, colorScheme) {
    $("#returningRateThisWeek").empty();
    //$("#returningRateLastWeek").empty();
    $("#returningRateUpDownPercent").empty();
    //$("#returningRateUpDownIcon").html();

    var changes = data.series[2].data[0];
    //var LastWeek = data.series[0].data[0];
    var ThisWeek = data.series[1].data[0];

    if (ThisWeek == 0)
        $("#returningRateThisWeek").append("-");
    else
        $("#returningRateThisWeek").append(ThisWeek.toFixed(2) + "%");

    //if (LastWeek == 0)
    //    $("#returningRateLastWeek").append("(" + LanguageLastWeek + ": - )");
    //else
    //    $("#returningRateLastWeek").append("(" + LanguageLastWeek + ": " + LastWeek.toFixed(2) + "%)");
    $("#returningRateUpDownPercent").removeClass("rise");
    $("#returningRateUpDownPercent").removeClass("drop");

    //if (ThisWeek == 0 || LastWeek == 0)
    //    $("#returningRateUpDownPercent").append("-");
    //else if (ThisWeek == LastWeek)
    //    $("#returningRateUpDownPercent").append(LanguageNoChanges);
    //else if (ThisWeek > LastWeek) {
    //    $("#returningRateUpDownPercent").addClass("rise");
    //    //$("#returningRateUpDownIcon").append("<i class=\"fa fa-caret-up\" style=\"color: " + colorScheme.chart.arrow.up + "\">");
    //    $("#returningRateUpDownPercent").append("<i class='fa fa-caret-up'></i> " + changes.toFixed(2) + "%");
    //}
    //else {
    //    $("#returningRateUpDownPercent").addClass("drop");
    //    //$('#returningRateUpDownIcon').append("<i class=\"fa fa-caret-down\" style=\"color: " + colorScheme.chart.arrow.down + "\">");
    //    $("#returningRateUpDownPercent").append("<i class='fa fa-caret-down'></i> " + changes.toFixed(2) + "%");
    //}

    if (changes == 0) {
        $("#returningRateUpDownPercent").append(LanguageNoChanges);
    } else if (changes > 0) {
        $("#returningRateUpDownPercent").addClass("rise");
        $("#returningRateUpDownPercent").append("<i class='fa fa-caret-up'></i> " + changes.toFixed(2) + "%");
    } else if (changes < 0) {
        $("#returningRateUpDownPercent").addClass("drop");
        $("#returningRateUpDownPercent").append("<i class='fa fa-caret-down'></i> " + changes.toFixed(2) + "%");
    }
}

function bindFootfallBox(data, colorScheme) {
    $("#totalVisitorThisWeek").empty();
    //$("#totalVisitorLastWeek").empty();
    $("#totalVisitorUpDownPercent").empty();
    //$("#totalVisitorUpDownIcon").html();

    var changes = data.series[2].data[0];
    //var LastWeek = data.series[0].data[0];
    var ThisWeek = data.series[1].data[0]; // today data

    if (ThisWeek == 0)
        $("#totalVisitorThisWeek").append("-");
    else
        $("#totalVisitorThisWeek").append(ThisWeek);

    //if (LastWeek == 0)
    //    $("#totalVisitorLastWeek").append("(" + LanguageLastWeek + ": - )");
    //else
    //    $("#totalVisitorLastWeek").append("(" + LanguageLastWeek + ": " + LastWeek + ")");
    $("#totalVisitorUpDownPercent").removeClass("rise");
    $("#totalVisitorUpDownPercent").removeClass("drop");

    //if (ThisWeek == 0 || LastWeek == 0)
    //    $("#totalVisitorUpDownPercent").append("-");
    //else if (ThisWeek == LastWeek)
    //    $("#totalVisitorUpDownPercent").append(LanguageNoChanges);
    //else if (ThisWeek > LastWeek) {
    //    $("#totalVisitorUpDownPercent").addClass("rise");
    //    //$("#totalVisitorUpDownIcon").append("<i class=\"fa fa-caret-up\" style=\"color: " + colorScheme.chart.arrow.up + "\">");
    //    $("#totalVisitorUpDownPercent").append("<i class='fa fa-caret-up'></i> " + changes.toFixed(2) + "%");
    //}
    //else {
    //    $("#totalVisitorUpDownPercent").addClass("drop");
    //    //$('#totalVisitorUpDownIcon').append("<i class=\"fa fa-caret-down\" style=\"color: " + colorScheme.chart.arrow.down + "\">");
    //    $("#totalVisitorUpDownPercent").append("<i class='fa fa-caret-down'></i> " + changes.toFixed(2) + "%");
    //}

    if (changes == 0) {
        $("#totalVisitorUpDownPercent").append(LanguageNoChanges);
    } else if (changes > 0) {
        $("#totalVisitorUpDownPercent").addClass("rise");
        $("#totalVisitorUpDownPercent").append("<i class='fa fa-caret-up'></i> " + changes.toFixed(2) + "%");
    } else if (changes < 0) {
        $("#totalVisitorUpDownPercent").addClass("drop");
        $("#totalVisitorUpDownPercent").append("<i class='fa fa-caret-down'></i> " + changes.toFixed(2) + "%");
    }

}

function bindTurnInRateBox(data, colorScheme) {
    $("#turnInRateThisWeek").empty();
    //$("#turnInRateLastWeek").empty();
    $("#turnInRateUpDownPercent").empty();
    //$("#turnInRateUpDownIcon").html();

    var changes = data.series[2].data[0];
    //var LastWeek = data.series[0].data[0];
    var ThisWeek = data.series[1].data[0]; //today data

    if (ThisWeek == 0)
        $("#turnInRateThisWeek").append("-");
    else
        $("#turnInRateThisWeek").append(ThisWeek.toFixed(2) + "%");

    //if (LastWeek == 0)
    //    $("#turnInRateLastWeek").append("(" + LanguageLastWeek + ": - )");
    //else
    //    $("#turnInRateLastWeek").append("(" + LanguageLastWeek + ": " + LastWeek.toFixed(2) + "%)");
    $("#turnInRateUpDownPercent").removeClass("rise");
    $("#turnInRateUpDownPercent").removeClass("drop");

    //if (ThisWeek == 0 || LastWeek == 0)
    //    $("#turnInRateUpDownPercent").append("-");
    //else if (ThisWeek == LastWeek)
    //    $("#turnInRateUpDownPercent").append(LanguageNoChanges);
    //else if (ThisWeek > LastWeek) {
    //    $("#turnInRateUpDownPercent").addClass("rise");
    //    //$("#turnInRateUpDownIcon").append("<i class=\"fa fa-caret-up\" style=\"color: " + colorScheme.chart.arrow.up + "\">");
    //    $("#turnInRateUpDownPercent").append("<i class='fa fa-caret-up'></i> " + changes.toFixed(2) + "%");
    //}
    //else {
    //    $("#turnInRateUpDownPercent").addClass("drop");
    //    //$('#turnInRateUpDownIcon').append("<i class=\"fa fa-caret-down\" style=\"color: " + colorScheme.chart.arrow.down + "\">");
    //    $("#turnInRateUpDownPercent").append("<i class='fa fa-caret-down'></i> " + changes.toFixed(2) + "%");
    //}

    if (changes == 0) {
        $("#turnInRateUpDownPercent").append(LanguageNoChanges);
    } else if (changes > 0) {
        $("#turnInRateUpDownPercent").addClass("rise");
        $("#turnInRateUpDownPercent").append("<i class='fa fa-caret-up'></i> " + changes.toFixed(2) + "%");
    } else if (changes < 0) {
        $("#turnInRateUpDownPercent").addClass("drop");
        $("#turnInRateUpDownPercent").append("<i class='fa fa-caret-down'></i> " + changes.toFixed(2) + "%");
    }
}
