﻿function chartLoading() {


}


function bindData(data, colorScheme) {
    //OutsideTraffic
    bindOutsideTraffic(data[0], colorScheme);

    //Turn In Rate
    bindTurnInRate(data[1], colorScheme);

    //Total Visitor
    bindVisitorCount(data[2], colorScheme);

    //Sales Conversion
    bindSalesConversion(data[3], colorScheme);

    //Sales Conversion Section Graph
    bindSalesConversionSectionGraph(data[4], colorScheme);

    //Sales Conversion Table
    bindSalesConversionTable(data[5], colorScheme);
}

function bindOutsideTraffic(data, colorScheme) {
    $("#todayOutsideTraffic").empty();
    $("#outsideTrafficUpDownPercent").empty();
    $("#outsideTrafficUpDownPercent").removeClass("rise");
    $("#outsideTrafficUpDownPercent").removeClass("drop");
    $("#outsideTrafficGraph").empty();

    var value = data.series[0].OutsideTrafficTotal;
    var diff = data.series[0].DifferencesInOT;


    $("#todayOutsideTraffic").html(numberWithCommas(value));

    var diffOtHtml = "";
    if (diff === 0) {
        $("#outsideTrafficUpDownPercent").append(LanguageNoChanges);
    } else if (diff > 0) {
        $("#outsideTrafficUpDownPercent").addClass("rise");
        diffOtHtml = "<i class='fa fa-caret-up'></i> " + parseFloat(diff).toFixed(2) + "%";
    } else if (diff < 0) {
        $("#outsideTrafficUpDownPercent").addClass("drop");
        diffOtHtml = "<i class='fa fa-caret-down'></i> " + parseFloat(diff).toFixed(2) + "%";
    }
    $("#outsideTrafficUpDownPercent").append(diffOtHtml);
    plotMatricHighChartGraph("outsideTrafficGraph", data, colorScheme);
}

function bindTurnInRate(data, colorScheme) {
    $("#todayTurnInRate").empty();
    $("#turnInRateUpDownPercent").empty();
    $("#turnInRateUpDownPercent").removeClass("rise");
    $("#turnInRateUpDownPercent").removeClass("drop");
    $("#turnInRateGraph").empty();

    var value = data.series[0].TurnInRateTotal;
    var diff = data.series[0].DifferencesInTIR;


    if (value === 0) {
        $("#todayTurnInRate").html("-");
    } else {
        $("#todayTurnInRate").html(parseFloat(value).toFixed(2) + " %");
    }

    var diffOtHtml = "";
    if (diff === 0) {
        $("#turnInRateUpDownPercent").append(LanguageNoChanges);
    } else if (diff > 0) {
        $("#turnInRateUpDownPercent").addClass("rise");
        diffOtHtml = "<i class='fa fa-caret-up'></i> " + parseFloat(diff).toFixed(2) + "%";
    } else if (diff < 0) {
        $("#turnInRateUpDownPercent").addClass("drop");
        diffOtHtml = "<i class='fa fa-caret-down'></i> " + parseFloat(diff).toFixed(2) + "%";
    }
    $("#turnInRateUpDownPercent").append(diffOtHtml);
    plotMatricHighChartGraph("turnInRateGraph", data, colorScheme);

}

function bindVisitorCount(data, colorScheme) {
    $("#todayVisitorCount").empty();
    $("#visitorCountUpDownPercent").empty();
    $("#visitorCountUpDownPercent").removeClass("rise");
    $("#visitorCountUpDownPercent").removeClass("drop");
    $("#visitorCountGraph").empty();

    var value = data.series[0].visitorTotal;
    var diff = data.series[0].DifferencesInFF;


    if (value === 0) {
        $("#todayVisitorCount").html("-");
    } else {
        $("#todayVisitorCount").html(numberWithCommas(value));
    }

    var diffOtHtml = "";
    if (diff === 0) {
        $("#visitorCountUpDownPercent").append(LanguageNoChanges);
    } else if (diff > 0) {
        $("#visitorCountUpDownPercent").addClass("rise");
        diffOtHtml = "<i class='fa fa-caret-up'></i> " + parseFloat(diff).toFixed(2) + "%";
    } else if (diff < 0) {
        $("#visitorCountUpDownPercent").addClass("drop");
        diffOtHtml = "<i class='fa fa-caret-down'></i> " + parseFloat(diff).toFixed(2) + "%";
    }
    $("#visitorCountUpDownPercent").append(diffOtHtml);
    plotMatricHighChartGraph("visitorCountGraph", data, colorScheme);
}

function bindSalesConversion(data, colorScheme) {
    $("#todaySalesConversion").empty();
    $("#salesConversionUpDownPercent").empty();
    $("#salesConversionUpDownPercent").removeClass("rise");
    $("#salesConversionUpDownPercent").removeClass("drop");
    $("#salesConversionGraph").empty();

    var value = data.series[0].SalesConversionTotal;
    var diff = data.series[0].DiffInSC;


    if (value === 0) {
        $("#todaySalesConversion").html("-");
    } else {
        $("#todaySalesConversion").html(value + " %");
    }

    var diffOtHtml = "";
    if (diff === 0) {
        $("#salesConversionUpDownPercent").append(LanguageNoChanges);
    } else if (diff > 0) {
        $("#salesConversionUpDownPercent").addClass("rise");
        diffOtHtml = "<i class='fa fa-caret-up'></i> " + parseFloat(diff).toFixed(2) + "%";
    } else if (diff < 0) {
        $("#salesConversionUpDownPercent").addClass("drop");
        diffOtHtml = "<i class='fa fa-caret-down'></i> " + parseFloat(diff).toFixed(2) + "%";
    }
    $("#salesConversionUpDownPercent").append(diffOtHtml);
    plotMatricHighChartGraph("salesConversionGraph", data, colorScheme);
}

function plotMatricHighChartGraph(matricGraphId, data, colorScheme) {
    var chart = new Highcharts.Chart(
        {
            chart: {
                margin: [0, 0, 0, 0],
                backgroundColor: "transparent",
                renderTo: matricGraphId
            },
            title: {
                text: ''
            },
            credits: {
                enabled: false
            },
            xAxis: {
                labels: {
                    enabled: false
                }
            },
            yAxis: {
                maxPadding: 0,
                minPadding: 0,
                gridLineWidth: 0,
                endOnTick: false,
                labels: {
                    enabled: false
                }
            },
            legend: {
                enabled: false
            },
            tooltip: {
                enabled: false
            },
            plotOptions: {
                series: {
                    enableMouseTracking: false,
                    lineWidth: 1,
                    shadow: false,
                    states: {
                        hover: {
                            lineWidth: 1
                        }
                    },
                    marker: {
                        enabled: false,
                        radius: 0,
                        states: {
                            hover: {
                                radius: 2
                            }
                        }
                    }
                }
            },
            exporting: {
                enabled: false,
            },
            series: [{
                type: "areaspline",
                data: data.series[0].data,
                color: colorScheme.chart.sparkLine.color,
                fillOpacity: 0.5
                //data[miniChartData[i]].series[1].data
            }]
        });
}

function bindSalesConversionSectionGraph(data, colorScheme) {
    var footfall = data.series[0].ValueInInt; //footfall
    var salesConversion = data.series[0].SalesConversion; //salesConversion

    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "newDailyTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                }
            },
            series: [{
                type: 'column',
                name: LanguageNoofVisitor,
                data: footfall,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageSalesConversion + " (%)",
                dashStyle: 'dash',
                data: salesConversion,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1,
                yAxis: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //text: LanguageWeeklyTrend,
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.outsideTraffic,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    },
                    point: {
                        events: {
                            click: function () {
                                location.href = "Analytics?type=w" + this.category.name + "&range=day&parameter=19&branchId=" + $("#selectBoxBranch").val() + "&compare=1";
                            }
                        }
                    },
                    cursor: 'pointer'
                }
            },
            yAxis: [{
                lineWidth: 0,
                tickWidth: 1,
                min: 0,
                gridLineWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            {
                opposite: true,
                //linkedTo: 0,
                lineWidth: 0,
                tickWidth: 0,
                min: 0,
                gridLineWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageSalesConversion + " (%)",
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 206,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            },
        });
    });


}

function bindSalesConversionTable(data, colorScheme) {
    var footfall = data.series[0].ValueInInt;
    var turnInRate = data.series[0].TIR;
    var outsideTraffic = data.series[0].OutsideTrafficInt;
    var salesConversion = data.series[0].SalesConversion;
    var transactionCount = data.series[0].TransactionCountInt;

    $("#todaySCTableContent").html("");

    for (var i = 0; i < data.categories.length; i++) {

        var html = "<tr><td>" + data.categories[i] + "</td><td>" + footfall[i] + "</td><td>" + outsideTraffic[i] + "</td><td>" + parseFloat(turnInRate[i]).toFixed(2) + "</td><td>" + transactionCount[i] + "</td><td>" + parseFloat(salesConversion[i]).toFixed(2) + "</td></tr>";

        $("#todaySCTableContent").append(html);
    }


}


function numberWithCommas(x) {
    var parts = x.toString().split(".");
    parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    return parts.join(".");
}


function emptyAll() {
    $("#todaySCTableContent").empty();
    $("#salesConversionGraph").empty();
    $("#salesConversionUpDownPercent").empty();
    $("#todaySalesConversion").empty();
    $("#visitorCountGraph").empty();
    $("#visitorCountUpDownPercent").empty();
    $("#todayVisitorCount").empty();
    $("#turnInRateGraph").empty();
    $("#turnInRateUpDownPercent").empty();
    $("#todayTurnInRate").empty();
    $("#outsideTrafficGraph").empty();
    $("#outsideTrafficUpDownPercent").empty();
    $("#todayOutsideTraffic").empty();
    $("#newDailyTrend").empty();

}