﻿//--------------General Function--------------//
function chartLoading() {
    loadingChart("newMonthlyTrend");
    $("#newMonthlyTrend").addClass("chartLoading");

    loadingChart("newWeeklyTrend");
    $("#newWeeklyTrend").addClass("chartLoading");

    loadingChart("newDailyTrend");
    $("#newDailyTrend").addClass("chartLoading");

    loadingChart("newLast7Days");
    $("#newLast7Days").addClass("chartLoading");

    loadingChart("weekdaysTrafficProfile");
    $("#weekdaysTrafficProfile").addClass("chartLoading");

    loadingChart("weekendsTrafficProfile");
    $("#weekendsTrafficProfile").addClass("chartLoading");

}

var weekDay//share to all table
function showDayAndDate(startDate) {
    if (startDate != null) {
        var tempDate = startDate.split("/");
        //console.log(tempDate[2], tempDate[1], tempDate[0]);
        startDate = new Date(tempDate[2], tempDate[1] - 1, tempDate[0] - 1);
        var date = new Array();
        for (var i = 0 ; i < 7; i++)
            date.push(new Date(startDate.setDate(startDate.getDate() + 1)));
        var day = new Array(7);
        weekDay = new Array(7);
        day[0] = LanguageSun;
        day[1] = LanguageMon;
        day[2] = LanguageTue;
        day[3] = LanguageWed;
        day[4] = LanguageThu;
        day[5] = LanguageFri;
        day[6] = LanguageSat;
        for (var i = 0 ; i < 7; i++) {
            weekDay[i] = day[date[i].getDay()] + " " + date[i].getDate() + "/" + (date[i].getMonth() + 1);
        }
        return weekDay;
    }
    else
        return new Array(7);

}

function checkSalesVolumeDataIntegrity(data) {
    //console.log(data);
    var count = 0;
    //console.log(data.length);
    //console.log(data);
    if (data.length >= 4) {
        for (var i = 0; i < data.length; i++) {
            if (data[i] == 0)
                count++;
        }
        if (count >= 4)
            return false;
        else
            return true;
    }
    else {
        return false;
    }
}

//Sales Conversion This Week and Last Week Highchart
function bindLastTwoWeekSalesConversion(data, colorScheme) {
    //console.log(data);
    //var thisWeekTotal = 0.0;
    //var lastWeekTotal = 0.0;
    //var count = 0;
    //var count2 = 0;
    //for (var i = 0; i < data.series[0].data.length; i++) {
    //    lastWeekTotal += data.series[0].data[i];
    //    if (data.series[0].data[i] != 0)
    //        count++;
    //}
    //lastWeekTotal = lastWeekTotal / count;
    //for (var i = 0; i < data.series[1].data.length; i++) {
    //    thisWeekTotal += data.series[1].data[i];
    //    if (data.series[1].data[i] != 0)
    //        count2++;
    //}
    //thisWeekTotal = thisWeekTotal / count2;
    //console.log(data.series[0].data);
    //console.log(data.series[1].data);
    //console.log("last week total: " + lastWeekTotal);
    //console.log("this week total: " + thisWeekTotal);
    lastWeekTotal = data.series[0].total < 0 ? "-" : data.series[0].total + "%";
    thisWeekTotal = data.series[1].total < 0 ? "-" : data.series[1].total + "%";

    var changesInTwoWeeks = data.series[2].total;
    $("#lastWeekSalesConversion").empty();
    $("#thisWeekSalesConversion").empty();
    // $('#totalSCUpDownIcon').empty();
    $("#changesInTwoWeeksSC").empty();

    //console.log("changesInTwoWeeks: " + changesInTwoWeeks);
    if (lastWeekTotal >= 100)
        lastWeekTotal = 100 + "%";
    else
        $("#lastWeekSalesConversion").append(lastWeekTotal);


    if (thisWeekTotal >= 100)
        thisWeekTotal = 100 + "%";
    else
        $("#thisWeekSalesConversion").append(thisWeekTotal);
    $("#changesInTwoWeeksSC").removeClass("rise");
    $("#changesInTwoWeeksSC").removeClass("drop");

    if (lastWeekTotal != 0 && thisWeekTotal != 0) {
        if (changesInTwoWeeks > 0) {
            $("#changesInTwoWeeksSC").addClass("rise");
            //$('#totalSCUpDownIcon').append("<i class=\"fa fa-caret-up\" style=\"color: " + colorScheme.chart.arrow.up + "\">");
            $("#changesInTwoWeeksSC").append("<i class='fa fa-caret-up'></i> " + changesInTwoWeeks + "%");
        }
        else if (changesInTwoWeeks < 0) {
            $("#changesInTwoWeeksSC").addClass("drop");
            //$('#totalSCUpDownIcon').append("<i class=\"fa fa-caret-down\" style=\"color: " + colorScheme.chart.arrow.down + "\">");
            $("#changesInTwoWeeksSC").append("<i class='fa fa-caret-down'></i> " + changesInTwoWeeks * -1 + "%");
        }
        else
            $('#changesInTwoWeeksSC').append(LanguageNoChanges);

    }
    var miniChartId = ['lastWeekGraph', 'thisWeekGraph'];
    var miniChartData = [data.series[0].data, data.series[1].data];
    //draw graph under each box, footfallcount
    for (var i = 0; i < miniChartId.length; i++) {
        $(function () {
            Highcharts.setOptions({
                global: {
                    useUTC: false
                }
            });
            var chart = new Highcharts.Chart({

                chart: {
                    renderTo: miniChartId[i],
                    margin: [0, 0, 0, 0],
                    backgroundColor: 'transparent'
                },
                title: {
                    text: ''
                },
                credits: {
                    enabled: false
                },
                xAxis: {
                    labels: {
                        enabled: false
                    }
                },
                yAxis: {
                    maxPadding: 0,
                    minPadding: 0,
                    gridLineWidth: 0,
                    endOnTick: false,
                    labels: {
                        enabled: false
                    }
                },
                legend: {
                    enabled: false
                },
                tooltip: {
                    enabled: false
                },
                plotOptions: {
                    series: {
                        enableMouseTracking: false,
                        lineWidth: 1,
                        shadow: false,
                        states: {
                            hover: {
                                lineWidth: 1
                            }
                        },
                        marker: {
                            enabled: false,
                            radius: 0,
                            states: {
                                hover: {
                                    radius: 2
                                }
                            }
                        }
                    }
                },
                exporting: {
                    enabled: false,
                },
                series: [{
                    type: 'areaspline',
                    data: miniChartData[i],
                    color: colorScheme.chart.sparkLine.color,
                    fillOpacity: 0.5
                    //data[miniChartData[i]].series[1].data
                }]
            });
        });
    }

    bindBestPerformDayTrend(data.series[1]);
}

//Sales Conversion Monthly Trend
function bindSalesConversionMonthlyTrend(data, colorScheme) {
    var footfall = data.series[0].ValueInInt; //footfall
    var salesConversion = data.series[0].SalesConversion; //salesConversion

    //console.log(footfall);


    //identify largest value of yaxis data
    //var largestValue = 0;
    //for (var i = 0; i < footfall.length; i++) {
    //    if (footfall[i] != null && footfall[i] != undefined && footfall[i] > largestValue)
    //        largestValue = footfall[i]
    //}

    //for (var i = 0; i < salesConversion.length; i++) {
    //    if (salesConversion.data[i] != null && salesConversion.data[i] != undefined && salesConversion.data[i] > largestValue)
    //        largestValue = salesConversion.data[i]
    //}

    //var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
    //                       : largestValue >= 10 && largestValue < 100 ? 10
    //                       : largestValue >= 100 && largestValue < 1000 ? 100
    //                       : largestValue >= 1000 && largestValue < 10000 ? 1000
    //                       : largestValue >= 10000 && largestValue < 100000 ? 10000
    //                       : largestValue >= 100000 && largestValue < 1000000 ? 100000
    //                       : 1000000;

    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "newMonthlyTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'column',
                name: LanguageNoofVisitor,
                data: footfall,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageSalesConversion + ' (%)',
                dashStyle: 'dash',
                data: salesConversion,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1,
                yAxis:1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //text: LanguageMonthlyTrend,
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.salesConversion,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    },
                    point: {
                        events: {
                            click: function () {
                                location.href = "Analytics?type=" + this.category.name + "&range=day&parameter=19&branchId=" + $("#selectBoxBranch").val() + "&compare=1";
                            }
                        }
                    },
                    cursor: 'pointer'
                }
            },
            yAxis: [{
                lineWidth: 0,
                min: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            {
                opposite: true,
                //linkedTo: 0,
                lineWidth: 0,
                min: 0,
                gridLineWidth: 1,
                tickWidth: 0,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                labels: {
                    format: '{value}',
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                title: {
                    text: LanguageSalesConversion +' (%)',
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                }
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                title: {
                    text: LanguageMonth,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 6,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 18,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            },
        });
    });
}

function bindLastTwoWeekSCInTable(data, data1, data2) {
    var weekNo = $('#weekpicker').val();
    weekNo = LanguageWeek + " " + weekNumber;

    $("#lastTwoWeeksSCTableHead").html("");
    $("#lastTwoWeeksSCTableContent").html("");
    $("#lastTwoWeeksSCTableFoot").html("");
    $("#lastTwoWeeksSCTableHead").append("<tr><th>" + weekNo + "</th><th>" + LanguageNoofVisitor + "</th><th>" + LanguageSalesVolume + "</th><th>" + LanguageConversion + "</th></tr>");
    var changes = 0;
    var UpdownIcon = "";
    var valueIn = "";
    var salesVolume = "";

    for (var i = 0; i < 7; i++) {
        changes = data.series[2].data[i] > 0 ? data.series[2].data[i] + "%" : "-";
        valueIn = data.series[0].data[i] > 0 ? data.series[0].data[i] : "-";
        salesVolume = data.series[1].data[i] > 0 ? data.series[1].data[i] : "-";

        $("#lastTwoWeeksSCTableContent").append("<tr><td>" + weekDay[i] + "</td><td>" + valueIn + "</td><td>" + salesVolume + "</td><td>" + changes + "</td></tr>");
    }

    var totalValueIn = data.series[0].total > 0 ? data.series[0].total : "-";
    var totalSalesVolume = data.series[1].total > 0 ? data.series[1].total : "-";
    var totalChanges = data.series[2].total > 0 ? data.series[2].total + "%" : "-";

    $("#lastTwoWeeksSCTableFoot").append("<tr><td>" + LanguageTotal + "</td><td>" + totalValueIn + "</td><td>" + totalSalesVolume + "</td><td>" + totalChanges + "</td></tr>");
}

//Sales Conversion Weekly Trend
function bindSalesConversionWeeklyTrend(data, colorScheme) {
    var tempWeek = [];
    for (var i = 1; i <= data.categories.length; i++) {
        tempWeek.push(i);
    }

    var footfall = data.series[0].ValueInInt; //footfall
    var salesConversion = data.series[0].SalesConversion; //salesConversion

    //identify largest value of yaxis data
    //var largestValue = 0;
    //for (var i = 0; i < footfall.count(); i++) {
    //    if (footfall.data[i] != null && footfall.data[i] != undefined && footfall.data[i] > largestValue)
    //        largestValue = footfall.data[i];
    //}

    //for (var i = 0; i < salesConversion.data.length; i++) {
    //    if (salesConversion.data[i] != null && salesConversion.data[i] != undefined && salesConversion.data[i] > largestValue)
    //        largestValue = salesvolume.data[i];
    //}

    //var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
    //                       : largestValue >= 10 && largestValue < 100 ? 10
    //                       : largestValue >= 100 && largestValue < 1000 ? 100
    //                       : largestValue >= 1000 && largestValue < 10000 ? 1000
    //                       : largestValue >= 10000 && largestValue < 100000 ? 10000
    //                       : largestValue >= 100000 && largestValue < 1000000 ? 100000
    //                       : 1000000;
    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "newWeeklyTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                }
            },
            series: [{
                type: 'column',
                name: LanguageNoofVisitor,
                data: footfall,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageSalesConversion + ' (%)',
                dashStyle: 'dash',
                data: salesConversion,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1,
                yAxis:1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //text: LanguageWeeklyTrend,
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.salesConversion,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    },
                    point: {
                        events: {
                            click: function () {
                                location.href = "Analytics?type=w" + this.category.name + "&range=day&parameter=19&branchId=" + $("#selectBoxBranch").val() + "&compare=1";
                            }
                        }
                    },
                    cursor: 'pointer'
                }
            },
            yAxis: [{
                lineWidth: 0,
                tickWidth: 1,
                min: 0,
                gridLineWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
           {
               opposite: true,
               //linkedTo: 0,
               lineWidth: 0,
               tickWidth: 0,
               min: 0,
               gridLineWidth: 1,
               //tickInterval: dynamicTickInterval,
               tickPixelInterval: 15,
               tickPosition: 'inside',
               title: {
                   text: LanguageSalesConversion + ' (%)',
                   style: {
                       color: colorScheme.chart.axisLabel.y.title.color,
                       fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                       "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                   }
               },
               labels: {
                   style: {
                       "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                       color: colorScheme.chart.axisLabel.y.label.color,
                       fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                   },
                   format: '{value}'
               }
           }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                title: {
                    text: LanguageWeek,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 206,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            },
        });
    });
}

//Sales Conversion Daily Trend
function bindSalesConversionDailyTrend(data, colorScheme) {
    var footfall = data.series[0].ValueInInt; //footfall
    var salesConversion = data.series[0].SalesConversion; //salesConversion

    //identify largest value of yaxis data
    //var largestValue = 0;
    //for (var i = 0; i < footfall.data.length; i++) {
    //    if (footfall.data[i] != null && footfall.data[i] != undefined && footfall.data[i] > largestValue)
    //        largestValue = footfall.data[i];
    //}

    //for (var i = 0; i < salesConversion.data.length; i++) {
    //    if (salesConversion.data[i] != null && salesConversion.data[i] != undefined && salesConversion.data[i] > largestValue)
    //        largestValue = salesConversion.data[i];
    //}

    //var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
    //                       : largestValue >= 10 && largestValue < 100 ? 10
    //                       : largestValue >= 100 && largestValue < 1000 ? 100
    //                       : largestValue >= 1000 && largestValue < 10000 ? 1000
    //                       : largestValue >= 10000 && largestValue < 100000 ? 10000
    //                       : largestValue >= 100000 && largestValue < 1000000 ? 100000
    //                       : 1000000;

    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "newDailyTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                }
            },
            series: [{
                type: 'column',
                name: LanguageNoofVisitor,
                data: footfall,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageSalesConversion + ' (%)',
                dashStyle: 'dash',
                data: salesConversion,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1,
                yAxis:1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //text: LanguageDailyTrend,
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.salesConversion,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    },
                    point: {
                        events: {
                            click: function () {
                                location.href = "Analytics?type=d" + this.category.name + "&range=hour&parameter=19&branchId=" + $("#selectBoxBranch").val() + "&compare=1";
                            }
                        }
                    },
                    cursor: 'pointer'
                }
            },
            yAxis: [{
                lineWidth: 0,
                min: 0,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                gridLineWidth: 1,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            {
                opposite: true,
                //linkedTo: 0,
                lineWidth: 0,
                tickWidth: 0,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                min: 0,
                gridLineWidth: 1,
                tickPosition: 'inside',
                title: {
                    text: LanguageSalesConversion + ' (%)',
                    margin: 25,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                tickInterval: 1,
                title: {
                    text: LanguageDay,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 206,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            },
        });
    });
}

//7days graph
function bindLastSevenDaysSCTrend(data, colorScheme) {
    var footfall = data.series[0]; //footfall
    var salesvolume = data.series[1]; //salesvolume

    //identify largest value of yaxis data
    var largestValue = 0;
    for (var i = 0; i < footfall.data.length; i++) {
        if (footfall.data[i] != null && footfall.data[i] != undefined && footfall.data[i] > largestValue)
            largestValue = footfall.data[i];
    }

    for (var i = 0; i < salesvolume.data.length; i++) {
        if (salesvolume.data[i] != null && salesvolume.data[i] != undefined && salesvolume.data[i] > largestValue)
            largestValue = salesvolume.data[i];
    }

    var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
                           : largestValue >= 10 && largestValue < 100 ? 10
                           : largestValue >= 100 && largestValue < 1000 ? 100
                           : largestValue >= 1000 && largestValue < 10000 ? 1000
                           : largestValue >= 10000 && largestValue < 100000 ? 10000
                           : largestValue >= 100000 && largestValue < 1000000 ? 100000
                           : 1000000;
    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "newLast7Days",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                }
            },
            series: [{
                type: 'areaspline',
                name: LanguageNoofVisitor,
                data: data.series[0].data,
                color: colorScheme.chart.sparkLine.color,
                fillOpacity: 0.5,
                lineWidth: 1
            }, {
                type: 'line',
                name: LanguageSalesVolume,
                dashStyle: 'dash',
                data: data.series[1].data,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //text: LanguageLastWeek,
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.salesConversion,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    }
                }
            },
            yAxis: [{
                lineWidth: 0,
                min: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            {
                opposite: true,
                linkedTo: 0,
                lineWidth: 0,
                tickWidth: 0,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                min: 0,
                gridLineWidth: 1,
                tickPosition: 'inside',
                title: {
                    text: LanguageSalesVolume,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }

                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            }],
            xAxis: {
                categories: [{
                    name: ifmonday,
                    categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                }, {
                    name: iftuesday,
                    categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                }, {
                    name: ifwednesday,
                    categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                },
                {
                    name: ifthursday,
                    categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                },
                {
                    name: iffriday,
                    categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                },
                {
                    name: ifsaturday,
                    categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                },
                {
                    name: ifsunday,
                    categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                }],
                tickWidth: 0,
                tickInterval: 4,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 206,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            },
        });
    });
}

//best perform day
function bindBestPerformDayTrend(data) {
    var weekNo = $('#weekpicker').val();
    weekNo = LanguageWeek + " " + weekNumber;

    var weekDay = new Array(7);

    if (firstDayOfWeek == "Sunday") {
        weekDay[0] = LanguageSunday;
        weekDay[1] = LanguageMonday;
        weekDay[2] = LanguageTuesday;
        weekDay[3] = LanguageWednesday;
        weekDay[4] = LanguageThursday;
        weekDay[5] = LanguageFriday;
        weekDay[6] = LanguageSaturday;
    } else if (firstDayOfWeek == "Saturday") {
        weekDay[0] = LanguageSaturday;
        weekDay[1] = LanguageSunday;
        weekDay[2] = LanguageMonday;
        weekDay[3] = LanguageTuesday;
        weekDay[4] = LanguageWednesday;
        weekDay[5] = LanguageThursday;
        weekDay[6] = LanguageFriday;
    } else if (firstDayOfWeek == "Friday") {
        weekDay[0] = LanguageFriday;
        weekDay[1] = LanguageSaturday;
        weekDay[2] = LanguageSunday;
        weekDay[3] = LanguageMonday;
        weekDay[4] = LanguageTuesday;
        weekDay[5] = LanguageWednesday;
        weekDay[6] = LanguageThursday;
    } else {
        weekDay[0] = LanguageMonday;
        weekDay[1] = LanguageTuesday;
        weekDay[2] = LanguageWednesday;
        weekDay[3] = LanguageThursday;
        weekDay[4] = LanguageFriday;
        weekDay[5] = LanguageSaturday;
        weekDay[6] = LanguageSunday;
    }
    //var weekDay = ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"];
    //var salesConversionByDay = 0;
    //var salesConversion = [];
    //var index = 0;
    //var valuesIn = 0;
    //var transactionCount = 0;
    //var count = 0;
    //for (var i = 1; i <= data.series[0].data.length; i++) {
    //    valuesIn += data.series[0].data[i - 1];
    //    transactionCount += data.series[1].data[i - 1];
    //    if (i % 24 == 0) {
    //        if (valuesIn != 0)
    //            salesConversionByDay = +((transactionCount * 100.0 / valuesIn).toFixed(2));
    //        else
    //            salesConversionByDay = 0;
    //        salesConversion.push(salesConversionByDay);
    //        index++;
    //        tempArr = [];
    //        valuesIn = 0;
    //        transactionCount = 0;
    //    }
    //}
    //var highestSC = salesConversion[0];
    //var highestIndex = 0;
    //for (var i = 0; i < salesConversion.length; i++) {
    //    if (highestSC <= salesConversion[i]) {
    //        highestSC = salesConversion[i];
    //        highestIndex = i;
    //    }
    //}
    //console.log(salesConversion);
    //console.log("The best perform day = " + weekDay[highestIndex]);
    //console.log("The best perform sales conversion = " + highestSC);3
    var bestOfDay = data.BestDay;
    highestSC = data.BestNumber > 0 ? data.BestNumber + "%" : "-";
    $("#bestPerformDay").empty();
    $("#totalBestPerformSC").empty();
    if (highestSC >= 100)
        $("#totalBestPerformSC").append("100%");
    else
        $("#totalBestPerformSC").append(highestSC);
    $("#bestPerformDay").append(bestOfDay);
}

function bindWeekdaysTrend(data, colorScheme) {
    if (data.series[0].isDayOff) {
        var showmarker = false;
        var showtooltip = false;
    }
    else {
        var showmarker = true;
        var showtooltip = true;
    }
    var weekdayshourlyValueIn = data.series[0].data;
    var weekdayshourlyTrans = data.series[1].data;

    //identify largest value of yaxis data
    var largestValue = 0;
    for (var i = 0; i < weekdayshourlyValueIn.length; i++) {
        if (weekdayshourlyValueIn[i] != null && weekdayshourlyValueIn[i] != undefined && weekdayshourlyValueIn[i] > largestValue)
            largestValue = weekdayshourlyValueIn[i]
    }

    for (var i = 0; i < weekdayshourlyTrans.length; i++) {
        if (weekdayshourlyTrans[i] != null && weekdayshourlyTrans[i] != undefined && weekdayshourlyTrans[i] > largestValue)
            largestValue = weekdayshourlyTrans[i]
    }

    var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
                           : largestValue >= 10 && largestValue < 100 ? 10
                           : largestValue >= 100 && largestValue < 1000 ? 100
                           : largestValue >= 1000 && largestValue < 10000 ? 1000
                           : largestValue >= 10000 && largestValue < 100000 ? 10000
                           : largestValue >= 100000 && largestValue < 1000000 ? 100000
                           : 1000000;
    //weekdays trend
    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "weekdaysTrafficProfile",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'column',
                name: LanguageNoofVisitor,
                data: weekdayshourlyValueIn,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageSalesVolume,
                dashStyle: 'dash',
                data: weekdayshourlyTrans,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
            },
            subtitle: {
                text: LanguageWeekdays,
                align: 'center',
                style: {
                    color: colorScheme.chart.subtitle.color,
                    fontSize: colorScheme.chart.subtitle.fontSize,
                    "font-family": colorScheme.chart.subtitle.fontFamily
                },
                margin: 0,
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false,
                        states: {
                            hover: {
                                enabled: showmarker,
                            }
                        }
                    }
                }
            },
            yAxis: [{
                lineWidth: 0,
                min: 0,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                gridLineWidth: 1,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            {
                opposite: true,
                linkedTo: 0,
                lineWidth: 0,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickWidth: 0,
                min: 0,
                gridLineWidth: 1,
                tickPosition: 'inside',
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                title: {
                    text: LanguageSalesVolume,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                //itemStyle: {
                //    color: colorScheme.chart.legend.text.color,
                //    "font-family": colorScheme.chart.legend.text.fontFamily,
                //    fontSize: colorScheme.chart.legend.text.fontSize,
                //    "font-weight": colorScheme.chart.legend.text.fontWeight
                //},
                enabled: false,
                //x: 12,
                //y: 15,
                //verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
                enabled: showtooltip,
            },
        });
        //if (data.series[0].isDayOff) {
        //    $("#weekdaysTrafficProfile").append("<div class='weekend-notice'>" + LanguageCloseonWeekends + "</div>");
        //}
    });
}

function bindWeekendsTrend(data, colorScheme) {
    if (data.series[0].isDayOff) {
        var showmarker = false;
        var showtooltip = false;
    }
    else {
        var showmarker = true;
        var showtooltip = true;
    }
    var weekendshourlyValueIn = data.series[0].data;
    var weekendshourlyTrans = data.series[1].data;

    //identify largest value of yaxis data
    var largestValue = 0;
    for (var i = 0; i < weekendshourlyValueIn.length; i++) {
        if (weekendshourlyValueIn[i] != null && weekendshourlyValueIn[i] != undefined && weekendshourlyValueIn[i] > largestValue)
            largestValue = weekendshourlyValueIn[i]
    }

    for (var i = 0; i < weekendshourlyTrans.length; i++) {
        if (weekendshourlyTrans[i] != null && weekendshourlyTrans[i] != undefined && weekendshourlyTrans[i] > largestValue)
            largestValue = weekendshourlyTrans[i]
    }

    var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
                           : largestValue >= 10 && largestValue < 100 ? 10
                           : largestValue >= 100 && largestValue < 1000 ? 100
                           : largestValue >= 1000 && largestValue < 10000 ? 1000
                           : largestValue >= 10000 && largestValue < 100000 ? 10000
                           : largestValue >= 100000 && largestValue < 1000000 ? 100000
                           : 1000000;
    //weekends trend
    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "weekendsTrafficProfile",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'column',
                name: LanguageNoofVisitor,
                data: weekendshourlyValueIn,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageSalesVolume,
                dashStyle: 'dash',
                data: weekendshourlyTrans,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
            },
            subtitle: {
                text: LanguageWeekends,
                align: 'center',
                style: {
                    color: colorScheme.chart.subtitle.color,
                    fontSize: colorScheme.chart.subtitle.fontSize,
                    "font-family": colorScheme.chart.subtitle.fontFamily
                },
                margin: 0,
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false,
                        states: {
                            hover: {
                                enabled: showmarker,
                            }
                        }
                    }
                }
            },
            yAxis: [{
                lineWidth: 0,
                min: 0,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                gridLineWidth: 1,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
             {
                 opposite: true,
                 linkedTo: 0,
                 lineWidth: 0,
                 min: 0,
                 gridLineWidth: 0,
                 tickWidth: 0,
                 //tickInterval: dynamicTickInterval,
                 tickPixelInterval: 15,
                 tickPosition: 'inside',
                 labels: {
                     style: {

                         "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                         color: colorScheme.chart.axisLabel.y.label.color,
                         fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                     }
                 },
                 title: {
                     text: LanguageSalesVolume,
                     style: {
                         color: colorScheme.chart.axisLabel.y.title.color,
                         fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                         "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                     }
                 },
             }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                //itemStyle: {
                //    color: colorScheme.chart.legend.text.color,
                //    "font-family": colorScheme.chart.legend.text.fontFamily,
                //    fontSize: colorScheme.chart.legend.text.fontSize,
                //    "font-weight": colorScheme.chart.legend.text.fontWeight
                //},
                enabled: false,
                //x: 12,
                //y: 15,
                //verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
                enabled: showtooltip,
            },
        });
        //if (data.series[0].isDayOff) {
        //    $("#weekendsTrafficProfile").append("<div class='weekend-notice'>" + LanguageCloseonWeekends + "</div>");
        //}
    });
}

//Wilson
//Top Matrices
function bindOutsideTraffic(data, colorScheme) {
    $("#thisWeekOutsideTraffic").html("");
    $("#outsideTrafficUpDownPercent").html("");
    $("#outsideTrafficUpDownPercent").removeClass("drop");
    $("#outsideTrafficUpDownPercent").removeClass("rise");

    $("#thisWeekOutsideTraffic").html(numberWithCommas(data.series[0].total));

    
    if (data.series[0].DifferencesInOT < 0) {
        $("#outsideTrafficUpDownPercent").addClass("drop");
        $("#outsideTrafficUpDownPercent").append('<i class="fa fa-caret-down"></i> ' + Math.abs(data.series[0].DifferencesInOT) + '%');
    } else {
        $("#outsideTrafficUpDownPercent").addClass("rise");
        $("#outsideTrafficUpDownPercent").append('<i class="fa fa-caret-up"></i> ' + data.series[0].DifferencesInOT + '%');
    }
    $(function () {
        Highcharts.setOptions({
            global: {
                useUTC: false
            }
        });
        var chart = new Highcharts.Chart({

            chart: {
                renderTo: 'outsideTrafficGraph',
                margin: [0, 0, 0, 0],
                backgroundColor: 'transparent'
            },
            title: {
                text: ''
            },
            credits: {
                enabled: false
            },
            xAxis: {
                labels: {
                    enabled: false
                }
            },
            yAxis: {
                maxPadding: 0,
                minPadding: 0,
                gridLineWidth: 0,
                endOnTick: false,
                labels: {
                    enabled: false
                }
            },
            legend: {
                enabled: false
            },
            tooltip: {
                enabled: false
            },
            plotOptions: {
                series: {
                    enableMouseTracking: false,
                    lineWidth: 1,
                    shadow: false,
                    states: {
                        hover: {
                            lineWidth: 1
                        }
                    },
                    marker: {
                        enabled: false,
                        radius: 0,
                        states: {
                            hover: {
                                radius: 2
                            }
                        }
                    }
                }
            },
            exporting: {
                enabled: false,
            },
            series: [{
                type: 'areaspline',
                data: data.series[0].data,
                color: colorScheme.chart.sparkLine.color,
                fillOpacity: 0.5
                //data[miniChartData[i]].series[1].data
            }]
        });
    });
}
function bindTurnInRate(data, colorScheme) {
    $("#thisWeekTurnInRate").html("");
    $("#turnInRateUpDownPercent").html("");
    $("#turnInRateUpDownPercent").removeClass("drop");
    $("#turnInRateUpDownPercent").removeClass("rise");
    $("#thisWeekTurnInRate").html(data.series[0].total+"%");

    if (data.series[0].DifferencesInTIR < 0) {
        $("#turnInRateUpDownPercent").addClass("drop");
        $("#turnInRateUpDownPercent").append('<i class="fa fa-caret-down"></i> ' + Math.abs(data.series[0].DifferencesInTIR) + '%');
    } else {
        $("#turnInRateUpDownPercent").addClass("rise");
        $("#turnInRateUpDownPercent").append('<i class="fa fa-caret-up"></i> ' + data.series[0].DifferencesInTIR + '%');
    }
    $(function () {
        Highcharts.setOptions({
            global: {
                useUTC: false
            }
        });
        var chart = new Highcharts.Chart({

            chart: {
                renderTo: 'turnInRateGraph',
                margin: [0, 0, 0, 0],
                backgroundColor: 'transparent'
            },
            title: {
                text: ''
            },
            credits: {
                enabled: false
            },
            xAxis: {
                labels: {
                    enabled: false
                }
            },
            yAxis: {
                maxPadding: 0,
                minPadding: 0,
                gridLineWidth: 0,
                endOnTick: false,
                labels: {
                    enabled: false
                }
            },
            legend: {
                enabled: false
            },
            tooltip: {
                enabled: false
            },
            plotOptions: {
                series: {
                    enableMouseTracking: false,
                    lineWidth: 1,
                    shadow: false,
                    states: {
                        hover: {
                            lineWidth: 1
                        }
                    },
                    marker: {
                        enabled: false,
                        radius: 0,
                        states: {
                            hover: {
                                radius: 2
                            }
                        }
                    }
                }
            },
            exporting: {
                enabled: false,
            },
            series: [{
                type: 'areaspline',
                data: data.series[0].data,
                color: colorScheme.chart.sparkLine.color,
                fillOpacity: 0.5
                //data[miniChartData[i]].series[1].data
            }]
        });
    });
}
function bindVisitorCount(data, colorScheme) {
    $("#thisWeekVisitorCount").html("");
    $("#visitorCountUpDownPercent").html("");
    $("#visitorCountUpDownPercent").removeClass("drop");
    $("#visitorCountUpDownPercent").removeClass("rise");
    $("#thisWeekVisitorCount").html(numberWithCommas(data.series[0].total));


    if (data.series[0].changesOfVisitorTotal < 0) {
        $("#visitorCountUpDownPercent").addClass("drop");
        $("#visitorCountUpDownPercent").append('<i class="fa fa-caret-down"></i> ' + Math.abs(data.series[0].changesOfVisitorTotal) + '%');
    } else {
        $("#visitorCountUpDownPercent").addClass("rise");
        $("#visitorCountUpDownPercent").append('<i class="fa fa-caret-up"></i> ' + data.series[0].changesOfVisitorTotal + '%');
    }
    $(function () {
        Highcharts.setOptions({
            global: {
                useUTC: false
            }
        });
        var chart = new Highcharts.Chart({

            chart: {
                renderTo: 'visitorCountGraph',
                margin: [0, 0, 0, 0],
                backgroundColor: 'transparent'
            },
            title: {
                text: ''
            },
            credits: {
                enabled: false
            },
            xAxis: {
                labels: {
                    enabled: false
                }
            },
            yAxis: {
                maxPadding: 0,
                minPadding: 0,
                gridLineWidth: 0,
                endOnTick: false,
                labels: {
                    enabled: false
                }
            },
            legend: {
                enabled: false
            },
            tooltip: {
                enabled: false
            },
            plotOptions: {
                series: {
                    enableMouseTracking: false,
                    lineWidth: 1,
                    shadow: false,
                    states: {
                        hover: {
                            lineWidth: 1
                        }
                    },
                    marker: {
                        enabled: false,
                        radius: 0,
                        states: {
                            hover: {
                                radius: 2
                            }
                        }
                    }
                }
            },
            exporting: {
                enabled: false,
            },
            series: [{
                type: 'areaspline',
                data: data.series[0].data,
                color: colorScheme.chart.sparkLine.color,
                fillOpacity: 0.5
                //data[miniChartData[i]].series[1].data
            }]
        });
    });
}

//League Statistics
function bindLeagueStatistic(data) {
    $("#leagueStatisticThisStore").html("");
    $("#leagueStatisticCompany").html("");

    var weeklyConversionHtml = '<table class="table">' +
        '<tr><td></td><td>%</td><td>Co. Rank</td></tr >' +
        '<tr><td>This Store</td><td>' + data.series[0].SalesConversion[0] + '</td><td>' + data.series[0].StoreRank + '/' + data.series[0].TotalNumberOfStore + '</td></tr></table >';

    var companyHtml = '<table class="table">' +
        '<tr><td>Range</td><td>%</td></tr >' +
        '<tr><td>Average</td><td>' + data.series[0].SalesConversion[1] + '%</td><tr>' +
        '<tr><td>Lowest</td><td>' + data.series[0].SalesConversion[2] + '%</td><tr>' +
        '<tr><td>Highest</td><td>' + data.series[0].SalesConversion[3]  + '%</td><tr>'

    $("#leagueStatisticThisStore").append(weeklyConversionHtml);
    $("#leagueStatisticCompany").append(companyHtml);
}

//Outside Traffic Monthly Trend
function bindOutsideTrafficMonthlyTrend(data, colorScheme) {
    var footfall = data.series[0].ValueInInt; //footfall
    var outsideTraffic = data.series[0].OutsideTrafficInt; //outsideTraffic

    //console.log(footfall);


    //identify largest value of yaxis data
    //var largestValue = 0;
    //for (var i = 0; i < footfall.length; i++) {
    //    if (footfall[i] != null && footfall[i] != undefined && footfall[i] > largestValue)
    //        largestValue = footfall[i]
    //}

    //for (var i = 0; i < outsideTraffic.length; i++) {
    //    if (outsideTraffic.data[i] != null && outsideTraffic.data[i] != undefined && outsideTraffic.data[i] > largestValue)
    //        largestValue = outsideTraffic.data[i]
    //}

    //var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
    //                       : largestValue >= 10 && largestValue < 100 ? 10
    //                       : largestValue >= 100 && largestValue < 1000 ? 100
    //                       : largestValue >= 1000 && largestValue < 10000 ? 1000
    //                       : largestValue >= 10000 && largestValue < 100000 ? 10000
    //                       : largestValue >= 100000 && largestValue < 1000000 ? 100000
    //                       : 1000000;

    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "newOutsideTrafficMonthlyTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'column',
                name: LanguageNoofVisitor,
                data: footfall,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageOutsideTraffic,
                dashStyle: 'dash',
                data: outsideTraffic,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1,
                yAxis: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //text: LanguageMonthlyTrend,
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.outsideTraffic,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    },
                    point: {
                        events: {
                            click: function () {
                                location.href = "Analytics?type=" + this.category.name + "&range=day&parameter=19&branchId=" + $("#selectBoxBranch").val() + "&compare=1";
                            }
                        }
                    },
                    cursor: 'pointer'
                }
            },
            yAxis: [{
                lineWidth: 0,
                min: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            {
                opposite: true,
                //linkedTo: 0,
                lineWidth: 0,
                min: 0,
                gridLineWidth: 1,
                tickWidth: 0,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                title: {
                    text: LanguageOutsideTraffic,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                }
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                title: {
                    text: LanguageMonth,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 6,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 18,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            },
        });
    });
}

//Outside Traffic Weekly Trend
function bindOutSideTrafficWeeklyTrend(data, colorScheme) {
    var tempWeek = [];
    for (var i = 1; i <= data.categories.length; i++) {
        tempWeek.push(i);
    }

    var footfall = data.series[0].ValueInInt; //footfall
    var outsideTraffic = data.series[0].OutsideTrafficInt; //outsideTraffic

    //identify largest value of yaxis data
    //var largestValue = 0;
    //for (var i = 0; i < footfall.count(); i++) {
    //    if (footfall.data[i] != null && footfall.data[i] != undefined && footfall.data[i] > largestValue)
    //        largestValue = footfall.data[i];
    //}

    //for (var i = 0; i < outsideTraffic.data.length; i++) {
    //    if (outsideTraffic.data[i] != null && outsideTraffic.data[i] != undefined && outsideTraffic.data[i] > largestValue)
    //        largestValue = salesvolume.data[i];
    //}

    //var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
    //                       : largestValue >= 10 && largestValue < 100 ? 10
    //                       : largestValue >= 100 && largestValue < 1000 ? 100
    //                       : largestValue >= 1000 && largestValue < 10000 ? 1000
    //                       : largestValue >= 10000 && largestValue < 100000 ? 10000
    //                       : largestValue >= 100000 && largestValue < 1000000 ? 100000
    //                       : 1000000;
    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "newOutsideTrafficWeeklyTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                }
            },
            series: [{
                type: 'column',
                name: LanguageNoofVisitor,
                data: footfall,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageOutsideTraffic,
                dashStyle: 'dash',
                data: outsideTraffic,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1,
                yAxis:1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //text: LanguageWeeklyTrend,
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.outsideTraffic,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    },
                    point: {
                        events: {
                            click: function () {
                                location.href = "Analytics?type=w" + this.category.name + "&range=day&parameter=19&branchId=" + $("#selectBoxBranch").val() + "&compare=1";
                            }
                        }
                    },
                    cursor: 'pointer'
                }
            },
            yAxis: [{
                lineWidth: 0,
                tickWidth: 1,
                min: 0,
                gridLineWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            {
                opposite: true,
                //linkedTo: 0,
                lineWidth: 0,
                tickWidth: 0,
                min: 0,
                gridLineWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageOutsideTraffic,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                title: {
                    text: LanguageWeek,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 206,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            },
        });
    });
}

//Outside Traffic Daily Trend
function bindOutsideTrafficDailyTrend(data, colorScheme) {
    var footfall = data.series[0].ValueInInt; //footfall
    var salesConversion = data.series[0].OutsideTrafficInt; //salesConversion

    //identify largest value of yaxis data
    //var largestValue = 0;
    //for (var i = 0; i < footfall.data.length; i++) {
    //    if (footfall.data[i] != null && footfall.data[i] != undefined && footfall.data[i] > largestValue)
    //        largestValue = footfall.data[i];
    //}

    //for (var i = 0; i < salesConversion.data.length; i++) {
    //    if (salesConversion.data[i] != null && salesConversion.data[i] != undefined && salesConversion.data[i] > largestValue)
    //        largestValue = salesConversion.data[i];
    //}

    //var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
    //                       : largestValue >= 10 && largestValue < 100 ? 10
    //                       : largestValue >= 100 && largestValue < 1000 ? 100
    //                       : largestValue >= 1000 && largestValue < 10000 ? 1000
    //                       : largestValue >= 10000 && largestValue < 100000 ? 10000
    //                       : largestValue >= 100000 && largestValue < 1000000 ? 100000
    //                       : 1000000;

    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "newOutsideTrafficDailyTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                }
            },
            series: [{
                type: 'column',
                name: LanguageNoofVisitor,
                data: footfall,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageOutsideTraffic,
                dashStyle: 'dash',
                data: salesConversion,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1,
                yAxis:1,
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //text: LanguageDailyTrend,
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.salesConversion,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    },
                    point: {
                        events: {
                            click: function () {
                                location.href = "Analytics?type=d" + this.category.name + "&range=hour&parameter=19&branchId=" + $("#selectBoxBranch").val() + "&compare=1";
                            }
                        }
                    },
                    cursor: 'pointer'
                }
            },
            yAxis: [{
                lineWidth: 0,
                min: 0,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                gridLineWidth: 1,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            {
                opposite: true,
                //linkedTo: 0,
                lineWidth: 0,
                tickWidth: 0,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                min: 0,
                gridLineWidth: 1,
                tickPosition: 'inside',
                title: {
                    text: LanguageOutsideTraffic,
                    margin: 25,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                tickInterval: 1,
                title: {
                    text: LanguageDay,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 206,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            },
        });
    });
}

//Visitor Profile
function bindBothVisitorProfile(data, colorScheme) {
    //Weekday
    var weekdayFootfall = data.series[0].ValueInInt;
    var weekdaySalesConversion = data.series[0].SalesConversion;
    var weekdayOutsideTraffic = data.series[0].OutsideTrafficInt;

    //Weekend
    var weekendFootfall = data.series[1].ValueInInt;
    var weekendSalesConversion = data.series[1].SalesConversion;
    var weekendOutsideTraffic = data.series[1].OutsideTrafficInt;

    //if (data.series[1].isDayOff) {
    //    var showmarker = false;
    //    var showtooltip = false;
    //}
    //else {
        var showmarker = true;
        var showtooltip = true;
    //}

    //Weekday SC
    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "weekdaysSCTrafficProfile",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'column',
                name: LanguageNoofVisitor,
                data: weekdayFootfall,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageSalesConversion + ' (%)',
                dashStyle: 'dash',
                data: weekdaySalesConversion,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1,
                yAxis: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
            },
            subtitle: {
                text: LanguageWeekdays,
                align: 'center',
                style: {
                    color: colorScheme.chart.subtitle.color,
                    fontSize: colorScheme.chart.subtitle.fontSize,
                    "font-family": colorScheme.chart.subtitle.fontFamily
                },
                margin: 0,
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false,
                        states: {
                            hover: {
                                enabled: true,
                            }
                        }
                    }
                }
            },
            yAxis: [{
                lineWidth: 0,
                min: 0,
                tickWidth: 1,
                tickPixelInterval: 15,
                gridLineWidth: 1,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            {
                opposite: true,
                //linkedTo: 0,
                lineWidth: 0,
                min: 0,
                gridLineWidth: 0,
                tickWidth: 0,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                labels: {
                    style: {

                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                title: {
                    text: LanguageSalesConversion + ' (%)',
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                enabled: false,
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
                enabled: true,
            },
        });
        });
    //Weekend SC
    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "weekendsSCTrafficProfile",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'column',
                name: LanguageNoofVisitor,
                data: weekendFootfall,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageSalesConversion + ' (%)',
                dashStyle: 'dash',
                data: weekendSalesConversion,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1,
                yAxis:1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
            },
            subtitle: {
                text: LanguageWeekends,
                align: 'center',
                style: {
                    color: colorScheme.chart.subtitle.color,
                    fontSize: colorScheme.chart.subtitle.fontSize,
                    "font-family": colorScheme.chart.subtitle.fontFamily
                },
                margin: 0,
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false,
                        states: {
                            hover: {
                                enabled: showmarker,
                            }
                        }
                    }
                }
            },
            yAxis: [{
                lineWidth: 0,
                min: 0,
                tickWidth: 1,
                tickPixelInterval: 15,
                gridLineWidth: 1,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            {
                opposite: true,
                //linkedTo: 0,
                lineWidth: 0,
                min: 0,
                gridLineWidth: 0,
                tickWidth: 0,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                labels: {
                    style: {

                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                title: {
                    text: LanguageSalesConversion + ' (%)',
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                enabled: false,
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
                enabled: showtooltip,
            },
        });
    });

    //Weekday OT
    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "weekdaysOutsideTrafficProfile",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'column',
                name: LanguageNoofVisitor,
                data: weekdayFootfall,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                    type: 'line',
                    name: LanguageOutsideTraffic,
                dashStyle: 'dash',
                data: weekdayOutsideTraffic,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1,
                yAxis: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
            },
            subtitle: {
                text: LanguageWeekdays,
                align: 'center',
                style: {
                    color: colorScheme.chart.subtitle.color,
                    fontSize: colorScheme.chart.subtitle.fontSize,
                    "font-family": colorScheme.chart.subtitle.fontFamily
                },
                margin: 0,
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false,
                        states: {
                            hover: {
                                enabled: true,
                            }
                        }
                    }
                }
            },
            yAxis: [{
                lineWidth: 0,
                min: 0,
                tickWidth: 1,
                tickPixelInterval: 15,
                gridLineWidth: 1,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            {
                opposite: true,
                //linkedTo: 0,
                lineWidth: 0,
                min: 0,
                gridLineWidth: 0,
                tickWidth: 0,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                labels: {
                    style: {

                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                title: {
                    text: LanguageOutsideTraffic,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                enabled: false,
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
                enabled: true,
            },
        });
    });
    //Weekend OT
    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "weekendsOutsideTrafficProfile",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'column',
                name: LanguageNoofVisitor,
                data: weekendFootfall,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                    type: 'line',
                    name: LanguageOutsideTraffic,
                dashStyle: 'dash',
                data: weekendOutsideTraffic,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1,
                yAxis:1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
            },
            subtitle: {
                text: LanguageWeekends,
                align: 'center',
                style: {
                    color: colorScheme.chart.subtitle.color,
                    fontSize: colorScheme.chart.subtitle.fontSize,
                    "font-family": colorScheme.chart.subtitle.fontFamily
                },
                margin: 0,
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false,
                        states: {
                            hover: {
                                enabled: showmarker,
                            }
                        }
                    }
                }
            },
            yAxis: [{
                lineWidth: 0,
                min: 0,
                tickWidth: 1,
                tickPixelInterval: 15,
                gridLineWidth: 1,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            {
                opposite: true,
                //linkedTo: 0,
                lineWidth: 0,
                min: 0,
                gridLineWidth: 0,
                tickWidth: 0,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                labels: {
                    style: {

                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                title: {
                    text: LanguageOutsideTraffic,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                enabled: false,
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
                enabled: showtooltip,
            },
        });
    });



}

function bindThisWeekTable(data, colorScheme) {

}
function newBindThisWeekInTable(data) {
    var weekNo = $('#weekpicker').val();
    weekNo = LanguageWeek + " " + weekNumber;

    //Content
    var footfall = data.series[0].ValueInInt;
    var turnInRate = data.series[0].TIR;
    var outsideTraffic = data.series[0].OutsideTrafficInt;
    var salesConversion = data.series[0].SalesConversion;
    var transactionCount = data.series[0].TransactionCountInt;
    var weekDay = data.series[0].dayOfTheWeek;

   

    //Sales Conversion
    $("#thisWeekSCTableHead").html("");
    $("#thisWeekSCTableContent").html("");
    $("#thisWeekSCTableFoot").html("");
    $("#thisWeekSCTableHead").append("<tr><th>" + weekNo + "</th><th>" + LanguageNoofVisitor + "</th><th>Transaction</th><th>" + LanguageConversion + "</th></tr>");

    //OutsideTraffic
    $("#thisWeekOTTableHead").html("");
    $("#thisWeekOTTableContent").html("");
    $("#thisWeekOTTableFoot").html("");
    $("#thisWeekOTTableHead").append("<tr><th>" + weekNo + "</th><th>" + LanguageOutsideTraffic + "</th><th>" + LanguageNoofVisitor + "</th><th>" + LanguageTurnInRate + "</th></tr>");


    for (var i = 0; i < 7; i++) {
        visitor = footfall[i] > 0 ? footfall[i] : "-";
        salesVolume = transactionCount[i] > 0 ? transactionCount[i]: "-";
        conversion = salesConversion[i] > 0 ? parseFloat(salesConversion[i]).toFixed(2)  + " %" : "-";
        day = weekDay[i] == undefined ? "-" : weekDay[i];

        $("#thisWeekSCTableContent").append("<tr><td>" + day + "</td><td>"
                + numberWithCommas(visitor) + "</td><td>" + numberWithCommas(salesVolume) + "</td><td>" + conversion + "</td></tr>");



        outside = outsideTraffic[i] > 0 ? outsideTraffic[i] : "-";
        tir = turnInRate[i] > 0 ? parseFloat(turnInRate[i]).toFixed(2) + " %" : "-";


        $("#thisWeekOTTableContent").append("<tr><td>" + day + "</td><td>" + numberWithCommas(outside) + "</td><td>" + numberWithCommas(visitor) + "</td><td>" + tir + "</td></tr>");

    }

  
    //Footer
    var totalTransac = data.series[0].transactionTotal;
    var totalConversion = data.series[0].ConversionTotal;
    var totalTIR = data.series[0].TurnInRateTotal;
    var totalOT = data.series[0].OutsideTrafficTotal;
    var totalfootfall = data.series[0].visitorTotal;
    $("#thisWeekSCTableFoot").append("<tr><td>" + LanguageTotal + "</td><td>" + numberWithCommas(totalfootfall) + "</td><td>" + numberWithCommas(totalTransac) + "</td><td>" + parseFloat(totalConversion).toFixed(2) + " %</td></tr>");
    $("#thisWeekOTTableFoot").append("<tr><td>" + LanguageTotal + "</td><td>" + numberWithCommas(totalOT) + "</td><td>" + numberWithCommas(totalfootfall) + "</td><td>" + parseFloat(totalTIR).toFixed(2) + " %</td></tr>");



}

function numberWithCommas(x) {
    var parts = x.toString().split(".");
    parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    return parts.join(".");
}
// end of Wilson

function emptyAll() {

    $("#thisWeekSalesConversion").empty();
    $("#thisWeekGraph").empty();
    $("#lastWeekSalesConversion").empty();
    $("#lastWeekGraph").empty();
    $("#changesInTwoWeeksSC").empty();
    $("#bestPerformDay").empty();
    $("#totalBestPerformSC").empty();
    $("#thisWeekOutsideTraffic").empty();
    $("#outsideTrafficUpDownPercent").empty();
    $("#outsideTrafficGraph").empty();
    $("#thisWeekTurnInRate").empty();
    $("#turnInRateUpDownPercent").empty();
    $("#turnInRateGraph").empty();
    $("#thisWeekVisitorCount").empty();
    $("#visitorCountUpDownPercent").empty();
    $("#visitorCountGraph").empty();
    $("#leagueStatisticThisStore").empty();
    $("#leagueStatisticCompany").empty();
    $("#newMonthlyTrend").empty();
    $("#lastTwoWeeksSCTable").empty();
    $("#thisWeekSCTableHead").empty();
    $("#thisWeekSCTableContent").empty();
    $("#thisWeekSCTableFoot").empty();
    $("#newWeeklyTrend").empty();
    $("#newDailyTrend").empty();
    $("#weekdaysSCTrafficProfile").empty();
    $("#weekendsSCTrafficProfile").empty();
    $("#newOutsideTrafficMonthlyTrend").empty();
    $("#lastTwoWeeksSCTable").empty();
    $("#thisWeekOTTableHead").empty();
    $("#thisWeekOTTableContent").empty();

    $("#thisWeekOTTableFoot").empty();
    $("#newOutsideTrafficWeeklyTrend").empty();
    $("#newOutsideTrafficDailyTrend").empty();
    $("#weekdaysOutsideTrafficProfile").empty();
    $("#weekendsOutsideTrafficProfile").empty();


}