﻿var emojiRegex = /(?:[\u2700-\u27bf]|(?:\ud83c[\udde6-\uddff]){2}|[\ud800-\udbff][\udc00-\udfff]|[\u0023-\u0039]\ufe0f?\u20e3|\u3299|\u3297|\u303d|\u3030|\u24c2|\ud83c[\udd70-\udd71]|\ud83c[\udd7e-\udd7f]|\ud83c\udd8e|\ud83c[\udd91-\udd9a]|\ud83c[\udde6-\uddff]|[\ud83c\ude01-\ude02]|\ud83c\ude1a|\ud83c\ude2f|[\ud83c\ude32-\ude3a]|[\ud83c\ude50-\ude51]|\u203c|\u2049|[\u25aa-\u25ab]|\u25b6|\u25c0|[\u25fb-\u25fe]|\u00a9|\u00ae|\u2122|\u2139|\ud83c\udc04|[\u2600-\u26FF]|\u2b05|\u2b06|\u2b07|\u2b1b|\u2b1c|\u2b50|\u2b55|\u231a|\u231b|\u2328|\u23cf|[\u23e9-\u23f3]|[\u23f8-\u23fa]|\ud83c\udccf|\u2934|\u2935|[\u2190-\u21ff])/g;
var specialCharRegex = /[ `~!@#$%^&*()_+\-=\[\]{};':"\\|,.<>\/?~·！@#￥%……&*（）——【】、：；“”‘’《》，。？/]/;

$(document).ready(function () {
	ShowLoadingPrompt("Getting data");
	setupToggleButton();
	getHotspotSettingByCompanyID();

	// Network addresses range limit (0 - 255)
	$('.network-address-input').focusout(function () {
		if (!this.value == "" && $.isNumeric(this.value)) {
			var value = this.value;
			if (value > 255)
				this.value = 255;
			else if (value < 0)
				this.value = 0;
			else
				this.value = parseInt(value);

		} else {
			this.value = 0;
		}
	});

	// Port range limit (1 - 65535)
	$('.ip-port-input').focusout(function () {
		if (!this.value == "" && $.isNumeric(this.value)) {
			var value = this.value;
			if (value > 65535)
				this.value = 65535;
			else if (value < 1)
				this.value = 1;
			else
				this.value = parseInt(value);
		} else {
			this.value = 1;
		}
	});

	// Subnet range limit (8 - 30)
	$('.network-subnet-input').focusout(function () {
		if (!this.value == "" && $.isNumeric(this.value)) {
			var value = this.value;
			if (value > 30)
				this.value = 30;
			else if (value < 8)
				this.value = 8;
			else
				this.value = parseInt(value);

		} else {
			this.value = 24;
		}
	});

	// Validate password input
	$(".password-input-validate").on("keypress", function (evt) {
		var charCode = (evt.which) ? evt.which : event.keyCode;
		if (this.value.length < 32) {
			if (charCode > 31 && (charCode < 48 || (charCode > 57 && charCode < 65) || (charCode > 90 && charCode < 97) || charCode > 122)) {
				if (charCode == 46 && this.value.length > 0)
					$(this).nextAll(".network-address-input").first().select();
				return false;
			}
			return true;
		} else {
			return false;
		}
	});

	// Validate Wifi SSID input
	$("#wifiSSID").on("keypress", function (evt) {
		var charCode = (evt.which) ? evt.which : event.keyCode;
		if (charCode > 31 && (charCode < 48 || (charCode > 57 && charCode < 65) || (charCode > 90 && charCode < 97) || charCode > 122)) {
			if (charCode == 46 && this.value.length > 0)
				$(this).nextAll(".network-address-input").first().select();
			return false;
		}
		return true;
	});

	// Validate ip address input
	$('.network-address-input, .ip-port-input, .network-subnet-input').on('keypress', function (evt) {
		var charCode = (evt.which) ? evt.which : event.keyCode;
		if (charCode > 31 && (charCode < 48 || charCode > 57)) {
			if (charCode == 46 && this.value.length > 0)
				$(this).nextAll(".network-address-input").first().select();
			return false;
		}
		return true;
	});

	// If each ip field reaches maximum length, go to next field.
	$('.network-address-input').on('keyup', function (evt) {
		var key = evt.which;
		if (this.value.length == 3 && ((key >= 96 && key <= 105) || (key >= 48 && key <= 57)))
			$(this).nextAll(".network-address-input").first().select();
	});

	// Let Server IP 2 have same last byte of adress as Server IP 1
	$("#CRadius_4").on("focusout", function () {
		$("#CRadius2_4").val($("#CRadius_4").val());
	});

	// When toggle MAC Authentication
	$("#CMacAuth").on("change", function () {
		$("#CMacPassword-change-btn").show();
		$("#CMacPassword-cancel-btn").hide();
		$("#CMacPassword_Confirm-div").hide();
		$("#CMacPassword_Temp").show();
		$("#CMacPassword").hide();
		$("#MacPassword-section").slideToggle();
		$("#CMacPassword").val("");
		$("#CMacPassword_Confirm").val("");
	});

	// When click Change Password for Server Password
	$("#FRSecret-change-btn").on("click", function () {
		$("#FRSecret-change-btn").toggle();
		$("#FRSecret-cancel-btn").toggle();
		$("#FRSecret").toggle();
		$("#FRSecret_Temp").toggle();
		$("#FRSecret_Confirm-div").slideToggle();
		$("#FRSecret").focus();
	});

	// When click Cancel for Server Password
	$("#FRSecret-cancel-btn").on("click", function () {
		$("#FRSecret-change-btn").toggle();
		$("#FRSecret-cancel-btn").toggle();
		$("#FRSecret").toggle();
		$("#FRSecret_Temp").toggle();
		$("#FRSecret").val("");
		$("#FRSecret_Confirm").val("");
		$("#FRSecret_Confirm-div").slideToggle();
	});

	// When click Change Password for MAC Password
	$("#CMacPassword-change-btn").on("click", function () {
		$("#CMacPassword-change-btn").toggle();
		$("#CMacPassword-cancel-btn").toggle();
		$("#CMacPassword").toggle();
		$("#CMacPassword_Temp").toggle();
		$("#CMacPassword_Confirm-div").slideToggle();
		$("#CMacPassword").focus();
	});

	// When click Cancel for MAC Password
	$("#CMacPassword-cancel-btn").on("click", function () {
		$("#CMacPassword-change-btn").toggle();
		$("#CMacPassword-cancel-btn").toggle();
		$("#CMacPassword").toggle();
		$("#CMacPassword_Temp").toggle();
		$("#CMacPassword").val("");
		$("#CMacPassword_Confirm").val("");
		$("#CMacPassword_Confirm-div").slideToggle();
	});

	// Display modal when click Save Changes Button
	$("#save-changes-btn").on("click", function () {
		$('#confirmationModal').modal({
			show: true,
			keyboard: false,
			backdrop: 'static'
		});
	});

	// When confirm save changes
	$("#btnconfirmationModalSend").on("click", function () {
		ShowLoadingPrompt("Saving changes");

		// Show error when input incorrect or password does not match
		if (checkForEmptyInput() || checkForInvalidInput() || checkWifiSSIDForInvalidInput()) {
			HideLoadingPrompt();
			ShowModal(LanguageInvalidInput, LanguageMakeSureAllInputAreEnteredCorrectly);
		} else {
			if ($("#FRSecret").val() === $("#FRSecret_Confirm").val()) {
				$("#FRSecret").removeClass("input-error");
				$("#FRSecret_Confirm").removeClass("input-error");
				if ($("#CMacPassword").val() === $("#CMacPassword_Confirm").val()) {
					$("#CMacPassword").removeClass("input-error");
					$("#CMacPassword_Confirm").removeClass("input-error");

					var TnC = JSON.stringify({
						options: {
							terms: {
								active: true,
								message: encodeURI($("#CPTnC_Message").val()),
								link: encodeURI($("#CPTnC_LinkMessage").val()),
								error: encodeURI($("#CPTnC_ErrorMessage").val()),
								terms: encodeURI($("#CPTnC_Terms").val().replace(/\n/g, '<br>'))
							},
							userAuthentication: {
								active: true,
								type: "user"
							}
						},
						chilliController: {
							host: $("#CUAMListen_1").val() + "." + $("#CUAMListen_2").val() + "." + $("#CUAMListen_3").val() + "." + $("#CUAMListen_4").val(),
							port: parseInt($("#CUAMUIPort").val()),
							interval: 60
						}
					});

					var saveData = {
						CompanyId: companyID,
						WifiSSID: encodeURI($("#wifiSSID").val()),
						WifiChannel: parseInt($("#wifiChannel").val()),
						FRSecret: $("#FRSecret").val(),
						CPTnC: TnC,
						CNetwork: $("#CNetwork_1").val() + "." + $("#CNetwork_2").val() + "." + $("#CNetwork_3").val() + "." + $("#CNetwork_4").val(),
						CNetMask: $("#CNetMask_1").val() + "." + $("#CNetMask_2").val() + "." + $("#CNetMask_3").val() + "." + $("#CNetMask_4").val(),
						CUAMListen: $("#CUAMListen_1").val() + "." + $("#CUAMListen_2").val() + "." + $("#CUAMListen_3").val() + "." + $("#CUAMListen_4").val(),
						CUAMPort: parseInt($("#CUAMPort").val()),
						CUAMUIPort: parseInt($("#CUAMUIPort").val()),
						CCOAPort: parseInt($("#CCOAPort").val()),
						CDNS1: $("#CDNS1_1").val() + "." + $("#CDNS1_2").val() + "." + $("#CDNS1_3").val() + "." + $("#CDNS1_4").val(),
						CDNS2: $("#CDNS2_1").val() + "." + $("#CDNS2_2").val() + "." + $("#CDNS2_3").val() + "." + $("#CDNS2_4").val(),
						CRadius: $("#CRadius_1").val() + "." + $("#CRadius_2").val() + "." + $("#CRadius_3").val() + "." + $("#CRadius_4").val(),
						CRadius2: $("#CRadius2_1").val() + "." + $("#CRadius2_2").val() + "." + $("#CRadius2_3").val() + "." + $("#CRadius2_4").val(),
						CUAMAllow: $("#CUAMAllow_1").val() + "." + $("#CUAMAllow_2").val() + "." + $("#CUAMAllow_3").val() + "." + $("#CUAMAllow_4").val() + "/" + $("#CUAMAllow_5").val(),
						CUAMDomains: encodeURI(processCUAMDomains($("#CUAMDomains").val())),
						CMACAuth: $("#CMacAuth").is(":checked") ? true : false,
						CMACPassword: $("#CMacPassword").val()
					};
					//console.log(saveData.CPTnC);
					var saveDataString = JSON.stringify(saveData);

					//console.log(saveData.CUAMDomains);

					$.ajax({
						type: "POST",
						url: "/HotspotView/updateHotspotSetting",
						data: {
							'saveDataString': saveDataString
						},
						success: function (resultString) {
							//var result = JSON.parse(resultString);

							//console.log(result);
							HideLoadingPrompt();

							$('#updateSuccessModal').modal({
								show: true,
								keyboard: false,
								backdrop: 'static',
							});
						},
						fail: function () {
							console.log("fail");
						}
					});
				} else {
					HideLoadingPrompt();
					ShowModal(LanguagePasswordDoesNotMatch, LanguageMACPasswordDoesNotMatchTheConfirmPassword);
					$("#CMacPassword").addClass("input-error");
					$("#CMacPassword_Confirm").addClass("input-error");
					$("#CMacPassword").removeClass("input-correct");
					$("#CMacPassword_Confirm").removeClass("input-correct");
					$("#CMacPassword").val("");
					$("#CMacPassword_Confirm").val("");
				}
			} else {
				HideLoadingPrompt();
				ShowModal(LanguagePasswordDoesNotMatch, LanguageServerPasswordDoesNotMatchTheConfirmPassword);
				$("#FRSecret").addClass("input-error");
				$("#FRSecret_Confirm").addClass("input-error");
				$("#FRSecret").removeClass("input-correct");
				$("#FRSecret_Confirm").removeClass("input-correct");
				$("#FRSecret").val("");
				$("#FRSecret_Confirm").val("");
			}
		}
	});

	// Upload Background Image
	$("#CPBackgroundIMG").change(function () {
		ShowLoadingPrompt("Uploading Image");
		var file = this.files[0];
		var name = file.name;
		var size = file.size;
		var type = file.type;
		var u = URL.createObjectURL(this.files[0]);
		var img = new Image;

		if (type != "image/jpg" && type != "image/jpeg") {
			HideLoadingPrompt();
			ShowModal(LanguageReminder, LanguagePleaseSelectOnlyJPGImage);
		} else {
			img.onload = function () {
				if (img.width != 800 && img.height != 960) {
					HideLoadingPrompt();
					ShowModal(LanguageReminder, LanguagePleaseUploadAJPGFileWithWidthAndHeight);
				} else {
					var formData = new FormData($('#uploadBackgroundForm')[0]);

					$.ajax({
						url: "/HotspotView/UploadBackgroundIMG",
						type: "POST",
						data: formData,
						processData: false,
						contentType: false,
						cache: false,
						success: function (data, textStatus, jqXHR) {
							HideLoadingPrompt();
							ShowModal(LanguageSuccess, LanguageBackgroundImageUplaoded);
							$("#uploadedBackgroundIMG").attr("src", data.Data + "?" + new Date().getTime());
						}
					});
				}
			};
		}

		img.src = u;
	});

	// Upload Logo
	$("#CPIcon").change(function () {
		ShowLoadingPrompt("Uploading Image");
		var file = this.files[0];
		var name = file.name;
		var size = file.size;
		var type = file.type;
		var u = URL.createObjectURL(this.files[0]);
		var img = new Image;

		if (type != "image/png") {
			HideLoadingPrompt();
			ShowModal(LanguageReminder, LanguagePleaseSelectOnlyPNGImage + ".");;
		} else {
			img.onload = function () {
				if (img.width != 300 && img.height != 150) {
					HideLoadingPrompt();
					ShowModal(LanguageReminder, LanguagePleaseUploadAPNGFileWithWidthAndHeight);
				}
				else {
					var formData = new FormData($('#uploadLogoForm')[0]);

					$.ajax({
						url: "/HotspotView/UploadLogo",
						type: "POST",
						data: formData,
						processData: false,
						contentType: false,
						cache: false,
						success: function (data, textStatus, jqXHR) {
							HideLoadingPrompt();
							ShowModal(LanguageSuccess, LanguageLogoUploaded);
							$("#uploadedLogo").attr("src", data.Data + "?" + new Date().getTime());
						}
					});
				}
			};
		}

		img.src = u;
	});

	$('#updateSuccessModal').on('hidden.bs.modal', function () {
		location.reload();
	});

	$("#FRSecret_Confirm, #FRSecret").on("keyup", function () {
		if ($('#FRSecret_Confirm').val() === $('#FRSecret').val()) {
			$('#FRSecret_Confirm').addClass('input-correct');
			$('#FRSecret').addClass('input-correct');
			$('#FRSecret_Confirm').removeClass('input-error');
			$('#FRSecret').removeClass('input-error');
		} else {
			$('#FRSecret_Confirm').removeClass('input-correct');
			$('#FRSecret').removeClass('input-correct');
			$('#FRSecret_Confirm').addClass('input-error');
			$('#FRSecret').addClass('input-error');
		}
	});

	$("#CMacPassword_Confirm, #CMacPassword").on("keyup", function () {
		if ($('#CMacPassword_Confirm').val() === $('#CMacPassword').val()) {
			$('#CMacPassword_Confirm').addClass('input-correct');
			$('#CMacPassword').addClass('input-correct');
			$('#CMacPassword_Confirm').removeClass('input-error');
			$('#CMacPassword').removeClass('input-error');
		} else {
			$('#CMacPassword_Confirm').removeClass('input-correct');
			$('#CMacPassword').removeClass('input-correct');
			$('#CMacPassword_Confirm').addClass('input-error');
			$('#CMacPassword').addClass('input-error');
		}
	});

	$("#wifiSSID").on("keyup", function () {
		var wifiSSID = $("#wifiSSID").val();

		var wifiSSIDWithoutEmoji = wifiSSID.replace(emojiRegex, "");

		if ($.trim(wifiSSIDWithoutEmoji).length > 0 && specialCharRegex.test(wifiSSIDWithoutEmoji) != true) {
			$('#wifiSSID').addClass('input-correct');
			$('#wifiSSID').removeClass('input-error');
		} else {
			$('#wifiSSID').removeClass('input-correct');
			$('#wifiSSID').addClass('input-error');
		}
	});

	$(".TnC-input").on("keyup", function () {
		if ($.trim(this.value).length > 0) {
			$(this).addClass('input-correct');
			$(this).removeClass('input-error');
		} else {
			$(this).removeClass('input-correct');
			$(this).addClass('input-error');
		}
	});
});

// Setup Toggle Button
function setupToggleButton() {
	var toggleButton = document.querySelectorAll('.toggleButton');
	toggleButton.forEach(function (html) {
		var switchery = new Switchery(html, { size: 'small' });
	});
}

// Use Company ID to get Hotspot Settings and load the data
function getHotspotSettingByCompanyID() {
	$.ajax({
		type: "POST",
		url: "/HotspotView/getHotspotSettingByCompanyID",
		data: {
			'companyID': companyID
		},
		success: function (hotspotSetting) {
			// Setup Hotspot Settings Section
			$('#wifiSSID').val(decodeURI(hotspotSetting.WifiSSID));
			$('#wifiChannel').val(hotspotSetting.WifiChannel);
			$('#uploadedBackgroundIMG').attr('src', hotspotSetting.CPbackgroundIMG);
			$('#uploadedLogo').attr('src', hotspotSetting.CPIcon);

			// Setup Terms & Conditions Section
			var CPTnCJSON = JSON.parse(hotspotSetting.CPTnC);

			$('#CPTnC_Message').val(decodeURI(CPTnCJSON.options.terms.message));
			$('#CPTnC_LinkMessage').val(decodeURI(CPTnCJSON.options.terms.link));
			$('#CPTnC_ErrorMessage').val(decodeURI(CPTnCJSON.options.terms.error));
			$('#CPTnC_Terms').html(decodeURI((CPTnCJSON.options.terms.terms)).replace(/<br>/gi, "\n"));

			// Setup Advance Settings Section
			var CNetworkSplit = hotspotSetting.CNetwork.split('.');
			for (var i = 0; i < CNetworkSplit.length; i++) {
				$('#CNetwork_' + (i + 1)).val(CNetworkSplit[i]);
			}

			var CNetMaskSplit = hotspotSetting.CNetMask.split('.');
			for (var i = 0; i < CNetMaskSplit.length; i++) {
				$('#CNetMask_' + (i + 1)).val(CNetMaskSplit[i]);
			}

			var CUAMListenSplit = hotspotSetting.CUAMListen.split('.');
			for (var i = 0; i < CUAMListenSplit.length; i++) {
				$('#CUAMListen_' + (i + 1)).val(CUAMListenSplit[i]);
			}

			$('#CUAMListen').val(hotspotSetting.CUAMListen);
			$('#CUAMPort').val(hotspotSetting.CUAMPort);
			$('#CUAMUIPort').val(hotspotSetting.CUAMUIPort);
			$('#CCOAPort').val(hotspotSetting.CCOAPort);

			var CDNS1Split = hotspotSetting.CDNS1.split('.');
			for (var i = 0; i < CDNS1Split.length; i++) {
				$('#CDNS1_' + (i + 1)).val(CDNS1Split[i]);
			}

			var CDNS2Split = hotspotSetting.CDNS2.split('.');
			for (var i = 0; i < CDNS2Split.length; i++) {
				$('#CDNS2_' + (i + 1)).val(CDNS2Split[i]);
			}

			var CRadiusSplit = hotspotSetting.CRadius.split('.');
			for (var i = 0; i < CRadiusSplit.length; i++) {
				$('#CRadius_' + (i + 1)).val(CRadiusSplit[i]);
			}

			var CRadius2Split = hotspotSetting.CRadius2.split('.');
			for (var i = 0; i < CRadius2Split.length; i++) {
				$('#CRadius2_' + (i + 1)).val(CRadius2Split[i]);
			}

			var CUAMAllowFirstSplit = hotspotSetting.CUAMAllow.split('/');
			var CUAMAllowSecondSplit = CUAMAllowFirstSplit[0].split('.');
			$('#CUAMAllow_5').val(CUAMAllowFirstSplit[1]);
			for (var i = 0; i < CUAMAllowSecondSplit.length; i++) {
				$('#CUAMAllow_' + (i + 1)).val(CUAMAllowSecondSplit[i]);
			}

			if (hotspotSetting.CMACAuth) {
				$("#CMacAuth").click();
			}

			$('#CUAMDomains').val(decodeURI(hotspotSetting.CUAMDomains).replace(/,|，/g,',\n'));

			HideLoadingPrompt();
		},
		error: function () {
			console.log("Fail");
		},
	});
}

// Check for text input that is empty
function checkForEmptyInput() {
	var containEmpty = false;

	$(".input-not-null").each(function () {
		if ($.trim(this.value).length === 0) {
			$(this).addClass("input-error");
			containEmpty = true;
		} else {
			$(this).removeClass("input-error");
		}
	});

	return containEmpty;
}

// Check for text input that contain special characters
function checkForInvalidInput() {
	var containInvalid = false;

	$(".password-input-validate").each(function () {
		console.log(this.length);
		if (specialCharRegex.test(this.value) == true) {
			$(this).addClass("input-error");
			$(this).removeClass("input-correct");
			containInvalid = true;
		} else {
			$(this).removeClass("input-error");
		}
	});

	return containInvalid;
}

// Check Wifi SSID for special character (Accept Emoji)
function checkWifiSSIDForInvalidInput() {
	var containInvalid = false;

	var wifiSSID = $("#wifiSSID").val();

	var wifiSSIDWithoutEmoji = wifiSSID.replace(emojiRegex, "");

	if (specialCharRegex.test(wifiSSIDWithoutEmoji) == true) {
		$('#wifiSSID').addClass("input-error");
		containInvalid = true;
	} else {
		$('#wifiSSID').removeClass("input-error");
	}

	return containInvalid;
}

// Trigger upload background image
function uploadBackground() {
	$("#CPBackgroundIMG").click();
}

// Trigger upload logo
function uploadLogo() {
	$("#CPIcon").click();
}

// Display Uploaded Image after choose image
function displaybackgroundIMG(input) {
	if (input.files && input.files[0]) {
		var reader = new FileReader();
		$("#uploadedBackgroundIMG").show();
		reader.onload = function (e) {
			$('#uploadedBackgroundIMG')
				.attr('src', e.target.result)
				.width(80)
				.height(96);
		};

		reader.readAsDataURL(input.files[0]);
	}
}

// Display Uploaded Image after choose image
function displayLogo(input) {
	if (input.files && input.files[0]) {
		var reader = new FileReader();
		$("#uploadedLogo").show();
		reader.onload = function (e) {
			$('#uploadedLogo')
				.attr('src', e.target.result)
				.width(150)
				.height(75);
		};

		reader.readAsDataURL(input.files[0]);
	}
}

function processCUAMDomains(unprocess) {
	var removedSpace = ($.trim(unprocess)).replace(/\n/g, '').replace(/\s/g, '');

	var splitted = removedSpace.split(/,|，/);

	var joinFilteredArray = splitted.filter(function (x) { return (x != (undefined || null || '')); }).join();

	return joinFilteredArray;
}