/**
 * sourceWidth and sourceHeight is dpi
 * dpi to px will be double
 * 100dpi = 200px
**/

//function to call graph for analytic page


function callZoneAnalytic(data) {
    $(function () {
        
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "dayreport",
                type: 'bubble',
                plotBorderWidth: 0,
                events: {
                    load: function () {
                        $("#container").removeClass("chartLoading");
                    }
                },
                plotBackgroundImage: data.background
            },
            title: {
                text: ''
            },
            credits: {
                enabled: false
            },
            xAxis: {
                startOnTick: false,
                endOnTick: false,
                gridLineWidth: 0,
                min: 0,
                max: 100,
                labels: { enabled: false },
                minorTickLength: 0,
                tickLength: 0
            },

            yAxis: {
                startOnTick: false,
                endOnTick: false,
                gridLineWidth: 0,
                min: 0,
                lineWidth: 0,
                minorGridLineWidth: 0,
                lineColor: 'transparent',
                max: 100,
                labels: { enabled: false }
            },
            tooltip: {
                shared: true,
                useHTML: true,
                headerFormat:'',
                pointFormat: '{point.Name}:<br /> ' + LanguageFootfall + ':<b>{point.ValueIn:.0f}</b><br /> ' + LanguageOutsideTraffic + ':<b>{point.OutsideTraffic}</b><br/>'
            },
            plotOptions: {
                bubble: {
                    minSize: 0,
                    maxSize: data.ratio,
                    zMin: 0,
                    zMax: data.ratio
                }
            },
            legend:{enabled:false},
            series: [{
                data: data.series[0].data
            }],
            exporting: {
                enabled: false,
            }
        });
    })
}


//function for visitor count by day
function callVisitorCountByDay(ShowOutValue, data, ID) {

    if (ShowOutValue) {
        $(function () {
            var chart = new Highcharts.Chart({
                chart: {
                    renderTo: "dayreport" + ID,
                    events: {
                        load: function () {
                            //chartEvent[3] = this;
                        }
                    }
                },
                series: [{
                    type: 'column',
                    name: data.series[0].name,
                    data: data.series[0].data,
                    color: '#97c5e9'

                }, {
                    type: 'column',
                    name: data.series[1].name,
                    data: data.series[1].data,
                    color: '#f49423'

                }],
                credits: {
                    enabled: false
                },
                title: {
                    text: ' ',
                    align: 'left',
                    style: {
                        "font-family": "Franklin Gothic Medium",
                        textDecoration: 'underline',
                        color: '#494b4b',
                        fontSize: '15px'
                    }
                },
                plotOptions: {
                    column: {
                        //stacking: 'normal',
                        pointPadding: 0,
                        borderWidth: 0
                    }
                },
                yAxis: [{
                    min: 0,
                    lineWidth: 1,
                    gridLineWidth: 0,
                    tickWidth: 1,
                    //tickInterval: 1000,
                    tickPixelInterval: 1000,
                    tickLength: 5,
                    tickPosition: 'inside',
                    title: {
                        text: data.series[0].name,
                        style: {
                            fontSize: '11px',
                            "font-family": "Arial",
                            color: '#474b4b'
                        }
                    },
                    labels: {
                        style: {
                            fontSize: '10px',
                            "font-family": "Arial"
                        }
                    }
                }],
                xAxis: {
                    categories: data.categories,
                    tickWidth: 0,
                    title: {
                        text: LanguageDay,
                        align: 'high',
                        y: -20,
                        style: {
                            fontSize: '12px',
                            "font-family": "Arial"
                        }
                    },
                    labels: {
                        rotation: -90,
                        x: 3,
                        style: {
                            fontSize: '10px',
                            "font-family": "Arial"
                        }
                    }
                },
                legend: {
                    itemStyle: {
                        font: '8pt Arial'
                    },
                    enabled: true,
                    borderWidth: 1,
                    borderColor: '#474b4b',
                    x: 300,
                    y: 15,
                    verticalAlign: 'top',
                },
                exporting: {
                    enabled: false,
                },
                tooltip: {
                    shared: true,
                },
            });
        })
    } else {
        $(function () {
            var chart = new Highcharts.Chart({
                chart: {
                    renderTo: "dayreport" + ID,
                    events: {
                        load: function () {
                            //chartEvent[3] = this;
                        }
                    }
                },
                series: [{
                    type: 'column',
                    name: data.series[0].name,
                    data: data.series[0].data,
                    color: '#97c5e9'
                }],
                credits: {
                    enabled: false
                },
                title: {
                    text: ' ',
                    align: 'left',
                    style: {
                        "font-family": "Franklin Gothic Medium",
                        textDecoration: 'underline',
                        color: '#494b4b',
                        fontSize: '15px'
                    }
                },
                plotOptions: {
                    column: {
                        //stacking: 'normal',
                        pointPadding: 0,
                        borderWidth: 0
                    }
                },
                yAxis: [{
                    min: 0,
                    lineWidth: 1,
                    gridLineWidth: 0,
                    tickWidth: 1,
                    //tickInterval: 1000,
                    tickPixelInterval: 1000,
                    tickLength: 5,
                    tickPosition: 'inside',
                    title: {
                        text: data.series[0].name,
                        style: {
                            fontSize: '11px',
                            "font-family": "Arial",
                            color: '#474b4b'
                        }
                    },
                    labels: {
                        style: {
                            fontSize: '10px',
                            "font-family": "Arial"
                        }
                    }
                },
                {
                    lineWidth: 1,
                    gridLineWidth: 0,
                    tickWidth: 1,
                    opposite: true,
                    //tickInterval: 1000,
                    tickPixelInterval: 1000,
                    tickLength: 5,
                    tickPosition: 'inside',
                    title: {
                        text: data.series[0].name,
                        style: {
                            fontSize: '11px',
                            "font-family": "Arial",
                            color: '#474b4b'
                        }
                    },
                    labels: {
                        style: {
                            fontSize: '10px',
                            "font-family": "Arial"
                        }
                    }
                }],
                xAxis: {
                    categories: data.categories,
                    tickWidth: 0,
                    title: {
                        text: LanguageDay,
                        align: 'high',
                        y: -20,
                        style: {
                            fontSize: '12px',
                            "font-family": "Arial"
                        }
                    },
                    labels: {
                        rotation: -90,
                        x: 3,
                        style: {
                            fontSize: '10px',
                            "font-family": "Arial"
                        }
                    }
                },
                legend: {
                    itemStyle: {
                        font: '8pt Arial'
                    },
                    enabled: true,
                    borderWidth: 1,
                    borderColor: '#474b4b',
                    x: 280,
                    y: 15,
                    verticalAlign: 'top',
                },
                exporting: {
                    enabled: false,
                },
                tooltip: {
                    shared: true,
                },
            });
        })
    }
}


function callVisitorCountByDayLine(ShowOutValue, data, ID) {

    if (ShowOutValue) {
        $(function () {
            var chart = new Highcharts.Chart({
                chart: {
                    renderTo: "dayreport" + ID,
                    events: {
                        load: function () {
                            //chartEvent[3] = this;
                        }
                    }
                },
                series: [{
                    type: 'line',
                    name: data.series[0].name,
                    data: data.series[0].data,
                    color: '#97c5e9'

                }, {
                    type: 'line',
                    name: data.series[1].name,
                    data: data.series[1].data,
                    color: '#f49423'

                }],
                credits: {
                    enabled: false
                },
                title: {
                    text: ' ',
                    align: 'left',
                    style: {
                        "font-family": "Franklin Gothic Medium",
                        textDecoration: 'underline',
                        color: '#494b4b',
                        fontSize: '15px'
                    }
                },
                plotOptions: {
                    column: {
                        //stacking: 'normal',
                        pointPadding: 0,
                        borderWidth: 0
                    }
                },
                yAxis: [{
                    min: 0,
                    lineWidth: 1,
                    gridLineWidth: 0,
                    tickWidth: 1,
                    //tickInterval: 1000,
                    tickPixelInterval: 1000,
                    tickLength: 5,
                    tickPosition: 'inside',
                    title: {
                        text: data.series[0].name,
                        style: {
                            fontSize: '11px',
                            "font-family": "Arial",
                            color: '#474b4b'
                        }
                    },
                    labels: {
                        style: {
                            fontSize: '10px',
                            "font-family": "Arial"
                        }
                    }
                }],
                xAxis: {
                    categories: data.categories,
                    tickWidth: 0,
                    title: {
                        text: LanguageDay,
                        align: 'high',
                        y: -20,
                        style: {
                            fontSize: '12px',
                            "font-family": "Arial"
                        }
                    },
                    labels: {
                        rotation: -90,
                        x: 3,
                        style: {
                            fontSize: '10px',
                            "font-family": "Arial"
                        }
                    }
                },
                legend: {
                    itemStyle: {
                        font: '8pt Arial'
                    },
                    enabled: true,
                    borderWidth: 1,
                    borderColor: '#474b4b',
                    x: 300,
                    y: 15,
                    verticalAlign: 'top',
                },
                exporting: {
                    enabled: false,
                },
                tooltip: {
                    shared: true,
                },
            });
        })
    } else {
        $(function () {
            var chart = new Highcharts.Chart({
                chart: {
                    renderTo: "dayreport" + ID,
                    events: {
                        load: function () {
                            //chartEvent[3] = this;
                        }
                    }
                },
                series: [{
                    type: 'line',
                    name: data.series[0].name,
                    data: data.series[0].data,
                    color: '#97c5e9'
                }],
                credits: {
                    enabled: false
                },
                title: {
                    text: ' ',
                    align: 'left',
                    style: {
                        "font-family": "Franklin Gothic Medium",
                        textDecoration: 'underline',
                        color: '#494b4b',
                        fontSize: '15px'
                    }
                },
                plotOptions: {
                    column: {
                        //stacking: 'normal',
                        pointPadding: 0,
                        borderWidth: 0
                    }
                },
                yAxis: [{
                    min: 0,
                    lineWidth: 1,
                    gridLineWidth: 0,
                    tickWidth: 1,
                    //tickInterval: 1000,
                    tickPixelInterval: 1000,
                    tickLength: 5,
                    tickPosition: 'inside',
                    title: {
                        text: data.series[0].name,
                        style: {
                            fontSize: '11px',
                            "font-family": "Arial",
                            color: '#474b4b'
                        }
                    },
                    labels: {
                        style: {
                            fontSize: '10px',
                            "font-family": "Arial"
                        }
                    }
                },
                {
                    lineWidth: 1,
                    gridLineWidth: 0,
                    tickWidth: 1,
                    opposite: true,
                    //tickInterval: 1000,
                    tickPixelInterval: 1000,
                    tickLength: 5,
                    tickPosition: 'inside',
                    title: {
                        text: data.series[0].name,
                        style: {
                            fontSize: '11px',
                            "font-family": "Arial",
                            color: '#474b4b'
                        }
                    },
                    labels: {
                        style: {
                            fontSize: '10px',
                            "font-family": "Arial"
                        }
                    }
                }],
                xAxis: {
                    categories: data.categories,
                    tickWidth: 0,
                    title: {
                        text: LanguageDay,
                        align: 'high',
                        y: -20,
                        style: {
                            fontSize: '12px',
                            "font-family": "Arial"
                        }
                    },
                    labels: {
                        rotation: -90,
                        x: 3,
                        style: {
                            fontSize: '10px',
                            "font-family": "Arial"
                        }
                    }
                },
                legend: {
                    itemStyle: {
                        font: '8pt Arial'
                    },
                    enabled: true,
                    borderWidth: 1,
                    borderColor: '#474b4b',
                    x: 280,
                    y: 15,
                    verticalAlign: 'top',
                },
                exporting: {
                    enabled: false,
                },
                tooltip: {
                    shared: true,
                },
            });
        })
    }
}

//function for visitor count by hour
function callVisitorCountByHour(data) {
    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "dayreport",
                events: {
                    load: function () {
                        $("#container").removeClass("chartLoading");
                    }
                },
            },
            title: {
                text: ''
            },
            credits: {
                enabled: false
            },
            xAxis: {
                gridLineWidth: 0,
                tickWidth: 0,
                gridLineWidth: 0,
                rotation: -90,
                title: {
                    text: LanguageTime
                },
                labels: {
                    rotation: -90
                },
                categories: data.categories,
            },
            yAxis: {
                minorGridLineWidth: 0,
                gridLineWidth: 0,
                lineWidth: 1,
                minorTickPosition: 'inside',
                minorTickWidth: 1,
                min: 0,
                title: {
                    text: LanguageTrafficCount
                }
            },
            tooltip: {
                shared: true,
                useHTML: true,
            },
            plotOptions: {
                column: {
                    series: {
                        pointPadding: 10,
                        borderWidth: 0,
                        groupPadding: 0,
                        pointWidth: 15
                    }
                }
            },
            legend: {
                align: 'right',
                x: -30,
                verticalAlign: 'top',
                y: -13,
                floating: true,
                shadow: false
            },

            series: data.series,
            exporting: {
                enabled: false,
            }
        })
    })
}

//function for visitor count by week
function callVisitorCountByWeek(data) {
    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "dayreport",
                events: {
                    load: function () {
                        $("#container").removeClass("chartLoading");
                    }
                },
            },
            title: {
                text: ''
            },
            credits: {
                enabled: false
            },
            xAxis: {
                gridLineWidth: 0,
                tickWidth: 0,
                gridLineWidth: 0,
                rotation: -90,
                title: {
                    text: LanguageWeek
                },
                labels: {
                    rotation: -90
                },
                categories: data.categories,
            },
            yAxis: {
                minorGridLineWidth: 0,
                gridLineWidth: 0,
                lineWidth: 1,
                minorTickPosition: 'inside',
                minorTickWidth: 1,
                min: 0,
                title: {
                    text: LanguageTrafficCount
                }
            },
            tooltip: {
                shared: true,
                useHTML: true
            },
            plotOptions: {
                column: {
                    series: {
                        pointPadding: 10,
                        borderWidth: 0,
                        groupPadding: 0,
                        pointWidth: 15
                    }
                }
            },
            legend: {
                align: 'right',
                x: -30,
                verticalAlign: 'top',
                y: -13,
                floating: true,
                shadow: false
            },

            series: data.series,
            exporting: {
                enabled: false,
            }
        })
    })
}

//function for Outside traffic count
function callOutsideTrafficCount(data) {
    $(function () {
        // create the chart
        var options = new Highcharts.Chart({
            chart: {
                renderTo: "dayreport",
                marginTop: 50,
                marginBottom: 50,
                events: {
                    load: function (event) {
                        $("#container").removeClass("chartLoading");
                    }
                }
            },
            title: {
                text: null
            },
            scrollbar: {
                enabled: false
            },
            rangeSelector: {
                enabled: false
            },
            navigator: {
                enabled: false
            },
            tooltip: {
                shared: true,
                pointFormat: '{series.name}: <b>{point.y:.0f}</b><br/>'
            },                    
            legend: {
                enabled: true,
                align: 'top',
                backgroundColor: '#FFFFFF',
                borderColor: 'black',
                borderWidth: 0,
                layout: 'horizontal',
                verticalAlign: 'top',
                x: 580,
                y: 50
            },
            rangeSelector: {
                selected: 1,
                enabled: false
            },
            yAxis: [{
                opposite: false,
                gridLineWidth: 0,
                lineWidth: 1,
                labels: {
                    align: 'left',
                    x: -25
                },
                title: {
                    text: LanguageTrafficCount,
                    margin: 30
                },
                lineWidth: 2,
                min: 0
            }, {
                opposite: true,
                gridLineWidth: 0,
                lineWidth: 1,
                labels: {
                    align: 'right',
                    x: 25
                },
                title: {
                    text: LanguageWalkBy,
                    margin: 30
                },                        
                lineWidth: 2,
                min: 0
            }, {
                opposite: false,
                gridLineWidth: 0,
                lineWidth: 1,
                labels: {
                    align: 'left',
                    x: -25
                },
                top: '0%',
                height: '30%',
                offset: 0,
                lineWidth: 2,
                min: 0
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 1,
                tickInterval: data.tickInterval
                //labels: {
                //    style: {
                //        fontSize: '0px',
                //        "font-family": "Arial"
                //    },
                //    formatter: function () {
                //        var splitValue = this.value.toString().split("<br/>", 2);
                //        if (splitValue[1] == undefined)
                //            splitValue[1] = '';
                //        return '<label style="font-size:11px;">' + splitValue[0] + '<label><br/><label style="font-size:10px;">' + splitValue[1] + '</label>';
                //    }
                //}
            },
            credits: {
                enabled: false
            },
            series: data.series,
            navigation: {
                buttonOptions: {
                    enabled: true
                }
            },
            exporting: {
                enabled: false,
            }
        })
    })
}

//function for turn in rate 
function callTurnInRate(data) {
    $(function () {
        var turnInRateOptions = new Highcharts.Chart({
            chart: {
                renderTo: "dayreport",
                width: 775,
                events: {
                    load: function (event) {
                        $("#turnIn").removeClass("chartLoading");
                    }
                }
            },
            title: {
                text: null,
            },
            scrollbar: {
                enabled: false
            },
            rangeSelector: {
                enabled: false
            },
            navigator: {
                enabled: false
            },
            tooltip: {
                shared: true,
                pointFormat: '{series.name}: <b>{point.y:.0f}</b><br/>'
            },
            legend: {
                enabled: true,
                align: 'top',
                backgroundColor: '#FFFFFF',
                borderColor: 'black',
                borderWidth: 0,
                layout: 'horizontal',
                verticalAlign: 'top',
                x: 580,
                y: 17
            },
            rangeSelector: {
                selected: 1,
                enabled: false
            },
            exporting: {
                enabled: false,
                buttons: {
                    contextButton: {
                        enabled: false
                    }
                }
            },
            yAxis: [{
                opposite: false,
                gridLineWidth: 0,
                lineWidth: 1,
                labels: {
                    align: 'left',
                    x: -25
                },
                lineWidth: 2,
                min: 0
            }, {
                opposite: true,
                gridLineWidth: 0,
                lineWidth: 1,
                labels: {
                    align: 'right',
                    x: 25
                },
                lineWidth: 2,
                min: 0
            }, {
                opposite: false,
                gridLineWidth: 0,
                lineWidth: 1,
                labels: {
                    align: 'left',
                    x: -25
                },
                title: {
                    text: LanguageTurnInRatepercent,
                    margin: 30
                },
                offset: 0,
                lineWidth: 2,
                min: 0
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 1,
                tickInterval: data.tickInterval
                //labels: {
                //    style: {
                //        fontSize: '0px',
                //        "font-family": "Arial"
                //    },
                //    formatter: function () {
                //        var splitValue = this.value.toString().split("<br/>", 2);
                //        if (splitValue[1] == undefined)
                //            splitValue[1] = '';
                //        return '<label style="font-size:11px;">' + splitValue[0] + '<label><br/><label style="font-size:10px;">' + splitValue[1] + '</label>';
                //    }
                //}
            },
            credits: {
                enabled: false
            },
            series: data.series,
            navigation: {
                buttonOptions: {
                    enabled: true
                }
            }
        });
    })
}

//function for visitor duration
function callDwellTime(data,ID) {
    $(function () {
        var dwellTime = new Highcharts.Chart({
            chart: {
                renderTo: "dayreport" + ID,
                type: 'column',
                events: {
                    load: function (event) {
                        $("#container").removeClass("chartLoading");
                    }
                }
            },
            title: {
                text: null,
            },
            xAxis: {                
                categories: data.categories,
                lineWidth: 1,
                title: {
                    text: LanguageDate
                },
                labels: {
                    rotation: -90,
                    x: 4
                }
            },
            yAxis: {
                lineWidth: 1,
                gridLineWidth: 0,
                min: 0,
                title: {
                    text: LanguageTrafficCount
                },
                stackLabels: {
                    enabled: false,
                    style: {
                        fontWeight: 'bold',
                        color: (Highcharts.theme && Highcharts.theme.textColor) || 'gray'
                    }
                }
            },
            legend: {
                enabled: true,
                align: 'top',
                backgroundColor: '#FFFFFF',
                borderColor: 'black',
                borderWidth: 0,
                layout: 'horizontal',
                verticalAlign: 'top',
                x: 350,
                y: 0
            },
            tooltip: {
                formatter: function () {
                    return '<b>' + this.x + '</b><br/>' +
                    this.series.name + ': ' + this.y + '<br/>' +
                    'Total: ' + this.point.stackTotal;
                }
            },
            plotOptions: {
                column: {
                    stacking: 'normal',
                    dataLabels: {
                        enabled: false,
                        color: (Highcharts.theme && Highcharts.theme.dataLabelsColor) || 'white',
                        style: {
                            textShadow: '0 0 3px black, 0 0 3px black'
                        }
                    }
                }
            },
            credits: {
                enabled: false
            },
            series: [{
                name: data.series[0].name,
                data: data.series[0].data
            }, {
                name: data.series[1].name,
                data: data.series[1].data
            }, {
                name: data.series[2].name,
                data: data.series[2].data
            }],
            exporting: {
                enabled: false,
            }
        });
    })
}

//function for returning customer
function callReturningCust(data,ID) {
    $(function () {
        var returningCust = new Highcharts.Chart({
            chart: {
                renderTo: "dayreport" + ID,
                type: 'column',
                events: {
                    load: function (event) {
                        $("#container").removeClass("chartLoading");
                    }
                }
            },
            title: {
                text: null,
            },
            xAxis: {
                categories: data.categories,
                lineWidth: 1,
                title: {
                    text: LanguageDate
                },
                labels: {
                    rotation: -90,
                    x: 4
                }
            },
            yAxis: {
                lineWidth: 1,
                gridLineWidth: 0,
                min: 0,
                title: {
                    text: LanguageTrafficCount
                },
                stackLabels: {
                    enabled: false,
                    style: {
                        fontWeight: 'bold',
                        color: (Highcharts.theme && Highcharts.theme.textColor) || 'gray'
                    }
                }
            },
            legend: {
                enabled: true,
                align: 'top',
                backgroundColor: '#FFFFFF',
                borderColor: 'black',
                borderWidth: 0,
                layout: 'horizontal',
                verticalAlign: 'top',
                x: 500,
            },
            tooltip: {
                formatter: function () {
                    return '<b>' + this.x + '</b><br/>' +
                    this.series.name + ': ' + this.y + '<br/>' +
                    'Total: ' + this.point.stackTotal;
                }
            },
            plotOptions: {
                column: {
                    stacking: 'normal',
                    dataLabels: {
                        enabled: false,
                        color: (Highcharts.theme && Highcharts.theme.dataLabelsColor) || 'white',
                        style: {
                            textShadow: '0 0 3px black, 0 0 3px black'
                        }
                    }
                }
            },
            credits: {
                enabled: false
            },
            series: data.series,
            exporting: {
                enabled: false,
            }
        });
    })
}

//function for cross shopping
function callCrossShopping() {
    $(function () {
        var crossShopping = new Highcharts.Chart({
            chart: {
                renderTo: "dayreport",
                type: 'column',
                events: {
                    load: function (event) {
                        $("#container").removeClass("chartLoading");
                    }
                }
            },
            title: {
                text: null,
            },
            xAxis: {
                categories: xdate,
                lineWidth: 1,
                title: {
                    text: LanguageDate
                },
                labels: {
                    rotation: -90,
                    x: 4
                }
            },
            yAxis: {
                lineWidth: 1,
                gridLineWidth: 0,
                min: 0,
                title: {
                    text: LanguageTrafficCount
                },
                stackLabels: {
                    enabled: false,
                    style: {
                        fontWeight: 'bold',
                        color: (Highcharts.theme && Highcharts.theme.textColor) || 'gray'
                    }
                }
            },
            legend: {
                enabled: true,
                align: 'top',
                backgroundColor: '#FFFFFF',
                borderColor: 'black',
                borderWidth: 0,
                layout: 'horizontal',
                verticalAlign: 'top',
                x: 500,
            },
            tooltip: {
                formatter: function () {
                    return '<b>' + this.x + '</b><br/>' +
                    this.series.name + ': ' + this.y + '<br/>' +
                    'Total: ' + this.point.stackTotal;
                }
            },
            plotOptions: {
                column: {
                    stacking: 'normal',
                    dataLabels: {
                        enabled: false,
                        color: (Highcharts.theme && Highcharts.theme.dataLabelsColor) || 'white',
                        style: {
                            textShadow: '0 0 3px black, 0 0 3px black'
                        }
                    }
                }
            },
            credits: {
                enabled: false
            },
            series: [{
                name: LanguageThisshoponly,
                data: newCust,
                color: "#82b4e0",
            }, {
                name: '2 ' + Languageormorestores,
                data: vlwCust,
                color: "#f7a94b",
            }],
            exporting: {
                enabled: false,
            }
        });
    })
}

//for compare 2 store
function call2seriesStore(ShowOutValue, data, data1, branch, ID) {
    
    if (ShowOutValue) {
        $(function () {
            var chart = new Highcharts.Chart({
                chart: {
                    renderTo: "dayreport" + ID,
                    events: {
                        load: function () {
                            //chartEvent[3] = this;
                        }
                    }
                },
                series: [{
                    type: 'line',
                    name: data.series[0].name + ' (' + branch[0] + ')',
                    data: data.series[0].data,
                    color: '#97c5e9'

                }, {
                    type: 'line',
                    name: data.series[1].name + ' (' + branch[0] + ')',
                    data: data.series[1].data,
                    color: '#f49423'

                }
                , {
                    type: 'line',
                    name: data1.series[0].name + ' (' + branch[1] + ')',
                    data: data1.series[0].data,
                    color: '#97c5e9',
                    yAxis: 0
                }, {
                    type: 'line',
                    name: data1.series[1].name + ' (' + branch[1] + ')',
                    data: data1.series[1].data,
                    color: '#f49423',
                    yAxis: 0
                }],
                credits: {
                    enabled: false
                },
                title: {
                    text: ' ',
                    align: 'left',
                    style: {
                        "font-family": "Franklin Gothic Medium",
                        textDecoration: 'underline',
                        color: '#494b4b',
                        fontSize: '15px'
                    }
                },
                plotOptions: {
                    column: {
                        //stacking: 'normal',
                        pointPadding: 0,
                        borderWidth: 0
                    }
                },
                yAxis: [{
                    min: 0,
                    lineWidth: 1,
                    gridLineWidth: 0,
                    tickWidth: 1,
                    //tickInterval: 1000,
                    tickPixelInterval: 1000,
                    tickLength: 5,
                    tickPosition: 'inside',
                    title: {
                        text: data.series[0].name,
                        style: {
                            fontSize: '11px',
                            "font-family": "Arial",
                            color: '#474b4b'
                        }
                    },
                    labels: {
                        style: {
                            fontSize: '10px',
                            "font-family": "Arial"
                        }
                    }
                }],
                xAxis: {
                    categories: data.categories,
                    tickWidth: 0,
                    title: {
                        text: LanguageDay,
                        align: 'high',
                        y: -20,
                        style: {
                            fontSize: '12px',
                            "font-family": "Arial"
                        }
                    },
                    labels: {
                        rotation: -90,
                        x: 3,
                        style: {
                            fontSize: '10px',
                            "font-family": "Arial"
                        }
                    }
                },
                legend: {
                    itemStyle: {
                        font: '8pt Arial'
                    },
                    enabled: true,
                    borderWidth: 1,
                    borderColor: '#474b4b',
                    x: 300,
                    y: 15,
                    verticalAlign: 'top',
                },
                exporting: {
                    enabled: false,
                },
                tooltip: {
                    shared: true,
                },
            });
        })
    } else {
        $(function () {
            var chart = new Highcharts.Chart({
                chart: {
                    renderTo: "dayreport" + ID,
                    events: {
                        load: function () {
                            //chartEvent[3] = this;
                        }
                    }
                },
                series: [{
                    type: 'line',
                    name: data.series[0].name + ' (' + branch[0] + ')',
                    data: data.series[0].data,
                    color: '#97c5e9'
                },
                {
                    type: 'line',
                    name: data1.series[0].name + ' (' + branch[1] + ')',
                    data: data1.series[0].data,
                    color: '#FF0000'
                }],
                credits: {
                    enabled: false
                },
                title: {
                    text: ' ',
                    align: 'left',
                    style: {
                        "font-family": "Franklin Gothic Medium",
                        textDecoration: 'underline',
                        color: '#494b4b',
                        fontSize: '15px'
                    }
                },
                plotOptions: {
                    column: {
                        //stacking: 'normal',
                        pointPadding: 0,
                        borderWidth: 0
                    }
                },
                yAxis: [{
                    min: 0,
                    lineWidth: 1,
                    gridLineWidth: 0,
                    tickWidth: 1,
                    //tickInterval: 1000,
                    tickPixelInterval: 1000,
                    tickLength: 5,
                    tickPosition: 'inside',
                    title: {
                        text: data.series[0].name,
                        style: {
                            fontSize: '11px',
                            "font-family": "Arial",
                            color: '#474b4b'
                        }
                    },
                    labels: {
                        style: {
                            fontSize: '10px',
                            "font-family": "Arial"
                        }
                    }
                }],
                xAxis: {
                    categories: data.categories,
                    tickWidth: 0,
                    title: {
                        text: LanguageDay,
                        align: 'high',
                        y: -20,
                        style: {
                            fontSize: '12px',
                            "font-family": "Arial"
                        }
                    },
                    labels: {
                        rotation: -90,
                        x: 3,
                        style: {
                            fontSize: '10px',
                            "font-family": "Arial"
                        }
                    }
                },
                legend: {
                    itemStyle: {
                        font: '8pt Arial'
                    },
                    enabled: true,
                    borderWidth: 1,
                    width: 150,
                    borderColor: '#474b4b',
                    x: 280,
                    y: 15,
                    verticalAlign: 'top',
                },
                exporting: {
                    enabled: false,
                },
                tooltip: {
                    shared: true,
                },
            });
        })
    }
}

//function for visitor duration (2 store)
function ComparecallDwellTime(data,data1,branch, ID) {
    $(function () {
        var dwellTime = new Highcharts.Chart({
            chart: {
                renderTo: "dayreport" + ID,
                type: 'column',
                events: {
                    load: function (event) {
                        $("#container").removeClass("chartLoading");
                    }
                }
            },
            title: {
                text: null,
            },
            xAxis: {
                categories: data.categories,
                lineWidth: 1,
                title: {
                    text: LanguageDate
                },
                labels: {
                    rotation: -90,
                    x: 4
                }
            },
            yAxis: {
                lineWidth: 1,
                gridLineWidth: 0,
                min: 0,
                title: {
                    text: LanguageTrafficCount
                },
                stackLabels: {
                    enabled: false,
                    style: {
                        fontWeight: 'bold',
                        color: (Highcharts.theme && Highcharts.theme.textColor) || 'gray'
                    }
                }
            },
            legend: {
                enabled: true,
                align: 'top',
                backgroundColor: '#FFFFFF',
                borderColor: 'black',
                borderWidth: 0,
                layout: 'horizontal',
                verticalAlign: 'top',
                x: 350,
                y: 0
            },
            tooltip: {
                formatter: function () {
                    return '<b>' + this.x + '</b><br/>' +
                    this.series.name + ': ' + this.y + '<br/>' +
                    'Total: ' + this.point.stackTotal;
                }
            },
            plotOptions: {
                column: {
                    stacking: 'normal',
                    dataLabels: {
                        enabled: false,
                        color: (Highcharts.theme && Highcharts.theme.dataLabelsColor) || 'white',
                        style: {
                            textShadow: '0 0 3px black, 0 0 3px black'
                        }
                    }
                }
            },
            credits: {
                enabled: false
            },
            series: [{
                name: branch[0]+", "+data.series[0].name,
                data: data.series[0].data,
                stack: branch[0]
            }, {
                name: branch[0] + ", " + data.series[1].name,
                data: data.series[1].data,
                stack: branch[0]
            }, {
                name: branch[0] + ", " + data.series[2].name,
                data: data.series[2].data,
                stack: branch[0]
            }, {
                name: branch[1] + ", " + data1.series[0].name,
                data: data1.series[0].data,
                stack: branch[1]
            }, {
                name: branch[1] + ", " + data1.series[1].name,
                data: data1.series[1].data,
                stack: branch[1]
            }, {
                name: branch[1] + ", " + data1.series[2].name,
                data: data1.series[2].data,
                stack: branch[1]
            }],
            exporting: {
                enabled: false,
            }
        });
    })
}

//for compare 3 store
function call3seriesStore(ShowOutValue, data, data1, data2, branch, ID) {

    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "dayreport" + ID,
                events: {
                    load: function () {
                        //chartEvent[3] = this;
                    }
                }
            },
            series: [{
                type: 'line',
                name: data.series[0].name + ' (' + branch[0] + ')',
                data: data.series[0].data,
                color: '#97c5e9'
            },
            {
                type: 'line',
                name: data1.series[0].name + ' (' + branch[1] + ')',
                data: data1.series[0].data,
                color: '#FF0000'
            },
            {
                type: 'line',
                name: data2.series[0].name + ' (' + branch[2] + ')',
                data: data2.series[0].data,
                color: '#FFFF00'
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ' ',
                align: 'left',
                style: {
                    "font-family": "Franklin Gothic Medium",
                    textDecoration: 'underline',
                    color: '#494b4b',
                    fontSize: '15px'
                }
            },
            plotOptions: {
                column: {
                    //stacking: 'normal',
                    pointPadding: 0,
                    borderWidth: 0
                }
            },
            yAxis: [{
                min: 0,
                lineWidth: 1,
                gridLineWidth: 0,
                tickWidth: 1,
                //tickInterval: 1000,
                tickPixelInterval: 1000,
                tickLength: 5,
                tickPosition: 'inside',
                title: {
                    text: data.series[0].name,
                    style: {
                        fontSize: '11px',
                        "font-family": "Arial",
                        color: '#474b4b'
                    }
                },
                labels: {
                    style: {
                        fontSize: '10px',
                        "font-family": "Arial"
                    }
                }
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                title: {
                    text: LanguageDay,
                    align: 'high',
                    y: -20,
                    style: {
                        fontSize: '12px',
                        "font-family": "Arial"
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        fontSize: '10px',
                        "font-family": "Arial"
                    }
                }
            },
            legend: {
                itemStyle: {
                    font: '8pt Arial'
                },
                enabled: true,
                borderWidth: 1,
                width: 150,
                borderColor: '#474b4b',
                x: 280,
                y: 15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                shared: true,
            },
        });
    })
    
}

//function for visitor duration (3 store)
function ComparecallDwellTime3(data, data1, data2, branch, ID) {
    $(function () {
        var dwellTime = new Highcharts.Chart({
            chart: {
                renderTo: "dayreport" + ID,
                type: 'column',
                events: {
                    load: function (event) {
                        $("#container").removeClass("chartLoading");
                    }
                }
            },
            title: {
                text: null,
            },
            xAxis: {
                categories: data.categories,
                lineWidth: 1,
                title: {
                    text: LanguageDate
                },
                labels: {
                    rotation: -90,
                    x: 4
                }
            },
            yAxis: {
                lineWidth: 1,
                gridLineWidth: 0,
                min: 0,
                title: {
                    text: LanguageTrafficCount
                },
                stackLabels: {
                    enabled: false,
                    style: {
                        fontWeight: 'bold',
                        color: (Highcharts.theme && Highcharts.theme.textColor) || 'gray'
                    }
                }
            },
            legend: {
                enabled: true,
                align: 'top',
                backgroundColor: '#FFFFFF',
                borderColor: 'black',
                borderWidth: 0,
                layout: 'horizontal',
                verticalAlign: 'top',
                x: 350,
                y: 0
            },
            tooltip: {
                formatter: function () {
                    return '<b>' + this.x + '</b><br/>' +
                    this.series.name + ': ' + this.y + '<br/>' +
                    'Total: ' + this.point.stackTotal;
                }
            },
            plotOptions: {
                column: {
                    stacking: 'normal',
                    dataLabels: {
                        enabled: false,
                        color: (Highcharts.theme && Highcharts.theme.dataLabelsColor) || 'white',
                        style: {
                            textShadow: '0 0 3px black, 0 0 3px black'
                        }
                    }
                }
            },
            credits: {
                enabled: false
            },
            series: [{
                name: branch[0] + ", " + data.series[0].name,
                data: data.series[0].data,
                stack: branch[0]
            }, {
                name: branch[0] + ", " + data.series[1].name,
                data: data.series[1].data,
                stack: branch[0]
            }, {
                name: branch[0] + ", " + data.series[2].name,
                data: data.series[2].data,
                stack: branch[0]
            }, {
                name: branch[1] + ", " + data1.series[0].name,
                data: data1.series[0].data,
                stack: branch[1]
            }, {
                name: branch[1] + ", " + data1.series[1].name,
                data: data1.series[1].data,
                stack: branch[1]
            }, {
                name: branch[1] + ", " + data1.series[2].name,
                data: data1.series[2].data,
                stack: branch[1]
            }, {
                name: branch[2] + ", " + data2.series[0].name,
                data: data2.series[0].data,
                stack: branch[2]
            }, {
                name: branch[2] + ", " + data2.series[1].name,
                data: data2.series[1].data,
                stack: branch[2]
            }, {
                name: branch[2] + ", " + data2.series[2].name,
                data: data2.series[2].data,
                stack: branch[2]
            }],
            exporting: {
                enabled: false,
            }
        });
    })
}

//for compare 2 parameter
function call2seriesParam(ShowOutValue, data, data1, ID) {
    ShowOutValue = false;
    if (ShowOutValue) {
        $(function () {
            var chart = new Highcharts.Chart({
                chart: {
                    renderTo: "dayreport" + ID,
                    events: {
                        load: function () {
                            //chartEvent[3] = this;
                        }
                    }
                },
                series: [{
                    type: 'line',
                    name: data.series[0].name,
                    data: data.series[0].data,
                    color: '#97c5e9'

                }, {
                    type: 'line',
                    name: data.series[1].name,
                    data: data.series[1].data,
                    color: '#f49423'

                }
                , {
                    type: 'line',
                    name: data1.series[0].name,
                    data: data1.series[0].data,
                    color: '#97c5e9',
                    yAxis: 1
                }, {
                    type: 'line',
                    name: data1.series[1].name,
                    data: data1.series[1].data,
                    color: '#f49423',
                    yAxis: 1
                }],
                credits: {
                    enabled: false
                },
                title: {
                    text: ' ',
                    align: 'left',
                    style: {
                        "font-family": "Franklin Gothic Medium",
                        textDecoration: 'underline',
                        color: '#494b4b',
                        fontSize: '15px'
                    }
                },
                plotOptions: {
                    column: {
                        //stacking: 'normal',
                        pointPadding: 0,
                        borderWidth: 0
                    }
                },
                yAxis: [{
                    min: 0,
                    lineWidth: 1,
                    gridLineWidth: 0,
                    tickWidth: 1,
                    //tickInterval: 1000,
                    tickPixelInterval: 1000,
                    tickLength: 5,
                    tickPosition: 'inside',
                    title: {
                        text: data.series[0].name,
                        style: {
                            fontSize: '11px',
                            "font-family": "Arial",
                            color: '#474b4b'
                        }
                    },
                    labels: {
                        style: {
                            fontSize: '10px',
                            "font-family": "Arial"
                        }
                    }
                }],
                xAxis: {
                    categories: data.categories,
                    tickWidth: 0,
                    title: {
                        text: LanguageDay,
                        align: 'high',
                        y: -20,
                        style: {
                            fontSize: '12px',
                            "font-family": "Arial"
                        }
                    },
                    labels: {
                        rotation: -90,
                        x: 3,
                        style: {
                            fontSize: '10px',
                            "font-family": "Arial"
                        }
                    }
                },
                legend: {
                    itemStyle: {
                        font: '8pt Arial'
                    },
                    enabled: true,
                    borderWidth: 1,
                    borderColor: '#474b4b',
                    x: 300,
                    y: 15,
                    verticalAlign: 'top',
                },
                exporting: {
                    enabled: false,
                },
                tooltip: {
                    shared: true,
                },
            });
        })
    } else {
        $(function () {
            var chart = new Highcharts.Chart({
                chart: {
                    renderTo: "dayreport" + ID,
                    events: {
                        load: function () {
                            //chartEvent[3] = this;
                        }
                    }
                },
                series: [{
                    type: 'line',
                    name: data.series[0].name,
                    data: data.series[0].data,
                    color: '#97c5e9'
                },
                {
                    type: 'line',
                    name: data1.series[0].name,
                    data: data1.series[0].data,
                    color: '#FF0000',
                    yAxis: 1
                }],
                credits: {
                    enabled: false
                },
                title: {
                    text: ' ',
                    align: 'left',
                    style: {
                        "font-family": "Franklin Gothic Medium",
                        textDecoration: 'underline',
                        color: '#494b4b',
                        fontSize: '15px'
                    }
                },
                plotOptions: {
                    column: {
                        //stacking: 'normal',
                        pointPadding: 0,
                        borderWidth: 0
                    }
                },
                yAxis: [{
                    min: 0,
                    lineWidth: 1,
                    gridLineWidth: 0,
                    tickWidth: 1,
                    //tickInterval: 1000,
                    tickPixelInterval: 1000,
                    tickLength: 5,
                    tickPosition: 'inside',
                    title: {
                        text: data.series[0].name,
                        style: {
                            fontSize: '11px',
                            "font-family": "Arial",
                            color: '#474b4b'
                        }
                    },
                    labels: {
                        style: {
                            fontSize: '10px',
                            "font-family": "Arial"
                        }
                    }
                }, {
                    min: 0,
                    opposite: true,
                    lineWidth: 1,
                    gridLineWidth: 0,
                    tickWidth: 1,
                    //tickInterval: 1000,
                    tickPixelInterval: 1000,
                    tickLength: 5,
                    tickPosition: 'inside',
                    title: {
                        text: data1.series[0].name,
                        style: {
                            fontSize: '11px',
                            "font-family": "Arial",
                            color: '#474b4b'
                        }
                    },
                    labels: {
                        style: {
                            fontSize: '10px',
                            "font-family": "Arial"
                        }
                    }
                }],
                xAxis: {
                    categories: data.categories,
                    tickWidth: 0,
                    title: {
                        text: LanguageDay,
                        align: 'high',
                        y: -20,
                        style: {
                            fontSize: '12px',
                            "font-family": "Arial"
                        }
                    },
                    labels: {
                        rotation: -90,
                        x: 3,
                        style: {
                            fontSize: '10px',
                            "font-family": "Arial"
                        }
                    }
                },
                legend: {
                    itemStyle: {
                        font: '8pt Arial'
                    },
                    enabled: true,
                    borderWidth: 1,
                    width: 150,
                    borderColor: '#474b4b',
                    x: 280,
                    y: 15,
                    verticalAlign: 'top',
                },
                exporting: {
                    enabled: false,
                },
                tooltip: {
                    shared: true,
                },
            });
        })
    }
}

//for compare 3 parameter
function call3seriesParam(ShowOutValue, data, data1, data2, ID) {
    ShowOutValue = false;
    if (ShowOutValue) {
        $(function () {
            var chart = new Highcharts.Chart({
                chart: {
                    renderTo: "dayreport" + ID,
                    events: {
                        load: function () {
                            //chartEvent[3] = this;
                        }
                    }
                },
                series: [{
                    type: 'line',
                    name: data.series[0].name,
                    data: data.series[0].data,
                    color: '#97c5e9'

                }, {
                    type: 'line',
                    name: data.series[1].name,
                    data: data.series[1].data,
                    color: '#f49423'

                }
                , {
                    type: 'line',
                    name: data1.series[0].name,
                    data: data1.series[0].data,
                    color: '#97c5e9',
                    yAxis: 1
                }, {
                    type: 'line',
                    name: data1.series[1].name,
                    data: data1.series[1].data,
                    color: '#f49423',
                    yAxis: 1
                }],
                credits: {
                    enabled: false
                },
                title: {
                    text: ' ',
                    align: 'left',
                    style: {
                        "font-family": "Franklin Gothic Medium",
                        textDecoration: 'underline',
                        color: '#494b4b',
                        fontSize: '15px'
                    }
                },
                plotOptions: {
                    column: {
                        //stacking: 'normal',
                        pointPadding: 0,
                        borderWidth: 0
                    }
                },
                yAxis: [{
                    min: 0,
                    lineWidth: 1,
                    gridLineWidth: 0,
                    tickWidth: 1,
                    //tickInterval: 1000,
                    tickPixelInterval: 1000,
                    tickLength: 5,
                    tickPosition: 'inside',
                    title: {
                        text: data.series[0].name,
                        style: {
                            fontSize: '11px',
                            "font-family": "Arial",
                            color: '#474b4b'
                        }
                    },
                    labels: {
                        style: {
                            fontSize: '10px',
                            "font-family": "Arial"
                        }
                    }
                }],
                xAxis: {
                    categories: data.categories,
                    tickWidth: 0,
                    title: {
                        text: LanguageDay,
                        align: 'high',
                        y: -20,
                        style: {
                            fontSize: '12px',
                            "font-family": "Arial"
                        }
                    },
                    labels: {
                        rotation: -90,
                        x: 3,
                        style: {
                            fontSize: '10px',
                            "font-family": "Arial"
                        }
                    }
                },
                legend: {
                    itemStyle: {
                        font: '8pt Arial'
                    },
                    enabled: true,
                    borderWidth: 1,
                    borderColor: '#474b4b',
                    x: 300,
                    y: 15,
                    verticalAlign: 'top',
                },
                exporting: {
                    enabled: false,
                },
                tooltip: {
                    shared: true,
                },
            });
        })
    } else {
        $(function () {
            var chart = new Highcharts.Chart({
                chart: {
                    renderTo: "dayreport" + ID,
                    events: {
                        load: function () {
                            //chartEvent[3] = this;
                        }
                    }
                },
                series: [{
                    type: 'line',
                    name: data.series[0].name,
                    data: data.series[0].data,
                    color: '#97c5e9'
                },
                {
                    type: 'line',
                    name: data1.series[0].name,
                    data: data1.series[0].data,
                    color: '#FF0000',
                    yAxis: 1
                },
                {
                    type: 'line',
                    name: data2.series[0].name,
                    data: data2.series[0].data,
                    color: '#FFFF00',
                    yAxis: 2
                }],
                credits: {
                    enabled: false
                },
                title: {
                    text: ' ',
                    align: 'left',
                    style: {
                        "font-family": "Franklin Gothic Medium",
                        textDecoration: 'underline',
                        color: '#494b4b',
                        fontSize: '15px'
                    }
                },
                plotOptions: {
                    column: {
                        //stacking: 'normal',
                        pointPadding: 0,
                        borderWidth: 0
                    }
                },
                yAxis: [{
                    min: 0,
                    lineWidth: 1,
                    gridLineWidth: 0,
                    tickWidth: 1,
                    //tickInterval: 1000,
                    tickPixelInterval: 1000,
                    tickLength: 5,
                    tickPosition: 'inside',
                    title: {
                        text: data.series[0].name,
                        style: {
                            fontSize: '11px',
                            "font-family": "Arial",
                            color: '#474b4b'
                        }
                    },
                    labels: {
                        style: {
                            fontSize: '10px',
                            "font-family": "Arial"
                        }
                    }
                }, {
                    min: 0,
                    opposite: true,
                    lineWidth: 1,
                    gridLineWidth: 0,
                    tickWidth: 1,
                    //tickInterval: 1000,
                    tickPixelInterval: 1000,
                    tickLength: 5,
                    tickPosition: 'inside',
                    title: {
                        text: data1.series[0].name,
                        style: {
                            fontSize: '11px',
                            "font-family": "Arial",
                            color: '#474b4b'
                        }
                    },
                    labels: {
                        style: {
                            fontSize: '10px',
                            "font-family": "Arial"
                        }
                    }
                }, {
                    min: 0,
                    opposite: true,
                    lineWidth: 1,
                    gridLineWidth: 0,
                    tickWidth: 1,
                    //tickInterval: 1000,
                    tickPixelInterval: 1000,
                    tickLength: 5,
                    tickPosition: 'inside',
                    title: {
                        text: data2.series[0].name,
                        style: {
                            fontSize: '11px',
                            "font-family": "Arial",
                            color: '#474b4b'
                        }
                    },
                    labels: {
                        style: {
                            fontSize: '10px',
                            "font-family": "Arial"
                        }
                    }
                }],
                xAxis: {
                    categories: data.categories,
                    tickWidth: 0,
                    title: {
                        text: LanguageDay,
                        align: 'high',
                        y: -20,
                        style: {
                            fontSize: '12px',
                            "font-family": "Arial"
                        }
                    },
                    labels: {
                        rotation: -90,
                        x: 3,
                        style: {
                            fontSize: '10px',
                            "font-family": "Arial"
                        }
                    }
                },
                legend: {
                    itemStyle: {
                        font: '8pt Arial'
                    },
                    enabled: true,
                    borderWidth: 1,
                    width: 150,
                    borderColor: '#474b4b',
                    x: 280,
                    y: 15,
                    verticalAlign: 'top',
                },
                exporting: {
                    enabled: false,
                },
                tooltip: {
                    shared: true,
                },
            });
        })
    }
}

//For compare 2 by Time (table)
function CompareCallTableByTime(data, data1, id) {

    $("#dataTable" + id).html("");

    var count1 = 0;
    var count2 = 0;

    var total1 = 0;
    var total2 = 0;

    //for (var t = 0 ; t < data.categories.length ; t++) {
    //    if (data.categories[t].search(":") != 2) {
    //        data.categories[t] = data.categories[t].substring(0, 3);
    //    }
    //}

    if (data.categories[0].search(":") != 2) {
        var range = "Day";
    } else {
        var range = "Time";
    }

    $("#dataTable" + id).append("<tr><th>" + range + "</th><td>" + LanguageSelectedDateRange + " 1" + "</td><td>" + LanguageSelectedDateRange + " 2" + "</td></tr>");
    for (var i = 0; i < data.categories.length; i++) {

        if (data.series[0].data[i] == undefined)
            data.series[0].data[i] = "<div style=\"color:red;\" >" + LanguageDateNotSelectedInThisRange + "</div>";
        if (data1.series[0].data[i] == undefined)
            data1.series[0].data[i] = "<div style=\"color:red;\" >" + LanguageDateNotSelectedInThisRange + "</div>";

        if (data.categories[i] == undefined)
            data.categories[i] = "<div style=\"color:red;\" >" + LanguageNotSelected + "</div>";
        if (data1.categories[i] == undefined)
            data1.categories[i] = "<div style=\"color:red;\" >" + LanguageNotSelected + "</div>";

        $("#dataTable"+id).append("<tr><th>" + data.categories[i] + " .Vs " + data1.categories[i] + "</th><td>" + data.series[0].data[i] + "</td><td>" + data1.series[0].data[i] + "</td></tr>");

        if (data.series[0].data[i] != 0)
            count1++;
        else if (data1.series[0].data[i] != 0)
            count2++;

        if (data.series[0].data[i] > 0)
            total1 += data.series[0].data[i];
        if (data1.series[0].data[i] > 0)
            total2 += data1.series[0].data[i];
    }

    if (data.series[0].name == "Turn In Rate" || data.series[0].name == "Walk By") {
        if (total1 != 0)
            total1 = total1 / count1;
        if (total2 != 0)
            total2 = total2 / count2;
    }

    if (total1 != 0)
        total1 = total1.toFixed(2);
    if (total2 != 0)
        total2 = total2.toFixed(2);

    $("#dataTable" + id).append("<tr><th>" + LanguageTotal + "</th><td>" + total1 + "</td><td>" + total2 + "</td></tr>");
}

//For Compare 2 By Time (graph)
function CompareCallGraphByTime(data, data1, id) {

    //for (var t = 0 ; t < data.categories.length ; t++) {
    //    if (data.categories[t].search(":") != 2) {
    //        data.categories[t] = data.categories[t].substring(0,3);
    //    }
    //}

    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "dayreport" + id,
                events: {
                    load: function () {
                        //chartEvent[3] = this;
                    }
                }
            },
            series: [{
                type: 'line',
                name: LanguageSelectedDateRange + " 1",
                data: data.series[0].data,
                color: '#97c5e9'
            },
            {
                type: 'line',
                name: LanguageSelectedDateRange + " 2",
                data: data1.series[0].data,
                color: '#FF0000'
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ' ',
                align: 'left',
                style: {
                    "font-family": "Franklin Gothic Medium",
                    textDecoration: 'underline',
                    color: '#494b4b',
                    fontSize: '15px'
                }
            },
            plotOptions: {
                column: {
                    //stacking: 'normal',
                    pointPadding: 0,
                    borderWidth: 0
                }
            },
            yAxis: [{
                min: 0,
                lineWidth: 1,
                gridLineWidth: 0,
                tickWidth: 1,
                //tickInterval: 1000,
                tickPixelInterval: 1000,
                tickLength: 5,
                tickPosition: 'inside',
                title: {
                    text: data.series[0].name,
                    style: {
                        fontSize: '11px',
                        "font-family": "Arial",
                        color: '#474b4b'
                    }
                },
                labels: {
                    style: {
                        fontSize: '10px',
                        "font-family": "Arial"
                    }
                }
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                title: {
                    text: LanguageDay,
                    align: 'high',
                    y: -20,
                    style: {
                        fontSize: '12px',
                        "font-family": "Arial"
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        fontSize: '10px',
                        "font-family": "Arial"
                    }
                }
            },
            legend: {
                itemStyle: {
                    font: '8pt Arial'
                },
                enabled: true,
                borderWidth: 1,
                width: 150,
                borderColor: '#474b4b',
                x: 280,
                y: 15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                shared: true,
            },
        });
    })

}

//For compare 3 by Time (table)
function CompareCallTableByTime2(data, data1, data2, id) {
    console.log("asd");
    $("#dataTable" + id ).html("");

    var count1 = 0;
    var count2 = 0;
    var count3 = 0;

    var total1 = 0;
    var total2 = 0;
    var total3 = 0;

    //for (var t = 0 ; t < data.categories.length ; t++) {
    //    if (data.categories[t].search(":") != 2) {
    //        data.categories[t] = data.categories[t].substring(0, 3);
    //    }
    //}

    if (data.categories[0].search(":") != 2) {
        var range = "Day";
    } else {
        var range = "Time";
    }

    $("#dataTable"+id).append("<tr><th>" + range + "</th><td>" + LanguageSelectedDateRange + " 1" + "</td><td>" + LanguageSelectedDateRange + " 2" + "</td><td>" + LanguageSelectedDateRange + " 3" + "</td></tr>");
    for (var i = 0; i < data.categories.length; i++) {

        if (data.series[0].data[i] == undefined)
            data.series[0].data[i] = "<div style=\"color:red;\" >" + LanguageDateNotSelectedInThisRange + "</div>";
        if (data1.series[0].data[i] == undefined)
            data1.series[0].data[i] = "<div style=\"color:red;\" >" + LanguageDateNotSelectedInThisRange + "</div>";
        if (data2.series[0].data[i] == undefined)
            data2.series[0].data[i] = "<div style=\"color:red;\" >" + LanguageDateNotSelectedInThisRange + "</div>";

        if (data.categories[i] == undefined)
            data.categories[i] = "<div style=\"color:red;\" >" + LanguageNotSelected + "</div>";
        if (data1.categories[i] == undefined)
            data1.categories[i] = "<div style=\"color:red;\" >" + LanguageNotSelected + "</div>";
        if (data2.categories[i] == undefined)
            data2.categories[i] = "<div style=\"color:red;\" >" + LanguageNotSelected + "</div>";

        $("#dataTable"+id).append("<tr><th>" + data.categories[i] + " Vs " + data1.categories[i] + " Vs " + data2.categories[i] + "</th><td>" + data.series[0].data[i] + "</td><td>" + data1.series[0].data[i] + "</td><td>" + data2.series[0].data[i] + "</td></tr>");

        if (data.series[0].data[i] != 0)
            count1++;
        else if (data1.series[0].data[i] != 0)
            count2++;
        else if (data2.series[0].data[i] != 0)
            count3++;

        if (data.series[0].data[i] > 0)
            total1 += data.series[0].data[i];
        if (data1.series[0].data[i] > 0)
            total2 += data1.series[0].data[i];
        if (data2.series[0].data[i] > 0)
            total3 += data2.series[0].data[i];
    }

    if (data.series[0].name == "Turn In Rate" || data.series[0].name == "Walk By") {
        if (total1 != 0)
            total1 = total1 / count1;
        if (total2 != 0)
            total2 = total2 / count2;
        if (total3 != 0)
            total3 = total3 / count3;
    }

    if (total1 != 0)
        total1 = total1.toFixed(2);
    if (total2 != 0)
        total2 = total2.toFixed(2);
    if (total3 != 0)
        total3 = total3.toFixed(2);

    $("#dataTable" + id).append("<tr><th>" + LanguageTotal + "</th><td>" + total1 + "</td><td>" + total2 + "</td><td>" + total3 + "</td></tr>");
}

//For Compare 3 By Time (graph)
function CompareCallGraphByTime2(data, data1, data2, id) {

    //for (var t = 0 ; t < data.categories.length ; t++) {
    //    if (data.categories[t].search(":") != 2) {
    //        data.categories[t] = data.categories[t].substring(0,3);
    //    }
    //}

    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "dayreport"+id,
                events: {
                    load: function () {
                        //chartEvent[3] = this;
                    }
                }
            },
            series: [{
                type: 'line',
                name: LanguageSelectedDateRange + " 1",
                data: data.series[0].data,
                color: '#97c5e9'
            },
            {
                type: 'line',
                name: LanguageSelectedDateRange + " 2",
                data: data1.series[0].data,
                color: '#FF0000'
            },
            {
                type: 'line',
                name: LanguageSelectedDateRange + " 3",
                data: data2.series[0].data,
                color: '#FFFF00'
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ' ',
                align: 'left',
                style: {
                    "font-family": "Franklin Gothic Medium",
                    textDecoration: 'underline',
                    color: '#494b4b',
                    fontSize: '15px'
                }
            },
            plotOptions: {
                column: {
                    //stacking: 'normal',
                    pointPadding: 0,
                    borderWidth: 0
                }
            },
            yAxis: [{
                min: 0,
                lineWidth: 1,
                gridLineWidth: 0,
                tickWidth: 1,
                //tickInterval: 1000,
                tickPixelInterval: 1000,
                tickLength: 5,
                tickPosition: 'inside',
                title: {
                    text: data.series[0].name,
                    style: {
                        fontSize: '11px',
                        "font-family": "Arial",
                        color: '#474b4b'
                    }
                },
                labels: {
                    style: {
                        fontSize: '10px',
                        "font-family": "Arial"
                    }
                }
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                title: {
                    text: LanguageDayorTime,
                    align: 'high',
                    y: -20,
                    style: {
                        fontSize: '12px',
                        "font-family": "Arial"
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        fontSize: '10px',
                        "font-family": "Arial"
                    }
                }
            },
            legend: {
                itemStyle: {
                    font: '8pt Arial'
                },
                enabled: true,
                borderWidth: 1,
                width: 150,
                borderColor: '#474b4b',
                x: 280,
                y: 15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                shared: true,
            },
        });
    })

}