//custom exception for debug and checking purposes
function UserException(message) {
    this.message = message;
    this.name = "Compare Exception";
}

//initialize an compare object to be contructed
function InitCompare(type) {
    if (type == null) throw new UserException("Please specify compare type");
    compare.Type = type;
    compare.CompareList = [];
}

//initialize comparison input based on "Category of Comparison"
function InitializeComparison() {
    if ($("input[name=compare-with-selection]:checked").val() == "site") {
        $("#compareBranchCounterSection").show();
        $("#compareDateSection").hide();
        $("#compareMetricSection").hide();
    } else if ($("input[name=compare-with-selection]:checked").val() == "time") {
        $("#compareBranchCounterSection").hide();
        $("#compareDateSection").show();
        $("#compareMetricSection").hide();
    }
    else {
        $("#compareBranchCounterSection").hide();
        $("#compareDateSection").hide();
        $("#compareMetricSection").show();
    }
}

function InitCompareMetrics() {
    $("#compareGroup").hide();
    InitializeComparison();
    $("input[name=compare-with-selection]").change(function () {
        InitializeComparison();
    });
    $("#toggleCompare").on("change", function () {
        if ($(this).is(':checked')) {
            $("#compareGroup").slideDown("fast");
        } else {
            $("#compareGroup").slideUp();
        }
    });
    $("#compareBranchCounterSection .helper-cancel i").click(function () {
        var selector = null;
        selector = $(this).data("clear-for");
        if (selector == null || typeof selector == "undefined")
            return;
        else {
            $("#" + selector).val(null).trigger("change");
        }
    });

    $("#compareMetricSection .helper-cancel i").click(function () {
        var selector = null;
        selector = $(this).data("clear-for");
        if (selector == null || typeof selector == "undefined")
            return;
        else {
            $("#" + selector).val(null);
        }
    });
}


function getEndDate(thisDate) {
    var momentFormat = dateFormat == "dateFirst" ? "DD/MM/YYYY" : "MM/DD/YYYY";
    var daysdiff = moment($("#endDate").val(), momentFormat).diff(moment($("#startDate").val(), momentFormat), 'd');
    

    if ($(thisDate).val() != ""){
        $(thisDate).siblings('input').val(moment($(thisDate).val(), momentFormat).add(daysdiff, 'days').format(momentFormat));
    }
}