﻿function setDate(lang) {
    if (typeof lang == 'undefined' || lang == null) {
        lang = "en";
    }
    var waitLoad = setInterval(function () {
        if (dateFormat) {
            var thisDate = dateFormat == "dateFirst" ? "dd/mm/yyyy" : dateFormat == "monthFirst" ? "mm/dd/yyyy" : dateFormat.toLowerCase();
            if (model.range == 3) {
                $('.hasDatePicker').datepicker({
                    format: thisDate,
                    //format: dateFormat == "dateFirst" ? "dd/mm/yyyy" : dateFormat == "monthFirst" ? "mm/dd/yyyy" : dateFormat.toLowerCase(),
                    startDate: new Date(),
                    endDate: new Date(new Date() + 1),
                    todayHighlight: true,
                    autoclose: true,
                    weekStart: days[firstDayOfWeek],
                    todayBtn: "linked",
                    calendarWeeks: true,
                    language: lang,
                });
            } else {
                $('.hasDatePicker').datepicker({
                    format: thisDate,
                    //format: dateFormat == "dateFirst" ? "dd/mm/yyyy" : dateFormat == "monthFirst" ? "mm/dd/yyyy" : dateFormat.toLowerCase(),
                    startDate: new Date(1000000000000),
                    endDate: new Date(),
                    todayHighlight: true,
                    autoclose: true,
                    weekStart: days[firstDayOfWeek],
                    todayBtn: "linked",
                    calendarWeeks: true,
                    language: lang,
                });
            }

            if ($('#startDate').val() == "") {
                /*model.start == "" ?*/ $('#startDate').datepicker("setDate", moment().subtract(7, 'd').toDate()) /*: $('#startDate').val(model.start)*/;
                /*model.end == "" ?*/ $('#endDate').datepicker("setDate", moment().format(dateFormat == "dateFirst" ? "DD/MM/YYYY" : dateFormat == "monthFirst" ? "MM/DD/YYYY" : dateFormat.toLowerCase())) /*: $('#endDate').val(model.end)*/;
            } else {
                clearInterval(waitLoad);
            }

        }
    }, 200);
}

function initializeDateRange() {
    var myDateFormat = dateFormat == "dateFirst" ? "DD/MM/YYYY" : "MM/DD/YYYY";

    $("#dateSelector").on("change", function () {
        var custDate = $("#dateSelector").val();

        if (custDate != "custom") {
            $("#startDate").attr("disabled", true); $("#endDate").attr("disabled", true);
        }
        else {
            $("#startDate").attr("disabled", false); $("#endDate").attr("disabled", false);
        }
        if (custDate == "today") {
            $('#startDate').val(moment().format(myDateFormat));
            $('#endDate').val(moment().format(myDateFormat));
        }
        else if (custDate == "yesterday") {
            $('#startDate').val(moment().subtract(1, 'd').format(myDateFormat));
            $('#endDate').val(moment().subtract(1, 'd').format(myDateFormat));
        }
        else if (custDate == "thisWeek") {
            var firstDay = days[firstDayOfWeek];
            $('#startDate').val(moment().subtract(moment().subtract(firstDay, 'd').days(), 'd').format(myDateFormat));
            $('#endDate').val(moment().subtract(moment().subtract(firstDay, 'd').days(), 'd').add(6, 'd').format(myDateFormat));
        }
        else if (custDate == "last7Days") {
            $('#startDate').val(moment().subtract(7, 'd').format(myDateFormat));
            $('#endDate').val(moment().subtract(1, 'd').format(myDateFormat));
        }
        else if (custDate == "lastWeek") {
            var firstDay = days[firstDayOfWeek];
            $('#startDate').val(moment().subtract(moment().subtract(firstDay, 'd').days() + 7, 'd').format(myDateFormat));
            $('#endDate').val(moment().subtract(moment().subtract(firstDay, 'd').days() + 7, 'd').add(6, 'd').format(myDateFormat));
        }
        else if (custDate == "thisMonth") {
            $('#startDate').val(moment().startOf('month').format(myDateFormat));
            $('#endDate').val(moment().endOf('month').format(myDateFormat));
        }
        else if (custDate == "lastMonth") {
            $('#startDate').val(moment().subtract(1, 'M').startOf('month').format(myDateFormat));
            $('#endDate').val(moment().subtract(1, 'M').endOf('month').format(myDateFormat));
        }
        else if (custDate == "last30Days") {
            $('#startDate').val(moment().subtract(31, 'd').format(myDateFormat));
            $('#endDate').val(moment().subtract(1, 'd').format(myDateFormat));
        }
    });

    $("input[name=data-selection]").on("change", function () {

        var periodNow = $("input[name=data-selection]:checked").val();
        if (periodNow == "1") {
            $("#endDate").attr("disabled", true); $("#endDate").val($("#startDate").val());
        }
        else
            $("#endDate").attr("disabled", false);
    });

    $("#startDate").on("change", function () {
        var periodNow = $("input[name=data-selection]:checked").val();
        if (periodNow == "1") {
            $("#endDate").attr("disabled", true); $("#endDate").val($("#startDate").val());
        }
        else
            $("#endDate").attr("disabled", false);
    });
}

//Initializing Settings (Required for generating PDF)[Kelvin Yap]
function initializeSettings(isGeneratePDF) {
    if (model.parameter != "") {
        var param = model.parameter.split(',');
        //$("input[name=compare-with-selection]:checked").val("metric").change();
        $("#radio-compare-metric").click();
        if (param.length > 1) {
            $("#toggleCompare").attr("checked", true);
        }
        for (var a = 0; a < param.length; a++) {
            $($(".MetricSelect")[a]).val(param[a]);
            //    $($("select[id^=compareMetricSelect]")[a]).append("<option value='" + param[paramIndex] + "'>" + param[paramIndex] + "</option>");
            //$($("select[id^=compareMetricSelect]")[a]).val(param[paramIndex]);

            //paramIndex++;

        }
    }

    var camID = model.cameraId.split(',');
    var branchID = model.branchId.split(',');
    model.selectedRegionID = model.selectedRegionID.split("&amp;").join("&");
    var selectedRegionID = model.selectedRegionID.split(',');
    var selectedMode = model.selectedMode.split(',');

    var camLength = model.cameraId == "" ? 0 : camID.length;
    var branchLength = model.branchId == "" ? 0 : branchID.length;
    var selectedRegionLength = model.selectedRegionID == "" ? 0 : selectedRegionID.length;
    var selectedModeLength = model.selectedMode == "" ? 0 : selectedMode.length;
    var pass = false;
    var pass2 = false;

    var camIndex = 0;
    var branchIndex = 0;
    var selectedRegionIndex = 0;
    var selectedModeIndex = 0;

    var comid = "";
    var comCode = "";

    if (companies.length > 1) {
        if (model.companyid != "") {
            $("#selectorCompany").val(model.companyid);
            comid = model.companyid;
            comCode = getCompanyCode(model.companyid);
        }
    }
    else {
        comCode = companies[0].CompanyCode;
        comid = companies[0].CompanyID;
    }
    if (selectedModeLength > 0) {
        if (isGeneratePDF) {
            $("select[id^=selector], .counterBranch").prop("disabled", false);
            if (selectedMode[selectedModeIndex] == "site" || selectedMode[selectedModeIndex] == "counter") {
                $("#selectorSite").append("<option class='opt-branch' value='" + sitesPDF[branchIndex].id + "'>" + sitesPDF[branchIndex].Name + "</option>");
                $("#selectorSite").val(sitesPDF[branchIndex].id);
                if (selectedMode[selectedModeIndex] == "counter") {
                    $("#selectorCounter").append("<option class='opt-cam' value='" + storesPDF[camIndex].id + "'>" + storesPDF[camIndex].Name + "</option>");
                    $("#selectorCounter").val(storesPDF[camIndex].id);
                    camIndex++;
                }
                branchIndex++;
            }
            else if (selectedMode[selectedModeIndex] == "region") {
                $("#selectorSite").append("<option class='opt-region' value='" + selectedRegionID[selectedRegionIndex] + "'>" + selectedRegionID[selectedRegionIndex] + "</option>");
                $("#selectorSite").val(selectedRegionID[selectedRegionIndex]);
                selectedRegionIndex++;
            }
            selectedModeIndex++;
            if (selectedModeIndex < selectedModeLength) {
                $("#toggleCompare").attr("checked", true);
                $("#compareGroup").show();
                $("#radio-compare-site").click();
                for (var a = 0; a < selectedModeLength - 1; a++) {
                    if (selectedMode[selectedModeIndex] == "counter" || selectedMode[selectedModeIndex] == "site") {
                        $($("select[id^=compareSiteSelect]")[a]).append("<option value='" + sitesPDF[branchIndex].id + "'>" + sitesPDF[branchIndex].Name + "</option>");
                        $($("select[id^=compareSiteSelect]")[a]).val(sitesPDF[branchIndex].id);
                        if (selectedMode[selectedModeIndex] == "counter") {
                            var ajaxPerform = loadCounterAjax(branchID[branchIndex]);
                            $($("select[id^=compareCounterSelect]")[a]).append("<option class='opt-branch' value='" + storesPDF[camIndex].id + "'>" + storesPDF[camIndex].Name + "</option>");
                            $($("select[id^=compareCounterSelect]")[a]).val(storesPDF[camIndex].id);
                            camIndex++;
                        }
                        else {
                            branchIndex++;
                        }
                    }
                    else if (selectedMode[selectedModeIndex] == "region") {
                        $($("select[id^=compareSiteSelect]")[a]).append("<option class='opt-region' value='" + selectedRegionID[selectedRegionIndex] + "'>" + selectedRegionID[selectedRegionIndex] + "</option>");
                        $($("select[id^=compareSiteSelect]")[a]).val(selectedRegionID[selectedRegionIndex]);
                        selectedRegionIndex++;
                    }
                    selectedModeIndex++;
                }
            }
            InitSelect2($("select[id^=selector], .counterBranch"), "", 0, 0);
        }
        else {
            $.when(loadRegionAjax(comCode), loadSiteAjax(comid, comCode)).done(function (a1, a2) {
                pass = true;
                populateSiteSelector($("#selectorSite, select[id^=compareSiteSelect]"), sites, regions);
                if (selectedMode[selectedModeIndex] == "site" || selectedMode[selectedModeIndex] == "counter") {
                    $("#selectorSite").val(branchID[branchIndex]);
                    if (selectedMode[selectedModeIndex] == "counter") {
                        var counterAjax = loadCounterAjax(branchID[branchIndex]);
                        loadCounterAjaxHold(counterAjax, camID[camIndex]);
                        camIndex++;
                    }
                    branchIndex++;
                }
                else if (selectedMode[selectedModeIndex] == "region") {
                    $("#selectorSite").val(selectedRegionID[selectedRegionIndex]);
                    selectedRegionIndex++;
                }

                selectedModeIndex++;

                if (selectedModeIndex < selectedModeLength) {
                    $("#toggleCompare").attr("checked", true);
                    $("#compareGroup").show();
                    $("#radio-compare-site").click();
                    if (selectedMode.lastIndexOf("counter") == 0) {
                        pass2 = true;
                    }
                    for (var a = 0; a < selectedModeLength - 1; a++) {
                        if (selectedMode[selectedModeIndex] == "counter" || selectedMode[selectedModeIndex] == "site") {
                            $($("select[id^=compareSiteSelect]")[a]).val(branchID[branchIndex]);
                            if (selectedMode[selectedModeIndex] == "counter") {
                                var ajaxPerform = loadCounterAjax(branchID[branchIndex]);
                                loadCompareCounterAjax(ajaxPerform, a, camID[camIndex], selectedModeIndex, function (s) {
                                    if (s == selectedMode.lastIndexOf("counter"))
                                        pass2 = true;
                                });
                                camIndex++;
                            }
                            branchIndex++;
                        }
                        else if (selectedMode[selectedModeIndex] == "region") {
                            $($("select[id^=compareSiteSelect]")[a]).val(selectedRegionID[selectedRegionIndex]);
                            selectedRegionIndex++;
                        }
                        selectedModeIndex++;
                    }
                }
                else {
                    pass2 = true;
                }
            });
        }
    }
    else {
        pass = true;
        pass2 = true;
    }

    var dateFormatString = dateFormat == "dateFirst" ? "DD/MM/YYYY" : dateFormat == "monthFirst" ? "MM/DD/YYYY" : dateFormat.toLowerCase();

    if (model.start != "") {
        var date = model.start.split(',');
        var enddate = model.end.split(',');
        //$("input[name=compare-with-selection]:checked").val("metric").change();

        if (date.length > 1) {
            $("#toggleCompare").attr("checked", true);
            $("#radio-compare-time").click();
        }


        for (var a = 0; a < date.length; a++) {
            //$($("input[id*='start']")[a]).val(date[a]).change();
            $($("input[id*='start']")[a]).datepicker({ format: dateFormatString.toLowerCase() }).datepicker("setDate", moment(date[a], dateFormatString).toDate());
            //console.log($($("input[id*='end']")[a]).val());
        }
        for (var a = 0; a < enddate.length; a++) {
            //$($("input[id*='end']")[a]).val(enddate[a]);
            $($("input[id*='end']")[a]).datepicker({ format: dateFormatString.toLowerCase() }).datepicker("setDate", moment(enddate[a], dateFormatString).toDate());
        }
        //$($("input[id*='end']")[0]).val(enddate[0]).change();
    }
    if (model.range == "1")
        $("#radio-hour").click();
    else if (model.range == "2")
        $("#radio-day").click();
    else if (model.range == "3")
        $("#radio-week").click();

    $("#toggleCompare").change();
    if (!isGeneratePDF) {
        var checkAjax = setInterval(function () {
            //console.log(pass, pass2, selectedModeIndex, selectedModeLength, camIndex, camLength, branchIndex, branchLength, selectedRegionIndex, selectedRegionLength);
            if (pass && pass2 && selectedModeIndex == selectedModeLength && camIndex == camLength && branchIndex == branchLength && selectedRegionIndex == selectedRegionLength) {
                InitSelect2($("#selectorCompany"), "", 0, 0);
                InitSelect2($("select[id^=compareSiteSelect]"), LanguageSelectASite, 0, 0);
                InitSelect2($("select[id^=compareCounterSelect]"), LanguageSelectACounter, 0, 0);
                InitSelect2($("#selectorSite"), "", 0, 0);
                setChart();
                clearInterval(checkAjax);
            }
        }, 150);
    }
    else
        setChart();
}

//To do callback function when waiting for the ajax to complete[Kelvin Yap]
function loadCompareCounterAjax(ajax, a, camID, index, callback) {
    ajax.done(function (a1) {
        var storelist = [];
        storelist = a1;
        populateCounterSelector($($("select[id^=compareCounterSelect]")[a]), storelist);
        $($("select[id^=compareCounterSelect]")[a]).val(camID);
        InitSelect2($($("select[id^=compareCounterSelect]")[a]), LanguageSelectASite, 0, 0);
        callback(index);
    });
}

function loadCounterAjaxHold(ajax, camID) {
    ajax.done(function (a1) {
        populateCounterSelector($("#selectorCounter"), stores);
        $("#selectorCounter").val(camID);
        InitSelect2($("#selectorCounter"), "", 0, 0);
    });
}

function InitializeTable(data, num, total, dateStart, dateEnd) {
    var tableRowAll = [];
    var tableRow = "";
    var compare = total > 1 ? true : false;
    var numOfClosed = 0;
    var period = $("input[name=data-selection]:checked").val();


    for (var x = 0; x < data.length; x++) {
        //def x means how many comparisons
        var toRet = manualMapData(data, 'data', num)[x] == null ? 0 : manualMapData(data, 'data', num)[x] < 0 ?
            LanguageClosed : numberify(manualMapData(data, 'data', num)[x]);
        //console.log(num, x, toRet);
        if (toRet == LanguageClosed) 
            numOfClosed++;
        var compareWith = $("input[name=compare-with-selection]:checked").val();
        var Header = "";

        if (!compare || total == 1) {
            Header = $("#pmSelector :selected[value='103']").text() != "" || $("#pmSelector :selected[value='206']").text() != "" || $("#pmSelector :selected[value='311']").text() != ""
                ? ($("#pmSelector :selected").text() + " (%)")
                : $("#pmSelector :selected").text();
        }
        else {
            if (compareWith == "metric") {
                Header = $($(".MetricSelect :selected[value!='']")[num]).val() == "103" || $($(".MetricSelect :selected[value!='']")[num]).val() == "206" || $($(".MetricSelect :selected[value!='']")[num]).val() == "311"
                    ? $($(".MetricSelect :selected[value!='']")[num]).html() + " (%)"
                    : $($(".MetricSelect :selected[value!='']")[num]).html();
            }
            else if (compareWith == "site") {
                if (num == 0) {
                    Header = $("#selectorCounter").val() != "" && typeof ($("#selectorCounter").val()) !== 'undefined' && $("#selectorCounter").val() != "-" ?
                        $("#selectorCounter :selected").text() :
                        $("#selectorSite").val() != "" && $("#selectorSite").val() != null ?
                            $("#selectorSite :selected").text() :
                            (companies.length < 2) ?
                                LanguageAllSites :
                                $("#selectorCompany").val() != "" ?
                                    $("#selectorCompany :selected").text() :
                                    LanguageAllSites;
                }
                else {
                    Header = $($("select[id^=compareSiteSelect] :selected:not([value=''])")[num - 1]).hasClass("opt-region") ?
                        $($("select[id^=compareSiteSelect] :selected:not([value=''])")[num - 1]).text() :
                        $($("select[id^=compareSiteSelect] :selected:not([value=''])")[num - 1]).parent().siblings("select[id^=compareCounterSelect]").val() != "" && $($("select[id^=compareSiteSelect] :selected:not([value=''])")[num - 1]).parent().siblings("select[id^=compareCounterSelect]").val() != undefined && $($("select[id^=compareSiteSelect] :selected:not([value=''])")[num - 1]).parent().siblings("select[id^=compareCounterSelect]").val() != "-" ?
                            $($("select[id^=compareSiteSelect] :selected:not([value=''])")[num - 1]).parent().siblings("select[id^=compareCounterSelect]").children(":selected").text() :
                            $($("select[id^=compareSiteSelect] :selected:not([value=''])")[num - 1]).text();
                }
            }
            else {
                if (dateStart[num] != dateEnd[num])
                    Header = dateStart[num] + " - " + dateEnd[num];
                else
                    Header = dateStart[num];
            }
        }

        if (compareParam[num].substring(0, 3) == "205" && !compare) {
            var data1 = manualMapData(data, 'data', num, "1")[x] == null ? 0 : manualMapData(data, 'data', num, "1")[x];
            var data2 = manualMapData(data, 'data', num, "2")[x] == null ? 0 : manualMapData(data, 'data', num, "2")[x];
            var data3 = manualMapData(data, 'data', num, "3")[x] == null ? 0 : manualMapData(data, 'data', num, "3")[x];

            var minThreshold = 15;
            var maxThreshold = 30;

            if ($("#typeSelector").val() == "area") {
                minThreshold = data[0].MinDwellThreshold;
                maxThreshold = data[0].MaxDwellThreshold;
            }

            if (x == 0) {
                if (period == "2")
                    num == 0 ? $("#dataTable" + model.Dashboard).html($("#dataTable" + model.Dashboard).html() + "<table><tr id='appendHeader'><th>" + LanguageDate + `</th><th>< ${minThreshold} ` + LanguageMins + `</th><th> ${minThreshold}-${maxThreshold} ` + LanguageMins + `</th><th>> ${maxThreshold} ` + LanguageMins + "</th><th>" + LanguageDayTotal + "</th></tr>") : $("#appendHeader").append("<th colspan='2'>" + Header + "</th>");

                else if (period == "1")
                    num == 0 ? $("#dataTable" + model.Dashboard).html($("#dataTable" + model.Dashboard).html() + "<table><tr id='appendHeader'><th>" + LanguageHour + `</th><th>< ${minThreshold} ` + LanguageMins + `</th><th> ${minThreshold}-${maxThreshold} ` + LanguageMins + `</th><th>> ${maxThreshold} ` + LanguageMins + "</th><th>" + LanguageDayTotal + "</th></tr>") : $("#appendHeader").append("<th>" + Header + "</th>");

                else if (period == "3")
                    num == 0 ? $("#dataTable" + model.Dashboard).html($("#dataTable" + model.Dashboard).html() + "<table><tr id='appendHeader'><th>" + LanguageWeek + `</th><th>< ${minThreshold} ` + LanguageMins + `</th><th> ${minThreshold}-${maxThreshold} ` + LanguageMins + `</th><th>> ${maxThreshold} ` + LanguageMins + "</th><th>" + LanguageDayTotal + "</th></tr>") : $("#appendHeader").append("<th>" + Header + "</th>");
            }

            num == 0 && !compare ? $("#dataTable" + model.Dashboard).html($("#dataTable" + model.Dashboard).html() + "<tr id='appendBody" + x + "'><td>" + data[x].Datetime + "</td><td>" + numberify(data1) + "</td><td>" + numberify(data2) + "</td><td>" + numberify(data3) + "</td><td>" + numberify(data1 + data2 + data3) + "</td></tr>") : $("#appendBody" + x).append("<td>" + numberify(data1) + "</td><td>" + numberify(data2) + "</td><td>" + numberify(data3) + "</td><td>" + numberify(data1 + data2 + data3) + "</td>");

        } else if (compareParam[num].substring(0, 3) == "206" && !compare || compareParam[num].substring(0, 3) == "206" && compareParam.length == 1) {
            var data1 = manualMapData(data, 'data', num, "1")[x] == null ? 0 : manualMapData(data, 'data', num, "1")[x];
            var data2 = manualMapData(data, 'data', num, "2")[x] == null ? 0 : manualMapData(data, 'data', num, "2")[x];


            if (x == 0) {
                if (period == "2") {
                    num == 0 ? $("#dataTable" + model.Dashboard).html($("#dataTable" + model.Dashboard).html() + "<table><tr id='appendHeader'><th>" + LanguageDate + "</th><th>" + LanguageReturningCustomer + " (%)</th><th>" + LanguageNewCustomer + " (%)</th></tr>") : $("#appendHeader").append("<th>" + Header + "</th>");
                }
                else if (period == "1")
                    num == 0 ? $("#dataTable" + model.Dashboard).html($("#dataTable" + model.Dashboard).html() + "<table><tr id='appendHeader'><th>" + LanguageHour + "</th><th>" + LanguageReturningCustomer + " (%)</th><th>" + LanguageNewCustomer + " (%)</th></tr>") : $("#appendHeader").append("<th>" + Header + "</th>");
                else if (period == "3")
                    num == 0 ? $("#dataTable" + model.Dashboard).html($("#dataTable" + model.Dashboard).html() + "<table><tr id='appendHeader'><th>" + LanguageWeek + "</th><th>" + LanguageReturningCustomer + " (%)</th><th>" + LanguageNewCustomer + " (%)</th></tr>") : $("#appendHeader").append("<th>" + Header + "</th>");


            }
            num == 0 ? $("#dataTable" + model.Dashboard).html($("#dataTable" + model.Dashboard).html() + "<tr id='appendBody" + x + "'><td>" + data[x].Datetime + "</td><td>" + numberify(data1) + "</td><td>" + numberify(data2) + "</td></tr>") : $("#appendBody" + x).append("<td>" + numberify(data1) + "</td><td>" + numberify(data2) + "</td>");

            if (x == (data.length - 1)) {
                //  var checkZero = manualMapData(data, 'data', num).length == 0 ? [0, 0] : manualMapData(data, 'data', num);
                var data1 = manualMapData(data, 'data', num, "1")[x] == null ? 0 : manualMapData(data, 'data', num, "1");
                var data2 = manualMapData(data, 'data', num, "2")[x] == null ? 0 : manualMapData(data, 'data', num, "2");

                var aveReturn = Math.round(numberify((Math.round(data1.reduce(getSum)) + numOfClosed)) / (data.length - numOfClosed) * 100) / 100;
                var aveNew = Math.round(numberify((Math.round(data2.reduce(getSum)) + numOfClosed)) / (data.length - numOfClosed) * 100) / 100;

                num == 0 ? $("#dataTable" + model.Dashboard).html($("#dataTable" + model.Dashboard).html() + "<tr id='appendBodyMax'><th>" + LanguageAverage + "</th><td>" + aveReturn + "</td><td>" + aveNew + "</td></tr>") : $("#appendBodyMax").append("<td>" + aveReturn + "</td><td>" + aveNew + "</td>");
            }
        }
            //Check here
        else {
            if (x == 0) {
                if (period == "2") {
                    num == 0 ?
                        (compare && compareWith == "time" ?
                            $("#dataTable" + model.Dashboard).html($("#dataTable" + model.Dashboard).html() + "<table><tr id='appendHeader'><th colspan='2'>" + Header + "</th></tr>")
                            : $("#dataTable" + model.Dashboard).html($("#dataTable" + model.Dashboard).html() + "<table><tr id='appendHeader'><th>" + LanguageDate + "</th><th>" + Header + "</th></tr>")
                        )
                        : (compareWith == "time" && compare ?
                            $("#appendHeader").append("<th colspan='2'>" + Header + "</th>")
                            : $("#appendHeader").append("<th>" + Header + "</th>")
                        );
                }

                else if (period == "1") {
                    num == 0 ?
                        (compare && compareWith == "time" ?
                            $("#dataTable" + model.Dashboard).html($("#dataTable" + model.Dashboard).html() + "<table><tr id='appendHeader'><th colspan='2'>" + Header + "</th></tr>")
                            : $("#dataTable" + model.Dashboard).html($("#dataTable" + model.Dashboard).html() + "<table><tr id='appendHeader'><th>" + LanguageHour + "</th><th>" + Header + "</th></tr>")
                        )
                        : (compareWith == "time" && compare ?
                            $("#appendHeader").append("<th colspan='2'>" + Header + "</th>")
                            : $("#appendHeader").append("<th>" + Header + "</th>")
                        );
                }
                else if (period == "3") {
                    num == 0 ?
                        (compare && compareWith == "time" ?
                            $("#dataTable" + model.Dashboard).html($("#dataTable" + model.Dashboard).html() + "<table><tr id='appendHeader'><th colspan='2'>" + Header + "</th></tr>")
                            : $("#dataTable" + model.Dashboard).html($("#dataTable" + model.Dashboard).html() + "<table><tr id='appendHeader'><th>" + LanguageWeek + "</th><th>" + Header + "</th></tr>")
                        ) : (compareWith == "time" && compare ?
                            $("#appendHeader").append("<th colspan='2'>" + Header + "</th>")
                            : $("#appendHeader").append("<th>" + Header + "</th>")
                        );
                }

            }
            num == 0 ?
                $("#dataTable" + model.Dashboard).html($("#dataTable" + model.Dashboard).html() + "<tr id='appendBody" + x + "'><td>" + data[x].Datetime  + "</td><td>" + toRet + "</td></tr>")
                : (compareWith == "time" && compare ? $("#appendBody" + x).append("<td>" + data[x].Datetime  + "</td><td>" + toRet + "</td>") : $("#appendBody" + x).append("<td>" + toRet + "</td>"));

            //console.log(numOfClosed);
            if (x == (data.length - 1)) {
                var checkZero = manualMapData(data, 'data', num).length == 0 ? [0, 0] : manualMapData(data, 'data', num);
                var totalValue = (compareParam[num].substring(0, 3) == "101" || compareParam[num].substring(0, 3) == "102" || compareParam[num].substring(0, 3) == "104" )
                    ? numberify((Math.round(checkZero.reduce(getSum)) + numOfClosed))
                    : ( compareParam[num].substring(0, 3) == "311")
                        ? Math.round(numberify(((checkZero.reduce(getSum)) + numOfClosed) / (data.length - numOfClosed) * 100.0) / 100.0)
                        :(compareParam[num].substring(0, 3) == "103" || compareParam[num].substring(0, 3) == "206") // if the filter was comparing "turnin" rate (103_?) //208 is "avg visitng duration"//206 is the returning cust rate
                            ? numberify(((checkZero.reduce(getSum)) + numOfClosed) / (data.length - numOfClosed))
                            : (compareParam[num].substring(0, 3) == "208") // give the time values in format of Hours and minutes and seconds where available
                                ? timify(((checkZero.reduce(getSum)) + numOfClosed) / (data.length - numOfClosed))
                            : "-";
                //console.log((compareParam[num].substring(0, 3) == "208") ? "CHECKZERO is: " + timify(((checkZero.reduce(getSum)) + numOfClosed) / (data.length - numOfClosed)) + " while numerifying is: " + numberify(((checkZero.reduce(getSum)) + numOfClosed) / (data.length - numOfClosed)) : "Not available in: " + compareParam[num].substring(0, 3));
                //ok  console.log("test timify1:  " + timify(12));
                //ok console.log("test timify2:  " + timify(120));
                //ok console.log("test timify3:  " + timify(165.123));
                //ok console.log("test timify4:  " + timify(199.47123433454243));
                //ok console.log("test timify5:  " + timify(745.3216)); 12 Hours 25 Minutes 19 Seconds
                //ok  console.log("test timify6:  " + timify(0.157585678567));
                var checkTotalOrAverage = [0, 0];
   

                compareParam.forEach(function (param) {
                    if (param.substring(0, 3) == "101" || param.substring(0, 3) == "102" || param.substring(0, 3) == "104" )
                        checkTotalOrAverage[0] = 1;
                    else if (param.substring(0, 3) == "103" || param.substring(0, 3) == "206" || param.substring(0, 3) == "208" || param.substring(0, 3) == "311")
                        checkTotalOrAverage[1] = 1;
                });

                var totalOrAverage = checkTotalOrAverage[0] == 1 && checkTotalOrAverage[1] == 1
                    ? LanguageTotal + " / " + LanguageAverage
                    : checkTotalOrAverage[0] == 0 && checkTotalOrAverage[1] == 1
                        ? LanguageAverage
                        : LanguageTotal;

                if (compareParam.length > 1) {
                    num == 0 ?
                        $("#dataTable" + model.Dashboard).html($("#dataTable" + model.Dashboard).html() + "<tr id='appendBodyMax'><th>" + totalOrAverage + "</th><td>" + totalValue + "</td></tr>")
                        : (compare && compareWith == "time" ?
                            $("#appendBodyMax").append("<td></td><td>" + totalValue + "</td>")
                            : $("#appendBodyMax").append("<td>" + totalValue + "</td>")
                        );
                }
                else {
                    num == 0 && totalValue != "-" ? $("#dataTable" + model.Dashboard).html($("#dataTable" + model.Dashboard).html() + "<tr id='appendBodyMax'><th>" + totalOrAverage + "</th><td>" + totalValue + "</td></tr>") : $("#appendBodyMax").append("<td>" + totalValue + "</td>");
                }
            }
        }
    }
}

function InitializeGraph(date, charts, colorScheme, chartType, isCompare, compareWith) {

    var chartColors = $.map(colorScheme.analytics.chart.stackColumn.color, function (value, index) {
        return [value];
    });

    var colorr = [];
    colorr.push("rgba(18, 179, 148, 0.5)");
    //var thisData = mapData(data);
    $(function () {
        var xAxisTitle = $("input[name=data-selection]:checked").val() == "1"
            ? LanguageHour
            : $("input[name=data-selection]:checked").val() == "2"
                ? LanguageDate
                : LanguageWeek;
        var dwellTime = new Highcharts.Chart({
            chart: {
                renderTo: "dayreport" + model.Dashboard,
                type: chartType,
                width: 760,
                events: {
                    load: function (event) {
                        $("#container").removeClass("chartLoading");
                    }
                }
            },
            colors: colorr,
            title: {
                text: null,
            },
            xAxis: {
                categories: date,
                lineWidth: 1,
                title: {
                    text: xAxisTitle,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 4,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                },
                scrollbar: {
                    enabled: false
                },
                crosshair: true
            },
            yAxis: yAxis,
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                align: 'center',
                verticalAlign: 'top',
                layout: 'horizontal',
                x: 0,
                y: -15,
            },
            tooltip: {
                formatter: function () {
                    if (isCompare == true) {
                        switch (compareWith) {
                            case "site":
                                return this.points.reduce(function (s, point) {
                                    return s + '<br/>' + point.series.name + ': <b>' +
                                        point.y + '</b>';
                                }, this.x);
                            case "time":
                      
                                return this.points.reduce(function (s, point) {
                                    return s + '<br/>' + point.series.name + ': <b>' +
                                        point.y + '</b>';
                                }, yAxis[0].title.text);
                            default:
                                return this.points.reduce(function (s, point) {
                                    return s + '<br/>' + point.series.name + ': <b>' +
                                        point.y + '</b>';
                                }, this.x);
                        }
                    }
                    return this.points.reduce(function (s, point) {
                        return s + '<br/>' + point.series.name + ': <b>' +
                            point.y + '</b>';
                    }, this.x);
                },
                shared: true
                //formatter: function () {
                //    return LanguageReturningCustomer + '<br/>' + this.x + '<br/>' +
                //        this.series.name + ': ' + this.y + '<br/>' +
                //        LanguageTotal + ': ' + this.point.stackTotal;
                //}
            },
            plotOptions: chartType == "column" && (model.parameter == "101" || model.parameter == "102") && model.range != "1" ? {
                column: {
                    stacking: 'normal',
                    cursor: 'pointer',
                    point: {
                        events: {
                            click: function () {
                                var tempDateFormat = dateFormat == "monthFirst" ? "MM/DD/YY" : "DD/MM/YY";

                                if (model.range == "2") {
                                    var selectedStartDate = this.category.name.split(' ')[0];

                                    $('#startDate').val(moment(selectedStartDate, tempDateFormat).format(dateFormat == "dateFirst" ? "DD/MM/YYYY" : dateFormat == "monthFirst" ? "MM/DD/YYYY" : dateFormat.toLowerCase()));

                                    $("#radio-hour").click();

                                    setChart();
                                }
                                else if (model.range == "3") {
                                    var splitedDate = this.category.name.split(' ');

                                    var selectedStartDate = splitedDate[splitedDate.length - 1].replace('(', '').replace(')', '');

                                    $('#startDate').val(moment(selectedStartDate, tempDateFormat).format(dateFormat == "dateFirst" ? "DD/MM/YYYY" : dateFormat == "monthFirst" ? "MM/DD/YYYY" : dateFormat.toLowerCase()));
                                    $('#endDate').val(moment(selectedStartDate, tempDateFormat).add(6, 'days').format(dateFormat == "dateFirst" ? "DD/MM/YYYY" : dateFormat == "monthFirst" ? "MM/DD/YYYY" : dateFormat.toLowerCase()));

                                    $("#radio-day").click();

                                    setChart();
                                }
                            }
                        }
                    },
                    dataLabels: {
                        enabled: false,
                        color: (Highcharts.theme && Highcharts.theme.dataLabelsColor) || 'white',
                        style: {
                            textShadow: '0 0 3px black, 0 0 3px black'
                        }
                    }
                }
            } : {
                    column: {
                        stacking: 'normal',
                        dataLabels: {
                            enabled: false,
                            color: (Highcharts.theme && Highcharts.theme.dataLabelsColor) || 'white',
                            style: {
                                textShadow: '0 0 3px black, 0 0 3px black'
                            }
                        }
                    }
                },
            credits: {
                enabled: false
            },
            series: charts,
            exporting: {
                enabled: false,
            }
        });
    });
}

function getSum(total, num) {
    return total + num;
}

function manualMapData(data, map, num, dataLevel) {
    var toRet = [];
    for (var x = 0; x < data.length; x++) {
        //console.log(map);
        if (map != 'datetime') {
            if (compareParam[num].substring(0, 3) == 101)
                toRet.push(data[x].ValueIn);
            else if (compareParam[num].substring(0, 3) == 102)
                toRet.push(data[x].ValueOut);
            else if (compareParam[num].substring(0, 3) == 103)
                toRet.push(data[x].TurnInRate);
            else if (compareParam[num].substring(0, 3) == 104)
                toRet.push(data[x].OutsideTraffic);
            else if (compareParam[num].substring(0, 3) == 205) {
                if (dataLevel == "1")
                    toRet.push(data[x].VisitDuration15);
                if (dataLevel == "2")
                    toRet.push(data[x].VisitDuration30);
                if (dataLevel == "3")
                    toRet.push(data[x].VisitDurationOver);
            }
            else if (compareParam[num].substring(0, 3) == 206) {
                if (dataLevel == "1")
                    toRet.push(data[x].ReturningCust);
                else if (dataLevel == "2")
                    toRet.push(data[x].NewCust);
                else
                    toRet.push(data[x].ReturningCust);
            }
            else if (compareParam[num].substring(0, 3) == 207)
                toRet.push(data[x].ReturningCustomer);
            else if (compareParam[num].substring(0, 3) == 208)
                toRet.push(data[x].AverageVisitDuration);
            else if (compareParam[num].substring(0, 3) == 309)
                toRet.push(data[x].TotalSales);
            else if (compareParam[num].substring(0, 3) == 310)
                toRet.push(data[x].AverageSalesVolume);
            else if (compareParam[num].substring(0, 3) == 311)
                toRet.push(data[x].SalesConversion);
            else if (compareParam[num].substring(0, 3) == 312)
                toRet.push(data[x].TransactionCount);
        }
        else {
            toRet.push(data[x].Datetime);
        }
    }
    return toRet;
}

function initializeModel() {
    var compare = $("#toggleCompare").attr("checked") == undefined ? false : true;
    var compareWith = $("input[name=compare-with-selection]:checked").val();
    var dateLength = compare == false ? 1 : compareWith != "time" ? 1 : $("input[id*='start']").length;
    var siteLength = compare == false ? 1 : compareWith != "site" ? 1 : $("select[id^=compareSiteSelect]").length + 1;
    var metricLength = compare == false ? 1 : compareWith != "metric" ? 1 : $(".MetricSelect").length;

    for (var x = 0; x < dateLength; x++) {
        //start date
        var val = $($("input[id*='start']")[x]).val();
        if (x == 0)
            model.start = "";
        if (val != "")
            model.start = model.start + val + ",";

        //end date
        var val = $($("input[id*='end']")[x]).val();
        if (x == 0)
            model.end = "";
        if (val != "")
            model.end = model.end + val + ",";

        if (x == dateLength - 1) {
            model.start = model.start.substring(0, model.start.length - 1);
            model.end = model.end.substring(0, model.end.length - 1);
        }
    }
    for (var x = 0; x < siteLength; x++) {
        var val = "";
        var category = "";

        if (x == 0) {
            model.cameraId = "";
            model.branchId = "";
            model.selectedRegionID = "";
            model.companyid = "";
            model.selectedMode = "";
        }

        if (x == 0) {
            if (companies.length > 1) {
                if ($("#selectorCompany").val() != "") {
                    model.companyid = $("#selectorCompany").val();
                }
            }
            model.selectedMode = "company,";
            if ($("#selectorSite").val() == "") {
                model.branchId = ",";
            }
            else {
                if ($("#selectorSite :selected").hasClass('opt-branch')) {
                    model.branchId = $("#selectorSite").val() + ","
                    model.selectedMode = "site,";
                }
                else {
                    model.selectedRegionID = $("#selectorSite").val() + ",";
                    model.selectedMode = "region,";
                }
            }
            model.selectedMode = $("#selectorCounter").val() == "" ?
                model.selectedMode : "counter,";
            model.cameraId = $("#selectorCounter").val() == "" ? "," : $("#selectorCounter").val() + ",";
        }
        else {                              //Compare Section
            if ($($("select[id^=compareSiteSelect]")[x - 1]).val() == "" || $($("select[id^=compareSiteSelect]")[x - 1]).val() == null) {
                val = null;
            }
            else {
                val = $($("select[id^=compareSiteSelect]")[x - 1]).val() == "" ?
                    null : $($("select[id^=compareSiteSelect]")[x - 1]).find(":selected").hasClass("opt-region") ?
                        $($("select[id^=compareSiteSelect]")[x - 1]).val() : $($("select[id^=compareSiteSelect]")[x - 1]).siblings("select[id^=compareCounterSelect]").val() == "" || $($("select[id^=compareSiteSelect]")[x - 1]).siblings("select[id^=compareCounterSelect]").val() == null || $($("select[id^=compareSiteSelect]")[x - 1]).siblings("select[id^=compareCounterSelect]").val() == "-" ?
                            $($("select[id^=compareSiteSelect]")[x - 1]).val() : $($("select[id^=compareSiteSelect]")[x - 1]).siblings("select[id^=compareCounterSelect]").val();

                category = $($("select[id^=compareSiteSelect]")[x - 1]).find(":selected").hasClass("opt-region") ?
                    "region" : $($("select[id^=compareSiteSelect]")[x - 1]).siblings("select[id^=compareCounterSelect]").val() != "" && $($("select[id^=compareSiteSelect]")[x - 1]).siblings("select[id^=compareCounterSelect]").val() != null && $($("select[id^=compareSiteSelect]")[x - 1]).siblings("select[id^=compareCounterSelect]").val() != "-" ?
                        "cam" : "site";
            }

            if (category == "cam" && val != null) {
                var val2 = $($("select[id^=compareSiteSelect]")[x - 1]).val();
                if (model.cameraId == ",")
                    model.cameraId = val + ",";
                else
                    model.cameraId = model.cameraId + val + ",";
                if (model.branchId == ",")
                    model.branchId = val2 + ",";
                else
                    model.branchId = model.branchId + val2 + ",";
                model.selectedMode = model.selectedMode + "counter,";
            }
            else if (category == "site" && val != null) {
                if (model.branchId == ",")
                    model.branchId = val + ",";
                else
                    model.branchId = model.branchId + val + ",";
                model.selectedMode = model.selectedMode + "site,";
            }
            else if (category == "region" && val != null) {
                model.selectedRegionID = model.selectedRegionID + val + ",";
                model.selectedMode = model.selectedMode + "region,";
            }
            else {
                model.selectedMode = model.selectedMode + ",";
            }
        }

        if (x == siteLength - 1) {
            model.cameraId = model.cameraId.substring(0, model.cameraId.length - 1);
            model.branchId = model.branchId.substring(0, model.branchId.length - 1);
            model.selectedRegionID = model.selectedRegionID.substring(0, model.selectedRegionID.length - 1);
            model.selectedMode = model.selectedMode.substring(0, model.selectedMode.length - 1);
        }
    }
    for (var x = 0; x < metricLength; x++) {
        var val = $($(".MetricSelect")[x]).val();

        if (x == 0) {
            model.parameter = "";
        }
        if (val != null)
            model.parameter = model.parameter + val + ",";

        if (x == metricLength - 1) {
            model.parameter = model.parameter.substring(0, model.parameter.length - 1);
        }
    }

    var periodNow = $("input[name=data-selection]:checked").val();
    model.range = periodNow;
    if (periodNow == "1")
        $("#radio-hour").click();
    else if (periodNow == "2")
        $("#radio-day").click();
    else if (periodNow == "3")
        $("#radio-week").click();
}

function getDateOfWeek(w, y) {
    var d = (1 + (w - 1) * 7); // 1st of January + 7 days for each week

    return new Date(y, 0, d);
}

function exportTableToCSV(filename) {
    var csv = [];
    var rows = document.querySelectorAll("table tr");

    for (var i = 0; i < rows.length; i++) {
        var row = [], cols = rows[i].querySelectorAll("td, th");

        for (var j = 0; j < cols.length; j++)
            row.push('"' + cols[j].innerText.replace(',', '') + '"');

        csv.push(row.join(","));
    }

    // Download CSV file
    downloadCSV(csv.join("\n"), filename);
}

function downloadCSV(csv, filename) {
    var csvFile;
    var downloadLink;
    var BOM = String.fromCharCode(0xFEFF);
    csv = BOM + csv;
    // CSV file
    csvFile = new Blob([csv], { type: "text/csv;charset=UTF-8" });

    // Download link
    downloadLink = document.createElement("a");

    // File name
    downloadLink.download = filename;

    // Create a link to the file
    downloadLink.href = window.URL.createObjectURL(csvFile);

    // Hide download link
    downloadLink.style.display = "none";

    // Add the link to DOM
    document.body.appendChild(downloadLink);

    // Click download link
    try {
        downloadLink.click();
    } catch (e) {
        navigator.msSaveBlob(csvFile, "data.csv"); // handle IE
    }
}

function addDashboard() {
    var Addusergroup = LanguageAddtoDashboard;
    var alertBodyContent = '<p>' + LanguageConfirmAddToDashboard + ' ? </p><p>' + LanguageConfirmAddToDashboard + ' ? </p>';

    var alertFooter = "<button class='btn not-primary-button' data-dismiss='modal'>" + LanguageClose + "</button>&nbsp;&nbsp;<button class='general-button' data-dismiss='modal' id='confirmAddUser'>" + LanguageAdd + "</button>";
    prompt(Addusergroup, alertBodyContent, alertFooter);
}

function shareLink() {
    var json = JSON.stringify(encodeURIComponent($("#report").html()));
    $.ajax({
        type: "POST",
        url: "/FootfallCam/saveExtReport",
        data: { html: json },
        success: function () {

        }
    })
}

function noCounterFoundPrompt(branchId) {
    var urlParam = GetURLParam();
    var LeftSideBarNavigationHighlight = GetNavHighlight(urlParam);
    var body =
        '<p>' + LanguageNoCounterRegisteredUnderSelectedSite + '. '
        + '<br>'
        + '<br>- ' + LanguageDoYouWantToAddNewCounter + '? - ' + LanguageToAddNewCounterGoTo + ' ' + '<a href="/FootfallCam/AllocateCounter?branchID=' + branchId + LeftSideBarNavigationHighlight + '">' + LanguageAddCounterPage + '...</a>'
        + '<br>- ' + LanguageDoYouWantToRemoveThisSite + '? - ' + LanguageToRemoveGoTo + ' ' + '<a href="/FootfallCam/ConfigureSite?branchID=' + branchId + LeftSideBarNavigationHighlight + '">' + LanguageConfigureSitePage + '...</a>'
        + '</p>';
    promptWarningPanel(body, true);
}

function noAreaFoundPrompt(branchId) {
    var urlParam = GetURLParam();
    var LeftSideBarNavigationHighlight = GetNavHighlight(urlParam);
    var body =
        '<p>' + LanguageThisSiteIsNotConfiguredWithAnyArea + '. '
        + '<br>'
        + '<br>- ' + LanguageDoYouWantToConfigureAreaForThisSite + '? - ' + LanguageToConfigureAreaGoTo + ' ' + '<a href="/FootfallCam/EditAreaConfiguration/' + branchId + '?' + LeftSideBarNavigationHighlight + '">' + LanguageConfigureAreaPage + '...</a>'
        + '<br>- ' + LanguageDoYouWantToRemoveThisSite + '? - ' + LanguageToRemoveGoTo + ' ' + '<a href="/FootfallCam/ConfigureSite?branchID=' + branchId + LeftSideBarNavigationHighlight + '">' + LanguageConfigureSitePage + '...</a>'
        + '</p>';
    promptWarningPanel(body, true);
}