﻿function chartLoading() {


}

function numberWithCommas(x) {
    return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
}

function drawTopMatricGraph(topMatricGraphId, data, colorScheme) {
    $(function() {
        Highcharts.setOptions({
            global: {
                useUTC: false
            }
        });

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: topMatricGraphId,
                margin: [0, 0, 0, 0],
                backgroundColor: 'transparent'
            },
            title: {
                text: ''
            },
            credits: {
                enabled: false
            },
            xAxis: {
                labels: {
                    enabled: false
                }
            },
            yAxis: {
                maxPadding: 0,
                minPadding: 0,
                gridLineWidth: 0,
                endOnTick: false,
                labels: {
                    enabled: false
                },
            },
            legend: {
                enabled: false
            },
            tooltip: {
                enabled: false
            },
            plotOptions: {
                series: {
                    enableMouseTracking: false,
                    lineWidth: 1,
                    shadow: false,
                    states: {
                        hover: {
                            lineWidth: 1
                        }
                    },
                    marker: {
                        radius: 0,
                        states: {
                            hover: {
                                radius: 2
                            }
                        }
                    }
                }
            },
            exporting: {
                enabled: false,
            },
            series: [{
                type: 'areaspline',
                data: data,
                color: colorScheme.chart.sparkLine.color,
                fillOpacity: 0.5
            }]
        });
    });

}

function bindData(data, colorScheme) {
    bindTopMatric(data[0].series[0], colorScheme);
    bindFootfallHourlyTrend(data[1], colorScheme);
    bindCompanyDailyTable2(data[2]);
}

//top matric
function bindTopMatric(data, colorScheme) {
    bindFootfallTopMatric(data, colorScheme);
    bindTurnInRateTopMatric(data, colorScheme);
    bindVisitdurationTopMatric(data, colorScheme);
    bindReturningRateTopMatric(data, colorScheme);
    bindSalesConversionTopMatric(data, colorScheme);
}

//data = data[1]
function bindFootfallTopMatric(data, colorScheme) {
    $('#totalVisitorThisWeek').empty();
    $('#totalVisitorUpDownPercent').removeClass('rise');
    $('#totalVisitorUpDownPercent').removeClass('drop');
    $('#totalVisitorUpDownPercent').empty();
    $('#FFGraph').empty();


    footfall = data.visitorTotal;
    foofallGraphTrend = data.ValueInInt;
    footfalldiff = data.DifferencesInFF;

    $('#totalVisitorThisWeek').append(numberWithCommas(footfall));

    var html = '';
    if (footfalldiff === 0.0) {
        html = LanguageNoChanges;
    } else if (footfalldiff > 0) {
        $('#totalVisitorUpDownPercent').addClass('rise');
        html = '<i class="fa fa-caret-up"></i>' + footfalldiff + ' %';
    } else if (footfalldiff < 0) {
        $('#totalVisitorUpDownPercent').addClass('drop');
        html = '<i class="fa fa-caret-down"></i>' + footfalldiff + ' %';
    }
    $('#totalVisitorUpDownPercent').append(html);
    drawTopMatricGraph('FFGraph', foofallGraphTrend, colorScheme);

}

function bindTurnInRateTopMatric(data, colorScheme) {

    $('#turnInRateThisWeek').empty();
    $('#turnInRateUpDownPercent').removeClass('rise');
    $('#turnInRateUpDownPercent').removeClass('drop');
    $('#turnInRateUpDownPercent').empty();
    $('#TIRGraph').empty();

    turnInRate = data.TurnInRateTotal;
    turnInRateGraphTrend = data.TIR;
    turnInRateDiff = data.DifferencesInTIR;

    $('#turnInRateThisWeek').append(turnInRate);

    var html = '';
    if (turnInRateDiff === 0.0) {
        html = LanguageNoChanges;
    } else if (turnInRateDiff > 0) {
        $('#turnInRateUpDownPercent').addClass('rise');
        html = '<i class="fa fa-caret-up"></i>' + turnInRateDiff + ' %';
    } else if (turnInRateDiff < 0) {
        $('#turnInRateUpDownPercent').addClass('drop');
        html = '<i class="fa fa-caret-down"></i>' + turnInRateDiff + ' %';
    }
    $('#turnInRateUpDownPercent').append(html);
    drawTopMatricGraph('TIRGraph', turnInRateGraphTrend, colorScheme);
}

function bindVisitdurationTopMatric(data, colorScheme) {


    $('#visitDurationThisWeek').empty();
    $('#visitDurationUpDownPercent').removeClass('rise');
    $('#visitDurationUpDownPercent').removeClass('drop');
    $('#visitDurationUpDownPercent').empty();
    // $('#VDGraph').empty();


    visitDuration = data.VisitDurationTotal;
    visitDurationGraphTrend = data.VisitDuration;
    visitDurationDiff = data.DifferencesInVisitDuration;
    
    $('#visitDurationThisWeek').append(visitDuration + ' ' + LanguageMin);

    var html = '';
    if (visitDurationDiff === 0.0) {
        html = LanguageNoChanges;
    } else if (visitDurationDiff > 0) {
        $('#visitDurationUpDownPercent').addClass('rise');
        html = '<i class="fa fa-caret-up"></i>' + visitDurationDiff + ' %';
    } else if (visitDurationDiff < 0) {
        $('#visitDurationUpDownPercent').addClass('drop');
        html = '<i class="fa fa-caret-down"></i>' + visitDurationDiff + ' %';
    }
    $('#visitDurationUpDownPercent').append(html);
    // drawTopMatricGraph('VDGraph', visitDurationGraphTrend, colorScheme);
}

function bindReturningRateTopMatric(data, colorScheme) {

    $('#returningRateThisWeek').empty();
    $('#returningRateUpDownPercent').removeClass('rise');
    $('#returningRateUpDownPercent').removeClass('drop');
    $('#returningRateUpDownPercent').empty();
    // $('#RRGraph').empty();

    returningRate = data.ReturnCustomerRate;
    returningRateGraphTrend = data.ReturningRate;
    returningRateDiff = data.DifferencesInReturingCustomerRate;

    $('#returningRateThisWeek').append(returningRate + " %");

    var html = '';
    if (returningRateDiff === 0.0) {
        html = LanguageNoChanges;
    } else if (returningRateDiff > 0) {
        $('#returningRateUpDownPercent').addClass('rise');
        html = '<i class="fa fa-caret-up"></i>' + returningRateDiff + ' %';
    } else if (returningRateDiff < 0) {
        $('#returningRateUpDownPercent').addClass('drop');
        html = '<i class="fa fa-caret-down"></i>' + returningRateDiff + ' %';
    }
    $('#returningRateUpDownPercent').append(html);
    // drawTopMatricGraph('RRGraph', returningRateGraphTrend, colorScheme);
}

function bindSalesConversionTopMatric(data, colorScheme) {

    $('#salesConversionRow').show();

    $('#SalesConv').empty();
    $('#SalesConvUpDownPercent').removeClass('rise');
    $('#SalesConvUpDownPercent').removeClass('drop');
    $('#SalesConvUpDownPercent').empty();
    $('#SCGraph').empty();


    salesConversion = data.SalesConversionTotal;
    salesConversionGraphTrend = data.SalesConversion;
    salesConversionDiff = data.DiffInSC;

    $('#SalesConv').append(salesConversion);

    var html = '';
    if (salesConversionDiff === 0.0) {
        html = LanguageNoChanges;
        $('#salesConversionRow').hide();
    } else if (salesConversionDiff > 0) {
        $('#SalesConvUpDownPercent').addClass('rise');
        html = '<i class="fa fa-caret-up"></i>' + salesConversionDiff + ' %';
    } else if (salesConversionDiff < 0) {
        $('#SalesConvUpDownPercent').addClass('drop');
        html = '<i class="fa fa-caret-down"></i>' + salesConversionDiff + ' %';
    }
    $('#SalesConvUpDownPercent').append(html);
    drawTopMatricGraph('SCGraph', salesConversionGraphTrend, colorScheme);
}

function bindCompanyDailyTable2(data) {
    $("#CompanyDailyTableHead").html('');
    $("#CompanyDailyTableContent").html('');
    var hasSalesData = data.series[0].hasSalesData;
    if (hasSalesData > 0) {
        $("#CompanyDailyTableHead").append("<tr><th>" + LanguageBranches + "</th><th>" + LanguageVisitorCounts + "</th><th>" + LanguageOutsideTraffic + "</th><th>" + LanguageTurnInRatepercent + "</th><th>" + LanguageVisitDurationminutes + "</th><th>" + LanguageReturningRateprecent + "</th><th>" + LanguageTransactionCount + "</th><th>" + LanguageSalesConversion + " (%)</th></tr>");
    } else {
        $("#CompanyDailyTableHead").append("<tr><th>" + LanguageBranches + "</th><th>" + LanguageVisitorCounts + "</th><th>" + LanguageOutsideTraffic + "</th><th>" + LanguageTurnInRatepercent + "</th><th>" + LanguageVisitDurationminutes + "</th><th>" + LanguageReturningRateprecent + "</th></tr>");
    }

    for (var i = 0; i < data.series[0].branchName.length; i++) {
        var visitorCount = data.series[0].ValueInInt[i] == 0 ? "-" : numberify(data.series[0].ValueInInt[i]);
        var outsideTraffic = data.series[0].OutsideTrafficInt[i] == 0 ? "-" : numberify(data.series[0].OutsideTrafficInt[i]);
        var turnInRate = data.series[0].TIR[i] == 0 ? "-" : data.series[0].TIR[i].toFixed(2);
        var visitDuration = data.series[0].VisitDuration[i] == 0 ? "-" : data.series[0].VisitDuration[i].toFixed(2);
        var returningRate = data.series[0].ReturningRate[i] == 0 ? "-" : data.series[0].ReturningRate[i].toFixed(2);
        var transactionCount = data.series[0].TransactionCountInt[i] == 0 ? "-" : data.series[0].TransactionCountInt[i];
        var salesConversion = data.series[0].SalesConversion[i] == 0 ? "-" : data.series[0].SalesConversion[i];
        var firstColumn = "<td>" + data.series[0].branchName[i] + "</td>";
        var secondColumn = "<td>" + visitorCount + "</td>";
        var thridColumn = "<td>" + outsideTraffic + "</td>";
        var forthColumn = "<td>" + turnInRate + "</td>";
        var fifthColumn = "<td>" + visitDuration + "</td>";
        var sixthColumn = "<td>" + returningRate + "</td>";
        var seventhColumn = "<td>" + transactionCount + "</td>";
        var eigthColumn = "<td>" + salesConversion + "</td>";
        if (hasSalesData > 0) {
            $("#CompanyDailyTableContent").append("<tr>" + firstColumn + secondColumn + thridColumn + forthColumn + fifthColumn + sixthColumn + seventhColumn + eigthColumn + "</tr>");
        } else {
            $("#CompanyDailyTableContent").append("<tr>" + firstColumn + secondColumn + thridColumn + forthColumn + fifthColumn + sixthColumn + "</tr>");
        }

    }
}



function bindHighchart(data, colorScheme) {
    var miniChartId = ['FFGraph', 'TIRGraph'];
    var miniChartData = [data.series[0].data, data.series[1].data];
    //draw graph under each box, footfallcount
    for (var i = 0; i < miniChartId.length; i++) {
        $(function() {
            Highcharts.setOptions({
                global: {
                    useUTC: false
                }
            });
            var chart = new Highcharts.Chart({
                chart: {
                    renderTo: miniChartId[i],
                    margin: [0, 0, 0, 0],
                    backgroundColor: 'transparent'
                },
                title: {
                    text: ''
                },
                credits: {
                    enabled: false
                },
                xAxis: {
                    labels: {
                        enabled: false
                    }
                },
                yAxis: {
                    maxPadding: 0,
                    minPadding: 0,
                    gridLineWidth: 0,
                    endOnTick: false,
                    labels: {
                        enabled: false
                    }
                },
                legend: {
                    enabled: false
                },
                tooltip: {
                    enabled: false
                },
                plotOptions: {
                    series: {
                        enableMouseTracking: false,
                        lineWidth: 1,
                        shadow: false,
                        states: {
                            hover: {
                                lineWidth: 1
                            }
                        },
                        marker: {
                            radius: 0,
                            states: {
                                hover: {
                                    radius: 2
                                }
                            }
                        }
                    }
                },
                exporting: {
                    enabled: false,
                },
                series: [{
                    type: 'areaspline',
                    data: miniChartData[i],
                    color: colorScheme.chart.sparkLine.color,
                    fillOpacity: 0.5
                }]
            });
        });
    }
}

function bindCompanyDailyTable(data) {
    $("#CompanyDailyTableHead").html('');
    $("#CompanyDailyTableContent").html('');
    var hasSalesData = data.series[5].hasSalesData;
    if (data.series[5].hasSalesData > 0) {
        $("#CompanyDailyTableHead").append("<tr><th>" + LanguageBranches + "</th><th>" + LanguageVisitorCounts + "</th><th>" + LanguageOutsideTraffic + "</th><th>" + LanguageTurnInRatepercent + "</th><th>" + LanguageVisitDurationminutes + "</th><th>" + LanguageReturningRateprecent + "</th><th>" + LanguageTransactionCount + "</th><th>" + LanguageSalesConversion + " (%)</th></tr>");
    } else {
        $("#CompanyDailyTableHead").append("<tr><th>" + LanguageBranches + "</th><th>" + LanguageVisitorCounts + "</th><th>" + LanguageOutsideTraffic + "</th><th>" + LanguageTurnInRatepercent + "</th><th>" + LanguageVisitDurationminutes + "</th><th>" + LanguageReturningRateprecent + "</th></tr>");
    }

    for (var i = 0; i < data.series[0].data.length; i++) {
        var visitorCount = data.series[0].data[i] == 0 ? "-" : data.series[0].data[i];
        var outsideTraffic = data.series[1].data[i] == 0 ? "-" : data.series[1].data[i];
        var turnInRate = data.series[2].data[i] == 0 ? "-" : data.series[2].data[i].toFixed(2);
        var visitDuration = data.series[3].data[i] == 0 ? "-" : data.series[3].data[i].toFixed(2);
        var returningRate = data.series[4].data[i] == 0 ? "-" : data.series[4].data[i].toFixed(2);
        var transactionCount = data.series[5].data[i] == 0 ? "-" : data.series[5].data[i];
        var salesConversion = data.series[6].data[i] == 0 ? "-" : data.series[6].data[i];
        var firstColumn = "<td>" + data.series[0].branchName[i] + "</td>";
        var secondColumn = "<td>" + visitorCount + "</td>";
        var thridColumn = "<td>" + outsideTraffic + "</td>";
        var forthColumn = "<td>" + turnInRate + "</td>";
        var fifthColumn = "<td>" + visitDuration + "</td>";
        var sixthColumn = "<td>" + returningRate + "</td>";
        var seventhColumn = "<td>" + transactionCount + "</td>";
        var eigthColumn = "<td>" + salesConversion + "</td>";
        if (data.series[5].hasSalesData > 0) {
            $("#CompanyDailyTableContent").append("<tr>" + firstColumn + secondColumn + thridColumn + forthColumn + fifthColumn + sixthColumn + seventhColumn + eigthColumn + "</tr>");
        } else {
            $("#CompanyDailyTableContent").append("<tr>" + firstColumn + secondColumn + thridColumn + forthColumn + fifthColumn + sixthColumn + "</tr>");
        }

    }
}

function bindFootfallHourlyTrend(data, colorScheme) {

    var lastWeek = data.series[1].ValueInInt;
    var thisWeek = data.series[0].ValueInInt;

    //identify largest value of yaxis data
    var largestValue = 0;
    for (var i = 0; i < lastWeek.length; i++) {
        if (lastWeek[i] != null && lastWeek[i] != undefined && lastWeek[i] > largestValue)
            largestValue = lastWeek[i]
    }

    for (var i = 0; i < thisWeek.length; i++) {
        if (thisWeek[i] != null && thisWeek[i] != undefined && thisWeek[i] > largestValue)
            largestValue = thisWeek[i]
    }

    var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1 :
        largestValue >= 10 && largestValue < 100 ? 10 :
        largestValue >= 100 && largestValue < 1000 ? 100 :
        largestValue >= 1000 && largestValue < 10000 ? 1000 :
        largestValue >= 10000 && largestValue < 100000 ? 10000 :
        largestValue >= 100000 && largestValue < 1000000 ? 100000 :
        1000000;

    $(function() {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "VisitorCountTrend",
                events: {
                    load: function() {
                        chartEvent[3] = this;
                    }
                }
            },
            series: [{
                type: 'column',
                name: LanguageThisWeek,
                data: thisWeek,
                color: colorScheme.chart.column.color,
                pointWidth: 18,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageLastWeek,
                dashStyle: 'dash',
                data: lastWeek,
                color: colorScheme.chart.line.color.lastWeek,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: '',
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    }
                }
            },
            yAxis: {
                lineWidth: 0,
                gridLineWidth: 1,
                tickWidth: 0,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 10,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                min: 0, // this sets minimum values of y to 0
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                tickInterval: 1,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                borderColor: '#474b4b',
                x: 260,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                shared: true,
            },
        });
    });
}

function bindVisitDurationBox(data, colorScheme) {
    $("#visitDurationThisWeek").empty();
    //$("#visitDurationLastWeek").empty();
    var changes = data.series[2].data[0];
    var LastWeek = data.series[0].data[0];
    var ThisWeek = data.series[1].data[0];

    if (ThisWeek == 0)
        $("#visitDurationThisWeek").append("-");
    else
        $("#visitDurationThisWeek").append(ThisWeek.toFixed(2) + "m");

    //if (LastWeek == 0)
    //    $("#visitDurationLastWeek").append("(" + LanguageLastWeek + ": - )");
    //else
    //    $("#visitDurationLastWeek").append("(" + LanguageLastWeek + ": " + LastWeek.toFixed(2) + " " + Languageminutes + ")");

    $("#visitDurationUpDownPercent").empty();
    //$("#visitDurationUpDownIcon").empty();
    $("#visitDurationUpDownPercent").removeClass("drop");
    $("#visitDurationUpDownPercent").removeClass("rise");

    if (ThisWeek == 0 || LastWeek == 0)
        $("#visitDurationUpDownPercent").append("-");
    else if (ThisWeek == LastWeek)
        $("#visitDurationUpDownPercent").append(LanguageNoChanges);
    else if (ThisWeek > LastWeek) {
        $("#visitDurationUpDownPercent").addClass("rise");
        //$("#visitDurationUpDownIcon").append("<i class=\"fa fa-caret-up\" style=\"color: " + colorScheme.chart.arrow.up + "\">");
        $("#visitDurationUpDownPercent").append("<i class='fa fa-caret-up'></i> " + changes.toFixed(2) + "%");
    } else {
        $("#visitDurationUpDownPercent").addClass("drop");
        //$('#visitDurationUpDownIcon').append("<i class=\"fa fa-caret-down\" style=\"color: " + colorScheme.chart.arrow.down + "\">");
        $("#visitDurationUpDownPercent").append("<i class='fa fa-caret-down'></i> " + changes.toFixed(2) + "%");
    }
}

function bindReturningRateBox(data, colorScheme) {
    $("#returningRateThisWeek").empty();
    //$("#returningRateLastWeek").empty();
    var changes = data.series[2].data[0];
    var LastWeek = data.series[0].data[0];
    var ThisWeek = data.series[1].data[0];

    if (ThisWeek == 0)
        $("#returningRateThisWeek").append("-");
    else
        $("#returningRateThisWeek").append(ThisWeek.toFixed(2) + "%");

    //if (LastWeek == 0)
    //    $("#returningRateLastWeek").append("(" + LanguageLastWeek + ": - )");
    //else
    //    $("#returningRateLastWeek").append("(" + LanguageLastWeek + ": " + LastWeek.toFixed(2) + "%)");
    $("#returningRateUpDownPercent").removeClass("drop");
    $("#returningRateUpDownPercent").removeClass("rise");

    $("#returningRateUpDownPercent").empty();
    //$("#returningRateUpDownIcon").empty();
    if (ThisWeek == 0 || LastWeek == 0)
        $("#returningRateUpDownPercent").append("-");
    else if (ThisWeek == LastWeek)
        $("#returningRateUpDownPercent").append(LanguageNoChanges);
    else if (ThisWeek > LastWeek) {
        $("#returningRateUpDownPercent").addClass("rise");
        //$("#returningRateUpDownIcon").append("<i class=\"fa fa-caret-up\" style=\"color: " + colorScheme.chart.arrow.up + "\">");
        $("#returningRateUpDownPercent").append("<i class='fa fa-caret-up'></i> " + changes.toFixed(2) + "%");
    } else {
        $("#returningRateUpDownPercent").addClass("drop");
        //$('#returningRateUpDownIcon').append("<i class=\"fa fa-caret-down\" style=\"color: " + colorScheme.chart.arrow.down + "\">");
        $("#returningRateUpDownPercent").append("<i class='fa fa-caret-down'></i> " + changes.toFixed(2) + "%");
    }
}

function bindSalesBox(data, colorScheme) {
    //$("#totalVisitorLastWeek").empty();
    $("#SalesConv").empty();

    var changes = data.series[1].data[0];
    var ThisWeek = data.series[0].data[0];
    //var ThisWeek = data.series[1].data[0];
    console.log(ThisWeek);
    if (ThisWeek == undefined)
        $(".second-row").hide();
    if (ThisWeek == 0)
        $("#SalesConv").append("-");
    else
        $("#SalesConv").append(ThisWeek + "%");

    $("#SalesConvUpDownPercent").removeClass("rise");
    $("#SalesConvUpDownPercent").removeClass("drop");

    $("#SalesConvUpDownPercent").empty();
    //if (ThisWeek == 0 || LastWeek == 0)
    if (ThisWeek == 0)
        $("#SalesConvUpDownPercent").append("-");
    else if (changes == 0)
        $("#SalesConvUpDownPercent").append(LanguageNoChanges);
    else if (changes > 0) {
        $("#SalesConvUpDownPercent").addClass("rise");
        $("#SalesConvUpDownPercent").append("<i class='fa fa-caret-up'></i> " + changes.toFixed(2) + "%");
    } else {
        $("#SalesConvUpDownPercent").addClass("drop");
        $("#SalesConvUpDownPercent").append("<i class='fa fa-caret-down'></i> " + changes.toFixed(2) + "%");
    }
}

function bindFootfallBox(data, colorScheme) {

    //$("#totalVisitorLastWeek").empty();
    $("#totalVisitorThisWeek").empty();
    var changes = data.series[2].data[0];
    var LastWeek = data.series[0].data[0];
    var ThisWeek = data.series[1].data[0];

    if (ThisWeek == 0)
        $("#totalVisitorThisWeek").append("-");
    else
        $("#totalVisitorThisWeek").append(ThisWeek);

    //if (LastWeek == 0)
    //    $("#totalVisitorLastWeek").append("(" + LanguageLastWeek + ": - )");
    //else
    //    $("#totalVisitorLastWeek").append("(" + LanguageLastWeek + ": " + LastWeek + ")");
    $("#totalVisitorUpDownPercent").removeClass("rise");
    $("#totalVisitorUpDownPercent").removeClass("drop");

    $("#totalVisitorUpDownPercent").empty();
    //$("#totalVisitorUpDownIcon").empty();
    if (ThisWeek == 0 || LastWeek == 0)
        $("#totalVisitorUpDownPercent").append("-");
    else if (ThisWeek == LastWeek)
        $("#totalVisitorUpDownPercent").append(LanguageNoChanges);
    else if (ThisWeek > LastWeek) {
        //$("#totalVisitorUpDownIcon").append("<i class=\"fa fa-caret-up\" style=\"color: " + colorScheme.chart.arrow.up + "\">");
        $("#totalVisitorUpDownPercent").addClass("rise");
        $("#totalVisitorUpDownPercent").append("<i class='fa fa-caret-up'></i> " + changes.toFixed(2) + "%");
    } else {
        //$('#totalVisitorUpDownIcon').append("<i class=\"fa fa-caret-down\" style=\"color: " + colorScheme.chart.arrow.down + "\">");
        $("#totalVisitorUpDownPercent").addClass("drop");
        $("#totalVisitorUpDownPercent").append("<i class='fa fa-caret-down'></i> " + changes.toFixed(2) + "%");
    }
}

function bindTurnInRateBox(data, colorScheme) {
    //console.log(data);
    //$("#turnInRateLastWeek").empty();
    $("#turnInRateThisWeek").empty();
    var changes = data.series[2].data[0];
    var LastWeek = data.series[0].data[0];
    var ThisWeek = data.series[1].data[0];

    if (ThisWeek == 0)
        $("#turnInRateThisWeek").append("-");
    else
        $("#turnInRateThisWeek").append(ThisWeek.toFixed(2) + "%");

    //if (LastWeek == 0)
    //    $("#turnInRateLastWeek").append("(" + LanguageLastWeek + ": - )");
    //else
    //    $("#turnInRateLastWeek").append("(" + LanguageLastWeek + ": " + LastWeek.toFixed(2) + "%)");
    $("#turnInRateUpDownPercent").removeClass("rise");
    $("#turnInRateUpDownPercent").removeClass("drop");

    $("#turnInRateUpDownPercent").empty();
    //$("#turnInRateUpDownIcon").empty();
    if (ThisWeek == 0 || LastWeek == 0)
        $("#turnInRateUpDownPercent").append("-");
    else if (ThisWeek == LastWeek)
        $("#turnInRateUpDownPercent").append(LanguageNoChanges);
    else if (ThisWeek > LastWeek) {
        $("#turnInRateUpDownPercent").addClass("rise");
        //$("#turnInRateUpDownIcon").append("<i class=\"fa fa-caret-up\" style=\"color: " + colorScheme.chart.arrow.up + "\">");
        $("#turnInRateUpDownPercent").append("<i class='fa fa-caret-up'></i> " + changes.toFixed(2) + "%");
    } else {
        $("#turnInRateUpDownPercent").addClass("drop");
        //$('#turnInRateUpDownIcon').append("<i class=\"fa fa-caret-down\" style=\"color: " + colorScheme.chart.arrow.down + "\">");
        $("#turnInRateUpDownPercent").append("<i class='fa fa-caret-down'></i> " + changes.toFixed(2) + "%");
    }
}