function chartLoading() {
    /*loadingChart('visitDuration')
    $('#visitDuration').addClass("chartLoading");

    loadingChart('returningCustomers')
    $('#returningCustomers').addClass("chartLoading");

    loadingChart('hourlyTrend')
    $('#hourlyTrend').addClass("chartLoading");

    loadingChart('outsideOpportunity')
    $('#outsideOpportunity').addClass("chartLoading");*/

    loadingChart('companyFootfallSummaryChart')
    $('#companyFootfallSummaryChart').addClass("chartLoading");

    loadingChart('trafficFlowGraph')
    $('#trafficFlowGraph').addClass("chartLoading");

}
// total visitors
function bindTotalVisitors(data, colorScheme) {

    $("#totalVisitorThisWeek").empty();
    var visitorCount = data.series[0].data[0];

    if (visitorCount == 0)
        $("#totalVisitorThisWeek").append("-");
    else
        $("#totalVisitorThisWeek").append(visitorCount);

}
// average visit duration
function bindAverageVisitDuration(data, colorScheme) {
    $("#averageVisitDurationThisWeek").empty();
    var avgDuration = data.series[0].data[0];
    if (avgDuration == 0)
        $("#averageVisitDurationThisWeek").append("-");
    else
        $("#averageVisitDurationThisWeek").append(avgDuration.toFixed(2) + "m");
}
// three visit duration
function bindDuration(threeCategoryData, colorScheme) {
    var thisWeekFirstCat = threeCategoryData.series[0].data[0];
    var thisWeekSecondCat = threeCategoryData.series[1].data[0];
    var thisWeekThirdCat = threeCategoryData.series[2].data[0];
    var dwellTimeMin = threeCategoryData.series[3].data[0];
    var dwellTimeMax = threeCategoryData.series[4].data[0];


    var donutChartColors = $.map(colorScheme.chart.donut, function (value, index) {
        return [value];
    });

    $(function () {
        $('#visitDuration').highcharts({
            chart: {
                type: 'bar'
            },
            exporting: {
                enabled: false
            },
            title: {
                text: ''
            },
            xAxis: {
                categories: [1, 2, 3],
                labels: {
                    useHTML: true,
                    formatter: function () {
                        return {
                            '1': "<" + dwellTimeMin + LanguageMin + ' <div style="width: 40px;height: 40px; float: right;"><img class="img-responsive" src="/Content/Footfallcam/images/duration_short.svg" /></div>',
                            '2': +dwellTimeMin + " - " + dwellTimeMax + LanguageMin + ' <div style="width: 40px;height: 40px; float: right;"><img class="img-responsive" src="/Content/Footfallcam/images/duration_medium.svg" /></div>',
                            '3': ">" + dwellTimeMax + LanguageMin + ' <div style="width: 40px;height: 40px; float: right;"><img class="img-responsive" src="/Content/Footfallcam/images/duration_long.svg" /></div>',
                        }[this.value];
                    }

                }
            },
            yAxis: {
                min: 0,
                title: {
                    text: '',
                },
                labels: {
                    overflow: 'justify'
                }
            },
            tooltip: {
                enabled: false
            },
            plotOptions: {
                bar: {
                    dataLabels: {
                        enabled: true,
                        format: '{point.y:.1f}%'
                    },
                    color: "#5AA995"
                }
            },
            legend: {
                enabled: false
            },
            credits: {
                enabled: false
            },
            series: [{

                data: [thisWeekFirstCat, thisWeekSecondCat, thisWeekThirdCat]
            }]
        });
    });
}

// returning customers
function bindReturningCustomers(data, colorScheme) {
    $("#returnCustomers").empty();
    $("#newCustomers").empty();
    var ThisWeekReturn = data.series[0].data[0];
    var ThisWeekNew = data.series[1].data[0];

    if (ThisWeekReturn == 0)
        $("#returnCustomers").append("-");
    else
        $("#returnCustomers").append(ThisWeekReturn.toFixed(2) + "%");
    if (ThisWeekNew == 0)
        $("#newCustomers").append("-");
    else
        $("#newCustomers").append(ThisWeekNew.toFixed(2) + "%");

    var donutChartColors = $.map(colorScheme.chart.donut, function (value, index) {
        return [value];
    });

    $(function () {
        $('#returningCustomers').highcharts({
            chart: {
                plotBackgroundColor: null,
                plotBorderWidth: 0,
                plotShadow: false,
                type: 'pie'
            },
            exporting: {
                enabled: false
            },
            title: {
                text: ''
            },
            tooltip: {
                formatter: function () {
                    return '<b>' + this.point.name + '</b>: ' + this.y + ' %';
                }
                //pointFormat: '{<b>{point.percentage: .1f}%</b>'
            },
            plotOptions: {
                pie: {
                    allowPointSelect: false,
                    cursor: 'pointer',
                    dataLabels: {
                        enabled: false,
                    },
                    showInLegend: true,
                    colors: ["#0E9CD8", "#E2BD2E"]
                }
            },
            series: [{
                type: 'pie',
                innerSize: '50%',
                data: [
                    [LanguageNewCustomer, parseFloat(ThisWeekNew)],
                    [LanguageReturningCustomer, parseFloat(ThisWeekReturn)],
                ]
            }],
            credits: {
                enabled: false
            }
        });
    });

}

// outside opportunity
function bindOutsideOpportunity(data, colorScheme) {
    var outsideThisWeek = data.series[0].data;
    $(function () {
        $('#outsideOpportunity').highcharts({
            chart: {
                type: 'areaspline'
            },
            exporting: {
                enabled: false
            },
            title: {
                text: ''
            },
            legend: {
                layout: 'vertical',
                align: 'left',
                verticalAlign: 'top',
                x: 150,
                y: 100,
                floating: true,
                borderWidth: 1,
                backgroundColor: (Highcharts.theme && Highcharts.theme.legendBackgroundColor) || '#FFFFFF'
            },
            xAxis: {
                categories: data.categories,
                labels: {
                    rotation: -90
                },
                title: {
                    text: LanguageTime,
                    align: 'high'
                }
            },
            yAxis: {
                title: {
                    text: 'Outside Opportunity'
                }
            },
            tooltip: {
                shared: false,
                valueSuffix: ''
            },
            credits: {
                enabled: false
            },
            plotOptions: {
                areaspline: {
                    color: "#5AA995",
                    fillOpacity: 0.5
                }
            },
            legend: {
                enabled: false
            },
            series: [{
                name: 'Outside Opportunity',
                data: outsideThisWeek,
            }]
        });
    });
}

// hourly trend
function bindHourlyTrend(data, colorScheme) {
    var thisWeekFootfall = data.series[0];
    var thisWeekTurnInRate = data.series[1];

    $(function () {
        $('#hourlyTrend').highcharts({
            chart: {
                zoomType: 'xy'
            },
            exporting: {
                enabled: false
            },
            title: {
                text: ''
            },
            xAxis: [{
                categories: data.categories,
                labels: {
                    rotation: -90,
                },
                crosshair: true,
                title: {
                    text: LanguageTime,
                    align: 'high'
                }
            }],
            yAxis: [{ // Primary yAxis
                labels: {
                    align: 'right',
                    format: '{value}',
                    style: {
                        color: Highcharts.getOptions().colors[1],
                    }
                },
                title: {
                    text: LanguageTurnInRate
                }
            }, { // Secondary yAxis
                title: {
                    text: LanguageFootfall,
                },
                labels: {
                    enabled: true,
                },
                opposite: true
            }],
            tooltip: {
                shared: true
            },
            legend: {
                align: 'center',
                verticalAlign: 'top',
                y: 0
            },
            series: [{
                name: LanguageFootfall,
                type: 'column',
                yAxis: 1,
                data: thisWeekFootfall.data,
                tooltip: {
                    valueSuffix: ''
                }

            }, {
                name: LanguageTurnInRate,
                type: 'line',
                data: thisWeekTurnInRate.data,
                tooltip: {
                    valueSuffix: '%'
                }
            }],
            plotOptions: {
                column: {
                    color: "#0E9CD8"
                },
                line: {
                    color: "#E2BD2E",
                    marker: {
                        enabled: false
                    }
                }

            },
            credits: {
                enabled: false
            }
        });
    });

    
}

function bindPeakLowestHours(data, colorScheme) {

    $("#peakHourThisWeek").empty();
    $("#peakVisitorCountThisWeek").empty();
    $("#lowestHourThisWeek").empty();
    $("#lowestVisitorCountThisWeek").empty();

    var peakHourThisWeek = data.series[0].data[0].highestHour;
    var highestVisitorCountThisWeek = data.series[0].data[0].highestVisitorCount;
    var lowestHourThisWeek = data.series[0].data[0].lowestHour;
    var lowestVisitorCountThisWeek = data.series[0].data[0].lowestVisitorCount;


    $("#peakHourThisWeek").append(peakHourThisWeek);
    $("#peakVisitorCountThisWeek").append(highestVisitorCountThisWeek + " " + LanguageVisitor);
    $("#lowestHourThisWeek").append(lowestHourThisWeek);
    $("#lowestVisitorCountThisWeek").append(lowestVisitorCountThisWeek + " " + LanguageVisitor);
}

// hourly trend
function bindSales(data, colorScheme) {
    var thisWeekFootfall = data.series[0];
    var dataAvail = false;
    console.log(thisWeekFootfall.data.length);
    for (var x = 0 ; x < thisWeekFootfall.data.length ; x++)
    {
        if (thisWeekFootfall.data[x] > 0)
            dataAvail = true;
    }

    if (dataAvail) {
        if($("#ParentsSalesConversion").css("display") == "none")
            $("#ParentsSalesConversion").css("display", "block");
    }
    else {
        $("#ParentsSalesConversion").css("display", "none");
    }

    $(function () {
        $('#salesConversion').highcharts({
            chart: {
                zoomType: 'xy'
            },
            exporting: {
                enabled: false
            },
            title: {
                text: ''
            },
            xAxis: [{
                categories: data.categories,
                labels: {
                    rotation: -90,
                },
                crosshair: true,
                title: {
                    text: LanguageTime,
                    align: 'high'
                }
            }],
            yAxis: [{ // Primary yAxis
                labels: {
                    align: 'right',
                    format: '{value}',
                    style: {
                        color: Highcharts.getOptions().colors[1],
                    }
                },
                title: {
                    text: "Sales Conversion"
                }
            }, { // Secondary yAxis
                title: {
                    text: "Sales Conversion",
                },
                labels: {
                    enabled: true,
                },
                opposite: true
            }],
            tooltip: {
                shared: true
            },
            legend: {
                align: 'left',
                verticalAlign: 'top',
            },
            series: [{
                name: "Sales Conversion",
                type: 'column',
                yAxis: 1,
                data: thisWeekFootfall.data,
                tooltip: {
                    valueSuffix: ''
                }

            }],
            plotOptions: {
                column: {
                    color: "#0E9CD8"
                },
                line: {
                    color: "#E2BD2E",
                    marker: {
                        enabled: false
                    }
                }

            },
            credits: {
                enabled: false
            }
        });
    });
}

function bindTopOverview(data, colorScheme)
{
     console.log(data);
     bindTodayVisitorTotal(data[0],colorScheme);
     bindlast7DaysVisitorTotal(data[1],colorScheme);
     bindTodayAvgVisitorTotal(data[2],colorScheme);
     bindTotalVisitorChanges(data[3],colorScheme);
};

function bindTodayVisitorTotal(data,colorScheme)
{
     $("#totalVisitorToday").empty();
    var visitorCount = data.series[0].visitorTotal;

    if (visitorCount == 0)
        $("#totalVisitorToday").append("-");
    else
        $("#totalVisitorToday").append(numberify(visitorCount));
}

function bindlast7DaysVisitorTotal(data,colorScheme)
{
     $("#totalVisitorLast7Days").empty();
    var last7DaysVisitorCount = data.series[0].visitorTotal;

    if (last7DaysVisitorCount == 0)
        $("#totalVisitorLast7Days").append("-");
    else
        $("#totalVisitorLast7Days").append(numberify(last7DaysVisitorCount));
}

function bindTodayAvgVisitorTotal(data,colorScheme)
{
     $("#averageVisitorTotal").empty();
    var avgVisitorCount = data.series[0].visitorTotal;

    if (avgVisitorCount == 0)
        $("#averageVisitorTotal").append("-");
    else
        $("#averageVisitorTotal").append(numberify(avgVisitorCount));
}

function bindTotalVisitorChanges(data,colorScheme)
{
    $("#changesVisitorBetweenTwoWeeks").empty();
    $("#changesVisitorBetweenTwoWeeks").removeClass("rise");
    $("#changesVisitorBetweenTwoWeeks").removeClass("drop");
    var visitorTotalChanges = data.series[0].changesOfVisitorTotal;

    if (visitorTotalChanges == 0)
    {   
        $("#changesVisitorBetweenTwoWeeks").append(LanguageNoChanges);
    }   
    else if(visitorTotalChanges > 0)
    {
        $("#changesVisitorBetweenTwoWeeks").addClass("rise");
        $("#changesVisitorBetweenTwoWeeks").append("<i class='fa fa-caret-up'></i> " + visitorTotalChanges.toFixed(2) + "%");
    }   
    else if(visitorTotalChanges < 0)
    {
        $("#changesVisitorBetweenTwoWeeks").addClass("drop");
        $("#changesVisitorBetweenTwoWeeks").append("<i class='fa fa-caret-down'></i> " + visitorTotalChanges.toFixed(2) + "%");
    }

}

function bindTop5VisitorCount(data,colorScheme)
{
    var thisWeekVisitorList = data.series[0].ValueInInt;
    var lastWeekVisitorList = data.series[0].LastValueInList;
    var branchNameList = data.series[0].branchName;
    var changesVisitorList = data.series[0].DifferencesInFFList;
    $("#top5BranchesVisitorTotalTable").html('');

    if(thisWeekVisitorList.length <= 0)
    {
        $("#top5BranchesVisitorTotalTable").html('');
    }
    else
    {
        $("#top5BranchesVisitorTotalTable").append('<thead><tr><th class="rankBranchTh">'+LanguageRank+'</th><th class="rankBranchTh">'+LanguageSite+'</th><th class="thisWeekLastWeekChangesThTd">'
                                                    +LanguageThisWeek+'</th><th class="thisWeekLastWeekChangesThTd">'+LanguageLastWeek+'</th><th class="thisWeekLastWeekChangesThTd">'+LanguageChanges+' (%)</th></tr></thead><tbody>');
        for(var i = 0; i< thisWeekVisitorList.length;i++)
        {
            var firstColumn =  branchNameList[i];
            var secondColumn = thisWeekVisitorList[i] > 0 ? numberify(thisWeekVisitorList[i]) : " - ";
            var thirdColumn =  lastWeekVisitorList[i] > 0 ? numberify(lastWeekVisitorList[i]) : " - ";
            var fourthColumn =  changesVisitorList[i] > 0  ? "<i class='fa fa-caret-up rise'></i> " + Math.abs(changesVisitorList[i]):
                                changesVisitorList[i] < 0 ? "<i class='fa fa-caret-down drop'></i> " + Math.abs(changesVisitorList[i]):
                                changesVisitorList[i] == 0 ? " - " : " - ";
            var rank = i+1;
            $("#top5BranchesVisitorTotalTable").append('<tr><td class="rankBranchTd">'+rank+'</td><td class="rankBranchTd">'+firstColumn+'</td><td class="thisWeekLastWeekChangesThTd">'+secondColumn+'</td>'+
                                                       '<td class="thisWeekLastWeekChangesThTd">'+thirdColumn+'</td><td class="thisWeekLastWeekChangesThTd">'+fourthColumn+'</td></tr></tbody>');
        }
    }
}

function isBiggerThan0(element, index, array) {
  return element > 0;
}

function bindTop5SalesConversion(data, colorScheme) {
    var thisWeekSalesConversion = data.series[0].SalesConversion;
    var lastWeekSalesConversion = data.series[0].LWSalesConversionList;
    var branchNameList = data.series[0].branchName;
    var changesSalesConversionList = data.series[0].DiffInScList;
    var isContainsTransactionCount = thisWeekSalesConversion.some(isBiggerThan0);
    console.log(isContainsTransactionCount);
    console.log(thisWeekSalesConversion);
    $("#top5BranchesSalesConversionTable").html('');

    if (!isContainsTransactionCount) {
        $("#top5BranchesSalesConversionTable").html('');
        $("#iboxTop5SalesConversion").hide();
    }
    else {
        $("#iboxTop5SalesConversion").show();
        $("#top5BranchesSalesConversionTable").append('<thead><tr><th class="rankBranchTh">' + LanguageRank + '</th><th class="rankBranchTh">' + LanguageSite + '</th><th class="thisWeekLastWeekChangesThTd">'
            + LanguageThisWeek + ' (%)</th><th class="thisWeekLastWeekChangesThTd">' + LanguageLastWeek + ' (%)</th><th class="thisWeekLastWeekChangesThTd">' + LanguageChanges + ' (%)</th></tr></thead><tbody>');
        for (var i = 0; i < thisWeekSalesConversion.length; i++) {
            var firstColumn = branchNameList[i];
            var secondColumn = thisWeekSalesConversion[i] > 0 ? thisWeekSalesConversion[i] : " - ";
            var thirdColumn = lastWeekSalesConversion[i] > 0 ? lastWeekSalesConversion[i] : " - ";
            var fourthColumn = changesSalesConversionList[i] > 0 ? "<i class='fa fa-caret-up rise'></i> " + Math.abs(changesSalesConversionList[i]):
                changesSalesConversionList[i] < 0 ? "<i class='fa fa-caret-down drop'></i> " + Math.abs(changesSalesConversionList[i]):
                    changesSalesConversionList[i] == 0 ? " - " : " - ";
            var rank = i + 1;
            $("#top5BranchesSalesConversionTable").append('<tr><td class="rankBranchTd">' + rank + '</td><td class="rankBranchTd">' + firstColumn + '</td><td class="thisWeekLastWeekChangesThTd">' + secondColumn + '</td>' +
                '<td class="thisWeekLastWeekChangesThTd">' + thirdColumn + '</td><td class="thisWeekLastWeekChangesThTd">' + fourthColumn + '</td></tr></tbody>');
        }
    }
}

function bindVisitorTotalByHour(data,colorScheme){
var hourList = data.categories;
var dayList = data.date;
var languageDayList = [];
for(var d = 0; d < dayList.length; d++){
	languageDayList.push(getDayLanguage(dayList[d]));
}
console.log(languageDayList);
var visitorByHour = data.series[0].ValueInInt;
var heatMapData = [];
var row = 0;
var arrayIndex = 0;
for(var i = 0;i < dayList.length;i++)
{
    for(var j=0;j< hourList.length;j++)
    {
        heatMapData.push([row,j,visitorByHour[arrayIndex]]);
        arrayIndex++;
    }
    row++;
}
var visitorTotalMax = Math.max.apply(null, visitorByHour);
$(function () {
    $('#trafficFlowGraph').highcharts({

        chart: {
           type: 'heatmap',
           plotBorderWidth: 0
        },
        
        title: {
           text: null
        },

        xAxis: {
           categories: languageDayList,
           lineColor: '#FFFFFF',
           tickColor: '#FFFFFF',
           opposite: true
        },

        yAxis: {
           categories: hourList,
           reversed: true,
           title: null
        },

        colorAxis: {
           min: 0,
           stops: [
               [0.0, '#cee6ee'],
               [0.5, '#89d4e9'],
               [0.99, '#47aed7']
           ],
           max: visitorTotalMax
        },
         
        tooltip: {
            enabled: false
        },

       legend: {
            align: 'right',
            layout: 'vertical',
            margin: 0,
            verticalAlign: 'bottom',
            y: 15,
            symbolHeight: 150
        },
                
        credits: {
           enabled: false
         },
                
        series: [{
           name: 'Visitor Total By Hour',
           borderWidth: 1,
           borderColor: '#FFFFFF',
           data: heatMapData,
            dataLabels: {
               enabled: true,
               color: '#606060',
               style: {
                   fontSize: '8px',
                   fontWeight: 'lighter'
               },
               format: '{point.value:,.0f}'
          }
        }]

      });
    });
}

function bindFootfallSummaryHour(data, colorScheme) {
    var hourList = data.categories;
    //console.log("oi:");
    //console.log(data.categories);
	var visitorByHour = data.series[0].ValueInInt;
	var transactionCountByHour = data.series[0].TransactionCountInt;
	var isContainsTransactionCount = transactionCountByHour.some(isBiggerThan0);
	var series = [];
	var yaxis = [];
	var legendPosition = 0;

	if (isContainsTransactionCount) {
		series = [{
			type: 'column',
			name: LanguageNoofVisitor,
			data: visitorByHour,
			color: '#179BD8',
			borderWidth: 0
		}, {
			type: 'column',
			name: LanguageNumberofTransaction,
			data: transactionCountByHour,
			color: colorScheme.time.year.thisYear
		}];
		yaxis = [{
			allowDecimals: false,
			lineWidth: 0,
			//tickInterval: dynamicTickIntervalVisitorTotal,
			tickWidth: 1,
			tickLength: 5,
			min: 0,
			tickPosition: 'inside',
			title: {
				text: LanguageNoofVisitor,
				style: {
					color: colorScheme.chart.axisLabel.y.title.color,
					fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
					"font-family": colorScheme.chart.axisLabel.y.title.fontFamily
				}
			},
			labels: {
				style: {
					"font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
					color: colorScheme.chart.axisLabel.y.label.color,
					fontSize: colorScheme.chart.axisLabel.y.label.fontSize
				}
			}
		},
		{
			allowDecimals: false,
			opposite: true,
			linkedTo: 0,
			lineWidth: 0,
			tickWidth: 0,
			//tickInterval: dynamicTickIntervalTransactionCount,
			tickWidth: 1,
			tickLength: 5,
			min: 0,
			tickPosition: 'inside',
			labels: {
				style: {
					"font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
					color: colorScheme.chart.axisLabel.y.label.color,
					fontSize: colorScheme.chart.axisLabel.y.label.fontSize
				}
			},
			title: {
				text: LanguageNumberofTransaction,
				style: {
					color: colorScheme.chart.axisLabel.y.title.color,
					fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
					"font-family": colorScheme.chart.axisLabel.y.title.fontFamily
				}
			}
		}];
		legendPosition = 300;
	} else {
		//var largestValueVisitorTotal = Math.max.apply(null, visitorByHour);
		//var dynamicTickIntervalVisitorTotal = largestValueVisitorTotal >= 0 && largestValueVisitorTotal < 10 ? 1
		//    : largestValueVisitorTotal >= 10 && largestValueVisitorTotal < 100 ? 10
		//        : largestValueVisitorTotal >= 100 && largestValueVisitorTotal < 1000 ? 100
		//            : largestValueVisitorTotal >= 1000 && largestValueVisitorTotal < 10000 ? 1000
		//                : largestValueVisitorTotal >= 10000 && largestValueVisitorTotal < 100000 ? 10000
		//                    : largestValueVisitorTotal >= 100000 && largestValueVisitorTotal < 1000000 ? 100000
		//                        : largestValueVisitorTotal >= 1000000 && largestValueVisitorTotal < 10000000 ? 1000000
		//                            : largestValueVisitorTotal >= 10000000 && largestValueVisitorTotal < 100000000 ? 10000000
		//                                : largestValueVisitorTotal >= 100000000 && largestValueVisitorTotal < 1000000000 ? 100000000
		//                                    : 1000000000;
		series = [{
			type: 'column',
			name: LanguageNoofVisitor,
			data: visitorByHour,
			color: '#179BD8',
			borderWidth: 0
		}];
		yaxis = [{
			allowDecimals: false,
			lineWidth: 0,
			//tickInterval: dynamicTickIntervalVisitorTotal,
			tickWidth: 1,
			tickLength: 5,
			min: 0,
			tickPosition: 'inside',
			title: {
				text: LanguageNoofVisitor,
				style: {
					color: colorScheme.chart.axisLabel.y.title.color,
					fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
					"font-family": colorScheme.chart.axisLabel.y.title.fontFamily
				}
			},
			labels: {
				style: {
					"font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
					color: colorScheme.chart.axisLabel.y.label.color,
					fontSize: colorScheme.chart.axisLabel.y.label.fontSize
				}
			}
		}];
		legendPosition = 350;
	}

	$(function () {
		var chart = new Highcharts.Chart({
			chart: {
				renderTo: "companyFootfallSummaryChart",
				events: {
					load: function () {
						chartEvent[3] = this;
					}
				},
				alignTicks: false,
				type: 'column'
			},
			title: {
				text: ''
			},
			series: series,
			credits: {
				enabled: false
			},
			yAxis: yaxis,
			xAxis: {
				categories: hourList,
				tickWidth: 0,
				gridLineWidth: 0,
				minorTickLength: 0,
				tickLength: 0,
				title: {
					text: LanguageHour,
					align: 'high',
					y: -20,
					style: {
						color: colorScheme.chart.axisLabel.x.title.color,
						fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
						"font-family": colorScheme.chart.axisLabel.x.title.fontFamily
					}
				},
				labels: {
					rotation: -90,
					x: 6,
					style: {
						color: colorScheme.chart.axisLabel.x.label.color,
						"font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
						fontSize: colorScheme.chart.axisLabel.x.label.fontSize
					}
				}
			},
			legend: {
				itemStyle: {
					color: colorScheme.chart.legend.text.color,
					"font-family": colorScheme.chart.legend.text.fontFamily,
					fontSize: colorScheme.chart.legend.text.fontSize,
					"font-weight": colorScheme.chart.legend.text.fontWeight
				},
				enabled: true,
				x: legendPosition,
				y: -15,
				verticalAlign: 'top',
			},
			exporting: {
				enabled: false,
			},
			tooltip: {
				useHTML: true,
				shared: true,
			},
		});
	});
	if ($("input[name=data-selection]:checked").val() == "hour") {
		$("#companyFootfallSummaryChart .highcharts-container").on("click", function () {
			var thisdate = $("#datepicker").val().substring($("#datepicker").val().length - 10);
			window.location.href = "/FootfallCam/Analytics?range=1&parameter=101&start=" + thisdate + "&end=" + thisdate;
		});
		$("#companyFootfallSummaryChart .highcharts-container").addClass("cursoronly")
		console.log("hourly");
	}


}


function bindFootfallSummaryDaily(data, colorScheme) {
	var dateList = data.date;
	var visitorByDaily = data.series[0].ValueInInt;
	var transactionCountByDaily = data.series[0].TransactionCountInt;
	var isContainsTransactionCount = transactionCountByDaily.some(isBiggerThan0);
	var series = [];
	var yaxis = [];
	var legendPosition = 0;
	if (isContainsTransactionCount) {
		//var largestValueVisitorTotal = Math.max.apply(null, visitorByDaily);
		//var largestValueTransactionCount = Math.max.apply(null, transactionCountByDaily);
		//var dynamicTickIntervalVisitorTotal = largestValueVisitorTotal >= 0 && largestValueVisitorTotal < 10 ? 1
		//    : largestValueVisitorTotal >= 10 && largestValueVisitorTotal < 100 ? 10
		//        : largestValueVisitorTotal >= 100 && largestValueVisitorTotal < 1000 ? 100
		//            : largestValueVisitorTotal >= 1000 && largestValueVisitorTotal < 10000 ? 1000
		//                : largestValueVisitorTotal >= 10000 && largestValueVisitorTotal < 100000 ? 10000
		//                    : largestValueVisitorTotal >= 100000 && largestValueVisitorTotal < 1000000 ? 100000
		//                        : largestValueVisitorTotal >= 1000000 && largestValueVisitorTotal < 10000000 ? 1000000
		//                            : largestValueVisitorTotal >= 10000000 && largestValueVisitorTotal < 100000000 ? 10000000
		//                                : largestValueVisitorTotal >= 100000000 && largestValueVisitorTotal < 1000000000 ? 100000000
		//                                    : 1000000000;
		//var dynamicTickIntervalTransactionCount = largestValueTransactionCount >= 0 && largestValueTransactionCount < 10 ? 1
		//    : largestValueTransactionCount >= 10 && largestValueTransactionCount < 100 ? 10
		//        : largestValueTransactionCount >= 100 && largestValueTransactionCount < 1000 ? 100
		//            : largestValueTransactionCount >= 1000 && largestValueTransactionCount < 10000 ? 1000
		//                : largestValueTransactionCount >= 10000 && largestValueTransactionCount < 100000 ? 10000
		//                    : largestValueTransactionCount >= 100000 && largestValueTransactionCount < 1000000 ? 100000
		//                        : largestValueTransactionCount >= 1000000 && largestValueTransactionCount < 10000000 ? 1000000
		//                            : largestValueTransactionCount >= 10000000 && largestValueTransactionCount < 100000000 ? 10000000
		//                                : largestValueTransactionCount >= 100000000 && largestValueTransactionCount < 1000000000 ? 100000000
		//                                    : 1000000000;
		series = [{
			type: 'column',
			name: LanguageNoofVisitor,
			data: visitorByDaily,
			color: '#179BD8',
			borderWidth: 0
		}, {
			type: 'column',
			name: LanguageNumberofTransaction,
			data: transactionCountByDaily,
			color: colorScheme.time.year.thisYear
		}];
		yaxis = [{
			allowDecimals: false,
			lineWidth: 0,
			//tickInterval: dynamicTickIntervalVisitorTotal,
			tickWidth: 1,
			tickLength: 5,
			min: 0,
			tickPosition: 'inside',
			title: {
				text: LanguageNoofVisitor,
				style: {
					color: colorScheme.chart.axisLabel.y.title.color,
					fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
					"font-family": colorScheme.chart.axisLabel.y.title.fontFamily
				}
			},
			labels: {
				style: {
					"font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
					color: colorScheme.chart.axisLabel.y.label.color,
					fontSize: colorScheme.chart.axisLabel.y.label.fontSize
				}
			},

		},
		{
			allowDecimals: false,
			opposite: true,
			linkedTo: 0,
			lineWidth: 0,
			tickWidth: 0,
			//tickInterval: dynamicTickIntervalTransactionCount,
			tickWidth: 1,
			tickLength: 5,
			min: 0,
			tickPosition: 'inside',
			labels: {
				style: {
					"font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
					color: colorScheme.chart.axisLabel.y.label.color,
					fontSize: colorScheme.chart.axisLabel.y.label.fontSize
				}
			},
			title: {
				text: LanguageNumberofTransaction,
				style: {
					color: colorScheme.chart.axisLabel.y.title.color,
					fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
					"font-family": colorScheme.chart.axisLabel.y.title.fontFamily
				}
			}
		}];
		legendPosition = 300;
	} else {
		//var largestValueVisitorTotal = Math.max.apply(null, visitorByDaily);
		//var dynamicTickIntervalVisitorTotal = largestValueVisitorTotal >= 0 && largestValueVisitorTotal < 10 ? 1
		//    : largestValueVisitorTotal >= 10 && largestValueVisitorTotal < 100 ? 10
		//        : largestValueVisitorTotal >= 100 && largestValueVisitorTotal < 1000 ? 100
		//            : largestValueVisitorTotal >= 1000 && largestValueVisitorTotal < 10000 ? 1000
		//                : largestValueVisitorTotal >= 10000 && largestValueVisitorTotal < 100000 ? 10000
		//                    : largestValueVisitorTotal >= 100000 && largestValueVisitorTotal < 1000000 ? 100000
		//                        : largestValueVisitorTotal >= 1000000 && largestValueVisitorTotal < 10000000 ? 1000000
		//                            : largestValueVisitorTotal >= 10000000 && largestValueVisitorTotal < 100000000 ? 10000000
		//                                : largestValueVisitorTotal >= 100000000 && largestValueVisitorTotal < 1000000000 ? 100000000
		//                                    : 1000000000;
		series = [{
			type: 'column',
			name: LanguageNoofVisitor,
			data: visitorByDaily,
			color: '#179BD8',
			borderWidth: 0
		}];
		yaxis = [{
			allowDecimals: false,
			lineWidth: 0,
			//tickInterval: dynamicTickIntervalVisitorTotal,
			tickWidth: 1,
			tickLength: 5,
			min: 0,
			tickPosition: 'inside',
			title: {
				text: LanguageNoofVisitor,
				style: {
					color: colorScheme.chart.axisLabel.y.title.color,
					fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
					"font-family": colorScheme.chart.axisLabel.y.title.fontFamily
				}
			},
			labels: {
				style: {
					"font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
					color: colorScheme.chart.axisLabel.y.label.color,
					fontSize: colorScheme.chart.axisLabel.y.label.fontSize
				}
			}
		}];
		legendPosition = 350;
	}

	$(function () {
		var chart = new Highcharts.Chart({
			chart: {
				renderTo: "companyFootfallSummaryChart",
				events: {
					load: function () {
						chartEvent[3] = this;
					}
				},
				alignTicks: false,
				type: 'column'
			},
			title: {
				text: ''
			},
			series: series,
			credits: {
				enabled: false
			},
			yAxis: yaxis,
			xAxis: {
				categories: dateList,
				tickWidth: 0,
				gridLineWidth: 0,
				minorTickLength: 0,
				tickLength: 0,
				title: {
					text: LanguageDate,
					align: 'high',
					y: -20,
					style: {
						color: colorScheme.chart.axisLabel.x.title.color,
						fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
						"font-family": colorScheme.chart.axisLabel.x.title.fontFamily
					}
				},
				labels: {
					rotation: -90,
					x: 6,
					style: {
						color: colorScheme.chart.axisLabel.x.label.color,
						"font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
						fontSize: colorScheme.chart.axisLabel.x.label.fontSize
					}
				}
			},
			legend: {
				itemStyle: {
					color: colorScheme.chart.legend.text.color,
					"font-family": colorScheme.chart.legend.text.fontFamily,
					fontSize: colorScheme.chart.legend.text.fontSize,
					"font-weight": colorScheme.chart.legend.text.fontWeight
				},
				enabled: true,
				x: legendPosition,
				y: -15,
				verticalAlign: 'top',
			},
			exporting: {
				enabled: false,
			},
			tooltip: {
				useHTML: true,
				shared: true,
			},
		});
	});

	if ($("input[name=data-selection]:checked").val() == "day") {
		$("#companyFootfallSummaryChart .highcharts-container").on("click", function () {
			var thisdate = $("#datepicker").val().substring($("#datepicker").val().length - 10);
			var startDate = moment(thisdate, "DD/MM/YYYY").add('days', -13).format("DD/MM/YYYY");
			window.location.href = "/FootfallCam/Analytics?range=2&selectedregionid=-1&parameter=101&start=" + startDate + "&end=" + thisdate;
		});
		$("#companyFootfallSummaryChart .highcharts-container").addClass("cursoronly");
		console.log("daily");
	}
}